
/*

var JaugeVie = Entity.extend({

	init: function(vec){
		this._super();
		this.coord = vec;
		
		this.tile = new Tile(IMAGE_Aircraft_07);
		this.tile.setPosition(vec.copy());
		this.tile.setSprite(this.tile.spriteBox.x, this.tile.spriteBox.y+5, this.tile.spriteBox.width, this.tile.spriteBox.height-10);	
		
		this.tileAlpha = new Tile(IMAGE_Aircraft_07);
		this.tileAlpha.setPosition(vec.copy());
		this.tileAlpha.setSprite(this.tileAlpha.spriteBox.x, this.tileAlpha.spriteBox.y+5, this.tileAlpha.spriteBox.width, this.tileAlpha.spriteBox.height-10);	
		this.tileAlpha.setAlpha(0.3);
		
		this.initSpriteBox = this.tile.spriteBox.copy();

		
	},

	maj: function(){
		var pct = game.vehiculeJoueur.vie/game.vehiculeJoueur.vieMax;
		var l = this.initSpriteBox.height*(1-pct);	
		this.tile.setSprite(this.initSpriteBox.x, this.initSpriteBox.y+l, this.initSpriteBox.width, this.initSpriteBox.height-l);	
		this.tile.coordBox.y=this.coord.y+l;
	},

	
	draw: function(){
	
		this.maj();
		
		this.tileAlpha.draw();
		this.tile.draw();
		
	},	
});
*/

var JaugeVie = Entity.extend({

	init: function(vec){
		this._super();
		this.coord = vec;
		
		this.width = 30;
		this.height = game.vehiculeJoueur.vieMax*5;
		if (this.height>300)
			this.height=300;

	},



	
	draw: function(){

		canvas2DContext.save();
		
		// Fond rouge
		canvas2DContext.fillStyle = "#F80808";
		canvas2DContext.fillRect(this.coord.x,this.coord.y-this.height,this.width,this.height);
		
		// Barre verte
		var h = this.height*(game.vehiculeJoueur.vie/game.vehiculeJoueur.vieMax);
		canvas2DContext.fillStyle = "#08F808";
		canvas2DContext.fillRect(this.coord.x,this.coord.y-h,this.width,h);
		
		
		canvas2DContext.fillStyle = "#646464";
		h=this.height/game.vehiculeJoueur.vieMax;
		for (var i=0 ; i<game.vehiculeJoueur.vieMax ; i++){
			//canvas2DContext.fillStyle = "#646464";
			//canvas2DContext.strokeRect(this.coord.x,this.coord.y-i*h,this.width,h);
			//canvas2DContext.fillStyle = "#08F808";
			canvas2DContext.fillRect(this.coord.x,this.coord.y-i*h,this.width,1);
		}		
		
		
		canvas2DContext.restore();
	},	
});


var Bouton = Entity.extend({
	init: function(vec){
		this._super();
		this.coord = vec;
		this.collision = new Collisionneur();
		this.actif=true;
	},
	enable: function(){
		this.actif=true;
	},
	disable: function(){
		this.actif=false;
	},
	setPosition: function(vec){
		this.coord = vec;
		this.collision.setPosition(vec);
	},		
	draw: function(){
		// Debug
		//canvas2DContext.rect(this.coord.x,this.coord.y,this.collision.boxEnglobante.width,this.collision.boxEnglobante.height);
		//canvas2DContext.strokeStyle="blue";
		//canvas2DContext.stroke();
		
		canvas2DContext.save();
		
		if (this.actif)
			canvas2DContext.fillStyle = "#646464";
		else
			canvas2DContext.fillStyle = "#080808";
		canvas2DContext.fillRect(this.coord.x,this.coord.y,this.collision.boxEnglobante.width,this.collision.boxEnglobante.height);
		
		canvas2DContext.restore();
	},
	
	testCollision: function(vec){
		return this.collision.testCollisionVec(vec);
	},
	
	doHit: function(){
	},	
	
});

var BoutonText = Bouton.extend({
	init: function(vec, texte, larg, haut, txtsize){
		this._super(vec);

		if (larg==undefined)
			larg=200;
		if (haut==undefined)
			haut=20;
		if (txtsize==undefined)
			txtsize=haut*2/3;
		this.collision.addBox(new Box(vec.x, vec.y, larg, haut));
		
		this.larg=larg;
		this.haut=haut;		
		
		
		var v = vec.copy();
		v.x+=larg/2;
		v.y+=haut/2;
		this.txt = new Text(texte, v, txtsize, TM_CENTER|TM_MIDDLE);
	},
	setPosition: function(vec){
		this._super(vec);
		var v = vec.copy();
		v.x+=this.larg/2;
		v.y+=this.haut/2;		
		this.txt.setPosition(v);
	},	
	draw: function(){
		this._super();
		this.txt.draw();
	},
});



var BoutonBoutique = BoutonText.extend({
	init: function(vec, prodDef, larg, haut, txtsize){
		this._super(vec, prodDef.nom, larg, haut, txtsize);
		this.possede=false;
		this.equipe=false;
		
		this.tileImg = new Tile(IMAGE_boutiqueitem);
		this.tileImg.setSpriteItem(prodDef.item);	
		this.tileImg.setMode(TILE_CENTER|TILE_MIDLE);
		this.tileImg.setPosition(new Vec(vec.x+larg/2, vec.y+haut/2));
		this.tileImg.coordBox.width = larg;
		this.tileImg.coordBox.height = haut;
	},
	
	joueurPossede: function(){
		this.possede=true;
		this.equipe=false;
	},
	
	joueurEquipe: function(){
		this.equipe=true;
		this.possede=true;
	},		

	draw: function(){
		
		canvas2DContext.save();
		
		if (this.equipe)
			canvas2DContext.fillStyle = "#089008";
		else if (this.possede)
			canvas2DContext.fillStyle = "#909090";
		else if (this.actif)
			canvas2DContext.fillStyle = "#646464";
		else
			canvas2DContext.fillStyle = "#080808";
		canvas2DContext.fillRect(this.coord.x,this.coord.y,this.collision.boxEnglobante.width,this.collision.boxEnglobante.height);
		
		canvas2DContext.restore();
		
		this.tileImg.draw();
		//this.txt.draw();
		
		
	},	
	
	testCollision: function(vec){
		if (this.actif)
			return this._super(vec);
			
		return false;
	},	
});



var HitPage = Entity.extend({
	init: function(){
		
		this._super();
		this.coord = new Vec(0,0);
		this.collision = new Collisionneur();
		this.collision.addBox(new Box(this.coord.x, this.coord.y, GAME_SIZE_WIDTH*3, GAME_SIZE_HEIGHT*3));
		this.actif=true;
	},
	enable: function(){
		this.actif=true;
	},
	disable: function(){
		this.actif=false;
	},
	setPosition: function(vec){
	},		
	draw: function(){
		
	},
	
	testCollision: function(vec){
		return this.collision.testCollisionVec(vec);
	},
	
	doHit: function(){
	},	
	
});

