var MISS_NULL = {"code":"00", "texte":"null", "nb":0};

var tMissionsDef = [
{"code":"EnnemieDetruit", "texte":"Destroy Ennemie", "tnb":[10,200,400,600,800,1000,1200,1400,1600,1700,]},
{"code":"EnnemieAvionDetruit", "texte":"Destroy plane", "tnb":[10,150,300,450,600,750,900,1150,1400,1550,]},
//{"code":"TireArme2", "texte":"Shoot with secondary weapon", "tnb":[1]},
{"code":"BatimentDetruit", "texte":"Destroy batiment", "tnb":[5,20,40,60,80,100,120,140,160,180,]},
//{"code":"Bonus", "texte":"Get bonus", "tnb":[10]},
{"code":"EnnemieTourelleDetruit", "texte":"Destroy tower", "tnb":[5,10,25,45,70,100,140,170,200,230,]},
{"code":"BonusArgent", "texte":"Get bonus coin", "tnb":[5,10,25,45,70,100,140,170,200,230,]},
{"code":"EnnemieBossDetruit", "texte":"Destroy boss", "tnb":[1,2,3,4,5,6,7,8,9,10,]},
//{"code":"Ratio", "texte":"Get good ratio shoot/Destroy", "nb":80},
//{"code":"EnnemieBateauDetruit", "texte":"Destroy ship", "nb":5},
];


var getMissionIndice = function(lvlMission) {
	return lvlMission%tMissionsDef.length;
};

var getMissionLvl = function(lvlMission) {
	return Math.floor(lvlMission/tMissionsDef.length);	
};

var getMissionValue = function(lvlMission) {
	var nb;	
	
	var iMiss	= getMissionIndice(lvlMission);
	var lvl = getMissionLvl(lvlMission);
	
	if (tMissionsDef[iMiss].code=="EnnemieDetruit"){
		nb = game.nbEnnemieDetruit;
	}
	else if (tMissionsDef[iMiss].code=="BatimentDetruit"){
		nb = game.nbBatimentDetruit;
	}
	else if (tMissionsDef[iMiss].code=="EnnemieTourelleDetruit"){
		nb = game.nbEnnemieTourelleDetruit;
	}
	else if (tMissionsDef[iMiss].code=="EnnemieBateauDetruit"){
		nb = game.nbEnnemieBateauDetruit;
	}
	else if (tMissionsDef[iMiss].code=="EnnemieAvionDetruit"){
		nb = game.nbEnnemieAvionDetruit;
	}
	else if (tMissionsDef[iMiss].code=="EnnemieBossDetruit"){
		nb = game.nbEnnemieBossDetruit;
	}
	else if (tMissionsDef[iMiss].code=="Bonus"){
		nb = game.nbBonus;
	}
	else if (tMissionsDef[iMiss].code=="BonusArgent"){
		return game.nbBonusArgent;
	}
	else if (tMissionsDef[iMiss].code=="TireArme2"){
		nb = game.nbTireArme2;
	}
	else if (tMissionsDef[iMiss].code=="Ratio"){
		nb = Math.round((game.nbTireArme1+game.nbTireArme2)/(game.nbEnnemieDetruit+game.nbBatimentDetruit));
	}
	else
		return -1;
		
	
		
	if (nb>getMissionValueNeed(lvlMission))
		nb=getMissionValueNeed(lvlMission);

	return nb;
};	

var getMissionValueNeed = function(lvlMission) {
	
	var i=getMissionIndice(lvlMission);	
	var l=getMissionLvl(lvlMission);
	
	if (l<tMissionsDef[i].tnb.length)
		return tMissionsDef[i].tnb[l];
	else 
		return tMissionsDef[i].tnb[tMissionsDef[i].tnb.length-1] + 
					tMissionsDef[i].tnb[1] * (l-tMissionsDef[i].tnb.length+1);
					
					
};

var isMissionReussi = function(lvlMission) {
	if (getMissionValue(lvlMission)>=getMissionValueNeed(lvlMission)){
		return true;
	}
	return false;
};


