
var NiveauVide = Class.extend({
	init: function(){
		this.terrain = new Array();
		this.mapArbre = new Array();
		this.mapEnemie = new Array();
		this.tDecors = new Array();
		this.tEnemies = new Array();
		this.tBuildings = new Array();
		
		this.MAX_CASE_LARG = 6;	
		this.MAX_CASE_HAUT = 10;		
		
		this.tPlaceOccuperDecors = new Array();	// Sert pour l'optimisation des recherches des decors
		this.tPlaceOccuperBuildings = new Array();	// Sert pour l'optimisation des recherches des Buildings
		
	},
	
	///\decorBox facultatif
	addDecors: function(image, item, v, decorBox){
		this.tDecors.push({"image":image, "item":item, "vec":v});
							
		if (decorBox==undefined)		
			decorBox = imageManager.getCollisionBox(image, item);

		var x1 = Math.floor(v.x/128);
		var y1 = this.MAX_CASE_HAUT-1-Math.ceil((v.y)/128);			

		var x2 = Math.ceil((v.x+decorBox.width)/128);
		var y2 = this.MAX_CASE_HAUT-1-Math.floor((v.y-decorBox.height)/128);	

		if (x1<0)
			x1=0;
		if (x2<0)
			x2=0;
		if (y1<0)
			y1=0;
		if (y2<0)
			y2=0;
		if (x1>=this.MAX_CASE_LARG)
			x1=this.MAX_CASE_LARG-1;
		if (x2>=this.MAX_CASE_LARG)
			x2=this.MAX_CASE_LARG-1;
		if (y1>=this.MAX_CASE_HAUT)
			y1=this.MAX_CASE_HAUT-1;
		if (y2>=this.MAX_CASE_HAUT)
			y2=this.MAX_CASE_HAUT-1;
		
		if (x1>x2)
			alert("addDecors boucle infini");
		if (y1>y2)
			alert("addDecors boucle infini");
					
		for (var x=x1 ; x<=x2 ; x++){
			for (var y=y1 ; y<=y2 ; y++){
				this.tPlaceOccuperDecors[y][x]=true;
			}				
		}			
		
	},

	addBuildings: function(def, v, angle, decorBox){		
	
	
		this.tBuildings.push({"definition":def, "vec":v, "angle":angle});
		
		if (decorBox==undefined)	
			decorBox = imageManager.getCollisionBox(IMAGE_buildings, def.item);

		var x1 = Math.floor(v.x/128);
		var y1 = this.MAX_CASE_HAUT-1-Math.ceil((v.y)/128);			

		var x2 = Math.ceil((v.x+decorBox.width)/128);
		var y2 = this.MAX_CASE_HAUT-1-Math.floor((v.y-decorBox.height)/128);	

		if (x1<0)
			x1=0;
		if (x2<0)
			x2=0;
		if (y1<0)
			y1=0;
		if (y2<0)
			y2=0;
		if (x1>=this.MAX_CASE_LARG)
			x1=this.MAX_CASE_LARG-1;
		if (x2>=this.MAX_CASE_LARG)
			x2=this.MAX_CASE_LARG-1;
		if (y1>=this.MAX_CASE_HAUT)
			y1=this.MAX_CASE_HAUT-1;
		if (y2>=this.MAX_CASE_HAUT)
			y2=this.MAX_CASE_HAUT-1;
		
		if (x1>x2)
			alert("addBuildings boucle infini");
		if (y1>y2)
			alert("addBuildings boucle infini");
					
		for (var x=x1 ; x<=x2 ; x++){
			for (var y=y1 ; y<=y2 ; y++){
				this.tPlaceOccuperBuildings[y][x]=true;
			}				
		}		
	},
	
	getHauteur: function(){
		return alert("redefinir");
	}
});
// Sable
var Niveau1 = NiveauVide.extend({
	init: function(){
		this.terrain = [
		[29,2,4,2,4,24],
		[43,0,0,0,0,9],
		[43,0,0,0,0,9],
		[43,0,0,0,0,9],
		[43,0,0,0,0,9],
		[43,0,0,0,0,9],
		[47,44,45,44,45,31],
		[-1,-1,-1,-1,-1,-1],
		];
		this.mapArbre = [
		[-1,-1,-1,-1,-1,-1],
		[-1,-1,-1,-1,-1,-1],
		[-1,-1,-1,-1,-1,-1],
		[-1,-1,-1,-1,-1,-1],
		[-1,-1,-1,-1,-1,-1],
		[-1,-1,-1,-1,-1,-1],
		[-1,-1,-1,-1,-1,-1],
		[-1,-1,-1,-1,-1,-1],
		];
		this.mapEnemie = [
		[-1,-1,-1,-1,-1,-1],
		[-1,-1,-1,-1,7,-1],
		[-1,-1,-1,-1,-1,-1],
		[-1,-1,7,-1,-1,-1],
		[-1,-1,-1,-1,-1,-1],
		[-1,-1,-1,-1,-1,-1],
		[-1,-1,7,-1,-1,-1],
		[-1,-1,-1,-1,-1,-1],
		];
		this.tDecors = [
			{"image":IMAGE_trees, "item":ITEM_trees_3, "vec":{"x":0,"y":100}},
			{"image":IMAGE_trees, "item":ITEM_trees_3, "vec":{"x":100,"y":100}},
			{"image":IMAGE_trees, "item":ITEM_trees_3, "vec":{"x":200,"y":100}},
			{"image":IMAGE_trees, "item":ITEM_trees_3, "vec":{"x":300,"y":100}},
			{"image":IMAGE_trees, "item":ITEM_trees_3, "vec":{"x":400,"y":100}},
			{"image":IMAGE_trees, "item":ITEM_trees_3, "vec":{"x":500,"y":100}},
			{"image":IMAGE_trees, "item":ITEM_trees_3, "vec":{"x":600,"y":100}},
			{"image":IMAGE_trees, "item":ITEM_trees_1, "vec":{"x":130,"y":120}},
			{"image":IMAGE_trees, "item":ITEM_trees_2, "vec":{"x":250,"y":256}},
			{"image":IMAGE_decor, "item":ITEM_decor_1, "vec":{"x":130,"y":300}},
			{"image":IMAGE_decor, "item":ITEM_decor_1, "vec":{"x":130,"y":330}},
		];
		
		this.tEnemies = [
			{"enemie":7, "vec":{"x":130,"y":50}},
			{"enemie":7, "vec":{"x":384,"y":384}},
		];
		
		this.tBuildings = [];
		
	},
	
	getHauteur: function(){
		return this.terrain.length*128;
	},
});

// Foret
var Niveau2 = NiveauVide.extend({
	init: function(){
		this.terrain = [
		[5,1,3,1,3,16],
		[23,8,8,8,8,12],
		[23,8,8,8,8,7],
		[23,8,8,8,8,12],
		[23,8,8,8,8,7],
		[46,36,37,39,36,30],
		];
		
		this.mapArbre = [
		[-1,-1,-1,-1,-1,-1],
		[-1,-1,-1,-1,-1,-1],
		[-1,-1,-1,-1,-1,-1],
		[-1,-1,-1,-1,-1,-1],
		[-1,-1,-1,-1,-1,-1],
		[-1,-1,-1,-1,-1,-1],
		];
		this.mapEnemie = [
		[-1,-1,-1,-1,-1,-1],
		[-1,-1,-1,-1,-1,-1],
		[-1,7,-1,-1,-1,-1],
		[-1,-1,-1,-1,-1,-1],
		[-1,-1,-1,-1,7,-1],
		[-1,-1,-1,-1,-1,-1],
		];
		this.tDecors = [
			{"image":IMAGE_trees, "item":1, "vec":{"x":12,"y":128}},
			{"image":IMAGE_decor, "item":2, "vec":{"x":250,"y":256}},
			{"image":IMAGE_trees, "item":3, "vec":{"x":130,"y":384}},
			{"image":IMAGE_decor, "item":1, "vec":{"x":130,"y":512}},
			{"image":IMAGE_decor, "item":2, "vec":{"x":300,"y":640}},
			{"image":IMAGE_trees, "item":3, "vec":{"x":300,"y":768}},
			{"image":IMAGE_trees, "item":1, "vec":{"x":300,"y":996}},
		];
		this.tEnemies = [
			{"enemie":7, "vec":{"x":384,"y":384}},
		];
		
		this.tBuildings = [];
	},
	
	getHauteur: function(){
		return this.terrain.length*128;
	},
});






// Graphisme du jeu
var GRAPH_FORET			= 1;
var GRAPH_SABLE			= 2;
var GRAPH_EAU			= 3;
var GRAPH_MAX			= 3;

// Type de niveau
var NIV_ENNEMIE		= 1;
var NIV_BOSS		= 2;
var NIV_BOUCLE		= 3;
var NIV_DEMO		= 4;


var NiveauAleatoire = NiveauVide.extend({
	
	fillArray: function(tableau, val){
		for (var y=0 ; y<this.MAX_CASE_HAUT ; y++)
		{
			tableau[y]=new Array();
			for (var x=0 ; x<this.MAX_CASE_LARG ; x++)
				tableau[y][x] = val;
		}	
	},

	genereTacheArray: function(tableau, item, larg_min, haut_min, larg_max, haut_max, testFonc, doFonc, startXRand, startYRand,  endXRand, endYRand){
		var x, y, l, h;
		var vecCase;
		var nb_iteration=0;
	
		if (startXRand==undefined)
			startXRand=0;
		if (startYRand==undefined)
			startYRand=0;
		if (endXRand==undefined)
			endXRand=this.MAX_CASE_LARG;
		if (endYRand==undefined)
			endYRand=this.MAX_CASE_HAUT;
			

		var iterationMax = Math.abs((endXRand-startXRand)*(endYRand-startYRand));
		if (iterationMax>20)
			iterationMax=20;
		else if (iterationMax==0)
			iterationMax=1;
	
		while (nb_iteration<iterationMax)
		{
			nb_iteration++;
				
			// x = randomInt(this.MAX_CASE_LARG);
			// y = randomInt(this.MAX_CASE_HAUT);
			x = startXRand+randomInt(endXRand-startXRand);
			y = startYRand+randomInt(endYRand-startYRand);
			
			
			var vecCase = new Vec(x,y);
			l = larg_min+randomInt(larg_max-larg_min);
			h = haut_min+randomInt(haut_max-haut_min);
			
			
			// Verifi si le terrain est libre
			var terrain_libre=true;
			if (testFonc!=undefined)
			{
				for (var y1=- Math.floor(h/2), maxY1=Math.ceil(h/2) ; y1<maxY1 ; y1++){
					for (var x1=-Math.floor(l/2), maxX1=Math.ceil(l/2) ; x1<maxX1 ; x1++){
						x = vecCase.x+x1;
						y = vecCase.y+y1;
						if (x<0 || x>=this.MAX_CASE_LARG || y<0 || y>=this.MAX_CASE_HAUT)
							continue;
							
						if (!testFonc(tableau, x, y, this))
						{
							terrain_libre=false;
							break;
						}
					}
					
					if (!terrain_libre)
						break;
				}
			}
			if (!terrain_libre)
				continue;
		
			if (doFonc!=undefined){
				doFonc(tableau, vecCase.x- Math.floor(l/2), vecCase.y- Math.floor(h/2), l, h, this);
			}
			else {
				// Le terrain est libre, on dessine
				for (var y1=- Math.floor(h/2), maxY1=Math.ceil(h/2) ; y1<maxY1 ; y1++){
					for (var x1=-Math.floor(l/2), maxX1=Math.ceil(l/2) ; x1<maxX1 ; x1++){
						x = vecCase.x+x1;
						y = vecCase.y+y1;

						if (x<0 || x>=this.MAX_CASE_LARG || y<0 || y>=this.MAX_CASE_HAUT)
							continue;

						tableau[y][x]=item;
					}
				}
			}
			
			return h*l;		// Nombre de case dessiner
		}
		
		return 0;
	},
	
	
	isCaseTerrainEau: function(x,y){
		
		if (x<0 || x>=this.MAX_CASE_LARG || y<0 || y>=this.MAX_CASE_HAUT){
			return false;
		}
				
		if (this.terrain[y][x]==ITEM_ground_eau && this.terrainFond[y][x]==ITEM_ground_eau)
			return true;
			
		
		return false;		
	},	
	
	isTterrainEau: function(vec){
		var x = Math.floor(vec.x/128);
		var y = this.MAX_CASE_HAUT-1-Math.floor(vec.y/128);
		
		return this.isCaseTerrainEau(x,y);
/*		if (this.terrain[y][x]==ITEM_ground_eau && this.terrainFond[y][x]==ITEM_ground_eau)
			return true;
			
		return false;*/
	},
	
	
	isCaseTerrainSol: function(x,y){
		if (x<0 || x>=this.MAX_CASE_LARG || y<0 || y>=this.MAX_CASE_HAUT){
			return false;
		}		
		
		if (this.terrain[y][x]==ITEM_ground_sable || this.terrainFond[y][x]==ITEM_ground_sable || this.terrain[y][x]==ITEM_ground_foret || this.terrainFond[y][x]==ITEM_ground_foret)
			return true;
		
		return false;		
	},
	
	isTterrainSol: function(vec){
		var x = Math.floor(vec.x/128);
		var y = this.MAX_CASE_HAUT-1-Math.floor(vec.y/128);
		

		return this.isCaseTerrainSol(x,y);
/*		if (this.terrain[y][x]==ITEM_ground_sable || this.terrainFond[y][x]==ITEM_ground_sable || this.terrain[y][x]==ITEM_ground_foret || this.terrainFond[y][x]==ITEM_ground_foret)
			return true;
		
		return false;*/
	},	
	
	isTterrainForet: function(vec){
		var x = Math.floor(vec.x/128);
		var y = this.MAX_CASE_HAUT-1-Math.floor(vec.y/128);
		
		if (x<0 || x>=this.MAX_CASE_LARG || y<0 || y>=this.MAX_CASE_HAUT){
			return false;
		}
		
		if (this.terrain[y][x]==ITEM_ground_foret || this.terrainFond[y][x]==ITEM_ground_foret)
			return true;
		
		return false;
	},	
	isTterrainSable: function(vec){
		var x = Math.floor(vec.x/128);
		var y = this.MAX_CASE_HAUT-1-Math.floor(vec.y/128);
		
		if (x<0 || x>=this.MAX_CASE_LARG || y<0 || y>=this.MAX_CASE_HAUT){
			return false;
		}
		
		if (this.terrain[y][x]==ITEM_ground_sable || this.terrainFond[y][x]==ITEM_ground_sable)
			return true;
		
		return false;
	},	
	
	
	isTDecorsLibre: function(imageItem, item, vec){
		var itemBox = imageManager.getCollisionBox(imageItem, item);
		itemBox.x+=vec.x;
		itemBox.y=vec.y-itemBox.height-itemBox.y;
		
		
/*		
		var x1 = Math.floor(vec.x/128);
		var y1 = this.MAX_CASE_HAUT-1-Math.ceil((vec.y)/128);			
		var x2 = Math.ceil((vec.x+itemBox.width)/128);
		var y2 = this.MAX_CASE_HAUT-1-Math.floor((vec.y-itemBox.height)/128);	
		if (x1>=this.MAX_CASE_LARG)
			x1=this.MAX_CASE_LARG-1;
		if (x2>=this.MAX_CASE_LARG)
			x2=this.MAX_CASE_LARG-1;
		if (y1>=this.MAX_CASE_HAUT)
			y1=this.MAX_CASE_HAUT-1;
		if (y2>=this.MAX_CASE_HAUT)
			y2=this.MAX_CASE_HAUT-1;			
		if (x1<0)
			x1=0;
		if (x2<0)
			x2=0;
		if (y1<0)
			y1=0;
		if (y2<0)
			y2=0;
						
		if (x1>x2)
			alert("isTDecorsLibre boucle infini");
		if (y1>y2)
			alert("isTDecorsLibre boucle infini");
	
		var occuper=false;		
		for (var x=x1 ; x<=x2 ; x++){
			for (var y=y1 ; y<=y2 ; y++){
				if (this.tPlaceOccuperDecors[y][x] || this.tPlaceOccuperBuildings[y][x]){
					occuper=true;
					break;
				}
			}				
		}
		
		
		this.DebugNbAppelFonction++;
		if (!occuper){
			this.DebugNbOptimOk++;
			return true;
		}
*/		
		
	
		// Collision avec le decor
		for (var i=0, max=this.tDecors.length ; i<max ; i++){
			var decorBox = imageManager.getCollisionBox(this.tDecors[i].image, this.tDecors[i].item);
			decorBox.x+=this.tDecors[i].vec.x;
			decorBox.y=this.tDecors[i].vec.y-decorBox.height-decorBox.y;		

			if (itemBox.boxCollision(decorBox))
				return false;
		}
		
		// Collision avec les buildings
		for (var i=0, max=this.tBuildings.length ; i<max ; i++){
			var decorBox = imageManager.getCollisionBox(IMAGE_buildings, this.tBuildings[i].definition.item);
			decorBox.x+=this.tBuildings[i].vec.x;
			decorBox.y=this.tBuildings[i].vec.y-decorBox.height-decorBox.y;		

			if (itemBox.boxCollision(decorBox))
				return false;
		}		
		
		
		
		return true;
	},	
	
	
	// Type Niveau
	init: function(case_larg, type_graphique, type_niveau, lvl){

		
		this._super();	
	
	
		this.MAX_CASE_LARG = case_larg;
			
		if (type_niveau==NIV_ENNEMIE)
			this.MAX_CASE_HAUT = 150;				
		else if (type_niveau==NIV_BOSS)
			this.MAX_CASE_HAUT = 20;
		else if (type_niveau==NIV_BOUCLE)
			this.MAX_CASE_HAUT = 10;
		else if (type_niveau==NIV_DEMO)
			this.MAX_CASE_HAUT = 10;
		else
			this.MAX_CASE_HAUT = 10;

			
		this.terrainFond = new Array();
		this.terrain = new Array();
		this.mapArbre = new Array();
		this.mapEnemie = new Array();
		this.tDecors = new Array();
		this.tEnemies = new Array();		
		this.tBuildings = new Array();
		
		
		
		this.fillArray(this.terrain, ITEM_vide);
		this.fillArray(this.mapArbre, ITEM_vide);
		this.fillArray(this.tPlaceOccuperDecors, false);
		this.fillArray(this.tPlaceOccuperBuildings, false);


this.DebugNbAppelFonction=0;
this.DebugNbOptimOk=0;

		
		//var type_graphique = randomPoid([[GRAPH_FORET, 1], [GRAPH_SABLE, 1], [GRAPH_EAU, 1]]);
		//var type_graphique= 1+lvl%GRAPH_MAX;
		//var type_graphique=GRAPH_EAU;

	
		 // // Debug ligne toute arbre		
		 // for (var x=0 ; x<this.MAX_CASE_LARG ; x++)
			 // this.tDecors.push({"image":IMAGE_trees, "item":ITEM_trees_3, "vec":{"x":x*128,"y":0}});						
		if (type_graphique==GRAPH_FORET){
			this.fillArray(this.terrainFond, ITEM_ground_foret);
		}
		else if (type_graphique==GRAPH_SABLE){
			this.fillArray(this.terrainFond, ITEM_ground_sable);
		}
		else if (type_graphique==GRAPH_EAU){
		
			this.fillArray(this.terrainFond, ITEM_ground_eau);
			
			var terrainTmp = new Array();
			this.fillArray(terrainTmp, ITEM_ground_eau);
		
			for (var nv=0 ; nv<0.2*this.MAX_CASE_HAUT ; nv++){
				if (randomTest(0.5)){
					this.genereTacheArray(terrainTmp, ITEM_ground_foret, 3, 3, this.MAX_CASE_LARG, 10,
									 function(tableau, x, y){	
										for (var y2 = Math.max(0,y-2) ; y2<Math.min(tableau.length, y+2) ; y2++)	
											for (var x2 = Math.max(0,x-2) ; x2<Math.min(tableau[0].length, x+2) ; x2++)
												if (tableau[y2][x2]!=ITEM_ground_eau)
													return false;
													
										return true;	
									});
				}
				else {
					this.genereTacheArray(terrainTmp, ITEM_ground_sable, 3, 3, this.MAX_CASE_LARG, 10, 
									 function(tableau, x, y){
										for (var y2 = Math.max(0,y-2) ; y2<Math.min(tableau.length, y+2) ; y2++)	
											for (var x2 = Math.max(0,x-2) ; x2<Math.min(tableau[0].length, x+2) ; x2++)
												if (tableau[y2][x2]!=ITEM_ground_eau)
													return false;
													
										return true;
									});

				}
			}

			// copie tableau
			this.terrain=terrainTmp.slice();

			// Jonction entre les cases de differente type (eau - foret - sable)
			for (var x=0 ; x<this.MAX_CASE_LARG ; x++)
			{
				for (var y=0 ; y<this.MAX_CASE_HAUT ; y++)
				{
					// foret - eau
					if (terrainTmp[y][x]==ITEM_ground_foret && (y<1 || terrainTmp[y-1][x]==ITEM_ground_eau) && x>0 && terrainTmp[y][x-1]==ITEM_ground_eau)
						this.terrain[y][x]=5;
					else if (terrainTmp[y][x]==ITEM_ground_foret && (y<1 || terrainTmp[y-1][x]==ITEM_ground_eau) && x+1<terrainTmp[0].length && terrainTmp[y][x+1]==ITEM_ground_eau)
						this.terrain[y][x]=16;
					else if (terrainTmp[y][x]==ITEM_ground_foret && (y+1>=terrainTmp.length || terrainTmp[y+1][x]==ITEM_ground_eau) && x>0 && terrainTmp[y][x-1]==ITEM_ground_eau)
						this.terrain[y][x]=46;
					else if (terrainTmp[y][x]==ITEM_ground_foret && (y+1>=terrainTmp.length || terrainTmp[y+1][x]==ITEM_ground_eau) && x+1<terrainTmp[0].length && terrainTmp[y][x+1]==ITEM_ground_eau)
						this.terrain[y][x]=30;
					else if (terrainTmp[y][x]==ITEM_ground_foret && (y<1 || terrainTmp[y-1][x]==ITEM_ground_eau))
						this.terrain[y][x]=1;//3
					else if (terrainTmp[y][x]==ITEM_ground_foret && (y+1>=terrainTmp.length || terrainTmp[y+1][x]==ITEM_ground_eau))
						this.terrain[y][x]=36;//37
					else if (terrainTmp[y][x]==ITEM_ground_foret && x+1<terrainTmp[0].length && terrainTmp[y][x+1]==ITEM_ground_eau)
						this.terrain[y][x]=12;//7
					else if (terrainTmp[y][x]==ITEM_ground_foret && x>0 && terrainTmp[y][x-1]==ITEM_ground_eau)
						this.terrain[y][x]=23;					

					// sable - eau
					else if (terrainTmp[y][x]==ITEM_ground_sable && (y<1 || terrainTmp[y-1][x]==ITEM_ground_eau) && x>0 && terrainTmp[y][x-1]==ITEM_ground_eau)
						this.terrain[y][x]=29;
					else if (terrainTmp[y][x]==ITEM_ground_sable && (y<1 || terrainTmp[y-1][x]==ITEM_ground_eau) && x+1<terrainTmp[0].length && terrainTmp[y][x+1]==ITEM_ground_eau)
						this.terrain[y][x]=24;
					else if (terrainTmp[y][x]==ITEM_ground_sable && (y+1>=terrainTmp.length || terrainTmp[y+1][x]==ITEM_ground_eau) && x>0 && terrainTmp[y][x-1]==ITEM_ground_eau)
						this.terrain[y][x]=47;
					else if (terrainTmp[y][x]==ITEM_ground_sable && (y+1>=terrainTmp.length || terrainTmp[y+1][x]==ITEM_ground_eau) && x+1<terrainTmp[0].length && terrainTmp[y][x+1]==ITEM_ground_eau)
						this.terrain[y][x]=31;
					else if (terrainTmp[y][x]==ITEM_ground_sable && (y<1 || terrainTmp[y-1][x]==ITEM_ground_eau))
						this.terrain[y][x]=2;
					else if (terrainTmp[y][x]==ITEM_ground_sable && (y+1>=terrainTmp.length || terrainTmp[y+1][x]==ITEM_ground_eau))
						this.terrain[y][x]=44;
					else if (terrainTmp[y][x]==ITEM_ground_sable && x+1<terrainTmp[0].length && terrainTmp[y][x+1]==ITEM_ground_eau)
						this.terrain[y][x]=9;
					else if (terrainTmp[y][x]==ITEM_ground_sable && x>0 && terrainTmp[y][x-1]==ITEM_ground_eau)
						this.terrain[y][x]=43;

						
					// On prend le mesh proposé par terrainTmp
					//else 
					//	this.terrain[y][x]=terrainTmp[y][x];
				}
			}			
		
		}
		
		
	
		if (TEST_AVION){
			
			for (var repetition=0 ; repetition<this.MAX_CASE_HAUT/10 ; repetition++){
				
				this.tEnemies.push({"enemie":TEST_AVION_DEF, "vec":{"x":165,"y":128*repetition*this.MAX_CASE_HAUT/10+500}, "lvl":1});			
			}
			return;
		}
	
		
		//this.fillArray(terrainTmp, ITEM_vide);
		//this.terrain=terrainTmp.slice();

		// // Debug
		// this.terrainFond[this.MAX_CASE_HAUT-2][this.MAX_CASE_LARG/2] = 3;
		// for (var x=0 ; x<this.MAX_CASE_LARG ; x++)
			// this.terrainFond[this.MAX_CASE_HAUT-1][x] = 3;	
	
		
		// this.tBuildings.push({"definition":buildings_house_1c, "vec":{"x":500,"y":500}});
		// //this.tDecors.push({"image":IMAGE_buildings, "item":ITEM_buildings_house_1c, "vec":{"x":500,"y":500}});
	// for (var j=0 ; j<5 ; ++j)
		// for (var i=0 ; i<5 ; ++i)
			// if (this.isTDecorsLibre(IMAGE_decor, ITEM_decor_voiture3, new Vec(400+j*80,300+80*i)))
				// this.tDecors.push({"image":IMAGE_decor, "item":ITEM_decor_voiture3, "vec":{"x":400+j*80,"y":300+80*i}});
				
		// return;
		
		
	
	
		// -------------------------------------     Routes	
		if (type_graphique==GRAPH_FORET || type_graphique==GRAPH_SABLE)
		{
			var rx=100;
			var ry=0;
			var boxTmp;
			var r;
			var roadType;
			var nbLongueur;
			
			
			
			for (var repetition=0 ; repetition<this.MAX_CASE_HAUT/10 ; repetition++){
				
				r=randomInt(3);
											
				// ----- Route droite (horizontal ou vertical)
				if (r==1){
					
					
					var tentative=0;
					var erreurTerrain=true;
					while (tentative<20 && erreurTerrain){
						erreurTerrain=false;						
						
						nbLongueur = 2+randomInt(5);
						roadType=1+randomInt(6);
	
						var rxStart;
						var ryStart;
						
									
						if (roadType==5 || roadType==6){
							rxStart = randomInt(2*128);
							ryStart = (repetition*10+randomInt(10))*128;
						}
						else {
							rxStart = randomInt((this.MAX_CASE_LARG-1)*128);
							ryStart = (repetition*10+randomInt(3))*128;
						}	
	
						for (var passe=0 ; passe<2 ; passe++){
							rx=rxStart;
							ry=ryStart;						
							
							for (var ir=0 ; ir<nbLongueur ; ir++){								
											
								if (roadType==1)
									r=ITEM_decor_road_1;	
								else if (roadType==2)
									r=ITEM_decor_road_2;
								else if (roadType==3)
									r=randomTab([ITEM_decor_road_3,ITEM_decor_road_4]);
								else if (roadType==4)
									r=randomTab([ITEM_decor_asphalt_clean_vert,ITEM_decor_asphalt_clean_to_damaged_vert]);
								else if (roadType==5)
									r=randomTab([ITEM_decor_asphalt_clean_hor,ITEM_decor_asphalt_damaged_hor,ITEM_decor_asphalt_clean_to_damaged_hor]);
								else if (roadType==6)
									r=ITEM_decor_road_5;
								
								boxTmp = imageManager.getCollisionBox(IMAGE_decor, r);
								//this.tDecors.push({"image":IMAGE_decor, "item":r, "vec":{"x":rx,"y":ry}});
								
								if (passe==0){
									if (!this.isTterrainSol(new Vec(rx, ry)) && 
									 	 !(((roadType==5 || roadType==6) && this.isTterrainSol(new Vec(rx+boxTmp.width, ry))) ||
										 ((roadType==5 || roadType==6) && this.isTterrainSol(new Vec(rx, ry+boxTmp.height))))
									){
										erreurTerrain=true;
										break;
									}
								}
								else if (passe==1)
									this.addDecors(IMAGE_decor, r, {"x":rx,"y":ry}, boxTmp);
								
								if (roadType==5 || roadType==6)
									rx += boxTmp.width;
								else
									ry += boxTmp.height;
									
									
									
							}
							
							if (erreurTerrain)
								break;
						}
						
						tentative++;
						
					
						
					}					
				
				}		
				else if (r==2) {
				
					
					//route zig zag
					var DROITE	= 1;
					var GAUCHE	= 2;
					var HAUT		= 3;
					//var BAS		= 4;	//inutile on vas toujours vers le jaut				
					
					rx = randomInt((this.MAX_CASE_LARG-1)*128);
					ry = (repetition*10+randomInt(1))*128;			
					var sense=0;
					var oldsense=0;
					var nbr;
					nbLongueur=3+randomInt(3);
					nbRouteDone=0;
					var arret=false;
					while (nbLongueur>0 && !arret){
	
						oldsense=sense;
						
						if (sense==0){
							if (rx>this.MAX_CASE_LARG*128/2)
								sense=randomTab([GAUCHE, HAUT]);
							else
								sense=randomTab([DROITE, HAUT]);
							
							//sense=randomTab([DROITE, GAUCHE, HAUT]);
						}
						else if (sense==HAUT){
							//sense=randomTab([DROITE, GAUCHE]);
							if (rx>this.MAX_CASE_LARG*128/2)
								sense=GAUCHE;
							else
								sense=DROITE;	
						}		
						else if (sense==DROITE || sense==GAUCHE)
							sense=HAUT;
	
						if (sense==HAUT)
							r=randomTab([ITEM_decor_road_3,ITEM_decor_road_4]);
						else if (sense==DROITE || sense==GAUCHE)
							r=ITEM_decor_road_5;		
						
						boxTmp = imageManager.getCollisionBox(IMAGE_decor, r);
						
											
						if (oldsense==HAUT && sense==DROITE){
							var boxTmpCoin = imageManager.getCollisionBox(IMAGE_decor, ITEM_decor_corner_4);
							
							ry+=boxTmpCoin.height;						
							//this.tDecors.push({"image":IMAGE_decor, "item":ITEM_decor_corner_4, "vec":{"x":rx,"y":ry}});
							this.addDecors(IMAGE_decor, ITEM_decor_corner_4, {"x":rx,"y":ry}, boxTmpCoin);
							rx+=boxTmpCoin.width;
							
						}
						else if (oldsense==HAUT && sense==GAUCHE){
							var boxTmpCoin = imageManager.getCollisionBox(IMAGE_decor, ITEM_decor_corner_1);
							
							ry+=boxTmpCoin.height;
							//this.tDecors.push({"image":IMAGE_decor, "item":ITEM_decor_corner_1, "vec":{"x":rx,"y":ry}});
							this.addDecors(IMAGE_decor, ITEM_decor_corner_1, {"x":rx,"y":ry}, boxTmpCoin);
						}
						else if (oldsense==GAUCHE && sense==HAUT){
							var boxTmpCoin = imageManager.getCollisionBox(IMAGE_decor, ITEM_decor_corner_3);
							
							rx-=boxTmpCoin.width;
							//this.tDecors.push({"image":IMAGE_decor, "item":ITEM_decor_corner_3, "vec":{"x":rx,"y":ry}});
							this.addDecors(IMAGE_decor, ITEM_decor_corner_3, {"x":rx,"y":ry}, boxTmpCoin);
						}				
						else if (oldsense==DROITE && sense==HAUT){
							var boxTmpCoin = imageManager.getCollisionBox(IMAGE_decor, ITEM_decor_corner_2);						
	
							//this.tDecors.push({"image":IMAGE_decor, "item":ITEM_decor_corner_2, "vec":{"x":rx,"y":ry}});
							this.addDecors(IMAGE_decor, ITEM_decor_corner_2, {"x":rx,"y":ry}, boxTmpCoin);
						}	
			
	
						if (sense==HAUT)
							nbr=2+randomInt(3);
						else
							nbr=1+randomInt(this.MAX_CASE_LARG/3);
						
						var rxSave=rx;
						var rySave=ry;
						for (var passe=0 ; passe<2 ; passe++){
							rx=rxSave;
							ry=rySave;
							for (var ir=0 ; ir<nbr ; ir++){
								
								if (ir>0 || nbRouteDone>0){
									if (sense==HAUT)
										ry+=boxTmp.height;
								}				
		
			
								if (sense==GAUCHE)
									rx-=boxTmp.width;
														
								//this.tDecors.push({"image":IMAGE_decor, "item":r, "vec":{"x":rx,"y":ry}});
								if (passe==0){
									if (rx>0 && ry>0 && rx<this.MAX_CASE_LARG*128 && ry<this.MAX_CASE_HAUT*128 && !this.isTterrainSol(new Vec(rx, ry))){
										arret=true;
										break;
									}
								}
								else
								{ 								
									this.addDecors(IMAGE_decor, r, {"x":rx,"y":ry});
								}
								
								
				
								
								
								
								if (sense==DROITE)
										rx+=boxTmp.width;
									
								// SI on sort de l'eccran alors on arret de dessiner des routes
								if (rx<0 || rx>this.MAX_CASE_LARG*128)
								{
									if (passe==1)
										arret=true;
									break;
								}
								
								if (passe==1 && sense==HAUT){
									nbLongueur--;
									if (nbLongueur<=0)
										break;
								}

							}
							
							if (arret)
								break;
						}

						nbRouteDone++;
					}					
				}			
			}				
		}
	 
	
		

		
		// -------------------------------------     Ville	
		if (type_niveau==NIV_ENNEMIE || type_niveau==NIV_DEMO){
			for (var nv=0 ; nv<0.1*this.MAX_CASE_HAUT ; nv++){
			
				var x = randomInt(this.MAX_CASE_LARG);
				var y = randomInt(this.MAX_CASE_HAUT);
				var l = 2+randomInt(2);			// Largeur de la ville (nombre de case)
				var h = 2+randomInt(2);			// hauteur de la ville (nombre de case)

				// Recouvre le terrain avec du sable
				// for (var xx = x ; xx<x+l ; ++xx){
					// for (var yy = y ; yy<y+h ; ++yy){
						// if (xx>=this.MAX_CASE_LARG || this.MAX_CASE_HAUT-yy-1<0)
							// continue;
						// terrainTmp[this.MAX_CASE_HAUT-yy-1][xx]=ITEM_ground_sable;
					// }
				// }

				
				var caseX = x*128;
				var caseY = (y+h-1)*128;			
				var caseXmax = (x+l)*128;
				var caseYmax = (y-1)*128;

				var orientCibleX = (x+l/2)*128;
				var orientCibleY = caseYmax;//(y+h/2-1)*128;
				
				var mx;
				var my=caseY-randomInt(100);

				var maxItemH=0;
				var boxTmp;
				var maison;
				var item;
				while(my>caseYmax){
					mx=caseX+randomInt(200);					
					while(mx<caseXmax){
					
						//item=randomTab([ITEM_buildings_house_1c, ITEM_buildings_house_1d, ITEM_buildings_house_1e, ITEM_buildings_house_2c, ITEM_buildings_house_2d	]);	
						
						maison=randomTab([buildings_house_1c,buildings_house_1d,buildings_house_1e,buildings_house_2c,buildings_house_2d]);
					
						boxTmp = imageManager.getCollisionBox(IMAGE_buildings, maison.item);
						if (mx+boxTmp.width>caseXmax)
							break;
							
							
						if (my-boxTmp.height>caseYmax && this.isTterrainSol(new Vec(mx,my)) && this.isTterrainSol(new Vec(mx,my+128))){
							//var angle = sin()
						
							var directionX = orientCibleX-mx;
							var directionY = orientCibleY-my;
								
							var angle = -90-orient(new Vec(mx, my), new Vec(orientCibleX, orientCibleY));
							

							this.addBuildings(maison, {"x":mx,"y":my}, angle, boxTmp);
							//this.tBuildings.push({"definition":maison, "vec":{"x":mx,"y":my}, "angle":angle});
							//this.tDecors.push({"image":IMAGE_buildings, "item":maison.item, "vec":{"x":mx,"y":my}});
						}

						
						mx+=boxTmp.width;
						mx+=5+randomInt(100);					

						if (maxItemH<boxTmp.height)
							maxItemH=boxTmp.height;
					}
					my-=maxItemH;
					my-=5+randomInt(100);

					// if (my<caseYmax)
						// break;
				}
			
				for (var x=0, max=l*h*2 ; x<max ; x++){
					mx = caseXmax+randomInt(caseX-caseXmax);
					my = caseYmax+randomInt(caseY-caseYmax);
					
					item=randomTab([ITEM_decor_bidon1,ITEM_decor_bidon2,
						ITEM_decor_pierre1,ITEM_decor_pierre2,ITEM_decor_pierre3,ITEM_decor_pierre4,ITEM_decor_pierre5,ITEM_decor_pierre6,ITEM_decor_pierre7,ITEM_decor_pierre8,ITEM_decor_pierre9,ITEM_decor_pierre10,ITEM_decor_pierre11,ITEM_decor_pierre12,ITEM_decor_pierre13,
						ITEM_decor_voiture1,ITEM_decor_voiture2,ITEM_decor_voiture3,ITEM_decor_voiture4,ITEM_decor_voiture5,ITEM_decor_voiture6,ITEM_decor_voiture7]);

					if (this.isTDecorsLibre(IMAGE_decor, item, new Vec(mx,my)) && this.isTterrainSol(new Vec(mx,my)) && this.isTterrainSol(new Vec(mx,my+128)))
						//this.tDecors.push({"image":IMAGE_decor, "item":item, "vec":{"x":mx,"y":my}});
						this.addDecors(IMAGE_decor, item, {"x":mx,"y":my});
				}
			}
		}



		// Buildings	
		if (type_niveau==NIV_ENNEMIE || type_niveau==NIV_DEMO){
			for (var i=0 ; i<0.1*this.MAX_CASE_HAUT ; ++i){
				var batiment = randomTab([buildings_bunkers_1x1,buildings_bunkers_1x1b,buildings_bunkers_1x2,buildings_bunkers_2x1,buildings_bunkers_2x2,buildings_bunkers_2x2_2,buildings_bunkers_big,buildings_bunkers_big_top]);			
			
				var x = randomInt(this.MAX_CASE_LARG*128);
				var y = randomInt(this.MAX_CASE_HAUT*128-imageManager.getCollisionBox(IMAGE_buildings, batiment.item).height);
				
				
				if (this.isTDecorsLibre(IMAGE_buildings, batiment.item, new Vec(x,y)) && this.isTterrainSable(new Vec(x,y)) && this.isTterrainSable(new Vec(x,y+128)))
					//this.tDecors.push({"image":IMAGE_buildings, "item":item_building, "vec":{"x":x,"y":y}});
					//this.tBuildings.push({"building":item_building, "itemDetruit":0, "indesctructible":true, "vie":2, "vec":{"x":x,"y":y}});
					//this.tBuildings.push({"definition":batiment, "vec":{"x":x,"y":y}, "angle":0});
					this.addBuildings(batiment, {"x":x,"y":y}, 0);
					
			}
		}


		
		

	// Foret arbre
messageLog("niveau foret");	
var debug_arbre_start = new Date();	

		var tarbreTmp = new Array();
		this.fillArray(tarbreTmp, ITEM_vide);
		
		var OCCUPER			 	 = 5;
		var ARBRE_DENSITER_1 = 1;
		var ARBRE_DENSITER_2 = 2;
		var ARBRE_DENSITER_3 = 3;
		var ARBRE_DECOR 	 = 4;



		for (var x=0 ; x<this.MAX_CASE_LARG ; x++){
			for (var y=0 ; y<this.MAX_CASE_HAUT ; y++){
				if (this.tPlaceOccuperDecors[y][x] || this.tPlaceOccuperBuildings[y][x])
					tarbreTmp[y][x]=OCCUPER;
			}
		}




		
		//for (var x=0, max=this.MAX_CASE_LARG*this.MAX_CASE_HAUT/2 ; x<max ; x++){
		for (var x=0, max=this.MAX_CASE_LARG*this.MAX_CASE_HAUT/5 ; x<max ; x++){
			this.genereTacheArray(tarbreTmp, ARBRE_DENSITER_1, 1, 1, 1, 1,
											function(tableau, x, y){
											 	if (tableau[y][x]==OCCUPER)
											 		return false;
												return true;
											});
		}
		
		for (var x=0 ; x<0.4*this.MAX_CASE_HAUT ; x++){			
			this.genereTacheArray(tarbreTmp, ARBRE_DENSITER_2, 1, 1, this.MAX_CASE_LARG/3, 3,
										function(tableau, x, y){
												if (tableau[y][x]==OCCUPER)
											 		return false;
												return true;
											});	
		}											
		
	
		for (var x=0, max=0.5*this.MAX_CASE_HAUT ; x<max ; x++){
			this.genereTacheArray(tarbreTmp, ARBRE_DECOR, 1, 1, 1, 1,
											 function(tableau, x, y){
												if (tableau[y][x]==OCCUPER)
											 		return false;
												return true;
											});
		}	

		
		for (var x=0 ; x<0.4*this.MAX_CASE_HAUT ; x++){			
			this.genereTacheArray(tarbreTmp, ARBRE_DENSITER_3, 1, 1, 3, 3,
											function(tableau, x, y){
												if (tableau[y][x]==OCCUPER)
											 		return false;
												return true;
											},
											function(tableau, x, y, l, h, me){
										
												for (var y1=- Math.floor(h/2), maxY1=Math.ceil(h/2) ; y1<maxY1 ; y1++){
													for (var x1=-Math.floor(l/2), maxX1=Math.ceil(l/2) ; x1<maxX1 ; x1++){
														casex = x+x1;
														casey = y+y1;
										
														if (casex<0 || casex>=me.MAX_CASE_LARG || casey<0 || casey>=me.MAX_CASE_HAUT)
															continue;
										
														tableau[casey][casex]=OCCUPER;
													}
												}										
												
											
												var larg = l*128;	// Largeur sur laquel on veut etaler des arbres
												var haut = h*128;	// Hauteur sur laquel on veut etaler des arbres
												var startX = (x-Math.floor(h/2))*128;
												var startY = (me.MAX_CASE_HAUT-y-1-Math.floor(l/2))*128;
												var item;
												var image;

												var arbreX=startX;
												var arbreY=startY;
												var decorBox;
												var maxItemY
												
												
												while (arbreY<startY+haut){
													maxItemY=10;
													arbreX=startX+randomInt(64);
													while (arbreX<startX+larg){
														image=IMAGE_trees;
														item=randomTab([ITEM_trees_1, ITEM_trees_2, ITEM_trees_3]);
														decorBox = imageManager.getCollisionBox(image, item);
														
														if (arbreX+decorBox.width>startX+larg || arbreY+decorBox.width>startY+haut)
															break;
														
														//if (me.isTDecorsLibre(image, item, new Vec(arbreX,arbreY)) && me.isTterrainSol(new Vec(arbreX,arbreY)) && me.isTterrainSol(new Vec(arbreX,arbreY+128)))														
															//me.tDecors.push({"image":image, "item":item, "vec":{"x":arbreX,"y":arbreY}});
														if(me.isTterrainForet(new Vec(arbreX,arbreY)) || me.isTterrainForet(new Vec(arbreX,arbreY+128)))
															me.addDecors(image, item, {"x":arbreX,"y":arbreY-5+randomInt(10)});
														
														
														
			
														arbreX+=decorBox.width+randomInt(5);
														
														if (decorBox.height>maxItemY)
															maxItemY=decorBox.height;
													}
													
													arbreY+=maxItemY+randomInt(10);
												}			
											});	
		}		


	
		for (var y=this.MAX_CASE_HAUT-1 ; y>=0 ; y--)
		{
			for (var x=0 ; x<this.MAX_CASE_LARG ; x++)
			{
				var caseX = x*128;
				var caseY = (this.MAX_CASE_HAUT-y-1)*128;
				

				var nbArbre;
				if (tarbreTmp[y][x]==ARBRE_DENSITER_1){
					nbArbre=1;
				}
				else if (tarbreTmp[y][x]==ARBRE_DENSITER_2){
					nbArbre=2;
				}
				//else if (tarbreTmp[y][x]==ARBRE_DENSITER_3){
				//	nbArbre=10;
				//}
				else if (tarbreTmp[y][x]==ARBRE_DECOR){
					nbArbre=1;
				}
				else 
					continue;


				var item;
				var image;
				var boxTmp;
				for (var nb=0 ; nb<nbArbre ; nb++){
	
					
					if (tarbreTmp[y][x]==ARBRE_DENSITER_1 || tarbreTmp[y][x]==ARBRE_DENSITER_2 || tarbreTmp[y][x]==ARBRE_DENSITER_3){
						image=IMAGE_trees;
						item=randomTab([/*ITEM_trees_1, ITEM_trees_2, ITEM_trees_3,*/ ITEM_trees_4, ITEM_trees_5, ITEM_trees_6, ITEM_trees_7, ITEM_trees_8, ITEM_trees_9, ITEM_trees_10, ITEM_trees_11, ITEM_trees_12, ITEM_trees_13, ITEM_trees_14, ITEM_trees_15, ITEM_trees_16, ITEM_trees_17]);	
					}
					else if (tarbreTmp[y][x]==ARBRE_DECOR){
						image=IMAGE_decor;
						item=randomTab([ITEM_decor_tank1,ITEM_decor_tank2,
									ITEM_decor_avion1,ITEM_decor_avion2,ITEM_decor_avion3,ITEM_decor_avion4,
									ITEM_decor_voiture1,ITEM_decor_voiture2,ITEM_decor_voiture3,ITEM_decor_voiture4,ITEM_decor_voiture5,ITEM_decor_voiture6,ITEM_decor_voiture7,
									ITEM_decor_socle1,ITEM_decor_socle2,ITEM_decor_socle3,ITEM_decor_socle4,ITEM_decor_socle5,ITEM_decor_socle6,
									ITEM_decor_caisse1,ITEM_decor_caisse2,ITEM_decor_caisse3,ITEM_decor_caisse4,
									ITEM_decor_bidon1,ITEM_decor_bidon2,
									ITEM_decor_herbe,
									ITEM_decor_pierre1,ITEM_decor_pierre2,ITEM_decor_pierre3,ITEM_decor_pierre4,ITEM_decor_pierre5,ITEM_decor_pierre6,ITEM_decor_pierre7,ITEM_decor_pierre8,ITEM_decor_pierre9,ITEM_decor_pierre10,ITEM_decor_pierre11,ITEM_decor_pierre12,ITEM_decor_pierre13]);
					}
					
					boxTmp = imageManager.getCollisionBox(image, item);
					
					var arbreX = caseX+randomInt(128-boxTmp.width);
					var arbreY = caseY+randomInt(128-boxTmp.height);

					if(this.isTterrainSol(new Vec(arbreX,arbreY)) && this.isTterrainSol(new Vec(arbreX,arbreY+128)) &&
						// this.isTDecorsLibre(image, item, new Vec(arbreX,arbreY)) &&	// trop gourmand
 						(!(tarbreTmp[y][x]==ARBRE_DENSITER_1 || tarbreTmp[y][x]==ARBRE_DENSITER_2 || tarbreTmp[y][x]==ARBRE_DENSITER_3) || (this.isTterrainForet(new Vec(arbreX,arbreY)) || this.isTterrainForet(new Vec(arbreX,arbreY+128)))))
						//this.tDecors.push({"image":image, "item":item, "vec":{"x":arbreX,"y":arbreY}});
						this.addDecors(image, item, {"x":arbreX,"y":arbreY});
	
				}
	
			}
		}
		
		



		//--------------------------------------------------     Ennemies
messageLog("niveau Enemies");	
var debug_enemies_start = new Date();
		
		if (type_niveau==NIV_ENNEMIE || type_niveau==NIV_DEMO)
		{
			
			// ------------------------------ Ennemie Volant --------------------------------------------
			//this.tEnnemies.push({"enemie":7, "vec":{"x":504,"y":384}});
			var AVION_VIDE	= -1;
			var AVION_NIV1	 = 1;
			var AVION_VAGUE	 = 2;
			var AVION_BIG	 = 3;
			var AVION_NIV4	 = 4;
			
			var ennemieTmp = new Array();
			this.fillArray(ennemieTmp, -1);




			//-------- Genere avion bonus
			if (this.MAX_CASE_HAUT>35){	// Pour un grand niveau, on en met 3 espacé equitablement
				//for (var i=0 ; i<2 ; i++){
				//	var re = randomInt(tEnnemieBonus.length);
				//	var x = randomInt(this.MAX_CASE_LARG);
				//	var y = this.MAX_CASE_HAUT - (1+i)*Math.floor(this.MAX_CASE_HAUT/3) - 1;
				//	addEnnemieInTabEnnemie(ennemieTmp, tEnnemieBonus[re], x, y);			
				//}
	
				for (var i=0 ; i<2 ; i++){
					var x = randomInt(this.MAX_CASE_LARG);
					var y = this.MAX_CASE_HAUT - (1+i)*Math.floor(this.MAX_CASE_HAUT/3) - 1;
					addEnnemieInTabEnnemie(ennemieTmp, avion_P38ArmeLvlUp, x, y+10);		// Celui ci apparraitra avant dans le jeux
					addEnnemieInTabEnnemie(ennemieTmp, avion_P38Vie, x, y-10);				// Celui ci apres (20 case plus loin)
				}				
				
				
			}
			//else if (randomInt(3)==1){	// Si le niveau est petit on a une chance sur 3 d'en mettre 1 n'importe ou dans le niveau
			//	var re = randomInt(tEnnemieBonus.length);
			//	var x = randomInt(this.MAX_CASE_LARG);
			//	var y = randomInt(this.MAX_CASE_HAUT);;
			//	addEnnemieInTabEnnemie(ennemieTmp, tEnnemieBonus[re], x, y);			
			//}



			// Creation des ennemies etalé tous au long du niveau
			for (var i=0, max=this.MAX_CASE_HAUT/10 ; i<max ; i++){
				
				var c = this.MAX_CASE_HAUT-i*10;
				
				
				//var agressivite = i*3;
				
				var agressivite = i*(lvl+3)+(lvl-1)*15;
				agressivite+=lvl*2;
				if (type_niveau==NIV_DEMO)
					agressivite = 4;
				
							
				
				
				
				
				// Genere des escadrons
				var re = randomInt(tEnnemieEscadron.length);
				var x=randomInt(3);
				var y=c-1-randomInt(10);
				// Regarde si la place est disponible pour positionné l'escadron
				var placeLibre=true;
				for (var n=0, x1=x, y1=y ; n<tEnnemieEscadron[re].nb ; n++){
					if (!isTabEnnemieLibrePourEnnemie(ennemieTmp, tEnnemieEscadron[re].avion, x1, y1)){
						placeLibre=false;
						break;
					}
					x1+=tEnnemieEscadron[re].ecartX;
					y1+=tEnnemieEscadron[re].ecartY;			
					if (x1<0 || y1<0 || x1>=this.MAX_CASE_LARG || y1>=this.MAX_CASE_HAUT)
						break;
				}
				if (placeLibre){
					// Positionne l'escadron
					for (var n=0 ; n<tEnnemieEscadron[re].nb ; n++){
						
						addEnnemieInTabEnnemie(ennemieTmp, tEnnemieEscadron[re].avion, x, y);
						//ennemieTmp[y][x]=findEnnemieDefIndice(tEnnemieEscadron[re].avion);
						x+=tEnnemieEscadron[re].ecartX;
						y+=tEnnemieEscadron[re].ecartY;
						
						if (x<0 || y<0 || x>=this.MAX_CASE_LARG || y>=this.MAX_CASE_HAUT)
							break;
					}
					agressivite-=tEnnemieEscadron[re].avion.agressivite*tEnnemieEscadron[re].nb/2;
				}

var debugTentativePlacement=0;				
				// Genere ennemie simple
				var ennemie=-1;
				while (agressivite>0){
debugTentativePlacement++;						
					// Cherche un ennemie
					var nbe = 0;
					for (var e=0, maxe=tEnnemieSingle.length ; e<maxe ; e++){
						if (type_graphique==GRAPH_EAU && tEnnemieSingle[e].id=="tank")
							continue;
						if (tEnnemieSingle[e].agressivite<=agressivite)
							++nbe;
					}
					if (nbe==0)
						break;
					var r = randomInt(nbe);
					for (var e=0, maxe=tEnnemieSingle.length ; e<maxe ; e++){
						if (type_graphique==GRAPH_EAU && tEnnemieSingle[e].id=="tank")
							continue;
						if (tEnnemieSingle[e].agressivite<=agressivite){
							r--;
							if (r<0){
								ennemie=e;
								agressivite-=tEnnemieSingle[ennemie].agressivite;
								break;
							}
						}
					}
									
			
					if (ennemie<0)
						alert("niveau.js ennemie<0");
					
					this.genereTacheArray(ennemieTmp, ennemie, 1, 1, 1, 1,
											 function(tableau, xe, ye){
													return isTabEnnemieLibrePourEnnemie(tableau, tEnnemieSingle[ennemie], xe, ye);								
											},
											function(tableau, xe, ye, l, h){
													// Rempli tableau en prenant en compte la zone d'influence de l'enemie
													addEnnemieInTabEnnemie(tableau, tEnnemieSingle[ennemie], xe, ye);
											},
											undefined, c,  undefined, c-10);
	
				}
				
			}
		
			for (var y=this.MAX_CASE_HAUT-1 ; y>=0 ; y--)
			{
				for (var x=0 ; x<this.MAX_CASE_LARG ; x++)
				{
					var caseX = x*128;
					var caseY = (this.MAX_CASE_HAUT-y-1)*128;
					
					if (ennemieTmp[y][x]>0)
						this.tEnemies.push({"enemie":tEnnemieDef[ennemieTmp[y][x]], "vec":{"x":caseX,"y":caseY}, "lvl":lvl});
				}
			}	
			
			
			
			
			
			
			
			// ------------------------------ Ennemie Terrestre --------------------------------------------
			var ennemieTerreTmp = new Array();
			this.fillArray(ennemieTerreTmp, -1);
			
			var tourelle=0;
			var nbTourelle=0;
			for (var c=0, max=this.MAX_CASE_HAUT/10 ; c<max ; c++){
				
				if (this.MAX_CASE_HAUT<20)
					nbTourelle = randomTab([0,2,4]);
				else if (c<3)
					nbTourelle=0;
				else
					nbTourelle = randomTab([0,Math.floor(c*lvl/4),Math.floor(c*lvl/2)]);		
					
				if (nbTourelle<=0)
					continue;					
					
				
				
				// Cherche un ennemie
				//tourelle = randomInt(tEnnemieTourelle.length);
				var nbe = 0;
				for (var e=0, maxe=tEnnemieTourelle.length ; e<maxe ; e++){
					if (tEnnemieTourelle[e].agressivite<=lvl)
						++nbe;
				}
				if (nbe==0)
					break;
				var r = randomInt(nbe);
				for (var e=0, maxe=tEnnemieTourelle.length ; e<maxe ; e++){
					if (tEnnemieTourelle[e].agressivite<=lvl){
						r--;
						if (r<0){
							tourelle=e;
							break;
						}
					}
				}				
				
				
				
				
				
				
				
				
			
				for (var t=0 ; t<nbTourelle ; t++){
		
					this.genereTacheArray(ennemieTerreTmp, tourelle, 1, 1, 1, 1,
											function(tableau, x, y, me){												
											 	if (tableau[y][x]!=-1)
											 		return false;
											 	
											 	if (me.tPlaceOccuperDecors[y][x] || me.tPlaceOccuperBuildings[y][x])
											 		return false;
											 		
											 	if (me.isCaseTerrainSol(x,y))
									 				return true;
									 			else 
									 				return false;
											},
											undefined,
											undefined, c*10+10,  undefined, c*10
											);
											
				}				
				
			}
			
			for (var y=this.MAX_CASE_HAUT-1 ; y>=0 ; y--)
			{
				for (var x=0 ; x<this.MAX_CASE_LARG ; x++)
				{
					var caseX = x*128;
					var caseY = (this.MAX_CASE_HAUT-y-1)*128;
					
					if (ennemieTerreTmp[y][x]>=0)
						this.tEnemies.push({"enemie":tEnnemieTourelle[ennemieTerreTmp[y][x]], "vec":{"x":caseX,"y":caseY}, "lvl":lvl});
				}
			}
		
		
		
			
			// ------------------------------ Ennemie Naviguant --------------------------------------------
			if (type_graphique==GRAPH_EAU){
				var tennemieMerTmp = new Array();
				this.fillArray(tennemieMerTmp, -1);
				
				var bateau=0;
				var nbBateau=0;
				
								
				
				for (var c=0, max=this.MAX_CASE_HAUT/10 ; c<max ; c++){
		
					var nbCaseEau = 0;
					for (var x=0 ; x<this.MAX_CASE_LARG ; x++){
						for (var y=c*10 ; y<c*10+10 ; y++){
							if (this.isCaseTerrainEau(x,y))
								nbCaseEau++;
						}
					}
					
					nbBateau=Math.floor(nbCaseEau/5);
					if (nbBateau==0)
						continue;
					
		
					// Cherche un ennemie
					var nbe = 0;
					for (var e=0, maxe=tEnnemieBateau.length ; e<maxe ; e++){
						if (tEnnemieBateau[e].agressivite<=lvl)
							++nbe;
					}
					if (nbe==0)
						break;
					var r = randomInt(nbe);
					for (var e=0, maxe=tEnnemieBateau.length ; e<maxe ; e++){
						if (tEnnemieBateau[e].agressivite<=lvl){
							r--;
							if (r<0){
								bateau=e;
								break;
							}
						}
					}		
		
			
				
					for (var t=0 ; t<nbBateau ; t++){
			
						this.genereTacheArray(tennemieMerTmp, bateau, 1, 1, 1, 1,
												function(tableau, x, y, me){
												 	if (tableau[y][x]!=-1)
												 		return false;
												 	
												 	if (me.tPlaceOccuperDecors[y][x] || me.tPlaceOccuperBuildings[y][x])
												 		return false;
												 		
												 	if (me.isCaseTerrainEau(x,y) && me.isCaseTerrainEau(x,y-1) && me.isCaseTerrainEau(x,y-2))
										 				return isTabEnnemieLibrePourEnnemie(tableau, tEnnemieBateau[bateau], x, y);
										 			else 
										 				return false;
												},
												function(tableau, xe, ye, l, h){
														// Rempli tableau en prenant en compte la zone d'influence de l'enemie
														addEnnemieInTabEnnemie(tableau, tEnnemieBateau[bateau], xe, ye);
												},

												undefined, c*10+10,  undefined, c*10
												);
					}				
					
				}
				
				for (var y=this.MAX_CASE_HAUT-1 ; y>=0 ; y--)
				{
					for (var x=0 ; x<this.MAX_CASE_LARG ; x++)
					{
						var caseX = x*128;
						var caseY = (this.MAX_CASE_HAUT-y-1)*128;
						
						if (tennemieMerTmp[y][x]>=0)
						{
							if (tEnnemieDef[tennemieMerTmp[y][x]]==undefined){
								messageLog("niveau erreur bateau");
								continue;
							}
							this.tEnemies.push({"enemie":tEnnemieDef[tennemieMerTmp[y][x]], "vec":{"x":caseX,"y":caseY}, "lvl":lvl});
						}
					}
				}
			}
			
					
			
			
			
			
			
			
			messageLog("nb enemie generere:"+this.tEnemies.length);	
			messageLog("nb enemie generere tentative:"+debugTentativePlacement);		
		
		
		
		
		
		
		
			//var ennemieTmp = new Array();
			//this.fillArray(ennemieTmp, null);		
			// var y, r;
		
			// y=this.MAX_CASE_HAUT-(15+randomInt(10));
			// r=30;
			// while(y>0){		
				// this.genereTacheArray(ennemieTmp, AVION_VAGUE, 1, 1, 1, 1,
										 // function(tableau, x, y){
											// if (tableau[y][x]==null)
												// return true;
											// else
												// return false;
										// },
										// undefined,
										// this.MAX_CASE_LARG/2, y-5,  this.MAX_CASE_LARG/2, y);
				// y-=(10+randomInt(r));
				// r-=0.5;
			// }

			// y=this.MAX_CASE_HAUT-(20+randomInt(10));
			// r=15;
			// while(y>0){		
				// this.genereTacheArray(ennemieTmp, AVION_BIG, 1, 1, 1, 1,
										 // function(tableau, x, y){
											// if (tableau[y][x]==null)
												// return true;
											// else
												// return false;
										// },
										// undefined,
										// undefined, y-5,  undefined, y);
				// y-=(10+randomInt(r));
				// r-=0.5;
			// }

			
			
			// for (var i=0 ; i<20 ; i++)
				// this.genereTacheArray(ennemieTmp, AVION_NIV1, 1, 1, 1, 1,
										 // function(tableau, x, y){
											 // if (tableau[y][x]==null)
												// return true;
											// else
												// return false;
										// },
										// undefined,
										// undefined, 5,  undefined, this.MAX_CASE_HAUT-5);
										
			
			
			// for (var y=this.MAX_CASE_HAUT-1 ; y>=0 ; y--)
			// {
				// for (var x=0 ; x<this.MAX_CASE_LARG ; x++)
				// {
					// var caseX = x*128;
					// var caseY = (this.MAX_CASE_HAUT-y-1)*128;
					
					// var avion=null;
					// if (ennemieTmp[y][x]==AVION_NIV1)
						// avion=randomTab([avion_zigzagtir, avion_chargeur]);
					// else if (ennemieTmp[y][x]==AVION_VAGUE){
						// avion=avion_zigzagtir;
						// caseX-=220;
						// for (var n=0 ; n<4 ; n++)
							// this.tEnemies.push({"enemie":avion, "vec":{"x":caseX+110*n,"y":caseY}, "lvl":lvl});
							
						// continue;
					// }
					// else if (ennemieTmp[y][x]==AVION_BIG)
						 // avion=avion_P38;
					// else
						// continue;
						
						

						
					// this.tEnemies.push({"enemie":avion, "vec":{"x":caseX,"y":caseY}, "lvl":lvl});
				// }
			// }
			
			
		}
		
		

		
messageLog("nbappelFonction isDecorLIbre"+this.DebugNbAppelFonction);
messageLog("isDecorLIbre optimiser nb:"+this.DebugNbOptimOk);


var debug_enemies_end = new Date();
var t_enemies = debug_enemies_end.getTime() - debug_enemies_start.getTime();
messageLog("genere enemies:"+t_enemies);

		
		if (type_niveau==NIV_BOSS)
			this.tEnemies.push({"enemie":boss_avion2, "vec":{"x":200,"y":1000}, "lvl":lvl});
		
		// for (var i=0, max=Math.floor(this.MAX_CASE_HAUT*128/1000) ; i<max ; i++){
			// this.tEnemies.push({"enemie":vehicule_tank5, "vec":{"x":randomInt(Math.floor((this.MAX_CASE_LARG-1)*128)),"y":(i+1)*1000}, "lvl":lvl});
		// }

		
		
		//messageLog(this.tDecors.length);
		
	},
	
	getHauteur: function(){
		return this.terrain.length*128;
	},
});






	
// renvoi vrai ou faux, si l'ennemiedef a la place de ce mettre dans le tableau
var isTabEnnemieLibrePourEnnemie = function(tableau, ennemieDef, xe, ye) {	

												
		//Verify qu'il ya la place pour mettre l'ennemie avec son influence sur le terrain 												
		
		var eTabPosX = 3;		// Position en X de l'ennemie dans le tableau
		var eTabPosY = 3;		// Position en Y de l'ennemie dans le tableau
		var tabLength = 7;													
		
		for (var x=xe-eTabPosX, maxx=x+tabLength, cx=0; x<maxx ; x++, cx++){
			for (var y=ye-eTabPosY, maxy=y+tabLength, cy=0; y<maxy ; y++,cy++){
				
				if (y<0 || y>=tableau.length || x<0 || x>=tableau[y].length)
					continue;
				if (cy<0 || cy>=tabLength || cx<0 || cx>=tabLength){
					messageLog("influenceTerrain erreur, debordement");
					continue;		
				}
				
				if (tableau[y][x]!=-1 && ennemieDef.influenceTerrain[cy][cx])
					return false;
			}
		}													
		
		return true;

	
}	


// Ajoute dans le tableau un ennemie avec son influence
var addEnnemieInTabEnnemie = function(tableau, ennemiedef, xe, ye) {	

		// Rempli tableau en prenant en compte la zone d'influence de l'enemie
		
		var eTabPosX = 3;		// Position en X de l'ennemie dans le tableau
		var eTabPosY = 3;		// Position en Y de l'ennemie dans le tableau
		var tabLength = 7;
		

		for (var x=xe-eTabPosX, maxx=x+tabLength, cx=0; x<maxx ; x++, cx++){
			for (var y=ye-eTabPosY, maxy=y+tabLength, cy=0; y<maxy ; y++,cy++){
				
				if (y<0 || y>=tableau.length || x<0 || x>=tableau[y].length)
					continue;
				if (cy<0 || cy>=tabLength || cx<0 || cx>=tabLength){
					messageLog("influenceTerrain erreur, debordement");
					continue;		
				}																									
				
				if (ennemiedef.influenceTerrain[cy][cx]==-2)
					tableau[y][x]=findEnnemieDefIndice(ennemiedef);
				else if (ennemiedef.influenceTerrain[cy][cx]==-1 && tableau[y][x]<0)
					tableau[y][x]--;
			}
		}

}
	
	