var Text2 = Entity.extend({

	init: function(text, vec){
		this._super();
		this.tile = new Tile(IMAGE_font);	
		this.coord = vec;
		this.text = text;
	},

	setText: function(text){
		this.text = text;
	},
	
	drawChar: function(ascii, vpos){
		ascii -= 32;
		
		var col = ascii%16;
		var lig = Math.floor(ascii/16);
		
		this.tile.setSprite(col*16, lig*16, 16, 16);
		this.tile.setPosition(vpos);
		this.tile.draw();
	},
	
	draw: function(){
		
		var pos = this.coord.copy();
		for (var i=0, max=this.text.length ; i<max ; i++){
			this.drawChar(this.text.charCodeAt(i), pos);
			pos.x+=16;
		}	
	},	
});



var TM_LEFT 	= 0X0001;
var TM_CENTER 	= 0X0002;
var TM_RIGHT	= 0X0004;
var TM_TOP 		= 0X0008;
var TM_MIDDLE 	= 0X0010;
var TM_BOTTOM	= 0X0020;
var Text = Entity.extend({
	

	init: function(text, vec, size, mode){
		this._super();
		if (mode==size)
			size=20;
		if (mode==undefined)
			mode=TM_LEFT;

			
		this.tile = new Tile(IMAGE_font);	
		this.coord = vec;
		this.text = text;
		this.size = size;
		this.mode = mode;
		this.color = "#000000";
		
		this.clignote=false;
		this.timeClignote=0;
	},

	setText: function(text){
		this.text = text;
	},

	setColor: function(text){
		this.color = text;
	},
	
	startClignote: function(){
		this.clignote=true;
		this.timeClignote=game.timeElapse;
	},
	stopClignote: function(){
		this.clignote=false;
	},	
	
	draw: function(){
		
		if (this.clignote){
			var time=(game.timeElapse%1000);
			if (time>500)
				return;
		}
				
		canvas2DContext.save();	
		canvas2DContext.font=""+this.size+"px pixeladeregular";
		canvas2DContext.fillStyle=this.color;
		canvas2DContext.textBaseline="top"; 
	
	

	
		var textrendu="";
		var textreste=this.text;
		var poslf;
		var x,y;
		
		
		
		
		y=this.coord.y;
		if (this.mode&TM_MIDDLE){
			var nbLigne = textreste.split("\n").length;
			if (nbLigne==0)
				nbLigne++;
			y-=nbLigne*this.size/2;
		}
		else if (this.mode&TM_BOTTOM){
			var nbLigne = textreste.split("\n").length;
			if (nbLigne==0)
				nbLigne++;
			y-=nbLigne*this.size;	
		}		
			



		while (textreste!=""){
		
			poslf=textreste.indexOf("\n");
			if (poslf>0){
				textrendu=textreste.substring(0, poslf);
				textreste=textreste.substring(poslf+1);
			}
			else {
				textrendu=textreste;
				textreste="";
			}
			
			x=this.coord.x;
			if (this.mode&TM_CENTER)
				x-=this.getSizeLine(textrendu)/2;
			else if (this.mode&TM_RIGHT)
				x-=this.getSizeLine(textrendu);
			
			canvas2DContext.fillText(textrendu,x,y);
			y+=this.size;
			
		}	
	
		canvas2DContext.restore();
		
	},
	
	getSizeLine: function(t){
		//canvas2DContext.font=""+this.size+"px Georgia";
		canvas2DContext.font=""+this.size+"px pixeladeregular";
		
		return canvas2DContext.measureText(t).width;	
	},	
	
	getSize: function(){
		//canvas2DContext.font=""+this.size+"px Georgia";
		canvas2DContext.font=""+this.size+"px pixeladeregular";
		
		return canvas2DContext.measureText(this.text).width;	
	}
});