/* Simple JavaScript Inheritance
 * By John Resig http://ejohn.org/
 * MIT Licensed.
 */
// Inspired by base2 and Prototype
(function(){
  var initializing = false, fnTest = /xyz/.test(function(){xyz;}) ? /\b_super\b/ : /.*/;
 
  // The base Class implementation (does nothing)
  this.Class = function(){};
 
  // Create a new Class that inherits from this class
  Class.extend = function(prop) {
    var _super = this.prototype;
   
    // Instantiate a base class (but only create the instance,
    // don't run the init constructor)
    initializing = true;
    var prototype = new this();
    initializing = false;
   
    // Copy the properties over onto the new prototype
    for (var name in prop) {
      // Check if we're overwriting an existing function
      prototype[name] = typeof prop[name] == "function" &&
        typeof _super[name] == "function" && fnTest.test(prop[name]) ?
        (function(name, fn){
          return function() {
            var tmp = this._super;
           
            // Add a new ._super() method that is the same method
            // but on the super-class
            this._super = _super[name];
           
            // The method only need to be bound temporarily, so we
            // remove it when we're done executing
            var ret = fn.apply(this, arguments);        
            this._super = tmp;
           
            return ret;
          };
        })(name, prop[name]) :
        prop[name];
    }
   
    // The dummy class constructor
    function Class() {
      // All construction is actually done in the init method
      if ( !initializing && this.init )
        this.init.apply(this, arguments);
    }
   
    // Populate our constructed prototype object
    Class.prototype = prototype;
   
    // Enforce the constructor to be what we expect
    Class.prototype.constructor = Class;
 
    // And make this class extendable
    Class.extend = arguments.callee;
	
   
    return Class;
  };
})();

var messageLog = function(t) {
	if (DEV)
    console.log(t);
};


var Box = Class.extend({
	init: function(x, y, width, height){
		if (x!=undefined && y!=undefined && width!=undefined && height!=undefined){
			this.x = x;
			this.y = y;
			this.width = width;
			this.height = height;
		}
		else {
			this.x = 0;
			this.y = 0;
			this.width = 0;
			this.height = 0;
		}
	},
	copy: function(){
		return new Box(this.x, this.y, this.width, this.height);
	},	
	
	addVec: function(vec){
		this.x += vec.x;
		this.y += vec.y;
	},
	raz: function(){
		this.x = 0;
		this.y = 0;
		this.width = 0;
		this.height = 0;
	},
	boxCollision: function(box2, vdecalme, vdecalbox2){
		if (vdecalme==undefined)
			vdecalme = new Vec(0,0);
		if (vdecalbox2==undefined)
			vdecalbox2 = new Vec(0,0);
	
		if ((vdecalbox2.y+box2.y>vdecalme.y+this.y+this.height) || 	// Box2 est en dessou de this
			(vdecalbox2.y+box2.y+box2.height<vdecalme.y+this.y) || 	// Box2 est au dessu de this
			(vdecalbox2.x+box2.x>vdecalme.x+this.x+this.width) || 				// Box2 est a droite de this
			(vdecalbox2.x+box2.x+box2.width<vdecalme.x+this.x))					// Box2 est a gauche de this
			return 0;
			
		return 1;
	},
	
	boxCollisionVec: function(vec, vdecalme){
		if (vdecalme==undefined)
			vdecalme = new Vec(0,0);


		if (vec.y>vdecalme.y+this.y+this.height ||
			vec.y<vdecalme.y+this.y ||
			vec.x>vdecalme.x+this.x+this.width ||
			vec.x<vdecalme.x+this.x)
			return 0;
			
		return 1;
	},
});

var Vec = Class.extend({

	init: function(x, y){
		if (x!=undefined && y!=undefined){
			this.x = x;
			this.y = y;
		}
		else {
			this.x = 0;
			this.y = 0;	
		}
	},
	
	copy: function(){
		return new Vec(this.x, this.y);
	},
	
	addVec: function(vec){
		this.x += vec.x;
		this.y += vec.y;
	},
	
	multF: function(f){
		this.x *= f;
		this.y *= f;
	},	
	
	setVec: function(vec){
		this.x = vec.x;
		this.y = vec.y;
	},
	
	getDist: function(vec){
		return Math.sqrt((this.x-vec.x)*(this.x-vec.x) + (this.y-vec.y)*(this.y-vec.y));
	},
	
	unitaire: function(){
		var norme = Math.sqrt(this.x*this.x + this.y*this.y);
		if (norme==0){
			messageLog("unitaire divion par 0");
			return;
		}
		this.x/=norme;
		this.y/=norme;
	},	


});

var VDep = Vec.extend({
	init: function(x, y, vitesse){
		this._super(x, y);
		
		if (vitesse!=undefined){
			this.unitaire();
			this.multF(vitesse);
		}
	},
	
	setVitesse: function(vit){
		this.unitaire();
		this.multF(vit);
	},

	getDeplacement: function(){
		return new Vec(this.x*game.get_mult_vitesse(), 
						this.y*game.get_mult_vitesse());
	}
});

var orient = function(vecpos,  veccible){
	var vecdir = new Vec(veccible.x-vecpos.x, veccible.y-vecpos.y);
	var angle;
	
	if (vecdir.y>0){
		if (vecdir.x>0)
			angle = Math.atan(Math.abs(vecdir.y/vecdir.x)) * 180 / Math.PI;
		else if (vecdir.x<0)
			angle = Math.atan(Math.abs(vecdir.x/vecdir.y)) * 180 / Math.PI + 90;
		else //vecdir.x==0
			angle = 90;
	}
	else if (vecdir.y<0){
		if (vecdir.x>0)
			angle = Math.atan(Math.abs(vecdir.x/vecdir.y)) * 180 / Math.PI + 270;
		else if (vecdir.x<0)
			angle = Math.atan(Math.abs(vecdir.y/vecdir.x)) * 180 / Math.PI + 180;
		else //vecdir.x==0
			angle = 270;
	}
	else {	// vecdir.y==0
		if (vecdir.x>0)
			angle = 0;
		else if (vecdir.x<0)
			angle = 180;
		else //vecdir.x==0
			angle = 0;
	}
	
	//var testa = Math.atan(Math.abs(vecdir.y/vecdir.x)) * 180 / Math.PI;
	//var testa = Math.atan(Math.abs(vecdir.x/vecdir.y)) * 180 / Math.PI;
	
	return angle;
};

var vecToAngle = function(vecdir){
	var angle;
	
	if (vecdir.y>0){
		if (vecdir.x>0)
			angle = Math.atan(Math.abs(vecdir.y/vecdir.x)) * 180 / Math.PI;
		else if (vecdir.x<0)
			angle = Math.atan(Math.abs(vecdir.x/vecdir.y)) * 180 / Math.PI + 90;
		else //vecdir.x==0
			angle = 90;
	}
	else if (vecdir.y<0){
		if (vecdir.x>0)
			angle = Math.atan(Math.abs(vecdir.x/vecdir.y)) * 180 / Math.PI + 270;
		else if (vecdir.x<0)
			angle = Math.atan(Math.abs(vecdir.y/vecdir.x)) * 180 / Math.PI + 180;
		else //vecdir.x==0
			angle = 270;
	}
	else {	// vecdir.y==0
		if (vecdir.x>0)
			angle = 0;
		else if (vecdir.x<0)
			angle = 180;
		else //vecdir.x==0
			angle = 0;
	}
	
	return angle;
}

var angleToVec = function(angle){
	return new Vec(Math.cos(angle*Math.PI/180), Math.sin(angle*Math.PI/180));
}

var normaliseAngle = function(angle){
	while (angle<360)
		angle+=360;
	angle%=360;
	return angle;
}

var angleInterpolateurPct = function(a, b, pct){

	// Met l'angle entre 0 et 360
	while (a<0)
		a += 360;
	while (b<0)
		b += 360;
	a %= 360;
	b %= 360;
	
	
	var dist = b - a;
	
	var angle=0;
	
	if (dist>180)
		dist=-360+dist;
		
	angle = a+dist*pct;
	
	angle += 360;
	angle %= 360;
	
	return angle;
}



var gameToScreenCoord = function(vec) {
	if (game==undefined)
		return new Vec(vec.x, GAME_SIZE_HEIGHT - vec.y); 
	return new Vec(vec.x, game.height - vec.y + game.origineYf); 
}

var ScreenToGameCoord = function(vec) {
	if (game==undefined)
		return new Vec(vec.x, GAME_SIZE_HEIGHT - vec.y); 	
	return new Vec(vec.x, game.origineYf+game.height-vec.y); 
}

var Entity = Class.extend({
	init: function(){
		this.coord = new Vec();
		this.angle=0;
		this.parent = null;
		this.child = new Array();
		
		this.del = false;
	},
	
	delme: function(){
		this.del = true;
	},
	
	setParent: function(entity){
		this.parent = entity;
	},
	
	addChild: function(entity){
		this.child.push(entity);
	},
	
	updateChild: function(){
		var max = this.child.length;
		for (var i=0 ; i<max ; i++){
			this.child[i].update();
			this.child[i].updateChild();
		}
	},
	
	update: function(){
		
	},
	
	setPosition: function(vec){
		this.coord.x = vec.x
		this.coord.y = vec.y;
	},
	
	setAngle: function(angle){
		this.angle=angle;
	},	

	drawChild: function(){
		for (var i=0, max=this.child.length ; i<max ; i++){
			this.child[i].draw();
			this.child[i].drawChild();
		}		
	},
	
	draw: function(){
		
	},
	
	getScreenCoord: function(){
		return gameToScreenCoord(this.coord);
		//return new Vec(this.coord.x, game.height - this.coord.y + game.origineYf);
	},	
	
});



var randomTest = function(pct) {
	return (Math.random()<pct);
}

var randomInt = function(val) {
	return Math.floor( Math.random() * val);
}

// Utilisation : randomPoid([[VAL1, POID1], [VAL2, POID2], [VAL3, POID3]]);
var randomPoid= function(tval) {
	var total = 0;
	for (var i=0, max=tval.length ; i<max ; i++)
		total+=tval[i][1];

	var r = Math.random() * total;
	
	var i=-1;
	do
	{
		i++;
		r-=tval[i][1];
		
	}while (r>0);

	return tval[i][0];
}

var randomTab= function(tval) {
	var r = randomInt(tval.length);
	return tval[r];
}



function show_hide_div(nomdiv){
	var lediv = document.getElementById(nomdiv);
	if(lediv.style.display!="none")
		lediv.style.display="none";
	else
		lediv.style.display="block";
}

function show_div(nomdiv){
	var lediv = document.getElementById(nomdiv);
	lediv.style.display="block";
}

function hide_div(nomdiv){
	var lediv = document.getElementById(nomdiv);
	lediv.style.display="none";
}

var clamp = function(num, min, max) {
    return num < min ? min : (num > max ? max : num);
};
var clampu = function(num, max) {
    return (num > max ? max : num);
};
var clampl = function(num, min) {
    return (num < min ? min : num);
};


window.mobilecheck = function() {
  var check = false;
  (function(a){if(/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows ce|xda|xiino/i.test(a)||/1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i.test(a.substr(0,4)))check = true})(navigator.userAgent||navigator.vendor||window.opera);
  return check;
}

window.mobileAndTabletcheck = function() {
  var check = false;
  (function(a){if(/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows ce|xda|xiino|android|ipad|playbook|silk/i.test(a)||/1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i.test(a.substr(0,4)))check = true})(navigator.userAgent||navigator.vendor||window.opera);
  return check;
}


if (!Date.now) {
  Date.now = function now() {
    return new Date().getTime();
  };
}