
var Vehicule = Entity.extend({
	init: function(){
		this._super();
		this.tile = null;
		this.ctp_temps = 0;
		this.collision = new Collisionneur();
		
		this.vie = 1;
		this.gainScore = 1;
		this.vitesseDeplacement = 0.2;
		this.cadenceTir = 300;

		
	},
	
	getCenter: function(){
		if (this.tile!=null){
			return new Vec(this.coord.x+this.tile.coordBox.width/2, this.coord.y-this.tile.coordBox.height/2);
		}
		else 
			return this.coord.copy();			
	},
	
	update: function(){
		this.ctp_temps+=game.timeDelay;
		
if (!DEBUG_DEFILEMENT_STOP)
		this.coord.addVec(new VDep(0,game.vitesse_defilement).getDeplacement());
	},
	
	setAngle: function(angle){
		this._super(angle);
		if (this.tile != null)
			this.tile.setAnge(angle);
	},
	
	drawVehicule: function(screenVec){
		this.tile.setPosition(screenVec);
		//this.tile.setPosition(this.coord);
		this.tile.draw();
	},
	
	draw: function(){
		if (this.tile!=null){
			this.drawVehicule(this.getScreenCoord());
		}
	},
	
	attaque: function(){
		if (this.ctp_temps>this.cadenceTir){
			game.tballes.push(new Balle1(new Vec(this.coord.x+12, this.coord.y), new VDep(0,0.6), 0));
			game.tballes.push(new Balle1(new Vec(this.coord.x+73, this.coord.y), new VDep(0,0.6), 0));
			this.ctp_temps=0;
		}
	},
	

	
	// Fonction a redefinir : 
	// Le vehicule explose (le bon moment pour faire une explosion)
	EvtExplosion : function(coord){
	},	
	
	// Le vehicule est mort (animation de destruction)
	EvtVehiculeMort : function(){
		this.delme();
	},
	
	// le vehicule subit des degat (animation de degat)
	EvtVehiculeSubitDegat : function(){
	},
	
	// Retourne vrai si le vehicule a bien subit des degats
	degat : function(pt){
		if (this.vie<=0)
			return false;
			
		this.vie -= pt;
		if (this.vie<=0){
			game.score+=this.gainScore;
			this.EvtVehiculeMort();
		}
		
		this.EvtVehiculeSubitDegat();
		
			
		return true;
	},
	
	degatBalle : function(balle){		
		if (this.degat(balle.getAttaque())){
			balle.EvtExplose();
		}
	},
	
	canCollide : function(){
		if (this.vie>0)
			return true;
		return false;
	},

	setLevel : function(lvl){
		this.vie *= (1+(lvl-1)*3);
		this.gainScore *= (1+lvl);
		this.vitesseDeplacement *= 1+(lvl-1)*0.07;
		this.cadenceTir /= 1+(lvl-1)*0.02;
	},
	
});



var VehiculeJoueur = Vehicule.extend({
	init: function(){
		this._super();
		this.tile = new Tile(IMAGE_Aircraft_07);
		this.collision.setPosition(this.tile.coordBox);
		//this.collision.addBox(this.tile.spriteBox.copy());
		
		this.collision.addBox(new Box(50, 8, 9, 66));
		this.collision.addBox(new Box(19, 25, 71, 15));
		this.collision.addBox(new Box(6, 34, 96, 12));
		this.collision.addBox(new Box(41, 46, 30, 28));
		

		
		
		
		this.vie = 10;
		this.vieMax = 10;
		this.invincibleDuree = 0;
		
		this.invincibleClignote = 0;
		this.degatSubit = 0;
		
		this.arme1 = undefined;	
		this.arme2 = undefined;

		this.timeMort = 0;
		this.timeAnimMort = 0;
	},
	
	reset: function(){
		this.vie = 1;
		this.invincibleDuree = 0;
		this.invincibleClignote = 0;
		this.degatSubit = 0;
		this.arme1.reset();
		if (this.arme2!=undefined)
			this.arme2.reset();
		this.timeMort = 0;
	},

	setPosition: function(vec){
		this._super(vec);
		this.tile.setPosition(this.getScreenCoord());
	},
	
	update: function(){
		this._super();
		
	
		if (this.coord.y<game.origineY+75)
			this.coord.y=game.origineY+75;
		if (this.coord.y>game.origineY+game.height)
			this.coord.y=game.origineY+game.height;
		if (this.coord.x>game.width-105)
			this.coord.x=game.width-105;
		if (this.coord.x<0)
			this.coord.x=0;
	
		
		if (this.invincibleDuree>0){
			this.invincibleDuree-=game.timeDelay;
			if (this.invincibleDuree<=0)
				this.tile.setAlpha(1);
			else {
				this.invincibleClignote-=game.timeDelay;
				if (this.invincibleClignote<=0){
					if (this.tile.alpha==1)
						this.tile.setAlpha(0.2);
					else 
						this.tile.setAlpha(1);
					this.invincibleClignote = 100;
				}
			}
		}
	},

	degat : function(pt){
		if (!game.inGame)
			return;
		if (this.vie<=0)
			return;
		this.degatSubit+=pt;
		if (this.invincibleDuree>0)
			return;
		this.invincibleDuree = 2000;

		sonManager.play(SON_Explosion);

		this.vie -= pt;	
		if (this.vie<=0){
			
			if (INVINCIBLECHEAT){
				this.vie=this.vieMax;
				return;	
			}
			
			this.EvtVehiculeMort();
			//this.delme();
			//game.finPartie();
			game.perdu=true;
		}
		else {
			this.invincibleClignote = 150;
			this.tile.setAlpha(0.2);			
		}
	},
	
	
	// Fonction a redefinir : 
	
	// Le vehicule est mort (animation de destruction)
	EvtVehiculeMort : function(){
		this._super();		
		this.timeMort=game.time;
		this.timeAnimMort=game.time;
	},
	
	draw: function(){
		this._super();
		if (this.timeMort>0 && game.time>this.timeAnimMort){
			var coord = new Vec(this.coord.x+randomInt(this.tile.coordBox.width), this.coord.y-randomInt(this.tile.coordBox.height));
			game.tEntity.push(new ExplosionBig(coord));
			sonManager.play(SON_Explosion);

			if (game.time-this.timeMort>2000){
				game.finPartie();
				this.timeMort=0;
			}
			else 
				this.timeAnimMort=game.time+100+randomInt(300);
		}
	},	

	attaque: function(){
		
		//playAudio("sons/hk53.mp3");
		this.arme1.EvtAttaque();
	},
	attaque2: function(){
		if (this.arme2!=undefined)
			this.arme2.EvtAttaque();
	},	
	
});


var VehiculeJoueurGuerrier = VehiculeJoueur.extend({
	init: function(){
		this._super();
		
		this.vie = 1;
		this.vieMax = 1;
		this.vitesseDeplacement = 0.22;
		
		this.arme1 = new ArmeStandardNiv1(this.coord);
		//this.arme2 = new ArmeBigArtifice(this.coord);
		this.arme2 = undefined;
		
	},
});

var VehiculeJoueurArcher = VehiculeJoueur.extend({
	init: function(){
		this._super();
		
		this.vie = 10;
		this.vieMax = 10;
		this.vitesseDeplacement = 0.3;
		
		this.arme1 = new ArmeDiagNiv2(this.coord);
		//this.arme2 = new ArmeBigBullet(this.coord);
		this.arme2 = undefined;
		
		
	},	
});