﻿/// <reference path="../index.html"/>
/// <reference path="index.js"/>
/// <reference path="ditJavascriptLibrary.js"/>

// To Do:
// Send data to server for backup.
// Allow data to be shared among > 1 users.
// Fix bug where toolbar shows too high when a textbox low on the page has focus.

// Alternative App Names: PopShopList, Shoptropica, shopinator, Shop List Go,

// Global variables.

var gSectionsArray;
var gItemsArray;
var gSelectedItem;
var gLastNewItemSectionName;
var gFavNeedsRefreshed  = true;
var gShopNeedsRefreshed = true;
var gCartNeedsRefreshed = true;
var gSettingsLastSectionMoved = "";

var gImageListIconDelete;
var gImageListIconFavToShop;
var gImageListIconShopToFav;
var gImageListIconShopToCart;
var gImageListIconCartToShop;

var gImageSettingsSortUpIcon;
var gImageSettingsSortDownIcon;

var ditResourceBase = "";
if(typeof cordova !== 'undefined'){
    ditResourceBase = "www/";
}

// Things that will likely change with UI settings options.

var gListRowFontName = "Helvetica-Light";
var gListRowBackColor = "#ffffff";
var gListRowItemFontColor = "#000000";
var gThemeColor = "#548f3f";                // The Trip Advisor theme green.
var gRowHighlightColor = "#b8e0aa";
var gButtonHighlightColor = "#4b4b4b";

var gListRowSectionFontWeight = "bold";
var gListRowItemFontWeight = "";

var gListRowFontSize;
var gSectionRowRect;
var gSectionNameRect;
var gItemRowRect;
var gItemNameRect;
var gListIconRect;
var gListRowLeftIconRect;
var gListRowRightIconRect;
var gColumnsPerRow;
var gColumnsAdded;

function body_load() {

    // Initialize the code library and "show" the Wait page.

    ditInit();
    ditWaitShow();

    // Load any needed graphics and call the next function after all images are loaded.

    var numberPreLoadedImages = 0;

    gImageListIconDelete        = ditImageNew("img/ListIconDelete.png",     initImagesAreLoaded);
    gImageListIconFavToShop     = ditImageNew("img/ListIconFavToShop.png",  initImagesAreLoaded);
    gImageListIconShopToFav     = ditImageNew("img/ListIconShopToFav.png",  initImagesAreLoaded);
    gImageListIconShopToCart    = ditImageNew("img/ListIconShopToCart.png", initImagesAreLoaded);
    gImageListIconCartToShop    = ditImageNew("img/ListIconCartToShop.png", initImagesAreLoaded);
    gImageSettingsSortUpIcon    = ditImageNew("img/SortUpIcon.png",         initImagesAreLoaded);
    gImageSettingsSortDownIcon  = ditImageNew("img/SortDownIcon.png",       initImagesAreLoaded);

    function initImagesAreLoaded() {
        numberPreLoadedImages++;

        if (numberPreLoadedImages == 7) {
            initAppUI();
        }
    }
}

function blockEvents(e){
    e.stopPropagation();
    e.originalEvent.stopPropagation();
}

function initAppUI() {

    lblVersion.innerHTML = "Version 1.1.0";

    // Connect event handlers

    // Top-level absolute positioning elements sometimes don't want to receive pointer events (Firefox)
    //  Targeting them here will fix that.
    var bindElements = document.querySelectorAll('.divNavBar, .divToolbar');
    for(var i = 0; i < bindElements.length; i++){
        bindElements[i].addEventListener('pointerdown', blockEvents, false);
        bindElements[i].addEventListener('pointerup', blockEvents, false);
        bindElements[i].addEventListener('pointermove', blockEvents, false);
    }

    // Debugging... TODO: Remove later
//    document.addEventListener('pointerdown', function(e){
//        e.originalEvent.stopPropagation();
//        console.log('pointerdown!');
//    }, false);
//    document.addEventListener('pointerup', function(e){
//        e.originalEvent.stopPropagation();
//        console.log('pointerup! ');
//    }, false);
//    document.addEventListener('pointermove', function(e){
//        e.originalEvent.stopPropagation();
//
//        var str = 'pointermove: ';
//        if(e.isPointerLeaveEmitter){
//            str += 'e.isPointerLeaveEmitter ';
//        }
//        var touches = e.getPointerList();
//        for(var i = 0; i < touches.length; i++){
////            str += JSON.stringify(touches[i]) + ' ';
//            str += '[' + touches[i].clientX + ',' + touches[i].clientY + '] ';
//            if(touches[i].isPointerLeaveEmitter){
//                str += 'touches[i].isPointerLeaveEmitter ';
//            }
//        }
//        console.log(str);
//    }, false);

    btnFavSearch.addEventListener('pointerdown', btnFavSearch_pointerDown, false);
    btnFavSearch.addEventListener('pointerup', btnFavSearch_pointerUp, false);

    btnFavNavRight.addEventListener('pointerdown', btnFavNavRight_pointerDown, false);
    btnFavNavRight.addEventListener('pointerup', btnFavNavRight_pointerUp, false);

    btnFavSearchDone.addEventListener('pointerdown', btnFavSearchDone_pointerDown, false);
    btnFavSearchDone.addEventListener('pointerup', btnFavSearchDone_pointerUp, false);

    txtFavSearch.addEventListener('keyup', txtFavSearch_keyUp, false);
    txtFavSearch.addEventListener('pointerup', txtFavSearch_pointerUp, false);

    divFavSearchClear.addEventListener('pointerdown', divFavSearchClear_pointerDown, false);

    btnShopNavLeft.addEventListener('pointerdown', btnShopNavLeft_pointerDown, false);
    btnShopNavLeft.addEventListener('pointerup', btnShopNavLeft_pointerUp, false);

    btnShopNavRight.addEventListener('pointerdown', btnShopNavRight_pointerDown, false);
    btnShopNavRight.addEventListener('pointerup', btnShopNavRight_pointerUp, false);

    btnCartNavLeft.addEventListener('pointerdown', btnCartNavLeft_pointerDown, false);
    btnCartNavLeft.addEventListener('pointerup', btnCartNavLeft_pointerUp, false);

    btnNewItemDone.addEventListener('pointerdown', btnNewItemDone_pointerDown, false);
    btnNewItemDone.addEventListener('pointerup', btnNewItemDone_pointerUp, false);

    btnHelpDone.addEventListener('pointerdown', btnHelpDone_pointerDown, false);
    btnHelpDone.addEventListener('pointerup', btnHelpDone_pointerUp, false);

    btnSettingsDone.addEventListener('pointerdown', btnSettingsDone_pointerDown, false);
    btnSettingsDone.addEventListener('pointerup', btnSettingsDone_pointerUp, false);

    btnSettingsReset.addEventListener('click', btnSettingsReset_click, false);

    btnToolbarNewItem.addEventListener('pointerdown', btnToolbarNewItem_pointerDown, false);
    btnToolbarNewItem.addEventListener('pointerup', btnToolbarNewItem_pointerUp, false);

    btnToolbarClear.addEventListener('pointerdown', btnToolbarClear_pointerDown, false);
    btnToolbarClear.addEventListener('pointerup', btnToolbarClear_pointerUp, false);

    btnToolbarHelp.addEventListener('pointerdown', btnToolbarHelp_pointerDown, false);
    btnToolbarHelp.addEventListener('pointerup', btnToolbarHelp_pointerUp, false);

    btnToolbarSettings.addEventListener('pointerdown', btnToolbarSettings_pointerDown, false);
    btnToolbarSettings.addEventListener('pointerup', btnToolbarSettings_pointerUp, false);

    // Initialize the lists for scrolling and swipes.

    ditScrollableDivInit(divFavList);
    divFavList.OnSwipeLeft = divFavList_OnSwipeLeft;

    ditScrollableDivInit(divShopList);
    divShopList.OnSwipeLeft = divShopList_OnSwipeLeft;
    divShopList.OnSwipeRight = divShopList_OnSwipeRight;

    ditScrollableDivInit(divCartList);
    divCartList.OnSwipeRight = divCartList_OnSwipeRight;

    ditScrollableDivInit(divNewItemSections);

    ditScrollableDivInit(divHelpPageContent);
    divHelpPageContent.ContentHeight = 3000;    // Allows the user to vertical scroll the page.  Number doesn't seem to matter as long as it is larger than actual height.

    ditScrollableDivInit(divSettingsPageContent);
    divSettingsPageContent.ContentHeight = 3000;    // Allows the user to vertical scroll the page.  Number doesn't seem to matter as long as it is larger than actual height.

    // Adjustments for varying screen heights. Use height of NavBars and the toolbar.

    // TODO: These could be loaded from the elements directly...
    // Don't forget to count in margins!
    var pageHeight = ditScreenHeight - 47;
    var pageContentHeight = ditScreenHeight - (47 + 44);

    divToolbar.style.top = pageHeight + "px";
    divFavPage.style.height = pageHeight + "px";
    divFavList.style.height = pageContentHeight + "px";
    divShopPage.style.height = pageHeight + "px";
    divShopList.style.height = pageContentHeight + "px";
    divCartPage.style.height = pageHeight + "px";
    divCartList.style.height = pageContentHeight + "px";
    divNewItemPage.style.height = pageHeight + "px";
    divHelpPage.style.height = pageHeight + "px";
    divHelpPageContent.style.height = pageContentHeight + "px";
    divSettingsPage.style.height = pageHeight + "px";
    divSettingsPageContent.style.height = pageContentHeight + "px";

    initAppState();
}

function initAppState() {

    // Move all pages to their hidden state.

    divFavPage.style.left = (-ditScreenWidth) + "px";
    divFavPage.style.display = "none";

    divShopPage.style.left = ditScreenWidth + "px";
    divShopPage.style.display = "none";

    divCartPage.style.left = ditScreenWidth + "px";
    divCartPage.style.display = "none";

    divNewItemPage.style.top = ditScreenHeight + "px";
    divNewItemPage.style.display = "none";

    divHelpPage.style.top = ditScreenHeight + "px";
    divHelpPage.style.display = "none";

    divSettingsPage.style.top = ditScreenHeight + "px";
    divSettingsPage.style.display = "none";

    // Load anything we may have saved to local storage.

    gLastNewItemSectionName = ditStorageGet("LastNewItemSectionName", "Miscellaneous");
    txtFavSearch.value = ditStorageGet("txtFavSearch", "");
    txtItemName.value = ditStorageGet("txtItemName", "");

    if (ditStorageGet("NewItemAddWhereFavChecked") == undefined) {
		ditStorageSet("NewItemAddWhereFavChecked", ditBoolToYN(true));
    }

    if (ditStorageGet("NewItemAddWhereShopChecked") == undefined) {
        ditStorageSet("NewItemAddWhereShopChecked", ditBoolToYN(true));
    }

    if (ditStorageGet("ListRowFontSize") == undefined) {
		ditStorageSet("ListRowFontSize", 20);
    }
    gListRowFontSize = ditStorageGet("ListRowFontSize");

    initUiElementSizes();

    // Load the file of sections and items on the list.
    if (ditStorageGet("ShoppingList") == undefined) {
        ditHttpGetAsync(ditResourceBase + "resources/DefaultList.txt", procGetDefaultListResponse);
    }
    else {
        procGetDefaultListResponse(ditStorageGet("ShoppingList"));
    }
}

function initUiElementSizes() {

    // Note list row icons are 40 x 30 pixels.
    var screenWidthToUse = ditScreenWidth - ditScrollbarWidth;

    if (gListRowFontSize == 26) {
        gSectionRowRect = ditRectNew(0, 0, screenWidthToUse, 40);
        gSectionNameRect = ditRectNew(10, 0, gSectionRowRect.Width - 10, gSectionRowRect.Height);
        gItemRowRect = ditRectNew(0, 0, screenWidthToUse, 40);
        gItemNameRect = ditRectNew(44, 0, gItemRowRect.Width - 88, gItemRowRect.Height);
        gListIconRect = ditRectNew(0, 8, 32, 24);
        gListRowItemFontWeight = "";
        gColumnsPerRow = 1;
    }
    else if (gListRowFontSize == 20) {
        gSectionRowRect = ditRectNew(0, 0, screenWidthToUse, 36);
        gSectionNameRect = ditRectNew(10, 0, gSectionRowRect.Width - 10, gSectionRowRect.Height);
        gItemRowRect = ditRectNew(0, 0, screenWidthToUse, 36);
        gItemNameRect = ditRectNew(40, 0, gItemRowRect.Width - 80, gItemRowRect.Height);
        gListIconRect = ditRectNew(0, 8, 27, 20);
        gListRowItemFontWeight = "";
        gColumnsPerRow = 1;
    }
    else if (gListRowFontSize == 16) {
        gSectionRowRect = ditRectNew(0, 0, screenWidthToUse, 30);
        gSectionNameRect = ditRectNew(10, 0, gSectionRowRect.Width - 10, gSectionRowRect.Height);
        gItemRowRect = ditRectNew(0, 0, Math.floor(screenWidthToUse / 2), 30);
        gItemNameRect = ditRectNew(30, 0, gItemRowRect.Width - 60, gItemRowRect.Height);
        gListIconRect = ditRectNew(5, 5, 21, 16);
        gColumnsPerRow = 2;
    }
    else if (gListRowFontSize == 10) {
        gSectionRowRect = ditRectNew(0, 0, screenWidthToUse, 20);
        gSectionNameRect = ditRectNew(20, 0, gSectionRowRect.Width - 20, gSectionRowRect.Height);
        gItemRowRect = ditRectNew(0, 0, Math.floor(screenWidthToUse / 3), 20);
        gItemNameRect = ditRectNew(25, 0, gItemRowRect.Width - 50, gItemRowRect.Height);
        gListIconRect = ditRectNew(5, 5, 15, 10);
        gColumnsPerRow = 3;
    }

    gListRowLeftIconRect = ditRectNew(5, gListIconRect.Top, gListIconRect.Width, gListIconRect.Height);
    gListRowRightIconRect = ditRectNew(gItemNameRect.Left + gItemNameRect.Width, gListIconRect.Top, gListIconRect.Width, gListIconRect.Height);
}

// Page Navigation Functions.

function btnFavNavRight_pointerDown(e) {
    e.originalEvent.stopPropagation();
    btnFavNavRight.style.backgroundColor = gButtonHighlightColor;
}

function btnFavNavRight_pointerUp(e) {
    e.originalEvent.stopPropagation();
    e.originalEvent.preventDefault();

    btnFavNavRight.style.backgroundColor = gThemeColor;
    shopPageRefresh();
    ditPageShowSlideLeftRight(divShopPage);
    ditPageHideOnLeft(divFavPage);
}

function btnShopNavLeft_pointerDown(e) {
    e.originalEvent.stopPropagation();
    btnShopNavLeft.style.backgroundColor = gButtonHighlightColor;
}

function btnShopNavLeft_pointerUp(e) {
    e.originalEvent.stopPropagation();
    e.originalEvent.preventDefault();

    btnShopNavLeft.style.backgroundColor = gThemeColor;
    favPageRefresh();
    ditPageShowSlideLeftRight(divFavPage);
    ditPageHideOnRight(divShopPage);
}

function btnShopNavRight_pointerDown(e) {
    e.originalEvent.stopPropagation();
    btnShopNavRight.style.backgroundColor = gButtonHighlightColor;
}

function btnShopNavRight_pointerUp(e) {
    e.originalEvent.stopPropagation();
    e.originalEvent.preventDefault();

    btnShopNavRight.style.backgroundColor = gThemeColor;
    cartPageRefresh();
    ditPageShowSlideLeftRight(divCartPage);
    ditPageHideOnLeft(divShopPage);
}

function btnCartNavLeft_pointerDown(e) {
    e.originalEvent.stopPropagation();
    btnCartNavLeft.style.backgroundColor = gButtonHighlightColor;
}

function btnCartNavLeft_pointerUp(e) {
    e.originalEvent.stopPropagation();
    e.originalEvent.preventDefault();

    btnCartNavLeft.style.backgroundColor = gThemeColor;
    shopPageRefresh();
    ditPageShowSlideLeftRight(divShopPage);
    ditPageHideOnRight(divCartPage);
}

function divFavList_OnSwipeLeft() {
    shopPageRefresh();
    ditPageShowSlideLeftRight(divShopPage);
    ditPageHideOnLeft(divFavPage);

	txtFavSearch.blur(); //Defocus this
}

function divShopList_OnSwipeLeft() {
    cartPageRefresh();
    ditPageShowSlideLeftRight(divCartPage);
    ditPageHideOnLeft(divShopPage);
}

function divShopList_OnSwipeRight() {
    favPageRefresh();
    ditPageShowSlideLeftRight(divFavPage);
    ditPageHideOnRight(divShopPage);
}

function divCartList_OnSwipeRight() {
    shopPageRefresh();
    ditPageShowSlideLeftRight(divShopPage);
    ditPageHideOnRight(divCartPage);
}

// Toolbar functions.

function btnToolbarNewItem_pointerDown(e) {
    e.originalEvent.stopPropagation();

    if (divSettingsPage.style.display == "block") {
        btnToolbarSettings.style.backgroundColor = "#000000";
        ditPageHideOnBottom(divSettingsPage);
    }

    if (divHelpPage.style.display == "block") {
        btnToolbarHelp.style.backgroundColor = "#000000";
        ditPageHideOnBottom(divHelpPage);
    }

    btnToolbarNewItem.style.backgroundColor = gButtonHighlightColor;
}

function btnToolbarNewItem_pointerUp(e) {
    e.originalEvent.stopPropagation();
    e.originalEvent.preventDefault();

    if (divNewItemPage.style.display == "block") {
        btnNewItemDone_pointerUp(e);
        return;
    }

    newItemPageShow();
}

function btnToolbarClear_pointerDown(e) {
    e.originalEvent.stopPropagation();

    if (divNewItemPage.style.display == "block" 
        || divHelpPage.style.display == "block"
        || divSettingsPage.style.display == "block") {
        return;
    }

    btnToolbarClear.style.backgroundColor = gButtonHighlightColor;
}

function btnToolbarClear_pointerUp(e) {
    e.originalEvent.stopPropagation();
    e.originalEvent.preventDefault();

    if (divNewItemPage.style.display == "block"
        || divHelpPage.style.display == "block"
        || divSettingsPage.style.display == "block") {
        return;
    }

    btnToolbarClear.style.backgroundColor = "#000000";

    if (divFavPage.style.display == "block") {
        ditMessageBoxYesNo(
            "Are you sure you want to clear the entire list of your favorites?",
            function () {
                for (var i = 0; i < gItemsArray.length; i++) {
                    gItemsArray[i].InFav = false;
                }
                gFavNeedsRefreshed = true;
                favPageRefresh();
                saveAppState();
            }
        );
    }
    else if (divShopPage.style.display == "block") {
        ditMessageBoxYesNo(
            "Are you sure you want to clear the entire shopping list?",
            function () {
                for (var i = 0; i < gItemsArray.length; i++) {
                    gItemsArray[i].InShop = false;
                }
                gFavNeedsRefreshed = true;
                gShopNeedsRefreshed = true;
                shopPageRefresh();
                saveAppState();
            }
        );
    }
    else if (divCartPage.style.display == "block") {
        ditMessageBoxYesNo(
            "Are you sure you want to remove all items from the cart?",
            function () {
                for (var i = 0; i < gItemsArray.length; i++) {
                    gItemsArray[i].InCart = false;
                }
                gCartNeedsRefreshed = true;
                cartPageRefresh();
                saveAppState();
            }
        );
    }
    return false;
}

function btnToolbarHelp_pointerDown(e) {
    e.originalEvent.stopPropagation();

    if (divNewItemPage.style.display == "block") {
        btnToolbarNewItem.style.backgroundColor = "#000000";
        ditPageHideOnBottom(divNewItemPage);
    }

    if (divSettingsPage.style.display == "block") {
        btnToolbarSettings.style.backgroundColor = "#000000";
        ditPageHideOnBottom(divSettingsPage);
    }

    btnToolbarHelp.style.backgroundColor = gButtonHighlightColor;
}

function btnToolbarHelp_pointerUp(e) {
    e.originalEvent.stopPropagation();
    e.originalEvent.preventDefault();

    if (divHelpPage.style.display == "block") {
        btnHelpDone_pointerUp(e);
        return;
    }

    helpPageShow();
}

function btnToolbarSettings_pointerDown(e) {
    e.originalEvent.stopPropagation();

    if (divNewItemPage.style.display == "block") {
        btnToolbarNewItem.style.backgroundColor = "#000000";
        ditPageHideOnBottom(divNewItemPage);
    }

    if (divHelpPage.style.display == "block") {
        btnToolbarHelp.style.backgroundColor = "#000000";
        ditPageHideOnBottom(divHelpPage);
    }

    btnToolbarSettings.style.backgroundColor = gButtonHighlightColor;
}

function btnToolbarSettings_pointerUp(e) {
    e.originalEvent.stopPropagation();
    e.originalEvent.preventDefault();

    if (divSettingsPage.style.display == "block") {
        btnSettingsDone_pointerUp(e);
        return;
    }

    settingsPageShow();
}

// Favorites page functions.

function favPageRefresh() {

    if (gFavNeedsRefreshed == false) {
        return;
    }
    gFavNeedsRefreshed = false;

    var section;
    var item;
    var itemName;
    var searchFor;
    var rowsAdded = 0;
    
    listClear(divFavList);
    refreshNumberOfSectionSubItems();

    //  When in search mode, show matching rows without sections.

    if (divFavSearchBar.style.display == "block") {
        searchFor = txtFavSearch.value.toLowerCase().trim();

        if (searchFor == "") {
            return;
        }

        gColumnsAdded = 0;

        for (var itemIndex = 0; itemIndex < gItemsArray.length; itemIndex++) {

            item = gItemsArray[itemIndex];

            if (item.InFav == true) {
             
                itemName = item.ItemName.toLowerCase();

                if (itemName.indexOf(searchFor) > -1) {
                    favNewItemRow(gItemsArray[itemIndex]);
                    rowsAdded++;
                    if (rowsAdded == 25) {
                        break;
                    }
                }
            }
        }

        if (rowsAdded == 0) {
            var newDiv = addEmptyMessage(divFavList, "No matching items. Tap to add.");
            newDiv.addEventListener('pointerdown', function(e){
                newItemPageShow(ditWordCap(txtFavSearch.value.trim()));
            }, false);
            return;
        }

        addEmptyColumnsToList(divFavList);

        if (rowsAdded == 25) {
            addEmptyMessage(divFavList, "At least 25 items found");
        }
    }

    else {

        // In non-search mode, add rows for each item name within each section.

        for (var sectionIndex = 0; sectionIndex < gSectionsArray.length; sectionIndex++) {

            section = gSectionsArray[sectionIndex];

            if (section.NumberFavSubItems == 0) {
                continue;
            }

            favNewSectionRow(section);
            gColumnsAdded = 0;

            // If the section is expanded, show all items in the section.

            if (section.FavExpanded == true) {

                for (var itemIndex = 0; itemIndex < gItemsArray.length; itemIndex++) {

                    item = gItemsArray[itemIndex];

                    if (item.SectionName == section.SectionName && item.InFav == true) {
                        favNewItemRow(item);
                    }
                }

                addEmptyColumnsToList(divFavList);
            }
        }

        if (divFavList.ContentHeight == 0) {
            addEmptyMessage(divFavList, "Your favorites list is empty");
        }
    }
}

function favNewSectionRow(section) {

    var listRowCanvas = ditCanvasNew(gSectionRowRect.Width, gSectionRowRect.Height);
    listRowCanvas.Section = section;
    ditFastClickCanvas(listRowCanvas, favDrawSectionRow, favSection_click);

    divFavList.appendChild(listRowCanvas);
    divFavList.ContentHeight += gSectionRowRect.Height;
}

function favDrawSectionRow(listRowCanvas) {

    var section = listRowCanvas.Section;

    if (section.FavExpanded == true) {
        drawSectionName(listRowCanvas, 0);
    }
    else {
        drawSectionName(listRowCanvas, section.NumberFavSubItems);
    }
}

function favSection_click(e) {

    this.Section.FavExpanded = !this.Section.FavExpanded;
    gFavNeedsRefreshed = true;
    favPageRefresh();
}

function favNewItemRow(item) {

    var listRowCanvas = ditCanvasNew(gItemRowRect.Width, gItemRowRect.Height);
    listRowCanvas.Item = item;
    ditFastClickCanvas(listRowCanvas, favDrawItemRow, favItem_click);

    listAddItemRow(divFavList, listRowCanvas);
}

function favDrawItemRow(listRowCanvas) {

    var backColor;
    var fontColor;
    var imageListRowRightIcon;

    if (listRowCanvas.Selected == true) {
        backColor = gRowHighlightColor;
    }
    else {
        backColor = gListRowBackColor;
    }

    if (listRowCanvas.Item.InShop == true || listRowCanvas.Item.InCart == true) {
        fontColor = "#999999";
        imageListRowRightIcon = gImageListIconShopToFav;
    }
    else {
        fontColor = gListRowItemFontColor;
        imageListRowRightIcon = gImageListIconFavToShop;
    }

    ditCanvasFillRect(listRowCanvas, listRowCanvas.Rect, backColor);
    ditCanvasDrawTextLeftMiddle(listRowCanvas, listRowCanvas.Item.ItemName, gItemNameRect, fontColor, gListRowFontName, gListRowFontSize, gListRowItemFontWeight);
    ditCanvasDrawImage(listRowCanvas, gImageListIconDelete, gListRowLeftIconRect);
    ditCanvasDrawImage(listRowCanvas, imageListRowRightIcon, gListRowRightIconRect);
    drawBottomBorderLine(listRowCanvas);
}

function favItem_click(listRowCanvas) {

    if (listRowCanvas.ClickX < 50) {

        gSelectedItem = listRowCanvas.Item;

        ditMessageBoxYesNo(
            "Are you sure you want to remove " + gSelectedItem.ItemName + " from your favorites list?",
            function () {
                gSelectedItem.InFav = false;
                gFavNeedsRefreshed = true;
                favPageRefresh();
                saveAppState();
            }
        );
    }
    else if (listRowCanvas.ClickX > gItemRowRect.Width - 50) {

        gSelectedItem = listRowCanvas.Item;

        if (listRowCanvas.Item.InShop == true || listRowCanvas.Item.InCart == true) {
            listRowCanvas.Item.InShop = false;
            listRowCanvas.Item.InCart = false;
        }
        else {
            listRowCanvas.Item.InShop = true;
            listRowCanvas.Item.InCart = false;
        }

        favDrawItemRow(listRowCanvas);

        gShopNeedsRefreshed = true;
        gCartNeedsRefreshed = true;
        saveAppState();
    }
}

function btnFavSearch_pointerDown(e) {
    e.originalEvent.stopPropagation();
    btnFavSearch.style.backgroundColor = gButtonHighlightColor;
}

function btnFavSearch_pointerUp(e) {
    e.originalEvent.stopPropagation();
    e.originalEvent.preventDefault();

    btnFavSearch.style.backgroundColor = gThemeColor;

    divFavSearchBar.style.display = "block";
    divFavNavBar.style.display = "none";
    sortItemsArray();
    gFavNeedsRefreshed = true;
    favPageRefresh();
    ditDelayedFocus(txtFavSearch);

    //This button doesn't like to position right... this will fix it
    var xPos = txtFavSearch.offsetLeft
                    + txtFavSearch.offsetWidth
                    - divFavSearchClear.offsetWidth - 2; //+ padding
    divFavSearchClear.style.left = xPos + "px";
}

function btnFavSearchDone_pointerDown(e) {
    e.originalEvent.stopPropagation();
    btnFavSearchDone.style.backgroundColor = gButtonHighlightColor;
}

function btnFavSearchDone_pointerUp(e) {
    e.originalEvent.stopPropagation();
    e.originalEvent.preventDefault();

    btnFavSearchDone.style.backgroundColor = gThemeColor;
    divFavNavBar.style.display = "block";
    divFavSearchBar.style.display = "none";
    sortItemsArray();
    gFavNeedsRefreshed = true;
    favPageRefresh();
    saveAppState();

	txtFavSearch.blur(); //Defocus this
}

function txtFavSearch_keyUp(e) {
    gFavNeedsRefreshed = true;
    favPageRefresh();
}

function txtFavSearch_pointerUp(e){
    e.originalEvent.stopPropagation();
    //Don't prevent default - breaks WP8
    this.focus();
}

function divFavSearchClear_pointerDown(e) {
    e.originalEvent.stopPropagation();
    txtFavSearch.value = "";
    gFavNeedsRefreshed = true;
    favPageRefresh();
    txtFavSearch.focus();
    saveAppState();
}

// Shopping List page functions.

function shopPageRefresh() {

    if (gShopNeedsRefreshed == false) {
        return;
    }
    gShopNeedsRefreshed = false;

    var section;
    var item;

    listClear(divShopList);
    refreshNumberOfSectionSubItems();

    // Add rows for each item name within each section.

    for (var sectionIndex = 0; sectionIndex < gSectionsArray.length; sectionIndex++) {

        section = gSectionsArray[sectionIndex];

        if (section.NumberShopSubItems == 0) {
            continue;
        }

        shopNewSectionRow(section);
        gColumnsAdded = 0;

        // If this section is expanded, show all items in this section.

        if (section.ShopExpanded == true) {
            for (var itemIndex = 0; itemIndex < gItemsArray.length; itemIndex++) {

                item = gItemsArray[itemIndex];

                if (item.SectionName == section.SectionName && item.InShop == true) {
                    shopNewItemRow(item);
                }
            }
        }
        addEmptyColumnsToList(divShopList);
    }

    if (divShopList.ContentHeight == 0) {
        addEmptyMessage(divShopList, "Your shopping list is empty");
    }
}

function shopNewSectionRow(section) {

    var listRowCanvas = ditCanvasNew(gSectionRowRect.Width, gSectionRowRect.Height);
    listRowCanvas.Section = section;
    ditFastClickCanvas(listRowCanvas, shopDrawSectionRow, shopSection_click);

    divShopList.appendChild(listRowCanvas);
    divShopList.ContentHeight += gSectionRowRect.Height;
}

function shopDrawSectionRow(listRowCanvas) {

    var section = listRowCanvas.Section;

    if (section.ShopExpanded == true) {
        drawSectionName(listRowCanvas, 0);
    }
    else {
        drawSectionName(listRowCanvas, section.NumberShopSubItems);
    }
}

function shopSection_click(e) {
    this.Section.ShopExpanded = !this.Section.ShopExpanded;
    gShopNeedsRefreshed = true;
    shopPageRefresh();
}

function shopNewItemRow(item) {

    var listRowCanvas = ditCanvasNew(gItemRowRect.Width, gItemRowRect.Height);
    listRowCanvas.Item = item;
    ditFastClickCanvas(listRowCanvas, shopDrawItemRow, shopItem_click);

    listAddItemRow(divShopList, listRowCanvas);
}

function shopDrawItemRow(listRowCanvas) {

    var backColor;
    var imageListRowLeftIcon;

    if (listRowCanvas.Selected == true) {
        backColor = gRowHighlightColor;
    }
    else {
        backColor = gListRowBackColor;
    }

    if (listRowCanvas.Item.InFav == true) {
        imageListRowLeftIcon = gImageListIconShopToFav;
    }
    else {
        imageListRowLeftIcon = gImageListIconDelete;
    }

    ditCanvasFillRect(listRowCanvas, listRowCanvas.Rect, backColor);
    ditCanvasDrawTextLeftMiddle(listRowCanvas, listRowCanvas.Item.ItemName, gItemNameRect, gListRowItemFontColor, gListRowFontName, gListRowFontSize, gListRowItemFontWeight);
    ditCanvasDrawImage(listRowCanvas, imageListRowLeftIcon, gListRowLeftIconRect);
    ditCanvasDrawImage(listRowCanvas, gImageListIconShopToCart, gListRowRightIconRect);
    drawBottomBorderLine(listRowCanvas);
}

function shopItem_click(listRowCanvas) {

    if (listRowCanvas.ClickX < 50) {
        gSelectedItem = listRowCanvas.Item;
        ditMessageBoxYesNo(
            "Are you sure you want to remove " + gSelectedItem.ItemName + " from your shopping list?",
            function () {
                gSelectedItem.InShop = false;
                gShopNeedsRefreshed = true;
                shopPageRefresh();
                saveAppState();

                if (gSelectedItem.InFav == true) {
                    gFavNeedsRefreshed = true;
                }
            }
        );
    }
    else if (listRowCanvas.ClickX > gItemRowRect.Width - 50) {
        gSelectedItem = listRowCanvas.Item;
        listRowCanvas.Item.InShop = false;
        listRowCanvas.Item.InCart = true;
        gShopNeedsRefreshed = true;
        shopPageRefresh();
        saveAppState();

        gCartNeedsRefreshed = true;

        if (gSelectedItem.InFav == true) {
            gFavNeedsRefreshed = true;
        }
    }
}

// Shopping Cart page functions.

function cartPageRefresh() {

    if (gCartNeedsRefreshed == false) {
        return;
    }
    gCartNeedsRefreshed = false;

    var section;
    var item;

    listClear(divCartList);
    refreshNumberOfSectionSubItems();

    // Add rows for each item name within each section.

    for (var sectionIndex = 0; sectionIndex < gSectionsArray.length; sectionIndex++) {

        section = gSectionsArray[sectionIndex];
        
        if (section.NumberCartSubItems == 0) {
            continue;
        }

        cartNewSectionRow(section);
        gColumnsAdded = 0;

        // If this section is expanded, show all items in this section.

        if (section.CartExpanded == true) {
            for (var itemIndex = 0; itemIndex < gItemsArray.length; itemIndex++) {

                item = gItemsArray[itemIndex];

                if (item.SectionName == section.SectionName && item.InCart == true) {
                    cartNewItemRow(item);
                }
            }
        }
        addEmptyColumnsToList(divCartList);
    }

    if (divCartList.ContentHeight == 0) {
        addEmptyMessage(divCartList, "Your shopping cart is empty");
    }
}

function cartNewSectionRow(section) {

    var listRowCanvas = ditCanvasNew(gSectionRowRect.Width, gSectionRowRect.Height);
    listRowCanvas.Section = section;
    ditFastClickCanvas(listRowCanvas, cartDrawSectionRow, cartSection_click);

    divCartList.appendChild(listRowCanvas);
    divCartList.ContentHeight += gSectionRowRect.Height;
}

function cartDrawSectionRow(listRowCanvas) {

    var section = listRowCanvas.Section;

    if (section.CartExpanded == true) {
        drawSectionName(listRowCanvas, 0);
    }
    else {
        drawSectionName(listRowCanvas, section.NumberCartSubItems);
    }
}

function cartSection_click(e) {
    this.Section.CartExpanded = !this.Section.CartExpanded;
    gCartNeedsRefreshed = true;
    cartPageRefresh();
}

function cartNewItemRow(item) {

    var listRowCanvas = ditCanvasNew(gItemRowRect.Width, gItemRowRect.Height);
    listRowCanvas.Item = item;
    ditFastClickCanvas(listRowCanvas, cartDrawItemRow, cartItem_click);

    listAddItemRow(divCartList, listRowCanvas);
}

function cartDrawItemRow(listRowCanvas) {

    var backColor;

    if (listRowCanvas.Selected == true) {
        backColor = gRowHighlightColor;
    }
    else {
        backColor = gListRowBackColor;
    }

    ditCanvasFillRect(listRowCanvas, listRowCanvas.Rect, backColor);
    ditCanvasDrawTextLeftMiddle(listRowCanvas, listRowCanvas.Item.ItemName, gItemNameRect, gListRowItemFontColor, gListRowFontName, gListRowFontSize, gListRowItemFontWeight);
    ditCanvasDrawImage(listRowCanvas, gImageListIconCartToShop, gListRowLeftIconRect);
    ditCanvasDrawImage(listRowCanvas, gImageListIconDelete, gListRowRightIconRect);
    drawBottomBorderLine(listRowCanvas);
}

function cartItem_click(listRowCanvas) {

    if (listRowCanvas.ClickX < 50) {
        gSelectedItem = listRowCanvas.Item;
        listRowCanvas.Item.InShop = true;
        listRowCanvas.Item.InCart = false;
        gFavNeedsRefreshed = true;
        gShopNeedsRefreshed = true;
        gCartNeedsRefreshed = true;
        cartPageRefresh();
        saveAppState();
    }
    else if (listRowCanvas.ClickX > gItemRowRect.Width - 50) {
        gSelectedItem = listRowCanvas.Item;
        ditMessageBoxYesNo(
            "Are you sure you want to remove " + gSelectedItem.ItemName + " from your cart?",
            function () {
                gSelectedItem.InCart = false;
                gCartNeedsRefreshed = true;
                cartPageRefresh();
                saveAppState();
            }
        );
    }
}

// New Item page functions.

function newItemPageShow(itemName) {
    btnToolbarNewItem.style.backgroundColor = gButtonHighlightColor;

    if (itemName == undefined) {
        txtItemName.value = "";
    }
    else {
        txtItemName.value = itemName;
    }

    // Draw the "Add Where" options.

    divNewItemAddWhere.innerHTML = "";

    newItemNewAddWhereRow("divNewItemAddWhereFav", "Add to Favorites", ditBoolParse(ditStorageGet("NewItemAddWhereFavChecked")));
    divAddSeparator(divNewItemAddWhere);
    newItemNewAddWhereRow("divNewItemAddWhereShop", "Add to Shopping List", ditBoolParse(ditStorageGet("NewItemAddWhereShopChecked")));

    // Draw the list of sections.

    removeEmptySections();
    newItemRefreshSections();

    // Show the page.

    ditPageShowSlideTop(divNewItemPage);
    ditDelayedFocus(txtItemName);
}

function newItemNewAddWhereRow(id, text, checked) {
    
    var can = ditCanvasNew(300, 40);
    can.Rect = ditRectNew(0, 0, 300, 40);

    can.id = id;
    can.Checked = checked;
    can.Text = text;
    can.CheckRect = ditRectNew(15, 10, 20, 20);
    can.TextRect = ditRectNew(50, 0, 255, 40);

    can.addEventListener('pointerdown', function(e){
        var touches = e.getPointerList();
        if (touches[0].clientX < 50) {
            e.originalEvent.stopPropagation();
            this.Checked = !this.Checked;
            newItemDrawAddWhereRow(this, gRowHighlightColor);
        }
    }, false);

    can.addEventListener('pointerup', function(e){
        newItemDrawAddWhereRow(this, "#ffffff");
    }, false);

    newItemDrawAddWhereRow(can, "#ffffff");
    divNewItemAddWhere.appendChild(can);
}

function newItemDrawAddWhereRow(canvas, backColor) {

    var fontColor = "#000000";

    ditCanvasFillRect(canvas, canvas.Rect, backColor);
    ditCanvasDrawCheckBox(canvas, canvas.CheckRect, canvas.Checked);
    ditCanvasDrawTextLeftMiddle(canvas, canvas.Text, canvas.TextRect, fontColor, gListRowFontName, 20, "");
}

function newItemRefreshSections() {

    divNewItemSections.innerHTML = "";
    divNewItemSections.ContentHeight = 0;

    for (var i = 0; i < gSectionsArray.length; i++) {
        newItemNewSectionRow(gSectionsArray[i]);
    }

    // Add the row for the new section input.

    var textbox = document.createElement("input");
    textbox.type = "text";
    textbox.id = "txtSectionName";
    textbox.placeholder = "Name for a new category";

    textbox.addEventListener('blur', txtSectionName_blur, false);

    //Need this compatibility hack to focus on click
    textbox.addEventListener('click', function(e){
        this.focus();
    }, false);

    divNewItemSections.appendChild(textbox);
    divNewItemSections.ContentHeight += 36;
}

function txtSectionName_blur(e) {
    window.scrollTo(0, 0);  // Reposition page after the keyboard is hidden.

    var sectionName = ditWordCap(txtSectionName.value.trim());

    if (sectionName == "") {
        return;
    }

    // See if this section is already in the array.

    var found = false;

    for (var i = 0; i < gSectionsArray.length; i++) {
        if (sectionName == gSectionsArray[i].SectionName) {
            found = true;
            break;
        }
    }

    // Add it to the end of the array if it isn't already in the array.

    if (found == false) {
        gSectionsArray[gSectionsArray.length] = sectionNew(sectionName);
    }

    // Refresh the section list to make sure this new section is selected.
    
    gLastNewItemSectionName = sectionName;
    newItemRefreshSections();
}

function newItemNewSectionRow(section) {
    var can;
    var listNeedsRedrawn = false;

    can = ditCanvasNew(300, 36);
    can.Rect = ditRectNew(0, 0, 300, 36);

    can.Section = section;
    can.CheckRect = ditRectNew(15, 10, 20, 20);
    can.TextRect = ditRectNew(50, 0, 255, 40);

    newItemDrawSectionRow(can, "#ffffff");

    can.addEventListener('pointerdown', function(e){
        var touches = e.getPointerList();
        if (touches[0].clientX < 50) {
            e.originalEvent.stopPropagation();
            gLastNewItemSectionName = this.Section.SectionName;
            newItemDrawSectionRow(this, gRowHighlightColor);
            listNeedsRedrawn = true;
        }
        else {
            listNeedsRedrawn = false;
        }
    }, false);

    can.addEventListener('pointerup', function(e){
        if (listNeedsRedrawn == true) {
            newItemRefreshSections();
            listNeedsRedrawn = false;
        }
    }, false);

    divNewItemSections.appendChild(can);
    divNewItemSections.ContentHeight += 36;
}

function newItemDrawSectionRow(canvas, backColor) {

    var checked = false;
    var fontColor = gThemeColor;

    if (canvas.Section.SectionName == gLastNewItemSectionName) {
        checked = true;
    }

    ditCanvasFillRect(canvas, canvas.Rect, backColor);
    ditCanvasDrawCheckBox(canvas, canvas.CheckRect, checked);
    ditCanvasDrawTextLeftMiddle(canvas, canvas.Section.SectionName, canvas.TextRect, fontColor, gListRowFontName, 20, "");
    drawBottomBorderLine(canvas);
}

function btnNewItemDone_pointerDown(e) {
    e.originalEvent.stopPropagation();
    btnNewItemDone.style.backgroundColor = gButtonHighlightColor;
}

function btnNewItemDone_pointerUp(e) {
    e.originalEvent.stopPropagation();
    e.originalEvent.preventDefault();

    btnNewItemDone.style.backgroundColor = gThemeColor;
    btnToolbarNewItem.style.backgroundColor = "#000000";

    var itemName = ditWordCap(txtItemName.value.trim());

    // Create a new item object.

    var item = itemNew(itemName, gLastNewItemSectionName);
    item.InFav = divNewItemAddWhereFav.Checked;
    item.InShop = divNewItemAddWhereShop.Checked;

    // Don't add anything if the item name is blank or neither list is selected.

    if (item.ItemName == "" || (item.InFav == false && item.InShop == false)) {
        ditPageHideOnBottom(divNewItemPage);
        return;
    }

    // Add the new item to the end of the array unless it is already in the array.

    var lowItemName = item.ItemName.toLowerCase();
    var found = false;

    for (var i = 0; i < gItemsArray.length; i++) {
        if (item.SectionName == gItemsArray[i].SectionName
        && lowItemName == gItemsArray[i].ItemName.toLowerCase()) {
            gItemsArray[i] = item;   // Change the values (capitalization, etc) to whatever was just entered.
            found = true;
        }
    }

    if (found == false) {
        gItemsArray[gItemsArray.length] = item;
        sortItemsArray();
    }

    // Save some UI values for next time the page is used.

    ditStorageSet("NewItemAddWhereFavChecked", ditBoolToYN(divNewItemAddWhereFav.Checked));
    ditStorageSet("NewItemAddWhereShopChecked", ditBoolToYN(divNewItemAddWhereShop.Checked));
    ditStorageSet("LastNewItemSectionName", gLastNewItemSectionName);

    // Refresh the UI lists.

    gFavNeedsRefreshed = true;
    gShopNeedsRefreshed = true;

    // Refresh the UI depending on what page is visible.

    removeEmptySections();

    if (divFavPage.style.display == "block") {
        favPageRefresh();
    }
    else if (divShopPage.style.display == "block") {
        shopPageRefresh();
    }

    ditPageHideOnBottom(divNewItemPage);
    saveAppState();
}

// Help page functions. 

function helpPageShow() {

    ditHttpGetAsync(ditResourceBase + "resources/help.html",
        function (helpHtml) {
            divHelpPageContent.innerHTML = helpHtml;
        }
    );

    ditPageShowSlideTop(divHelpPage);
}

function btnHelpDone_pointerDown(e) {
    e.originalEvent.stopPropagation();
    btnHelpDone.style.backgroundColor = gButtonHighlightColor;
}

function btnHelpDone_pointerUp(e) {
    e.originalEvent.stopPropagation();
    e.originalEvent.preventDefault();

    btnHelpDone.style.backgroundColor = gThemeColor;
    btnToolbarHelp.style.backgroundColor = "#000000";
    ditPageHideOnBottom(divHelpPage);
}

// Settings page functions.

function settingsPageShow() {

    removeEmptySections();
    settingsRefreshFontSizes();
    settingsRefreshSectionsSortOrder();
    ditPageShowSlideTop(divSettingsPage);
}

function settingsRefreshFontSizes() {

    divSettingsFontSizes.innerHTML = "";

    settingsNewFontSizeRow("divSettingsFontSizeLarge", "Large", 26);
    divAddSeparator(divSettingsFontSizes);
    settingsNewFontSizeRow("divSettingsFontSizeMedium", "Medium", 20);
    divAddSeparator(divSettingsFontSizes);
    settingsNewFontSizeRow("divSettingsFontSizeSmall", "Small    Small", 16);
    divAddSeparator(divSettingsFontSizes);
    settingsNewFontSizeRow("divSettingsFontSizeTiny", "Tiny    Tiny    Tiny", 10);
}

function settingsNewFontSizeRow(id, text, fontSize) {

    var can = ditCanvasNew(300, 40);
    can.Rect = ditRectNew(0, 0, 300, 40);

    can.id = id;
    can.Text = text;
    can.FontSize = fontSize;
    can.CheckRect = ditRectNew(15, 10, 20, 20);
    can.TextRect = ditRectNew(50, 0, 255, 40);

    if (fontSize == gListRowFontSize) {
        can.Checked = true;
    }
    else {
        can.Checked = false;
    }

    settingsDrawFontSizeRow(can, "#ffffff");

    can.addEventListener('pointerdown', function(e){
        var touches = e.getPointerList();
        if(touches.length == 0)
            return;

        if (touches[0].clientX < 50) {
            e.originalEvent.stopPropagation();
            gListRowFontSize = this.FontSize;
            this.Checked = true;
            settingsDrawFontSizeRow(this, gRowHighlightColor);
        }
    }, false);

    can.addEventListener('pointerup', function(e){
        settingsRefreshFontSizes();
    }, false);

    divSettingsFontSizes.appendChild(can);
}

function settingsDrawFontSizeRow(canvas, backColor) {

    var fontColor = "#000000";

    ditCanvasFillRect(canvas, canvas.Rect, backColor);

    ditCanvasDrawTextLeftMiddle(canvas, canvas.Text, canvas.TextRect, fontColor, gListRowFontName, canvas.FontSize, "");

    ditCanvasDrawCheckBox(canvas, canvas.CheckRect, canvas.Checked);
}

function settingsRefreshSectionsSortOrder() {

    divSettingsSectionsSortOrder.innerHTML = "";
    divSettingsSectionsSortOrder.ContentHeight = 0;

    for (var i = 0; i < gSectionsArray.length; i++) {
        settingsNewSectionRow(i);
    }
}

function settingsNewSectionRow(index) {

    var listRowCanvas;
    var textRect = ditRectNew(36, 0, 264, 36);
    var upIconRect = ditRectNew(5, 5, 26, 26);
    var downIconRect = ditRectNew(256, 5, 26, 26);

    listRowCanvas = ditCanvasNew(300, 36);
    listRowCanvas.Rect = ditRectNew(0, 0, 300, 36);

    listRowCanvas.Index = index;
    listRowCanvas.Section = gSectionsArray[index];

    if (listRowCanvas.Section.SectionName == gSettingsLastSectionMoved) {
        ditCanvasFillRect(listRowCanvas, listRowCanvas.Rect, gRowHighlightColor);
    }
    else {
        ditCanvasFillRect(listRowCanvas, listRowCanvas.Rect, "#ffffff");
    }

    ditCanvasDrawTextLeftMiddle(listRowCanvas, listRowCanvas.Section.SectionName, textRect, gThemeColor, gListRowFontName, 20, "");

    if (listRowCanvas.Section != gSectionsArray[0]) {
        ditCanvasDrawImage(listRowCanvas, gImageSettingsSortUpIcon, upIconRect);
    }

    if (listRowCanvas.Section != gSectionsArray[gSectionsArray.length - 1]) {
        ditCanvasDrawImage(listRowCanvas, gImageSettingsSortDownIcon, downIconRect);
    }

    drawBottomBorderLine(listRowCanvas);

    listRowCanvas.addEventListener('pointerdown', settingsSortOrderItem_pointerDown, false);

    divSettingsSectionsSortOrder.appendChild(listRowCanvas);
    divSettingsSectionsSortOrder.ContentHeight += 36;
}

function settingsSortOrderItem_pointerDown(e) {
    var touches = e.getPointerList();
    if(touches.length == 0)
        return;

    var tempSection;
    var i = this.Index;
    var arrowWidth = 50;

    var x = touches[0].clientX;

    // Move up?

    if (x < arrowWidth) {

        gSettingsLastSectionMoved = gSectionsArray[i].SectionName;

        if (i > 0) {

            tempSection = gSectionsArray[i - 1];
            gSectionsArray[i - 1] = gSectionsArray[i];
            gSectionsArray[i] = tempSection;

            settingsRefreshSectionsSortOrder();
            e.originalEvent.stopPropagation();
        }
    }

    // Move down?

    else if (x > (this.width / ditDevicePixelRatio) - arrowWidth) {

        gSettingsLastSectionMoved = gSectionsArray[i].SectionName;

        if (i < gSectionsArray.length - 1) {

            tempSection = gSectionsArray[i + 1];
            gSectionsArray[i + 1] = gSectionsArray[i];
            gSectionsArray[i] = tempSection;

            settingsRefreshSectionsSortOrder();
            e.originalEvent.stopPropagation();
        }
    }
}

function btnSettingsReset_click(e) {

    ditMessageBoxYesNo(
            "Are you sure you want to reset all lists and all settings to the default values?",
            function () {
                ditStorageClear();
                initAppState();
                btnToolbarSettings.style.backgroundColor = "#000000";
                ditPageHideOnBottom(divSettingsPage);
                ditMessageBoxOK("All setting have been reset to default values.");

                //Persist the newly reset values
                saveAppState();
            }
        );
}

function btnSettingsDone_pointerDown(e) {
    e.originalEvent.stopPropagation();
    btnSettingsDone.style.backgroundColor = gButtonHighlightColor;
}

function btnSettingsDone_pointerUp(e) {
    e.originalEvent.stopPropagation();
    e.originalEvent.preventDefault();

    btnSettingsDone.style.backgroundColor = gThemeColor;
    btnToolbarSettings.style.backgroundColor = "#000000";

    // Re-initialize the UI element sizes.

    ditStorageSet("ListRowFontSize", gListRowFontSize);

    initUiElementSizes();

    // Refresh the UI depending on what page is visible.

    gFavNeedsRefreshed = true;
    gShopNeedsRefreshed = true;
    gCartNeedsRefreshed = true;

    if (divFavPage.style.display == "block") {
        favPageRefresh();
    }
    else if (divShopPage.style.display == "block") {
        shopPageRefresh();
    }
    else if (divCartPage.style.display == "block") {
        cartPageRefresh();
    }

    // Hide the settings page.

    ditPageHideOnBottom(divSettingsPage);

    saveAppState();
}

// File I/O functions.

function procGetDefaultListResponse(response) {

    var lineIndex;
    var sectionsIndex = 0;
    var itemsIndex = 0;

    gSectionsArray = [];
    gItemsArray = [];

    var lines = response.split("\r\n");

    // Find the [Sections] header.

    for (lineIndex = 0; lineIndex < lines.length; lineIndex++) {
        if (lines[lineIndex] == "[Sections]") {
            lineIndex++;
            break;
        }
    }

    // Next, process the sections until the [Items] header is found.

    sectionsIndex = 0;
    for (; lineIndex < lines.length; lineIndex++) {

        if (lines[lineIndex] == "") {
            continue;
        }
        if (lines[lineIndex] == "[Items]") {
            lineIndex++;
            break;
        }

        gSectionsArray[sectionsIndex] = sectionDeserialize(lines[lineIndex]);
        sectionsIndex++;
    }

    // Process the items.

    itemsIndex = 0;
    for (; lineIndex < lines.length; lineIndex++) {

        if (lines[lineIndex] == "") {
            continue;
        }

        gItemsArray[itemsIndex] = itemDeserialize(lines[lineIndex]);
        itemsIndex++;
    }

    // Finally, sort the list and show the Shopping List page.

    ditWaitHide();
    gFavNeedsRefreshed = true;
    gShopNeedsRefreshed = true;
    gCartNeedsRefreshed = true;
    sortItemsArray();
    shopPageRefresh();
    ditPageShowSlideLeftRight(divShopPage);
}

function sectionDeserialize(line) {

    // Record format = Section name ~ FavExpanded ~ ShopExpanded ~ CartExpanded */

    var fields = line.split("\t");

    var s = {};

    s.SectionName = fields[0];
    s.FavExpanded = ditBoolParse(fields[1]);
    s.ShopExpanded = ditBoolParse(fields[2]);
    s.CartExpanded = ditBoolParse(fields[3]);

    s.NumberFavSubItems = 0;
    s.NumberShopSubItems = 0;
    s.NumberCartSubItems = 0;

    return s;
}

function sectionNew(sectionName) {
    
    var s = {};

    s.SectionName = sectionName;
    s.FavExpanded = true;
    s.ShopExpanded = true;
    s.CartExpanded = true;

    s.NumberFavSubItems = 0;
    s.NumberShopSubItems = 0;
    s.NumberCartSubItems = 0;

    return s;
}

function itemDeserialize(line) {

    // Record format = Item name ~ Category ~ InFav ~ InShop ~ InCart */

    var fields = line.split("\t");

    var i = {};

    i.SectionName = fields[0];
    i.ItemName = fields[1];
    i.InFav = ditBoolParse(fields[2]);
    i.InShop = ditBoolParse(fields[3]);
    i.InCart = ditBoolParse(fields[4]);

    return i;
}

function itemNew(itemName, sectionName) {

    var i = {};

    i.SectionName = sectionName;
    i.ItemName = itemName;
    i.InFav = false;
    i.InShop = false;
    i.InCart = false;

    return i;
}

function saveAppState() {
    // TODO: Fix This!
    //  Call when app is closing.
    //  Also send the list to the server?  
    //  Save other app state options?

    ditStorageSet("ShoppingList", serializeList());
    ditStorageSet("txtFavSearch", txtFavSearch.value);
    ditStorageSet("txtItemName", txtItemName.value);
}

function serializeList() {
    var file = "v1\r\n";

    file += "[Sections]\r\n";

    for (var sectionIndex = 0; sectionIndex < gSectionsArray.length; sectionIndex++) {
        var section = gSectionsArray[sectionIndex];
        
        file += 
            section.SectionName                 + "\t"
            + ditBoolToYN(section.FavExpanded)  + "\t"
            + ditBoolToYN(section.ShopExpanded) + "\t"
            + ditBoolToYN(section.CartExpanded) + "\r\n";
    }

    file += "[Items]\r\n";

    for (var itemIndex = 0; itemIndex < gItemsArray.length; itemIndex++) {
        var item = gItemsArray[itemIndex];

        if (item.InFav == true || item.InShop == true || item.InCart == true) {
            file +=
                item.SectionName + "\t"
                + item.ItemName + "\t"
                + ditBoolToYN(item.InFav) + "\t"
                + ditBoolToYN(item.InShop) + "\t"
                + ditBoolToYN(item.InCart) + "\r\n";
        }
    }

    return file;
}

// Helper functions.

function listClear(divList) {
    divList.innerHTML = "";
    divList.ContentHeight = 0;
    gColumnsAdded = 0;
}

function listAddItemRow(divList, listRowCanvas) {

    divList.appendChild(listRowCanvas);

    gColumnsAdded++;

    if (gColumnsAdded == gColumnsPerRow) {
        divList.ContentHeight += gItemRowRect.Height;
        gColumnsAdded = 0;
    }
}

function addEmptyColumnsToList(divList) {

    // Add some empty empty columns to complete the row if needed.

    if (gColumnsAdded == 0) {
        return;
    }

    var columnsNeeded = gColumnsPerRow - gColumnsAdded;

    for (var i = 0; i < columnsNeeded; i++) {
        var listRowCanvas = ditCanvasNew(gItemRowRect.Width, gItemRowRect.Height);
        listRowCanvas.Rect = gItemRowRect;
        ditCanvasFillRect(listRowCanvas, listRowCanvas.Rect, gListRowBackColor);
        divList.appendChild(listRowCanvas);
    }

    divList.ContentHeight += gItemRowRect.Height;
}

function sortItemsArray() {

    if (divFavSearchBar.style.display == "block") {
        gItemsArray.sort(compareItems);
    }
    else {
        gItemsArray.sort(compareItemsGrouped);
    }
}

function compareItems(i1, i2) {

    var i1lowItemName = i1.ItemName.toLowerCase();
    var i2lowItemName = i2.ItemName.toLowerCase();

    if (i1lowItemName < i2lowItemName) {
        return -1;
    }

    if (i1lowItemName > i2lowItemName) {
        return 1;
    }

    return 0;
}

function compareItemsGrouped(i1, i2) {

    var i1lowSectionName = i1.SectionName.toLowerCase();
    var i1lowItemName = i1.ItemName.toLowerCase();

    var i2lowSectionName = i2.SectionName.toLowerCase();
    var i2lowItemName = i2.ItemName.toLowerCase();

    if (i1lowSectionName < i2lowSectionName) {
        return -1;
    }

    if (i1lowSectionName > i2lowSectionName) {
        return 1;
    }

    if (i1lowItemName < i2lowItemName) {
        return -1;
    }

    if (i1lowItemName > i2lowItemName) {
        return 1;
    }

    return 0;   // This shouldn't happen as both section name and item name should never be equal.
}

function refreshNumberOfSectionSubItems() {

    for (var s = 0; s < gSectionsArray.length; s++) {

        gSectionsArray[s].NumberFavSubItems = 0;
        gSectionsArray[s].NumberShopSubItems = 0;
        gSectionsArray[s].NumberCartSubItems = 0;

        for (var i = 0; i < gItemsArray.length; i++) {

            if (gItemsArray[i].SectionName == gSectionsArray[s].SectionName) {

                if (gItemsArray[i].InFav == true) {
                    gSectionsArray[s].NumberFavSubItems++;
                }
                if (gItemsArray[i].InShop == true) {
                    gSectionsArray[s].NumberShopSubItems++;
                }
                if (gItemsArray[i].InCart == true) {
                    gSectionsArray[s].NumberCartSubItems++;
                }

            }
        }
    }
}

function removeEmptySections() {
    var sectionsArray = [];

    refreshNumberOfSectionSubItems();

    for (var i = 0; i < gSectionsArray.length; i++) {
        var section = gSectionsArray[i];
        if (section.NumberFavSubItems > 0
            || section.NumberShopSubItems > 0
            || section.NumberCartSubItems > 0) {
            sectionsArray[sectionsArray.length] = section;
        }
    }

    gSectionsArray = sectionsArray;
}

function drawSectionName(listRowCanvas, numberSubItems) {

    var sectionString = listRowCanvas.Section.SectionName;

    if (numberSubItems > 0) {
        sectionString += " (" + numberSubItems + ")";
    }

    if (listRowCanvas.Selected == true) {
        ditCanvasFillRect(listRowCanvas, listRowCanvas.Rect, gRowHighlightColor);
    
    }
    else {
        ditCanvasFillRect(listRowCanvas, listRowCanvas.Rect, gListRowBackColor);
    }

    ditCanvasDrawTextLeftMiddle(
        listRowCanvas,
        sectionString,
        gSectionNameRect,
        gThemeColor,
        gListRowFontName,
        gListRowFontSize, 
        gListRowSectionFontWeight);
    
    drawBottomBorderLine(listRowCanvas);
}

function addEmptyMessage(div, text) {

    var listRowCanvas = ditCanvasNew(ditScreenWidth, 40);
    listRowCanvas.Rect = ditRectNew(0, 0, ditScreenWidth, 40);
    ditCanvasFillRect(listRowCanvas, listRowCanvas.Rect, "#eeeeee");
    ditCanvasDrawTextCenterMiddle(listRowCanvas, text, listRowCanvas.Rect, gListRowItemFontColor, gListRowFontName, 20, "italic");
    div.appendChild(listRowCanvas);

    return listRowCanvas;
}

function drawBottomBorderLine(canvas) {
    ditCanvasDrawLine(canvas, "#eeeeee", 1,
        canvas.Rect.Left,
        canvas.Rect.Height - 1,
        canvas.Rect.Width, 
        canvas.Rect.Height - 1);
}

function divAddSeparator(div) {

    var line = ditCanvasNew(300, 1);
    ditCanvasFillRect(line, ditRectNew(0, 0, 300, 1), "#7F7F7F");
    line.className = "separator";
    div.appendChild(line);
}
