
var categoryicons = new Array();
var shopit = {};
shopit.db = {};
shopit.indexedDB = {};
shopit.indexedDB.db = null;
shopit.indexedDB.ret = new Array();

shopit.indexedDB.open = function(dbname, version) {
	
	var request = indexedDB.open(dbname, version);
	var prom = $.Deferred();
	
	request.onsuccess = function(e){
		shopit.indexedDB.db = e.target.result;
		prom.resolve();
	};
	
	request.onerror = function(e){
		console.log("[SHOPIT DB ERROR: ]"+e);
	};
	
	request.onupgradeneeded = function(e){
		var db = e.target.result;
		e.target.transaction.onerror = shopit.indexedDB.onerror;
		
		// create object stores
		shopit.indexedDB.createOS(db, "categories", { autoIncrement : true });
		shopit.indexedDB.createOS(db, "shoplists", { autoIncrement : true });
		shopit.indexedDB.createOS(db, "settings", { autoIncrement : true });
	};
	
	return $.when(prom).done(function(){}).promise();
};

shopit.indexedDB.createOS = function(db, osname, index){
	if(db.objectStoreNames.contains(osname)) db.deleteObjectStore(osname);
	var store  = db.createObjectStore(osname, index);
};

shopit.indexedDB.clear = function(osname){
	var db = shopit.indexedDB.db;
  	var trans = db.transaction([osname], "readwrite");
  	var store = trans.objectStore(osname);
  	store.clear();
};

shopit.indexedDB.update = function(osname, item, callback){
	var db = shopit.indexedDB.db;
  	var trans = db.transaction([osname], "readwrite");
  	var store = trans.objectStore(osname);
  	var request = store.get(Number(item.id));
  	
  	request.onerror = function(event) {
	  
	};
	
	request.onsuccess = function(e) {
	  // Get the old value that we want to update
	 
	 
	
	 var requestUpadate = store.put(item, item.id);
	 
	 requestUpadate.onsuccess = function(e){
	 	callback();
	 };
		
	  // Put this updated object back into the database.
	 
	};
	
};

shopit.indexedDB.add = function(osname, item) {
  	var db = shopit.indexedDB.db;
  	var trans = db.transaction([osname], "readwrite");

  	var store = trans.objectStore(osname);
  	var request = store.put(item);

	trans.oncomplete = function(e) {
		console.log("Item added to: "+osname);
	};

  	request.onerror = function(e) {
    	console.log(e.value);
  	};
};

shopit.indexedDB.remove = function(osname, id){
	var db = shopit.indexedDB.db;
  	var trans = db.transaction([osname], "readwrite");
  	var store = trans.objectStore(osname);
  	var request = store.delete(id);	
};

shopit.indexedDB.removeDb = function(dbname){
	var req = indexedDB.deleteDatabase(dbname);
	req.onsuccess = function () {
	    console.log("Deleted database successfully");
	};
	req.onerror = function () {
	    console.log("Couldn't delete database");
	};
	req.onblocked = function () {
	    console.log("Couldn't delete database due to the operation being blocked");
	};
};

shopit.indexedDB.getAllDataFrom = function(osname){
	var db = shopit.indexedDB.db;
	var trans = db.transaction([osname], "readwrite");
	var store = trans.objectStore(osname);
	var cursorRequest = store.openCursor(null, "next");
	var prom = $.Deferred();
	
	shopit.indexedDB.ret[osname] = [];

	cursorRequest.onsuccess = function(e){
		var result = e.target.result;
		if(!!result == false)
      	return prom.resolve();
      	result.value.id = result.primaryKey;
      	shopit.indexedDB.ret[osname].push(result.value);
      	result.continue();      	
	};
	
	return $.when(prom).done(function(){}).promise();
};

//
// FUNCTIONS 
// CALL IT WITH AN EVENT (USUALLY BY CLICK)
//

// database init - it call by index.js (addEventListener)
function init() {
	
  var prom = $.Deferred();
  shopit.indexedDB.open("shopit",11).done(function(){
  var i = 0;
  shopit.indexedDB.getAllDataFrom('settings').done(function(){
	  		shopit.indexedDB.ret['settings'].forEach(function(item){
	  				 i++;
	  		});
	  		if(i==0){
	  			add("settings",{name:"initalized", value:1});
	  			loadDemoDb();
	  		} 
	  		prom.resolve();
	});	
  }); 
  return $.when(prom).done(function(){}).promise();
  // uncomment do delete the db - reset the app
  //shopit.indexedDB.removeDb("shopit");
}

function add(osname, item) {
	shopit.indexedDB.add(osname, item);
}

function update(osname, id, item){
	shopit.indexedDB.update(osname, id, item);
}

function remove(osname, id){
	shopit.indexedDB.remove(osname, id);
}

// order by name ASC
function compare(a,b) {
	if (a.name < b.name)
		return -1;
	if (a.name > b.name)
		return 1;
	return 0;
}

function categoryCompare(a,b) {
	if (a.id_category < b.id_category)
		return -1;
	if (a.id_category > b.id_category)
		return 1;
	return 0;
}


function loadDemoDb()
{
	//shopit.indexedDB.removeDb("shopit");
	shopit.indexedDB.add("categories",{name:"Milk products"});
	shopit.indexedDB.add("categories",{name:"Breads"});
	shopit.indexedDB.add("categories",{name:"Cleaning products"});
	shopit.indexedDB.add("categories",{name:"Vegetables"});
	shopit.indexedDB.add("categories",{name:"Fruits"});
}









