var db;
var objectStore;

window.onload = function () {
/*
    document.querySelector("#delItem").onclick = function (e) {

        objectStore = db.transaction(["toDoList"], "readwrite").objectStore("toDoList");
        console.log(deleteIDX);
        var req = objectStore.delete(deleteIDX);

        req.onsuccess = function (event) {
            console.log("torolve");
            document.querySelector("#delDiv").setAttribute("style", "display: none;");
            list();
        };

        req.onerror = function (event) {
            console.log("Hiba! Nincs meg az elem!");
        };
    };
    
    document.querySelector("#disItem").onclick = function (e) {

        objectStore = db.transaction(["toDoList"], "readwrite").objectStore("toDoList");
        console.log(disIDX);
        var req = objectStore.index("id").get(disIDX);

        req.onsuccess = function (event) {

            var data = event.target.result;
            data.checked = true;
            var reqUpdate = objectStore.put(data);

            reqUpdate.onerror = function (event) {
                document.querySelector("#disDiv").setAttribute("style", "display: none;");
                console.log("Hiba a frissítésnél!");
            };

            reqUpdate.onsuccess = function (event) {
                document.querySelector("#disDiv").setAttribute("style", "display: none;");
                console.log("Sikeres frissítés!");
                list();
            };
        };
        
        req.onerror = function(event){
            console.log("Hiba! Nincs meg az elem!");
        };
    };*/
};


var request = window.indexedDB.open("ToDo0", 1);

request.onerror = function (event) {
    console.log("Hiba van!");
};

request.onsuccess = function (event) {
    console.log("DB nyitva!");
    db = event.target.result;
    list();
};

request.onupgradeneeded = function (event) {
    console.log("DB onupgradeneeded!");
    db = event.target.result;
    objectStore = db.createObjectStore("toDoList", {keyPath: "id", autoIncrement: true});
    objectStore.createIndex("name", "name", {unique: false});
};

function clearAll() {
    document.querySelector("ul").setAttribute("style", "display: none;");
    
    document.querySelector("#delAllDiv").setAttribute("style", "display: block;");
    
    document.querySelector("#delAllItem").onclick = function () {
        objectStore = db.transaction("toDoList", "readwrite").objectStore("toDoList");
        var req = objectStore.clear();

        req.onsuccess = function (event) {
            console.log("Kipucolva.");
            document.querySelector("#delAllDiv").setAttribute("style", "display: none;");
            document.querySelector("ul").setAttribute("style", "display: block;");
            list();
        };

        req.onerror = function (event) {
            console.log("Hiba van!");
            console.log(event.target.errorCode);
            document.querySelector("#delAllDiv").setAttribute("style", "display: none;");
            document.querySelector("ul").setAttribute("style", "display: block;");
        };
    };
}

function add() {
    data = {
        name: document.querySelector("#add_item").value,
        checked: false
    };
    if (data.name !== "") {
        document.querySelector("#add_item").value = "";

        objectStore = db.transaction(["toDoList"], "readwrite").objectStore("toDoList");
        var req = objectStore.add(data);

        req.onsuccess = function (event) {
            console.log("Tarolva!");
            list();
        };

        req.onerror = function (event) {
            console.log("Hiba a tárolásnál!");
        };
    }
}

function list() {
    document.querySelector("ul").innerHTML = "";
    objectStore = db.transaction(["toDoList"], "readwrite").objectStore("toDoList");
    var req = objectStore.index("name").openCursor(IDBKeyRange.lowerBound("", true));
    req.onsuccess = function (event) {
        var cursor = event.target.result;
        if (cursor) {
            var li = document.createElement("LI");
            li.setAttribute("aria-disabled", cursor.value["checked"]);
            var p = document.createElement("P");
            var input = document.createElement("INPUT");
            input.setAttribute("type", "checkbox");
            input.setAttribute("itemid", cursor.value["id"]);
            if (cursor.value["checked"]) {
                input.setAttribute("checked", "");    
            }
            p.appendChild(input);
            p.appendChild(document.createTextNode(cursor.value["name"]));
            var button = document.createElement("BUTTON");
            button.setAttribute("data-icon", "delete");
            button.setAttribute("aria-hidden", "true");
            button.setAttribute("style", "float: right;");
            button.setAttribute("itemid", cursor.value["id"]);
            p.appendChild(button);
            li.appendChild(p);
            document.querySelector("ul").appendChild(li);
            input.addEventListener("click", dis);
            button.addEventListener("click", del);

            console.log(cursor.value["id"] + " " + cursor.value["name"] + " " + cursor.value["checked"]);

            cursor.continue();
        } else {
            console.log("Minden felsorolva.");

            var li = document.createElement("LI");
            var p = document.createElement("P");
            p.appendChild(document.createTextNode("Delete all items"));
            p.setAttribute("style", " color: red;");
            var button = document.createElement("BUTTON");
            button.setAttribute("data-icon", "delete");
            button.setAttribute("aria-hidden", "true");
            button.setAttribute("style", "float: right;");
            button.addEventListener("click", clearAll);
            p.appendChild(button);
            li.appendChild(p);
            document.querySelector("ul").appendChild(li);
        }
    };
}

function dis(e) {
    document.querySelector("ul").setAttribute("style", "display: none;");
    
    document.querySelector("#disDiv").setAttribute("style", "display: block;");
    
    document.querySelector("#disItem").onclick = function () {

        //e.target.parentNode.parentNode.setAttribute("aria-disabled", "true");

        objectStore = db.transaction(["toDoList"], "readwrite").objectStore("toDoList");
        var req = objectStore.get(parseInt(e.target.getAttribute("itemid")));

        req.onsuccess = function (event) {

            var data = event.target.result;
            data.checked = true;
            var reqUpdate = objectStore.put(data);

            reqUpdate.onerror = function (event) {
                document.querySelector("#disDiv").setAttribute("style", "display: none;");
                document.querySelector("ul").setAttribute("style", "display: block;");
                console.log("Hiba a frissítésnél!");
            };

            reqUpdate.onsuccess = function (event) {
                document.querySelector("#disDiv").setAttribute("style", "display: none;");
                document.querySelector("ul").setAttribute("style", "display: block;");
                console.log("Sikeres frissítés!");
                list();
            };
        };

        req.onerror = function (event) {
            document.querySelector("#disDiv").setAttribute("style", "display: none;");
            document.querySelector("ul").setAttribute("style", "display: block;");
            console.log("Hiba! Nincs meg az elem!");
        };
    };
}

function del(e) {
    document.querySelector("ul").setAttribute("style", "display: none;");
    
    document.querySelector("#delDiv").setAttribute("style", "display: block;");
    
    document.querySelector("#delItem").onclick = function () {

        objectStore = db.transaction(["toDoList"], "readwrite").objectStore("toDoList");
        var req = objectStore.delete(parseInt(e.target.getAttribute("itemid")));

        req.onsuccess = function (event) {
            console.log("Torolve!");
            document.querySelector("#delDiv").setAttribute("style", "display: none;");
            document.querySelector("ul").setAttribute("style", "display: block;");
            list();
        };

        req.onerror = function (event) {
            console.log("Hiba! Nincs meg az elem!");
            document.querySelector("#delDiv").setAttribute("style", "display: none;");
            document.querySelector("ul").setAttribute("style", "display: block;");
        };
    };
}

function hide(){
    document.querySelector("ul").setAttribute("style", "display: block;");
    
    document.querySelector("#delDiv").setAttribute("style", "display: none;");
    document.querySelector("#disDiv").setAttribute("style", "display: none;");
    document.querySelector("#delAllDiv").setAttribute("style", "display: none;");
    
    list();
}