/*
 *  Shotgun app.
 */

var audioContext;
var gainNode;
var convolverNode;

var loadSoundBuffer;
var loadVibrationSpec;
var shootSoundBuffer;
var shootVibrationSpec;

var lastX = false;
var weaponIndex = 0;
var environmentIndex = 0;

// millisecond delay to get better audio/vibrate sync
// chosen for ZTE Open C
var vibrateDelay = 200;

// Delay for visual flash
var flashDelay = 100;

var weapons = [
	{
		name: 'Shotgun',
		loadSound: 'load.ogg',
		shootSound: 'shotgun.ogg',
		loadVibrate: [ 50, 200, 50 ],
		shootVibrate: [ 350 ],
		bgClass: 'shotgun'
	},
	{
		name: 'Pistol',
		loadSound: 'cock.ogg',
		shootSound: 'pistol.ogg',
		loadVibrate: [ 30, 50, 30, 50, 30, 50, 100 ],
		shootVibrate: [ 200 ],
		bgClass: 'pistol'
	},
	{
		name: 'Silenced pistol',
		loadSound: 'popclip.ogg',
		shootSound: 'silenced.ogg', 
		loadVibrate: [ 30, 100, 50 ],
		shootVibrate: [ 80 ],
		bgClass: 'silenced'
	},
	{
		name: 'AK-47',
		loadSound: 'popclip.ogg',
		shootSound: 'machinegun.ogg',
		loadVibrate: [ 30, 200, 60 ],
		shootVibrate: [ 50, 50, 50, 50, 50, 50, 150 ],
		bgClass: 'ak47'
	},
/* Disabled for now
	{
		name: 'Suomi-konepistooli',
		loadSound: 'popclip.ogg',
		shootSound: 'machinegun.ogg',  // FIXME
		loadVibrate: [ 30, 200, 60 ],
		shootVibrate: [ 100, 50, 100, 50, 100 ],
		bgClass: 'suomikp',
		actionImage: 'vuosalmi1944.jpg'
	},
*/
	{
		name: 'Minigun',
		loadSound: 'popclip.ogg',
		shootSound: 'minigun.ogg',
		loadVibrate: [ 100, 100, 100 ],
		shootVibrate: [
			0, 50, 650, 50,
			40, 40, 40, 40, 40, 40, 40, 40, 40, 40,
			40, 40, 40, 40, 40, 40, 40, 40, 40, 40,
			40, 40, 40, 40, 40, 40, 40, 40, 40, 40,
			40, 40, 40, 40, 40, 40, 40, 40, 40, 40,
			40, 40, 40, 40, 40, 40, 40, 40, 40, 40,
			40, 40,
			40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40 ],
		bgClass: 'minigun'
	}
];

var environments = [
	{
		name: 'Normal',
		irFile: null
	},
	{
		name: 'Koli Forest Summer',
		irFile: 'koli_summer_site1_1way_mono.ogg'
	}
];

function loadBuffer(uri, callback) {
	var request = new XMLHttpRequest();
	request.open('GET', uri, true);
	request.responseType = 'arraybuffer';
	request.onload = function () {
		audioContext.decodeAudioData(request.response, function (buffer) {
			console.log('buffer ' + uri + ':', buffer.sampleRate, buffer.length, buffer.duration, buffer.numberOfChannels);
			callback(buffer);
		}, function () {
			alert('audio decode failed');
		});
	};
	request.send();
}

function createTestConvolverBuffer() {
	var bufLen = audioContext.sampleRate * 10;  // 10 secs
	var buf = audioContext.createBuffer(2 /*channels*/, bufLen /*length*/, audioContext.sampleRate);
	var data = buf.getChannelData(0);
	var i;

	console.log('createTestConvolverBuffer', bufLen, buf);

	data[0] = 1.0;
	data[audioContext.sampleRate] = 0.75;
	data[audioContext.sampleRate * 2] = 0.65;
	data[audioContext.sampleRate * 3] = 0.45;
	data[audioContext.sampleRate * 4] = 0.35;
	data[audioContext.sampleRate * 5] = 0.25;
	data[audioContext.sampleRate * 6] = 0.20;
	data[audioContext.sampleRate * 7] = 0.15;
	data[audioContext.sampleRate * 8] = 0.10;
	data[audioContext.sampleRate * 9] = 0.05;

	return buf;
}

function convertBufferToStereoBuffer(buffer) {
	var bufLen = buffer.length;
	var buf = audioContext.createBuffer(2 /*channels*/, bufLen /*length*/, buffer.sampleRate);
	var dataIn, dataOut;
	var channel;
	var i, n;

	for (channel = 0; channel < 2; channel++) {
		dataIn = buffer.getChannelData(0);  // copy channel 0
		dataOut = buf.getChannelData(channel);
		for (i = 0; i < bufLen; i++) {
			dataOut[i] = dataIn[i];
		}
	}

	return buf;
}

/* Lenient disconnector helper */
function disconnectNode(node) {
	if (!node) {
		console.log('disconnectNode: node is null');
		return;
	}
	try {
		console.log('disconnectNode: trying to disconnect ' + node);
		node.disconnect(0);
	} catch (e) {
		alert(e);
	}
}

function dumpAudioNode(node, name) {
	if (!node) {
		console.log(name + ': null');
		return;
	}
	console.log(name + ':', node, node.numberOfInputs, node.numberOfOutputs, node.channelCount, node.channelCountMode);
}

function dumpAudioChain(name, source) {
	console.log(name + ': ' + source + ' ' + convolverNode + ' ' + gainNode + ' ' + audioContext.destination + ' ' +
		audioContext.sampleRate + ' --> ' +
		(source ? source.numberOfInputs : '?') + ':' + (source ? source.numberOfOutputs : '?') + ' ' +
		(convolverNode ? convolverNode.numberOfInputs : '?') + ':' + (convolverNode ? convolverNode.numberOfOutputs : '?') + '-' +
		(convolverNode && convolverNode.buffer ? convolverNode.buffer.sampleRate : '?') + ' ' +
		(gainNode ? gainNode.numberOfInputs : '?') + ':' + (gainNode ? gainNode.numberOfOutputs : '?') + ' ' +
		audioContext.destination.numberOfInputs + ':' + audioContext.destination.numberOfOutputs);

	if (convolverNode && convolverNode.buffer) {
		var buf = convolverNode.buffer.getChannelData(0);
		console.log(buf, buf.length);
	}

	dumpAudioNode(source, 'source');
	dumpAudioNode(convolverNode, 'convolver');
	dumpAudioNode(gainNode, 'gain');
	dumpAudioNode(audioContext.destination, 'destination');
}

function rewireAudio() {
	/*
	 *  [source] -> [gain] -> [convolver] -> [audiocontext]
	 */

	dumpAudioChain('rewire-1');

	disconnectNode(gainNode);
	disconnectNode(convolverNode);

	dumpAudioChain('rewire-2');

	if (convolverNode) {
		console.log('rewire gain -> convolver -> destination');
		gainNode.connect(convolverNode);
		convolverNode.connect(audioContext.destination);
		gainNode.gain.value = 1.0;
	} else {
		console.log('rewire gain -> destination');
		gainNode.connect(audioContext.destination);
		gainNode.gain.value = 1.0;
	}

	dumpAudioChain('rewire-3');
}

function setEnvironment(idx) {
	var e = environments[idx % environments.length];
	if (!e) { return; }

	if (!e.irFile) {
		disconnectNode(convolverNode);
		convolverNode = null;
		rewireAudio();
		dumpAudioChain('rewire-noconv');
		return;
	}

	loadBuffer(e.irFile, function (buffer) {
		disconnectNode(convolverNode);
		convolverNode = audioContext.createConvolver();
		convolverNode.normalize = true;

		/* Note: it's critical to match the channel count of audioContext.destination.
		 * At least on concrete testing, a mono convolution buffer will cause silence
		 * to come out of the convolution.
		 */
		//convolverNode.buffer = buffer;
		convolverNode.buffer = createTestConvolverBuffer();
		//convolverNode.buffer = convertBufferToStereoBuffer(buffer);  /* NOTE: resampled to AudioContext sampleRate automatically */
		rewireAudio();
		dumpAudioChain('rewire-conv');
	});
}

function setWeapon(idx) {
	var w = weapons[idx % weapons.length];
	if (!w) { return; }

	var body = document.getElementById('body');
	var weaponName = document.getElementById('weapon-name');
	body.className = 'loading';
	weaponName.innerHTML = '';
	weaponName.className = 'loading';

	loadVibrationSpec = w.loadVibrate;
	shootVibrationSpec = w.shootVibrate;

	loadSoundBuffer = null;
	shootSoundBuffer = null;

	function checkChangeComplete() {
		if (loadSoundBuffer && shootSoundBuffer) {
			body.className = w.bgClass;
			weaponName.innerHTML = w.name;
			weaponName.className = '';
		}
	}

	loadBuffer(w.loadSound, function (buffer) {
		loadSoundBuffer = buffer;
		checkChangeComplete();
	});
	loadBuffer(w.shootSound, function (buffer) {
		shootSoundBuffer = buffer;
		checkChangeComplete();
	});
}

function playSoundRaw(buffer) {
	var source;
	if (!audioContext) {
		return;
	}
	if (!buffer) {
		return;
	}
	source = audioContext.createBufferSource();
	source.buffer = buffer;
	source.connect(gainNode);
	//source.connect(audioContext.destination);
	//source.connect(convolverNode || gainNode);
	dumpAudioChain('bang', source);
	source.start(0);
}
function playSound(buffer) {
	try {
		playSoundRaw(buffer);
	} catch (e) {
		alert(e);
	}
}

function vibrateRaw(spec) {
	if (typeof navigator.vibrate !== 'function') {
		return;
	}
	setTimeout(function () {
		navigator.vibrate(spec);
	}, vibrateDelay);
}

function handleLoadGun() {
	if (loadSoundBuffer) {
		playSoundRaw(loadSoundBuffer);
	}
	if (loadVibrationSpec) {
		vibrateRaw(loadVibrationSpec);
	}
}

function handleShootGun() {
	var elem;

	if (shootSoundBuffer) {
		playSoundRaw(shootSoundBuffer);
	}
	if (shootVibrationSpec) {
		vibrateRaw(shootVibrationSpec);
	}

	elem = document.getElementById('content');
	setTimeout(function () {
		elem.classList.add('flash');
		setTimeout(function () {
			elem.classList.remove('flash');
		}, 100);
	}, flashDelay);
}

function handleMotionRaw(ev) {
	var acceleration = ev.acceleration;
	var accelerationIncludingGravity = ev.accelerationIncludingGravity;
	var rotationRate = ev.rotationRate;
	var interval = ev.interval;
	var x, y, z, veclen;
	var absx, absy, absz;
	var major;

	// acceleration is null on ZTE Open C

	x = y = z = 0.0;
	if (accelerationIncludingGravity) {
		x = accelerationIncludingGravity.x || 0.0;
		y = accelerationIncludingGravity.y || 0.0;
		z = accelerationIncludingGravity.z || 0.0;
	}
	veclen = Math.sqrt(x*x + y*y + z*z);
	absx = Math.abs(x) / veclen;
	absy = Math.abs(y) / veclen;
	absz = Math.abs(z) / veclen;

	if (absz > 0.5) {
		// XXX: help anim
	} else if (absx > 0.75) {
		if (!lastX) {
			handleLoadGun();
		}
		lastX = true;
	} else {
		if (lastX) {
			handleShootGun();
		}
		lastX = false;
	}
}
function handleMotion(ev) {
	try {
		handleMotionRaw(ev);
	} catch (e) {
		alert(e);
	}
}

function goFullScreenRaw() {
	var e = document.documentElement;
	if (e.requestFullScreen) {
		e.requestFullScreen();
	} else if (e.mozRequestFullScreen) {
		e.mozRequestFullScreen();
	}
}
function goFullScreen() {
	try {
		goFullScreenRaw();
	} catch (e) {
		alert(e);
	}
}

function lockToPortraitRaw() {
	if (window.screen && window.screen.lockOrientation) {
		var allowed = window.screen.lockOrientation('portrait-primary');
		//alert('orientation lock allowed: ' + allowed);
	} else if (window.screen && window.screen.mozLockOrientation) {
		var allowed = window.screen.mozLockOrientation('portrait-primary');
		//alert('orientation lock allowed: ' + allowed);
	}
}
function lockToPortrait() {
	try {
		lockToPortraitRaw();
	} catch (e) {
		alert(e);
	}
}

function initAudioRaw() {
	// http://www.html5rocks.com/en/tutorials/webaudio/intro/
	// http://stackoverflow.com/questions/17988630/audiocontext-of-web-audio-api-is-not-exist-in-chrome-beta-29-of-android-4-0-tabl

	var audioCtxConstructor =
		this.AudioContext ||
		this.webkitAudioContext ||
		this.mozAudioContext ||
		this.oAudioContext ||
		this.msAudioContext;
	if (!audioCtxConstructor) {
		alert('No Audio API support, audio disabled.');
		return;
	}
	audioContext = new audioCtxConstructor();

	gainNode = audioContext.createGain();
	gainNode.gain.value = 1.0;

	convolverNode = null;

	// Load first weapon only when audioContext has been created
	setWeapon(weaponIndex);
	setEnvironment(environmentIndex);
}
function initAudio() {
	try {
		initAudioRaw();
	} catch (e) {
		alert(e);
	}
}

function initRaw() {
	var e;

	e = document.getElementById('body');
	e.addEventListener('click', function (event) {
		try {
			event.stopPropagation();
			handleShootGun();
		} catch (e) {
			alert(e);
		}
	}, false);

	e = document.getElementById('about-button');
	e.addEventListener('click', function (event) {
		var aboutText = document.getElementById('about-text');
		event.stopPropagation();
		if (aboutText.className == 'show') {
			aboutText.className = '';
		} else {
			aboutText.className = 'show';
		}
	}, false);

	e = document.getElementById('weapon-button');
	e.addEventListener('click', function (event) {
		try {
			event.stopPropagation();
			setWeapon(++weaponIndex);
		} catch (e) {
			alert(e);
		}
	}, false);

/* Disabled for now
	e = document.getElementById('env-button');
	e.addEventListener('click', function (event) {
		try {
			event.stopPropagation();
			setEnvironment(++environmentIndex);
		} catch (e) {
			alert(e);
		}
	}, false);
*/

	//window.addEventListener('devicemotion', handleMotion, true);
	window.ondevicemotion = handleMotion;

	setTimeout(initAudio, 10);
	setTimeout(goFullScreen, 20);

	// For some reason this must be called some time after loading,
	// at least on ZTE Open C
	setTimeout(lockToPortrait, 200);
}

window.onload = function () {
	try {
		initRaw();
	} catch (e) {
		alert(e);
	}
};
