/* Generated by SharpKit 5 v5.4.7 */
if (typeof($CreateDelegate)=='undefined'){
    if(typeof($iKey)=='undefined') var $iKey = 0;
    if(typeof($pKey)=='undefined') var $pKey = String.fromCharCode(1);
    var $CreateDelegate = function(target, func){
        if (target == null || func == null) 
            return func;
        if(func.target==target && func.func==func)
            return func;
        if (target.$delegateCache == null)
            target.$delegateCache = {};
        if (func.$key == null)
            func.$key = $pKey + String(++$iKey);
        var delegate;
        if(target.$delegateCache!=null)
            delegate = target.$delegateCache[func.$key];
        if (delegate == null){
            delegate = function(){
                return func.apply(target, arguments);
            };
            delegate.func = func;
            delegate.target = target;
            delegate.isDelegate = true;
            if(target.$delegateCache!=null)
                target.$delegateCache[func.$key] = delegate;
        }
        return delegate;
    }
}


var openAddButton = null;
var addName = null;
var addKey = null;
var addDialog = null;
var list = null;
var scanner = null;
var video = null;
var canvas = null;
var ctx = null;
var decodeWorker = null;
function InitAddKey(){
    openAddButton = document.getElementById("addButton");
    openAddButton.onclick = ToggleAddKeyDialog;
    list = document.getElementById("list");
    addDialog = document.getElementById("dialogAdd");
    addName = document.getElementById("name");
    addKey = document.getElementById("key");
    document.getElementById("addForm").onsubmit = Submit;
    scanner = document.getElementById("scanner");
    video = document.getElementById("video");
};
function ToggleAddKeyDialog(evt){
    if (addDialog.hidden){
        addDialog.hidden = false;
        list.hidden = true;
        openAddButton.setAttribute("data-icon", "close");
        OpenDialog();
    }
    else {
        addDialog.hidden = true;
        list.hidden = false;
        openAddButton.setAttribute("data-icon", "add");
        CloseDialog();
    }
};
function OpenDialog(){
    addName.scrollIntoView();
    addName.focus();
    BlockPasswordReset = true;
    try{
        cordova.plugins.barcodeScanner.scan(ScanSuccess, ScanFailure);
    }
    catch($$e1){
    }
    BlockPasswordReset = false;
    try{
        scanner.hidden = true;
        canvas = document.createElement('canvas');
        ctx = canvas.getContext("2d");
        navigator.mozGetUserMedia({
            video: true,
            audio: false
        }, GotMedia, FailedMedia);
        scanner.hidden = false;
    }
    catch(ex){
    }
};
function CloseDialog(){
    ctx = null;
    StopDecoding();
    addDialog.hidden = true;
    addName.value = "";
    addKey.value = "";
    BlockPasswordReset = false;
};
function StopDecoding(){
    scanner.hidden = true;
    video.pause();
    video.mozSrcObject = null;
    if (decodeWorker != null){
        decodeWorker.terminate();
        decodeWorker = null;
    }
};
function GotMedia(stream){
    video.mozSrcObject = stream;
    video.play();
    DecodeQR();
};
function DecodeQR(){
    if (decodeWorker == null){
        decodeWorker = new Worker("js/decoder.js");
        decodeWorker.onmessage = ReceivedQR;
    }
    DrawVideo();
};
function DrawVideo(){
    try{
         
                ctx.drawImage(video, 0, 0, canvas.width, canvas.height);
                decodeWorker.postMessage({
                    imageData: ctx.getImageData(0, 0, canvas.width, canvas.height).data,
                    width: canvas.width,
                    height: canvas.height
                });
    }
    catch(e){
        if (e.name == "NS_ERROR_NOT_AVAILABLE"){
            setTimeout(DrawVideo, 0);
        }
        else {
            throw e;
        }
    }
};
function ReceivedQR(evt){
    var data = evt.data;
    if (!data.success){
        DecodeQR();
        return;
    }
    ParseQRData(data.result[0][2]);
    StopDecoding();
};
function FailedMedia(arg){
    alert(arg);
};
function ScanSuccess(result){
    if (result.cancelled){
        return;
    }
    ParseQRData(result.text);
};
function ParseQRData(text){
    if (text.indexOf("otpauth://totp/") != 0){
        alert("Sorry, we only support TOTP: " + text);
        return;
    }
    var sep = text.indexOf("?", 15);
    if (sep > 0)
        addName.value = decodeURIComponent(text.substring(15, sep));
    else
        return;
    var secret = GetVar(text, "secret");
    if (secret != null)
        addKey.value = secret;
};
function GetVar(url, keyName){
    var start = url.indexOf("?");
    var key = url.indexOf(keyName + "=", start);
    if (key < 0)
        return null;
    var next = url.indexOf("&", key);
    if (next < 0)
        return url.substring(key + keyName.length + 1);
    else
        return url.substring(key + keyName.length + 1, next);
};
function ScanFailure(error){
    alert(error);
};
function Submit(evt){
    evt.preventDefault();
    try{
        var val = addKey.value;
        val = val.toUpperCase();
        val = val.trim().replace(new RegExp("[^ABCDEFGHIJKLMNOPQRSTUVWXYZ234567]"), "");
        if (val.length < 16)
            throw new Error("Key must be at least 16 valid characters or numbers");
        Add(addName.value, Base32ToHex(val));
    }
    catch(e){
        alert(e.message);
        addKey.focus();
        return;
    }
    ToggleAddKeyDialog(null);
};
var password = null;
var lastT = 0;
var step = 30;
var lastLast = false;
var BlockPasswordReset = false;
document.addEventListener("deviceready", CordovaReady, false);
window.onload = Loaded;
window.onerror = OnError;
function CordovaReady(evt){
    document.addEventListener("pause", PasswordReset, false);
};
function Loaded(evt){
    document.addEventListener("visibilitychange", PasswordReset);
    password = document.getElementById("password");
    password.oninput = PasswordChanged;
    PasswordChanged(null);
    document.getElementById("lockPassword").onclick = PasswordReset;
    document.getElementById("passwordForm").onsubmit = LeavePassword;
    password.focus();
    InitAddKey();
    Load();
    InitOtpList();
    setInterval(AnimateProgress, 200);
    MakeExternal(document.getElementById("license"));
};
function AnimateProgress(){
    var seconds = new Date().getTime() / 1000;
    var t = Math.floor(seconds / 30);
    if (t != lastT)
        UpdateList();
    lastT = t;
    var op = (seconds % 30) / 30;
    var late = op > 0.8;
    var changeLate = late != lastLast;
    lastLast = late;
    for (var $i2 = 0,$t2 = document.getElementsByClassName("tindicator"),$l2 = $t2.length,el = $t2[$i2]; $i2 < $l2; $i2++, el = $t2[$i2]){
        el.value = op;
        if (changeLate){
            if (late)
                el.classList.add("late");
            else
                el.classList.remove("late");
        }
    }
};
function PasswordReset(evt){
    if (evt != null)
        evt.preventDefault();
    if (BlockPasswordReset)
        return;
    password.value = "";
    PasswordChanged(null);
    password.focus();
};
function PasswordChanged(evt){
    var pw = password.value.trim();
    document.getElementById("lockPassword").setAttribute("data-icon", pw == "" ? "lock" : "unlock");
    SetMasterPassword(pw);
    UpdateList();
    var sha = new jsSHA(pw, "TEXT");
    var masterHash = sha.getHash("SHA-1", "HEX");
    password.style.borderBottomColor = "#" + masterHash.substr(0, 3);
};
function LeavePassword(evt){
    evt.preventDefault();
    password.disabled = true;
    setTimeout(function (){
        password.disabled = false;
    }, 100);
};
var Base32chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZ234567";
function Base32ToHex(base32){
    base32 = base32.toUpperCase();
    var bits = "";
    for (var i = 0; i < base32.length; i++){
        var val = "ABCDEFGHIJKLMNOPQRSTUVWXYZ234567".indexOf(base32.charAt(i));
        if (val < 0)
            throw new Error("Invalid Base32 character: " + base32.charAt(i));
        bits += Pad(val.toString(2), 5);
    }
    var hex = "";
    for (var i = 0; i + 4 <= bits.length; i += 4){
        var chunk = bits.substr(i, 4);
        hex += parseInt(chunk, 2).toString(16);
    }
    return hex;
};
function Pad(str, len){
    if (len <= str.length)
        return str;
    return new Array(len - str.length + 1).join("0") + str;
};
function OnError(message, url, line){
    alert(message + "\n" + line + ": " + url);
};
function MakeExternal(element){
    for (var $i3 = 0,$t3 = element.getElementsByTagName("a"),$l3 = $t3.length,el = $t3[$i3]; $i3 < $l3; $i3++, el = $t3[$i3]){
        el.onclick = OpenExternally;
    }
};
function OpenExternally(evt){
    evt.preventDefault();
    var a = evt.target;
    try{
         new MozActivity({
                name: "view",
                data: {
                    type: "url",
                    url: a.href
                }
            });
    }
    catch($$e2){
        window.open(a.href, "_system");
    }
};
var listElement = null;
var widgets =  [];
function InitOtpList(){
    listElement = document.getElementById("list");
    for (var $i4 = 0,$l4 = Keys.length,totp = Keys[$i4]; $i4 < $l4; $i4++, totp = Keys[$i4])
        AddWidget(totp);
    UpdateList();
};
function AddWidget(totp){
    if (totp == null)
        return;
    var w = new SilentOrbit.TotpWidget(totp);
    listElement.appendChild(w.Element);
    widgets.push(w);
    UpdateList();
};
function UpdateList(){
    var time = Math.floor(new Date().getTime() / 30000);
    var timeHex1 = Pad(time.toString(16), 16);
    var timeHex2 = Pad((time + 1).toString(16), 16);
    var hmac1 = new jsSHA(timeHex1, "HEX");
    var hmac2 = new jsSHA(timeHex2, "HEX");
    for (var $i5 = 0,$l5 = widgets.length,w = widgets[$i5]; $i5 < $l5; $i5++, w = widgets[$i5]){
        w.Update(hmac1, hmac2);
    }
};
var Keys = null;
function Load(){
    try{
        Keys = (JSON.parse(localStorage["keys"]) != null ? JSON.parse(localStorage["keys"]) :  []);
    }
    catch($$e3){
        Keys =  [];
    }
};
function Save(){
    try{
        localStorage["keys"] = JSON.stringify(Keys);
    }
    catch($$e4){
        alert("Sorry, I was unable to save your key");
    }
};
function Add(name, hexKey){
    var totp = new SilentOrbit.TOTP();
    totp.Name = name;
    totp.Key = XorHex(hexKey);
    var test = XorHex(totp.Key);
    if (test != hexKey)
        throw new Error("Xor failed");
    Keys.push(totp);
    Save();
    AddWidget(totp);
};
function Delete(totp){
    var index = Keys.indexOf(totp);
    if (index < 0)
        return;
    delete Keys[index];
    Save();
};
if (typeof(SilentOrbit) == "undefined")
    var SilentOrbit = {};
SilentOrbit.TOTP = function (){
    this.Name = null;
    this.Key = null;
};
SilentOrbit.TotpWidget = function (totp){
    this.totp = null;
    this.nameElement = null;
    this.currentOtpElement = null;
    this.nextOtpElement = null;
    this.Element = null;
    this.totp = totp;
    this.Element = document.getElementById("template").cloneNode(true);
    this.Element.removeAttribute("id");
    this.nameElement = this.Element.querySelector(".name");
    this.nameElement.textContent = totp.Name;
    this.currentOtpElement = this.Element.querySelector(".currentOtp");
    this.nextOtpElement = this.Element.querySelector(".nextOtp");
    this.Element.querySelector(".delete").onclick = $CreateDelegate(this, this.Delete);
    this.nameElement.onclick = $CreateDelegate(this, this.ChangeName);
};
SilentOrbit.TotpWidget.prototype.Update = function (hmacObj1, hmacObj2){
    if (this.totp.Key.length % 2 == 1)
        this.totp.Key = "0" + this.totp.Key;
    var key = XorHex(this.totp.Key);
    this.currentOtpElement.textContent = SilentOrbit.TotpWidget.GetOTP(hmacObj1, key);
    this.nextOtpElement.textContent = SilentOrbit.TotpWidget.GetOTP(hmacObj2, key);
};
SilentOrbit.TotpWidget.GetOTP = function (hmacObj, key){
    var hmac = hmacObj.getHMAC(key, "HEX", "SHA-1", "HEX");
    var offset1 = parseInt(hmac.substring(hmac.length - 1), 16);
    var otp = "" + (parseInt(hmac.substr(offset1 * 2, 8), 16) & 2147483647);
    otp = otp.substr(otp.length - 6, 6);
    return otp.substr(0, 2) + " " + otp.substr(2, 2) + " " + otp.substr(4, 2);
};
SilentOrbit.TotpWidget.prototype.ChangeName = function (evt){
    var name = prompt("Change name", this.totp.Name);
    if (name == null)
        return;
    this.totp.Name = name.trim();
    Save();
    this.nameElement.textContent = this.totp.Name;
};
SilentOrbit.TotpWidget.prototype.Delete = function (evt){
    evt.cancelBubble = true;
    var name = prompt("Remove the name to delete the key", this.totp.Name);
    if (name == null)
        return;
    if (name == ""){
        Delete(this.totp);
        this.Element.parentNode.removeChild(this.Element);
    }
};
var masterHash = "";
function SetMasterPassword(password){
    var sha = new jsSHA(password, "TEXT");
    masterHash = sha.getHash("SHA-1", "HEX");
};
function XorHex(key){
    if (key.length > masterHash.length)
        throw new Error("Password Hash too short");
    var xor = "";
    var chunk = 4;
    for (var i = 0; i < key.length; i += chunk){
        var length = key.length - i;
        if (length > chunk)
            length = chunk;
        var a = parseInt(key.substr(i, length), 16);
        var b = parseInt(masterHash.substr(i, length), 16);
        xor += Pad((a ^ b).toString(16), length);
    }
    return xor;
};

