"use strict";
(function(){
	$("#btn_start").click(function(e){
	 		game.start();
			$(this).hide();
	 });
	var getMaxResults = function(){
		var max_result = localStorage["max_results"] ;
		if(!max_result ||	max_result === "")
			max_result = 0;
		$("#result").html(max_result);
	};
	var Game = function(){
		this.arr_secuence = [];
		this.n_secuence = 0;
		this.isStart = 0;
		this.is_play_secuence = false;
		$("#b0").click(this.click_element);	
		$("#b1").click(this.click_element);
		$("#b2").click(this.click_element);
		$("#b3").click(this.click_element);
	}
	Game.prototype = {
		start:function(){
			this.isStart = 1;
			this.n_secuence = 0;
			this.is_play_secuence = false; 
			this.next();
			

		},
		stop:function(){
			this.isStart = 0;
			this.arr_secuence = [];
			this.n_secuence = 0;
		},
		click_element:function(e){
			if(game.isStart == 1 && !game.is_play_secuence){
				var n_el = (this.id).substring(1);
				game.play(this,"s"+n_el,function(){
					game.validation(n_el); 
				});
			}
		},
		generate_random:function(){
			return Math.floor(Math.random()*4)
		},
		play_secuence:function(){
			this.is_play_secuence = true;
			console.log(this.arr_secuence);
			var self = this;
			var counter = 0;
			var play_next = function(counter,callback){
				console.log("counter:"+counter+" length secuence"+self.arr_secuence.length);
				if(counter >= self.arr_secuence.length){
					console.log("entrer?")
					return callback();
				}	
				var n = self.arr_secuence[counter];
				var el = document.getElementById("b"+n);
				self.play(el,"s"+n,function(){
					console.log("next animation");
					counter++;
					play_next(counter,callback);			
				});
			}

			play_next(counter,function(){
				self.is_play_secuence = false;
			 	console.log("end secuence");
			});

		},
		validation:function(n_press){
			n_press = parseInt(n_press, 10);
			
			console.log("press:"+n_press)
			var number = this.arr_secuence[this.n_secuence];
			console.log("number secuence:"+number);
			if(number === n_press){

				this.n_secuence++;
				console.log("number secuence: "+this.n_secuence+" secuence length"+this.arr_secuence.length);
				if(this.n_secuence >= this.arr_secuence.length) {
					
					this.next();
				}
				 
					
			}else{
				this.finish();
			}
		},
		next:function(){

			console.log("next");
			this.n_secuence = 0 ;
			this.arr_secuence.push(this.generate_random());
			$("#level").html(this.arr_secuence.length);
			this.play_secuence();
		},

		play:function(el,sound,callback){
			this.animation(el,callback);
			this.sound(sound);
		},
		animation:function(el,callback){
			var anim = Animate();
			anim.start(el,callback);
		},
		sound:function(sound){
			var sound = document.getElementById(sound);
			sound.play();
		},
		reset:function(){
			this.arr_secuence = [];
			this.n_secuence = 0;
			this.isStart = 0;
			$("#level").html("0");
		},
		finish:function(){
			var max_score = parseInt(localStorage["max_results"]);
			if(!max_score ||	max_score === "" ||	max_score === NaN)
				max_score = 0;
			if(max_score < this.arr_secuence.length){
				max_score = localStorage["max_results"] = this.arr_secuence.length;
			}
        	$("#result").html(max_score);
			this.reset();
			$("#btn_start").show();
			 
		}

	};

	var game = new Game();
	

	var Animate = function(){
		var type_animation = "flip";
		var startAnim = function($el,x,callback) {
			$el.removeClass(x + ' animated').addClass(x + ' animated');
			var wait = window.setTimeout( function(){
				$el.removeClass(x + ' animated');
				//Wait the class is removed
				setTimeout(function(){
					callback();
				},500);
			},1000);
		};
		var start = function(el,callback){
			var $el = $(el);
			startAnim($el,type_animation,callback);
		};
		return {start:start};
	}

	getMaxResults(); 
	
})();

if (!Array.prototype.forEach) {
	    Array.prototype.forEach = function (fn, scope) {
	        'use strict';
	        var i, len;
	        for (i = 0, len = this.length; i < len; ++i) {
	            if (i in this) {
	                fn.call(scope, this[i], i, this);
	            }
	        }
	    };
	}