//containers
var container         = document.getElementById('container');
var message           = document.getElementById('message');
var restart           = document.getElementById('restart');
//fields
var score             = document.getElementById('score');
var counter_current   = document.getElementById('counter_current');
var counter_total     = document.getElementById('counter_total');
var first             = document.getElementById('first');
var second            = document.getElementById('second');
var sign              = document.getElementById('sign');
var answer            = document.getElementById('answer');
var correct           = null;
//special
var counter_          = parseInt(counter_current.value);
var limit_            = parseInt(counter_total.value); 
//audio
var sound_correct     = document.getElementById('sound_correct');
//messages
var message_correct   = document.getElementById('message_correct');
var message_incorrect = document.getElementById('message_incorrect');

//opening the app...
window.onload = function() { 
	score.value           = 0;
	first.value           = firstNumber();
	second.value          = secondNumber();
	sign.value            = operatorSign();
	counter_current.value = 0;
}

//get first number
function firstNumber(){
	return Math.round(Math.random()*(10)+1);
}

//get second number
function secondNumber(){
	return Math.round(Math.random()*(10)+1);
}

//get operator
function operatorSign(){
	return '+';
}

//place value
function placeValue(number){
	answer.value = answer.value + number;
	return false;
}

//clear field
function clearAnswer(){
	answer.value = null;
	return false;
}

//correct answer
function correctAnswer(){
	switch( sign.value ){
		default:
		case '+':
			correct = parseInt(first.value) + parseInt(second.value);
		break;
	}
	return correct;
}

//user's answer
function usersAnswer(){
	usersanwer = answer.value;
	return usersanwer;
}

//check result
function checkAnswer(){
	//alert(usersAnswer() + correctAnswer());
	//when user's answer exist
	if( usersAnswer() ){
		//when user's answer is correct
		if( usersAnswer() == correctAnswer() ){
			sound_correct.play();
			score.value++;
			correctMessage();
			//new operation
			answer.value = null;
			first.value  = firstNumber();
			second.value = secondNumber();
			scoreColor();
		}
		//when user's answer is incorrect
		else{
			navigator.vibrate(1000);
			//score.value--;
			incorrectMessage();
			//new operation
			answer.value = null;
			first.value  = firstNumber();
			second.value = secondNumber();
			scoreColor();
		}
		//increment counter
		counter_++;
		counter_current.value = counter_;
		//alert(counter_);
		//only when we're under the limit
		if( counter_ == limit_ ){
			finalScore();
		}
	}
	//when user's answer is empty
	else{
		navigator.vibrate(1000);
		alert('Please, type your answer.');
	}
	return false;
}

function finalScore(){
	//sleep(5000);
	//switch containers
	container.style.display = 'none';
	message.style.display = 'none';
	restart.style.display = 'block';
	//display score
	alert('Your score is: ' + score.value);
	return false;
}

//start again button
function startAgain(){
	window.location = 'index.html';
	return false;
}

//score color
function scoreColor(){
	if( score.value < 1 ){
		score.style.color = '#ff0000';
	}else{
		score.style.color = '#2D89EF';
	}
	return false;
}

//display correct text message
function correctMessage(){
	message_incorrect.style.display = 'none';
	message_correct.style.display = 'inline-block';
	setTimeout("hideMessages()", 2000);
	return false;
}

//display incorrect text message
function incorrectMessage(){
	message_correct.style.display = 'none';
	message_incorrect.style.display = 'inline-block';
	setTimeout("hideMessages()", 2000);
	return false;
}

//hide all text message
function hideMessages(){
	message_correct.style.display = 'none';
	message_incorrect.style.display = 'none';
	return false;
}