/*
 * Package:     FoxWork
 * Name: 	G11n
 * Author:	K@mil
 *
 * Thanks:
 *		Zepto			http://zeptojs.org
 *		Globalize		https://github.com/jquery/globalize
 */

define(['globalize', 'zepto'], function(){
    var aLocaleList = ["en"];
    var sLanguage = "en";
    var oConfig = {
        baseUrl: "",
        localeDir: "/l10n/",
        attrName: "data-l10n"
    }

    function getLocaleFromISO(iso) {
        return iso.substring(0,2);
    }
    function loadLocaleFile(locale) {
        var filename = oConfig.baseUrl + oConfig.localeDir + getLocaleFromISO(locale) + ".json";
        // alert(filename);

        $.ajax({
            async: false,
            global: false,
            url: filename,
            dataType: 'json',
            success: function(data) {
                Globalize.addCultureInfo(locale, {
                    messages: data
                });
            }
        })
        // $.getJSON(filename, function(data) {

            // Globalize.addCultureInfo(locale, {
                // messages: data
            // });
        // });
    }

    return {
        init: function(config) {
            oConfig.baseUrl = location.href.split("/");
            oConfig.baseUrl.splice(-1,1);
            oConfig.baseUrl = oConfig.baseUrl. join("/");
            if (config) {
                if (config.localeDir) oConfig.localeDir = config.localeDir;
                if (config.attrName) oConfig.attrName = config.attrName;
                if (config.locales) this.addLocales(config.locales);
                if (config.lang) this.lang(config.lang);
            }
            // if (sLanguage == "en") loadLocaleFile(sLanguage);
            // alert(Globalize.culture());
            // alert(Globalize.localize("history"));
        },

        addLocales: function(list) {
            if ($.isArray(list)) {
                $.each(list, function(index, item) {
                    if ($.inArray(item, aLocaleList) == -1) {
                        aLocaleList.push(item);
                    }
                });
            } else {
                if ($.inArray(item, aLocaleList) == -1) {
                    aLocaleList.push(list);
                    return true;
                } else return false;
            }
        },
        getLocales: function() {
            return aLocaleList;
        },
        removeLocales: function(list) {
            if ($.isArray(list)) {
                $.each(list, function(index, item) {
                    if ($.inArray(item, aLocaleList) != -1) {
                        aLocaleList.splice($.inArray(item, aLocaleList), 1);
                    }
                });
            } else {
                if ($.inArray(item, aLocaleList) != -1) {
                    aLocaleList.splice($.inArray(item, aLocaleList), 1);
                    return true;
                } else return false;
            }
        },

        lang: function(locale) {
            locale = getLocaleFromISO(locale);
            if (!locale) {
                return sLanguage;
            } else if ($.inArray(locale, aLocaleList) != -1) {
                sLanguage = locale;
                loadLocaleFile(sLanguage);
                Globalize.culture(sLanguage);
                return true;
            } else {
                loadLocaleFile(sLanguage);
                Globalize.culture(sLanguage);
                return false;
            }
        },

        localizeDOM: function(conf) {
            conf = conf || {};
            if (!conf.attr) conf.attr = oConfig.attrName;
            if (!conf.objects) conf.objects = $("["+conf.attr+"]");
            var attrid;
            $.each(conf.objects, function(index, item) {
                if (Globalize.culture().messages[$(item).attr(conf.attr)]) {
                    $(item).text(Globalize.localize($(item).attr(conf.attr)));
                }
            });
        },

        // Globalize.js function aliases
        addCultureInfo: function(cultureName, extendCultureName, info) {
            return Globalize.addCultureInfo(cultureName, extendCultureName, info);
        },
        cultures: function() {
            return Globalize.cultures;
        },
        culture: function(selector) {
            return Globalize.culture(selector);
        },
        findClosestCulture: function(selector) {
            return Globalize.findClosestCulture(selector);
        },
        format: function(value, format, culture) {
            return Globalize.format(value, format, culture);
        },
        localize: function(key, culture) {
            return Globalize.localize(key, culture);
        },
        parseInt: function(value, radix, culture) {
            return Globalize.parseInt(value, radix, culture);
        },
        parseFloat: function(value, radix, culture) {
            return Globalize.parseFloat(value, radix, culture);
        },
        parseDate: function(value, formats, culture) {
            return Globalize.parseDate(value, formats, culture);
        }
    }
})
