/*
 * Package:     FoxWork
 * Name: 	ViewManager
 * Author:	K@mil
 *
 * Thanks:
 *		Zepto			http://zeptojs.org
 */

define(['zepto'], function(){
    var sCurrentPage = "index";
    var aPages = [];
    var sCurrentPrompt;
    var aPrompts = [];
    var oConfig = {

    }

    return {
        init: function(config) {
            if (config) {
                sCurrentPage = config.startPage;
            }
            $("#"+sCurrentPage).addClass("visible");
            $.each($("section[role='region']"), function(index, item){
                aPages.push($(item).attr('id'));
            });
            $.each($("form[data-type='confirm']"), function(index, item){
                aPrompts.push($(item).attr('id'));
            });
        },

        switched: function() {
            return true;
        },

        getCurrentPage: function() {
            return sCurrentPage;
        },
        switchToPage: function(id, back) {
            if (!back) back = false;
            if ($.inArray(id, aPages) != -1) {
                var curr = $("#"+sCurrentPage);
                var newp = $("#"+id);
                newp.addClass("visible");
                if (back) {
                    curr.one("animationend", function(e){
                        curr.removeClass("visible");
                        curr.removeClass("goBackCurrent");
                    });
                    curr.addClass("goBackCurrent");
                    newp.one("animationend", function(e){
                        newp.removeClass("goBackOld");
                    });
                    newp.addClass("goBackOld");
                } else {
                    curr.one("animationend", function(e){
                        curr.removeClass("visible");
                        curr.removeClass("goForwardCurrent");
                    });
                    curr.addClass("goForwardCurrent");
                    newp.one("animationend", function(e){
                        newp.removeClass("goForwardNew");
                    });
                    newp.addClass("goForwardNew");
                }
                sCurrentPage = id;
                this.switched();
                return true;
            }
            return false;
        },

        openPrompt: function(id) {
            if (!sCurrentPrompt && $.inArray(id, aPrompts) != -1) {
                var prompt = $("#"+id);
                prompt.css('visibility', 'visible');
                prompt.one("animationend", function(){
                    // prompt.removeClass("openPrompt");
                });
                prompt.addClass("openPrompt");
                sCurrentPrompt = id;
                return true;
            }
            return false;
        },
        closePrompt: function(id) {
            if (sCurrentPrompt && $.inArray(id, aPrompts) != -1) {
                var prompt = $("#"+id);
                prompt.one("animationend", function(){
                    prompt.removeClass("openPrompt");
                    prompt.removeClass("closePrompt");
                    prompt.css('visibility', 'hidden');
                });
                prompt.addClass("closePrompt");
                sCurrentPrompt = "";
                return true;
            }
            return false;
        }
    }
})
