
// This uses require.js to structure javascript:
// http://requirejs.org/docs/api.html#define
var V;
define(function(require) {
    // Zepto provides nice js and DOM methods (very similar to jQuery,
    // and a lot smaller):
    // http://zeptojs.com/
    var $ = require('zepto');

    // Globalization settings
    var G11n = require('foxwork/g11n');
    G11n.init({
        locales: ["pl", "ru"], // "fr", "es", "pt", "de"
        lang: window.navigator.language
    });
    G11n.localizeDOM();
    require("globalize.cultures");
    // $(".key-dot").text(G11n.culture().numberFormat["."]);

    // ViewManager
    V = require('foxwork/view');
    V.init({
        startPage: "calc"
    });

    V.switched = function() {
        if (V.getCurrentPage() == "calc") {
            $(window).trigger('resize');
        } else {
            $('html').css('font-size', '10px');
            $('#list-container').css('height', (window.innerHeight-50)+'px');
        }
    }

    // V.openPrompt("clear-confirm");

    // Write your app here.
    require('./scalc');
    require('./disabler');
    require('./key');
    require('./parser');
    require('./history');

    (function(){
        // Set window size
        $(window).resize(function() {
            $('html').css('width', window.innerWidth+'px');
            $('html').css('height', window.innerHeight+'px');
            // $('section[role="region"]').css('height', window.innerHeight+'px');
            if (V.getCurrentPage() == "calc") $('html').css('font-size', (((window.innerHeight/28.75)*10)/10)+'px');
        });
        $(window).trigger('resize');

        // setTimeout(function(){
            // V.switchToPage("history");
        // }, 2000);

            Key.init();
        $('.key-hex').attr('disabled', 'disabled');
        $('.key-hex').removeClass('key-num');

        // Parser.parseNumber("1101.01", 2);
        // Parser.parse("D3*E2/12");
        Disabler.set(Disabler.S_DEFAULT);

        History.init();


        // ActiveState for touch events
        $(document.body).on('touchstart touchend', '*', function(e) {
            $(this).toggleClass('active');
        });

        // Detect touch screen
        var hasTouch;
        function detect() {
            hasTouch = true;
            $(document.body).off('touchstart', detect);
        }
        $(document.body).on('touchstart', detect);

        // Desktop fallback
        // alert(hasTouch);
        $(document.body).on('click', '*', function(e) {
            if (hasTouch != true) {
                e.preventDefault();
                $(this).trigger('tap');
            }
        });
    })();
});
