var History = {
    count:	 0,
    lastcheck:	 0,
    limit:	 10,
    db:		 null,
    items:	 [],

    init: function() {
        var request = window.indexedDB.open("SimpleCalcDB");
        request.onerror = function(event) {
            alert("Database error. History will not work properly.");
        }
        request.onsuccess = function(event) {
            History.db = request.result;
            History.db.onerror = function(event) {
                    alert("Database error: " + event.target.errorCode);
            }

            var tx = History.db.transaction("history", "readonly");
            var os = tx.objectStore("history");

            var cnt = os.count()
            cnt.onsuccess = function(event) {
                    History.count = event.target.result;
                    History.list();
            };
        }
        request.onupgradeneeded = function(event) {
            History.db = event.target.result;
            var objStore = History.db.createObjectStore("history", { keyPath: "id", autoIncrement: true });
        }

        $("#history-list").on('tap', 'a.history-item', Key.history.item);
    },

    list: function() {
        var elem = $("#history-list");
        var key,item,row;
        var i;

        elem.html('');
        History.lastcheck = 0;

        if (History.count != 0) {
            tx = History.db.transaction("history", "readonly");
            os = tx.objectStore("history");

            os.openCursor().onsuccess = function(event) {
                var cursor = event.target.result;
                if (cursor) {
                    elem.prepend("<li><a href='#' class='history-item'><p>"+cursor.value.expr+"</p><p>= "+cursor.value.result+" ("+SCalc._systems[cursor.value.system]+")</p></a></li>");
                    History.lastcheck++;
                    cursor.continue();
                }
            };
        }
    },

    saveItem: function(e, r, s) {
        var first;
        if (History.count == History.limit) {
            var request = History.db.transaction("history", "readonly").objectStore("history");
            request.openCursor().onsuccess = function(event) {
                var cursor = event.target.result;
                if (cursor) {
                    History.removeItem(cursor.key);
                    History.count--;
                    History.lastcheck = 0;
                }
            };
        }

        var now = new Date();
        var data = {
            "time": now.getTime(),
            "expr": e.substring(0, e.length-1),
            "result": r,
            "system": s
        }
        var tx = History.db.transaction("history", "readwrite");
        var os = tx.objectStore("history");
        var req = os.add(data);
        req.onsuccess = function(event) {
                History.count++;
        };
    },
    removeItem: function(item) {
        var tx = History.db.transaction("history", "readwrite");
        var os = tx.objectStore("history");
        var req = os.delete(item);
        // req.onsuccess = function(event) {

        // };
    },

    clear: function() {
        var tx = History.db.transaction("history", "readwrite");
        var os = tx.objectStore("history");

        if (History.count != 0){
            os.clear().onsuccess = function(event) {
                History.count = 0;
            }
        }
    }
}
