var Key = {
    init: function() {
        $('.key-c').tap(function() { Key.c(); });
        $('.key-ce').tap(function() { Key.ce(); });

        $('.key-const').tap(function() { Key.constant($(this).text()); });
        $('.key-count').tap(function() { Key.count(); });

        $('.key-degrad').tap(function() { Key.degrad(); });

        $('.key-dot').tap(function() { Key.dot($(this).text()); });
        $('.key-fact').tap(function() { Key.fact(); });
        $('.key-func').tap(function() { Key.func($(this).text()); });

        $('.key-history').tap(function() { Key.history.open(); });
        $('.key-history-back').tap(function() { Key.history.back(); });
        $('.key-history-clear').tap(function() { Key.history.clear(); });

        $('.key-memory-add').tap(function() { Key.memory.add(); });
        $('.key-memory-clear').tap(function() { Key.memory.clear(); });
        $('.key-memory-read').tap(function() { Key.memory.read(); });
        $('.key-memory-sub').tap(function() { Key.memory.sub(); });

        $('.key-num').tap(function() { Key.num($(this).text()); });
        $('.key-onediv').tap(function() { Key.onediv(); });
        $('.key-operator').tap(function() { Key.operator($(this).text()); });
        $('.key-par').tap(function() { Key.par(); });
        $('.key-per').tap(function() { Key.per(); });
        $('.key-sign').tap(function() { Key.sign(); });

        $('.key-systemb').tap(function() { Key.systemb(); });
        $('.key-systemf').tap(function() { Key.systemf(); });
    },

    c: function() {
        if (SCalc._clr == 1) {
            SCalc.result = '';
            SCalc._clr = 0;
        }

        Disabler.set(Disabler.S_CLEAR);

        SCalc._cdot = 0;
        SCalc._cadot = 0;
        SCalc._cpar = 0;
        SCalc._cop = 0;
        SCalc.expr = '';
        SCalc.result = '';
        SCalc.updateExpr();
        SCalc.updateResult();
    },

    ce: function() {
        if (SCalc._clr == 1) {
            SCalc._clr = 0;
        }

        Disabler.set(Disabler.S_CLEAR);
        if (SCalc.expr.length != 0 && $.inArray(SCalc.expr.substring(SCalc.expr.length-1,SCalc.expr.length),["n","s","t"]) != -1) Disabler.disable('.key-func');
        if (SCalc.expr.length == 0 || $.inArray(SCalc.expr.substring(SCalc.expr.length-1,SCalc.expr.length),["(","n","s","t"]) != -1) Disabler.disable('.key-count');
        if (SCalc.expr.length == 0 || $.inArray(SCalc.expr.substring(SCalc.expr.length-1,SCalc.expr.length),["(","n","s","t"]) != -1) Disabler.disable('.key-operator');
        if (SCalc.memory != null) Disabler.enable('.key-memory-read');

        SCalc._cdot = 0;
        SCalc._cadot = 0;
        SCalc.result = '';
        SCalc.updateResult();
    },

    constant: function(key) {
        Disabler.set(Disabler.S_CONST);
        (SCalc._cpar == 0 ? Disabler.disable('.key-par') : Disabler.enable('.key-par'));

        if (SCalc._clr == 1) {
            SCalc.expr = '';
            SCalc.result = '';
            SCalc._clr = 0;
            SCalc._cop = 0;
        }

        SCalc.result += key;
        SCalc.updateExpr();
        SCalc.updateResult();
    },

    count: function() {
        Disabler.set(Disabler.S_COUNT);
        (SCalc.memory != null ? Disabler.enable('.key-memory-read') : Disabler.disable('.key-memory-read'));

        if (SCalc.result == '') {
            if (SCalc.expr.substring(SCalc.expr.length-3,SCalc.expr.length) == "mod") {
                SCalc.expr = SCalc.expr.substring(0,SCalc.expr.length-3);
            } else if ($.inArray(SCalc.expr.substring(SCalc.expr.length-1,SCalc.expr.length),[")","0","1","2","3","4","5","6","7","8","9","!","%"]) == -1) {
                SCalc.expr = SCalc.expr.substring(0,SCalc.expr.length-1);
            }
        } else {
            if (Parser.parseNumber(SCalc.result, SCalc._sysnum[SCalc._system]) < 0) SCalc.result = '('+SCalc.result+')';
            SCalc.expr += SCalc.result;
        }

        if (SCalc._cpar > 0) {
            for (i=0; i<SCalc._cpar; i++) SCalc.expr += ')';
            SCalc._cpar = 0;
        }

        SCalc.result = Parser.parse(SCalc.expr);
        if (SCalc.result.substring(0,5) != "Error") {
            SCalc.result = SCalc.result.replace("e","E");
        }
        SCalc.result = SCalc.result.replace("INFINITY", "∞");
        // alert(SCalc.result);
        // SCalc.result = SCalc.result.toUpperCase();
        SCalc.expr += '=';


        if (SCalc.result.substring(0,5) == "Error") {
            Disabler.set(Disabler.S_ERROR);
        } else {
            if (SCalc.result%1 !== 0 || SCalc.result < 0) Disabler.disable('.key-fact');

            History.saveItem(SCalc.expr, SCalc.result, SCalc._system);
        }
        SCalc._clr = 1;
        SCalc._cdot = 0;
        SCalc._cadot = 0;
        SCalc._cop = 0;

        SCalc.updateExpr();
        SCalc.updateResult();
        SCalc._expr = SCalc.expr;
        SCalc.expr = '';
    },

    degrad: function() {
        if (SCalc._degrad == 0) {
            SCalc._degrad = 1;
            $('.key-degrad').text('deg');
            $('.info-deg').removeClass('active');
            $('.info-rad').addClass('active');
        } else {
            SCalc._degrad = 0;
            $('.key-degrad').text('rad');
            $('.info-rad').removeClass('active');
            $('.info-deg').addClass('active');
        }
    },

    dot: function(key) {
        Disabler.set(Disabler.S_DOT);

        if (SCalc._clr == 1) {
            SCalc.result = '';
            SCalc._clr = 0;
        }

        if (SCalc._cdot == 0) {
            SCalc._cdot = 1;
            if (SCalc.result == '') SCalc.result = '0';
            SCalc.result += '.';
            SCalc.updateResult();
        }
        SCalc.updateExpr();
    },

    fact: function() {
        Disabler.set(Disabler.S_FACT);

        SCalc.result += '!';
        SCalc.expr += SCalc.result;
        SCalc.result = '';

        SCalc.updateExpr();
        SCalc.updateResult();
    },

    func: function(key) {
        Disabler.set(Disabler.S_FUNC);
        (SCalc.memory != null ? Disabler.enable('.key-memory-read') : Disabler.disable('.key-memory-read'));

        if (SCalc._clr == 1) SCalc._clr = 0;

        SCalc.expr += key;
        SCalc.result = '';
        SCalc.updateExpr();
        SCalc.updateResult();
    },

    history: {
        back: function() {
            $("html meta[name='theme-color']").attr('content', '#FFF');
            V.switchToPage("calc", true);
        },

        clear: function () {
            if (confirm("Are you sure you want to clear history?")) {
                History.clear();
                History.list();
            }
        },

        item: function() {
            var r = $(this).children().last().text();
            var sys = r.substring(r.length-4,r.length-1);
            r = r.substring(2,r.length-6);

            var s = ["bin", "oct", "dec", "hex"];
            var w = SCalc._system - s.indexOf(sys);
            if (w < 0) w += s.length;

            for (w;w>0;w--) $(".key-systemb").trigger("tap");

            SCalc.result = r;
            SCalc.expr = $(this).children().first().text()+'=';
            SCalc.updateResult();
            SCalc.updateExpr();

            Disabler.set(Disabler.S_COUNT);
            (SCalc.memory != null ? Disabler.enable('.key-memory-read') : Disabler.disable('.key-memory-read'));
            if (SCalc.result%1 !== 0 || SCalc.result < 0) Disabler.disable('.key-fact');

            V.switchToPage("calc", true);
//            SCalc.expr = '';
            SCalc._clr = 1;
        },

        open: function() {
            if (History.count != History.lastcheck) {
                History.list();
            }
            $("html meta[name='theme-color']").attr('content', '#F97C17');
            V.switchToPage("history");
        }
    },

    memory: {
        add: function() {
            if (SCalc._clr == 1) SCalc._clr = 0;

            SCalc.memory += Parser.parseNumber(SCalc.result, SCalc._sysnum[SCalc._system]);

            if (SCalc.memory != null) {
                Disabler.enable('.key-memory-clear');
                Disabler.enable('.key-memory-read');
            }

            SCalc._clr = 1;
        },

        clear: function() {
            Disabler.disable('.key-memory-clear');
            Disabler.disable('.key-memory-read');

            if (SCalc._clr == 1) SCalc._clr = 0;

            SCalc.memory = null;
        },

        read: function() {
            Disabler.set(Disabler.S_NUM);
            Disabler.disable('.key-num');
            Disabler.enable('.key-memory-read');

            if (SCalc.memory%1 !== 0) {
                SCalc._cdot = 1;
                Disabler.disable('.key-dot');
            }
            (SCalc._cdot == 0 ? Disabler.enable('.key-fact') : Disabler.disable('.key-fact'));
            (SCalc._cpar == 0 ? Disabler.disable('.key-par') : Disabler.enable('.key-par'));
            (SCalc._cop > 0 ? Disabler.enable('.key-per') : Disabler.disable('.key-per'));

            if (SCalc._clr == 1) {
                SCalc.expr = '';
                SCalc.updateExpr();
            } else {
                SCalc._clr = 1;
            }

            SCalc.result = SCalc.memory.toString(SCalc._sysnum[SCalc._system]);
            SCalc._cdot = 1;
            if (SCalc.result%1 === 0)	SCalc._cdot = 0;
            SCalc.updateResult();
        },

        sub: function() {
            if (SCalc._clr == 1) SCalc._clr = 0;

            SCalc.memory -= Parser.parseNumber(SCalc.result, SCalc._sysnum[SCalc._system]);

            if (SCalc.memory != null) {
                Disabler.enable('.key-memory-clear');
                Disabler.enable('.key-memory-read');
            }

            SCalc._clr = 1;
        }
    },

    num: function(key) {
        Disabler.set(Disabler.S_NUM);
        (SCalc._cdot == 0 ? Disabler.enable('.key-fact') : Disabler.disable('.key-fact'));
        (SCalc._cpar == 0 ? Disabler.disable('.key-par') : Disabler.enable('.key-par'));
        if (SCalc._cdot == 1) {
            SCalc._cadot++;
            if (SCalc._cadot == SCalc._prec) {
                Disabler.disable('.key-num');
            }
        }

        if (SCalc._clr == 1) {
            SCalc.expr = '';
            SCalc.result = '';
            SCalc._cdot = 0;
            SCalc._cadot = 0;
            SCalc._clr = 0;
            SCalc._cop = 0;
        }

        (SCalc._cop > 0 ? Disabler.enable('.key-per') : Disabler.disable('.key-per'));

        if (SCalc.result == '0') SCalc.result = '';
        SCalc.result += key;
        SCalc.updateExpr();
        SCalc.updateResult();
    },

    onediv: function() {
        SCalc.result = "(1/"+SCalc.result+")";
        SCalc.result = Parser.parse(SCalc.result);

        SCalc.updateResult();
    },

    operator: function(key) {
        Disabler.set(Disabler.S_OPERATOR);
        (SCalc.memory != null ? Disabler.enable('.key-memory-read') : Disabler.disable('.key-memory-read'));

        if (SCalc._clr == 1) {
            SCalc.expr = '';
            SCalc._clr = 0;
        }
        if (SCalc._cpar == 0) SCalc._cop++;

        if (SCalc.result == '') {
            if (SCalc.expr.substring(SCalc.expr.length-3,SCalc.expr.length) == "mod") {
                SCalc.expr = SCalc.expr.substring(0,SCalc.expr.length-3);
            } else if ($.inArray(SCalc.expr.substring(SCalc.expr.length-1,SCalc.expr.length),[")","!","%"]) == -1) {
                SCalc.expr = SCalc.expr.substring(0,SCalc.expr.length-1);
            }
        }
        if (Parser.parseNumber(SCalc.result, SCalc._sysnum[SCalc._system]) < 0) SCalc.result = '('+SCalc.result+')';

        SCalc.result += key;
        SCalc.expr += SCalc.result;
        SCalc._cdot = 0;
        SCalc._cadot = 0;
        SCalc.result = '';
        SCalc.updateExpr();
        SCalc.updateResult();
    },

    par: function() {
        if (SCalc._clr == 1) {
            SCalc.result = '';
            SCalc._clr = 0;
        }

        if (SCalc._cpar > 0 && SCalc.result == '' && $.inArray(SCalc.expr.substring(SCalc.expr.length-1,SCalc.expr.length),["(","+","-","*","/","^","√","n","s","t","d"]) == -1) {
            Disabler.set(Disabler.S_PAR_C);
            (SCalc._cop > 0 ? Disabler.enable('.key-per') : Disabler.disable('.key-per'));

            SCalc.expr += ')';

            SCalc._cpar--;
        } else if (SCalc._cpar > 0 && SCalc.result != '') {
            Disabler.set(Disabler.S_PAR_C);
            (SCalc._cop > 0 ? Disabler.enable('.key-per') : Disabler.disable('.key-per'));

            if (Parser.parseNumber(SCalc.result, SCalc._sysnum[SCalc._system]) < 0) SCalc.result = "("+SCalc.result+")";
            SCalc.result += ')';
            SCalc.expr += SCalc.result;
            SCalc.result = '';

            SCalc._cdot = 0;
            SCalc._cadot = 0;
            SCalc._cpar--;
        } else if (SCalc.result == '') {
            Disabler.set(Disabler.S_PAR_O);
            (SCalc.memory != null ? Disabler.enable('.key-memory-read') : Disabler.disable('.key-memory-read'));

            SCalc.expr += '(';

            SCalc._cpar++;
        }
        if (SCalc._cpar == 0) Disabler.disable('.key-par');
        SCalc.updateResult();
        SCalc.updateExpr();
    },

    per: function() {
        Disabler.set(Disabler.S_PER);

        SCalc.result += '%';
        SCalc.expr += SCalc.result;
        SCalc.result = '';

        SCalc.updateExpr();
        SCalc.updateResult();
    },

    sign: function() {
        SCalc.result = SCalc.result*(-1);
        (SCalc.result < 0 || SCalc._cdot == 1) ? Disabler.disable('.key-fact') : Disabler.enable('.key-fact');

        SCalc.updateResult();
    },

    systemb: function() {
        $('.info-'+SCalc._systems[SCalc._system]).removeClass('active');
        $('.key-systemf').text(SCalc._systems[SCalc._system]);

        $('.key-'+SCalc._systems[SCalc._system]).attr('disabled', 'disabled');
        $('.key-'+SCalc._systems[SCalc._system]).removeClass('key-num');

        if ($.inArray(SCalc.result, ['','π','e','γ']) == -1) {
            r = Parser.parseNumber(SCalc.result, SCalc._sysnum[SCalc._system]).toString(SCalc._sysnum[(SCalc._system+3)%4]);
            r = Parser.precise(r);
            SCalc.result = r;
        }
        SCalc.updateResult();

        SCalc._system = (SCalc._system+3)%4;
        if (SCalc._system == 3) {
            for (i=0; i<4; i++) {
                $('.key-'+SCalc._systems[i]).removeAttr('disabled');
                $('.key-'+SCalc._systems[i]).addClass('key-num');
            }
        }

        $('.info-'+SCalc._systems[SCalc._system]).addClass('active');
        $('.key-systemb').text(SCalc._systems[(SCalc._system+3)%4]);

        Parser.reCalcExpr();
        //alert(SCalc._system);
    },

    systemf: function() {
        $('.info-'+SCalc._systems[SCalc._system]).removeClass('active');
        $('.key-systemb').text(SCalc._systems[SCalc._system]);

        if (SCalc._system == 3) {
            for (i=0; i<4; i++) {
                $('.key-'+SCalc._systems[i]).attr('disabled', 'disabled');
                $('.key-'+SCalc._systems[i]).removeClass('key-num');
            }
        }

        if ($.inArray(SCalc.result, ['','π','e','γ']) == -1) {
            r = Parser.parseNumber(SCalc.result, SCalc._sysnum[SCalc._system]).toString(SCalc._sysnum[(SCalc._system+5)%4]);
            r = Parser.precise(r);
            SCalc.result = r;
        }
        SCalc.updateResult();


        SCalc._system = (SCalc._system+5)%4;

        $('.key-'+SCalc._systems[SCalc._system]).removeAttr('disabled');
        $('.key-'+SCalc._systems[SCalc._system]).addClass('key-num');

        // Disabler.set(Disabler.S_DEFAULT);

        $('.info-'+SCalc._systems[SCalc._system]).addClass('active');
        $('.key-systemf').text(SCalc._systems[(SCalc._system+5)%4]);

        Parser.reCalcExpr(true);
        //    alert(SCalc._system);
    }
}
