var Parser = {
    elem:		new Array(),
    exit:		new Array(),
    stack:		new Array(),

    op : {
        LC: 1,
        RC: 1,
        connect: {
            '+': 3,		'-': 1,			'*': 3,			'/': 1,
            'mod': 1,		'^': 1
        },
        prior: {
            '(': 0,		'+': 1,			'-': 1,			')': 1,
            '*': 2,		'/': 2,			'mod': 2,		'^': 3,
            '%': 3,		'√': 3,			'3√': 3,		'sin': 3,
            'cos': 3,		'tan': 3,		'cot': 3,		'asin': 3,
            'acos': 3,		'atan': 3,		'acot': 3,		'ln': 3,
            'log': 3,		'!': 4
        },
    },
    pattern:	 /([\d\.ABCDEF]+([-](?![\)\d]))?)|(∞|e|γ|π)|(nisa|soca|nata|toca|nis|soc|nat|toc|nl|gol|dom|√3|√|!|%)|([\^\(\)\/\*\+-]{1})/g,
    precision:	 1000000000000,

    reCalcExpr: function(forward) {
        var cnt = 4;
        if (forward == true) cnt--;
        else cnt++;

        expr = SCalc.expr;
        if (!expr) expr = SCalc._expr;

        if (SCalc._system != 3) {
            expr = expr.replace("E+", "*10^");
            expr = expr.replace("E-", "*1/10^");
        }
        // expr = expr.replace("π", Math.PI.toString(SCalc._sysnum[SCalc._system]));
        // expr = expr.replace("e", Math.E.toString(SCalc._sysnum[SCalc._system]));
        // expr = expr.replace("γ", (0.577215664901).toString(SCalc._sysnum[SCalc._system]));

        Parser.elem = expr.split('').reverse().join('').match(Parser.pattern);

        var i = 0;
        for (i; i<Parser.elem.length; i++) {
            Parser.elem[i] = Parser.elem[i].split('').reverse().join('');
        }
        Parser.elem = Parser.elem.reverse();

        for (i=0; i<Parser.elem.length; i++) {
            if (Parser.elem[i].match(/[\d\.ABCDEF]+/) && Parser.elem[i] != '3√') {
                // alert(Parser.elem[i]);
                Parser.elem[i] = Parser.parseNumber(Parser.elem[i], SCalc._sysnum[(SCalc._system+cnt)%4]).toString(SCalc._sysnum[SCalc._system]).toUpperCase();
                // Parser.exit.push(Parser.parseNumber(Parser.elem[i], SCalc._sysnum[SCalc._system]));
            }
        }
        expr = Parser.elem.join('')+'=';
        SCalc.expr = expr;
        SCalc._expr = '';
        SCalc.updateExpr();
    },

    parse: function(expr) {
        if (SCalc._system != 3) {
            expr = expr.replace("E+", "*10^");
            expr = expr.replace("E-", "*1/10^");
        }
        expr = expr.replace("π", Math.PI.toString(SCalc._sysnum[SCalc._system]));
        expr = expr.replace("e", Math.E.toString(SCalc._sysnum[SCalc._system]));
        expr = expr.replace("γ", (0.577215664901).toString(SCalc._sysnum[SCalc._system]));

        Parser.elem = expr.split('').reverse().join('').match(Parser.pattern);

        var i = 0;
        for (i; i<Parser.elem.length; i++) {
            Parser.elem[i] = Parser.elem[i].split('').reverse().join('');
        }
        Parser.elem = Parser.elem.reverse();

        for (i=0; i<Parser.elem.length; i++) {
            if (Parser.elem[i] == '∞') return '∞';
            if (Parser.elem[i].match(/[\d\.ABCDEF]+/) && Parser.elem[i] != '3√') {
                // alert(Parser.elem[i]);
                Parser.exit.push(Parser.elem[i]);
                // Parser.exit.push(Parser.parseNumber(Parser.elem[i], SCalc._sysnum[SCalc._system]));
            } else if (Parser.elem[i].match(/[^\(\)]/)) {
                var op1 = Parser.elem[i];
                if (Parser.stack.length > 0) {
                    var op2 = Parser.stack[Parser.stack.length - 1];
                    while (
                        (((Parser.op.connect[op1] & Parser.op.LC) && Parser.op.prior[op1] <= Parser.op.prior[op2]) ||
                        ((Parser.op.connect[op1] & Parser.op.RC) && Parser.op.prior[op1] < Parser.op.prior[op2])) && Parser.stack.length > 0
                    ) {
                        Parser.exit.push(Parser.stack.pop());
                        op2 = Parser.stack[Parser.stack.length - 1];
                    }
                }
                Parser.stack.push(op1);
            } else if (Parser.elem[i].match(/\(/)) {
                Parser.stack.push(Parser.elem[i]);
            } else if (Parser.elem[i].match(/\)/)) {
                var ch = Parser.stack[Parser.stack.length - 1];
                while (!ch.match(/\(/)) {
                    Parser.exit.push(Parser.stack.pop());
                    ch = Parser.stack[Parser.stack.length - 1];
                }
                Parser.stack.pop();
            }
        }

        while(Parser.stack.length > 0){
            Parser.exit.push(Parser.stack.pop());
        }
    //	alert(Parser.exit);

        Parser.stack = [];
        i = 0;
        var r = 0;
        while (Parser.exit.length > 0) {
            var item = Parser.exit.shift();
            i++;
            if (item.match(/[\d\.ABCDEF]+/) && item != '3√') {
                item = Parser.parseNumber(item, SCalc._sysnum[SCalc._system]);
                Parser.stack.push(item);
            } else if (item.match(/(sin|cos|tan|cot|asin|acos|atan|acot|ln|log|3√|√|!|%)/)) {
                var a = Parser.stack.pop();
                switch (item) {
                    case 'sin':
                        //if (a%180 == 0) r = 0;
                        //else if ((a-30)%360 == 0 || (a-150)%360 == 0) r = 0.5;
                        //else if ((a+30)%360 == 0 || (a+150)%360 == 0) r = -0.5;
                        //else
                        if (SCalc._degrad == 0) a = a*Math.PI/180;
                        r = Math.sin(a);
                        break;
                    case 'cos':
                        //if ((a-90)%180 == 0) r = 0;
                        //else if ((a-60)%360 == 0 || (a+60)%360 == 0) r = 0.5;
                        //else if ((a-120)%360 == 0 || (a+120)%360 == 0) r = -0.5;
                        //else
                        if (SCalc._degrad == 0) a = a*Math.PI/180;
                        r = Math.cos(a);
                        break;
                    case 'tan':
                        if ((a-90)%180 == 0) {
                                return "Error: tan("+a+") is incomputable";
                        }
                        //if (a%180 == 0) r = 0;
                        //else if ((a-45)%180 == 0) r = 1;
                        //else if ((a+45)%180 == 0) r = -1;
                        //else
                        if (SCalc._degrad == 0) a = a*Math.PI/180;
                        r = Math.tan(a);
                        break;
                    case 'cot':
                        if (a%180 == 0) {
                                return "Error: cot("+a+") is incomputable";
                        }
                        if (SCalc._degrad == 0) a = a*Math.PI/180;
                        r = Math.cos(a)/Math.sin(a);
                        break;
                    case 'asin':
                        if (a < -1 || a > 1) {
                                return "Error: asin("+a+") is incomputable";
                        }
                        //if (a == 0.5) r = 30;
                        //else if (a == -0.5) r = -30;
                        //else
                        r = Math.asin(a);
                        if (SCalc._degrad == 0) r = r*180/Math.PI;
                        break;
                    case 'acos':
                        if (a < -1 || a > 1) return "Error: acos("+a+") is incomputable";
                        //if (a == 0.5) r = 60;
                        //else if (a == -0.5) r = 120;
                        //else
                        r = Math.acos(a);
                        if (SCalc._degrad == 0) r = r*180/Math.PI;
                        break;
                    case 'atan':
                        r = Math.atan(a);
                        if (SCalc._degrad == 0) r = r*180/Math.PI;
                        break;
                    case 'acot':
                        r = Math.atan(1/a);
                        if (SCalc._degrad == 0) r = r*180/Math.PI;
                        break;
                    case 'ln':
                        if (a <= 0) return "Error: ln("+a+") is uncomputable";
                        r = Math.log(a);
                        break;
                    case 'log':
                        if (a <= 0) return "Error: log("+a+") is uncomputable";
                        r = Math.log(a)/Math.log(10);
                        break;
                    case '3√':
                        var sign = (a < 0 ? -1 : 1);
                        r = sign*Math.pow(Math.abs(a),1/3);
                        break;
                    case '√':
                        if (a < 0) return "Error: √("+a+") is not real";
                        r = Math.sqrt(a);
                        break;
                    case '!':
                        var b = 1;
                        var i = 2;
                        for (i; i<=a; i++) b *= i;
                        r = b;
                        break;
                    case '%':
                        var b = Parser.stack.pop();
                        var op = Parser.exit.shift();
                        switch (op) {
                            case '+':
                                r = b*(100+a)/100;
                                break;
                            case '-':
                                r = b*(100-a)/100;
                                break;
                            case '*':
                                r = b*a/100;
                                break;
                            case '/':
                                r = b*100/a;
                                break;
                            default:
                                break;
                        }
                        break;
                    default:
                        break;
                }
                Parser.stack.push(Parser.precise(r));
            } else {
                var b = Parser.stack.pop();
                var a = Parser.stack.pop();
                switch (item) {
                    case '+':
                        r = a+b;
                        break;
                    case '-':
                        r = a-b;
                        break;
                    case '*':
                        r = a*b;
                        break;
                    case '/':
                        if (b == 0) return "Error: division by zero";
                        r = a/b;
                        break;
                    case '^':
                        r = Math.pow(a,b);
                        break;
                    case 'mod':
                        r = a%b;
                        break;
                    default:
                        return "Error: unknown";
                }
                Parser.stack.push(Parser.precise(r));
            }
        }
        // alert(r);
        // r = Parser.precise(Parser.stack.pop());
        r = Parser.stack.pop();
        // alert(r);
        r = r.toString(SCalc._sysnum[SCalc._system]);
        // alert(r);
// if (SCalc._system != 3)
        return Parser.precise(r);
// else
        // return r;
        // return r.toString(SCalc._sysnum[SCalc._system]);
    },

    parseNumber: function(number, system) {
// alert(number);
// alert(system);
        min = 0;
        res = 0;
        num = number;
        num = num.split(".");
        if (num[0][0] == '-') {
            num[0] = num[0].substring(1);
            min = 1;
        }
        num[0] = num[0].split("").reverse().join("");
        n = 0;
        s = 1;
        for (i=0; i<num[0].length; i++) {
            if (num[0][i].charCodeAt(0) > 64) {
                v = num[0][i].charCodeAt(0) - 55;
            } else {
                v = parseInt(num[0][i]);
            }
            // alert(v);
            n = n+(s*v);
            s *= system;
// alert(n);
        }
        res += n;
        if (num[1]) {
// alert(num[1]);
            n = 0;
            s = 1/system;
            for (i=0; i<num[1].length; i++) {
                if (num[1][i].charCodeAt(0) > 64) {
                    v = num[1][i].charCodeAt(0) - 55;
                } else {
                    v = parseInt(num[1][i]);
                }
                n = n+(s*v);
                s /= system;
// alert(n);
            }
            res += n;
        }

        if (min == 1) res *= -1;

        return res;
    },

    precise: function(number) {
        r = number;
        if (typeof number === 'string' && number.indexOf('e') == -1) {
            r = number.split(".");
            if (r[1] && r[1].length > SCalc._prec) {
                    r[1] = r[1].substr(0,SCalc._prec);
            }
            r = r.join(".").toUpperCase();
            // alert(r);
        } else if (typeof number === 'number') {
            r = Math.round(number*Parser.precision)/Parser.precision;
        }

        return r;
    }
}
