var Album = Backbone.Model.extend({
    defaults: {
        title  : '',
        artist : ''
    }
});

var AlbumView = Backbone.View.extend({
    tagName: 'li',

    events: {
        'click': 'songs'
    },

    initialize: function(){
        _.bindAll(this, 'render', 'songs');
    },

    render: function(){
        $(this.el).html('<button>' + this.model.get('title') + '</button>');
        return this;
    },

    songs: function(){
        var listSongsView = new ListSongsView(
            {
                'album' : unescape(encodeURIComponent(this.model.get('title'))),
                'artist': unescape(encodeURIComponent(this.model.get('artist'))),
            }
        );
    }
});

var ListAlbumsView = Backbone.View.extend({
    el: 'ul#albums-list',

    initialize: function(options){
        console.log('ListAlbumsView.initialize');
        _.bindAll(this, 'appendAlbum');

        var progress = this.el.parentNode.querySelector('progress');

        this.el.innerHTML = '';
        progress.classList.remove('hidden');

        var self = this;
        var data = '';
        var socket_albums = navigator.mozTCPSocket.open(settings.host, settings.port, { binaryType: 'string' });

        socket_albums.onopen = function (event) {
            //~ console.log('socket_albums open', options);

            socket_albums.send(getCommand(command_list_albums.replace('param', options.artist)));
        };
        socket_albums.onclose = function (event) {
            //~ console.log('socket_albums closed');
        };
        socket_albums.ondata = function (event) {
            //~ console.log('socket_albums data');

            if (typeof event.data === 'string') {
                //~ console.log(event.data);
                data += event.data;

                if (data.lastIndexOf("OK\n") > 0) {
                    socket_albums.close();

                    var data_splitted = data.split("\n");

                    data_splitted.sort(
                        function(a, b) {
                            if (a.toLowerCase() < b.toLowerCase()) return -1;
                            if (a.toLowerCase() > b.toLowerCase()) return 1;
                            return 0;
                        }
                    );

                    data_splitted.forEach( function (line) {
                        var regexped = line.match(/[A-Za-z]*: .*/);

                        if (regexped) {
                            var params = regexped[0].split("Album: ");

                            if (params[1].length > 0) {
                                self.appendAlbum(new Album(
                                    {
                                        'title'  : decodeURIComponent(escape(params[1])),
                                        'artist' : options.artist,
                                    }
                                ));
                            }
                        }
                    });
                    progress.classList.add('hidden');

                    if (self.el.length === 0) {
                        showBanner("<p>No album</p>");
                    }
                }

            } else {
                console.error('Fuck, received data is shitty');
                socket_albums.close();
            }
        };

        var viewAlbums = document.getElementById("albums-view");
        viewAlbums.classList.remove('move-right');
        viewAlbums.classList.add('move-left');

        var divAlbums = document.getElementById('div-albums');
        divAlbums.scrollTop = 0;
    },

    appendAlbum: function(album){
        var albumView = new AlbumView({
            model: album
        });
        this.el.appendChild(albumView.render().el);
    },

});
