var Artist = Backbone.Model.extend({
    defaults: {
        name : ''
    }
});

var ArtistView = Backbone.View.extend({
    tagName: 'li',

    events: {
        'click': 'albums',
    },

    initialize: function(){
        _.bindAll(this, 'render', 'albums');
    },

    render: function(){
        this.el.innerHTML = '<button>' + this.model.get('name') + '</button>';
        this.el.classList.add('hidden');
        return this;
    },

    albums: function(){
        var listAlbumsView = new ListAlbumsView(
            {
                'artist': unescape(encodeURIComponent(this.model.get('name'))),
            }
        );
    }

});

var ListArtistsView = Backbone.View.extend({
    el: 'ul#artists-list',

    initialize: function(){
        console.log('ListArtistsView.initialize');
        _.bindAll(this, 'appendArtist');
    },

    load: function() {
        var self = this;

        var data = '';
        this.el.innerHTML = '';
        this.artistsFragment = document.createDocumentFragment();

        var socket_artists = navigator.mozTCPSocket.open(settings.host, settings.port, { binaryType: 'string' });

        socket_artists.onopen = function (event) {
            //~ console.log('socket_artists open');

            socket_artists.send(getCommand(getCommand(command_list_artists)));
        };
        socket_artists.onclose = function (event) {
            //console.log('socket closed');
        };
        socket_artists.ondata = function (event) {

            if (typeof event.data === 'string') {
                //~ console.log(event.data);
                data += event.data;

                if (data.lastIndexOf("OK\n") > 0) {
                    socket_artists.close();

                    var data_splitted = data.split("\n");

                    data_splitted.sort(
                        function(a, b) {
                            if (a.toLowerCase() < b.toLowerCase()) return -1;
                            if (a.toLowerCase() > b.toLowerCase()) return 1;
                            return 0;
                        }
                    );

                    var first_letter = "";
                    var others = [];

                    data_splitted.forEach( function (line) {
                        var regexped = line.match(/[A-Za-z]*: .*/);

                        if (regexped) {
                            var params = regexped[0].split("Artist: ");
                            var artist_name = decodeURIComponent(escape(params[1]));

                            if (artist_name.length > 0) {
                                var isOther = false;

                                // Add index letters
                                if (first_letter < artist_name[0].toUpperCase()) {
                                    var new_first_letter = artist_name[0].toUpperCase();

                                    var h1 = document.createElement("li");
                                    h1.classList.add('first-letter');

                                    if (new_first_letter.match(/[A-Z]/)) {
                                        h1.innerHTML = '<h1>' + new_first_letter + '</h1>';
                                        first_letter = new_first_letter;
                                    } else if ( (new_first_letter <= '9') && (new_first_letter >= '0') && (first_letter != '9') ){
                                        h1.innerHTML = '<h1>#</h1>';
                                        first_letter = '9';
                                    } else {
                                        isOther = true;
                                        others.push(artist_name);
                                    }

                                    // Add H1 title to list. Skip others.
                                    if (!isOther) {
                                        h1.addEventListener('click', function() {
                                            var index = $(self.el.childNodes).index(this) + 1;

                                            while (self.el.childNodes[index].firstChild.tagName != 'H1') {
                                                self.el.childNodes[index].classList.toggle('hidden');
                                                index++;
                                            }
                                        });
                                        self.artistsFragment.appendChild(h1);
                                    }
                                }

                                // Add artist to list. Skip others.
                                if (!isOther) {
                                    // Add artist
                                    self.appendArtist( new Artist({'name' : artist_name}) );
                                }
                            }
                        }
                    });

                    // Add others
                    if (others) {
                        var h1 = document.createElement("li");
                        h1.classList.add('first-letter');
                        h1.innerHTML = '<h1>others</h1>';

                        h1.addEventListener('click', function() {
                            var index = $(self.el.childNodes).index(this) + 1;

                            while ( (index < self.el.childNodes.length) && (self.el.childNodes[index].firstChild.tagName != 'H1') ) {
                                self.el.childNodes[index].classList.toggle('hidden');
                                index++;
                            }
                        });
                        self.artistsFragment.appendChild(h1);

                        for (var i=0; i<others.length; i++) {
                            self.appendArtist( new Artist({'name' : others[i]}) );
                        }
                    }

                    self.el.appendChild(self.artistsFragment);

                    connectionMessage.innerHTML = "";

                    // Hide settings view
                    settings_btn.classList.remove('active');

                    viewSettings.classList.remove('move-up');
                    viewSettings.classList.add('move-down');

                    // Adapt view as small-section : remove header and apply class
                    setTimeout(function() {
                        viewSettings.classList.add('small-section');

                        var header = viewSettings.querySelector('header');
                        if (header) {
                            viewSettings.removeChild(viewSettings.querySelector('header'));
                        }
                    }, 300);
                }

            } else {
                console.error('Fuck, received data is shitty');
                socket_artists.close();
            }
        };

        var divArtists = document.getElementById('div-artists');
        divArtists.scrollTop = 0;
    },

    appendArtist: function(artist){
        var artistView = new ArtistView({
            model: artist
        });

        this.artistsFragment.appendChild(artistView.render().el);
    },

});

var listArtistsView = new ListArtistsView();

$(function(){

    // IndexLetters : show only letters on click
    var artistsView = document.getElementById('artists-view');

    var artistsList  = artistsView.querySelector('#artists-list');
    var indexLetters = artistsView.querySelector('#indexLetters');
    var searchIcon   = artistsView.querySelector('.search-icon');
    var searchInput  = artistsView.querySelector('.search');
    var h1           = artistsView.querySelector('header > h1');

    var artists = listArtistsView.el.childNodes;

    indexLetters.addEventListener('click', function() {

        artistsList.classList.add('loading');
        
        setTimeout(function() {
            if (searchIcon.classList.contains('active')) {
                searchInput.style.display = 'none';
                h1.style.display          = 'block';
                searchIcon.classList.remove('active');
            }

            if (!indexLetters.classList.contains('active')) {
                indexLetters.classList.add('active');
                for (var i = 0, length = artists.length; i < length; i++) {
                    // Don't hide first letter titles
                    if ( (artists[i].firstChild) && (artists[i].firstChild.tagName != 'H1') ) {
                        artists[i].classList.add('hidden');
                    }
                }
            } else {
                indexLetters.classList.remove('active');
                for (var j = 0, length = artists.length; j < length; j++) {
                    // Don't hide first letter titles
                    if ( (artists[j].firstChild) && (artists[j].firstChild.tagName != 'H1') ) {
                        artists[j].classList.remove('hidden');
                    }
                }
            }

            artistsList.classList.remove('loading');
        }, 0);
    });

});
