var AudioSettingsView = Backbone.View.extend({
    el: 'section#audio-settings-view',
    events: {
        'click   #repeat'  : 'repeat',
        'click   #random'  : 'random',
        'click   #single'  : 'single',
        'touchstart  #volume'  : 'volume',
    },

    initialize: function(){
        console.log('AduioSettingsView');
        _.bindAll(this, 'volume');
    },

    repeat: function(event) {
        //~ console.log(event.currentTarget.value);

        value = 0;
        if (!event.currentTarget.value) {
            value = 1;
        }

        this.send(getCommand(command_repeat.replace('param', value)));
    },
    
    random: function(event) {
        //~ console.log(event.currentTarget.value);

        value = 0;
        if (!event.currentTarget.value) {
            value = 1;
        }

        this.send(getCommand(command_random.replace('param', value)));
    },
    
    single: function(event) {
        //~ console.log(event.currentTarget.value);

        value = 0;
        if (!event.currentTarget.value) {
            value = 1;
        }

        this.send(getCommand(command_single.replace('param', value)));
    },

    volume: function(event) {
        //~ console.log(event);
        var touchobj = event.originalEvent.changedTouches[0];
        var value = parseInt((touchobj.pageX - getPosition(event.currentTarget).x) / event.currentTarget.offsetWidth * 100);

        this.send(getCommand(command_volume.replace('param', value)));
    },

    send: function (command) {
        var data = '';
        var socket_audio_settings = navigator.mozTCPSocket.open(settings.host, settings.port, { binaryType: 'string' });

        socket_audio_settings.onopen = function (event) {
            //~ console.log('socket_audio_settings open');
            socket_audio_settings.send(command);
        };
        socket_audio_settings.onclose = function (event) {
            //console.log('socket_audio_settings closed');
        };

        socket_audio_settings.ondata = function (event) {

            if (typeof event.data === 'string') {
                data += event.data;

                if (data.lastIndexOf("OK\n") > 0) {
                    //console.log(data);

                    socket_audio_settings.close();

                    mpd_status.update();
                }

            } else {
                console.error('Fuck, received data is shitty');
                socket_audio_settings.close();
            }
        };
    }
});

var audioSettingsView = new AudioSettingsView();

function getPosition(element) {
    var xPosition = 0;
    var yPosition = 0;

    while (element) {
        xPosition += (element.offsetLeft - element.scrollLeft + element.clientLeft);
        yPosition += (element.offsetTop - element.scrollTop + element.clientTop);
        element = element.offsetParent;
    }
    return { x: xPosition, y: yPosition };
}
