// Bind menu events
var artists_btn        = document.getElementsByClassName("browse-artists");
var playlist_btn       = document.getElementById("playlist-btn");
var settings_btn       = document.getElementById("settings-btn");
var audio_settings_btn = document.getElementById("audio-settings-btn");

var viewSettings = document.getElementById("settings-view");
var viewAudioSettings  = document.getElementById("audio-settings-view");

// Go to artists
for(var i=0, length=artists_btn.length; i<length; i++) {
    artists_btn[i].addEventListener ('click', function () {
        closeSettings();
        closeAudioSettings();

        var viewArtists = document.getElementById("artists-view");
        viewArtists.classList.remove('move-right');
        viewArtists.classList.add('move-left');
    });
}

// Go to playlist
playlist_btn.addEventListener ('click', function () {
    closeSettings();
    closeAudioSettings();

    var viewPlaylist = document.getElementById("playlist-view");
    viewPlaylist.classList.remove('move-right');
    viewPlaylist.classList.add('move-left');
});

// Playlist : Go to current song
var goToCurrent = document.getElementById("goToCurrent");

goToCurrent.addEventListener ('click', function () {
    var body = $("body");
    var playlist_list = $("#playlist-list");
    var current = $(".current");
    var scrollTop_temp, gotTo;

    if (current.length > 0) {
        scrollTop_temp = playlist_list.scrollTop();
        playlist_list.scrollTop(0);

        gotTo = current.position().top + current.height() - body.height() / 2 ;
        playlist_list.scrollTop(scrollTop_temp);

        playlist_list.animate({
             scrollTop: gotTo
        }, 500);
    }
});

settings_btn.addEventListener ('click', function () {
    closeAudioSettings();

    this.classList.toggle('active');

    if (this.classList.contains('active')) {
        viewSettings.classList.remove('move-down');
        viewSettings.classList.add('move-up');
    } else {
        viewSettings.classList.remove('move-up');
        viewSettings.classList.add('move-down');
    }
});

audio_settings_btn.addEventListener ('click', function () {
    closeSettings();

    this.classList.toggle('active');

    if (this.classList.contains('active')) {
        viewAudioSettings.classList.remove('move-down');
        viewAudioSettings.classList.add('move-up');
    } else {
        viewAudioSettings.classList.remove('move-up');
        viewAudioSettings.classList.add('move-down');
    }
});

function closeSettings() {
    if (settings_btn.classList.contains('active')) {
        settings_btn.classList.remove('active');

        viewSettings.classList.remove('move-up');
        viewSettings.classList.add('move-down');
    }
}
function closeAudioSettings() {
    if (audio_settings_btn.classList.contains('active')) {
        audio_settings_btn.classList.remove('active');

        viewAudioSettings.classList.remove('move-up');
        viewAudioSettings.classList.add('move-down');
    }
}
/* Back buttons */
var back_buttons = document.getElementsByClassName("back");
var home_btn     = document.getElementsByClassName("home");

for(var i=0, length=back_buttons.length; i<length; i++) {
    back_buttons[i].addEventListener ('click', function () {
        var view = this.parentNode.parentNode;

        view.classList.remove('move-left');
        view.classList.add('move-right');
    });
}

for(var i=0, length=home_btn.length; i<length; i++) {
    home_btn[i].addEventListener ('click', function () {
        var viewSongs    = document.getElementById("songs-view");
        var viewAlbums   = document.getElementById("albums-view");
        var viewArtists  = document.getElementById("artists-view");
        var viewPlaylist = document.getElementById("playlist-view");

        viewSongs.classList.remove('move-left');
        viewSongs.classList.add('move-right');

        viewAlbums.classList.remove('move-left');
        viewAlbums.classList.add('move-right');

        viewArtists.classList.remove('move-left');
        viewArtists.classList.add('move-right');

        viewPlaylist.classList.remove('move-left');
        viewPlaylist.classList.add('move-right');
    });
}
