var PlaylistSong = Backbone.Model.extend({
    defaults: {
        songid : '',
        file   : '',
        title  : '',
        album  : '',
        artist : '',
        track  : '',
        time   : '',
    }
});

var PlayList = Backbone.Collection.extend({
    model: PlaylistSong
});

var PlaylistSongView = Backbone.View.extend({
    tagName: 'li',

    events: {
        'touchend .playable' : 'playSong',

        //~ 'click .playable' : 'touchstart',
        'touchstart .cancel'   : 'cancelDelete',
        'touchstart'      : 'touchstart',
        'touchend'        : 'clearTouch'
    },

    initialize: function(){
        _.bindAll(this, 'render', 'unrender', 'remove', 'playSong');
    },

    render: function(){
        var classes = 'playable ';

        this.el.innerHTML =
            '<a class="' + classes + '"><aside class="pack-end"><p class="playlist-time">' + toTime(this.model.get('time')) + '</p></aside>' +

            '<p>' +
                this.model.get('title') +
            '</p>' +

            '<p>' +
                this.model.get('artist') +
            '</p></a>';

        return this;
    },

    playSong: function(){
        // Check if it's a click
        var isLongTouch = Date.now() - this.click_time > 300;
        var isTouchmove = Math.abs(this.click_move - document.querySelector('ul#playlist-list').scrollTop) > 3;

        if  (isTouchmove || isLongTouch) {
            // Not a click, abort.
            return;
        }

        console.log('PlaylistSongView.playSong : ' + this.model.get('songid'));

        this.clearTouch();

        var self = this;
        var data = '';
        var socket_playsong = navigator.mozTCPSocket.open(settings.host, settings.port, { binaryType: 'string' });

        socket_playsong.onopen = function (event) {
            //~ console.log('socket_playsong open');

            socket_playsong.send(getCommand(command_playlist_play.replace('param', self.model.get('songid'))));
        };
        socket_playsong.onclose = function (event) {
            //console.log('socket_playsong closed');
        };
        socket_playsong.ondata = function (event) {

            if (typeof event.data === 'string') {
                data += event.data;

                if (data.lastIndexOf("OK\n") > 0) {
                    //console.log(data);

                    socket_playsong.close();

                    mpd_status.update();
                }

            } else {
                console.error('Fuck, received data is shitty');
                socket_playsong.close();
            }
        };
    },

    touchstart: function(){
        var self = this;
        this.click_move = document.querySelector('ul#playlist-list').scrollTop;

        // To know in touchend if it's a click
        this.click_time = Date.now();

        this.click_id = window.setTimeout(function() {
            if (Math.abs(self.click_move - document.querySelector('ul#playlist-list').scrollTop) < 3) {
                self.promptDelete();
            }
        }, 1500);
    },

    clearTouch: function() {
        console.log('clearTouch');
        clearInterval(this.click_id);
    },

    promptDelete: function() {
        this.el.classList.add('cancel');
        this.el.querySelector('a').classList.add('cancel');
        this.el.querySelector('a').classList.remove('playable');

        this.el.querySelector('a > p:last-child').innerHTML = "Deleting...";
        this.el.querySelector('.playlist-time').innerHTML = "Cancel";

        var self = this;
        this.delete_id = window.setTimeout(function() {
            self.deleteSong();
        }, 5000);
    },

    cancelDelete: function() {
        clearInterval(this.delete_id);

        this.el.classList.remove('cancel');
        this.el.querySelector('a').classList.remove('cancel');

        this.el.querySelector('a > p:last-child').innerHTML = this.model.get('artist');
        this.el.querySelector('.playlist-time').innerHTML = toTime(this.model.get('time'));

        this.delete_id = null;

        // Hack to avoid touchstart on playable on the same time that touching cancel
        var self = this;
        setTimeout(function() {
            self.el.querySelector('a').classList.add('playable');
        }, 100);
    },

    deleteSong: function(){
        var self = this;
        var data = '';
        var socket_deleteSong = navigator.mozTCPSocket.open(settings.host, settings.port, { binaryType: 'string' });

        socket_deleteSong.onopen = function (event) {
            //~ console.log('socket_deleteSong open');
            socket_deleteSong.send(getCommand(command_delete_song.replace('param', self.model.get('songid'))));
        };
        socket_deleteSong.onclose = function (event) {
            //~ console.log('socket_deleteSong closed');
        };

        socket_deleteSong.ondata = function (event) {

            if (typeof event.data === 'string') {
                data += event.data;

                if (data.lastIndexOf("OK\n") > 0) {
                    //~ console.log(data);
                    console.log('Song ' + self.model.get('songid') + ' deleted');

                    socket_deleteSong.close();

                    self.remove();
                }

            } else {
                console.error('Fuck, received data is shitty');
                socket_deleteSong.close();
            }
        };
    },

    unrender: function(){
        this.el.parentNode.removeChild(this.el);
    },

    remove: function(){
        Backbone.pubSub.trigger('playlist:deleteSong', this.model);
        showBanner("Song <strong>removed</strong> from playlist");

        this.unrender();
    }
});

var ListPlaylistView = Backbone.View.extend({
    el: 'ul#playlist-list',

    initialize: function(){
        console.log('ListPlaylistView.initialize');

        _.bindAll(this, 'render', 'appendPlaylistSong');

        this.collection = new PlayList();
        this.collection.bind('add', this.appendPlaylistSong);

        Backbone.pubSub.on('playlist:addSong', this.addSong, this);
        Backbone.pubSub.on('playlist:currentSong', this.currentSong, this);
        Backbone.pubSub.on('playlist:deleteSong', this.deleteSong, this);
    },

    load: function() {
        var self = this;

        this.currentSongPosition = null;
        this.playlistFragment = document.createDocumentFragment();
        this.el.innerHTML = '';
        $('#playlist-view .search').val('');
        $('#playlist-view progress').show();

        this.collection.length = 0;
        var data = '';

        var socket_playlist = navigator.mozTCPSocket.open(settings.host, settings.port, { binaryType: 'string' });

        socket_playlist.onopen = function (event) {
            //~ console.log('socket_playlist open');

            socket_playlist.send(getCommand(command_playlistinfo));
        };
        socket_playlist.onclose = function (event) {
            //console.log('socket_playlist closed');
        };
        socket_playlist.ondata = function (event) {

            if (typeof event.data === 'string') {
                data += event.data;

                if (data.lastIndexOf("OK\n") > 0) {
                    //console.log(data);

                    socket_playlist.close();

                    var data_splitted = data.split("\n");
                    var song = null;

                    data_splitted.forEach( function (line) {
                        var regexped = line.match(/[A-Za-z]*: .*/);

                        if (regexped) {
                            var params = regexped[0].split(": ");

                            switch (params[0]) {
                                case 'file':
                                    if (song) {
                                        self.collection.add(song);
                                    }

                                    song = {};
                                    song.file = decodeURIComponent(escape(params[1]));
                                    break;
                                case 'Artist':
                                    song.artist = decodeURIComponent(escape(params[1]));
                                    break;
                                case 'Album':
                                    song.album = decodeURIComponent(escape(params[1]));
                                    break;
                                case 'Title':
                                    song.title = decodeURIComponent(escape(params[1]));
                                    break;
                                case 'Track':
                                    song.track = params[1];
                                    break;
                                case 'Time':
                                    song.time = params[1];
                                    break;
                                case 'Id':
                                    song.songid = params[1];
                                    break;
                            }
                        }
                    });
                    // Add last song
                    self.collection.add(song);

                    // Update status : need playlist loaded to set current song
                    mpd_status.update();
                }

            } else {
                console.error('Fuck, received data is shitty');
                socket_playlist.close();
            }
        };
    },

    render: function(){
        this.collection.each(this.appendPlaylistSong, this);
        this.el.appendChild(this.playlistFragment);
    },

    appendPlaylistSong: function(playlistSong){
        var playlistSongView = new PlaylistSongView({
            model: playlistSong
        });

        this.el.appendChild(playlistSongView.render().el);
    },

    addSong: function(song) {
        this.collection.add(song);
    },

    currentSong: function(position) {
        //~ console.log('currentSong - ' + position + '(' + this.currentSongPosition + ', ' + this.collection.models.length + ')');

        if ( (this.currentSongPosition) && (this.el.childNodes[this.currentSongPosition]) ) {
            // Render old currentSong
            this.el.childNodes[this.currentSongPosition].classList.remove('current');
        }

        // Render new currentSong
        this.el.childNodes[position].classList.add('current');

        this.currentSongPosition = position;
    },

    // Set correct position for all songs following deleted
    deleteSong: function(model) {
        this.collection.remove(model);
        mpd_status.update();
    }
});

var listPlaylistView = new ListPlaylistView();
