var settings = {
    host          : '',
    port          : -1,
    password      : '',
    display_cover : 2,

    initialize: function(values) {
        this.host     = values.host;
        this.port     = values.port;
        this.password = values.password || '';
        this.display_cover = values.display_cover;

        document.getElementById('host').value            = this.host;
        document.getElementById('port').value            = this.port;
        document.getElementById('password').value        = this.password || '';
        document.getElementById('display_cover').value   = this.display_cover;
    },

    save: function(values) {

        if (values.host) {
            this.host = values.host;
        }
        if (values.port) {
            this.port = values.port;
        }

        try {
            // If password setted or empty string, save it
            if (values.password.length >= 0) {
                this.password = values.password;
            }
        }
        // If no password in values, catch exception and do nothing
        catch (e if e instanceof TypeError) {
        }

        if (values.display_cover) {
            this.display_cover = values.display_cover;
        }

        database.saveSettings({"host": this.host, "port": this.port, "password": this.password, "display_cover": this.display_cover});
    }
};

document.getElementById('display_cover').addEventListener('change', function() {
    settings.save({'display_cover': this.value});
    getCover();
});

$('#settings-view form').bind('submit', function(event) {
    event.preventDefault();

    var form = event.target;

    var connectionStatus = false;
    var connectionError  = false;
    connectionMessage = document.getElementById("connection-message");
    connectionMessage.innerHTML = "<progress></progress> Connecting...";

    if (form.checkValidity()) {
        var test_host     = document.getElementById('host').value;
        var test_port     = document.getElementById('port').value;
        var test_password = document.getElementById('password').value;

        var self = this;
        var data = '';
        var socket_settings = navigator.mozTCPSocket.open(test_host, test_port, { binaryType: 'string' });

        socket_settings.onopen = function (event) {
            //~ console.log('socket_settings open');

            socket_settings.send(getCommandAuth(test_password));
        };
        socket_settings.onclose = function (event) {
            //~ console.log('socket_settings closed');

            if (!connectionStatus) {
                connectionMessage = document.getElementById("connection-message");
                connectionMessage.innerHTML = "Connection failed";
            } else if (!connectionError) {
                /* Update mpd status on some windows event */
                window.onfocus = function() {
                    mpd_status.update();
                };
                window.ononline = function() {
                    mpd_status.update();
                };
            }
        };
        socket_settings.ondata = function (event) {

            if (typeof event.data === 'string') {
                data += event.data;

                if (data.lastIndexOf("OK\n") > 0) {
                    // console.log(data);

                    connectionStatus = true;

                    if (data.contains('ACK [')) {
                        connectionError = true;

                        connectionMessage.innerHTML = "Connection failed<br/>Is the password required/correct ?";

                        socket_settings.close();
                        return;
                    }

                    connectionMessage.innerHTML    = "<progress></progress> Loading artists and playlist ...";

                    settings.save({'host': test_host, 'port': test_port, 'password': test_password});

                    // Load data first
                    listArtistsView.load();
                    listPlaylistView.load();

                    socket_settings.close();
                }

            } else {
                console.error('Fuck, received data is shitty');
                connectionMessage.innerHTML = "Connection failed (data type error)";
                socket_settings.close();
            }
        };
    }
});
