var Song = Backbone.Model.extend({
    defaults: {
        file   : '',
        title  : '',
        album  : '',
        artist : '',
        track  : '',
        time   : '',
        loading: false,
    }
});

var SongsList = Backbone.Collection.extend({
    model: Song,

    comparator: function(model) {
        return model.get('track');
    }
});

var SongView = Backbone.View.extend({
    tagName: 'li',

    events: {
        'click': 'addSong'
    },

    initialize: function(){
        _.bindAll(this, 'render', 'addSong');

        this.model.bind('change', this.render);
    },

    render: function(){
        var classes = '';
        if (this.model.get('loading')) {
            classes += 'loading';
        }

        this.el.innerHTML =
            '<button class="' + classes + '">' +
            '<aside class="song-time">' + toTime(this.model.get('time')) + '</aside>' +
            '<p class="song-title">' + this.model.get('title') + '</p>' +
            '</button>';

        return this;
    },

    addSong: function(){
        console.log('SongView.addSong : ' + this.model.get('file'));

        var self = this;
        var data = '';
        var socket_songs = navigator.mozTCPSocket.open(settings.host, settings.port, { binaryType: 'string' });

        socket_songs.onopen = function (event) {
            //~ console.log('socket_songs open');

            socket_songs.send(getCommand(command_add_song.replace('param', unescape(encodeURIComponent(self.model.get('file'))))));
        };
        socket_songs.onclose = function (event) {
            //console.log('socket closed');
        };
        socket_songs.ondata = function (event) {

            if (typeof event.data === 'string') {
                data += event.data;

                if (data.lastIndexOf("OK\n") > 0) {
                    //~ console.log(data);

                    socket_songs.close();

                    var data_splitted = data.split("\n");

                    data_splitted.forEach( function (line) {
                        var regexped = line.match(/[A-Za-z]*: .*/);

                        if (regexped) {
                            var params = regexped[0].split(": ");

                            switch (params[0]) {
                                case 'Id':
                                    self.model.set(
                                        {
                                            'songid': params[1],
                                            'loading': true
                                        }
                                    );

                                    Backbone.pubSub.trigger('playlist:addSong', self.model.attributes);
                                    break;
                            }
                        }
                    });

                }

            } else {
                console.error('Fuck, received data is shitty');
                socket_playsong.close();
            }
        };
    }

});

var ListSongsView = Backbone.View.extend({
    el: 'ul#songs-list',

    initialize: function(options){
        console.log('ListSongsView.initialize');
        _.bindAll(this, 'render', 'appendSong');

        this.collection = new SongsList();
        this.collection.bind('add', this.appendSong);

        var progress = this.el.parentNode.querySelector('progress');

        this.el.innerHTML = '';
        progress.classList.remove('hidden');

        var self = this;
        var data = '';
        var socket_songs = navigator.mozTCPSocket.open(settings.host, settings.port, { binaryType: 'string' });

        socket_songs.onopen = function (event) {
            //~ console.log('socket_songs open');

            socket_songs.send(getCommand(command_list_songs.replace('param', options.album)));
        };
        socket_songs.onclose = function (event) {
            //console.log('socket closed');
        };
        socket_songs.ondata = function (event) {

            if (typeof event.data === 'string') {
                //~ console.log(event.data);
                data += event.data;

                if (data.lastIndexOf("OK\n") > 0) {
                    //~ console.log(data);
                    socket_songs.close();

                    var data_splitted = data.split("\n");
                    var song = null;

                    data_splitted.forEach( function (line) {
                        var regexped = line.match(/[A-Za-z]*: .*/);

                        if (regexped) {
                            var params = regexped[0].split(": ");

                            switch (params[0]) {
                                case 'file':
                                    if (song) {
                                        self.collection.add(song);
                                    }

                                    song = {};
                                    song.file = decodeURIComponent(escape(params[1]));
                                    break;
                                case 'Artist':
                                    song.artist = decodeURIComponent(escape(params[1]));
                                    break;
                                case 'Album':
                                    song.album = decodeURIComponent(escape(params[1]));
                                    break;
                                case 'Title':
                                    song.title = decodeURIComponent(escape(params[1]));
                                    break;
                                case 'Track':
                                    song.track = params[1];
                                    break;
                                case 'Time':
                                    song.time = params[1];
                                    break;
                                case 'Genre':
                                    break;
                            }
                        }
                    });
                    // Add last song
                    self.collection.add(song);

                    progress.classList.add('hidden');

                    if (self.collection.length === 0) {
                        showBanner("<p>No song</p>");
                    }
                }

            } else {
                console.error('Fuck, received data is shitty');
                socket_songs.close();
            }
        };

        var viewSongs = document.getElementById("songs-view");
        viewSongs.classList.remove('move-right');
        viewSongs.classList.add('move-left');

        var divSongs = document.getElementById('div-songs');
        divSongs.scrollTop = 0;
    },

    appendSong: function(song){
        var songView = new SongView({
            model: song
        });
        this.el.appendChild(songView.render().el);
    },

});
