# SimpleRSS

SimpleRSS is a simple RSS/Atom client for Firefox OS.

![SimpleRSS Feeds list](http://user1.be/simplerss/01.png "SimpleRSS Feeds list")

## Features

- Works offline
- View by Feeds or Timeline
- Privacy : standalone application, does not depend on online service
- Export/Import OPML version 1
- Search
- Share urls

## Links

- [Homepage](http://simplerss.user1.be/)
- [Marketplace](https://marketplace.firefox.com/app/simplerss/)
- [Mercurial repository](http://hg.user1.be/simplerss/)
- [Bug tracker](http://tracker.user1.be/SimpleRSS/)

## Privacy

SimpleRSS does not collect or share personal information.

## Localization and contribution

SimpleRSS supports the localization. If your language is not supported or incomplete, you can propose your translation on [Transifex](https://www.transifex.com/projects/p/simplerss/) or on the [bug tracker](http://tracker.user1.be/SimpleRSS/).

In the same way, suggestions and code contributions are welcome on the bug tracker.

## Licence

SimpleRSS is released under GPLv3.

## Contact

pumpkin <pumpkin@mailoo.org>

## How to use it in Firefox browser

It's more convenient to use the application in the Firefox browser during the development. To do that, simply open the index.html.

However, you need to enable the SystemXHR permission in the Firefox browser to allow cross domain requests used for feeds reloading.

1. Open the error console by pressing: CTRL + SHIFT + J
2. Copy and paste the following code in the error console by replacing « (http|file)://host/index.html » by the URL you use to open the index.html:

    host = '(http|file)://host/index.html';
    perm = Components.classes["@mozilla.org/permissionmanager;1"].createInstance(Components.interfaces.nsIPermissionManager);
    ios = Components.classes["@mozilla.org/network/io-service;1"].getService(Components.interfaces.nsIIOService);
    uri = ios.newURI(host, null, null);
    perm.add(uri, 'systemXHR', 1);
    'Successfully added systemXHR permission for ' + host;

3. Press enter. The message « Successfully added systemXHR permission for http://the-domain-you-enter » should appear.

You should know that some features don't work because they use specific javascript functions of the Firefox OS API:

- Sharing an item by mail or with other applications
- Opening an item in the browser
- Exporting feeds to SDCard.

## Tests

There are some javascript unit tests written with Jasmine. To run them, simple open the file tests/SpecRunner.html.

You also have to enable the SystemXHR permission in the Firefox browser to allow cross domain requests used for feeds reloading. See the previous point to allow the test URL.
