(function (document) {

    var viewAdd = document.getElementById("add-view");
    var feedUrl = document.getElementById("feed-url");
    var addSwitchBtn = document.getElementById('add-switch-btn');

    navigator.mozSetMessageHandler('activity', function(activityRequest) {
        console.log('activity');

        var option = activityRequest.source;
        var data   = option.data;

        console.log(option.name + ' - ' + option.type);

        // Webactivities 'save-bookmark' or 'share'
        if ( (option.name === "save-bookmark") || (option.name === "share") ) {
            //~ console.log("activity save-bookmark or share");
            //~ console.log(data.url);
            //~ console.log(data.name);

            addSwitchBtn.click();

            viewAdd.classList.remove('move-bottom');
            viewAdd.classList.add('move-up');

            feedUrl.value = decodeURIComponent(data.url);
        }

        // Webactivity 'open'
        if (option.name === "open") {
            var blob = data.blob;
            var type = data.type;

            //~ console.log("activity open");
            //~ console.log(blob);
            //~ console.log(type);

            // Extract data from blob
            var reader = new FileReader();
            reader.addEventListener("loadend", function() {
                // reader.result contains the contents of blob as a typed text
                var opmlContent = reader.result;
                //~ console.log('opmlContent', opmlContent);

                // Parse opml content
                var opmlParser = OpmlParser();

                navigator.mozL10n.ready(function() {
                    opmlParser.parse(opmlContent, feedList);
                });

            });
            reader.readAsText(blob);
        }
    });

})(document);

(function (document) {

    navigator.mozSetMessageHandler("alarm", function (alarm) {
        console.log('alarm');

        if(alarm.data.action == ALARM_ACTION_RELOAD) {
            console.log("alarm reload");
            Backbone.pubSub.trigger('feed:reloadAll');
            updateAutoRefresh();
        }

    });

})(document);
