/* Add & import view */
(function (document) {

    var btnAdd         = document.getElementById("add-btn");
    var btnBackAddView = document.getElementById("add-back-btn");
    var btnOpmlSwitch  = document.getElementById("opml-switch-btn");
    var btnAddSwitch   = document.getElementById("add-switch-btn");

    var viewAdd = document.getElementById("add-view");

    var opmlFormContainer  = document.getElementById("import-opml-container");
    var addFormContainer  = document.getElementById("add-feed-container");

    btnAdd.addEventListener ('click', function () {
        viewAdd.classList.remove('move-down');
        viewAdd.classList.add('move-up');
    });

    btnBackAddView.addEventListener ('click', function () {
        viewAdd.classList.remove('move-up');
        viewAdd.classList.add('move-down');
    });

    btnOpmlSwitch.addEventListener ('click', function () {
        opmlFormContainer.hidden = false;
        addFormContainer.hidden = true;

        btnOpmlSwitch.parentNode.classList.add('active');
        btnAddSwitch.parentNode.classList.remove('active');
    });

    btnAddSwitch.addEventListener ('click', function () {
        opmlFormContainer.hidden = true;
        addFormContainer.hidden = false;

        btnOpmlSwitch.parentNode.classList.remove('active');
        btnAddSwitch.parentNode.classList.add('active');
    });

    /* Edit view */
    var btnEdit         = document.getElementById("edit-btn");
    var btnBackEditView = document.getElementById("edit-back-btn");

    var viewEdit = document.getElementById("edit-view");

    btnEdit.addEventListener ('click', function () {
        viewEdit.classList.remove('move-down');
        viewEdit.classList.add('move-up');
    });

    btnBackEditView.addEventListener ('click', function () {
        viewEdit.classList.remove('move-up');
        viewEdit.classList.add('move-down');
    });

    /* Items & Detail view */
    var btnBackToItems = document.getElementById("back-items-btn");

    var viewItems  = document.getElementById("items-view");
    var viewDetail = document.getElementById("detail-view");

    var displayTimeline = document.getElementById("display_timeline");

    btnBackToItems.addEventListener ('click', function () {
        viewDetail.classList.remove('move-center');

        if (displayTimeline.classList.contains('active')) {
            var drawer = document.getElementById('drawer');
            drawer.classList.remove('fade-left');
        } else {
            var viewItems = document.getElementById('items-view');
            viewItems.classList.remove('fade-left');
        }
    });

    /* Settings */
    var viewSettings = document.getElementById("settings");

    document.getElementById("menu-settings").addEventListener('click', function() {
        viewSettings.classList.remove('move-down');
        viewSettings.classList.add('move-up');
    });

    var btnCloseSettings  = document.getElementById("settings-close-btn");

    btnCloseSettings.addEventListener('click', function() {
        viewSettings.classList.remove('move-up');
        viewSettings.classList.add('move-down');
    });

})(document);

/* Settings */
(function (document) {
    var menu              = document.getElementById('menu');
    var drawer            = document.getElementById('drawer');
    var drawerShowBtn     = document.getElementById('drawer-button');
    var drawerHideBtn     = document.getElementById('drawer-hide-button');
    var isSettingsVisible = false;

    // Show menu on drawerShowBtn click
    drawerShowBtn.addEventListener('click', function() {
        isSettingsVisible = true;
        menu.hidden       = false;
    });

    // Flag menu as hidden when drawerHideBtn clicked
    drawerHideBtn.addEventListener('click', function() {
        isSettingsVisible = false;
    });

    // Flag menu as hidden when <a/> in menu clicked
    menu.addEventListener('click', function(event) {
        if (event.target.tagName === 'A' || event.target.parentNode.tagName === 'A') {
            isSettingsVisible = false;
        }
    });

    // Hide menu when drawer transition ends
    drawer.addEventListener('transitionend', function(event) {
        if (event.propertyName === "transform" && !isSettingsVisible) {
            menu.hidden = true;
        }
    });
})(document);

/* Timeline/Feeds */
(function (document) {

    var displayTimeline = document.getElementById("display_timeline");
    var displayFeeds    = document.getElementById("display_feeds");

    var btnSearch  = document.getElementById("search-btn");
    var search     = document.getElementById("search");
    var searchForm = document.getElementById("searchForm");

    var divTimeline  = document.getElementById("div-timeline");
    var timelineList = document.getElementById("timeline-list");
    var divIndex     = document.getElementById("div-index");

    displayTimeline.addEventListener('click', function() {
        // Load timeline
        timelineView.loadTimeline();

        displayTimeline.classList.add('active');
        displayFeeds.classList.remove('active');

        divIndex.classList.add('fade-out');
    });

    displayFeeds.addEventListener('click', function() {
        displayTimeline.classList.remove('active');
        displayFeeds.classList.add('active');

        divTimeline.classList.add('fade-out');
    });

    // Hide divIndex when divIndex transition ends
    divIndex.addEventListener('transitionend', function(event) {
        //~ console.log('divIndex transition end');

        if (!divIndex.classList.contains('fade-out')) {
            return;
        }

        divIndex.hidden    = true;
        divTimeline.hidden = false;

        setTimeout(function() {
            divTimeline.classList.remove('fade-out');
        }, 100);

    });

    // Hide and clear divTimeline when divTimeline transition ends
    divTimeline.addEventListener('transitionend', function(event) {
        //~ console.log('divTimeline transition end');

        if (!divTimeline.classList.contains('fade-out')) {
            return;
        }

        timelineView.cleanTimeline();

        divTimeline.scrollTop = 0;
        divTimeline.hidden    = true;
        divIndex.hidden       = false;

        // Leave search
        if (!searchForm.classList.contains('hidden')) {
            btnSearch.click();
        }

        setTimeout(function() {
            divIndex.classList.remove('fade-out');
        }, 100);
    });

    btnSearch.addEventListener('click', function() {
        // Enable search
        btnSearch.parentNode.classList.toggle('active');
        searchForm.classList.toggle('hidden');

        // Show timeline (with search input)
        if (!searchForm.classList.contains('hidden')) {
            timelineView.cleanTimeline();

            divTimeline.classList.remove('fade-out');
            divTimeline.hidden = false;
            divIndex.hidden    = true;

            displayTimeline.classList.add('active');
            displayFeeds.classList.remove('active');

            search.focus();
        } else {
            // Reset input
            search.value = "";

            // Reload timeline
            timelineView.loadTimeline();
        }
    });

    /* Leave search when mark all feeds read */
    var markAllFeedsRead = document.getElementById("mark-all-feeds-read");

    markAllFeedsRead.addEventListener('click', function() {
        //
        if (!searchForm.classList.contains('hidden')) {
            btnSearch.click();
        }
    });


})(document);
