settings = {
    values: {
        // default values
        "history"          : 100,
        "hide_read"        : false,
        "big_font"         : false,
        "auto_refresh"     : false,
        "notification"     : false,
    },

    render: function() {
        document.getElementById("history_number").value      = this.values.history;
        document.getElementById("history_label").textContent = this.values.history;

        document.getElementById("auto_refresh_time").value = this.values.auto_refresh;

        updateHideReadLabel();
        updateAutoRefresh();
        updateNotification();

        if (this.values.big_font) {
            document.getElementById('font-size-btn').classList.remove('text-muted');
            document.getElementById('detail-description').classList.add('big');
        }
    },

    initialize: function(values) {
        console.log('initialize settings');

        this.values = values;

        this.render();
    },

    update: function(key, value) {
        console.log('update settings : ' + value);
        this.values[key] = value;

        database.saveSettings(this.values);
    }
};

/* Toggle some settings */
function toggleSetting(optionId, labelId, settingValueTrue) {
    var option = document.getElementById(optionId);
    var label  = document.getElementById(labelId);

    if (settingValueTrue) {
        option.classList.remove('text-muted');
        label.textContent = translate('yes');
    } else {
        option.classList.add('text-muted');
        label.textContent = translate('no');
    }
}

// Toggle Hide/show read
function updateHideReadLabel() {
    toggleSetting("hide_read", "hide_read_label", settings.values.hide_read);
}

// Toggle auto-refresh
function updateAutoRefresh() {
    toggleSetting("auto_refresh", "auto_refresh_label", settings.values.auto_refresh);

    if ( (settings.values.auto_refresh) && (settings.values.auto_refresh != AUTOREFRESH_STARTUP) ) {
        scheduleAlarm();
    } else {
        removeAlarm();
    }
}

// Toggle notification
function updateNotification() {
    toggleSetting("notification", "notification_label", settings.values.notification);
}

/* Toggle font size in detail */

(function (document) {
    var fontSizeBtn       = document.getElementById('font-size-btn');
    var detailDescription = document.getElementById('detail-description');

    fontSizeBtn.addEventListener('click', function() {
        fontSizeBtn.classList.toggle('text-muted');
        detailDescription.classList.toggle('big');

        settings.update("big_font", detailDescription.classList.contains('big'));
    });
})(document);

/* Bind settings changes */

// History number
document.getElementById("history_number").addEventListener('change', function() {
    console.log('history change : ' + this.value);

    document.getElementById("history_label").textContent = this.value;

    settings.update("history", this.value);
});

// Hide read
document.getElementById("hide_read").addEventListener('click', function() {
    settings.update("hide_read", !settings.values.hide_read);

    updateHideReadLabel();

    // Refresh timeline
    if (!document.getElementById('div-timeline').hidden) {
        timelineView.loadTimeline();
    }
});

// Auto-refresh
document.getElementById('auto_refresh_time').addEventListener('change', function() {
    settings.update("auto_refresh", this.value);

    updateAutoRefresh();
});

// Notification
document.getElementById('notification').addEventListener('click', function() {
    settings.update("notification", !settings.values.notification);

    updateNotification();
});
