var TimelineView = Backbone.View.extend({
    el: '#div-timeline',

    events: {
        'click #updateTimeline' : 'loadTimeline',
        'scroll'                : 'checkScroll',
        'keyup #search'         : 'searchInput'
    },

    // Created by FeedList (collection)
    initialize: function() {
        _.bindAll(this, 'checkScroll', 'searchInput');

        Backbone.pubSub.on('timeline:notifyUpdate', this.notifyUpdate, this);
        Backbone.pubSub.on('timeline:appendOne', this.appendOne, this);

        this.timelineList         = document.getElementById("timeline-list");
        this.updateTimelineButton = document.getElementById("updateTimeline");
        this.noitem               = document.getElementById('notimeline');
        this.search               = document.getElementById('search');
        this.searchForm           = document.getElementById('searchForm');

        this.newItemsCount = 0;
        this.items = [];
    },

    cleanTimeline: function() {
        // Reset view
        this.pagination             = 0;
        this.timelineList.innerHTML = '';
        this.newItemsCount          = 0;
        this.appending              = false;

        // Hide update button
        this.updateTimelineButton.classList.add('hidden');
        this.updateTimelineButton.innerHTML = "";

        // Fill array with items of all feeds
        this.items  = [];
        this.titles = {};
    },

    loadTimeline: function() {
        console.log("Timeline.loadTimeline");

        // Clean timeline
        this.cleanTimeline();

        // Get all feeds
        var feeds = feedList.models;

        for (var i=0, length=feeds.length; i < length; i++) {
            this.items = this.items.concat(feeds[i].get('items').slice(0));
            this.titles[feeds[i].get('url')] = feeds[i].get('title');
        }

        // Sort by dates
        this.items.sort(function(item1, item2) { return item2.date - item1.date; });

        // Load new items
        this.appendItems(20);

    },

    notifyUpdate: function(items) {
        // Remove items without date
        for (var i=0, length=items.length; i < length; i++) {
            if ( (!items[i]) || (!items[i].date) ) {
                items.splice(i, 1);
                length--;
                i--;
            }
        }

        // If items contain some elements after removing incorrect dates
        if (items.length) {
            // Add new items to list of items to be updated and sort
            this.newItemsCount += items.length;

            // Update button notifying new items
            this.updateTimelineButton.innerHTML =  translate('newitems', { 'number' : this.newItemsCount });
            this.updateTimelineButton.classList.remove('hidden');
        }
    },

    checkScroll: function (evt) {
        if( (!this.appending) && (evt.target.scrollTopMax - evt.target.scrollTop === 0) ) {
            this.appendItems(20);
        }
    },

    appendOne: function () {
        console.log('Timeline.appendOne');
        this.appendItems(1);
    },

    appendItems: function(number) {
        this.appending = true;

        // Append max 20 el in UI
        var pagination_max = this.pagination + number;

        if (this.pagination > this.items.length) {
            this.pagination = this.items.length;
        }

        if (pagination_max > this.items.length) {
            pagination_max = this.items.length;
        }

        // Loop through items
        var now = Date.now();
        var self = this;

        var isSearch    = !self.searchForm.classList.contains('hidden');
        var isInSearch  = true;
        var searchValue = self.search.value.toLowerCase();

        for (var i = self.pagination; i < pagination_max; i++) {

            var item = null;

            // Filter if search
            if (isSearch && searchValue) {
                try {
                    // Filter on title
                    isInSearch = self.items[i].title.toLowerCase().contains(searchValue);

                    // Filter on description
                    isInSearch = isInSearch || self.items[i].description.toLowerCase().contains(searchValue);
                } catch (e) {
                    // Probably description field does not exist.
                    console.log('Search - description field of item does not exist', isInSearch);

                    item = new Item(self.items[i]);
                    isInSearch = isInSearch || item.getContent().toLowerCase().contains(searchValue);
                }
            }

            // Don't add if hide read, but loop one more time
            // Don't display strange items which date > now
            if ( (settings.values.hide_read && self.items[i].read) || (!self.items[i].date) || (self.items[i].date > now) || !isInSearch ) {
                if (pagination_max < self.items.length) {
                    pagination_max++;
                }
            } else {
                if (!item) {
                    item = new Item(self.items[i]);
                }
                self.addItem(item, searchValue);
            }

        }

        this.showHideNoitem();

        this.pagination = i;
        this.appending  = false;

    },

    addItem: function(item, searchValue, prepend) {
        var itemView = new ItemView({
            model: item
        });

        // Hack to set title to itemView
        itemView.timeline = {
            'feedTitle' : this.titles[item.get('url')],
            'highlight' : searchValue
        };

        if (prepend) {
            $('#timeline-list', this.el).prepend(itemView.render().el);
        } else {
            $('#timeline-list', this.el).append(itemView.render().el);
        }
    },

    searchInput: function() {
        this.timelineList.classList.add('loading');

        // Clear previous delayed search
        if (this.searchInputTimeout) {
            clearInterval(this.searchInputTimeout);
        }

        // Run search after delay
        var self = this;
        this.searchInputTimeout = setTimeout(function() {
            self.timelineList.classList.remove('loading');

            self.loadTimeline.call(self);
        }, 800);
    },

    showHideNoitem: function() {
        if (!this.timelineList.childNodes.length) {
            this.noitem.hidden = false;
        } else {
            this.noitem.hidden = true;
        }
    }

});

var timelineView;
