/* Tricky.Stuff : fix correct height for scrolling div */
(function () {

    var divWithToolbars = ["div-items", "div-detail"];

    function updateHeight() {
        var divMainList = Array.filter( document.getElementsByTagName('div'), function(element){
            return element.getAttribute('role') == 'main';
        });

        for (var i=0; i < divMainList.length; i++) {

            if (divWithToolbars.indexOf(divMainList[i].id) > -1) {
                divMainList[i].style.height = window.innerHeight - 110 + "px";
            } else {
                divMainList[i].style.height = window.innerHeight - 70 + "px";
            }

        }

        document.getElementById("nav-menu").style.height = window.innerHeight - 70 + "px";
    }

    window.onresize = updateHeight;
    updateHeight();

})(window, document);

// Reset related input on reset button click
(function() {
    var resetButtons = document.querySelectorAll("[type='reset']");

    for (var i=0; i<resetButtons.length; i++) {

        resetButtons[i].addEventListener("touchstart", function click(event) {
            var input   = event.currentTarget.previousElementSibling;

            input.value = '';
            $(input).trigger('keyup');

            setTimeout(function() {
                input.focus();
            }, 100);
        });

    }
})(document);

function highlight(string, key) {
    var regex = new RegExp("(" + key + ")", "gi");

    return string.replace(regex, "<span class='highlight'>$1</span>");
}

function notifyUser(body) {
    // Check if the app is NOT in the foreground and trigger notification
    if ( (document.hidden) && (settings.values.notification) ) {
        var notification = new Notification("SimpleRSS", {
            'icon' : 'http://simplerss.user1.be/icon-notification.png',
            'body' : body,
            'tag'  : 'SimpleRSS'
        });

        // Open SimpleRSS when clicking on notification
        notification.addEventListener('click', function(event) {
            // Close the notification
            event.currentTarget.close();

            // Open the app
            var request = window.navigator.mozApps.getSelf();

            request.onsuccess = function() {
                if (request.result) {
                    request.result.launch();
                }
            }
        });
    } else {
        console.log('notifyUser: Do nothing');
    }
}

function scheduleAlarm() {
    var callback = function() {
        var nextAlarm = settings.values.auto_refresh * 60000;
        var alarmDate = new Date(Date.now() + nextAlarm);

        var data = {
          action: ALARM_ACTION_RELOAD
        }

        // Schedule alarm reload
        var request = navigator.mozAlarms.add(alarmDate, "honorTimezone", data);

        request.onsuccess = function () {
          console.log("Alarm: scheduled at " + alarmDate);
        };

        request.onerror = function () {
          console.log("Alarm: error in scheduling: " + this.error.name);
        };
    }

    removeAlarm(callback);
}

function removeAlarm(callback) {
    var request = navigator.mozAlarms.getAll();

    request.onsuccess = function () {
        this.result.forEach(function (alarm) {
            if (alarm.data.action == ALARM_ACTION_RELOAD) {
                console.log("Alarm: remove " + alarm.id);
                navigator.mozAlarms.remove(alarm.id);
            }
        });

        if (callback) {
            callback();
        }
    };

    request.onerror = function () {
      console.log("Alarm: remove error: " + this.error.name);
    };
}
