var news_limit = 10;
var news_offset = 0;
var KEY = 'pagk6dqqj9gcdby3k5gc7qap';

$(document).bind("pageinit", function () {
    $.mobile.allowCrossDomainPages = true;
    $.support.cors = true;
	$.mobile.loader.prototype.options.text = "Please wait...";
	$.mobile.loader.prototype.options.textVisible = true;
	$.mobile.loader.prototype.options.theme = "e";

    load_more_news();

    $("a#load-more").on("click", function(e) {
		e.preventDefault();
		load_more_news();
    });

});

$(document).on("pageshow", function() {
	$.mobile.loading( "show", {
		text: "Getting soccer updates...",
		theme: "b",
		textVisible: true,
		textonly: false
	});
});

$( document ).on( "click", ".news-link", function(e) {
	e.preventDefault();
	var url = $(this).attr("href");
	loadContent(url);
	return false;
});

function loadContent(url) {

	$.mobile.loading( "show", {
		text: "Loading news...",
		theme: "b",
		textVisible: true,
		textonly: false
	});

    $.ajax({
        url: url, 
        data: { 
            apikey: KEY,
            _accept: "application/json"
        }, 
        dataType: "jsonp", 
        beforeSend: function() {
        } 
    }).done(function(data) {
		if (data.headlines[0].headline) {
			$('#popupBasic').find('div h1').text(data.headlines[0].headline);
			$('#popupBasic').find('h2.headline').html('<a href="'+data.headlines[0].links.mobile.href+'" onclick="window.open(this.href, \'_system\'); return false;">' + data.headlines[0].headline + '</a>');
		}

		if (data.headlines[0].title) {
			$('#popupBasic').find('p.title').text(data.headlines[0].title);
		}

		if (data.headlines[0].images[1]) {
			$('#popupBasic').find('.story-img').attr("src", data.headlines[0].images[1].url);
		} else if (data.headlines[0].images[0]) {
			$('#popupBasic').find('.story-img').attr("src", data.headlines[0].images[0].url);
		}

		if (data.headlines[0].description) {
			$('#popupBasic').find('p.desc').text(data.headlines[0].description);
		}
		$('#popupBasic').popup('open');
    }).fail(function() {
		$('#popupBasic').find('div h1').text("Error");
		$('#popupBasic').find('p.title').text("Unable to load news!");
		$('#popupBasic').popup('open');
    }).complete(function() {
		$.mobile.loading( "hide" );
    });
}

function load_more_news(){
    news_offset += news_limit;

	$.mobile.loading( "show", {
		text: "Getting soccer updates...",
		theme: "b",
		textVisible: true,
		textonly: false
	});

    $.ajax({
        url: "http://api.espn.com/v1/sports/soccer/fifa.world/news/headlines", 
        data: { 
            // enter your developer api key here 
            apikey: KEY,
            // the type of data you're expecting back from the api 
            _accept: "application/json",
            // number of results to be shown
            limit: news_limit,
            offset: news_offset
        }, 
        dataType: "jsonp", 
        beforeSend: function() {
        } 
    }).done(function(data) {
        $.each(data.headlines, function() { 
			var htm = "";
			var ID = this.id;
			htm += "<li id='"+this.id+"'>";
			htm += '<a href="'+this.links.api.news.href+'" class="link news-link">';
			htm += '<div class="img-holder"></div>';
			if (this.headline) {
				htm += '<h2>'+this.headline+'</h2>';
			}
			htm += '<p><strong>'+ this.title +'</strong></p>';
			if (this.description) {
				htm += '<p>'+ this.description +'</p>';
			}
			htm += '</a>';
			htm += '</li>';
			$("#list-headlines").append(htm);

			if (this.images[1]) {
				var img = $("<img />").attr('src', this.images[1].url)
				.load(function() {
					if (!this.complete || typeof this.naturalWidth == "undefined" || this.naturalWidth === 0) {
					} else {
						$("#"+ID).find(".img-holder").append(img);
					}
				});
			}

        });

		$('#list-headlines').listview('refresh');
    }).fail(function() {
		$('#popupBasic').find('div h1').text("Error");
		$('#popupBasic').find('p.title').text("Unable to load news!");
		$('#popupBasic').popup('open');
    }).complete(function() {
        $("#load-more").show();
		$.mobile.loading( "hide" );
    });
}
