app.directive('ngEnter', function() {
    return function(scope, elm, attrs) {
        elm.bind('keypress', function(e) {
            if (e.charCode === 13) scope.$apply(
                function(){
                    /* Send jQuery press event to Angular function */
                    scope.pressEnter(e);
                }
            );
        });
    };
});

app.directive('tabs', function() {
    return {
      restrict: 'E',
      transclude: true,
      scope: {},
      controller: function($scope, $element, $timeout ) {
        var panes = $scope.panes = [];

        $scope.select = function(pane) {
            angular.forEach(panes, function(pane) {
                pane.selected = false;
            });
            pane.selected = true;
        }

        this.addPane = function(pane) {
            if (panes.length == 0){
                $scope.select(pane);
            }
            panes.push(pane);
        }
      },
      templateUrl: 'app/templates/tab.html',
      replace: true
    };
});

app.directive('pane', function() {
    return {
      require: '^tabs',
      restrict: 'E',
      transclude: true,
      scope: { title: '@', icon: '@' },
      link: function( $scope, element, attrs, tabsCtrl) {
        tabsCtrl.addPane( $scope);
      },
      templateUrl: 'app/templates/pane.html',
      replace: true
    };
});

app.directive('song', function(){
    return {
      restrict: 'E',
      transclude: true,
      scope: {
          data: '='
      },
      templateUrl: 'app/templates/song.html',
      replace: true,
      link: function( $scope, $elem ) {

          $elem.bind("click",function(){
              document.querySelector('#song-page').className = 'current';
              document.querySelector('[data-position="current"]').className = 'left';

              $scope.openSong();
          });


      },
      controller: function( $scope, $attrs, $rootScope ) {
          $scope.openSong = function(){
              $rootScope.openSongPage( $scope.data );
          }
      }
    };
});

app.directive('loading', function(){
    return {
      restrict: 'E',
      replace: true,
      scope: {
          display: '='
      },
      templateUrl: 'app/templates/loading.html'
    };
});
