var STORAGE_KEY= 'hits';
var CHART_URL = "http://chordtabs.in.th/chart.html";
var UPDATE_PERIOD = 1000*60*60*24*7;
function HitCtrl($scope, xhr ){

    init();

    $scope.lastupdate = function(){
        var currentDate = new Date($scope.data.lastUpdated);
        var day = currentDate.getDate()
        var month = currentDate.getMonth() + 1
        var year = currentDate.getFullYear()
        var result = day + "/" + month + "/" + year;
        return result;
    }

    function init(){
        if(!localStorage.getItem(STORAGE_KEY)){
            getSongs();
        }else{
            $scope.data = localStorage.getObject(STORAGE_KEY);

            var currentTime = new Date();
            var lastTime = new Date($scope.data.lastUpdated);
            var timedelta = currentTime - lastTime;
            if( timedelta > UPDATE_PERIOD ){
                getSongs();
            }
        }
    }

    function getSongs(){
        xhr.get( { url: CHART_URL }, function(data){
            var links = data.match(/<a[^>]*>(.*?)<\/a>/g);
            $scope.data = {
                songs: linksToJSON(links),
                lastUpdated: new Date()
            };
            localStorage.setObject( STORAGE_KEY, $scope.data);
        });
    }

    function linksToJSON(links){
        var res = [];
        var i = 0;
        var count = 0;
        while( count < 5 ){
            var link = links[i];
            if( link.match(/song_id=[0-9]+/) )
            {
                var song = {};
                song['url'] = CHORDTABS_URL + link.match(/href="(.*?)"/)[1];

                var songInfo = link.match(/<a.*>(.*?)<\/a>/)[1].replace(/[0-9]+\.\s/,'').split(' - ');
                song['artist'] = songInfo[0];
                song['name'] = songInfo[1];

                res.push(song);
                count++;

            }
            i++;
        }
        return res;

    }
}
