function SearchCtrl($scope, $timeout, xhr){

    $scope.searchNotFound = false;
    $scope.loadingObj = { isLoading: false };

    /* Songs result from searching */
    $scope.songs = [];
    $scope.search = function(){
        /* Prevent searching from empty query */
        if( $scope.q == '' ){
            return;
        }

        var url = "http://chordtabs.in.th/admin/ui/search.php?xjxfun=writeSongDiv&xjxr=1336961115600&xjxargs[]="+$scope.q;
        $scope.loadingObj.isLoading = true;

        $scope.songs = [];

        xhr.get( { url: url }, function(data){
            $scope.songs = $scope.getSearchResult( data, $scope.q );

            if( !$scope.songs || $scope.songs.length == 0 ) {
                $scope.searchNotFound = true;
            }

            $scope.loadingObj.isLoading = false;

            $scope.$apply();
        });

    };

    $scope.reset = function(){
        $scope.q = '';
        $('input').focus(); // focus search box.
        $scope.songs = [];
    };

    /*
     * Get result data with option
     *  Description : Get JSON  data that recieve from ChordTabs.in.th
     */
    $scope.getSearchResult = function( data, word, shift_flag ){
        var table_data;
        try {
            table_data = x2js.xml_str2json(data).xjx.cmd_asArray[1].__cdata;
        } catch(err) {
            return;
        }

        // Rewrite Chord's URL to external url
        var rewrite_url = table_data.replace(/(\.\.\/){2}/g,CHORDTABS_URL) ;

        var $my_data = $(rewrite_url);
        var $my_table = null;

        $.map( $my_data, function(n,i){
            if( i == 0 ){
                $my_table = $(n);
            }
        });

        var my_json = $($my_table).tb2json(); // Convert Table to JSON

        var search_result = { songs : [] };

        /*
         * Search Option
         * Enter           => Serach from song's name
         * Shift + Enter   => Search from Lyric
         */

        var songs =[]
        var word = word.toLowerCase();
        for( var i = 0 ; i < my_json['songs'].length ; i++ )
        {
                var song = my_json['songs'][ i ];
                song.id = song.url.match(/song_id=(\d+)/)[1];
                songs.push( song );
        }
        return songs;
    }

}
