app.service('favService', function(){
    var STORAGE_KEY = 'favorite';

    this.favList = localStorage.getObject(STORAGE_KEY) || [];

    this.fav = function(song) {
        this.favList.push(song);

        this.save();
    };

    this.unfav = function(url) {
        var index = this.findSongInList(url);
        this.favList.splice( index, 1 );

        this.save();
    };

    this.isFav = function(url) {
        if( !url ) return false; // Make sure url has value

        var index = this.findSongInList(url);

        if( index != -1 ) {
            return true;
        } else {
            return false;
        }
    };

    /* Song match */
    /* We match by `song_id` */
    /* Not check all url */
    this.isSame = function(x,y) {
        var regEx = new RegExp(/song_id=\d+/);
        if( x.match(y.match(regEx)) ) {
            return true;
        }
        return false;

    };

    /* Return -1 if it's exist */
    this.findSongInList = function(url) {
        for( var i=0; i < this.favList.length; i++ ){
            var song = this.favList[i];
            if( this.isSame(song.url,url) ) {
                return i;
            }

        }

        return -1;
    };

    this.save = function (){
        localStorage.setObject( STORAGE_KEY, this.favList );
    };


});

app.service('app', function($http){
    var self = this;

    this.load = function(callback) {
        self.promise = $http.get('../../manifest.json').success(function(data){
            self.data = data
        });
    };

    /* Get data */
    this.load();

    this.manifest = function(){
        return self.data;
    };

});

app.service('xhr', function($q, $timeout, $rootScope ) {

    this.get = function( opt, callback ){

        var xhr = new XMLHttpRequest({mozSystem: true});

        xhr.onreadystatechange = function() {
           if ( xhr.status === 200 && xhr.readyState === 4 ) {
                callback( xhr.responseText );
            }
        };

        xhr.onerror = function(e){
            callback('');
            console.log('xhr error : ' +  e.target.status);
            console.log( xhr.status );
        };

        xhr.ontimeout = function() {
            callback('');
        };

        xhr.open( "GET", opt.url, true );
        xhr.timeout = 10000; // 10s
        xhr.send();


        return xhr;


    };

});
