 /*
  * Description jQuery convert `Table` to `JSON`
  * By Pattarawat Chormai
  */

(function($){

    var methods = {
        init : function(){

            var my_json = { "songs" :[ ] };

            // Use :gt(0) to Skip table header row
            $(this).find('tr:gt(0)').each(function(){

                    // Create song's node
                    var my_song = { };

                    my_song['record']   = $(this).find('td:eq(0)').text();
                    my_song['artist']   = $(this).find('td:eq(1)').text();
                    my_song['album']    = $(this).find('td:eq(2)').text();

                    var song_node      = $(this).find('td:eq(3)').html();
                    my_song['name']     = $(song_node).text();
                    my_song['url']     = $(song_node).attr('href').replace(/^\s|\s$/,"");

                    my_json['songs'][ my_json['songs'].length ] = my_song;

            });//End loop in Table

            return my_json;
        }
    };

    $.fn.tb2json = function( method ){
        // Method calling logic
        if ( methods[method] ) {
          return methods[ method ].apply( this, Array.prototype.slice.call( arguments, 1 ));
        } else if ( typeof method === 'object' || ! method ) {
          return methods.init.apply( this, arguments );
        } else {
          $.error( 'Method ' +  method + ' does not exist on jQuery.preview_popup' );
        }
    };

})(jQuery);


