var mapbes_home;
var mapbes_home_reportar;
var user_latitude;
var user_longitude;
var user_markersArray;
var user_markersArray_reportar;
var LatLng_Reportar;

var markersArray_home = [];

  $(document).ready(function(){
  		refresh_map_home();
  		$( "#bloque_contenido_home" ).fadeIn();




  		$( ".btn_recarga_mapa_home" ).click(function() { 
  			refresh_map_home();
  		});

  		$( ".btn_recarga_info_estadisticas_baches" ).click(function() { 
  			genera_estadisticas();
  		});

  		$( ".btn_recarga_bloque_contenido_conocelos" ).click(function() { 
  			genera_conocelos_baches();
  		});

  		$( ".btn_enviar_reporte" ).click(function() { 
			enviar_reporte()
  		});


  		$( ".btn_inicio" ).click(function() { 
  			$( ".bloque_contenido" ).hide();
  			$( "#left-panel" ).panel( "close" );
  			$( ".titulo_panel" ).html('Sin Llantas!');
  			$( "#bloque_contenido_home" ).fadeIn();
  		});
  		$( ".btn_estadisticas" ).click(function() { 
  			genera_estadisticas();
  			$( ".bloque_contenido" ).hide();
  			$( "#left-panel" ).panel( "close" );
  			$( ".titulo_panel" ).html('Cuantos baches tenemos!');
  			$( "#bloque_contenido_estadisticas" ).fadeIn();
  		});
  		$( ".btn_conocelos" ).click(function() { 
			genera_conocelos_baches()
  			$( ".bloque_contenido" ).hide();
  			$( "#left-panel" ).panel( "close" );
  			$( ".titulo_panel" ).html('Baches al azar!');
  			$( "#bloque_contenido_conocelos" ).fadeIn();
  		});
  		$( ".btn_reportalo" ).click(function() { 
  			refresh_map_reportar();
  			$( ".bloque_contenido" ).hide();
  			$( "#left-panel" ).panel( "close" );
  			$( ".titulo_panel" ).html('Repórtalo!');
  			$( "#bloque_contenido_reportar" ).fadeIn();
  		});

  		$( ".btn_aboutSolesti" ).click(function() { 
  			$( ".bloque_contenido" ).hide();
  			$( "#left-panel" ).panel( "close" );
  			$( ".titulo_panel" ).html('Acerca de la aplicación');
  			$( "#bloque_contenido_intro" ).fadeIn();
  		});


	  
  });


	//iniciamos el mapa
	function initialize() {		
		var mapDiv = document.getElementById('map-canvas-home');
        var map = new google.maps.Map(mapDiv, {
          center: new google.maps.LatLng(user_latitude, user_longitude),
          zoom: 16,
		  streetViewControl: false,
		  disableDefaultUI: true,
          mapTypeId: google.maps.MapTypeId.ROADMAP
        });
      	//variable global para identificar el mapa
	  	mapbes_home=map;

		//variable de información del mapa
        var infoWindow = new google.maps.InfoWindow();

        //limpiamos el punto anterior destino
		if(user_markersArray){user_markersArray.setMap(null);}
		var panPoint = new google.maps.LatLng(user_latitude, user_longitude); 
		//creamos el punto en el mapa, el icono debe estar en una ruta absoluta
		user_markersArray = new google.maps.Marker({
			map: mapbes_home,
			position: panPoint,
			icon: 'images/icons/user.png'				
		});

		genera_puntos_baches();

      }

function refresh_map_home(){
	navigator.geolocation.getCurrentPosition(function (position) {
		user_latitude=position.coords.latitude;
		user_longitude=position.coords.longitude;
		initialize();

	    },
		function (position) {
        	alert("Failed to get your current location");
        });
}

function genera_puntos_baches(){
	$.getJSON("http://demo.solesti.com.mx/bache/home.php?jsoncallback=?", function(data){
         var i=0;
         while(markersArray_home[i]){
         	if(markersArray_home[i]){markersArray_home[i].setMap(null);}
         	i++;
         }

         var i=0;
         while(data[i]){

         	var punto = data[i];
         	var n=punto.split("|"); 
			var panPoint = new google.maps.LatLng(n[0], n[1]); 
			var img_icon="";
			if(n[2]=='0'){
				img_icon="images/icons/bache.png";
			}else{
				img_icon="images/icons/reparado.png";
			}

			//creamos el punto en el mapa, el icono debe estar en una ruta absoluta
			markersArray_home[i] = new google.maps.Marker({
				map: mapbes_home,
				position: panPoint,
				icon: img_icon				
			});

         	i++;
         }



    });
}

function genera_estadisticas(){
	$.getJSON("http://demo.solesti.com.mx/bache/estadisticas.php?jsoncallback=?", function(data){

         $( ".num_baches_reportados" ).html(data.reportados);
         $( ".num_baches_reparados" ).html(data.reparados);

         $( ".baches_viejo_fecha" ).html(data.viejitofecha);
         $( ".baches_viejo_nombre" ).html(data.viejitonombre);
         $( ".baches_viejo_comentario" ).html(data.viejitocomentario);
         $( "#img_info_estadisticas_baches_viejo" ).attr( "src", "http://maps.googleapis.com/maps/api/staticmap?center="+data.viejitolatitud+","+data.viejitolongitud+"&zoom=17&size=300x250&sensor=false&markers=color:blue%7Clabel:S%7C"+data.viejitolatitud+","+data.viejitolongitud+" " )

         $( ".baches_nuevo_fecha" ).html(data.nuevofecha);
         $( ".baches_nuevo_nombre" ).html(data.nuevonombre);
         $( ".baches_nuevo_comentario" ).html(data.nuevocomentario);
         $( "#img_info_estadisticas_baches_nuevo" ).attr( "src", "http://maps.googleapis.com/maps/api/staticmap?center="+data.nuevolatitud+","+data.nuevolongitud+"&zoom=17&size=300x250&sensor=false&markers=color:blue%7Clabel:S%7C"+data.nuevolatitud+","+data.nuevolongitud+" " )

    });

}


function genera_conocelos_baches(){
	$.getJSON("http://demo.solesti.com.mx/bache/conocelos.php?jsoncallback=?", function(data){

       	var html_conoce='';
         var i=0;
         while(data[i]){

         	var punto = data[i];
         	var n=punto.split("|"); 
         	html_conoce+="<p align='center'>Lo encontró: <span class='baches_conocelo_nombre'>"+ n[2] +"</span> Cuando:"+
         	" <span class='baches_conocelo_nombre'>"+n[3]+"</span><br/><span style='font-style: italic;'>"+n[4]+"</span><br/><img src='"+
         	"http://maps.googleapis.com/maps/api/staticmap?center="+n[0]+","+n[1]+"&zoom=17&size=300x250&sensor=false&markers=color:blue%7Clabel:S%7C"+n[0]+","+n[1]+" "+
         	"'></p>";

         	i++;
         }

		$( "#bloque_contenido_conocelos_info" ).html(html_conoce);

    });
}




function refresh_map_reportar(){
	navigator.geolocation.getCurrentPosition(function (position) {
		user_latitude=position.coords.latitude;
		user_longitude=position.coords.longitude;
		initialize_reportar();

	    },
		function (position) {
        	alert("Failed to get your current location");
        });
}

	//iniciamos el mapa
	function initialize_reportar() {		
		var mapDiv = document.getElementById('map-canvas-reportar');
        var map = new google.maps.Map(mapDiv, {
          center: new google.maps.LatLng(user_latitude, user_longitude),
		  streetViewControl: false,
		  disableDefaultUI: true,
          zoom: 17,
          mapTypeId: google.maps.MapTypeId.ROADMAP
        });
      	//variable global para identificar el mapa
	  	mapbes_home_reportar=map;

		//variable de información del mapa
        var infoWindow = new google.maps.InfoWindow();

        //limpiamos el punto anterior destino
		if(user_markersArray_reportar){user_markersArray_reportar.setMap(null);}
		var panPoint = new google.maps.LatLng(user_latitude, user_longitude); 
		LatLng_Reportar=panPoint;
		//creamos el punto en el mapa, el icono debe estar en una ruta absoluta
		user_markersArray_reportar = new google.maps.Marker({
			map: mapbes_home_reportar,
			position: panPoint,
			icon: 'images/icons/user.png'				
		});

		//agregamos un evento de clic al mapa para generar los puntos
        google.maps.event.addListener(mapbes_home_reportar, 'click', function(event) {
				//si es origen limpiamos la marca anterior
				if(user_markersArray_reportar){user_markersArray_reportar.setMap(null);}
				//guardamos la latitud y longitud del punto en una variable global
				LatLng_Reportar=event.latLng;
				//creamos el punto en el mapa, el icono debe estar en una ruta absoluta
				user_markersArray_reportar = new google.maps.Marker({
					map: mapbes_home_reportar,
					position: LatLng_Reportar,
					icon: 'images/icons/user.png'				
				});
		//cerramos el evento onclick
        });

      }

function enviar_reporte(){

	var nombre=$( "#nombre_reportar" ).val();
	var correo=$( "#correo_reportar" ).val();
	var comentario=$( "#comentario_reportar" ).val();
	var latitud=LatLng_Reportar.lat();
	var longitud=LatLng_Reportar.lng();

	if(nombre=='' || correo=='' || comentario=='' || latitud=='' || longitud==''){
		alert('Es necesario llenar todos los campos');
		return false;
	}

	$.getJSON("http://demo.solesti.com.mx/bache/guarda.php?nombre="+nombre+"&correo="+correo+"&comentario="+comentario+"&latitud="+latitud+"&longitud="+longitud+"&jsoncallback=?", function(data){

		alert(data.mensaje);

		$( "#nombre_reportar" ).val('');
		$( "#correo_reportar" ).val('');
		$( "#comentario_reportar" ).val('');

    });

}