﻿// Generated by Construct 2, the HTML5 game and app creator :: http://www.scirra.com
var cr = {};
cr.plugins_ = {};
cr.behaviors = {};
if (typeof Object.getPrototypeOf !== "function")
{
	if (typeof "test".__proto__ === "object")
	{
		Object.getPrototypeOf = function(object) {
			return object.__proto__;
		};
	}
	else
	{
		Object.getPrototypeOf = function(object) {
			return object.constructor.prototype;
		};
	}
}
(function(){
	cr.logexport = function (msg)
	{
		if (window.console && window.console.log)
			window.console.log(msg);
	};
	cr.seal = function(x)
	{
		return x;
	};
	cr.freeze = function(x)
	{
		return x;
	};
	cr.is_undefined = function (x)
	{
		return typeof x === "undefined";
	};
	cr.is_number = function (x)
	{
		return typeof x === "number";
	};
	cr.is_string = function (x)
	{
		return typeof x === "string";
	};
	cr.isPOT = function (x)
	{
		return x > 0 && ((x - 1) & x) === 0;
	};
	cr.nextHighestPowerOfTwo = function(x) {
		--x;
		for (var i = 1; i < 32; i <<= 1) {
			x = x | x >> i;
		}
		return x + 1;
	}
	cr.abs = function (x)
	{
		return (x < 0 ? -x : x);
	};
	cr.max = function (a, b)
	{
		return (a > b ? a : b);
	};
	cr.min = function (a, b)
	{
		return (a < b ? a : b);
	};
	cr.PI = Math.PI;
	cr.round = function (x)
	{
		return (x + 0.5) | 0;
	};
	cr.floor = function (x)
	{
		return x | 0;
	};
	cr.ceil = function (x)
	{
		var f = x | 0;
		return (f === x ? f : f + 1);
	};
	function Vector2(x, y)
	{
		this.x = x;
		this.y = y;
		cr.seal(this);
	};
	Vector2.prototype.offset = function (px, py)
	{
		this.x += px;
		this.y += py;
		return this;
	};
	Vector2.prototype.mul = function (px, py)
	{
		this.x *= px;
		this.y *= py;
		return this;
	};
	cr.vector2 = Vector2;
	cr.segments_intersect = function(a1x, a1y, a2x, a2y, b1x, b1y, b2x, b2y)
	{
		var max_ax, min_ax, max_ay, min_ay, max_bx, min_bx, max_by, min_by;
		if (a1x < a2x)
		{
			min_ax = a1x;
			max_ax = a2x;
		}
		else
		{
			min_ax = a2x;
			max_ax = a1x;
		}
		if (b1x < b2x)
		{
			min_bx = b1x;
			max_bx = b2x;
		}
		else
		{
			min_bx = b2x;
			max_bx = b1x;
		}
		if (max_ax < min_bx || min_ax > max_bx)
			return false;
		if (a1y < a2y)
		{
			min_ay = a1y;
			max_ay = a2y;
		}
		else
		{
			min_ay = a2y;
			max_ay = a1y;
		}
		if (b1y < b2y)
		{
			min_by = b1y;
			max_by = b2y;
		}
		else
		{
			min_by = b2y;
			max_by = b1y;
		}
		if (max_ay < min_by || min_ay > max_by)
			return false;
		var dpx = b1x - a1x + b2x - a2x;
		var dpy = b1y - a1y + b2y - a2y;
		var qax = a2x - a1x;
		var qay = a2y - a1y;
		var qbx = b2x - b1x;
		var qby = b2y - b1y;
		var d = cr.abs(qay * qbx - qby * qax);
		var la = qbx * dpy - qby * dpx;
		if (cr.abs(la) > d)
			return false;
		var lb = qax * dpy - qay * dpx;
		return cr.abs(lb) <= d;
	};
	function Rect(left, top, right, bottom)
	{
		this.set(left, top, right, bottom);
		cr.seal(this);
	};
	Rect.prototype.set = function (left, top, right, bottom)
	{
		this.left = left;
		this.top = top;
		this.right = right;
		this.bottom = bottom;
	};
	Rect.prototype.width = function ()
	{
		return this.right - this.left;
	};
	Rect.prototype.height = function ()
	{
		return this.bottom - this.top;
	};
	Rect.prototype.offset = function (px, py)
	{
		this.left += px;
		this.top += py;
		this.right += px;
		this.bottom += py;
		return this;
	};
	Rect.prototype.intersects_rect = function (rc)
	{
		return !(rc.right < this.left || rc.bottom < this.top || rc.left > this.right || rc.top > this.bottom);
	};
	Rect.prototype.intersects_rect_off = function (rc, ox, oy)
	{
		return !(rc.right + ox < this.left || rc.bottom + oy < this.top || rc.left + ox > this.right || rc.top + oy > this.bottom);
	};
	Rect.prototype.contains_pt = function (x, y)
	{
		return (x >= this.left && x <= this.right) && (y >= this.top && y <= this.bottom);
	};
	cr.rect = Rect;
	function Quad()
	{
		this.tlx = 0;
		this.tly = 0;
		this.trx = 0;
		this.try_ = 0;	// is a keyword otherwise!
		this.brx = 0;
		this.bry = 0;
		this.blx = 0;
		this.bly = 0;
		cr.seal(this);
	};
	Quad.prototype.set_from_rect = function (rc)
	{
		this.tlx = rc.left;
		this.tly = rc.top;
		this.trx = rc.right;
		this.try_ = rc.top;
		this.brx = rc.right;
		this.bry = rc.bottom;
		this.blx = rc.left;
		this.bly = rc.bottom;
	};
	Quad.prototype.set_from_rotated_rect = function (rc, a)
	{
		if (a === 0)
		{
			this.set_from_rect(rc);
		}
		else
		{
			var sin_a = Math.sin(a);
			var cos_a = Math.cos(a);
			var left_sin_a = rc.left * sin_a;
			var top_sin_a = rc.top * sin_a;
			var right_sin_a = rc.right * sin_a;
			var bottom_sin_a = rc.bottom * sin_a;
			var left_cos_a = rc.left * cos_a;
			var top_cos_a = rc.top * cos_a;
			var right_cos_a = rc.right * cos_a;
			var bottom_cos_a = rc.bottom * cos_a;
			this.tlx = left_cos_a - top_sin_a;
			this.tly = top_cos_a + left_sin_a;
			this.trx = right_cos_a - top_sin_a;
			this.try_ = top_cos_a + right_sin_a;
			this.brx = right_cos_a - bottom_sin_a;
			this.bry = bottom_cos_a + right_sin_a;
			this.blx = left_cos_a - bottom_sin_a;
			this.bly = bottom_cos_a + left_sin_a;
		}
	};
	Quad.prototype.offset = function (px, py)
	{
		this.tlx += px;
		this.tly += py;
		this.trx += px;
		this.try_ += py;
		this.brx += px;
		this.bry += py;
		this.blx += px;
		this.bly += py;
		return this;
	};
	Quad.prototype.bounding_box = function (rc)
	{
		rc.left =   cr.min(cr.min(this.tlx, this.trx),  cr.min(this.brx, this.blx));
		rc.top =    cr.min(cr.min(this.tly, this.try_), cr.min(this.bry, this.bly));
		rc.right =  cr.max(cr.max(this.tlx, this.trx),  cr.max(this.brx, this.blx));
		rc.bottom = cr.max(cr.max(this.tly, this.try_), cr.max(this.bry, this.bly));
	};
	Quad.prototype.contains_pt = function (x, y)
	{
		var v0x = this.trx - this.tlx;
		var v0y = this.try_ - this.tly;
		var v1x = this.brx - this.tlx;
		var v1y = this.bry - this.tly;
		var v2x = x - this.tlx;
		var v2y = y - this.tly;
		var dot00 = v0x * v0x + v0y * v0y
		var dot01 = v0x * v1x + v0y * v1y
		var dot02 = v0x * v2x + v0y * v2y
		var dot11 = v1x * v1x + v1y * v1y
		var dot12 = v1x * v2x + v1y * v2y
		var invDenom = 1.0 / (dot00 * dot11 - dot01 * dot01);
		var u = (dot11 * dot02 - dot01 * dot12) * invDenom;
		var v = (dot00 * dot12 - dot01 * dot02) * invDenom;
		if ((u >= 0.0) && (v > 0.0) && (u + v < 1))
			return true;
		v0x = this.blx - this.tlx;
		v0y = this.bly - this.tly;
		var dot00 = v0x * v0x + v0y * v0y
		var dot01 = v0x * v1x + v0y * v1y
		var dot02 = v0x * v2x + v0y * v2y
		invDenom = 1.0 / (dot00 * dot11 - dot01 * dot01);
		u = (dot11 * dot02 - dot01 * dot12) * invDenom;
		v = (dot00 * dot12 - dot01 * dot02) * invDenom;
		return (u >= 0.0) && (v > 0.0) && (u + v < 1);
	};
	Quad.prototype.at = function (i, xory)
	{
		if (xory)
		{
			switch (i)
			{
				case 0: return this.tlx;
				case 1: return this.trx;
				case 2: return this.brx;
				case 3: return this.blx;
				case 4: return this.tlx;
				default: return this.tlx;
			}
		}
		else
		{
			switch (i)
			{
				case 0: return this.tly;
				case 1: return this.try_;
				case 2: return this.bry;
				case 3: return this.bly;
				case 4: return this.tly;
				default: return this.tly;
			}
		}
	};
	Quad.prototype.midX = function ()
	{
		return (this.tlx + this.trx  + this.brx + this.blx) / 4;
	};
	Quad.prototype.midY = function ()
	{
		return (this.tly + this.try_ + this.bry + this.bly) / 4;
	};
	Quad.prototype.intersects_segment = function (x1, y1, x2, y2)
	{
		if (this.contains_pt(x1, y1) || this.contains_pt(x2, y2))
			return true;
		var a1x, a1y, a2x, a2y;
		var i;
		for (i = 0; i < 4; i++)
		{
			a1x = this.at(i, true);
			a1y = this.at(i, false);
			a2x = this.at(i + 1, true);
			a2y = this.at(i + 1, false);
			if (cr.segments_intersect(x1, y1, x2, y2, a1x, a1y, a2x, a2y))
				return true;
		}
		return false;
	};
	Quad.prototype.intersects_quad = function (rhs)
	{
		var midx = rhs.midX();
		var midy = rhs.midY();
		if (this.contains_pt(midx, midy))
			return true;
		midx = this.midX();
		midy = this.midY();
		if (rhs.contains_pt(midx, midy))
			return true;
		var a1x, a1y, a2x, a2y, b1x, b1y, b2x, b2y;
		var i, j;
		for (i = 0; i < 4; i++)
		{
			for (j = 0; j < 4; j++)
			{
				a1x = this.at(i, true);
				a1y = this.at(i, false);
				a2x = this.at(i + 1, true);
				a2y = this.at(i + 1, false);
				b1x = rhs.at(j, true);
				b1y = rhs.at(j, false);
				b2x = rhs.at(j + 1, true);
				b2y = rhs.at(j + 1, false);
				if (cr.segments_intersect(a1x, a1y, a2x, a2y, b1x, b1y, b2x, b2y))
					return true;
			}
		}
		return false;
	};
	cr.quad = Quad;
	cr.RGB = function (red, green, blue)
	{
		return Math.max(Math.min(red, 255), 0)
			 | (Math.max(Math.min(green, 255), 0) << 8)
			 | (Math.max(Math.min(blue, 255), 0) << 16);
	};
	cr.GetRValue = function (rgb)
	{
		return rgb & 0xFF;
	};
	cr.GetGValue = function (rgb)
	{
		return (rgb & 0xFF00) >> 8;
	};
	cr.GetBValue = function (rgb)
	{
		return (rgb & 0xFF0000) >> 16;
	};
	cr.shallowCopy = function (a, b, allowOverwrite)
	{
		var attr;
		for (attr in b)
		{
			if (b.hasOwnProperty(attr))
			{
;
				a[attr] = b[attr];
			}
		}
		return a;
	};
	cr.arrayRemove = function (arr, index)
	{
		var i, len;
		index = cr.floor(index);
		if (index < 0 || index >= arr.length)
			return;							// index out of bounds
		if (index === 0)					// removing first item
			arr.shift();
		else if (index === arr.length - 1)	// removing last item
			arr.pop();
		else
		{
			for (i = index, len = arr.length - 1; i < len; i++)
				arr[i] = arr[i + 1];
			arr.length = len;
		}
	};
	cr.shallowAssignArray = function(dest, src)
	{
		dest.length = src.length;
		var i, len;
		for (i = 0, len = src.length; i < len; i++)
			dest[i] = src[i];
	};
	cr.arrayFindRemove = function (arr, item)
	{
		var index = arr.indexOf(item);
		if (index !== -1)
			cr.arrayRemove(arr, index);
	};
	cr.clamp = function(x, a, b)
	{
		if (x < a)
			return a;
		else if (x > b)
			return b;
		else
			return x;
	};
	cr.to_radians = function(x)
	{
		return x / (180.0 / cr.PI);
	};
	cr.to_degrees = function(x)
	{
		return x * (180.0 / cr.PI);
	};
	cr.clamp_angle_degrees = function (a)
	{
		a %= 360;       // now in (-360, 360) range
		if (a < 0)
			a += 360;   // now in [0, 360) range
		return a;
	};
	cr.clamp_angle = function (a)
	{
		a %= 2 * cr.PI;       // now in (-2pi, 2pi) range
		if (a < 0)
			a += 2 * cr.PI;   // now in [0, 2pi) range
		return a;
	};
	cr.to_clamped_degrees = function (x)
	{
		return cr.clamp_angle_degrees(cr.to_degrees(x));
	};
	cr.to_clamped_radians = function (x)
	{
		return cr.clamp_angle(cr.to_radians(x));
	};
	cr.angleTo = function(x1, y1, x2, y2)
	{
		var dx = x2 - x1;
        var dy = y2 - y1;
		return Math.atan2(dy, dx);
	};
	cr.angleDiff = function (a1, a2)
	{
		if (a1 === a2)
			return 0;
		var s1 = Math.sin(a1);
		var c1 = Math.cos(a1);
		var s2 = Math.sin(a2);
		var c2 = Math.cos(a2);
		var n = s1 * s2 + c1 * c2;
		if (n >= 1)
			return 0;
		if (n <= -1)
			return cr.PI;
		return Math.acos(n);
	};
	cr.angleRotate = function (start, end, step)
	{
		var ss = Math.sin(start);
		var cs = Math.cos(start);
		var se = Math.sin(end);
		var ce = Math.cos(end);
		if (Math.acos(ss * se + cs * ce) > step)
		{
			if (cs * se - ss * ce > 0)
				return cr.clamp_angle(start + step);
			else
				return cr.clamp_angle(start - step);
		}
		else
			return cr.clamp_angle(end);
	};
	cr.angleClockwise = function (a1, a2)
	{
		var s1 = Math.sin(a1);
		var c1 = Math.cos(a1);
		var s2 = Math.sin(a2);
		var c2 = Math.cos(a2);
		return c1 * s2 - s1 * c2 <= 0;
	};
	cr.rotatePtAround = function (px, py, a, ox, oy, getx)
	{
		if (a === 0)
			return getx ? px : py;
		var sin_a = Math.sin(a);
		var cos_a = Math.cos(a);
		px -= ox;
		py -= oy;
		var left_sin_a = px * sin_a;
		var top_sin_a = py * sin_a;
		var left_cos_a = px * cos_a;
		var top_cos_a = py * cos_a;
		px = left_cos_a - top_sin_a;
		py = top_cos_a + left_sin_a;
		px += ox;
		py += oy;
		return getx ? px : py;
	}
	cr.distanceTo = function(x1, y1, x2, y2)
	{
		var dx = x2 - x1;
        var dy = y2 - y1;
		return Math.sqrt(dx*dx + dy*dy);
	};
	cr.xor = function (x, y)
	{
		return !x !== !y;
	};
	cr.lerp = function (a, b, x)
	{
		return a + (b - a) * x;
	};
	cr.hasAnyOwnProperty = function (o)
	{
		var p;
		for (p in o)
		{
			if (o.hasOwnProperty(p))
				return true;
		}
		return false;
	};
	cr.wipe = function (obj)
	{
		var p;
		for (p in obj)
		{
			if (obj.hasOwnProperty(p))
				delete obj[p];
		}
	};
	var startup_time = +(new Date());
	cr.performance_now = function()
	{
		if (typeof window["performance"] !== "undefined")
		{
			var winperf = window["performance"];
			if (typeof winperf.now !== "undefined")
				return winperf.now();
			else if (typeof winperf["webkitNow"] !== "undefined")
				return winperf["webkitNow"]();
			else if (typeof winperf["mozNow"] !== "undefined")
				return winperf["mozNow"]();
			else if (typeof winperf["msNow"] !== "undefined")
				return winperf["msNow"]();
		}
		return Date.now() - startup_time;
	};
	var supports_set = (typeof Set !== "undefined" && typeof Set.prototype["forEach"] !== "undefined");
	function ObjectSet_()
	{
		if (supports_set)
		{
			this.s = new Set();
		}
		else
		{
			this.items = {};
			this.item_count = 0;
		}
		this.values_cache = [];
		this.cache_valid = true;
		cr.seal(this);
	};
	ObjectSet_.prototype.contains = function (x)
	{
		if (supports_set)
			return this.s["has"](x);
		else
			return this.items.hasOwnProperty(x.toString());
	};
	ObjectSet_.prototype.add = function (x)
	{
		if (supports_set)
		{
			if (!this.s["has"](x))
			{
				this.s["add"](x);
				this.cache_valid = false;
			}
		}
		else
		{
			var str = x.toString();
			if (!this.items.hasOwnProperty(str))
			{
				this.items[str] = x;
				this.item_count++;
				this.cache_valid = false;
			}
		}
		return this;
	};
	ObjectSet_.prototype.remove = function (x)
	{
		if (supports_set)
		{
			if (this.s["has"](x))
			{
				this.s["delete"](x);
				this.cache_valid = false;
			}
		}
		else
		{
			var str = x.toString();
			if (this.items.hasOwnProperty(str))
			{
				delete this.items[str];
				this.item_count--;
				this.cache_valid = false;
			}
		}
		return this;
	};
	ObjectSet_.prototype.clear = function ()
	{
		if (supports_set)
		{
			this.s["clear"]();
		}
		else
		{
			this.items = {};
			this.item_count = 0;
		}
		this.values_cache.length = 0;
		this.cache_valid = true;
		return this;
	};
	ObjectSet_.prototype.isEmpty = function ()
	{
		if (supports_set)
			return this.s["size"] === 0;
		else
			return this.item_count === 0;
	};
	ObjectSet_.prototype.count = function ()
	{
		if (supports_set)
			return this.s["size"];
		else
			return this.item_count;
	};
	var current_arr = null;
	var current_index = 0;
	function set_append_to_arr(x)
	{
		current_arr[current_index++] = x;
	};
	ObjectSet_.prototype.update_cache = function ()
	{
		if (this.cache_valid)
			return;
		if (supports_set)
		{
			this.values_cache.length = this.s["size"];
			current_arr = this.values_cache;
			current_index = 0;
			this.s["forEach"](set_append_to_arr);
;
			current_arr = null;
			current_index = 0;
		}
		else
		{
			this.values_cache.length = this.item_count;
			var p, n = 0;
			for (p in this.items)
			{
				if (this.items.hasOwnProperty(p))
					this.values_cache[n++] = this.items[p];
			}
;
		}
		this.cache_valid = true;
	};
	ObjectSet_.prototype.values = function ()
	{
		this.update_cache();
		return this.values_cache.slice(0);
	};
	ObjectSet_.prototype.valuesRef = function ()
	{
		this.update_cache();
		return this.values_cache;
	};
	cr.ObjectSet = ObjectSet_;
	function KahanAdder_()
	{
		this.c = 0;
        this.y = 0;
        this.t = 0;
        this.sum = 0;
		cr.seal(this);
	};
	KahanAdder_.prototype.add = function (v)
	{
		this.y = v - this.c;
	    this.t = this.sum + this.y;
	    this.c = (this.t - this.sum) - this.y;
	    this.sum = this.t;
	};
    KahanAdder_.prototype.reset = function ()
    {
        this.c = 0;
        this.y = 0;
        this.t = 0;
        this.sum = 0;
    };
	cr.KahanAdder = KahanAdder_;
	cr.regexp_escape = function(text)
	{
		return text.replace(/[-[\]{}()*+?.,\\^$|#\s]/g, "\\$&");
	};
	function CollisionPoly_(pts_array_)
	{
		this.pts_cache = [];
		this.bboxLeft = 0;
		this.bboxTop = 0;
		this.bboxRight = 0;
		this.bboxBottom = 0;
		this.set_pts(pts_array_);
		cr.seal(this);
	};
	CollisionPoly_.prototype.set_pts = function(pts_array_)
	{
		this.pts_array = pts_array_;
		this.pts_count = pts_array_.length / 2;			// x, y, x, y... in array
		this.pts_cache.length = pts_array_.length;
		this.cache_width = -1;
		this.cache_height = -1;
		this.cache_angle = 0;
	};
	CollisionPoly_.prototype.is_empty = function()
	{
		return !this.pts_array.length;
	};
	CollisionPoly_.prototype.update_bbox = function ()
	{
		var myptscache = this.pts_cache;
		var bboxLeft_ = myptscache[0];
		var bboxRight_ = bboxLeft_;
		var bboxTop_ = myptscache[1];
		var bboxBottom_ = bboxTop_;
		var x, y, i = 1, i2, len = this.pts_count;
		for ( ; i < len; ++i)
		{
			i2 = i*2;
			x = myptscache[i2];
			y = myptscache[i2+1];
			if (x < bboxLeft_)
				bboxLeft_ = x;
			if (x > bboxRight_)
				bboxRight_ = x;
			if (y < bboxTop_)
				bboxTop_ = y;
			if (y > bboxBottom_)
				bboxBottom_ = y;
		}
		this.bboxLeft = bboxLeft_;
		this.bboxRight = bboxRight_;
		this.bboxTop = bboxTop_;
		this.bboxBottom = bboxBottom_;
	};
	CollisionPoly_.prototype.set_from_rect = function(rc, offx, offy)
	{
		this.pts_cache.length = 8;
		this.pts_count = 4;
		var myptscache = this.pts_cache;
		myptscache[0] = rc.left - offx;
		myptscache[1] = rc.top - offy;
		myptscache[2] = rc.right - offx;
		myptscache[3] = rc.top - offy;
		myptscache[4] = rc.right - offx;
		myptscache[5] = rc.bottom - offy;
		myptscache[6] = rc.left - offx;
		myptscache[7] = rc.bottom - offy;
		this.cache_width = rc.right - rc.left;
		this.cache_height = rc.bottom - rc.top;
		this.update_bbox();
	};
	CollisionPoly_.prototype.set_from_quad = function(q, offx, offy, w, h)
	{
		this.pts_cache.length = 8;
		this.pts_count = 4;
		var myptscache = this.pts_cache;
		myptscache[0] = q.tlx - offx;
		myptscache[1] = q.tly - offy;
		myptscache[2] = q.trx - offx;
		myptscache[3] = q.try_ - offy;
		myptscache[4] = q.brx - offx;
		myptscache[5] = q.bry - offy;
		myptscache[6] = q.blx - offx;
		myptscache[7] = q.bly - offy;
		this.cache_width = w;
		this.cache_height = h;
		this.update_bbox();
	};
	CollisionPoly_.prototype.set_from_poly = function (r)
	{
		this.pts_count = r.pts_count;
		cr.shallowAssignArray(this.pts_cache, r.pts_cache);
		this.bboxLeft = r.bboxLeft;
		this.bboxTop - r.bboxTop;
		this.bboxRight = r.bboxRight;
		this.bboxBottom = r.bboxBottom;
	};
	CollisionPoly_.prototype.cache_poly = function(w, h, a)
	{
		if (this.cache_width === w && this.cache_height === h && this.cache_angle === a)
			return;		// cache up-to-date
		this.cache_width = w;
		this.cache_height = h;
		this.cache_angle = a;
		var i, i2, i21, len, x, y;
		var sina = 0;
		var cosa = 1;
		var myptsarray = this.pts_array;
		var myptscache = this.pts_cache;
		if (a !== 0)
		{
			sina = Math.sin(a);
			cosa = Math.cos(a);
		}
		for (i = 0, len = this.pts_count; i < len; i++)
		{
			i2 = i*2;
			i21 = i2+1;
			x = myptsarray[i2] * w;
			y = myptsarray[i21] * h;
			myptscache[i2] = (x * cosa) - (y * sina);
			myptscache[i21] = (y * cosa) + (x * sina);
		}
		this.update_bbox();
	};
	CollisionPoly_.prototype.contains_pt = function (a2x, a2y)
	{
		var myptscache = this.pts_cache;
		if (a2x === myptscache[0] && a2y === myptscache[1])
			return true;
		var i, i2, imod, len = this.pts_count;
		var a1x = this.bboxLeft - 110;
		var a1y = this.bboxTop - 101;
		var a3x = this.bboxRight + 131
		var a3y = this.bboxBottom + 120;
		var b1x, b1y, b2x, b2y;
		var count1 = 0, count2 = 0;
		for (i = 0; i < len; i++)
		{
			i2 = i*2;
			imod = ((i+1)%len)*2;
			b1x = myptscache[i2];
			b1y = myptscache[i2+1];
			b2x = myptscache[imod];
			b2y = myptscache[imod+1];
			if (cr.segments_intersect(a1x, a1y, a2x, a2y, b1x, b1y, b2x, b2y))
				count1++;
			if (cr.segments_intersect(a3x, a3y, a2x, a2y, b1x, b1y, b2x, b2y))
				count2++;
		}
		return (count1 % 2 === 1) || (count2 % 2 === 1);
	};
	CollisionPoly_.prototype.intersects_poly = function (rhs, offx, offy)
	{
		var rhspts = rhs.pts_cache;
		var mypts = this.pts_cache;
		if (this.contains_pt(rhspts[0] + offx, rhspts[1] + offy))
			return true;
		if (rhs.contains_pt(mypts[0] - offx, mypts[1] - offy))
			return true;
		var i, i2, imod, leni, j, j2, jmod, lenj;
		var a1x, a1y, a2x, a2y, b1x, b1y, b2x, b2y;
		for (i = 0, leni = this.pts_count; i < leni; i++)
		{
			i2 = i*2;
			imod = ((i+1)%leni)*2;
			a1x = mypts[i2];
			a1y = mypts[i2+1];
			a2x = mypts[imod];
			a2y = mypts[imod+1];
			for (j = 0, lenj = rhs.pts_count; j < lenj; j++)
			{
				j2 = j*2;
				jmod = ((j+1)%lenj)*2;
				b1x = rhspts[j2] + offx;
				b1y = rhspts[j2+1] + offy;
				b2x = rhspts[jmod] + offx;
				b2y = rhspts[jmod+1] + offy;
				if (cr.segments_intersect(a1x, a1y, a2x, a2y, b1x, b1y, b2x, b2y))
					return true;
			}
		}
		return false;
	};
	CollisionPoly_.prototype.intersects_segment = function (offx, offy, x1, y1, x2, y2)
	{
		var mypts = this.pts_cache;
		if (this.contains_pt(x1 - offx, y1 - offy))
			return true;
		var i, leni, i2, imod;
		var a1x, a1y, a2x, a2y;
		for (i = 0, leni = this.pts_count; i < leni; i++)
		{
			i2 = i*2;
			imod = ((i+1)%leni)*2;
			a1x = mypts[i2] + offx;
			a1y = mypts[i2+1] + offy;
			a2x = mypts[imod] + offx;
			a2y = mypts[imod+1] + offy;
			if (cr.segments_intersect(x1, y1, x2, y2, a1x, a1y, a2x, a2y))
				return true;
		}
		return false;
	};
	CollisionPoly_.prototype.mirror = function (px)
	{
		var i, leni, i2;
		for (i = 0, leni = this.pts_count; i < leni; ++i)
		{
			i2 = i*2;
			this.pts_cache[i2] = px * 2 - this.pts_cache[i2];
		}
	};
	CollisionPoly_.prototype.flip = function (py)
	{
		var i, leni, i21;
		for (i = 0, leni = this.pts_count; i < leni; ++i)
		{
			i21 = i*2+1;
			this.pts_cache[i21] = py * 2 - this.pts_cache[i21];
		}
	};
	CollisionPoly_.prototype.diag = function ()
	{
		var i, leni, i2, i21, temp;
		for (i = 0, leni = this.pts_count; i < leni; ++i)
		{
			i2 = i*2;
			i21 = i2+1;
			temp = this.pts_cache[i2];
			this.pts_cache[i2] = this.pts_cache[i21];
			this.pts_cache[i21] = temp;
		}
	};
	cr.CollisionPoly = CollisionPoly_;
	var fxNames = [ "lighter",
					"xor",
					"copy",
					"destination-over",
					"source-in",
					"destination-in",
					"source-out",
					"destination-out",
					"source-atop",
					"destination-atop"];
	cr.effectToCompositeOp = function(effect)
	{
		if (effect <= 0 || effect >= 11)
			return "source-over";
		return fxNames[effect - 1];	// not including "none" so offset by 1
	};
	cr.setGLBlend = function(this_, effect, gl)
	{
		if (!gl)
			return;
		this_.srcBlend = gl.ONE;
		this_.destBlend = gl.ONE_MINUS_SRC_ALPHA;
		switch (effect) {
		case 1:		// lighter (additive)
			this_.srcBlend = gl.ONE;
			this_.destBlend = gl.ONE;
			break;
		case 2:		// xor
			break;	// todo
		case 3:		// copy
			this_.srcBlend = gl.ONE;
			this_.destBlend = gl.ZERO;
			break;
		case 4:		// destination-over
			this_.srcBlend = gl.ONE_MINUS_DST_ALPHA;
			this_.destBlend = gl.ONE;
			break;
		case 5:		// source-in
			this_.srcBlend = gl.DST_ALPHA;
			this_.destBlend = gl.ZERO;
			break;
		case 6:		// destination-in
			this_.srcBlend = gl.ZERO;
			this_.destBlend = gl.SRC_ALPHA;
			break;
		case 7:		// source-out
			this_.srcBlend = gl.ONE_MINUS_DST_ALPHA;
			this_.destBlend = gl.ZERO;
			break;
		case 8:		// destination-out
			this_.srcBlend = gl.ZERO;
			this_.destBlend = gl.ONE_MINUS_SRC_ALPHA;
			break;
		case 9:		// source-atop
			this_.srcBlend = gl.DST_ALPHA;
			this_.destBlend = gl.ONE_MINUS_SRC_ALPHA;
			break;
		case 10:	// destination-atop
			this_.srcBlend = gl.ONE_MINUS_DST_ALPHA;
			this_.destBlend = gl.SRC_ALPHA;
			break;
		}
	};
	cr.round6dp = function (x)
	{
		return cr.round(x * 1000000) / 1000000;
	};
	/*
	var localeCompare_options = {
		"usage": "search",
		"sensitivity": "accent"
	};
	var has_localeCompare = !!"a".localeCompare;
	var localeCompare_works1 = (has_localeCompare && "a".localeCompare("A", undefined, localeCompare_options) === 0);
	var localeCompare_works2 = (has_localeCompare && "a".localeCompare("á", undefined, localeCompare_options) !== 0);
	var supports_localeCompare = (has_localeCompare && localeCompare_works1 && localeCompare_works2);
	*/
	cr.equals_nocase = function (a, b)
	{
		if (typeof a !== "string" || typeof b !== "string")
			return false;
		if (a.length !== b.length)
			return false;
		if (a === b)
			return true;
		/*
		if (supports_localeCompare)
		{
			return (a.localeCompare(b, undefined, localeCompare_options) === 0);
		}
		else
		{
		*/
			return a.toLowerCase() === b.toLowerCase();
	};
}());
var MatrixArray=typeof Float32Array!=="undefined"?Float32Array:Array,glMatrixArrayType=MatrixArray,vec3={},mat3={},mat4={},quat4={};vec3.create=function(a){var b=new MatrixArray(3);a&&(b[0]=a[0],b[1]=a[1],b[2]=a[2]);return b};vec3.set=function(a,b){b[0]=a[0];b[1]=a[1];b[2]=a[2];return b};vec3.add=function(a,b,c){if(!c||a===c)return a[0]+=b[0],a[1]+=b[1],a[2]+=b[2],a;c[0]=a[0]+b[0];c[1]=a[1]+b[1];c[2]=a[2]+b[2];return c};
vec3.subtract=function(a,b,c){if(!c||a===c)return a[0]-=b[0],a[1]-=b[1],a[2]-=b[2],a;c[0]=a[0]-b[0];c[1]=a[1]-b[1];c[2]=a[2]-b[2];return c};vec3.negate=function(a,b){b||(b=a);b[0]=-a[0];b[1]=-a[1];b[2]=-a[2];return b};vec3.scale=function(a,b,c){if(!c||a===c)return a[0]*=b,a[1]*=b,a[2]*=b,a;c[0]=a[0]*b;c[1]=a[1]*b;c[2]=a[2]*b;return c};
vec3.normalize=function(a,b){b||(b=a);var c=a[0],d=a[1],e=a[2],g=Math.sqrt(c*c+d*d+e*e);if(g){if(g===1)return b[0]=c,b[1]=d,b[2]=e,b}else return b[0]=0,b[1]=0,b[2]=0,b;g=1/g;b[0]=c*g;b[1]=d*g;b[2]=e*g;return b};vec3.cross=function(a,b,c){c||(c=a);var d=a[0],e=a[1],a=a[2],g=b[0],f=b[1],b=b[2];c[0]=e*b-a*f;c[1]=a*g-d*b;c[2]=d*f-e*g;return c};vec3.length=function(a){var b=a[0],c=a[1],a=a[2];return Math.sqrt(b*b+c*c+a*a)};vec3.dot=function(a,b){return a[0]*b[0]+a[1]*b[1]+a[2]*b[2]};
vec3.direction=function(a,b,c){c||(c=a);var d=a[0]-b[0],e=a[1]-b[1],a=a[2]-b[2],b=Math.sqrt(d*d+e*e+a*a);if(!b)return c[0]=0,c[1]=0,c[2]=0,c;b=1/b;c[0]=d*b;c[1]=e*b;c[2]=a*b;return c};vec3.lerp=function(a,b,c,d){d||(d=a);d[0]=a[0]+c*(b[0]-a[0]);d[1]=a[1]+c*(b[1]-a[1]);d[2]=a[2]+c*(b[2]-a[2]);return d};vec3.str=function(a){return"["+a[0]+", "+a[1]+", "+a[2]+"]"};
mat3.create=function(a){var b=new MatrixArray(9);a&&(b[0]=a[0],b[1]=a[1],b[2]=a[2],b[3]=a[3],b[4]=a[4],b[5]=a[5],b[6]=a[6],b[7]=a[7],b[8]=a[8]);return b};mat3.set=function(a,b){b[0]=a[0];b[1]=a[1];b[2]=a[2];b[3]=a[3];b[4]=a[4];b[5]=a[5];b[6]=a[6];b[7]=a[7];b[8]=a[8];return b};mat3.identity=function(a){a[0]=1;a[1]=0;a[2]=0;a[3]=0;a[4]=1;a[5]=0;a[6]=0;a[7]=0;a[8]=1;return a};
mat3.transpose=function(a,b){if(!b||a===b){var c=a[1],d=a[2],e=a[5];a[1]=a[3];a[2]=a[6];a[3]=c;a[5]=a[7];a[6]=d;a[7]=e;return a}b[0]=a[0];b[1]=a[3];b[2]=a[6];b[3]=a[1];b[4]=a[4];b[5]=a[7];b[6]=a[2];b[7]=a[5];b[8]=a[8];return b};mat3.toMat4=function(a,b){b||(b=mat4.create());b[15]=1;b[14]=0;b[13]=0;b[12]=0;b[11]=0;b[10]=a[8];b[9]=a[7];b[8]=a[6];b[7]=0;b[6]=a[5];b[5]=a[4];b[4]=a[3];b[3]=0;b[2]=a[2];b[1]=a[1];b[0]=a[0];return b};
mat3.str=function(a){return"["+a[0]+", "+a[1]+", "+a[2]+", "+a[3]+", "+a[4]+", "+a[5]+", "+a[6]+", "+a[7]+", "+a[8]+"]"};mat4.create=function(a){var b=new MatrixArray(16);a&&(b[0]=a[0],b[1]=a[1],b[2]=a[2],b[3]=a[3],b[4]=a[4],b[5]=a[5],b[6]=a[6],b[7]=a[7],b[8]=a[8],b[9]=a[9],b[10]=a[10],b[11]=a[11],b[12]=a[12],b[13]=a[13],b[14]=a[14],b[15]=a[15]);return b};
mat4.set=function(a,b){b[0]=a[0];b[1]=a[1];b[2]=a[2];b[3]=a[3];b[4]=a[4];b[5]=a[5];b[6]=a[6];b[7]=a[7];b[8]=a[8];b[9]=a[9];b[10]=a[10];b[11]=a[11];b[12]=a[12];b[13]=a[13];b[14]=a[14];b[15]=a[15];return b};mat4.identity=function(a){a[0]=1;a[1]=0;a[2]=0;a[3]=0;a[4]=0;a[5]=1;a[6]=0;a[7]=0;a[8]=0;a[9]=0;a[10]=1;a[11]=0;a[12]=0;a[13]=0;a[14]=0;a[15]=1;return a};
mat4.transpose=function(a,b){if(!b||a===b){var c=a[1],d=a[2],e=a[3],g=a[6],f=a[7],h=a[11];a[1]=a[4];a[2]=a[8];a[3]=a[12];a[4]=c;a[6]=a[9];a[7]=a[13];a[8]=d;a[9]=g;a[11]=a[14];a[12]=e;a[13]=f;a[14]=h;return a}b[0]=a[0];b[1]=a[4];b[2]=a[8];b[3]=a[12];b[4]=a[1];b[5]=a[5];b[6]=a[9];b[7]=a[13];b[8]=a[2];b[9]=a[6];b[10]=a[10];b[11]=a[14];b[12]=a[3];b[13]=a[7];b[14]=a[11];b[15]=a[15];return b};
mat4.determinant=function(a){var b=a[0],c=a[1],d=a[2],e=a[3],g=a[4],f=a[5],h=a[6],i=a[7],j=a[8],k=a[9],l=a[10],n=a[11],o=a[12],m=a[13],p=a[14],a=a[15];return o*k*h*e-j*m*h*e-o*f*l*e+g*m*l*e+j*f*p*e-g*k*p*e-o*k*d*i+j*m*d*i+o*c*l*i-b*m*l*i-j*c*p*i+b*k*p*i+o*f*d*n-g*m*d*n-o*c*h*n+b*m*h*n+g*c*p*n-b*f*p*n-j*f*d*a+g*k*d*a+j*c*h*a-b*k*h*a-g*c*l*a+b*f*l*a};
mat4.inverse=function(a,b){b||(b=a);var c=a[0],d=a[1],e=a[2],g=a[3],f=a[4],h=a[5],i=a[6],j=a[7],k=a[8],l=a[9],n=a[10],o=a[11],m=a[12],p=a[13],r=a[14],s=a[15],A=c*h-d*f,B=c*i-e*f,t=c*j-g*f,u=d*i-e*h,v=d*j-g*h,w=e*j-g*i,x=k*p-l*m,y=k*r-n*m,z=k*s-o*m,C=l*r-n*p,D=l*s-o*p,E=n*s-o*r,q=1/(A*E-B*D+t*C+u*z-v*y+w*x);b[0]=(h*E-i*D+j*C)*q;b[1]=(-d*E+e*D-g*C)*q;b[2]=(p*w-r*v+s*u)*q;b[3]=(-l*w+n*v-o*u)*q;b[4]=(-f*E+i*z-j*y)*q;b[5]=(c*E-e*z+g*y)*q;b[6]=(-m*w+r*t-s*B)*q;b[7]=(k*w-n*t+o*B)*q;b[8]=(f*D-h*z+j*x)*q;
b[9]=(-c*D+d*z-g*x)*q;b[10]=(m*v-p*t+s*A)*q;b[11]=(-k*v+l*t-o*A)*q;b[12]=(-f*C+h*y-i*x)*q;b[13]=(c*C-d*y+e*x)*q;b[14]=(-m*u+p*B-r*A)*q;b[15]=(k*u-l*B+n*A)*q;return b};mat4.toRotationMat=function(a,b){b||(b=mat4.create());b[0]=a[0];b[1]=a[1];b[2]=a[2];b[3]=a[3];b[4]=a[4];b[5]=a[5];b[6]=a[6];b[7]=a[7];b[8]=a[8];b[9]=a[9];b[10]=a[10];b[11]=a[11];b[12]=0;b[13]=0;b[14]=0;b[15]=1;return b};
mat4.toMat3=function(a,b){b||(b=mat3.create());b[0]=a[0];b[1]=a[1];b[2]=a[2];b[3]=a[4];b[4]=a[5];b[5]=a[6];b[6]=a[8];b[7]=a[9];b[8]=a[10];return b};mat4.toInverseMat3=function(a,b){var c=a[0],d=a[1],e=a[2],g=a[4],f=a[5],h=a[6],i=a[8],j=a[9],k=a[10],l=k*f-h*j,n=-k*g+h*i,o=j*g-f*i,m=c*l+d*n+e*o;if(!m)return null;m=1/m;b||(b=mat3.create());b[0]=l*m;b[1]=(-k*d+e*j)*m;b[2]=(h*d-e*f)*m;b[3]=n*m;b[4]=(k*c-e*i)*m;b[5]=(-h*c+e*g)*m;b[6]=o*m;b[7]=(-j*c+d*i)*m;b[8]=(f*c-d*g)*m;return b};
mat4.multiply=function(a,b,c){c||(c=a);var d=a[0],e=a[1],g=a[2],f=a[3],h=a[4],i=a[5],j=a[6],k=a[7],l=a[8],n=a[9],o=a[10],m=a[11],p=a[12],r=a[13],s=a[14],a=a[15],A=b[0],B=b[1],t=b[2],u=b[3],v=b[4],w=b[5],x=b[6],y=b[7],z=b[8],C=b[9],D=b[10],E=b[11],q=b[12],F=b[13],G=b[14],b=b[15];c[0]=A*d+B*h+t*l+u*p;c[1]=A*e+B*i+t*n+u*r;c[2]=A*g+B*j+t*o+u*s;c[3]=A*f+B*k+t*m+u*a;c[4]=v*d+w*h+x*l+y*p;c[5]=v*e+w*i+x*n+y*r;c[6]=v*g+w*j+x*o+y*s;c[7]=v*f+w*k+x*m+y*a;c[8]=z*d+C*h+D*l+E*p;c[9]=z*e+C*i+D*n+E*r;c[10]=z*g+C*
j+D*o+E*s;c[11]=z*f+C*k+D*m+E*a;c[12]=q*d+F*h+G*l+b*p;c[13]=q*e+F*i+G*n+b*r;c[14]=q*g+F*j+G*o+b*s;c[15]=q*f+F*k+G*m+b*a;return c};mat4.multiplyVec3=function(a,b,c){c||(c=b);var d=b[0],e=b[1],b=b[2];c[0]=a[0]*d+a[4]*e+a[8]*b+a[12];c[1]=a[1]*d+a[5]*e+a[9]*b+a[13];c[2]=a[2]*d+a[6]*e+a[10]*b+a[14];return c};
mat4.multiplyVec4=function(a,b,c){c||(c=b);var d=b[0],e=b[1],g=b[2],b=b[3];c[0]=a[0]*d+a[4]*e+a[8]*g+a[12]*b;c[1]=a[1]*d+a[5]*e+a[9]*g+a[13]*b;c[2]=a[2]*d+a[6]*e+a[10]*g+a[14]*b;c[3]=a[3]*d+a[7]*e+a[11]*g+a[15]*b;return c};
mat4.translate=function(a,b,c){var d=b[0],e=b[1],b=b[2],g,f,h,i,j,k,l,n,o,m,p,r;if(!c||a===c)return a[12]=a[0]*d+a[4]*e+a[8]*b+a[12],a[13]=a[1]*d+a[5]*e+a[9]*b+a[13],a[14]=a[2]*d+a[6]*e+a[10]*b+a[14],a[15]=a[3]*d+a[7]*e+a[11]*b+a[15],a;g=a[0];f=a[1];h=a[2];i=a[3];j=a[4];k=a[5];l=a[6];n=a[7];o=a[8];m=a[9];p=a[10];r=a[11];c[0]=g;c[1]=f;c[2]=h;c[3]=i;c[4]=j;c[5]=k;c[6]=l;c[7]=n;c[8]=o;c[9]=m;c[10]=p;c[11]=r;c[12]=g*d+j*e+o*b+a[12];c[13]=f*d+k*e+m*b+a[13];c[14]=h*d+l*e+p*b+a[14];c[15]=i*d+n*e+r*b+a[15];
return c};mat4.scale=function(a,b,c){var d=b[0],e=b[1],b=b[2];if(!c||a===c)return a[0]*=d,a[1]*=d,a[2]*=d,a[3]*=d,a[4]*=e,a[5]*=e,a[6]*=e,a[7]*=e,a[8]*=b,a[9]*=b,a[10]*=b,a[11]*=b,a;c[0]=a[0]*d;c[1]=a[1]*d;c[2]=a[2]*d;c[3]=a[3]*d;c[4]=a[4]*e;c[5]=a[5]*e;c[6]=a[6]*e;c[7]=a[7]*e;c[8]=a[8]*b;c[9]=a[9]*b;c[10]=a[10]*b;c[11]=a[11]*b;c[12]=a[12];c[13]=a[13];c[14]=a[14];c[15]=a[15];return c};
mat4.rotate=function(a,b,c,d){var e=c[0],g=c[1],c=c[2],f=Math.sqrt(e*e+g*g+c*c),h,i,j,k,l,n,o,m,p,r,s,A,B,t,u,v,w,x,y,z;if(!f)return null;f!==1&&(f=1/f,e*=f,g*=f,c*=f);h=Math.sin(b);i=Math.cos(b);j=1-i;b=a[0];f=a[1];k=a[2];l=a[3];n=a[4];o=a[5];m=a[6];p=a[7];r=a[8];s=a[9];A=a[10];B=a[11];t=e*e*j+i;u=g*e*j+c*h;v=c*e*j-g*h;w=e*g*j-c*h;x=g*g*j+i;y=c*g*j+e*h;z=e*c*j+g*h;e=g*c*j-e*h;g=c*c*j+i;d?a!==d&&(d[12]=a[12],d[13]=a[13],d[14]=a[14],d[15]=a[15]):d=a;d[0]=b*t+n*u+r*v;d[1]=f*t+o*u+s*v;d[2]=k*t+m*u+A*
v;d[3]=l*t+p*u+B*v;d[4]=b*w+n*x+r*y;d[5]=f*w+o*x+s*y;d[6]=k*w+m*x+A*y;d[7]=l*w+p*x+B*y;d[8]=b*z+n*e+r*g;d[9]=f*z+o*e+s*g;d[10]=k*z+m*e+A*g;d[11]=l*z+p*e+B*g;return d};mat4.rotateX=function(a,b,c){var d=Math.sin(b),b=Math.cos(b),e=a[4],g=a[5],f=a[6],h=a[7],i=a[8],j=a[9],k=a[10],l=a[11];c?a!==c&&(c[0]=a[0],c[1]=a[1],c[2]=a[2],c[3]=a[3],c[12]=a[12],c[13]=a[13],c[14]=a[14],c[15]=a[15]):c=a;c[4]=e*b+i*d;c[5]=g*b+j*d;c[6]=f*b+k*d;c[7]=h*b+l*d;c[8]=e*-d+i*b;c[9]=g*-d+j*b;c[10]=f*-d+k*b;c[11]=h*-d+l*b;return c};
mat4.rotateY=function(a,b,c){var d=Math.sin(b),b=Math.cos(b),e=a[0],g=a[1],f=a[2],h=a[3],i=a[8],j=a[9],k=a[10],l=a[11];c?a!==c&&(c[4]=a[4],c[5]=a[5],c[6]=a[6],c[7]=a[7],c[12]=a[12],c[13]=a[13],c[14]=a[14],c[15]=a[15]):c=a;c[0]=e*b+i*-d;c[1]=g*b+j*-d;c[2]=f*b+k*-d;c[3]=h*b+l*-d;c[8]=e*d+i*b;c[9]=g*d+j*b;c[10]=f*d+k*b;c[11]=h*d+l*b;return c};
mat4.rotateZ=function(a,b,c){var d=Math.sin(b),b=Math.cos(b),e=a[0],g=a[1],f=a[2],h=a[3],i=a[4],j=a[5],k=a[6],l=a[7];c?a!==c&&(c[8]=a[8],c[9]=a[9],c[10]=a[10],c[11]=a[11],c[12]=a[12],c[13]=a[13],c[14]=a[14],c[15]=a[15]):c=a;c[0]=e*b+i*d;c[1]=g*b+j*d;c[2]=f*b+k*d;c[3]=h*b+l*d;c[4]=e*-d+i*b;c[5]=g*-d+j*b;c[6]=f*-d+k*b;c[7]=h*-d+l*b;return c};
mat4.frustum=function(a,b,c,d,e,g,f){f||(f=mat4.create());var h=b-a,i=d-c,j=g-e;f[0]=e*2/h;f[1]=0;f[2]=0;f[3]=0;f[4]=0;f[5]=e*2/i;f[6]=0;f[7]=0;f[8]=(b+a)/h;f[9]=(d+c)/i;f[10]=-(g+e)/j;f[11]=-1;f[12]=0;f[13]=0;f[14]=-(g*e*2)/j;f[15]=0;return f};mat4.perspective=function(a,b,c,d,e){a=c*Math.tan(a*Math.PI/360);b*=a;return mat4.frustum(-b,b,-a,a,c,d,e)};
mat4.ortho=function(a,b,c,d,e,g,f){f||(f=mat4.create());var h=b-a,i=d-c,j=g-e;f[0]=2/h;f[1]=0;f[2]=0;f[3]=0;f[4]=0;f[5]=2/i;f[6]=0;f[7]=0;f[8]=0;f[9]=0;f[10]=-2/j;f[11]=0;f[12]=-(a+b)/h;f[13]=-(d+c)/i;f[14]=-(g+e)/j;f[15]=1;return f};
mat4.lookAt=function(a,b,c,d){d||(d=mat4.create());var e,g,f,h,i,j,k,l,n=a[0],o=a[1],a=a[2];g=c[0];f=c[1];e=c[2];c=b[1];j=b[2];if(n===b[0]&&o===c&&a===j)return mat4.identity(d);c=n-b[0];j=o-b[1];k=a-b[2];l=1/Math.sqrt(c*c+j*j+k*k);c*=l;j*=l;k*=l;b=f*k-e*j;e=e*c-g*k;g=g*j-f*c;(l=Math.sqrt(b*b+e*e+g*g))?(l=1/l,b*=l,e*=l,g*=l):g=e=b=0;f=j*g-k*e;h=k*b-c*g;i=c*e-j*b;(l=Math.sqrt(f*f+h*h+i*i))?(l=1/l,f*=l,h*=l,i*=l):i=h=f=0;d[0]=b;d[1]=f;d[2]=c;d[3]=0;d[4]=e;d[5]=h;d[6]=j;d[7]=0;d[8]=g;d[9]=i;d[10]=k;d[11]=
0;d[12]=-(b*n+e*o+g*a);d[13]=-(f*n+h*o+i*a);d[14]=-(c*n+j*o+k*a);d[15]=1;return d};mat4.fromRotationTranslation=function(a,b,c){c||(c=mat4.create());var d=a[0],e=a[1],g=a[2],f=a[3],h=d+d,i=e+e,j=g+g,a=d*h,k=d*i;d*=j;var l=e*i;e*=j;g*=j;h*=f;i*=f;f*=j;c[0]=1-(l+g);c[1]=k+f;c[2]=d-i;c[3]=0;c[4]=k-f;c[5]=1-(a+g);c[6]=e+h;c[7]=0;c[8]=d+i;c[9]=e-h;c[10]=1-(a+l);c[11]=0;c[12]=b[0];c[13]=b[1];c[14]=b[2];c[15]=1;return c};
mat4.str=function(a){return"["+a[0]+", "+a[1]+", "+a[2]+", "+a[3]+", "+a[4]+", "+a[5]+", "+a[6]+", "+a[7]+", "+a[8]+", "+a[9]+", "+a[10]+", "+a[11]+", "+a[12]+", "+a[13]+", "+a[14]+", "+a[15]+"]"};quat4.create=function(a){var b=new MatrixArray(4);a&&(b[0]=a[0],b[1]=a[1],b[2]=a[2],b[3]=a[3]);return b};quat4.set=function(a,b){b[0]=a[0];b[1]=a[1];b[2]=a[2];b[3]=a[3];return b};
quat4.calculateW=function(a,b){var c=a[0],d=a[1],e=a[2];if(!b||a===b)return a[3]=-Math.sqrt(Math.abs(1-c*c-d*d-e*e)),a;b[0]=c;b[1]=d;b[2]=e;b[3]=-Math.sqrt(Math.abs(1-c*c-d*d-e*e));return b};quat4.inverse=function(a,b){if(!b||a===b)return a[0]*=-1,a[1]*=-1,a[2]*=-1,a;b[0]=-a[0];b[1]=-a[1];b[2]=-a[2];b[3]=a[3];return b};quat4.length=function(a){var b=a[0],c=a[1],d=a[2],a=a[3];return Math.sqrt(b*b+c*c+d*d+a*a)};
quat4.normalize=function(a,b){b||(b=a);var c=a[0],d=a[1],e=a[2],g=a[3],f=Math.sqrt(c*c+d*d+e*e+g*g);if(f===0)return b[0]=0,b[1]=0,b[2]=0,b[3]=0,b;f=1/f;b[0]=c*f;b[1]=d*f;b[2]=e*f;b[3]=g*f;return b};quat4.multiply=function(a,b,c){c||(c=a);var d=a[0],e=a[1],g=a[2],a=a[3],f=b[0],h=b[1],i=b[2],b=b[3];c[0]=d*b+a*f+e*i-g*h;c[1]=e*b+a*h+g*f-d*i;c[2]=g*b+a*i+d*h-e*f;c[3]=a*b-d*f-e*h-g*i;return c};
quat4.multiplyVec3=function(a,b,c){c||(c=b);var d=b[0],e=b[1],g=b[2],b=a[0],f=a[1],h=a[2],a=a[3],i=a*d+f*g-h*e,j=a*e+h*d-b*g,k=a*g+b*e-f*d,d=-b*d-f*e-h*g;c[0]=i*a+d*-b+j*-h-k*-f;c[1]=j*a+d*-f+k*-b-i*-h;c[2]=k*a+d*-h+i*-f-j*-b;return c};quat4.toMat3=function(a,b){b||(b=mat3.create());var c=a[0],d=a[1],e=a[2],g=a[3],f=c+c,h=d+d,i=e+e,j=c*f,k=c*h;c*=i;var l=d*h;d*=i;e*=i;f*=g;h*=g;g*=i;b[0]=1-(l+e);b[1]=k+g;b[2]=c-h;b[3]=k-g;b[4]=1-(j+e);b[5]=d+f;b[6]=c+h;b[7]=d-f;b[8]=1-(j+l);return b};
quat4.toMat4=function(a,b){b||(b=mat4.create());var c=a[0],d=a[1],e=a[2],g=a[3],f=c+c,h=d+d,i=e+e,j=c*f,k=c*h;c*=i;var l=d*h;d*=i;e*=i;f*=g;h*=g;g*=i;b[0]=1-(l+e);b[1]=k+g;b[2]=c-h;b[3]=0;b[4]=k-g;b[5]=1-(j+e);b[6]=d+f;b[7]=0;b[8]=c+h;b[9]=d-f;b[10]=1-(j+l);b[11]=0;b[12]=0;b[13]=0;b[14]=0;b[15]=1;return b};
quat4.slerp=function(a,b,c,d){d||(d=a);var e=a[0]*b[0]+a[1]*b[1]+a[2]*b[2]+a[3]*b[3],g,f;if(Math.abs(e)>=1)return d!==a&&(d[0]=a[0],d[1]=a[1],d[2]=a[2],d[3]=a[3]),d;g=Math.acos(e);f=Math.sqrt(1-e*e);if(Math.abs(f)<0.001)return d[0]=a[0]*0.5+b[0]*0.5,d[1]=a[1]*0.5+b[1]*0.5,d[2]=a[2]*0.5+b[2]*0.5,d[3]=a[3]*0.5+b[3]*0.5,d;e=Math.sin((1-c)*g)/f;c=Math.sin(c*g)/f;d[0]=a[0]*e+b[0]*c;d[1]=a[1]*e+b[1]*c;d[2]=a[2]*e+b[2]*c;d[3]=a[3]*e+b[3]*c;return d};
quat4.str=function(a){return"["+a[0]+", "+a[1]+", "+a[2]+", "+a[3]+"]"};
(function()
{
	var MAX_VERTICES = 8000;						// equates to 2500 objects being drawn
	var MAX_INDICES = (MAX_VERTICES / 2) * 3;		// 6 indices for every 4 vertices
	var MAX_POINTS = 8000;
	var MULTI_BUFFERS = 4;							// cycle 4 buffers to try and avoid blocking
	var BATCH_NULL = 0;
	var BATCH_QUAD = 1;
	var BATCH_SETTEXTURE = 2;
	var BATCH_SETOPACITY = 3;
	var BATCH_SETBLEND = 4;
	var BATCH_UPDATEMODELVIEW = 5;
	var BATCH_RENDERTOTEXTURE = 6;
	var BATCH_CLEAR = 7;
	var BATCH_POINTS = 8;
	var BATCH_SETPROGRAM = 9;
	var BATCH_SETPROGRAMPARAMETERS = 10;
	var BATCH_SETTEXTURE1 = 11;
	function GLWrap_(gl, isMobile)
	{
		this.isIE = /msie/i.test(navigator.userAgent) || /trident/i.test(navigator.userAgent);
		this.width = 0;		// not yet known, wait for call to setSize()
		this.height = 0;
		this.cam = vec3.create([0, 0, 100]);			// camera position
		this.look = vec3.create([0, 0, 0]);				// lookat position
		this.up = vec3.create([0, 1, 0]);				// up vector
		this.worldScale = vec3.create([1, 1, 1]);		// world scaling factor
		this.matP = mat4.create();						// perspective matrix
		this.matMV = mat4.create();						// model view matrix
		this.lastMV = mat4.create();
		this.currentMV = mat4.create();
		this.gl = gl;
		this.initState();
	};
	GLWrap_.prototype.initState = function ()
	{
		var gl = this.gl;
		var i, len;
		this.lastOpacity = 1;
		this.lastTexture0 = null;			// last bound to TEXTURE0
		this.lastTexture1 = null;			// last bound to TEXTURE1
		this.currentOpacity = 1;
		gl.clearColor(0, 0, 0, 0);
		gl.clear(gl.COLOR_BUFFER_BIT);
		gl.enable(gl.BLEND);
        gl.blendFunc(gl.ONE, gl.ONE_MINUS_SRC_ALPHA);
		gl.disable(gl.CULL_FACE);
		gl.disable(gl.DEPTH_TEST);
		this.maxTextureSize = gl.getParameter(gl.MAX_TEXTURE_SIZE);
		this.lastSrcBlend = gl.ONE;
		this.lastDestBlend = gl.ONE_MINUS_SRC_ALPHA;
		this.pointBuffer = gl.createBuffer();
		gl.bindBuffer(gl.ARRAY_BUFFER, this.pointBuffer);
		this.vertexBuffers = new Array(MULTI_BUFFERS);
		this.texcoordBuffers = new Array(MULTI_BUFFERS);
		for (i = 0; i < MULTI_BUFFERS; i++)
		{
			this.vertexBuffers[i] = gl.createBuffer();
			gl.bindBuffer(gl.ARRAY_BUFFER, this.vertexBuffers[i]);
			this.texcoordBuffers[i] = gl.createBuffer();
			gl.bindBuffer(gl.ARRAY_BUFFER, this.texcoordBuffers[i]);
		}
		this.curBuffer = 0;
		this.indexBuffer = gl.createBuffer();
		gl.bindBuffer(gl.ELEMENT_ARRAY_BUFFER, this.indexBuffer);
		this.vertexData = new Float32Array(MAX_VERTICES * 2);
		this.texcoordData = new Float32Array(MAX_VERTICES * 2);
		this.pointData = new Float32Array(MAX_POINTS * 4);
		var indexData = new Uint16Array(MAX_INDICES);
		i = 0, len = MAX_INDICES;
		var fv = 0;
		while (i < len)
		{
			indexData[i++] = fv;		// top left
			indexData[i++] = fv + 1;	// top right
			indexData[i++] = fv + 2;	// bottom right (first tri)
			indexData[i++] = fv;		// top left
			indexData[i++] = fv + 2;	// bottom right
			indexData[i++] = fv + 3;	// bottom left
			fv += 4;
		}
		gl.bufferData(gl.ELEMENT_ARRAY_BUFFER, indexData, gl.STATIC_DRAW);
		this.vertexPtr = 0;
		this.pointPtr = 0;
		var fsSource, vsSource;
		this.shaderPrograms = [];
		fsSource = [
			"varying mediump vec2 vTex;",
			"uniform lowp float opacity;",
			"uniform lowp sampler2D samplerFront;",
			"void main(void) {",
			"	gl_FragColor = texture2D(samplerFront, vTex);",
			"	gl_FragColor *= opacity;",
			"}"
		].join("\n");
		vsSource = [
			"attribute highp vec2 aPos;",
			"attribute mediump vec2 aTex;",
			"varying mediump vec2 vTex;",
			"uniform highp mat4 matP;",
			"uniform highp mat4 matMV;",
			"void main(void) {",
			"	gl_Position = matP * matMV * vec4(aPos.x, aPos.y, 0.0, 1.0);",
			"	vTex = aTex;",
			"}"
		].join("\n");
		var shaderProg = this.createShaderProgram({src: fsSource}, vsSource, "<default>");
;
		this.shaderPrograms.push(shaderProg);		// Default shader is always shader 0
		fsSource = [
			"uniform mediump sampler2D samplerFront;",
			"varying lowp float opacity;",
			"void main(void) {",
			"	gl_FragColor = texture2D(samplerFront, gl_PointCoord);",
			"	gl_FragColor *= opacity;",
			"}"
		].join("\n");
		var pointVsSource = [
			"attribute vec4 aPos;",
			"varying float opacity;",
			"uniform mat4 matP;",
			"uniform mat4 matMV;",
			"void main(void) {",
			"	gl_Position = matP * matMV * vec4(aPos.x, aPos.y, 0.0, 1.0);",
			"	gl_PointSize = aPos.z;",
			"	opacity = aPos.w;",
			"}"
		].join("\n");
		shaderProg = this.createShaderProgram({src: fsSource}, pointVsSource, "<point>");
;
		this.shaderPrograms.push(shaderProg);		// Point shader is always shader 1
		for (var shader_name in cr.shaders)
		{
			if (cr.shaders.hasOwnProperty(shader_name))
				this.shaderPrograms.push(this.createShaderProgram(cr.shaders[shader_name], vsSource, shader_name));
		}
		gl.activeTexture(gl.TEXTURE0);
		gl.bindTexture(gl.TEXTURE_2D, null);
		this.batch = [];
		this.batchPtr = 0;
		this.hasQuadBatchTop = false;
		this.hasPointBatchTop = false;
		this.lastProgram = -1;				// start -1 so first switchProgram can do work
		this.currentProgram = -1;			// current program during batch execution
		this.currentShader = null;
		this.fbo = gl.createFramebuffer();
		this.renderToTex = null;
		this.tmpVec3 = vec3.create([0, 0, 0]);
;
;
		var pointsizes = gl.getParameter(gl.ALIASED_POINT_SIZE_RANGE);
		this.minPointSize = pointsizes[0];
		this.maxPointSize = pointsizes[1];
;
		this.switchProgram(0);
		cr.seal(this);
	};
	function GLShaderProgram(gl, shaderProgram, name)
	{
		this.gl = gl;
		this.shaderProgram = shaderProgram;
		this.name = name;
		this.locAPos = gl.getAttribLocation(shaderProgram, "aPos");
		this.locATex = gl.getAttribLocation(shaderProgram, "aTex");
		this.locMatP = gl.getUniformLocation(shaderProgram, "matP");
		this.locMatMV = gl.getUniformLocation(shaderProgram, "matMV");
		this.locOpacity = gl.getUniformLocation(shaderProgram, "opacity");
		this.locSamplerFront = gl.getUniformLocation(shaderProgram, "samplerFront");
		this.locSamplerBack = gl.getUniformLocation(shaderProgram, "samplerBack");
		this.locDestStart = gl.getUniformLocation(shaderProgram, "destStart");
		this.locDestEnd = gl.getUniformLocation(shaderProgram, "destEnd");
		this.locSeconds = gl.getUniformLocation(shaderProgram, "seconds");
		this.locPixelWidth = gl.getUniformLocation(shaderProgram, "pixelWidth");
		this.locPixelHeight = gl.getUniformLocation(shaderProgram, "pixelHeight");
		this.locLayerScale = gl.getUniformLocation(shaderProgram, "layerScale");
		if (this.locOpacity)
			gl.uniform1f(this.locOpacity, 1);
		if (this.locSamplerFront)
			gl.uniform1i(this.locSamplerFront, 0);
		if (this.locSamplerBack)
			gl.uniform1i(this.locSamplerBack, 1);
		if (this.locDestStart)
			gl.uniform2f(this.locDestStart, 0.0, 0.0);
		if (this.locDestEnd)
			gl.uniform2f(this.locDestEnd, 1.0, 1.0);
		this.hasCurrentMatMV = false;		// matMV needs updating
	};
	GLWrap_.prototype.createShaderProgram = function(shaderEntry, vsSource, name)
	{
		var gl = this.gl;
		var fragmentShader = gl.createShader(gl.FRAGMENT_SHADER);
		gl.shaderSource(fragmentShader, shaderEntry.src);
		gl.compileShader(fragmentShader);
		if (!gl.getShaderParameter(fragmentShader, gl.COMPILE_STATUS))
		{
;
			gl.deleteShader(fragmentShader);
			return null;
		}
		var vertexShader = gl.createShader(gl.VERTEX_SHADER);
		gl.shaderSource(vertexShader, vsSource);
		gl.compileShader(vertexShader);
		if (!gl.getShaderParameter(vertexShader, gl.COMPILE_STATUS))
		{
;
			gl.deleteShader(fragmentShader);
			gl.deleteShader(vertexShader);
			return null;
		}
		var shaderProgram = gl.createProgram();
		gl.attachShader(shaderProgram, fragmentShader);
		gl.attachShader(shaderProgram, vertexShader);
		gl.linkProgram(shaderProgram);
		if (!gl.getProgramParameter(shaderProgram, gl.LINK_STATUS))
		{
;
			gl.deleteShader(fragmentShader);
			gl.deleteShader(vertexShader);
			gl.deleteProgram(shaderProgram);
			return null;
		}
		gl.useProgram(shaderProgram);
;
		gl.deleteShader(fragmentShader);
		gl.deleteShader(vertexShader);
		var ret = new GLShaderProgram(gl, shaderProgram, name);
		ret.extendBoxHorizontal = shaderEntry.extendBoxHorizontal || 0;
		ret.extendBoxVertical = shaderEntry.extendBoxVertical || 0;
		ret.crossSampling = !!shaderEntry.crossSampling;
		ret.animated = !!shaderEntry.animated;
		ret.parameters = shaderEntry.parameters || [];
		var i, len;
		for (i = 0, len = ret.parameters.length; i < len; i++)
		{
			ret.parameters[i][1] = gl.getUniformLocation(shaderProgram, ret.parameters[i][0]);
			gl.uniform1f(ret.parameters[i][1], 0);
		}
		cr.seal(ret);
		return ret;
	};
	GLWrap_.prototype.getShaderIndex = function(name_)
	{
		var i, len;
		for (i = 0, len = this.shaderPrograms.length; i < len; i++)
		{
			if (this.shaderPrograms[i].name === name_)
				return i;
		}
		return -1;
	};
	GLWrap_.prototype.project = function (x, y, out)
	{
		var viewport = [0, 0, this.width, this.height];
		var mv = this.matMV;
		var proj = this.matP;
		var fTempo = [0, 0, 0, 0, 0, 0, 0, 0];
		fTempo[0] = mv[0]*x+mv[4]*y+mv[12];
		fTempo[1] = mv[1]*x+mv[5]*y+mv[13];
		fTempo[2] = mv[2]*x+mv[6]*y+mv[14];
		fTempo[3] = mv[3]*x+mv[7]*y+mv[15];
		fTempo[4] = proj[0]*fTempo[0]+proj[4]*fTempo[1]+proj[8]*fTempo[2]+proj[12]*fTempo[3];
		fTempo[5] = proj[1]*fTempo[0]+proj[5]*fTempo[1]+proj[9]*fTempo[2]+proj[13]*fTempo[3];
		fTempo[6] = proj[2]*fTempo[0]+proj[6]*fTempo[1]+proj[10]*fTempo[2]+proj[14]*fTempo[3];
		fTempo[7] = -fTempo[2];
		if(fTempo[7]===0.0)	//The w value
			return;
		fTempo[7]=1.0/fTempo[7];
		fTempo[4]*=fTempo[7];
		fTempo[5]*=fTempo[7];
		fTempo[6]*=fTempo[7];
		out[0]=(fTempo[4]*0.5+0.5)*viewport[2]+viewport[0];
		out[1]=(fTempo[5]*0.5+0.5)*viewport[3]+viewport[1];
	};
	GLWrap_.prototype.setSize = function(w, h, force)
	{
		if (this.width === w && this.height === h && !force)
			return;
		this.endBatch();
		this.width = w;
		this.height = h;
		this.gl.viewport(0, 0, w, h);
		mat4.perspective(45, w / h, 1, 1000, this.matP);
		mat4.lookAt(this.cam, this.look, this.up, this.matMV);
		var tl = [0, 0];
		var br = [0, 0];
		this.project(0, 0, tl);
		this.project(1, 1, br);
		this.worldScale[0] = 1 / (br[0] - tl[0]);
		this.worldScale[1] = -1 / (br[1] - tl[1]);
		var i, len, s;
		for (i = 0, len = this.shaderPrograms.length; i < len; i++)
		{
			s = this.shaderPrograms[i];
			s.hasCurrentMatMV = false;
			if (s.locMatP)
			{
				this.gl.useProgram(s.shaderProgram);
				this.gl.uniformMatrix4fv(s.locMatP, false, this.matP);
			}
		}
		this.gl.useProgram(this.shaderPrograms[this.lastProgram].shaderProgram);
		this.gl.bindTexture(this.gl.TEXTURE_2D, null);
		this.gl.activeTexture(this.gl.TEXTURE1);
		this.gl.bindTexture(this.gl.TEXTURE_2D, null);
		this.gl.activeTexture(this.gl.TEXTURE0);
		this.lastTexture0 = null;
		this.lastTexture1 = null;
	};
	GLWrap_.prototype.resetModelView = function ()
	{
		mat4.lookAt(this.cam, this.look, this.up, this.matMV);
		mat4.scale(this.matMV, this.worldScale);
	};
	GLWrap_.prototype.translate = function (x, y)
	{
		if (x === 0 && y === 0)
			return;
		this.tmpVec3[0] = x;// * this.worldScale[0];
		this.tmpVec3[1] = y;// * this.worldScale[1];
		this.tmpVec3[2] = 0;
		mat4.translate(this.matMV, this.tmpVec3);
	};
	GLWrap_.prototype.scale = function (x, y)
	{
		if (x === 1 && y === 1)
			return;
		this.tmpVec3[0] = x;
		this.tmpVec3[1] = y;
		this.tmpVec3[2] = 1;
		mat4.scale(this.matMV, this.tmpVec3);
	};
	GLWrap_.prototype.rotateZ = function (a)
	{
		if (a === 0)
			return;
		mat4.rotateZ(this.matMV, a);
	};
	GLWrap_.prototype.updateModelView = function()
	{
		var anydiff = false;
		for (var i = 0; i < 16; i++)
		{
			if (this.lastMV[i] !== this.matMV[i])
			{
				anydiff = true;
				break;
			}
		}
		if (!anydiff)
			return;
		var b = this.pushBatch();
		b.type = BATCH_UPDATEMODELVIEW;
		if (b.mat4param)
			mat4.set(this.matMV, b.mat4param);
		else
			b.mat4param = mat4.create(this.matMV);
		mat4.set(this.matMV, this.lastMV);
		this.hasQuadBatchTop = false;
		this.hasPointBatchTop = false;
	};
	/*
	var debugBatch = false;
	jQuery(document).mousedown(
		function(info) {
			if (info.which === 2)
				debugBatch = true;
		}
	);
	*/
	function GLBatchJob(type_, glwrap_)
	{
		this.type = type_;
		this.glwrap = glwrap_;
		this.gl = glwrap_.gl;
		this.opacityParam = 0;		// for setOpacity()
		this.startIndex = 0;		// for quad()
		this.indexCount = 0;		// "
		this.texParam = null;		// for setTexture()
		this.mat4param = null;		// for updateModelView()
		this.shaderParams = [];		// for user parameters
		cr.seal(this);
	};
	GLBatchJob.prototype.doSetTexture = function ()
	{
		this.gl.bindTexture(this.gl.TEXTURE_2D, this.texParam);
	};
	GLBatchJob.prototype.doSetTexture1 = function ()
	{
		var gl = this.gl;
		gl.activeTexture(gl.TEXTURE1);
		gl.bindTexture(gl.TEXTURE_2D, this.texParam);
		gl.activeTexture(gl.TEXTURE0);
	};
	GLBatchJob.prototype.doSetOpacity = function ()
	{
		var o = this.opacityParam;
		var glwrap = this.glwrap;
		glwrap.currentOpacity = o;
		var curProg = glwrap.currentShader;
		if (curProg.locOpacity)
			this.gl.uniform1f(curProg.locOpacity, o);
	};
	GLBatchJob.prototype.doQuad = function ()
	{
		this.gl.drawElements(this.gl.TRIANGLES, this.indexCount, this.gl.UNSIGNED_SHORT, this.startIndex * 2);
	};
	GLBatchJob.prototype.doSetBlend = function ()
	{
		this.gl.blendFunc(this.startIndex, this.indexCount);
	};
	GLBatchJob.prototype.doUpdateModelView = function ()
	{
		var i, len, s, shaderPrograms = this.glwrap.shaderPrograms, currentProgram = this.glwrap.currentProgram;
		for (i = 0, len = shaderPrograms.length; i < len; i++)
		{
			s = shaderPrograms[i];
			if (i === currentProgram && s.locMatMV)
			{
				this.gl.uniformMatrix4fv(s.locMatMV, false, this.mat4param);
				s.hasCurrentMatMV = true;
			}
			else
				s.hasCurrentMatMV = false;
		}
		mat4.set(this.mat4param, this.glwrap.currentMV);
	};
	GLBatchJob.prototype.doRenderToTexture = function ()
	{
		var gl = this.gl;
		var glwrap = this.glwrap;
		if (this.texParam)
		{
			if (glwrap.lastTexture1 === this.texParam)
			{
				gl.activeTexture(gl.TEXTURE1);
				gl.bindTexture(gl.TEXTURE_2D, null);
				glwrap.lastTexture1 = null;
				gl.activeTexture(gl.TEXTURE0);
			}
			gl.bindFramebuffer(gl.FRAMEBUFFER, glwrap.fbo);
			gl.framebufferTexture2D(gl.FRAMEBUFFER, gl.COLOR_ATTACHMENT0, gl.TEXTURE_2D, this.texParam, 0);
		}
		else
		{
			gl.framebufferTexture2D(gl.FRAMEBUFFER, gl.COLOR_ATTACHMENT0, gl.TEXTURE_2D, null, 0);
			gl.bindFramebuffer(gl.FRAMEBUFFER, null);
		}
	};
	GLBatchJob.prototype.doClear = function ()
	{
		var gl = this.gl;
		if (this.startIndex === 0)		// clear whole surface
		{
			gl.clearColor(this.mat4param[0], this.mat4param[1], this.mat4param[2], this.mat4param[3]);
			gl.clear(gl.COLOR_BUFFER_BIT);
		}
		else							// clear rectangle
		{
			gl.enable(gl.SCISSOR_TEST);
			gl.scissor(this.mat4param[0], this.mat4param[1], this.mat4param[2], this.mat4param[3]);
			gl.clearColor(0, 0, 0, 0);
			gl.clear(this.gl.COLOR_BUFFER_BIT);
			gl.disable(gl.SCISSOR_TEST);
		}
	};
	GLBatchJob.prototype.doPoints = function ()
	{
		var gl = this.gl;
		var glwrap = this.glwrap;
		var s = glwrap.shaderPrograms[1];
		gl.useProgram(s.shaderProgram);
		if (!s.hasCurrentMatMV && s.locMatMV)
		{
			gl.uniformMatrix4fv(s.locMatMV, false, glwrap.currentMV);
			s.hasCurrentMatMV = true;
		}
		gl.enableVertexAttribArray(s.locAPos);
		gl.bindBuffer(gl.ARRAY_BUFFER, glwrap.pointBuffer);
		gl.vertexAttribPointer(s.locAPos, 4, gl.FLOAT, false, 0, 0);
		gl.drawArrays(gl.POINTS, this.startIndex / 4, this.indexCount);
		s = glwrap.currentShader;
		gl.useProgram(s.shaderProgram);
		if (s.locAPos >= 0)
		{
			gl.enableVertexAttribArray(s.locAPos);
			gl.bindBuffer(gl.ARRAY_BUFFER, glwrap.vertexBuffers[glwrap.curBuffer]);
			gl.vertexAttribPointer(s.locAPos, 2, gl.FLOAT, false, 0, 0);
		}
		if (s.locATex >= 0)
		{
			gl.enableVertexAttribArray(s.locATex);
			gl.bindBuffer(gl.ARRAY_BUFFER, glwrap.texcoordBuffers[glwrap.curBuffer]);
			gl.vertexAttribPointer(s.locATex, 2, gl.FLOAT, false, 0, 0);
		}
	};
	GLBatchJob.prototype.doSetProgram = function ()
	{
		var gl = this.gl;
		var glwrap = this.glwrap;
		var s = glwrap.shaderPrograms[this.startIndex];		// recycled param to save memory
		glwrap.currentProgram = this.startIndex;			// current batch program
		glwrap.currentShader = s;
		gl.useProgram(s.shaderProgram);						// switch to
		if (!s.hasCurrentMatMV && s.locMatMV)
		{
			gl.uniformMatrix4fv(s.locMatMV, false, glwrap.currentMV);
			s.hasCurrentMatMV = true;
		}
		if (s.locOpacity)
			gl.uniform1f(s.locOpacity, glwrap.currentOpacity);
		if (s.locAPos >= 0)
		{
			gl.enableVertexAttribArray(s.locAPos);
			gl.bindBuffer(gl.ARRAY_BUFFER, glwrap.vertexBuffers[glwrap.curBuffer]);
			gl.vertexAttribPointer(s.locAPos, 2, gl.FLOAT, false, 0, 0);
		}
		if (s.locATex >= 0)
		{
			gl.enableVertexAttribArray(s.locATex);
			gl.bindBuffer(gl.ARRAY_BUFFER, glwrap.texcoordBuffers[glwrap.curBuffer]);
			gl.vertexAttribPointer(s.locATex, 2, gl.FLOAT, false, 0, 0);
		}
	}
	GLBatchJob.prototype.doSetProgramParameters = function ()
	{
		var i, len, s = this.glwrap.currentShader;
		var gl = this.gl;
		if (s.locSamplerBack && this.glwrap.lastTexture1 !== this.texParam)
		{
			gl.activeTexture(gl.TEXTURE1);
			gl.bindTexture(gl.TEXTURE_2D, this.texParam);
			this.glwrap.lastTexture1 = this.texParam;
			gl.activeTexture(gl.TEXTURE0);
		}
		if (s.locPixelWidth)
			gl.uniform1f(s.locPixelWidth, this.mat4param[0]);
		if (s.locPixelHeight)
			gl.uniform1f(s.locPixelHeight, this.mat4param[1]);
		if (s.locDestStart)
			gl.uniform2f(s.locDestStart, this.mat4param[2], this.mat4param[3]);
		if (s.locDestEnd)
			gl.uniform2f(s.locDestEnd, this.mat4param[4], this.mat4param[5]);
		if (s.locLayerScale)
			gl.uniform1f(s.locLayerScale, this.mat4param[6]);
		if (s.locSeconds)
			gl.uniform1f(s.locSeconds, cr.performance_now() / 1000.0);
		if (s.parameters.length)
		{
			for (i = 0, len = s.parameters.length; i < len; i++)
			{
				gl.uniform1f(s.parameters[i][1], this.shaderParams[i]);
			}
		}
	};
	GLWrap_.prototype.pushBatch = function ()
	{
		if (this.batchPtr === this.batch.length)
			this.batch.push(new GLBatchJob(BATCH_NULL, this));
		return this.batch[this.batchPtr++];
	};
	GLWrap_.prototype.endBatch = function ()
	{
		if (this.batchPtr === 0)
			return;
		if (this.gl.isContextLost())
			return;
		var gl = this.gl;
		if (this.pointPtr > 0)
		{
			gl.bindBuffer(gl.ARRAY_BUFFER, this.pointBuffer);
			gl.bufferData(gl.ARRAY_BUFFER, this.pointData.subarray(0, this.pointPtr), gl.STREAM_DRAW);
			if (s && s.locAPos >= 0 && s.name === "<point>")
				gl.vertexAttribPointer(s.locAPos, 4, gl.FLOAT, false, 0, 0);
		}
		if (this.vertexPtr > 0)
		{
			var s = this.currentShader;
			gl.bindBuffer(gl.ARRAY_BUFFER, this.vertexBuffers[this.curBuffer]);
			gl.bufferData(gl.ARRAY_BUFFER, this.vertexData.subarray(0, this.vertexPtr), gl.STREAM_DRAW);
			if (s && s.locAPos >= 0 && s.name !== "<point>")
				gl.vertexAttribPointer(s.locAPos, 2, gl.FLOAT, false, 0, 0);
			gl.bindBuffer(gl.ARRAY_BUFFER, this.texcoordBuffers[this.curBuffer]);
			gl.bufferData(gl.ARRAY_BUFFER, this.texcoordData.subarray(0, this.vertexPtr), gl.STREAM_DRAW);
			if (s && s.locATex >= 0 && s.name !== "<point>")
				gl.vertexAttribPointer(s.locATex, 2, gl.FLOAT, false, 0, 0);
		}
		var i, len, b;
		for (i = 0, len = this.batchPtr; i < len; i++)
		{
			b = this.batch[i];
			switch (b.type) {
			case BATCH_QUAD:
				b.doQuad();
				break;
			case BATCH_SETTEXTURE:
				b.doSetTexture();
				break;
			case BATCH_SETOPACITY:
				b.doSetOpacity();
				break;
			case BATCH_SETBLEND:
				b.doSetBlend();
				break;
			case BATCH_UPDATEMODELVIEW:
				b.doUpdateModelView();
				break;
			case BATCH_RENDERTOTEXTURE:
				b.doRenderToTexture();
				break;
			case BATCH_CLEAR:
				b.doClear();
				break;
			case BATCH_POINTS:
				b.doPoints();
				break;
			case BATCH_SETPROGRAM:
				b.doSetProgram();
				break;
			case BATCH_SETPROGRAMPARAMETERS:
				b.doSetProgramParameters();
				break;
			case BATCH_SETTEXTURE1:
				b.doSetTexture1();
				break;
			}
		}
		this.batchPtr = 0;
		this.vertexPtr = 0;
		this.pointPtr = 0;
		this.hasQuadBatchTop = false;
		this.hasPointBatchTop = false;
		this.curBuffer++;
		if (this.curBuffer >= MULTI_BUFFERS)
			this.curBuffer = 0;
	};
	GLWrap_.prototype.setOpacity = function (op)
	{
		if (op === this.lastOpacity)
			return;
		var b = this.pushBatch();
		b.type = BATCH_SETOPACITY;
		b.opacityParam = op;
		this.lastOpacity = op;
		this.hasQuadBatchTop = false;
		this.hasPointBatchTop = false;
	};
	GLWrap_.prototype.setTexture = function (tex)
	{
		if (tex === this.lastTexture0)
			return;
;
		var b = this.pushBatch();
		b.type = BATCH_SETTEXTURE;
		b.texParam = tex;
		this.lastTexture0 = tex;
		this.hasQuadBatchTop = false;
		this.hasPointBatchTop = false;
	};
	GLWrap_.prototype.setBlend = function (s, d)
	{
		if (s === this.lastSrcBlend && d === this.lastDestBlend)
			return;
		var b = this.pushBatch();
		b.type = BATCH_SETBLEND;
		b.startIndex = s;		// recycle params to save memory
		b.indexCount = d;
		this.lastSrcBlend = s;
		this.lastDestBlend = d;
		this.hasQuadBatchTop = false;
		this.hasPointBatchTop = false;
	};
	GLWrap_.prototype.setAlphaBlend = function ()
	{
		this.setBlend(this.gl.ONE, this.gl.ONE_MINUS_SRC_ALPHA);
	};
	var LAST_VERTEX = MAX_VERTICES * 2 - 8;
	GLWrap_.prototype.quad = function(tlx, tly, trx, try_, brx, bry, blx, bly)
	{
		if (this.vertexPtr >= LAST_VERTEX)
			this.endBatch();
		var v = this.vertexPtr;			// vertex cursor
		var vd = this.vertexData;		// vertex data array
		var td = this.texcoordData;		// texture coord data array
		if (this.hasQuadBatchTop)
		{
			this.batch[this.batchPtr - 1].indexCount += 6;
		}
		else
		{
			var b = this.pushBatch();
			b.type = BATCH_QUAD;
			b.startIndex = (v / 4) * 3;
			b.indexCount = 6;
			this.hasQuadBatchTop = true;
			this.hasPointBatchTop = false;
		}
		vd[v] = tlx;
		td[v++] = 0;
		vd[v] = tly;
		td[v++] = 0;
		vd[v] = trx;
		td[v++] = 1;
		vd[v] = try_;
		td[v++] = 0;
		vd[v] = brx;
		td[v++] = 1;
		vd[v] = bry;
		td[v++] = 1;
		vd[v] = blx;
		td[v++] = 0;
		vd[v] = bly;
		td[v++] = 1;
		this.vertexPtr = v;
	};
	GLWrap_.prototype.quadTex = function(tlx, tly, trx, try_, brx, bry, blx, bly, rcTex)
	{
		if (this.vertexPtr >= LAST_VERTEX)
			this.endBatch();
		var v = this.vertexPtr;			// vertex cursor
		var vd = this.vertexData;		// vertex data array
		var td = this.texcoordData;		// texture coord data array
		if (this.hasQuadBatchTop)
		{
			this.batch[this.batchPtr - 1].indexCount += 6;
		}
		else
		{
			var b = this.pushBatch();
			b.type = BATCH_QUAD;
			b.startIndex = (v / 4) * 3;
			b.indexCount = 6;
			this.hasQuadBatchTop = true;
			this.hasPointBatchTop = false;
		}
		var rc_left = rcTex.left;
		var rc_top = rcTex.top;
		var rc_right = rcTex.right;
		var rc_bottom = rcTex.bottom;
		vd[v] = tlx;
		td[v++] = rc_left;
		vd[v] = tly;
		td[v++] = rc_top;
		vd[v] = trx;
		td[v++] = rc_right;
		vd[v] = try_;
		td[v++] = rc_top;
		vd[v] = brx;
		td[v++] = rc_right;
		vd[v] = bry;
		td[v++] = rc_bottom;
		vd[v] = blx;
		td[v++] = rc_left;
		vd[v] = bly;
		td[v++] = rc_bottom;
		this.vertexPtr = v;
	};
	GLWrap_.prototype.quadTexUV = function(tlx, tly, trx, try_, brx, bry, blx, bly, tlu, tlv, tru, trv, bru, brv, blu, blv)
	{
		if (this.vertexPtr >= LAST_VERTEX)
			this.endBatch();
		var v = this.vertexPtr;			// vertex cursor
		var vd = this.vertexData;		// vertex data array
		var td = this.texcoordData;		// texture coord data array
		if (this.hasQuadBatchTop)
		{
			this.batch[this.batchPtr - 1].indexCount += 6;
		}
		else
		{
			var b = this.pushBatch();
			b.type = BATCH_QUAD;
			b.startIndex = (v / 4) * 3;
			b.indexCount = 6;
			this.hasQuadBatchTop = true;
			this.hasPointBatchTop = false;
		}
		vd[v] = tlx;
		td[v++] = tlu;
		vd[v] = tly;
		td[v++] = tlv;
		vd[v] = trx;
		td[v++] = tru;
		vd[v] = try_;
		td[v++] = trv;
		vd[v] = brx;
		td[v++] = bru;
		vd[v] = bry;
		td[v++] = brv;
		vd[v] = blx;
		td[v++] = blu;
		vd[v] = bly;
		td[v++] = blv;
		this.vertexPtr = v;
	};
	var LAST_POINT = MAX_POINTS - 4;
	GLWrap_.prototype.point = function(x_, y_, size_, opacity_)
	{
		if (this.pointPtr >= LAST_POINT)
			this.endBatch();
		var p = this.pointPtr;			// point cursor
		var pd = this.pointData;		// point data array
		if (this.hasPointBatchTop)
		{
			this.batch[this.batchPtr - 1].indexCount++;
		}
		else
		{
			var b = this.pushBatch();
			b.type = BATCH_POINTS;
			b.startIndex = p;
			b.indexCount = 1;
			this.hasPointBatchTop = true;
			this.hasQuadBatchTop = false;
		}
		pd[p++] = x_;
		pd[p++] = y_;
		pd[p++] = size_;
		pd[p++] = opacity_;
		this.pointPtr = p;
	};
	GLWrap_.prototype.switchProgram = function (progIndex)
	{
		if (this.lastProgram === progIndex)
			return;			// no change
		var shaderProg = this.shaderPrograms[progIndex];
		if (!shaderProg)
		{
			if (this.lastProgram === 0)
				return;								// already on default shader
			progIndex = 0;
			shaderProg = this.shaderPrograms[0];
		}
		var b = this.pushBatch();
		b.type = BATCH_SETPROGRAM;
		b.startIndex = progIndex;
		this.lastProgram = progIndex;
		this.hasQuadBatchTop = false;
		this.hasPointBatchTop = false;
	};
	GLWrap_.prototype.programUsesDest = function (progIndex)
	{
		var s = this.shaderPrograms[progIndex];
		return !!(s.locDestStart || s.locDestEnd);
	};
	GLWrap_.prototype.programUsesCrossSampling = function (progIndex)
	{
		var s = this.shaderPrograms[progIndex];
		return !!(s.locDestStart || s.locDestEnd || s.crossSampling);
	};
	GLWrap_.prototype.programExtendsBox = function (progIndex)
	{
		var s = this.shaderPrograms[progIndex];
		return s.extendBoxHorizontal !== 0 || s.extendBoxVertical !== 0;
	};
	GLWrap_.prototype.getProgramBoxExtendHorizontal = function (progIndex)
	{
		return this.shaderPrograms[progIndex].extendBoxHorizontal;
	};
	GLWrap_.prototype.getProgramBoxExtendVertical = function (progIndex)
	{
		return this.shaderPrograms[progIndex].extendBoxVertical;
	};
	GLWrap_.prototype.getProgramParameterType = function (progIndex, paramIndex)
	{
		return this.shaderPrograms[progIndex].parameters[paramIndex][2];
	};
	GLWrap_.prototype.programIsAnimated = function (progIndex)
	{
		return this.shaderPrograms[progIndex].animated;
	};
	GLWrap_.prototype.setProgramParameters = function (backTex, pixelWidth, pixelHeight, destStartX, destStartY, destEndX, destEndY, layerScale, params)
	{
		var i, len, s = this.shaderPrograms[this.lastProgram];
		if (s.locPixelWidth || s.locPixelHeight || s.locSeconds || s.locSamplerBack ||
			s.locDestStart || s.locDestEnd || s.locLayerScale || params.length)
		{
			var b = this.pushBatch();
			b.type = BATCH_SETPROGRAMPARAMETERS;
			if (b.mat4param)
				mat4.set(this.matMV, b.mat4param);
			else
				b.mat4param = mat4.create();
			b.mat4param[0] = pixelWidth;
			b.mat4param[1] = pixelHeight;
			b.mat4param[2] = destStartX;
			b.mat4param[3] = destStartY;
			b.mat4param[4] = destEndX;
			b.mat4param[5] = destEndY;
			b.mat4param[6] = layerScale;
			if (s.locSamplerBack)
			{
;
				b.texParam = backTex;
			}
			else
				b.texParam = null;
			if (params.length)
			{
				b.shaderParams.length = params.length;
				for (i = 0, len = params.length; i < len; i++)
					b.shaderParams[i] = params[i];
			}
			this.hasQuadBatchTop = false;
			this.hasPointBatchTop = false;
		}
	};
	GLWrap_.prototype.clear = function (r, g, b_, a)
	{
		var b = this.pushBatch();
		b.type = BATCH_CLEAR;
		b.startIndex = 0;					// clear all mode
		if (!b.mat4param)
			b.mat4param = mat4.create();
		b.mat4param[0] = r;
		b.mat4param[1] = g;
		b.mat4param[2] = b_;
		b.mat4param[3] = a;
		this.hasQuadBatchTop = false;
		this.hasPointBatchTop = false;
	};
	GLWrap_.prototype.clearRect = function (x, y, w, h)
	{
		var b = this.pushBatch();
		b.type = BATCH_CLEAR;
		b.startIndex = 1;					// clear rect mode
		if (!b.mat4param)
			b.mat4param = mat4.create();
		b.mat4param[0] = x;
		b.mat4param[1] = y;
		b.mat4param[2] = w;
		b.mat4param[3] = h;
		this.hasQuadBatchTop = false;
		this.hasPointBatchTop = false;
	};
	GLWrap_.prototype.present = function ()
	{
		this.endBatch();
		this.gl.flush();
		/*
		if (debugBatch)
		{
;
			debugBatch = false;
		}
		*/
	};
	function nextHighestPowerOfTwo(x) {
		--x;
		for (var i = 1; i < 32; i <<= 1) {
			x = x | x >> i;
		}
		return x + 1;
	}
	var all_textures = [];
	var textures_by_src = {};
	var BF_RGBA8 = 0;
	var BF_RGB8 = 1;
	var BF_RGBA4 = 2;
	var BF_RGB5_A1 = 3;
	var BF_RGB565 = 4;
	GLWrap_.prototype.loadTexture = function (img, tiling, linearsampling, pixelformat, tiletype)
	{
		tiling = !!tiling;
		linearsampling = !!linearsampling;
		var tex_key = img.src + "," + tiling + "," + linearsampling + (tiling ? ("," + tiletype) : "");
		var webGL_texture = null;
		if (typeof img.src !== "undefined" && textures_by_src.hasOwnProperty(tex_key))
		{
			webGL_texture = textures_by_src[tex_key];
			webGL_texture.c2refcount++;
			return webGL_texture;
		}
		this.endBatch();
;
		var gl = this.gl;
		var isPOT = (cr.isPOT(img.width) && cr.isPOT(img.height));
		webGL_texture = gl.createTexture();
		gl.bindTexture(gl.TEXTURE_2D, webGL_texture);
		gl.pixelStorei(gl["UNPACK_PREMULTIPLY_ALPHA_WEBGL"], true);
		var internalformat = gl.RGBA;
		var format = gl.RGBA;
		var type = gl.UNSIGNED_BYTE;
		if (pixelformat && !this.isIE)
		{
			switch (pixelformat) {
			case BF_RGB8:
				internalformat = gl.RGB;
				format = gl.RGB;
				break;
			case BF_RGBA4:
				type = gl.UNSIGNED_SHORT_4_4_4_4;
				break;
			case BF_RGB5_A1:
				type = gl.UNSIGNED_SHORT_5_5_5_1;
				break;
			case BF_RGB565:
				internalformat = gl.RGB;
				format = gl.RGB;
				type = gl.UNSIGNED_SHORT_5_6_5;
				break;
			}
		}
		if (!isPOT && tiling)
		{
			var canvas = document.createElement("canvas");
			canvas.width = cr.nextHighestPowerOfTwo(img.width);
			canvas.height = cr.nextHighestPowerOfTwo(img.height);
			var ctx = canvas.getContext("2d");
			ctx.drawImage(img,
						  0, 0, img.width, img.height,
						  0, 0, canvas.width, canvas.height);
			gl.texImage2D(gl.TEXTURE_2D, 0, internalformat, format, type, canvas);
		}
		else
			gl.texImage2D(gl.TEXTURE_2D, 0, internalformat, format, type, img);
		if (tiling)
		{
			if (tiletype === "repeat-x")
			{
				gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_WRAP_S, gl.REPEAT);
				gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_WRAP_T, gl.CLAMP_TO_EDGE);
			}
			else if (tiletype === "repeat-y")
			{
				gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_WRAP_S, gl.CLAMP_TO_EDGE);
				gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_WRAP_T, gl.REPEAT);
			}
			else
			{
				gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_WRAP_S, gl.REPEAT);
				gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_WRAP_T, gl.REPEAT);
			}
		}
		else
		{
			gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_WRAP_S, gl.CLAMP_TO_EDGE);
			gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_WRAP_T, gl.CLAMP_TO_EDGE);
		}
		if (linearsampling)
		{
			gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_MAG_FILTER, gl.LINEAR);
			if (isPOT)
			{
				gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_MIN_FILTER, gl.LINEAR_MIPMAP_LINEAR);
				gl.generateMipmap(gl.TEXTURE_2D);
			}
			else
				gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_MIN_FILTER, gl.LINEAR);
		}
		else
		{
			gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_MAG_FILTER, gl.NEAREST);
			gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_MIN_FILTER, gl.NEAREST);
		}
		gl.bindTexture(gl.TEXTURE_2D, null);
		this.lastTexture0 = null;
		webGL_texture.c2width = img.width;
		webGL_texture.c2height = img.height;
		webGL_texture.c2refcount = 1;
		webGL_texture.c2texkey = tex_key;
		all_textures.push(webGL_texture);
		textures_by_src[tex_key] = webGL_texture;
		return webGL_texture;
	};
	GLWrap_.prototype.createEmptyTexture = function (w, h, linearsampling, _16bit, tiling)
	{
		this.endBatch();
		var gl = this.gl;
		if (this.isIE)
			_16bit = false;
		var webGL_texture = gl.createTexture();
		gl.bindTexture(gl.TEXTURE_2D, webGL_texture);
		gl.texImage2D(gl.TEXTURE_2D, 0, gl.RGBA, w, h, 0, gl.RGBA, _16bit ? gl.UNSIGNED_SHORT_4_4_4_4 : gl.UNSIGNED_BYTE, null);
		if (tiling)
		{
			gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_WRAP_S, gl.REPEAT);
			gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_WRAP_T, gl.REPEAT);
		}
		else
		{
			gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_WRAP_S, gl.CLAMP_TO_EDGE);
			gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_WRAP_T, gl.CLAMP_TO_EDGE);
		}
		gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_MAG_FILTER, linearsampling ? gl.LINEAR : gl.NEAREST);
		gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_MIN_FILTER, linearsampling ? gl.LINEAR : gl.NEAREST);
		gl.bindTexture(gl.TEXTURE_2D, null);
		this.lastTexture0 = null;
		webGL_texture.c2width = w;
		webGL_texture.c2height = h;
		all_textures.push(webGL_texture);
		return webGL_texture;
	};
	GLWrap_.prototype.videoToTexture = function (video_, texture_, _16bit)
	{
		this.endBatch();
		var gl = this.gl;
		if (this.isIE)
			_16bit = false;
		gl.bindTexture(gl.TEXTURE_2D, texture_);
		gl.texImage2D(gl.TEXTURE_2D, 0, gl.RGBA, gl.RGBA, _16bit ? gl.UNSIGNED_SHORT_4_4_4_4 : gl.UNSIGNED_BYTE, video_);
		gl.bindTexture(gl.TEXTURE_2D, null);
		this.lastTexture0 = null;
	};
	GLWrap_.prototype.deleteTexture = function (tex)
	{
		if (!tex)
			return;
		if (typeof tex.c2refcount !== "undefined" && tex.c2refcount > 1)
		{
			tex.c2refcount--;
			return;
		}
		this.endBatch();
		if (tex === this.lastTexture0)
		{
			this.gl.bindTexture(this.gl.TEXTURE_2D, null);
			this.lastTexture0 = null;
		}
		if (tex === this.lastTexture1)
		{
			this.gl.activeTexture(this.gl.TEXTURE1);
			this.gl.bindTexture(this.gl.TEXTURE_2D, null);
			this.gl.activeTexture(this.gl.TEXTURE0);
			this.lastTexture1 = null;
		}
		cr.arrayFindRemove(all_textures, tex);
		if (typeof tex.c2texkey !== "undefined")
			delete textures_by_src[tex.c2texkey];
		this.gl.deleteTexture(tex);
	};
	GLWrap_.prototype.estimateVRAM = function ()
	{
		var total = this.width * this.height * 4 * 2;
		var i, len, t;
		for (i = 0, len = all_textures.length; i < len; i++)
		{
			t = all_textures[i];
			total += (t.c2width * t.c2height * 4);
		}
		return total;
	};
	GLWrap_.prototype.textureCount = function ()
	{
		return all_textures.length;
	};
	GLWrap_.prototype.setRenderingToTexture = function (tex)
	{
		if (tex === this.renderToTex)
			return;
;
		var b = this.pushBatch();
		b.type = BATCH_RENDERTOTEXTURE;
		b.texParam = tex;
		this.renderToTex = tex;
		this.hasQuadBatchTop = false;
		this.hasPointBatchTop = false;
	};
	cr.GLWrap = GLWrap_;
}());
;
(function()
{
	function Runtime(canvas)
	{
		if (!canvas || (!canvas.getContext && !canvas["dc"]))
			return;
		if (canvas["c2runtime"])
			return;
		else
			canvas["c2runtime"] = this;
		var self = this;
		this.isPhoneGap = (typeof window["device"] !== "undefined" && (typeof window["device"]["cordova"] !== "undefined" || typeof window["device"]["phonegap"] !== "undefined"));
		this.isDirectCanvas = !!canvas["dc"];
		this.isAppMobi = (typeof window["AppMobi"] !== "undefined" || this.isDirectCanvas);
		this.isCocoonJs = !!window["c2cocoonjs"];
		if (this.isCocoonJs)
		{
			CocoonJS["App"]["onSuspended"].addEventListener(function() {
				self["setSuspended"](true);
			});
			CocoonJS["App"]["onActivated"].addEventListener(function () {
				self["setSuspended"](false);
			});
		}
		this.isDomFree = this.isDirectCanvas || this.isCocoonJs;
		this.isTizen = /tizen/i.test(navigator.userAgent);
		this.isAndroid = /android/i.test(navigator.userAgent) && !this.isTizen;		// tizen says "like Android"
		this.isIE = /msie/i.test(navigator.userAgent) || /trident/i.test(navigator.userAgent);
		this.isiPhone = /iphone/i.test(navigator.userAgent) || /ipod/i.test(navigator.userAgent);	// treat ipod as an iphone
		this.isiPad = /ipad/i.test(navigator.userAgent);
		this.isiOS = this.isiPhone || this.isiPad;
		this.isChrome = /chrome/i.test(navigator.userAgent) || /chromium/i.test(navigator.userAgent);
		this.isCrosswalk = /crosswalk/i.test(navigator.userAgent) || /xwalk/i.test(navigator.userAgent);
		this.isAmazonWebApp = /amazonwebappplatform/i.test(navigator.userAgent);
		this.isFirefox = /firefox/i.test(navigator.userAgent);
		this.isSafari = !this.isChrome && /safari/i.test(navigator.userAgent);		// Chrome includes Safari in UA
		this.isWindows = /windows/i.test(navigator.userAgent);
		this.isNodeWebkit = (typeof window["c2nodewebkit"] !== "undefined");
		this.isArcade = (typeof window["is_scirra_arcade"] !== "undefined");
		this.isWindows8App = !!(typeof window["c2isWindows8"] !== "undefined" && window["c2isWindows8"]);
		this.isWindowsPhone8 = !!(typeof window["c2isWindowsPhone8"] !== "undefined" && window["c2isWindowsPhone8"]);
		this.isBlackberry10 = !!(typeof window["c2isBlackberry10"] !== "undefined" && window["c2isBlackberry10"]);
		this.isAndroidStockBrowser = (this.isAndroid && !this.isChrome && !this.isFirefox && !this.isAmazonWebApp && !this.isDomFree);
		this.devicePixelRatio = 1;
		this.isMobile = (this.isPhoneGap || this.isAppMobi || this.isCocoonJs || this.isAndroid || this.isiOS || this.isWindowsPhone8 || this.isBlackberry10 || this.isTizen);
		if (!this.isMobile)
			this.isMobile = /(blackberry|bb10|playbook|palm|symbian|nokia|windows\s+ce|phone|mobile|tablet)/i.test(navigator.userAgent);
		if (typeof cr_is_preview !== "undefined" && !this.isNodeWebkit && (window.location.search === "?nw" || /nodewebkit/i.test(navigator.userAgent)))
		{
			this.isNodeWebkit = true;
		}
		this.isDebug = (typeof cr_is_preview !== "undefined" && window.location.search.indexOf("debug") > -1)
		this.canvas = canvas;
		this.canvasdiv = document.getElementById("c2canvasdiv");
		this.gl = null;
		this.glwrap = null;
		this.ctx = null;
		this.fullscreenOldMarginCss = "";
		this.firstInFullscreen = false;
		this.oldWidth = 0;		// for restoring non-fullscreen canvas after fullscreen
		this.oldHeight = 0;
		this.canvas.oncontextmenu = function (e) { if (e.preventDefault) e.preventDefault(); return false; };
		this.canvas.onselectstart = function (e) { if (e.preventDefault) e.preventDefault(); return false; };
		if (this.isDirectCanvas)
			window["c2runtime"] = this;
		if (this.isNodeWebkit)
		{
			window.ondragover = function(e) { e.preventDefault(); return false; };
			window.ondrop = function(e) { e.preventDefault(); return false; };
			require("nw.gui")["App"]["clearCache"]();
		}
		this.width = canvas.width;
		this.height = canvas.height;
		this.lastwidth = this.width;
		this.lastheight = this.height;
		this.cssWidth = this.width;
		this.cssHeight = this.height;
		this.redraw = true;
		this.isSuspended = false;
		if (!Date.now) {
		  Date.now = function now() {
			return +new Date();
		  };
		}
		this.plugins = [];
		this.types = {};
		this.types_by_index = [];
		this.behaviors = [];
		this.layouts = {};
		this.layouts_by_index = [];
		this.eventsheets = {};
		this.eventsheets_by_index = [];
		this.wait_for_textures = [];        // for blocking until textures loaded
		this.triggers_to_postinit = [];
		this.all_global_vars = [];
		this.all_local_vars = [];
		this.deathRow = new cr.ObjectSet();
		this.isInClearDeathRow = false;
		this.isInOnDestroy = 0;					// needs to support recursion so increments and decrements and is true if > 0
		this.isRunningEvents = false;
		this.createRow = [];
		this.isLoadingState = false;
		this.saveToSlot = "";
		this.loadFromSlot = "";
		this.loadFromJson = "";
		this.lastSaveJson = "";
		this.signalledContinuousPreview = false;
		this.suspendDrawing = false;		// for hiding display until continuous preview loads
		this.dt = 0;
        this.dt1 = 0;
		this.logictime = 0;			// used to calculate CPUUtilisation
		this.cpuutilisation = 0;
		this.zeroDtCount = 0;
        this.timescale = 1.0;
        this.kahanTime = new cr.KahanAdder();
		this.last_tick_time = 0;
		this.measuring_dt = true;
		this.fps = 0;
		this.last_fps_time = 0;
		this.tickcount = 0;
		this.execcount = 0;
		this.framecount = 0;        // for fps
		this.objectcount = 0;
		this.changelayout = null;
		this.destroycallbacks = [];
		this.event_stack = [];
		this.event_stack_index = -1;
		this.localvar_stack = [[]];
		this.localvar_stack_index = 0;
		this.trigger_depth = 0;		// recursion depth for triggers
		this.pushEventStack(null);
		this.loop_stack = [];
		this.loop_stack_index = -1;
		this.next_uid = 0;
		this.next_puid = 0;		// permanent unique ids
		this.layout_first_tick = true;
		this.family_count = 0;
		this.suspend_events = [];
		this.raf_id = 0;
		this.timeout_id = 0;
		this.isloading = true;
		this.loadingprogress = 0;
		this.isNodeFullscreen = false;
		this.stackLocalCount = 0;	// number of stack-based local vars for recursion
		this.halfFramerateMode = false;
		this.lastRafTime = 0;		// time of last requestAnimationFrame call
		this.ranLastRaf = false;	// false if last requestAnimationFrame was skipped for half framerate mode
		this.had_a_click = false;
        this.objects_to_tick = new cr.ObjectSet();
		this.objects_to_tick2 = new cr.ObjectSet();
		this.registered_collisions = [];
		this.temp_poly = new cr.CollisionPoly([]);
		this.temp_poly2 = new cr.CollisionPoly([]);
		this.allGroups = [];				// array of all event groups
        this.activeGroups = {};				// event group activation states
		this.cndsBySid = {};
		this.actsBySid = {};
		this.varsBySid = {};
		this.blocksBySid = {};
		this.running_layout = null;			// currently running layout
		this.layer_canvas = null;			// for layers "render-to-texture"
		this.layer_ctx = null;
		this.layer_tex = null;
		this.layout_tex = null;
		this.is_WebGL_context_lost = false;
		this.uses_background_blending = false;	// if any shader uses background blending, so entire layout renders to texture
		this.fx_tex = [null, null];
		this.fullscreen_scaling = 0;
		this.files_subfolder = "";			// path with project files
		this.objectsByUid = {};				// maps every in-use UID (as a string) to its instance
		this.loaderlogo = null;
		this.snapshotCanvas = null;
		this.snapshotData = "";
		this.load();
		this.isRetina = (!this.isDomFree && this.useHighDpi && !this.isAndroidStockBrowser);
		this.devicePixelRatio = (this.isRetina ? (window["devicePixelRatio"] || window["webkitDevicePixelRatio"] || window["mozDevicePixelRatio"] || window["msDevicePixelRatio"] || 1) : 1);
		this.ClearDeathRow();
		var attribs;
		var alpha_canvas = this.alphaBackground && !(this.isNodeWebkit || this.isWindows8App || this.isWindowsPhone8);
		if (typeof jQuery !== "undefined" && this.fullscreen_mode > 0)
			this["setSize"](jQuery(window).width(), jQuery(window).height());
		try {
			if (this.enableWebGL && (this.isCocoonJs || !this.isDomFree))
			{
				attribs = {
					"alpha": alpha_canvas,
					"depth": false,
					"antialias": false
				};
				var use_webgl = true;
				if (this.isChrome && this.isWindows)
				{
					var tempcanvas = document.createElement("canvas");
					var tempgl = (tempcanvas.getContext("webgl", attribs) || tempcanvas.getContext("experimental-webgl", attribs));
					if (tempgl.getSupportedExtensions().toString() === "OES_texture_float,OES_standard_derivatives,WEBKIT_WEBGL_lose_context")
					{
;
						use_webgl = false;
					}
				}
				if (use_webgl)
					this.gl = (canvas.getContext("webgl", attribs) || canvas.getContext("experimental-webgl", attribs));
			}
		}
		catch (e) {
		}
		if (this.gl)
		{
;
			if (!this.isDomFree)
			{
				this.overlay_canvas = document.createElement("canvas");
				jQuery(this.overlay_canvas).appendTo(this.canvas.parentNode);
				this.overlay_canvas.oncontextmenu = function (e) { return false; };
				this.overlay_canvas.onselectstart = function (e) { return false; };
				this.overlay_canvas.width = this.cssWidth;
				this.overlay_canvas.height = this.cssHeight;
				jQuery(this.overlay_canvas).css({"width": this.cssWidth + "px",
												"height": this.cssHeight + "px"});
				this.positionOverlayCanvas();
				this.overlay_ctx = this.overlay_canvas.getContext("2d");
			}
			this.glwrap = new cr.GLWrap(this.gl, this.isMobile);
			this.glwrap.setSize(canvas.width, canvas.height);
			this.ctx = null;
			this.canvas.addEventListener("webglcontextlost", function (ev) {
				ev.preventDefault();
				self.onContextLost();
				console.log("[Construct 2] WebGL context lost");
				window["cr_setSuspended"](true);		// stop rendering
			}, false);
			this.canvas.addEventListener("webglcontextrestored", function (ev) {
				self.glwrap.initState();
				self.glwrap.setSize(self.glwrap.width, self.glwrap.height, true);
				self.layer_tex = null;
				self.layout_tex = null;
				self.fx_tex[0] = null;
				self.fx_tex[1] = null;
				self.onContextRestored();
				self.redraw = true;
				console.log("[Construct 2] WebGL context restored");
				window["cr_setSuspended"](false);		// resume rendering
			}, false);
			var i, len, j, lenj, k, lenk, t, s, l, y;
			for (i = 0, len = this.types_by_index.length; i < len; i++)
			{
				t = this.types_by_index[i];
				for (j = 0, lenj = t.effect_types.length; j < lenj; j++)
				{
					s = t.effect_types[j];
					s.shaderindex = this.glwrap.getShaderIndex(s.id);
					this.uses_background_blending = this.uses_background_blending || this.glwrap.programUsesDest(s.shaderindex);
				}
			}
			for (i = 0, len = this.layouts_by_index.length; i < len; i++)
			{
				l = this.layouts_by_index[i];
				for (j = 0, lenj = l.effect_types.length; j < lenj; j++)
				{
					s = l.effect_types[j];
					s.shaderindex = this.glwrap.getShaderIndex(s.id);
				}
				for (j = 0, lenj = l.layers.length; j < lenj; j++)
				{
					y = l.layers[j];
					for (k = 0, lenk = y.effect_types.length; k < lenk; k++)
					{
						s = y.effect_types[k];
						s.shaderindex = this.glwrap.getShaderIndex(s.id);
						this.uses_background_blending = this.uses_background_blending || this.glwrap.programUsesDest(s.shaderindex);
					}
				}
			}
		}
		else
		{
			if (this.fullscreen_mode > 0 && this.isDirectCanvas)
			{
;
				this.canvas = null;
				document.oncontextmenu = function (e) { return false; };
				document.onselectstart = function (e) { return false; };
				this.ctx = AppMobi["canvas"]["getContext"]("2d");
				try {
					this.ctx["samplingMode"] = this.linearSampling ? "smooth" : "sharp";
					this.ctx["globalScale"] = 1;
					this.ctx["HTML5CompatibilityMode"] = true;
					this.ctx["imageSmoothingEnabled"] = this.linearSampling;
				} catch(e){}
				if (this.width !== 0 && this.height !== 0)
				{
					this.ctx.width = this.width;
					this.ctx.height = this.height;
				}
			}
			if (!this.ctx)
			{
;
				if (this.isCocoonJs)
				{
					attribs = {
						"antialias": !!this.linearSampling,
						"alpha": alpha_canvas
					};
					this.ctx = canvas.getContext("2d", attribs);
				}
				else
				{
					attribs = {
						"alpha": alpha_canvas
					};
					this.ctx = canvas.getContext("2d", attribs);
				}
				this.ctx["webkitImageSmoothingEnabled"] = this.linearSampling;
				this.ctx["mozImageSmoothingEnabled"] = this.linearSampling;
				this.ctx["msImageSmoothingEnabled"] = this.linearSampling;
				this.ctx["imageSmoothingEnabled"] = this.linearSampling;
			}
			this.overlay_canvas = null;
			this.overlay_ctx = null;
		}
		this.tickFunc = function () { self.tick(); };
		if (window != window.top && !this.isDomFree && !this.isWindows8App)
		{
			document.addEventListener("mousedown", function () {
				window.focus();
			}, true);
			document.addEventListener("touchstart", function () {
				window.focus();
			}, true);
		}
		if (typeof cr_is_preview !== "undefined")
		{
			if (this.isCocoonJs)
				console.log("[Construct 2] In preview-over-wifi via CocoonJS mode");
			if (window.location.search.indexOf("continuous") > -1)
			{
				cr.logexport("Reloading for continuous preview");
				this.loadFromSlot = "__c2_continuouspreview";
				this.suspendDrawing = true;
			}
			if (this.pauseOnBlur && !this.isMobile)
			{
				jQuery(window).focus(function ()
				{
					self["setSuspended"](false);
				});
				jQuery(window).blur(function ()
				{
					self["setSuspended"](true);
				});
			}
		}
		if (this.fullscreen_mode === 0 && this.isRetina && this.devicePixelRatio > 1)
		{
			this["setSize"](this.original_width, this.original_height, true);
		}
		this.tryLockOrientation();
		this.go();			// run loading screen
		this.extra = {};
		cr.seal(this);
	};
	var webkitRepaintFlag = false;
	Runtime.prototype["setSize"] = function (w, h, force)
	{
		var offx = 0, offy = 0;
		var neww = 0, newh = 0, intscale = 0;
		var mode = this.fullscreen_mode;
		var isfullscreen = (document["mozFullScreen"] || document["webkitIsFullScreen"] || !!document["msFullscreenElement"] || document["fullScreen"] || this.isNodeFullscreen);
		if (!isfullscreen && this.fullscreen_mode === 0 && !force)
			return;			// ignore size events when not fullscreen and not using a fullscreen-in-browser mode
		if (isfullscreen && this.fullscreen_scaling > 0)
			mode = this.fullscreen_scaling;
		if (mode >= 4)
		{
			var orig_aspect = this.original_width / this.original_height;
			var cur_aspect = w / h;
			if (cur_aspect > orig_aspect)
			{
				neww = h * orig_aspect;
				if (mode === 5)	// integer scaling
				{
					intscale = neww / this.original_width;
					if (intscale > 1)
						intscale = Math.floor(intscale);
					else if (intscale < 1)
						intscale = 1 / Math.ceil(1 / intscale);
					neww = this.original_width * intscale;
					newh = this.original_height * intscale;
					offx = (w - neww) / 2;
					offy = (h - newh) / 2;
					w = neww;
					h = newh;
				}
				else
				{
					offx = (w - neww) / 2;
					w = neww;
				}
			}
			else
			{
				newh = w / orig_aspect;
				if (mode === 5)	// integer scaling
				{
					intscale = newh / this.original_height;
					if (intscale > 1)
						intscale = Math.floor(intscale);
					else if (intscale < 1)
						intscale = 1 / Math.ceil(1 / intscale);
					neww = this.original_width * intscale;
					newh = this.original_height * intscale;
					offx = (w - neww) / 2;
					offy = (h - newh) / 2;
					w = neww;
					h = newh;
				}
				else
				{
					offy = (h - newh) / 2;
					h = newh;
				}
			}
			if (isfullscreen && !this.isNodeWebkit)
			{
				offx = 0;
				offy = 0;
			}
			offx = Math.floor(offx);
			offy = Math.floor(offy);
			w = Math.floor(w);
			h = Math.floor(h);
		}
		else if (this.isNodeWebkit && this.isNodeFullscreen && this.fullscreen_mode_set === 0)
		{
			offx = Math.floor((w - this.original_width) / 2);
			offy = Math.floor((h - this.original_height) / 2);
			w = this.original_width;
			h = this.original_height;
		}
		if (mode < 2)
			this.aspect_scale = this.devicePixelRatio;
		if (this.isRetina && this.isiPad && this.devicePixelRatio > 1)	// don't apply to iPad 1-2
		{
			if (w >= 1024)
				w = 1023;		// 2046 retina pixels
			if (h >= 1024)
				h = 1023;
		}
		var multiplier = this.devicePixelRatio;
		this.cssWidth = w;
		this.cssHeight = h;
		this.width = Math.round(w * multiplier);
		this.height = Math.round(h * multiplier);
		this.redraw = true;
		if (this.canvasdiv && !this.isDomFree)
		{
			jQuery(this.canvasdiv).css({"width": w + "px",
										"height": h + "px",
										"margin-left": offx,
										"margin-top": offy});
			if (typeof cr_is_preview !== "undefined")
			{
				jQuery("#borderwrap").css({"width": w + "px",
											"height": h + "px"});
			}
		}
		if (this.canvas)
		{
			this.canvas.width = Math.round(w * multiplier);
			this.canvas.height = Math.round(h * multiplier);
			if (this.isRetina)
			{
				jQuery(this.canvas).css({"width": w + "px",
										"height": h + "px"});
			}
		}
		if (this.overlay_canvas)
		{
			this.overlay_canvas.width = w;
			this.overlay_canvas.height = h;
			jQuery(this.overlay_canvas).css({"width": w + "px",
											"height": h + "px"});
		}
		if (this.glwrap)
			this.glwrap.setSize(Math.round(w * multiplier), Math.round(h * multiplier));
		if (this.isDirectCanvas && this.ctx)
		{
			this.ctx.width = w;
			this.ctx.height = h;
		}
		if (this.ctx)
		{
			this.ctx["webkitImageSmoothingEnabled"] = this.linearSampling;
			this.ctx["mozImageSmoothingEnabled"] = this.linearSampling;
			this.ctx["msImageSmoothingEnabled"] = this.linearSampling;
			this.ctx["imageSmoothingEnabled"] = this.linearSampling;
		}
		this.tryLockOrientation();
	};
	Runtime.prototype.tryLockOrientation = function ()
	{
		if (!this.autoLockOrientation || this.orientations === 0)
			return;
		var orientation = "portrait";
		if (this.orientations === 2)
			orientation = "landscape";
		if (screen["lockOrientation"])
			screen["lockOrientation"](orientation);
		else if (screen["webkitLockOrientation"])
			screen["webkitLockOrientation"](orientation);
		else if (screen["mozLockOrientation"])
			screen["mozLockOrientation"](orientation);
		else if (screen["msLockOrientation"])
			screen["msLockOrientation"](orientation);
	};
	Runtime.prototype.onContextLost = function ()
	{
		this.is_WebGL_context_lost = true;
		var i, len, t;
		for (i = 0, len = this.types_by_index.length; i < len; i++)
		{
			t = this.types_by_index[i];
			if (t.onLostWebGLContext)
				t.onLostWebGLContext();
		}
	};
	Runtime.prototype.onContextRestored = function ()
	{
		this.is_WebGL_context_lost = false;
		var i, len, t;
		for (i = 0, len = this.types_by_index.length; i < len; i++)
		{
			t = this.types_by_index[i];
			if (t.onRestoreWebGLContext)
				t.onRestoreWebGLContext();
		}
	};
	Runtime.prototype.positionOverlayCanvas = function()
	{
		if (this.isDomFree)
			return;
		var isfullscreen = (document["mozFullScreen"] || document["webkitIsFullScreen"] || document["fullScreen"] || !!document["msFullscreenElement"] || this.isNodeFullscreen);
		var overlay_position = isfullscreen ? jQuery(this.canvas).offset() : jQuery(this.canvas).position();
		overlay_position.position = "absolute";
		jQuery(this.overlay_canvas).css(overlay_position);
	};
	var caf = window["cancelAnimationFrame"] ||
	  window["mozCancelAnimationFrame"]    ||
	  window["webkitCancelAnimationFrame"] ||
	  window["msCancelAnimationFrame"]     ||
	  window["oCancelAnimationFrame"];
	Runtime.prototype["setSuspended"] = function (s)
	{
		var i, len;
		if (s && !this.isSuspended)
		{
			cr.logexport("[Construct 2] Suspending");
			this.isSuspended = true;			// next tick will be last
			if (this.raf_id !== 0 && caf)		// note: CocoonJS does not implement cancelAnimationFrame
				caf(this.raf_id);
			if (this.timeout_id !== 0)
				clearTimeout(this.timeout_id);
			for (i = 0, len = this.suspend_events.length; i < len; i++)
				this.suspend_events[i](true);
		}
		else if (!s && this.isSuspended)
		{
			cr.logexport("[Construct 2] Resuming");
			this.isSuspended = false;
			this.last_tick_time = cr.performance_now();	// ensure first tick is a zero-dt one
			this.last_fps_time = cr.performance_now();	// reset FPS counter
			this.framecount = 0;
			this.logictime = 0;
			for (i = 0, len = this.suspend_events.length; i < len; i++)
				this.suspend_events[i](false);
			this.tick();						// kick off runtime again
		}
	};
	Runtime.prototype.addSuspendCallback = function (f)
	{
		this.suspend_events.push(f);
	};
	Runtime.prototype.load = function ()
	{
;
		var pm = cr.getProjectModel();
		this.name = pm[0];
		this.first_layout = pm[1];
		this.fullscreen_mode = pm[11];	// 0 = off, 1 = crop, 2 = scale inner, 3 = scale outer, 4 = letterbox scale, 5 = integer letterbox scale
		this.fullscreen_mode_set = pm[11];
		if (this.isDomFree && (pm[11] >= 4 || pm[11] === 0))
		{
			cr.logexport("[Construct 2] Letterbox scale fullscreen modes are not supported on this platform - falling back to 'Scale outer'");
			this.fullscreen_mode = 3;
			this.fullscreen_mode_set = 3;
		}
		this.uses_loader_layout = pm[17];
		this.loaderstyle = pm[18];
		if (this.loaderstyle === 0)
		{
			this.loaderlogo = new Image();
			this.loaderlogo.src = "loading-logo.png";
		}
		this.next_uid = pm[20];
		this.system = new cr.system_object(this);
		var i, len, j, lenj, k, lenk, idstr, m, b, t, f;
		var plugin, plugin_ctor;
		for (i = 0, len = pm[2].length; i < len; i++)
		{
			m = pm[2][i];
;
			cr.add_common_aces(m);
			plugin = new m[0](this);
			plugin.singleglobal = m[1];
			plugin.is_world = m[2];
			plugin.must_predraw = m[9];
			if (plugin.onCreate)
				plugin.onCreate();  // opportunity to override default ACEs
			cr.seal(plugin);
			this.plugins.push(plugin);
		}
		pm = cr.getProjectModel();
		for (i = 0, len = pm[3].length; i < len; i++)
		{
			m = pm[3][i];
			plugin_ctor = m[1];
;
			plugin = null;
			for (j = 0, lenj = this.plugins.length; j < lenj; j++)
			{
				if (this.plugins[j] instanceof plugin_ctor)
				{
					plugin = this.plugins[j];
					break;
				}
			}
;
;
			var type_inst = new plugin.Type(plugin);
;
			type_inst.name = m[0];
			type_inst.is_family = m[2];
			type_inst.instvar_sids = m[3].slice(0);
			type_inst.vars_count = m[3].length;
			type_inst.behs_count = m[4];
			type_inst.fx_count = m[5];
			type_inst.sid = m[11];
			if (type_inst.is_family)
			{
				type_inst.members = [];				// types in this family
				type_inst.family_index = this.family_count++;
				type_inst.families = null;
			}
			else
			{
				type_inst.members = null;
				type_inst.family_index = -1;
				type_inst.families = [];			// families this type belongs to
			}
			type_inst.family_var_map = null;
			type_inst.family_beh_map = null;
			type_inst.family_fx_map = null;
			type_inst.is_contained = false;
			type_inst.container = null;
			if (m[6])
			{
				type_inst.texture_file = m[6][0];
				type_inst.texture_filesize = m[6][1];
				type_inst.texture_pixelformat = m[6][2];
			}
			else
			{
				type_inst.texture_file = null;
				type_inst.texture_filesize = 0;
				type_inst.texture_pixelformat = 0;		// rgba8
			}
			if (m[7])
			{
				type_inst.animations = m[7];
			}
			else
			{
				type_inst.animations = null;
			}
			type_inst.index = i;                                // save index in to types array in type
			type_inst.instances = [];                           // all instances of this type
			type_inst.deadCache = [];							// destroyed instances to recycle next create
			type_inst.solstack = [new cr.selection(type_inst)]; // initialise SOL stack with one empty SOL
			type_inst.cur_sol = 0;
			type_inst.default_instance = null;
			type_inst.stale_iids = true;
			type_inst.updateIIDs = cr.type_updateIIDs;
			type_inst.getFirstPicked = cr.type_getFirstPicked;
			type_inst.getPairedInstance = cr.type_getPairedInstance;
			type_inst.getCurrentSol = cr.type_getCurrentSol;
			type_inst.pushCleanSol = cr.type_pushCleanSol;
			type_inst.pushCopySol = cr.type_pushCopySol;
			type_inst.popSol = cr.type_popSol;
			type_inst.getBehaviorByName = cr.type_getBehaviorByName;
			type_inst.getBehaviorIndexByName = cr.type_getBehaviorIndexByName;
			type_inst.getEffectIndexByName = cr.type_getEffectIndexByName;
			type_inst.applySolToContainer = cr.type_applySolToContainer;
			type_inst.getInstanceByIID = cr.type_getInstanceByIID;
			type_inst.extra = {};
			type_inst.toString = cr.type_toString;
			type_inst.behaviors = [];
			for (j = 0, lenj = m[8].length; j < lenj; j++)
			{
				b = m[8][j];
				var behavior_ctor = b[1];
				var behavior_plugin = null;
				for (k = 0, lenk = this.behaviors.length; k < lenk; k++)
				{
					if (this.behaviors[k] instanceof behavior_ctor)
					{
						behavior_plugin = this.behaviors[k];
						break;
					}
				}
				if (!behavior_plugin)
				{
					behavior_plugin = new behavior_ctor(this);
					behavior_plugin.my_instances = new cr.ObjectSet(); 	// instances of this behavior
					if (behavior_plugin.onCreate)
						behavior_plugin.onCreate();
					cr.seal(behavior_plugin);
					this.behaviors.push(behavior_plugin);
				}
				var behavior_type = new behavior_plugin.Type(behavior_plugin, type_inst);
				behavior_type.name = b[0];
				behavior_type.sid = b[2];
				behavior_type.onCreate();
				cr.seal(behavior_type);
				type_inst.behaviors.push(behavior_type);
			}
			type_inst.global = m[9];
			type_inst.isOnLoaderLayout = m[10];
			type_inst.effect_types = [];
			for (j = 0, lenj = m[12].length; j < lenj; j++)
			{
				type_inst.effect_types.push({
					id: m[12][j][0],
					name: m[12][j][1],
					shaderindex: -1,
					active: true,
					index: j
				});
			}
			type_inst.tile_poly_data = m[13];
			if (!this.uses_loader_layout || type_inst.is_family || type_inst.isOnLoaderLayout || !plugin.is_world)
			{
				type_inst.onCreate();
				cr.seal(type_inst);
			}
			if (type_inst.name)
				this.types[type_inst.name] = type_inst;
			this.types_by_index.push(type_inst);
			if (plugin.singleglobal)
			{
				var instance = new plugin.Instance(type_inst);
				instance.uid = this.next_uid++;
				instance.puid = this.next_puid++;
				instance.iid = 0;
				instance.get_iid = cr.inst_get_iid;
				instance.toString = cr.inst_toString;
				instance.properties = m[14];
				instance.onCreate();
				cr.seal(instance);
				type_inst.instances.push(instance);
				this.objectsByUid[instance.uid.toString()] = instance;
			}
		}
		for (i = 0, len = pm[4].length; i < len; i++)
		{
			var familydata = pm[4][i];
			var familytype = this.types_by_index[familydata[0]];
			var familymember;
			for (j = 1, lenj = familydata.length; j < lenj; j++)
			{
				familymember = this.types_by_index[familydata[j]];
				familymember.families.push(familytype);
				familytype.members.push(familymember);
			}
		}
		for (i = 0, len = pm[22].length; i < len; i++)
		{
			var containerdata = pm[22][i];
			var containertypes = [];
			for (j = 0, lenj = containerdata.length; j < lenj; j++)
				containertypes.push(this.types_by_index[containerdata[j]]);
			for (j = 0, lenj = containertypes.length; j < lenj; j++)
			{
				containertypes[j].is_contained = true;
				containertypes[j].container = containertypes;
			}
		}
		if (this.family_count > 0)
		{
			for (i = 0, len = this.types_by_index.length; i < len; i++)
			{
				t = this.types_by_index[i];
				if (t.is_family || !t.families.length)
					continue;
				t.family_var_map = new Array(this.family_count);
				t.family_beh_map = new Array(this.family_count);
				t.family_fx_map = new Array(this.family_count);
				var all_fx = [];
				var varsum = 0;
				var behsum = 0;
				var fxsum = 0;
				for (j = 0, lenj = t.families.length; j < lenj; j++)
				{
					f = t.families[j];
					t.family_var_map[f.family_index] = varsum;
					varsum += f.vars_count;
					t.family_beh_map[f.family_index] = behsum;
					behsum += f.behs_count;
					t.family_fx_map[f.family_index] = fxsum;
					fxsum += f.fx_count;
					for (k = 0, lenk = f.effect_types.length; k < lenk; k++)
						all_fx.push(cr.shallowCopy({}, f.effect_types[k]));
				}
				t.effect_types = all_fx.concat(t.effect_types);
				for (j = 0, lenj = t.effect_types.length; j < lenj; j++)
					t.effect_types[j].index = j;
			}
		}
		for (i = 0, len = pm[5].length; i < len; i++)
		{
			m = pm[5][i];
			var layout = new cr.layout(this, m);
			cr.seal(layout);
			this.layouts[layout.name] = layout;
			this.layouts_by_index.push(layout);
		}
		for (i = 0, len = pm[6].length; i < len; i++)
		{
			m = pm[6][i];
			var sheet = new cr.eventsheet(this, m);
			cr.seal(sheet);
			this.eventsheets[sheet.name] = sheet;
			this.eventsheets_by_index.push(sheet);
		}
		for (i = 0, len = this.eventsheets_by_index.length; i < len; i++)
			this.eventsheets_by_index[i].postInit();
		for (i = 0, len = this.triggers_to_postinit.length; i < len; i++)
			this.triggers_to_postinit[i].postInit();
		this.triggers_to_postinit.length = 0;
		this.files_subfolder = pm[7];
		this.pixel_rounding = pm[8];
		this.original_width = pm[9];
		this.original_height = pm[10];
		this.aspect_scale = 1.0;
		this.enableWebGL = pm[12];
		this.linearSampling = pm[13];
		this.alphaBackground = pm[14];
		this.versionstr = pm[15];
		this.useHighDpi = pm[16];
		this.orientations = pm[19];		// 0 = any, 1 = portrait, 2 = landscape
		this.autoLockOrientation = (this.orientations > 0);
		this.pauseOnBlur = pm[21];
		this.start_time = Date.now();
	};
	Runtime.prototype.findWaitingTexture = function (src_)
	{
		var i, len;
		for (i = 0, len = this.wait_for_textures.length; i < len; i++)
		{
			if (this.wait_for_textures[i].cr_src === src_)
				return this.wait_for_textures[i];
		}
		return null;
	};
	Runtime.prototype.areAllTexturesLoaded = function ()
	{
		var totalsize = 0;
		var completedsize = 0;
		var ret = true;
		var i, len;
		for (i = 0, len = this.wait_for_textures.length; i < len; i++)
		{
			var filesize = this.wait_for_textures[i].cr_filesize;
			if (!filesize || filesize <= 0)
				filesize = 50000;
			totalsize += filesize;
			if (this.wait_for_textures[i].complete || this.wait_for_textures[i]["loaded"])
				completedsize += filesize;
			else
				ret = false;    // not all textures loaded
		}
		if (totalsize == 0)
			this.progress = 0;
		else
			this.progress = (completedsize / totalsize);
		return ret;
	};
	Runtime.prototype.go = function ()
	{
		if (!this.ctx && !this.glwrap)
			return;
		var ctx = this.ctx || this.overlay_ctx;
		if (this.overlay_canvas)
			this.positionOverlayCanvas();
		this.progress = 0;
		this.last_progress = -1;
		if (this.areAllTexturesLoaded())
			this.go_textures_done();
		else
		{
			var ms_elapsed = Date.now() - this.start_time;
			if (ctx)
			{
				var overlay_width = this.width;
				var overlay_height = this.height;
				var multiplier = this.devicePixelRatio;
				if (this.overlay_canvas)
				{
					overlay_width = this.cssWidth;
					overlay_height = this.cssHeight;
					multiplier = 1;
				}
				if (this.loaderstyle !== 3 && ms_elapsed >= 500 && this.last_progress != this.progress)
				{
					ctx.clearRect(0, 0, overlay_width, overlay_height);
					var mx = overlay_width / 2;
					var my = overlay_height / 2;
					var haslogo = (this.loaderstyle === 0 && this.loaderlogo.complete);
					var hlw = 40 * multiplier;
					var hlh = 0;
					var logowidth = 80 * multiplier;
					var logoheight;
					if (haslogo)
					{
						logowidth = this.loaderlogo.width * multiplier;
						logoheight = this.loaderlogo.height * multiplier;
						hlw = logowidth / 2;
						hlh = logoheight / 2;
						ctx.drawImage(this.loaderlogo, cr.floor(mx - hlw), cr.floor(my - hlh), logowidth, logoheight);
					}
					if (this.loaderstyle <= 1)
					{
						my += hlh + (haslogo ? 12 * multiplier : 0);
						mx -= hlw;
						mx = cr.floor(mx) + 0.5;
						my = cr.floor(my) + 0.5;
						ctx.fillStyle = "DodgerBlue";
						ctx.fillRect(mx, my, Math.floor(logowidth * this.progress), 6 * multiplier);
						ctx.strokeStyle = "black";
						ctx.strokeRect(mx, my, logowidth, 6 * multiplier);
						ctx.strokeStyle = "white";
						ctx.strokeRect(mx - 1 * multiplier, my - 1 * multiplier, logowidth + 2 * multiplier, 8 * multiplier);
					}
					else if (this.loaderstyle === 2)
					{
						ctx.font = "12pt Arial";
						ctx.fillStyle = "#999";
						ctx.textBaseLine = "middle";
						var percent_text = Math.round(this.progress * 100) + "%";
						var text_dim = ctx.measureText ? ctx.measureText(percent_text) : null;
						var text_width = text_dim ? text_dim.width : 0;
						ctx.fillText(percent_text, mx - (text_width / 2), my);
					}
				}
				this.last_progress = this.progress;
			}
			setTimeout((function (self) { return function () { self.go(); }; })(this), 100);
		}
	};
	Runtime.prototype.go_textures_done = function ()
	{
		if (this.overlay_canvas)
		{
			this.canvas.parentNode.removeChild(this.overlay_canvas);
			this.overlay_ctx = null;
			this.overlay_canvas = null;
		}
		this.start_time = Date.now();
		this.last_fps_time = cr.performance_now();       // for counting framerate
		var i, len, t;
		if (this.uses_loader_layout)
		{
			for (i = 0, len = this.types_by_index.length; i < len; i++)
			{
				t = this.types_by_index[i];
				if (!t.is_family && !t.isOnLoaderLayout && t.plugin.is_world)
				{
					t.onCreate();
					cr.seal(t);
				}
			}
		}
		else
			this.isloading = false;
		for (i = 0, len = this.layouts_by_index.length; i < len; i++)
		{
			this.layouts_by_index[i].createGlobalNonWorlds();
		}
		if (this.fullscreen_mode >= 2)
		{
			var orig_aspect = this.original_width / this.original_height;
			var cur_aspect = this.width / this.height;
			if ((this.fullscreen_mode !== 2 && cur_aspect > orig_aspect) || (this.fullscreen_mode === 2 && cur_aspect < orig_aspect))
				this.aspect_scale = this.height / this.original_height;
			else
				this.aspect_scale = this.width / this.original_width;
		}
		if (this.first_layout)
			this.layouts[this.first_layout].startRunning();
		else
			this.layouts_by_index[0].startRunning();
;
		if (!this.uses_loader_layout)
		{
			this.loadingprogress = 1;
			this.trigger(cr.system_object.prototype.cnds.OnLoadFinished, null);
		}
		this.tick();
		if (this.isDirectCanvas)
			AppMobi["webview"]["execute"]("onGameReady();");
	};
	var raf = window["requestAnimationFrame"] ||
	  window["mozRequestAnimationFrame"]    ||
	  window["webkitRequestAnimationFrame"] ||
	  window["msRequestAnimationFrame"]     ||
	  window["oRequestAnimationFrame"];
	Runtime.prototype.tick = function ()
	{
		if (!this.running_layout)
			return;
		var logic_start = cr.performance_now();
		if (this.halfFramerateMode && this.ranLastRaf)
		{
			if (logic_start - this.lastRafTime < 29)
			{
				this.ranLastRaf = false;
				this.lastRafTime = logic_start;
				if (raf)
					this.raf_id = raf(this.tickFunc, this.canvas);
				else	// no idea if this works without raf/hi res timers but let's hope for the best
					this.timeout_id = setTimeout(this.tickFunc, this.isMobile ? 1 : 16);
				return;		// skipped this frame
			}
		}
		this.ranLastRaf = true;
		this.lastRafTime = logic_start;
		if (this.isTizen || (!this.isDomFree && window != window.top))
		{
			var mode = this.fullscreen_mode;
			var isfullscreen = (document["mozFullScreen"] || document["webkitIsFullScreen"] || document["fullScreen"] || !!document["msFullscreenElement"] || this.isNodeFullscreen);
			if (isfullscreen && this.fullscreen_scaling > 0)
				mode = this.fullscreen_scaling;
			if (mode > 0)
			{
				var curwidth = window.innerWidth;
				var curheight = window.innerHeight;
				if (this.lastwidth !== curwidth || this.lastheight !== curheight)
				{
					this.lastwidth = curwidth;
					this.lastheight = curheight;
					this["setSize"](curwidth, curheight);
				}
			}
		}
		if (!this.isDomFree)
		{
			var isfullscreen = (document["mozFullScreen"] || document["webkitIsFullScreen"] || !!document["msFullscreenElement"] || document["fullScreen"]);
			if (isfullscreen)
			{
				if (!this.firstInFullscreen)
				{
					this.fullscreenOldMarginCss = jQuery(this.canvas).css("margin") || "0";
					this.firstInFullscreen = true;
				}
				if (!this.isChrome && !this.isNodeWebkit)
				{
					jQuery(this.canvas).css({
						"margin-left": "" + Math.floor((screen.width - (this.width / this.devicePixelRatio)) / 2) + "px",
						"margin-top": "" + Math.floor((screen.height - (this.height / this.devicePixelRatio)) / 2) + "px"
					});
				}
			}
			else
			{
				if (this.firstInFullscreen)
				{
					if (!this.isChrome && !this.isNodeWebkit)
					{
						jQuery(this.canvas).css("margin", this.fullscreenOldMarginCss);
					}
					this.fullscreenOldMarginCss = "";
					this.firstInFullscreen = false;
					if (this.fullscreen_mode === 0)
					{
						this["setSize"](Math.round(this.oldWidth / this.devicePixelRatio), Math.round(this.oldHeight / this.devicePixelRatio), true);
					}
				}
				else
				{
					this.oldWidth = this.width;
					this.oldHeight = this.height;
				}
			}
		}
		if (this.isloading)
		{
			var done = this.areAllTexturesLoaded();		// updates this.progress
			this.loadingprogress = this.progress;
			if (done)
			{
				this.isloading = false;
				this.progress = 1;
				this.trigger(cr.system_object.prototype.cnds.OnLoadFinished, null);
			}
		}
		this.logic();
		if ((this.redraw || this.isCocoonJs) && !this.is_WebGL_context_lost && !this.suspendDrawing)
		{
			this.redraw = false;
			if (this.glwrap)
				this.drawGL();
			else
				this.draw();
			if (this.snapshotCanvas)
			{
				if (this.canvas && this.canvas.toDataURL)
				{
					this.snapshotData = this.canvas.toDataURL(this.snapshotCanvas[0], this.snapshotCanvas[1]);
					this.trigger(cr.system_object.prototype.cnds.OnCanvasSnapshot, null);
				}
				this.snapshotCanvas = null;
			}
		}
		if (!this.hit_breakpoint)
		{
			this.tickcount++;
			this.execcount++;
			this.framecount++;
		}
		this.logictime += cr.performance_now() - logic_start;
		if (this.isSuspended)
			return;
		if (raf)
			this.raf_id = raf(this.tickFunc, this.canvas);
		else
		{
			this.timeout_id = setTimeout(this.tickFunc, this.isMobile ? 1 : 16);
		}
	};
	Runtime.prototype.logic = function ()
	{
		var i, leni, j, lenj, k, lenk, type, inst, binst;
		var cur_time = cr.performance_now();
		if (cur_time - this.last_fps_time >= 1000)  // every 1 second
		{
			this.last_fps_time += 1000;
			this.fps = this.framecount;
			this.framecount = 0;
			this.cpuutilisation = this.logictime;
			this.logictime = 0;
		}
		if (this.measuring_dt)
		{
			if (this.last_tick_time !== 0)
			{
				var ms_diff = cur_time - this.last_tick_time;
				if (ms_diff === 0 && !this.isDebug)
				{
					this.zeroDtCount++;
					if (this.zeroDtCout >= 10)
						this.measuring_dt = false;
					this.dt1 = 1.0 / 60.0;            // 60fps assumed (0.01666...)
				}
				else
				{
					this.dt1 = ms_diff / 1000.0; // dt measured in seconds
					if (this.dt1 > 0.5)
						this.dt1 = 0;
					else if (this.dt1 > 0.1)
						this.dt1 = 0.1;
				}
			}
			this.last_tick_time = cur_time;
		}
        this.dt = this.dt1 * this.timescale;
        this.kahanTime.add(this.dt);
		var isfullscreen = (document["mozFullScreen"] || document["webkitIsFullScreen"] || document["fullScreen"] || !!document["msFullscreenElement"] || this.isNodeFullscreen);
		if (this.fullscreen_mode >= 2 /* scale */ || (isfullscreen && this.fullscreen_scaling > 0))
		{
			var orig_aspect = this.original_width / this.original_height;
			var cur_aspect = this.width / this.height;
			var mode = this.fullscreen_mode;
			if (isfullscreen && this.fullscreen_scaling > 0)
				mode = this.fullscreen_scaling;
			if ((mode !== 2 && cur_aspect > orig_aspect) || (mode === 2 && cur_aspect < orig_aspect))
			{
				this.aspect_scale = this.height / this.original_height;
			}
			else
			{
				this.aspect_scale = this.width / this.original_width;
			}
			if (this.running_layout)
			{
				this.running_layout.scrollToX(this.running_layout.scrollX);
				this.running_layout.scrollToY(this.running_layout.scrollY);
			}
		}
		else
			this.aspect_scale = (this.isRetina ? this.devicePixelRatio : 1);
		this.ClearDeathRow();
		this.isInOnDestroy++;
		this.system.runWaits();		// prevent instance list changing
		this.isInOnDestroy--;
		this.ClearDeathRow();		// allow instance list changing
		this.isInOnDestroy++;
		for (i = 0, leni = this.types_by_index.length; i < leni; i++)
		{
			type = this.types_by_index[i];
			if (type.is_family || (!type.behaviors.length && !type.families.length))
				continue;
			for (j = 0, lenj = type.instances.length; j < lenj; j++)
			{
				inst = type.instances[j];
				for (k = 0, lenk = inst.behavior_insts.length; k < lenk; k++)
				{
					inst.behavior_insts[k].tick();
				}
			}
		}
		for (i = 0, leni = this.types_by_index.length; i < leni; i++)
		{
			type = this.types_by_index[i];
			if (type.is_family || (!type.behaviors.length && !type.families.length))
				continue;	// type doesn't have any behaviors
			for (j = 0, lenj = type.instances.length; j < lenj; j++)
			{
				inst = type.instances[j];
				for (k = 0, lenk = inst.behavior_insts.length; k < lenk; k++)
				{
					binst = inst.behavior_insts[k];
					if (binst.posttick)
						binst.posttick();
				}
			}
		}
        var tickarr = this.objects_to_tick.valuesRef();
        for (i = 0, leni = tickarr.length; i < leni; i++)
            tickarr[i].tick();
		this.isInOnDestroy--;		// end preventing instance lists from being changed
		this.handleSaveLoad();		// save/load now if queued
		i = 0;
		while (this.changelayout && i++ < 10)
		{
			this.doChangeLayout(this.changelayout);
		}
        for (i = 0, leni = this.eventsheets_by_index.length; i < leni; i++)
            this.eventsheets_by_index[i].hasRun = false;
		if (this.running_layout.event_sheet)
			this.running_layout.event_sheet.run();
		this.registered_collisions.length = 0;
		this.layout_first_tick = false;
		this.isInOnDestroy++;		// prevent instance lists from being changed
		for (i = 0, leni = this.types_by_index.length; i < leni; i++)
		{
			type = this.types_by_index[i];
			if (type.is_family || (!type.behaviors.length && !type.families.length))
				continue;	// type doesn't have any behaviors
			for (j = 0, lenj = type.instances.length; j < lenj; j++)
			{
				var inst = type.instances[j];
				for (k = 0, lenk = inst.behavior_insts.length; k < lenk; k++)
				{
					binst = inst.behavior_insts[k];
					if (binst.tick2)
						binst.tick2();
				}
			}
		}
        tickarr = this.objects_to_tick2.valuesRef();
        for (i = 0, leni = tickarr.length; i < leni; i++)
            tickarr[i].tick2();
		this.isInOnDestroy--;		// end preventing instance lists from being changed
	};
	Runtime.prototype.doChangeLayout = function (changeToLayout)
	{
;
		var prev_layout = this.running_layout;
		this.running_layout.stopRunning();
		var i, len, j, lenj, k, lenk, type, inst, binst;
		if (this.glwrap)
		{
			for (i = 0, len = this.types_by_index.length; i < len; i++)
			{
				type = this.types_by_index[i];
				if (type.is_family)
					continue;
				if (type.unloadTextures && (!type.global || type.instances.length === 0) && changeToLayout.initial_types.indexOf(type) === -1)
				{
					type.unloadTextures();
				}
			}
		}
		if (prev_layout == changeToLayout)
			this.system.waits.length = 0;
		changeToLayout.startRunning();
		for (i = 0, len = this.types_by_index.length; i < len; i++)
		{
			type = this.types_by_index[i];
			if (!type.global && !type.plugin.singleglobal)
				continue;
			for (j = 0, lenj = type.instances.length; j < lenj; j++)
			{
				inst = type.instances[j];
				if (inst.onLayoutChange)
					inst.onLayoutChange();
				if (inst.behavior_insts)
				{
					for (k = 0, lenk = inst.behavior_insts.length; k < lenk; k++)
					{
						binst = inst.behavior_insts[k];
						if (binst.onLayoutChange)
							binst.onLayoutChange();
					}
				}
			}
		}
		this.redraw = true;
		this.layout_first_tick = true;
		this.ClearDeathRow();
	};
    Runtime.prototype.tickMe = function (inst)
    {
        this.objects_to_tick.add(inst);
    };
	Runtime.prototype.untickMe = function (inst)
	{
		this.objects_to_tick.remove(inst);
	};
	Runtime.prototype.tick2Me = function (inst)
    {
        this.objects_to_tick2.add(inst);
    };
	Runtime.prototype.untick2Me = function (inst)
	{
		this.objects_to_tick2.remove(inst);
	};
    Runtime.prototype.getDt = function (inst)
    {
        if (!inst || inst.my_timescale === -1.0)
            return this.dt;
        return this.dt1 * inst.my_timescale;
    };
	Runtime.prototype.draw = function ()
	{
		this.running_layout.draw(this.ctx);
		if (this.isDirectCanvas)
			this.ctx["present"]();
	};
	Runtime.prototype.drawGL = function ()
	{
		this.running_layout.drawGL(this.glwrap);
		this.glwrap.present();
	};
	Runtime.prototype.addDestroyCallback = function (f)
	{
		if (f)
			this.destroycallbacks.push(f);
	};
	Runtime.prototype.removeDestroyCallback = function (f)
	{
		cr.arrayFindRemove(this.destroycallbacks, f);
	};
	Runtime.prototype.getObjectByUID = function (uid_)
	{
;
		return this.objectsByUid[uid_.toString()];
	};
	Runtime.prototype.DestroyInstance = function (inst)
	{
		var i, len;
		if (!this.deathRow.contains(inst))
		{
			this.deathRow.add(inst);
			if (inst.is_contained)
			{
				for (i = 0, len = inst.siblings.length; i < len; i++)
				{
					this.DestroyInstance(inst.siblings[i]);
				}
			}
			if (this.isInClearDeathRow)
				this.deathRow.values_cache.push(inst);
			this.isInOnDestroy++;		// support recursion
			this.trigger(Object.getPrototypeOf(inst.type.plugin).cnds.OnDestroyed, inst);
			this.isInOnDestroy--;
		}
	};
	Runtime.prototype.ClearDeathRow = function ()
	{
		var inst, index, type, instances, binst;
		var i, j, k, leni, lenj, lenk;
		var w, f;
		this.isInClearDeathRow = true;
		for (i = 0, leni = this.createRow.length; i < leni; i++)
		{
			inst = this.createRow[i];
			type = inst.type;
			type.instances.push(inst);
			for (j = 0, lenj = type.families.length; j < lenj; j++)
			{
				type.families[j].instances.push(inst);
				type.families[j].stale_iids = true;
			}
		}
		this.createRow.length = 0;
		var arr = this.deathRow.valuesRef();	// get array of items from set
		for (i = 0; i < arr.length; i++)		// check array length every time in case it changes
		{
			inst = arr[i];
			type = inst.type;
			instances = type.instances;
			for (j = 0, lenj = this.destroycallbacks.length; j < lenj; j++)
				this.destroycallbacks[j](inst);
			cr.arrayFindRemove(instances, inst);
			if (inst.layer)
			{
				cr.arrayRemove(inst.layer.instances, inst.get_zindex());
				inst.layer.zindices_stale = true;
			}
			for (j = 0, lenj = type.families.length; j < lenj; j++)
			{
				cr.arrayFindRemove(type.families[j].instances, inst);
				type.families[j].stale_iids = true;
			}
			if (inst.behavior_insts)
			{
				for (j = 0, lenj = inst.behavior_insts.length; j < lenj; j++)
				{
					binst = inst.behavior_insts[j];
					if (binst.onDestroy)
						binst.onDestroy();
					binst.behavior.my_instances.remove(inst);
				}
			}
            this.objects_to_tick.remove(inst);
			this.objects_to_tick2.remove(inst);
			for (j = 0, lenj = this.system.waits.length; j < lenj; j++)
			{
				w = this.system.waits[j];
				if (w.sols.hasOwnProperty(type.index))
					cr.arrayFindRemove(w.sols[type.index].insts, inst);
				if (!type.is_family)
				{
					for (k = 0, lenk = type.families.length; k < lenk; k++)
					{
						f = type.families[k];
						if (w.sols.hasOwnProperty(f.index))
							cr.arrayFindRemove(w.sols[f.index].insts, inst);
					}
				}
			}
			if (inst.onDestroy)
				inst.onDestroy();
			if (this.objectsByUid.hasOwnProperty(inst.uid.toString()))
				delete this.objectsByUid[inst.uid.toString()];
			this.objectcount--;
			if (type.deadCache.length < 64)
				type.deadCache.push(inst);
			type.stale_iids = true;
		}
		if (!this.deathRow.isEmpty())
			this.redraw = true;
		this.deathRow.clear();
		this.isInClearDeathRow = false;
	};
	Runtime.prototype.createInstance = function (type, layer, sx, sy)
	{
		if (type.is_family)
		{
			var i = cr.floor(Math.random() * type.members.length);
			return this.createInstance(type.members[i], layer, sx, sy);
		}
		if (!type.default_instance)
		{
			return null;
		}
		return this.createInstanceFromInit(type.default_instance, layer, false, sx, sy, false);
	};
	var all_behaviors = [];
	Runtime.prototype.createInstanceFromInit = function (initial_inst, layer, is_startup_instance, sx, sy, skip_siblings)
	{
		var i, len, j, lenj, p, effect_fallback, x, y;
		if (!initial_inst)
			return null;
		var type = this.types_by_index[initial_inst[1]];
;
;
		var is_world = type.plugin.is_world;
;
		if (this.isloading && is_world && !type.isOnLoaderLayout)
			return null;
		if (is_world && !this.glwrap && initial_inst[0][11] === 11)
			return null;
		var original_layer = layer;
		if (!is_world)
			layer = null;
		var inst;
		if (type.deadCache.length)
		{
			inst = type.deadCache.pop();
			inst.recycled = true;
			type.plugin.Instance.call(inst, type);
		}
		else
		{
			inst = new type.plugin.Instance(type);
			inst.recycled = false;
		}
		if (is_startup_instance && !skip_siblings)
			inst.uid = initial_inst[2];
		else
			inst.uid = this.next_uid++;
		this.objectsByUid[inst.uid.toString()] = inst;
		inst.puid = this.next_puid++;
		inst.iid = type.instances.length;
		for (i = 0, len = this.createRow.length; i < len; ++i)
		{
			if (this.createRow[i].type === type)
				inst.iid++;
		}
		inst.get_iid = cr.inst_get_iid;
		var initial_vars = initial_inst[3];
		if (inst.recycled)
		{
			cr.wipe(inst.extra);
		}
		else
		{
			inst.extra = {};
			if (typeof cr_is_preview !== "undefined")
			{
				inst.instance_var_names = [];
				inst.instance_var_names.length = initial_vars.length;
				for (i = 0, len = initial_vars.length; i < len; i++)
					inst.instance_var_names[i] = initial_vars[i][1];
			}
			inst.instance_vars = [];
			inst.instance_vars.length = initial_vars.length;
		}
		for (i = 0, len = initial_vars.length; i < len; i++)
			inst.instance_vars[i] = initial_vars[i][0];
		if (is_world)
		{
			var wm = initial_inst[0];
;
			inst.x = cr.is_undefined(sx) ? wm[0] : sx;
			inst.y = cr.is_undefined(sy) ? wm[1] : sy;
			inst.z = wm[2];
			inst.width = wm[3];
			inst.height = wm[4];
			inst.depth = wm[5];
			inst.angle = wm[6];
			inst.opacity = wm[7];
			inst.hotspotX = wm[8];
			inst.hotspotY = wm[9];
			inst.blend_mode = wm[10];
			effect_fallback = wm[11];
			if (!this.glwrap && type.effect_types.length)	// no WebGL renderer and shaders used
				inst.blend_mode = effect_fallback;			// use fallback blend mode - destroy mode was handled above
			inst.compositeOp = cr.effectToCompositeOp(inst.blend_mode);
			if (this.gl)
				cr.setGLBlend(inst, inst.blend_mode, this.gl);
			if (inst.recycled)
			{
				for (i = 0, len = wm[12].length; i < len; i++)
				{
					for (j = 0, lenj = wm[12][i].length; j < lenj; j++)
						inst.effect_params[i][j] = wm[12][i][j];
				}
				inst.bbox.set(0, 0, 0, 0);
				inst.bquad.set_from_rect(inst.bbox);
				inst.bbox_changed_callbacks.length = 0;
			}
			else
			{
				inst.effect_params = wm[12].slice(0);
				for (i = 0, len = inst.effect_params.length; i < len; i++)
					inst.effect_params[i] = wm[12][i].slice(0);
				inst.active_effect_types = [];
				inst.active_effect_flags = [];
				inst.active_effect_flags.length = type.effect_types.length;
				inst.bbox = new cr.rect(0, 0, 0, 0);
				inst.bquad = new cr.quad();
				inst.bbox_changed_callbacks = [];
				inst.set_bbox_changed = cr.set_bbox_changed;
				inst.add_bbox_changed_callback = cr.add_bbox_changed_callback;
				inst.contains_pt = cr.inst_contains_pt;
				inst.update_bbox = cr.update_bbox;
				inst.get_zindex = cr.inst_get_zindex;
			}
			inst.tilemap_exists = false;
			inst.tilemap_width = 0;
			inst.tilemap_height = 0;
			inst.tilemap_data = null;
			if (wm.length === 14)
			{
				inst.tilemap_exists = true;
				inst.tilemap_width = wm[13][0];
				inst.tilemap_height = wm[13][1];
				inst.tilemap_data = wm[13][2];
			}
			for (i = 0, len = type.effect_types.length; i < len; i++)
				inst.active_effect_flags[i] = true;
			inst.updateActiveEffects = cr.inst_updateActiveEffects;
			inst.updateActiveEffects();
			inst.uses_shaders = !!inst.active_effect_types.length;
			inst.bbox_changed = true;
			inst.visible = true;
            inst.my_timescale = -1.0;
			inst.layer = layer;
			inst.zindex = layer.instances.length;	// will be placed at top of current layer
			if (typeof inst.collision_poly === "undefined")
				inst.collision_poly = null;
			inst.collisionsEnabled = true;
			this.redraw = true;
		}
		inst.toString = cr.inst_toString;
		var initial_props, binst;
		all_behaviors.length = 0;
		for (i = 0, len = type.families.length; i < len; i++)
		{
			all_behaviors.push.apply(all_behaviors, type.families[i].behaviors);
		}
		all_behaviors.push.apply(all_behaviors, type.behaviors);
		if (inst.recycled)
		{
			for (i = 0, len = all_behaviors.length; i < len; i++)
			{
				var btype = all_behaviors[i];
				binst = inst.behavior_insts[i];
				binst.recycled = true;
				btype.behavior.Instance.call(binst, btype, inst);
				initial_props = initial_inst[4][i];
				for (j = 0, lenj = initial_props.length; j < lenj; j++)
					binst.properties[j] = initial_props[j];
				binst.onCreate();
				btype.behavior.my_instances.add(inst);
			}
		}
		else
		{
			inst.behavior_insts = [];
			for (i = 0, len = all_behaviors.length; i < len; i++)
			{
				var btype = all_behaviors[i];
				var binst = new btype.behavior.Instance(btype, inst);
				binst.recycled = false;
				binst.properties = initial_inst[4][i].slice(0);
				binst.onCreate();
				cr.seal(binst);
				inst.behavior_insts.push(binst);
				btype.behavior.my_instances.add(inst);
			}
		}
		initial_props = initial_inst[5];
		if (inst.recycled)
		{
			for (i = 0, len = initial_props.length; i < len; i++)
				inst.properties[i] = initial_props[i];
		}
		else
			inst.properties = initial_props.slice(0);
		this.createRow.push(inst);
		if (layer)
		{
;
			layer.instances.push(inst);
		}
		this.objectcount++;
		if (type.is_contained)
		{
			inst.is_contained = true;
			if (inst.recycled)
				inst.siblings.length = 0;
			else
				inst.siblings = [];			// note: should not include self in siblings
			if (!is_startup_instance && !skip_siblings)	// layout links initial instances
			{
				for (i = 0, len = type.container.length; i < len; i++)
				{
					if (type.container[i] === type)
						continue;
					if (!type.container[i].default_instance)
					{
						return null;
					}
					inst.siblings.push(this.createInstanceFromInit(type.container[i].default_instance, original_layer, false, is_world ? inst.x : sx, is_world ? inst.y : sy, true));
				}
				for (i = 0, len = inst.siblings.length; i < len; i++)
				{
					inst.siblings[i].siblings.push(inst);
					for (j = 0; j < len; j++)
					{
						if (i !== j)
							inst.siblings[i].siblings.push(inst.siblings[j]);
					}
				}
			}
		}
		else
		{
			inst.is_contained = false;
			inst.siblings = null;
		}
		inst.onCreate();
		if (!inst.recycled)
			cr.seal(inst);
		for (i = 0, len = inst.behavior_insts.length; i < len; i++)
		{
			if (inst.behavior_insts[i].postCreate)
				inst.behavior_insts[i].postCreate();
		}
		return inst;
	};
	Runtime.prototype.getLayerByName = function (layer_name)
	{
		var i, len;
		for (i = 0, len = this.running_layout.layers.length; i < len; i++)
		{
			var layer = this.running_layout.layers[i];
			if (cr.equals_nocase(layer.name, layer_name))
				return layer;
		}
		return null;
	};
	Runtime.prototype.getLayerByNumber = function (index)
	{
		index = cr.floor(index);
		if (index < 0)
			index = 0;
		if (index >= this.running_layout.layers.length)
			index = this.running_layout.layers.length - 1;
		return this.running_layout.layers[index];
	};
	Runtime.prototype.getLayer = function (l)
	{
		if (cr.is_number(l))
			return this.getLayerByNumber(l);
		else
			return this.getLayerByName(l.toString());
	};
	Runtime.prototype.clearSol = function (solModifiers)
	{
		var i, len;
		for (i = 0, len = solModifiers.length; i < len; i++)
		{
			solModifiers[i].getCurrentSol().select_all = true;
		}
	};
	Runtime.prototype.pushCleanSol = function (solModifiers)
	{
		var i, len;
		for (i = 0, len = solModifiers.length; i < len; i++)
		{
			solModifiers[i].pushCleanSol();
		}
	};
	Runtime.prototype.pushCopySol = function (solModifiers)
	{
		var i, len;
		for (i = 0, len = solModifiers.length; i < len; i++)
		{
			solModifiers[i].pushCopySol();
		}
	};
	Runtime.prototype.popSol = function (solModifiers)
	{
		var i, len;
		for (i = 0, len = solModifiers.length; i < len; i++)
		{
			solModifiers[i].popSol();
		}
	};
	Runtime.prototype.testAndSelectCanvasPointOverlap = function (type, ptx, pty, inverted)
	{
		var sol = type.getCurrentSol();
		var i, j, inst, len;
		var lx, ly;
		if (sol.select_all)
		{
			if (!inverted)
			{
				sol.select_all = false;
				sol.instances.length = 0;   // clear contents
			}
			for (i = 0, len = type.instances.length; i < len; i++)
			{
				inst = type.instances[i];
				inst.update_bbox();
				lx = inst.layer.canvasToLayer(ptx, pty, true);
				ly = inst.layer.canvasToLayer(ptx, pty, false);
				if (inst.contains_pt(lx, ly))
				{
					if (inverted)
						return false;
					else
						sol.instances.push(inst);
				}
			}
		}
		else
		{
			j = 0;
			for (i = 0, len = sol.instances.length; i < len; i++)
			{
				inst = sol.instances[i];
				inst.update_bbox();
				lx = inst.layer.canvasToLayer(ptx, pty, true);
				ly = inst.layer.canvasToLayer(ptx, pty, false);
				if (inst.contains_pt(lx, ly))
				{
					if (inverted)
						return false;
					else
					{
						sol.instances[j] = sol.instances[i];
						j++;
					}
				}
			}
			if (!inverted)
				sol.instances.length = j;
		}
		type.applySolToContainer();
		if (inverted)
			return true;		// did not find anything overlapping
		else
			return sol.hasObjects();
	};
	Runtime.prototype.testOverlap = function (a, b)
	{
		if (!a || !b || a === b || !a.collisionsEnabled || !b.collisionsEnabled)
			return false;
		a.update_bbox();
		b.update_bbox();
		var layera = a.layer;
		var layerb = b.layer;
		var different_layers = (layera !== layerb && (layera.parallaxX !== layerb.parallaxX || layerb.parallaxY !== layerb.parallaxY || layera.scale !== layerb.scale || layera.angle !== layerb.angle || layera.zoomRate !== layerb.zoomRate));
		var i, len, i2, i21, x, y, haspolya, haspolyb, polya, polyb;
		if (!different_layers)	// same layers: easy check
		{
			if (!a.bbox.intersects_rect(b.bbox))
				return false;
			if (!a.bquad.intersects_quad(b.bquad))
				return false;
			if (a.tilemap_exists && b.tilemap_exists)
				return false;
			if (a.tilemap_exists)
				return this.testTilemapOverlap(a, b);
			if (b.tilemap_exists)
				return this.testTilemapOverlap(b, a);
			haspolya = (a.collision_poly && !a.collision_poly.is_empty());
			haspolyb = (b.collision_poly && !b.collision_poly.is_empty());
			if (!haspolya && !haspolyb)
				return true;
			if (haspolya)
			{
				a.collision_poly.cache_poly(a.width, a.height, a.angle);
				polya = a.collision_poly;
			}
			else
			{
				this.temp_poly.set_from_quad(a.bquad, a.x, a.y, a.width, a.height);
				polya = this.temp_poly;
			}
			if (haspolyb)
			{
				b.collision_poly.cache_poly(b.width, b.height, b.angle);
				polyb = b.collision_poly;
			}
			else
			{
				this.temp_poly.set_from_quad(b.bquad, b.x, b.y, b.width, b.height);
				polyb = this.temp_poly;
			}
			return polya.intersects_poly(polyb, b.x - a.x, b.y - a.y);
		}
		else	// different layers: need to do full translated check
		{
			haspolya = (a.collision_poly && !a.collision_poly.is_empty());
			haspolyb = (b.collision_poly && !b.collision_poly.is_empty());
			if (haspolya)
			{
				a.collision_poly.cache_poly(a.width, a.height, a.angle);
				this.temp_poly.set_from_poly(a.collision_poly);
			}
			else
			{
				this.temp_poly.set_from_quad(a.bquad, a.x, a.y, a.width, a.height);
			}
			polya = this.temp_poly;
			if (haspolyb)
			{
				b.collision_poly.cache_poly(b.width, b.height, b.angle);
				this.temp_poly2.set_from_poly(b.collision_poly);
			}
			else
			{
				this.temp_poly2.set_from_quad(b.bquad, b.x, b.y, b.width, b.height);
			}
			polyb = this.temp_poly2;
			for (i = 0, len = polya.pts_count; i < len; i++)
			{
				i2 = i * 2;
				i21 = i2 + 1;
				x = polya.pts_cache[i2];
				y = polya.pts_cache[i21];
				polya.pts_cache[i2] = layera.layerToCanvas(x + a.x, y + a.y, true);
				polya.pts_cache[i21] = layera.layerToCanvas(x + a.x, y + a.y, false);
			}
			polya.update_bbox();
			for (i = 0, len = polyb.pts_count; i < len; i++)
			{
				i2 = i * 2;
				i21 = i2 + 1;
				x = polyb.pts_cache[i2];
				y = polyb.pts_cache[i21];
				polyb.pts_cache[i2] = layerb.layerToCanvas(x + b.x, y + b.y, true);
				polyb.pts_cache[i21] = layerb.layerToCanvas(x + b.x, y + b.y, false);
			}
			polyb.update_bbox();
			return polya.intersects_poly(polyb, 0, 0);
		}
	};
	var tmpQuad = new cr.quad();
	var tmpRect = new cr.rect(0, 0, 0, 0);
	Runtime.prototype.testTilemapOverlap = function (tm, a)
	{
		var collrects = tm.collision_rects;
		var i, len, c, rc;
		var bbox = a.bbox;
		var tmx = tm.x;
		var tmy = tm.y;
		var haspolya = (a.collision_poly && !a.collision_poly.is_empty());
		for (i = 0, len = collrects.length; i < len; ++i)
		{
			c = collrects[i];
			rc = c.rc;
			if (bbox.intersects_rect_off(rc, tmx, tmy))
			{
				tmpQuad.set_from_rect(rc);
				tmpQuad.offset(tmx, tmy);
				if (tmpQuad.intersects_quad(a.bquad))
				{
					if (haspolya)
					{
						a.collision_poly.cache_poly(a.width, a.height, a.angle);
						if (c.poly)
						{
							if (c.poly.intersects_poly(a.collision_poly, a.x - (tmx + rc.left), a.y - (tmy + rc.top)))
							{
								return true;
							}
						}
						else
						{
							this.temp_poly.set_from_quad(tmpQuad, 0, 0, rc.right - rc.left, rc.bottom - rc.top);
							if (this.temp_poly.intersects_poly(a.collision_poly, a.x, a.y))
								return true;
						}
					}
					else
					{
						if (c.poly)
						{
							this.temp_poly.set_from_quad(a.bquad, 0, 0, a.width, a.height);
							if (c.poly.intersects_poly(this.temp_poly, -(tmx + rc.left), -(tmy + rc.top)))
							{
								return true;
							}
						}
						else
							return true;
					}
				}
			}
		}
		return false;
	};
	Runtime.prototype.testRectOverlap = function (r, b)
	{
		if (!b || !b.collisionsEnabled)
			return false;
		b.update_bbox();
		var layerb = b.layer;
		var haspolyb, polyb;
		if (!b.bbox.intersects_rect(r))
			return false;
		if (b.tilemap_exists)
		{
			var collrects = b.collision_rects;
			var i, len, c, tilerc;
			var tmx = b.x;
			var tmy = b.y;
			for (i = 0, len = collrects.length; i < len; ++i)
			{
				c = collrects[i];
				tilerc = c.rc;
				if (r.intersects_rect_off(tilerc, tmx, tmy))
				{
					if (c.poly)
					{
						this.temp_poly.set_from_rect(r, 0, 0);
						if (c.poly.intersects_poly(this.temp_poly, -(tmx + tilerc.left), -(tmy + tilerc.top)))
							return true;
					}
					else
						return true;
				}
			}
			return false;
		}
		else
		{
			tmpQuad.set_from_rect(r);
			if (!b.bquad.intersects_quad(tmpQuad))
				return false;
			haspolyb = (b.collision_poly && !b.collision_poly.is_empty());
			if (!haspolyb)
				return true;
			b.collision_poly.cache_poly(b.width, b.height, b.angle);
			tmpQuad.offset(-r.left, -r.top);
			this.temp_poly.set_from_quad(tmpQuad, 0, 0, 1, 1);
			return b.collision_poly.intersects_poly(this.temp_poly, r.left - b.x, r.top - b.y);
		}
	};
	Runtime.prototype.testSegmentOverlap = function (x1, y1, x2, y2, b)
	{
		if (!b || !b.collisionsEnabled)
			return false;
		b.update_bbox();
		var layerb = b.layer;
		var haspolyb, polyb;
		tmpRect.set(cr.min(x1, x2), cr.min(y1, y2), cr.max(x1, x2), cr.max(y1, y2));
		if (!b.bbox.intersects_rect(tmpRect))
			return false;
		if (b.tilemap_exists)
		{
			var collrects = b.collision_rects;
			var i, len, c, tilerc;
			var tmx = b.x;
			var tmy = b.y;
			for (i = 0, len = collrects.length; i < len; ++i)
			{
				c = collrects[i];
				tilerc = c.rc;
				if (tmpRect.intersects_rect_off(tilerc, tmx, tmy))
				{
					tmpQuad.set_from_rect(tilerc);
					tmpQuad.offset(tmx, tmy);
					if (tmpQuad.intersects_segment(x1, y1, x2, y2))
					{
						if (c.poly)
						{
							if (c.poly.intersects_segment(tmx + tilerc.left, tmy + tilerc.top, x1, y1, x2, y2))
							{
								return true;
							}
						}
						else
							return true;
					}
				}
			}
			return false;
		}
		else
		{
			if (!b.bquad.intersects_segment(x1, y1, x2, y2))
				return false;
			haspolyb = (b.collision_poly && !b.collision_poly.is_empty());
			if (!haspolyb)
				return true;
			b.collision_poly.cache_poly(b.width, b.height, b.angle);
			return b.collision_poly.intersects_segment(b.x, b.y, x1, y1, x2, y2);
		}
	};
	Runtime.prototype.typeHasBehavior = function (t, b)
	{
		if (!b)
			return false;
		var i, len, j, lenj, f;
		for (i = 0, len = t.behaviors.length; i < len; i++)
		{
			if (t.behaviors[i].behavior instanceof b)
				return true;
		}
		if (!t.is_family)
		{
			for (i = 0, len = t.families.length; i < len; i++)
			{
				f = t.families[i];
				for (j = 0, lenj = f.behaviors.length; j < lenj; j++)
				{
					if (f.behaviors[j].behavior instanceof b)
						return true;
				}
			}
		}
		return false;
	};
	Runtime.prototype.typeHasNoSaveBehavior = function (t)
	{
		return this.typeHasBehavior(t, cr.behaviors.NoSave);
	};
	Runtime.prototype.typeHasPersistBehavior = function (t)
	{
		return this.typeHasBehavior(t, cr.behaviors.Persist);
	};
	Runtime.prototype.getSolidBehavior = function ()
	{
		if (!cr.behaviors.solid)
			return null;
		var i, len;
		for (i = 0, len = this.behaviors.length; i < len; i++)
		{
			if (this.behaviors[i] instanceof cr.behaviors.solid)
				return this.behaviors[i];
		}
		return null;
	};
	Runtime.prototype.testOverlapSolid = function (inst)
	{
		var solid = this.getSolidBehavior();
		if (!solid)
			return null;
		var i, len, s;
		var solids = solid.my_instances.valuesRef();
		for (i = 0, len = solids.length; i < len; ++i)
		{
			s = solids[i];
			if (!s.extra.solidEnabled)
				continue;
			if (this.testOverlap(inst, s))
				return s;
		}
		return null;
	};
	Runtime.prototype.testRectOverlapSolid = function (r)
	{
		var solid = this.getSolidBehavior();
		if (!solid)
			return null;
		var i, len, s;
		var solids = solid.my_instances.valuesRef();
		for (i = 0, len = solids.length; i < len; ++i)
		{
			s = solids[i];
			if (!s.extra.solidEnabled)
				continue;
			if (this.testRectOverlap(r, s))
				return s;
		}
		return null;
	};
	var jumpthru_array_ret = [];
	Runtime.prototype.testOverlapJumpThru = function (inst, all)
	{
		var jumpthru = null;
		var i, len, s;
		if (!cr.behaviors.jumpthru)
			return null;
		for (i = 0, len = this.behaviors.length; i < len; i++)
		{
			if (this.behaviors[i] instanceof cr.behaviors.jumpthru)
			{
				jumpthru = this.behaviors[i];
				break;
			}
		}
		if (!jumpthru)
			return null;
		var ret = null;
		if (all)
		{
			ret = jumpthru_array_ret;
			ret.length = 0;
		}
		var jumpthrus = jumpthru.my_instances.valuesRef();
		for (i = 0, len = jumpthrus.length; i < len; ++i)
		{
			s = jumpthrus[i];
			if (!s.extra.jumpthruEnabled)
				continue;
			if (this.testOverlap(inst, s))
			{
				if (all)
					ret.push(s);
				else
					return s;
			}
		}
		return ret;
	};
	Runtime.prototype.pushOutSolid = function (inst, xdir, ydir, dist, include_jumpthrus, specific_jumpthru)
	{
		var push_dist = dist || 50;
		var oldx = inst.x
		var oldy = inst.y;
		var i;
		var last_overlapped = null, secondlast_overlapped = null;
		for (i = 0; i < push_dist; i++)
		{
			inst.x = (oldx + (xdir * i));
			inst.y = (oldy + (ydir * i));
			inst.set_bbox_changed();
			if (!this.testOverlap(inst, last_overlapped))
			{
				last_overlapped = this.testOverlapSolid(inst);
				if (last_overlapped)
					secondlast_overlapped = last_overlapped;
				if (!last_overlapped)
				{
					if (include_jumpthrus)
					{
						if (specific_jumpthru)
							last_overlapped = (this.testOverlap(inst, specific_jumpthru) ? specific_jumpthru : null);
						else
							last_overlapped = this.testOverlapJumpThru(inst);
						if (last_overlapped)
							secondlast_overlapped = last_overlapped;
					}
					if (!last_overlapped)
					{
						if (secondlast_overlapped)
							this.pushInFractional(inst, xdir, ydir, secondlast_overlapped, 16);
						return true;
					}
				}
			}
		}
		inst.x = oldx;
		inst.y = oldy;
		inst.set_bbox_changed();
		return false;
	};
	Runtime.prototype.pushOut = function (inst, xdir, ydir, dist, otherinst)
	{
		var push_dist = dist || 50;
		var oldx = inst.x
		var oldy = inst.y;
		var i;
		for (i = 0; i < push_dist; i++)
		{
			inst.x = (oldx + (xdir * i));
			inst.y = (oldy + (ydir * i));
			inst.set_bbox_changed();
			if (!this.testOverlap(inst, otherinst))
				return true;
		}
		inst.x = oldx;
		inst.y = oldy;
		inst.set_bbox_changed();
		return false;
	};
	Runtime.prototype.pushInFractional = function (inst, xdir, ydir, obj, limit)
	{
		var divisor = 2;
		var frac;
		var forward = false;
		var overlapping = false;
		var bestx = inst.x;
		var besty = inst.y;
		while (divisor <= limit)
		{
			frac = 1 / divisor;
			divisor *= 2;
			inst.x += xdir * frac * (forward ? 1 : -1);
			inst.y += ydir * frac * (forward ? 1 : -1);
			inst.set_bbox_changed();
			if (this.testOverlap(inst, obj))
			{
				forward = true;
				overlapping = true;
			}
			else
			{
				forward = false;
				overlapping = false;
				bestx = inst.x;
				besty = inst.y;
			}
		}
		if (overlapping)
		{
			inst.x = bestx;
			inst.y = besty;
			inst.set_bbox_changed();
		}
	};
	Runtime.prototype.pushOutSolidNearest = function (inst, max_dist_)
	{
		var max_dist = (cr.is_undefined(max_dist_) ? 100 : max_dist_);
		var dist = 0;
		var oldx = inst.x
		var oldy = inst.y;
		var dir = 0;
		var dx = 0, dy = 0;
		var last_overlapped = this.testOverlapSolid(inst);
		if (!last_overlapped)
			return true;		// already clear of solids
		while (dist <= max_dist)
		{
			switch (dir) {
			case 0:		dx = 0; dy = -1; dist++; break;
			case 1:		dx = 1; dy = -1; break;
			case 2:		dx = 1; dy = 0; break;
			case 3:		dx = 1; dy = 1; break;
			case 4:		dx = 0; dy = 1; break;
			case 5:		dx = -1; dy = 1; break;
			case 6:		dx = -1; dy = 0; break;
			case 7:		dx = -1; dy = -1; break;
			}
			dir = (dir + 1) % 8;
			inst.x = cr.floor(oldx + (dx * dist));
			inst.y = cr.floor(oldy + (dy * dist));
			inst.set_bbox_changed();
			if (!this.testOverlap(inst, last_overlapped))
			{
				last_overlapped = this.testOverlapSolid(inst);
				if (!last_overlapped)
					return true;
			}
		}
		inst.x = oldx;
		inst.y = oldy;
		inst.set_bbox_changed();
		return false;
	};
	Runtime.prototype.registerCollision = function (a, b)
	{
		if (!a.collisionsEnabled || !b.collisionsEnabled)
			return;
		this.registered_collisions.push([a, b]);
	};
	Runtime.prototype.checkRegisteredCollision = function (a, b)
	{
		var i, len, x;
		for (i = 0, len = this.registered_collisions.length; i < len; i++)
		{
			x = this.registered_collisions[i];
			if ((x[0] == a && x[1] == b) || (x[0] == b && x[1] == a))
				return true;
		}
		return false;
	};
	Runtime.prototype.calculateSolidBounceAngle = function(inst, startx, starty, obj)
	{
		var objx = inst.x;
		var objy = inst.y;
		var radius = cr.max(10, cr.distanceTo(startx, starty, objx, objy));
		var startangle = cr.angleTo(startx, starty, objx, objy);
		var firstsolid = obj || this.testOverlapSolid(inst);
		if (!firstsolid)
			return cr.clamp_angle(startangle + cr.PI);
		var cursolid = firstsolid;
		var i, curangle, anticlockwise_free_angle, clockwise_free_angle;
		var increment = cr.to_radians(5);	// 5 degree increments
		for (i = 1; i < 36; i++)
		{
			curangle = startangle - i * increment;
			inst.x = startx + Math.cos(curangle) * radius;
			inst.y = starty + Math.sin(curangle) * radius;
			inst.set_bbox_changed();
			if (!this.testOverlap(inst, cursolid))
			{
				cursolid = obj ? null : this.testOverlapSolid(inst);
				if (!cursolid)
				{
					anticlockwise_free_angle = curangle;
					break;
				}
			}
		}
		if (i === 36)
			anticlockwise_free_angle = cr.clamp_angle(startangle + cr.PI);
		var cursolid = firstsolid;
		for (i = 1; i < 36; i++)
		{
			curangle = startangle + i * increment;
			inst.x = startx + Math.cos(curangle) * radius;
			inst.y = starty + Math.sin(curangle) * radius;
			inst.set_bbox_changed();
			if (!this.testOverlap(inst, cursolid))
			{
				cursolid = obj ? null : this.testOverlapSolid(inst);
				if (!cursolid)
				{
					clockwise_free_angle = curangle;
					break;
				}
			}
		}
		if (i === 36)
			clockwise_free_angle = cr.clamp_angle(startangle + cr.PI);
		inst.x = objx;
		inst.y = objy;
		inst.set_bbox_changed();
		if (clockwise_free_angle === anticlockwise_free_angle)
			return clockwise_free_angle;
		var half_diff = cr.angleDiff(clockwise_free_angle, anticlockwise_free_angle) / 2;
		var normal;
		if (cr.angleClockwise(clockwise_free_angle, anticlockwise_free_angle))
		{
			normal = cr.clamp_angle(anticlockwise_free_angle + half_diff + cr.PI);
		}
		else
		{
			normal = cr.clamp_angle(clockwise_free_angle + half_diff);
		}
;
		var vx = Math.cos(startangle);
		var vy = Math.sin(startangle);
		var nx = Math.cos(normal);
		var ny = Math.sin(normal);
		var v_dot_n = vx * nx + vy * ny;
		var rx = vx - 2 * v_dot_n * nx;
		var ry = vy - 2 * v_dot_n * ny;
		return cr.angleTo(0, 0, rx, ry);
	};
	var triggerSheetStack = [];
	var triggerSheetIndex = -1;
	Runtime.prototype.trigger = function (method, inst, value /* for fast triggers */)
	{
;
		if (!this.running_layout)
			return false;
		var sheet = this.running_layout.event_sheet;
		if (!sheet)
			return false;     // no event sheet active; nothing to trigger
		triggerSheetIndex++;
		if (triggerSheetIndex === triggerSheetStack.length)
			triggerSheetStack.push(new cr.ObjectSet());
		else
			triggerSheetStack[triggerSheetIndex].clear();
        var ret = this.triggerOnSheet(method, inst, sheet, value);
		triggerSheetIndex--;
		return ret;
    };
    Runtime.prototype.triggerOnSheet = function (method, inst, sheet, value)
    {
		var alreadyTriggeredSheets = triggerSheetStack[triggerSheetIndex];
        if (alreadyTriggeredSheets.contains(sheet))
            return false;
        alreadyTriggeredSheets.add(sheet);
        var includes = sheet.includes.valuesRef();
        var ret = false;
		var i, leni, r;
        for (i = 0, leni = includes.length; i < leni; i++)
        {
			if (includes[i].isActive())
			{
				r = this.triggerOnSheet(method, inst, includes[i].include_sheet, value);
				ret = ret || r;
			}
        }
		if (!inst)
		{
			r = this.triggerOnSheetForTypeName(method, inst, "system", sheet, value);
			ret = ret || r;
		}
		else
		{
			r = this.triggerOnSheetForTypeName(method, inst, inst.type.name, sheet, value);
			ret = ret || r;
			for (i = 0, leni = inst.type.families.length; i < leni; i++)
			{
				r = this.triggerOnSheetForTypeName(method, inst, inst.type.families[i].name, sheet, value);
				ret = ret || r;
			}
		}
		return ret;             // true if anything got triggered
	};
	Runtime.prototype.triggerOnSheetForTypeName = function (method, inst, type_name, sheet, value)
	{
		var i, leni;
		var ret = false, ret2 = false;
		var trig, index;
		var fasttrigger = (typeof value !== "undefined");
		var triggers = (fasttrigger ? sheet.fasttriggers : sheet.triggers);
		var obj_entry = triggers[type_name];
		if (!obj_entry)
			return ret;
		var triggers_list = null;
		for (i = 0, leni = obj_entry.length; i < leni; i++)
		{
			if (obj_entry[i].method == method)
			{
				triggers_list = obj_entry[i].evs;
				break;
			}
		}
		if (!triggers_list)
			return ret;
		var triggers_to_fire;
		if (fasttrigger)
		{
			triggers_to_fire = triggers_list[value];
		}
		else
		{
			triggers_to_fire = triggers_list;
		}
		if (!triggers_to_fire)
			return null;
		for (i = 0, leni = triggers_to_fire.length; i < leni; i++)
		{
			trig = triggers_to_fire[i][0];
			index = triggers_to_fire[i][1];
			ret2 = this.executeSingleTrigger(inst, type_name, trig, index);
			ret = ret || ret2;
		}
		return ret;
	};
	Runtime.prototype.executeSingleTrigger = function (inst, type_name, trig, index)
	{
		var i, leni;
		var ret = false;
		this.trigger_depth++;
		var current_event = this.getCurrentEventStack().current_event;
		if (current_event)
			this.pushCleanSol(current_event.solModifiersIncludingParents);
		var isrecursive = (this.trigger_depth > 1);		// calling trigger from inside another trigger
		this.pushCleanSol(trig.solModifiersIncludingParents);
		if (isrecursive)
			this.pushLocalVarStack();
		var event_stack = this.pushEventStack(trig);
		event_stack.current_event = trig;
		if (inst)
		{
			var sol = this.types[type_name].getCurrentSol();
			sol.select_all = false;
			sol.instances.length = 1;
			sol.instances[0] = inst;
			this.types[type_name].applySolToContainer();
		}
		var ok_to_run = true;
		if (trig.parent)
		{
			var temp_parents_arr = event_stack.temp_parents_arr;
			var cur_parent = trig.parent;
			while (cur_parent)
			{
				temp_parents_arr.push(cur_parent);
				cur_parent = cur_parent.parent;
			}
			temp_parents_arr.reverse();
			for (i = 0, leni = temp_parents_arr.length; i < leni; i++)
			{
				if (!temp_parents_arr[i].run_pretrigger())   // parent event failed
				{
					ok_to_run = false;
					break;
				}
			}
		}
		if (ok_to_run)
		{
			this.execcount++;
			if (trig.orblock)
				trig.run_orblocktrigger(index);
			else
				trig.run();
			ret = ret || event_stack.last_event_true;
		}
		this.popEventStack();
		if (isrecursive)
			this.popLocalVarStack();
		this.popSol(trig.solModifiersIncludingParents);
		if (current_event)
			this.popSol(current_event.solModifiersIncludingParents);
		if (this.isInOnDestroy === 0 && triggerSheetIndex === 0 && !this.isRunningEvents && (!this.deathRow.isEmpty() || this.createRow.length))
		{
			this.ClearDeathRow();
		}
		this.trigger_depth--;
		return ret;
	};
	Runtime.prototype.getCurrentCondition = function ()
	{
		var evinfo = this.getCurrentEventStack();
		return evinfo.current_event.conditions[evinfo.cndindex];
	};
	Runtime.prototype.getCurrentAction = function ()
	{
		var evinfo = this.getCurrentEventStack();
		return evinfo.current_event.actions[evinfo.actindex];
	};
	Runtime.prototype.pushLocalVarStack = function ()
	{
		this.localvar_stack_index++;
		if (this.localvar_stack_index >= this.localvar_stack.length)
			this.localvar_stack.push([]);
	};
	Runtime.prototype.popLocalVarStack = function ()
	{
;
		this.localvar_stack_index--;
	};
	Runtime.prototype.getCurrentLocalVarStack = function ()
	{
		return this.localvar_stack[this.localvar_stack_index];
	};
	Runtime.prototype.pushEventStack = function (cur_event)
	{
		this.event_stack_index++;
		if (this.event_stack_index >= this.event_stack.length)
			this.event_stack.push(new cr.eventStackFrame());
		var ret = this.getCurrentEventStack();
		ret.reset(cur_event);
		return ret;
	};
	Runtime.prototype.popEventStack = function ()
	{
;
		this.event_stack_index--;
	};
	Runtime.prototype.getCurrentEventStack = function ()
	{
		return this.event_stack[this.event_stack_index];
	};
	Runtime.prototype.pushLoopStack = function (name_)
	{
		this.loop_stack_index++;
		if (this.loop_stack_index >= this.loop_stack.length)
		{
			this.loop_stack.push(cr.seal({ name: name_, index: 0, stopped: false }));
		}
		var ret = this.getCurrentLoop();
		ret.name = name_;
		ret.index = 0;
		ret.stopped = false;
		return ret;
	};
	Runtime.prototype.popLoopStack = function ()
	{
;
		this.loop_stack_index--;
	};
	Runtime.prototype.getCurrentLoop = function ()
	{
		return this.loop_stack[this.loop_stack_index];
	};
	Runtime.prototype.getEventVariableByName = function (name, scope)
	{
		var i, leni, j, lenj, sheet, e;
		while (scope)
		{
			for (i = 0, leni = scope.subevents.length; i < leni; i++)
			{
				e = scope.subevents[i];
				if (e instanceof cr.eventvariable && cr.equals_nocase(name, e.name))
					return e;
			}
			scope = scope.parent;
		}
		for (i = 0, leni = this.eventsheets_by_index.length; i < leni; i++)
		{
			sheet = this.eventsheets_by_index[i];
			for (j = 0, lenj = sheet.events.length; j < lenj; j++)
			{
				e = sheet.events[j];
				if (e instanceof cr.eventvariable && cr.equals_nocase(name, e.name))
					return e;
			}
		}
		return null;
	};
	Runtime.prototype.getLayoutBySid = function (sid_)
	{
		var i, len;
		for (i = 0, len = this.layouts_by_index.length; i < len; i++)
		{
			if (this.layouts_by_index[i].sid === sid_)
				return this.layouts_by_index[i];
		}
		return null;
	};
	Runtime.prototype.getObjectTypeBySid = function (sid_)
	{
		var i, len;
		for (i = 0, len = this.types_by_index.length; i < len; i++)
		{
			if (this.types_by_index[i].sid === sid_)
				return this.types_by_index[i];
		}
		return null;
	};
	Runtime.prototype.getGroupBySid = function (sid_)
	{
		var i, len;
		for (i = 0, len = this.allGroups.length; i < len; i++)
		{
			if (this.allGroups[i].sid === sid_)
				return this.allGroups[i];
		}
		return null;
	};
	function makeSaveDb(e)
	{
		var db = e.target.result;
		db.createObjectStore("saves", { keyPath: "slot" });
	};
	function IndexedDB_WriteSlot(slot_, data_, oncomplete_, onerror_)
	{
		var request = indexedDB.open("_C2SaveStates");
		request.onupgradeneeded = makeSaveDb;
		request.onerror = onerror_;
		request.onsuccess = function (e)
		{
			var db = e.target.result;
			db.onerror = onerror_;
			var transaction = db.transaction(["saves"], "readwrite");
			var objectStore = transaction.objectStore("saves");
			var putReq = objectStore.put({"slot": slot_, "data": data_ });
			putReq.onsuccess = oncomplete_;
		};
	};
	function IndexedDB_ReadSlot(slot_, oncomplete_, onerror_)
	{
		var request = indexedDB.open("_C2SaveStates");
		request.onupgradeneeded = makeSaveDb;
		request.onerror = onerror_;
		request.onsuccess = function (e)
		{
			var db = e.target.result;
			db.onerror = onerror_;
			var transaction = db.transaction(["saves"]);
			var objectStore = transaction.objectStore("saves");
			var readReq = objectStore.get(slot_);
			readReq.onsuccess = function (e)
			{
				if (readReq.result)
					oncomplete_(readReq.result["data"]);
				else
					oncomplete_(null);
			};
		};
	};
	Runtime.prototype.signalContinuousPreview = function ()
	{
		this.signalledContinuousPreview = true;
	};
	function doContinuousPreviewReload()
	{
		cr.logexport("Reloading for continuous preview");
		if (!!window["c2cocoonjs"])
		{
			CocoonJS["App"]["reload"]();
		}
		else
		{
			if (window.location.search.indexOf("continuous") > -1)
				window.location.reload(true);
			else
				window.location = window.location + "?continuous";
		}
	};
	Runtime.prototype.handleSaveLoad = function ()
	{
		var self = this;
		var savingToSlot = this.saveToSlot;
		var savingJson = this.lastSaveJson;
		var loadingFromSlot = this.loadFromSlot;
		var continuous = false;
		if (this.signalledContinuousPreview)
		{
			continuous = true;
			savingToSlot = "__c2_continuouspreview";
			this.signalledContinuousPreview = false;
		}
		if (savingToSlot.length)
		{
			this.ClearDeathRow();
			savingJson = this.saveToJSONString();
			if (window.indexedDB && !this.isCocoonJs)
			{
				IndexedDB_WriteSlot(savingToSlot, savingJson, function ()
				{
					cr.logexport("Saved state to IndexedDB storage (" + savingJson.length + " bytes)");
					self.lastSaveJson = savingJson;
					self.trigger(cr.system_object.prototype.cnds.OnSaveComplete, null);
					self.lastSaveJson = "";
					if (continuous)
						doContinuousPreviewReload();
				}, function (e)
				{
					try {
						localStorage.setItem("__c2save_" + savingToSlot, savingJson);
						cr.logexport("Saved state to WebStorage (" + savingJson.length + " bytes)");
						self.lastSaveJson = savingJson;
						self.trigger(cr.system_object.prototype.cnds.OnSaveComplete, null);
						self.lastSaveJson = "";
						if (continuous)
							doContinuousPreviewReload();
					}
					catch (f)
					{
						cr.logexport("Failed to save game state: " + e + "; " + f);
					}
				});
			}
			else
			{
				try {
					localStorage.setItem("__c2save_" + savingToSlot, savingJson);
					cr.logexport("Saved state to WebStorage (" + savingJson.length + " bytes)");
					self.lastSaveJson = savingJson;
					this.trigger(cr.system_object.prototype.cnds.OnSaveComplete, null);
					self.lastSaveJson = "";
					if (continuous)
						doContinuousPreviewReload();
				}
				catch (e)
				{
					cr.logexport("Error saving to WebStorage: " + e);
				}
			}
			this.saveToSlot = "";
			this.loadFromSlot = "";
			this.loadFromJson = "";
		}
		if (loadingFromSlot.length)
		{
			if (window.indexedDB && !this.isCocoonJs)
			{
				IndexedDB_ReadSlot(loadingFromSlot, function (result_)
				{
					if (result_)
					{
						self.loadFromJson = result_;
						cr.logexport("Loaded state from IndexedDB storage (" + self.loadFromJson.length + " bytes)");
					}
					else
					{
						self.loadFromJson = localStorage.getItem("__c2save_" + loadingFromSlot) || "";
						cr.logexport("Loaded state from WebStorage (" + self.loadFromJson.length + " bytes)");
					}
					self.suspendDrawing = false;
					if (!self.loadFromJson.length)
						self.trigger(cr.system_object.prototype.cnds.OnLoadFailed, null);
				}, function (e)
				{
					self.loadFromJson = localStorage.getItem("__c2save_" + loadingFromSlot) || "";
					cr.logexport("Loaded state from WebStorage (" + self.loadFromJson.length + " bytes)");
					self.suspendDrawing = false;
					if (!self.loadFromJson.length)
						self.trigger(cr.system_object.prototype.cnds.OnLoadFailed, null);
				});
			}
			else
			{
				this.loadFromJson = localStorage.getItem("__c2save_" + loadingFromSlot) || "";
				cr.logexport("Loaded state from WebStorage (" + this.loadFromJson.length + " bytes)");
				this.suspendDrawing = false;
				if (!self.loadFromJson.length)
					self.trigger(cr.system_object.prototype.cnds.OnLoadFailed, null);
			}
			this.loadFromSlot = "";
			this.saveToSlot = "";
		}
		if (this.loadFromJson.length)
		{
			this.ClearDeathRow();
			this.loadFromJSONString(this.loadFromJson);
			this.lastSaveJson = this.loadFromJson;
			this.trigger(cr.system_object.prototype.cnds.OnLoadComplete, null);
			this.lastSaveJson = "";
			this.loadFromJson = "";
		}
	};
	function CopyExtraObject(extra)
	{
		var p, ret = {};
		for (p in extra)
		{
			if (extra.hasOwnProperty(p))
			{
				if (extra[p] instanceof cr.ObjectSet)
					continue;
				if (extra[p] && typeof extra[p].c2userdata !== "undefined")
					continue;
				ret[p] = extra[p];
			}
		}
		return ret;
	};
	Runtime.prototype.saveToJSONString = function()
	{
		var i, len, j, lenj, type, layout, typeobj, g, c, a, v, p;
		var o = {
			"c2save":				true,
			"version":				1,
			"rt": {
				"time":				this.kahanTime.sum,
				"timescale":		this.timescale,
				"tickcount":		this.tickcount,
				"execcount":		this.execcount,
				"next_uid":			this.next_uid,
				"running_layout":	this.running_layout.sid,
				"start_time_offset": (Date.now() - this.start_time)
			},
			"types": {},
			"layouts": {},
			"events": {
				"groups": {},
				"cnds": {},
				"acts": {},
				"vars": {}
			}
		};
		for (i = 0, len = this.types_by_index.length; i < len; i++)
		{
			type = this.types_by_index[i];
			if (type.is_family || this.typeHasNoSaveBehavior(type))
				continue;
			typeobj = {
				"instances": []
			};
			if (cr.hasAnyOwnProperty(type.extra))
				typeobj["ex"] = CopyExtraObject(type.extra);
			for (j = 0, lenj = type.instances.length; j < lenj; j++)
			{
				typeobj["instances"].push(this.saveInstanceToJSON(type.instances[j]));
			}
			o["types"][type.sid.toString()] = typeobj;
		}
		for (i = 0, len = this.layouts_by_index.length; i < len; i++)
		{
			layout = this.layouts_by_index[i];
			o["layouts"][layout.sid.toString()] = layout.saveToJSON();
		}
		var ogroups = o["events"]["groups"];
		for (i = 0, len = this.allGroups.length; i < len; i++)
		{
			g = this.allGroups[i];
			ogroups[g.sid.toString()] = !!this.activeGroups[g.group_name];
		}
		var ocnds = o["events"]["cnds"];
		for (p in this.cndsBySid)
		{
			if (this.cndsBySid.hasOwnProperty(p))
			{
				c = this.cndsBySid[p];
				if (cr.hasAnyOwnProperty(c.extra))
					ocnds[p] = { "ex": CopyExtraObject(c.extra) };
			}
		}
		var oacts = o["events"]["acts"];
		for (p in this.actsBySid)
		{
			if (this.actsBySid.hasOwnProperty(p))
			{
				a = this.actsBySid[p];
				if (cr.hasAnyOwnProperty(a.extra))
					oacts[p] = { "ex": a.extra };
			}
		}
		var ovars = o["events"]["vars"];
		for (p in this.varsBySid)
		{
			if (this.varsBySid.hasOwnProperty(p))
			{
				v = this.varsBySid[p];
				if (!v.is_constant && (!v.parent || v.is_static))
					ovars[p] = v.data;
			}
		}
		o["system"] = this.system.saveToJSON();
		return JSON.stringify(o);
	};
	Runtime.prototype.refreshUidMap = function ()
	{
		var i, len, type, j, lenj, inst;
		this.objectsByUid = {};
		for (i = 0, len = this.types_by_index.length; i < len; i++)
		{
			type = this.types_by_index[i];
			if (type.is_family)
				continue;
			for (j = 0, lenj = type.instances.length; j < lenj; j++)
			{
				inst = type.instances[j];
				this.objectsByUid[inst.uid.toString()] = inst;
			}
		}
	};
	Runtime.prototype.loadFromJSONString = function (str)
	{
		var o = JSON.parse(str);
		if (!o["c2save"])
			return;		// probably not a c2 save state
		if (o["version"] > 1)
			return;		// from future version of c2; assume not compatible
		var rt = o["rt"];
		this.kahanTime.reset();
		this.kahanTime.sum = rt["time"];
		this.timescale = rt["timescale"];
		this.tickcount = rt["tickcount"];
		this.execcount = rt["execcount"];
		this.start_time = Date.now() - rt["start_time_offset"];
		var layout_sid = rt["running_layout"];
		if (layout_sid !== this.running_layout.sid)
		{
			var changeToLayout = this.getLayoutBySid(layout_sid);
			if (changeToLayout)
				this.doChangeLayout(changeToLayout);
			else
				return;		// layout that was saved on has gone missing (deleted?)
		}
		this.isLoadingState = true;
		var i, len, j, lenj, k, lenk, p, type, existing_insts, load_insts, inst, binst, layout, layer, g, iid, t;
		var otypes = o["types"];
		for (p in otypes)
		{
			if (otypes.hasOwnProperty(p))
			{
				type = this.getObjectTypeBySid(parseInt(p, 10));
				if (!type || type.is_family || this.typeHasNoSaveBehavior(type))
					continue;
				if (otypes[p]["ex"])
					type.extra = otypes[p]["ex"];
				else
					cr.wipe(type.extra);
				existing_insts = type.instances;
				load_insts = otypes[p]["instances"];
				for (i = 0, len = cr.min(existing_insts.length, load_insts.length); i < len; i++)
				{
					this.loadInstanceFromJSON(existing_insts[i], load_insts[i]);
				}
				for (i = load_insts.length, len = existing_insts.length; i < len; i++)
					this.DestroyInstance(existing_insts[i]);
				for (i = existing_insts.length, len = load_insts.length; i < len; i++)
				{
					layer = null;
					if (type.plugin.is_world)
					{
						layer = this.running_layout.getLayerBySid(load_insts[i]["w"]["l"]);
						if (!layer)
							continue;
					}
					inst = this.createInstanceFromInit(type.default_instance, layer, false, 0, 0, true);
					this.loadInstanceFromJSON(inst, load_insts[i]);
				}
				type.stale_iids = true;
			}
		}
		this.ClearDeathRow();
		this.refreshUidMap();
		var olayouts = o["layouts"];
		for (p in olayouts)
		{
			if (olayouts.hasOwnProperty(p))
			{
				layout = this.getLayoutBySid(parseInt(p, 10));
				if (!layout)
					continue;		// must've gone missing
				layout.loadFromJSON(olayouts[p]);
			}
		}
		var ogroups = o["events"]["groups"];
		for (p in ogroups)
		{
			if (ogroups.hasOwnProperty(p))
			{
				g = this.getGroupBySid(parseInt(p, 10));
				if (g)
					this.activeGroups[g.group_name] = ogroups[p];
			}
		}
		var ocnds = o["events"]["cnds"];
		for (p in ocnds)
		{
			if (ocnds.hasOwnProperty(p) && this.cndsBySid.hasOwnProperty(p))
			{
				this.cndsBySid[p].extra = ocnds[p]["ex"];
			}
		}
		var oacts = o["events"]["acts"];
		for (p in oacts)
		{
			if (oacts.hasOwnProperty(p) && this.actsBySid.hasOwnProperty(p))
			{
				this.actsBySid[p].extra = oacts[p]["ex"];
			}
		}
		var ovars = o["events"]["vars"];
		for (p in ovars)
		{
			if (ovars.hasOwnProperty(p) && this.varsBySid.hasOwnProperty(p))
			{
				this.varsBySid[p].data = ovars[p];
			}
		}
		this.next_uid = rt["next_uid"];
		this.isLoadingState = false;
		this.system.loadFromJSON(o["system"]);
		for (i = 0, len = this.types_by_index.length; i < len; i++)
		{
			type = this.types_by_index[i];
			if (type.is_family)
				continue;
			for (j = 0, lenj = type.instances.length; j < lenj; j++)
			{
				inst = type.instances[j];
				if (type.is_contained)
				{
					iid = inst.get_iid();
					inst.siblings.length = 0;
					for (k = 0, lenk = type.container.length; k < lenk; k++)
					{
						t = type.container[k];
						if (type === t)
							continue;
;
						inst.siblings.push(t.instances[iid]);
					}
				}
				if (inst.afterLoad)
					inst.afterLoad();
				if (inst.behavior_insts)
				{
					for (k = 0, lenk = inst.behavior_insts.length; k < lenk; k++)
					{
						binst = inst.behavior_insts[k];
						if (binst.afterLoad)
							binst.afterLoad();
					}
				}
			}
		}
		this.redraw = true;
	};
	Runtime.prototype.saveInstanceToJSON = function(inst, state_only)
	{
		var i, len, world, behinst, et;
		var type = inst.type;
		var plugin = type.plugin;
		var o = {};
		if (state_only)
			o["c2"] = true;		// mark as known json data from Construct 2
		else
			o["uid"] = inst.uid;
		if (cr.hasAnyOwnProperty(inst.extra))
			o["ex"] = CopyExtraObject(inst.extra);
		if (inst.instance_vars && inst.instance_vars.length)
		{
			o["ivs"] = {};
			for (i = 0, len = inst.instance_vars.length; i < len; i++)
			{
				o["ivs"][inst.type.instvar_sids[i].toString()] = inst.instance_vars[i];
			}
		}
		if (plugin.is_world)
		{
			world = {
				"x": inst.x,
				"y": inst.y,
				"w": inst.width,
				"h": inst.height,
				"l": inst.layer.sid,
				"zi": inst.get_zindex()
			};
			if (inst.angle !== 0)
				world["a"] = inst.angle;
			if (inst.opacity !== 1)
				world["o"] = inst.opacity;
			if (inst.hotspotX !== 0.5)
				world["hX"] = inst.hotspotX;
			if (inst.hotspotY !== 0.5)
				world["hY"] = inst.hotspotY;
			if (inst.blend_mode !== 0)
				world["bm"] = inst.blend_mode;
			if (!inst.visible)
				world["v"] = inst.visible;
			if (!inst.collisionsEnabled)
				world["ce"] = inst.collisionsEnabled;
			if (inst.my_timescale !== -1)
				world["mts"] = inst.my_timescale;
			if (type.effect_types.length)
			{
				world["fx"] = [];
				for (i = 0, len = type.effect_types.length; i < len; i++)
				{
					et = type.effect_types[i];
					world["fx"].push({"name": et.name,
									  "active": inst.active_effect_flags[et.index],
									  "params": inst.effect_params[et.index] });
				}
			}
			o["w"] = world;
		}
		if (inst.behavior_insts && inst.behavior_insts.length)
		{
			o["behs"] = {};
			for (i = 0, len = inst.behavior_insts.length; i < len; i++)
			{
				behinst = inst.behavior_insts[i];
				if (behinst.saveToJSON)
					o["behs"][behinst.type.sid.toString()] = behinst.saveToJSON();
			}
		}
		if (inst.saveToJSON)
			o["data"] = inst.saveToJSON();
		return o;
	};
	Runtime.prototype.getInstanceVarIndexBySid = function (type, sid_)
	{
		var i, len;
		for (i = 0, len = type.instvar_sids.length; i < len; i++)
		{
			if (type.instvar_sids[i] === sid_)
				return i;
		}
		return -1;
	};
	Runtime.prototype.getBehaviorIndexBySid = function (inst, sid_)
	{
		var i, len;
		for (i = 0, len = inst.behavior_insts.length; i < len; i++)
		{
			if (inst.behavior_insts[i].type.sid === sid_)
				return i;
		}
		return -1;
	};
	Runtime.prototype.loadInstanceFromJSON = function(inst, o, state_only)
	{
		var p, i, len, iv, oivs, world, fxindex, obehs, behindex;
		var oldlayer;
		var type = inst.type;
		var plugin = type.plugin;
		if (state_only)
		{
			if (!o["c2"])
				return;
		}
		else
			inst.uid = o["uid"];
		if (o["ex"])
			inst.extra = o["ex"];
		else
			cr.wipe(inst.extra);
		oivs = o["ivs"];
		if (oivs)
		{
			for (p in oivs)
			{
				if (oivs.hasOwnProperty(p))
				{
					iv = this.getInstanceVarIndexBySid(type, parseInt(p, 10));
					if (iv < 0 || iv >= inst.instance_vars.length)
						continue;		// must've gone missing
					inst.instance_vars[iv] = oivs[p];
				}
			}
		}
		if (plugin.is_world)
		{
			world = o["w"];
			if (inst.layer.sid !== world["l"])
			{
				oldlayer = inst.layer;
				inst.layer = this.running_layout.getLayerBySid(world["l"]);
				if (inst.layer)
				{
					inst.layer.instances.push(inst);
					inst.layer.zindices_stale = true;
					cr.arrayFindRemove(oldlayer.instances, inst);
					oldlayer.zindices_stale = true;
				}
				else
				{
					inst.layer = oldlayer;
					this.DestroyInstance(inst);
				}
			}
			inst.x = world["x"];
			inst.y = world["y"];
			inst.width = world["w"];
			inst.height = world["h"];
			inst.zindex = world["zi"];
			inst.angle = world.hasOwnProperty("a") ? world["a"] : 0;
			inst.opacity = world.hasOwnProperty("o") ? world["o"] : 1;
			inst.hotspotX = world.hasOwnProperty("hX") ? world["hX"] : 0.5;
			inst.hotspotY = world.hasOwnProperty("hY") ? world["hY"] : 0.5;
			inst.visible = world.hasOwnProperty("v") ? world["v"] : true;
			inst.collisionsEnabled = world.hasOwnProperty("ce") ? world["ce"] : true;
			inst.my_timescale = world.hasOwnProperty("mts") ? world["mts"] : -1;
			inst.blend_mode = world.hasOwnProperty("bm") ? world["bm"] : 0;;
			inst.compositeOp = cr.effectToCompositeOp(inst.blend_mode);
			if (this.gl)
				cr.setGLBlend(inst, inst.blend_mode, this.gl);
			inst.set_bbox_changed();
			if (world.hasOwnProperty("fx"))
			{
				for (i = 0, len = world["fx"].length; i < len; i++)
				{
					fxindex = type.getEffectIndexByName(world["fx"][i]["name"]);
					if (fxindex < 0)
						continue;		// must've gone missing
					inst.active_effect_flags[fxindex] = world["fx"][i]["active"];
					inst.effect_params[fxindex] = world["fx"][i]["params"];
				}
			}
			inst.updateActiveEffects();
		}
		obehs = o["behs"];
		if (obehs)
		{
			for (p in obehs)
			{
				if (obehs.hasOwnProperty(p))
				{
					behindex = this.getBehaviorIndexBySid(inst, parseInt(p, 10));
					if (behindex < 0)
						continue;		// must've gone missing
					inst.behavior_insts[behindex].loadFromJSON(obehs[p]);
				}
			}
		}
		if (o["data"])
			inst.loadFromJSON(o["data"]);
	};
	cr.runtime = Runtime;
	cr.createRuntime = function (canvasid)
	{
		return new Runtime(document.getElementById(canvasid));
	};
	cr.createDCRuntime = function (w, h)
	{
		return new Runtime({ "dc": true, "width": w, "height": h });
	};
	window["cr_createRuntime"] = cr.createRuntime;
	window["cr_createDCRuntime"] = cr.createDCRuntime;
	window["createCocoonJSRuntime"] = function ()
	{
		window["c2cocoonjs"] = true;
		var canvas = document.createElement("screencanvas") || document.createElement("canvas");
		document.body.appendChild(canvas);
		var rt = new Runtime(canvas);
		window["c2runtime"] = rt;
		window.addEventListener("orientationchange", function () {
			window["c2runtime"]["setSize"](window.innerWidth, window.innerHeight);
		});
		window["c2runtime"]["setSize"](window.innerWidth, window.innerHeight);
		return rt;
	};
}());
window["cr_getC2Runtime"] = function()
{
	var canvas = document.getElementById("c2canvas");
	if (canvas)
		return canvas["c2runtime"];
	else if (window["c2runtime"])
		return window["c2runtime"];
	else
		return null;
}
window["cr_sizeCanvas"] = function(w, h)
{
	if (w === 0 || h === 0)
		return;
	var runtime = window["cr_getC2Runtime"]();
	if (runtime)
		runtime["setSize"](w, h);
}
window["cr_setSuspended"] = function(s)
{
	var runtime = window["cr_getC2Runtime"]();
	if (runtime)
		runtime["setSuspended"](s);
}
;
(function()
{
	function Layout(runtime, m)
	{
		this.runtime = runtime;
		this.event_sheet = null;
		this.scrollX = (this.runtime.original_width / 2);
		this.scrollY = (this.runtime.original_height / 2);
		this.scale = 1.0;
		this.angle = 0;
		this.first_visit = true;
		this.name = m[0];
		this.width = m[1];
		this.height = m[2];
		this.unbounded_scrolling = m[3];
		this.sheetname = m[4];
		this.sid = m[5];
		var lm = m[6];
		var i, len;
		this.layers = [];
		this.initial_types = [];
		for (i = 0, len = lm.length; i < len; i++)
		{
			var layer = new cr.layer(this, lm[i]);
			layer.number = i;
			cr.seal(layer);
			this.layers.push(layer);
		}
		var im = m[7];
		this.initial_nonworld = [];
		for (i = 0, len = im.length; i < len; i++)
		{
			var inst = im[i];
			var type = this.runtime.types_by_index[inst[1]];
;
			if (!type.default_instance)
				type.default_instance = inst;
			this.initial_nonworld.push(inst);
			if (this.initial_types.indexOf(type) === -1)
				this.initial_types.push(type);
		}
		this.effect_types = [];
		this.active_effect_types = [];
		this.effect_params = [];
		for (i = 0, len = m[8].length; i < len; i++)
		{
			this.effect_types.push({
				id: m[8][i][0],
				name: m[8][i][1],
				shaderindex: -1,
				active: true,
				index: i
			});
			this.effect_params.push(m[8][i][2].slice(0));
		}
		this.updateActiveEffects();
		this.rcTex = new cr.rect(0, 0, 1, 1);
		this.rcTex2 = new cr.rect(0, 0, 1, 1);
		this.persist_data = {};
	};
	Layout.prototype.saveObjectToPersist = function (inst)
	{
		var sidStr = inst.type.sid.toString();
		if (!this.persist_data.hasOwnProperty(sidStr))
			this.persist_data[sidStr] = [];
		var type_persist = this.persist_data[sidStr];
		type_persist.push(this.runtime.saveInstanceToJSON(inst));
	};
	Layout.prototype.hasOpaqueBottomLayer = function ()
	{
		var layer = this.layers[0];
		return !layer.transparent && layer.opacity === 1.0 && !layer.forceOwnTexture && layer.visible;
	};
	Layout.prototype.updateActiveEffects = function ()
	{
		this.active_effect_types.length = 0;
		var i, len, et;
		for (i = 0, len = this.effect_types.length; i < len; i++)
		{
			et = this.effect_types[i];
			if (et.active)
				this.active_effect_types.push(et);
		}
	};
	Layout.prototype.getEffectByName = function (name_)
	{
		var i, len, et;
		for (i = 0, len = this.effect_types.length; i < len; i++)
		{
			et = this.effect_types[i];
			if (et.name === name_)
				return et;
		}
		return null;
	};
	var created_instances = [];
	Layout.prototype.startRunning = function ()
	{
		if (this.sheetname)
		{
			this.event_sheet = this.runtime.eventsheets[this.sheetname];
;
		}
		this.runtime.running_layout = this;
		this.scrollX = (this.runtime.original_width / 2);
		this.scrollY = (this.runtime.original_height / 2);
		var i, k, len, lenk, type, type_instances, inst, iid, t, s, p, q, type_data, layer;
		for (i = 0, len = this.runtime.types_by_index.length; i < len; i++)
		{
			type = this.runtime.types_by_index[i];
			if (type.is_family)
				continue;		// instances are only transferred for their real type
			type_instances = type.instances;
			for (k = 0, lenk = type_instances.length; k < lenk; k++)
			{
				inst = type_instances[k];
				if (inst.layer)
				{
					var num = inst.layer.number;
					if (num >= this.layers.length)
						num = this.layers.length - 1;
					inst.layer = this.layers[num];
					inst.layer.instances.push(inst);
					inst.layer.zindices_stale = true;
				}
			}
		}
		var layer;
		created_instances.length = 0;
		this.boundScrolling();
		for (i = 0, len = this.layers.length; i < len; i++)
		{
			layer = this.layers[i];
			layer.createInitialInstances();		// fills created_instances
			layer.disableAngle = true;
			var px = layer.canvasToLayer(0, 0, true);
			var py = layer.canvasToLayer(0, 0, false);
			layer.disableAngle = false;
			if (this.runtime.pixel_rounding)
			{
				px = (px + 0.5) | 0;
				py = (py + 0.5) | 0;
			}
			layer.rotateViewport(px, py, null);
		}
		var uids_changed = false;
		if (!this.first_visit)
		{
			for (p in this.persist_data)
			{
				if (this.persist_data.hasOwnProperty(p))
				{
					type = this.runtime.getObjectTypeBySid(parseInt(p, 10));
					if (!type || type.is_family || !this.runtime.typeHasPersistBehavior(type))
						continue;
					type_data = this.persist_data[p];
					for (i = 0, len = type_data.length; i < len; i++)
					{
						layer = null;
						if (type.plugin.is_world)
						{
							layer = this.getLayerBySid(type_data[i]["w"]["l"]);
							if (!layer)
								continue;
						}
						inst = this.runtime.createInstanceFromInit(type.default_instance, layer, false, 0, 0, true);
						this.runtime.loadInstanceFromJSON(inst, type_data[i]);
						uids_changed = true;
						created_instances.push(inst);
					}
					type_data.length = 0;
				}
			}
			for (i = 0, len = this.layers.length; i < len; i++)
			{
				this.layers[i].instances.sort(sortInstanceByZIndex);
				this.layers[i].zindices_stale = true;		// in case of duplicates/holes
			}
		}
		if (uids_changed)
		{
			this.runtime.ClearDeathRow();
			this.runtime.refreshUidMap();
		}
		for (i = 0; i < created_instances.length; i++)
		{
			inst = created_instances[i];
			if (!inst.type.is_contained)
				continue;
			iid = inst.get_iid();
			for (k = 0, lenk = inst.type.container.length; k < lenk; k++)
			{
				t = inst.type.container[k];
				if (inst.type === t)
					continue;
				if (t.instances.length > iid)
					inst.siblings.push(t.instances[iid]);
				else
				{
					if (!t.default_instance)
					{
					}
					else
					{
						s = this.runtime.createInstanceFromInit(t.default_instance, inst.layer, true, inst.x, inst.y, true);
						this.runtime.ClearDeathRow();
						t.updateIIDs();
						inst.siblings.push(s);
						created_instances.push(s);		// come back around and link up its own instances too
					}
				}
			}
		}
		for (i = 0, len = this.initial_nonworld.length; i < len; i++)
		{
			inst = this.runtime.createInstanceFromInit(this.initial_nonworld[i], null, true);
;
		}
		this.runtime.changelayout = null;
		this.runtime.ClearDeathRow();
		if (this.runtime.ctx && !this.runtime.isDomFree)
		{
			for (i = 0, len = this.runtime.types_by_index.length; i < len; i++)
			{
				t = this.runtime.types_by_index[i];
				if (t.is_family || !t.instances.length || !t.preloadCanvas2D)
					continue;
				t.preloadCanvas2D(this.runtime.ctx);
			}
		}
		/*
		if (this.runtime.glwrap)
		{
			console.log("Estimated VRAM at layout start: " + this.runtime.glwrap.textureCount() + " textures, approx. " + Math.round(this.runtime.glwrap.estimateVRAM() / 1024) + " kb");
		}
		*/
		for (i = 0, len = created_instances.length; i < len; i++)
		{
			inst = created_instances[i];
			this.runtime.trigger(Object.getPrototypeOf(inst.type.plugin).cnds.OnCreated, inst);
		}
		created_instances.length = 0;
		this.runtime.trigger(cr.system_object.prototype.cnds.OnLayoutStart, null);
		this.first_visit = false;
	};
	Layout.prototype.createGlobalNonWorlds = function ()
	{
		var i, k, len, initial_inst, inst, type;
		for (i = 0, k = 0, len = this.initial_nonworld.length; i < len; i++)
		{
			initial_inst = this.initial_nonworld[i];
			type = this.runtime.types_by_index[initial_inst[1]];
			if (type.global)
				inst = this.runtime.createInstanceFromInit(initial_inst, null, true);
			else
			{
				this.initial_nonworld[k] = initial_inst;
				k++;
			}
		}
		this.initial_nonworld.length = k;
	};
	Layout.prototype.stopRunning = function ()
	{
;
		/*
		if (this.runtime.glwrap)
		{
			console.log("Estimated VRAM at layout end: " + this.runtime.glwrap.textureCount() + " textures, approx. " + Math.round(this.runtime.glwrap.estimateVRAM() / 1024) + " kb");
		}
		*/
		this.runtime.trigger(cr.system_object.prototype.cnds.OnLayoutEnd, null);
		this.runtime.system.waits.length = 0;
		var i, leni, j, lenj;
		var layer_instances, inst, type;
		for (i = 0, leni = this.layers.length; i < leni; i++)
		{
			layer_instances = this.layers[i].instances;
			for (j = 0, lenj = layer_instances.length; j < lenj; j++)
			{
				inst = layer_instances[j];
				if (!inst.type.global)
				{
					if (this.runtime.typeHasPersistBehavior(inst.type))
						this.saveObjectToPersist(inst);
					this.runtime.DestroyInstance(inst);
				}
			}
			this.runtime.ClearDeathRow();
			layer_instances.length = 0;
			this.layers[i].zindices_stale = true;
		}
		for (i = 0, leni = this.runtime.types_by_index.length; i < leni; i++)
		{
			type = this.runtime.types_by_index[i];
			if (type.global || type.plugin.is_world || type.plugin.singleglobal || type.is_family)
				continue;
			for (j = 0, lenj = type.instances.length; j < lenj; j++)
				this.runtime.DestroyInstance(type.instances[j]);
			this.runtime.ClearDeathRow();
		}
	};
	Layout.prototype.draw = function (ctx)
	{
		ctx.globalAlpha = 1;
		ctx.globalCompositeOperation = "source-over";
		if (this.runtime.alphaBackground && !this.hasOpaqueBottomLayer())
			ctx.clearRect(0, 0, this.runtime.width, this.runtime.height);
		var i, len, l;
		for (i = 0, len = this.layers.length; i < len; i++)
		{
			l = this.layers[i];
			if (l.visible && l.opacity > 0 && l.blend_mode !== 11)
				l.draw(ctx);
		}
	};
	Layout.prototype.drawGL = function (glw)
	{
		var render_to_texture = (this.active_effect_types.length > 0 || this.runtime.uses_background_blending);
		if (render_to_texture)
		{
			if (!this.runtime.layout_tex)
			{
				this.runtime.layout_tex = glw.createEmptyTexture(this.runtime.width, this.runtime.height, this.runtime.linearSampling);
			}
			if (this.runtime.layout_tex.c2width !== this.runtime.width || this.runtime.layout_tex.c2height !== this.runtime.height)
			{
				glw.deleteTexture(this.runtime.layout_tex);
				this.runtime.layout_tex = glw.createEmptyTexture(this.runtime.width, this.runtime.height, this.runtime.linearSampling);
			}
			glw.setRenderingToTexture(this.runtime.layout_tex);
		}
		if (this.runtime.alphaBackground && !this.hasOpaqueBottomLayer())
			glw.clear(0, 0, 0, 0);
		var i, len;
		for (i = 0, len = this.layers.length; i < len; i++)
		{
			if (this.layers[i].visible && this.layers[i].opacity > 0)
				this.layers[i].drawGL(glw);
		}
		if (render_to_texture)
		{
			if (this.active_effect_types.length <= 1)
			{
				if (this.active_effect_types.length === 1)
				{
					var etindex = this.active_effect_types[0].index;
					glw.switchProgram(this.active_effect_types[0].shaderindex);
					glw.setProgramParameters(null,								// backTex
											 1.0 / this.runtime.width,			// pixelWidth
											 1.0 / this.runtime.height,			// pixelHeight
											 0.0, 0.0,							// destStart
											 1.0, 1.0,							// destEnd
											 this.scale,						// layerScale
											 this.effect_params[etindex]);		// fx parameters
					if (glw.programIsAnimated(this.active_effect_types[0].shaderindex))
						this.runtime.redraw = true;
				}
				else
					glw.switchProgram(0);
				glw.setRenderingToTexture(null);				// to backbuffer
				glw.setOpacity(1);
				glw.setTexture(this.runtime.layout_tex);
				glw.setAlphaBlend();
				glw.resetModelView();
				glw.updateModelView();
				var halfw = this.runtime.width / 2;
				var halfh = this.runtime.height / 2;
				glw.quad(-halfw, halfh, halfw, halfh, halfw, -halfh, -halfw, -halfh);
				glw.setTexture(null);
			}
			else
			{
				this.renderEffectChain(glw, null, null, null);
			}
		}
	};
	Layout.prototype.getRenderTarget = function()
	{
		return (this.active_effect_types.length > 0 || this.runtime.uses_background_blending) ? this.runtime.layout_tex : null;
	};
	Layout.prototype.getMinLayerScale = function ()
	{
		var m = this.layers[0].getScale();
		var i, len, l;
		for (i = 1, len = this.layers.length; i < len; i++)
		{
			l = this.layers[i];
			if (l.parallaxX === 0 && l.parallaxY === 0)
				continue;
			if (l.getScale() < m)
				m = l.getScale();
		}
		return m;
	};
	Layout.prototype.scrollToX = function (x)
	{
		if (!this.unbounded_scrolling)
		{
			var widthBoundary = (this.runtime.width * (1 / this.getMinLayerScale()) / 2);
			if (x > this.width - widthBoundary)
				x = this.width - widthBoundary;
			if (x < widthBoundary)
				x = widthBoundary;
		}
		if (this.scrollX !== x)
		{
			this.scrollX = x;
			this.runtime.redraw = true;
		}
	};
	Layout.prototype.scrollToY = function (y)
	{
		if (!this.unbounded_scrolling)
		{
			var heightBoundary = (this.runtime.height * (1 / this.getMinLayerScale()) / 2);
			if (y > this.height - heightBoundary)
				y = this.height - heightBoundary;
			if (y < heightBoundary)
				y = heightBoundary;
		}
		if (this.scrollY !== y)
		{
			this.scrollY = y;
			this.runtime.redraw = true;
		}
	};
	Layout.prototype.boundScrolling = function ()
	{
		this.scrollToX(this.scrollX);
		this.scrollToY(this.scrollY);
	};
	Layout.prototype.renderEffectChain = function (glw, layer, inst, rendertarget)
	{
		var active_effect_types = inst ?
							inst.active_effect_types :
							layer ?
								layer.active_effect_types :
								this.active_effect_types;
		var layerScale = inst ? inst.layer.getScale() :
							layer ? layer.getScale() : 1;
		var fx_tex = this.runtime.fx_tex;
		var i, len, last, temp, fx_index = 0, other_fx_index = 1;
		var y, h;
		var windowWidth = this.runtime.width;
		var windowHeight = this.runtime.height;
		var halfw = windowWidth / 2;
		var halfh = windowHeight / 2;
		var rcTex = layer ? layer.rcTex : this.rcTex;
		var rcTex2 = layer ? layer.rcTex2 : this.rcTex2;
		var screenleft = 0, clearleft = 0;
		var screentop = 0, cleartop = 0;
		var screenright = windowWidth, clearright = windowWidth;
		var screenbottom = windowHeight, clearbottom = windowHeight;
		var boxExtendHorizontal = 0;
		var boxExtendVertical = 0;
		var inst_layer_angle = inst ? inst.layer.getAngle() : 0;
		if (inst)
		{
			for (i = 0, len = active_effect_types.length; i < len; i++)
			{
				boxExtendHorizontal += glw.getProgramBoxExtendHorizontal(active_effect_types[i].shaderindex);
				boxExtendVertical += glw.getProgramBoxExtendVertical(active_effect_types[i].shaderindex);
			}
			var bbox = inst.bbox;
			screenleft = layer.layerToCanvas(bbox.left, bbox.top, true);
			screentop = layer.layerToCanvas(bbox.left, bbox.top, false);
			screenright = layer.layerToCanvas(bbox.right, bbox.bottom, true);
			screenbottom = layer.layerToCanvas(bbox.right, bbox.bottom, false);
			if (inst_layer_angle !== 0)
			{
				var screentrx = layer.layerToCanvas(bbox.right, bbox.top, true);
				var screentry = layer.layerToCanvas(bbox.right, bbox.top, false);
				var screenblx = layer.layerToCanvas(bbox.left, bbox.bottom, true);
				var screenbly = layer.layerToCanvas(bbox.left, bbox.bottom, false);
				temp = cr.min(screenleft, screenright, screentrx, screenblx);
				screenright = cr.max(screenleft, screenright, screentrx, screenblx);
				screenleft = temp;
				temp = cr.min(screentop, screenbottom, screentry, screenbly);
				screenbottom = cr.max(screentop, screenbottom, screentry, screenbly);
				screentop = temp;
			}
			screenleft -= boxExtendHorizontal;
			screentop -= boxExtendVertical;
			screenright += boxExtendHorizontal;
			screenbottom += boxExtendVertical;
			rcTex2.left = screenleft / windowWidth;
			rcTex2.top = 1 - screentop / windowHeight;
			rcTex2.right = screenright / windowWidth;
			rcTex2.bottom = 1 - screenbottom / windowHeight;
			clearleft = screenleft = cr.floor(screenleft);
			cleartop = screentop = cr.floor(screentop);
			clearright = screenright = cr.ceil(screenright);
			clearbottom = screenbottom = cr.ceil(screenbottom);
			clearleft -= boxExtendHorizontal;
			cleartop -= boxExtendVertical;
			clearright += boxExtendHorizontal;
			clearbottom += boxExtendVertical;
			if (screenleft < 0)					screenleft = 0;
			if (screentop < 0)					screentop = 0;
			if (screenright > windowWidth)		screenright = windowWidth;
			if (screenbottom > windowHeight)	screenbottom = windowHeight;
			if (clearleft < 0)					clearleft = 0;
			if (cleartop < 0)					cleartop = 0;
			if (clearright > windowWidth)		clearright = windowWidth;
			if (clearbottom > windowHeight)		clearbottom = windowHeight;
			rcTex.left = screenleft / windowWidth;
			rcTex.top = 1 - screentop / windowHeight;
			rcTex.right = screenright / windowWidth;
			rcTex.bottom = 1 - screenbottom / windowHeight;
		}
		else
		{
			rcTex.left = rcTex2.left = 0;
			rcTex.top = rcTex2.top = 0;
			rcTex.right = rcTex2.right = 1;
			rcTex.bottom = rcTex2.bottom = 1;
		}
		var pre_draw = (inst && (((inst.angle || inst_layer_angle) && glw.programUsesDest(active_effect_types[0].shaderindex)) || boxExtendHorizontal !== 0 || boxExtendVertical !== 0 || inst.opacity !== 1 || inst.type.plugin.must_predraw)) || (layer && !inst && layer.opacity !== 1);
		glw.setAlphaBlend();
		if (pre_draw)
		{
			if (!fx_tex[fx_index])
			{
				fx_tex[fx_index] = glw.createEmptyTexture(windowWidth, windowHeight, this.runtime.linearSampling);
			}
			if (fx_tex[fx_index].c2width !== windowWidth || fx_tex[fx_index].c2height !== windowHeight)
			{
				glw.deleteTexture(fx_tex[fx_index]);
				fx_tex[fx_index] = glw.createEmptyTexture(windowWidth, windowHeight, this.runtime.linearSampling);
			}
			glw.switchProgram(0);
			glw.setRenderingToTexture(fx_tex[fx_index]);
			h = clearbottom - cleartop;
			y = (windowHeight - cleartop) - h;
			glw.clearRect(clearleft, y, clearright - clearleft, h);
			if (inst)
			{
				inst.drawGL(glw);
			}
			else
			{
				glw.setTexture(this.runtime.layer_tex);
				glw.setOpacity(layer.opacity);
				glw.resetModelView();
				glw.translate(-halfw, -halfh);
				glw.updateModelView();
				glw.quadTex(screenleft, screenbottom, screenright, screenbottom, screenright, screentop, screenleft, screentop, rcTex);
			}
			rcTex2.left = rcTex2.top = 0;
			rcTex2.right = rcTex2.bottom = 1;
			if (inst)
			{
				temp = rcTex.top;
				rcTex.top = rcTex.bottom;
				rcTex.bottom = temp;
			}
			fx_index = 1;
			other_fx_index = 0;
		}
		glw.setOpacity(1);
		var last = active_effect_types.length - 1;
		var post_draw = glw.programUsesCrossSampling(active_effect_types[last].shaderindex);
		var etindex = 0;
		for (i = 0, len = active_effect_types.length; i < len; i++)
		{
			if (!fx_tex[fx_index])
			{
				fx_tex[fx_index] = glw.createEmptyTexture(windowWidth, windowHeight, this.runtime.linearSampling);
			}
			if (fx_tex[fx_index].c2width !== windowWidth || fx_tex[fx_index].c2height !== windowHeight)
			{
				glw.deleteTexture(fx_tex[fx_index]);
				fx_tex[fx_index] = glw.createEmptyTexture(windowWidth, windowHeight, this.runtime.linearSampling);
			}
			glw.switchProgram(active_effect_types[i].shaderindex);
			etindex = active_effect_types[i].index;
			if (glw.programIsAnimated(active_effect_types[i].shaderindex))
				this.runtime.redraw = true;
			if (i == 0 && !pre_draw)
			{
				glw.setRenderingToTexture(fx_tex[fx_index]);
				h = clearbottom - cleartop;
				y = (windowHeight - cleartop) - h;
				glw.clearRect(clearleft, y, clearright - clearleft, h);
				if (inst)
				{
					glw.setProgramParameters(rendertarget,					// backTex
											 1.0 / inst.width,				// pixelWidth
											 1.0 / inst.height,				// pixelHeight
											 rcTex2.left, rcTex2.top,		// destStart
											 rcTex2.right, rcTex2.bottom,	// destEnd
											 layerScale,
											 inst.effect_params[etindex]);	// fx params
					inst.drawGL(glw);
				}
				else
				{
					glw.setProgramParameters(rendertarget,					// backTex
											 1.0 / windowWidth,				// pixelWidth
											 1.0 / windowHeight,			// pixelHeight
											 0.0, 0.0,						// destStart
											 1.0, 1.0,						// destEnd
											 layerScale,
											 layer ?						// fx params
												layer.effect_params[etindex] :
												this.effect_params[etindex]);
					glw.setTexture(layer ? this.runtime.layer_tex : this.runtime.layout_tex);
					glw.resetModelView();
					glw.translate(-halfw, -halfh);
					glw.updateModelView();
					glw.quadTex(screenleft, screenbottom, screenright, screenbottom, screenright, screentop, screenleft, screentop, rcTex);
				}
				rcTex2.left = rcTex2.top = 0;
				rcTex2.right = rcTex2.bottom = 1;
				if (inst && !post_draw)
				{
					temp = screenbottom;
					screenbottom = screentop;
					screentop = temp;
				}
			}
			else
			{
				glw.setProgramParameters(rendertarget,						// backTex
										 1.0 / windowWidth,					// pixelWidth
										 1.0 / windowHeight,				// pixelHeight
										 rcTex2.left, rcTex2.top,			// destStart
										 rcTex2.right, rcTex2.bottom,		// destEnd
										 layerScale,
										 inst ?								// fx params
											inst.effect_params[etindex] :
											layer ?
												layer.effect_params[etindex] :
												this.effect_params[etindex]);
				glw.setTexture(null);
				if (i === last && !post_draw)
				{
					if (inst)
						glw.setBlend(inst.srcBlend, inst.destBlend);
					else if (layer)
						glw.setBlend(layer.srcBlend, layer.destBlend);
					glw.setRenderingToTexture(rendertarget);
				}
				else
				{
					glw.setRenderingToTexture(fx_tex[fx_index]);
					h = clearbottom - cleartop;
					y = (windowHeight - cleartop) - h;
					glw.clearRect(clearleft, y, clearright - clearleft, h);
				}
				glw.setTexture(fx_tex[other_fx_index]);
				glw.resetModelView();
				glw.translate(-halfw, -halfh);
				glw.updateModelView();
				glw.quadTex(screenleft, screenbottom, screenright, screenbottom, screenright, screentop, screenleft, screentop, rcTex);
				if (i === last && !post_draw)
					glw.setTexture(null);
			}
			fx_index = (fx_index === 0 ? 1 : 0);
			other_fx_index = (fx_index === 0 ? 1 : 0);		// will be opposite to fx_index since it was just assigned
		}
		if (post_draw)
		{
			glw.switchProgram(0);
			if (inst)
				glw.setBlend(inst.srcBlend, inst.destBlend);
			else if (layer)
				glw.setBlend(layer.srcBlend, layer.destBlend);
			glw.setRenderingToTexture(rendertarget);
			glw.setTexture(fx_tex[other_fx_index]);
			glw.resetModelView();
			glw.translate(-halfw, -halfh);
			glw.updateModelView();
			if (inst && active_effect_types.length === 1 && !pre_draw)
				glw.quadTex(screenleft, screentop, screenright, screentop, screenright, screenbottom, screenleft, screenbottom, rcTex);
			else
				glw.quadTex(screenleft, screenbottom, screenright, screenbottom, screenright, screentop, screenleft, screentop, rcTex);
			glw.setTexture(null);
		}
	};
	Layout.prototype.getLayerBySid = function (sid_)
	{
		var i, len;
		for (i = 0, len = this.layers.length; i < len; i++)
		{
			if (this.layers[i].sid === sid_)
				return this.layers[i];
		}
		return null;
	};
	Layout.prototype.saveToJSON = function ()
	{
		var i, len, layer, et;
		var o = {
			"sx": this.scrollX,
			"sy": this.scrollY,
			"s": this.scale,
			"a": this.angle,
			"w": this.width,
			"h": this.height,
			"fv": this.first_visit,			// added r127
			"persist": this.persist_data,
			"fx": [],
			"layers": {}
		};
		for (i = 0, len = this.effect_types.length; i < len; i++)
		{
			et = this.effect_types[i];
			o["fx"].push({"name": et.name, "active": et.active, "params": this.effect_params[et.index] });
		}
		for (i = 0, len = this.layers.length; i < len; i++)
		{
			layer = this.layers[i];
			o["layers"][layer.sid.toString()] = layer.saveToJSON();
		}
		return o;
	};
	Layout.prototype.loadFromJSON = function (o)
	{
		var i, len, fx, p, layer;
		this.scrollX = o["sx"];
		this.scrollY = o["sy"];
		this.scale = o["s"];
		this.angle = o["a"];
		this.width = o["w"];
		this.height = o["h"];
		this.persist_data = o["persist"];
		if (typeof o["fv"] !== "undefined")
			this.first_visit = o["fv"];
		var ofx = o["fx"];
		for (i = 0, len = ofx.length; i < len; i++)
		{
			fx = this.getEffectByName(ofx[i]["name"]);
			if (!fx)
				continue;		// must've gone missing
			fx.active = ofx[i]["active"];
			this.effect_params[fx.index] = ofx[i]["params"];
		}
		this.updateActiveEffects();
		var olayers = o["layers"];
		for (p in olayers)
		{
			if (olayers.hasOwnProperty(p))
			{
				layer = this.getLayerBySid(parseInt(p, 10));
				if (!layer)
					continue;		// must've gone missing
				layer.loadFromJSON(olayers[p]);
			}
		}
	};
	cr.layout = Layout;
	function Layer(layout, m)
	{
		this.layout = layout;
		this.runtime = layout.runtime;
		this.instances = [];        // running instances
		this.scale = 1.0;
		this.angle = 0;
		this.disableAngle = false;
		this.tmprect = new cr.rect(0, 0, 0, 0);
		this.tmpquad = new cr.quad();
		this.viewLeft = 0;
		this.viewRight = 0;
		this.viewTop = 0;
		this.viewBottom = 0;
		this.zindices_stale = false;
		this.name = m[0];
		this.index = m[1];
		this.sid = m[2];
		this.visible = m[3];		// initially visible
		this.background_color = m[4];
		this.transparent = m[5];
		this.parallaxX = m[6];
		this.parallaxY = m[7];
		this.opacity = m[8];
		this.forceOwnTexture = m[9];
		this.zoomRate = m[10];
		this.blend_mode = m[11];
		this.effect_fallback = m[12];
		this.compositeOp = "source-over";
		this.srcBlend = 0;
		this.destBlend = 0;
		this.render_offscreen = false;
		var im = m[13];
		var i, len;
		this.initial_instances = [];
		for (i = 0, len = im.length; i < len; i++)
		{
			var inst = im[i];
			var type = this.runtime.types_by_index[inst[1]];
;
			if (!type.default_instance)
				type.default_instance = inst;
			this.initial_instances.push(inst);
			if (this.layout.initial_types.indexOf(type) === -1)
				this.layout.initial_types.push(type);
		}
		this.effect_types = [];
		this.active_effect_types = [];
		this.effect_params = [];
		for (i = 0, len = m[14].length; i < len; i++)
		{
			this.effect_types.push({
				id: m[14][i][0],
				name: m[14][i][1],
				shaderindex: -1,
				active: true,
				index: i
			});
			this.effect_params.push(m[14][i][2].slice(0));
		}
		this.updateActiveEffects();
		this.rcTex = new cr.rect(0, 0, 1, 1);
		this.rcTex2 = new cr.rect(0, 0, 1, 1);
	};
	Layer.prototype.updateActiveEffects = function ()
	{
		this.active_effect_types.length = 0;
		var i, len, et;
		for (i = 0, len = this.effect_types.length; i < len; i++)
		{
			et = this.effect_types[i];
			if (et.active)
				this.active_effect_types.push(et);
		}
	};
	Layer.prototype.getEffectByName = function (name_)
	{
		var i, len, et;
		for (i = 0, len = this.effect_types.length; i < len; i++)
		{
			et = this.effect_types[i];
			if (et.name === name_)
				return et;
		}
		return null;
	};
	Layer.prototype.createInitialInstances = function ()
	{
		var i, k, len, inst, initial_inst, type, keep, hasPersistBehavior;
		for (i = 0, k = 0, len = this.initial_instances.length; i < len; i++)
		{
			initial_inst = this.initial_instances[i];
			type = this.runtime.types_by_index[initial_inst[1]];
;
			hasPersistBehavior = this.runtime.typeHasPersistBehavior(type);
			keep = true;
			if (!hasPersistBehavior || this.layout.first_visit)
			{
				inst = this.runtime.createInstanceFromInit(initial_inst, this, true);
;
				created_instances.push(inst);
				if (inst.type.global)
					keep = false;
			}
			if (keep)
			{
				this.initial_instances[k] = this.initial_instances[i];
				k++;
			}
		}
		this.initial_instances.length = k;
		this.runtime.ClearDeathRow();		// flushes creation row so IIDs will be correct
		if (!this.runtime.glwrap && this.effect_types.length)	// no WebGL renderer and shaders used
			this.blend_mode = this.effect_fallback;				// use fallback blend mode
		this.compositeOp = cr.effectToCompositeOp(this.blend_mode);
		if (this.runtime.gl)
			cr.setGLBlend(this, this.blend_mode, this.runtime.gl);
	};
	Layer.prototype.updateZIndices = function ()
	{
		if (!this.zindices_stale)
			return;
		var i, len;
		for (i = 0, len = this.instances.length; i < len; i++)
		{
;
;
			this.instances[i].zindex = i;
		}
		this.zindices_stale = false;
	};
	Layer.prototype.getScale = function ()
	{
		return this.getNormalScale() * this.runtime.aspect_scale;
	};
	Layer.prototype.getNormalScale = function ()
	{
		return ((this.scale * this.layout.scale) - 1) * this.zoomRate + 1;
	};
	Layer.prototype.getAngle = function ()
	{
		if (this.disableAngle)
			return 0;
		return cr.clamp_angle(this.layout.angle + this.angle);
	};
	Layer.prototype.draw = function (ctx)
	{
		this.render_offscreen = (this.forceOwnTexture || this.opacity !== 1.0 || this.blend_mode !== 0);
		var layer_canvas = this.runtime.canvas;
		var layer_ctx = ctx;
		ctx.globalAlpha = 1;
		ctx.globalCompositeOperation = "source-over";
		if (this.render_offscreen)
		{
			if (!this.runtime.layer_canvas)
			{
				this.runtime.layer_canvas = document.createElement("canvas");
;
				layer_canvas = this.runtime.layer_canvas;
				layer_canvas.width = this.runtime.width;
				layer_canvas.height = this.runtime.height;
				this.runtime.layer_ctx = layer_canvas.getContext("2d");
;
			}
			layer_canvas = this.runtime.layer_canvas;
			layer_ctx = this.runtime.layer_ctx;
			if (layer_canvas.width !== this.runtime.width)
				layer_canvas.width = this.runtime.width;
			if (layer_canvas.height !== this.runtime.height)
				layer_canvas.height = this.runtime.height;
			if (this.transparent)
				layer_ctx.clearRect(0, 0, this.runtime.width, this.runtime.height);
		}
		if (!this.transparent)
		{
			layer_ctx.fillStyle = "rgb(" + this.background_color[0] + "," + this.background_color[1] + "," + this.background_color[2] + ")";
			layer_ctx.fillRect(0, 0, this.runtime.width, this.runtime.height);
		}
		layer_ctx.save();
		this.disableAngle = true;
		var px = this.canvasToLayer(0, 0, true);
		var py = this.canvasToLayer(0, 0, false);
		this.disableAngle = false;
		if (this.runtime.pixel_rounding)
		{
			px = (px + 0.5) | 0;
			py = (py + 0.5) | 0;
		}
		this.rotateViewport(px, py, layer_ctx);
		var myscale = this.getScale();
		layer_ctx.scale(myscale, myscale);
		layer_ctx.translate(-px, -py);
		var i, len, inst, bbox;
		for (i = 0, len = this.instances.length; i < len; i++)
		{
			inst = this.instances[i];
			if (!inst.visible || inst.width === 0 || inst.height === 0)
				continue;
			inst.update_bbox();
			bbox = inst.bbox;
			if (bbox.right < this.viewLeft || bbox.bottom < this.viewTop || bbox.left > this.viewRight || bbox.top > this.viewBottom)
				continue;
			layer_ctx.globalCompositeOperation = inst.compositeOp;
			inst.draw(layer_ctx);
		}
		layer_ctx.restore();
		if (this.render_offscreen)
		{
			ctx.globalCompositeOperation = this.compositeOp;
			ctx.globalAlpha = this.opacity;
			ctx.drawImage(layer_canvas, 0, 0);
		}
	};
	Layer.prototype.rotateViewport = function (px, py, ctx)
	{
		var myscale = this.getScale();
		this.viewLeft = px;
		this.viewTop = py;
		this.viewRight = px + (this.runtime.width * (1 / myscale));
		this.viewBottom = py + (this.runtime.height * (1 / myscale));
		var myAngle = this.getAngle();
		if (myAngle !== 0)
		{
			if (ctx)
			{
				ctx.translate(this.runtime.width / 2, this.runtime.height / 2);
				ctx.rotate(-myAngle);
				ctx.translate(this.runtime.width / -2, this.runtime.height / -2);
			}
			this.tmprect.set(this.viewLeft, this.viewTop, this.viewRight, this.viewBottom);
			this.tmprect.offset((this.viewLeft + this.viewRight) / -2, (this.viewTop + this.viewBottom) / -2);
			this.tmpquad.set_from_rotated_rect(this.tmprect, myAngle);
			this.tmpquad.bounding_box(this.tmprect);
			this.tmprect.offset((this.viewLeft + this.viewRight) / 2, (this.viewTop + this.viewBottom) / 2);
			this.viewLeft = this.tmprect.left;
			this.viewTop = this.tmprect.top;
			this.viewRight = this.tmprect.right;
			this.viewBottom = this.tmprect.bottom;
		}
	}
	Layer.prototype.drawGL = function (glw)
	{
		var windowWidth = this.runtime.width;
		var windowHeight = this.runtime.height;
		var shaderindex = 0;
		var etindex = 0;
		this.render_offscreen = (this.forceOwnTexture || this.opacity !== 1.0 || this.active_effect_types.length > 0 || this.blend_mode !== 0);
		if (this.render_offscreen)
		{
			if (!this.runtime.layer_tex)
			{
				this.runtime.layer_tex = glw.createEmptyTexture(this.runtime.width, this.runtime.height, this.runtime.linearSampling);
			}
			if (this.runtime.layer_tex.c2width !== this.runtime.width || this.runtime.layer_tex.c2height !== this.runtime.height)
			{
				glw.deleteTexture(this.runtime.layer_tex);
				this.runtime.layer_tex = glw.createEmptyTexture(this.runtime.width, this.runtime.height, this.runtime.linearSampling);
			}
			glw.setRenderingToTexture(this.runtime.layer_tex);
			if (this.transparent)
				glw.clear(0, 0, 0, 0);
		}
		if (!this.transparent)
		{
			glw.clear(this.background_color[0] / 255, this.background_color[1] / 255, this.background_color[2] / 255, 1);
		}
		this.disableAngle = true;
		var px = this.canvasToLayer(0, 0, true);
		var py = this.canvasToLayer(0, 0, false);
		this.disableAngle = false;
		if (this.runtime.pixel_rounding)
		{
			px = (px + 0.5) | 0;
			py = (py + 0.5) | 0;
		}
		this.rotateViewport(px, py, null);
		var myscale = this.getScale();
		glw.resetModelView();
		glw.scale(myscale, myscale);
		glw.rotateZ(-this.getAngle());
		glw.translate((this.viewLeft + this.viewRight) / -2, (this.viewTop + this.viewBottom) / -2);
		glw.updateModelView();
		var i, len, inst, bbox;
		for (i = 0, len = this.instances.length; i < len; i++)
		{
			inst = this.instances[i];
			if (!inst.visible || inst.width === 0 || inst.height === 0)
				continue;
			inst.update_bbox();
			bbox = inst.bbox;
			if (bbox.right < this.viewLeft || bbox.bottom < this.viewTop || bbox.left > this.viewRight || bbox.top > this.viewBottom)
				continue;
			if (inst.uses_shaders)
			{
				shaderindex = inst.active_effect_types[0].shaderindex;
				etindex = inst.active_effect_types[0].index;
				if (inst.active_effect_types.length === 1 && !glw.programUsesCrossSampling(shaderindex) &&
					!glw.programExtendsBox(shaderindex) && ((!inst.angle && !inst.layer.getAngle()) || !glw.programUsesDest(shaderindex)) &&
					inst.opacity === 1 && !inst.type.plugin.must_predraw)
				{
					glw.switchProgram(shaderindex);
					glw.setBlend(inst.srcBlend, inst.destBlend);
					if (glw.programIsAnimated(shaderindex))
						this.runtime.redraw = true;
					var destStartX = 0, destStartY = 0, destEndX = 0, destEndY = 0;
					if (glw.programUsesDest(shaderindex))
					{
						var bbox = inst.bbox;
						var screenleft = this.layerToCanvas(bbox.left, bbox.top, true);
						var screentop = this.layerToCanvas(bbox.left, bbox.top, false);
						var screenright = this.layerToCanvas(bbox.right, bbox.bottom, true);
						var screenbottom = this.layerToCanvas(bbox.right, bbox.bottom, false);
						destStartX = screenleft / windowWidth;
						destStartY = 1 - screentop / windowHeight;
						destEndX = screenright / windowWidth;
						destEndY = 1 - screenbottom / windowHeight;
					}
					glw.setProgramParameters(this.render_offscreen ? this.runtime.layer_tex : this.layout.getRenderTarget(), // backTex
											 1.0 / inst.width,			// pixelWidth
											 1.0 / inst.height,			// pixelHeight
											 destStartX, destStartY,
											 destEndX, destEndY,
											 this.getScale(),
											 inst.effect_params[etindex]);
					inst.drawGL(glw);
				}
				else
				{
					this.layout.renderEffectChain(glw, this, inst, this.render_offscreen ? this.runtime.layer_tex : this.layout.getRenderTarget());
					glw.resetModelView();
					glw.scale(myscale, myscale);
					glw.rotateZ(-this.getAngle());
					glw.translate((this.viewLeft + this.viewRight) / -2, (this.viewTop + this.viewBottom) / -2);
					glw.updateModelView();
				}
			}
			else
			{
				glw.switchProgram(0);		// un-set any previously set shader
				glw.setBlend(inst.srcBlend, inst.destBlend);
				inst.drawGL(glw);
			}
		}
		if (this.render_offscreen)
		{
			shaderindex = this.active_effect_types.length ? this.active_effect_types[0].shaderindex : 0;
			etindex = this.active_effect_types.length ? this.active_effect_types[0].index : 0;
			if (this.active_effect_types.length === 0 || (this.active_effect_types.length === 1 &&
				!glw.programUsesCrossSampling(shaderindex) && this.opacity === 1))
			{
				if (this.active_effect_types.length === 1)
				{
					glw.switchProgram(shaderindex);
					glw.setProgramParameters(this.layout.getRenderTarget(),		// backTex
											 1.0 / this.runtime.width,			// pixelWidth
											 1.0 / this.runtime.height,			// pixelHeight
											 0.0, 0.0,							// destStart
											 1.0, 1.0,							// destEnd
											 this.getScale(),					// layerScale
											 this.effect_params[etindex]);		// fx parameters
					if (glw.programIsAnimated(shaderindex))
						this.runtime.redraw = true;
				}
				else
					glw.switchProgram(0);
				glw.setRenderingToTexture(this.layout.getRenderTarget());
				glw.setOpacity(this.opacity);
				glw.setTexture(this.runtime.layer_tex);
				glw.setBlend(this.srcBlend, this.destBlend);
				glw.resetModelView();
				glw.updateModelView();
				var halfw = this.runtime.width / 2;
				var halfh = this.runtime.height / 2;
				glw.quad(-halfw, halfh, halfw, halfh, halfw, -halfh, -halfw, -halfh);
				glw.setTexture(null);
			}
			else
			{
				this.layout.renderEffectChain(glw, this, null, this.layout.getRenderTarget());
			}
		}
	};
	Layer.prototype.canvasToLayer = function (ptx, pty, getx)
	{
		var multiplier = this.runtime.devicePixelRatio;
		if (this.runtime.isRetina)
		{
			ptx *= multiplier;
			pty *= multiplier;
		}
		var ox = (this.runtime.original_width / 2);
		var oy = (this.runtime.original_height / 2);
		var x = ((this.layout.scrollX - ox) * this.parallaxX) + ox;
		var y = ((this.layout.scrollY - oy) * this.parallaxY) + oy;
		var invScale = 1 / this.getScale();
		x -= (this.runtime.width * invScale) / 2;
		y -= (this.runtime.height * invScale) / 2;
		x += ptx * invScale;
		y += pty * invScale;
		var a = this.getAngle();
		if (a !== 0)
		{
			x -= this.layout.scrollX;
			y -= this.layout.scrollY;
			var cosa = Math.cos(a);
			var sina = Math.sin(a);
			var x_temp = (x * cosa) - (y * sina);
			y = (y * cosa) + (x * sina);
			x = x_temp;
			x += this.layout.scrollX;
			y += this.layout.scrollY;
		}
		return getx ? x : y;
	};
	Layer.prototype.layerToCanvas = function (ptx, pty, getx)
	{
		var a = this.getAngle();
		if (a !== 0)
		{
			ptx -= this.layout.scrollX;
			pty -= this.layout.scrollY;
			var cosa = Math.cos(-a);
			var sina = Math.sin(-a);
			var x_temp = (ptx * cosa) - (pty * sina);
			pty = (pty * cosa) + (ptx * sina);
			ptx = x_temp;
			ptx += this.layout.scrollX;
			pty += this.layout.scrollY;
		}
		var ox = (this.runtime.original_width / 2);
		var oy = (this.runtime.original_height / 2);
		var x = ((this.layout.scrollX - ox) * this.parallaxX) + ox;
		var y = ((this.layout.scrollY - oy) * this.parallaxY) + oy;
		var invScale = 1 / this.getScale();
		x -= (this.runtime.width * invScale) / 2;
		y -= (this.runtime.height * invScale) / 2;
		x = (ptx - x) / invScale;
		y = (pty - y) / invScale;
		var multiplier = this.runtime.devicePixelRatio;
		if (this.runtime.isRetina)
		{
			x /= multiplier;
			y /= multiplier;
		}
		return getx ? x : y;
	};
	Layer.prototype.rotatePt = function (x_, y_, getx)
	{
		if (this.getAngle() === 0)
			return getx ? x_ : y_;
		var nx = this.layerToCanvas(x_, y_, true);
		var ny = this.layerToCanvas(x_, y_, false);
		this.disableAngle = true;
		var px = this.canvasToLayer(nx, ny, true);
		var py = this.canvasToLayer(nx, ny, true);
		this.disableAngle = false;
		return getx ? px : py;
	};
	Layer.prototype.saveToJSON = function ()
	{
		var i, len, et;
		var o = {
			"s": this.scale,
			"a": this.angle,
			"vl": this.viewLeft,
			"vt": this.viewTop,
			"vr": this.viewRight,
			"vb": this.viewBottom,
			"v": this.visible,
			"bc": this.background_color,
			"t": this.transparent,
			"px": this.parallaxX,
			"py": this.parallaxY,
			"o": this.opacity,
			"zr": this.zoomRate,
			"fx": [],
			"instances": []
		};
		for (i = 0, len = this.effect_types.length; i < len; i++)
		{
			et = this.effect_types[i];
			o["fx"].push({"name": et.name, "active": et.active, "params": this.effect_params[et.index] });
		}
		return o;
	};
	function sortInstanceByZIndex(a, b)
	{
		return a.zindex - b.zindex;
	};
	Layer.prototype.loadFromJSON = function (o)
	{
		var i, len, p, inst, fx;
		this.scale = o["s"];
		this.angle = o["a"];
		this.viewLeft = o["vl"];
		this.viewTop = o["vt"];
		this.viewRight = o["vr"];
		this.viewBottom = o["vb"];
		this.visible = o["v"];
		this.background_color = o["bc"];
		this.transparent = o["t"];
		this.parallaxX = o["px"];
		this.parallaxY = o["py"];
		this.opacity = o["o"];
		this.zoomRate = o["zr"];
		var ofx = o["fx"];
		for (i = 0, len = ofx.length; i < len; i++)
		{
			fx = this.getEffectByName(ofx[i]["name"]);
			if (!fx)
				continue;		// must've gone missing
			fx.active = ofx[i]["active"];
			this.effect_params[fx.index] = ofx[i]["params"];
		}
		this.updateActiveEffects();
		this.instances.sort(sortInstanceByZIndex);
		this.zindices_stale = true;
	};
	cr.layer = Layer;
}());
;
(function()
{
	var allUniqueSolModifiers = [];
	function testSolsMatch(arr1, arr2)
	{
		var i, len = arr1.length;
		switch (len) {
		case 0:
			return true;
		case 1:
			return arr1[0] === arr2[0];
		case 2:
			return arr1[0] === arr2[0] && arr1[1] === arr2[1];
		default:
			for (i = 0; i < len; i++)
			{
				if (arr1[i] !== arr2[i])
					return false;
			}
			return true;
		}
	};
	function solArraySorter(t1, t2)
	{
		return t1.index - t2.index;
	};
	function findMatchingSolModifier(arr)
	{
		var i, len, u, temp, subarr;
		if (arr.length === 2)
		{
			if (arr[0].index > arr[1].index)
			{
				temp = arr[0];
				arr[0] = arr[1];
				arr[1] = temp;
			}
		}
		else if (arr.length > 2)
			arr.sort(solArraySorter);		// so testSolsMatch compares in same order
		if (arr.length >= allUniqueSolModifiers.length)
			allUniqueSolModifiers.length = arr.length + 1;
		if (!allUniqueSolModifiers[arr.length])
			allUniqueSolModifiers[arr.length] = [];
		subarr = allUniqueSolModifiers[arr.length];
		for (i = 0, len = subarr.length; i < len; i++)
		{
			u = subarr[i];
			if (testSolsMatch(arr, u))
				return u;
		}
		subarr.push(arr);
		return arr;
	};
	function EventSheet(runtime, m)
	{
		this.runtime = runtime;
		this.triggers = {};
		this.fasttriggers = {};
        this.hasRun = false;
        this.includes = new cr.ObjectSet(); // all event sheets included by this sheet, at first-level indirection only
		this.name = m[0];
		var em = m[1];		// events model
		this.events = [];       // triggers won't make it to this array
		var i, len;
		for (i = 0, len = em.length; i < len; i++)
			this.init_event(em[i], null, this.events);
	};
    EventSheet.prototype.toString = function ()
    {
        return this.name;
    };
	EventSheet.prototype.init_event = function (m, parent, nontriggers)
	{
		switch (m[0]) {
		case 0:	// event block
		{
			var block = new cr.eventblock(this, parent, m);
			cr.seal(block);
			if (block.orblock)
			{
				nontriggers.push(block);
				var i, len;
				for (i = 0, len = block.conditions.length; i < len; i++)
				{
					if (block.conditions[i].trigger)
						this.init_trigger(block, i);
				}
			}
			else
			{
				if (block.is_trigger())
					this.init_trigger(block, 0);
				else
					nontriggers.push(block);
			}
			break;
		}
		case 1: // variable
		{
			var v = new cr.eventvariable(this, parent, m);
			cr.seal(v);
			nontriggers.push(v);
			break;
		}
        case 2:	// include
        {
            var inc = new cr.eventinclude(this, parent, m);
			cr.seal(inc);
            nontriggers.push(inc);
			break;
        }
		default:
;
		}
	};
	EventSheet.prototype.postInit = function ()
	{
		var i, len;
		for (i = 0, len = this.events.length; i < len; i++)
		{
			this.events[i].postInit(i < len - 1 && this.events[i + 1].is_else_block);
		}
	};
	EventSheet.prototype.run = function (from_include)
	{
		if (!this.runtime.resuming_breakpoint)
		{
			this.hasRun = true;
			if (!from_include)
				this.runtime.isRunningEvents = true;
		}
		var i, len;
		for (i = 0, len = this.events.length; i < len; i++)
		{
			var ev = this.events[i];
			ev.run();
				this.runtime.clearSol(ev.solModifiers);
				if (!this.runtime.deathRow.isEmpty() || this.runtime.createRow.length)
					this.runtime.ClearDeathRow();
		}
			if (!from_include)
				this.runtime.isRunningEvents = false;
	};
	EventSheet.prototype.init_trigger = function (trig, index)
	{
		if (!trig.orblock)
			this.runtime.triggers_to_postinit.push(trig);	// needs to be postInit'd later
		var i, len;
		var cnd = trig.conditions[index];
		var type_name;
		if (cnd.type)
			type_name = cnd.type.name;
		else
			type_name = "system";
		var fasttrigger = cnd.fasttrigger;
		var triggers = (fasttrigger ? this.fasttriggers : this.triggers);
		if (!triggers[type_name])
			triggers[type_name] = [];
		var obj_entry = triggers[type_name];
		var method = cnd.func;
		if (fasttrigger)
		{
			if (!cnd.parameters.length)				// no parameters
				return;
			var firstparam = cnd.parameters[0];
			if (firstparam.type !== 1 ||			// not a string param
				firstparam.expression.type !== 2)	// not a string literal node
			{
				return;
			}
			var fastevs;
			var firstvalue = firstparam.expression.value.toLowerCase();
			var i, len;
			for (i = 0, len = obj_entry.length; i < len; i++)
			{
				if (obj_entry[i].method == method)
				{
					fastevs = obj_entry[i].evs;
					if (!fastevs[firstvalue])
						fastevs[firstvalue] = [[trig, index]];
					else
						fastevs[firstvalue].push([trig, index]);
					return;
				}
			}
			fastevs = {};
			fastevs[firstvalue] = [[trig, index]];
			obj_entry.push({ method: method, evs: fastevs });
		}
		else
		{
			for (i = 0, len = obj_entry.length; i < len; i++)
			{
				if (obj_entry[i].method == method)
				{
					obj_entry[i].evs.push([trig, index]);
					return;
				}
			}
			obj_entry.push({ method: method, evs: [[trig, index]]});
		}
	};
	cr.eventsheet = EventSheet;
	function Selection(type)
	{
		this.type = type;
		this.instances = [];        // subset of picked instances
		this.else_instances = [];	// subset of unpicked instances
		this.select_all = true;
	};
	Selection.prototype.hasObjects = function ()
	{
		if (this.select_all)
			return this.type.instances.length;
		else
			return this.instances.length;
	};
	Selection.prototype.getObjects = function ()
	{
		if (this.select_all)
			return this.type.instances;
		else
			return this.instances;
	};
	/*
	Selection.prototype.ensure_picked = function (inst, skip_siblings)
	{
		var i, len;
		var orblock = inst.runtime.getCurrentEventStack().current_event.orblock;
		if (this.select_all)
		{
			this.select_all = false;
			if (orblock)
			{
				cr.shallowAssignArray(this.else_instances, inst.type.instances);
				cr.arrayFindRemove(this.else_instances, inst);
			}
			this.instances.length = 1;
			this.instances[0] = inst;
		}
		else
		{
			if (orblock)
			{
				i = this.else_instances.indexOf(inst);
				if (i !== -1)
				{
					this.instances.push(this.else_instances[i]);
					this.else_instances.splice(i, 1);
				}
			}
			else
			{
				if (this.instances.indexOf(inst) === -1)
					this.instances.push(inst);
			}
		}
		if (!skip_siblings)
		{
		}
	};
	*/
	Selection.prototype.pick_one = function (inst)
	{
		if (!inst)
			return;
		if (inst.runtime.getCurrentEventStack().current_event.orblock)
		{
			if (this.select_all)
			{
				this.instances.length = 0;
				cr.shallowAssignArray(this.else_instances, inst.type.instances);
				this.select_all = false;
			}
			var i = this.else_instances.indexOf(inst);
			if (i !== -1)
			{
				this.instances.push(this.else_instances[i]);
				this.else_instances.splice(i, 1);
			}
		}
		else
		{
			this.select_all = false;
			this.instances.length = 1;
			this.instances[0] = inst;
		}
	};
	cr.selection = Selection;
	function EventBlock(sheet, parent, m)
	{
		this.sheet = sheet;
		this.parent = parent;
		this.runtime = sheet.runtime;
		this.solModifiers = [];
		this.solModifiersIncludingParents = [];
		this.solWriterAfterCnds = false;	// block does not change SOL after running its conditions
		this.group = false;					// is group of events
		this.initially_activated = false;	// if a group, is active on startup
		this.toplevelevent = false;			// is an event block parented only by a top-level group
		this.toplevelgroup = false;			// is parented only by other groups or is top-level (i.e. not in a subevent)
		this.has_else_block = false;		// is followed by else
;
		this.conditions = [];
		this.actions = [];
		this.subevents = [];
        if (m[1])
        {
			this.group_name = m[1][1].toLowerCase();
			this.group = true;
			this.initially_activated = !!m[1][0];
			this.runtime.allGroups.push(this);
            this.runtime.activeGroups[(/*this.sheet.name + "|" + */this.group_name).toLowerCase()] = this.initially_activated;
        }
		else
		{
			this.group_name = "";
			this.group = false;
			this.initially_activated = false;
		}
		this.orblock = m[2];
		this.sid = m[4];
		if (!this.group)
			this.runtime.blocksBySid[this.sid.toString()] = this;
		var i, len;
		var cm = m[5];
		for (i = 0, len = cm.length; i < len; i++)
		{
			var cnd = new cr.condition(this, cm[i]);
			cnd.index = i;
			cr.seal(cnd);
			this.conditions.push(cnd);
			/*
			if (cnd.is_logical())
				this.is_logical = true;
			if (cnd.type && !cnd.type.plugin.singleglobal && this.cndReferences.indexOf(cnd.type) === -1)
				this.cndReferences.push(cnd.type);
			*/
			this.addSolModifier(cnd.type);
		}
		var am = m[6];
		for (i = 0, len = am.length; i < len; i++)
		{
			var act = new cr.action(this, am[i]);
			act.index = i;
			cr.seal(act);
			this.actions.push(act);
		}
		if (m.length === 8)
		{
			var em = m[7];
			for (i = 0, len = em.length; i < len; i++)
				this.sheet.init_event(em[i], this, this.subevents);
		}
		this.is_else_block = false;
		if (this.conditions.length)
		{
			this.is_else_block = (this.conditions[0].type == null && this.conditions[0].func == cr.system_object.prototype.cnds.Else);
		}
	};
	EventBlock.prototype.postInit = function (hasElse/*, prevBlock_*/)
	{
		var i, len;
		var p = this.parent;
		if (this.group)
		{
			this.toplevelgroup = true;
			while (p)
			{
				if (!p.group)
				{
					this.toplevelgroup = false;
					break;
				}
				p = p.parent;
			}
		}
		this.toplevelevent = !this.is_trigger() && (!this.parent || (this.parent.group && this.parent.toplevelgroup));
		this.has_else_block = !!hasElse;
		this.solModifiersIncludingParents = this.solModifiers.slice(0);
		p = this.parent;
		while (p)
		{
			for (i = 0, len = p.solModifiers.length; i < len; i++)
				this.addParentSolModifier(p.solModifiers[i]);
			p = p.parent;
		}
		this.solModifiers = findMatchingSolModifier(this.solModifiers);
		this.solModifiersIncludingParents = findMatchingSolModifier(this.solModifiersIncludingParents);
		var i, len/*, s*/;
		for (i = 0, len = this.conditions.length; i < len; i++)
			this.conditions[i].postInit();
		for (i = 0, len = this.actions.length; i < len; i++)
			this.actions[i].postInit();
		for (i = 0, len = this.subevents.length; i < len; i++)
		{
			this.subevents[i].postInit(i < len - 1 && this.subevents[i + 1].is_else_block);
		}
		/*
		if (this.is_else_block && this.prev_block)
		{
			for (i = 0, len = this.prev_block.solModifiers.length; i < len; i++)
			{
				s = this.prev_block.solModifiers[i];
				if (this.solModifiers.indexOf(s) === -1)
					this.solModifiers.push(s);
			}
		}
		*/
	}
	function addSolModifierToList(type, arr)
	{
		var i, len, t;
		if (!type)
			return;
		if (arr.indexOf(type) === -1)
			arr.push(type);
		if (type.is_contained)
		{
			for (i = 0, len = type.container.length; i < len; i++)
			{
				t = type.container[i];
				if (type === t)
					continue;		// already handled
				if (arr.indexOf(t) === -1)
					arr.push(t);
			}
		}
	};
	EventBlock.prototype.addSolModifier = function (type)
	{
		addSolModifierToList(type, this.solModifiers);
	};
	EventBlock.prototype.addParentSolModifier = function (type)
	{
		addSolModifierToList(type, this.solModifiersIncludingParents);
	};
	EventBlock.prototype.setSolWriterAfterCnds = function ()
	{
		this.solWriterAfterCnds = true;
		if (this.parent)
			this.parent.setSolWriterAfterCnds();
	};
	EventBlock.prototype.is_trigger = function ()
	{
		if (!this.conditions.length)    // no conditions
			return false;
		else
			return this.conditions[0].trigger;
	};
	EventBlock.prototype.run = function ()
	{
		var i, len, any_true = false, cnd_result;
		var evinfo = this.runtime.getCurrentEventStack();
		evinfo.current_event = this;
			if (!this.is_else_block)
				evinfo.else_branch_ran = false;
		if (this.orblock)
		{
			if (this.conditions.length === 0)
				any_true = true;		// be sure to run if empty block
				evinfo.cndindex = 0
			for (len = this.conditions.length; evinfo.cndindex < len; evinfo.cndindex++)
			{
				if (this.conditions[evinfo.cndindex].trigger)		// skip triggers when running OR block
					continue;
				cnd_result = this.conditions[evinfo.cndindex].run();
				if (cnd_result)			// make sure all conditions run and run if any were true
					any_true = true;
			}
			evinfo.last_event_true = any_true;
			if (any_true)
				this.run_actions_and_subevents();
		}
		else
		{
				evinfo.cndindex = 0
			for (len = this.conditions.length; evinfo.cndindex < len; evinfo.cndindex++)
			{
				cnd_result = this.conditions[evinfo.cndindex].run();
				if (!cnd_result)    // condition failed
				{
					evinfo.last_event_true = false;
					if (this.toplevelevent && (!this.runtime.deathRow.isEmpty() || this.runtime.createRow.length))
						this.runtime.ClearDeathRow();
					return;		// bail out now
				}
			}
			evinfo.last_event_true = true;
			this.run_actions_and_subevents();
		}
		this.end_run(evinfo);
	};
	EventBlock.prototype.end_run = function (evinfo)
	{
		if (evinfo.last_event_true && this.has_else_block)
			evinfo.else_branch_ran = true;
		if (this.toplevelevent && (!this.runtime.deathRow.isEmpty() || this.runtime.createRow.length))
			this.runtime.ClearDeathRow();
	};
	EventBlock.prototype.run_orblocktrigger = function (index)
	{
		var evinfo = this.runtime.getCurrentEventStack();
		evinfo.current_event = this;
		if (this.conditions[index].run())
		{
			this.run_actions_and_subevents();
			this.runtime.getCurrentEventStack().last_event_true = true;
		}
	};
	EventBlock.prototype.run_actions_and_subevents = function ()
	{
		var evinfo = this.runtime.getCurrentEventStack();
		var len;
		for (evinfo.actindex = 0, len = this.actions.length; evinfo.actindex < len; evinfo.actindex++)
		{
			if (this.actions[evinfo.actindex].run())
				return;
		}
		this.run_subevents();
	};
	EventBlock.prototype.resume_actions_and_subevents = function ()
	{
		var evinfo = this.runtime.getCurrentEventStack();
		var len;
		for (len = this.actions.length; evinfo.actindex < len; evinfo.actindex++)
		{
			if (this.actions[evinfo.actindex].run())
				return;
		}
		this.run_subevents();
	};
	EventBlock.prototype.run_subevents = function ()
	{
		if (!this.subevents.length)
			return;
		var i, len, subev, pushpop/*, skipped_pop = false, pop_modifiers = null*/;
		var last = this.subevents.length - 1;
			this.runtime.pushEventStack(this);
		if (this.solWriterAfterCnds)
		{
			for (i = 0, len = this.subevents.length; i < len; i++)
			{
				subev = this.subevents[i];
					pushpop = (!this.toplevelgroup || (!this.group && i < last));
					if (pushpop)
						this.runtime.pushCopySol(subev.solModifiers);
				subev.run();
					if (pushpop)
						this.runtime.popSol(subev.solModifiers);
					else
						this.runtime.clearSol(subev.solModifiers);
			}
		}
		else
		{
			for (i = 0, len = this.subevents.length; i < len; i++)
			{
				this.subevents[i].run();
			}
		}
			this.runtime.popEventStack();
	};
	EventBlock.prototype.run_pretrigger = function ()
	{
		var evinfo = this.runtime.getCurrentEventStack();
		evinfo.current_event = this;
		var any_true = false;
		var i, len;
		for (evinfo.cndindex = 0, len = this.conditions.length; evinfo.cndindex < len; evinfo.cndindex++)
		{
;
			if (this.conditions[evinfo.cndindex].run())
				any_true = true;
			else if (!this.orblock)			// condition failed (let OR blocks run all conditions anyway)
				return false;               // bail out
		}
		return this.orblock ? any_true : true;
	};
	EventBlock.prototype.retrigger = function ()
	{
		this.runtime.execcount++;
		var prevcndindex = this.runtime.getCurrentEventStack().cndindex;
		var len;
		var evinfo = this.runtime.pushEventStack(this);
		if (!this.orblock)
		{
			for (evinfo.cndindex = prevcndindex + 1, len = this.conditions.length; evinfo.cndindex < len; evinfo.cndindex++)
			{
				if (!this.conditions[evinfo.cndindex].run())    // condition failed
				{
					this.runtime.popEventStack();               // moving up level of recursion
					return false;                               // bail out
				}
			}
		}
		this.run_actions_and_subevents();
		this.runtime.popEventStack();
		return true;		// ran an iteration
	};
	EventBlock.prototype.isFirstConditionOfType = function (cnd)
	{
		var cndindex = cnd.index;
		if (cndindex === 0)
			return true;
		--cndindex;
		for ( ; cndindex >= 0; --cndindex)
		{
			if (this.conditions[cndindex].type === cnd.type)
				return false;
		}
		return true;
	};
	cr.eventblock = EventBlock;
	function Condition(block, m)
	{
		this.block = block;
		this.sheet = block.sheet;
		this.runtime = block.runtime;
		this.parameters = [];
		this.results = [];
		this.extra = {};		// for plugins to stow away some custom info
		this.index = -1;
		this.func = m[1];
;
		this.trigger = (m[3] > 0);
		this.fasttrigger = (m[3] === 2);
		this.looping = m[4];
		this.inverted = m[5];
		this.isstatic = m[6];
		this.sid = m[7];
		this.runtime.cndsBySid[this.sid.toString()] = this;
		if (m[0] === -1)		// system object
		{
			this.type = null;
			this.run = this.run_system;
			this.behaviortype = null;
			this.beh_index = -1;
		}
		else
		{
			this.type = this.runtime.types_by_index[m[0]];
;
			if (this.isstatic)
				this.run = this.run_static;
			else
				this.run = this.run_object;
			if (m[2])
			{
				this.behaviortype = this.type.getBehaviorByName(m[2]);
;
				this.beh_index = this.type.getBehaviorIndexByName(m[2]);
;
			}
			else
			{
				this.behaviortype = null;
				this.beh_index = -1;
			}
			if (this.block.parent)
				this.block.parent.setSolWriterAfterCnds();
		}
		if (this.fasttrigger)
			this.run = this.run_true;
		if (m.length === 10)
		{
			var i, len;
			var em = m[9];
			for (i = 0, len = em.length; i < len; i++)
			{
				var param = new cr.parameter(this, em[i]);
				cr.seal(param);
				this.parameters.push(param);
			}
			this.results.length = em.length;
		}
	};
	Condition.prototype.postInit = function ()
	{
		var i, len;
		for (i = 0, len = this.parameters.length; i < len; i++)
			this.parameters[i].postInit();
	};
	/*
	Condition.prototype.is_logical = function ()
	{
		return !this.type || this.type.plugin.singleglobal;
	};
	*/
	Condition.prototype.run_true = function ()
	{
		return true;
	};
	Condition.prototype.run_system = function ()
	{
		var i, len;
		for (i = 0, len = this.parameters.length; i < len; i++)
			this.results[i] = this.parameters[i].get();
		return cr.xor(this.func.apply(this.runtime.system, this.results), this.inverted);
	};
	Condition.prototype.run_static = function ()
	{
		var i, len;
		for (i = 0, len = this.parameters.length; i < len; i++)
			this.results[i] = this.parameters[i].get(i);
		var ret = this.func.apply(this.behaviortype ? this.behaviortype : this.type, this.results);
		this.type.applySolToContainer();
		return ret;
	};
	Condition.prototype.run_object = function ()
	{
		var i, j, leni, lenj, ret, met, inst, s, sol2;
		var sol = this.type.getCurrentSol();
		var is_orblock = this.block.orblock && !this.trigger;		// triggers in OR blocks need to work normally
		var offset = 0;
		var is_contained = this.type.is_contained;
		if (sol.select_all) {
			sol.instances.length = 0;       // clear contents
			sol.else_instances.length = 0;
			for (i = 0, leni = this.type.instances.length; i < leni; i++)
			{
				inst = this.type.instances[i];
;
				for (j = 0, lenj = this.parameters.length; j < lenj; j++)
					this.results[j] = this.parameters[j].get(i);        // default SOL index is current object
				if (this.beh_index > -1)
				{
					if (this.type.is_family)
					{
						offset = inst.type.family_beh_map[this.type.family_index];
					}
					ret = this.func.apply(inst.behavior_insts[this.beh_index + offset], this.results);
				}
				else
					ret = this.func.apply(inst, this.results);
				met = cr.xor(ret, this.inverted);
				if (met)
					sol.instances.push(inst);
				else if (is_orblock)					// in OR blocks, keep the instances not meeting the condition for subsequent testing
					sol.else_instances.push(inst);
			}
			if (this.type.finish)
				this.type.finish(true);
			sol.select_all = false;
			this.type.applySolToContainer();
			return sol.hasObjects();
		}
		else {
			var k = 0;
			var using_else_instances = (is_orblock && !this.block.isFirstConditionOfType(this));
			var arr = (using_else_instances ? sol.else_instances : sol.instances);
			var any_true = false;
			for (i = 0, leni = arr.length; i < leni; i++)
			{
				inst = arr[i];
;
				for (j = 0, lenj = this.parameters.length; j < lenj; j++)
					this.results[j] = this.parameters[j].get(i);        // default SOL index is current object
				if (this.beh_index > -1)
				{
					if (this.type.is_family)
					{
						offset = inst.type.family_beh_map[this.type.family_index];
					}
					ret = this.func.apply(inst.behavior_insts[this.beh_index + offset], this.results);
				}
				else
					ret = this.func.apply(inst, this.results);
				if (cr.xor(ret, this.inverted))
				{
					any_true = true;
					if (using_else_instances)
					{
						sol.instances.push(inst);
						if (is_contained)
						{
							for (j = 0, lenj = inst.siblings.length; j < lenj; j++)
							{
								s = inst.siblings[j];
								s.type.getCurrentSol().instances.push(s);
							}
						}
					}
					else
					{
						arr[k] = inst;
						if (is_contained)
						{
							for (j = 0, lenj = inst.siblings.length; j < lenj; j++)
							{
								s = inst.siblings[j];
								s.type.getCurrentSol().instances[k] = s;
							}
						}
						k++;
					}
				}
				else
				{
					if (using_else_instances)
					{
						arr[k] = inst;
						if (is_contained)
						{
							for (j = 0, lenj = inst.siblings.length; j < lenj; j++)
							{
								s = inst.siblings[j];
								s.type.getCurrentSol().else_instances[k] = s;
							}
						}
						k++;
					}
					else if (is_orblock)
					{
						sol.else_instances.push(inst);
						if (is_contained)
						{
							for (j = 0, lenj = inst.siblings.length; j < lenj; j++)
							{
								s = inst.siblings[j];
								s.type.getCurrentSol().else_instances.push(s);
							}
						}
					}
				}
			}
			arr.length = k;
			if (is_contained)
			{
				for (i = 0, leni = this.type.container.length; i < leni; i++)
				{
					sol2 = this.type.container[i].getCurrentSol();
					if (using_else_instances)
						sol2.else_instances.length = k;
					else
						sol2.instances.length = k;
				}
			}
			var pick_in_finish = any_true;		// don't pick in finish() if we're only doing the logic test below
			if (using_else_instances && !any_true)
			{
				for (i = 0, leni = sol.instances.length; i < leni; i++)
				{
					inst = sol.instances[i];
					for (j = 0, lenj = this.parameters.length; j < lenj; j++)
						this.results[j] = this.parameters[j].get(i);
					if (this.beh_index > -1)
						ret = this.func.apply(inst.behavior_insts[this.beh_index], this.results);
					else
						ret = this.func.apply(inst, this.results);
					if (cr.xor(ret, this.inverted))
					{
						any_true = true;
						break;		// got our flag, don't need to test any more
					}
				}
			}
			if (this.type.finish)
				this.type.finish(pick_in_finish || is_orblock);
			return is_orblock ? any_true : sol.hasObjects();
		}
	};
	cr.condition = Condition;
	function Action(block, m)
	{
		this.block = block;
		this.sheet = block.sheet;
		this.runtime = block.runtime;
		this.parameters = [];
		this.results = [];
		this.extra = {};		// for plugins to stow away some custom info
		this.index = -1;
		this.func = m[1];
;
		if (m[0] === -1)	// system
		{
			this.type = null;
			this.run = this.run_system;
			this.behaviortype = null;
			this.beh_index = -1;
		}
		else
		{
			this.type = this.runtime.types_by_index[m[0]];
;
			this.run = this.run_object;
			if (m[2])
			{
				this.behaviortype = this.type.getBehaviorByName(m[2]);
;
				this.beh_index = this.type.getBehaviorIndexByName(m[2]);
;
			}
			else
			{
				this.behaviortype = null;
				this.beh_index = -1;
			}
		}
		this.sid = m[3];
		this.runtime.actsBySid[this.sid.toString()] = this;
		if (m.length === 6)
		{
			var i, len;
			var em = m[5];
			for (i = 0, len = em.length; i < len; i++)
			{
				var param = new cr.parameter(this, em[i]);
				cr.seal(param);
				this.parameters.push(param);
			}
			this.results.length = em.length;
		}
	};
	Action.prototype.postInit = function ()
	{
		var i, len;
		for (i = 0, len = this.parameters.length; i < len; i++)
			this.parameters[i].postInit();
	};
	Action.prototype.run_system = function ()
	{
		var i, len;
		for (i = 0, len = this.parameters.length; i < len; i++)
			this.results[i] = this.parameters[i].get();
		return this.func.apply(this.runtime.system, this.results);
	};
	Action.prototype.run_object = function ()
	{
		var instances = this.type.getCurrentSol().getObjects();
		var i, j, leni, lenj, inst;
		for (i = 0, leni = instances.length; i < leni; i++)
		{
			inst = instances[i];
			for (j = 0, lenj = this.parameters.length; j < lenj; j++)
				this.results[j] = this.parameters[j].get(i);    // pass i to use as default SOL index
			if (this.beh_index > -1)
			{
				var offset = 0;
				if (this.type.is_family)
				{
					offset = inst.type.family_beh_map[this.type.family_index];
				}
				this.func.apply(inst.behavior_insts[this.beh_index + offset], this.results);
			}
			else
				this.func.apply(inst, this.results);
		}
		return false;
	};
	cr.action = Action;
	var tempValues = [];
	var tempValuesPtr = -1;
	function Parameter(owner, m)
	{
		this.owner = owner;
		this.block = owner.block;
		this.sheet = owner.sheet;
		this.runtime = owner.runtime;
		this.type = m[0];
		this.expression = null;
		this.solindex = 0;
		this.combosel = 0;
		this.layout = null;
		this.key = 0;
		this.object = null;
		this.index = 0;
		this.varname = null;
		this.eventvar = null;
		this.fileinfo = null;
		this.subparams = null;
		this.variadicret = null;
		var i, len, param;
		switch (m[0])
		{
			case 0:		// number
			case 7:		// any
				this.expression = new cr.expNode(this, m[1]);
				this.solindex = 0;
				this.get = this.get_exp;
				break;
			case 1:		// string
				this.expression = new cr.expNode(this, m[1]);
				this.solindex = 0;
				this.get = this.get_exp_str;
				break;
			case 5:		// layer
				this.expression = new cr.expNode(this, m[1]);
				this.solindex = 0;
				this.get = this.get_layer;
				break;
			case 3:		// combo
			case 8:		// cmp
				this.combosel = m[1];
				this.get = this.get_combosel;
				break;
			case 6:		// layout
				this.layout = this.runtime.layouts[m[1]];
;
				this.get = this.get_layout;
				break;
			case 9:		// keyb
				this.key = m[1];
				this.get = this.get_key;
				break;
			case 4:		// object
				this.object = this.runtime.types_by_index[m[1]];
;
				this.get = this.get_object;
				this.block.addSolModifier(this.object);
				if (this.owner instanceof cr.action)
					this.block.setSolWriterAfterCnds();
				else if (this.block.parent)
					this.block.parent.setSolWriterAfterCnds();
				break;
			case 10:	// instvar
				this.index = m[1];
				if (owner.type.is_family)
					this.get = this.get_familyvar;
				else
					this.get = this.get_instvar;
				break;
			case 11:	// eventvar
				this.varname = m[1];
				this.eventvar = null;
				this.get = this.get_eventvar;
				break;
			case 2:		// audiofile	["name", ismusic]
			case 12:	// fileinfo		"name"
				this.fileinfo = m[1];
				this.get = this.get_audiofile;
				break;
			case 13:	// variadic
				this.get = this.get_variadic;
				this.subparams = [];
				this.variadicret = [];
				for (i = 1, len = m.length; i < len; i++)
				{
					param = new cr.parameter(this.owner, m[i]);
					cr.seal(param);
					this.subparams.push(param);
					this.variadicret.push(0);
				}
				break;
			default:
;
		}
	};
	Parameter.prototype.postInit = function ()
	{
		var i, len;
		if (this.type === 11)		// eventvar
		{
			this.eventvar = this.runtime.getEventVariableByName(this.varname, this.block.parent);
;
		}
		else if (this.type === 13)	// variadic, postInit all sub-params
		{
			for (i = 0, len = this.subparams.length; i < len; i++)
				this.subparams[i].postInit();
		}
		if (this.expression)
			this.expression.postInit();
	};
	Parameter.prototype.pushTempValue = function ()
	{
		tempValuesPtr++;
		if (tempValues.length === tempValuesPtr)
			tempValues.push(new cr.expvalue());
		return tempValues[tempValuesPtr];
	};
	Parameter.prototype.popTempValue = function ()
	{
		tempValuesPtr--;
	};
	Parameter.prototype.get_exp = function (solindex)
	{
		this.solindex = solindex || 0;   // default SOL index to use
		var temp = this.pushTempValue();
		this.expression.get(temp);
		this.popTempValue();
		return temp.data;      			// return actual JS value, not expvalue
	};
	Parameter.prototype.get_exp_str = function (solindex)
	{
		this.solindex = solindex || 0;   // default SOL index to use
		var temp = this.pushTempValue();
		this.expression.get(temp);
		this.popTempValue();
		if (cr.is_string(temp.data))
			return temp.data;
		else
			return "";
	};
	Parameter.prototype.get_object = function ()
	{
		return this.object;
	};
	Parameter.prototype.get_combosel = function ()
	{
		return this.combosel;
	};
	Parameter.prototype.get_layer = function (solindex)
	{
		this.solindex = solindex || 0;   // default SOL index to use
		var temp = this.pushTempValue();
		this.expression.get(temp);
		this.popTempValue();
		if (temp.is_number())
			return this.runtime.getLayerByNumber(temp.data);
		else
			return this.runtime.getLayerByName(temp.data);
	}
	Parameter.prototype.get_layout = function ()
	{
		return this.layout;
	};
	Parameter.prototype.get_key = function ()
	{
		return this.key;
	};
	Parameter.prototype.get_instvar = function ()
	{
		return this.index;
	};
	Parameter.prototype.get_familyvar = function (solindex)
	{
		var familytype = this.owner.type;
		var realtype = null;
		var sol = familytype.getCurrentSol();
		var objs = sol.getObjects();
		if (objs.length)
			realtype = objs[solindex % objs.length].type;
		else
		{
;
			realtype = sol.else_instances[solindex % sol.else_instances.length].type;
		}
		return this.index + realtype.family_var_map[familytype.family_index];
	};
	Parameter.prototype.get_eventvar = function ()
	{
		return this.eventvar;
	};
	Parameter.prototype.get_audiofile = function ()
	{
		return this.fileinfo;
	};
	Parameter.prototype.get_variadic = function ()
	{
		var i, len;
		for (i = 0, len = this.subparams.length; i < len; i++)
		{
			this.variadicret[i] = this.subparams[i].get();
		}
		return this.variadicret;
	};
	cr.parameter = Parameter;
	function EventVariable(sheet, parent, m)
	{
		this.sheet = sheet;
		this.parent = parent;
		this.runtime = sheet.runtime;
		this.solModifiers = [];
		this.name = m[1];
		this.vartype = m[2];
		this.initial = m[3];
		this.is_static = !!m[4];
		this.is_constant = !!m[5];
		this.sid = m[6];
		this.runtime.varsBySid[this.sid.toString()] = this;
		this.data = this.initial;	// note: also stored in event stack frame for local nonstatic nonconst vars
		if (this.parent)			// local var
		{
			if (this.is_static || this.is_constant)
				this.localIndex = -1;
			else
				this.localIndex = this.runtime.stackLocalCount++;
			this.runtime.all_local_vars.push(this);
		}
		else						// global var
		{
			this.localIndex = -1;
			this.runtime.all_global_vars.push(this);
		}
	};
	EventVariable.prototype.postInit = function ()
	{
		this.solModifiers = findMatchingSolModifier(this.solModifiers);
	};
	EventVariable.prototype.setValue = function (x)
	{
;
		var lvs = this.runtime.getCurrentLocalVarStack();
		if (!this.parent || this.is_static || !lvs)
			this.data = x;
		else	// local nonstatic variable: use event stack to keep value at this level of recursion
		{
			if (this.localIndex >= lvs.length)
				lvs.length = this.localIndex + 1;
			lvs[this.localIndex] = x;
		}
	};
	EventVariable.prototype.getValue = function ()
	{
		var lvs = this.runtime.getCurrentLocalVarStack();
		if (!this.parent || this.is_static || !lvs || this.is_constant)
			return this.data;
		else	// local nonstatic variable
		{
			if (this.localIndex >= lvs.length)
			{
;
				return this.initial;
			}
			if (typeof lvs[this.localIndex] === "undefined")
			{
;
				return this.initial;
			}
			return lvs[this.localIndex];
		}
	};
	EventVariable.prototype.run = function ()
	{
			if (this.parent && !this.is_static && !this.is_constant)
				this.setValue(this.initial);
	};
	cr.eventvariable = EventVariable;
	function EventInclude(sheet, parent, m)
	{
		this.sheet = sheet;
		this.parent = parent;
		this.runtime = sheet.runtime;
		this.solModifiers = [];
		this.include_sheet = null;		// determined in postInit
		this.include_sheet_name = m[1];
	};
	EventInclude.prototype.toString = function ()
	{
		return "include:" + this.include_sheet.toString();
	};
	EventInclude.prototype.postInit = function ()
	{
        this.include_sheet = this.runtime.eventsheets[this.include_sheet_name];
;
;
        this.sheet.includes.add(this);
		this.solModifiers = findMatchingSolModifier(this.solModifiers);
	};
	EventInclude.prototype.run = function ()
	{
			if (this.parent)
				this.runtime.pushCleanSol(this.runtime.types_by_index);
        if (!this.include_sheet.hasRun)
            this.include_sheet.run(true);			// from include
			if (this.parent)
				this.runtime.popSol(this.runtime.types_by_index);
	};
	EventInclude.prototype.isActive = function ()
	{
		var p = this.parent;
		while (p)
		{
			if (p.group)
			{
				if (!this.runtime.activeGroups[p.group_name.toLowerCase()])
					return false;
			}
			p = p.parent;
		}
		return true;
	};
	cr.eventinclude = EventInclude;
	function EventStackFrame()
	{
		this.temp_parents_arr = [];
		this.reset(null);
		cr.seal(this);
	};
	EventStackFrame.prototype.reset = function (cur_event)
	{
		this.current_event = cur_event;
		this.cndindex = 0;
		this.actindex = 0;
		this.temp_parents_arr.length = 0;
		this.last_event_true = false;
		this.else_branch_ran = false;
		this.any_true_state = false;
	};
	EventStackFrame.prototype.isModifierAfterCnds = function ()
	{
		if (this.current_event.solWriterAfterCnds)
			return true;
		if (this.cndindex < this.current_event.conditions.length - 1)
			return !!this.current_event.solModifiers.length;
		return false;
	};
	cr.eventStackFrame = EventStackFrame;
}());
(function()
{
	function ExpNode(owner_, m)
	{
		this.owner = owner_;
		this.runtime = owner_.runtime;
		this.type = m[0];
;
		this.get = [this.eval_int,
					this.eval_float,
					this.eval_string,
					this.eval_unaryminus,
					this.eval_add,
					this.eval_subtract,
					this.eval_multiply,
					this.eval_divide,
					this.eval_mod,
					this.eval_power,
					this.eval_and,
					this.eval_or,
					this.eval_equal,
					this.eval_notequal,
					this.eval_less,
					this.eval_lessequal,
					this.eval_greater,
					this.eval_greaterequal,
					this.eval_conditional,
					this.eval_system_exp,
					this.eval_object_behavior_exp,
					this.eval_instvar_exp,
					this.eval_object_behavior_exp,
					this.eval_eventvar_exp][this.type];
		var paramsModel = null;
		this.value = null;
		this.first = null;
		this.second = null;
		this.third = null;
		this.func = null;
		this.results = null;
		this.parameters = null;
		this.object_type = null;
		this.beh_index = -1;
		this.instance_expr = null;
		this.varindex = -1;
		this.behavior_type = null;
		this.varname = null;
		this.eventvar = null;
		this.return_string = false;
		switch (this.type) {
		case 0:		// int
		case 1:		// float
		case 2:		// string
			this.value = m[1];
			break;
		case 3:		// unaryminus
			this.first = new cr.expNode(owner_, m[1]);
			break;
		case 18:	// conditional
			this.first = new cr.expNode(owner_, m[1]);
			this.second = new cr.expNode(owner_, m[2]);
			this.third = new cr.expNode(owner_, m[3]);
			break;
		case 19:	// system_exp
			this.func = m[1];
;
			this.results = [];
			this.parameters = [];
			if (m.length === 3)
			{
				paramsModel = m[2];
				this.results.length = paramsModel.length + 1;	// must also fit 'ret'
			}
			else
				this.results.length = 1;      // to fit 'ret'
			break;
		case 20:	// object_exp
			this.object_type = this.runtime.types_by_index[m[1]];
;
			this.beh_index = -1;
			this.func = m[2];
			this.return_string = m[3];
			if (m[4])
				this.instance_expr = new cr.expNode(owner_, m[4]);
			else
				this.instance_expr = null;
			this.results = [];
			this.parameters = [];
			if (m.length === 6)
			{
				paramsModel = m[5];
				this.results.length = paramsModel.length + 1;
			}
			else
				this.results.length = 1;	// to fit 'ret'
			break;
		case 21:		// instvar_exp
			this.object_type = this.runtime.types_by_index[m[1]];
;
			this.return_string = m[2];
			if (m[3])
				this.instance_expr = new cr.expNode(owner_, m[3]);
			else
				this.instance_expr = null;
			this.varindex = m[4];
			break;
		case 22:		// behavior_exp
			this.object_type = this.runtime.types_by_index[m[1]];
;
			this.behavior_type = this.object_type.getBehaviorByName(m[2]);
;
			this.beh_index = this.object_type.getBehaviorIndexByName(m[2]);
			this.func = m[3];
			this.return_string = m[4];
			if (m[5])
				this.instance_expr = new cr.expNode(owner_, m[5]);
			else
				this.instance_expr = null;
			this.results = [];
			this.parameters = [];
			if (m.length === 7)
			{
				paramsModel = m[6];
				this.results.length = paramsModel.length + 1;
			}
			else
				this.results.length = 1;	// to fit 'ret'
			break;
		case 23:		// eventvar_exp
			this.varname = m[1];
			this.eventvar = null;	// assigned in postInit
			break;
		}
		if (this.type >= 4 && this.type <= 17)
		{
			this.first = new cr.expNode(owner_, m[1]);
			this.second = new cr.expNode(owner_, m[2]);
		}
		if (paramsModel)
		{
			var i, len;
			for (i = 0, len = paramsModel.length; i < len; i++)
				this.parameters.push(new cr.expNode(owner_, paramsModel[i]));
		}
		cr.seal(this);
	};
	ExpNode.prototype.postInit = function ()
	{
		if (this.type === 23)	// eventvar_exp
		{
			this.eventvar = this.owner.runtime.getEventVariableByName(this.varname, this.owner.block.parent);
;
		}
		if (this.first)
			this.first.postInit();
		if (this.second)
			this.second.postInit();
		if (this.third)
			this.third.postInit();
		if (this.instance_expr)
			this.instance_expr.postInit();
		if (this.parameters)
		{
			var i, len;
			for (i = 0, len = this.parameters.length; i < len; i++)
				this.parameters[i].postInit();
		}
	};
	ExpNode.prototype.eval_system_exp = function (ret)
	{
		this.results[0] = ret;
		var temp = this.owner.pushTempValue();
		var i, len;
		for (i = 0, len = this.parameters.length; i < len; i++)
		{
			this.parameters[i].get(temp);
			this.results[i + 1] = temp.data;   // passing actual javascript value as argument instead of expvalue
		}
		this.owner.popTempValue();
		this.func.apply(this.runtime.system, this.results);
	};
	ExpNode.prototype.eval_object_behavior_exp = function (ret)
	{
		var sol = this.object_type.getCurrentSol();
		var instances = sol.getObjects();
		if (!instances.length)
		{
			if (sol.else_instances.length)
				instances = sol.else_instances;
			else
			{
				if (this.return_string)
					ret.set_string("");
				else
					ret.set_int(0);
				return;
			}
		}
		this.results[0] = ret;
		ret.object_class = this.object_type;		// so expression can access family type if need be
		var temp = this.owner.pushTempValue();
		var i, len;
		for (i = 0, len = this.parameters.length; i < len; i++) {
			this.parameters[i].get(temp);
			this.results[i + 1] = temp.data;   // passing actual javascript value as argument instead of expvalue
		}
		var index = this.owner.solindex;
		if (this.instance_expr) {
			this.instance_expr.get(temp);
			if (temp.is_number()) {
				index = temp.data;
				instances = this.object_type.instances;    // pick from all instances, not SOL
			}
		}
		this.owner.popTempValue();
		index %= instances.length;      // wraparound
		if (index < 0)
			index += instances.length;
		var returned_val;
		var inst = instances[index];
		if (this.beh_index > -1)
		{
			var offset = 0;
			if (this.object_type.is_family)
			{
				offset = inst.type.family_beh_map[this.object_type.family_index];
			}
			returned_val = this.func.apply(inst.behavior_insts[this.beh_index + offset], this.results);
		}
		else
			returned_val = this.func.apply(inst, this.results);
;
	};
	ExpNode.prototype.eval_instvar_exp = function (ret)
	{
		var sol = this.object_type.getCurrentSol();
		var instances = sol.getObjects();
		if (!instances.length)
		{
			if (sol.else_instances.length)
				instances = sol.else_instances;
			else
			{
				if (this.return_string)
					ret.set_string("");
				else
					ret.set_int(0);
				return;
			}
		}
		var index = this.owner.solindex;
		if (this.instance_expr)
		{
			var temp = this.owner.pushTempValue();
			this.instance_expr.get(temp);
			if (temp.is_number())
			{
				index = temp.data;
				var type_instances = this.object_type.instances;
				index %= type_instances.length;     // wraparound
				if (index < 0)                      // offset
					index += type_instances.length;
				var to_ret = type_instances[index].instance_vars[this.varindex];
				if (cr.is_string(to_ret))
					ret.set_string(to_ret);
				else
					ret.set_float(to_ret);
				this.owner.popTempValue();
				return;         // done
			}
			this.owner.popTempValue();
		}
		index %= instances.length;      // wraparound
		if (index < 0)
			index += instances.length;
		var inst = instances[index];
		var offset = 0;
		if (this.object_type.is_family)
		{
			offset = inst.type.family_var_map[this.object_type.family_index];
		}
		var to_ret = inst.instance_vars[this.varindex + offset];
		if (cr.is_string(to_ret))
			ret.set_string(to_ret);
		else
			ret.set_float(to_ret);
	};
	ExpNode.prototype.eval_int = function (ret)
	{
		ret.type = cr.exptype.Integer;
		ret.data = this.value;
	};
	ExpNode.prototype.eval_float = function (ret)
	{
		ret.type = cr.exptype.Float;
		ret.data = this.value;
	};
	ExpNode.prototype.eval_string = function (ret)
	{
		ret.type = cr.exptype.String;
		ret.data = this.value;
	};
	ExpNode.prototype.eval_unaryminus = function (ret)
	{
		this.first.get(ret);                // retrieve operand
		if (ret.is_number())
			ret.data = -ret.data;
	};
	ExpNode.prototype.eval_add = function (ret)
	{
		this.first.get(ret);                // left operand
		var temp = this.owner.pushTempValue();
		this.second.get(temp);			// right operand
		if (ret.is_number() && temp.is_number())
		{
			ret.data += temp.data;          // both operands numbers: add
			if (temp.is_float())
				ret.make_float();
		}
		this.owner.popTempValue();
	};
	ExpNode.prototype.eval_subtract = function (ret)
	{
		this.first.get(ret);                // left operand
		var temp = this.owner.pushTempValue();
		this.second.get(temp);			// right operand
		if (ret.is_number() && temp.is_number())
		{
			ret.data -= temp.data;          // both operands numbers: subtract
			if (temp.is_float())
				ret.make_float();
		}
		this.owner.popTempValue();
	};
	ExpNode.prototype.eval_multiply = function (ret)
	{
		this.first.get(ret);                // left operand
		var temp = this.owner.pushTempValue();
		this.second.get(temp);			// right operand
		if (ret.is_number() && temp.is_number())
		{
			ret.data *= temp.data;          // both operands numbers: multiply
			if (temp.is_float())
				ret.make_float();
		}
		this.owner.popTempValue();
	};
	ExpNode.prototype.eval_divide = function (ret)
	{
		this.first.get(ret);                // left operand
		var temp = this.owner.pushTempValue();
		this.second.get(temp);			// right operand
		if (ret.is_number() && temp.is_number())
		{
			ret.data /= temp.data;          // both operands numbers: divide
			ret.make_float();
		}
		this.owner.popTempValue();
	};
	ExpNode.prototype.eval_mod = function (ret)
	{
		this.first.get(ret);                // left operand
		var temp = this.owner.pushTempValue();
		this.second.get(temp);			// right operand
		if (ret.is_number() && temp.is_number())
		{
			ret.data %= temp.data;          // both operands numbers: modulo
			if (temp.is_float())
				ret.make_float();
		}
		this.owner.popTempValue();
	};
	ExpNode.prototype.eval_power = function (ret)
	{
		this.first.get(ret);                // left operand
		var temp = this.owner.pushTempValue();
		this.second.get(temp);			// right operand
		if (ret.is_number() && temp.is_number())
		{
			ret.data = Math.pow(ret.data, temp.data);   // both operands numbers: raise to power
			if (temp.is_float())
				ret.make_float();
		}
		this.owner.popTempValue();
	};
	ExpNode.prototype.eval_and = function (ret)
	{
		this.first.get(ret);                // left operand
		var temp = this.owner.pushTempValue();
		this.second.get(temp);			// right operand
		if (ret.is_number())
		{
			if (temp.is_string())
			{
				ret.set_string(ret.data.toString() + temp.data);
			}
			else
			{
				if (ret.data && temp.data)
					ret.set_int(1);
				else
					ret.set_int(0);
			}
		}
		else if (ret.is_string())
		{
			if (temp.is_string())
				ret.data += temp.data;
			else
			{
				ret.data += (Math.round(temp.data * 1e10) / 1e10).toString();
			}
		}
		this.owner.popTempValue();
	};
	ExpNode.prototype.eval_or = function (ret)
	{
		this.first.get(ret);                // left operand
		var temp = this.owner.pushTempValue();
		this.second.get(temp);			// right operand
		if (ret.is_number() && temp.is_number())
		{
			if (ret.data || temp.data)
				ret.set_int(1);
			else
				ret.set_int(0);
		}
		this.owner.popTempValue();
	};
	ExpNode.prototype.eval_conditional = function (ret)
	{
		this.first.get(ret);                // condition operand
		if (ret.data)                       // is true
			this.second.get(ret);           // evaluate second operand to ret
		else
			this.third.get(ret);            // evaluate third operand to ret
	};
	ExpNode.prototype.eval_equal = function (ret)
	{
		this.first.get(ret);                // left operand
		var temp = this.owner.pushTempValue();
		this.second.get(temp);			// right operand
		ret.set_int(ret.data === temp.data ? 1 : 0);
		this.owner.popTempValue();
	};
	ExpNode.prototype.eval_notequal = function (ret)
	{
		this.first.get(ret);                // left operand
		var temp = this.owner.pushTempValue();
		this.second.get(temp);			// right operand
		ret.set_int(ret.data !== temp.data ? 1 : 0);
		this.owner.popTempValue();
	};
	ExpNode.prototype.eval_less = function (ret)
	{
		this.first.get(ret);                // left operand
		var temp = this.owner.pushTempValue();
		this.second.get(temp);			// right operand
		ret.set_int(ret.data < temp.data ? 1 : 0);
		this.owner.popTempValue();
	};
	ExpNode.prototype.eval_lessequal = function (ret)
	{
		this.first.get(ret);                // left operand
		var temp = this.owner.pushTempValue();
		this.second.get(temp);			// right operand
		ret.set_int(ret.data <= temp.data ? 1 : 0);
		this.owner.popTempValue();
	};
	ExpNode.prototype.eval_greater = function (ret)
	{
		this.first.get(ret);                // left operand
		var temp = this.owner.pushTempValue();
		this.second.get(temp);			// right operand
		ret.set_int(ret.data > temp.data ? 1 : 0);
		this.owner.popTempValue();
	};
	ExpNode.prototype.eval_greaterequal = function (ret)
	{
		this.first.get(ret);                // left operand
		var temp = this.owner.pushTempValue();
		this.second.get(temp);			// right operand
		ret.set_int(ret.data >= temp.data ? 1 : 0);
		this.owner.popTempValue();
	};
	ExpNode.prototype.eval_eventvar_exp = function (ret)
	{
		var val = this.eventvar.getValue();
		if (cr.is_number(val))
			ret.set_float(val);
		else
			ret.set_string(val);
	};
	cr.expNode = ExpNode;
	function ExpValue(type, data)
	{
		this.type = type || cr.exptype.Integer;
		this.data = data || 0;
		this.object_class = null;
;
;
;
		if (this.type == cr.exptype.Integer)
			this.data = Math.floor(this.data);
		cr.seal(this);
	};
	ExpValue.prototype.is_int = function ()
	{
		return this.type === cr.exptype.Integer;
	};
	ExpValue.prototype.is_float = function ()
	{
		return this.type === cr.exptype.Float;
	};
	ExpValue.prototype.is_number = function ()
	{
		return this.type === cr.exptype.Integer || this.type === cr.exptype.Float;
	};
	ExpValue.prototype.is_string = function ()
	{
		return this.type === cr.exptype.String;
	};
	ExpValue.prototype.make_int = function ()
	{
		if (!this.is_int())
		{
			if (this.is_float())
				this.data = Math.floor(this.data);      // truncate float
			else if (this.is_string())
				this.data = parseInt(this.data, 10);
			this.type = cr.exptype.Integer;
		}
	};
	ExpValue.prototype.make_float = function ()
	{
		if (!this.is_float())
		{
			if (this.is_string())
				this.data = parseFloat(this.data);
			this.type = cr.exptype.Float;
		}
	};
	ExpValue.prototype.make_string = function ()
	{
		if (!this.is_string())
		{
			this.data = this.data.toString();
			this.type = cr.exptype.String;
		}
	};
	ExpValue.prototype.set_int = function (val)
	{
;
		this.type = cr.exptype.Integer;
		this.data = Math.floor(val);
	};
	ExpValue.prototype.set_float = function (val)
	{
;
		this.type = cr.exptype.Float;
		this.data = val;
	};
	ExpValue.prototype.set_string = function (val)
	{
;
		this.type = cr.exptype.String;
		this.data = val;
	};
	ExpValue.prototype.set_any = function (val)
	{
		if (cr.is_number(val))
		{
			this.type = cr.exptype.Float;
			this.data = val;
		}
		else if (cr.is_string(val))
		{
			this.type = cr.exptype.String;
			this.data = val.toString();
		}
		else
		{
			this.type = cr.exptype.Integer;
			this.data = 0;
		}
	};
	cr.expvalue = ExpValue;
	cr.exptype = {
		Integer: 0,     // emulated; no native integer support in javascript
		Float: 1,
		String: 2
	};
}());
;
cr.system_object = function (runtime)
{
    this.runtime = runtime;
	this.waits = [];
};
cr.system_object.prototype.saveToJSON = function ()
{
	var o = {};
	var i, len, j, lenj, p, w, t, sobj;
	o["waits"] = [];
	var owaits = o["waits"];
	var waitobj;
	for (i = 0, len = this.waits.length; i < len; i++)
	{
		w = this.waits[i];
		waitobj = {
			"t": w.time,
			"ev": w.ev.sid,
			"sm": [],
			"sols": {}
		};
		if (w.ev.actions[w.actindex])
			waitobj["act"] = w.ev.actions[w.actindex].sid;
		for (j = 0, lenj = w.solModifiers.length; j < lenj; j++)
			waitobj["sm"].push(w.solModifiers[j].sid);
		for (p in w.sols)
		{
			if (w.sols.hasOwnProperty(p))
			{
				t = this.runtime.types_by_index[parseInt(p, 10)];
;
				sobj = {
					"sa": w.sols[p].sa,
					"insts": []
				};
				for (j = 0, lenj = w.sols[p].insts.length; j < lenj; j++)
					sobj["insts"].push(w.sols[p].insts[j].uid);
				waitobj["sols"][t.sid.toString()] = sobj;
			}
		}
		owaits.push(waitobj);
	}
	return o;
};
cr.system_object.prototype.loadFromJSON = function (o)
{
	var owaits = o["waits"];
	var i, len, j, lenj, p, w, addWait, e, aindex, t, savedsol, nusol, inst;
	this.waits.length = 0;
	for (i = 0, len = owaits.length; i < len; i++)
	{
		w = owaits[i];
		e = this.runtime.blocksBySid[w["ev"].toString()];
		if (!e)
			continue;	// event must've gone missing
		aindex = -1;
		for (j = 0, lenj = e.actions.length; j < lenj; j++)
		{
			if (e.actions[j].sid === w["act"])
			{
				aindex = j;
				break;
			}
		}
		if (aindex === -1)
			continue;	// action must've gone missing
		addWait = {};
		addWait.sols = {};
		addWait.solModifiers = [];
		addWait.deleteme = false;
		addWait.time = w["t"];
		addWait.ev = e;
		addWait.actindex = aindex;
		for (j = 0, lenj = w["sm"].length; j < lenj; j++)
		{
			t = this.runtime.getObjectTypeBySid(w["sm"][j]);
			if (t)
				addWait.solModifiers.push(t);
		}
		for (p in w["sols"])
		{
			if (w["sols"].hasOwnProperty(p))
			{
				t = this.runtime.getObjectTypeBySid(parseInt(p, 10));
				if (!t)
					continue;		// type must've been deleted
				savedsol = w["sols"][p];
				nusol = {
					sa: savedsol["sa"],
					insts: []
				};
				for (j = 0, lenj = savedsol["insts"].length; j < lenj; j++)
				{
					inst = this.runtime.getObjectByUID(savedsol["insts"][j]);
					if (inst)
						nusol.insts.push(inst);
				}
				addWait.sols[t.index.toString()] = nusol;
			}
		}
		this.waits.push(addWait);
	}
};
(function ()
{
	var sysProto = cr.system_object.prototype;
	function SysCnds() {};
    SysCnds.prototype.EveryTick = function()
    {
        return true;
    };
    SysCnds.prototype.OnLayoutStart = function()
    {
        return true;
    };
    SysCnds.prototype.OnLayoutEnd = function()
    {
        return true;
    };
    SysCnds.prototype.Compare = function(x, cmp, y)
    {
        return cr.do_cmp(x, cmp, y);
    };
    SysCnds.prototype.CompareTime = function (cmp, t)
    {
        var elapsed = this.runtime.kahanTime.sum;
        if (cmp === 0)
        {
            var cnd = this.runtime.getCurrentCondition();
            if (!cnd.extra.CompareTime_executed)
            {
                if (elapsed >= t)
                {
                    cnd.extra.CompareTime_executed = true;
                    return true;
                }
            }
            return false;
        }
        return cr.do_cmp(elapsed, cmp, t);
    };
    SysCnds.prototype.LayerVisible = function (layer)
    {
        if (!layer)
            return false;
        else
            return layer.visible;
    };
	SysCnds.prototype.LayerCmpOpacity = function (layer, cmp, opacity_)
	{
		if (!layer)
			return false;
		return cr.do_cmp(layer.opacity * 100, cmp, opacity_);
	};
    SysCnds.prototype.Repeat = function (count)
    {
		var current_frame = this.runtime.getCurrentEventStack();
        var current_event = current_frame.current_event;
		var solModifierAfterCnds = current_frame.isModifierAfterCnds();
        var current_loop = this.runtime.pushLoopStack();
        var i;
		if (solModifierAfterCnds)
		{
			for (i = 0; i < count && !current_loop.stopped; i++)
			{
				this.runtime.pushCopySol(current_event.solModifiers);
				current_loop.index = i;
				current_event.retrigger();
				this.runtime.popSol(current_event.solModifiers);
			}
		}
		else
		{
			for (i = 0; i < count && !current_loop.stopped; i++)
			{
				current_loop.index = i;
				current_event.retrigger();
			}
		}
        this.runtime.popLoopStack();
		return false;
    };
	SysCnds.prototype.While = function (count)
    {
		var current_frame = this.runtime.getCurrentEventStack();
        var current_event = current_frame.current_event;
		var solModifierAfterCnds = current_frame.isModifierAfterCnds();
        var current_loop = this.runtime.pushLoopStack();
        var i;
		if (solModifierAfterCnds)
		{
			for (i = 0; !current_loop.stopped; i++)
			{
				this.runtime.pushCopySol(current_event.solModifiers);
				current_loop.index = i;
				if (!current_event.retrigger())		// one of the other conditions returned false
					current_loop.stopped = true;	// break
				this.runtime.popSol(current_event.solModifiers);
			}
		}
		else
		{
			for (i = 0; !current_loop.stopped; i++)
			{
				current_loop.index = i;
				if (!current_event.retrigger())
					current_loop.stopped = true;
			}
		}
        this.runtime.popLoopStack();
		return false;
    };
    SysCnds.prototype.For = function (name, start, end)
    {
        var current_frame = this.runtime.getCurrentEventStack();
        var current_event = current_frame.current_event;
		var solModifierAfterCnds = current_frame.isModifierAfterCnds();
        var current_loop = this.runtime.pushLoopStack(name);
        var i;
		if (end < start)
		{
			if (solModifierAfterCnds)
			{
				for (i = start; i >= end && !current_loop.stopped; --i)  // inclusive to end
				{
					this.runtime.pushCopySol(current_event.solModifiers);
					current_loop.index = i;
					current_event.retrigger();
					this.runtime.popSol(current_event.solModifiers);
				}
			}
			else
			{
				for (i = start; i >= end && !current_loop.stopped; --i)  // inclusive to end
				{
					current_loop.index = i;
					current_event.retrigger();
				}
			}
		}
		else
		{
			if (solModifierAfterCnds)
			{
				for (i = start; i <= end && !current_loop.stopped; ++i)  // inclusive to end
				{
					this.runtime.pushCopySol(current_event.solModifiers);
					current_loop.index = i;
					current_event.retrigger();
					this.runtime.popSol(current_event.solModifiers);
				}
			}
			else
			{
				for (i = start; i <= end && !current_loop.stopped; ++i)  // inclusive to end
				{
					current_loop.index = i;
					current_event.retrigger();
				}
			}
		}
        this.runtime.popLoopStack();
		return false;
    };
	var foreach_instancestack = [];
	var foreach_instanceptr = -1;
    SysCnds.prototype.ForEach = function (obj)
    {
        var sol = obj.getCurrentSol();
		foreach_instanceptr++;
		if (foreach_instancestack.length === foreach_instanceptr)
			foreach_instancestack.push([]);
		var instances = foreach_instancestack[foreach_instanceptr];
		cr.shallowAssignArray(instances, sol.getObjects());
        var current_frame = this.runtime.getCurrentEventStack();
        var current_event = current_frame.current_event;
		var solModifierAfterCnds = current_frame.isModifierAfterCnds();
        var current_loop = this.runtime.pushLoopStack();
        var i, len, j, lenj, inst, s, sol2;
		var is_contained = obj.is_contained;
		if (solModifierAfterCnds)
		{
			for (i = 0, len = instances.length; i < len && !current_loop.stopped; i++)
			{
				this.runtime.pushCopySol(current_event.solModifiers);
				inst = instances[i];
				sol = obj.getCurrentSol();
				sol.select_all = false;
				sol.instances.length = 1;
				sol.instances[0] = inst;
				if (is_contained)
				{
					for (j = 0, lenj = inst.siblings.length; j < lenj; j++)
					{
						s = inst.siblings[j];
						sol2 = s.type.getCurrentSol();
						sol2.select_all = false;
						sol2.instances.length = 1;
						sol2.instances[0] = s;
					}
				}
				current_loop.index = i;
				current_event.retrigger();
				this.runtime.popSol(current_event.solModifiers);
			}
		}
		else
		{
			sol.select_all = false;
			sol.instances.length = 1;
			for (i = 0, len = instances.length; i < len && !current_loop.stopped; i++)
			{
				inst = instances[i];
				sol.instances[0] = inst;
				if (is_contained)
				{
					for (j = 0, lenj = inst.siblings.length; j < lenj; j++)
					{
						s = inst.siblings[j];
						sol2 = s.type.getCurrentSol();
						sol2.select_all = false;
						sol2.instances.length = 1;
						sol2.instances[0] = s;
					}
				}
				current_loop.index = i;
				current_event.retrigger();
			}
		}
		instances.length = 0;
        this.runtime.popLoopStack();
		foreach_instanceptr--;
		return false;
    };
	function foreach_sortinstances(a, b)
	{
		var va = a.extra.c2_foreachordered_val;
		var vb = b.extra.c2_foreachordered_val;
		if (cr.is_number(va) && cr.is_number(vb))
			return va - vb;
		else
		{
			va = "" + va;
			vb = "" + vb;
			if (va < vb)
				return -1;
			else if (va > vb)
				return 1;
			else
				return 0;
		}
	};
	SysCnds.prototype.ForEachOrdered = function (obj, exp, order)
    {
        var sol = obj.getCurrentSol();
		foreach_instanceptr++;
		if (foreach_instancestack.length === foreach_instanceptr)
			foreach_instancestack.push([]);
		var instances = foreach_instancestack[foreach_instanceptr];
		cr.shallowAssignArray(instances, sol.getObjects());
        var current_frame = this.runtime.getCurrentEventStack();
        var current_event = current_frame.current_event;
		var current_condition = this.runtime.getCurrentCondition();
		var solModifierAfterCnds = current_frame.isModifierAfterCnds();
        var current_loop = this.runtime.pushLoopStack();
		var i, len, j, lenj, inst, s, sol2;
		for (i = 0, len = instances.length; i < len; i++)
		{
			instances[i].extra.c2_foreachordered_val = current_condition.parameters[1].get(i);
		}
		instances.sort(foreach_sortinstances);
		if (order === 1)
			instances.reverse();
		var is_contained = obj.is_contained;
		if (solModifierAfterCnds)
		{
			for (i = 0, len = instances.length; i < len && !current_loop.stopped; i++)
			{
				this.runtime.pushCopySol(current_event.solModifiers);
				inst = instances[i];
				sol = obj.getCurrentSol();
				sol.select_all = false;
				sol.instances.length = 1;
				sol.instances[0] = inst;
				if (is_contained)
				{
					for (j = 0, lenj = inst.siblings.length; j < lenj; j++)
					{
						s = inst.siblings[j];
						sol2 = s.type.getCurrentSol();
						sol2.select_all = false;
						sol2.instances.length = 1;
						sol2.instances[0] = s;
					}
				}
				current_loop.index = i;
				current_event.retrigger();
				this.runtime.popSol(current_event.solModifiers);
			}
		}
		else
		{
			sol.select_all = false;
			sol.instances.length = 1;
			for (i = 0, len = instances.length; i < len && !current_loop.stopped; i++)
			{
				inst = instances[i];
				sol.instances[0] = inst;
				if (is_contained)
				{
					for (j = 0, lenj = inst.siblings.length; j < lenj; j++)
					{
						s = inst.siblings[j];
						sol2 = s.type.getCurrentSol();
						sol2.select_all = false;
						sol2.instances.length = 1;
						sol2.instances[0] = s;
					}
				}
				current_loop.index = i;
				current_event.retrigger();
			}
		}
		instances.length = 0;
        this.runtime.popLoopStack();
		foreach_instanceptr--;
		return false;
    };
	SysCnds.prototype.PickByComparison = function (obj_, exp_, cmp_, val_)
	{
		var i, len, k, inst;
		if (!obj_)
			return;
		foreach_instanceptr++;
		if (foreach_instancestack.length === foreach_instanceptr)
			foreach_instancestack.push([]);
		var tmp_instances = foreach_instancestack[foreach_instanceptr];
		var sol = obj_.getCurrentSol();
		cr.shallowAssignArray(tmp_instances, sol.getObjects());
		if (sol.select_all)
			sol.else_instances.length = 0;
		var current_condition = this.runtime.getCurrentCondition();
		for (i = 0, k = 0, len = tmp_instances.length; i < len; i++)
		{
			inst = tmp_instances[i];
			tmp_instances[k] = inst;
			exp_ = current_condition.parameters[1].get(i);
			val_ = current_condition.parameters[3].get(i);
			if (cr.do_cmp(exp_, cmp_, val_))
			{
				k++;
			}
			else
			{
				sol.else_instances.push(inst);
			}
		}
		tmp_instances.length = k;
		sol.select_all = false;
		cr.shallowAssignArray(sol.instances, tmp_instances);
		tmp_instances.length = 0;
		foreach_instanceptr--;
		obj_.applySolToContainer();
		return !!sol.instances.length;
	};
	SysCnds.prototype.PickByEvaluate = function (obj_, exp_)
	{
		var i, len, k, inst;
		if (!obj_)
			return;
		foreach_instanceptr++;
		if (foreach_instancestack.length === foreach_instanceptr)
			foreach_instancestack.push([]);
		var tmp_instances = foreach_instancestack[foreach_instanceptr];
		var sol = obj_.getCurrentSol();
		cr.shallowAssignArray(tmp_instances, sol.getObjects());
		if (sol.select_all)
			sol.else_instances.length = 0;
		var current_condition = this.runtime.getCurrentCondition();
		for (i = 0, k = 0, len = tmp_instances.length; i < len; i++)
		{
			inst = tmp_instances[i];
			tmp_instances[k] = inst;
			exp_ = current_condition.parameters[1].get(i);
			if (exp_)
			{
				k++;
			}
			else
			{
				sol.else_instances.push(inst);
			}
		}
		tmp_instances.length = k;
		sol.select_all = false;
		cr.shallowAssignArray(sol.instances, tmp_instances);
		tmp_instances.length = 0;
		foreach_instanceptr--;
		obj_.applySolToContainer();
		return !!sol.instances.length;
	};
    SysCnds.prototype.TriggerOnce = function ()
    {
        var cndextra = this.runtime.getCurrentCondition().extra;
		if (typeof cndextra.TriggerOnce_lastTick === "undefined")
			cndextra.TriggerOnce_lastTick = -1;
        var last_tick = cndextra.TriggerOnce_lastTick;
        var cur_tick = this.runtime.tickcount;
        cndextra.TriggerOnce_lastTick = cur_tick;
        return this.runtime.layout_first_tick || last_tick !== cur_tick - 1;
    };
    SysCnds.prototype.Every = function (seconds)
    {
        var cnd = this.runtime.getCurrentCondition();
        var last_time = cnd.extra.Every_lastTime || 0;
        var cur_time = this.runtime.kahanTime.sum;
		if (typeof cnd.extra.Every_seconds === "undefined")
			cnd.extra.Every_seconds = seconds;
		var this_seconds = cnd.extra.Every_seconds;
        if (cur_time >= last_time + this_seconds)
        {
            cnd.extra.Every_lastTime = last_time + this_seconds;
			if (cur_time >= cnd.extra.Every_lastTime + this_seconds)
				cnd.extra.Every_lastTime = cur_time;
			cnd.extra.Every_seconds = seconds;
            return true;
        }
        else
            return false;
    };
    SysCnds.prototype.PickNth = function (obj, index)
    {
        if (!obj)
            return false;
        var sol = obj.getCurrentSol();
        var instances = sol.getObjects();
		index = cr.floor(index);
        if (index < 0 || index >= instances.length)
            return false;
		var inst = instances[index];
        sol.pick_one(inst);
		obj.applySolToContainer();
        return true;
    };
	SysCnds.prototype.PickRandom = function (obj)
    {
        if (!obj)
            return false;
        var sol = obj.getCurrentSol();
        var instances = sol.getObjects();
		var index = cr.floor(Math.random() * instances.length);
        if (index >= instances.length)
            return false;
		var inst = instances[index];
        sol.pick_one(inst);
		obj.applySolToContainer();
        return true;
    };
	SysCnds.prototype.CompareVar = function (v, cmp, val)
    {
        return cr.do_cmp(v.getValue(), cmp, val);
    };
    SysCnds.prototype.IsGroupActive = function (group)
    {
        return this.runtime.activeGroups[(/*this.runtime.getCurrentCondition().sheet.name + "|" + */group).toLowerCase()];
    };
	SysCnds.prototype.IsPreview = function ()
	{
		return typeof cr_is_preview !== "undefined";
	};
	SysCnds.prototype.PickAll = function (obj)
    {
        if (!obj)
            return false;
		if (!obj.instances.length)
			return false;
        var sol = obj.getCurrentSol();
        sol.select_all = true;
		obj.applySolToContainer();
        return true;
    };
	SysCnds.prototype.IsMobile = function ()
	{
		return this.runtime.isMobile;
	};
	SysCnds.prototype.CompareBetween = function (x, a, b)
	{
		return x >= a && x <= b;
	};
	SysCnds.prototype.Else = function ()
	{
		var current_frame = this.runtime.getCurrentEventStack();
		if (current_frame.else_branch_ran)
			return false;		// another event in this else-if chain has run
		else
			return !current_frame.last_event_true;
		/*
		var current_frame = this.runtime.getCurrentEventStack();
        var current_event = current_frame.current_event;
		var prev_event = current_event.prev_block;
		if (!prev_event)
			return false;
		if (prev_event.is_logical)
			return !this.runtime.last_event_true;
		var i, len, j, lenj, s, sol, temp, inst, any_picked = false;
		for (i = 0, len = prev_event.cndReferences.length; i < len; i++)
		{
			s = prev_event.cndReferences[i];
			sol = s.getCurrentSol();
			if (sol.select_all || sol.instances.length === s.instances.length)
			{
				sol.select_all = false;
				sol.instances.length = 0;
			}
			else
			{
				if (sol.instances.length === 1 && sol.else_instances.length === 0 && s.instances.length >= 2)
				{
					inst = sol.instances[0];
					sol.instances.length = 0;
					for (j = 0, lenj = s.instances.length; j < lenj; j++)
					{
						if (s.instances[j] != inst)
							sol.instances.push(s.instances[j]);
					}
					any_picked = true;
				}
				else
				{
					temp = sol.instances;
					sol.instances = sol.else_instances;
					sol.else_instances = temp;
					any_picked = true;
				}
			}
		}
		return any_picked;
		*/
	};
	SysCnds.prototype.OnLoadFinished = function ()
	{
		return true;
	};
	SysCnds.prototype.OnCanvasSnapshot = function ()
	{
		return true;
	};
	SysCnds.prototype.EffectsSupported = function ()
	{
		return !!this.runtime.glwrap;
	};
	SysCnds.prototype.OnSaveComplete = function ()
	{
		return true;
	};
	SysCnds.prototype.OnLoadComplete = function ()
	{
		return true;
	};
	SysCnds.prototype.OnLoadFailed = function ()
	{
		return true;
	};
	SysCnds.prototype.ObjectUIDExists = function (u)
	{
		return !!this.runtime.getObjectByUID(u);
	};
	SysCnds.prototype.IsOnPlatform = function (p)
	{
		var rt = this.runtime;
		switch (p) {
		case 0:		// HTML5 website
			return !rt.isDomFree && !rt.isNodeWebkit && !rt.isPhoneGap && !rt.isWindows8App && !rt.isWindowsPhone8 && !rt.isBlackberry10;
		case 1:		// iOS
			return rt.isiOS;
		case 2:		// Android
			return rt.isAndroid;
		case 3:		// Windows 8
			return rt.isWindows8App;
		case 4:		// Windows Phone 8
			return rt.isWindowsPhone8;
		case 5:		// Blackberry 10
			return rt.isBlackberry10;
		case 6:		// Tizen
			return rt.isTizen;
		case 7:		// node-webkit
			return rt.isNodeWebkit;
		case 8:		// CocoonJS
			return rt.isCocoonJs;
		case 9:		// PhoneGap
			return rt.isPhoneGap;
		case 10:	// Scirra Arcade
			return rt.isArcade;
		case 11:	// node-webkit
			return rt.isNodeWebkit;
		default:	// should not be possible
			return false;
		}
	};
	var cacheRegex = null;
	var lastRegex = "";
	var lastFlags = "";
	function getRegex(regex_, flags_)
	{
		if (!cacheRegex || regex_ !== lastRegex || flags_ !== lastFlags)
		{
			cacheRegex = new RegExp(regex_, flags_);
			lastRegex = regex_;
			lastFlags = flags_;
		}
		cacheRegex.lastIndex = 0;		// reset
		return cacheRegex;
	};
	SysCnds.prototype.RegexTest = function (str_, regex_, flags_)
	{
		var regex = getRegex(regex_, flags_);
		return regex.test(str_);
	};
	var tmp_arr = [];
	SysCnds.prototype.PickOverlappingPoint = function (obj_, x_, y_)
	{
		if (!obj_)
            return false;
        var sol = obj_.getCurrentSol();
        var instances = sol.getObjects();
		var current_event = this.runtime.getCurrentEventStack().current_event;
		var orblock = current_event.orblock;
		var cnd = this.runtime.getCurrentCondition();
		var i, len, inst, pick;
		if (sol.select_all)
		{
			cr.shallowAssignArray(tmp_arr, instances);
			sol.else_instances.length = 0;
			sol.select_all = false;
			sol.instances.length = 0;
		}
		else
		{
			if (orblock)
			{
				cr.shallowAssignArray(tmp_arr, sol.else_instances);
				sol.else_instances.length = 0;
			}
			else
			{
				cr.shallowAssignArray(tmp_arr, instances);
				sol.instances.length = 0;
			}
		}
		for (i = 0, len = tmp_arr.length; i < len; ++i)
		{
			inst = tmp_arr[i];
			pick = cr.xor(inst.contains_pt(x_, y_), cnd.inverted);
			if (pick)
				sol.instances.push(inst);
			else
				sol.else_instances.push(inst);
		}
		obj_.applySolToContainer();
		return cr.xor(!!sol.instances.length, cnd.inverted);
	};
	sysProto.cnds = new SysCnds();
    function SysActs() {};
    SysActs.prototype.GoToLayout = function(to)
    {
		if (this.runtime.isloading)
			return;		// cannot change layout while loading on loader layout
		if (this.runtime.changelayout)
			return;		// already changing to a different layout
;
        this.runtime.changelayout = to;
    };
    SysActs.prototype.CreateObject = function (obj, layer, x, y)
    {
        if (!layer || !obj)
            return;
        var inst = this.runtime.createInstance(obj, layer, x, y);
		if (!inst)
			return;
		this.runtime.isInOnDestroy++;
		var i, len, s;
		this.runtime.trigger(Object.getPrototypeOf(obj.plugin).cnds.OnCreated, inst);
		if (inst.is_contained)
		{
			for (i = 0, len = inst.siblings.length; i < len; i++)
			{
				s = inst.siblings[i];
				this.runtime.trigger(Object.getPrototypeOf(s.type.plugin).cnds.OnCreated, s);
			}
		}
		this.runtime.isInOnDestroy--;
        var sol = obj.getCurrentSol();
        sol.select_all = false;
		sol.instances.length = 1;
		sol.instances[0] = inst;
		if (inst.is_contained)
		{
			for (i = 0, len = inst.siblings.length; i < len; i++)
			{
				s = inst.siblings[i];
				sol = s.type.getCurrentSol();
				sol.select_all = false;
				sol.instances.length = 1;
				sol.instances[0] = s;
			}
		}
    };
    SysActs.prototype.SetLayerVisible = function (layer, visible_)
    {
        if (!layer)
            return;
		if (layer.visible !== visible_)
		{
			layer.visible = visible_;
			this.runtime.redraw = true;
		}
    };
	SysActs.prototype.SetLayerOpacity = function (layer, opacity_)
	{
		if (!layer)
			return;
		opacity_ = cr.clamp(opacity_ / 100, 0, 1);
		if (layer.opacity !== opacity_)
		{
			layer.opacity = opacity_;
			this.runtime.redraw = true;
		}
	};
	SysActs.prototype.SetLayerScaleRate = function (layer, sr)
	{
		if (!layer)
			return;
		if (layer.zoomRate !== sr)
		{
			layer.zoomRate = sr;
			this.runtime.redraw = true;
		}
	};
	SysActs.prototype.SetLayoutScale = function (s)
	{
		if (!this.runtime.running_layout)
			return;
		if (this.runtime.running_layout.scale !== s)
		{
			this.runtime.running_layout.scale = s;
			this.runtime.running_layout.boundScrolling();
			this.runtime.redraw = true;
		}
	};
    SysActs.prototype.ScrollX = function(x)
    {
        this.runtime.running_layout.scrollToX(x);
    };
    SysActs.prototype.ScrollY = function(y)
    {
        this.runtime.running_layout.scrollToY(y);
    };
    SysActs.prototype.Scroll = function(x, y)
    {
        this.runtime.running_layout.scrollToX(x);
        this.runtime.running_layout.scrollToY(y);
    };
    SysActs.prototype.ScrollToObject = function(obj)
    {
        var inst = obj.getFirstPicked();
        if (inst)
        {
            this.runtime.running_layout.scrollToX(inst.x);
            this.runtime.running_layout.scrollToY(inst.y);
        }
    };
	SysActs.prototype.SetVar = function(v, x)
	{
;
		if (v.vartype === 0)
		{
			if (cr.is_number(x))
				v.setValue(x);
			else
				v.setValue(parseFloat(x));
		}
		else if (v.vartype === 1)
			v.setValue(x.toString());
	};
	SysActs.prototype.AddVar = function(v, x)
	{
;
		if (v.vartype === 0)
		{
			if (cr.is_number(x))
				v.setValue(v.getValue() + x);
			else
				v.setValue(v.getValue() + parseFloat(x));
		}
		else if (v.vartype === 1)
			v.setValue(v.getValue() + x.toString());
	};
	SysActs.prototype.SubVar = function(v, x)
	{
;
		if (v.vartype === 0)
		{
			if (cr.is_number(x))
				v.setValue(v.getValue() - x);
			else
				v.setValue(v.getValue() - parseFloat(x));
		}
	};
    SysActs.prototype.SetGroupActive = function (group, active)
    {
		var activeGroups = this.runtime.activeGroups;
		var groupkey = (/*this.runtime.getCurrentAction().sheet.name + "|" + */group).toLowerCase();
		switch (active) {
		case 0:
			activeGroups[groupkey] = false;
			break;
		case 1:
			activeGroups[groupkey] = true;
			break;
		case 2:
			activeGroups[groupkey] = !activeGroups[groupkey];
			break;
		}
    };
    SysActs.prototype.SetTimescale = function (ts_)
    {
        var ts = ts_;
        if (ts < 0)
            ts = 0;
        this.runtime.timescale = ts;
    };
    SysActs.prototype.SetObjectTimescale = function (obj, ts_)
    {
        var ts = ts_;
        if (ts < 0)
            ts = 0;
        if (!obj)
            return;
        var sol = obj.getCurrentSol();
        var instances = sol.getObjects();
        var i, len;
        for (i = 0, len = instances.length; i < len; i++)
        {
            instances[i].my_timescale = ts;
        }
    };
    SysActs.prototype.RestoreObjectTimescale = function (obj)
    {
        if (!obj)
            return false;
        var sol = obj.getCurrentSol();
        var instances = sol.getObjects();
        var i, len;
        for (i = 0, len = instances.length; i < len; i++)
        {
            instances[i].my_timescale = -1.0;
        }
    };
	var waitobjrecycle = [];
	function allocWaitObject()
	{
		var w;
		if (waitobjrecycle.length)
			w = waitobjrecycle.pop();
		else
		{
			w = {};
			w.sols = {};
			w.solModifiers = [];
		}
		w.deleteme = false;
		return w;
	};
	function freeWaitObject(w)
	{
		cr.wipe(w.sols);
		w.solModifiers.length = 0;
		waitobjrecycle.push(w);
	};
	var solstateobjects = [];
	function allocSolStateObject()
	{
		var s;
		if (solstateobjects.length)
			s = solstateobjects.pop();
		else
		{
			s = {};
			s.insts = [];
		}
		s.sa = false;
		return s;
	};
	function freeSolStateObject(s)
	{
		s.insts.length = 0;
		solstateobjects.push(s);
	};
	SysActs.prototype.Wait = function (seconds)
	{
		if (seconds < 0)
			return;
		var i, len, s, t, ss;
		var evinfo = this.runtime.getCurrentEventStack();
		var waitobj = allocWaitObject();
		waitobj.time = this.runtime.kahanTime.sum + seconds;
		waitobj.ev = evinfo.current_event;
		waitobj.actindex = evinfo.actindex + 1;	// pointing at next action
		for (i = 0, len = this.runtime.types_by_index.length; i < len; i++)
		{
			t = this.runtime.types_by_index[i];
			s = t.getCurrentSol();
			if (s.select_all && evinfo.current_event.solModifiers.indexOf(t) === -1)
				continue;
			waitobj.solModifiers.push(t);
			ss = allocSolStateObject();
			ss.sa = s.select_all;
			cr.shallowAssignArray(ss.insts, s.instances);
			waitobj.sols[i.toString()] = ss;
		}
		this.waits.push(waitobj);
		return true;
	};
	SysActs.prototype.SetLayerScale = function (layer, scale)
    {
        if (!layer)
            return;
		if (layer.scale === scale)
			return;
        layer.scale = scale;
        this.runtime.redraw = true;
    };
	SysActs.prototype.ResetGlobals = function ()
	{
		var i, len, g;
		for (i = 0, len = this.runtime.all_global_vars.length; i < len; i++)
		{
			g = this.runtime.all_global_vars[i];
			g.data = g.initial;
		}
	};
	SysActs.prototype.SetLayoutAngle = function (a)
	{
		a = cr.to_radians(a);
		a = cr.clamp_angle(a);
		if (this.runtime.running_layout)
		{
			if (this.runtime.running_layout.angle !== a)
			{
				this.runtime.running_layout.angle = a;
				this.runtime.redraw = true;
			}
		}
	};
	SysActs.prototype.SetLayerAngle = function (layer, a)
    {
        if (!layer)
            return;
		a = cr.to_radians(a);
		a = cr.clamp_angle(a);
		if (layer.angle === a)
			return;
        layer.angle = a;
        this.runtime.redraw = true;
    };
	SysActs.prototype.SetLayerParallax = function (layer, px, py)
    {
        if (!layer)
            return;
		if (layer.parallaxX === px / 100 && layer.parallaxY === py / 100)
			return;
        layer.parallaxX = px / 100;
		layer.parallaxY = py / 100;
        this.runtime.redraw = true;
    };
	SysActs.prototype.SetLayerBackground = function (layer, c)
    {
        if (!layer)
            return;
		var r = cr.GetRValue(c);
		var g = cr.GetGValue(c);
		var b = cr.GetBValue(c);
		if (layer.background_color[0] === r && layer.background_color[1] === g && layer.background_color[2] === b)
			return;
        layer.background_color[0] = r;
		layer.background_color[1] = g;
		layer.background_color[2] = b;
        this.runtime.redraw = true;
    };
	SysActs.prototype.SetLayerTransparent = function (layer, t)
    {
        if (!layer)
            return;
		if (!!t === !!layer.transparent)
			return;
		layer.transparent = !!t;
        this.runtime.redraw = true;
    };
	SysActs.prototype.StopLoop = function ()
	{
		if (this.runtime.loop_stack_index < 0)
			return;		// no loop currently running
		this.runtime.getCurrentLoop().stopped = true;
	};
	SysActs.prototype.GoToLayoutByName = function (layoutname)
	{
		if (this.runtime.isloading)
			return;		// cannot change layout while loading on loader layout
		if (this.runtime.changelayout)
			return;		// already changing to different layout
;
		var l;
		for (l in this.runtime.layouts)
		{
			if (this.runtime.layouts.hasOwnProperty(l) && cr.equals_nocase(l, layoutname))
			{
				this.runtime.changelayout = this.runtime.layouts[l];
				return;
			}
		}
	};
	SysActs.prototype.RestartLayout = function (layoutname)
	{
		if (this.runtime.isloading)
			return;		// cannot restart loader layouts
		if (this.runtime.changelayout)
			return;		// already changing to a different layout
;
		if (!this.runtime.running_layout)
			return;
		this.runtime.changelayout = this.runtime.running_layout;
		var i, len, g;
		for (i = 0, len = this.runtime.allGroups.length; i < len; i++)
		{
			g = this.runtime.allGroups[i];
			this.runtime.activeGroups[g.group_name.toLowerCase()] = g.initially_activated;
		}
	};
	SysActs.prototype.SnapshotCanvas = function (format_, quality_)
	{
		this.runtime.snapshotCanvas = [format_ === 0 ? "image/png" : "image/jpeg", quality_ / 100];
		this.runtime.redraw = true;		// force redraw so snapshot is always taken
	};
	SysActs.prototype.SetCanvasSize = function (w, h)
	{
		if (w <= 0 || h <= 0)
			return;
		this.runtime["setSize"](w, h, true);
	};
	SysActs.prototype.SetLayoutEffectEnabled = function (enable_, effectname_)
	{
		if (!this.runtime.running_layout || !this.runtime.glwrap)
			return;
		var et = this.runtime.running_layout.getEffectByName(effectname_);
		if (!et)
			return;		// effect name not found
		var enable = (enable_ === 1);
		if (et.active == enable)
			return;		// no change
		et.active = enable;
		this.runtime.running_layout.updateActiveEffects();
		this.runtime.redraw = true;
	};
	SysActs.prototype.SetLayerEffectEnabled = function (layer, enable_, effectname_)
	{
		if (!layer || !this.runtime.glwrap)
			return;
		var et = layer.getEffectByName(effectname_);
		if (!et)
			return;		// effect name not found
		var enable = (enable_ === 1);
		if (et.active == enable)
			return;		// no change
		et.active = enable;
		layer.updateActiveEffects();
		this.runtime.redraw = true;
	};
	SysActs.prototype.SetLayoutEffectParam = function (effectname_, index_, value_)
	{
		if (!this.runtime.running_layout || !this.runtime.glwrap)
			return;
		var et = this.runtime.running_layout.getEffectByName(effectname_);
		if (!et)
			return;		// effect name not found
		var params = this.runtime.running_layout.effect_params[et.index];
		index_ = Math.floor(index_);
		if (index_ < 0 || index_ >= params.length)
			return;		// effect index out of bounds
		if (this.runtime.glwrap.getProgramParameterType(et.shaderindex, index_) === 1)
			value_ /= 100.0;
		if (params[index_] === value_)
			return;		// no change
		params[index_] = value_;
		if (et.active)
			this.runtime.redraw = true;
	};
	SysActs.prototype.SetLayerEffectParam = function (layer, effectname_, index_, value_)
	{
		if (!layer || !this.runtime.glwrap)
			return;
		var et = layer.getEffectByName(effectname_);
		if (!et)
			return;		// effect name not found
		var params = layer.effect_params[et.index];
		index_ = Math.floor(index_);
		if (index_ < 0 || index_ >= params.length)
			return;		// effect index out of bounds
		if (this.runtime.glwrap.getProgramParameterType(et.shaderindex, index_) === 1)
			value_ /= 100.0;
		if (params[index_] === value_)
			return;		// no change
		params[index_] = value_;
		if (et.active)
			this.runtime.redraw = true;
	};
	SysActs.prototype.SaveState = function (slot_)
	{
		this.runtime.saveToSlot = slot_;
	};
	SysActs.prototype.LoadState = function (slot_)
	{
		this.runtime.loadFromSlot = slot_;
	};
	SysActs.prototype.LoadStateJSON = function (jsonstr_)
	{
		this.runtime.loadFromJson = jsonstr_;
	};
	SysActs.prototype.SetHalfFramerateMode = function (set_)
	{
		this.runtime.halfFramerateMode = (set_ !== 0);
	};
	sysProto.acts = new SysActs();
    function SysExps() {};
    SysExps.prototype["int"] = function(ret, x)
    {
        if (cr.is_string(x))
        {
            ret.set_int(parseInt(x, 10));
            if (isNaN(ret.data))
                ret.data = 0;
        }
        else
            ret.set_int(x);
    };
    SysExps.prototype["float"] = function(ret, x)
    {
        if (cr.is_string(x))
        {
            ret.set_float(parseFloat(x));
            if (isNaN(ret.data))
                ret.data = 0;
        }
        else
            ret.set_float(x);
    };
    SysExps.prototype.str = function(ret, x)
    {
        if (cr.is_string(x))
            ret.set_string(x);
        else
            ret.set_string(x.toString());
    };
    SysExps.prototype.len = function(ret, x)
    {
        ret.set_int(x.length || 0);
    };
    SysExps.prototype.random = function (ret, a, b)
    {
        if (b === undefined)
        {
            ret.set_float(Math.random() * a);
        }
        else
        {
            ret.set_float(Math.random() * (b - a) + a);
        }
    };
    SysExps.prototype.sqrt = function(ret, x)
    {
        ret.set_float(Math.sqrt(x));
    };
    SysExps.prototype.abs = function(ret, x)
    {
        ret.set_float(Math.abs(x));
    };
    SysExps.prototype.round = function(ret, x)
    {
        ret.set_int(Math.round(x));
    };
    SysExps.prototype.floor = function(ret, x)
    {
        ret.set_int(Math.floor(x));
    };
    SysExps.prototype.ceil = function(ret, x)
    {
        ret.set_int(Math.ceil(x));
    };
    SysExps.prototype.sin = function(ret, x)
    {
        ret.set_float(Math.sin(cr.to_radians(x)));
    };
    SysExps.prototype.cos = function(ret, x)
    {
        ret.set_float(Math.cos(cr.to_radians(x)));
    };
    SysExps.prototype.tan = function(ret, x)
    {
        ret.set_float(Math.tan(cr.to_radians(x)));
    };
    SysExps.prototype.asin = function(ret, x)
    {
        ret.set_float(cr.to_degrees(Math.asin(x)));
    };
    SysExps.prototype.acos = function(ret, x)
    {
        ret.set_float(cr.to_degrees(Math.acos(x)));
    };
    SysExps.prototype.atan = function(ret, x)
    {
        ret.set_float(cr.to_degrees(Math.atan(x)));
    };
    SysExps.prototype.exp = function(ret, x)
    {
        ret.set_float(Math.exp(x));
    };
    SysExps.prototype.ln = function(ret, x)
    {
        ret.set_float(Math.log(x));
    };
    SysExps.prototype.log10 = function(ret, x)
    {
        ret.set_float(Math.log(x) / Math.LN10);
    };
    SysExps.prototype.max = function(ret)
    {
		var max_ = arguments[1];
		var i, len;
		for (i = 2, len = arguments.length; i < len; i++)
		{
			if (max_ < arguments[i])
				max_ = arguments[i];
		}
		ret.set_float(max_);
    };
    SysExps.prototype.min = function(ret)
    {
        var min_ = arguments[1];
		var i, len;
		for (i = 2, len = arguments.length; i < len; i++)
		{
			if (min_ > arguments[i])
				min_ = arguments[i];
		}
		ret.set_float(min_);
    };
    SysExps.prototype.dt = function(ret)
    {
        ret.set_float(this.runtime.dt);
    };
    SysExps.prototype.timescale = function(ret)
    {
        ret.set_float(this.runtime.timescale);
    };
    SysExps.prototype.wallclocktime = function(ret)
    {
        ret.set_float((Date.now() - this.runtime.start_time) / 1000.0);
    };
    SysExps.prototype.time = function(ret)
    {
        ret.set_float(this.runtime.kahanTime.sum);
    };
    SysExps.prototype.tickcount = function(ret)
    {
        ret.set_int(this.runtime.tickcount);
    };
    SysExps.prototype.objectcount = function(ret)
    {
        ret.set_int(this.runtime.objectcount);
    };
    SysExps.prototype.fps = function(ret)
    {
        ret.set_int(this.runtime.fps);
    };
    SysExps.prototype.loopindex = function(ret, name_)
    {
		var loop, i, len;
        if (!this.runtime.loop_stack.length)
        {
            ret.set_int(0);
            return;
        }
        if (name_)
        {
            for (i = 0, len = this.runtime.loop_stack.length; i < len; i++)
            {
                loop = this.runtime.loop_stack[i];
                if (loop.name === name_)
                {
                    ret.set_int(loop.index);
                    return;
                }
            }
            ret.set_int(0);
        }
        else
        {
			loop = this.runtime.getCurrentLoop();
			ret.set_int(loop ? loop.index : -1);
        }
    };
    SysExps.prototype.distance = function(ret, x1, y1, x2, y2)
    {
        ret.set_float(cr.distanceTo(x1, y1, x2, y2));
    };
    SysExps.prototype.angle = function(ret, x1, y1, x2, y2)
    {
        ret.set_float(cr.to_degrees(cr.angleTo(x1, y1, x2, y2)));
    };
    SysExps.prototype.scrollx = function(ret)
    {
        ret.set_float(this.runtime.running_layout.scrollX);
    };
    SysExps.prototype.scrolly = function(ret)
    {
        ret.set_float(this.runtime.running_layout.scrollY);
    };
    SysExps.prototype.newline = function(ret)
    {
        ret.set_string("\n");
    };
    SysExps.prototype.lerp = function(ret, a, b, x)
    {
        ret.set_float(cr.lerp(a, b, x));
    };
    SysExps.prototype.windowwidth = function(ret)
    {
        ret.set_int(this.runtime.width);
    };
    SysExps.prototype.windowheight = function(ret)
    {
        ret.set_int(this.runtime.height);
    };
	SysExps.prototype.uppercase = function(ret, str)
	{
		ret.set_string(cr.is_string(str) ? str.toUpperCase() : "");
	};
	SysExps.prototype.lowercase = function(ret, str)
	{
		ret.set_string(cr.is_string(str) ? str.toLowerCase() : "");
	};
	SysExps.prototype.clamp = function(ret, x, l, u)
	{
		if (x < l)
			ret.set_float(l);
		else if (x > u)
			ret.set_float(u);
		else
			ret.set_float(x);
	};
	SysExps.prototype.layerscale = function (ret, layerparam)
	{
		var layer = this.runtime.getLayer(layerparam);
		if (!layer)
			ret.set_float(0);
		else
			ret.set_float(layer.scale);
	};
	SysExps.prototype.layeropacity = function (ret, layerparam)
	{
		var layer = this.runtime.getLayer(layerparam);
		if (!layer)
			ret.set_float(0);
		else
			ret.set_float(layer.opacity * 100);
	};
	SysExps.prototype.layerscalerate = function (ret, layerparam)
	{
		var layer = this.runtime.getLayer(layerparam);
		if (!layer)
			ret.set_float(0);
		else
			ret.set_float(layer.zoomRate);
	};
	SysExps.prototype.layerparallaxx = function (ret, layerparam)
	{
		var layer = this.runtime.getLayer(layerparam);
		if (!layer)
			ret.set_float(0);
		else
			ret.set_float(layer.parallaxX * 100);
	};
	SysExps.prototype.layerparallaxy = function (ret, layerparam)
	{
		var layer = this.runtime.getLayer(layerparam);
		if (!layer)
			ret.set_float(0);
		else
			ret.set_float(layer.parallaxY * 100);
	};
	SysExps.prototype.layoutscale = function (ret)
	{
		if (this.runtime.running_layout)
			ret.set_float(this.runtime.running_layout.scale);
		else
			ret.set_float(0);
	};
	SysExps.prototype.layoutangle = function (ret)
	{
		ret.set_float(cr.to_degrees(this.runtime.running_layout.angle));
	};
	SysExps.prototype.layerangle = function (ret, layerparam)
	{
		var layer = this.runtime.getLayer(layerparam);
		if (!layer)
			ret.set_float(0);
		else
			ret.set_float(cr.to_degrees(layer.angle));
	};
	SysExps.prototype.layoutwidth = function (ret)
	{
		ret.set_int(this.runtime.running_layout.width);
	};
	SysExps.prototype.layoutheight = function (ret)
	{
		ret.set_int(this.runtime.running_layout.height);
	};
	SysExps.prototype.find = function (ret, text, searchstr)
	{
		if (cr.is_string(text) && cr.is_string(searchstr))
			ret.set_int(text.search(new RegExp(cr.regexp_escape(searchstr), "i")));
		else
			ret.set_int(-1);
	};
	SysExps.prototype.left = function (ret, text, n)
	{
		ret.set_string(cr.is_string(text) ? text.substr(0, n) : "");
	};
	SysExps.prototype.right = function (ret, text, n)
	{
		ret.set_string(cr.is_string(text) ? text.substr(text.length - n) : "");
	};
	SysExps.prototype.mid = function (ret, text, index_, length_)
	{
		ret.set_string(cr.is_string(text) ? text.substr(index_, length_) : "");
	};
	SysExps.prototype.tokenat = function (ret, text, index_, sep)
	{
		if (cr.is_string(text) && cr.is_string(sep))
		{
			var arr = text.split(sep);
			var i = cr.floor(index_);
			if (i < 0 || i >= arr.length)
				ret.set_string("");
			else
				ret.set_string(arr[i]);
		}
		else
			ret.set_string("");
	};
	SysExps.prototype.tokencount = function (ret, text, sep)
	{
		if (cr.is_string(text) && text.length)
			ret.set_int(text.split(sep).length);
		else
			ret.set_int(0);
	};
	SysExps.prototype.replace = function (ret, text, find_, replace_)
	{
		if (cr.is_string(text) && cr.is_string(find_) && cr.is_string(replace_))
			ret.set_string(text.replace(new RegExp(cr.regexp_escape(find_), "gi"), replace_));
		else
			ret.set_string(cr.is_string(text) ? text : "");
	};
	SysExps.prototype.trim = function (ret, text)
	{
		ret.set_string(cr.is_string(text) ? text.trim() : "");
	};
	SysExps.prototype.pi = function (ret)
	{
		ret.set_float(cr.PI);
	};
	SysExps.prototype.layoutname = function (ret)
	{
		if (this.runtime.running_layout)
			ret.set_string(this.runtime.running_layout.name);
		else
			ret.set_string("");
	};
	SysExps.prototype.renderer = function (ret)
	{
		ret.set_string(this.runtime.gl ? "webgl" : "canvas2d");
	};
	SysExps.prototype.anglediff = function (ret, a, b)
	{
		ret.set_float(cr.to_degrees(cr.angleDiff(cr.to_radians(a), cr.to_radians(b))));
	};
	SysExps.prototype.choose = function (ret)
	{
		var index = cr.floor(Math.random() * (arguments.length - 1));
		ret.set_any(arguments[index + 1]);
	};
	SysExps.prototype.rgb = function (ret, r, g, b)
	{
		ret.set_int(cr.RGB(r, g, b));
	};
	SysExps.prototype.projectversion = function (ret)
	{
		ret.set_string(this.runtime.versionstr);
	};
	SysExps.prototype.anglelerp = function (ret, a, b, x)
	{
		a = cr.to_radians(a);
		b = cr.to_radians(b);
		var diff = cr.angleDiff(a, b);
		if (cr.angleClockwise(b, a))
		{
			ret.set_float(cr.to_clamped_degrees(a + diff * x));
		}
		else
		{
			ret.set_float(cr.to_clamped_degrees(a - diff * x));
		}
	};
	SysExps.prototype.anglerotate = function (ret, a, b, c)
	{
		a = cr.to_radians(a);
		b = cr.to_radians(b);
		c = cr.to_radians(c);
		ret.set_float(cr.to_clamped_degrees(cr.angleRotate(a, b, c)));
	};
	SysExps.prototype.zeropad = function (ret, n, d)
	{
		var s = (n < 0 ? "-" : "");
		if (n < 0) n = -n;
		var zeroes = d - n.toString().length;
		for (var i = 0; i < zeroes; i++)
			s += "0";
		ret.set_string(s + n.toString());
	};
	SysExps.prototype.cpuutilisation = function (ret)
	{
		ret.set_float(this.runtime.cpuutilisation / 1000);
	};
	SysExps.prototype.viewportleft = function (ret, layerparam)
	{
		var layer = this.runtime.getLayer(layerparam);
		ret.set_float(layer ? layer.viewLeft : 0);
	};
	SysExps.prototype.viewporttop = function (ret, layerparam)
	{
		var layer = this.runtime.getLayer(layerparam);
		ret.set_float(layer ? layer.viewTop : 0);
	};
	SysExps.prototype.viewportright = function (ret, layerparam)
	{
		var layer = this.runtime.getLayer(layerparam);
		ret.set_float(layer ? layer.viewRight : 0);
	};
	SysExps.prototype.viewportbottom = function (ret, layerparam)
	{
		var layer = this.runtime.getLayer(layerparam);
		ret.set_float(layer ? layer.viewBottom : 0);
	};
	SysExps.prototype.loadingprogress = function (ret)
	{
		ret.set_float(this.runtime.loadingprogress);
	};
	SysExps.prototype.unlerp = function(ret, a, b, y)
    {
        ret.set_float((y - a) / (b - a));
    };
	SysExps.prototype.canvassnapshot = function (ret)
	{
		ret.set_string(this.runtime.snapshotData);
	};
	SysExps.prototype.urlencode = function (ret, s)
	{
		ret.set_string(encodeURIComponent(s));
	};
	SysExps.prototype.urldecode = function (ret, s)
	{
		ret.set_string(decodeURIComponent(s));
	};
	SysExps.prototype.canvastolayerx = function (ret, layerparam, x, y)
	{
		var layer = this.runtime.getLayer(layerparam);
		ret.set_float(layer ? layer.canvasToLayer(x, y, true) : 0);
	};
	SysExps.prototype.canvastolayery = function (ret, layerparam, x, y)
	{
		var layer = this.runtime.getLayer(layerparam);
		ret.set_float(layer ? layer.canvasToLayer(x, y, false) : 0);
	};
	SysExps.prototype.layertocanvasx = function (ret, layerparam, x, y)
	{
		var layer = this.runtime.getLayer(layerparam);
		ret.set_float(layer ? layer.layerToCanvas(x, y, true) : 0);
	};
	SysExps.prototype.layertocanvasy = function (ret, layerparam, x, y)
	{
		var layer = this.runtime.getLayer(layerparam);
		ret.set_float(layer ? layer.layerToCanvas(x, y, false) : 0);
	};
	SysExps.prototype.savestatejson = function (ret)
	{
		ret.set_string(this.runtime.lastSaveJson);
	};
	SysExps.prototype.imagememoryusage = function (ret)
	{
		if (this.runtime.glwrap)
			ret.set_float(Math.round(100 * this.runtime.glwrap.estimateVRAM() / (1024 * 1024)) / 100);
		else
			ret.set_float(0);
	};
	SysExps.prototype.regexsearch = function (ret, str_, regex_, flags_)
	{
		var regex = getRegex(regex_, flags_);
		ret.set_int(str_ ? str_.search(regex) : -1);
	};
	SysExps.prototype.regexreplace = function (ret, str_, regex_, flags_, replace_)
	{
		var regex = getRegex(regex_, flags_);
		ret.set_string(str_ ? str_.replace(regex, replace_) : "");
	};
	var regexMatches = [];
	var lastMatchesStr = "";
	var lastMatchesRegex = "";
	var lastMatchesFlags = "";
	function updateRegexMatches(str_, regex_, flags_)
	{
		if (str_ === lastMatchesStr && regex_ === lastMatchesRegex && flags_ === lastMatchesFlags)
			return;
		var regex = getRegex(regex_, flags_);
		regexMatches = str_.match(regex);
		lastMatchesStr = str_;
		lastMatchesRegex = regex_;
		lastMatchesFlags = flags_;
	};
	SysExps.prototype.regexmatchcount = function (ret, str_, regex_, flags_)
	{
		var regex = getRegex(regex_, flags_);
		updateRegexMatches(str_, regex_, flags_);
		ret.set_int(regexMatches ? regexMatches.length : 0);
	};
	SysExps.prototype.regexmatchat = function (ret, str_, regex_, flags_, index_)
	{
		index_ = Math.floor(index_);
		var regex = getRegex(regex_, flags_);
		updateRegexMatches(str_, regex_, flags_);
		if (!regexMatches || index_ < 0 || index_ >= regexMatches.length)
			ret.set_string("");
		else
			ret.set_string(regexMatches[index_]);
	};
	SysExps.prototype.infinity = function (ret)
	{
		ret.set_float(Infinity);
	};
	sysProto.exps = new SysExps();
	sysProto.runWaits = function ()
	{
		var i, j, len, w, k, s, ss;
		var evinfo = this.runtime.getCurrentEventStack();
		for (i = 0, len = this.waits.length; i < len; i++)
		{
			w = this.waits[i];
			if (w.time > this.runtime.kahanTime.sum)
				continue;
			evinfo.current_event = w.ev;
			evinfo.actindex = w.actindex;
			evinfo.cndindex = 0;
			for (k in w.sols)
			{
				if (w.sols.hasOwnProperty(k))
				{
					s = this.runtime.types_by_index[parseInt(k, 10)].getCurrentSol();
					ss = w.sols[k];
					s.select_all = ss.sa;
					cr.shallowAssignArray(s.instances, ss.insts);
					freeSolStateObject(ss);
				}
			}
			w.ev.resume_actions_and_subevents();
			this.runtime.clearSol(w.solModifiers);
			w.deleteme = true;
		}
		for (i = 0, j = 0, len = this.waits.length; i < len; i++)
		{
			w = this.waits[i];
			this.waits[j] = w;
			if (w.deleteme)
				freeWaitObject(w);
			else
				j++;
		}
		this.waits.length = j;
	};
}());
;
cr.add_common_aces = function (m)
{
	var pluginProto = m[0].prototype;
	var singleglobal_ = m[1];
	var position_aces = m[3];
	var size_aces = m[4];
	var angle_aces = m[5];
	var appearance_aces = m[6];
	var zorder_aces = m[7];
	var effects_aces = m[8];
    if (!pluginProto.cnds)
        pluginProto.cnds = {};
    if (!pluginProto.acts)
        pluginProto.acts = {};
    if (!pluginProto.exps)
        pluginProto.exps = {};
    var cnds = pluginProto.cnds;
    var acts = pluginProto.acts;
    var exps = pluginProto.exps;
    if (position_aces)
    {
        cnds.CompareX = function (cmp, x)
        {
            return cr.do_cmp(this.x, cmp, x);
        };
        cnds.CompareY = function (cmp, y)
        {
            return cr.do_cmp(this.y, cmp, y);
        };
        cnds.IsOnScreen = function ()
        {
			var layer = this.layer;
            this.update_bbox();
            var bbox = this.bbox;
            return !(bbox.right < layer.viewLeft || bbox.bottom < layer.viewTop || bbox.left > layer.viewRight || bbox.top > layer.viewBottom);
        };
        cnds.IsOutsideLayout = function ()
        {
            this.update_bbox();
            var bbox = this.bbox;
            var layout = this.runtime.running_layout;
            return (bbox.right < 0 || bbox.bottom < 0 || bbox.left > layout.width || bbox.top > layout.height);
        };
		cnds.PickDistance = function (which, x, y)
		{
			var sol = this.getCurrentSol();
			var instances = sol.getObjects();
			if (!instances.length)
				return false;
			var inst = instances[0];
			var pickme = inst;
			var dist = cr.distanceTo(inst.x, inst.y, x, y);
			var i, len, d;
			for (i = 1, len = instances.length; i < len; i++)
			{
				inst = instances[i];
				d = cr.distanceTo(inst.x, inst.y, x, y);
				if ((which === 0 && d < dist) || (which === 1 && d > dist))
				{
					dist = d;
					pickme = inst;
				}
			}
			sol.pick_one(pickme);
			return true;
		};
        acts.SetX = function (x)
        {
            if (this.x !== x)
            {
                this.x = x;
                this.set_bbox_changed();
            }
        };
        acts.SetY = function (y)
        {
            if (this.y !== y)
            {
                this.y = y;
                this.set_bbox_changed();
            }
        };
        acts.SetPos = function (x, y)
        {
            if (this.x !== x || this.y !== y)
            {
                this.x = x;
                this.y = y;
                this.set_bbox_changed();
            }
        };
        acts.SetPosToObject = function (obj, imgpt)
        {
            var inst = obj.getPairedInstance(this);
            if (!inst)
				return;
			var newx, newy;
			if (inst.getImagePoint)
			{
				newx = inst.getImagePoint(imgpt, true);
				newy = inst.getImagePoint(imgpt, false);
			}
			else
			{
				newx = inst.x;
				newy = inst.y;
			}
			if (this.x !== newx || this.y !== newy)
            {
				this.x = newx;
				this.y = newy;
				this.set_bbox_changed();
            }
        };
        acts.MoveForward = function (dist)
        {
            if (dist !== 0)
            {
                this.x += Math.cos(this.angle) * dist;
                this.y += Math.sin(this.angle) * dist;
                this.set_bbox_changed();
            }
        };
        acts.MoveAtAngle = function (a, dist)
        {
            if (dist !== 0)
            {
                this.x += Math.cos(cr.to_radians(a)) * dist;
                this.y += Math.sin(cr.to_radians(a)) * dist;
                this.set_bbox_changed();
            }
        };
        exps.X = function (ret)
        {
            ret.set_float(this.x);
        };
        exps.Y = function (ret)
        {
            ret.set_float(this.y);
        };
        exps.dt = function (ret)
        {
            ret.set_float(this.runtime.getDt(this));
        };
    }
    if (size_aces)
    {
        cnds.CompareWidth = function (cmp, w)
        {
            return cr.do_cmp(this.width, cmp, w);
        };
        cnds.CompareHeight = function (cmp, h)
        {
            return cr.do_cmp(this.height, cmp, h);
        };
        acts.SetWidth = function (w)
        {
            if (this.width !== w)
            {
                this.width = w;
                this.set_bbox_changed();
            }
        };
        acts.SetHeight = function (h)
        {
            if (this.height !== h)
            {
                this.height = h;
                this.set_bbox_changed();
            }
        };
        acts.SetSize = function (w, h)
        {
            if (this.width !== w || this.height !== h)
            {
                this.width = w;
                this.height = h;
                this.set_bbox_changed();
            }
        };
        exps.Width = function (ret)
        {
            ret.set_float(this.width);
        };
        exps.Height = function (ret)
        {
            ret.set_float(this.height);
        };
		exps.BBoxLeft = function (ret)
        {
			this.update_bbox();
            ret.set_float(this.bbox.left);
        };
		exps.BBoxTop = function (ret)
        {
			this.update_bbox();
            ret.set_float(this.bbox.top);
        };
		exps.BBoxRight = function (ret)
        {
			this.update_bbox();
            ret.set_float(this.bbox.right);
        };
		exps.BBoxBottom = function (ret)
        {
			this.update_bbox();
            ret.set_float(this.bbox.bottom);
        };
    }
    if (angle_aces)
    {
        cnds.AngleWithin = function (within, a)
        {
            return cr.angleDiff(this.angle, cr.to_radians(a)) <= cr.to_radians(within);
        };
        cnds.IsClockwiseFrom = function (a)
        {
            return cr.angleClockwise(this.angle, cr.to_radians(a));
        };
		cnds.IsBetweenAngles = function (a, b)
		{
			var lower = cr.to_clamped_radians(a);
			var upper = cr.to_clamped_radians(b);
			var angle = cr.clamp_angle(this.angle);
			var obtuse = (!cr.angleClockwise(upper, lower));
			if (obtuse)
				return !(!cr.angleClockwise(angle, lower) && cr.angleClockwise(angle, upper));
			else
				return cr.angleClockwise(angle, lower) && !cr.angleClockwise(angle, upper);
		};
        acts.SetAngle = function (a)
        {
            var newangle = cr.to_radians(cr.clamp_angle_degrees(a));
            if (isNaN(newangle))
                return;
            if (this.angle !== newangle)
            {
                this.angle = newangle;
                this.set_bbox_changed();
            }
        };
        acts.RotateClockwise = function (a)
        {
            if (a !== 0 && !isNaN(a))
            {
                this.angle += cr.to_radians(a);
                this.angle = cr.clamp_angle(this.angle);
                this.set_bbox_changed();
            }
        };
        acts.RotateCounterclockwise = function (a)
        {
            if (a !== 0 && !isNaN(a))
            {
                this.angle -= cr.to_radians(a);
                this.angle = cr.clamp_angle(this.angle);
                this.set_bbox_changed();
            }
        };
        acts.RotateTowardAngle = function (amt, target)
        {
            var newangle = cr.angleRotate(this.angle, cr.to_radians(target), cr.to_radians(amt));
            if (isNaN(newangle))
                return;
            if (this.angle !== newangle)
            {
                this.angle = newangle;
                this.set_bbox_changed();
            }
        };
        acts.RotateTowardPosition = function (amt, x, y)
        {
            var dx = x - this.x;
            var dy = y - this.y;
            var target = Math.atan2(dy, dx);
            var newangle = cr.angleRotate(this.angle, target, cr.to_radians(amt));
            if (isNaN(newangle))
                return;
            if (this.angle !== newangle)
            {
                this.angle = newangle;
                this.set_bbox_changed();
            }
        };
        acts.SetTowardPosition = function (x, y)
        {
            var dx = x - this.x;
            var dy = y - this.y;
            var newangle = Math.atan2(dy, dx);
            if (isNaN(newangle))
                return;
            if (this.angle !== newangle)
            {
                this.angle = newangle;
                this.set_bbox_changed();
            }
        };
        exps.Angle = function (ret)
        {
            ret.set_float(cr.to_clamped_degrees(this.angle));
        };
    }
    if (!singleglobal_)
    {
        cnds.CompareInstanceVar = function (iv, cmp, val)
        {
            return cr.do_cmp(this.instance_vars[iv], cmp, val);
        };
        cnds.IsBoolInstanceVarSet = function (iv)
        {
            return this.instance_vars[iv];
        };
		cnds.PickInstVarHiLow = function (which, iv)
		{
			var sol = this.getCurrentSol();
			var instances = sol.getObjects();
			if (!instances.length)
				return false;
			var inst = instances[0];
			var pickme = inst;
			var val = inst.instance_vars[iv];
			var i, len, v;
			for (i = 1, len = instances.length; i < len; i++)
			{
				inst = instances[i];
				v = inst.instance_vars[iv];
				if ((which === 0 && v < val) || (which === 1 && v > val))
				{
					val = v;
					pickme = inst;
				}
			}
			sol.pick_one(pickme);
			return true;
		};
		cnds.PickByUID = function (u)
		{
			var i, len, j, inst, families, instances, sol;
			var cnd = this.runtime.getCurrentCondition();
			if (cnd.inverted)
			{
				sol = this.getCurrentSol();
				if (sol.select_all)
				{
					sol.select_all = false;
					sol.instances.length = 0;
					sol.else_instances.length = 0;
					instances = this.instances;
					for (i = 0, len = instances.length; i < len; i++)
					{
						inst = instances[i];
						if (inst.uid === u)
							sol.else_instances.push(inst);
						else
							sol.instances.push(inst);
					}
					this.applySolToContainer();
					return !!sol.instances.length;
				}
				else
				{
					for (i = 0, j = 0, len = sol.instances.length; i < len; i++)
					{
						inst = sol.instances[i];
						sol.instances[j] = inst;
						if (inst.uid === u)
						{
							sol.else_instances.push(inst);
						}
						else
							j++;
					}
					sol.instances.length = j;
					this.applySolToContainer();
					return !!sol.instances.length;
				}
			}
			else
			{
				inst = this.runtime.getObjectByUID(u);
				if (!inst)
					return false;
				sol = this.getCurrentSol();
				if (!sol.select_all && sol.instances.indexOf(inst) === -1)
					return false;		// not picked
				if (this.is_family)
				{
					families = inst.type.families;
					for (i = 0, len = families.length; i < len; i++)
					{
						if (families[i] === this)
						{
							sol.pick_one(inst);
							this.applySolToContainer();
							return true;
						}
					}
				}
				else if (inst.type === this)
				{
					sol.pick_one(inst);
					this.applySolToContainer();
					return true;
				}
				return false;
			}
		};
		cnds.OnCreated = function ()
		{
			return true;
		};
		cnds.OnDestroyed = function ()
		{
			return true;
		};
        acts.SetInstanceVar = function (iv, val)
        {
			var myinstvars = this.instance_vars;
            if (cr.is_number(myinstvars[iv]))
            {
                if (cr.is_number(val))
                    myinstvars[iv] = val;
                else
                    myinstvars[iv] = parseFloat(val);
            }
            else if (cr.is_string(myinstvars[iv]))
            {
                if (cr.is_string(val))
                    myinstvars[iv] = val;
                else
                    myinstvars[iv] = val.toString();
            }
            else
;
        };
        acts.AddInstanceVar = function (iv, val)
        {
			var myinstvars = this.instance_vars;
            if (cr.is_number(myinstvars[iv]))
            {
                if (cr.is_number(val))
                    myinstvars[iv] += val;
                else
                    myinstvars[iv] += parseFloat(val);
            }
            else if (cr.is_string(myinstvars[iv]))
            {
                if (cr.is_string(val))
                    myinstvars[iv] += val;
                else
                    myinstvars[iv] += val.toString();
            }
            else
;
        };
        acts.SubInstanceVar = function (iv, val)
        {
			var myinstvars = this.instance_vars;
            if (cr.is_number(myinstvars[iv]))
            {
                if (cr.is_number(val))
                    myinstvars[iv] -= val;
                else
                    myinstvars[iv] -= parseFloat(val);
            }
            else
;
        };
        acts.SetBoolInstanceVar = function (iv, val)
        {
            this.instance_vars[iv] = val ? 1 : 0;
        };
        acts.ToggleBoolInstanceVar = function (iv)
        {
            this.instance_vars[iv] = 1 - this.instance_vars[iv];
        };
        acts.Destroy = function ()
        {
            this.runtime.DestroyInstance(this);
        };
		if (!acts.LoadFromJsonString)
		{
			acts.LoadFromJsonString = function (str_)
			{
				var o, i, len, binst;
				try {
					o = JSON.parse(str_);
				}
				catch (e) {
					return;
				}
				this.runtime.loadInstanceFromJSON(this, o, true);
				if (this.afterLoad)
					this.afterLoad();
				if (this.behavior_insts)
				{
					for (i = 0, len = this.behavior_insts.length; i < len; ++i)
					{
						binst = this.behavior_insts[i];
						if (binst.afterLoad)
							binst.afterLoad();
					}
				}
			};
		}
        exps.Count = function (ret)
        {
			var count = ret.object_class.instances.length;
			var i, len, inst;
			for (i = 0, len = this.runtime.createRow.length; i < len; i++)
			{
				inst = this.runtime.createRow[i];
				if (ret.object_class.is_family)
				{
					if (inst.type.families.indexOf(ret.object_class) >= 0)
						count++;
				}
				else
				{
					if (inst.type === ret.object_class)
						count++;
				}
			}
            ret.set_int(count);
        };
		exps.PickedCount = function (ret)
        {
            ret.set_int(ret.object_class.getCurrentSol().getObjects().length);
        };
		exps.UID = function (ret)
		{
			ret.set_int(this.uid);
		};
		exps.IID = function (ret)
		{
			ret.set_int(this.get_iid());
		};
		if (!exps.AsJSON)
		{
			exps.AsJSON = function (ret)
			{
				ret.set_string(JSON.stringify(this.runtime.saveInstanceToJSON(this, true)));
			};
		}
    }
    if (appearance_aces)
    {
        cnds.IsVisible = function ()
        {
            return this.visible;
        };
        acts.SetVisible = function (v)
        {
			if (!v !== !this.visible)
			{
				this.visible = v;
				this.runtime.redraw = true;
			}
        };
        cnds.CompareOpacity = function (cmp, x)
        {
            return cr.do_cmp(cr.round6dp(this.opacity * 100), cmp, x);
        };
        acts.SetOpacity = function (x)
        {
            var new_opacity = x / 100.0;
            if (new_opacity < 0)
                new_opacity = 0;
            else if (new_opacity > 1)
                new_opacity = 1;
            if (new_opacity !== this.opacity)
            {
                this.opacity = new_opacity;
                this.runtime.redraw = true;
            }
        };
        exps.Opacity = function (ret)
        {
            ret.set_float(cr.round6dp(this.opacity * 100.0));
        };
    }
	if (zorder_aces)
	{
		cnds.IsOnLayer = function (layer_)
		{
			if (!layer_)
				return false;
			return this.layer === layer_;
		};
		cnds.PickTopBottom = function (which_)
		{
			var sol = this.getCurrentSol();
			var instances = sol.getObjects();
			if (!instances.length)
				return false;
			var inst = instances[0];
			var pickme = inst;
			var i, len;
			for (i = 1, len = instances.length; i < len; i++)
			{
				inst = instances[i];
				if (which_ === 0)
				{
					if (inst.layer.index > pickme.layer.index || (inst.layer.index === pickme.layer.index && inst.get_zindex() > pickme.get_zindex()))
					{
						pickme = inst;
					}
				}
				else
				{
					if (inst.layer.index < pickme.layer.index || (inst.layer.index === pickme.layer.index && inst.get_zindex() < pickme.get_zindex()))
					{
						pickme = inst;
					}
				}
			}
			sol.pick_one(pickme);
			return true;
		};
		acts.MoveToTop = function ()
		{
			var zindex = this.get_zindex();
			if (zindex === this.layer.instances.length - 1)
				return;
			cr.arrayRemove(this.layer.instances, zindex);
			this.layer.instances.push(this);
			this.runtime.redraw = true;
			this.layer.zindices_stale = true;
		};
		acts.MoveToBottom = function ()
		{
			var zindex = this.get_zindex();
			if (zindex === 0)
				return;
			cr.arrayRemove(this.layer.instances, zindex);
			this.layer.instances.unshift(this);
			this.runtime.redraw = true;
			this.layer.zindices_stale = true;
		};
		acts.MoveToLayer = function (layerMove)
		{
			if (!layerMove || layerMove == this.layer)
				return;
			cr.arrayRemove(this.layer.instances, this.get_zindex());
			this.layer.zindices_stale = true;
			this.layer = layerMove;
			this.zindex = layerMove.instances.length;
			layerMove.instances.push(this);
			this.runtime.redraw = true;
		};
		acts.ZMoveToObject = function (where_, obj_)
		{
			var isafter = (where_ === 0);
			if (!obj_)
				return;
			var other = obj_.getFirstPicked(this);
			if (!other || other.uid === this.uid)
				return;
			if (this.layer.index !== other.layer.index)
			{
				cr.arrayRemove(this.layer.instances, this.get_zindex());
				this.layer.zindices_stale = true;
				this.layer = other.layer;
				this.zindex = other.layer.instances.length;
				other.layer.instances.push(this);
			}
			var myZ = this.get_zindex();
			var insertZ = other.get_zindex();
			cr.arrayRemove(this.layer.instances, myZ);
			if (myZ < insertZ)
				insertZ--;
			if (isafter)
				insertZ++;
			if (insertZ === this.layer.instances.length)
				this.layer.instances.push(this);
			else
				this.layer.instances.splice(insertZ, 0, this);
			this.layer.zindices_stale = true;
			this.runtime.redraw = true;
		};
		exps.LayerNumber = function (ret)
		{
			ret.set_int(this.layer.number);
		};
		exps.LayerName = function (ret)
		{
			ret.set_string(this.layer.name);
		};
		exps.ZIndex = function (ret)
		{
			ret.set_int(this.get_zindex());
		};
	}
	if (effects_aces)
	{
		acts.SetEffectEnabled = function (enable_, effectname_)
		{
			if (!this.runtime.glwrap)
				return;
			var i = this.type.getEffectIndexByName(effectname_);
			if (i < 0)
				return;		// effect name not found
			var enable = (enable_ === 1);
			if (this.active_effect_flags[i] === enable)
				return;		// no change
			this.active_effect_flags[i] = enable;
			this.updateActiveEffects();
			this.runtime.redraw = true;
		};
		acts.SetEffectParam = function (effectname_, index_, value_)
		{
			if (!this.runtime.glwrap)
				return;
			var i = this.type.getEffectIndexByName(effectname_);
			if (i < 0)
				return;		// effect name not found
			var et = this.type.effect_types[i];
			var params = this.effect_params[i];
			index_ = Math.floor(index_);
			if (index_ < 0 || index_ >= params.length)
				return;		// effect index out of bounds
			if (this.runtime.glwrap.getProgramParameterType(et.shaderindex, index_) === 1)
				value_ /= 100.0;
			if (params[index_] === value_)
				return;		// no change
			params[index_] = value_;
			if (et.active)
				this.runtime.redraw = true;
		};
	}
};
cr.set_bbox_changed = function ()
{
    this.bbox_changed = true;       // will recreate next time box requested
    this.runtime.redraw = true;     // assume runtime needs to redraw
	var i, len;
	for (i = 0, len = this.bbox_changed_callbacks.length; i < len; i++)
	{
		this.bbox_changed_callbacks[i](this);
	}
};
cr.add_bbox_changed_callback = function (f)
{
	if (f)
		this.bbox_changed_callbacks.push(f);
};
cr.update_bbox = function ()
{
    if (!this.bbox_changed)
        return;                 // bounding box not changed
    this.bbox.set(this.x, this.y, this.x + this.width, this.y + this.height);
    this.bbox.offset(-this.hotspotX * this.width, -this.hotspotY * this.height);
    if (!this.angle)
    {
        this.bquad.set_from_rect(this.bbox);    // make bounding quad from box
    }
    else
    {
        this.bbox.offset(-this.x, -this.y);       					// translate to origin
        this.bquad.set_from_rotated_rect(this.bbox, this.angle);	// rotate around origin
        this.bquad.offset(this.x, this.y);      					// translate back to original position
        this.bquad.bounding_box(this.bbox);
    }
	var temp = 0;
	if (this.bbox.left > this.bbox.right)
	{
		temp = this.bbox.left;
		this.bbox.left = this.bbox.right;
		this.bbox.right = temp;
	}
	if (this.bbox.top > this.bbox.bottom)
	{
		temp = this.bbox.top;
		this.bbox.top = this.bbox.bottom;
		this.bbox.bottom = temp;
	}
    this.bbox_changed = false;  // bounding box up to date
};
cr.inst_contains_pt = function (x, y)
{
	if (!this.bbox.contains_pt(x, y))
		return false;
	if (!this.bquad.contains_pt(x, y))
		return false;
	if (this.collision_poly && !this.collision_poly.is_empty())
	{
		this.collision_poly.cache_poly(this.width, this.height, this.angle);
		return this.collision_poly.contains_pt(x - this.x, y - this.y);
	}
	else
		return true;
};
cr.inst_get_iid = function ()
{
	this.type.updateIIDs();
	return this.iid;
};
cr.inst_get_zindex = function ()
{
	this.layer.updateZIndices();
	return this.zindex;
};
cr.inst_updateActiveEffects = function ()
{
	this.active_effect_types.length = 0;
	var i, len, et, inst;
	for (i = 0, len = this.active_effect_flags.length; i < len; i++)
	{
		if (this.active_effect_flags[i])
			this.active_effect_types.push(this.type.effect_types[i]);
	}
	this.uses_shaders = !!this.active_effect_types.length;
};
cr.inst_toString = function ()
{
	return "Inst" + this.puid;
};
cr.type_getFirstPicked = function (frominst)
{
	if (frominst && frominst.is_contained && frominst.type != this)
	{
		var i, len, s;
		for (i = 0, len = frominst.siblings.length; i < len; i++)
		{
			s = frominst.siblings[i];
			if (s.type == this)
				return s;
		}
	}
    var instances = this.getCurrentSol().getObjects();
    if (instances.length)
        return instances[0];
    else
        return null;
};
cr.type_getPairedInstance = function (inst)
{
	var instances = this.getCurrentSol().getObjects();
	if (instances.length)
		return instances[inst.get_iid() % instances.length];
	else
		return null;
};
cr.type_updateIIDs = function ()
{
	if (!this.stale_iids || this.is_family)
		return;		// up to date or is family - don't want family to overwrite IIDs
	var i, len;
	for (i = 0, len = this.instances.length; i < len; i++)
		this.instances[i].iid = i;
	var next_iid = i;
	var createRow = this.runtime.createRow;
	for (i = 0, len = createRow.length; i < len; ++i)
	{
		if (createRow[i].type === this)
			createRow[i].iid = next_iid++;
	}
	this.stale_iids = false;
};
cr.type_getInstanceByIID = function (i)
{
	if (i < this.instances.length)
		return this.instances[i];
	i -= this.instances.length;
	var createRow = this.runtime.createRow;
	var j, lenj;
	for (j = 0, lenj = createRow.length; j < lenj; ++j)
	{
		if (createRow[j].type === this)
		{
			if (i === 0)
				return createRow[j];
			--i;
		}
	}
;
	return null;
};
cr.type_getCurrentSol = function ()
{
    return this.solstack[this.cur_sol];
};
cr.type_pushCleanSol = function ()
{
    this.cur_sol++;
    if (this.cur_sol === this.solstack.length)
        this.solstack.push(new cr.selection(this));
    else
        this.solstack[this.cur_sol].select_all = true;  // else clear next SOL
};
cr.type_pushCopySol = function ()
{
    this.cur_sol++;
    if (this.cur_sol === this.solstack.length)
        this.solstack.push(new cr.selection(this));
    var clonesol = this.solstack[this.cur_sol];
    var prevsol = this.solstack[this.cur_sol - 1];
    if (prevsol.select_all)
        clonesol.select_all = true;
    else
    {
        clonesol.select_all = false;
		cr.shallowAssignArray(clonesol.instances, prevsol.instances);
		cr.shallowAssignArray(clonesol.else_instances, prevsol.else_instances);
    }
};
cr.type_popSol = function ()
{
;
    this.cur_sol--;
};
cr.type_getBehaviorByName = function (behname)
{
    var i, len, j, lenj, f, index = 0;
	if (!this.is_family)
	{
		for (i = 0, len = this.families.length; i < len; i++)
		{
			f = this.families[i];
			for (j = 0, lenj = f.behaviors.length; j < lenj; j++)
			{
				if (behname === f.behaviors[j].name)
				{
					this.extra.lastBehIndex = index;
					return f.behaviors[j];
				}
				index++;
			}
		}
	}
    for (i = 0, len = this.behaviors.length; i < len; i++) {
        if (behname === this.behaviors[i].name)
		{
			this.extra.lastBehIndex = index;
            return this.behaviors[i];
		}
		index++;
    }
	return null;
};
cr.type_getBehaviorIndexByName = function (behname)
{
    var b = this.getBehaviorByName(behname);
	if (b)
		return this.extra.lastBehIndex;
	else
		return -1;
};
cr.type_getEffectIndexByName = function (name_)
{
	var i, len;
	for (i = 0, len = this.effect_types.length; i < len; i++)
	{
		if (this.effect_types[i].name === name_)
			return i;
	}
	return -1;
};
cr.type_applySolToContainer = function ()
{
	if (!this.is_contained || this.is_family)
		return;
	var i, len, j, lenj, t, sol, sol2;
	this.updateIIDs();
	sol = this.getCurrentSol();
	var select_all = sol.select_all;
	var es = this.runtime.getCurrentEventStack();
	var orblock = es && es.current_event && es.current_event.orblock;
	for (i = 0, len = this.container.length; i < len; i++)
	{
		t = this.container[i];
		if (t === this)
			continue;
		t.updateIIDs();
		sol2 = t.getCurrentSol();
		sol2.select_all = select_all;
		if (!select_all)
		{
			sol2.instances.length = sol.instances.length;
			for (j = 0, lenj = sol.instances.length; j < lenj; j++)
				sol2.instances[j] = t.getInstanceByIID(sol.instances[j].iid);
			if (orblock)
			{
				sol2.else_instances.length = sol.else_instances.length;
				for (j = 0, lenj = sol.else_instances.length; j < lenj; j++)
					sol2.else_instances[j] = t.getInstanceByIID(sol.else_instances[j].iid);
			}
		}
	}
};
cr.type_toString = function ()
{
	return "Type" + this.sid;
};
cr.do_cmp = function (x, cmp, y)
{
	if (typeof x === "undefined" || typeof y === "undefined")
		return false;
    switch (cmp)
    {
        case 0:     // equal
            return x === y;
        case 1:     // not equal
            return x !== y;
        case 2:     // less
            return x < y;
        case 3:     // less/equal
            return x <= y;
        case 4:     // greater
            return x > y;
        case 5:     // greater/equal
            return x >= y;
        default:
;
            return false;
    }
};
cr.shaders = {};
;
;
cr.plugins_.Audio = function(runtime)
{
	this.runtime = runtime;
};
(function ()
{
	var pluginProto = cr.plugins_.Audio.prototype;
	pluginProto.Type = function(plugin)
	{
		this.plugin = plugin;
		this.runtime = plugin.runtime;
	};
	var typeProto = pluginProto.Type.prototype;
	typeProto.onCreate = function()
	{
	};
	var audRuntime = null;
	var audInst = null;
	var audTag = "";
	var appPath = "";			// for PhoneGap only
	var API_HTML5 = 0;
	var API_WEBAUDIO = 1;
	var API_PHONEGAP = 2;
	var API_APPMOBI = 3;
	var api = API_HTML5;
	var context = null;
	var audioBuffers = [];		// cache of buffers
	var audioInstances = [];	// cache of instances
	var lastAudio = null;
	var useOgg = false;			// determined at create time
	var timescale_mode = 0;
	var silent = false;
	var masterVolume = 1;
	var listenerX = 0;
	var listenerY = 0;
	var panningModel = 1;		// HRTF
	var distanceModel = 1;		// Inverse
	var refDistance = 10;
	var maxDistance = 10000;
	var rolloffFactor = 1;
	var micSource = null;
	var micTag = "";
	var isMusicWorkaround = false;
	var musicPlayNextTouch = [];
	function dbToLinear(x)
	{
		var v = dbToLinear_nocap(x);
		if (v < 0)
			v = 0;
		if (v > 1)
			v = 1;
		return v;
	};
	function linearToDb(x)
	{
		if (x < 0)
			x = 0;
		if (x > 1)
			x = 1;
		return linearToDb_nocap(x);
	};
	function dbToLinear_nocap(x)
	{
		return Math.pow(10, x / 20);
	};
	function linearToDb_nocap(x)
	{
		return (Math.log(x) / Math.log(10)) * 20;
	};
	var effects = {};
	function getDestinationForTag(tag)
	{
		tag = tag.toLowerCase();
		if (effects.hasOwnProperty(tag))
		{
			if (effects[tag].length)
				return effects[tag][0].getInputNode();
		}
		return context["destination"];
	};
	function createGain()
	{
		if (context["createGain"])
			return context["createGain"]();
		else
			return context["createGainNode"]();
	};
	function createDelay(d)
	{
		if (context["createDelay"])
			return context["createDelay"](d);
		else
			return context["createDelayNode"](d);
	};
	function startSource(s)
	{
		if (s["start"])
			s["start"](0);
		else
			s["noteOn"](0);
	};
	function startSourceAt(s, x, d)
	{
		if (s["start"])
			s["start"](0, x);
		else
			s["noteGrainOn"](0, x, d - x);
	};
	function stopSource(s)
	{
		try {
			if (s["stop"])
				s["stop"](0);
			else
				s["noteOff"](0);
		}
		catch (e) {}
	};
	function setAudioParam(ap, value, ramp, time)
	{
		if (!ap)
			return;		// iOS is missing some parameters
		ap["cancelScheduledValues"](0);
		if (time === 0)
		{
			ap["value"] = value;
			return;
		}
		var curTime = context["currentTime"];
		time += curTime;
		switch (ramp) {
		case 0:		// step
			ap["setValueAtTime"](value, time);
			break;
		case 1:		// linear
			ap["setValueAtTime"](ap["value"], curTime);		// to set what to ramp from
			ap["linearRampToValueAtTime"](value, time);
			break;
		case 2:		// exponential
			ap["setValueAtTime"](ap["value"], curTime);		// to set what to ramp from
			ap["exponentialRampToValueAtTime"](value, time);
			break;
		}
	};
	var filterTypes = ["lowpass", "highpass", "bandpass", "lowshelf", "highshelf", "peaking", "notch", "allpass"];
	function FilterEffect(type, freq, detune, q, gain, mix)
	{
		this.type = "filter";
		this.params = [type, freq, detune, q, gain, mix];
		this.inputNode = createGain();
		this.wetNode = createGain();
		this.wetNode["gain"]["value"] = mix;
		this.dryNode = createGain();
		this.dryNode["gain"]["value"] = 1 - mix;
		this.filterNode = context["createBiquadFilter"]();
		if (typeof this.filterNode["type"] === "number")
			this.filterNode["type"] = type;
		else
			this.filterNode["type"] = filterTypes[type];
		this.filterNode["frequency"]["value"] = freq;
		if (this.filterNode["detune"])		// iOS 6 doesn't have detune yet
			this.filterNode["detune"]["value"] = detune;
		this.filterNode["Q"]["value"] = q;
		this.filterNode["gain"]["value"] = gain;
		this.inputNode["connect"](this.filterNode);
		this.inputNode["connect"](this.dryNode);
		this.filterNode["connect"](this.wetNode);
	};
	FilterEffect.prototype.connectTo = function (node)
	{
		this.wetNode["disconnect"]();
		this.wetNode["connect"](node);
		this.dryNode["disconnect"]();
		this.dryNode["connect"](node);
	};
	FilterEffect.prototype.remove = function ()
	{
		this.inputNode["disconnect"]();
		this.filterNode["disconnect"]();
		this.wetNode["disconnect"]();
		this.dryNode["disconnect"]();
	};
	FilterEffect.prototype.getInputNode = function ()
	{
		return this.inputNode;
	};
	FilterEffect.prototype.setParam = function(param, value, ramp, time)
	{
		switch (param) {
		case 0:		// mix
			value = value / 100;
			if (value < 0) value = 0;
			if (value > 1) value = 1;
			this.params[5] = value;
			setAudioParam(this.wetNode["gain"], value, ramp, time);
			setAudioParam(this.dryNode["gain"], 1 - value, ramp, time);
			break;
		case 1:		// filter frequency
			this.params[1] = value;
			setAudioParam(this.filterNode["frequency"], value, ramp, time);
			break;
		case 2:		// filter detune
			this.params[2] = value;
			setAudioParam(this.filterNode["detune"], value, ramp, time);
			break;
		case 3:		// filter Q
			this.params[3] = value;
			setAudioParam(this.filterNode["Q"], value, ramp, time);
			break;
		case 4:		// filter/delay gain (note value is in dB here)
			this.params[4] = value;
			setAudioParam(this.filterNode["gain"], value, ramp, time);
			break;
		}
	};
	function DelayEffect(delayTime, delayGain, mix)
	{
		this.type = "delay";
		this.params = [delayTime, delayGain, mix];
		this.inputNode = createGain();
		this.wetNode = createGain();
		this.wetNode["gain"]["value"] = mix;
		this.dryNode = createGain();
		this.dryNode["gain"]["value"] = 1 - mix;
		this.mainNode = createGain();
		this.delayNode = createDelay(delayTime);
		this.delayNode["delayTime"]["value"] = delayTime;
		this.delayGainNode = createGain();
		this.delayGainNode["gain"]["value"] = delayGain;
		this.inputNode["connect"](this.mainNode);
		this.inputNode["connect"](this.dryNode);
		this.mainNode["connect"](this.wetNode);
		this.mainNode["connect"](this.delayNode);
		this.delayNode["connect"](this.delayGainNode);
		this.delayGainNode["connect"](this.mainNode);
	};
	DelayEffect.prototype.connectTo = function (node)
	{
		this.wetNode["disconnect"]();
		this.wetNode["connect"](node);
		this.dryNode["disconnect"]();
		this.dryNode["connect"](node);
	};
	DelayEffect.prototype.remove = function ()
	{
		this.inputNode["disconnect"]();
		this.mainNode["disconnect"]();
		this.delayNode["disconnect"]();
		this.delayGainNode["disconnect"]();
		this.wetNode["disconnect"]();
		this.dryNode["disconnect"]();
	};
	DelayEffect.prototype.getInputNode = function ()
	{
		return this.inputNode;
	};
	DelayEffect.prototype.setParam = function(param, value, ramp, time)
	{
		switch (param) {
		case 0:		// mix
			value = value / 100;
			if (value < 0) value = 0;
			if (value > 1) value = 1;
			this.params[2] = value;
			setAudioParam(this.wetNode["gain"], value, ramp, time);
			setAudioParam(this.dryNode["gain"], 1 - value, ramp, time);
			break;
		case 4:		// filter/delay gain (note value is passed in dB but needs to be linear here)
			this.params[1] = dbToLinear(value);
			setAudioParam(this.delayGainNode["gain"], dbToLinear(value), ramp, time);
			break;
		case 5:		// delay time
			this.params[0] = value;
			setAudioParam(this.delayNode["delayTime"], value, ramp, time);
			break;
		}
	};
	function ConvolveEffect(buffer, normalize, mix, src)
	{
		this.type = "convolve";
		this.params = [normalize, mix, src];
		this.inputNode = createGain();
		this.wetNode = createGain();
		this.wetNode["gain"]["value"] = mix;
		this.dryNode = createGain();
		this.dryNode["gain"]["value"] = 1 - mix;
		this.convolveNode = context["createConvolver"]();
		if (buffer)
		{
			this.convolveNode["normalize"] = normalize;
			this.convolveNode["buffer"] = buffer;
		}
		this.inputNode["connect"](this.convolveNode);
		this.inputNode["connect"](this.dryNode);
		this.convolveNode["connect"](this.wetNode);
	};
	ConvolveEffect.prototype.connectTo = function (node)
	{
		this.wetNode["disconnect"]();
		this.wetNode["connect"](node);
		this.dryNode["disconnect"]();
		this.dryNode["connect"](node);
	};
	ConvolveEffect.prototype.remove = function ()
	{
		this.inputNode["disconnect"]();
		this.convolveNode["disconnect"]();
		this.wetNode["disconnect"]();
		this.dryNode["disconnect"]();
	};
	ConvolveEffect.prototype.getInputNode = function ()
	{
		return this.inputNode;
	};
	ConvolveEffect.prototype.setParam = function(param, value, ramp, time)
	{
		switch (param) {
		case 0:		// mix
			value = value / 100;
			if (value < 0) value = 0;
			if (value > 1) value = 1;
			this.params[1] = value;
			setAudioParam(this.wetNode["gain"], value, ramp, time);
			setAudioParam(this.dryNode["gain"], 1 - value, ramp, time);
			break;
		}
	};
	function FlangerEffect(delay, modulation, freq, feedback, mix)
	{
		this.type = "flanger";
		this.params = [delay, modulation, freq, feedback, mix];
		this.inputNode = createGain();
		this.dryNode = createGain();
		this.dryNode["gain"]["value"] = 1 - (mix / 2);
		this.wetNode = createGain();
		this.wetNode["gain"]["value"] = mix / 2;
		this.feedbackNode = createGain();
		this.feedbackNode["gain"]["value"] = feedback;
		this.delayNode = createDelay(delay + modulation);
		this.delayNode["delayTime"]["value"] = delay;
		this.oscNode = context["createOscillator"]();
		this.oscNode["frequency"]["value"] = freq;
		this.oscGainNode = createGain();
		this.oscGainNode["gain"]["value"] = modulation;
		this.inputNode["connect"](this.delayNode);
		this.inputNode["connect"](this.dryNode);
		this.delayNode["connect"](this.wetNode);
		this.delayNode["connect"](this.feedbackNode);
		this.feedbackNode["connect"](this.delayNode);
		this.oscNode["connect"](this.oscGainNode);
		this.oscGainNode["connect"](this.delayNode["delayTime"]);
		startSource(this.oscNode);
	};
	FlangerEffect.prototype.connectTo = function (node)
	{
		this.dryNode["disconnect"]();
		this.dryNode["connect"](node);
		this.wetNode["disconnect"]();
		this.wetNode["connect"](node);
	};
	FlangerEffect.prototype.remove = function ()
	{
		this.inputNode["disconnect"]();
		this.delayNode["disconnect"]();
		this.oscNode["disconnect"]();
		this.oscGainNode["disconnect"]();
		this.dryNode["disconnect"]();
		this.wetNode["disconnect"]();
		this.feedbackNode["disconnect"]();
	};
	FlangerEffect.prototype.getInputNode = function ()
	{
		return this.inputNode;
	};
	FlangerEffect.prototype.setParam = function(param, value, ramp, time)
	{
		switch (param) {
		case 0:		// mix
			value = value / 100;
			if (value < 0) value = 0;
			if (value > 1) value = 1;
			this.params[4] = value;
			setAudioParam(this.wetNode["gain"], value / 2, ramp, time);
			setAudioParam(this.dryNode["gain"], 1 - (value / 2), ramp, time);
			break;
		case 6:		// modulation
			this.params[1] = value / 1000;
			setAudioParam(this.oscGainNode["gain"], value / 1000, ramp, time);
			break;
		case 7:		// modulation frequency
			this.params[2] = value;
			setAudioParam(this.oscNode["frequency"], value, ramp, time);
			break;
		case 8:		// feedback
			this.params[3] = value / 100;
			setAudioParam(this.feedbackNode["gain"], value / 100, ramp, time);
			break;
		}
	};
	function PhaserEffect(freq, detune, q, modulation, modfreq, mix)
	{
		this.type = "phaser";
		this.params = [freq, detune, q, modulation, modfreq, mix];
		this.inputNode = createGain();
		this.dryNode = createGain();
		this.dryNode["gain"]["value"] = 1 - (mix / 2);
		this.wetNode = createGain();
		this.wetNode["gain"]["value"] = mix / 2;
		this.filterNode = context["createBiquadFilter"]();
		if (typeof this.filterNode["type"] === "number")
			this.filterNode["type"] = 7;	// all-pass
		else
			this.filterNode["type"] = "allpass";
		this.filterNode["frequency"]["value"] = freq;
		if (this.filterNode["detune"])		// iOS 6 doesn't have detune yet
			this.filterNode["detune"]["value"] = detune;
		this.filterNode["Q"]["value"] = q;
		this.oscNode = context["createOscillator"]();
		this.oscNode["frequency"]["value"] = modfreq;
		this.oscGainNode = createGain();
		this.oscGainNode["gain"]["value"] = modulation;
		this.inputNode["connect"](this.filterNode);
		this.inputNode["connect"](this.dryNode);
		this.filterNode["connect"](this.wetNode);
		this.oscNode["connect"](this.oscGainNode);
		this.oscGainNode["connect"](this.filterNode["frequency"]);
		startSource(this.oscNode);
	};
	PhaserEffect.prototype.connectTo = function (node)
	{
		this.dryNode["disconnect"]();
		this.dryNode["connect"](node);
		this.wetNode["disconnect"]();
		this.wetNode["connect"](node);
	};
	PhaserEffect.prototype.remove = function ()
	{
		this.inputNode["disconnect"]();
		this.filterNode["disconnect"]();
		this.oscNode["disconnect"]();
		this.oscGainNode["disconnect"]();
		this.dryNode["disconnect"]();
		this.wetNode["disconnect"]();
	};
	PhaserEffect.prototype.getInputNode = function ()
	{
		return this.inputNode;
	};
	PhaserEffect.prototype.setParam = function(param, value, ramp, time)
	{
		switch (param) {
		case 0:		// mix
			value = value / 100;
			if (value < 0) value = 0;
			if (value > 1) value = 1;
			this.params[5] = value;
			setAudioParam(this.wetNode["gain"], value / 2, ramp, time);
			setAudioParam(this.dryNode["gain"], 1 - (value / 2), ramp, time);
			break;
		case 1:		// filter frequency
			this.params[0] = value;
			setAudioParam(this.filterNode["frequency"], value, ramp, time);
			break;
		case 2:		// filter detune
			this.params[1] = value;
			setAudioParam(this.filterNode["detune"], value, ramp, time);
			break;
		case 3:		// filter Q
			this.params[2] = value;
			setAudioParam(this.filterNode["Q"], value, ramp, time);
			break;
		case 6:		// modulation
			this.params[3] = value;
			setAudioParam(this.oscGainNode["gain"], value, ramp, time);
			break;
		case 7:		// modulation frequency
			this.params[4] = value;
			setAudioParam(this.oscNode["frequency"], value, ramp, time);
			break;
		}
	};
	function GainEffect(g)
	{
		this.type = "gain";
		this.params = [g];
		this.node = createGain();
		this.node["gain"]["value"] = g;
	};
	GainEffect.prototype.connectTo = function (node_)
	{
		this.node["disconnect"]();
		this.node["connect"](node_);
	};
	GainEffect.prototype.remove = function ()
	{
		this.node["disconnect"]();
	};
	GainEffect.prototype.getInputNode = function ()
	{
		return this.node;
	};
	GainEffect.prototype.setParam = function(param, value, ramp, time)
	{
		switch (param) {
		case 4:		// gain
			this.params[0] = dbToLinear(value);
			setAudioParam(this.node["gain"], dbToLinear(value), ramp, time);
			break;
		}
	};
	function TremoloEffect(freq, mix)
	{
		this.type = "tremolo";
		this.params = [freq, mix];
		this.node = createGain();
		this.node["gain"]["value"] = 1 - (mix / 2);
		this.oscNode = context["createOscillator"]();
		this.oscNode["frequency"]["value"] = freq;
		this.oscGainNode = createGain();
		this.oscGainNode["gain"]["value"] = mix / 2;
		this.oscNode["connect"](this.oscGainNode);
		this.oscGainNode["connect"](this.node["gain"]);
		startSource(this.oscNode);
	};
	TremoloEffect.prototype.connectTo = function (node_)
	{
		this.node["disconnect"]();
		this.node["connect"](node_);
	};
	TremoloEffect.prototype.remove = function ()
	{
		this.oscNode["disconnect"]();
		this.oscGainNode["disconnect"]();
		this.node["disconnect"]();
	};
	TremoloEffect.prototype.getInputNode = function ()
	{
		return this.node;
	};
	TremoloEffect.prototype.setParam = function(param, value, ramp, time)
	{
		switch (param) {
		case 0:		// mix
			value = value / 100;
			if (value < 0) value = 0;
			if (value > 1) value = 1;
			this.params[1] = value;
			setAudioParam(this.node["gain"]["value"], 1 - (value / 2), ramp, time);
			setAudioParam(this.oscGainNode["gain"]["value"], value / 2, ramp, time);
			break;
		case 7:		// modulation frequency
			this.params[0] = value;
			setAudioParam(this.oscNode["frequency"], value, ramp, time);
			break;
		}
	};
	function RingModulatorEffect(freq, mix)
	{
		this.type = "ringmod";
		this.params = [freq, mix];
		this.inputNode = createGain();
		this.wetNode = createGain();
		this.wetNode["gain"]["value"] = mix;
		this.dryNode = createGain();
		this.dryNode["gain"]["value"] = 1 - mix;
		this.ringNode = createGain();
		this.ringNode["gain"]["value"] = 0;
		this.oscNode = context["createOscillator"]();
		this.oscNode["frequency"]["value"] = freq;
		this.oscNode["connect"](this.ringNode["gain"]);
		startSource(this.oscNode);
		this.inputNode["connect"](this.ringNode);
		this.inputNode["connect"](this.dryNode);
		this.ringNode["connect"](this.wetNode);
	};
	RingModulatorEffect.prototype.connectTo = function (node_)
	{
		this.wetNode["disconnect"]();
		this.wetNode["connect"](node_);
		this.dryNode["disconnect"]();
		this.dryNode["connect"](node_);
	};
	RingModulatorEffect.prototype.remove = function ()
	{
		this.oscNode["disconnect"]();
		this.ringNode["disconnect"]();
		this.inputNode["disconnect"]();
		this.wetNode["disconnect"]();
		this.dryNode["disconnect"]();
	};
	RingModulatorEffect.prototype.getInputNode = function ()
	{
		return this.inputNode;
	};
	RingModulatorEffect.prototype.setParam = function(param, value, ramp, time)
	{
		switch (param) {
		case 0:		// mix
			value = value / 100;
			if (value < 0) value = 0;
			if (value > 1) value = 1;
			this.params[1] = value;
			setAudioParam(this.wetNode["gain"], value, ramp, time);
			setAudioParam(this.dryNode["gain"], 1 - value, ramp, time);
			break;
		case 7:		// modulation frequency
			this.params[0] = value;
			setAudioParam(this.oscNode["frequency"], value, ramp, time);
			break;
		}
	};
	function DistortionEffect(threshold, headroom, drive, makeupgain, mix)
	{
		this.type = "distortion";
		this.params = [threshold, headroom, drive, makeupgain, mix];
		this.inputNode = createGain();
		this.preGain = createGain();
		this.postGain = createGain();
		this.setDrive(drive, dbToLinear_nocap(makeupgain));
		this.wetNode = createGain();
		this.wetNode["gain"]["value"] = mix;
		this.dryNode = createGain();
		this.dryNode["gain"]["value"] = 1 - mix;
		this.waveShaper = context["createWaveShaper"]();
		this.curve = new Float32Array(65536);
		this.generateColortouchCurve(threshold, headroom);
		this.waveShaper.curve = this.curve;
		this.inputNode["connect"](this.preGain);
		this.inputNode["connect"](this.dryNode);
		this.preGain["connect"](this.waveShaper);
		this.waveShaper["connect"](this.postGain);
		this.postGain["connect"](this.wetNode);
	};
	DistortionEffect.prototype.setDrive = function (drive, makeupgain)
	{
		if (drive < 0.01)
			drive = 0.01;
		this.preGain["gain"]["value"] = drive;
		this.postGain["gain"]["value"] = Math.pow(1 / drive, 0.6) * makeupgain;
	};
	function e4(x, k)
	{
		return 1.0 - Math.exp(-k * x);
	}
	DistortionEffect.prototype.shape = function (x, linearThreshold, linearHeadroom)
	{
		var maximum = 1.05 * linearHeadroom * linearThreshold;
		var kk = (maximum - linearThreshold);
		var sign = x < 0 ? -1 : +1;
		var absx = x < 0 ? -x : x;
		var shapedInput = absx < linearThreshold ? absx : linearThreshold + kk * e4(absx - linearThreshold, 1.0 / kk);
		shapedInput *= sign;
		return shapedInput;
	};
	DistortionEffect.prototype.generateColortouchCurve = function (threshold, headroom)
	{
		var linearThreshold = dbToLinear_nocap(threshold);
		var linearHeadroom = dbToLinear_nocap(headroom);
		var n = 65536;
		var n2 = n / 2;
		var x = 0;
		for (var i = 0; i < n2; ++i) {
			x = i / n2;
			x = this.shape(x, linearThreshold, linearHeadroom);
			this.curve[n2 + i] = x;
			this.curve[n2 - i - 1] = -x;
		}
	};
	DistortionEffect.prototype.connectTo = function (node)
	{
		this.wetNode["disconnect"]();
		this.wetNode["connect"](node);
		this.dryNode["disconnect"]();
		this.dryNode["connect"](node);
	};
	DistortionEffect.prototype.remove = function ()
	{
		this.inputNode["disconnect"]();
		this.preGain["disconnect"]();
		this.waveShaper["disconnect"]();
		this.postGain["disconnect"]();
		this.wetNode["disconnect"]();
		this.dryNode["disconnect"]();
	};
	DistortionEffect.prototype.getInputNode = function ()
	{
		return this.inputNode;
	};
	DistortionEffect.prototype.setParam = function(param, value, ramp, time)
	{
		switch (param) {
		case 0:		// mix
			value = value / 100;
			if (value < 0) value = 0;
			if (value > 1) value = 1;
			this.params[4] = value;
			setAudioParam(this.wetNode["gain"], value, ramp, time);
			setAudioParam(this.dryNode["gain"], 1 - value, ramp, time);
			break;
		}
	};
	function CompressorEffect(threshold, knee, ratio, attack, release)
	{
		this.type = "compressor";
		this.params = [threshold, knee, ratio, attack, release];
		this.node = context["createDynamicsCompressor"]();
		this.node["threshold"]["value"] = threshold;
		this.node["knee"]["value"] = knee;
		this.node["ratio"]["value"] = ratio;
		this.node["attack"]["value"] = attack;
		this.node["release"]["value"] = release;
	};
	CompressorEffect.prototype.connectTo = function (node_)
	{
		this.node["disconnect"]();
		this.node["connect"](node_);
	};
	CompressorEffect.prototype.remove = function ()
	{
		this.node["disconnect"]();
	};
	CompressorEffect.prototype.getInputNode = function ()
	{
		return this.node;
	};
	CompressorEffect.prototype.setParam = function(param, value, ramp, time)
	{
	};
	function AnalyserEffect(fftSize, smoothing)
	{
		this.type = "analyser";
		this.params = [fftSize, smoothing];
		this.node = context["createAnalyser"]();
		this.node["fftSize"] = fftSize;
		this.node["smoothingTimeConstant"] = smoothing;
		this.freqBins = new Float32Array(this.node["frequencyBinCount"]);
		this.signal = new Uint8Array(fftSize);
		this.peak = 0;
		this.rms = 0;
	};
	AnalyserEffect.prototype.tick = function ()
	{
		this.node["getFloatFrequencyData"](this.freqBins);
		this.node["getByteTimeDomainData"](this.signal);
		var fftSize = this.node["fftSize"];
		var i = 0;
		this.peak = 0;
		var rmsSquaredSum = 0;
		var s = 0;
		for ( ; i < fftSize; i++)
		{
			s = (this.signal[i] - 128) / 128;
			if (s < 0)
				s = -s;
			if (this.peak < s)
				this.peak = s;
			rmsSquaredSum += s * s;
		}
		this.peak = linearToDb(this.peak);
		this.rms = linearToDb(Math.sqrt(rmsSquaredSum / fftSize));
	};
	AnalyserEffect.prototype.connectTo = function (node_)
	{
		this.node["disconnect"]();
		this.node["connect"](node_);
	};
	AnalyserEffect.prototype.remove = function ()
	{
		this.node["disconnect"]();
	};
	AnalyserEffect.prototype.getInputNode = function ()
	{
		return this.node;
	};
	AnalyserEffect.prototype.setParam = function(param, value, ramp, time)
	{
	};
	var OT_POS_SAMPLES = 4;
	function ObjectTracker()
	{
		this.obj = null;
		this.loadUid = 0;
		this.speeds = [];
		this.lastX = 0;
		this.lastY = 0;
		this.moveAngle = 0;
	};
	ObjectTracker.prototype.setObject = function (obj_)
	{
		this.obj = obj_;
		if (this.obj)
		{
			this.lastX = this.obj.x;
			this.lastY = this.obj.y;
		}
		this.speeds.length = 0;
	};
	ObjectTracker.prototype.hasObject = function ()
	{
		return !!this.obj;
	};
	ObjectTracker.prototype.tick = function (dt)
	{
		if (!this.obj || dt === 0)
			return;
		this.moveAngle = cr.angleTo(this.lastX, this.lastY, this.obj.x, this.obj.y);
		var s = cr.distanceTo(this.lastX, this.lastY, this.obj.x, this.obj.y) / dt;
		if (this.speeds.length < OT_POS_SAMPLES)
			this.speeds.push(s);
		else
		{
			this.speeds.shift();
			this.speeds.push(s);
		}
		this.lastX = this.obj.x;
		this.lastY = this.obj.y;
	};
	ObjectTracker.prototype.getSpeed = function ()
	{
		if (!this.speeds.length)
			return 0;
		var i, len, sum = 0;
		for (i = 0, len = this.speeds.length; i < len; i++)
		{
			sum += this.speeds[i];
		}
		return sum / this.speeds.length;
	};
	ObjectTracker.prototype.getVelocityX = function ()
	{
		return Math.cos(this.moveAngle) * this.getSpeed();
	};
	ObjectTracker.prototype.getVelocityY = function ()
	{
		return Math.sin(this.moveAngle) * this.getSpeed();
	};
	var iOShadtouch = false;	// has had touch input on iOS to work around web audio API muting
	function C2AudioBuffer(src_, is_music)
	{
		this.src = src_;
		this.myapi = api;
		this.is_music = is_music;
		this.added_end_listener = false;
		var self = this;
		this.outNode = null;
		this.mediaSourceNode = null;
		this.panWhenReady = [];		// for web audio API positioned sounds
		this.seekWhenReady = 0;
		this.pauseWhenReady = false;
		if (api === API_WEBAUDIO && is_music)
		{
			this.myapi = API_HTML5;
			this.outNode = createGain();
		}
		this.bufferObject = null;			// actual audio object
		this.audioData = null;				// web audio api: ajax request result (compressed audio that needs decoding)
		var request;
		switch (this.myapi) {
		case API_HTML5:
			this.bufferObject = new Audio();
			if (api === API_WEBAUDIO && context["createMediaElementSource"] && !audRuntime.isFirefox)
			{
				this.bufferObject.addEventListener("canplay", function ()
				{
					if (!self.mediaSourceNode)		// protect against this event firing twice
					{
						self.mediaSourceNode = context["createMediaElementSource"](self.bufferObject);
						self.mediaSourceNode["connect"](self.outNode);
					}
				});
			}
			this.bufferObject.autoplay = false;	// this is only a source buffer, not an instance
			this.bufferObject.preload = "auto";
			this.bufferObject.src = src_;
			break;
		case API_WEBAUDIO:
			request = new XMLHttpRequest();
			request.open("GET", src_, true);
			request.responseType = "arraybuffer";
			request.onload = function () {
				self.audioData = request.response;
				self.decodeAudioBuffer();
			};
			request.send();
			break;
		case API_PHONEGAP:
			this.bufferObject = true;
			break;
		case API_APPMOBI:
			this.bufferObject = true;
			break;
		}
	};
	C2AudioBuffer.prototype.decodeAudioBuffer = function ()
	{
		if (this.bufferObject || !this.audioData)
			return;		// audio already decoded or AJAX request not yet complete
		var self = this;
		if (context["decodeAudioData"])
		{
			context["decodeAudioData"](this.audioData, function (buffer) {
					self.bufferObject = buffer;
					var p, i, len, a;
					if (!cr.is_undefined(self.playTagWhenReady) && !silent)
					{
						if (self.panWhenReady.length)
						{
							for (i = 0, len = self.panWhenReady.length; i < len; i++)
							{
								p = self.panWhenReady[i];
								a = new C2AudioInstance(self, p.thistag);
								a.setPannerEnabled(true);
								if (typeof p.objUid !== "undefined")
								{
									p.obj = audRuntime.getObjectByUID(p.objUid);
									if (!p.obj)
										continue;
								}
								if (p.obj)
								{
									var px = cr.rotatePtAround(p.obj.x, p.obj.y, -p.obj.layer.getAngle(), listenerX, listenerY, true);
									var py = cr.rotatePtAround(p.obj.x, p.obj.y, -p.obj.layer.getAngle(), listenerX, listenerY, false);
									a.setPan(px, py, cr.to_degrees(p.obj.angle - p.obj.layer.getAngle()), p.ia, p.oa, p.og);
									a.setObject(p.obj);
								}
								else
								{
									a.setPan(p.x, p.y, p.a, p.ia, p.oa, p.og);
								}
								a.play(self.loopWhenReady, self.volumeWhenReady, self.seekWhenReady);
								if (self.pauseWhenReady)
									a.pause();
								audioInstances.push(a);
							}
							self.panWhenReady.length = 0;
						}
						else
						{
							a = new C2AudioInstance(self, self.playTagWhenReady);
							a.play(self.loopWhenReady, self.volumeWhenReady, self.seekWhenReady);
							if (self.pauseWhenReady)
								a.pause();
							audioInstances.push(a);
						}
					}
					else if (!cr.is_undefined(self.convolveWhenReady))
					{
						var convolveNode = self.convolveWhenReady.convolveNode;
						convolveNode["normalize"] = self.normalizeWhenReady;
						convolveNode["buffer"] = buffer;
					}
			});
		}
		else
		{
			this.bufferObject = context["createBuffer"](this.audioData, false);
			if (!cr.is_undefined(this.playTagWhenReady) && !silent)
			{
				var a = new C2AudioInstance(this, this.playTagWhenReady);
				a.play(this.loopWhenReady, this.volumeWhenReady, this.seekWhenReady);
				if (this.pauseWhenReady)
					a.pause();
				audioInstances.push(a);
			}
			else if (!cr.is_undefined(this.convolveWhenReady))
			{
				var convolveNode = this.convolveWhenReady.convolveNode;
				convolveNode["normalize"] = this.normalizeWhenReady;
				convolveNode["buffer"] = this.bufferObject;
			}
		}
	};
	C2AudioBuffer.prototype.isLoaded = function ()
	{
		switch (this.myapi) {
		case API_HTML5:
			return this.bufferObject["readyState"] === 4;	// HAVE_ENOUGH_DATA
		case API_WEBAUDIO:
			return !!this.audioData;			// null until AJAX request completes
		case API_PHONEGAP:
			return true;
		case API_APPMOBI:
			return true;
		}
		return false;
	};
	function C2AudioInstance(buffer_, tag_)
	{
		var self = this;
		this.tag = tag_;
		this.fresh = true;
		this.stopped = true;
		this.src = buffer_.src;
		this.buffer = buffer_;
		this.myapi = api;
		this.is_music = buffer_.is_music;
		this.playbackRate = 1;
		this.pgended = true;			// for PhoneGap only: ended flag
		this.resume_me = false;			// make sure resumes when leaving suspend
		this.is_paused = false;
		this.resume_position = 0;		// for web audio api to resume from correct playback position
		this.looping = false;
		this.is_muted = false;
		this.is_silent = false;
		this.volume = 1;
		this.mutevol = 1;
		this.startTime = audRuntime.kahanTime.sum;
		this.gainNode = null;
		this.pannerNode = null;
		this.pannerEnabled = false;
		this.objectTracker = null;
		this.panX = 0;
		this.panY = 0;
		this.panAngle = 0;
		this.panConeInner = 0;
		this.panConeOuter = 0;
		this.panConeOuterGain = 0;
		this.instanceObject = null;
		var add_end_listener = false;
		switch (this.myapi) {
		case API_HTML5:
			if (this.is_music)
			{
				this.instanceObject = buffer_.bufferObject;
				add_end_listener = !buffer_.added_end_listener;
				buffer_.added_end_listener = true;
			}
			else
			{
				this.instanceObject = new Audio();
				this.instanceObject.autoplay = false;
				this.instanceObject.src = buffer_.bufferObject.src;
				add_end_listener = true;
			}
			if (add_end_listener)
			{
				this.instanceObject.addEventListener('ended', function () {
						audTag = self.tag;
						self.stopped = true;
						audRuntime.trigger(cr.plugins_.Audio.prototype.cnds.OnEnded, audInst);
				});
			}
			break;
		case API_WEBAUDIO:
			this.gainNode = createGain();
			this.gainNode["connect"](getDestinationForTag(tag_));
			if (this.buffer.myapi === API_WEBAUDIO)
			{
				if (buffer_.bufferObject)
				{
					this.instanceObject = context["createBufferSource"]();
					this.instanceObject["buffer"] = buffer_.bufferObject;
					this.instanceObject["connect"](this.gainNode);
				}
			}
			else
			{
				this.instanceObject = this.buffer.bufferObject;		// reference the audio element
				this.buffer.outNode["connect"](this.gainNode);
			}
			break;
		case API_PHONEGAP:
			this.instanceObject = new window["Media"](appPath + this.src, null, null, function (status) {
					if (status === window["Media"]["MEDIA_STOPPED"])
					{
						self.pgended = true;
						self.stopped = true;
						audTag = self.tag;
						audRuntime.trigger(cr.plugins_.Audio.prototype.cnds.OnEnded, audInst);
					}
			});
			break;
		case API_APPMOBI:
			this.instanceObject = true;
			break;
		}
	};
	C2AudioInstance.prototype.hasEnded = function ()
	{
		switch (this.myapi) {
		case API_HTML5:
			return this.instanceObject.ended;
		case API_WEBAUDIO:
			if (this.buffer.myapi === API_WEBAUDIO)
			{
				if (!this.fresh && !this.stopped && this.instanceObject["loop"])
					return false;
				if (this.is_paused)
					return false;
				return (audRuntime.kahanTime.sum - this.startTime) > this.buffer.bufferObject["duration"];
			}
			else
				return this.instanceObject.ended;
		case API_PHONEGAP:
			return this.pgended;
		case API_APPMOBI:
			true;	// recycling an AppMobi sound does not matter because it will just do another throwaway playSound
		}
		return true;
	};
	C2AudioInstance.prototype.canBeRecycled = function ()
	{
		if (this.fresh || this.stopped)
			return true;		// not yet used or is not playing
		return this.hasEnded();
	};
	C2AudioInstance.prototype.setPannerEnabled = function (enable_)
	{
		if (api !== API_WEBAUDIO)
			return;
		if (!this.pannerEnabled && enable_)
		{
			if (!this.pannerNode)
			{
				this.pannerNode = context["createPanner"]();
				if (typeof this.pannerNode["panningModel"] === "number")
					this.pannerNode["panningModel"] = panningModel;
				else
					this.pannerNode["panningModel"] = ["equalpower", "HRTF", "soundfield"][panningModel];
				if (typeof this.pannerNode["distanceModel"] === "number")
					this.pannerNode["distanceModel"] = distanceModel;
				else
					this.pannerNode["distanceModel"] = ["linear", "inverse", "exponential"][distanceModel];
				this.pannerNode["refDistance"] = refDistance;
				this.pannerNode["maxDistance"] = maxDistance;
				this.pannerNode["rolloffFactor"] = rolloffFactor;
			}
			this.gainNode["disconnect"]();
			this.gainNode["connect"](this.pannerNode);
			this.pannerNode["connect"](getDestinationForTag(this.tag));
			this.pannerEnabled = true;
		}
		else if (this.pannerEnabled && !enable_)
		{
			this.pannerNode["disconnect"]();
			this.gainNode["disconnect"]();
			this.gainNode["connect"](getDestinationForTag(this.tag));
			this.pannerEnabled = false;
		}
	};
	C2AudioInstance.prototype.setPan = function (x, y, angle, innerangle, outerangle, outergain)
	{
		if (!this.pannerEnabled || api !== API_WEBAUDIO)
			return;
		this.pannerNode["setPosition"](x, y, 0);
		this.pannerNode["setOrientation"](Math.cos(cr.to_radians(angle)), Math.sin(cr.to_radians(angle)), 0);
		this.pannerNode["coneInnerAngle"] = innerangle;
		this.pannerNode["coneOuterAngle"] = outerangle;
		this.pannerNode["coneOuterGain"] = outergain;
		this.panX = x;
		this.panY = y;
		this.panAngle = angle;
		this.panConeInner = innerangle;
		this.panConeOuter = outerangle;
		this.panConeOuterGain = outergain;
	};
	C2AudioInstance.prototype.setObject = function (o)
	{
		if (!this.pannerEnabled || api !== API_WEBAUDIO)
			return;
		if (!this.objectTracker)
			this.objectTracker = new ObjectTracker();
		this.objectTracker.setObject(o);
	};
	C2AudioInstance.prototype.tick = function (dt)
	{
		if (!this.pannerEnabled || api !== API_WEBAUDIO || !this.objectTracker || !this.objectTracker.hasObject() || !this.isPlaying())
		{
			return;
		}
		this.objectTracker.tick(dt);
		var inst = this.objectTracker.obj;
		var px = cr.rotatePtAround(inst.x, inst.y, -inst.layer.getAngle(), listenerX, listenerY, true);
		var py = cr.rotatePtAround(inst.x, inst.y, -inst.layer.getAngle(), listenerX, listenerY, false);
		this.pannerNode["setPosition"](px, py, 0);
		var a = 0;
		if (typeof this.objectTracker.obj.angle !== "undefined")
		{
			a = inst.angle - inst.layer.getAngle();
			this.pannerNode["setOrientation"](Math.cos(a), Math.sin(a), 0);
		}
		this.pannerNode["setVelocity"](this.objectTracker.getVelocityX(), this.objectTracker.getVelocityY(), 0);
	};
	C2AudioInstance.prototype.play = function (looping, vol, fromPosition)
	{
		var instobj = this.instanceObject;
		this.looping = looping;
		this.volume = vol;
		var seekPos = fromPosition || 0;
		switch (this.myapi) {
		case API_HTML5:
			if (instobj.playbackRate !== 1.0)
				instobj.playbackRate = 1.0;
			if (instobj.volume !== vol * masterVolume)
				instobj.volume = vol * masterVolume;
			if (instobj.loop !== looping)
				instobj.loop = looping;
			if (instobj.muted)
				instobj.muted = false;
			if (instobj.currentTime !== seekPos)
			{
				try {
					instobj.currentTime = seekPos;
				}
				catch (err)
				{
;
				}
			}
			if (this.is_music && isMusicWorkaround)
				musicPlayNextTouch.push(this);
			else
				this.instanceObject.play();
			break;
		case API_WEBAUDIO:
			this.muted = false;
			this.mutevol = 1;
			if (this.buffer.myapi === API_WEBAUDIO)
			{
				if (!this.fresh)
				{
					this.instanceObject = context["createBufferSource"]();
					this.instanceObject["buffer"] = this.buffer.bufferObject;
					this.instanceObject["connect"](this.gainNode);
				}
				this.instanceObject.loop = looping;
				this.gainNode["gain"]["value"] = vol * masterVolume;
				if (seekPos === 0)
					startSource(this.instanceObject);
				else
					startSourceAt(this.instanceObject, seekPos, this.getDuration());
			}
			else
			{
				if (instobj.playbackRate !== 1.0)
					instobj.playbackRate = 1.0;
				if (instobj.loop !== looping)
					instobj.loop = looping;
				this.gainNode["gain"]["value"] = vol * masterVolume;
				if (instobj.currentTime !== seekPos)
				{
					try {
						instobj.currentTime = seekPos;
					}
					catch (err)
					{
;
					}
				}
				if (this.is_music && isMusicWorkaround)
					musicPlayNextTouch.push(this);
				else
					instobj.play();
			}
			break;
		case API_PHONEGAP:
			if ((!this.fresh && this.stopped) || seekPos !== 0)
				instobj["seekTo"](seekPos);
			instobj["play"]();
			this.pgended = false;
			break;
		case API_APPMOBI:
			if (audRuntime.isDirectCanvas)
				AppMobi["context"]["playSound"](this.src);
			else
				AppMobi["player"]["playSound"](this.src);
			break;
		}
		this.playbackRate = 1;
		this.startTime = audRuntime.kahanTime.sum - seekPos;
		this.fresh = false;
		this.stopped = false;
		this.is_paused = false;
	};
	C2AudioInstance.prototype.stop = function ()
	{
		switch (this.myapi) {
		case API_HTML5:
			if (!this.instanceObject.paused)
				this.instanceObject.pause();
			break;
		case API_WEBAUDIO:
			if (this.buffer.myapi === API_WEBAUDIO)
				stopSource(this.instanceObject);
			else
			{
				if (!this.instanceObject.paused)
					this.instanceObject.pause();
			}
			break;
		case API_PHONEGAP:
			this.instanceObject["stop"]();
			break;
		case API_APPMOBI:
			break;
		}
		this.stopped = true;
		this.is_paused = false;
	};
	C2AudioInstance.prototype.pause = function ()
	{
		if (this.fresh || this.stopped || this.hasEnded() || this.is_paused)
			return;
		switch (this.myapi) {
		case API_HTML5:
			if (!this.instanceObject.paused)
				this.instanceObject.pause();
			break;
		case API_WEBAUDIO:
			if (this.buffer.myapi === API_WEBAUDIO)
			{
				this.resume_position = this.getPlaybackTime();
				if (this.looping)
					this.resume_position = this.resume_position % this.getDuration();
				stopSource(this.instanceObject);
			}
			else
			{
				if (!this.instanceObject.paused)
					this.instanceObject.pause();
			}
			break;
		case API_PHONEGAP:
			this.instanceObject["pause"]();
			break;
		case API_APPMOBI:
			break;
		}
		this.is_paused = true;
	};
	C2AudioInstance.prototype.resume = function ()
	{
		if (this.fresh || this.stopped || this.hasEnded() || !this.is_paused)
			return;
		switch (this.myapi) {
		case API_HTML5:
			this.instanceObject.play();
			break;
		case API_WEBAUDIO:
			if (this.buffer.myapi === API_WEBAUDIO)
			{
				this.instanceObject = context["createBufferSource"]();
				this.instanceObject["buffer"] = this.buffer.bufferObject;
				this.instanceObject["connect"](this.gainNode);
				this.instanceObject.loop = this.looping;
				this.gainNode["gain"]["value"] = masterVolume * this.volume * this.mutevol;
				this.startTime = audRuntime.kahanTime.sum - this.resume_position;
				startSourceAt(this.instanceObject, this.resume_position, this.getDuration());
			}
			else
			{
				this.instanceObject.play();
			}
			break;
		case API_PHONEGAP:
			this.instanceObject["play"]();
			break;
		case API_APPMOBI:
			break;
		}
		this.is_paused = false;
	};
	C2AudioInstance.prototype.seek = function (pos)
	{
		if (this.fresh || this.stopped || this.hasEnded())
			return;
		switch (this.myapi) {
		case API_HTML5:
			try {
				this.instanceObject.currentTime = pos;
			}
			catch (e) {}
			break;
		case API_WEBAUDIO:
			if (this.buffer.myapi === API_WEBAUDIO)
			{
				if (this.is_paused)
					this.resume_position = pos;
				else
				{
					this.pause();
					this.resume_position = pos;
					this.resume();
				}
			}
			else
			{
				try {
					this.instanceObject.currentTime = pos;
				}
				catch (e) {}
			}
			break;
		case API_PHONEGAP:
			break;
		case API_APPMOBI:
			break;
		}
	};
	C2AudioInstance.prototype.reconnect = function (toNode)
	{
		if (this.myapi !== API_WEBAUDIO)
			return;
		if (this.pannerEnabled)
		{
			this.pannerNode["disconnect"]();
			this.pannerNode["connect"](toNode);
		}
		else
		{
			this.gainNode["disconnect"]();
			this.gainNode["connect"](toNode);
		}
	};
	C2AudioInstance.prototype.getDuration = function ()
	{
		switch (this.myapi) {
		case API_HTML5:
			if (typeof this.instanceObject.duration !== "undefined")
				return this.instanceObject.duration;
			else
				return 0;
		case API_WEBAUDIO:
			return this.buffer.bufferObject["duration"];
		case API_PHONEGAP:
			return this.instanceObject["getDuration"]();
		case API_APPMOBI:
			return 0;
		}
		return 0;
	};
	C2AudioInstance.prototype.getPlaybackTime = function ()
	{
		var duration = this.getDuration();
		var ret = 0;
		switch (this.myapi) {
		case API_HTML5:
			if (typeof this.instanceObject.currentTime !== "undefined")
				ret = this.instanceObject.currentTime;
			break;
		case API_WEBAUDIO:
			if (this.buffer.myapi === API_WEBAUDIO)
			{
				if (this.is_paused)
					return this.resume_position;
				else
					ret = audRuntime.kahanTime.sum - this.startTime;
			}
			else if (typeof this.instanceObject.currentTime !== "undefined")
				ret = this.instanceObject.currentTime;
			break;
		case API_PHONEGAP:
			break;
		case API_APPMOBI:
			break;
		}
		if (!this.looping && ret > duration)
			ret = duration;
		return ret;
	};
	C2AudioInstance.prototype.isPlaying = function ()
	{
		return !this.is_paused && !this.fresh && !this.stopped && !this.hasEnded();
	};
	C2AudioInstance.prototype.setVolume = function (v)
	{
		this.volume = v;
		this.updateVolume();
	};
	C2AudioInstance.prototype.updateVolume = function ()
	{
		var volToSet = this.volume * masterVolume;
		switch (this.myapi) {
		case API_HTML5:
			if (this.instanceObject.volume && this.instanceObject.volume !== volToSet)
				this.instanceObject.volume = volToSet;
			break;
		case API_WEBAUDIO:
			this.gainNode["gain"]["value"] = volToSet * this.mutevol;
			break;
		case API_PHONEGAP:
			break;
		case API_APPMOBI:
			break;
		}
	};
	C2AudioInstance.prototype.getVolume = function ()
	{
		return this.volume;
	};
	C2AudioInstance.prototype.doSetMuted = function (m)
	{
		switch (this.myapi) {
		case API_HTML5:
			if (this.instanceObject.muted !== !!m)
				this.instanceObject.muted = !!m;
			break;
		case API_WEBAUDIO:
			this.mutevol = (m ? 0 : 1);
			this.gainNode["gain"]["value"] = masterVolume * this.volume * this.mutevol;
			break;
		case API_PHONEGAP:
			break;
		case API_APPMOBI:
			break;
		}
	};
	C2AudioInstance.prototype.setMuted = function (m)
	{
		this.is_muted = !!m;
		this.doSetMuted(this.is_muted || this.is_silent);
	};
	C2AudioInstance.prototype.setSilent = function (m)
	{
		this.is_silent = !!m;
		this.doSetMuted(this.is_muted || this.is_silent);
	};
	C2AudioInstance.prototype.setLooping = function (l)
	{
		this.looping = l;
		switch (this.myapi) {
		case API_HTML5:
			if (this.instanceObject.loop !== !!l)
				this.instanceObject.loop = !!l;
			break;
		case API_WEBAUDIO:
			if (this.instanceObject.loop !== !!l)
				this.instanceObject.loop = !!l;
			break;
		case API_PHONEGAP:
			break;
		case API_APPMOBI:
			break;
		}
	};
	C2AudioInstance.prototype.setPlaybackRate = function (r)
	{
		this.playbackRate = r;
		this.updatePlaybackRate();
	};
	C2AudioInstance.prototype.updatePlaybackRate = function ()
	{
		var r = this.playbackRate;
		if ((timescale_mode === 1 && !this.is_music) || timescale_mode === 2)
			r *= audRuntime.timescale;
		switch (this.myapi) {
		case API_HTML5:
			if (this.instanceObject.playbackRate !== r)
				this.instanceObject.playbackRate = r;
			break;
		case API_WEBAUDIO:
			if (this.buffer.myapi === API_WEBAUDIO)
			{
				if (this.instanceObject["playbackRate"]["value"] !== r)
					this.instanceObject["playbackRate"]["value"] = r;
			}
			else
			{
				if (this.instanceObject.playbackRate !== r)
					this.instanceObject.playbackRate = r;
			}
			break;
		case API_PHONEGAP:
			break;
		case API_APPMOBI:
			break;
		}
	};
	C2AudioInstance.prototype.setSuspended = function (s)
	{
		switch (this.myapi) {
		case API_HTML5:
			if (s)
			{
				if (this.isPlaying())
				{
					this.instanceObject["pause"]();
					this.resume_me = true;
				}
				else
					this.resume_me = false;
			}
			else
			{
				if (this.resume_me)
					this.instanceObject["play"]();
			}
			break;
		case API_WEBAUDIO:
			if (s)
			{
				if (this.isPlaying())
				{
					if (this.buffer.myapi === API_WEBAUDIO)
					{
						this.resume_position = this.getPlaybackTime();
						if (this.looping)
							this.resume_position = this.resume_position % this.getDuration();
						stopSource(this.instanceObject);
					}
					else
						this.instanceObject["pause"]();
					this.resume_me = true;
				}
				else
					this.resume_me = false;
			}
			else
			{
				if (this.resume_me)
				{
					if (this.buffer.myapi === API_WEBAUDIO)
					{
						this.instanceObject = context["createBufferSource"]();
						this.instanceObject["buffer"] = this.buffer.bufferObject;
						this.instanceObject["connect"](this.gainNode);
						this.instanceObject.loop = this.looping;
						this.gainNode["gain"]["value"] = masterVolume * this.volume * this.mutevol;
						this.startTime = audRuntime.kahanTime.sum - this.resume_position;
						startSourceAt(this.instanceObject, this.resume_position, this.getDuration());
					}
					else
					{
						this.instanceObject["play"]();
					}
				}
			}
			break;
		case API_PHONEGAP:
			if (s)
			{
				if (this.isPlaying())
				{
					this.instanceObject["pause"]();
					this.resume_me = true;
				}
				else
					this.resume_me = false;
			}
			else
			{
				if (this.resume_me)
					this.instanceObject["play"]();
			}
			break;
		case API_APPMOBI:
			break;
		}
	};
	pluginProto.Instance = function(type)
	{
		this.type = type;
		this.runtime = type.runtime;
		audRuntime = this.runtime;
		audInst = this;
		this.listenerTracker = null;
		this.listenerZ = -600;
		if ((this.runtime.isiOS || (this.runtime.isAndroid && (this.runtime.isChrome || this.runtime.isAndroidStockBrowser))) && !this.runtime.isCrosswalk)
		{
			isMusicWorkaround = true;
		}
		context = null;
		if (typeof AudioContext !== "undefined")
		{
			api = API_WEBAUDIO;
			context = new AudioContext();
		}
		else if (typeof webkitAudioContext !== "undefined")
		{
			api = API_WEBAUDIO;
			context = new webkitAudioContext();
		}
		if ((this.runtime.isiOS && api === API_WEBAUDIO) || isMusicWorkaround)
		{
			document.addEventListener("touchstart", function ()
			{
				var i, len, m;
				if (isMusicWorkaround)
				{
					if (!silent)
					{
						for (i = 0, len = musicPlayNextTouch.length; i < len; ++i)
						{
							m = musicPlayNextTouch[i];
							if (!m.stopped && !m.is_paused)
								m.instanceObject.play();
						}
					}
					musicPlayNextTouch.length = 0;
				}
				if (iOShadtouch || !context)
					return;
				var buffer = context["createBuffer"](1, 1, 22050);
				var source = context["createBufferSource"]();
				source["buffer"] = buffer;
				source["connect"](context["destination"]);
				startSource(source);
				iOShadtouch = true;
			}, true);
		}
		if (api !== API_WEBAUDIO)
		{
			if (this.runtime.isPhoneGap)
				api = API_PHONEGAP;
			else if (this.runtime.isAppMobi)
				api = API_APPMOBI;
		}
		if (api === API_PHONEGAP)
		{
			appPath = location.href;
			var i = appPath.lastIndexOf("/");
			if (i > -1)
				appPath = appPath.substr(0, i + 1);
			appPath = appPath.replace("file://", "");
		}
		if (this.runtime.isSafari && this.runtime.isWindows && typeof Audio === "undefined")
		{
			alert("It looks like you're using Safari for Windows without Quicktime.  Audio cannot be played until Quicktime is installed.");
			this.runtime.DestroyInstance(this);
		}
		else
		{
			if (this.runtime.isDirectCanvas)
				useOgg = this.runtime.isAndroid;		// AAC on iOS, OGG on Android
			else
			{
				try {
					useOgg = !!(new Audio().canPlayType('audio/ogg; codecs="vorbis"'));
				}
				catch (e)
				{
					useOgg = false;
				}
			}
			switch (api) {
			case API_HTML5:
;
				break;
			case API_WEBAUDIO:
;
				break;
			case API_PHONEGAP:
;
				break;
			case API_APPMOBI:
;
				break;
			default:
;
			}
			this.runtime.tickMe(this);
		}
	};
	var instanceProto = pluginProto.Instance.prototype;
	instanceProto.onCreate = function ()
	{
		timescale_mode = this.properties[0];	// 0 = off, 1 = sounds only, 2 = all
		this.saveload = this.properties[1];		// 0 = all, 1 = sounds only, 2 = music only, 3 = none
		panningModel = this.properties[2];		// 0 = equalpower, 1 = hrtf, 3 = soundfield
		distanceModel = this.properties[3];		// 0 = linear, 1 = inverse, 2 = exponential
		this.listenerZ = -this.properties[4];
		refDistance = this.properties[5];
		maxDistance = this.properties[6];
		rolloffFactor = this.properties[7];
		this.listenerTracker = new ObjectTracker();
		if (api === API_WEBAUDIO)
		{
			context["listener"]["speedOfSound"] = this.properties[8];
			context["listener"]["dopplerFactor"] = this.properties[9];
			context["listener"]["setPosition"](this.runtime.width / 2, this.runtime.height / 2, this.listenerZ);
			context["listener"]["setOrientation"](0, 0, 1, 0, -1, 0);
			window["c2OnAudioMicStream"] = function (localMediaStream, tag)
			{
				if (micSource)
					micSource["disconnect"]();
				micTag = tag.toLowerCase();
				micSource = context["createMediaStreamSource"](localMediaStream);
				micSource["connect"](getDestinationForTag(micTag));
			};
		}
		this.runtime.addSuspendCallback(function(s)
		{
			audInst.onSuspend(s);
		});
		var self = this;
		this.runtime.addDestroyCallback(function (inst)
		{
			self.onInstanceDestroyed(inst);
		});
	};
	instanceProto.onInstanceDestroyed = function (inst)
	{
		var i, len, a;
		for (i = 0, len = audioInstances.length; i < len; i++)
		{
			a = audioInstances[i];
			if (a.objectTracker)
			{
				if (a.objectTracker.obj === inst)
				{
					a.objectTracker.obj = null;
					if (a.pannerEnabled && a.isPlaying() && a.looping)
						a.stop();
				}
			}
		}
		if (this.listenerTracker.obj === inst)
			this.listenerTracker.obj = null;
	};
	instanceProto.saveToJSON = function ()
	{
		var o = {
			"silent": silent,
			"masterVolume": masterVolume,
			"listenerZ": this.listenerZ,
			"listenerUid": this.listenerTracker.hasObject() ? this.listenerTracker.obj.uid : -1,
			"playing": [],
			"effects": {}
		};
		var playingarr = o["playing"];
		var i, len, a, d, p, panobj, playbackTime;
		for (i = 0, len = audioInstances.length; i < len; i++)
		{
			a = audioInstances[i];
			if (!a.isPlaying())
				continue;				// no need to save stopped sounds
			if (this.saveload === 3)	// not saving/loading any sounds/music
				continue;
			if (a.is_music && this.saveload === 1)	// not saving/loading music
				continue;
			if (!a.is_music && this.saveload === 2)	// not saving/loading sound
				continue;
			playbackTime = a.getPlaybackTime();
			if (a.looping)
				playbackTime = playbackTime % a.getDuration();
			d = {
				"tag": a.tag,
				"buffersrc": a.buffer.src,
				"is_music": a.is_music,
				"playbackTime": playbackTime,
				"volume": a.volume,
				"looping": a.looping,
				"muted": a.is_muted,
				"playbackRate": a.playbackRate,
				"paused": a.is_paused,
				"resume_position": a.resume_position
			};
			if (a.pannerEnabled)
			{
				d["pan"] = {};
				panobj = d["pan"];
				if (a.objectTracker && a.objectTracker.hasObject())
				{
					panobj["objUid"] = a.objectTracker.obj.uid;
				}
				else
				{
					panobj["x"] = a.panX;
					panobj["y"] = a.panY;
					panobj["a"] = a.panAngle;
				}
				panobj["ia"] = a.panConeInner;
				panobj["oa"] = a.panConeOuter;
				panobj["og"] = a.panConeOuterGain;
			}
			playingarr.push(d);
		}
		var fxobj = o["effects"];
		var fxarr;
		for (p in effects)
		{
			if (effects.hasOwnProperty(p))
			{
				fxarr = [];
				for (i = 0, len = effects[p].length; i < len; i++)
				{
					fxarr.push({ "type": effects[p][i].type, "params": effects[p][i].params });
				}
				fxobj[p] = fxarr;
			}
		}
		return o;
	};
	var objectTrackerUidsToLoad = [];
	instanceProto.loadFromJSON = function (o)
	{
		var setSilent = o["silent"];
		masterVolume = o["masterVolume"];
		this.listenerZ = o["listenerZ"];
		this.listenerTracker.setObject(null);
		var listenerUid = o["listenerUid"];
		if (listenerUid !== -1)
		{
			this.listenerTracker.loadUid = listenerUid;
			objectTrackerUidsToLoad.push(this.listenerTracker);
		}
		var playingarr = o["playing"];
		var i, len, d, src, is_music, tag, playbackTime, looping, vol, b, a, p, pan, panObjUid;
		if (this.saveload !== 3)
		{
			for (i = 0, len = audioInstances.length; i < len; i++)
			{
				a = audioInstances[i];
				if (a.is_music && this.saveload === 1)
					continue;		// only saving/loading sound: leave music playing
				if (!a.is_music && this.saveload === 2)
					continue;		// only saving/loading music: leave sound playing
				a.stop();
			}
		}
		var fxarr, fxtype, fxparams, fx;
		for (p in effects)
		{
			if (effects.hasOwnProperty(p))
			{
				for (i = 0, len = effects[p].length; i < len; i++)
					effects[p][i].remove();
			}
		}
		cr.wipe(effects);
		for (p in o["effects"])
		{
			if (o["effects"].hasOwnProperty(p))
			{
				fxarr = o["effects"][p];
				for (i = 0, len = fxarr.length; i < len; i++)
				{
					fxtype = fxarr[i]["type"];
					fxparams = fxarr[i]["params"];
					switch (fxtype) {
					case "filter":
						addEffectForTag(p, new FilterEffect(fxparams[0], fxparams[1], fxparams[2], fxparams[3], fxparams[4], fxparams[5]));
						break;
					case "delay":
						addEffectForTag(p, new DelayEffect(fxparams[0], fxparams[1], fxparams[2]));
						break;
					case "convolve":
						src = fxparams[2];
						b = this.getAudioBuffer(src, false);
						if (b.bufferObject)
						{
							fx = new ConvolveEffect(b.bufferObject, fxparams[0], fxparams[1], src);
						}
						else
						{
							fx = new ConvolveEffect(null, fxparams[0], fxparams[1], src);
							b.normalizeWhenReady = fxparams[0];
							b.convolveWhenReady = fx;
						}
						addEffectForTag(p, fx);
						break;
					case "flanger":
						addEffectForTag(p, new FlangerEffect(fxparams[0], fxparams[1], fxparams[2], fxparams[3], fxparams[4]));
						break;
					case "phaser":
						addEffectForTag(p, new PhaserEffect(fxparams[0], fxparams[1], fxparams[2], fxparams[3], fxparams[4], fxparams[5]));
						break;
					case "gain":
						addEffectForTag(p, new GainEffect(fxparams[0]));
						break;
					case "tremolo":
						addEffectForTag(p, new TremoloEffect(fxparams[0], fxparams[1]));
						break;
					case "ringmod":
						addEffectForTag(p, new RingModulatorEffect(fxparams[0], fxparams[1]));
						break;
					case "distortion":
						addEffectForTag(p, new DistortionEffect(fxparams[0], fxparams[1], fxparams[2], fxparams[3], fxparams[4]));
						break;
					case "compressor":
						addEffectForTag(p, new CompressorEffect(fxparams[0], fxparams[1], fxparams[2], fxparams[3], fxparams[4]));
						break;
					case "analyser":
						addEffectForTag(p, new AnalyserEffect(fxparams[0], fxparams[1]));
						break;
					}
				}
			}
		}
		for (i = 0, len = playingarr.length; i < len; i++)
		{
			if (this.saveload === 3)	// not saving/loading any sounds/music
				continue;
			d = playingarr[i];
			src = d["buffersrc"];
			is_music = d["is_music"];
			tag = d["tag"];
			playbackTime = d["playbackTime"];
			looping = d["looping"];
			vol = d["volume"];
			pan = d["pan"];
			panObjUid = (pan && pan.hasOwnProperty("objUid")) ? pan["objUid"] : -1;
			if (is_music && this.saveload === 1)	// not saving/loading music
				continue;
			if (!is_music && this.saveload === 2)	// not saving/loading sound
				continue;
			a = this.getAudioInstance(src, tag, is_music, looping, vol);
			if (!a)
			{
				b = this.getAudioBuffer(src, is_music);
				b.seekWhenReady = playbackTime;
				b.pauseWhenReady = d["paused"];
				if (pan)
				{
					if (panObjUid !== -1)
					{
						b.panWhenReady.push({ objUid: panObjUid, ia: pan["ia"], oa: pan["oa"], og: pan["og"], thistag: tag });
					}
					else
					{
						b.panWhenReady.push({ x: pan["x"], y: pan["y"], a: pan["a"], ia: pan["ia"], oa: pan["oa"], og: pan["og"], thistag: tag });
					}
				}
				continue;
			}
			a.resume_position = d["resume_position"];
			a.setPannerEnabled(!!pan);
			a.play(looping, vol, playbackTime);
			a.updatePlaybackRate();
			a.updateVolume();
			a.doSetMuted(a.is_muted || a.is_silent);
			if (d["paused"])
				a.pause();
			if (d["muted"])
				a.setMuted(true);
			a.doSetMuted(a.is_muted || a.is_silent);
			if (pan)
			{
				if (panObjUid !== -1)
				{
					a.objectTracker = a.objectTracker || new ObjectTracker();
					a.objectTracker.loadUid = panObjUid;
					objectTrackerUidsToLoad.push(a.objectTracker);
				}
				else
				{
					a.setPan(pan["x"], pan["y"], pan["a"], pan["ia"], pan["oa"], pan["og"]);
				}
			}
		}
		if (setSilent && !silent)			// setting silent
		{
			for (i = 0, len = audioInstances.length; i < len; i++)
				audioInstances[i].setSilent(true);
			silent = true;
		}
		else if (!setSilent && silent)		// setting not silent
		{
			for (i = 0, len = audioInstances.length; i < len; i++)
				audioInstances[i].setSilent(false);
			silent = false;
		}
	};
	instanceProto.afterLoad = function ()
	{
		var i, len, ot, inst;
		for (i = 0, len = objectTrackerUidsToLoad.length; i < len; i++)
		{
			ot = objectTrackerUidsToLoad[i];
			inst = this.runtime.getObjectByUID(ot.loadUid);
			ot.setObject(inst);
			ot.loadUid = -1;
			if (inst)
			{
				listenerX = inst.x;
				listenerY = inst.y;
			}
		}
		objectTrackerUidsToLoad.length = 0;
	};
	instanceProto.onSuspend = function (s)
	{
		var i, len;
		for (i = 0, len = audioInstances.length; i < len; i++)
			audioInstances[i].setSuspended(s);
	};
	instanceProto.tick = function ()
	{
		var dt = this.runtime.dt;
		var i, len, a;
		for (i = 0, len = audioInstances.length; i < len; i++)
		{
			a = audioInstances[i];
			a.tick(dt);
			if (a.myapi !== API_HTML5 && a.myapi !== API_APPMOBI)
			{
				if (!a.fresh && !a.stopped && a.hasEnded())
				{
					a.stopped = true;
					audTag = a.tag;
					audRuntime.trigger(cr.plugins_.Audio.prototype.cnds.OnEnded, audInst);
				}
			}
			if (timescale_mode !== 0)
				a.updatePlaybackRate();
		}
		var p, arr, f;
		for (p in effects)
		{
			if (effects.hasOwnProperty(p))
			{
				arr = effects[p];
				for (i = 0, len = arr.length; i < len; i++)
				{
					f = arr[i];
					if (f.tick)
						f.tick();
				}
			}
		}
		if (api === API_WEBAUDIO && this.listenerTracker.hasObject())
		{
			this.listenerTracker.tick(dt);
			listenerX = this.listenerTracker.obj.x;
			listenerY = this.listenerTracker.obj.y;
			context["listener"]["setPosition"](this.listenerTracker.obj.x, this.listenerTracker.obj.y, this.listenerZ);
			context["listener"]["setVelocity"](this.listenerTracker.getVelocityX(), this.listenerTracker.getVelocityY(), 0);
		}
	};
	instanceProto.getAudioBuffer = function (src_, is_music)
	{
		var i, len, a, ret = null, j, k, lenj, ai;
		for (i = 0, len = audioBuffers.length; i < len; i++)
		{
			a = audioBuffers[i];
			if (a.src === src_)
			{
				ret = a;
				break;
			}
		}
		if (!ret)
		{
			ret = new C2AudioBuffer(src_, is_music);
			audioBuffers.push(ret);
		}
		return ret;
	};
	instanceProto.getAudioInstance = function (src_, tag, is_music, looping, vol)
	{
		var i, len, a;
		for (i = 0, len = audioInstances.length; i < len; i++)
		{
			a = audioInstances[i];
			if (a.src === src_ && (a.canBeRecycled() || is_music))
			{
				a.tag = tag;
				return a;
			}
		}
		var b = this.getAudioBuffer(src_, is_music);
		if (!b.bufferObject)
		{
			if (tag !== "<preload>")
			{
				b.playTagWhenReady = tag;
				b.loopWhenReady = looping;
				b.volumeWhenReady = vol;
			}
			return null;
		}
		a = new C2AudioInstance(b, tag);
		audioInstances.push(a);
		return a;
	};
	var taggedAudio = [];
	function getAudioByTag(tag)
	{
		taggedAudio.length = 0;
		if (!tag.length)
		{
			if (!lastAudio || lastAudio.hasEnded())
				return;
			else
			{
				taggedAudio.length = 1;
				taggedAudio[0] = lastAudio;
				return;
			}
		}
		var i, len, a;
		for (i = 0, len = audioInstances.length; i < len; i++)
		{
			a = audioInstances[i];
			if (cr.equals_nocase(tag, a.tag))
				taggedAudio.push(a);
		}
	};
	function reconnectEffects(tag)
	{
		var i, len, arr, n, toNode = context["destination"];
		if (effects.hasOwnProperty(tag))
		{
			arr = effects[tag];
			if (arr.length)
			{
				toNode = arr[0].getInputNode();
				for (i = 0, len = arr.length; i < len; i++)
				{
					n = arr[i];
					if (i + 1 === len)
						n.connectTo(context["destination"]);
					else
						n.connectTo(arr[i + 1].getInputNode());
				}
			}
		}
		getAudioByTag(tag);
		for (i = 0, len = taggedAudio.length; i < len; i++)
			taggedAudio[i].reconnect(toNode);
		if (micSource && micTag === tag)
		{
			micSource["disconnect"]();
			micSource["connect"](toNode);
		}
	};
	function addEffectForTag(tag, fx)
	{
		if (!effects.hasOwnProperty(tag))
			effects[tag] = [fx];
		else
			effects[tag].push(fx);
		reconnectEffects(tag);
	};
	function Cnds() {};
	Cnds.prototype.OnEnded = function (t)
	{
		return cr.equals_nocase(audTag, t);
	};
	Cnds.prototype.PreloadsComplete = function ()
	{
		var i, len;
		for (i = 0, len = audioBuffers.length; i < len; i++)
		{
			if (!audioBuffers[i].isLoaded())
				return false;
		}
		return true;
	};
	Cnds.prototype.AdvancedAudioSupported = function ()
	{
		return api === API_WEBAUDIO;
	};
	Cnds.prototype.IsSilent = function ()
	{
		return silent;
	};
	Cnds.prototype.IsAnyPlaying = function ()
	{
		var i, len;
		for (i = 0, len = audioInstances.length; i < len; i++)
		{
			if (audioInstances[i].isPlaying())
				return true;
		}
		return false;
	};
	Cnds.prototype.IsTagPlaying = function (tag)
	{
		getAudioByTag(tag);
		var i, len;
		for (i = 0, len = taggedAudio.length; i < len; i++)
		{
			if (taggedAudio[i].isPlaying())
				return true;
		}
		return false;
	};
	pluginProto.cnds = new Cnds();
	function Acts() {};
	Acts.prototype.Play = function (file, looping, vol, tag)
	{
		if (silent)
			return;
		var v = dbToLinear(vol);
		var is_music = file[1];
		var src = this.runtime.files_subfolder + file[0] + (useOgg ? ".ogg" : ".m4a");
		lastAudio = this.getAudioInstance(src, tag, is_music, looping!==0, v);
		if (!lastAudio)
			return;
		lastAudio.setPannerEnabled(false);
		lastAudio.play(looping!==0, v);
	};
	Acts.prototype.PlayAtPosition = function (file, looping, vol, x_, y_, angle_, innerangle_, outerangle_, outergain_, tag)
	{
		if (silent)
			return;
		var v = dbToLinear(vol);
		var is_music = file[1];
		var src = this.runtime.files_subfolder + file[0] + (useOgg ? ".ogg" : ".m4a");
		lastAudio = this.getAudioInstance(src, tag, is_music, looping!==0, v);
		if (!lastAudio)
		{
			var b = this.getAudioBuffer(src, is_music);
			b.panWhenReady.push({ x: x_, y: y_, a: angle_, ia: innerangle_, oa: outerangle_, og: dbToLinear(outergain_), thistag: tag });
			return;
		}
		lastAudio.setPannerEnabled(true);
		lastAudio.setPan(x_, y_, angle_, innerangle_, outerangle_, dbToLinear(outergain_));
		lastAudio.play(looping!==0, v);
	};
	Acts.prototype.PlayAtObject = function (file, looping, vol, obj, innerangle, outerangle, outergain, tag)
	{
		if (silent || !obj)
			return;
		var inst = obj.getFirstPicked();
		if (!inst)
			return;
		var v = dbToLinear(vol);
		var is_music = file[1];
		var src = this.runtime.files_subfolder + file[0] + (useOgg ? ".ogg" : ".m4a");
		lastAudio = this.getAudioInstance(src, tag, is_music, looping!==0, v);
		if (!lastAudio)
		{
			var b = this.getAudioBuffer(src, is_music);
			b.panWhenReady.push({ obj: inst, ia: innerangle, oa: outerangle, og: dbToLinear(outergain), thistag: tag });
			return;
		}
		lastAudio.setPannerEnabled(true);
		var px = cr.rotatePtAround(inst.x, inst.y, -inst.layer.getAngle(), listenerX, listenerY, true);
		var py = cr.rotatePtAround(inst.x, inst.y, -inst.layer.getAngle(), listenerX, listenerY, false);
		lastAudio.setPan(px, py, cr.to_degrees(inst.angle - inst.layer.getAngle()), innerangle, outerangle, dbToLinear(outergain));
		lastAudio.setObject(inst);
		lastAudio.play(looping!==0, v);
	};
	Acts.prototype.PlayByName = function (folder, filename, looping, vol, tag)
	{
		if (silent)
			return;
		var v = dbToLinear(vol);
		var is_music = (folder === 1);
		var src = this.runtime.files_subfolder + filename.toLowerCase() + (useOgg ? ".ogg" : ".m4a");
		lastAudio = this.getAudioInstance(src, tag, is_music, looping!==0, v);
		if (!lastAudio)
			return;
		lastAudio.setPannerEnabled(false);
		lastAudio.play(looping!==0, v);
	};
	Acts.prototype.PlayAtPositionByName = function (folder, filename, looping, vol, x_, y_, angle_, innerangle_, outerangle_, outergain_, tag)
	{
		if (silent)
			return;
		var v = dbToLinear(vol);
		var is_music = (folder === 1);
		var src = this.runtime.files_subfolder + filename.toLowerCase() + (useOgg ? ".ogg" : ".m4a");
		lastAudio = this.getAudioInstance(src, tag, is_music, looping!==0, v);
		if (!lastAudio)
		{
			var b = this.getAudioBuffer(src, is_music);
			b.panWhenReady.push({ x: x_, y: y_, a: angle_, ia: innerangle_, oa: outerangle_, og: dbToLinear(outergain_), thistag: tag });
			return;
		}
		lastAudio.setPannerEnabled(true);
		lastAudio.setPan(x_, y_, angle_, innerangle_, outerangle_, dbToLinear(outergain_));
		lastAudio.play(looping!==0, v);
	};
	Acts.prototype.PlayAtObjectByName = function (folder, filename, looping, vol, obj, innerangle, outerangle, outergain, tag)
	{
		if (silent || !obj)
			return;
		var inst = obj.getFirstPicked();
		if (!inst)
			return;
		var v = dbToLinear(vol);
		var is_music = (folder === 1);
		var src = this.runtime.files_subfolder + filename.toLowerCase() + (useOgg ? ".ogg" : ".m4a");
		lastAudio = this.getAudioInstance(src, tag, is_music, looping!==0, v);
		if (!lastAudio)
		{
			var b = this.getAudioBuffer(src, is_music);
			b.panWhenReady.push({ obj: inst, ia: innerangle, oa: outerangle, og: dbToLinear(outergain), thistag: tag });
			return;
		}
		lastAudio.setPannerEnabled(true);
		var px = cr.rotatePtAround(inst.x, inst.y, -inst.layer.getAngle(), listenerX, listenerY, true);
		var py = cr.rotatePtAround(inst.x, inst.y, -inst.layer.getAngle(), listenerX, listenerY, false);
		lastAudio.setPan(px, py, cr.to_degrees(inst.angle - inst.layer.getAngle()), innerangle, outerangle, dbToLinear(outergain));
		lastAudio.setObject(inst);
		lastAudio.play(looping!==0, v);
	};
	Acts.prototype.SetLooping = function (tag, looping)
	{
		getAudioByTag(tag);
		var i, len;
		for (i = 0, len = taggedAudio.length; i < len; i++)
			taggedAudio[i].setLooping(looping === 0);
	};
	Acts.prototype.SetMuted = function (tag, muted)
	{
		getAudioByTag(tag);
		var i, len;
		for (i = 0, len = taggedAudio.length; i < len; i++)
			taggedAudio[i].setMuted(muted === 0);
	};
	Acts.prototype.SetVolume = function (tag, vol)
	{
		getAudioByTag(tag);
		var v = dbToLinear(vol);
		var i, len;
		for (i = 0, len = taggedAudio.length; i < len; i++)
			taggedAudio[i].setVolume(v);
	};
	Acts.prototype.Preload = function (file)
	{
		if (silent)
			return;
		var is_music = file[1];
		var src = this.runtime.files_subfolder + file[0] + (useOgg ? ".ogg" : ".m4a");
		if (api === API_APPMOBI)
		{
			if (this.runtime.isDirectCanvas)
				AppMobi["context"]["loadSound"](src);
			else
				AppMobi["player"]["loadSound"](src);
			return;
		}
		else if (api === API_PHONEGAP)
		{
			return;
		}
		this.getAudioInstance(src, "<preload>", is_music, false);
	};
	Acts.prototype.PreloadByName = function (folder, filename)
	{
		if (silent)
			return;
		var is_music = (folder === 1);
		var src = this.runtime.files_subfolder + filename.toLowerCase() + (useOgg ? ".ogg" : ".m4a");
		if (api === API_APPMOBI)
		{
			if (this.runtime.isDirectCanvas)
				AppMobi["context"]["loadSound"](src);
			else
				AppMobi["player"]["loadSound"](src);
			return;
		}
		else if (api === API_PHONEGAP)
		{
			return;
		}
		this.getAudioInstance(src, "<preload>", is_music, false);
	};
	Acts.prototype.SetPlaybackRate = function (tag, rate)
	{
		getAudioByTag(tag);
		if (rate < 0.0)
			rate = 0;
		var i, len;
		for (i = 0, len = taggedAudio.length; i < len; i++)
			taggedAudio[i].setPlaybackRate(rate);
	};
	Acts.prototype.Stop = function (tag)
	{
		getAudioByTag(tag);
		var i, len;
		for (i = 0, len = taggedAudio.length; i < len; i++)
			taggedAudio[i].stop();
	};
	Acts.prototype.StopAll = function ()
	{
		var i, len;
		for (i = 0, len = audioInstances.length; i < len; i++)
			audioInstances[i].stop();
	};
	Acts.prototype.SetPaused = function (tag, state)
	{
		getAudioByTag(tag);
		var i, len;
		for (i = 0, len = taggedAudio.length; i < len; i++)
		{
			if (state === 0)
				taggedAudio[i].pause();
			else
				taggedAudio[i].resume();
		}
	};
	Acts.prototype.Seek = function (tag, pos)
	{
		getAudioByTag(tag);
		var i, len;
		for (i = 0, len = taggedAudio.length; i < len; i++)
		{
			taggedAudio[i].seek(pos);
		}
	};
	Acts.prototype.SetSilent = function (s)
	{
		var i, len;
		if (s === 2)					// toggling
			s = (silent ? 1 : 0);		// choose opposite state
		if (s === 0 && !silent)			// setting silent
		{
			for (i = 0, len = audioInstances.length; i < len; i++)
				audioInstances[i].setSilent(true);
			silent = true;
		}
		else if (s === 1 && silent)		// setting not silent
		{
			for (i = 0, len = audioInstances.length; i < len; i++)
				audioInstances[i].setSilent(false);
			silent = false;
		}
	};
	Acts.prototype.SetMasterVolume = function (vol)
	{
		masterVolume = dbToLinear(vol);
		var i, len;
		for (i = 0, len = audioInstances.length; i < len; i++)
			audioInstances[i].updateVolume();
	};
	Acts.prototype.AddFilterEffect = function (tag, type, freq, detune, q, gain, mix)
	{
		if (api !== API_WEBAUDIO || type < 0 || type >= filterTypes.length)
			return;
		tag = tag.toLowerCase();
		mix = mix / 100;
		if (mix < 0) mix = 0;
		if (mix > 1) mix = 1;
		addEffectForTag(tag, new FilterEffect(type, freq, detune, q, gain, mix));
	};
	Acts.prototype.AddDelayEffect = function (tag, delay, gain, mix)
	{
		if (api !== API_WEBAUDIO)
			return;
		tag = tag.toLowerCase();
		mix = mix / 100;
		if (mix < 0) mix = 0;
		if (mix > 1) mix = 1;
		addEffectForTag(tag, new DelayEffect(delay, dbToLinear(gain), mix));
	};
	Acts.prototype.AddFlangerEffect = function (tag, delay, modulation, freq, feedback, mix)
	{
		if (api !== API_WEBAUDIO)
			return;
		tag = tag.toLowerCase();
		mix = mix / 100;
		if (mix < 0) mix = 0;
		if (mix > 1) mix = 1;
		addEffectForTag(tag, new FlangerEffect(delay / 1000, modulation / 1000, freq, feedback / 100, mix));
	};
	Acts.prototype.AddPhaserEffect = function (tag, freq, detune, q, mod, modfreq, mix)
	{
		if (api !== API_WEBAUDIO)
			return;
		tag = tag.toLowerCase();
		mix = mix / 100;
		if (mix < 0) mix = 0;
		if (mix > 1) mix = 1;
		addEffectForTag(tag, new PhaserEffect(freq, detune, q, mod, modfreq, mix));
	};
	Acts.prototype.AddConvolutionEffect = function (tag, file, norm, mix)
	{
		if (api !== API_WEBAUDIO)
			return;
		var doNormalize = (norm === 0);
		var src = this.runtime.files_subfolder + file[0] + (useOgg ? ".ogg" : ".m4a");
		var b = this.getAudioBuffer(src, false);
		tag = tag.toLowerCase();
		mix = mix / 100;
		if (mix < 0) mix = 0;
		if (mix > 1) mix = 1;
		var fx;
		if (b.bufferObject)
		{
			fx = new ConvolveEffect(b.bufferObject, doNormalize, mix, src);
		}
		else
		{
			fx = new ConvolveEffect(null, doNormalize, mix, src);
			b.normalizeWhenReady = doNormalize;
			b.convolveWhenReady = fx;
		}
		addEffectForTag(tag, fx);
	};
	Acts.prototype.AddGainEffect = function (tag, g)
	{
		if (api !== API_WEBAUDIO)
			return;
		tag = tag.toLowerCase();
		addEffectForTag(tag, new GainEffect(dbToLinear(g)));
	};
	Acts.prototype.AddMuteEffect = function (tag)
	{
		if (api !== API_WEBAUDIO)
			return;
		tag = tag.toLowerCase();
		addEffectForTag(tag, new GainEffect(0));	// re-use gain effect with 0 gain
	};
	Acts.prototype.AddTremoloEffect = function (tag, freq, mix)
	{
		if (api !== API_WEBAUDIO)
			return;
		tag = tag.toLowerCase();
		mix = mix / 100;
		if (mix < 0) mix = 0;
		if (mix > 1) mix = 1;
		addEffectForTag(tag, new TremoloEffect(freq, mix));
	};
	Acts.prototype.AddRingModEffect = function (tag, freq, mix)
	{
		if (api !== API_WEBAUDIO)
			return;
		tag = tag.toLowerCase();
		mix = mix / 100;
		if (mix < 0) mix = 0;
		if (mix > 1) mix = 1;
		addEffectForTag(tag, new RingModulatorEffect(freq, mix));
	};
	Acts.prototype.AddDistortionEffect = function (tag, threshold, headroom, drive, makeupgain, mix)
	{
		if (api !== API_WEBAUDIO)
			return;
		tag = tag.toLowerCase();
		mix = mix / 100;
		if (mix < 0) mix = 0;
		if (mix > 1) mix = 1;
		addEffectForTag(tag, new DistortionEffect(threshold, headroom, drive, makeupgain, mix));
	};
	Acts.prototype.AddCompressorEffect = function (tag, threshold, knee, ratio, attack, release)
	{
		if (api !== API_WEBAUDIO)
			return;
		tag = tag.toLowerCase();
		addEffectForTag(tag, new CompressorEffect(threshold, knee, ratio, attack / 1000, release / 1000));
	};
	Acts.prototype.AddAnalyserEffect = function (tag, fftSize, smoothing)
	{
		if (api !== API_WEBAUDIO)
			return;
		tag = tag.toLowerCase();
		addEffectForTag(tag, new AnalyserEffect(fftSize, smoothing));
	};
	Acts.prototype.RemoveEffects = function (tag)
	{
		if (api !== API_WEBAUDIO)
			return;
		tag = tag.toLowerCase();
		var i, len, arr;
		if (effects.hasOwnProperty(tag))
		{
			arr = effects[tag];
			if (arr.length)
			{
				for (i = 0, len = arr.length; i < len; i++)
					arr[i].remove();
				arr.length = 0;
				reconnectEffects(tag);
			}
		}
	};
	Acts.prototype.SetEffectParameter = function (tag, index, param, value, ramp, time)
	{
		if (api !== API_WEBAUDIO)
			return;
		tag = tag.toLowerCase();
		index = Math.floor(index);
		var arr;
		if (!effects.hasOwnProperty(tag))
			return;
		arr = effects[tag];
		if (index < 0 || index >= arr.length)
			return;
		arr[index].setParam(param, value, ramp, time);
	};
	Acts.prototype.SetListenerObject = function (obj_)
	{
		if (!obj_ || api !== API_WEBAUDIO)
			return;
		var inst = obj_.getFirstPicked();
		if (!inst)
			return;
		this.listenerTracker.setObject(inst);
		listenerX = inst.x;
		listenerY = inst.y;
	};
	Acts.prototype.SetListenerZ = function (z)
	{
		this.listenerZ = z;
	};
	pluginProto.acts = new Acts();
	function Exps() {};
	Exps.prototype.Duration = function (ret, tag)
	{
		getAudioByTag(tag);
		if (taggedAudio.length)
			ret.set_float(taggedAudio[0].getDuration());
		else
			ret.set_float(0);
	};
	Exps.prototype.PlaybackTime = function (ret, tag)
	{
		getAudioByTag(tag);
		if (taggedAudio.length)
			ret.set_float(taggedAudio[0].getPlaybackTime());
		else
			ret.set_float(0);
	};
	Exps.prototype.Volume = function (ret, tag)
	{
		getAudioByTag(tag);
		if (taggedAudio.length)
		{
			var v = taggedAudio[0].getVolume();
			ret.set_float(linearToDb(v));
		}
		else
			ret.set_float(0);
	};
	Exps.prototype.MasterVolume = function (ret)
	{
		ret.set_float(masterVolume);
	};
	Exps.prototype.EffectCount = function (ret, tag)
	{
		tag = tag.toLowerCase();
		var arr = null;
		if (effects.hasOwnProperty(tag))
			arr = effects[tag];
		ret.set_int(arr ? arr.length : 0);
	};
	function getAnalyser(tag, index)
	{
		var arr = null;
		if (effects.hasOwnProperty(tag))
			arr = effects[tag];
		if (arr && index >= 0 && index < arr.length && arr[index].freqBins)
			return arr[index];
		else
			return null;
	};
	Exps.prototype.AnalyserFreqBinCount = function (ret, tag, index)
	{
		tag = tag.toLowerCase();
		index = Math.floor(index);
		var analyser = getAnalyser(tag, index);
		ret.set_int(analyser ? analyser.node["frequencyBinCount"] : 0);
	};
	Exps.prototype.AnalyserFreqBinAt = function (ret, tag, index, bin)
	{
		tag = tag.toLowerCase();
		index = Math.floor(index);
		bin = Math.floor(bin);
		var analyser = getAnalyser(tag, index);
		if (!analyser)
			ret.set_float(0);
		else if (bin < 0 || bin >= analyser.node["frequencyBinCount"])
			ret.set_float(0);
		else
			ret.set_float(analyser.freqBins[bin]);
	};
	Exps.prototype.AnalyserPeakLevel = function (ret, tag, index)
	{
		tag = tag.toLowerCase();
		index = Math.floor(index);
		var analyser = getAnalyser(tag, index);
		if (analyser)
			ret.set_float(analyser.peak);
		else
			ret.set_float(0);
	};
	Exps.prototype.AnalyserRMSLevel = function (ret, tag, index)
	{
		tag = tag.toLowerCase();
		index = Math.floor(index);
		var analyser = getAnalyser(tag, index);
		if (analyser)
			ret.set_float(analyser.rms);
		else
			ret.set_float(0);
	};
	pluginProto.exps = new Exps();
}());
;
;
cr.plugins_.Browser = function(runtime)
{
	this.runtime = runtime;
};
(function ()
{
	var pluginProto = cr.plugins_.Browser.prototype;
	pluginProto.Type = function(plugin)
	{
		this.plugin = plugin;
		this.runtime = plugin.runtime;
	};
	var typeProto = pluginProto.Type.prototype;
	typeProto.onCreate = function()
	{
	};
	pluginProto.Instance = function(type)
	{
		this.type = type;
		this.runtime = type.runtime;
	};
	var instanceProto = pluginProto.Instance.prototype;
	instanceProto.onCreate = function()
	{
		var self = this;
		window.addEventListener("resize", function () {
			self.runtime.trigger(cr.plugins_.Browser.prototype.cnds.OnResize, self);
		});
		if (typeof navigator.onLine !== "undefined")
		{
			window.addEventListener("online", function() {
				self.runtime.trigger(cr.plugins_.Browser.prototype.cnds.OnOnline, self);
			});
			window.addEventListener("offline", function() {
				self.runtime.trigger(cr.plugins_.Browser.prototype.cnds.OnOffline, self);
			});
		}
		if (typeof window.applicationCache !== "undefined")
		{
			window.applicationCache.addEventListener('updateready', function() {
				self.runtime.loadingprogress = 1;
				self.runtime.trigger(cr.plugins_.Browser.prototype.cnds.OnUpdateReady, self);
			});
			window.applicationCache.addEventListener('progress', function(e) {
				self.runtime.loadingprogress = e["loaded"] / e["total"];
			});
		}
		if (!this.runtime.isDirectCanvas)
		{
			document.addEventListener("appMobi.device.update.available", function() {
				self.runtime.trigger(cr.plugins_.Browser.prototype.cnds.OnUpdateReady, self);
			});
			document.addEventListener("backbutton", function() {
				self.runtime.trigger(cr.plugins_.Browser.prototype.cnds.OnBackButton, self);
			});
			document.addEventListener("menubutton", function() {
				self.runtime.trigger(cr.plugins_.Browser.prototype.cnds.OnMenuButton, self);
			});
			document.addEventListener("searchbutton", function() {
				self.runtime.trigger(cr.plugins_.Browser.prototype.cnds.OnSearchButton, self);
			});
			document.addEventListener("tizenhwkey", function (e) {
				var ret;
				switch (e["keyName"]) {
				case "back":
					ret = self.runtime.trigger(cr.plugins_.Browser.prototype.cnds.OnBackButton, self);
					if (!ret)
					{
						if (window["tizen"])
							window["tizen"]["application"]["getCurrentApplication"]()["exit"]();
					}
					break;
				case "menu":
					ret = self.runtime.trigger(cr.plugins_.Browser.prototype.cnds.OnMenuButton, self);
					if (!ret)
						e.preventDefault();
					break;
				}
			});
		}
		this.runtime.addSuspendCallback(function(s) {
			if (s)
			{
				self.runtime.trigger(cr.plugins_.Browser.prototype.cnds.OnPageHidden, self);
			}
			else
			{
				self.runtime.trigger(cr.plugins_.Browser.prototype.cnds.OnPageVisible, self);
			}
		});
		this.is_arcade = (typeof window["is_scirra_arcade"] !== "undefined");
	};
	function Cnds() {};
	Cnds.prototype.CookiesEnabled = function()
	{
		return navigator ? navigator.cookieEnabled : false;
	};
	Cnds.prototype.IsOnline = function()
	{
		return navigator ? navigator.onLine : false;
	};
	Cnds.prototype.HasJava = function()
	{
		return navigator ? navigator.javaEnabled() : false;
	};
	Cnds.prototype.OnOnline = function()
	{
		return true;
	};
	Cnds.prototype.OnOffline = function()
	{
		return true;
	};
	Cnds.prototype.IsDownloadingUpdate = function ()
	{
		if (typeof window["applicationCache"] === "undefined")
			return false;
		else
			return window["applicationCache"]["status"] === window["applicationCache"]["DOWNLOADING"];
	};
	Cnds.prototype.OnUpdateReady = function ()
	{
		return true;
	};
	Cnds.prototype.PageVisible = function ()
	{
		return !this.runtime.isSuspended;
	};
	Cnds.prototype.OnPageVisible = function ()
	{
		return true;
	};
	Cnds.prototype.OnPageHidden = function ()
	{
		return true;
	};
	Cnds.prototype.OnResize = function ()
	{
		return true;
	};
	Cnds.prototype.IsFullscreen = function ()
	{
		return !!(document["mozFullScreen"] || document["webkitIsFullScreen"] || document["fullScreen"] || this.runtime.isNodeFullscreen);
	};
	Cnds.prototype.OnBackButton = function ()
	{
		return true;
	};
	Cnds.prototype.OnMenuButton = function ()
	{
		return true;
	};
	Cnds.prototype.OnSearchButton = function ()
	{
		return true;
	};
	Cnds.prototype.IsMetered = function ()
	{
		var connection = navigator["connection"] || navigator["mozConnection"] || navigator["webkitConnection"];
		if (!connection)
			return false;
		return connection["metered"];
	};
	Cnds.prototype.IsCharging = function ()
	{
		var battery = navigator["battery"] || navigator["mozBattery"] || navigator["webkitBattery"];
		if (!battery)
			return true;
		return battery["charging"];
	};
	Cnds.prototype.IsPortraitLandscape = function (p)
	{
		var current = (window.innerWidth <= window.innerHeight ? 0 : 1);
		return current === p;
	};
	pluginProto.cnds = new Cnds();
	function Acts() {};
	Acts.prototype.Alert = function (msg)
	{
		if (!this.runtime.isDomFree)
			alert(msg.toString());
	};
	Acts.prototype.Close = function ()
	{
		if (this.runtime.isCocoonJs)
			CocoonJS["App"]["forceToFinish"]();
		else if (window["tizen"])
			window["tizen"]["application"]["getCurrentApplication"]()["exit"]();
		else if (!this.is_arcade && !this.runtime.isDomFree)
			window.close();
	};
	Acts.prototype.Focus = function ()
	{
		if (this.runtime.isNodeWebkit)
		{
			var win = window["nwgui"]["Window"]["get"]();
			win["focus"]();
		}
		else if (!this.is_arcade && !this.runtime.isDomFree)
			window.focus();
	};
	Acts.prototype.Blur = function ()
	{
		if (this.runtime.isNodeWebkit)
		{
			var win = window["nwgui"]["Window"]["get"]();
			win["blur"]();
		}
		else if (!this.is_arcade && !this.runtime.isDomFree)
			window.blur();
	};
	Acts.prototype.GoBack = function ()
	{
		if (!this.is_arcade && !this.runtime.isDomFree && window.back)
			window.back();
	};
	Acts.prototype.GoForward = function ()
	{
		if (!this.is_arcade && !this.runtime.isDomFree && window.forward)
			window.forward();
	};
	Acts.prototype.GoHome = function ()
	{
		if (!this.is_arcade && !this.runtime.isDomFree && window.home)
			window.home();
	};
	Acts.prototype.GoToURL = function (url)
	{
		if (this.runtime.isCocoonJs)
			CocoonJS["App"]["openURL"](url);
		else if (!this.is_arcade && !this.runtime.isDomFree)
			window.location = url;
	};
	Acts.prototype.GoToURLWindow = function (url, tag)
	{
		if (this.runtime.isCocoonJs)
			CocoonJS["App"]["openURL"](url);
		else if (!this.is_arcade && !this.runtime.isDomFree)
			window.open(url, tag);
	};
	Acts.prototype.Reload = function ()
	{
		if (!this.is_arcade && !this.runtime.isDomFree)
			window.location.reload();
	};
	var firstRequestFullscreen = true;
	var crruntime = null;
	function onFullscreenError()
	{
		if (typeof jQuery !== "undefined")
		{
			crruntime["setSize"](jQuery(window).width(), jQuery(window).height());
		}
	};
	Acts.prototype.RequestFullScreen = function (stretchmode)
	{
		if (this.runtime.isDomFree)
		{
			cr.logexport("[Construct 2] Requesting fullscreen is not supported on this platform - the request has been ignored");
			return;
		}
		if (stretchmode >= 2)
			stretchmode += 1;
		if (stretchmode === 6)
			stretchmode = 2;
		if (this.runtime.isNodeWebkit)
		{
			if (!this.runtime.isNodeFullscreen)
			{
				window["nwgui"]["Window"]["get"]()["enterFullscreen"]();
				this.runtime.isNodeFullscreen = true;
			}
		}
		else
		{
			if (document["mozFullScreen"] || document["webkitIsFullScreen"] || !!document["msFullscreenElement"] || document["fullScreen"])
			{
				return;
			}
			this.runtime.fullscreen_scaling = (stretchmode >= 2 ? stretchmode : 0);
			var elem = this.runtime.canvasdiv || this.runtime.canvas;
			if (firstRequestFullscreen)
			{
				firstRequestFullscreen = false;
				crruntime = this.runtime;
				elem.addEventListener("mozfullscreenerror", onFullscreenError);
				elem.addEventListener("webkitfullscreenerror", onFullscreenError);
				elem.addEventListener("msfullscreenerror", onFullscreenError);
				elem.addEventListener("fullscreenerror", onFullscreenError);
			}
			if (!cr.is_undefined(elem["requestFullscreen"]))
				elem["requestFullscreen"]();
			else if (!cr.is_undefined(elem["webkitRequestFullScreen"]))
			{
				if (typeof Element !== "undefined" && typeof Element["ALLOW_KEYBOARD_INPUT"] !== "undefined")
					elem["webkitRequestFullScreen"](Element["ALLOW_KEYBOARD_INPUT"]);
				else
					elem["webkitRequestFullScreen"]();
			}
			else if (!cr.is_undefined(elem["mozRequestFullScreen"]))
				elem["mozRequestFullScreen"]();
			else if (!cr.is_undefined(elem["msRequestFullscreen"]))
				elem["msRequestFullscreen"]();
		}
	};
	Acts.prototype.CancelFullScreen = function ()
	{
		if (this.runtime.isDomFree)
		{
			cr.logexport("[Construct 2] Exiting fullscreen is not supported on this platform - the request has been ignored");
			return;
		}
		if (this.runtime.isNodeWebkit)
		{
			if (this.runtime.isNodeFullscreen)
			{
				window["nwgui"]["Window"]["get"]()["leaveFullscreen"]();
				this.runtime.isNodeFullscreen = false;
			}
		}
		else
		{
			if (!cr.is_undefined(document["exitFullscreen"]))
				document["exitFullscreen"]();
			else if (!cr.is_undefined(document["webkitCancelFullScreen"]))
				document["webkitCancelFullScreen"]();
			else if (!cr.is_undefined(document["mozCancelFullScreen"]))
				document["mozCancelFullScreen"]();
			else if (!cr.is_undefined(document["msExitFullscreen"]))
				document["msExitFullscreen"]();
		}
	};
	Acts.prototype.Vibrate = function (pattern_)
	{
		try {
			var arr = pattern_.split(",");
			var i, len;
			for (i = 0, len = arr.length; i < len; i++)
			{
				arr[i] = parseInt(arr[i], 10);
			}
			if (navigator["vibrate"])
				navigator["vibrate"](arr);
			else if (navigator["mozVibrate"])
				navigator["mozVibrate"](arr);
			else if (navigator["webkitVibrate"])
				navigator["webkitVibrate"](arr);
			else if (navigator["msVibrate"])
				navigator["msVibrate"](arr);
		}
		catch (e) {}
	};
	Acts.prototype.InvokeDownload = function (url_, filename_)
	{
		var a = document.createElement("a");
		if (typeof a.download === "undefined")
		{
			window.open(url_);
		}
		else
		{
			var body = document.getElementsByTagName("body")[0];
			a.textContent = filename_;
			a.href = url_;
			a.download = filename_;
			body.appendChild(a);
			var clickEvent = document.createEvent("MouseEvent");
			clickEvent.initMouseEvent("click", true, true, window, 0, 0, 0, 0, 0, false, false, false, false, 0, null);
			a.dispatchEvent(clickEvent);
			body.removeChild(a);
		}
	};
	Acts.prototype.InvokeDownloadString = function (str_, mimetype_, filename_)
	{
		var datauri = "data:" + mimetype_ + "," + encodeURIComponent(str_);
		var a = document.createElement("a");
		if (typeof a.download === "undefined")
		{
			window.open(datauri);
		}
		else
		{
			var body = document.getElementsByTagName("body")[0];
			a.textContent = filename_;
			a.href = datauri;
			a.download = filename_;
			body.appendChild(a);
			var clickEvent = document.createEvent("MouseEvent");
			clickEvent.initMouseEvent("click", true, true, window, 0, 0, 0, 0, 0, false, false, false, false, 0, null);
			a.dispatchEvent(clickEvent);
			body.removeChild(a);
		}
	};
	Acts.prototype.ConsoleLog = function (type_, msg_)
	{
		if (typeof console === "undefined")
			return;
		if (type_ === 0 && console.log)
			console.log(msg_.toString());
		if (type_ === 1 && console.warn)
			console.warn(msg_.toString());
		if (type_ === 2 && console.error)
			console.error(msg_.toString());
	};
	Acts.prototype.ConsoleGroup = function (name_)
	{
		if (console && console.group)
			console.group(name_);
	};
	Acts.prototype.ConsoleGroupEnd = function ()
	{
		if (console && console.groupEnd)
			console.groupEnd();
	};
	Acts.prototype.ExecJs = function (js_)
	{
		if (eval)
			eval(js_);
	};
	var orientations = [
		"portrait",
		"landscape",
		"portrait-primary",
		"portrait-secondary",
		"landscape-primary",
		"landscape-secondary"
	];
	Acts.prototype.LockOrientation = function (o)
	{
		o = Math.floor(o);
		if (o < 0 || o >= orientations.length)
			return;
		this.runtime.autoLockOrientation = false;
		var orientation = orientations[o];
		if (screen["lockOrientation"])
			screen["lockOrientation"](orientation);
		else if (screen["webkitLockOrientation"])
			screen["webkitLockOrientation"](orientation);
		else if (screen["mozLockOrientation"])
			screen["mozLockOrientation"](orientation);
		else if (screen["msLockOrientation"])
			screen["msLockOrientation"](orientation);
	};
	Acts.prototype.UnlockOrientation = function ()
	{
		this.runtime.autoLockOrientation = false;
		if (screen["unlockOrientation"])
			screen["unlockOrientation"]();
		else if (screen["webkitUnlockOrientation"])
			screen["webkitUnlockOrientation"]();
		else if (screen["mozUnlockOrientation"])
			screen["mozUnlockOrientation"]();
		else if (screen["msUnlockOrientation"])
			screen["msUnlockOrientation"]();
	};
	pluginProto.acts = new Acts();
	function Exps() {};
	Exps.prototype.URL = function (ret)
	{
		ret.set_string(this.runtime.isDomFree ? "" : window.location.toString());
	};
	Exps.prototype.Protocol = function (ret)
	{
		ret.set_string(this.runtime.isDomFree ? "" : window.location.protocol);
	};
	Exps.prototype.Domain = function (ret)
	{
		ret.set_string(this.runtime.isDomFree ? "" : window.location.hostname);
	};
	Exps.prototype.PathName = function (ret)
	{
		ret.set_string(this.runtime.isDomFree ? "" : window.location.pathname);
	};
	Exps.prototype.Hash = function (ret)
	{
		ret.set_string(this.runtime.isDomFree ? "" : window.location.hash);
	};
	Exps.prototype.Referrer = function (ret)
	{
		ret.set_string(this.runtime.isDomFree ? "" : document.referrer);
	};
	Exps.prototype.Title = function (ret)
	{
		ret.set_string(this.runtime.isDomFree ? "" : document.title);
	};
	Exps.prototype.Name = function (ret)
	{
		ret.set_string(this.runtime.isDomFree ? "" : navigator.appName);
	};
	Exps.prototype.Version = function (ret)
	{
		ret.set_string(this.runtime.isDomFree ? "" : navigator.appVersion);
	};
	Exps.prototype.Language = function (ret)
	{
		if (navigator && navigator.language)
			ret.set_string(navigator.language);
		else
			ret.set_string("");
	};
	Exps.prototype.Platform = function (ret)
	{
		ret.set_string(this.runtime.isDomFree ? "" : navigator.platform);
	};
	Exps.prototype.Product = function (ret)
	{
		if (navigator && navigator.product)
			ret.set_string(navigator.product);
		else
			ret.set_string("");
	};
	Exps.prototype.Vendor = function (ret)
	{
		if (navigator && navigator.vendor)
			ret.set_string(navigator.vendor);
		else
			ret.set_string("");
	};
	Exps.prototype.UserAgent = function (ret)
	{
		ret.set_string(this.runtime.isDomFree ? "" : navigator.userAgent);
	};
	Exps.prototype.QueryString = function (ret)
	{
		ret.set_string(this.runtime.isDomFree ? "" : window.location.search);
	};
	Exps.prototype.QueryParam = function (ret, paramname)
	{
		if (this.runtime.isDomFree)
		{
			ret.set_string("");
			return;
		}
		var match = RegExp('[?&]' + paramname + '=([^&]*)').exec(window.location.search);
		if (match)
			ret.set_string(decodeURIComponent(match[1].replace(/\+/g, ' ')));
		else
			ret.set_string("");
	};
	Exps.prototype.Bandwidth = function (ret)
	{
		var connection = navigator["connection"] || navigator["mozConnection"] || navigator["webkitConnection"];
		if (!connection)
			ret.set_float(Number.POSITIVE_INFINITY);
		else
			ret.set_float(connection["bandwidth"]);
	};
	Exps.prototype.BatteryLevel = function (ret)
	{
		var battery = navigator["battery"] || navigator["mozBattery"] || navigator["webkitBattery"];
		if (!battery)
			ret.set_float(1);
		else
			ret.set_float(battery["level"]);
	};
	Exps.prototype.BatteryTimeLeft = function (ret)
	{
		var battery = navigator["battery"] || navigator["mozBattery"] || navigator["webkitBattery"];
		if (!battery)
			ret.set_float(Number.POSITIVE_INFINITY);
		else
			ret.set_float(battery["dischargingTime"]);
	};
	Exps.prototype.ExecJS = function (ret, js_)
	{
		if (!eval)
		{
			ret.set_any(0);
			return;
		}
		var result = eval(js_);
		if (typeof result === "number")
			ret.set_any(result);
		else if (typeof result === "string")
			ret.set_any(result);
		else if (typeof result === "boolean")
			ret.set_any(result ? 1 : 0);
		else
			ret.set_any(0);
	};
	Exps.prototype.ScreenWidth = function (ret)
	{
		ret.set_int(screen.width);
	};
	Exps.prototype.ScreenHeight = function (ret)
	{
		ret.set_int(screen.height);
	};
	Exps.prototype.DevicePixelRatio = function (ret)
	{
		ret.set_float(this.runtime.devicePixelRatio);
	};
	pluginProto.exps = new Exps();
}());
;
;
cr.plugins_.CJSAds = function(runtime)
{
	this.runtime = runtime;
};
(function ()
{
	var input_text = "";
	var products_list = [];
	var requested_score = 0;
	var bannerPosition = 0;
	var preloadingBanner = false;
	var bannerReady = false;
	var preloadingFullscreen = false;
	var fullscreenReady = false;
	var pluginProto = cr.plugins_.CJSAds.prototype;
	pluginProto.Type = function(plugin)
	{
		this.plugin = plugin;
		this.runtime = plugin.runtime;
	};
	var typeProto = pluginProto.Type.prototype;
	typeProto.onCreate = function()
	{
	};
	pluginProto.Instance = function(type)
	{
		this.type = type;
		this.runtime = type.runtime;
	};
	var instanceProto = pluginProto.Instance.prototype;
	instanceProto.onCreate = function()
	{
		this.isShowingBanner = false;
		this.isShowingFullscreen = false;
		this.triggerProduct = "";
		this.socialService = null;
		this.socialServiceAvailable = false;
		this.storeServiceAvailable = (this.runtime.isCocoonJs && typeof CocoonJS["Store"]["nativeExtensionObjectAvailable"] !== "undefined");
		this.storeManaged = (this.properties[1] !== 1);
		this.storeSandboxed = (this.properties[2] !== 0);
		this.onConsumePurchaseFailedTransactionId = "";
		this.onConsumePurchaseCompleted = "";
		var self = this;
		if (this.runtime.isCocoonJs)
		{
			CocoonJS["App"]["onTextDialogFinished"].addEventListener(function(text) {
				input_text = text;
				self.runtime.trigger(cr.plugins_.CJSAds.prototype.cnds.OnKeyboardOK, self);
			});
			CocoonJS["App"]["onTextDialogCancelled"].addEventListener(function() {
					self.runtime.trigger(cr.plugins_.CJSAds.prototype.cnds.OnKeyboardCancelled, self);
			});
			CocoonJS["Ad"]["onBannerShown"].addEventListener(function ()
			{
				self.isShowingBanner = true;
				self.runtime.trigger(cr.plugins_.CJSAds.prototype.cnds.OnBannerShown, self);
			});
			CocoonJS["Ad"]["onBannerReady"].addEventListener(function ()
			{
				bannerReady = true;
				if (!preloadingBanner)
				{
					CocoonJS["Ad"]["setBannerLayout"](bannerPosition);
					CocoonJS["Ad"]["showBanner"]();
				}
			});
			CocoonJS["Ad"]["onFullScreenShown"].addEventListener(function ()
			{
				self.isShowingFullscreen = true;
				self.runtime.trigger(cr.plugins_.CJSAds.prototype.cnds.OnFullscreenShown, self);
			});
			CocoonJS["Ad"]["onFullScreenHidden"].addEventListener(function ()
			{
				self.isShowingFullscreen = false;
				self.runtime.trigger(cr.plugins_.CJSAds.prototype.cnds.OnFullscreenHidden, self);
			});
			CocoonJS["Ad"]["onFullScreenReady"].addEventListener(function ()
			{
				fullscreenReady = true;
				if (!preloadFullScreen)
					CocoonJS["Ad"]["showFullScreen"]();
			});
			if (this.storeServiceAvailable)
			{
				CocoonJS["Store"]["onProductPurchaseCompleted"].addEventListener(function (purchase)
				{
					self.triggerProduct = purchase["productId"];
					self.runtime.trigger(cr.plugins_.CJSAds.prototype.cnds.OnPurchaseComplete, self);
					CocoonJS["Store"]["addPurchase"](purchase);
					CocoonJS["Store"]["consumePurchase"](purchase["transactionId"], purchase["productId"]);
					CocoonJS["Store"]["finishPurchase"](purchase["transactionId"]);
				});
				CocoonJS["Store"]["onConsumePurchaseFailed"].addEventListener(function(transactionId, errorMessage)
				{
					this.onConsumePurchaseFailedTransactionId = transactionId;
					self.runtime.trigger(cr.plugins_.CJSAds.prototype.cnds.onConsumePurchaseFailed, self);
				});
				CocoonJS["Store"]["onConsumePurchaseCompleted"].addEventListener(function(transactionId)
				{
					this.onConsumePurchaseCompleted = transactionId;
					self.runtime.trigger(cr.plugins_.CJSAds.prototype.cnds.onConsumePurchaseCompleted, self);
				});
				CocoonJS["Store"]["onProductPurchaseFailed"].addEventListener(function (productId, errorMsg)
				{
					self.triggerProduct = productId;
					self.runtime.trigger(cr.plugins_.CJSAds.prototype.cnds.OnPurchaseFail, self);
				});
				CocoonJS["Store"]["onProductPurchaseStarted"].addEventListener(function (productinfo)
				{
					self.triggerProduct = productinfo["productId"];
					self.runtime.trigger(cr.plugins_.CJSAds.prototype.cnds.OnPurchaseStart, self);
				});
				CocoonJS["Store"]["onProductsFetchStarted"].addEventListener(function ()
				{
					self.runtime.trigger(cr.plugins_.CJSAds.prototype.cnds.onProductsFetchStarted, self);
				});
				CocoonJS["Store"]["onProductsFetchFailed"].addEventListener(function ()
				{
					self.runtime.trigger(cr.plugins_.CJSAds.prototype.cnds.onProductsFetchFailed, self);
				});
				CocoonJS["Store"]["onProductsFetchCompleted"].addEventListener(function (products)
				{
					self.runtime.trigger(cr.plugins_.CJSAds.prototype.cnds.onProductsFetchCompleted, self);
				});
				CocoonJS["Store"]["requestInitialization"]({
					"managed": this.storeManaged,
					"sandbox": this.storeSandboxed
				});
				CocoonJS["Store"]["start"]();
			}
			this.socialService = CocoonJS["SocialGaming"]["GameCenter"];
			this.socialServiceAvailable = !!this.socialService["nativeExtensionObjectAvailable"];
			this.socialService["onRequestLoginSucceed"].addEventListener(function () {
				self.runtime.trigger(cr.plugins_.CJSAds.prototype.cnds.OnGCLoginSuccess, self);
			});
			this.socialService["onRequestLoginFailed"].addEventListener(function () {
				self.runtime.trigger(cr.plugins_.CJSAds.prototype.cnds.OnGCLoginFail, self);
			});
			this.socialService["onLogout"].addEventListener(function () {
				self.runtime.trigger(cr.plugins_.CJSAds.prototype.cnds.OnGCLogout, self);
			});
			this.socialService["onRequestUserScoreSucceed"].addEventListener(function (userInfo) {
				requested_score = userInfo["score"] || 0;
				self.runtime.trigger(cr.plugins_.CJSAds.prototype.cnds.OnGCScoreReceived, self);
			});
			this.socialService["onRequestUserScoreFailed"].addEventListener(function () {
				self.runtime.trigger(cr.plugins_.CJSAds.prototype.cnds.OnGCScoreUnavailable, self);
			});
			this.socialService["onSubmitUserScoreSucceed"].addEventListener(function () {
				self.runtime.trigger(cr.plugins_.CJSAds.prototype.cnds.OnGCScoreSubmitSuccess, self);
			});
			this.socialService["onSubmitUserScoreFailed"].addEventListener(function () {
				self.runtime.trigger(cr.plugins_.CJSAds.prototype.cnds.OnGCScoreSubmitFail, self);
			});
			this.socialService["onLeaderboardViewSucceed"].addEventListener(function () {
				self.runtime.trigger(cr.plugins_.CJSAds.prototype.cnds.OnGCLeaderboardOpen, self);
			});
			this.socialService["onLeaderboardViewClosed"].addEventListener(function () {
				self.runtime.trigger(cr.plugins_.CJSAds.prototype.cnds.OnGCLeaderboardClose, self);
			});
		}
	};
	function Cnds() {};
	Cnds.prototype.IsShowingBanner = function ()
	{
		return this.isShowingBanner;
	};
	Cnds.prototype.IsCocoonJS = function ()
	{
		return this.runtime.isCocoonJs;
	};
	Cnds.prototype.OnBannerShown = function ()
	{
		return true;
	};
	Cnds.prototype.OnFullscreenShown = function ()
	{
		return true;
	};
	Cnds.prototype.OnFullscreenHidden = function ()
	{
		return true;
	};
	Cnds.prototype.IsShowingFullscreen = function ()
	{
		return this.isShowingFullscreen;
	};
	Cnds.prototype.IsStoreAvailable = function ()
	{
		if (this.runtime.isCocoonJs)
			return this.storeServiceAvailable && CocoonJS["Store"]["canPurchase"]();
		else
			return false;
	};
	Cnds.prototype.OnPurchaseStart = function (productid)
	{
		return this.triggerProduct === productid;
	};
	Cnds.prototype.OnPurchaseComplete = function (productid)
	{
		return this.triggerProduct === productid;
	};
	Cnds.prototype.OnPurchaseFail = function (productid)
	{
		return this.triggerProduct === productid;
	};
	Cnds.prototype.onProductsFetchStarted = function(){
		return true;
	}
	Cnds.prototype.onConsumePurchaseFailed = function(){
		return true;
	}
	Cnds.prototype.onProductsFetchCompleted = function(){
		return true;
	}
	Cnds.prototype.onProductsFetchFailed = function(){
		return true;
	}
	Cnds.prototype.IsProductPurchased = function (productid)
	{
		if (this.runtime.isCocoonJs)
			return CocoonJS["Store"]["isProductPurchased"](productid);
		else
			return false;
	};
	Cnds.prototype.OnKeyboardCancelled = function ()
	{
		return true;
	};
	Cnds.prototype.OnKeyboardOK = function ()
	{
		return true;
	};
	Cnds.prototype.IsGCAvailable = function ()
	{
		return this.socialServiceAvailable;
	};
	Cnds.prototype.IsGCLoggedIn = function ()
	{
		if (!this.socialServiceAvailable)
			return false;
		return this.socialService["isLoggedIn"]();
	};
	Cnds.prototype.OnGCLoginSuccess = function ()
	{
		return true;
	};
	Cnds.prototype.OnGCLoginFail = function ()
	{
		return true;
	};
	Cnds.prototype.OnGCLogout = function ()
	{
		return true;
	};
	Cnds.prototype.OnGCScoreReceived = function ()
	{
		return true;
	};
	Cnds.prototype.OnGCScoreUnavailable = function ()
	{
		return true;
	};
	Cnds.prototype.OnGCScoreSubmitSuccess = function ()
	{
		return true;
	};
	Cnds.prototype.OnGCScoreSubmitFail = function ()
	{
		return true;
	};
	Cnds.prototype.OnGCLeaderboardOpen = function ()
	{
		return true;
	};
	Cnds.prototype.OnGCLeaderboardClose = function ()
	{
		return true;
	};
	pluginProto.cnds = new Cnds();
	function Acts() {};
	Acts.prototype.ShowBanner = function (layout_)
	{
		if (!this.runtime.isCocoonJs)
			return;
		bannerPosition = (layout_ === 0 ? CocoonJS["Ad"]["BannerLayout"]["TOP_CENTER"] : CocoonJS["Ad"]["BannerLayout"]["BOTTOM_CENTER"]);
		preloadingBanner = false;
		if (bannerReady)
		{
			CocoonJS["Ad"]["setBannerLayout"](bannerPosition);
			CocoonJS["Ad"]["showBanner"]();
		}
		else
		{
			CocoonJS["Ad"]["preloadBanner"]();
		}
	};
	Acts.prototype.ShowFullscreen = function ()
	{
		if (!this.runtime.isCocoonJs)
			return;
		preloadingFullscreen = false;
		if (fullscreenReady)
			CocoonJS["Ad"]["showFullScreen"]();
		else
			CocoonJS["Ad"]["preloadFullScreen"]();
	};
	Acts.prototype.HideBanner = function ()
	{
		if (!this.runtime.isCocoonJs)
			return;
		CocoonJS["Ad"]["hideBanner"]();
		this.isShowingBanner = false;
	};
	Acts.prototype.PreloadBanner = function ()
	{
		if (!this.runtime.isCocoonJs)
			return;
		preloadingBanner = true;
		CocoonJS["Ad"]["preloadBanner"]();
	};
	Acts.prototype.PreloadFullscreen = function ()
	{
		if (!this.runtime.isCocoonJs)
			return;
		preloadingFullscreen = true;
		CocoonJS["Ad"]["preloadFullScreen"]();
	};
	Acts.prototype.RefreshBanner = function ()
	{
		if (!this.runtime.isCocoonJs)
			return;
		CocoonJS["Ad"]["refreshBanner"]();
	};
	Acts.prototype.RefreshFullscreen = function ()
	{
		if (!this.runtime.isCocoonJs)
			return;
		CocoonJS["Ad"]["refreshFullScreen"]();
	};
	Acts.prototype.Purchase = function (productid)
	{
		if (!this.runtime.isCocoonJs)
			return;
		CocoonJS["Store"]["purchaseProduct"](productid);
	};
	Acts.prototype.fetchProductsFromStore = function (products)
	{
		if (!this.runtime.isCocoonJs)
			return;
		CocoonJS["Store"]["fetchProductsFromStore"](products.split(","));
	};
	Acts.prototype.restorePurchases = function ()
	{
		if (this.runtime.isCocoonJs)
			return CocoonJS["Store"]["restorePurchases"]();
	};
	Acts.prototype.PurchasePreview = function (productid)
	{
		if (!this.runtime.isCocoonJs)
			return;
		CocoonJS["Store"]["purchaseProductModalWithPreview"](productid);
	};
	Acts.prototype.RestorePurchases = function ()
	{
		if (!this.runtime.isCocoonJs)
			return;
		CocoonJS["Store"]["restorePurchases"]();
	};
	Acts.prototype.PromptKeyboard = function (title_, message_, initial_, type_, canceltext_, oktext_)
	{
		if (!this.runtime.isCocoonJs)
			return;
		var typestr = ["text", "num", "phone", "email", "url"][type_];
		CocoonJS["App"]["showTextDialog"](title_, message_, initial_, typestr, canceltext_, oktext_);
	};
	Acts.prototype.UpdateProductsList = function ()
	{
		if (!this.runtime.isCocoonJs)
			return;
		if (!CocoonJS["Store"]["canPurchase"]())
			return;
		products_list = CocoonJS["Store"]["getProducts"]();
	};
	Acts.prototype.GCLogin = function ()
	{
		if (!this.socialServiceAvailable || this.socialService["isLoggedIn"]())
			return;
		this.socialService["requestLogin"]();
	};
	Acts.prototype.GCLogout = function ()
	{
		if (!this.socialServiceAvailable || !this.socialService["isLoggedIn"]())
			return;
		this.socialService["requestLogout"]();
	};
	Acts.prototype.GCSubmitScore = function (score_, leaderboard_)
	{
		if (!this.socialServiceAvailable || !this.socialService["isLoggedIn"]())
			return;
		this.socialService["submitUserScore"](score_, leaderboard_);
	};
	Acts.prototype.GCRequestScore = function (leaderboard_)
	{
		if (!this.socialServiceAvailable || !this.socialService["isLoggedIn"]())
			return;
		this.socialService["requestUserScore"](leaderboard_);
	};
	Acts.prototype.GCOpenLeaderboard = function (leaderboard_)
	{
		if (!this.socialServiceAvailable || !this.socialService["isLoggedIn"]())
			return;
		this.socialService["showLeaderboardView"](leaderboard_);
	};
	pluginProto.acts = new Acts();
	function Exps() {};
	Exps.prototype.InputText = function (ret)
	{
		ret.set_string(input_text);
	};
	Exps.prototype.ProductCount = function (ret)
	{
		ret.set_int(products_list.length);
	};
	Exps.prototype.ProductDescription = function (ret, index)
	{
		index = Math.floor(index);
		if (index < 0 || index >= products_list.length)
		{
			ret.set_string("");
			return;
		}
		ret.set_string(products_list[index]["description"]);
	};
	Exps.prototype.ProductLocalizedPrice = function (ret, index)
	{
		index = Math.floor(index);
		if (index < 0 || index >= products_list.length)
		{
			ret.set_string("");
			return;
		}
		ret.set_string(products_list[index]["localizedPrice"]);
	};
	Exps.prototype.ProductPrice = function (ret, index)
	{
		index = Math.floor(index);
		if (index < 0 || index >= products_list.length)
		{
			ret.set_string("");
			return;
		}
		ret.set_string(products_list[index]["price"]);
	};
	Exps.prototype.ProductAlias = function (ret, index)
	{
		index = Math.floor(index);
		if (index < 0 || index >= products_list.length)
		{
			ret.set_string("");
			return;
		}
		ret.set_string(products_list[index]["productAlias"]);
	};
	Exps.prototype.ProductID = function (ret, index)
	{
		index = Math.floor(index);
		if (index < 0 || index >= products_list.length)
		{
			ret.set_string("");
			return;
		}
		ret.set_string(products_list[index]["productId"]);
	};
	Exps.prototype.ProductTitle = function (ret, index)
	{
		index = Math.floor(index);
		if (index < 0 || index >= products_list.length)
		{
			ret.set_string("");
			return;
		}
		ret.set_string(products_list[index]["title"]);
	};
	Exps.prototype.GameCenterScore = function (ret)
	{
		ret.set_float(requested_score);
	};
	pluginProto.exps = new Exps();
}());
;
;
cr.plugins_.Particles = function(runtime)
{
	this.runtime = runtime;
};
(function ()
{
	var pluginProto = cr.plugins_.Particles.prototype;
	pluginProto.Type = function(plugin)
	{
		this.plugin = plugin;
		this.runtime = plugin.runtime;
	};
	var typeProto = pluginProto.Type.prototype;
	typeProto.onCreate = function()
	{
		if (this.is_family)
			return;
		this.texture_img = new Image();
		this.texture_img["idtkLoadDisposed"] = true;
		this.texture_img.src = this.texture_file;
		this.texture_img.cr_filesize = this.texture_filesize;
		this.webGL_texture = null;
		this.runtime.wait_for_textures.push(this.texture_img);
	};
	typeProto.onLostWebGLContext = function ()
	{
		if (this.is_family)
			return;
		this.webGL_texture = null;
	};
	typeProto.onRestoreWebGLContext = function ()
	{
		if (this.is_family || !this.instances.length)
			return;
		if (!this.webGL_texture)
		{
			this.webGL_texture = this.runtime.glwrap.loadTexture(this.texture_img, true, this.runtime.linearSampling, this.texture_pixelformat);
		}
	};
	typeProto.loadTextures = function ()
	{
		if (this.is_family || this.webGL_texture || !this.runtime.glwrap)
			return;
		this.webGL_texture = this.runtime.glwrap.loadTexture(this.texture_img, true, this.runtime.linearSampling, this.texture_pixelformat);
	};
	typeProto.unloadTextures = function ()
	{
		if (this.is_family || this.instances.length || !this.webGL_texture)
			return;
		this.runtime.glwrap.deleteTexture(this.webGL_texture);
		this.webGL_texture = null;
	};
	typeProto.preloadCanvas2D = function (ctx)
	{
		ctx.drawImage(this.texture_img, 0, 0);
	};
	function Particle(owner)
	{
		this.owner = owner;
		this.active = false;
		this.x = 0;
		this.y = 0;
		this.speed = 0;
		this.angle = 0;
		this.opacity = 1;
		this.grow = 0;
		this.size = 0;
		this.gs = 0;			// gravity speed
		this.age = 0;
		cr.seal(this);
	};
	Particle.prototype.init = function ()
	{
		var owner = this.owner;
		this.x = owner.x - (owner.xrandom / 2) + (Math.random() * owner.xrandom);
		this.y = owner.y - (owner.yrandom / 2) + (Math.random() * owner.yrandom);
		this.speed = owner.initspeed - (owner.speedrandom / 2) + (Math.random() * owner.speedrandom);
		this.angle = owner.angle - (owner.spraycone / 2) + (Math.random() * owner.spraycone);
		this.opacity = owner.initopacity;
		this.size = owner.initsize - (owner.sizerandom / 2) + (Math.random() * owner.sizerandom);
		this.grow = owner.growrate - (owner.growrandom / 2) + (Math.random() * owner.growrandom);
		this.gs = 0;
		this.age = 0;
	};
	Particle.prototype.tick = function (dt)
	{
		var owner = this.owner;
		this.x += Math.cos(this.angle) * this.speed * dt;
		this.y += Math.sin(this.angle) * this.speed * dt;
		this.y += this.gs * dt;
		this.speed += owner.acc * dt;
		this.size += this.grow * dt;
		this.gs += owner.g * dt;
		this.age += dt;
		if (this.size < 1)
		{
			this.active = false;
			return;
		}
		if (owner.lifeanglerandom !== 0)
			this.angle += (Math.random() * owner.lifeanglerandom * dt) - (owner.lifeanglerandom * dt / 2);
		if (owner.lifespeedrandom !== 0)
			this.speed += (Math.random() * owner.lifespeedrandom * dt) - (owner.lifespeedrandom * dt / 2);
		if (owner.lifeopacityrandom !== 0)
		{
			this.opacity += (Math.random() * owner.lifeopacityrandom * dt) - (owner.lifeopacityrandom * dt / 2);
			if (this.opacity < 0)
				this.opacity = 0;
			else if (this.opacity > 1)
				this.opacity = 1;
		}
		if (owner.destroymode <= 1 && this.age >= owner.timeout)
		{
			this.active = false;
		}
		if (owner.destroymode === 2 && this.speed <= 0)
		{
			this.active = false;
		}
	};
	Particle.prototype.draw = function (ctx)
	{
		var curopacity = this.owner.opacity * this.opacity;
		if (curopacity === 0)
			return;
		if (this.owner.destroymode === 0)
			curopacity *= 1 - (this.age / this.owner.timeout);
		ctx.globalAlpha = curopacity;
		var drawx = this.x - this.size / 2;
		var drawy = this.y - this.size / 2;
		if (this.owner.runtime.pixel_rounding)
		{
			drawx = (drawx + 0.5) | 0;
			drawy = (drawy + 0.5) | 0;
		}
		ctx.drawImage(this.owner.type.texture_img, drawx, drawy, this.size, this.size);
	};
	Particle.prototype.drawGL = function (glw)
	{
		var curopacity = this.owner.opacity * this.opacity;
		if (this.owner.destroymode === 0)
			curopacity *= 1 - (this.age / this.owner.timeout);
		var drawsize = this.size;
		var scaleddrawsize = drawsize * this.owner.particlescale;
		var drawx = this.x - drawsize / 2;
		var drawy = this.y - drawsize / 2;
		if (this.owner.runtime.pixel_rounding)
		{
			drawx = (drawx + 0.5) | 0;
			drawy = (drawy + 0.5) | 0;
		}
		if (scaleddrawsize < 1 || curopacity === 0)
			return;
		if (scaleddrawsize < glw.minPointSize || scaleddrawsize > glw.maxPointSize)
		{
			glw.setOpacity(curopacity);
			glw.quad(drawx, drawy, drawx + drawsize, drawy, drawx + drawsize, drawy + drawsize, drawx, drawy + drawsize);
		}
		else
			glw.point(this.x, this.y, scaleddrawsize, curopacity);
	};
	Particle.prototype.left = function ()
	{
		return this.x - this.size / 2;
	};
	Particle.prototype.right = function ()
	{
		return this.x + this.size / 2;
	};
	Particle.prototype.top = function ()
	{
		return this.y - this.size / 2;
	};
	Particle.prototype.bottom = function ()
	{
		return this.y + this.size / 2;
	};
	pluginProto.Instance = function(type)
	{
		this.type = type;
		this.runtime = type.runtime;
	};
	var instanceProto = pluginProto.Instance.prototype;
	var deadparticles = [];
	instanceProto.onCreate = function()
	{
		var props = this.properties;
		this.rate = props[0];
		this.spraycone = cr.to_radians(props[1]);
		this.spraytype = props[2];			// 0 = continuous, 1 = one-shot
		this.spraying = true;				// for continuous mode only
		this.initspeed = props[3];
		this.initsize = props[4];
		this.initopacity = props[5] / 100.0;
		this.growrate = props[6];
		this.xrandom = props[7];
		this.yrandom = props[8];
		this.speedrandom = props[9];
		this.sizerandom = props[10];
		this.growrandom = props[11];
		this.acc = props[12];
		this.g = props[13];
		this.lifeanglerandom = props[14];
		this.lifespeedrandom = props[15];
		this.lifeopacityrandom = props[16];
		this.destroymode = props[17];		// 0 = fade, 1 = timeout, 2 = stopped
		this.timeout = props[18];
		this.particleCreateCounter = 0;
		this.particlescale = 1;
		this.particleBoxLeft = this.x;
		this.particleBoxTop = this.y;
		this.particleBoxRight = this.x;
		this.particleBoxBottom = this.y;
		this.add_bbox_changed_callback(function (self) {
			self.bbox.set(self.particleBoxLeft, self.particleBoxTop, self.particleBoxRight, self.particleBoxBottom);
			self.bquad.set_from_rect(self.bbox);
			self.bbox_changed = false;
		});
		if (!this.recycled)
			this.particles = [];
		this.runtime.tickMe(this);
		this.type.loadTextures();
		if (this.spraytype === 1)
		{
			for (var i = 0; i < this.rate; i++)
				this.allocateParticle().opacity = 0;
		}
		this.first_tick = true;		// for re-init'ing one-shot particles on first tick so they assume any new angle/position
	};
	instanceProto.saveToJSON = function ()
	{
		var o = {
			"r": this.rate,
			"sc": this.spraycone,
			"st": this.spraytype,
			"s": this.spraying,
			"isp": this.initspeed,
			"isz": this.initsize,
			"io": this.initopacity,
			"gr": this.growrate,
			"xr": this.xrandom,
			"yr": this.yrandom,
			"spr": this.speedrandom,
			"szr": this.sizerandom,
			"grnd": this.growrandom,
			"acc": this.acc,
			"g": this.g,
			"lar": this.lifeanglerandom,
			"lsr": this.lifespeedrandom,
			"lor": this.lifeopacityrandom,
			"dm": this.destroymode,
			"to": this.timeout,
			"pcc": this.particleCreateCounter,
			"ft": this.first_tick,
			"p": []
		};
		var i, len, p;
		var arr = o["p"];
		for (i = 0, len = this.particles.length; i < len; i++)
		{
			p = this.particles[i];
			arr.push([p.x, p.y, p.speed, p.angle, p.opacity, p.grow, p.size, p.gs, p.age]);
		}
		return o;
	};
	instanceProto.loadFromJSON = function (o)
	{
		this.rate = o["r"];
		this.spraycone = o["sc"];
		this.spraytype = o["st"];
		this.spraying = o["s"];
		this.initspeed = o["isp"];
		this.initsize = o["isz"];
		this.initopacity = o["io"];
		this.growrate = o["gr"];
		this.xrandom = o["xr"];
		this.yrandom = o["yr"];
		this.speedrandom = o["spr"];
		this.sizerandom = o["szr"];
		this.growrandom = o["grnd"];
		this.acc = o["acc"];
		this.g = o["g"];
		this.lifeanglerandom = o["lar"];
		this.lifespeedrandom = o["lsr"];
		this.lifeopacityrandom = o["lor"];
		this.destroymode = o["dm"];
		this.timeout = o["to"];
		this.particleCreateCounter = o["pcc"];
		this.first_tick = o["ft"];
		deadparticles.push.apply(deadparticles, this.particles);
		this.particles.length = 0;
		var i, len, p, d;
		var arr = o["p"];
		for (i = 0, len = arr.length; i < len; i++)
		{
			p = this.allocateParticle();
			d = arr[i];
			p.x = d[0];
			p.y = d[1];
			p.speed = d[2];
			p.angle = d[3];
			p.opacity = d[4];
			p.grow = d[5];
			p.size = d[6];
			p.gs = d[7];
			p.age = d[8];
		}
	};
	instanceProto.onDestroy = function ()
	{
		deadparticles.push.apply(deadparticles, this.particles);
		this.particles.length = 0;
	};
	instanceProto.allocateParticle = function ()
	{
		var p;
		if (deadparticles.length)
		{
			p = deadparticles.pop();
			p.owner = this;
		}
		else
			p = new Particle(this);
		this.particles.push(p);
		p.active = true;
		return p;
	};
	instanceProto.tick = function()
	{
		var dt = this.runtime.getDt(this);
		var i, len, p, n, j;
		if (this.spraytype === 0 && this.spraying)
		{
			this.particleCreateCounter += dt * this.rate;
			n = cr.floor(this.particleCreateCounter);
			this.particleCreateCounter -= n;
			for (i = 0; i < n; i++)
			{
				p = this.allocateParticle();
				p.init();
			}
		}
		this.particleBoxLeft = this.x;
		this.particleBoxTop = this.y;
		this.particleBoxRight = this.x;
		this.particleBoxBottom = this.y;
		for (i = 0, j = 0, len = this.particles.length; i < len; i++)
		{
			p = this.particles[i];
			this.particles[j] = p;
			this.runtime.redraw = true;
			if (this.spraytype === 1 && this.first_tick)
				p.init();
			p.tick(dt);
			if (!p.active)
			{
				deadparticles.push(p);
				continue;
			}
			if (p.left() < this.particleBoxLeft)
				this.particleBoxLeft = p.left();
			if (p.right() > this.particleBoxRight)
				this.particleBoxRight = p.right();
			if (p.top() < this.particleBoxTop)
				this.particleBoxTop = p.top();
			if (p.bottom() > this.particleBoxBottom)
				this.particleBoxBottom = p.bottom();
			j++;
		}
		this.particles.length = j;
		this.set_bbox_changed();
		this.first_tick = false;
		if (this.spraytype === 1 && this.particles.length === 0)
			this.runtime.DestroyInstance(this);
	};
	instanceProto.draw = function (ctx)
	{
		var i, len, p, layer = this.layer;
		for (i = 0, len = this.particles.length; i < len; i++)
		{
			p = this.particles[i];
			if (p.right() >= layer.viewLeft && p.bottom() >= layer.viewTop && p.left() <= layer.viewRight && p.top() <= layer.viewBottom)
			{
				p.draw(ctx);
			}
		}
	};
	instanceProto.drawGL = function (glw)
	{
		this.particlescale = this.layer.getScale();
		glw.setTexture(this.type.webGL_texture);
		var i, len, p, layer = this.layer;
		for (i = 0, len = this.particles.length; i < len; i++)
		{
			p = this.particles[i];
			if (p.right() >= layer.viewLeft && p.bottom() >= layer.viewTop && p.left() <= layer.viewRight && p.top() <= layer.viewBottom)
			{
				p.drawGL(glw);
			}
		}
	};
	function Cnds() {};
	Cnds.prototype.IsSpraying = function ()
	{
		return this.spraying;
	};
	pluginProto.cnds = new Cnds();
	function Acts() {};
	Acts.prototype.SetSpraying = function (set_)
	{
		this.spraying = (set_ !== 0);
	};
	Acts.prototype.SetEffect = function (effect)
	{
		this.compositeOp = cr.effectToCompositeOp(effect);
		cr.setGLBlend(this, effect, this.runtime.gl);
		this.runtime.redraw = true;
	};
	Acts.prototype.SetRate = function (x)
	{
		this.rate = x;
		var diff, i;
		if (this.spraytype === 1 && this.first_tick)
		{
			if (x < this.particles.length)
			{
				diff = this.particles.length - x;
				for (i = 0; i < diff; i++)
					deadparticles.push(this.particles.pop());
			}
			else if (x > this.particles.length)
			{
				diff = x - this.particles.length;
				for (i = 0; i < diff; i++)
					this.allocateParticle().opacity = 0;
			}
		}
	};
	Acts.prototype.SetSprayCone = function (x)
	{
		this.spraycone = cr.to_radians(x);
	};
	Acts.prototype.SetInitSpeed = function (x)
	{
		this.initspeed = x;
	};
	Acts.prototype.SetInitSize = function (x)
	{
		this.initsize = x;
	};
	Acts.prototype.SetInitOpacity = function (x)
	{
		this.initopacity = x / 100;
	};
	Acts.prototype.SetGrowRate = function (x)
	{
		this.growrate = x;
	};
	Acts.prototype.SetXRandomiser = function (x)
	{
		this.xrandom = x;
	};
	Acts.prototype.SetYRandomiser = function (x)
	{
		this.yrandom = x;
	};
	Acts.prototype.SetSpeedRandomiser = function (x)
	{
		this.speedrandom = x;
	};
	Acts.prototype.SetSizeRandomiser = function (x)
	{
		this.sizerandom = x;
	};
	Acts.prototype.SetGrowRateRandomiser = function (x)
	{
		this.growrandom = x;
	};
	Acts.prototype.SetParticleAcc = function (x)
	{
		this.acc = x;
	};
	Acts.prototype.SetGravity = function (x)
	{
		this.g = x;
	};
	Acts.prototype.SetAngleRandomiser = function (x)
	{
		this.lifeanglerandom = x;
	};
	Acts.prototype.SetSpeedRandomiser = function (x)
	{
		this.lifespeedrandom = x;
	};
	Acts.prototype.SetOpacityRandomiser = function (x)
	{
		this.lifeopacityrandom = x;
	};
	Acts.prototype.SetTimeout = function (x)
	{
		this.timeout = x;
	};
	pluginProto.acts = new Acts();
	function Exps() {};
	Exps.prototype.ParticleCount = function (ret)
	{
		ret.set_int(this.particles.length);
	};
	Exps.prototype.Rate = function (ret)
	{
		ret.set_float(this.rate);
	};
	Exps.prototype.SprayCone = function (ret)
	{
		ret.set_float(cr.to_degrees(this.spraycone));
	};
	Exps.prototype.InitSpeed = function (ret)
	{
		ret.set_float(this.initspeed);
	};
	Exps.prototype.InitSize = function (ret)
	{
		ret.set_float(this.initsize);
	};
	Exps.prototype.InitOpacity = function (ret)
	{
		ret.set_float(this.initopacity * 100);
	};
	Exps.prototype.InitGrowRate = function (ret)
	{
		ret.set_float(this.growrate);
	};
	Exps.prototype.XRandom = function (ret)
	{
		ret.set_float(this.xrandom);
	};
	Exps.prototype.YRandom = function (ret)
	{
		ret.set_float(this.yrandom);
	};
	Exps.prototype.InitSpeedRandom = function (ret)
	{
		ret.set_float(this.speedrandom);
	};
	Exps.prototype.InitSizeRandom = function (ret)
	{
		ret.set_float(this.sizerandom);
	};
	Exps.prototype.InitGrowRandom = function (ret)
	{
		ret.set_float(this.growrandom);
	};
	Exps.prototype.ParticleAcceleration = function (ret)
	{
		ret.set_float(this.acc);
	};
	Exps.prototype.Gravity = function (ret)
	{
		ret.set_float(this.g);
	};
	Exps.prototype.ParticleAngleRandom = function (ret)
	{
		ret.set_float(this.lifeanglerandom);
	};
	Exps.prototype.ParticleSpeedRandom = function (ret)
	{
		ret.set_float(this.lifespeedrandom);
	};
	Exps.prototype.ParticleOpacityRandom = function (ret)
	{
		ret.set_float(this.lifeopacityrandom);
	};
	Exps.prototype.Timeout = function (ret)
	{
		ret.set_float(this.timeout);
	};
	pluginProto.exps = new Exps();
}());
;
;
cr.plugins_.Sprite = function(runtime)
{
	this.runtime = runtime;
};
(function ()
{
	var pluginProto = cr.plugins_.Sprite.prototype;
	pluginProto.Type = function(plugin)
	{
		this.plugin = plugin;
		this.runtime = plugin.runtime;
	};
	var typeProto = pluginProto.Type.prototype;
	function frame_getDataUri()
	{
		if (this.datauri.length === 0)
		{
			var tmpcanvas = document.createElement("canvas");
			tmpcanvas.width = this.width;
			tmpcanvas.height = this.height;
			var tmpctx = tmpcanvas.getContext("2d");
			if (this.spritesheeted)
			{
				tmpctx.drawImage(this.texture_img, this.offx, this.offy, this.width, this.height,
										 0, 0, this.width, this.height);
			}
			else
			{
				tmpctx.drawImage(this.texture_img, 0, 0, this.width, this.height);
			}
			this.datauri = tmpcanvas.toDataURL("image/png");
		}
		return this.datauri;
	};
	typeProto.onCreate = function()
	{
		if (this.is_family)
			return;
		var i, leni, j, lenj;
		var anim, frame, animobj, frameobj, wt, uv;
		this.all_frames = [];
		this.has_loaded_textures = false;
		for (i = 0, leni = this.animations.length; i < leni; i++)
		{
			anim = this.animations[i];
			animobj = {};
			animobj.name = anim[0];
			animobj.speed = anim[1];
			animobj.loop = anim[2];
			animobj.repeatcount = anim[3];
			animobj.repeatto = anim[4];
			animobj.pingpong = anim[5];
			animobj.sid = anim[6];
			animobj.frames = [];
			for (j = 0, lenj = anim[7].length; j < lenj; j++)
			{
				frame = anim[7][j];
				frameobj = {};
				frameobj.texture_file = frame[0];
				frameobj.texture_filesize = frame[1];
				frameobj.offx = frame[2];
				frameobj.offy = frame[3];
				frameobj.width = frame[4];
				frameobj.height = frame[5];
				frameobj.duration = frame[6];
				frameobj.hotspotX = frame[7];
				frameobj.hotspotY = frame[8];
				frameobj.image_points = frame[9];
				frameobj.poly_pts = frame[10];
				frameobj.pixelformat = frame[11];
				frameobj.spritesheeted = (frameobj.width !== 0);
				frameobj.datauri = "";		// generated on demand and cached
				frameobj.getDataUri = frame_getDataUri;
				uv = {};
				uv.left = 0;
				uv.top = 0;
				uv.right = 1;
				uv.bottom = 1;
				frameobj.sheetTex = uv;
				frameobj.webGL_texture = null;
				wt = this.runtime.findWaitingTexture(frame[0]);
				if (wt)
				{
					frameobj.texture_img = wt;
				}
				else
				{
					frameobj.texture_img = new Image();
					frameobj.texture_img["idtkLoadDisposed"] = true;
					frameobj.texture_img.src = frame[0];
					frameobj.texture_img.cr_src = frame[0];
					frameobj.texture_img.cr_filesize = frame[1];
					frameobj.texture_img.c2webGL_texture = null;
					this.runtime.wait_for_textures.push(frameobj.texture_img);
				}
				cr.seal(frameobj);
				animobj.frames.push(frameobj);
				this.all_frames.push(frameobj);
			}
			cr.seal(animobj);
			this.animations[i] = animobj;		// swap array data for object
		}
	};
	typeProto.updateAllCurrentTexture = function ()
	{
		var i, len, inst;
		for (i = 0, len = this.instances.length; i < len; i++)
		{
			inst = this.instances[i];
			inst.curWebGLTexture = inst.curFrame.webGL_texture;
		}
	};
	typeProto.onLostWebGLContext = function ()
	{
		if (this.is_family)
			return;
		var i, len, frame;
		for (i = 0, len = this.all_frames.length; i < len; ++i)
		{
			frame = this.all_frames[i];
			frame.texture_img.c2webGL_texture = null;
			frame.webGL_texture = null;
		}
	};
	typeProto.onRestoreWebGLContext = function ()
	{
		if (this.is_family || !this.instances.length)
			return;
		var i, len, frame;
		for (i = 0, len = this.all_frames.length; i < len; ++i)
		{
			frame = this.all_frames[i];
			frame.webGL_texture = this.runtime.glwrap.loadTexture(frame.texture_img, false, this.runtime.linearSampling, frame.pixelformat);
		}
		this.updateAllCurrentTexture();
	};
	typeProto.loadTextures = function ()
	{
		if (this.is_family || this.has_loaded_textures || !this.runtime.glwrap)
			return;
		var i, len, frame;
		for (i = 0, len = this.all_frames.length; i < len; ++i)
		{
			frame = this.all_frames[i];
			frame.webGL_texture = this.runtime.glwrap.loadTexture(frame.texture_img, false, this.runtime.linearSampling, frame.pixelformat);
		}
		this.has_loaded_textures = true;
	};
	typeProto.unloadTextures = function ()
	{
		if (this.is_family || this.instances.length || !this.has_loaded_textures)
			return;
		var i, len, frame;
		for (i = 0, len = this.all_frames.length; i < len; ++i)
		{
			frame = this.all_frames[i];
			this.runtime.glwrap.deleteTexture(frame.webGL_texture);
		}
		this.has_loaded_textures = false;
	};
	var already_drawn_images = [];
	typeProto.preloadCanvas2D = function (ctx)
	{
		var i, len, frameimg;
		already_drawn_images.length = 0;
		for (i = 0, len = this.all_frames.length; i < len; ++i)
		{
			frameimg = this.all_frames[i].texture_img;
			if (already_drawn_images.indexOf(frameimg) !== -1)
					continue;
			ctx.drawImage(frameimg, 0, 0);
			already_drawn_images.push(frameimg);
		}
	};
	pluginProto.Instance = function(type)
	{
		this.type = type;
		this.runtime = type.runtime;
		var poly_pts = this.type.animations[0].frames[0].poly_pts;
		if (this.recycled)
			this.collision_poly.set_pts(poly_pts);
		else
			this.collision_poly = new cr.CollisionPoly(poly_pts);
	};
	var instanceProto = pluginProto.Instance.prototype;
	instanceProto.onCreate = function()
	{
		this.visible = (this.properties[0] === 0);	// 0=visible, 1=invisible
		this.isTicking = false;
		this.inAnimTrigger = false;
		this.collisionsEnabled = (this.properties[3] !== 0);
		if (!(this.type.animations.length === 1 && this.type.animations[0].frames.length === 1) && this.type.animations[0].speed !== 0)
		{
			this.runtime.tickMe(this);
			this.isTicking = true;
		}
		this.cur_animation = this.getAnimationByName(this.properties[1]) || this.type.animations[0];
		this.cur_frame = this.properties[2];
		if (this.cur_frame < 0)
			this.cur_frame = 0;
		if (this.cur_frame >= this.cur_animation.frames.length)
			this.cur_frame = this.cur_animation.frames.length - 1;
		var curanimframe = this.cur_animation.frames[this.cur_frame];
		this.collision_poly.set_pts(curanimframe.poly_pts);
		this.hotspotX = curanimframe.hotspotX;
		this.hotspotY = curanimframe.hotspotY;
		this.cur_anim_speed = this.cur_animation.speed;
		if (this.recycled)
			this.animTimer.reset();
		else
			this.animTimer = new cr.KahanAdder();
		this.frameStart = this.getNowTime();
		this.animPlaying = true;
		this.animRepeats = 0;
		this.animForwards = true;
		this.animTriggerName = "";
		this.changeAnimName = "";
		this.changeAnimFrom = 0;
		this.changeAnimFrame = -1;
		this.type.loadTextures();
		var i, leni, j, lenj;
		var anim, frame, uv, maintex;
		for (i = 0, leni = this.type.animations.length; i < leni; i++)
		{
			anim = this.type.animations[i];
			for (j = 0, lenj = anim.frames.length; j < lenj; j++)
			{
				frame = anim.frames[j];
				if (frame.width === 0)
				{
					frame.width = frame.texture_img.width;
					frame.height = frame.texture_img.height;
				}
				if (frame.spritesheeted)
				{
					maintex = frame.texture_img;
					uv = frame.sheetTex;
					uv.left = frame.offx / maintex.width;
					uv.top = frame.offy / maintex.height;
					uv.right = (frame.offx + frame.width) / maintex.width;
					uv.bottom = (frame.offy + frame.height) / maintex.height;
					if (frame.offx === 0 && frame.offy === 0 && frame.width === maintex.width && frame.height === maintex.height)
					{
						frame.spritesheeted = false;
					}
				}
			}
		}
		this.curFrame = this.cur_animation.frames[this.cur_frame];
		this.curWebGLTexture = this.curFrame.webGL_texture;
	};
	instanceProto.saveToJSON = function ()
	{
		var o = {
			"a": this.cur_animation.sid,
			"f": this.cur_frame,
			"cas": this.cur_anim_speed,
			"fs": this.frameStart,
			"ar": this.animRepeats,
			"at": this.animTimer.sum
		};
		if (!this.animPlaying)
			o["ap"] = this.animPlaying;
		if (!this.animForwards)
			o["af"] = this.animForwards;
		return o;
	};
	instanceProto.loadFromJSON = function (o)
	{
		var anim = this.getAnimationBySid(o["a"]);
		if (anim)
			this.cur_animation = anim;
		this.cur_frame = o["f"];
		if (this.cur_frame < 0)
			this.cur_frame = 0;
		if (this.cur_frame >= this.cur_animation.frames.length)
			this.cur_frame = this.cur_animation.frames.length - 1;
		this.cur_anim_speed = o["cas"];
		this.frameStart = o["fs"];
		this.animRepeats = o["ar"];
		this.animTimer.reset();
		this.animTimer.sum = o["at"];
		this.animPlaying = o.hasOwnProperty("ap") ? o["ap"] : true;
		this.animForwards = o.hasOwnProperty("af") ? o["af"] : true;
		this.curFrame = this.cur_animation.frames[this.cur_frame];
		this.curWebGLTexture = this.curFrame.webGL_texture;
		this.collision_poly.set_pts(this.curFrame.poly_pts);
		this.hotspotX = this.curFrame.hotspotX;
		this.hotspotY = this.curFrame.hotspotY;
	};
	instanceProto.animationFinish = function (reverse)
	{
		this.cur_frame = reverse ? 0 : this.cur_animation.frames.length - 1;
		this.animPlaying = false;
		this.animTriggerName = this.cur_animation.name;
		this.inAnimTrigger = true;
		this.runtime.trigger(cr.plugins_.Sprite.prototype.cnds.OnAnyAnimFinished, this);
		this.runtime.trigger(cr.plugins_.Sprite.prototype.cnds.OnAnimFinished, this);
		this.inAnimTrigger = false;
		this.animRepeats = 0;
	};
	instanceProto.getNowTime = function()
	{
		return this.animTimer.sum;
	};
	instanceProto.tick = function()
	{
		this.animTimer.add(this.runtime.getDt(this));
		if (this.changeAnimName.length)
			this.doChangeAnim();
		if (this.changeAnimFrame >= 0)
			this.doChangeAnimFrame();
		var now = this.getNowTime();
		var cur_animation = this.cur_animation;
		var prev_frame = cur_animation.frames[this.cur_frame];
		var next_frame;
		var cur_frame_time = prev_frame.duration / this.cur_anim_speed;
		if (this.animPlaying && now >= this.frameStart + cur_frame_time)
		{
			if (this.animForwards)
			{
				this.cur_frame++;
			}
			else
			{
				this.cur_frame--;
			}
			this.frameStart += cur_frame_time;
			if (this.cur_frame >= cur_animation.frames.length)
			{
				if (cur_animation.pingpong)
				{
					this.animForwards = false;
					this.cur_frame = cur_animation.frames.length - 2;
				}
				else if (cur_animation.loop)
				{
					this.cur_frame = cur_animation.repeatto;
				}
				else
				{
					this.animRepeats++;
					if (this.animRepeats >= cur_animation.repeatcount)
					{
						this.animationFinish(false);
					}
					else
					{
						this.cur_frame = cur_animation.repeatto;
					}
				}
			}
			if (this.cur_frame < 0)
			{
				if (cur_animation.pingpong)
				{
					this.cur_frame = 1;
					this.animForwards = true;
					if (!cur_animation.loop)
					{
						this.animRepeats++;
						if (this.animRepeats >= cur_animation.repeatcount)
						{
							this.animationFinish(true);
						}
					}
				}
				else
				{
					if (cur_animation.loop)
					{
						this.cur_frame = cur_animation.repeatto;
					}
					else
					{
						this.animRepeats++;
						if (this.animRepeats >= cur_animation.repeatcount)
						{
							this.animationFinish(true);
						}
						else
						{
							this.cur_frame = cur_animation.repeatto;
						}
					}
				}
			}
			if (this.cur_frame < 0)
				this.cur_frame = 0;
			else if (this.cur_frame >= cur_animation.frames.length)
				this.cur_frame = cur_animation.frames.length - 1;
			if (now > this.frameStart + (cur_animation.frames[this.cur_frame].duration / this.cur_anim_speed))
			{
				this.frameStart = now;
			}
			next_frame = cur_animation.frames[this.cur_frame];
			this.OnFrameChanged(prev_frame, next_frame);
			this.runtime.redraw = true;
		}
	};
	instanceProto.getAnimationByName = function (name_)
	{
		var i, len, a;
		for (i = 0, len = this.type.animations.length; i < len; i++)
		{
			a = this.type.animations[i];
			if (cr.equals_nocase(a.name, name_))
				return a;
		}
		return null;
	};
	instanceProto.getAnimationBySid = function (sid_)
	{
		var i, len, a;
		for (i = 0, len = this.type.animations.length; i < len; i++)
		{
			a = this.type.animations[i];
			if (a.sid === sid_)
				return a;
		}
		return null;
	};
	instanceProto.doChangeAnim = function ()
	{
		var prev_frame = this.cur_animation.frames[this.cur_frame];
		var anim = this.getAnimationByName(this.changeAnimName);
		this.changeAnimName = "";
		if (!anim)
			return;
		if (cr.equals_nocase(anim.name, this.cur_animation.name) && this.animPlaying)
			return;
		this.cur_animation = anim;
		this.cur_anim_speed = anim.speed;
		if (this.cur_frame < 0)
			this.cur_frame = 0;
		if (this.cur_frame >= this.cur_animation.frames.length)
			this.cur_frame = this.cur_animation.frames.length - 1;
		if (this.changeAnimFrom === 1)
			this.cur_frame = 0;
		this.animPlaying = true;
		this.frameStart = this.getNowTime();
		this.animForwards = true;
		this.OnFrameChanged(prev_frame, this.cur_animation.frames[this.cur_frame]);
		this.runtime.redraw = true;
	};
	instanceProto.doChangeAnimFrame = function ()
	{
		var prev_frame = this.cur_animation.frames[this.cur_frame];
		var prev_frame_number = this.cur_frame;
		this.cur_frame = cr.floor(this.changeAnimFrame);
		if (this.cur_frame < 0)
			this.cur_frame = 0;
		if (this.cur_frame >= this.cur_animation.frames.length)
			this.cur_frame = this.cur_animation.frames.length - 1;
		if (prev_frame_number !== this.cur_frame)
		{
			this.OnFrameChanged(prev_frame, this.cur_animation.frames[this.cur_frame]);
			this.frameStart = this.getNowTime();
			this.runtime.redraw = true;
		}
		this.changeAnimFrame = -1;
	};
	instanceProto.OnFrameChanged = function (prev_frame, next_frame)
	{
		var oldw = prev_frame.width;
		var oldh = prev_frame.height;
		var neww = next_frame.width;
		var newh = next_frame.height;
		if (oldw != neww)
			this.width *= (neww / oldw);
		if (oldh != newh)
			this.height *= (newh / oldh);
		this.hotspotX = next_frame.hotspotX;
		this.hotspotY = next_frame.hotspotY;
		this.collision_poly.set_pts(next_frame.poly_pts);
		this.set_bbox_changed();
		this.curFrame = next_frame;
		this.curWebGLTexture = next_frame.webGL_texture;
		var i, len, b;
		for (i = 0, len = this.behavior_insts.length; i < len; i++)
		{
			b = this.behavior_insts[i];
			if (b.onSpriteFrameChanged)
				b.onSpriteFrameChanged(prev_frame, next_frame);
		}
		this.runtime.trigger(cr.plugins_.Sprite.prototype.cnds.OnFrameChanged, this);
	};
	instanceProto.draw = function(ctx)
	{
		ctx.globalAlpha = this.opacity;
		var cur_frame = this.curFrame;
		var spritesheeted = cur_frame.spritesheeted;
		var cur_image = cur_frame.texture_img;
		var myx = this.x;
		var myy = this.y;
		var w = this.width;
		var h = this.height;
		if (this.angle === 0 && w >= 0 && h >= 0)
		{
			myx -= this.hotspotX * w;
			myy -= this.hotspotY * h;
			if (this.runtime.pixel_rounding)
			{
				myx = (myx + 0.5) | 0;
				myy = (myy + 0.5) | 0;
			}
			if (spritesheeted)
			{
				ctx.drawImage(cur_image, cur_frame.offx, cur_frame.offy, cur_frame.width, cur_frame.height,
										 myx, myy, w, h);
			}
			else
			{
				ctx.drawImage(cur_image, myx, myy, w, h);
			}
		}
		else
		{
			if (this.runtime.pixel_rounding)
			{
				myx = (myx + 0.5) | 0;
				myy = (myy + 0.5) | 0;
			}
			ctx.save();
			var widthfactor = w > 0 ? 1 : -1;
			var heightfactor = h > 0 ? 1 : -1;
			ctx.translate(myx, myy);
			if (widthfactor !== 1 || heightfactor !== 1)
				ctx.scale(widthfactor, heightfactor);
			ctx.rotate(this.angle * widthfactor * heightfactor);
			var drawx = 0 - (this.hotspotX * cr.abs(w))
			var drawy = 0 - (this.hotspotY * cr.abs(h));
			if (spritesheeted)
			{
				ctx.drawImage(cur_image, cur_frame.offx, cur_frame.offy, cur_frame.width, cur_frame.height,
										 drawx, drawy, cr.abs(w), cr.abs(h));
			}
			else
			{
				ctx.drawImage(cur_image, drawx, drawy, cr.abs(w), cr.abs(h));
			}
			ctx.restore();
		}
		/*
		ctx.strokeStyle = "#f00";
		ctx.lineWidth = 3;
		ctx.beginPath();
		this.collision_poly.cache_poly(this.width, this.height, this.angle);
		var i, len, ax, ay, bx, by;
		for (i = 0, len = this.collision_poly.pts_count; i < len; i++)
		{
			ax = this.collision_poly.pts_cache[i*2] + this.x;
			ay = this.collision_poly.pts_cache[i*2+1] + this.y;
			bx = this.collision_poly.pts_cache[((i+1)%len)*2] + this.x;
			by = this.collision_poly.pts_cache[((i+1)%len)*2+1] + this.y;
			ctx.moveTo(ax, ay);
			ctx.lineTo(bx, by);
		}
		ctx.stroke();
		ctx.closePath();
		*/
		/*
		if (this.behavior_insts.length >= 1 && this.behavior_insts[0].draw)
		{
			this.behavior_insts[0].draw(ctx);
		}
		*/
	};
	instanceProto.drawGL = function(glw)
	{
		glw.setTexture(this.curWebGLTexture);
		glw.setOpacity(this.opacity);
		var cur_frame = this.curFrame;
		var q = this.bquad;
		if (this.runtime.pixel_rounding)
		{
			var ox = ((this.x + 0.5) | 0) - this.x;
			var oy = ((this.y + 0.5) | 0) - this.y;
			if (cur_frame.spritesheeted)
				glw.quadTex(q.tlx + ox, q.tly + oy, q.trx + ox, q.try_ + oy, q.brx + ox, q.bry + oy, q.blx + ox, q.bly + oy, cur_frame.sheetTex);
			else
				glw.quad(q.tlx + ox, q.tly + oy, q.trx + ox, q.try_ + oy, q.brx + ox, q.bry + oy, q.blx + ox, q.bly + oy);
		}
		else
		{
			if (cur_frame.spritesheeted)
				glw.quadTex(q.tlx, q.tly, q.trx, q.try_, q.brx, q.bry, q.blx, q.bly, cur_frame.sheetTex);
			else
				glw.quad(q.tlx, q.tly, q.trx, q.try_, q.brx, q.bry, q.blx, q.bly);
		}
	};
	instanceProto.getImagePointIndexByName = function(name_)
	{
		var cur_frame = this.curFrame;
		var i, len;
		for (i = 0, len = cur_frame.image_points.length; i < len; i++)
		{
			if (cr.equals_nocase(name_, cur_frame.image_points[i][0]))
				return i;
		}
		return -1;
	};
	instanceProto.getImagePoint = function(imgpt, getX)
	{
		var cur_frame = this.curFrame;
		var image_points = cur_frame.image_points;
		var index;
		if (cr.is_string(imgpt))
			index = this.getImagePointIndexByName(imgpt);
		else
			index = imgpt - 1;	// 0 is origin
		index = cr.floor(index);
		if (index < 0 || index >= image_points.length)
			return getX ? this.x : this.y;	// return origin
		var x = (image_points[index][1] - cur_frame.hotspotX) * this.width;
		var y = image_points[index][2];
		y = (y - cur_frame.hotspotY) * this.height;
		var cosa = Math.cos(this.angle);
		var sina = Math.sin(this.angle);
		var x_temp = (x * cosa) - (y * sina);
		y = (y * cosa) + (x * sina);
		x = x_temp;
		x += this.x;
		y += this.y;
		return getX ? x : y;
	};
	function Cnds() {};
	var arrCache = [];
	function allocArr()
	{
		if (arrCache.length)
			return arrCache.pop();
		else
			return [0, 0];
	};
	function freeArr(a)
	{
		a[0] = 0;
		a[1] = 0;
		arrCache.push(a);
	};
	function collmemory_add(collmemory, a, b)
	{
		var arr = allocArr();
		arr[0] = a.uid;
		arr[1] = b.uid;
		collmemory.push(arr);
	};
	function collmemory_remove(collmemory, a, b)
	{
;
		var a_uid = a.uid;
		var b_uid = b.uid;
		var i, j = 0, len, entry;
		for (i = 0, len = collmemory.length; i < len; i++)
		{
			entry = collmemory[i];
			if (!((entry[0] === a_uid && entry[1] === b_uid) || (entry[0] === b_uid && entry[1] === a_uid)))
			{
				collmemory[j][0] = collmemory[i][0];
				collmemory[j][1] = collmemory[i][1];
				j++;
			}
		}
		for (i = j; i < len; i++)
			freeArr(collmemory[i]);
		collmemory.length = j;
	};
	function collmemory_removeInstance(collmemory, inst)
	{
;
		var i, j = 0, len, entry, uid = inst.uid;
		for (i = 0, len = collmemory.length; i < len; i++)
		{
			entry = collmemory[i];
			if (entry[0] !== uid && entry[1] !== uid)
			{
				collmemory[j][0] = collmemory[i][0];
				collmemory[j][1] = collmemory[i][1];
				j++;
			}
		}
		for (i = j; i < len; i++)
			freeArr(collmemory[i]);
		collmemory.length = j;
	};
	function collmemory_has(collmemory, a, b)
	{
		var a_uid = a.uid;
		var b_uid = b.uid;
		var i, len, entry;
		for (i = 0, len = collmemory.length; i < len; i++)
		{
			entry = collmemory[i];
			if ((entry[0] === a_uid && entry[1] === b_uid) || (entry[0] === b_uid && entry[1] === a_uid))
				return true;
		}
		return false;
	};
	Cnds.prototype.OnCollision = function (rtype)
	{
		if (!rtype)
			return false;
		var runtime = this.runtime;
		var cnd = runtime.getCurrentCondition();
		var ltype = cnd.type;
		if (!cnd.extra.collmemory)
		{
			cnd.extra.collmemory = [];
			runtime.addDestroyCallback((function (collmemory) {
				return function(inst) {
					collmemory_removeInstance(collmemory, inst);
				};
			})(cnd.extra.collmemory));
		}
		var lsol = ltype.getCurrentSol();
		var rsol = rtype.getCurrentSol();
		var linstances = lsol.getObjects();
		var rinstances = rsol.getObjects();
		var l, linst, r, rinst;
		var curlsol, currsol;
		var current_event = runtime.getCurrentEventStack().current_event;
		var orblock = current_event.orblock;
		for (l = 0; l < linstances.length; l++)
		{
			linst = linstances[l];
			for (r = 0; r < rinstances.length; r++)
			{
				rinst = rinstances[r];
				if (runtime.testOverlap(linst, rinst) || runtime.checkRegisteredCollision(linst, rinst))
				{
					if (!collmemory_has(cnd.extra.collmemory, linst, rinst))
					{
						collmemory_add(cnd.extra.collmemory, linst, rinst);
						runtime.pushCopySol(current_event.solModifiers);
						curlsol = ltype.getCurrentSol();
						currsol = rtype.getCurrentSol();
						curlsol.select_all = false;
						currsol.select_all = false;
						if (ltype === rtype)
						{
							curlsol.instances.length = 2;	// just use lsol, is same reference as rsol
							curlsol.instances[0] = linst;
							curlsol.instances[1] = rinst;
							ltype.applySolToContainer();
						}
						else
						{
							curlsol.instances.length = 1;
							currsol.instances.length = 1;
							curlsol.instances[0] = linst;
							currsol.instances[0] = rinst;
							ltype.applySolToContainer();
							rtype.applySolToContainer();
						}
						current_event.retrigger();
						runtime.popSol(current_event.solModifiers);
					}
				}
				else
				{
					collmemory_remove(cnd.extra.collmemory, linst, rinst);
				}
			}
		}
		return false;
	};
	var rpicktype = null;
	var rtopick = new cr.ObjectSet();
	var needscollisionfinish = false;
	function DoOverlapCondition(rtype, offx, offy)
	{
		if (!rtype)
			return false;
		var do_offset = (offx !== 0 || offy !== 0);
		var oldx, oldy, ret = false, r, lenr, rinst;
		var cnd = this.runtime.getCurrentCondition();
		var ltype = cnd.type;
		var inverted = cnd.inverted;
		var rsol = rtype.getCurrentSol();
		var orblock = this.runtime.getCurrentEventStack().current_event.orblock;
		var rinstances;
		if (rsol.select_all)
			rinstances = rsol.type.instances;
		else if (orblock)
			rinstances = rsol.else_instances;
		else
			rinstances = rsol.instances;
		rpicktype = rtype;
		needscollisionfinish = (ltype !== rtype && !inverted);
		if (do_offset)
		{
			oldx = this.x;
			oldy = this.y;
			this.x += offx;
			this.y += offy;
			this.set_bbox_changed();
		}
		for (r = 0, lenr = rinstances.length; r < lenr; r++)
		{
			rinst = rinstances[r];
			if (this.runtime.testOverlap(this, rinst))
			{
				ret = true;
				if (inverted)
					break;
				if (ltype !== rtype)
					rtopick.add(rinst);
			}
		}
		if (do_offset)
		{
			this.x = oldx;
			this.y = oldy;
			this.set_bbox_changed();
		}
		return ret;
	};
	typeProto.finish = function (do_pick)
	{
		if (!needscollisionfinish)
			return;
		if (do_pick)
		{
			var orblock = this.runtime.getCurrentEventStack().current_event.orblock;
			var sol = rpicktype.getCurrentSol();
			var topick = rtopick.valuesRef();
			var i, len, inst;
			if (sol.select_all)
			{
				sol.select_all = false;
				sol.instances.length = topick.length;
				for (i = 0, len = topick.length; i < len; i++)
				{
					sol.instances[i] = topick[i];
				}
				if (orblock)
				{
					sol.else_instances.length = 0;
					for (i = 0, len = rpicktype.instances.length; i < len; i++)
					{
						inst = rpicktype.instances[i];
						if (!rtopick.contains(inst))
							sol.else_instances.push(inst);
					}
				}
			}
			else
			{
				if (orblock)
				{
					var initsize = sol.instances.length;
					sol.instances.length = initsize + topick.length;
					for (i = 0, len = topick.length; i < len; i++)
					{
						sol.instances[initsize + i] = topick[i];
						cr.arrayFindRemove(sol.else_instances, topick[i]);
					}
				}
				else
				{
					cr.shallowAssignArray(sol.instances, topick);
				}
			}
			rpicktype.applySolToContainer();
		}
		rtopick.clear();
		needscollisionfinish = false;
	};
	Cnds.prototype.IsOverlapping = function (rtype)
	{
		return DoOverlapCondition.call(this, rtype, 0, 0);
	};
	Cnds.prototype.IsOverlappingOffset = function (rtype, offx, offy)
	{
		return DoOverlapCondition.call(this, rtype, offx, offy);
	};
	Cnds.prototype.IsAnimPlaying = function (animname)
	{
		if (this.changeAnimName.length)
			return cr.equals_nocase(this.changeAnimName, animname);
		else
			return cr.equals_nocase(this.cur_animation.name, animname);
	};
	Cnds.prototype.CompareFrame = function (cmp, framenum)
	{
		return cr.do_cmp(this.cur_frame, cmp, framenum);
	};
	Cnds.prototype.OnAnimFinished = function (animname)
	{
		return cr.equals_nocase(this.animTriggerName, animname);
	};
	Cnds.prototype.OnAnyAnimFinished = function ()
	{
		return true;
	};
	Cnds.prototype.OnFrameChanged = function ()
	{
		return true;
	};
	Cnds.prototype.IsMirrored = function ()
	{
		return this.width < 0;
	};
	Cnds.prototype.IsFlipped = function ()
	{
		return this.height < 0;
	};
	Cnds.prototype.OnURLLoaded = function ()
	{
		return true;
	};
	Cnds.prototype.IsCollisionEnabled = function ()
	{
		return this.collisionsEnabled;
	};
	pluginProto.cnds = new Cnds();
	function Acts() {};
	Acts.prototype.Spawn = function (obj, layer, imgpt)
	{
		if (!obj || !layer)
			return;
		var inst = this.runtime.createInstance(obj, layer, this.getImagePoint(imgpt, true), this.getImagePoint(imgpt, false));
		if (!inst)
			return;
		if (typeof inst.angle !== "undefined")
		{
			inst.angle = this.angle;
			inst.set_bbox_changed();
		}
		this.runtime.isInOnDestroy++;
		var i, len, s;
		this.runtime.trigger(Object.getPrototypeOf(obj.plugin).cnds.OnCreated, inst);
		if (inst.is_contained)
		{
			for (i = 0, len = inst.siblings.length; i < len; i++)
			{
				s = inst.siblings[i];
				this.runtime.trigger(Object.getPrototypeOf(s.type.plugin).cnds.OnCreated, s);
			}
		}
		this.runtime.isInOnDestroy--;
		var cur_act = this.runtime.getCurrentAction();
		var reset_sol = false;
		if (cr.is_undefined(cur_act.extra.Spawn_LastExec) || cur_act.extra.Spawn_LastExec < this.runtime.execcount)
		{
			reset_sol = true;
			cur_act.extra.Spawn_LastExec = this.runtime.execcount;
		}
		var sol;
		if (obj != this.type)
		{
			sol = obj.getCurrentSol();
			sol.select_all = false;
			if (reset_sol)
			{
				sol.instances.length = 1;
				sol.instances[0] = inst;
			}
			else
				sol.instances.push(inst);
			if (inst.is_contained)
			{
				for (i = 0, len = inst.siblings.length; i < len; i++)
				{
					s = inst.siblings[i];
					sol = s.type.getCurrentSol();
					sol.select_all = false;
					if (reset_sol)
					{
						sol.instances.length = 1;
						sol.instances[0] = s;
					}
					else
						sol.instances.push(s);
				}
			}
		}
	};
	Acts.prototype.SetEffect = function (effect)
	{
		this.compositeOp = cr.effectToCompositeOp(effect);
		cr.setGLBlend(this, effect, this.runtime.gl);
		this.runtime.redraw = true;
	};
	Acts.prototype.StopAnim = function ()
	{
		this.animPlaying = false;
	};
	Acts.prototype.StartAnim = function (from)
	{
		this.animPlaying = true;
		this.frameStart = this.getNowTime();
		if (from === 1 && this.cur_frame !== 0)
		{
			this.changeAnimFrame = 0;
			if (!this.inAnimTrigger)
				this.doChangeAnimFrame();
		}
		if (!this.isTicking)
		{
			this.runtime.tickMe(this);
			this.isTicking = true;
		}
	};
	Acts.prototype.SetAnim = function (animname, from)
	{
		this.changeAnimName = animname;
		this.changeAnimFrom = from;
		if (!this.isTicking)
		{
			this.runtime.tickMe(this);
			this.isTicking = true;
		}
		if (!this.inAnimTrigger)
			this.doChangeAnim();
	};
	Acts.prototype.SetAnimFrame = function (framenumber)
	{
		this.changeAnimFrame = framenumber;
		if (!this.isTicking)
		{
			this.runtime.tickMe(this);
			this.isTicking = true;
		}
		if (!this.inAnimTrigger)
			this.doChangeAnimFrame();
	};
	Acts.prototype.SetAnimSpeed = function (s)
	{
		this.cur_anim_speed = cr.abs(s);
		this.animForwards = (s >= 0);
		if (!this.isTicking)
		{
			this.runtime.tickMe(this);
			this.isTicking = true;
		}
	};
	Acts.prototype.SetMirrored = function (m)
	{
		var neww = cr.abs(this.width) * (m === 0 ? -1 : 1);
		if (this.width === neww)
			return;
		this.width = neww;
		this.set_bbox_changed();
	};
	Acts.prototype.SetFlipped = function (f)
	{
		var newh = cr.abs(this.height) * (f === 0 ? -1 : 1);
		if (this.height === newh)
			return;
		this.height = newh;
		this.set_bbox_changed();
	};
	Acts.prototype.SetScale = function (s)
	{
		var cur_frame = this.curFrame;
		var mirror_factor = (this.width < 0 ? -1 : 1);
		var flip_factor = (this.height < 0 ? -1 : 1);
		var new_width = cur_frame.width * s * mirror_factor;
		var new_height = cur_frame.height * s * flip_factor;
		if (this.width !== new_width || this.height !== new_height)
		{
			this.width = new_width;
			this.height = new_height;
			this.set_bbox_changed();
		}
	};
	Acts.prototype.LoadURL = function (url_, resize_)
	{
		var img = new Image();
		var self = this;
		var curFrame_ = this.curFrame;
		img.onload = function ()
		{
			if (curFrame_.texture_img.src === img.src)
			{
				if (self.runtime.glwrap && self.curFrame === curFrame_)
					self.curWebGLTexture = curFrame_.webGL_texture;
				self.runtime.redraw = true;
				self.runtime.trigger(cr.plugins_.Sprite.prototype.cnds.OnURLLoaded, self);
				return;
			}
			curFrame_.texture_img = img;
			curFrame_.offx = 0;
			curFrame_.offy = 0;
			curFrame_.width = img.width;
			curFrame_.height = img.height;
			curFrame_.spritesheeted = false;
			curFrame_.datauri = "";
			if (self.runtime.glwrap)
			{
				if (curFrame_.webGL_texture)
					self.runtime.glwrap.deleteTexture(curFrame_.webGL_texture);
				curFrame_.webGL_texture = self.runtime.glwrap.loadTexture(img, false, self.runtime.linearSampling);
				if (self.curFrame === curFrame_)
					self.curWebGLTexture = curFrame_.webGL_texture;
				self.type.updateAllCurrentTexture();
			}
			if (resize_ === 0)		// resize to image size
			{
				self.width = img.width;
				self.height = img.height;
				self.set_bbox_changed();
			}
			self.runtime.redraw = true;
			self.runtime.trigger(cr.plugins_.Sprite.prototype.cnds.OnURLLoaded, self);
		};
		if (url_.substr(0, 5) !== "data:")
			img.crossOrigin = 'anonymous';
		img.src = url_;
	};
	Acts.prototype.SetCollisions = function (set_)
	{
		this.collisionsEnabled = (set_ !== 0);
	};
	pluginProto.acts = new Acts();
	function Exps() {};
	Exps.prototype.AnimationFrame = function (ret)
	{
		ret.set_int(this.cur_frame);
	};
	Exps.prototype.AnimationFrameCount = function (ret)
	{
		ret.set_int(this.cur_animation.frames.length);
	};
	Exps.prototype.AnimationName = function (ret)
	{
		ret.set_string(this.cur_animation.name);
	};
	Exps.prototype.AnimationSpeed = function (ret)
	{
		ret.set_float(this.cur_anim_speed);
	};
	Exps.prototype.ImagePointX = function (ret, imgpt)
	{
		ret.set_float(this.getImagePoint(imgpt, true));
	};
	Exps.prototype.ImagePointY = function (ret, imgpt)
	{
		ret.set_float(this.getImagePoint(imgpt, false));
	};
	Exps.prototype.ImagePointCount = function (ret)
	{
		ret.set_int(this.curFrame.image_points.length);
	};
	Exps.prototype.ImageWidth = function (ret)
	{
		ret.set_float(this.curFrame.width);
	};
	Exps.prototype.ImageHeight = function (ret)
	{
		ret.set_float(this.curFrame.height);
	};
	pluginProto.exps = new Exps();
}());
;
;
cr.plugins_.Text = function(runtime)
{
	this.runtime = runtime;
};
(function ()
{
	var pluginProto = cr.plugins_.Text.prototype;
	pluginProto.onCreate = function ()
	{
		pluginProto.acts.SetWidth = function (w)
		{
			if (this.width !== w)
			{
				this.width = w;
				this.text_changed = true;	// also recalculate text wrapping
				this.set_bbox_changed();
			}
		};
	};
	pluginProto.Type = function(plugin)
	{
		this.plugin = plugin;
		this.runtime = plugin.runtime;
	};
	var typeProto = pluginProto.Type.prototype;
	typeProto.onCreate = function()
	{
	};
	typeProto.onLostWebGLContext = function ()
	{
		if (this.is_family)
			return;
		var i, len, inst;
		for (i = 0, len = this.instances.length; i < len; i++)
		{
			inst = this.instances[i];
			inst.mycanvas = null;
			inst.myctx = null;
			inst.mytex = null;
		}
	};
	pluginProto.Instance = function(type)
	{
		this.type = type;
		this.runtime = type.runtime;
		if (this.recycled)
			this.lines.length = 0;
		else
			this.lines = [];		// for word wrapping
		this.text_changed = true;
	};
	var instanceProto = pluginProto.Instance.prototype;
	var requestedWebFonts = {};		// already requested web fonts have an entry here
	instanceProto.onCreate = function()
	{
		this.text = this.properties[0];
		this.visible = (this.properties[1] === 0);		// 0=visible, 1=invisible
		this.font = this.properties[2];
		this.color = this.properties[3];
		this.halign = this.properties[4];				// 0=left, 1=center, 2=right
		this.valign = this.properties[5];				// 0=top, 1=center, 2=bottom
		this.wrapbyword = (this.properties[7] === 0);	// 0=word, 1=character
		this.lastwidth = this.width;
		this.lastwrapwidth = this.width;
		this.lastheight = this.height;
		this.line_height_offset = this.properties[8];
		this.facename = "";
		this.fontstyle = "";
		this.ptSize = 0;
		this.textWidth = 0;
		this.textHeight = 0;
		this.parseFont();
		this.mycanvas = null;
		this.myctx = null;
		this.mytex = null;
		this.need_text_redraw = false;
		this.last_render_tick = this.runtime.tickcount;
		if (this.recycled)
			this.rcTex.set(0, 0, 1, 1);
		else
			this.rcTex = new cr.rect(0, 0, 1, 1);
		if (this.runtime.glwrap)
			this.runtime.tickMe(this);
;
	};
	instanceProto.parseFont = function ()
	{
		var arr = this.font.split(" ");
		var i;
		for (i = 0; i < arr.length; i++)
		{
			if (arr[i].substr(arr[i].length - 2, 2) === "pt")
			{
				this.ptSize = parseInt(arr[i].substr(0, arr[i].length - 2));
				this.pxHeight = Math.ceil((this.ptSize / 72.0) * 96.0) + 4;	// assume 96dpi...
				if (i > 0)
					this.fontstyle = arr[i - 1];
				this.facename = arr[i + 1];
				for (i = i + 2; i < arr.length; i++)
					this.facename += " " + arr[i];
				break;
			}
		}
	};
	instanceProto.saveToJSON = function ()
	{
		return {
			"t": this.text,
			"f": this.font,
			"c": this.color,
			"ha": this.halign,
			"va": this.valign,
			"wr": this.wrapbyword,
			"lho": this.line_height_offset,
			"fn": this.facename,
			"fs": this.fontstyle,
			"ps": this.ptSize,
			"pxh": this.pxHeight,
			"tw": this.textWidth,
			"th": this.textHeight,
			"lrt": this.last_render_tick
		};
	};
	instanceProto.loadFromJSON = function (o)
	{
		this.text = o["t"];
		this.font = o["f"];
		this.color = o["c"];
		this.halign = o["ha"];
		this.valign = o["va"];
		this.wrapbyword = o["wr"];
		this.line_height_offset = o["lho"];
		this.facename = o["fn"];
		this.fontstyle = o["fs"];
		this.ptSize = o["ps"];
		this.pxHeight = o["pxh"];
		this.textWidth = o["tw"];
		this.textHeight = o["th"];
		this.last_render_tick = o["lrt"];
		this.text_changed = true;
		this.lastwidth = this.width;
		this.lastwrapwidth = this.width;
		this.lastheight = this.height;
	};
	instanceProto.tick = function ()
	{
		if (this.runtime.glwrap && this.mytex && (this.runtime.tickcount - this.last_render_tick >= 300))
		{
			var layer = this.layer;
            this.update_bbox();
            var bbox = this.bbox;
            if (bbox.right < layer.viewLeft || bbox.bottom < layer.viewTop || bbox.left > layer.viewRight || bbox.top > layer.viewBottom)
			{
				this.runtime.glwrap.deleteTexture(this.mytex);
				this.mytex = null;
				this.myctx = null;
				this.mycanvas = null;
			}
		}
	};
	instanceProto.onDestroy = function ()
	{
		this.myctx = null;
		this.mycanvas = null;
		if (this.runtime.glwrap && this.mytex)
			this.runtime.glwrap.deleteTexture(this.mytex);
		this.mytex = null;
	};
	instanceProto.updateFont = function ()
	{
		this.font = this.fontstyle + " " + this.ptSize.toString() + "pt " + this.facename;
		this.text_changed = true;
		this.runtime.redraw = true;
	};
	instanceProto.draw = function(ctx, glmode)
	{
		ctx.font = this.font;
		ctx.textBaseline = "top";
		ctx.fillStyle = this.color;
		ctx.globalAlpha = glmode ? 1 : this.opacity;
		var myscale = 1;
		if (glmode)
		{
			myscale = this.layer.getScale();
			ctx.save();
			ctx.scale(myscale, myscale);
		}
		if (this.text_changed || this.width !== this.lastwrapwidth)
		{
			this.type.plugin.WordWrap(this.text, this.lines, ctx, this.width, this.wrapbyword);
			this.text_changed = false;
			this.lastwrapwidth = this.width;
		}
		this.update_bbox();
		var penX = glmode ? 0 : this.bquad.tlx;
		var penY = glmode ? 0 : this.bquad.tly;
		if (this.runtime.pixel_rounding)
		{
			penX = (penX + 0.5) | 0;
			penY = (penY + 0.5) | 0;
		}
		if (this.angle !== 0 && !glmode)
		{
			ctx.save();
			ctx.translate(penX, penY);
			ctx.rotate(this.angle);
			penX = 0;
			penY = 0;
		}
		var endY = penY + this.height;
		var line_height = this.pxHeight;
		line_height += this.line_height_offset;
		var drawX;
		var i;
		if (this.valign === 1)		// center
			penY += Math.max(this.height / 2 - (this.lines.length * line_height) / 2, 0);
		else if (this.valign === 2)	// bottom
			penY += Math.max(this.height - (this.lines.length * line_height) - 2, 0);
		for (i = 0; i < this.lines.length; i++)
		{
			drawX = penX;
			if (this.halign === 1)		// center
				drawX = penX + (this.width - this.lines[i].width) / 2;
			else if (this.halign === 2)	// right
				drawX = penX + (this.width - this.lines[i].width);
			ctx.fillText(this.lines[i].text, drawX, penY);
			penY += line_height;
			if (penY >= endY - line_height)
				break;
		}
		if (this.angle !== 0 || glmode)
			ctx.restore();
		this.last_render_tick = this.runtime.tickcount;
	};
	instanceProto.drawGL = function(glw)
	{
		if (this.width < 1 || this.height < 1)
			return;
		var need_redraw = this.text_changed || this.need_text_redraw;
		this.need_text_redraw = false;
		var layer_scale = this.layer.getScale();
		var layer_angle = this.layer.getAngle();
		var rcTex = this.rcTex;
		var floatscaledwidth = layer_scale * this.width;
		var floatscaledheight = layer_scale * this.height;
		var scaledwidth = Math.ceil(floatscaledwidth);
		var scaledheight = Math.ceil(floatscaledheight);
		var windowWidth = this.runtime.width;
		var windowHeight = this.runtime.height;
		var halfw = windowWidth / 2;
		var halfh = windowHeight / 2;
		if (!this.myctx)
		{
			this.mycanvas = document.createElement("canvas");
			this.mycanvas.width = scaledwidth;
			this.mycanvas.height = scaledheight;
			this.lastwidth = scaledwidth;
			this.lastheight = scaledheight;
			need_redraw = true;
			this.myctx = this.mycanvas.getContext("2d");
		}
		if (scaledwidth !== this.lastwidth || scaledheight !== this.lastheight)
		{
			this.mycanvas.width = scaledwidth;
			this.mycanvas.height = scaledheight;
			if (this.mytex)
			{
				glw.deleteTexture(this.mytex);
				this.mytex = null;
			}
			need_redraw = true;
		}
		if (need_redraw)
		{
			this.myctx.clearRect(0, 0, scaledwidth, scaledheight);
			this.draw(this.myctx, true);
			if (!this.mytex)
				this.mytex = glw.createEmptyTexture(scaledwidth, scaledheight, this.runtime.linearSampling, this.runtime.isMobile);
			glw.videoToTexture(this.mycanvas, this.mytex, this.runtime.isMobile);
		}
		this.lastwidth = scaledwidth;
		this.lastheight = scaledheight;
		glw.setTexture(this.mytex);
		glw.setOpacity(this.opacity);
		glw.resetModelView();
		glw.translate(-halfw, -halfh);
		glw.updateModelView();
		var q = this.bquad;
		var old_dpr = this.runtime.devicePixelRatio;
		this.runtime.devicePixelRatio = 1;
		var tlx = this.layer.layerToCanvas(q.tlx, q.tly, true);
		var tly = this.layer.layerToCanvas(q.tlx, q.tly, false);
		var trx = this.layer.layerToCanvas(q.trx, q.try_, true);
		var try_ = this.layer.layerToCanvas(q.trx, q.try_, false);
		var brx = this.layer.layerToCanvas(q.brx, q.bry, true);
		var bry = this.layer.layerToCanvas(q.brx, q.bry, false);
		var blx = this.layer.layerToCanvas(q.blx, q.bly, true);
		var bly = this.layer.layerToCanvas(q.blx, q.bly, false);
		this.runtime.devicePixelRatio = old_dpr;
		if (this.runtime.pixel_rounding || (this.angle === 0 && layer_angle === 0))
		{
			var ox = ((tlx + 0.5) | 0) - tlx;
			var oy = ((tly + 0.5) | 0) - tly
			tlx += ox;
			tly += oy;
			trx += ox;
			try_ += oy;
			brx += ox;
			bry += oy;
			blx += ox;
			bly += oy;
		}
		if (this.angle === 0 && layer_angle === 0)
		{
			trx = tlx + scaledwidth;
			try_ = tly;
			brx = trx;
			bry = tly + scaledheight;
			blx = tlx;
			bly = bry;
			rcTex.right = 1;
			rcTex.bottom = 1;
		}
		else
		{
			rcTex.right = floatscaledwidth / scaledwidth;
			rcTex.bottom = floatscaledheight / scaledheight;
		}
		glw.quadTex(tlx, tly, trx, try_, brx, bry, blx, bly, rcTex);
		glw.resetModelView();
		glw.scale(layer_scale, layer_scale);
		glw.rotateZ(-this.layer.getAngle());
		glw.translate((this.layer.viewLeft + this.layer.viewRight) / -2, (this.layer.viewTop + this.layer.viewBottom) / -2);
		glw.updateModelView();
		this.last_render_tick = this.runtime.tickcount;
	};
	var wordsCache = [];
	pluginProto.TokeniseWords = function (text)
	{
		wordsCache.length = 0;
		var cur_word = "";
		var ch;
		var i = 0;
		while (i < text.length)
		{
			ch = text.charAt(i);
			if (ch === "\n")
			{
				if (cur_word.length)
				{
					wordsCache.push(cur_word);
					cur_word = "";
				}
				wordsCache.push("\n");
				++i;
			}
			else if (ch === " " || ch === "\t" || ch === "-")
			{
				do {
					cur_word += text.charAt(i);
					i++;
				}
				while (i < text.length && (text.charAt(i) === " " || text.charAt(i) === "\t"));
				wordsCache.push(cur_word);
				cur_word = "";
			}
			else if (i < text.length)
			{
				cur_word += ch;
				i++;
			}
		}
		if (cur_word.length)
			wordsCache.push(cur_word);
	};
	var linesCache = [];
	function allocLine()
	{
		if (linesCache.length)
			return linesCache.pop();
		else
			return {};
	};
	function freeLine(l)
	{
		linesCache.push(l);
	};
	function freeAllLines(arr)
	{
		var i, len;
		for (i = 0, len = arr.length; i < len; i++)
		{
			freeLine(arr[i]);
		}
		arr.length = 0;
	};
	pluginProto.WordWrap = function (text, lines, ctx, width, wrapbyword)
	{
		if (!text || !text.length)
		{
			freeAllLines(lines);
			return;
		}
		if (width <= 2.0)
		{
			freeAllLines(lines);
			return;
		}
		if (text.length <= 100 && text.indexOf("\n") === -1)
		{
			var all_width = ctx.measureText(text).width;
			if (all_width <= width)
			{
				freeAllLines(lines);
				lines.push(allocLine());
				lines[0].text = text;
				lines[0].width = all_width;
				return;
			}
		}
		this.WrapText(text, lines, ctx, width, wrapbyword);
	};
	pluginProto.WrapText = function (text, lines, ctx, width, wrapbyword)
	{
		var wordArray;
		if (wrapbyword)
		{
			this.TokeniseWords(text);	// writes to wordsCache
			wordArray = wordsCache;
		}
		else
			wordArray = text;
		var cur_line = "";
		var prev_line;
		var line_width;
		var i;
		var lineIndex = 0;
		var line;
		for (i = 0; i < wordArray.length; i++)
		{
			if (wordArray[i] === "\n")
			{
				if (lineIndex >= lines.length)
					lines.push(allocLine());
				line = lines[lineIndex];
				line.text = cur_line;
				line.width = ctx.measureText(cur_line).width;
				lineIndex++;
				cur_line = "";
				continue;
			}
			prev_line = cur_line;
			cur_line += wordArray[i];
			line_width = ctx.measureText(cur_line).width;
			if (line_width >= width)
			{
				if (lineIndex >= lines.length)
					lines.push(allocLine());
				line = lines[lineIndex];
				line.text = prev_line;
				line.width = ctx.measureText(prev_line).width;
				lineIndex++;
				cur_line = wordArray[i];
				if (!wrapbyword && cur_line === " ")
					cur_line = "";
			}
		}
		if (cur_line.length)
		{
			if (lineIndex >= lines.length)
				lines.push(allocLine());
			line = lines[lineIndex];
			line.text = cur_line;
			line.width = ctx.measureText(cur_line).width;
			lineIndex++;
		}
		for (i = lineIndex; i < lines.length; i++)
			freeLine(lines[i]);
		lines.length = lineIndex;
	};
	function Cnds() {};
	Cnds.prototype.CompareText = function(text_to_compare, case_sensitive)
	{
		if (case_sensitive)
			return this.text == text_to_compare;
		else
			return cr.equals_nocase(this.text, text_to_compare);
	};
	pluginProto.cnds = new Cnds();
	function Acts() {};
	Acts.prototype.SetText = function(param)
	{
		if (cr.is_number(param) && param < 1e9)
			param = Math.round(param * 1e10) / 1e10;	// round to nearest ten billionth - hides floating point errors
		var text_to_set = param.toString();
		if (this.text !== text_to_set)
		{
			this.text = text_to_set;
			this.text_changed = true;
			this.runtime.redraw = true;
		}
	};
	Acts.prototype.AppendText = function(param)
	{
		if (cr.is_number(param))
			param = Math.round(param * 1e10) / 1e10;	// round to nearest ten billionth - hides floating point errors
		var text_to_append = param.toString();
		if (text_to_append)	// not empty
		{
			this.text += text_to_append;
			this.text_changed = true;
			this.runtime.redraw = true;
		}
	};
	Acts.prototype.SetFontFace = function (face_, style_)
	{
		var newstyle = "";
		switch (style_) {
		case 1: newstyle = "bold"; break;
		case 2: newstyle = "italic"; break;
		case 3: newstyle = "bold italic"; break;
		}
		if (face_ === this.facename && newstyle === this.fontstyle)
			return;		// no change
		this.facename = face_;
		this.fontstyle = newstyle;
		this.updateFont();
	};
	Acts.prototype.SetFontSize = function (size_)
	{
		if (this.ptSize === size_)
			return;
		this.ptSize = size_;
		this.pxHeight = Math.ceil((this.ptSize / 72.0) * 96.0) + 4;	// assume 96dpi...
		this.updateFont();
	};
	Acts.prototype.SetFontColor = function (rgb)
	{
		var newcolor = "rgb(" + cr.GetRValue(rgb).toString() + "," + cr.GetGValue(rgb).toString() + "," + cr.GetBValue(rgb).toString() + ")";
		if (newcolor === this.color)
			return;
		this.color = newcolor;
		this.need_text_redraw = true;
		this.runtime.redraw = true;
	};
	Acts.prototype.SetWebFont = function (familyname_, cssurl_)
	{
		if (this.runtime.isDomFree)
		{
			cr.logexport("[Construct 2] Text plugin: 'Set web font' not supported on this platform - the action has been ignored");
			return;		// DC todo
		}
		var self = this;
		var refreshFunc = (function () {
							self.runtime.redraw = true;
							self.text_changed = true;
						});
		if (requestedWebFonts.hasOwnProperty(cssurl_))
		{
			var newfacename = "'" + familyname_ + "'";
			if (this.facename === newfacename)
				return;	// no change
			this.facename = newfacename;
			this.updateFont();
			for (var i = 1; i < 10; i++)
			{
				setTimeout(refreshFunc, i * 100);
				setTimeout(refreshFunc, i * 1000);
			}
			return;
		}
		var wf = document.createElement("link");
		wf.href = cssurl_;
		wf.rel = "stylesheet";
		wf.type = "text/css";
		wf.onload = refreshFunc;
		document.getElementsByTagName('head')[0].appendChild(wf);
		requestedWebFonts[cssurl_] = true;
		this.facename = "'" + familyname_ + "'";
		this.updateFont();
		for (var i = 1; i < 10; i++)
		{
			setTimeout(refreshFunc, i * 100);
			setTimeout(refreshFunc, i * 1000);
		}
;
	};
	Acts.prototype.SetEffect = function (effect)
	{
		this.compositeOp = cr.effectToCompositeOp(effect);
		cr.setGLBlend(this, effect, this.runtime.gl);
		this.runtime.redraw = true;
	};
	pluginProto.acts = new Acts();
	function Exps() {};
	Exps.prototype.Text = function(ret)
	{
		ret.set_string(this.text);
	};
	Exps.prototype.FaceName = function (ret)
	{
		ret.set_string(this.facename);
	};
	Exps.prototype.FaceSize = function (ret)
	{
		ret.set_int(this.ptSize);
	};
	Exps.prototype.TextWidth = function (ret)
	{
		var w = 0;
		var i, len, x;
		for (i = 0, len = this.lines.length; i < len; i++)
		{
			x = this.lines[i].width;
			if (w < x)
				w = x;
		}
		ret.set_int(w);
	};
	Exps.prototype.TextHeight = function (ret)
	{
		ret.set_int(this.lines.length * (this.pxHeight + this.line_height_offset) - this.line_height_offset);
	};
	pluginProto.exps = new Exps();
}());
;
;
cr.plugins_.TextBox = function(runtime)
{
	this.runtime = runtime;
};
(function ()
{
	var pluginProto = cr.plugins_.TextBox.prototype;
	pluginProto.Type = function(plugin)
	{
		this.plugin = plugin;
		this.runtime = plugin.runtime;
	};
	var typeProto = pluginProto.Type.prototype;
	typeProto.onCreate = function()
	{
	};
	pluginProto.Instance = function(type)
	{
		this.type = type;
		this.runtime = type.runtime;
	};
	var instanceProto = pluginProto.Instance.prototype;
	var elemTypes = ["text", "password", "email", "number", "tel", "url"];
	if (navigator.userAgent.indexOf("MSIE 9") > -1)
	{
		elemTypes[2] = "text";
		elemTypes[3] = "text";
		elemTypes[4] = "text";
		elemTypes[5] = "text";
	}
	instanceProto.onCreate = function()
	{
		if (this.runtime.isDomFree)
		{
			cr.logexport("[Construct 2] Textbox plugin not supported on this platform - the object will not be created");
			return;
		}
		if (this.properties[7] === 6)	// textarea
		{
			this.elem = document.createElement("textarea");
			jQuery(this.elem).css("resize", "none");
		}
		else
		{
			this.elem = document.createElement("input");
			this.elem.type = elemTypes[this.properties[7]];
		}
		this.elem.id = this.properties[9];
		jQuery(this.elem).appendTo(this.runtime.canvasdiv ? this.runtime.canvasdiv : "body");
		this.elem["autocomplete"] = "off";
		this.elem.value = this.properties[0];
		this.elem["placeholder"] = this.properties[1];
		this.elem.title = this.properties[2];
		this.elem.disabled = (this.properties[4] === 0);
		this.elem["readOnly"] = (this.properties[5] === 1);
		this.elem["spellcheck"] = (this.properties[6] === 1);
		this.autoFontSize = (this.properties[8] !== 0);
		this.element_hidden = false;
		if (this.properties[3] === 0)
		{
			jQuery(this.elem).hide();
			this.visible = false;
			this.element_hidden = true;
		}
		var onchangetrigger = (function (self) {
			return function() {
				self.runtime.trigger(cr.plugins_.TextBox.prototype.cnds.OnTextChanged, self);
			};
		})(this);
		this.elem["oninput"] = onchangetrigger;
		if (navigator.userAgent.indexOf("MSIE") !== -1)
			this.elem["oncut"] = onchangetrigger;
		this.elem.onclick = (function (self) {
			return function(e) {
				e.stopPropagation();
				self.runtime.trigger(cr.plugins_.TextBox.prototype.cnds.OnClicked, self);
			};
		})(this);
		this.elem.ondblclick = (function (self) {
			return function(e) {
				e.stopPropagation();
				self.runtime.trigger(cr.plugins_.TextBox.prototype.cnds.OnDoubleClicked, self);
			};
		})(this);
		this.elem.addEventListener("touchstart", function (e) {
			e.stopPropagation();
		}, false);
		this.elem.addEventListener("touchmove", function (e) {
			e.stopPropagation();
		}, false);
		this.elem.addEventListener("touchend", function (e) {
			e.stopPropagation();
		}, false);
		jQuery(this.elem).mousedown(function (e) {
			e.stopPropagation();
		});
		jQuery(this.elem).mouseup(function (e) {
			e.stopPropagation();
		});
		jQuery(this.elem).keydown(function (e) {
			if (e.which !== 13 && e.which != 27)	// allow enter and escape
				e.stopPropagation();
		});
		jQuery(this.elem).keyup(function (e) {
			if (e.which !== 13 && e.which != 27)	// allow enter and escape
				e.stopPropagation();
		});
		this.lastLeft = 0;
		this.lastTop = 0;
		this.lastRight = 0;
		this.lastBottom = 0;
		this.lastWinWidth = 0;
		this.lastWinHeight = 0;
		this.updatePosition(true);
		this.runtime.tickMe(this);
	};
	instanceProto.saveToJSON = function ()
	{
		return {
			"text": this.elem.value,
			"placeholder": this.elem.placeholder,
			"tooltip": this.elem.title,
			"disabled": !!this.elem.disabled,
			"readonly": !!this.elem.readOnly,
			"spellcheck": !!this.elem["spellcheck"]
		};
	};
	instanceProto.loadFromJSON = function (o)
	{
		this.elem.value = o["text"];
		this.elem.placeholder = o["placeholder"];
		this.elem.title = o["tooltip"];
		this.elem.disabled = o["disabled"];
		this.elem.readOnly = o["readonly"];
		this.elem["spellcheck"] = o["spellcheck"];
	};
	instanceProto.onDestroy = function ()
	{
		if (this.runtime.isDomFree)
				return;
		jQuery(this.elem).remove();
		this.elem = null;
	};
	instanceProto.tick = function ()
	{
		this.updatePosition();
	};
	instanceProto.updatePosition = function (first)
	{
		if (this.runtime.isDomFree)
			return;
		var left = this.layer.layerToCanvas(this.x, this.y, true);
		var top = this.layer.layerToCanvas(this.x, this.y, false);
		var right = this.layer.layerToCanvas(this.x + this.width, this.y + this.height, true);
		var bottom = this.layer.layerToCanvas(this.x + this.width, this.y + this.height, false);
		if (!this.visible || !this.layer.visible || right <= 0 || bottom <= 0 || left >= this.runtime.width || top >= this.runtime.height)
		{
			if (!this.element_hidden)
				jQuery(this.elem).hide();
			this.element_hidden = true;
			return;
		}
		if (left < 1)
			left = 1;
		if (top < 1)
			top = 1;
		if (right >= this.runtime.width)
			right = this.runtime.width - 1;
		if (bottom >= this.runtime.height)
			bottom = this.runtime.height - 1;
		var curWinWidth = window.innerWidth;
		var curWinHeight = window.innerHeight;
		if (!first && this.lastLeft === left && this.lastTop === top && this.lastRight === right && this.lastBottom === bottom && this.lastWinWidth === curWinWidth && this.lastWinHeight === curWinHeight)
		{
			if (this.element_hidden)
			{
				jQuery(this.elem).show();
				this.element_hidden = false;
			}
			return;
		}
		this.lastLeft = left;
		this.lastTop = top;
		this.lastRight = right;
		this.lastBottom = bottom;
		this.lastWinWidth = curWinWidth;
		this.lastWinHeight = curWinHeight;
		if (this.element_hidden)
		{
			jQuery(this.elem).show();
			this.element_hidden = false;
		}
		var offx = Math.round(left) + jQuery(this.runtime.canvas).offset().left;
		var offy = Math.round(top) + jQuery(this.runtime.canvas).offset().top;
		jQuery(this.elem).css("position", "absolute");
		jQuery(this.elem).offset({left: offx, top: offy});
		jQuery(this.elem).width(Math.round(right - left));
		jQuery(this.elem).height(Math.round(bottom - top));
		if (this.autoFontSize)
			jQuery(this.elem).css("font-size", ((this.layer.getScale() / this.runtime.devicePixelRatio) - 0.2) + "em");
	};
	instanceProto.draw = function(ctx)
	{
	};
	instanceProto.drawGL = function(glw)
	{
	};
	function Cnds() {};
	Cnds.prototype.CompareText = function (text, case_)
	{
		if (this.runtime.isDomFree)
			return false;
		if (case_ === 0)	// insensitive
			return cr.equals_nocase(this.elem.value, text);
		else
			return this.elem.value === text;
	};
	Cnds.prototype.OnTextChanged = function ()
	{
		return true;
	};
	Cnds.prototype.OnClicked = function ()
	{
		return true;
	};
	Cnds.prototype.OnDoubleClicked = function ()
	{
		return true;
	};
	pluginProto.cnds = new Cnds();
	function Acts() {};
	Acts.prototype.SetText = function (text)
	{
		if (this.runtime.isDomFree)
			return;
		this.elem.value = text;
	};
	Acts.prototype.SetPlaceholder = function (text)
	{
		if (this.runtime.isDomFree)
			return;
		this.elem.placeholder = text;
	};
	Acts.prototype.SetTooltip = function (text)
	{
		if (this.runtime.isDomFree)
			return;
		this.elem.title = text;
	};
	Acts.prototype.SetVisible = function (vis)
	{
		if (this.runtime.isDomFree)
			return;
		this.visible = (vis !== 0);
	};
	Acts.prototype.SetEnabled = function (en)
	{
		if (this.runtime.isDomFree)
			return;
		this.elem.disabled = (en === 0);
	};
	Acts.prototype.SetReadOnly = function (ro)
	{
		if (this.runtime.isDomFree)
			return;
		this.elem.readOnly = (ro === 0);
	};
	Acts.prototype.SetFocus = function ()
	{
		if (this.runtime.isDomFree)
			return;
		this.elem.focus();
	};
	Acts.prototype.SetBlur = function ()
	{
		if (this.runtime.isDomFree)
			return;
		this.elem.blur();
	};
	Acts.prototype.SetCSSStyle = function (p, v)
	{
		if (this.runtime.isDomFree)
			return;
		jQuery(this.elem).css(p, v);
	};
	pluginProto.acts = new Acts();
	function Exps() {};
	Exps.prototype.Text = function (ret)
	{
		if (this.runtime.isDomFree)
		{
			ret.set_string("");
			return;
		}
		ret.set_string(this.elem.value);
	};
	pluginProto.exps = new Exps();
}());
;
;
cr.plugins_.TiledBg = function(runtime)
{
	this.runtime = runtime;
};
(function ()
{
	var pluginProto = cr.plugins_.TiledBg.prototype;
	pluginProto.Type = function(plugin)
	{
		this.plugin = plugin;
		this.runtime = plugin.runtime;
	};
	var typeProto = pluginProto.Type.prototype;
	typeProto.onCreate = function()
	{
		if (this.is_family)
			return;
		this.texture_img = new Image();
		this.texture_img["idtkLoadDisposed"] = true;
		this.texture_img.src = this.texture_file;
		this.texture_img.cr_filesize = this.texture_filesize;
		this.runtime.wait_for_textures.push(this.texture_img);
		this.pattern = null;
		this.webGL_texture = null;
	};
	typeProto.onLostWebGLContext = function ()
	{
		if (this.is_family)
			return;
		this.webGL_texture = null;
	};
	typeProto.onRestoreWebGLContext = function ()
	{
		if (this.is_family || !this.instances.length)
			return;
		if (!this.webGL_texture)
		{
			this.webGL_texture = this.runtime.glwrap.loadTexture(this.texture_img, true, this.runtime.linearSampling, this.texture_pixelformat);
		}
		var i, len;
		for (i = 0, len = this.instances.length; i < len; i++)
			this.instances[i].webGL_texture = this.webGL_texture;
	};
	typeProto.loadTextures = function ()
	{
		if (this.is_family || this.webGL_texture || !this.runtime.glwrap)
			return;
		this.webGL_texture = this.runtime.glwrap.loadTexture(this.texture_img, true, this.runtime.linearSampling, this.texture_pixelformat);
	};
	typeProto.unloadTextures = function ()
	{
		if (this.is_family || this.instances.length || !this.webGL_texture)
			return;
		this.runtime.glwrap.deleteTexture(this.webGL_texture);
		this.webGL_texture = null;
	};
	typeProto.preloadCanvas2D = function (ctx)
	{
		ctx.drawImage(this.texture_img, 0, 0);
	};
	pluginProto.Instance = function(type)
	{
		this.type = type;
		this.runtime = type.runtime;
	};
	var instanceProto = pluginProto.Instance.prototype;
	instanceProto.onCreate = function()
	{
		this.visible = (this.properties[0] === 0);							// 0=visible, 1=invisible
		this.rcTex = new cr.rect(0, 0, 0, 0);
		this.has_own_texture = false;										// true if a texture loaded in from URL
		this.texture_img = this.type.texture_img;
		if (this.runtime.glwrap)
		{
			this.type.loadTextures();
			this.webGL_texture = this.type.webGL_texture;
		}
		else
		{
			if (!this.type.pattern)
				this.type.pattern = this.runtime.ctx.createPattern(this.type.texture_img, "repeat");
			this.pattern = this.type.pattern;
		}
	};
	instanceProto.afterLoad = function ()
	{
		this.has_own_texture = false;
		this.texture_img = this.type.texture_img;
	};
	instanceProto.onDestroy = function ()
	{
		if (this.runtime.glwrap && this.has_own_texture && this.webGL_texture)
		{
			this.runtime.glwrap.deleteTexture(this.webGL_texture);
			this.webGL_texture = null;
		}
	};
	instanceProto.draw = function(ctx)
	{
		ctx.globalAlpha = this.opacity;
		ctx.save();
		ctx.fillStyle = this.pattern;
		var myx = this.x;
		var myy = this.y;
		if (this.runtime.pixel_rounding)
		{
			myx = (myx + 0.5) | 0;
			myy = (myy + 0.5) | 0;
		}
		var drawX = -(this.hotspotX * this.width);
		var drawY = -(this.hotspotY * this.height);
		var offX = drawX % this.texture_img.width;
		var offY = drawY % this.texture_img.height;
		if (offX < 0)
			offX += this.texture_img.width;
		if (offY < 0)
			offY += this.texture_img.height;
		ctx.translate(myx, myy);
		ctx.rotate(this.angle);
		ctx.translate(offX, offY);
		ctx.fillRect(drawX - offX,
					 drawY - offY,
					 this.width,
					 this.height);
		ctx.restore();
	};
	instanceProto.drawGL = function(glw)
	{
		glw.setTexture(this.webGL_texture);
		glw.setOpacity(this.opacity);
		var rcTex = this.rcTex;
		rcTex.right = this.width / this.texture_img.width;
		rcTex.bottom = this.height / this.texture_img.height;
		var q = this.bquad;
		if (this.runtime.pixel_rounding)
		{
			var ox = ((this.x + 0.5) | 0) - this.x;
			var oy = ((this.y + 0.5) | 0) - this.y;
			glw.quadTex(q.tlx + ox, q.tly + oy, q.trx + ox, q.try_ + oy, q.brx + ox, q.bry + oy, q.blx + ox, q.bly + oy, rcTex);
		}
		else
			glw.quadTex(q.tlx, q.tly, q.trx, q.try_, q.brx, q.bry, q.blx, q.bly, rcTex);
	};
	function Cnds() {};
	Cnds.prototype.OnURLLoaded = function ()
	{
		return true;
	};
	pluginProto.cnds = new Cnds();
	function Acts() {};
	Acts.prototype.SetEffect = function (effect)
	{
		this.compositeOp = cr.effectToCompositeOp(effect);
		cr.setGLBlend(this, effect, this.runtime.gl);
		this.runtime.redraw = true;
	};
	Acts.prototype.LoadURL = function (url_)
	{
		var img = new Image();
		var self = this;
		img.onload = function ()
		{
			self.texture_img = img;
			if (self.runtime.glwrap)
			{
				if (self.has_own_texture && self.webGL_texture)
					self.runtime.glwrap.deleteTexture(self.webGL_texture);
				self.webGL_texture = self.runtime.glwrap.loadTexture(img, true, self.runtime.linearSampling);
			}
			else
			{
				self.pattern = self.runtime.ctx.createPattern(img, "repeat");
			}
			self.has_own_texture = true;
			self.runtime.redraw = true;
			self.runtime.trigger(cr.plugins_.TiledBg.prototype.cnds.OnURLLoaded, self);
		};
		if (url_.substr(0, 5) !== "data:")
			img.crossOrigin = 'anonymous';
		img.src = url_;
	};
	pluginProto.acts = new Acts();
	function Exps() {};
	Exps.prototype.ImageWidth = function (ret)
	{
		ret.set_float(this.texture_img.width);
	};
	Exps.prototype.ImageHeight = function (ret)
	{
		ret.set_float(this.texture_img.height);
	};
	pluginProto.exps = new Exps();
}());
;
;
cr.plugins_.Touch = function(runtime)
{
	this.runtime = runtime;
};
(function ()
{
	var pluginProto = cr.plugins_.Touch.prototype;
	pluginProto.Type = function(plugin)
	{
		this.plugin = plugin;
		this.runtime = plugin.runtime;
	};
	var typeProto = pluginProto.Type.prototype;
	typeProto.onCreate = function()
	{
	};
	pluginProto.Instance = function(type)
	{
		this.type = type;
		this.runtime = type.runtime;
		this.touches = [];
		this.mouseDown = false;
	};
	var instanceProto = pluginProto.Instance.prototype;
	var dummyoffset = {left: 0, top: 0};
	instanceProto.findTouch = function (id)
	{
		var i, len;
		for (i = 0, len = this.touches.length; i < len; i++)
		{
			if (this.touches[i]["id"] === id)
				return i;
		}
		return -1;
	};
	var appmobi_accx = 0;
	var appmobi_accy = 0;
	var appmobi_accz = 0;
	function AppMobiGetAcceleration(evt)
	{
		appmobi_accx = evt.x;
		appmobi_accy = evt.y;
		appmobi_accz = evt.z;
	};
	var pg_accx = 0;
	var pg_accy = 0;
	var pg_accz = 0;
	function PhoneGapGetAcceleration(evt)
	{
		pg_accx = evt.x;
		pg_accy = evt.y;
		pg_accz = evt.z;
	};
	var theInstance = null;
	instanceProto.onCreate = function()
	{
		theInstance = this;
		this.isWindows8 = !!(typeof window["c2isWindows8"] !== "undefined" && window["c2isWindows8"]);
		this.orient_alpha = 0;
		this.orient_beta = 0;
		this.orient_gamma = 0;
		this.acc_g_x = 0;
		this.acc_g_y = 0;
		this.acc_g_z = 0;
		this.acc_x = 0;
		this.acc_y = 0;
		this.acc_z = 0;
		this.curTouchX = 0;
		this.curTouchY = 0;
		this.trigger_index = 0;
		this.trigger_id = 0;
		this.useMouseInput = (this.properties[0] !== 0);
		var elem = (this.runtime.fullscreen_mode > 0) ? document : this.runtime.canvas;
		var elem2 = document;
		if (this.runtime.isDirectCanvas)
			elem2 = elem = window["Canvas"];
		else if (this.runtime.isCocoonJs)
			elem2 = elem = window;
		var self = this;
		if (window.navigator["pointerEnabled"])
		{
			elem.addEventListener("pointerdown",
				function(info) {
					self.onPointerStart(info);
				},
				false
			);
			elem.addEventListener("pointermove",
				function(info) {
					self.onPointerMove(info);
				},
				false
			);
			elem2.addEventListener("pointerup",
				function(info) {
					self.onPointerEnd(info);
				},
				false
			);
			elem2.addEventListener("pointercancel",
				function(info) {
					self.onPointerEnd(info);
				},
				false
			);
			if (this.runtime.canvas)
			{
				this.runtime.canvas.addEventListener("MSGestureHold", function(e) {
					e.preventDefault();
				}, false);
				document.addEventListener("MSGestureHold", function(e) {
					e.preventDefault();
				}, false);
				this.runtime.canvas.addEventListener("gesturehold", function(e) {
					e.preventDefault();
				}, false);
				document.addEventListener("gesturehold", function(e) {
					e.preventDefault();
				}, false);
			}
		}
		else if (window.navigator["msPointerEnabled"])
		{
			elem.addEventListener("MSPointerDown",
				function(info) {
					self.onPointerStart(info);
				},
				false
			);
			elem.addEventListener("MSPointerMove",
				function(info) {
					self.onPointerMove(info);
				},
				false
			);
			elem2.addEventListener("MSPointerUp",
				function(info) {
					self.onPointerEnd(info);
				},
				false
			);
			elem2.addEventListener("MSPointerCancel",
				function(info) {
					self.onPointerEnd(info);
				},
				false
			);
			if (this.runtime.canvas)
			{
				this.runtime.canvas.addEventListener("MSGestureHold", function(e) {
					e.preventDefault();
				}, false);
				document.addEventListener("MSGestureHold", function(e) {
					e.preventDefault();
				}, false);
			}
		}
		else
		{
			elem.addEventListener("touchstart",
				function(info) {
					self.onTouchStart(info);
				},
				false
			);
			elem.addEventListener("touchmove",
				function(info) {
					self.onTouchMove(info);
				},
				false
			);
			elem2.addEventListener("touchend",
				function(info) {
					self.onTouchEnd(info);
				},
				false
			);
			elem2.addEventListener("touchcancel",
				function(info) {
					self.onTouchEnd(info);
				},
				false
			);
		}
		if (this.isWindows8)
		{
			var win8accelerometerFn = function(e) {
					var reading = e["reading"];
					self.acc_x = reading["accelerationX"];
					self.acc_y = reading["accelerationY"];
					self.acc_z = reading["accelerationZ"];
				};
			var win8inclinometerFn = function(e) {
					var reading = e["reading"];
					self.orient_alpha = reading["yawDegrees"];
					self.orient_beta = reading["pitchDegrees"];
					self.orient_gamma = reading["rollDegrees"];
				};
			var accelerometer = Windows["Devices"]["Sensors"]["Accelerometer"]["getDefault"]();
            if (accelerometer)
			{
                accelerometer["reportInterval"] = Math.max(accelerometer["minimumReportInterval"], 16);
				accelerometer.addEventListener("readingchanged", win8accelerometerFn);
            }
			var inclinometer = Windows["Devices"]["Sensors"]["Inclinometer"]["getDefault"]();
			if (inclinometer)
			{
				inclinometer["reportInterval"] = Math.max(inclinometer["minimumReportInterval"], 16);
				inclinometer.addEventListener("readingchanged", win8inclinometerFn);
			}
			document.addEventListener("visibilitychange", function(e) {
				if (document["hidden"] || document["msHidden"])
				{
					if (accelerometer)
						accelerometer.removeEventListener("readingchanged", win8accelerometerFn);
					if (inclinometer)
						inclinometer.removeEventListener("readingchanged", win8inclinometerFn);
				}
				else
				{
					if (accelerometer)
						accelerometer.addEventListener("readingchanged", win8accelerometerFn);
					if (inclinometer)
						inclinometer.addEventListener("readingchanged", win8inclinometerFn);
				}
			}, false);
		}
		else
		{
			window.addEventListener("deviceorientation", function (eventData) {
				self.orient_alpha = eventData["alpha"] || 0;
				self.orient_beta = eventData["beta"] || 0;
				self.orient_gamma = eventData["gamma"] || 0;
			}, false);
			window.addEventListener("devicemotion", function (eventData) {
				if (eventData["accelerationIncludingGravity"])
				{
					self.acc_g_x = eventData["accelerationIncludingGravity"]["x"];
					self.acc_g_y = eventData["accelerationIncludingGravity"]["y"];
					self.acc_g_z = eventData["accelerationIncludingGravity"]["z"];
				}
				if (eventData["acceleration"])
				{
					self.acc_x = eventData["acceleration"]["x"];
					self.acc_y = eventData["acceleration"]["y"];
					self.acc_z = eventData["acceleration"]["z"];
				}
			}, false);
		}
		if (this.useMouseInput && !this.runtime.isDomFree)
		{
			jQuery(document).mousemove(
				function(info) {
					self.onMouseMove(info);
				}
			);
			jQuery(document).mousedown(
				function(info) {
					self.onMouseDown(info);
				}
			);
			jQuery(document).mouseup(
				function(info) {
					self.onMouseUp(info);
				}
			);
		}
		if (this.runtime.isAppMobi && !this.runtime.isDirectCanvas)
		{
			AppMobi["accelerometer"]["watchAcceleration"](AppMobiGetAcceleration, { "frequency": 40, "adjustForRotation": true });
		}
		if (this.runtime.isPhoneGap)
		{
			navigator["accelerometer"]["watchAcceleration"](PhoneGapGetAcceleration, null, { "frequency": 40 });
		}
		this.runtime.tick2Me(this);
	};
	instanceProto.onPointerMove = function (info)
	{
		if (info["pointerType"] === info["MSPOINTER_TYPE_MOUSE"] || info["pointerType"] === "mouse")
			return;
		if (info.preventDefault)
			info.preventDefault();
		var i = this.findTouch(info["pointerId"]);
		var nowtime = cr.performance_now();
		if (i >= 0)
		{
			var offset = this.runtime.isDomFree ? dummyoffset : jQuery(this.runtime.canvas).offset();
			var t = this.touches[i];
			if (nowtime - t.time < 2)
				return;
			t.lasttime = t.time;
			t.lastx = t.x;
			t.lasty = t.y;
			t.time = nowtime;
			t.x = info.pageX - offset.left;
			t.y = info.pageY - offset.top;
		}
	};
	instanceProto.onPointerStart = function (info)
	{
		if (info["pointerType"] === info["MSPOINTER_TYPE_MOUSE"] || info["pointerType"] === "mouse")
			return;
		if (info.preventDefault)
			info.preventDefault();
		var offset = this.runtime.isDomFree ? dummyoffset : jQuery(this.runtime.canvas).offset();
		var touchx = info.pageX - offset.left;
		var touchy = info.pageY - offset.top;
		var nowtime = cr.performance_now();
		this.trigger_index = this.touches.length;
		this.trigger_id = info["pointerId"];
		this.touches.push({ time: nowtime,
							x: touchx,
							y: touchy,
							lasttime: nowtime,
							lastx: touchx,
							lasty: touchy,
							"id": info["pointerId"],
							startindex: this.trigger_index
						});
		this.runtime.trigger(cr.plugins_.Touch.prototype.cnds.OnNthTouchStart, this);
		this.runtime.trigger(cr.plugins_.Touch.prototype.cnds.OnTouchStart, this);
		this.curTouchX = touchx;
		this.curTouchY = touchy;
		this.runtime.trigger(cr.plugins_.Touch.prototype.cnds.OnTouchObject, this);
	};
	instanceProto.onPointerEnd = function (info)
	{
		if (info["pointerType"] === info["MSPOINTER_TYPE_MOUSE"] || info["pointerType"] === "mouse")
			return;
		if (info.preventDefault)
			info.preventDefault();
		var i = this.findTouch(info["pointerId"]);
		this.trigger_index = (i >= 0 ? this.touches[i].startindex : -1);
		this.trigger_id = (i >= 0 ? this.touches[i]["id"] : -1);
		this.runtime.trigger(cr.plugins_.Touch.prototype.cnds.OnNthTouchEnd, this);
		this.runtime.trigger(cr.plugins_.Touch.prototype.cnds.OnTouchEnd, this);
		if (i >= 0)
		{
			this.touches.splice(i, 1);
		}
	};
	instanceProto.onTouchMove = function (info)
	{
		if (info.preventDefault)
			info.preventDefault();
		var nowtime = cr.performance_now();
		var i, len, t, u;
		for (i = 0, len = info.changedTouches.length; i < len; i++)
		{
			t = info.changedTouches[i];
			var j = this.findTouch(t["identifier"]);
			if (j >= 0)
			{
				var offset = this.runtime.isDomFree ? dummyoffset : jQuery(this.runtime.canvas).offset();
				u = this.touches[j];
				if (nowtime - u.time < 2)
					continue;
				u.lasttime = u.time;
				u.lastx = u.x;
				u.lasty = u.y;
				u.time = nowtime;
				u.x = t.pageX - offset.left;
				u.y = t.pageY - offset.top;
			}
		}
	};
	instanceProto.onTouchStart = function (info)
	{
		if (info.preventDefault)
			info.preventDefault();
		var offset = this.runtime.isDomFree ? dummyoffset : jQuery(this.runtime.canvas).offset();
		var nowtime = cr.performance_now();
		var i, len, t, j;
		for (i = 0, len = info.changedTouches.length; i < len; i++)
		{
			t = info.changedTouches[i];
			j = this.findTouch(t["identifier"]);
			if (j !== -1)
				continue;
			var touchx = t.pageX - offset.left;
			var touchy = t.pageY - offset.top;
			this.trigger_index = this.touches.length;
			this.trigger_id = t["identifier"];
			this.touches.push({ time: nowtime,
								x: touchx,
								y: touchy,
								lasttime: nowtime,
								lastx: touchx,
								lasty: touchy,
								"id": t["identifier"],
								startindex: this.trigger_index
							});
			this.runtime.trigger(cr.plugins_.Touch.prototype.cnds.OnNthTouchStart, this);
			this.runtime.trigger(cr.plugins_.Touch.prototype.cnds.OnTouchStart, this);
			this.curTouchX = touchx;
			this.curTouchY = touchy;
			this.runtime.trigger(cr.plugins_.Touch.prototype.cnds.OnTouchObject, this);
		}
	};
	instanceProto.onTouchEnd = function (info)
	{
		if (info.preventDefault)
			info.preventDefault();
		var i, len, t, j;
		for (i = 0, len = info.changedTouches.length; i < len; i++)
		{
			t = info.changedTouches[i];
			j = this.findTouch(t["identifier"]);
			if (j >= 0)
			{
				this.trigger_index = this.touches[j].startindex;
				this.trigger_id = this.touches[j]["id"];
				this.runtime.trigger(cr.plugins_.Touch.prototype.cnds.OnNthTouchEnd, this);
				this.runtime.trigger(cr.plugins_.Touch.prototype.cnds.OnTouchEnd, this);
				this.touches.splice(j, 1);
			}
		}
	};
	instanceProto.getAlpha = function ()
	{
		if (this.runtime.isAppMobi && this.orient_alpha === 0 && appmobi_accz !== 0)
			return appmobi_accz * 90;
		else if (this.runtime.isPhoneGap  && this.orient_alpha === 0 && pg_accz !== 0)
			return pg_accz * 90;
		else
			return this.orient_alpha;
	};
	instanceProto.getBeta = function ()
	{
		if (this.runtime.isAppMobi && this.orient_beta === 0 && appmobi_accy !== 0)
			return appmobi_accy * -90;
		else if (this.runtime.isPhoneGap  && this.orient_beta === 0 && pg_accy !== 0)
			return pg_accy * -90;
		else
			return this.orient_beta;
	};
	instanceProto.getGamma = function ()
	{
		if (this.runtime.isAppMobi && this.orient_gamma === 0 && appmobi_accx !== 0)
			return appmobi_accx * 90;
		else if (this.runtime.isPhoneGap  && this.orient_gamma === 0 && pg_accx !== 0)
			return pg_accx * 90;
		else
			return this.orient_gamma;
	};
	var noop_func = function(){};
	instanceProto.onMouseDown = function(info)
	{
		if (info.preventDefault && this.runtime.had_a_click)
			info.preventDefault();
		var t = { pageX: info.pageX, pageY: info.pageY, "identifier": 0 };
		var fakeinfo = { changedTouches: [t] };
		this.onTouchStart(fakeinfo);
		this.mouseDown = true;
	};
	instanceProto.onMouseMove = function(info)
	{
		if (info.preventDefault && this.runtime.had_a_click)
			info.preventDefault();
		if (!this.mouseDown)
			return;
		var t = { pageX: info.pageX, pageY: info.pageY, "identifier": 0 };
		var fakeinfo = { changedTouches: [t] };
		this.onTouchMove(fakeinfo);
	};
	instanceProto.onMouseUp = function(info)
	{
		if (info.preventDefault && this.runtime.had_a_click)
			info.preventDefault();
		this.runtime.had_a_click = true;
		var t = { pageX: info.pageX, pageY: info.pageY, "identifier": 0 };
		var fakeinfo = { changedTouches: [t] };
		this.onTouchEnd(fakeinfo);
		this.mouseDown = false;
	};
	instanceProto.tick2 = function()
	{
		var i, len, t;
		var nowtime = cr.performance_now();
		for (i = 0, len = this.touches.length; i < len; i++)
		{
			t = this.touches[i];
			if (t.time <= nowtime - 50)
				t.lasttime = nowtime;
		}
	};
	function Cnds() {};
	Cnds.prototype.OnTouchStart = function ()
	{
		return true;
	};
	Cnds.prototype.OnTouchEnd = function ()
	{
		return true;
	};
	Cnds.prototype.IsInTouch = function ()
	{
		return this.touches.length;
	};
	Cnds.prototype.OnTouchObject = function (type)
	{
		if (!type)
			return false;
		return this.runtime.testAndSelectCanvasPointOverlap(type, this.curTouchX, this.curTouchY, false);
	};
	Cnds.prototype.IsTouchingObject = function (type)
	{
		if (!type)
			return false;
		var sol = type.getCurrentSol();
		var instances = sol.getObjects();
		var px, py;
		var touching = [];
		var i, leni, j, lenj;
		for (i = 0, leni = instances.length; i < leni; i++)
		{
			var inst = instances[i];
			inst.update_bbox();
			for (j = 0, lenj = this.touches.length; j < lenj; j++)
			{
				var touch = this.touches[j];
				px = inst.layer.canvasToLayer(touch.x, touch.y, true);
				py = inst.layer.canvasToLayer(touch.x, touch.y, false);
				if (inst.contains_pt(px, py))
				{
					touching.push(inst);
					break;
				}
			}
		}
		if (touching.length)
		{
			sol.select_all = false;
			sol.instances = touching;
			type.applySolToContainer();
			return true;
		}
		else
			return false;
	};
	Cnds.prototype.CompareTouchSpeed = function (index, cmp, s)
	{
		index = Math.floor(index);
		if (index < 0 || index >= this.touches.length)
			return false;
		var t = this.touches[index];
		var dist = cr.distanceTo(t.x, t.y, t.lastx, t.lasty);
		var timediff = (t.time - t.lasttime) / 1000;
		var speed = 0;
		if (timediff > 0)
			speed = dist / timediff;
		return cr.do_cmp(speed, cmp, s);
	};
	Cnds.prototype.OrientationSupported = function ()
	{
		return typeof window["DeviceOrientationEvent"] !== "undefined";
	};
	Cnds.prototype.MotionSupported = function ()
	{
		return typeof window["DeviceMotionEvent"] !== "undefined";
	};
	Cnds.prototype.CompareOrientation = function (orientation_, cmp_, angle_)
	{
		var v = 0;
		if (orientation_ === 0)
			v = this.getAlpha();
		else if (orientation_ === 1)
			v = this.getBeta();
		else
			v = this.getGamma();
		return cr.do_cmp(v, cmp_, angle_);
	};
	Cnds.prototype.CompareAcceleration = function (acceleration_, cmp_, angle_)
	{
		var v = 0;
		if (acceleration_ === 0)
			v = this.acc_g_x;
		else if (acceleration_ === 1)
			v = this.acc_g_y;
		else if (acceleration_ === 2)
			v = this.acc_g_z;
		else if (acceleration_ === 3)
			v = this.acc_x;
		else if (acceleration_ === 4)
			v = this.acc_y;
		else if (acceleration_ === 5)
			v = this.acc_z;
		return cr.do_cmp(v, cmp_, angle_);
	};
	Cnds.prototype.OnNthTouchStart = function (touch_)
	{
		touch_ = Math.floor(touch_);
		return touch_ === this.trigger_index;
	};
	Cnds.prototype.OnNthTouchEnd = function (touch_)
	{
		touch_ = Math.floor(touch_);
		return touch_ === this.trigger_index;
	};
	Cnds.prototype.HasNthTouch = function (touch_)
	{
		touch_ = Math.floor(touch_);
		return this.touches.length >= touch_ + 1;
	};
	pluginProto.cnds = new Cnds();
	function Exps() {};
	Exps.prototype.TouchCount = function (ret)
	{
		ret.set_int(this.touches.length);
	};
	Exps.prototype.X = function (ret, layerparam)
	{
		if (this.touches.length)
		{
			var layer, oldScale, oldZoomRate, oldParallaxX, oldAngle;
			if (cr.is_undefined(layerparam))
			{
				layer = this.runtime.getLayerByNumber(0);
				oldScale = layer.scale;
				oldZoomRate = layer.zoomRate;
				oldParallaxX = layer.parallaxX;
				oldAngle = layer.angle;
				layer.scale = this.runtime.running_layout.scale;
				layer.zoomRate = 1.0;
				layer.parallaxX = 1.0;
				layer.angle = this.runtime.running_layout.angle;
				ret.set_float(layer.canvasToLayer(this.touches[0].x, this.touches[0].y, true));
				layer.scale = oldScale;
				layer.zoomRate = oldZoomRate;
				layer.parallaxX = oldParallaxX;
				layer.angle = oldAngle;
			}
			else
			{
				if (cr.is_number(layerparam))
					layer = this.runtime.getLayerByNumber(layerparam);
				else
					layer = this.runtime.getLayerByName(layerparam);
				if (layer)
					ret.set_float(layer.canvasToLayer(this.touches[0].x, this.touches[0].y, true));
				else
					ret.set_float(0);
			}
		}
		else
			ret.set_float(0);
	};
	Exps.prototype.XAt = function (ret, index, layerparam)
	{
		index = Math.floor(index);
		if (index < 0 || index >= this.touches.length)
		{
			ret.set_float(0);
			return;
		}
		var layer, oldScale, oldZoomRate, oldParallaxX, oldAngle;
		if (cr.is_undefined(layerparam))
		{
			layer = this.runtime.getLayerByNumber(0);
			oldScale = layer.scale;
			oldZoomRate = layer.zoomRate;
			oldParallaxX = layer.parallaxX;
			oldAngle = layer.angle;
			layer.scale = this.runtime.running_layout.scale;
			layer.zoomRate = 1.0;
			layer.parallaxX = 1.0;
			layer.angle = this.runtime.running_layout.angle;
			ret.set_float(layer.canvasToLayer(this.touches[index].x, this.touches[index].y, true));
			layer.scale = oldScale;
			layer.zoomRate = oldZoomRate;
			layer.parallaxX = oldParallaxX;
			layer.angle = oldAngle;
		}
		else
		{
			if (cr.is_number(layerparam))
				layer = this.runtime.getLayerByNumber(layerparam);
			else
				layer = this.runtime.getLayerByName(layerparam);
			if (layer)
				ret.set_float(layer.canvasToLayer(this.touches[index].x, this.touches[index].y, true));
			else
				ret.set_float(0);
		}
	};
	Exps.prototype.XForID = function (ret, id, layerparam)
	{
		var index = this.findTouch(id);
		if (index < 0)
		{
			ret.set_float(0);
			return;
		}
		var touch = this.touches[index];
		var layer, oldScale, oldZoomRate, oldParallaxX, oldAngle;
		if (cr.is_undefined(layerparam))
		{
			layer = this.runtime.getLayerByNumber(0);
			oldScale = layer.scale;
			oldZoomRate = layer.zoomRate;
			oldParallaxX = layer.parallaxX;
			oldAngle = layer.angle;
			layer.scale = this.runtime.running_layout.scale;
			layer.zoomRate = 1.0;
			layer.parallaxX = 1.0;
			layer.angle = this.runtime.running_layout.angle;
			ret.set_float(layer.canvasToLayer(touch.x, touch.y, true));
			layer.scale = oldScale;
			layer.zoomRate = oldZoomRate;
			layer.parallaxX = oldParallaxX;
			layer.angle = oldAngle;
		}
		else
		{
			if (cr.is_number(layerparam))
				layer = this.runtime.getLayerByNumber(layerparam);
			else
				layer = this.runtime.getLayerByName(layerparam);
			if (layer)
				ret.set_float(layer.canvasToLayer(touch.x, touch.y, true));
			else
				ret.set_float(0);
		}
	};
	Exps.prototype.Y = function (ret, layerparam)
	{
		if (this.touches.length)
		{
			var layer, oldScale, oldZoomRate, oldParallaxY, oldAngle;
			if (cr.is_undefined(layerparam))
			{
				layer = this.runtime.getLayerByNumber(0);
				oldScale = layer.scale;
				oldZoomRate = layer.zoomRate;
				oldParallaxY = layer.parallaxY;
				oldAngle = layer.angle;
				layer.scale = this.runtime.running_layout.scale;
				layer.zoomRate = 1.0;
				layer.parallaxY = 1.0;
				layer.angle = this.runtime.running_layout.angle;
				ret.set_float(layer.canvasToLayer(this.touches[0].x, this.touches[0].y, false));
				layer.scale = oldScale;
				layer.zoomRate = oldZoomRate;
				layer.parallaxY = oldParallaxY;
				layer.angle = oldAngle;
			}
			else
			{
				if (cr.is_number(layerparam))
					layer = this.runtime.getLayerByNumber(layerparam);
				else
					layer = this.runtime.getLayerByName(layerparam);
				if (layer)
					ret.set_float(layer.canvasToLayer(this.touches[0].x, this.touches[0].y, false));
				else
					ret.set_float(0);
			}
		}
		else
			ret.set_float(0);
	};
	Exps.prototype.YAt = function (ret, index, layerparam)
	{
		index = Math.floor(index);
		if (index < 0 || index >= this.touches.length)
		{
			ret.set_float(0);
			return;
		}
		var layer, oldScale, oldZoomRate, oldParallaxY, oldAngle;
		if (cr.is_undefined(layerparam))
		{
			layer = this.runtime.getLayerByNumber(0);
			oldScale = layer.scale;
			oldZoomRate = layer.zoomRate;
			oldParallaxY = layer.parallaxY;
			oldAngle = layer.angle;
			layer.scale = this.runtime.running_layout.scale;
			layer.zoomRate = 1.0;
			layer.parallaxY = 1.0;
			layer.angle = this.runtime.running_layout.angle;
			ret.set_float(layer.canvasToLayer(this.touches[index].x, this.touches[index].y, false));
			layer.scale = oldScale;
			layer.zoomRate = oldZoomRate;
			layer.parallaxY = oldParallaxY;
			layer.angle = oldAngle;
		}
		else
		{
			if (cr.is_number(layerparam))
				layer = this.runtime.getLayerByNumber(layerparam);
			else
				layer = this.runtime.getLayerByName(layerparam);
			if (layer)
				ret.set_float(layer.canvasToLayer(this.touches[index].x, this.touches[index].y, false));
			else
				ret.set_float(0);
		}
	};
	Exps.prototype.YForID = function (ret, id, layerparam)
	{
		var index = this.findTouch(id);
		if (index < 0)
		{
			ret.set_float(0);
			return;
		}
		var touch = this.touches[index];
		var layer, oldScale, oldZoomRate, oldParallaxY, oldAngle;
		if (cr.is_undefined(layerparam))
		{
			layer = this.runtime.getLayerByNumber(0);
			oldScale = layer.scale;
			oldZoomRate = layer.zoomRate;
			oldParallaxY = layer.parallaxY;
			oldAngle = layer.angle;
			layer.scale = this.runtime.running_layout.scale;
			layer.zoomRate = 1.0;
			layer.parallaxY = 1.0;
			layer.angle = this.runtime.running_layout.angle;
			ret.set_float(layer.canvasToLayer(touch.x, touch.y, false));
			layer.scale = oldScale;
			layer.zoomRate = oldZoomRate;
			layer.parallaxY = oldParallaxY;
			layer.angle = oldAngle;
		}
		else
		{
			if (cr.is_number(layerparam))
				layer = this.runtime.getLayerByNumber(layerparam);
			else
				layer = this.runtime.getLayerByName(layerparam);
			if (layer)
				ret.set_float(layer.canvasToLayer(touch.x, touch.y, false));
			else
				ret.set_float(0);
		}
	};
	Exps.prototype.AbsoluteX = function (ret)
	{
		if (this.touches.length)
			ret.set_float(this.touches[0].x);
		else
			ret.set_float(0);
	};
	Exps.prototype.AbsoluteXAt = function (ret, index)
	{
		index = Math.floor(index);
		if (index < 0 || index >= this.touches.length)
		{
			ret.set_float(0);
			return;
		}
		ret.set_float(this.touches[index].x);
	};
	Exps.prototype.AbsoluteXForID = function (ret, id)
	{
		var index = this.findTouch(id);
		if (index < 0)
		{
			ret.set_float(0);
			return;
		}
		var touch = this.touches[index];
		ret.set_float(touch.x);
	};
	Exps.prototype.AbsoluteY = function (ret)
	{
		if (this.touches.length)
			ret.set_float(this.touches[0].y);
		else
			ret.set_float(0);
	};
	Exps.prototype.AbsoluteYAt = function (ret, index)
	{
		index = Math.floor(index);
		if (index < 0 || index >= this.touches.length)
		{
			ret.set_float(0);
			return;
		}
		ret.set_float(this.touches[index].y);
	};
	Exps.prototype.AbsoluteYForID = function (ret, id)
	{
		var index = this.findTouch(id);
		if (index < 0)
		{
			ret.set_float(0);
			return;
		}
		var touch = this.touches[index];
		ret.set_float(touch.y);
	};
	Exps.prototype.SpeedAt = function (ret, index)
	{
		index = Math.floor(index);
		if (index < 0 || index >= this.touches.length)
		{
			ret.set_float(0);
			return;
		}
		var t = this.touches[index];
		var dist = cr.distanceTo(t.x, t.y, t.lastx, t.lasty);
		var timediff = (t.time - t.lasttime) / 1000;
		if (timediff === 0)
			ret.set_float(0);
		else
			ret.set_float(dist / timediff);
	};
	Exps.prototype.SpeedForID = function (ret, id)
	{
		var index = this.findTouch(id);
		if (index < 0)
		{
			ret.set_float(0);
			return;
		}
		var touch = this.touches[index];
		var dist = cr.distanceTo(touch.x, touch.y, touch.lastx, touch.lasty);
		var timediff = (touch.time - touch.lasttime) / 1000;
		if (timediff === 0)
			ret.set_float(0);
		else
			ret.set_float(dist / timediff);
	};
	Exps.prototype.AngleAt = function (ret, index)
	{
		index = Math.floor(index);
		if (index < 0 || index >= this.touches.length)
		{
			ret.set_float(0);
			return;
		}
		var t = this.touches[index];
		ret.set_float(cr.to_degrees(cr.angleTo(t.lastx, t.lasty, t.x, t.y)));
	};
	Exps.prototype.AngleForID = function (ret, id)
	{
		var index = this.findTouch(id);
		if (index < 0)
		{
			ret.set_float(0);
			return;
		}
		var touch = this.touches[index];
		ret.set_float(cr.to_degrees(cr.angleTo(touch.lastx, touch.lasty, touch.x, touch.y)));
	};
	Exps.prototype.Alpha = function (ret)
	{
		ret.set_float(this.getAlpha());
	};
	Exps.prototype.Beta = function (ret)
	{
		ret.set_float(this.getBeta());
	};
	Exps.prototype.Gamma = function (ret)
	{
		ret.set_float(this.getGamma());
	};
	Exps.prototype.AccelerationXWithG = function (ret)
	{
		ret.set_float(this.acc_g_x);
	};
	Exps.prototype.AccelerationYWithG = function (ret)
	{
		ret.set_float(this.acc_g_y);
	};
	Exps.prototype.AccelerationZWithG = function (ret)
	{
		ret.set_float(this.acc_g_z);
	};
	Exps.prototype.AccelerationX = function (ret)
	{
		ret.set_float(this.acc_x);
	};
	Exps.prototype.AccelerationY = function (ret)
	{
		ret.set_float(this.acc_y);
	};
	Exps.prototype.AccelerationZ = function (ret)
	{
		ret.set_float(this.acc_z);
	};
	Exps.prototype.TouchIndex = function (ret)
	{
		ret.set_int(this.trigger_index);
	};
	Exps.prototype.TouchID = function (ret)
	{
		ret.set_float(this.trigger_id);
	};
	pluginProto.exps = new Exps();
}());
;
;
cr.plugins_.WebStorage = function(runtime)
{
	this.runtime = runtime;
};
(function()
{
	var pluginProto = cr.plugins_.WebStorage.prototype;
	pluginProto.Type = function(plugin)
	{
		this.plugin = plugin;
		this.runtime = plugin.runtime;
	};
	var typeProto = pluginProto.Type.prototype;
	typeProto.onCreate = function()
	{
	};
	pluginProto.Instance = function(type)
	{
		this.type = type;
		this.runtime = type.runtime;
	};
	var instanceProto = pluginProto.Instance.prototype;
	var prefix = "";
	var is_arcade = (typeof window["is_scirra_arcade"] !== "undefined");
	if (is_arcade)
		prefix = "arcade" + window["scirra_arcade_id"];
	var logged_sessionnotsupported = false;
	function LogSessionNotSupported()
	{
		if (logged_sessionnotsupported)
			return;
		cr.logexport("[Construct 2] Webstorage plugin: session storage is not supported on this platform. Try using local storage or global variables instead.");
		logged_sessionnotsupported = true;
	};
	instanceProto.onCreate = function()
	{
	};
	function Cnds() {};
	Cnds.prototype.LocalStorageEnabled = function()
	{
		return true;
	};
	Cnds.prototype.SessionStorageEnabled = function()
	{
		return true;
	};
	Cnds.prototype.LocalStorageExists = function(key)
	{
		return localStorage.getItem(prefix + key) != null;
	};
	Cnds.prototype.SessionStorageExists = function(key)
	{
		if (this.runtime.isCocoonJs || !sessionStorage)
		{
			LogSessionNotSupported();
			return false;
		}
		return sessionStorage.getItem(prefix + key) != null;
	};
	Cnds.prototype.OnQuotaExceeded = function ()
	{
		return true;
	};
	Cnds.prototype.CompareKeyText = function (key, text_to_compare, case_sensitive)
	{
		var value = localStorage.getItem(prefix + key) || "";
		if (case_sensitive)
			return value == text_to_compare;
		else
			return cr.equals_nocase(value, text_to_compare);
	};
	Cnds.prototype.CompareKeyNumber = function (key, cmp, x)
	{
		var value = localStorage.getItem(prefix + key) || "";
		return cr.do_cmp(parseFloat(value), cmp, x);
	};
	pluginProto.cnds = new Cnds();
	function Acts() {};
	Acts.prototype.StoreLocal = function(key, data)
	{
		try {
			localStorage.setItem(prefix + key, data);
		}
		catch (e)
		{
			this.runtime.trigger(cr.plugins_.WebStorage.prototype.cnds.OnQuotaExceeded, this);
		}
	};
	Acts.prototype.StoreSession = function(key,data)
	{
		if (this.runtime.isCocoonJs || !sessionStorage)
		{
			LogSessionNotSupported();
			return;
		}
		try {
			sessionStorage.setItem(prefix + key, data);
		}
		catch (e)
		{
			this.runtime.trigger(cr.plugins_.WebStorage.prototype.cnds.OnQuotaExceeded, this);
		}
	};
	Acts.prototype.RemoveLocal = function(key)
	{
		localStorage.removeItem(prefix + key);
	};
	Acts.prototype.RemoveSession = function(key)
	{
		if (this.runtime.isCocoonJs || !sessionStorage)
		{
			LogSessionNotSupported();
			return;
		}
		sessionStorage.removeItem(prefix + key);
	};
	Acts.prototype.ClearLocal = function()
	{
		if (!is_arcade)
			localStorage.clear();
	};
	Acts.prototype.ClearSession = function()
	{
		if (this.runtime.isCocoonJs || !sessionStorage)
		{
			LogSessionNotSupported();
			return;
		}
		if (!is_arcade)
			sessionStorage.clear();
	};
	Acts.prototype.JSONLoad = function (json_, mode_)
	{
		var d;
		try {
			d = JSON.parse(json_);
		}
		catch(e) { return; }
		if (!d["c2dictionary"])			// presumably not a c2dictionary object
			return;
		var o = d["data"];
		if (mode_ === 0 && !is_arcade)	// 'set' mode: must clear webstorage first
			localStorage.clear();
		var p;
		for (p in o)
		{
			if (o.hasOwnProperty(p))
			{
				try {
					localStorage.setItem(prefix + p, o[p]);
				}
				catch (e)
				{
					this.runtime.trigger(cr.plugins_.WebStorage.prototype.cnds.OnQuotaExceeded, this);
					return;
				}
			}
		}
	};
	pluginProto.acts = new Acts();
	function Exps() {};
	Exps.prototype.LocalValue = function(ret,key)
	{
		ret.set_string(localStorage.getItem(prefix + key) || "");
	};
	Exps.prototype.SessionValue = function(ret,key)
	{
		if (this.runtime.isCocoonJs || !sessionStorage)
		{
			LogSessionNotSupported();
			ret.set_string("");
			return;
		}
		ret.set_string(sessionStorage.getItem(prefix + key) || "");
	};
	Exps.prototype.LocalCount = function(ret)
	{
		ret.set_int(is_arcade ? 0 : localStorage.length);
	};
	Exps.prototype.SessionCount = function(ret)
	{
		if (this.runtime.isCocoonJs || !sessionStorage)
		{
			LogSessionNotSupported();
			ret.set_int(0);
			return;
		}
		ret.set_int(is_arcade ? 0 : sessionStorage.length);
	};
	Exps.prototype.LocalAt = function(ret,n)
	{
		if (is_arcade)
			ret.set_string("");
		else
			ret.set_string(localStorage.getItem(localStorage.key(n)) || "");
	};
	Exps.prototype.SessionAt = function(ret,n)
	{
		if (this.runtime.isCocoonJs || !sessionStorage)
		{
			LogSessionNotSupported();
			ret.set_string("");
			return;
		}
		if (is_arcade)
			ret.set_string("");
		else
			ret.set_string(sessionStorage.getItem(sessionStorage.key(n)) || "");
	};
	Exps.prototype.LocalKeyAt = function(ret,n)
	{
		if (is_arcade)
			ret.set_string("");
		else
			ret.set_string(localStorage.key(n) || "");
	};
	Exps.prototype.SessionKeyAt = function(ret,n)
	{
		if (this.runtime.isCocoonJs || !sessionStorage)
		{
			LogSessionNotSupported();
			ret.set_string("");
			return;
		}
		if (is_arcade)
			ret.set_string("");
		else
			ret.set_string(sessionStorage.key(n) || "");
	};
	Exps.prototype.AsJSON = function (ret)
	{
		var o = {}, i, len, k;
		for (i = 0, len = localStorage.length; i < len; i++)
		{
			k = localStorage.key(i);
			if (is_arcade)
			{
				if (k.substr(0, prefix.length) === prefix)
				{
					o[k.substr(prefix.length)] = localStorage.getItem(k);
				}
			}
			else
				o[k] = localStorage.getItem(k);
		}
		ret.set_string(JSON.stringify({
			"c2dictionary": true,
			"data": o
		}));
	};
	pluginProto.exps = new Exps();
}());
;
;
cr.behaviors.Anchor = function(runtime)
{
	this.runtime = runtime;
};
(function ()
{
	var behaviorProto = cr.behaviors.Anchor.prototype;
	behaviorProto.Type = function(behavior, objtype)
	{
		this.behavior = behavior;
		this.objtype = objtype;
		this.runtime = behavior.runtime;
	};
	var behtypeProto = behaviorProto.Type.prototype;
	behtypeProto.onCreate = function()
	{
	};
	behaviorProto.Instance = function(type, inst)
	{
		this.type = type;
		this.behavior = type.behavior;
		this.inst = inst;				// associated object instance to modify
		this.runtime = type.runtime;
	};
	var behinstProto = behaviorProto.Instance.prototype;
	behinstProto.onCreate = function()
	{
		this.anch_left = this.properties[0];		// 0 = left, 1 = right
		this.anch_top = this.properties[1];			// 0 = top, 1 = bottom
		this.anch_right = this.properties[2];		// 0 = none, 1 = right
		this.anch_bottom = this.properties[3];		// 0 = none, 1 = bottom
		this.inst.update_bbox();
		this.xleft = this.inst.bbox.left;
		this.ytop = this.inst.bbox.top;
		this.xright = this.runtime.original_width - this.inst.bbox.left;
		this.ybottom = this.runtime.original_height - this.inst.bbox.top;
		this.rdiff = this.runtime.original_width - this.inst.bbox.right;
		this.bdiff = this.runtime.original_height - this.inst.bbox.bottom;
		this.enabled = (this.properties[4] !== 0);
	};
	behinstProto.saveToJSON = function ()
	{
		return {
			"xleft": this.xleft,
			"ytop": this.ytop,
			"xright": this.xright,
			"ybottom": this.ybottom,
			"rdiff": this.rdiff,
			"bdiff": this.bdiff,
			"enabled": this.enabled
		};
	};
	behinstProto.loadFromJSON = function (o)
	{
		this.xleft = o["xleft"];
		this.ytop = o["ytop"];
		this.xright = o["xright"];
		this.ybottom = o["ybottom"];
		this.rdiff = o["rdiff"];
		this.bdiff = o["bdiff"];
		this.enabled = o["enabled"];
	};
	behinstProto.tick = function ()
	{
		if (!this.enabled)
			return;
		var n;
		var layer = this.inst.layer;
		var inst = this.inst;
		var bbox = this.inst.bbox;
		if (this.anch_left === 0)
		{
			inst.update_bbox();
			n = (layer.viewLeft + this.xleft) - bbox.left;
			if (n !== 0)
			{
				inst.x += n;
				inst.set_bbox_changed();
			}
		}
		else if (this.anch_left === 1)
		{
			inst.update_bbox();
			n = (layer.viewRight - this.xright) - bbox.left;
			if (n !== 0)
			{
				inst.x += n;
				inst.set_bbox_changed();
			}
		}
		if (this.anch_top === 0)
		{
			inst.update_bbox();
			n = (layer.viewTop + this.ytop) - bbox.top;
			if (n !== 0)
			{
				inst.y += n;
				inst.set_bbox_changed();
			}
		}
		else if (this.anch_top === 1)
		{
			inst.update_bbox();
			n = (layer.viewBottom - this.ybottom) - bbox.top;
			if (n !== 0)
			{
				inst.y += n;
				inst.set_bbox_changed();
			}
		}
		if (this.anch_right === 1)
		{
			inst.update_bbox();
			n = (layer.viewRight - this.rdiff) - bbox.right;
			if (n !== 0)
			{
				inst.width += n;
				if (inst.width < 0)
					inst.width = 0;
				inst.set_bbox_changed();
			}
		}
		if (this.anch_bottom === 1)
		{
			inst.update_bbox();
			n = (layer.viewBottom - this.bdiff) - bbox.bottom;
			if (n !== 0)
			{
				inst.height += n;
				if (inst.height < 0)
					inst.height = 0;
				inst.set_bbox_changed();
			}
		}
	};
	function Cnds() {};
	behaviorProto.cnds = new Cnds();
	function Acts() {};
	Acts.prototype.SetEnabled = function (e)
	{
		if (this.enabled && e === 0)
			this.enabled = false;
		else if (!this.enabled && e !== 0)
		{
			this.inst.update_bbox();
			this.xleft = this.inst.bbox.left;
			this.ytop = this.inst.bbox.top;
			this.xright = this.runtime.original_width - this.inst.bbox.left;
			this.ybottom = this.runtime.original_height - this.inst.bbox.top;
			this.rdiff = this.runtime.original_width - this.inst.bbox.right;
			this.bdiff = this.runtime.original_height - this.inst.bbox.bottom;
			this.enabled = true;
		}
	};
	behaviorProto.acts = new Acts();
	function Exps() {};
	behaviorProto.exps = new Exps();
}());
;
;
cr.behaviors.Bullet = function(runtime)
{
	this.runtime = runtime;
};
(function ()
{
	var behaviorProto = cr.behaviors.Bullet.prototype;
	behaviorProto.Type = function(behavior, objtype)
	{
		this.behavior = behavior;
		this.objtype = objtype;
		this.runtime = behavior.runtime;
	};
	var behtypeProto = behaviorProto.Type.prototype;
	behtypeProto.onCreate = function()
	{
	};
	behaviorProto.Instance = function(type, inst)
	{
		this.type = type;
		this.behavior = type.behavior;
		this.inst = inst;				// associated object instance to modify
		this.runtime = type.runtime;
	};
	var behinstProto = behaviorProto.Instance.prototype;
	behinstProto.onCreate = function()
	{
		var speed = this.properties[0];
		this.acc = this.properties[1];
		this.g = this.properties[2];
		this.bounceOffSolid = (this.properties[3] !== 0);
		this.setAngle = (this.properties[4] !== 0);
		this.dx = Math.cos(this.inst.angle) * speed;
		this.dy = Math.sin(this.inst.angle) * speed;
		this.lastx = this.inst.x;
		this.lasty = this.inst.y;
		this.lastKnownAngle = this.inst.angle;
		this.travelled = 0;
		this.enabled = (this.properties[5] !== 0);
	};
	behinstProto.saveToJSON = function ()
	{
		return {
			"acc": this.acc,
			"g": this.g,
			"dx": this.dx,
			"dy": this.dy,
			"lx": this.lastx,
			"ly": this.lasty,
			"lka": this.lastKnownAngle,
			"t": this.travelled,
			"e": this.enabled
		};
	};
	behinstProto.loadFromJSON = function (o)
	{
		this.acc = o["acc"];
		this.g = o["g"];
		this.dx = o["dx"];
		this.dy = o["dy"];
		this.lastx = o["lx"];
		this.lasty = o["ly"];
		this.lastKnownAngle = o["lka"];
		this.travelled = o["t"];
		this.enabled = o["e"];
	};
	behinstProto.tick = function ()
	{
		if (!this.enabled)
			return;
		var dt = this.runtime.getDt(this.inst);
		var s, a;
		var bounceSolid, bounceAngle;
		if (this.inst.angle !== this.lastKnownAngle)
		{
			if (this.setAngle)
			{
				s = cr.distanceTo(0, 0, this.dx, this.dy);
				this.dx = Math.cos(this.inst.angle) * s;
				this.dy = Math.sin(this.inst.angle) * s;
			}
			this.lastKnownAngle = this.inst.angle;
		}
		if (this.acc !== 0)
		{
			s = cr.distanceTo(0, 0, this.dx, this.dy);
			if (this.dx === 0 && this.dy === 0)
				a = this.inst.angle;
			else
				a = cr.angleTo(0, 0, this.dx, this.dy);
			s += this.acc * dt;
			if (s < 0)
				s = 0;
			this.dx = Math.cos(a) * s;
			this.dy = Math.sin(a) * s;
		}
		if (this.g !== 0)
			this.dy += this.g * dt;
		this.lastx = this.inst.x;
		this.lasty = this.inst.y;
		if (this.dx !== 0 || this.dy !== 0)
		{
			this.inst.x += this.dx * dt;
			this.inst.y += this.dy * dt;
			this.travelled += cr.distanceTo(0, 0, this.dx * dt, this.dy * dt)
			if (this.setAngle)
			{
				this.inst.angle = cr.angleTo(0, 0, this.dx, this.dy);
				this.inst.set_bbox_changed();
				this.lastKnownAngle = this.inst.angle;
			}
			this.inst.set_bbox_changed();
			if (this.bounceOffSolid)
			{
				bounceSolid = this.runtime.testOverlapSolid(this.inst);
				if (bounceSolid)
				{
					this.runtime.registerCollision(this.inst, bounceSolid);
					s = cr.distanceTo(0, 0, this.dx, this.dy);
					bounceAngle = this.runtime.calculateSolidBounceAngle(this.inst, this.lastx, this.lasty);
					this.dx = Math.cos(bounceAngle) * s;
					this.dy = Math.sin(bounceAngle) * s;
					this.inst.x += this.dx * dt;			// move out for one tick since the object can't have spent a tick in the solid
					this.inst.y += this.dy * dt;
					this.inst.set_bbox_changed();
					if (this.setAngle)
					{
						this.inst.angle = bounceAngle;
						this.lastKnownAngle = bounceAngle;
						this.inst.set_bbox_changed();
					}
					if (!this.runtime.pushOutSolid(this.inst, this.dx / s, this.dy / s, Math.max(s * 2.5 * dt, 30)))
						this.runtime.pushOutSolidNearest(this.inst, 100);
				}
			}
		}
	};
	function Cnds() {};
	Cnds.prototype.CompareSpeed = function (cmp, s)
	{
		return cr.do_cmp(cr.distanceTo(0, 0, this.dx, this.dy), cmp, s);
	};
	Cnds.prototype.CompareTravelled = function (cmp, d)
	{
		return cr.do_cmp(this.travelled, cmp, d);
	};
	behaviorProto.cnds = new Cnds();
	function Acts() {};
	Acts.prototype.SetSpeed = function (s)
	{
		var a = cr.angleTo(0, 0, this.dx, this.dy);
		this.dx = Math.cos(a) * s;
		this.dy = Math.sin(a) * s;
	};
	Acts.prototype.SetAcceleration = function (a)
	{
		this.acc = a;
	};
	Acts.prototype.SetGravity = function (g)
	{
		this.g = g;
	};
	Acts.prototype.SetAngleOfMotion = function (a)
	{
		a = cr.to_radians(a);
		var s = cr.distanceTo(0, 0, this.dx, this.dy)
		this.dx = Math.cos(a) * s;
		this.dy = Math.sin(a) * s;
	};
	Acts.prototype.Bounce = function (objtype)
	{
		if (!objtype)
			return;
		var otherinst = objtype.getFirstPicked(this.inst);
		if (!otherinst)
			return;
		var dt = this.runtime.getDt(this.inst);
		var s = cr.distanceTo(0, 0, this.dx, this.dy);
		var bounceAngle = this.runtime.calculateSolidBounceAngle(this.inst, this.lastx, this.lasty, otherinst);
		this.dx = Math.cos(bounceAngle) * s;
		this.dy = Math.sin(bounceAngle) * s;
		this.inst.x += this.dx * dt;			// move out for one tick since the object can't have spent a tick in the solid
		this.inst.y += this.dy * dt;
		this.inst.set_bbox_changed();
		if (this.setAngle)
		{
			this.inst.angle = bounceAngle;
			this.lastKnownAngle = bounceAngle;
			this.inst.set_bbox_changed();
		}
		if (this.bounceOffSolid)
		{
			if (!this.runtime.pushOutSolid(this.inst, this.dx / s, this.dy / s, Math.max(s * 2.5 * dt, 30)))
				this.runtime.pushOutSolidNearest(this.inst, 100);
		}
		else
		{
			this.runtime.pushOut(this.inst, this.dx / s, this.dy / s, Math.max(s * 2.5 * dt, 30), otherinst)
		}
	};
	Acts.prototype.SetEnabled = function (en)
	{
		this.enabled = (en === 1);
	};
	behaviorProto.acts = new Acts();
	function Exps() {};
	Exps.prototype.Speed = function (ret)
	{
		var s = cr.distanceTo(0, 0, this.dx, this.dy);
		s = cr.round6dp(s);
		ret.set_float(s);
	};
	Exps.prototype.Acceleration = function (ret)
	{
		ret.set_float(this.acc);
	};
	Exps.prototype.AngleOfMotion = function (ret)
	{
		ret.set_float(cr.to_degrees(cr.angleTo(0, 0, this.dx, this.dy)));
	};
	Exps.prototype.DistanceTravelled = function (ret)
	{
		ret.set_float(this.travelled);
	};
	behaviorProto.exps = new Exps();
}());
;
;
cr.behaviors.Platform = function(runtime)
{
	this.runtime = runtime;
};
(function ()
{
	var behaviorProto = cr.behaviors.Platform.prototype;
	behaviorProto.Type = function(behavior, objtype)
	{
		this.behavior = behavior;
		this.objtype = objtype;
		this.runtime = behavior.runtime;
	};
	var behtypeProto = behaviorProto.Type.prototype;
	behtypeProto.onCreate = function()
	{
	};
	var ANIMMODE_STOPPED = 0;
	var ANIMMODE_MOVING = 1;
	var ANIMMODE_JUMPING = 2;
	var ANIMMODE_FALLING = 3;
	behaviorProto.Instance = function(type, inst)
	{
		this.type = type;
		this.behavior = type.behavior;
		this.inst = inst;				// associated object instance to modify
		this.runtime = type.runtime;
		this.leftkey = false;
		this.rightkey = false;
		this.jumpkey = false;
		this.jumped = false;			// prevent bunnyhopping
		this.ignoreInput = false;
		this.simleft = false;
		this.simright = false;
		this.simjump = false;
		this.lastFloorObject = null;
		this.loadFloorObject = -1;
		this.lastFloorX = 0;
		this.lastFloorY = 0;
		this.floorIsJumpthru = false;
		this.animMode = ANIMMODE_STOPPED;
		this.fallthrough = 0;			// fall through jump-thru.  >0 to disable, lasts a few ticks
		this.firstTick = true;
		this.dx = 0;
		this.dy = 0;
	};
	var behinstProto = behaviorProto.Instance.prototype;
	behinstProto.updateGravity = function()
	{
		this.downx = Math.cos(this.ga);
		this.downy = Math.sin(this.ga);
		this.rightx = Math.cos(this.ga - Math.PI / 2);
		this.righty = Math.sin(this.ga - Math.PI / 2);
		this.downx = cr.round6dp(this.downx);
		this.downy = cr.round6dp(this.downy);
		this.rightx = cr.round6dp(this.rightx);
		this.righty = cr.round6dp(this.righty);
		this.g1 = this.g;
		if (this.g < 0)
		{
			this.downx *= -1;
			this.downy *= -1;
			this.g = Math.abs(this.g);
		}
	};
	behinstProto.onCreate = function()
	{
		this.maxspeed = this.properties[0];
		this.acc = this.properties[1];
		this.dec = this.properties[2];
		this.jumpStrength = this.properties[3];
		this.g = this.properties[4];
		this.g1 = this.g;
		this.maxFall = this.properties[5];
		this.defaultControls = (this.properties[6] === 1);	// 0=no, 1=yes
		this.enabled = (this.properties[7] !== 0);
		this.wasOnFloor = false;
		this.wasOverJumpthru = this.runtime.testOverlapJumpThru(this.inst);
		this.ga = cr.to_radians(90);
		this.updateGravity();
		var self = this;
		if (this.defaultControls && !this.runtime.isDomFree)
		{
			jQuery(document).keydown(function(info) {
						self.onKeyDown(info);
					});
			jQuery(document).keyup(function(info) {
						self.onKeyUp(info);
					});
		}
		if (!this.recycled)
		{
			this.myDestroyCallback = function(inst) {
										self.onInstanceDestroyed(inst);
									};
		}
		this.runtime.addDestroyCallback(this.myDestroyCallback);
	};
	behinstProto.saveToJSON = function ()
	{
		return {
			"ii": this.ignoreInput,
			"lfx": this.lastFloorX,
			"lfy": this.lastFloorY,
			"lfo": (this.lastFloorObject ? this.lastFloorObject.uid : -1),
			"am": this.animMode,
			"en": this.enabled,
			"fall": this.fallthrough,
			"ft": this.firstTick,
			"dx": this.dx,
			"dy": this.dy,
			"ms": this.maxspeed,
			"acc": this.acc,
			"dec": this.dec,
			"js": this.jumpStrength,
			"g": this.g,
			"g1": this.g1,
			"mf": this.maxFall,
			"wof": this.wasOnFloor,
			"woj": this.wasOverJumpthru,
			"ga": this.ga
		};
	};
	behinstProto.loadFromJSON = function (o)
	{
		this.ignoreInput = o["ii"];
		this.lastFloorX = o["lfx"];
		this.lastFloorY = o["lfy"];
		this.loadFloorObject = o["lfo"];
		this.animMode = o["am"];
		this.enabled = o["en"];
		this.fallthrough = o["fall"];
		this.firstTick = o["ft"];
		this.dx = o["dx"];
		this.dy = o["dy"];
		this.maxspeed = o["ms"];
		this.acc = o["acc"];
		this.dec = o["dec"];
		this.jumpStrength = o["js"];
		this.g = o["g"];
		this.g1 = o["g1"];
		this.maxFall = o["mf"];
		this.wasOnFloor = o["wof"];
		this.wasOverJumpthru = o["woj"];
		this.ga = o["ga"];
		this.leftkey = false;
		this.rightkey = false;
		this.jumpkey = false;
		this.jumped = false;
		this.simleft = false;
		this.simright = false;
		this.simjump = false;
		this.updateGravity();
	};
	behinstProto.afterLoad = function ()
	{
		if (this.loadFloorObject === -1)
			this.lastFloorObject = null;
		else
			this.lastFloorObject = this.runtime.getObjectByUID(this.loadFloorObject);
	};
	behinstProto.onInstanceDestroyed = function (inst)
	{
		if (this.lastFloorObject == inst)
			this.lastFloorObject = null;
	};
	behinstProto.onDestroy = function ()
	{
		this.lastFloorObject = null;
		this.runtime.removeDestroyCallback(this.myDestroyCallback);
	};
	behinstProto.onKeyDown = function (info)
	{
		switch (info.which) {
		case 38:	// up
			info.preventDefault();
			this.jumpkey = true;
			break;
		case 37:	// left
			info.preventDefault();
			this.leftkey = true;
			break;
		case 39:	// right
			info.preventDefault();
			this.rightkey = true;
			break;
		}
	};
	behinstProto.onKeyUp = function (info)
	{
		switch (info.which) {
		case 38:	// up
			info.preventDefault();
			this.jumpkey = false;
			this.jumped = false;
			break;
		case 37:	// left
			info.preventDefault();
			this.leftkey = false;
			break;
		case 39:	// right
			info.preventDefault();
			this.rightkey = false;
			break;
		}
	};
	behinstProto.getGDir = function ()
	{
		if (this.g < 0)
			return -1;
		else
			return 1;
	};
	behinstProto.isOnFloor = function ()
	{
		var ret = null;
		var ret2 = null;
		var i, len, j;
		var oldx = this.inst.x;
		var oldy = this.inst.y;
		this.inst.x += this.downx;
		this.inst.y += this.downy;
		this.inst.set_bbox_changed();
		if (this.lastFloorObject && this.runtime.testOverlap(this.inst, this.lastFloorObject))
		{
			this.inst.x = oldx;
			this.inst.y = oldy;
			this.inst.set_bbox_changed();
			return this.lastFloorObject;
		}
		else
		{
			ret = this.runtime.testOverlapSolid(this.inst);
			if (!ret && this.fallthrough === 0)
				ret2 = this.runtime.testOverlapJumpThru(this.inst, true);
			this.inst.x = oldx;
			this.inst.y = oldy;
			this.inst.set_bbox_changed();
			if (ret)		// was overlapping solid
			{
				if (this.runtime.testOverlap(this.inst, ret))
					return null;
				else
				{
					this.floorIsJumpthru = false;
					return ret;
				}
			}
			if (ret2 && ret2.length)
			{
				for (i = 0, j = 0, len = ret2.length; i < len; i++)
				{
					ret2[j] = ret2[i];
					if (!this.runtime.testOverlap(this.inst, ret2[i]))
						j++;
				}
				if (j >= 1)
				{
					this.floorIsJumpthru = true;
					return ret2[0];
				}
			}
			return null;
		}
	};
	behinstProto.tick = function ()
	{
	};
	behinstProto.posttick = function ()
	{
		var dt = this.runtime.getDt(this.inst);
		var mx, my, obstacle, mag, allover, i, len, j, oldx, oldy;
		if (!this.jumpkey && !this.simjump)
			this.jumped = false;
		var left = this.leftkey || this.simleft;
		var right = this.rightkey || this.simright;
		var jump = (this.jumpkey || this.simjump) && !this.jumped;
		this.simleft = false;
		this.simright = false;
		this.simjump = false;
		if (!this.enabled)
			return;
		if (this.ignoreInput)
		{
			left = false;
			right = false;
			jump = false;
		}
		var lastFloor = this.lastFloorObject;
		var floor_moved = false;
		if (this.firstTick)
		{
			if (this.runtime.testOverlapSolid(this.inst) || this.runtime.testOverlapJumpThru(this.inst))
			{
				this.runtime.pushOutSolid(this.inst, -this.downx, -this.downy, 4, true);
			}
			this.firstTick = false;
		}
		if (lastFloor && this.dy === 0 && (lastFloor.y !== this.lastFloorY || lastFloor.x !== this.lastFloorX))
		{
			mx = (lastFloor.x - this.lastFloorX);
			my = (lastFloor.y - this.lastFloorY);
			this.inst.x += mx;
			this.inst.y += my;
			this.inst.set_bbox_changed();
			this.lastFloorX = lastFloor.x;
			this.lastFloorY = lastFloor.y;
			floor_moved = true;
			if (this.runtime.testOverlapSolid(this.inst))
			{
				this.runtime.pushOutSolid(this.inst, -mx, -my, Math.sqrt(mx * mx + my * my) * 2.5);
			}
		}
		var floor_ = this.isOnFloor();
		var collobj = this.runtime.testOverlapSolid(this.inst);
		if (collobj)
		{
			if (this.runtime.pushOutSolidNearest(this.inst, Math.max(this.inst.width, this.inst.height) / 2))
				this.runtime.registerCollision(this.inst, collobj);
			else
				return;
		}
		if (floor_)
		{
			if (this.dy > 0)
			{
				if (!this.wasOnFloor)
				{
					this.runtime.pushInFractional(this.inst, -this.downx, -this.downy, floor_, 16);
					this.wasOnFloor = true;
				}
				this.dy = 0;
			}
			if (lastFloor != floor_)
			{
				this.lastFloorObject = floor_;
				this.lastFloorX = floor_.x;
				this.lastFloorY = floor_.y;
				this.runtime.registerCollision(this.inst, floor_);
			}
			else if (floor_moved)
			{
				collobj = this.runtime.testOverlapSolid(this.inst);
				if (collobj)
				{
					this.runtime.registerCollision(this.inst, collobj);
					if (mx !== 0)
					{
						if (mx > 0)
							this.runtime.pushOutSolid(this.inst, -this.rightx, -this.righty);
						else
							this.runtime.pushOutSolid(this.inst, this.rightx, this.righty);
					}
					this.runtime.pushOutSolid(this.inst, -this.downx, -this.downy);
				}
			}
			if (jump)
			{
				oldx = this.inst.x;
				oldy = this.inst.y;
				this.inst.x -= this.downx;
				this.inst.y -= this.downy;
				this.inst.set_bbox_changed();
				if (!this.runtime.testOverlapSolid(this.inst))
				{
					this.runtime.trigger(cr.behaviors.Platform.prototype.cnds.OnJump, this.inst);
					this.animMode = ANIMMODE_JUMPING;
					this.dy = -this.jumpStrength;
					this.jumped = true;
				}
				else
					jump = false;
				this.inst.x = oldx;
				this.inst.y = oldy;
				this.inst.set_bbox_changed();
			}
		}
		else
		{
			this.lastFloorObject = null;
			this.dy += this.g * dt;
			if (this.dy > this.maxFall)
				this.dy = this.maxFall;
			if (jump)
				this.jumped = true;
		}
		this.wasOnFloor = !!floor_;
		if (left == right)	// both up or both down
		{
			if (this.dx < 0)
			{
				this.dx += this.dec * dt;
				if (this.dx > 0)
					this.dx = 0;
			}
			else if (this.dx > 0)
			{
				this.dx -= this.dec * dt;
				if (this.dx < 0)
					this.dx = 0;
			}
		}
		if (left && !right)
		{
			if (this.dx > 0)
				this.dx -= (this.acc + this.dec) * dt;
			else
				this.dx -= this.acc * dt;
		}
		if (right && !left)
		{
			if (this.dx < 0)
				this.dx += (this.acc + this.dec) * dt;
			else
				this.dx += this.acc * dt;
		}
		if (this.dx > this.maxspeed)
			this.dx = this.maxspeed;
		else if (this.dx < -this.maxspeed)
			this.dx = -this.maxspeed;
		var landed = false;
		if (this.dx !== 0)
		{
			oldx = this.inst.x;
			oldy = this.inst.y;
			mx = this.dx * dt * this.rightx;
			my = this.dx * dt * this.righty;
			this.inst.x += this.rightx * (this.dx > 1 ? 1 : -1) - this.downx;
			this.inst.y += this.righty * (this.dx > 1 ? 1 : -1) - this.downy;
			this.inst.set_bbox_changed();
			var is_jumpthru = false;
			var slope_too_steep = this.runtime.testOverlapSolid(this.inst);
			/*
			if (!slope_too_steep && floor_)
			{
				slope_too_steep = this.runtime.testOverlapJumpThru(this.inst);
				is_jumpthru = true;
				if (slope_too_steep)
				{
					this.inst.x = oldx;
					this.inst.y = oldy;
					this.inst.set_bbox_changed();
					if (this.runtime.testOverlap(this.inst, slope_too_steep))
					{
						slope_too_steep = null;
						is_jumpthru = false;
					}
				}
			}
			*/
			this.inst.x = oldx + mx;
			this.inst.y = oldy + my;
			this.inst.set_bbox_changed();
			obstacle = this.runtime.testOverlapSolid(this.inst);
			if (!obstacle && floor_)
			{
				obstacle = this.runtime.testOverlapJumpThru(this.inst);
				if (obstacle)
				{
					this.inst.x = oldx;
					this.inst.y = oldy;
					this.inst.set_bbox_changed();
					if (this.runtime.testOverlap(this.inst, obstacle))
					{
						obstacle = null;
						is_jumpthru = false;
					}
					else
						is_jumpthru = true;
					this.inst.x = oldx + mx;
					this.inst.y = oldy + my;
					this.inst.set_bbox_changed();
				}
			}
			if (obstacle)
			{
				var push_dist = Math.abs(this.dx * dt) + 2;
				if (slope_too_steep || !this.runtime.pushOutSolid(this.inst, -this.downx, -this.downy, push_dist, is_jumpthru, obstacle))
				{
					this.runtime.registerCollision(this.inst, obstacle);
					push_dist = Math.max(Math.abs(this.dx * dt * 2.5), 30);
					if (!this.runtime.pushOutSolid(this.inst, this.rightx * (this.dx < 0 ? 1 : -1), this.righty * (this.dx < 0 ? 1 : -1), push_dist, false))
					{
						this.inst.x = oldx;
						this.inst.y = oldy;
						this.inst.set_bbox_changed();
					}
					else if (floor_ && !is_jumpthru && !this.floorIsJumpthru)
					{
						oldx = this.inst.x;
						oldy = this.inst.y;
						this.inst.x += this.downx;
						this.inst.y += this.downy;
						if (this.runtime.testOverlapSolid(this.inst))
						{
							if (!this.runtime.pushOutSolid(this.inst, -this.downx, -this.downy, 3, false))
							{
								this.inst.x = oldx;
								this.inst.y = oldy;
								this.inst.set_bbox_changed();
							}
						}
						else
						{
							this.inst.x = oldx;
							this.inst.y = oldy;
							this.inst.set_bbox_changed();
						}
					}
					if (!is_jumpthru)
						this.dx = 0;	// stop
				}
				else if (!slope_too_steep && Math.abs(this.dy) < 15)
				{
					this.dy = 0;
					if (!floor_)
						landed = true;
				}
			}
			else
			{
				var newfloor = this.isOnFloor();
				if (floor_ && !newfloor)
				{
					mag = Math.ceil(Math.abs(this.dx * dt)) + 2;
					oldx = this.inst.x;
					oldy = this.inst.y;
					this.inst.x += this.downx * mag;
					this.inst.y += this.downy * mag;
					this.inst.set_bbox_changed();
					if (this.runtime.testOverlapSolid(this.inst) || this.runtime.testOverlapJumpThru(this.inst))
						this.runtime.pushOutSolid(this.inst, -this.downx, -this.downy, mag + 2, true);
					else
					{
						this.inst.x = oldx;
						this.inst.y = oldy;
						this.inst.set_bbox_changed();
					}
				}
				else if (newfloor && this.dy === 0)
				{
					this.runtime.pushInFractional(this.inst, -this.downx, -this.downy, newfloor, 16);
				}
			}
		}
		if (this.dy !== 0)
		{
			oldx = this.inst.x;
			oldy = this.inst.y;
			this.inst.x += this.dy * dt * this.downx;
			this.inst.y += this.dy * dt * this.downy;
			var newx = this.inst.x;
			var newy = this.inst.y;
			this.inst.set_bbox_changed();
			collobj = this.runtime.testOverlapSolid(this.inst);
			var fell_on_jumpthru = false;
			if (!collobj && (this.dy > 0) && !floor_)
			{
				allover = this.fallthrough > 0 ? null : this.runtime.testOverlapJumpThru(this.inst, true);
				if (allover && allover.length)
				{
					if (this.wasOverJumpthru)
					{
						this.inst.x = oldx;
						this.inst.y = oldy;
						this.inst.set_bbox_changed();
						for (i = 0, j = 0, len = allover.length; i < len; i++)
						{
							allover[j] = allover[i];
							if (!this.runtime.testOverlap(this.inst, allover[i]))
								j++;
						}
						allover.length = j;
						this.inst.x = newx;
						this.inst.y = newy;
						this.inst.set_bbox_changed();
					}
					if (allover.length >= 1)
						collobj = allover[0];
				}
				fell_on_jumpthru = !!collobj;
			}
			if (collobj)
			{
				this.runtime.registerCollision(this.inst, collobj);
				var push_dist = (fell_on_jumpthru ? Math.abs(this.dy * dt * 2.5 + 10) : Math.max(Math.abs(this.dy * dt * 2.5 + 10), 30));
				if (!this.runtime.pushOutSolid(this.inst, this.downx * (this.dy < 0 ? 1 : -1), this.downy * (this.dy < 0 ? 1 : -1), push_dist, fell_on_jumpthru, collobj))
				{
					this.inst.x = oldx;
					this.inst.y = oldy;
					this.inst.set_bbox_changed();
					this.wasOnFloor = true;		// prevent adjustment for unexpected floor landings
					if (!fell_on_jumpthru)
						this.dy = 0;	// stop
				}
				else
				{
					this.lastFloorObject = collobj;
					this.lastFloorX = collobj.x;
					this.lastFloorY = collobj.y;
					this.floorIsJumpthru = fell_on_jumpthru;
					if (fell_on_jumpthru)
						landed = true;
					this.dy = 0;	// stop
				}
			}
		}
		if (this.animMode !== ANIMMODE_FALLING && this.dy > 0 && !floor_)
		{
			this.runtime.trigger(cr.behaviors.Platform.prototype.cnds.OnFall, this.inst);
			this.animMode = ANIMMODE_FALLING;
		}
		if (floor_ || landed)
		{
			if (this.animMode === ANIMMODE_FALLING || landed || (jump && this.dy === 0))
			{
				this.runtime.trigger(cr.behaviors.Platform.prototype.cnds.OnLand, this.inst);
				if (this.dx === 0 && this.dy === 0)
					this.animMode = ANIMMODE_STOPPED;
				else
					this.animMode = ANIMMODE_MOVING;
			}
			else
			{
				if (this.animMode !== ANIMMODE_STOPPED && this.dx === 0 && this.dy === 0)
				{
					this.runtime.trigger(cr.behaviors.Platform.prototype.cnds.OnStop, this.inst);
					this.animMode = ANIMMODE_STOPPED;
				}
				if (this.animMode !== ANIMMODE_MOVING && (this.dx !== 0 || this.dy !== 0) && !jump)
				{
					this.runtime.trigger(cr.behaviors.Platform.prototype.cnds.OnMove, this.inst);
					this.animMode = ANIMMODE_MOVING;
				}
			}
		}
		if (this.fallthrough > 0)
			this.fallthrough--;
		this.wasOverJumpthru = this.runtime.testOverlapJumpThru(this.inst);
	};
	function Cnds() {};
	Cnds.prototype.IsMoving = function ()
	{
		return this.dx !== 0 || this.dy !== 0;
	};
	Cnds.prototype.CompareSpeed = function (cmp, s)
	{
		var speed = Math.sqrt(this.dx * this.dx + this.dy * this.dy);
		return cr.do_cmp(speed, cmp, s);
	};
	Cnds.prototype.IsOnFloor = function ()
	{
		if (this.dy !== 0)
			return false;
		var ret = null;
		var ret2 = null;
		var i, len, j;
		var oldx = this.inst.x;
		var oldy = this.inst.y;
		this.inst.x += this.downx;
		this.inst.y += this.downy;
		this.inst.set_bbox_changed();
		ret = this.runtime.testOverlapSolid(this.inst);
		if (!ret && this.fallthrough === 0)
			ret2 = this.runtime.testOverlapJumpThru(this.inst, true);
		this.inst.x = oldx;
		this.inst.y = oldy;
		this.inst.set_bbox_changed();
		if (ret)		// was overlapping solid
		{
			return !this.runtime.testOverlap(this.inst, ret);
		}
		if (ret2 && ret2.length)
		{
			for (i = 0, j = 0, len = ret2.length; i < len; i++)
			{
				ret2[j] = ret2[i];
				if (!this.runtime.testOverlap(this.inst, ret2[i]))
					j++;
			}
			if (j >= 1)
				return true;
		}
		return false;
	};
	Cnds.prototype.IsByWall = function (side)
	{
		var ret = false;
		var oldx = this.inst.x;
		var oldy = this.inst.y;
		this.inst.x -= this.downx * 3;
		this.inst.y -= this.downy * 3;
		this.inst.set_bbox_changed();
		if (this.runtime.testOverlapSolid(this.inst))
		{
			this.inst.x = oldx;
			this.inst.y = oldy;
			this.inst.set_bbox_changed();
			return false;
		}
		if (side === 0)		// left
		{
			this.inst.x -= this.rightx * 2;
			this.inst.y -= this.righty * 2;
		}
		else
		{
			this.inst.x += this.rightx * 2;
			this.inst.y += this.righty * 2;
		}
		this.inst.set_bbox_changed();
		ret = this.runtime.testOverlapSolid(this.inst);
		this.inst.x = oldx;
		this.inst.y = oldy;
		this.inst.set_bbox_changed();
		return ret;
	};
	Cnds.prototype.IsJumping = function ()
	{
		return this.dy < 0;
	};
	Cnds.prototype.IsFalling = function ()
	{
		return this.dy > 0;
	};
	Cnds.prototype.OnJump = function ()
	{
		return true;
	};
	Cnds.prototype.OnFall = function ()
	{
		return true;
	};
	Cnds.prototype.OnStop = function ()
	{
		return true;
	};
	Cnds.prototype.OnMove = function ()
	{
		return true;
	};
	Cnds.prototype.OnLand = function ()
	{
		return true;
	};
	behaviorProto.cnds = new Cnds();
	function Acts() {};
	Acts.prototype.SetIgnoreInput = function (ignoring)
	{
		this.ignoreInput = ignoring;
	};
	Acts.prototype.SetMaxSpeed = function (maxspeed)
	{
		this.maxspeed = maxspeed;
		if (this.maxspeed < 0)
			this.maxspeed = 0;
	};
	Acts.prototype.SetAcceleration = function (acc)
	{
		this.acc = acc;
		if (this.acc < 0)
			this.acc = 0;
	};
	Acts.prototype.SetDeceleration = function (dec)
	{
		this.dec = dec;
		if (this.dec < 0)
			this.dec = 0;
	};
	Acts.prototype.SetJumpStrength = function (js)
	{
		this.jumpStrength = js;
		if (this.jumpStrength < 0)
			this.jumpStrength = 0;
	};
	Acts.prototype.SetGravity = function (grav)
	{
		if (this.g1 === grav)
			return;		// no change
		this.g = grav;
		this.updateGravity();
		if (this.runtime.testOverlapSolid(this.inst))
		{
			this.runtime.pushOutSolid(this.inst, this.downx, this.downy, 10);
			this.inst.x += this.downx * 2;
			this.inst.y += this.downy * 2;
			this.inst.set_bbox_changed();
		}
		this.lastFloorObject = null;
	};
	Acts.prototype.SetMaxFallSpeed = function (mfs)
	{
		this.maxFall = mfs;
		if (this.maxFall < 0)
			this.maxFall = 0;
	};
	Acts.prototype.SimulateControl = function (ctrl)
	{
		switch (ctrl) {
		case 0:		this.simleft = true;	break;
		case 1:		this.simright = true;	break;
		case 2:		this.simjump = true;	break;
		}
	};
	Acts.prototype.SetVectorX = function (vx)
	{
		this.dx = vx;
	};
	Acts.prototype.SetVectorY = function (vy)
	{
		this.dy = vy;
	};
	Acts.prototype.SetGravityAngle = function (a)
	{
		a = cr.to_radians(a);
		a = cr.clamp_angle(a);
		if (this.ga === a)
			return;		// no change
		this.ga = a;
		this.updateGravity();
		this.lastFloorObject = null;
	};
	Acts.prototype.SetEnabled = function (en)
	{
		this.enabled = (en === 1);
	};
	Acts.prototype.FallThrough = function ()
	{
		var oldx = this.inst.x;
		var oldy = this.inst.y;
		this.inst.x += this.downx;
		this.inst.y += this.downy;
		this.inst.set_bbox_changed();
		var overlaps = this.runtime.testOverlapJumpThru(this.inst, false);
		this.inst.x = oldx;
		this.inst.y = oldy;
		this.inst.set_bbox_changed();
		if (!overlaps)
			return;
		this.fallthrough = 3;			// disable jumpthrus for 3 ticks (1 doesn't do it, 2 does, 3 to be on safe side)
		this.lastFloorObject = null;
	};
	behaviorProto.acts = new Acts();
	function Exps() {};
	Exps.prototype.Speed = function (ret)
	{
		ret.set_float(Math.sqrt(this.dx * this.dx + this.dy * this.dy));
	};
	Exps.prototype.MaxSpeed = function (ret)
	{
		ret.set_float(this.maxspeed);
	};
	Exps.prototype.Acceleration = function (ret)
	{
		ret.set_float(this.acc);
	};
	Exps.prototype.Deceleration = function (ret)
	{
		ret.set_float(this.dec);
	};
	Exps.prototype.JumpStrength = function (ret)
	{
		ret.set_float(this.jumpStrength);
	};
	Exps.prototype.Gravity = function (ret)
	{
		ret.set_float(this.g);
	};
	Exps.prototype.GravityAngle = function (ret)
	{
		ret.set_float(cr.to_degrees(this.ga));
	};
	Exps.prototype.MaxFallSpeed = function (ret)
	{
		ret.set_float(this.maxFall);
	};
	Exps.prototype.MovingAngle = function (ret)
	{
		ret.set_float(cr.to_degrees(Math.atan2(this.dy, this.dx)));
	};
	Exps.prototype.VectorX = function (ret)
	{
		ret.set_float(this.dx);
	};
	Exps.prototype.VectorY = function (ret)
	{
		ret.set_float(this.dy);
	};
	behaviorProto.exps = new Exps();
}());
;
;
cr.behaviors.Sin = function(runtime)
{
	this.runtime = runtime;
};
(function ()
{
	var behaviorProto = cr.behaviors.Sin.prototype;
	behaviorProto.Type = function(behavior, objtype)
	{
		this.behavior = behavior;
		this.objtype = objtype;
		this.runtime = behavior.runtime;
	};
	var behtypeProto = behaviorProto.Type.prototype;
	behtypeProto.onCreate = function()
	{
	};
	behaviorProto.Instance = function(type, inst)
	{
		this.type = type;
		this.behavior = type.behavior;
		this.inst = inst;				// associated object instance to modify
		this.runtime = type.runtime;
		this.i = 0;		// period offset (radians)
	};
	var behinstProto = behaviorProto.Instance.prototype;
	var _2pi = 2 * Math.PI;
	var _pi_2 = Math.PI / 2;
	var _3pi_2 = (3 * Math.PI) / 2;
	behinstProto.onCreate = function()
	{
		this.active = (this.properties[0] === 1);
		this.movement = this.properties[1]; // 0=Horizontal|1=Vertical|2=Size|3=Width|4=Height|5=Angle|6=Opacity|7=Value only
		this.wave = this.properties[2];		// 0=Sine|1=Triangle|2=Sawtooth|3=Reverse sawtooth|4=Square
		this.period = this.properties[3];
		this.period += Math.random() * this.properties[4];								// period random
		if (this.period === 0)
			this.i = 0;
		else
		{
			this.i = (this.properties[5] / this.period) * _2pi;								// period offset
			this.i += ((Math.random() * this.properties[6]) / this.period) * _2pi;			// period offset random
		}
		this.mag = this.properties[7];													// magnitude
		this.mag += Math.random() * this.properties[8];									// magnitude random
		this.initialValue = 0;
		this.initialValue2 = 0;
		this.ratio = 0;
		this.init();
	};
	behinstProto.saveToJSON = function ()
	{
		return {
			"i": this.i,
			"a": this.active,
			"mv": this.movement,
			"w": this.wave,
			"p": this.period,
			"mag": this.mag,
			"iv": this.initialValue,
			"iv2": this.initialValue2,
			"r": this.ratio,
			"lkv": this.lastKnownValue,
			"lkv2": this.lastKnownValue2
		};
	};
	behinstProto.loadFromJSON = function (o)
	{
		this.i = o["i"];
		this.active = o["a"];
		this.movement = o["mv"];
		this.wave = o["w"];
		this.period = o["p"];
		this.mag = o["mag"];
		this.initialValue = o["iv"];
		this.initialValue2 = o["iv2"] || 0;
		this.ratio = o["r"];
		this.lastKnownValue = o["lkv"];
		this.lastKnownValue2 = o["lkv2"] || 0;
	};
	behinstProto.init = function ()
	{
		switch (this.movement) {
		case 0:		// horizontal
			this.initialValue = this.inst.x;
			break;
		case 1:		// vertical
			this.initialValue = this.inst.y;
			break;
		case 2:		// size
			this.initialValue = this.inst.width;
			this.ratio = this.inst.height / this.inst.width;
			break;
		case 3:		// width
			this.initialValue = this.inst.width;
			break;
		case 4:		// height
			this.initialValue = this.inst.height;
			break;
		case 5:		// angle
			this.initialValue = this.inst.angle;
			this.mag = cr.to_radians(this.mag);		// convert magnitude from degrees to radians
			break;
		case 6:		// opacity
			this.initialValue = this.inst.opacity;
			break;
		case 7:
			this.initialValue = 0;
			break;
		case 8:		// forwards/backwards
			this.initialValue = this.inst.x;
			this.initialValue2 = this.inst.y;
			break;
		default:
;
		}
		this.lastKnownValue = this.initialValue;
		this.lastKnownValue2 = this.initialValue2;
	};
	behinstProto.waveFunc = function (x)
	{
		x = x % _2pi;
		switch (this.wave) {
		case 0:		// sine
			return Math.sin(x);
		case 1:		// triangle
			if (x <= _pi_2)
				return x / _pi_2;
			else if (x <= _3pi_2)
				return 1 - (2 * (x - _pi_2) / Math.PI);
			else
				return (x - _3pi_2) / _pi_2 - 1;
		case 2:		// sawtooth
			return 2 * x / _2pi - 1;
		case 3:		// reverse sawtooth
			return -2 * x / _2pi + 1;
		case 4:		// square
			return x < Math.PI ? -1 : 1;
		};
		return 0;
	};
	behinstProto.tick = function ()
	{
		var dt = this.runtime.getDt(this.inst);
		if (!this.active || dt === 0)
			return;
		if (this.period === 0)
			this.i = 0;
		else
		{
			this.i += (dt / this.period) * _2pi;
			this.i = this.i % _2pi;
		}
		switch (this.movement) {
		case 0:		// horizontal
			if (this.inst.x !== this.lastKnownValue)
				this.initialValue += this.inst.x - this.lastKnownValue;
			this.inst.x = this.initialValue + this.waveFunc(this.i) * this.mag;
			this.lastKnownValue = this.inst.x;
			break;
		case 1:		// vertical
			if (this.inst.y !== this.lastKnownValue)
				this.initialValue += this.inst.y - this.lastKnownValue;
			this.inst.y = this.initialValue + this.waveFunc(this.i) * this.mag;
			this.lastKnownValue = this.inst.y;
			break;
		case 2:		// size
			this.inst.width = this.initialValue + this.waveFunc(this.i) * this.mag;
			this.inst.height = this.inst.width * this.ratio;
			break;
		case 3:		// width
			this.inst.width = this.initialValue + this.waveFunc(this.i) * this.mag;
			break;
		case 4:		// height
			this.inst.height = this.initialValue + this.waveFunc(this.i) * this.mag;
			break;
		case 5:		// angle
			if (this.inst.angle !== this.lastKnownValue)
				this.initialValue = cr.clamp_angle(this.initialValue + (this.inst.angle - this.lastKnownValue));
			this.inst.angle = cr.clamp_angle(this.initialValue + this.waveFunc(this.i) * this.mag);
			this.lastKnownValue = this.inst.angle;
			break;
		case 6:		// opacity
			this.inst.opacity = this.initialValue + (this.waveFunc(this.i) * this.mag) / 100;
			if (this.inst.opacity < 0)
				this.inst.opacity = 0;
			else if (this.inst.opacity > 1)
				this.inst.opacity = 1;
			break;
		case 8:		// forwards/backwards
			if (this.inst.x !== this.lastKnownValue)
				this.initialValue += this.inst.x - this.lastKnownValue;
			if (this.inst.y !== this.lastKnownValue2)
				this.initialValue2 += this.inst.y - this.lastKnownValue2;
			this.inst.x = this.initialValue + Math.cos(this.inst.angle) * this.waveFunc(this.i) * this.mag;
			this.inst.y = this.initialValue2 + Math.sin(this.inst.angle) * this.waveFunc(this.i) * this.mag;
			this.lastKnownValue = this.inst.x;
			this.lastKnownValue2 = this.inst.y;
			break;
		}
		this.inst.set_bbox_changed();
	};
	behinstProto.onSpriteFrameChanged = function (prev_frame, next_frame)
	{
		switch (this.movement) {
		case 2:	// size
			this.initialValue *= (next_frame.width / prev_frame.width);
			this.ratio = next_frame.height / next_frame.width;
			break;
		case 3:	// width
			this.initialValue *= (next_frame.width / prev_frame.width);
			break;
		case 4:	// height
			this.initialValue *= (next_frame.height / prev_frame.height);
			break;
		}
	};
	function Cnds() {};
	Cnds.prototype.IsActive = function ()
	{
		return this.active;
	};
	Cnds.prototype.CompareMovement = function (m)
	{
		return this.movement === m;
	};
	Cnds.prototype.ComparePeriod = function (cmp, v)
	{
		return cr.do_cmp(this.period, cmp, v);
	};
	Cnds.prototype.CompareMagnitude = function (cmp, v)
	{
		if (this.movement === 5)
			return cr.do_cmp(this.mag, cmp, cr.to_radians(v));
		else
			return cr.do_cmp(this.mag, cmp, v);
	};
	Cnds.prototype.CompareWave = function (w)
	{
		return this.wave === w;
	};
	behaviorProto.cnds = new Cnds();
	function Acts() {};
	Acts.prototype.SetActive = function (a)
	{
		this.active = (a === 1);
	};
	Acts.prototype.SetPeriod = function (x)
	{
		this.period = x;
	};
	Acts.prototype.SetMagnitude = function (x)
	{
		this.mag = x;
		if (this.movement === 5)	// angle
			this.mag = cr.to_radians(this.mag);
	};
	Acts.prototype.SetMovement = function (m)
	{
		if (this.movement === 5)
			this.mag = cr.to_degrees(this.mag);
		this.movement = m;
		this.init();
	};
	Acts.prototype.SetWave = function (w)
	{
		this.wave = w;
	};
	behaviorProto.acts = new Acts();
	function Exps() {};
	Exps.prototype.CyclePosition = function (ret)
	{
		ret.set_float(this.i / _2pi);
	};
	Exps.prototype.Period = function (ret)
	{
		ret.set_float(this.period);
	};
	Exps.prototype.Magnitude = function (ret)
	{
		if (this.movement === 5)	// angle
			ret.set_float(cr.to_degrees(this.mag));
		else
			ret.set_float(this.mag);
	};
	Exps.prototype.Value = function (ret)
	{
		ret.set_float(this.waveFunc(this.i) * this.mag);
	};
	behaviorProto.exps = new Exps();
}());
;
;
cr.behaviors.destroy = function(runtime)
{
	this.runtime = runtime;
};
(function ()
{
	var behaviorProto = cr.behaviors.destroy.prototype;
	behaviorProto.Type = function(behavior, objtype)
	{
		this.behavior = behavior;
		this.objtype = objtype;
		this.runtime = behavior.runtime;
	};
	var behtypeProto = behaviorProto.Type.prototype;
	behtypeProto.onCreate = function()
	{
	};
	behaviorProto.Instance = function(type, inst)
	{
		this.type = type;
		this.behavior = type.behavior;
		this.inst = inst;				// associated object instance to modify
		this.runtime = type.runtime;
	};
	var behinstProto = behaviorProto.Instance.prototype;
	behinstProto.onCreate = function()
	{
	};
	behinstProto.tick = function ()
	{
		this.inst.update_bbox();
		var bbox = this.inst.bbox;
		var layout = this.inst.layer.layout;
		if (bbox.right < 0 || bbox.bottom < 0 || bbox.left > layout.width || bbox.top > layout.height)
			this.runtime.DestroyInstance(this.inst);
	};
}());
;
;
cr.behaviors.jumpthru = function(runtime)
{
	this.runtime = runtime;
};
(function ()
{
	var behaviorProto = cr.behaviors.jumpthru.prototype;
	behaviorProto.Type = function(behavior, objtype)
	{
		this.behavior = behavior;
		this.objtype = objtype;
		this.runtime = behavior.runtime;
	};
	var behtypeProto = behaviorProto.Type.prototype;
	behtypeProto.onCreate = function()
	{
	};
	behaviorProto.Instance = function(type, inst)
	{
		this.type = type;
		this.behavior = type.behavior;
		this.inst = inst;				// associated object instance to modify
		this.runtime = type.runtime;
	};
	var behinstProto = behaviorProto.Instance.prototype;
	behinstProto.onCreate = function()
	{
		this.inst.extra.jumpthruEnabled = (this.properties[0] !== 0);
	};
	behinstProto.tick = function ()
	{
	};
	function Cnds() {};
	Cnds.prototype.IsEnabled = function ()
	{
		return this.inst.extra.jumpthruEnabled;
	};
	behaviorProto.cnds = new Cnds();
	function Acts() {};
	Acts.prototype.SetEnabled = function (e)
	{
		this.inst.extra.jumpthruEnabled = !!e;
	};
	behaviorProto.acts = new Acts();
}());
;
;
cr.behaviors.scrollto = function(runtime)
{
	this.runtime = runtime;
	this.shakeMag = 0;
	this.shakeStart = 0;
	this.shakeEnd = 0;
	this.shakeMode = 0;
};
(function ()
{
	var behaviorProto = cr.behaviors.scrollto.prototype;
	behaviorProto.Type = function(behavior, objtype)
	{
		this.behavior = behavior;
		this.objtype = objtype;
		this.runtime = behavior.runtime;
	};
	var behtypeProto = behaviorProto.Type.prototype;
	behtypeProto.onCreate = function()
	{
	};
	behaviorProto.Instance = function(type, inst)
	{
		this.type = type;
		this.behavior = type.behavior;
		this.inst = inst;				// associated object instance to modify
		this.runtime = type.runtime;
	};
	var behinstProto = behaviorProto.Instance.prototype;
	behinstProto.onCreate = function()
	{
		this.enabled = (this.properties[0] !== 0);
	};
	behinstProto.saveToJSON = function ()
	{
		return {
			"smg": this.behavior.shakeMag,
			"ss": this.behavior.shakeStart,
			"se": this.behavior.shakeEnd,
			"smd": this.behavior.shakeMode
		};
	};
	behinstProto.loadFromJSON = function (o)
	{
		this.behavior.shakeMag = o["smg"];
		this.behavior.shakeStart = o["ss"];
		this.behavior.shakeEnd = o["se"];
		this.behavior.shakeMode = o["smd"];
	};
	behinstProto.tick = function ()
	{
	};
	behinstProto.tick2 = function ()
	{
		if (!this.enabled)
			return;
		var all = this.behavior.my_instances.values();
		var sumx = 0, sumy = 0;
		var i, len;
		for (i = 0, len = all.length; i < len; i++)
		{
			sumx += all[i].x;
			sumy += all[i].y;
		}
		var layout = this.inst.layer.layout;
		var now = this.runtime.kahanTime.sum;
		var offx = 0, offy = 0;
		if (now >= this.behavior.shakeStart && now < this.behavior.shakeEnd)
		{
			var mag = this.behavior.shakeMag * Math.min(this.runtime.timescale, 1);
			if (this.behavior.shakeMode === 0)
				mag *= 1 - (now - this.behavior.shakeStart) / (this.behavior.shakeEnd - this.behavior.shakeStart);
			var a = Math.random() * Math.PI * 2;
			var d = Math.random() * mag;
			offx = Math.cos(a) * d;
			offy = Math.sin(a) * d;
		}
		layout.scrollToX(sumx / all.length + offx);
		layout.scrollToY(sumy / all.length + offy);
	};
	function Acts() {};
	Acts.prototype.Shake = function (mag, dur, mode)
	{
		this.behavior.shakeMag = mag;
		this.behavior.shakeStart = this.runtime.kahanTime.sum;
		this.behavior.shakeEnd = this.behavior.shakeStart + dur;
		this.behavior.shakeMode = mode;
	};
	Acts.prototype.SetEnabled = function (e)
	{
		this.enabled = (e !== 0);
	};
	behaviorProto.acts = new Acts();
}());
;
;
cr.behaviors.solid = function(runtime)
{
	this.runtime = runtime;
};
(function ()
{
	var behaviorProto = cr.behaviors.solid.prototype;
	behaviorProto.Type = function(behavior, objtype)
	{
		this.behavior = behavior;
		this.objtype = objtype;
		this.runtime = behavior.runtime;
	};
	var behtypeProto = behaviorProto.Type.prototype;
	behtypeProto.onCreate = function()
	{
	};
	behaviorProto.Instance = function(type, inst)
	{
		this.type = type;
		this.behavior = type.behavior;
		this.inst = inst;				// associated object instance to modify
		this.runtime = type.runtime;
	};
	var behinstProto = behaviorProto.Instance.prototype;
	behinstProto.onCreate = function()
	{
		this.inst.extra.solidEnabled = (this.properties[0] !== 0);
	};
	behinstProto.tick = function ()
	{
	};
	function Cnds() {};
	Cnds.prototype.IsEnabled = function ()
	{
		return this.inst.extra.solidEnabled;
	};
	behaviorProto.cnds = new Cnds();
	function Acts() {};
	Acts.prototype.SetEnabled = function (e)
	{
		this.inst.extra.solidEnabled = !!e;
	};
	behaviorProto.acts = new Acts();
}());
cr.getProjectModel = function() { return [
	null,
	null,
	[
	[
		cr.plugins_.Audio,
		true,
		false,
		false,
		false,
		false,
		false,
		false,
		false,
		false
	]
,	[
		cr.plugins_.Browser,
		true,
		false,
		false,
		false,
		false,
		false,
		false,
		false,
		false
	]
,	[
		cr.plugins_.CJSAds,
		true,
		false,
		false,
		false,
		false,
		false,
		false,
		false,
		false
	]
,	[
		cr.plugins_.Particles,
		false,
		true,
		true,
		false,
		true,
		true,
		true,
		true,
		true
	]
,	[
		cr.plugins_.Sprite,
		false,
		true,
		true,
		true,
		true,
		true,
		true,
		true,
		false
	]
,	[
		cr.plugins_.Text,
		false,
		true,
		true,
		true,
		true,
		true,
		true,
		true,
		false
	]
,	[
		cr.plugins_.TextBox,
		false,
		true,
		true,
		true,
		false,
		false,
		false,
		false,
		false
	]
,	[
		cr.plugins_.TiledBg,
		false,
		true,
		true,
		true,
		true,
		true,
		true,
		true,
		true
	]
,	[
		cr.plugins_.Touch,
		true,
		false,
		false,
		false,
		false,
		false,
		false,
		false,
		false
	]
,	[
		cr.plugins_.WebStorage,
		true,
		false,
		false,
		false,
		false,
		false,
		false,
		false,
		false
	]
	],
	[
	[
		"t0",
		cr.plugins_.WebStorage,
		false,
		[],
		0,
		0,
		null,
		null,
		[
		],
		false,
		false,
		5348170403011429,
		[],
		null
		,[]
	]
,	[
		"t1",
		cr.plugins_.Touch,
		false,
		[],
		0,
		0,
		null,
		null,
		[
		],
		false,
		false,
		5360238741765463,
		[],
		null
		,[1]
	]
,	[
		"t2",
		cr.plugins_.Browser,
		false,
		[],
		0,
		0,
		null,
		null,
		[
		],
		false,
		false,
		2272070290508734,
		[],
		null
		,[]
	]
,	[
		"t3",
		cr.plugins_.Audio,
		false,
		[],
		0,
		0,
		null,
		null,
		[
		],
		false,
		false,
		432376389717995,
		[],
		null
		,[0,0,1,1,600,600,10000,1,5000,1]
	]
,	[
		"t4",
		cr.plugins_.Sprite,
		false,
		[],
		1,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			1499583104246126,
			[
				["imagenes/piedra1-sheet0.png", 34664, 0, 0, 838, 221, 1, 0.5, 0.502262,[],[-0.498807,-0.497738,0.49642,-0.488688,0.49642,0.484163,-0.498807,0.493213],0]
			]
			]
		],
		[
		[
			"Solid",
			cr.behaviors.solid,
			4422165828748628
		]
		],
		false,
		false,
		6154830834932382,
		[],
		null
	]
,	[
		"t5",
		cr.plugins_.TiledBg,
		false,
		[],
		0,
		0,
		["imagenes/tiledbackground.png", 18593, 3],
		null,
		[
		],
		false,
		false,
		8558840480593912,
		[],
		null
	]
,	[
		"t6",
		cr.plugins_.Sprite,
		false,
		[],
		2,
		0,
		null,
		[
			[
			"normal",
			5,
			false,
			1,
			0,
			false,
			1516303046554688,
			[
				["imagenes/play-sheet0.png", 288704, 1, 1, 132, 167, 1, 0.515152, 0.60479,[["punto1", 0.5, 0.502994]],[-0.151515,-0.395209,-0.0757575,-0.413173,-0.00757551,-0.371257,-0.0151515,-0.113772,-0.0227265,0.0658686,-0.0454545,0.383234,-0.0984845,0.137725],0]
			]
			]
,			[
			"corriendo",
			30,
			true,
			1,
			0,
			false,
			8658361963481386,
			[
				["imagenes/play-sheet0.png", 288704, 134, 1, 132, 167, 1, 0.5, 0.502994,[],[-0.098485,-0.347305,-0.030303,-0.359281,0.022727,-0.329341,-0.00757599,-0.047904,-0.030303,0.179641,-0.05303,0.48503,-0.075758,0.239521],0],
				["imagenes/play-sheet0.png", 288704, 267, 1, 132, 167, 1, 0.5, 0.502994,[],[-0.121212,-0.353293,-0.05303,-0.389222,0.015152,-0.383234,0,0,0.022728,0.227545,0,0.491018,-0.075758,0.191617,-0.075758,0.005988],0],
				["imagenes/play-sheet0.png", 288704, 400, 1, 132, 167, 1, 0.5, 0.502994,[],[-0.090909,-0.323353,-0.022727,-0.371257,0.060606,-0.329341,0.045455,0.017964,0.037879,0.209581,0.037879,0.48503,-0.030303,0.179641,-0.053031,-0.005988],0],
				["imagenes/play-sheet0.png", 288704, 533, 1, 132, 167, 1, 0.5, 0.502994,[],[-0.113636,-0.341317,-0.05303,-0.341317,0.05303,-0.317365,0.075758,-0.005988,0.075757,0.197605,0.05303,0.497006,0,0.209581,-0.037879,0.011976],0],
				["imagenes/play-sheet0.png", 288704, 666, 1, 132, 167, 1, 0.5, 0.502994,[],[-0.136364,-0.329341,-0.075758,-0.359281,0.098485,-0.413174,0.083333,-0.005988,0.05303,0.239521,0.045455,0.479042,-0.022727,0.197605,-0.060606,0],0],
				["imagenes/play-sheet0.png", 288704, 799, 1, 132, 167, 1, 0.5, 0.502994,[],[-0.136364,-0.317365,-0.090909,-0.353293,0.090909,-0.413174,0.075758,-0.011976,0.037879,0.179641,0,0.497006,-0.022727,0.239521,-0.05303,-0.005988],0],
				["imagenes/play-sheet0.png", 288704, 1, 169, 132, 167, 1, 0.5, 0.502994,[],[-0.106061,-0.311377,-0.037879,-0.347305,0.045455,-0.365269,0.05303,0.005988,0.05303,0.173653,0,0.497006,-0.060606,0.263473],0],
				["imagenes/play-sheet0.png", 288704, 134, 169, 132, 167, 1, 0.5, 0.502994,[],[-0.128788,-0.341317,-0.037879,-0.359281,0.037879,-0.359281,0.022727,-0.005988,0,0.161677,-0.037879,0.467066,-0.136364,0.323353,-0.128788,-0.011976],0],
				["imagenes/play-sheet0.png", 288704, 267, 169, 132, 167, 1, 0.5, 0.502994,[],[-0.098485,-0.299401,-0.060606,-0.359281,0.045454,-0.359282,0.015152,-0.005988,0.00757599,0.161677,-0.037879,0.48503,-0.151515,0.317365,-0.113636,0.011976],0],
				["imagenes/play-sheet0.png", 288704, 400, 169, 132, 167, 1, 0.5, 0.502994,[],[-0.121212,-0.341317,-0.015152,-0.371257,0.060606,-0.365269,0.037879,0,0.00757599,0.257485,-0.015152,0.491018,-0.098485,0.311377,-0.106061,0.02994],0],
				["imagenes/play-sheet0.png", 288704, 533, 169, 132, 167, 1, 0.5, 0.502994,[],[-0.083333,-0.341317,-0.037879,-0.335329,0.045455,-0.329342,0.045455,-0.005988,0.045455,0.287425,0,0.497006,-0.068182,0.251497],0],
				["imagenes/play-sheet0.png", 288704, 666, 169, 132, 167, 1, 0.5, 0.502994,[],[-0.106061,-0.347305,-0.00757599,-0.377245,0.098485,-0.413174,0.05303,0.239521,0,0.491018,-0.037879,0.239521,-0.045455,-0.011976],0]
			]
			]
,			[
			"corriendoatras",
			25,
			true,
			1,
			0,
			false,
			5617395090492395,
			[
				["imagenes/play-sheet0.png", 288704, 799, 169, 132, 167, 1, 0.5, 0.502994,[],[-0.090909,-0.317365,0,-0.502994,0.106061,-0.311377,0.037879,0.191617,0,0.48503,-0.121212,0.197605,-0.098484,-0.005988],0],
				["imagenes/play-sheet0.png", 288704, 1, 337, 132, 167, 1, 0.5, 0.502994,[],[-0.257576,-0.323353,0,-0.502994,0.280303,-0.293413,0.227273,-0.005988,0,0.497006,-0.098485,0.179641,-0.265152,-0.005988],0],
				["imagenes/play-sheet0.png", 288704, 134, 337, 132, 167, 1, 0.5, 0.502994,[],[-0.272727,-0.347305,0,-0.502994,0.386364,-0.413174,0.242424,-0.005988,0.128788,0.203593,0,0.491018,-0.098485,0.179641,-0.257576,-0.005988],0],
				["imagenes/play-sheet0.png", 288704, 267, 337, 132, 167, 1, 0.5, 0.502994,[],[-0.234848,-0.329341,0,-0.502994,0.386364,-0.413174,0.265152,-0.005988,0.128788,0.203593,0,0.497006,-0.098485,0.179641,-0.25,-0.005988],0],
				["imagenes/play-sheet0.png", 288704, 400, 337, 132, 167, 1, 0.5, 0.502994,[],[-0.19697,-0.341317,0.037879,-0.491018,0.227273,-0.365269,0.083333,-0.005988,0.113636,0.191617,0,0.497006,-0.113636,0.191617,-0.106061,0],0],
				["imagenes/play-sheet0.png", 288704, 533, 337, 132, 167, 1, 0.5, 0.502994,[],[-0.287879,-0.311377,0,-0.497006,0.287879,-0.287425,0.227273,-0.005988,0.113636,0.191617,0,0.473054,-0.128788,0.203593,-0.272727,-0.005988],0],
				["imagenes/play-sheet0.png", 288704, 666, 337, 132, 167, 1, 0.5, 0.502994,[],[-0.242424,-0.263473,0,-0.497006,0.272727,-0.269461,0.151515,0.221557,0,0.491018,-0.098485,0.179641,-0.25,-0.005988],0],
				["imagenes/play-sheet0.png", 288704, 799, 337, 132, 167, 1, 0.5, 0.502994,[],[-0.340909,-0.245509,0,-0.497006,0.234848,-0.245509,0.227273,-0.005988,0.181818,0.245509,0,0.497006,-0.098485,0.179641,-0.234848,-0.005988],0],
				["imagenes/play-sheet0.png", 288704, 1, 505, 132, 167, 1, 0.5, 0.502994,[],[-0.212121,-0.329341,0,-0.497006,0.25,-0.257485,0.219697,-0.005988,0.242424,0.293413,0,0.497006,-0.19697,0.257485,-0.227273,-0.005988],0],
				["imagenes/play-sheet0.png", 288704, 134, 505, 132, 167, 1, 0.5, 0.502994,[],[-0.265152,-0.263473,0.00757599,-0.347305,0.219697,-0.311377,0.227273,-0.005988,0.265152,0.311377,0,0.491018,-0.189394,0.251497,-0.219697,-0.005988],0],
				["imagenes/play-sheet0.png", 288704, 267, 505, 132, 167, 1, 0.5, 0.502994,[],[-0.075757,-0.221557,-0.00757599,-0.323353,0.121212,-0.233533,0.083334,-0.011976,0.098485,0.293413,0,0.491018,0.030303,0.251497,-0.060606,-0.035928],0],
				["imagenes/play-sheet0.png", 288704, 400, 505, 132, 167, 1, 0.5, 0.502994,[],[-0.174242,-0.275449,0.015152,-0.45509,0.098485,-0.215569,0.113637,-0.005988,0.106061,0.245509,0,0.497006,-0.090909,0.281437,-0.151515,0.011976],0],
				["imagenes/play-sheet0.png", 288704, 533, 505, 132, 167, 1, 0.5, 0.502994,[],[-0.166667,-0.263473,-0.045455,-0.329341,0.015152,-0.287425,0.00757599,0.239521,0,0.491018,-0.098484,0.245509],0]
			]
			]
,			[
			"disparando",
			30,
			true,
			1,
			0,
			false,
			4597426488077751,
			[
				["imagenes/play-sheet0.png", 288704, 666, 505, 132, 167, 1, 0.5, 0.502994,[],[-0.106061,-0.323353,-0.045455,-0.365269,0.045455,-0.377246,0.022727,-0.041916,0.022727,0.167665,0,0.48503,-0.045455,0.245509,-0.098485,0.011976],0],
				["imagenes/play-sheet0.png", 288704, 799, 505, 132, 167, 1, 0.5, 0.502994,[],[-0.136364,-0.329341,-0.05303,-0.359281,0.030303,-0.323353,0.05303,-0.005988,0,0.491018,-0.083333,0.233533,-0.113636,0.005988],0],
				["imagenes/play-sheet0.png", 288704, 1, 673, 132, 167, 1, 0.5, 0.502994,[],[-0.121212,-0.323353,-0.098485,-0.353293,-0.00757599,-0.359281,-0.00757599,-0.011976,0,0.167665,0,0.497006,-0.075758,0.239521,-0.090909,-0.005988],0],
				["imagenes/play-sheet0.png", 288704, 134, 673, 132, 167, 1, 0.5, 0.502994,[],[-0.113636,-0.299401,-0.037879,-0.311377,0.022727,-0.329342,0.022727,-0.011976,0.00757599,0.173653,0,0.497006,-0.083333,0.239521,-0.098485,0],0],
				["imagenes/play-sheet0.png", 288704, 267, 673, 132, 167, 1, 0.5, 0.502994,[],[-0.128788,-0.353293,-0.037879,-0.389222,0.022727,-0.401198,0.00757599,-0.005988,0.022727,0.161677,0,0.497006,-0.060606,0.233533,-0.083333,0.011976],0],
				["imagenes/play-sheet0.png", 288704, 400, 673, 132, 167, 1, 0.5, 0.502994,[],[-0.090909,-0.347305,0,-0.479042,0.037879,-0.353293,0.015152,-0.005988,0.00757599,0.167665,0,0.497006,-0.075758,0.221557,-0.090909,0.005988],0],
				["imagenes/play-sheet0.png", 288704, 533, 673, 132, 167, 1, 0.5, 0.502994,[],[-0.083333,-0.305389,-0.022727,-0.353293,0.083333,-0.353293,0.060606,-0.005988,0.075758,0.161677,0,0.497006,-0.037879,0.251497,-0.068182,-0.005988],0],
				["imagenes/play-sheet0.png", 288704, 666, 673, 132, 167, 1, 0.5, 0.502994,[],[-0.098485,-0.347305,-0.015152,-0.377245,0.083333,-0.389222,0.022727,0.005988,0.022727,0.155689,0,0.491018,-0.060606,0.245509,-0.075758,0.017964],0],
				["imagenes/play-sheet0.png", 288704, 799, 673, 132, 167, 1, 0.5, 0.502994,[],[-0.060606,-0.347305,-0.00757599,-0.377245,0.083333,-0.341317,0.068182,-0.005988,0.068182,0.155689,0,0.491018,-0.068181,0.245509,-0.068182,0],0],
				["imagenes/play-sheet0.png", 288704, 1, 841, 132, 167, 1, 0.5, 0.502994,[],[-0.015152,-0.317365,0.030303,-0.389222,0.106061,-0.413174,0.060606,-0.005988,0.045455,0.155689,0,0.497006,-0.00757599,0.209581,-0.00757599,0.011976],0],
				["imagenes/play-sheet0.png", 288704, 134, 841, 132, 167, 1, 0.5, 0.502994,[],[-0.045455,-0.341317,0,-0.353293,0.106061,-0.353293,0.075758,-0.005988,0.053031,0.167665,0,0.497006,-0.030303,0.227545,-0.030303,-0.011976],0],
				["imagenes/play-sheet0.png", 288704, 267, 841, 132, 167, 1, 0.5, 0.502994,[],[-0.090909,-0.347305,0,-0.371257,0.045454,-0.33533,0.045455,-0.005988,0,0.497006,-0.05303,0.239521,-0.090909,-0.005988],0],
				["imagenes/play-sheet0.png", 288704, 400, 841, 132, 167, 1, 0.5, 0.502994,[],[-0.068182,-0.353293,-0.00757599,-0.365269,0.022727,-0.323353,0.045455,-0.023952,0.022727,0.185629,0,0.497006,-0.045455,0.239521,-0.060606,-0.005988],0]
			]
			]
		],
		[
		[
			"ScrollTo",
			cr.behaviors.scrollto,
			6305085442883295
		]
,		[
			"Platform",
			cr.behaviors.Platform,
			950070379483423
		]
		],
		false,
		false,
		7717931990436266,
		[],
		null
	]
,	[
		"t7",
		cr.plugins_.Sprite,
		false,
		[],
		0,
		0,
		null,
		[
			[
			"Default",
			5,
			true,
			1,
			0,
			false,
			3354453719519126,
			[
				["imagenes/agua-sheet0.png", 155, 0, 0, 250, 250, 1, 0.5, 0.5,[],[-0.432,-0.432,0.42,-0.42,0.5,0,0.5,0.5,-0.5,0.5,-0.5,0],1]
			]
			]
		],
		[
		],
		false,
		false,
		5195995817763902,
		[],
		null
	]
,	[
		"t8",
		cr.plugins_.Sprite,
		false,
		[],
		1,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			8838882385450079,
			[
				["imagenes/imgizquierda-sheet0.png", 733, 0, 0, 80, 80, 1, 0.5, 0.5,[],[-0.35,-0.35,0,-0.4875,0.35,-0.35,0.5,0,0.35,0.35,0,0.5,-0.35,0.35,-0.5,0],0]
			]
			]
		],
		[
		[
			"Anchor",
			cr.behaviors.Anchor,
			8652458463429189
		]
		],
		false,
		false,
		6784380803236501,
		[],
		null
	]
,	[
		"t9",
		cr.plugins_.Sprite,
		false,
		[],
		1,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			6902193333098072,
			[
				["imagenes/imgderecha-sheet0.png", 721, 0, 0, 80, 80, 1, 0.5, 0.5,[],[-0.35,-0.35,0,-0.4875,0.35,-0.35,0.5,0,0.35,0.35,0,0.5,-0.35,0.35,-0.5,0],0]
			]
			]
		],
		[
		[
			"Anchor",
			cr.behaviors.Anchor,
			7571629879884421
		]
		],
		false,
		false,
		5402368956868106,
		[],
		null
	]
,	[
		"t10",
		cr.plugins_.Sprite,
		false,
		[],
		1,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			9869517403993871,
			[
				["imagenes/imgsaltar-sheet0.png", 723, 0, 0, 80, 80, 1, 0.5, 0.5,[],[-0.35,-0.35,0,-0.4875,0.35,-0.35,0.5,0,0.35,0.35,0,0.5,-0.35,0.35,-0.5,0],0]
			]
			]
		],
		[
		[
			"Anchor",
			cr.behaviors.Anchor,
			6893177141979744
		]
		],
		false,
		false,
		6380369595383096,
		[],
		null
	]
,	[
		"t11",
		cr.plugins_.Sprite,
		false,
		[],
		1,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			8690436183194849,
			[
				["imagenes/imgpause-sheet0.png", 240, 0, 0, 48, 48, 1, 0.5, 0.5,[],[-0.458333,-0.458333,0,-0.5,0.458333,-0.458333,0.5,0,0.458333,0.458333,0,0.5,-0.458333,0.458333,-0.5,0],0]
			]
			]
		],
		[
		[
			"Anchor",
			cr.behaviors.Anchor,
			6970469349457727
		]
		],
		false,
		false,
		1672241984175708,
		[],
		null
	]
,	[
		"t12",
		cr.plugins_.Sprite,
		false,
		[],
		1,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			300592170999103,
			[
				["imagenes/quitapause-sheet0.png", 289, 0, 0, 48, 48, 1, 0.5, 0.5,[],[-0.458333,-0.458333,0,-0.5,0.458333,-0.458333,0.5,0,0.458333,0.458333,0,0.5,-0.458333,0.458333,-0.5,0],0]
			]
			]
		],
		[
		[
			"Anchor",
			cr.behaviors.Anchor,
			8490200382595776
		]
		],
		false,
		false,
		7287575421225926,
		[],
		null
	]
,	[
		"t13",
		cr.plugins_.Sprite,
		false,
		[],
		1,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			2140901275096953,
			[
				["imagenes/sprite-sheet0.png", 155, 0, 0, 250, 250, 1, 0.5, 0.5,[],[],1]
			]
			]
		],
		[
		[
			"Solid",
			cr.behaviors.solid,
			8907700135113745
		]
		],
		false,
		false,
		3119313257442431,
		[],
		null
	]
,	[
		"t14",
		cr.plugins_.Sprite,
		false,
		[],
		0,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			1467942752341627,
			[
				["imagenes/jugar-sheet0.png", 6329, 1, 1, 241, 81, 1, 0.502075, 0.506173,[],[-0.46473,-0.395062,0.46473,-0.407407,0.468879,0.407407,-0.00414971,0.432099,-0.473029,0.407407],0]
			]
			]
,			[
			"ES",
			5,
			false,
			1,
			0,
			false,
			9690479956029708,
			[
				["imagenes/jugar-sheet0.png", 6329, 1, 83, 241, 81, 1, 0.502075, 0.506173,[],[-0.46473,-0.395062,0.46473,-0.407407,0.468879,0.407407,-0.00414971,0.432099,-0.473029,0.407407],0]
			]
			]
		],
		[
		],
		false,
		true,
		2983668919932067,
		[],
		null
	]
,	[
		"t15",
		cr.plugins_.Sprite,
		false,
		[],
		1,
		0,
		null,
		[
			[
			"gusano",
			6,
			true,
			1,
			0,
			false,
			1528405107122706,
			[
				["imagenes/snakes-sheet1.png", 21571, 1, 1, 156, 107, 1, 0.50641, 0.523364,[],[-0.365384,-0.214953,-0.00641024,-0.0654205,0.141026,-0.00934547,0.134616,-0.0280375,0.314103,0.214954,-0.185897,0.355141,-0.25641,0.11215,-0.224359,-0.0280375],0],
				["imagenes/snakes-sheet1.png", 21571, 1, 109, 156, 107, 1, 0.5, 0.504673,[],[-0.333333,-0.261682,0,-0.0560749,0.166667,-0.0186919,0.365385,0.299065,0,0.299065,-0.237179,0.112149,-0.211538,-0.00934589],0],
				["imagenes/snakes-sheet2.png", 19110, 1, 1, 156, 107, 1, 0.5, 0.504673,[],[-0.333333,-0.261682,0,-0.0280369,0.166667,-0.0186919,0.365385,0.299065,0,0.35514,-0.198718,0.0560751,-0.192308,-0.00934589],0],
				["imagenes/snakes-sheet2.png", 19110, 1, 109, 156, 107, 1, 0.5, 0.504673,[],[-0.333333,-0.261682,0,-0.0280369,0.153846,1.19209e-007,0.147436,-0.00934589,0.339744,0.261682,0,0.317757,-0.205128,0.0654201,-0.198718,-0.00934589],0]
			]
			]
,			[
			"boom",
			15,
			false,
			1,
			0,
			false,
			105280935752063,
			[
				["imagenes/snakes-sheet1.png", 21571, 158, 1, 44, 42, 1, 0.5, 0.5,[],[],0],
				["imagenes/snakes-sheet1.png", 21571, 203, 1, 44, 42, 1, 0.5, 0.5,[],[],0],
				["imagenes/snakes-sheet1.png", 21571, 158, 44, 44, 42, 1, 0.5, 0.5,[],[],0],
				["imagenes/snakes-sheet1.png", 21571, 203, 44, 44, 42, 1, 0.5, 0.5,[],[],0],
				["imagenes/snakes-sheet1.png", 21571, 158, 87, 44, 42, 1, 0.5, 0.5,[],[],0],
				["imagenes/snakes-sheet0.png", 168, 0, 0, 250, 250, 1, 0.5, 0.5,[],[],3]
			]
			]
		],
		[
		[
			"Sine",
			cr.behaviors.Sin,
			2604250821703165
		]
		],
		false,
		false,
		8517033831440909,
		[],
		null
	]
,	[
		"t16",
		cr.plugins_.Sprite,
		false,
		[],
		0,
		0,
		null,
		[
			[
			"Default",
			7,
			true,
			1,
			0,
			false,
			4735822644740926,
			[
				["imagenes/mono-sheet0.png", 23191, 1, 1, 123, 203, 1, 0.504065, 0.502463,[],[-0.00813004,-0.359606,0.252033,-0.35468,0.243902,-0.00492606,-0.357724,-0.019704,-0.00813004,0.0640389,0.056911,0.157635,-0.487805,-0.00492606],0],
				["imagenes/mono-sheet0.png", 23191, 125, 1, 123, 203, 1, 0.504065, 0.502463,[],[-0.097561,-0.256158,-0.00813004,-0.310345,0.284553,-0.374384,0.203252,-0.00492606,-0.121951,0.123153,0.154472,0.0985219,-0.398374,-0.00492606],0],
				["imagenes/mono-sheet1.png", 21752, 0, 0, 123, 203, 1, 0.504065, 0.502463,[],[-0.260163,-0.35468,-0.00813004,-0.261084,0.276423,-0.369458,0.162602,-0.00492606,0.219512,0.330049,-0.00813004,0.162562,0.0325199,0.172414,-0.357724,-0.00492606],0]
			]
			]
		],
		[
		],
		false,
		false,
		3699505883879878,
		[],
		null
	]
,	[
		"t17",
		cr.plugins_.Sprite,
		false,
		[],
		0,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			1335082511430699,
			[
				["imagenes/sombracaca-sheet0.png", 801, 0, 0, 46, 9, 1, 0.5, 0.555556,[],[-0.434783,-0.222223,0,-0.444445,0.434783,-0.222223,0.478261,-0.111112,0.434783,0.111111,0,0.222222,-0.434783,0.111111,-0.478261,-0.111112],0]
			]
			]
		],
		[
		],
		false,
		false,
		9481975920750518,
		[],
		null
	]
,	[
		"t18",
		cr.plugins_.Sprite,
		false,
		[],
		1,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			1939527108875911,
			[
				["imagenes/caca-sheet0.png", 6624, 0, 0, 48, 46, 1, 0.5, 0.5,[],[-0.229167,-0.217391,0,-0.478261,0.208333,-0.195652,0.375,0,0.4375,0.434783,0,0.478261,-0.458333,0.456522,-0.354167,0],0]
			]
			]
,			[
			"boom",
			5,
			false,
			1,
			0,
			false,
			2733759963657967,
			[
				["imagenes/snakes-sheet1.png", 21571, 158, 1, 44, 42, 1, 0.5, 0.5,[],[],0],
				["imagenes/snakes-sheet1.png", 21571, 203, 1, 44, 42, 1, 0.5, 0.5,[],[],0],
				["imagenes/snakes-sheet1.png", 21571, 158, 44, 44, 42, 1, 0.5, 0.5,[],[],0],
				["imagenes/snakes-sheet1.png", 21571, 203, 44, 44, 42, 1, 0.5, 0.5,[],[],0],
				["imagenes/snakes-sheet1.png", 21571, 158, 87, 44, 42, 1, 0.5, 0.5,[],[],0],
				["imagenes/snakes-sheet0.png", 168, 0, 0, 250, 250, 1, 0.5, 0.5,[],[],3]
			]
			]
		],
		[
		[
			"Sine",
			cr.behaviors.Sin,
			4741811704815149
		]
		],
		false,
		false,
		3396753224056077,
		[],
		null
	]
,	[
		"t19",
		cr.plugins_.Sprite,
		false,
		[],
		1,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			112369103309395,
			[
				["imagenes/sprite2-sheet0.png", 3205, 0, 0, 48, 48, 1, 0.5, 0.5,[],[-0.270833,-0.270833,0,-0.375,0.270833,-0.270833,0.270833,0,0.25,0.25,0,0.333333,-0.208333,0.208333,-0.25,0],0]
			]
			]
		],
		[
		[
			"Anchor",
			cr.behaviors.Anchor,
			6260176973369826
		]
		],
		false,
		false,
		7738622093273435,
		[],
		null
	]
,	[
		"t20",
		cr.plugins_.Sprite,
		false,
		[],
		0,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			1109132160370951,
			[
				["imagenes/bola-sheet0.png", 3210, 0, 0, 48, 48, 1, 0.520833, 0.520833,[],[-0.333333,-0.333333,-0.0208333,-0.416666,0.25,-0.291666,0.375,-0.0208333,0.291667,0.291667,-0.0208333,0.4375,-0.354166,0.3125,-0.458333,-0.0208333],0]
			]
			]
		],
		[
		],
		false,
		false,
		2395300832798972,
		[],
		null
	]
,	[
		"t21",
		cr.plugins_.Text,
		false,
		[],
		1,
		0,
		null,
		null,
		[
		[
			"Anchor",
			cr.behaviors.Anchor,
			5658105124564206
		]
		],
		false,
		false,
		6705981961733426,
		[],
		null
	]
,	[
		"t22",
		cr.plugins_.Text,
		false,
		[],
		1,
		0,
		null,
		null,
		[
		[
			"Anchor",
			cr.behaviors.Anchor,
			8584477505146285
		]
		],
		false,
		false,
		7235204044209109,
		[],
		null
	]
,	[
		"t23",
		cr.plugins_.Sprite,
		false,
		[],
		1,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			9902495585901038,
			[
				["imagenes/bolanada-sheet0.png", 2794, 0, 0, 48, 48, 1, 0.5, 0.5,[],[-0.270833,-0.270833,0,-0.354167,0.270833,-0.270833,0.375,0,0.291667,0.291667,0,0.4375,-0.291667,0.291667,-0.375,0],0]
			]
			]
		],
		[
		[
			"Anchor",
			cr.behaviors.Anchor,
			2279341649692886
		]
		],
		false,
		false,
		8504955776230032,
		[],
		null
	]
,	[
		"t24",
		cr.plugins_.Sprite,
		false,
		[],
		0,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			804356067443213,
			[
				["imagenes/transparentdark-sheet0.png", 834, 0, 0, 80, 80, 1, 0.5, 0.5,[],[-0.35,-0.35,0,-0.4875,0.35,-0.35,0.5,0,0.35,0.35,0,0.5,-0.35,0.35,-0.5,0],0]
			]
			]
		],
		[
		],
		false,
		false,
		6574423034265546,
		[],
		null
	]
,	[
		"t25",
		cr.plugins_.Sprite,
		false,
		[],
		1,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			5574898024939043,
			[
				["imagenes/transparentdark-sheet0.png", 834, 0, 0, 80, 80, 1, 0.5, 0.5,[],[-0.35,-0.35,0,-0.4875,0.35,-0.35,0.5,0,0.35,0.35,0,0.5,-0.35,0.35,-0.5,0],0]
			]
			]
		],
		[
		[
			"Anchor",
			cr.behaviors.Anchor,
			5264083314286775
		]
		],
		false,
		false,
		3877365198586427,
		[],
		null
	]
,	[
		"t26",
		cr.plugins_.Text,
		false,
		[],
		0,
		0,
		null,
		null,
		[
		],
		false,
		true,
		6366036840976227,
		[],
		null
	]
,	[
		"t27",
		cr.plugins_.Sprite,
		false,
		[],
		1,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			6510763297319279,
			[
				["imagenes/pisochico-sheet0.png", 4840, 0, 0, 50, 69, 1, 0.5, 0.507246,[],[-0.48,-0.492754,0,-0.507246,0.48,-0.492754,0.5,-0.0144924,0.48,0.478261,0,0.492754,-0.48,0.478261,-0.5,-0.0144924],0]
			]
			]
		],
		[
		[
			"Solid",
			cr.behaviors.solid,
			8605509260820821
		]
		],
		false,
		false,
		9769851648889711,
		[],
		null
	]
,	[
		"t28",
		cr.plugins_.Sprite,
		false,
		[],
		0,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			4446659076913537,
			[
				["imagenes/masvida-sheet0.png", 857, 0, 0, 32, 32, 1, 0.5, 0.5,[],[-0.34375,-0.34375,0,-0.3125,0.3125,-0.3125,0.375,0,0.1875,0.1875,0,0.3125,-0.21875,0.21875,-0.4375,0],0]
			]
			]
		],
		[
		],
		false,
		false,
		6143985665914309,
		[],
		null
	]
,	[
		"t29",
		cr.plugins_.Sprite,
		false,
		[],
		0,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			4652321131152251,
			[
				["imagenes/mata-sheet0.png", 18365, 0, 0, 104, 139, 1, 0.5, 0.503597,[],[-0.067308,-0.179856,0,-0.273381,0.028846,-0.151079,0.432692,-0.00719413,0.173077,0.251799,0,0.33813,-0.201923,0.273381,-0.25,-0.00719413],0]
			]
			]
		],
		[
		],
		false,
		false,
		2088202407934994,
		[],
		null
	]
,	[
		"t30",
		cr.plugins_.Sprite,
		false,
		[],
		0,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			9120519669495404,
			[
				["imagenes/mata2-sheet0.png", 14838, 0, 0, 163, 42, 1, 0.503067, 0.5,[],[-0.398773,-0.095238,0.435583,-0.261905,0.478527,0,0.453987,0.333333,-0.466258,0.357143,-0.429448,0],0]
			]
			]
		],
		[
		],
		false,
		false,
		2860667230468269,
		[],
		null
	]
,	[
		"t31",
		cr.plugins_.Sprite,
		false,
		[],
		1,
		0,
		null,
		[
			[
			"nohay",
			5,
			false,
			1,
			0,
			false,
			7549069595473165,
			[
				["imagenes/dispara-sheet0.png", 11891, 0, 0, 160, 160, 1, 0.5, 0.5,[],[-0.35,-0.35,0,-0.49375,0.35,-0.35,0.5,0,0.35,0.35,0,0.5,-0.35,0.35,-0.5,0],0]
			]
			]
,			[
			"sihay",
			5,
			false,
			1,
			0,
			false,
			9539583286765503,
			[
				["imagenes/dispara-sheet1.png", 17528, 0, 0, 160, 160, 1, 0.5, 0.5,[],[-0.35,-0.35,0,-0.49375,0.35,-0.35,0.5,0,0.35,0.35,0,0.5,-0.35,0.35,-0.5,0],0]
			]
			]
		],
		[
		[
			"Anchor",
			cr.behaviors.Anchor,
			4034207359984805
		]
		],
		false,
		false,
		4673467154289485,
		[],
		null
	]
,	[
		"t32",
		cr.plugins_.Sprite,
		false,
		[],
		2,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			8207807531789788,
			[
				["imagenes/bala-sheet0.png", 3148, 0, 0, 48, 48, 1, 0.5, 0.5,[],[-0.3125,-0.3125,0,-0.395833,0.270833,-0.270833,0.395833,0,0.3125,0.3125,0,0.458333,-0.333333,0.333333,-0.4375,0],0]
			]
			]
,			[
			"boom",
			15,
			true,
			1,
			0,
			false,
			9680090328560423,
			[
				["imagenes/snakes-sheet1.png", 21571, 158, 1, 44, 42, 1, 0.5, 0.5,[],[],0],
				["imagenes/snakes-sheet1.png", 21571, 203, 1, 44, 42, 1, 0.5, 0.5,[],[],0],
				["imagenes/snakes-sheet1.png", 21571, 158, 44, 44, 42, 1, 0.5, 0.5,[],[],0],
				["imagenes/snakes-sheet1.png", 21571, 203, 44, 44, 42, 1, 0.5, 0.5,[],[],0],
				["imagenes/snakes-sheet1.png", 21571, 158, 87, 44, 42, 1, 0.5, 0.5,[],[],0],
				["imagenes/snakes-sheet0.png", 168, 0, 0, 250, 250, 1, 0.5, 0.5,[],[],3]
			]
			]
		],
		[
		[
			"Bullet",
			cr.behaviors.Bullet,
			4188691302575283
		]
,		[
			"DestroyOutsideLayout",
			cr.behaviors.destroy,
			1694088490645578
		]
		],
		false,
		false,
		7550044019233307,
		[],
		null
	]
,	[
		"t33",
		cr.plugins_.Sprite,
		false,
		[],
		0,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			8992915038848387,
			[
				["imagenes/juanman2-sheet0.png", 15292, 0, 0, 127, 217, 1, 0.503937, 0.502304,[],[-0.181102,-0.313364,-0.00787401,-0.488479,0.330709,-0.40553,0.173228,-0.00460812,0.15748,0.299539,-0.00787401,0.442396,-0.07874,0.248848,-0.047244,-0.00460812],0]
			]
			]
		],
		[
		],
		false,
		false,
		8986840832063021,
		[],
		null
	]
,	[
		"t34",
		cr.plugins_.Sprite,
		false,
		[],
		0,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			4567643709267695,
			[
				["imagenes/snakes-sheet0.png", 168, 0, 0, 250, 250, 1, 0.5, 0.5,[],[],3]
			]
			]
		],
		[
		],
		false,
		false,
		4378656539541522,
		[],
		null
	]
,	[
		"t35",
		cr.plugins_.TiledBg,
		false,
		[],
		0,
		0,
		["imagenes/tiledbackground2.png", 169, 3],
		null,
		[
		],
		false,
		false,
		9071108342024731,
		[],
		null
	]
,	[
		"t36",
		cr.plugins_.Sprite,
		false,
		[],
		0,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			7707455060593889,
			[
				["imagenes/fondosplash-sheet0.png", 264575, 0, 0, 1390, 987, 1, 0.5, 0.500507,[],[],1]
			]
			]
		],
		[
		],
		false,
		true,
		8597125381957576,
		[],
		null
	]
,	[
		"t37",
		cr.plugins_.Sprite,
		false,
		[],
		1,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			1863931961575049,
			[
				["imagenes/gfhfgth-sheet0.png", 76008, 0, 0, 538, 183, 1, 0.5, 0.502732,[],[-0.460966,-0.387978,0,-0.251366,0.412639,-0.245901,0.492565,-0.00546423,0.483271,0.448088,0,0.480875,-0.486989,0.459017,-0.451673,-0.00546423],0]
			]
			]
		],
		[
		[
			"Sine",
			cr.behaviors.Sin,
			8139309104653209
		]
		],
		false,
		true,
		278946677678561,
		[],
		null
	]
,	[
		"t38",
		cr.plugins_.Sprite,
		false,
		[],
		0,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			7155442774768808,
			[
				["imagenes/creditos-sheet0.png", 7940, 1, 1, 241, 81, 1, 0.502075, 0.506173,[],[-0.46473,-0.395062,0.46473,-0.407407,0.468879,0.407407,-0.00414971,0.432099,-0.473029,0.407407],0]
			]
			]
,			[
			"ES",
			5,
			false,
			1,
			0,
			false,
			6249134912351921,
			[
				["imagenes/creditos-sheet0.png", 7940, 1, 83, 241, 81, 1, 0.502075, 0.506173,[],[-0.46473,-0.395062,0.46473,-0.407407,0.468879,0.407407,-0.00414971,0.432099,-0.473029,0.407407],0]
			]
			]
		],
		[
		],
		false,
		true,
		6539863324908262,
		[],
		null
	]
,	[
		"t39",
		cr.plugins_.Text,
		false,
		[],
		0,
		0,
		null,
		null,
		[
		],
		false,
		true,
		1504163378926336,
		[],
		null
	]
,	[
		"t40",
		cr.plugins_.Sprite,
		false,
		[],
		0,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			9770729920300219,
			[
				["imagenes/bolamundo1-sheet0.png", 1508, 0, 0, 36, 36, 1, 0.5, 0.5,[],[-0.305556,-0.305556,0,-0.444444,0.305556,-0.305556,0.444444,0,0.305556,0.305556,0,0.444444,-0.305556,0.305556,-0.444444,0],0]
			]
			]
		],
		[
		],
		false,
		false,
		9671812209879328,
		[],
		null
	]
,	[
		"t41",
		cr.plugins_.Text,
		false,
		[],
		0,
		0,
		null,
		null,
		[
		],
		false,
		false,
		2158233971110892,
		[],
		null
	]
,	[
		"t42",
		cr.plugins_.Sprite,
		false,
		[],
		0,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			633341539972456,
			[
				["imagenes/bloqueada-sheet0.png", 2261, 1, 1, 50, 69, 1, 0.5, 0.507246,[],[-0.48,-0.492754,0,-0.507246,0.48,-0.492754,0.5,-0.0144924,0.48,0.478261,0,0.492754,-0.48,0.478261,-0.5,-0.0144924],0]
			]
			]
,			[
			"ani2",
			5,
			false,
			1,
			0,
			false,
			2662302986275388,
			[
				["imagenes/bloqueada-sheet0.png", 2261, 52, 1, 50, 69, 1, 0.5, 0.507246,[],[-0.48,-0.492754,0,-0.507246,0.48,-0.492754,0.5,-0.0144924,0.48,0.478261,0,0.492754,-0.48,0.478261,-0.5,-0.0144924],0]
			]
			]
		],
		[
		],
		false,
		false,
		9705338935115923,
		[],
		null
	]
,	[
		"t43",
		cr.plugins_.Sprite,
		false,
		[],
		0,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			7674548110890294,
			[
				["imagenes/bloqueada2-sheet0.png", 2518, 0, 0, 50, 69, 1, 0.5, 0.507246,[],[-0.48,-0.492754,0,-0.507246,0.48,-0.492754,0.5,-0.0144924,0.48,0.478261,0,0.492754,-0.48,0.478261,-0.5,-0.0144924],0]
			]
			]
,			[
			"ani2",
			5,
			false,
			1,
			0,
			false,
			8069278852433229,
			[
				["imagenes/bloqueada-sheet0.png", 2261, 52, 1, 50, 69, 1, 0.5, 0.507246,[],[-0.48,-0.492754,0,-0.507246,0.48,-0.492754,0.5,-0.0144924,0.48,0.478261,0,0.492754,-0.48,0.478261,-0.5,-0.0144924],0]
			]
			]
		],
		[
		],
		false,
		false,
		9328689042825252,
		[],
		null
	]
,	[
		"t44",
		cr.plugins_.Sprite,
		false,
		[],
		0,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			8431542582549848,
			[
				["imagenes/bloqueada2-sheet0.png", 2518, 0, 0, 50, 69, 1, 0.5, 0.507246,[],[-0.48,-0.492754,0,-0.507246,0.48,-0.492754,0.5,-0.0144924,0.48,0.478261,0,0.492754,-0.48,0.478261,-0.5,-0.0144924],0]
			]
			]
,			[
			"ani2",
			5,
			false,
			1,
			0,
			false,
			9601175053117746,
			[
				["imagenes/bloqueada-sheet0.png", 2261, 52, 1, 50, 69, 1, 0.5, 0.507246,[],[-0.48,-0.492754,0,-0.507246,0.48,-0.492754,0.5,-0.0144924,0.48,0.478261,0,0.492754,-0.48,0.478261,-0.5,-0.0144924],0]
			]
			]
		],
		[
		],
		false,
		false,
		9395355430107365,
		[],
		null
	]
,	[
		"t45",
		cr.plugins_.Sprite,
		false,
		[],
		0,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			788927337732006,
			[
				["imagenes/bloqueada2-sheet0.png", 2518, 0, 0, 50, 69, 1, 0.5, 0.507246,[],[-0.48,-0.492754,0,-0.507246,0.48,-0.492754,0.5,-0.0144924,0.48,0.478261,0,0.492754,-0.48,0.478261,-0.5,-0.0144924],0]
			]
			]
,			[
			"ani2",
			5,
			false,
			1,
			0,
			false,
			5540409204269511,
			[
				["imagenes/bloqueada-sheet0.png", 2261, 1, 1, 50, 69, 1, 0.5, 0.507246,[],[-0.48,-0.492754,0,-0.507246,0.48,-0.492754,0.5,-0.0144924,0.48,0.478261,0,0.492754,-0.48,0.478261,-0.5,-0.0144924],0]
			]
			]
		],
		[
		],
		false,
		false,
		8638882855095188,
		[],
		null
	]
,	[
		"t46",
		cr.plugins_.Sprite,
		false,
		[],
		0,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			3352196411611828,
			[
				["imagenes/bloqueada2-sheet0.png", 2518, 0, 0, 50, 69, 1, 0.5, 0.507246,[],[-0.48,-0.492754,0,-0.507246,0.48,-0.492754,0.5,-0.0144924,0.48,0.478261,0,0.492754,-0.48,0.478261,-0.5,-0.0144924],0]
			]
			]
,			[
			"ani2",
			5,
			false,
			1,
			0,
			false,
			5678365750854093,
			[
				["imagenes/bloqueada-sheet0.png", 2261, 1, 1, 50, 69, 1, 0.5, 0.507246,[],[-0.48,-0.492754,0,-0.507246,0.48,-0.492754,0.5,-0.0144924,0.48,0.478261,0,0.492754,-0.48,0.478261,-0.5,-0.0144924],0]
			]
			]
		],
		[
		],
		false,
		false,
		4781429001147187,
		[],
		null
	]
,	[
		"t47",
		cr.plugins_.Sprite,
		false,
		[],
		0,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			6903448400236158,
			[
				["imagenes/bloqueada2-sheet0.png", 2518, 0, 0, 50, 69, 1, 0.5, 0.507246,[],[-0.48,-0.492754,0,-0.507246,0.48,-0.492754,0.5,-0.0144924,0.48,0.478261,0,0.492754,-0.48,0.478261,-0.5,-0.0144924],0]
			]
			]
,			[
			"ani2",
			5,
			false,
			1,
			0,
			false,
			8833913999548733,
			[
				["imagenes/bloqueada-sheet0.png", 2261, 1, 1, 50, 69, 1, 0.5, 0.507246,[],[-0.48,-0.492754,0,-0.507246,0.48,-0.492754,0.5,-0.0144924,0.48,0.478261,0,0.492754,-0.48,0.478261,-0.5,-0.0144924],0]
			]
			]
		],
		[
		],
		false,
		false,
		2250561164556172,
		[],
		null
	]
,	[
		"t48",
		cr.plugins_.Sprite,
		false,
		[],
		0,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			8402009846870507,
			[
				["imagenes/bloqueada2-sheet0.png", 2518, 0, 0, 50, 69, 1, 0.5, 0.507246,[],[-0.48,-0.492754,0,-0.507246,0.48,-0.492754,0.5,-0.0144924,0.48,0.478261,0,0.492754,-0.48,0.478261,-0.5,-0.0144924],0]
			]
			]
,			[
			"ani2",
			5,
			false,
			1,
			0,
			false,
			8744010544959883,
			[
				["imagenes/bloqueada-sheet0.png", 2261, 1, 1, 50, 69, 1, 0.5, 0.507246,[],[-0.48,-0.492754,0,-0.507246,0.48,-0.492754,0.5,-0.0144924,0.48,0.478261,0,0.492754,-0.48,0.478261,-0.5,-0.0144924],0]
			]
			]
		],
		[
		],
		false,
		false,
		5804635661755248,
		[],
		null
	]
,	[
		"t49",
		cr.plugins_.Sprite,
		false,
		[],
		0,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			7960671012659593,
			[
				["imagenes/bloqueada2-sheet0.png", 2518, 0, 0, 50, 69, 1, 0.5, 0.507246,[],[-0.48,-0.492754,0,-0.507246,0.48,-0.492754,0.5,-0.0144924,0.48,0.478261,0,0.492754,-0.48,0.478261,-0.5,-0.0144924],0]
			]
			]
,			[
			"ani2",
			5,
			false,
			1,
			0,
			false,
			9054397925538395,
			[
				["imagenes/bloqueada-sheet0.png", 2261, 1, 1, 50, 69, 1, 0.5, 0.507246,[],[-0.48,-0.492754,0,-0.507246,0.48,-0.492754,0.5,-0.0144924,0.48,0.478261,0,0.492754,-0.48,0.478261,-0.5,-0.0144924],0]
			]
			]
		],
		[
		],
		false,
		false,
		6853725359869142,
		[],
		null
	]
,	[
		"t50",
		cr.plugins_.Sprite,
		false,
		[],
		0,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			382002316521787,
			[
				["imagenes/bloqueada2-sheet0.png", 2518, 0, 0, 50, 69, 1, 0.5, 0.507246,[],[-0.48,-0.492754,0,-0.507246,0.48,-0.492754,0.5,-0.0144924,0.48,0.478261,0,0.492754,-0.48,0.478261,-0.5,-0.0144924],0]
			]
			]
,			[
			"ani2",
			5,
			false,
			1,
			0,
			false,
			4940207228196566,
			[
				["imagenes/bloqueada-sheet0.png", 2261, 1, 1, 50, 69, 1, 0.5, 0.507246,[],[-0.48,-0.492754,0,-0.507246,0.48,-0.492754,0.5,-0.0144924,0.48,0.478261,0,0.492754,-0.48,0.478261,-0.5,-0.0144924],0]
			]
			]
		],
		[
		],
		false,
		false,
		4206144111744816,
		[],
		null
	]
,	[
		"t51",
		cr.plugins_.Sprite,
		false,
		[],
		0,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			4332058642536274,
			[
				["imagenes/bloqueada2-sheet0.png", 2518, 0, 0, 50, 69, 1, 0.5, 0.507246,[],[-0.48,-0.492754,0,-0.507246,0.48,-0.492754,0.5,-0.0144924,0.48,0.478261,0,0.492754,-0.48,0.478261,-0.5,-0.0144924],0]
			]
			]
,			[
			"ani2",
			5,
			false,
			1,
			0,
			false,
			7549327747464438,
			[
				["imagenes/bloqueada-sheet0.png", 2261, 1, 1, 50, 69, 1, 0.5, 0.507246,[],[-0.48,-0.492754,0,-0.507246,0.48,-0.492754,0.5,-0.0144924,0.48,0.478261,0,0.492754,-0.48,0.478261,-0.5,-0.0144924],0]
			]
			]
		],
		[
		],
		false,
		false,
		7412497067424342,
		[],
		null
	]
,	[
		"t52",
		cr.plugins_.Sprite,
		false,
		[],
		0,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			3611473242840901,
			[
				["imagenes/bloqueada2-sheet0.png", 2518, 0, 0, 50, 69, 1, 0.5, 0.507246,[],[-0.48,-0.492754,0,-0.507246,0.48,-0.492754,0.5,-0.0144924,0.48,0.478261,0,0.492754,-0.48,0.478261,-0.5,-0.0144924],0]
			]
			]
,			[
			"ani2",
			5,
			false,
			1,
			0,
			false,
			9885845505785793,
			[
				["imagenes/bloqueada-sheet0.png", 2261, 1, 1, 50, 69, 1, 0.5, 0.507246,[],[-0.48,-0.492754,0,-0.507246,0.48,-0.492754,0.5,-0.0144924,0.48,0.478261,0,0.492754,-0.48,0.478261,-0.5,-0.0144924],0]
			]
			]
		],
		[
		],
		false,
		false,
		399282517412385,
		[],
		null
	]
,	[
		"t53",
		cr.plugins_.Sprite,
		false,
		[],
		0,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			4096323446823411,
			[
				["imagenes/bloqueada2-sheet0.png", 2518, 0, 0, 50, 69, 1, 0.5, 0.507246,[],[-0.48,-0.492754,0,-0.507246,0.48,-0.492754,0.5,-0.0144924,0.48,0.478261,0,0.492754,-0.48,0.478261,-0.5,-0.0144924],0]
			]
			]
,			[
			"ani2",
			5,
			false,
			1,
			0,
			false,
			5530852414667829,
			[
				["imagenes/bloqueada-sheet0.png", 2261, 1, 1, 50, 69, 1, 0.5, 0.507246,[],[-0.48,-0.492754,0,-0.507246,0.48,-0.492754,0.5,-0.0144924,0.48,0.478261,0,0.492754,-0.48,0.478261,-0.5,-0.0144924],0]
			]
			]
		],
		[
		],
		false,
		false,
		5881081573672048,
		[],
		null
	]
,	[
		"t54",
		cr.plugins_.Sprite,
		false,
		[],
		0,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			2522404154420169,
			[
				["imagenes/sonido-sheet0.png", 359, 0, 0, 48, 48, 1, 0.5, 0.5,[],[-0.458333,-0.458333,0,-0.5,0.458333,-0.458333,0.5,0,0.458333,0.458333,0,0.5,-0.458333,0.458333,-0.5,0],0]
			]
			]
		],
		[
		],
		false,
		true,
		9091541927941428,
		[],
		null
	]
,	[
		"t55",
		cr.plugins_.Sprite,
		false,
		[],
		0,
		0,
		null,
		[
			[
			"Default",
			15,
			true,
			1,
			0,
			false,
			9436010920997901,
			[
				["imagenes/hablamision-sheet0.png", 45693, 1, 1, 492, 204, 1, 0.5, 0.5,[],[-0.49187,-0.480392,0,-0.5,0.49187,-0.480392,0.49187,0.480392,0,0.5,-0.49187,0.480392],0],
				["imagenes/hablamision-sheet0.png", 45693, 1, 206, 492, 204, 1, 0.5, 0.5,[],[-0.49187,-0.480392,0,-0.5,0.49187,-0.480392,0.49187,0.480392,0,0.5,-0.49187,0.480392],0],
				["imagenes/hablamision-sheet1.png", 45635, 1, 1, 492, 204, 1, 0.5, 0.5,[],[-0.49187,-0.480392,0,-0.5,0.49187,-0.480392,0.49187,0.480392,0,0.5,-0.49187,0.480392],0],
				["imagenes/hablamision-sheet1.png", 45635, 1, 206, 492, 204, 1, 0.5, 0.5,[],[-0.49187,-0.480392,0,-0.5,0.49187,-0.480392,0.49187,0.480392,0,0.5,-0.49187,0.480392],0]
			]
			]
		],
		[
		],
		false,
		false,
		4731890676757827,
		[],
		null
	]
,	[
		"t56",
		cr.plugins_.Sprite,
		false,
		[],
		0,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			9209584665568865,
			[
				["imagenes/continue-sheet0.png", 5547, 0, 0, 241, 81, 1, 0.502075, 0.506173,[],[-0.46473,-0.395062,0.46473,-0.407407,0.468879,0.407407,-0.00414971,0.432099,-0.473029,0.407407],0]
			]
			]
		],
		[
		],
		false,
		false,
		3432426764537808,
		[],
		null
	]
,	[
		"t57",
		cr.plugins_.Sprite,
		false,
		[],
		1,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			4007384365926687,
			[
				["imagenes/tochh-sheet0.png", 5233, 0, 0, 82, 82, 1, 0.512195, 0.5,[],[-0.402439,-0.390244,-0.0121951,-0.243902,0.463415,-0.47561,0.231707,0.243902,-0.0121951,0.463415,-0.439024,0.426829,-0.390244,0],0]
			]
			]
		],
		[
		[
			"Sine",
			cr.behaviors.Sin,
			6957339480186592
		]
		],
		false,
		false,
		9223211894745665,
		[],
		null
	]
,	[
		"t58",
		cr.plugins_.Text,
		false,
		[],
		0,
		0,
		null,
		null,
		[
		],
		false,
		false,
		3121173415201315,
		[],
		null
	]
,	[
		"t59",
		cr.plugins_.TextBox,
		false,
		[],
		0,
		0,
		null,
		null,
		[
		],
		false,
		false,
		8496948621362893,
		[],
		null
	]
,	[
		"t60",
		cr.plugins_.Text,
		false,
		[],
		0,
		0,
		null,
		null,
		[
		],
		false,
		false,
		102235538957635,
		[],
		null
	]
,	[
		"t61",
		cr.plugins_.TextBox,
		false,
		[],
		0,
		0,
		null,
		null,
		[
		],
		false,
		false,
		9397741831849457,
		[],
		null
	]
,	[
		"t62",
		cr.plugins_.Text,
		false,
		[],
		0,
		0,
		null,
		null,
		[
		],
		false,
		false,
		7672913177251211,
		[],
		null
	]
,	[
		"t63",
		cr.plugins_.Sprite,
		false,
		[],
		0,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			2192036160508229,
			[
				["imagenes/dfsedrulo-sheet0.png", 5422, 0, 0, 163, 53, 1, 0.503067, 0.509434,[],[-0.460123,-0.377359,-0.00613448,-0.245283,0.263803,0.207547,0.423312,-0.018868,0.447852,0.339623,-0.00613448,0.301887,-0.411043,0.207547,-0.478528,-0.018868],0]
			]
			]
		],
		[
		],
		false,
		true,
		4943298888316284,
		[],
		null
	]
,	[
		"t64",
		cr.plugins_.Sprite,
		false,
		[],
		0,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			7925108955242661,
			[
				["imagenes/continue2-sheet0.png", 5527, 0, 0, 241, 81, 1, 0.502075, 0.506173,[],[-0.46473,-0.395062,0.46473,-0.407407,0.468879,0.407407,-0.00414971,0.432099,-0.473029,0.407407],0]
			]
			]
		],
		[
		],
		false,
		false,
		4625162063518331,
		[],
		null
	]
,	[
		"t65",
		cr.plugins_.TiledBg,
		false,
		[],
		0,
		0,
		["imagenes/tiledbackground2.png", 169, 3],
		null,
		[
		],
		false,
		false,
		3096580525410418,
		[],
		null
	]
,	[
		"t66",
		cr.plugins_.Sprite,
		false,
		[],
		0,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			1174619062182277,
			[
				["imagenes/sprite3-sheet0.png", 338435, 0, 0, 1280, 1024, 1, 0.5, 0.5,[],[],1]
			]
			]
		],
		[
		],
		false,
		false,
		4426370056589679,
		[],
		null
	]
,	[
		"t67",
		cr.plugins_.Sprite,
		false,
		[],
		0,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			2712055097167321,
			[
				["imagenes/lineas-sheet0.png", 2583, 0, 0, 808, 71, 1, 0.5, 0.507042,[],[-0.449257,0.0704228,0,-0.338028,0.464109,-0.0985912,0.498762,-0.0140842,0.5,0.492958,-0.5,0.492958,-0.491337,-0.0140842],0]
			]
			]
		],
		[
		],
		false,
		false,
		7544618320999334,
		[],
		null
	]
,	[
		"t68",
		cr.plugins_.Text,
		false,
		[],
		0,
		0,
		null,
		null,
		[
		],
		false,
		false,
		9360727562930166,
		[],
		null
	]
,	[
		"t69",
		cr.plugins_.Text,
		false,
		[],
		1,
		0,
		null,
		null,
		[
		[
			"Anchor",
			cr.behaviors.Anchor,
			2053798148476585
		]
		],
		false,
		false,
		2689275984145787,
		[],
		null
	]
,	[
		"t70",
		cr.plugins_.Text,
		false,
		[],
		1,
		0,
		null,
		null,
		[
		[
			"Anchor",
			cr.behaviors.Anchor,
			3248035405501922
		]
		],
		false,
		false,
		1604464134626496,
		[],
		null
	]
,	[
		"t71",
		cr.plugins_.Sprite,
		false,
		[],
		1,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			5358087197571648,
			[
				["imagenes/scoree-sheet0.png", 835, 0, 0, 203, 50, 1, 0.502463, 0.5,[],[-0.482759,-0.42,-0.00492606,-0.5,0.477833,-0.42,0.497537,0,0.482759,0.44,-0.00492606,0.5,-0.482759,0.42,-0.502463,0],0]
			]
			]
		],
		[
		[
			"Anchor",
			cr.behaviors.Anchor,
			3071272796499541
		]
		],
		false,
		false,
		5327647893119758,
		[],
		null
	]
,	[
		"t72",
		cr.plugins_.TiledBg,
		false,
		[],
		0,
		0,
		["imagenes/tiledbackground5.png", 103979, 3],
		null,
		[
		],
		false,
		false,
		721416887043912,
		[],
		null
	]
,	[
		"t73",
		cr.plugins_.Sprite,
		false,
		[],
		2,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			9270157320822478,
			[
				["imagenes/sprite6-sheet0.png", 4156, 0, 0, 487, 66, 1, 0.501027, 0.5,[],[-0.498973,-0.484848,-0.00205368,-0.5,0.49692,-0.484848,0.49692,0.484848,-0.00205368,0.5,-0.498973,0.484848],0]
			]
			]
		],
		[
		[
			"Solid",
			cr.behaviors.solid,
			4265390417655359
		]
,		[
			"Sine",
			cr.behaviors.Sin,
			1038379230714028
		]
		],
		false,
		false,
		2429973316803297,
		[],
		null
	]
,	[
		"t74",
		cr.plugins_.Sprite,
		false,
		[],
		0,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			5486904305187881,
			[
				["imagenes/palooo-sheet0.png", 43781, 0, 0, 183, 144, 1, 0.502732, 0.5,[],[-0.327869,-0.277778,-0.00546423,-0.479167,0.349727,-0.3125,0.47541,0,0.306011,0.256944,-0.00546423,0.5,-0.344262,0.298611,-0.464481,0],0]
			]
			]
		],
		[
		],
		false,
		false,
		4721353231193011,
		[],
		null
	]
,	[
		"t75",
		cr.plugins_.Sprite,
		false,
		[],
		2,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			9785132000051536,
			[
				["imagenes/pierdd-sheet0.png", 6786, 0, 0, 487, 66, 1, 0.501027, 0.5,[],[-0.498973,-0.484848,-0.00205368,-0.5,0.49692,-0.484848,0.49692,0.484848,-0.00205368,0.5,-0.498973,0.484848],0]
			]
			]
		],
		[
		[
			"Solid",
			cr.behaviors.solid,
			1433353543918368
		]
,		[
			"Jumpthru",
			cr.behaviors.jumpthru,
			8784167181323408
		]
		],
		false,
		false,
		2721280382116708,
		[],
		null
	]
,	[
		"t76",
		cr.plugins_.Sprite,
		false,
		[],
		1,
		0,
		null,
		[
			[
			"Default",
			10,
			true,
			1,
			0,
			false,
			3785841329739973,
			[
				["imagenes/culbraimputa-sheet0.png", 12678, 1, 1, 156, 107, 1, 0.5, 0.504673,[],[-0.461538,-0.448598,0,-0.121495,0.24359,-0.130841,0.282051,-0.00934589,0.442308,0.411215,0,0.336448,-0.333333,0.252336,-0.282051,-0.00934589],0],
				["imagenes/culbraimputa-sheet0.png", 12678, 1, 109, 156, 107, 1, 0.5, 0.504673,[],[-0.461538,-0.448598,0,-0.158879,0.211538,-0.0841119,0.230769,-0.00934589,0.410256,0.364486,0,0.224299,-0.339744,0.261682,-0.294872,-0.00934589],0]
			]
			]
		],
		[
		[
			"Sine",
			cr.behaviors.Sin,
			3481893332234744
		]
		],
		false,
		false,
		2811047180182565,
		[],
		null
	]
,	[
		"t77",
		cr.plugins_.Sprite,
		false,
		[],
		1,
		0,
		null,
		[
			[
			"Default",
			20,
			true,
			1,
			0,
			true,
			2487217025535785,
			[
				["imagenes/bolaq-sheet0.png", 6806, 1, 1, 73, 82, 1, 0.506849, 0.5,[],[-0.342465,-0.353659,-0.0136983,-0.5,0.342466,-0.365854,0.493151,0,0.328767,0.353659,-0.0136983,0.5,-0.342465,0.353659,-0.506849,0],0],
				["imagenes/bolaq-sheet1.png", 10377, 0, 0, 73, 82, 1, 0.506849, 0.5,[],[-0.273972,-0.292683,-0.0136983,-0.365854,0.260274,-0.292683,0.465754,0,0.342466,0.365854,-0.0136983,0.5,-0.342465,0.353659,-0.465753,0],0],
				["imagenes/bolaq-sheet2.png", 10569, 0, 0, 73, 82, 1, 0.506849, 0.5,[],[-0.205479,-0.231707,-0.0136983,-0.268293,0.191781,-0.231707,0.438356,0,0.328767,0.353659,-0.0136983,0.487805,-0.342465,0.353659,-0.424657,0],0]
			]
			]
,			[
			"boom",
			5,
			false,
			1,
			0,
			false,
			3877837440493262,
			[
				["imagenes/snakes-sheet1.png", 21571, 158, 1, 44, 42, 1, 0.5, 0.5,[],[],0],
				["imagenes/snakes-sheet1.png", 21571, 203, 1, 44, 42, 1, 0.5, 0.5,[],[],0],
				["imagenes/snakes-sheet1.png", 21571, 158, 44, 44, 42, 1, 0.5, 0.5,[],[],0],
				["imagenes/snakes-sheet1.png", 21571, 203, 44, 44, 42, 1, 0.5, 0.5,[],[],0],
				["imagenes/snakes-sheet1.png", 21571, 158, 87, 44, 42, 1, 0.5, 0.5,[],[],0],
				["imagenes/bolaq-sheet0.png", 6806, 75, 1, 11, 10, 1, 0.545455, 0.5,[],[],0]
			]
			]
		],
		[
		[
			"Solid",
			cr.behaviors.solid,
			4015575713195203
		]
		],
		false,
		false,
		2772288443569037,
		[],
		null
	]
,	[
		"t78",
		cr.plugins_.Sprite,
		false,
		[],
		0,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			371483019073027,
			[
				["imagenes/bolamundo2-sheet0.png", 1464, 0, 0, 36, 36, 1, 0.5, 0.5,[],[-0.305556,-0.305556,0,-0.444444,0.305556,-0.305556,0.444444,0,0.305556,0.305556,0,0.444444,-0.305556,0.305556,-0.444444,0],0]
			]
			]
		],
		[
		],
		false,
		false,
		7760811276802815,
		[],
		null
	]
,	[
		"t79",
		cr.plugins_.Sprite,
		false,
		[],
		0,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			7004131727548206,
			[
				["imagenes/levelcomplete-sheet0.png", 24186, 0, 0, 466, 82, 1, 0.5, 0.512195,[],[-0.476395,-0.378049,0,-0.292683,0.484979,-0.426829,0.465665,0.292683,0,-0.0243901,-0.405579,-0.0487801,-0.465665,-0.0121951],0]
			]
			]
		],
		[
		],
		false,
		false,
		2732537632303617,
		[],
		null
	]
,	[
		"t80",
		cr.plugins_.Sprite,
		false,
		[],
		0,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			5331526386657524,
			[
				["imagenes/idioma-sheet0.png", 7776, 1, 1, 241, 81, 1, 0.502075, 0.506173,[],[-0.46473,-0.395062,0.46473,-0.407407,0.468879,0.407407,-0.00414971,0.432099,-0.473029,0.407407],0]
			]
			]
,			[
			"ES",
			5,
			false,
			1,
			0,
			false,
			7509415100904219,
			[
				["imagenes/idioma-sheet0.png", 7776, 1, 83, 241, 81, 1, 0.502075, 0.506173,[],[-0.46473,-0.395062,0.46473,-0.407407,0.468879,0.407407,-0.00414971,0.432099,-0.473029,0.407407],0]
			]
			]
		],
		[
		],
		false,
		true,
		991389452667821,
		[],
		null
	]
,	[
		"t81",
		cr.plugins_.Sprite,
		false,
		[],
		0,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			5170335115082249,
			[
				["imagenes/historia-sheet0.png", 7645, 1, 1, 241, 81, 1, 0.502075, 0.506173,[],[-0.46473,-0.395062,0.46473,-0.407407,0.468879,0.407407,-0.00414971,0.432099,-0.473029,0.407407],0]
			]
			]
,			[
			"ES",
			5,
			false,
			1,
			0,
			false,
			9044792951699945,
			[
				["imagenes/historia-sheet0.png", 7645, 1, 83, 241, 81, 1, 0.502075, 0.506173,[],[-0.46473,-0.395062,0.46473,-0.407407,0.468879,0.407407,-0.00414971,0.432099,-0.473029,0.407407],0]
			]
			]
		],
		[
		],
		false,
		true,
		1970281911878449,
		[],
		null
	]
,	[
		"t82",
		cr.plugins_.Sprite,
		false,
		[],
		0,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			6092084290918193,
			[
				["imagenes/es-sheet0.png", 5960, 0, 0, 241, 81, 1, 0.502075, 0.506173,[],[-0.46473,-0.395062,0.46473,-0.407407,0.468879,0.407407,-0.00414971,0.432099,-0.473029,0.407407],0]
			]
			]
		],
		[
		],
		false,
		false,
		7907452518884137,
		[],
		null
	]
,	[
		"t83",
		cr.plugins_.Sprite,
		false,
		[],
		0,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			1391206120494354,
			[
				["imagenes/en-sheet0.png", 5289, 0, 0, 241, 81, 1, 0.502075, 0.506173,[],[-0.46473,-0.395062,0.46473,-0.407407,0.468879,0.407407,-0.00414971,0.432099,-0.473029,0.407407],0]
			]
			]
		],
		[
		],
		false,
		false,
		5002708556401787,
		[],
		null
	]
,	[
		"t84",
		cr.plugins_.Sprite,
		false,
		[],
		0,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			3967807078644522,
			[
				["imagenes/fondo1copia-sheet0.png", 206495, 0, 0, 1390, 987, 1, 0.5, 0.500507,[],[],1]
			]
			]
		],
		[
		],
		false,
		false,
		4912216748453287,
		[],
		null
	]
,	[
		"t85",
		cr.plugins_.Text,
		false,
		[],
		0,
		0,
		null,
		null,
		[
		],
		false,
		false,
		660132975230214,
		[],
		null
	]
,	[
		"t86",
		cr.plugins_.Text,
		false,
		[],
		0,
		0,
		null,
		null,
		[
		],
		false,
		false,
		2155953265459447,
		[],
		null
	]
,	[
		"t87",
		cr.plugins_.Sprite,
		false,
		[],
		0,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			8477869800192937,
			[
				["imagenes/snakes-sheet0.png", 168, 0, 0, 250, 250, 1, 0.5, 0.5,[],[],3]
			]
			]
		],
		[
		],
		false,
		false,
		8519989662520064,
		[],
		null
	]
,	[
		"t88",
		cr.plugins_.Sprite,
		false,
		[],
		0,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			3475998256596479,
			[
				["imagenes/snakes-sheet0.png", 168, 0, 0, 250, 250, 1, 0.524, 0.372,[["mundo2", 0.5, 0.5]],[],3]
			]
			]
		],
		[
		],
		false,
		false,
		672765914464296,
		[],
		null
	]
,	[
		"t89",
		cr.plugins_.Sprite,
		false,
		[],
		0,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			8179043837470753,
			[
				["imagenes/agua2-sheet0.png", 155, 0, 0, 250, 250, 1, 0.5, 0.5,[],[],1]
			]
			]
		],
		[
		],
		false,
		false,
		5277114806092652,
		[],
		null
	]
,	[
		"t90",
		cr.plugins_.TiledBg,
		false,
		[],
		0,
		0,
		["imagenes/tiledbackground4.png", 84842, 1],
		null,
		[
		],
		false,
		false,
		5547868842231876,
		[],
		null
	]
,	[
		"t91",
		cr.plugins_.Sprite,
		false,
		[],
		1,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			3892993120811738,
			[
				["imagenes/vainaa-sheet0.png", 11049, 0, 0, 421, 143, 1, 0.501188, 0.503497,[],[-0.494062,-0.482518,-0.00237563,-0.503497,0.491686,-0.482518,0.470308,0.412587,-0.00237563,0.496503,-0.465558,0.391608,-0.465558,-0.00699252],0]
			]
			]
		],
		[
		[
			"Solid",
			cr.behaviors.solid,
			9083741836283214
		]
		],
		false,
		false,
		1501244835332627,
		[],
		null
	]
,	[
		"t92",
		cr.plugins_.Sprite,
		false,
		[],
		0,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			6643851452312514,
			[
				["imagenes/snakes-sheet0.png", 168, 0, 0, 250, 250, 1, 0.5, 0.5,[],[],3]
			]
			]
		],
		[
		],
		false,
		false,
		68842657069124,
		[],
		null
	]
,	[
		"t93",
		cr.plugins_.Sprite,
		false,
		[],
		0,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			954827933784767,
			[
				["imagenes/regresarimg-sheet0.png", 155, 0, 0, 250, 250, 1, 0.5, 0.596,[["Imagepoint 1", 0.5, 0.5]],[],1]
			]
			]
		],
		[
		],
		false,
		false,
		2870180475944456,
		[],
		null
	]
,	[
		"t94",
		cr.plugins_.Sprite,
		false,
		[],
		1,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			8636352990504261,
			[
				["imagenes/nieve-sheet0.png", 8406, 0, 0, 532, 190, 1, 0.5, 0.5,[],[-0.479323,-0.442105,0,-0.457895,0.469925,-0.415789,0.469925,0.415789,0,0.5,-0.481203,0.447368],0]
			]
			]
		],
		[
		[
			"Solid",
			cr.behaviors.solid,
			9769206848598316
		]
		],
		false,
		false,
		5162379887577084,
		[],
		null
	]
,	[
		"t95",
		cr.plugins_.TiledBg,
		false,
		[],
		0,
		0,
		["imagenes/tiledbackground6.png", 390730, 1],
		null,
		[
		],
		false,
		false,
		8835980508252166,
		[],
		null
	]
,	[
		"t96",
		cr.plugins_.Sprite,
		false,
		[],
		0,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			8774989423260793,
			[
				["imagenes/snakes-sheet0.png", 168, 0, 0, 250, 250, 1, 0.5, 0.5,[["Imagepoint 1", 0.5, 0.5]],[],3]
			]
			]
		],
		[
		],
		false,
		false,
		5677629368791121,
		[],
		null
	]
,	[
		"t97",
		cr.plugins_.Sprite,
		false,
		[],
		0,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			5321005030354092,
			[
				["imagenes/bolamundo3-sheet0.png", 1377, 0, 0, 36, 36, 1, 0.5, 0.5,[],[-0.305556,-0.305556,0,-0.444444,0.305556,-0.305556,0.444444,0,0.305556,0.305556,0,0.444444,-0.305556,0.305556,-0.444444,0],0]
			]
			]
		],
		[
		],
		false,
		false,
		1257225935278009,
		[],
		null
	]
,	[
		"t98",
		cr.plugins_.Sprite,
		false,
		[],
		1,
		0,
		null,
		[
			[
			"Default",
			10,
			true,
			1,
			0,
			false,
			4216118172545889,
			[
				["imagenes/nieves-sheet0.png", 11188, 1, 1, 74, 124, 1, 0.5, 0.5,[],[-0.175676,-0.306452,0,-0.467742,0.189189,-0.314516,0.459459,0.16129,0.337838,0.403226,0,0.467742,-0.310811,0.387097,-0.283784,0],0],
				["imagenes/nieves-sheet0.png", 11188, 76, 1, 74, 124, 1, 0.5, 0.5,[],[-0.148649,-0.290323,0,-0.451613,0.202703,-0.322581,0.351351,0.41129,0,0.483871,-0.324324,0.395161],0],
				["imagenes/nieves-sheet0.png", 11188, 151, 1, 74, 124, 1, 0.5, 0.5,[],[-0.162162,-0.298387,0,-0.459677,0.189189,-0.314516,0.297297,0,0.337838,0.403226,0,0.475806,-0.324324,0.395161,-0.256757,0],0],
				["imagenes/nieves-sheet0.png", 11188, 1, 126, 74, 124, 1, 0.5, 0.5,[],[-0.189189,-0.314516,0,-0.475807,0.189189,-0.314516,0.337838,0,0.324324,0.395161,0,0.459677,-0.310811,0.387097,-0.283784,0],0],
				["imagenes/nieves-sheet0.png", 11188, 76, 126, 74, 124, 1, 0.5, 0.5,[],[-0.148649,-0.290323,0,-0.451613,0.202703,-0.322581,0.351351,0.41129,0,0.483871,-0.324324,0.395161],0]
			]
			]
,			[
			"boom",
			10,
			true,
			1,
			0,
			false,
			5365849128881872,
			[
				["imagenes/snakes-sheet1.png", 21571, 158, 1, 44, 42, 1, 0.5, 0.5,[],[],0],
				["imagenes/snakes-sheet1.png", 21571, 203, 1, 44, 42, 1, 0.5, 0.5,[],[],0],
				["imagenes/snakes-sheet1.png", 21571, 158, 44, 44, 42, 1, 0.5, 0.5,[],[],0],
				["imagenes/snakes-sheet1.png", 21571, 203, 44, 44, 42, 1, 0.5, 0.5,[],[],0],
				["imagenes/snakes-sheet1.png", 21571, 158, 87, 44, 42, 1, 0.5, 0.5,[],[],0]
			]
			]
		],
		[
		[
			"Solid",
			cr.behaviors.solid,
			1486260334302259
		]
		],
		false,
		false,
		858027819622822,
		[],
		null
	]
,	[
		"t99",
		cr.plugins_.Sprite,
		false,
		[],
		1,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			5821560080683672,
			[
				["imagenes/flagyellow-sheet0.png", 711, 0, 0, 70, 70, 1, 0.5, 0.5,[],[-0.471429,-0.471429,0,-0.271429,0.271429,-0.271429,0.157143,0,0.071429,0.071429,0,0.114286,-0.5,0.5,-0.5,0],0]
			]
			]
		],
		[
		[
			"Anchor",
			cr.behaviors.Anchor,
			6511767485969832
		]
		],
		false,
		false,
		6529289738843285,
		[],
		null
	]
,	[
		"t100",
		cr.plugins_.Sprite,
		false,
		[],
		2,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			5368872695885765,
			[
				["imagenes/mostri-sheet0.png", 8215, 0, 0, 92, 101, 1, 0.5, 0.504951,[],[-0.326087,-0.346535,0,-0.504951,0.26087,-0.287129,0.23913,-0.00990051,0.423913,0.425742,0,0.455445,-0.423913,0.425742,-0.326087,-0.00990051],0]
			]
			]
,			[
			"boom",
			10,
			true,
			1,
			0,
			false,
			1897605247664699,
			[
				["imagenes/snakes-sheet1.png", 21571, 158, 1, 44, 42, 1, 0.5, 0.5,[],[],0],
				["imagenes/snakes-sheet1.png", 21571, 203, 1, 44, 42, 1, 0.5, 0.5,[],[],0],
				["imagenes/snakes-sheet1.png", 21571, 158, 44, 44, 42, 1, 0.5, 0.5,[],[],0],
				["imagenes/snakes-sheet1.png", 21571, 203, 44, 44, 42, 1, 0.5, 0.5,[],[],0],
				["imagenes/snakes-sheet1.png", 21571, 158, 87, 44, 42, 1, 0.5, 0.5,[],[],0]
			]
			]
		],
		[
		[
			"Sine",
			cr.behaviors.Sin,
			1629495832588548
		]
,		[
			"Solid",
			cr.behaviors.solid,
			7031652727215977
		]
		],
		false,
		false,
		2563971055947374,
		[],
		null
	]
,	[
		"t101",
		cr.plugins_.Sprite,
		false,
		[],
		2,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			196128455768599,
			[
				["imagenes/nieve2-sheet0.png", 6743, 0, 0, 532, 190, 1, 0.5, 0.5,[],[-0.479323,-0.442105,0,-0.457895,0.469925,-0.415789,0.49812,0,0.486842,0.463158,0,0.5,-0.496241,0.489474],0]
			]
			]
		],
		[
		[
			"Solid",
			cr.behaviors.solid,
			3151603488062437
		]
,		[
			"Jumpthru",
			cr.behaviors.jumpthru,
			6819685006989327
		]
		],
		false,
		false,
		9222971471490912,
		[],
		null
	]
,	[
		"t102",
		cr.plugins_.Sprite,
		false,
		[],
		2,
		0,
		null,
		[
			[
			"Default",
			9,
			true,
			1,
			0,
			false,
			4471160338394534,
			[
				["imagenes/vampi-sheet0.png", 10616, 1, 1, 135, 82, 1, 0.503704, 0.5,[],[-0.414815,-0.353659,-0.00740772,-0.292683,0.429629,-0.390244,0.222222,0,0.288889,0.158537,-0.00740772,0.365854,-0.311111,0.182927,-0.333334,0],0],
				["imagenes/vampi-sheet0.png", 10616, 1, 84, 135, 82, 1, 0.503704, 0.5,[],[-0.407407,-0.341463,-0.00740772,-0.365854,0.414815,-0.365854,0.266666,0,0.311111,0.195122,-0.00740772,0.353659,-0.303704,0.170732,-0.325926,0],0]
			]
			]
,			[
			"boom",
			10,
			true,
			1,
			0,
			false,
			7019973557780593,
			[
				["imagenes/snakes-sheet1.png", 21571, 158, 1, 44, 42, 1, 0.5, 0.5,[],[],0],
				["imagenes/snakes-sheet1.png", 21571, 203, 1, 44, 42, 1, 0.5, 0.5,[],[],0],
				["imagenes/snakes-sheet1.png", 21571, 158, 44, 44, 42, 1, 0.5, 0.5,[],[],0],
				["imagenes/snakes-sheet1.png", 21571, 203, 44, 44, 42, 1, 0.5, 0.5,[],[],0],
				["imagenes/snakes-sheet1.png", 21571, 158, 87, 44, 42, 1, 0.5, 0.5,[],[],0]
			]
			]
		],
		[
		[
			"Sine",
			cr.behaviors.Sin,
			5730339341827558
		]
,		[
			"Solid",
			cr.behaviors.solid,
			9552674767719543
		]
		],
		false,
		false,
		2565412299629396,
		[],
		null
	]
,	[
		"t103",
		cr.plugins_.Sprite,
		false,
		[],
		1,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			6706144775041569,
			[
				["imagenes/sprite7-sheet0.png", 10432, 0, 0, 611, 207, 1, 0.500818, 0.502415,[],[-0.494272,-0.483092,-0.00163633,-0.502415,0.492635,-0.483092,0.471359,0.415459,-0.00163633,0.497585,-0.466448,0.396136,-0.466448,-0.00483048],0]
			]
			]
		],
		[
		[
			"Solid",
			cr.behaviors.solid,
			6204427877036696
		]
		],
		false,
		false,
		3535929732868394,
		[],
		null
	]
,	[
		"t104",
		cr.plugins_.TiledBg,
		false,
		[],
		0,
		0,
		["imagenes/tiledbackground7.png", 230026, 1],
		null,
		[
		],
		false,
		false,
		1072811271305659,
		[],
		null
	]
,	[
		"t105",
		cr.plugins_.Sprite,
		false,
		[],
		0,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			2220942693859408,
			[
				["imagenes/snakes-sheet0.png", 168, 0, 0, 250, 250, 1, 0.5, 0.5,[["Imagepoint 1", 0.5, 0.5]],[],3]
			]
			]
		],
		[
		],
		false,
		false,
		3956605534948173,
		[],
		null
	]
,	[
		"t106",
		cr.plugins_.Sprite,
		false,
		[],
		0,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			4804470022714508,
			[
				["imagenes/bolamundo5-sheet0.png", 1140, 0, 0, 36, 36, 1, 0.5, 0.5,[],[-0.305556,-0.305556,0,-0.444444,0.305556,-0.305556,0.444444,0,0.305556,0.305556,0,0.444444,-0.305556,0.305556,-0.444444,0],0]
			]
			]
		],
		[
		],
		false,
		false,
		4928131468297431,
		[],
		null
	]
,	[
		"t107",
		cr.plugins_.Sprite,
		false,
		[],
		0,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			9994971150098729,
			[
				["imagenes/bolamundo4-sheet0.png", 1230, 0, 0, 36, 36, 1, 0.5, 0.5,[],[-0.305556,-0.305556,0,-0.444444,0.305556,-0.305556,0.444444,0,0.305556,0.305556,0,0.444444,-0.305556,0.305556,-0.444444,0],0]
			]
			]
		],
		[
		],
		false,
		false,
		9275882310376963,
		[],
		null
	]
,	[
		"t108",
		cr.plugins_.Sprite,
		false,
		[],
		0,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			3135024597886115,
			[
				["imagenes/catilloecenar-sheet0.png", 20986, 0, 0, 246, 231, 1, 0.5, 0.502164,[],[-0.487805,-0.489177,0,-0.502164,0.48374,-0.484848,0.418699,-0.00432947,0.418699,0.411256,0,0.497836,-0.434959,0.428572,-0.434959,-0.00432947],3]
			]
			]
		],
		[
		],
		false,
		false,
		5541734249628396,
		[],
		null
	]
,	[
		"t109",
		cr.plugins_.Sprite,
		false,
		[],
		0,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			5302631671201468,
			[
				["imagenes/sprite8-sheet0.png", 155, 0, 0, 250, 250, 1, 0.5, 0.5,[],[],1]
			]
			]
		],
		[
		],
		false,
		false,
		7176387267957505,
		[],
		null
	]
,	[
		"t110",
		cr.plugins_.TiledBg,
		false,
		[],
		0,
		0,
		["imagenes/tiledbackground8.png", 1384, 0],
		null,
		[
		],
		false,
		false,
		3754586988034109,
		[],
		null
	]
,	[
		"t111",
		cr.plugins_.Sprite,
		false,
		[],
		2,
		0,
		null,
		[
			[
			"Default",
			8,
			true,
			1,
			0,
			false,
			6017136220739912,
			[
				["imagenes/anifire-sheet0.png", 30470, 1, 1, 101, 123, 1, 0.504951, 0.504065,[],[-0.257426,-0.300813,-0.00990051,-0.406504,0.217821,-0.276423,0.415841,-0.00813004,0.188118,0.243902,-0.00990051,0.414634,-0.217822,0.260163,-0.435644,-0.00813004],0],
				["imagenes/anifire-sheet0.png", 30470, 103, 1, 101, 123, 1, 0.504951, 0.504065,[],[],0],
				["imagenes/anifire-sheet0.png", 30470, 1, 125, 101, 123, 1, 0.504951, 0.504065,[],[],0],
				["imagenes/anifire-sheet0.png", 30470, 103, 125, 101, 123, 1, 0.504951, 0.504065,[],[],0]
			]
			]
		],
		[
		[
			"Sine",
			cr.behaviors.Sin,
			2360887186459999
		]
,		[
			"Solid",
			cr.behaviors.solid,
			810674023042119
		]
		],
		false,
		false,
		9480444395071282,
		[],
		null
	]
,	[
		"t112",
		cr.plugins_.Sprite,
		false,
		[],
		1,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			6298291406165484,
			[
				["imagenes/saltosnipequee-sheet0.png", 8064, 0, 0, 190, 71, 1, 0.5, 0.507042,[],[-0.478947,-0.450704,0,-0.478873,0.478947,-0.450704,0.5,-0.0140842,0.447368,0.352113,0,0.450705,-0.442105,0.338028,-0.494737,-0.0140842],0]
			]
			]
,			[
			"boom",
			9,
			true,
			1,
			0,
			false,
			6448360192981498,
			[
				["imagenes/snakes-sheet1.png", 21571, 203, 1, 44, 42, 1, 0.5, 0.5,[],[],0],
				["imagenes/snakes-sheet1.png", 21571, 158, 44, 44, 42, 1, 0.5, 0.5,[],[],0],
				["imagenes/snakes-sheet1.png", 21571, 203, 44, 44, 42, 1, 0.5, 0.5,[],[],0],
				["imagenes/snakes-sheet1.png", 21571, 158, 87, 44, 42, 1, 0.5, 0.5,[],[],0],
				["imagenes/snakes-sheet0.png", 168, 0, 0, 250, 250, 1, 0.5, 0.5,[],[],3]
			]
			]
		],
		[
		[
			"Solid",
			cr.behaviors.solid,
			5755305968418552
		]
		],
		false,
		false,
		447796643806147,
		[],
		null
	]
,	[
		"t113",
		cr.plugins_.Sprite,
		false,
		[],
		0,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			4163400145192394,
			[
				["imagenes/snakes-sheet0.png", 168, 0, 0, 250, 250, 1, 0.5, 0.5,[],[],3]
			]
			]
		],
		[
		],
		false,
		false,
		4137311927357185,
		[],
		null
	]
,	[
		"t114",
		cr.plugins_.TiledBg,
		false,
		[],
		0,
		0,
		["imagenes/tiledbackground9.png", 118629, 1],
		null,
		[
		],
		false,
		false,
		2071084447273008,
		[],
		null
	]
,	[
		"t115",
		cr.plugins_.Sprite,
		false,
		[],
		0,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			6569288990008663,
			[
				["imagenes/snakes-sheet0.png", 168, 0, 0, 250, 250, 1, 0.5, 0.5,[],[],3]
			]
			]
		],
		[
		],
		false,
		false,
		3147597961853022,
		[],
		null
	]
,	[
		"t116",
		cr.plugins_.Sprite,
		false,
		[],
		0,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			3293528639858291,
			[
				["imagenes/snakes-sheet0.png", 168, 0, 0, 250, 250, 1, 0.5, 0.5,[],[],3]
			]
			]
		],
		[
		],
		false,
		false,
		9452663397527351,
		[],
		null
	]
,	[
		"t117",
		cr.plugins_.Sprite,
		false,
		[],
		2,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			7977098869614809,
			[
				["imagenes/verde-sheet0.png", 7425, 0, 0, 158, 59, 1, 0.5, 0.508475,[],[-0.481013,-0.457627,0,-0.474576,0.481013,-0.457627,0.5,-0.0169496,0.443038,0.338983,0,0.440678,-0.443038,0.338983,-0.493671,-0.0169496],0]
			]
			]
		],
		[
		[
			"Sine",
			cr.behaviors.Sin,
			4440319317832887
		]
,		[
			"Solid",
			cr.behaviors.solid,
			9529902602858585
		]
		],
		false,
		false,
		4649240818175705,
		[],
		null
	]
,	[
		"t118",
		cr.plugins_.TiledBg,
		false,
		[],
		0,
		0,
		["imagenes/tiledbackground10.png", 50018, 3],
		null,
		[
		],
		false,
		false,
		1972516689695001,
		[],
		null
	]
,	[
		"t119",
		cr.plugins_.Sprite,
		false,
		[],
		2,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			1289620301947763,
			[
				["imagenes/hielomovible-sheet0.png", 5735, 0, 0, 532, 190, 1, 0.5, 0.5,[],[-0.479323,-0.442105,0,-0.457895,0.469925,-0.415789,0.469925,0.415789,0,0.5,-0.481203,0.447368],0]
			]
			]
		],
		[
		[
			"Solid",
			cr.behaviors.solid,
			3098099362216554
		]
,		[
			"Sine",
			cr.behaviors.Sin,
			3172421061640564
		]
		],
		false,
		false,
		8013476901390819,
		[],
		null
	]
,	[
		"t120",
		cr.plugins_.Sprite,
		false,
		[],
		0,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			7428320279178781,
			[
				["imagenes/bolamundo6-sheet0.png", 1039, 0, 0, 36, 36, 1, 0.5, 0.5,[],[-0.305556,-0.305556,0,-0.444444,0.305556,-0.305556,0.444444,0,0.305556,0.305556,0,0.444444,-0.305556,0.305556,-0.444444,0],0]
			]
			]
		],
		[
		],
		false,
		false,
		8364120947889834,
		[],
		null
	]
,	[
		"t121",
		cr.plugins_.Sprite,
		false,
		[],
		1,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			7371011737572736,
			[
				["imagenes/pisodesierto-sheet0.png", 155, 0, 0, 250, 250, 1, 0.5, 0.5,[],[],1]
			]
			]
		],
		[
		[
			"Solid",
			cr.behaviors.solid,
			610191948760805
		]
		],
		false,
		false,
		423355768359683,
		[],
		null
	]
,	[
		"t122",
		cr.plugins_.Sprite,
		false,
		[],
		0,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			3240091572129198,
			[
				["imagenes/snakes-sheet0.png", 168, 0, 0, 250, 250, 1, 0.5, 0.5,[],[],3]
			]
			]
		],
		[
		],
		false,
		false,
		2543238263696155,
		[],
		null
	]
,	[
		"t123",
		cr.plugins_.Sprite,
		false,
		[],
		2,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			2053151685364233,
			[
				["imagenes/desiertoquecamina-sheet0.png", 155, 0, 0, 250, 250, 1, 0.5, 0.5,[],[],1]
			]
			]
		],
		[
		[
			"Bullet",
			cr.behaviors.Bullet,
			7016415101201592
		]
,		[
			"Solid",
			cr.behaviors.solid,
			5569287142943852
		]
		],
		false,
		false,
		2539679826474361,
		[],
		null
	]
,	[
		"t124",
		cr.plugins_.Sprite,
		false,
		[],
		0,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			85370795367453,
			[
				["imagenes/snakes-sheet0.png", 168, 0, 0, 250, 250, 1, 0.5, 0.5,[],[],3]
			]
			]
		],
		[
		],
		false,
		false,
		7504595308311752,
		[],
		null
	]
,	[
		"t125",
		cr.plugins_.Sprite,
		false,
		[],
		1,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			5147794550964813,
			[
				["imagenes/sitocacamina-sheet0.png", 155, 0, 0, 250, 250, 1, 0.488, 0.452,[],[],1]
			]
			]
		],
		[
		[
			"Bullet",
			cr.behaviors.Bullet,
			7565962455467593
		]
		],
		false,
		false,
		7871372817765556,
		[],
		null
	]
,	[
		"t126",
		cr.plugins_.Sprite,
		false,
		[],
		0,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			772482350241375,
			[
				["imagenes/verde-sheet0.png", 7425, 0, 0, 158, 59, 1, 0.5, 0.508475,[],[-0.481013,-0.457627,0,-0.474576,0.481013,-0.457627,0.5,-0.0169496,0.443038,0.338983,0,0.440678,-0.443038,0.338983,-0.493671,-0.0169496],0]
			]
			]
		],
		[
		],
		false,
		false,
		782826446029751,
		[],
		null
	]
,	[
		"t127",
		cr.plugins_.Sprite,
		false,
		[],
		0,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			8980284337768416,
			[
				["imagenes/verde-sheet0.png", 7425, 0, 0, 158, 59, 1, 0.5, 0.508475,[],[-0.481013,-0.457627,0,-0.474576,0.481013,-0.457627,0.5,-0.0169496,0.443038,0.338983,0,0.440678,-0.443038,0.338983,-0.493671,-0.0169496],0]
			]
			]
		],
		[
		],
		false,
		false,
		7656417262887997,
		[],
		null
	]
,	[
		"t128",
		cr.plugins_.Sprite,
		false,
		[],
		2,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			7400481277287918,
			[
				["imagenes/piedramovible-sheet0.png", 35737, 0, 0, 270, 222, 1, 0.5, 0.5,[],[0.048148,0.166667,0.062963,-0.486486,0.433334,-0.193694,0.485185,0.486486,-0.5,0.495495,-0.47037,0.310811,0.048148,0.324324],0]
			]
			]
		],
		[
		[
			"Solid",
			cr.behaviors.solid,
			3420144754185552
		]
,		[
			"Bullet",
			cr.behaviors.Bullet,
			7450938866530039
		]
		],
		false,
		false,
		7193396580740151,
		[],
		null
	]
,	[
		"t129",
		cr.plugins_.Sprite,
		false,
		[],
		0,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			1375999821979786,
			[
				["imagenes/snakes-sheet0.png", 168, 0, 0, 250, 250, 1, 0.5, 0.5,[],[],3]
			]
			]
		],
		[
		],
		false,
		false,
		5058916644007917,
		[],
		null
	]
,	[
		"t130",
		cr.plugins_.Sprite,
		false,
		[],
		2,
		0,
		null,
		[
			[
			"Default",
			15,
			true,
			1,
			0,
			false,
			4247208507008831,
			[
				["imagenes/moscaband-sheet0.png", 12092, 1, 1, 135, 82, 1, 0.503704, 0.5,[],[-0.414815,-0.353659,-0.00740772,-0.329268,0.429629,-0.390244,0.244444,0,0.296296,0.170732,-0.00740772,0.365854,-0.311111,0.182927],0],
				["imagenes/moscaband-sheet0.png", 12092, 1, 84, 135, 82, 1, 0.503704, 0.5,[],[-0.4,-0.329268,-0.00740772,-0.304878,0.385185,-0.317073,0.303703,0,0.288889,0.158537,-0.00740772,0.365854,-0.311111,0.182927,-0.333334,0],0]
			]
			]
,			[
			"boom",
			5,
			true,
			1,
			0,
			false,
			3174066319474957,
			[
				["imagenes/snakes-sheet1.png", 21571, 158, 1, 44, 42, 1, 0.5, 0.5,[],[],0],
				["imagenes/snakes-sheet1.png", 21571, 203, 1, 44, 42, 1, 0.5, 0.5,[],[],0],
				["imagenes/snakes-sheet1.png", 21571, 158, 44, 44, 42, 1, 0.5, 0.5,[],[],0],
				["imagenes/snakes-sheet1.png", 21571, 203, 44, 44, 42, 1, 0.5, 0.5,[],[],0],
				["imagenes/snakes-sheet0.png", 168, 0, 0, 250, 250, 1, 0.5, 0.5,[],[],3],
				["imagenes/snakes-sheet1.png", 21571, 158, 87, 44, 42, 1, 0.5, 0.5,[],[],0]
			]
			]
		],
		[
		[
			"Solid",
			cr.behaviors.solid,
			5007052000786401
		]
,		[
			"Sine",
			cr.behaviors.Sin,
			5528115808028875
		]
		],
		false,
		false,
		6929930938560866,
		[],
		null
	]
,	[
		"t131",
		cr.plugins_.Sprite,
		false,
		[],
		0,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			7671206660980721,
			[
				["imagenes/bolamundo7-sheet0.png", 1003, 0, 0, 36, 36, 1, 0.5, 0.5,[],[-0.305556,-0.305556,0,-0.444444,0.305556,-0.305556,0.444444,0,0.305556,0.305556,0,0.444444,-0.305556,0.305556,-0.444444,0],0]
			]
			]
		],
		[
		],
		false,
		false,
		8605139584445043,
		[],
		null
	]
,	[
		"t132",
		cr.plugins_.Sprite,
		false,
		[],
		0,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			9958719463616524,
			[
				["imagenes/bolamundo8-sheet0.png", 1222, 0, 0, 36, 36, 1, 0.5, 0.5,[],[-0.305556,-0.305556,0,-0.444444,0.305556,-0.305556,0.444444,0,0.305556,0.305556,0,0.444444,-0.305556,0.305556,-0.444444,0],0]
			]
			]
		],
		[
		],
		false,
		false,
		1225431298434954,
		[],
		null
	]
,	[
		"t133",
		cr.plugins_.Sprite,
		false,
		[],
		1,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			2403807439720672,
			[
				["imagenes/amarillodeseirto-sheet0.png", 6987, 0, 0, 158, 59, 1, 0.5, 0.508475,[],[-0.481013,-0.457627,0,-0.474576,0.481013,-0.457627,0.5,-0.0169496,0.443038,0.338983,0,0.440678,-0.443038,0.338983,-0.493671,-0.0169496],0]
			]
			]
		],
		[
		[
			"Solid",
			cr.behaviors.solid,
			2928703345191702
		]
		],
		false,
		false,
		2343198629083411,
		[],
		null
	]
,	[
		"t134",
		cr.plugins_.Sprite,
		false,
		[],
		0,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			8109250103161886,
			[
				["imagenes/hielopuntavarias-sheet0.png", 486, 0, 0, 67, 36, 1, 0.507463, 0.5,[],[-0.492537,-0.472222,-0.0149257,-0.5,0.492537,-0.5,0.358209,0.25,-0.0149257,0.444444,-0.373135,0.25],0]
			]
			]
		],
		[
		],
		false,
		false,
		7564885713536039,
		[],
		null
	]
,	[
		"t135",
		cr.plugins_.Text,
		false,
		[],
		0,
		0,
		null,
		null,
		[
		],
		false,
		false,
		3547052811382439,
		[],
		null
	]
,	[
		"t136",
		cr.plugins_.Sprite,
		false,
		[],
		0,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			2817806592524361,
			[
				["imagenes/captus-sheet0.png", 12466, 0, 0, 122, 208, 1, 0.5, 0.5,[],[-0.057377,-0.240385,0,-0.480769,0.139344,-0.288462,0.385246,0,0.122951,0.278846,0,0.495192,-0.065574,0.245192,-0.491803,0],0]
			]
			]
		],
		[
		],
		false,
		false,
		9901119476233908,
		[],
		null
	]
,	[
		"t137",
		cr.plugins_.Text,
		false,
		[],
		0,
		0,
		null,
		null,
		[
		],
		false,
		false,
		4014169919577345,
		[],
		null
	]
,	[
		"t138",
		cr.plugins_.Sprite,
		false,
		[],
		0,
		0,
		null,
		[
			[
			"Default",
			3,
			true,
			1,
			0,
			false,
			6398353036841665,
			[
				["imagenes/destello-sheet0.png", 7534, 0, 0, 47, 47, 1, 0.510638, 0.510638,[],[],0],
				["imagenes/destello-sheet1.png", 107, 0, 0, 47, 47, 1, 0.510638, 0.510638,[],[],3]
			]
			]
		],
		[
		],
		false,
		false,
		3058803019947123,
		[],
		null
	]
,	[
		"t139",
		cr.plugins_.Particles,
		false,
		[],
		0,
		0,
		["imagenes/particles.png", 168, 3],
		null,
		[
		],
		false,
		false,
		3895519705289292,
		[],
		null
	]
,	[
		"t140",
		cr.plugins_.Sprite,
		false,
		[],
		1,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			9474636381408555,
			[
				["imagenes/snakes-sheet0.png", 168, 0, 0, 250, 250, 1, 0.5, 0.5,[],[],3]
			]
			]
		],
		[
		[
			"Solid",
			cr.behaviors.solid,
			8232103774051616
		]
		],
		false,
		false,
		5147606108547905,
		[],
		null
	]
,	[
		"t141",
		cr.plugins_.Sprite,
		false,
		[],
		0,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			481421848377295,
			[
				["imagenes/soon-sheet0.png", 2099, 0, 0, 139, 20, 1, 0.503597, 0.5,[],[-0.496403,-0.45,-0.00719413,-0.3,0.467626,-0.3,0.489209,0,0.460432,0.25,-0.00719413,0.25,-0.402878,-0.2,-0.503597,0],0]
			]
			]
		],
		[
		],
		false,
		false,
		4005267539934217,
		[],
		null
	]
,	[
		"t142",
		cr.plugins_.Sprite,
		false,
		[],
		0,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			399518444705657,
			[
				["imagenes/snakes-sheet0.png", 168, 0, 0, 250, 250, 1, 0.5, 0.5,[],[],3]
			]
			]
		],
		[
		],
		false,
		false,
		739106180236066,
		[],
		null
	]
,	[
		"t143",
		cr.plugins_.Sprite,
		false,
		[],
		2,
		0,
		null,
		[
			[
			"Default",
			20,
			true,
			1,
			0,
			false,
			8349239540105594,
			[
				["imagenes/bolarueda-sheet0.png", 137132, 1, 1, 154, 154, 1, 0.5, 0.5,[],[-0.311688,-0.311688,0,-0.435065,0.305195,-0.305195,0.428571,0,0.305195,0.305195,0,0.441558,-0.311688,0.311688,-0.448052,0],0],
				["imagenes/bolarueda-sheet0.png", 137132, 156, 1, 154, 154, 1, 0.5, 0.5,[],[-0.311688,-0.311688,0,-0.435065,0.305195,-0.305195,0.428571,0,0.305195,0.305195,0,0.441558,-0.311688,0.311688,-0.441558,0],0],
				["imagenes/bolarueda-sheet0.png", 137132, 311, 1, 154, 154, 1, 0.5, 0.5,[],[-0.311688,-0.311688,0,-0.428571,0.305195,-0.305195,0.435065,0,0.311688,0.311688,0,0.441558,-0.318182,0.318182,-0.441558,0],0],
				["imagenes/bolarueda-sheet0.png", 137132, 1, 156, 154, 154, 1, 0.5, 0.5,[],[-0.311688,-0.311688,0,-0.428571,0.298701,-0.298701,0.435065,0,0.311688,0.311688,0,0.448052,-0.318182,0.318182,-0.441558,0],0],
				["imagenes/bolarueda-sheet0.png", 137132, 156, 156, 154, 154, 1, 0.5, 0.5,[],[-0.305195,-0.305195,0,-0.428571,0.305195,-0.305195,0.435065,0,0.311688,0.311688,0,0.448052,-0.318182,0.318182,-0.441558,0],0],
				["imagenes/bolarueda-sheet0.png", 137132, 311, 156, 154, 154, 1, 0.5, 0.5,[],[-0.305195,-0.305195,0,-0.415584,0.298701,-0.298701,0.428571,0,0.311688,0.311688,0,0.454545,-0.324675,0.324675,-0.448052,0],0],
				["imagenes/bolarueda-sheet0.png", 137132, 1, 311, 154, 154, 1, 0.5, 0.5,[],[-0.298701,-0.298701,0,-0.409091,0.292208,-0.292208,0.435065,0,0.318182,0.318182,0,0.461039,-0.324675,0.324675,-0.441558,0],0],
				["imagenes/bolarueda-sheet0.png", 137132, 156, 311, 154, 154, 1, 0.5, 0.5,[],[-0.292208,-0.292208,0,-0.396104,0.285714,-0.285714,0.428571,0,0.324675,0.324675,0,0.480519,-0.331169,0.331169,-0.441558,0],0],
				["imagenes/bolarueda-sheet0.png", 137132, 311, 311, 154, 154, 1, 0.5, 0.5,[],[-0.285714,-0.285714,0,-0.38961,0.279221,-0.279221,0.428571,0,0.331169,0.331169,0,0.487013,-0.337662,0.337662,-0.441558,0],0],
				["imagenes/bolarueda-sheet1.png", 19270, 0, 0, 154, 154, 1, 0.5, 0.5,[],[-0.292208,-0.292208,0,-0.38961,0.279221,-0.279221,0.422078,0,0.324675,0.324675,0,0.487013,-0.344156,0.344156,-0.448052,0],0]
			]
			]
		],
		[
		[
			"Solid",
			cr.behaviors.solid,
			2688594970451153
		]
,		[
			"Bullet",
			cr.behaviors.Bullet,
			2204496273509564
		]
		],
		false,
		false,
		899543301257375,
		[],
		null
	]
,	[
		"t144",
		cr.plugins_.Sprite,
		false,
		[],
		1,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			2876213938239818,
			[
				["imagenes/snakes-sheet0.png", 168, 0, 0, 250, 250, 1, 0.5, 0.5,[],[],3]
			]
			]
		],
		[
		[
			"Solid",
			cr.behaviors.solid,
			6806657994920709
		]
		],
		false,
		false,
		9738158178687455,
		[],
		null
	]
,	[
		"t145",
		cr.plugins_.Sprite,
		false,
		[],
		1,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			538171040510225,
			[
				["imagenes/puyast-sheet0.png", 464, 0, 0, 68, 35, 1, 0.5, 0.514286,[],[-0.382353,-0.285715,0,-0.485714,0.367647,-0.257143,0.5,0.485714,-0.5,0.485714],0]
			]
			]
		],
		[
		[
			"Solid",
			cr.behaviors.solid,
			6109066671871672
		]
		],
		false,
		false,
		596285531091157,
		[],
		null
	]
,	[
		"t146",
		cr.plugins_.Sprite,
		false,
		[],
		0,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			1418173290129687,
			[
				["imagenes/snakes-sheet0.png", 168, 0, 0, 250, 250, 1, 0.5, 0.5,[],[],3]
			]
			]
		],
		[
		],
		false,
		false,
		5904955396271712,
		[],
		null
	]
,	[
		"t147",
		cr.plugins_.Sprite,
		false,
		[],
		0,
		0,
		null,
		[
			[
			"Default",
			4,
			true,
			1,
			0,
			false,
			5785402000792777,
			[
				["imagenes/mas100_-sheet0.png", 837, 0, 0, 55, 18, 1, 0.509091, 0.5,[],[-0.436364,-0.277778,0.454545,-0.388889,0.490909,0,0.454545,0.388889,-0.436364,0.277778,-0.509091,0],0]
			]
			]
		],
		[
		],
		false,
		false,
		1805197584724986,
		[],
		null
	]
,	[
		"t148",
		cr.plugins_.Sprite,
		false,
		[],
		0,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			3117464933718019,
			[
				["imagenes/bolamundo10-sheet0.png", 1247, 0, 0, 36, 36, 1, 0.5, 0.5,[],[-0.305556,-0.305556,0,-0.444444,0.305556,-0.305556,0.444444,0,0.305556,0.305556,0,0.444444,-0.305556,0.305556,-0.444444,0],0]
			]
			]
		],
		[
		],
		false,
		false,
		17567242209984,
		[],
		null
	]
,	[
		"t149",
		cr.plugins_.Sprite,
		false,
		[],
		0,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			9783779663173753,
			[
				["imagenes/bolamundo9-sheet0.png", 1141, 0, 0, 36, 36, 1, 0.5, 0.5,[],[-0.305556,-0.305556,0,-0.444444,0.305556,-0.305556,0.444444,0,0.305556,0.305556,0,0.444444,-0.305556,0.305556,-0.444444,0],0]
			]
			]
		],
		[
		],
		false,
		false,
		7947379899300225,
		[],
		null
	]
,	[
		"t150",
		cr.plugins_.CJSAds,
		false,
		[],
		0,
		0,
		null,
		null,
		[
		],
		false,
		false,
		6379739204501273,
		[],
		null
		,[0,0,1]
	]
,	[
		"t151",
		cr.plugins_.Sprite,
		false,
		[],
		0,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			4480064795782813,
			[
				["imagenes/sprite11-sheet0.png", 155, 0, 0, 250, 250, 1, 0.5, 0.5,[],[],4]
			]
			]
		],
		[
		],
		false,
		false,
		1048037303772961,
		[],
		null
	]
,	[
		"t152",
		cr.plugins_.Sprite,
		false,
		[],
		0,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			8400429793575661,
			[
				["imagenes/lunamini-sheet0.png", 32898, 0, 0, 193, 191, 1, 0.502591, 0.502618,[],[-0.264249,-0.26178,-0.00518167,-0.366492,0.264248,-0.267016,0.388601,-0.00523579,0.279792,0.277487,-0.00518167,0.39267,-0.274612,0.267016,-0.38342,-0.00523579],0]
			]
			]
		],
		[
		],
		false,
		false,
		3047638704257351,
		[],
		null
	]
,	[
		"t153",
		cr.plugins_.Sprite,
		false,
		[],
		0,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			6955903015430507,
			[
				["imagenes/sol-sheet0.png", 14731, 0, 0, 216, 209, 1, 0.5, 0.502392,[],[-0.277778,-0.272727,0,-0.397129,0.282407,-0.277512,0.402778,-0.00478435,0.282407,0.272728,0,0.38756,-0.277778,0.267943,-0.393519,-0.00478435],0]
			]
			]
		],
		[
		],
		false,
		false,
		8049283332709281,
		[],
		null
	]
,	[
		"t154",
		cr.plugins_.Sprite,
		false,
		[],
		1,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			7842756625564423,
			[
				["imagenes/hongo-sheet0.png", 3374, 0, 0, 415, 354, 1, 0.501205, 0.5,[],[-0.489157,-0.485876,-0.00240985,-0.5,0.486747,-0.485876,0.0987952,0,0.0987952,0.031073,-0.00240985,0.5,-0.13253,0.067797,-0.13253,0],0]
			]
			]
		],
		[
		[
			"Solid",
			cr.behaviors.solid,
			2599636696953513
		]
		],
		false,
		false,
		66650727333007,
		[],
		null
	]
,	[
		"t155",
		cr.plugins_.Sprite,
		false,
		[],
		0,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			8244484486540544,
			[
				["imagenes/palomini-sheet0.png", 1080, 0, 0, 64, 179, 1, 0.5, 0.502793,[],[-0.484375,-0.497207,0.484375,-0.497207,0.484375,0.49162,-0.46875,0.486034],0]
			]
			]
		],
		[
		],
		false,
		false,
		1638916713747416,
		[],
		null
	]
,	[
		"t156",
		cr.plugins_.Sprite,
		false,
		[],
		0,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			7933733157224713,
			[
				["imagenes/snakes-sheet0.png", 168, 0, 0, 250, 250, 1, 0.5, 0.5,[],[],3]
			]
			]
		],
		[
		],
		false,
		false,
		4218673666613369,
		[],
		null
	]
,	[
		"t157",
		cr.plugins_.Sprite,
		false,
		[],
		1,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			6335884790713989,
			[
				["imagenes/inmoviblecoco-sheet0.png", 3208, 0, 0, 48, 48, 1, 0.5, 0.5,[],[-0.3125,-0.3125,0,-0.395833,0.270833,-0.270833,0.395833,0,0.3125,0.3125,0,0.458333,-0.333333,0.333333,-0.4375,0],0]
			]
			]
		],
		[
		[
			"Anchor",
			cr.behaviors.Anchor,
			3814730373405242
		]
		],
		false,
		false,
		9103833134361439,
		[],
		null
	]
,	[
		"t158",
		cr.plugins_.Sprite,
		false,
		[],
		1,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			5651435673125547,
			[
				["imagenes/perlas-sheet0.png", 4660, 0, 0, 41, 43, 1, 0.512195, 0.511628,[],[-0.439024,-0.44186,-0.0243901,-0.488372,0.414634,-0.44186,0.487805,-0.0232559,0.463415,0.465116,-0.0243901,0.488372,-0.439024,0.418605],0]
			]
			]
		],
		[
		[
			"Anchor",
			cr.behaviors.Anchor,
			3131612106726082
		]
		],
		false,
		false,
		8801686659290808,
		[],
		null
	]
,	[
		"t159",
		cr.plugins_.Text,
		false,
		[],
		1,
		0,
		null,
		null,
		[
		[
			"Anchor",
			cr.behaviors.Anchor,
			6500535045119526
		]
		],
		false,
		false,
		9243810882444234,
		[],
		null
	]
,	[
		"t160",
		cr.plugins_.Sprite,
		false,
		[],
		0,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			8737178758714247,
			[
				["imagenes/snakes-sheet0.png", 168, 0, 0, 250, 250, 1, 0.5, 0.5,[],[],3]
			]
			]
		],
		[
		],
		false,
		false,
		8591630506664642,
		[],
		null
	]
,	[
		"t161",
		cr.plugins_.Sprite,
		false,
		[],
		2,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			4175060966461482,
			[
				["imagenes/mostronegro-sheet0.png", 1991, 0, 0, 63, 98, 1, 0.507937, 0.5,[],[-0.492064,-0.489796,0.47619,-0.489796,0.492063,0,0.47619,0.489796,-0.492064,0.489796,-0.507937,0],0]
			]
			]
		],
		[
		[
			"Solid",
			cr.behaviors.solid,
			3221986946506769
		]
,		[
			"Sine",
			cr.behaviors.Sin,
			5591646301444082
		]
		],
		false,
		false,
		2530149764537011,
		[],
		null
	]
,	[
		"t162",
		cr.plugins_.Sprite,
		false,
		[],
		0,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			2866944945322103,
			[
				["imagenes/bolamundo11-sheet0.png", 1448, 0, 0, 36, 36, 1, 0.5, 0.5,[],[-0.305556,-0.305556,0,-0.444444,0.305556,-0.305556,0.444444,0,0.305556,0.305556,0,0.444444,-0.305556,0.305556,-0.444444,0],0]
			]
			]
		],
		[
		],
		false,
		false,
		1156233587504541,
		[],
		null
	]
,	[
		"t163",
		cr.plugins_.Sprite,
		false,
		[],
		0,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			7388613761690997,
			[
				["imagenes/sprite13-sheet0.png", 2526, 0, 0, 50, 69, 1, 0.5, 0.507246,[],[-0.48,-0.492754,0,-0.507246,0.48,-0.492754,0.5,-0.0144924,0.48,0.478261,0,0.492754,-0.48,0.478261,-0.5,-0.0144924],0]
			]
			]
		],
		[
		],
		false,
		false,
		8773504787537604,
		[],
		null
	]
,	[
		"t164",
		cr.plugins_.Sprite,
		false,
		[],
		1,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			9476322607117079,
			[
				["imagenes/grisbolita-sheet0.png", 578, 0, 0, 36, 36, 1, 0.5, 0.5,[],[-0.305556,-0.305556,0,-0.444444,0.305556,-0.305556,0.444444,0,0.305556,0.305556,0,0.444444,-0.305556,0.305556,-0.444444,0],0]
			]
			]
		],
		[
		[
			"Anchor",
			cr.behaviors.Anchor,
			8306795652445665
		]
		],
		false,
		false,
		4890815076024509,
		[],
		null
	]
,	[
		"t165",
		cr.plugins_.Sprite,
		false,
		[],
		2,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			4924620319713953,
			[
				["imagenes/hongos-sheet0.png", 3172, 0, 0, 415, 354, 1, 0.501205, 0.5,[],[-0.489157,-0.485876,-0.00240985,-0.5,0.486747,-0.485876,0.0987952,0,0.0987952,0.031073,-0.00240985,0.5,-0.13253,0.067797,-0.13253,0],0]
			]
			]
		],
		[
		[
			"Solid",
			cr.behaviors.solid,
			3485945910867555
		]
,		[
			"Sine",
			cr.behaviors.Sin,
			7391430536830297
		]
		],
		false,
		false,
		2852721412881191,
		[],
		null
	]
,	[
		"t166",
		cr.plugins_.Sprite,
		false,
		[],
		0,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			1380601169260686,
			[
				["imagenes/snakes-sheet0.png", 168, 0, 0, 250, 250, 1, 0.5, 0.5,[],[],3]
			]
			]
		],
		[
		],
		false,
		false,
		3030214568230664,
		[],
		null
	]
,	[
		"t167",
		cr.plugins_.Sprite,
		false,
		[],
		0,
		0,
		null,
		[
			[
			"Default",
			15,
			true,
			1,
			0,
			false,
			1899534304177565,
			[
				["imagenes/blackhole_logo-sheet0.png", 97733, 1, 1, 217, 194, 1, 0.502304, 0.5,[],[-0.285714,-0.257732,-0.00460812,-0.43299,0.313364,-0.293814,0.451613,0,0.299539,0.278351,-0.00460812,0.443299,-0.304147,0.278351,-0.423963,0],0],
				["imagenes/blackhole_logo-sheet0.png", 97733, 219, 1, 217, 194, 1, 0.502304, 0.5,[],[],0],
				["imagenes/blackhole_logo-sheet0.png", 97733, 1, 196, 217, 194, 1, 0.502304, 0.5,[],[],0],
				["imagenes/blackhole_logo-sheet0.png", 97733, 219, 196, 217, 194, 1, 0.502304, 0.5,[],[],0],
				["imagenes/blackhole_logo-sheet1.png", 40152, 0, 0, 217, 194, 1, 0.502304, 0.5,[],[],0]
			]
			]
		],
		[
		],
		false,
		false,
		1385759198337003,
		[],
		null
	]
,	[
		"t168",
		cr.plugins_.Sprite,
		false,
		[],
		0,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			6706079594252873,
			[
				["imagenes/bolasmagicas-sheet0.png", 13417, 0, 0, 93, 82, 1, 0.505376, 0.5,[],[-0.27957,-0.243902,-0.0107524,-0.451219,0.204301,-0.170732,0.290323,0,0.39785,0.390244,-0.0107524,0.451219,-0.365591,0.341463,-0.462366,0],0]
			]
			]
		],
		[
		],
		false,
		false,
		8494020887004287,
		[],
		null
	]
,	[
		"t169",
		cr.plugins_.Sprite,
		false,
		[],
		0,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			2905131869571789,
			[
				["imagenes/fin-sheet0.png", 5934, 0, 0, 336, 72, 1, 0.5, 0.5,[],[-0.488095,-0.444444,0.488095,-0.444444,0.488095,0,0.467262,0.347222,-0.446429,0.25,-0.446429,0],0]
			]
			]
		],
		[
		],
		false,
		false,
		8727025366708188,
		[],
		null
	]
,	[
		"t170",
		cr.plugins_.Sprite,
		false,
		[],
		1,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			4447466703100114,
			[
				["imagenes/saltoalante-sheet0.png", 723, 0, 0, 80, 80, 1, 0.5, 0.5,[],[-0.35,-0.35,0,-0.4875,0.35,-0.35,0.5,0,0.35,0.35,0,0.5,-0.35,0.35,-0.5,0],0]
			]
			]
		],
		[
		[
			"Anchor",
			cr.behaviors.Anchor,
			8307970210673508
		]
		],
		false,
		false,
		8112016591774278,
		[],
		null
	]
,	[
		"t171",
		cr.plugins_.Sprite,
		false,
		[],
		0,
		0,
		null,
		[
			[
			"Default",
			5,
			false,
			1,
			0,
			false,
			1151381975081326,
			[
				["imagenes/sprite14-sheet0.png", 1307, 0, 0, 32, 32, 1, 0.5, 0.5,[],[-0.46875,-0.46875,0,-0.5,0.46875,-0.46875,0.5,0,0.46875,0.46875,0,0.5,-0.46875,0.46875,-0.5,0],0]
			]
			]
		],
		[
		],
		false,
		true,
		5842663478207763,
		[],
		null
	]
,	[
		"t172",
		cr.plugins_.Text,
		false,
		[],
		0,
		0,
		null,
		null,
		[
		],
		false,
		true,
		226262790425978,
		[],
		null
	]
	],
	[
	],
	[
	[
		"splash",
		1018,
		628,
		false,
		"splasheven",
		63378487717332,
		[
		[
			"Layer 0",
			0,
			8982576006739955,
			true,
			[255, 255, 255],
			false,
			1,
			1,
			1,
			false,
			1,
			0,
			0,
			[
			[
				[361, 188, 0, 364, 83, 0, 0, 1, 0, 0, 0, 0, []],
				26,
				39,
				[
				],
				[
				],
				[
					"CREADO POR JEANKEE",
					0,
					"22pt Arial",
					"rgb(0,0,0)",
					0,
					0,
					0,
					0,
					0
				]
			]
,			[
				[519, 319.418, 0, 1036, 669, 0, 0, 1, 0.5, 0.500507, 0, 0, []],
				36,
				26,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
			],
			[			]
		]
,		[
			"despuesdefondo",
			1,
			4542101587634751,
			true,
			[255, 255, 255],
			true,
			1,
			1,
			1,
			false,
			1,
			0,
			0,
			[
			[
				[236, 435, 0, 323, 101, 0, 0.0377222, 1, 0.502075, 0.506173, 0, 0, []],
				14,
				15,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[518, 131, 0, 468, 144, 0, 0, 1, 0.5, 0.502732, 0, 0, []],
				37,
				35,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					6,
					10,
					0,
					30,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[817, 425, 0, 323, 101, 0, -0.11419, 1, 0.502075, 0.506173, 0, 0, []],
				38,
				36,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[958, 81, 0, 45, 42, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				54,
				132,
				[
				],
				[
				],
				[
					1,
					"Default",
					0,
					1
				]
			]
,			[
				[96, 41, 0, 176, 59, 0, -0.0280149, 1, 0.503067, 0.509434, 0, 0, []],
				63,
				139,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[246, 289, 0, 325, 110, 0, 0.00887381, 1, 0.502075, 0.506173, 0, 0, []],
				80,
				384,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[809, 288, 0, 323, 101, 0, -0.0447436, 1, 0.502075, 0.506173, 0, 0, []],
				81,
				403,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[280, 693, 0, 569, 69, 0, 0, 1, 0, 0, 0, 0, []],
				39,
				231,
				[
				],
				[
				],
				[
					"Loading...",
					1,
					"bold 24pt Trebuchet MS",
					"rgb(0,0,0)",
					1,
					0,
					0,
					0,
					0
				]
			]
,			[
				[176, 556, 0, 61, 59, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				171,
				1267,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[610, 201, 0, 143, 30, 0, 0, 1, 0, 0, 0, 0, []],
				172,
				1268,
				[
				],
				[
				],
				[
					"www.Jeankee.com",
					0,
					"bold 14pt Arial Narrow",
					"rgb(0,0,0)",
					0,
					0,
					0,
					0,
					0
				]
			]
			],
			[			]
		]
		],
		[
		],
		[]
	]
,	[
		"seleccionar",
		1018,
		628,
		false,
		"seleccionareve",
		1180659700833194,
		[
		[
			"Layer 0",
			0,
			5158690250262704,
			true,
			[255, 255, 255],
			false,
			1,
			1,
			1,
			false,
			1,
			0,
			0,
			[
			[
				[536, 358.52, 0, 1303, 776, 0, 0, 1, 0.5, 0.500507, 0, 0, []],
				84,
				432,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[129, 175, 0, 103, 127, 0, -0.00583026, 1, 0.5, 0.507246, 0, 0, []],
				42,
				114,
				[
				],
				[
				],
				[
					0,
					"ani2",
					0,
					1
				]
			]
,			[
				[238, 177, 0, 103, 127, 0, 0, 1, 0.5, 0.507246, 0, 0, []],
				43,
				115,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[349, 176, 0, 103, 127, 0, 0, 1, 0.5, 0.507246, 0, 0, []],
				44,
				116,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[463, 173, 0, 103, 127, 0, 0, 1, 0.5, 0.507246, 0, 0, []],
				45,
				117,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[572, 173, 0, 103, 127, 0, 0, 1, 0.5, 0.507246, 0, 0, []],
				46,
				118,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[685, 173, 0, 103, 127, 0, 0, 1, 0.5, 0.507246, 0, 0, []],
				47,
				119,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[798, 175, 0, 103, 127, 0, 0, 1, 0.5, 0.507246, 0, 0, []],
				48,
				120,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[913, 176, 0, 103, 127, 0, 0, 1, 0.5, 0.507246, 0, 0, []],
				49,
				121,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[130.056, 310.69, 0, 103, 127, 0, 0, 1, 0.5, 0.507246, 0, 0, []],
				50,
				122,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[240, 312, 0, 103, 127, 0, 0, 1, 0.5, 0.507246, 0, 0, []],
				51,
				123,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[353, 312, 0, 103, 127, 0, 0, 1, 0.5, 0.507246, 0, 0, []],
				52,
				124,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[95, 131, 0, 69.637, 72.3627, 0, 0, 0.5, 0, 0, 0, 0, []],
				68,
				157,
				[
				],
				[
				],
				[
					"1",
					0,
					"22pt Bell Gothic Std Light",
					"rgb(255,255,255)",
					1,
					0,
					0,
					0,
					0
				]
			]
,			[
				[207, 127, 0, 69.637, 72.3627, 0, 0, 0.5, 0, 0, 0, 0, []],
				68,
				158,
				[
				],
				[
				],
				[
					"2",
					0,
					"22pt Bell Gothic Std Light",
					"rgb(255,255,255)",
					1,
					0,
					0,
					0,
					0
				]
			]
,			[
				[320, 129, 0, 69.637, 72.3627, 0, 0, 0.5, 0, 0, 0, 0, []],
				68,
				159,
				[
				],
				[
				],
				[
					"3",
					0,
					"22pt Bell Gothic Std Light",
					"rgb(255,255,255)",
					1,
					0,
					0,
					0,
					0
				]
			]
,			[
				[432, 126, 0, 69.6431, 72.369, 0, 0, 0.5, 0, 0, 0, 0, []],
				68,
				160,
				[
				],
				[
				],
				[
					"4",
					0,
					"22pt Bell Gothic Std Light",
					"rgb(255,255,255)",
					1,
					0,
					0,
					0,
					0
				]
			]
,			[
				[539, 123, 0, 69.6431, 72.369, 0, 0, 0.5, 0, 0, 0, 0, []],
				68,
				161,
				[
				],
				[
				],
				[
					"5",
					0,
					"22pt Bell Gothic Std Light",
					"rgb(255,255,255)",
					1,
					0,
					0,
					0,
					0
				]
			]
,			[
				[651, 125, 0, 69.637, 72.3627, 0, 0, 0.5, 0, 0, 0, 0, []],
				68,
				162,
				[
				],
				[
				],
				[
					"6",
					0,
					"22pt Bell Gothic Std Light",
					"rgb(255,255,255)",
					1,
					0,
					0,
					0,
					0
				]
			]
,			[
				[766.637, 128.181, 0, 70, 72, 0, 0, 0.5, 0, 0, 0, 0, []],
				68,
				163,
				[
				],
				[
				],
				[
					"7",
					0,
					"22pt Bell Gothic Std Light",
					"rgb(255,255,255)",
					1,
					0,
					0,
					0,
					0
				]
			]
,			[
				[881, 129, 0, 69.637, 72.3627, 0, 0, 0.5, 0, 0, 0, 0, []],
				68,
				164,
				[
				],
				[
				],
				[
					"8",
					0,
					"22pt Bell Gothic Std Light",
					"rgb(255,255,255)",
					1,
					0,
					0,
					0,
					0
				]
			]
,			[
				[501, 481, 0, -170, 160, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				25,
				165,
				[
				],
				[
				[
					0,
					0,
					0,
					0,
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[91, 256.181, 0, 70, 72, 0, 0, 0.5, 0, 0, 0, 0, []],
				68,
				166,
				[
				],
				[
				],
				[
					"9",
					0,
					"22pt Bell Gothic Std Light",
					"rgb(255,255,255)",
					1,
					0,
					0,
					0,
					0
				]
			]
,			[
				[208, 259, 0, 69.637, 72.3627, 0, 0, 0.5, 0, 0, 0, 0, []],
				68,
				167,
				[
				],
				[
				],
				[
					"10",
					0,
					"22pt Bell Gothic Std Light",
					"rgb(255,255,255)",
					1,
					0,
					0,
					0,
					0
				]
			]
,			[
				[317, 259, 0, 69.637, 72.3627, 0, 0, 0.5, 0, 0, 0, 0, []],
				68,
				168,
				[
				],
				[
				],
				[
					"11",
					0,
					"22pt Bell Gothic Std Light",
					"rgb(255,255,255)",
					1,
					0,
					0,
					0,
					0
				]
			]
,			[
				[466, 312, 0, 103, 127, 0, 0, 1, 0.5, 0.507246, 0, 0, []],
				53,
				1192,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[430, 256, 0, 69.637, 72.3627, 0, 0, 0.5, 0, 0, 0, 0, []],
				68,
				1178,
				[
				],
				[
				],
				[
					"12",
					0,
					"22pt Bell Gothic Std Light",
					"rgb(255,255,255)",
					1,
					0,
					0,
					0,
					0
				]
			]
,			[
				[490, 242, 0, 500, 124, 0, 0, 0.6, 0, 0, 0, 0, []],
				39,
				51,
				[
				],
				[
				],
				[
					"Loading...",
					1,
					"bold 72pt Trebuchet MS",
					"rgb(0,0,0)",
					1,
					0,
					0,
					0,
					0
				]
			]
			],
			[			]
		]
		],
		[
		],
		[]
	]
,	[
		"mundos",
		188000,
		700,
		false,
		"mundoseventos",
		4003114904966748,
		[
		[
			"ecenario",
			0,
			5219311130234725,
			true,
			[255, 255, 255],
			false,
			1,
			1,
			1,
			false,
			1,
			0,
			0,
			[
			[
				[-48, -3, 0, 10193, 798, 0, 0, 1, 0, 0, 0, 0, []],
				5,
				4,
				[
				],
				[
				],
				[
					0,
					0
				]
			]
,			[
				[4268, 746.5, 0, 8804, 16, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				7,
				8,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[3277, 193, 0, 48, 46, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				18,
				24,
				[
				],
				[
				[
					1,
					1,
					2,
					4,
					0,
					0,
					0,
					300,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[1672, 150, 0, 48, 46, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				18,
				21,
				[
				],
				[
				[
					1,
					1,
					2,
					4,
					0,
					0,
					0,
					300,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[4948, 230, 0, 48, 46, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				18,
				48,
				[
				],
				[
				[
					1,
					1,
					2,
					4,
					0,
					0,
					0,
					300,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[5425, 190, 0, 48, 46, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				18,
				75,
				[
				],
				[
				[
					1,
					1,
					2,
					4,
					0,
					0,
					0,
					300,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[7555, 170, 0, 48, 46, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				18,
				71,
				[
				],
				[
				[
					1,
					1,
					2,
					4,
					0,
					0,
					0,
					300,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[8035, 77, 0, 62, 54, 0, 3.03974, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				107,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[3727, 232, 0, 48, 46, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				18,
				81,
				[
				],
				[
				[
					1,
					1,
					2,
					4,
					0,
					0,
					0,
					300,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[3773, 201, 0, 48, 46, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				18,
				79,
				[
				],
				[
				[
					1,
					1,
					2,
					4,
					0,
					0,
					0,
					300,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[352, 476.606, 0, 878, 86, 0, 0, 1, 0.5, 0.507042, 0, 0, []],
				67,
				112,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[2476.62, 516, 0, 797.765, 85, 0, 0, 1, 0.5, 0.507042, 0, 0, []],
				67,
				141,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[6026, 598, 0, 808, 85, 0, 0, 1, 0.5, 0.507042, 0, 0, []],
				67,
				142,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[7569, 249, 0, 48, 46, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				18,
				146,
				[
				],
				[
				[
					1,
					1,
					2,
					4,
					0,
					0,
					0,
					300,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[7543, 231, 0, 48, 46, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				18,
				145,
				[
				],
				[
				[
					1,
					1,
					2,
					4,
					0,
					0,
					0,
					300,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[7528.16, 278.932, 0, 48, 46, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				18,
				152,
				[
				],
				[
				[
					1,
					1,
					2,
					4,
					0,
					0,
					0,
					300,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[46448, -5, 0, 11978, 709, 0, 0, 1, 0, 0, 0, 0, []],
				95,
				214,
				[
				],
				[
				],
				[
					0,
					0
				]
			]
,			[
				[49868, 529, 0, 92, 101, 0, 0, 1, 0.5, 0.504951, 0, 0, []],
				100,
				243,
				[
				],
				[
				[
					1,
					0,
					0,
					6,
					0,
					0,
					0,
					50,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[53207, 336, 0, 92, 101, 0, 0, 1, 0.5, 0.504951, 0, 0, []],
				100,
				247,
				[
				],
				[
				[
					1,
					0,
					0,
					9,
					0,
					0,
					0,
					50,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[53984, 583, 0, 92, 101, 0, 0, 1, 0.5, 0.504951, 0, 0, []],
				100,
				195,
				[
				],
				[
				[
					1,
					0,
					0,
					9,
					0,
					0,
					0,
					50,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[54139.5, 559.604, 0, 121, 122, 0, 0, 1, 0.5, 0.504951, 0, 0, []],
				100,
				267,
				[
				],
				[
				[
					1,
					0,
					0,
					9,
					0,
					0,
					0,
					50,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[58427, 0, 0, 13386, 725, 0, 0, 1, 0, 0, 0, 0, []],
				104,
				367,
				[
				],
				[
				],
				[
					0,
					0
				]
			]
,			[
				[71813, -3, 0, 14972, 784, 0, 0, 1, 0, 0, 0, 0, []],
				72,
				686,
				[
				],
				[
				],
				[
					0,
					0
				]
			]
,			[
				[86757, -20, 0, 20169, 745, 0, 0, 1, 0, 0, 0, 0, []],
				114,
				942,
				[
				],
				[
				],
				[
					0,
					0
				]
			]
,			[
				[123640, -204, 0, 20995, 900, 0, 0, 1, 0, 0, 0, 0, []],
				118,
				696,
				[
				],
				[
				],
				[
					0,
					0
				]
			]
,			[
				[106925, -16, 0, 16691, 798, 0, 0, 1, 0, 0, 0, 0, []],
				5,
				702,
				[
				],
				[
				],
				[
					0,
					0
				]
			]
,			[
				[118771, 661, 0, 92, 101, 0, 0, 1, 0.5, 0.504951, 0, 0, []],
				100,
				998,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					100,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[119351, 669, 0, 121, 122, 0, 0, 1, 0.5, 0.504951, 0, 0, []],
				100,
				999,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					100,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[118423, 681, 0, 98, 59, 0, -3.11153, 1, 0.507463, 0.5, 0, 0, []],
				134,
				1000,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[118285, 682, 0, 98, 59, 0, -3.11153, 1, 0.507463, 0.5, 0, 0, []],
				134,
				1001,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
			],
			[			]
		]
,		[
			"villanos",
			1,
			3954677379188748,
			true,
			[255, 255, 255],
			true,
			1,
			1,
			1,
			false,
			1,
			0,
			0,
			[
			[
				[144646, -88, 0, 43353, 798, 0, 0, 1, 0, 0, 0, 0, []],
				5,
				1043,
				[
				],
				[
				],
				[
					0,
					0
				]
			]
,			[
				[30710, -7, 0, 15738, 745, 0, 0, 1, 0, 0, 0, 0, []],
				114,
				177,
				[
				],
				[
				],
				[
					0,
					0
				]
			]
,			[
				[84522, 282, 0, 48, 46, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				18,
				973,
				[
				],
				[
				[
					1,
					1,
					2,
					6,
					0,
					0,
					0,
					600,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[84222, 253, 0, 48, 46, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				18,
				967,
				[
				],
				[
				[
					1,
					1,
					2,
					6,
					0,
					0,
					0,
					600,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[80621, 33, 0, 178, 259, 0, 0, 1, 0.504065, 0.502463, 0, 0, []],
				16,
				373,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[80589, 119, 0, 48, 46, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				18,
				707,
				[
				],
				[
				[
					1,
					1,
					2,
					4,
					0,
					0,
					0,
					300,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[76970, 240, 0, 48, 46, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				18,
				323,
				[
				],
				[
				[
					1,
					1,
					2,
					4,
					0,
					0,
					0,
					300,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[77016, 209, 0, 48, 46, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				18,
				324,
				[
				],
				[
				[
					1,
					1,
					2,
					4,
					0,
					0,
					0,
					300,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[76941, 191, 0, 48, 46, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				18,
				325,
				[
				],
				[
				[
					1,
					1,
					2,
					4,
					0,
					0,
					0,
					300,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[76992, 182, 0, 48, 46, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				18,
				328,
				[
				],
				[
				[
					1,
					1,
					2,
					4,
					0,
					0,
					0,
					300,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[76497, 214, 0, 48, 46, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				18,
				687,
				[
				],
				[
				[
					1,
					1,
					2,
					4,
					0,
					0,
					0,
					300,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[76491, 235, 0, 48, 46, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				18,
				316,
				[
				],
				[
				[
					1,
					1,
					2,
					4,
					0,
					0,
					0,
					300,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[76479, 204, 0, 48, 46, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				18,
				659,
				[
				],
				[
				[
					1,
					1,
					2,
					4,
					0,
					0,
					0,
					300,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[76501, 165, 0, 48, 46, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				18,
				669,
				[
				],
				[
				[
					1,
					1,
					2,
					4,
					0,
					0,
					0,
					300,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[78402, 93, 0, 178, 259, 0, 0, 1, 0.504065, 0.502463, 0, 0, []],
				16,
				318,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[116259, 162, 0, 98, 59, 0, 0, 1, 0.507463, 0.5, 0, 0, []],
				134,
				931,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[116065, 161, 0, 98, 59, 0, 0, 1, 0.507463, 0.5, 0, 0, []],
				134,
				926,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[115962, 164, 0, 98, 59, 0, 0.0264624, 1, 0.507463, 0.5, 0, 0, []],
				134,
				925,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[116160, 161, 0, 98, 59, 0, 0, 1, 0.507463, 0.5, 0, 0, []],
				134,
				927,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[110774, 138, 0, 98, 59, 0, 0, 1, 0.507463, 0.5, 0, 0, []],
				134,
				952,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[110674, 126, 0, 98, 59, 0, 0, 1, 0.507463, 0.5, 0, 0, []],
				134,
				951,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[110458, 111, 0, 98, 59, 0, 0, 1, 0.507463, 0.5, 0, 0, []],
				134,
				950,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[110065, 117, 0, 98, 59, 0, 0, 1, 0.507463, 0.5, 0, 0, []],
				134,
				937,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[110163, 117, 0, 98, 59, 0, 0, 1, 0.507463, 0.5, 0, 0, []],
				134,
				938,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[110259, 118, 0, 98, 59, 0, 0, 1, 0.507463, 0.5, 0, 0, []],
				134,
				943,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[110357, 118, 0, 98, 59, 0, 0, 1, 0.507463, 0.5, 0, 0, []],
				134,
				947,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[109349, 142, 0, 98, 59, 0, 0, 1, 0.507463, 0.5, 0, 0, []],
				134,
				932,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[109447, 142, 0, 98, 59, 0, 0, 1, 0.507463, 0.5, 0, 0, []],
				134,
				933,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[109543, 143, 0, 98, 59, 0, 0, 1, 0.507463, 0.5, 0, 0, []],
				134,
				934,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[109641, 143, 0, 98, 59, 0, 0, 1, 0.507463, 0.5, 0, 0, []],
				134,
				936,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[111176, 672, 0, 98, 59, 0, 3.12692, 1, 0.507463, 0.5, 0, 0, []],
				134,
				918,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[111271, 675, 0, 98, 59, 0, 3.12692, 1, 0.507463, 0.5, 0, 0, []],
				134,
				919,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[108356, 22, 0, 692, -193, 0, 0.0133033, 1, 0.5, 0.5, 0, 0, []],
				94,
				916,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[108976, 10, 0, 692, -193, 0, 0.0133033, 1, 0.5, 0.5, 0, 0, []],
				94,
				915,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[50130, 525, 0, 116, 139, 0, 0, 1, 0.5, 0.504951, 0, 0, []],
				100,
				715,
				[
				],
				[
				[
					1,
					0,
					0,
					9,
					0,
					0,
					0,
					50,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[54935, 424, 0, 92, 101, 0, 0, 1, 0.5, 0.504951, 0, 0, []],
				100,
				292,
				[
				],
				[
				[
					1,
					0,
					0,
					9,
					0,
					0,
					0,
					50,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[53573, 562, 0, 92, 101, 0, 0, 1, 0.5, 0.504951, 0, 0, []],
				100,
				236,
				[
				],
				[
				[
					1,
					0,
					0,
					9,
					0,
					0,
					0,
					50,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[51332, 543, 0, 116, 139, 0, 0, 1, 0.5, 0.504951, 0, 0, []],
				100,
				291,
				[
				],
				[
				[
					1,
					0,
					0,
					9,
					0,
					0,
					0,
					70,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[51059, 544, 0, 116, 139, 0, 0, 1, 0.5, 0.504951, 0, 0, []],
				100,
				253,
				[
				],
				[
				[
					1,
					0,
					0,
					9,
					0,
					0,
					0,
					50,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[49650, 527, 0, 116, 139, 0, 0, 1, 0.5, 0.504951, 0, 0, []],
				100,
				250,
				[
				],
				[
				[
					1,
					0,
					0,
					9,
					0,
					0,
					0,
					50,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[60253, 705, 0, 120, 140, 0, 0, 1, 0.504951, 0.504065, 0, 0, []],
				111,
				279,
				[
				],
				[
				[
					1,
					1,
					0,
					3,
					0,
					0,
					0,
					500,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[58417, 656, 0, 13371, 96, 0, 0, 1, 0, 0, 0, 0, []],
				110,
				269,
				[
				],
				[
				],
				[
					0,
					0
				]
			]
,			[
				[3290, 71, 0, 178, 259, 0, 0, 1, 0.504065, 0.502463, 0, 0, []],
				16,
				22,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[1691.03, 73.5566, 0, 178, 259, 0, 0, 1, 0.504065, 0.502463, 0, 0, []],
				16,
				19,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[691, 444, 0, 67, 69, 0, 0, 1, 0.5, 0.507246, 0, 0, []],
				27,
				40,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[3828, 281, 0, 50, 57, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				28,
				41,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[4593, 593, 0, 838, 221, 0, 0, 1, 0.5, 0.502262, 0, 0, []],
				4,
				42,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[4466, 422, 0, 435, 124, 0, 0, 1, 0.5, 0.502262, 0, 0, []],
				4,
				43,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[4479.06, 344.673, 0, 56, 49, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				44,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[4728.18, 475.277, 0, 62, 54, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				46,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[4953, 78, 0, 178, 259, 0, 0, 1, 0.504065, 0.502463, 0, 0, []],
				16,
				47,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[4924, 482, 0, 131, 40, 0, 0, 1, 0.5, 0.555556, 0, 0, []],
				17,
				49,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[3982, 469.029, 0, 73, 73, 0, 0, 1, 0.5, 0.507246, 0, 0, []],
				27,
				50,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[6039, 706, 0, 838, 221, 0, 0, 1, 0.5, 0.502262, 0, 0, []],
				4,
				52,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[6618, 681, 0, 73, 73, 0, 0, 1, 0.5, 0.507246, 0, 0, []],
				27,
				53,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[6918.53, 665, 0, 73, 73, 0, 0, 1, 0.5, 0.507246, 0, 0, []],
				27,
				55,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[7190, 646.922, 0, 73, 73, 0, 0, 1, 0.5, 0.507246, 0, 0, []],
				27,
				57,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[7400.62, 584.698, 0, 73, 73, 0, 0, 1, 0.5, 0.507246, 0, 0, []],
				27,
				58,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[7525.63, 469.769, 0, 73, 73, 0, 0, 1, 0.5, 0.507246, 0, 0, []],
				27,
				59,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[5305, 543, 0, 73, 73, 0, 0, 1, 0.5, 0.507246, 0, 0, []],
				27,
				60,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[7736, 361, 0, 73, 73, 0, 0, 1, 0.5, 0.507246, 0, 0, []],
				27,
				61,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[8013, 350, 0, 73, 73, 0, 0, 1, 0.5, 0.507246, 0, 0, []],
				27,
				62,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[8230, 348, 0, 73, 73, 0, 0, 1, 0.5, 0.507246, 0, 0, []],
				27,
				63,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[8302, 349, 0, 73, 73, 0, 0, 1, 0.5, 0.507246, 0, 0, []],
				27,
				64,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[8375, 350, 0, 73, 73, 0, 0, 1, 0.5, 0.507246, 0, 0, []],
				27,
				65,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[8447, 350, 0, 73, 73, 0, 0, 1, 0.5, 0.507246, 0, 0, []],
				27,
				66,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[8310, 276, 0, 73, 73, 0, 0, 1, 0.5, 0.507246, 0, 0, []],
				27,
				67,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[8157, 349, 0, 73, 73, 0, 0, 1, 0.5, 0.507246, 0, 0, []],
				27,
				68,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[8086, 349, 0, 73, 73, 0, 0, 1, 0.5, 0.507246, 0, 0, []],
				27,
				69,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[7546, 79, 0, 178, 259, 0, 0, 1, 0.504065, 0.502463, 0, 0, []],
				16,
				70,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[7523.08, 437.229, 0, 82, 24, 0, 0, 1, 0.5, 0.555556, 0, 0, []],
				17,
				72,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[5177, 590, 0, 73, 73, 0, 0, 1, 0.5, 0.507246, 0, 0, []],
				27,
				73,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[5429, 90, 0, 178, 259, 0, 0, 1, 0.504065, 0.502463, 0, 0, []],
				16,
				74,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[5428, 478, 0, 73, 73, 0, 0, 1, 0.5, 0.507246, 0, 0, []],
				27,
				76,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[5429, 439, 0, 76, 17, 0, 0, 1, 0.5, 0.555556, 0, 0, []],
				17,
				77,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[3747, 71, 0, 178, 259, 0, 0, 1, 0.504065, 0.502463, 0, 0, []],
				16,
				78,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[3206, 47, 0, 120, 128, 0, 0, 1, 0.5, 0.503597, 0, 0, []],
				29,
				83,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[3634, 57, 0, 126, 138, 0, 0, 1, 0.5, 0.503597, 0, 0, []],
				29,
				84,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[3367, 17, 0, 116, 132, 0, 0.846575, 1, 0.5, 0.503597, 0, 0, []],
				29,
				85,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[4881, 47, 0, 120, 128, 0, 0, 1, 0.5, 0.503597, 0, 0, []],
				29,
				87,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[5012, 26, 0, 120, 128, 0, 0.528897, 1, 0.5, 0.503597, 0, 0, []],
				29,
				88,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[5072, 56, 0, 120, 128, 0, 0, 1, 0.5, 0.503597, 0, 0, []],
				29,
				89,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[5211, 51, 0, 120, 128, 0, 0, 1, 0.5, 0.503597, 0, 0, []],
				29,
				90,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[5377, 10, 0, 120, 128, 0, 0, 1, 0.5, 0.503597, 0, 0, []],
				29,
				91,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[5487, 40, 0, -83, 99, 0, 0.792027, 1, 0.5, 0.503597, 0, 0, []],
				29,
				92,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[7491, 34, 0, 120, 128, 0, 0, 1, 0.5, 0.503597, 0, 0, []],
				29,
				93,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[2464, 24, 0, 120, 128, 0, 0, 1, 0.5, 0.503597, 0, 0, []],
				29,
				94,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[2547, 19, 0, 120, 128, 0, -1.43394, 1, 0.5, 0.503597, 0, 0, []],
				29,
				95,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[1616, 8, 0, 120, 128, 0, 0, 1, 0.5, 0.503597, 0, 0, []],
				29,
				96,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[1770.5, -19, 0, -115, -129, 0, 1.67019, 1, 0.5, 0.503597, 0, 0, []],
				29,
				97,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[1743, 35, 0, 120, 128, 0, 0, 1, 0.5, 0.503597, 0, 0, []],
				29,
				98,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[5274, 51, 0, 120, 128, 0, -0.790467, 1, 0.5, 0.503597, 0, 0, []],
				29,
				99,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[3810, 30, 0, 126, 138, 0, -1.31302, 1, 0.5, 0.503597, 0, 0, []],
				29,
				100,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[2500, 47, 0, 120, 128, 0, 0, 1, 0.5, 0.503597, 0, 0, []],
				29,
				101,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[583.024, 380.009, 0, 133, 221, 0, 0, 1, 0.503937, 0.502304, 0, 0, []],
				33,
				105,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[2553.09, 42.0751, 0, 47.1576, 42.8889, 0, 2.92944, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				31,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[4414.28, 324.187, 0, 147, 91, 0, 0, 1, 0.50641, 0.523364, 0, 0, []],
				15,
				32,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					90,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[8130, 268, 0, 186, 108, 0, 0, 1, 0.50641, 0.523364, 0, 0, []],
				15,
				34,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					90,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[6077, 602, 0, 62, 54, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				54,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[8003, 37, 0, 120, 128, 0, 0.427153, 1, 0.5, 0.503597, 0, 0, []],
				29,
				56,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[8064, 34, 0, 120, 128, 0, -1.02826, 1, 0.5, 0.503597, 0, 0, []],
				29,
				106,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[8307.03, 224.027, 0, 37.2993, 35.6848, 0, -2.30562, 1, 0.5, 0.5, 0, 0, []],
				40,
				108,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[7940, 350, 0, 73, 73, 0, 0, 1, 0.5, 0.507246, 0, 0, []],
				27,
				109,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[4782, 458, 0, -171, 91, 0, -0.0408838, 1, 0.50641, 0.523364, 0, 0, []],
				15,
				110,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					90,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[536, 295, 0, 702, 307, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				55,
				133,
				[
				],
				[
				],
				[
					1,
					"Default",
					0,
					1
				]
			]
,			[
				[748, 415, 0, 139, 48, 0, 0, 1, 0.502075, 0.506173, 0, 0, []],
				56,
				134,
				[
				],
				[
				],
				[
					1,
					"Default",
					0,
					1
				]
			]
,			[
				[485.375, 399.737, 0, -115, -108, 0, -2.85705, 0.6, 0.512195, 0.5, 0, 0, []],
				57,
				135,
				[
				],
				[
				[
					1,
					1,
					0,
					4,
					0,
					0,
					0,
					50,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[398, 182, 0, 425, 222, 0, 0, 1, 0, 0, 0, 0, []],
				62,
				136,
				[
				],
				[
				],
				[
					"Text",
					1,
					"20pt Book Antiqua",
					"rgb(0,0,0)",
					0,
					0,
					0,
					0,
					0
				]
			]
,			[
				[2683, 477, 0, -132, 72, 0, 0, 1, 0.50641, 0.523364, 0, 0, []],
				15,
				138,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					90,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[6887, 608, 0, 50, 57, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				28,
				144,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[7597.78, 469.769, 0, 73, 73, 0, 0, 1, 0.5, 0.507246, 0, 0, []],
				27,
				147,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[7591.23, 435.308, 0, 82, 24, 0, 0, 1, 0.5, 0.555556, 0, 0, []],
				17,
				148,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[7580, 47, 0, -104, 128, 0, 0, 1, 0.5, 0.503597, 0, 0, []],
				29,
				149,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[7524.1, 541.691, 0, 73, 73, 0, 0, 1, 0.5, 0.507246, 0, 0, []],
				27,
				150,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[7670.92, 470.009, 0, 73, 73, 0, 0, 1, 0.5, 0.507246, 0, 0, []],
				27,
				151,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[7596, 540, 0, 73, 73, 0, 0, 1, 0.5, 0.507246, 0, 0, []],
				27,
				153,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[7668, 541, 0, 73, 73, 0, 0, 1, 0.5, 0.507246, 0, 0, []],
				27,
				154,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[4393, 449, 0, 147, 91, 0, 0, 1, 0.50641, 0.523364, 0, 0, []],
				15,
				155,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					90,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[7524, 614, 0, 73, 73, 0, 0, 1, 0.5, 0.507246, 0, 0, []],
				27,
				156,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[6845, 668, 0, 73, 73, 0, 0, 1, 0.5, 0.507246, 0, 0, []],
				27,
				140,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[6770, 683, 0, 73, 73, 0, 0, 1, 0.5, 0.507246, 0, 0, []],
				27,
				420,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[62111, 768, 0, 106881, 27, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				7,
				442,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[19913, 57, 0, 62, 54, 0, 3.03974, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				443,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[14354, 496, 0, 797.765, 85, 0, 0, 1, 0.5, 0.507042, 0, 0, []],
				67,
				445,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[17904, 578, 0, 808, 85, 0, 0, 1, 0.5, 0.507042, 0, 0, []],
				67,
				446,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[10161, -25, 0, 20541, 797, 0, 0, 1, 0, 0, 0, 0, []],
				72,
				447,
				[
				],
				[
				],
				[
					0,
					0
				]
			]
,			[
				[12224, 633, 0, 691, 66, 0, 0, 1, 0.501027, 0.5, 0, 0, []],
				73,
				448,
				[
				],
				[
				[
					1
				],
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					50,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[15157, 628, 0, 487, 66, 0, 0, 1, 0.501027, 0.5, 0, 0, []],
				73,
				449,
				[
				],
				[
				[
					1
				],
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					50,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[16482, 649, 0, 487, 66, 0, 0, 1, 0.501027, 0.5, 0, 0, []],
				73,
				450,
				[
				],
				[
				[
					1
				],
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					50,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[18155, 659, 0, 487, 66, 0, 0, 1, 0.501027, 0.5, 0, 0, []],
				73,
				451,
				[
				],
				[
				[
					1
				],
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					50,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[13807.7, 680, 0, 548, 66, 0, 0, 1, 0.501027, 0.5, 0, 0, []],
				73,
				453,
				[
				],
				[
				[
					1
				],
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					50,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[14382, 678, 0, 610, 65, 0, 0, 1, 0.501027, 0.5, 0, 0, []],
				73,
				454,
				[
				],
				[
				[
					1
				],
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					50,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[15683, 629, 0, 224, 46, 0, 0, 1, 0.501027, 0.5, 0, 0, []],
				73,
				455,
				[
				],
				[
				[
					1
				],
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					50,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[16053, 529, 0, 344, 66, 0, 0, 1, 0.501027, 0.5, 0, 0, []],
				73,
				456,
				[
				],
				[
				[
					1
				],
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					50,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[16901, 521, 0, 183, 50, 0, -0.296616, 1, 0.501027, 0.5, 0, 0, []],
				75,
				457,
				[
				],
				[
				[
					1
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[17203, 534, 0, 259, 50, 0, 0.290545, 1, 0.501027, 0.5, 0, 0, []],
				75,
				458,
				[
				],
				[
				[
					1
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[17551, 549, 0, 311, 50, 0, -0.483869, 1, 0.501027, 0.5, 0, 0, []],
				75,
				459,
				[
				],
				[
				[
					1
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[17871, 501, 0, 229, 50, 0, 0.204511, 1, 0.501027, 0.5, 0, 0, []],
				75,
				460,
				[
				],
				[
				[
					1
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[18536, 620, 0, 183, 50, 0, -0.259474, 1, 0.501027, 0.5, 0, 0, []],
				75,
				461,
				[
				],
				[
				[
					1
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[18840, 608, 0, 227, 50, 0, -0.116451, 1, 0.501027, 0.5, 0, 0, []],
				75,
				462,
				[
				],
				[
				[
					1
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[19162, 513, 0, 264, 50, 0, 0.00559462, 1, 0.501027, 0.5, 0, 0, []],
				75,
				463,
				[
				],
				[
				[
					1
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[19544, 455, 0, 383, 62, 0, 0, 1, 0.501027, 0.5, 0, 0, []],
				73,
				464,
				[
				],
				[
				[
					1
				],
				[
					1,
					0,
					0,
					6,
					0,
					0,
					0,
					50,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[20133, 616, 0, 453, 62, 0, -0.0226739, 1, 0.501027, 0.5, 0, 0, []],
				73,
				465,
				[
				],
				[
				[
					1
				],
				[
					1,
					0,
					0,
					6,
					0,
					0,
					0,
					50,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[20766, 642, 0, 535, 62, 0, -0.0197648, 1, 0.501027, 0.5, 0, 0, []],
				73,
				466,
				[
				],
				[
				[
					1
				],
				[
					1,
					0,
					0,
					6,
					0,
					0,
					0,
					50,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[21356, 657, 0, 334, 62, 0, 0.00559462, 1, 0.501027, 0.5, 0, 0, []],
				75,
				467,
				[
				],
				[
				[
					1
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[21683, 660.028, 0, 344, 62, 0, 0.00559462, 1, 0.501027, 0.5, 0, 0, []],
				75,
				468,
				[
				],
				[
				[
					1
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[22154, 588, 0, 334, 62, 0, -0.189129, 1, 0.501027, 0.5, 0, 0, []],
				75,
				469,
				[
				],
				[
				[
					1
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[22544, 450, 0, 397, 62, 0, -0.189129, 1, 0.501027, 0.5, 0, 0, []],
				75,
				470,
				[
				],
				[
				[
					1
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[23004, 359, 0, 428, 62, 0, -0.189129, 1, 0.501027, 0.5, 0, 0, []],
				75,
				471,
				[
				],
				[
				[
					1
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[26484, 428, 0, 287, 194, 0, 0, 1, 0.5, 0.504673, 0, 0, []],
				76,
				472,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					50,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[26488, 553, 0, 408, 67, 0, 0.013855, 1, 0.501027, 0.5, 0, 0, []],
				75,
				473,
				[
				],
				[
				[
					1
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[23540, 557, 0, 386, 62, 0, 0.0536611, 1, 0.501027, 0.5, 0, 0, []],
				75,
				474,
				[
				],
				[
				[
					1
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[24011.5, 558.585, 0, 367, 62, 0, 0.0353624, 1, 0.501027, 0.5, 0, 0, []],
				75,
				475,
				[
				],
				[
				[
					1
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[25089, 649, 0, 530, 118, 0, 0.00559462, 1, 0.501027, 0.5, 0, 0, []],
				75,
				476,
				[
				],
				[
				[
					1
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[25753, 665, 0, 687, 87, 0, 0.00559462, 1, 0.501027, 0.5, 0, 0, []],
				75,
				477,
				[
				],
				[
				[
					1
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[24921, 536, 0, 530, 118, 0, 0.00559462, 1, 0.501027, 0.5, 0, 0, []],
				75,
				478,
				[
				],
				[
				[
					1
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[24577, 650, 0, 530, 118, 0, 0.00559462, 1, 0.501027, 0.5, 0, 0, []],
				75,
				479,
				[
				],
				[
				[
					1
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[24777, 407, 0, 50, 57, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				28,
				480,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[24838, 404, 0, 50, 57, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				28,
				481,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[24896, 404, 0, 50, 57, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				28,
				482,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[24968, 402, 0, 50, 57, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				28,
				483,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[25022, 398, 0, 50, 57, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				28,
				484,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[26996, 591, 0, 377, 62, 0, -0.00325216, 1, 0.501027, 0.5, 0, 0, []],
				75,
				485,
				[
				],
				[
				[
					1
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[19139, 456, 0, -129, 91, 0, -0.0914466, 1, 0.50641, 0.523364, 0, 0, []],
				15,
				486,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					90,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[25083, 398, 0, 50, 57, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				28,
				487,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[27535, 374, 0, 334, 62, 0, 0.187352, 1, 0.501027, 0.5, 0, 0, []],
				75,
				488,
				[
				],
				[
				[
					1
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[12905.7, 637.349, 0, 384, 55, 0, 0.235178, 1, 0.501027, 0.5, 0, 0, []],
				73,
				489,
				[
				],
				[
				[
					1
				],
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					50,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[13326, 643, 0, 262, 44, 0, -0.0400786, 1, 0.501027, 0.5, 0, 0, []],
				73,
				490,
				[
				],
				[
				[
					1
				],
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					50,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[13662, 594, 0, 262, 44, 0, 0.0109283, 1, 0.501027, 0.5, 0, 0, []],
				73,
				491,
				[
				],
				[
				[
					1
				],
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					50,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[27859, 644, 0, 334, 62, 0, 0.187352, 1, 0.501027, 0.5, 0, 0, []],
				75,
				492,
				[
				],
				[
				[
					1
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[28241, 627, 0, 334, 62, 0, 0, 1, 0.501027, 0.5, 0, 0, []],
				75,
				493,
				[
				],
				[
				[
					1
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[28211, 333, 0, 334, 62, 0, -3.1286, 1, 0.501027, 0.5, 0, 0, []],
				75,
				494,
				[
				],
				[
				[
					1
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[27800, 567, 0, 65, 63, 0, 0.00656778, 1, 0.506849, 0.5, 0, 0, []],
				77,
				495,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[13336, 583, 0, 80, 78, 0, -0.0489648, 1, 0.506849, 0.5, 0, 0, []],
				77,
				497,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[18165, 580, 0, 113, 110, 0, 0.0160771, 1, 0.506849, 0.5, 0, 0, []],
				77,
				498,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[18281, 588, 0, 84, 85, 0, 0.0160771, 1, 0.506849, 0.5, 0, 0, []],
				77,
				499,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[19504, 383, 0, 85, 84, 0, 0.0160771, 1, 0.506849, 0.5, 0, 0, []],
				77,
				500,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[19669, 391, 0, 75, 71, 0, 0.0160771, 1, 0.506849, 0.5, 0, 0, []],
				77,
				501,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[18931, 31, 0, -104, 128, 0, 0, 1, 0.5, 0.503597, 0, 0, []],
				29,
				502,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[18995, 35, 0, -104, 128, 0, 0, 1, 0.5, 0.503597, 0, 0, []],
				29,
				503,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[18973, 26, 0, 120, 128, 0, 0, 1, 0.5, 0.503597, 0, 0, []],
				29,
				504,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[19195, 45, 0, -104, 128, 0, 0, 1, 0.5, 0.503597, 0, 0, []],
				29,
				505,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[19173, 36, 0, 120, 128, 0, 0, 1, 0.5, 0.503597, 0, 0, []],
				29,
				506,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[19026, 22, 0, 120, 128, 0, 0, 1, 0.5, 0.503597, 0, 0, []],
				29,
				507,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[19083, 35, 0, -104, 128, 0, 0, 1, 0.5, 0.503597, 0, 0, []],
				29,
				508,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[19343, 27, 0, -104, 128, 0, 0, 1, 0.5, 0.503597, 0, 0, []],
				29,
				509,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[19321, 18, 0, 120, 128, 0, 0, 1, 0.5, 0.503597, 0, 0, []],
				29,
				510,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[19174, 4, 0, 120, 128, 0, 0, 1, 0.5, 0.503597, 0, 0, []],
				29,
				511,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[19231, 17, 0, -104, 128, 0, 0, 1, 0.5, 0.503597, 0, 0, []],
				29,
				512,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[19919, 15, 0, -104, 128, 0, 0, 1, 0.5, 0.503597, 0, 0, []],
				29,
				513,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[19897, 6, 0, 120, 128, 0, 0, 1, 0.5, 0.503597, 0, 0, []],
				29,
				514,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[19750, -8, 0, 120, 128, 0, 0, 1, 0.5, 0.503597, 0, 0, []],
				29,
				515,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[19807, 5, 0, -104, 128, 0, 0, 1, 0.5, 0.503597, 0, 0, []],
				29,
				516,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[20072, 23, 0, -104, 128, 0, 0, 1, 0.5, 0.503597, 0, 0, []],
				29,
				517,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[20050, 14, 0, 120, 128, 0, 0, 1, 0.5, 0.503597, 0, 0, []],
				29,
				518,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[19903, 0, 0, 120, 128, 0, 0, 1, 0.5, 0.503597, 0, 0, []],
				29,
				519,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[19960, 13, 0, -104, 128, 0, 0, 1, 0.5, 0.503597, 0, 0, []],
				29,
				520,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[20243, 6, 0, -104, 128, 0, 0, 1, 0.5, 0.503597, 0, 0, []],
				29,
				521,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[20221, -3, 0, 120, 128, 0, 0, 1, 0.5, 0.503597, 0, 0, []],
				29,
				522,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[20074, -17, 0, 120, 128, 0, 0, 1, 0.5, 0.503597, 0, 0, []],
				29,
				523,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[20131, -4, 0, -104, 128, 0, 0, 1, 0.5, 0.503597, 0, 0, []],
				29,
				524,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[12481, 27, 0, -104, 128, 0, 0, 1, 0.5, 0.503597, 0, 0, []],
				29,
				525,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[12459, 18, 0, 120, 128, 0, 0, 1, 0.5, 0.503597, 0, 0, []],
				29,
				526,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[12312, 4, 0, 120, 128, 0, 0, 1, 0.5, 0.503597, 0, 0, []],
				29,
				527,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[12369, 17, 0, -104, 128, 0, 0, 1, 0.5, 0.503597, 0, 0, []],
				29,
				528,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[12610, 8, 0, -104, 128, 0, 0, 1, 0.5, 0.503597, 0, 0, []],
				29,
				529,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[12588, -1, 0, 120, 128, 0, 0, 1, 0.5, 0.503597, 0, 0, []],
				29,
				530,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[12441, -15, 0, 120, 128, 0, 0, 1, 0.5, 0.503597, 0, 0, []],
				29,
				531,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[12498, -2, 0, -104, 128, 0, 0, 1, 0.5, 0.503597, 0, 0, []],
				29,
				532,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[12079, -3, 0, -104, 128, 0, 0, 1, 0.5, 0.503597, 0, 0, []],
				29,
				533,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[12057, -12, 0, 120, 128, 0, 0, 1, 0.5, 0.503597, 0, 0, []],
				29,
				534,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[11967, -13, 0, -104, 128, 0, 0, 1, 0.5, 0.503597, 0, 0, []],
				29,
				535,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[22416, 396, 0, 113, 110, 0, -0.178089, 1, 0.506849, 0.5, 0, 0, []],
				77,
				536,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[22616, 368, 0, 84, 85, 0, -0.178089, 1, 0.506849, 0.5, 0, 0, []],
				77,
				537,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[25462, 578, 0, 113, 110, 0, 0.0435534, 1, 0.506849, 0.5, 0, 0, []],
				77,
				538,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[14036, 443, 0, 262, 44, 0, 0, 1, 0.501027, 0.5, 0, 0, []],
				73,
				540,
				[
				],
				[
				[
					1
				],
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					50,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[14483.5, 272, 0, 275, 44, 0, 0, 1, 0.501027, 0.5, 0, 0, []],
				73,
				541,
				[
				],
				[
				[
					1
				],
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					50,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[14806, 234, 0, 262, 44, 0, 0, 1, 0.501027, 0.5, 0, 0, []],
				73,
				542,
				[
				],
				[
				[
					1
				],
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					50,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[14433, 193, 0, 219, 156, 0, 0, 1, 0.50641, 0.523364, 0, 0, []],
				15,
				543,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					90,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[14708, 167, 0, 191, 122, 0, 0, 1, 0.50641, 0.523364, 0, 0, []],
				15,
				544,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					90,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[14852, 174, 0, 191, 122, 0, 0, 1, 0.50641, 0.523364, 0, 0, []],
				15,
				545,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					90,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[14534, 207, 0, 191, 122, 0, 0, 1, 0.50641, 0.523364, 0, 0, []],
				15,
				546,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					90,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[15047, 263, 0, 54, 50, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				547,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[15092, 266, 0, 54, 50, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				548,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[15137, 264, 0, 54, 50, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				549,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[15174, 262, 0, 54, 50, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				550,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[15219, 261, 0, 54, 50, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				551,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[15392, 136, 0, 54, 50, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				552,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[15448, 142, 0, 54, 50, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				553,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[15524, 144, 0, 54, 50, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				554,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[15565, 142, 0, 54, 50, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				555,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[15731, 95, 0, 54, 50, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				556,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[15771, 94, 0, 54, 50, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				557,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[15815, 92, 0, 54, 50, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				558,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[15869, 91, 0, 54, 50, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				559,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[15912, 90, 0, 54, 50, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				560,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[15489, 137, 0, 54, 50, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				561,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[15858, 138, 0, 343, 50, 0, -0.027734, 1, 0.501027, 0.5, 0, 0, []],
				75,
				562,
				[
				],
				[
				[
					1
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[15495, 184, 0, 343, 50, 0, -0.00182451, 1, 0.501027, 0.5, 0, 0, []],
				75,
				563,
				[
				],
				[
				[
					1
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[15163, 310, 0, 343, 50, 0, 0.0179867, 1, 0.501027, 0.5, 0, 0, []],
				75,
				564,
				[
				],
				[
				[
					1
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[15517, 110, 0, 54, 50, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				565,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[15556, 112, 0, 54, 50, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				566,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[15961, 69, 0, 50, 57, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				28,
				567,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[15999, 78, 0, 50, 57, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				28,
				568,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[15964, 89, 0, 50, 57, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				28,
				569,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[15982, 40, 0, 50, 57, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				28,
				570,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[15985, 81, 0, 50, 57, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				28,
				571,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[15628, 124, 0, 50, 57, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				28,
				572,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[15619, 127, 0, 50, 57, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				28,
				573,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[15602, 136, 0, 50, 57, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				28,
				574,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[15616, 78, 0, 50, 57, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				28,
				575,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[15599, 104, 0, 50, 57, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				28,
				576,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[15628, 130, 0, 50, 57, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				28,
				577,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[15642, 92, 0, 50, 57, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				28,
				578,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[15628, 139, 0, 50, 57, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				28,
				579,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[15850, 90, 0, 54, 50, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				580,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[15889, 60, 0, 54, 50, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				581,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[15850, 51, 0, 54, 50, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				582,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[15874, 28, 0, 54, 50, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				583,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[15908, 23, 0, 54, 50, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				584,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[15232, 264, 0, 50, 57, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				28,
				585,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[15275, 252, 0, 50, 57, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				28,
				586,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[15253, 240, 0, 50, 57, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				28,
				587,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[15296, 228, 0, 50, 57, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				28,
				588,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[15282, 275, 0, 50, 57, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				28,
				589,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[15245, 238, 0, 50, 57, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				28,
				590,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[15285, 229, 0, 50, 57, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				28,
				591,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[15258, 249, 0, 50, 57, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				28,
				592,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[15071, 531, 0, 219, 156, 0, 0, 1, 0.50641, 0.523364, 0, 0, []],
				15,
				593,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					90,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[15944, 53, 0, 50, 57, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				28,
				594,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[15947, 73, 0, 50, 57, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				28,
				595,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[15965, 24, 0, 50, 57, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				28,
				596,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[15968, 65, 0, 50, 57, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				28,
				597,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[15944, 53, 0, 50, 57, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				28,
				598,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[15947, 73, 0, 50, 57, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				28,
				599,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[15965, 24, 0, 50, 57, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				28,
				600,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[15968, 65, 0, 50, 57, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				28,
				601,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[27544, 263, 0, 352, 183, 0, 0.112444, 1, 0.5, 0.504673, 0, 0, []],
				76,
				602,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					50,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[27438, 659, 0, 377, 62, 0, 0.115669, 1, 0.501027, 0.5, 0, 0, []],
				75,
				603,
				[
				],
				[
				[
					1
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[25701, 577, 0, 113, 110, 0, 0.0435534, 1, 0.506849, 0.5, 0, 0, []],
				77,
				604,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[28241, 510, 0, 344, 183, 0, 0.00124493, 1, 0.5, 0.504673, 0, 0, []],
				76,
				605,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					50,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[27212, 403, 0, 235, 62, 0, -0.0552312, 1, 0.501027, 0.5, 0, 0, []],
				75,
				606,
				[
				],
				[
				[
					1
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[27671, 128, 0, 334, 62, 0, 0.150765, 1, 0.501027, 0.5, 0, 0, []],
				75,
				607,
				[
				],
				[
				[
					1
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[27384, 314, 0, 50, 57, 0, 0.523808, 1, 0.5, 0.5, 0, 0, []],
				28,
				608,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[27690, 81, 0, 50, 57, 0, 0.523808, 1, 0.5, 0.5, 0, 0, []],
				28,
				609,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[27752, 93, 0, 50, 57, 0, 0.523808, 1, 0.5, 0.5, 0, 0, []],
				28,
				610,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[28210, 286, 0, 43.1267, 45, 0, -2.39529, 1, 0.5, 0.5, 0, 0, []],
				78,
				611,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[28311, 272, 0, 65, 63, 0, 0.00656778, 1, 0.506849, 0.5, 0, 0, []],
				77,
				612,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[28116, 268, 0, 65, 63, 0, 0.00656778, 1, 0.506849, 0.5, 0, 0, []],
				77,
				614,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[27021, 539, 0, 50, 57, 0, 0.151283, 1, 0.5, 0.5, 0, 0, []],
				28,
				615,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[27459, 598, 0, 65, 63, 0, 0.00656778, 1, 0.506849, 0.5, 0, 0, []],
				77,
				616,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[27545, 618, 0, 50, 57, 0, -0.038162, 1, 0.5, 0.5, 0, 0, []],
				28,
				617,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[27382, 595, 0, 50, 57, 0, -0.038162, 1, 0.5, 0.5, 0, 0, []],
				28,
				618,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[26835, 412, 0, 235, 62, 0, -0.0552312, 1, 0.501027, 0.5, 0, 0, []],
				75,
				619,
				[
				],
				[
				[
					1
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[27236, 129, 0, 235, 62, 0, -0.0552312, 1, 0.501027, 0.5, 0, 0, []],
				75,
				620,
				[
				],
				[
				[
					1
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[27183, 339, 0, 65, 63, 0, 0.00656778, 1, 0.506849, 0.5, 0, 0, []],
				77,
				621,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[26101, 555, 0, 235, 62, 0, 0.00968067, 1, 0.501027, 0.5, 0, 0, []],
				75,
				622,
				[
				],
				[
				[
					1
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[26705, 123, 0, 235, 62, 0, -0.0552312, 1, 0.501027, 0.5, 0, 0, []],
				75,
				623,
				[
				],
				[
				[
					1
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[27038, 265, 0, 208, 55, 0, -0.0552312, 1, 0.501027, 0.5, 0, 0, []],
				75,
				624,
				[
				],
				[
				[
					1
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[26870, 528, 0, 65, 63, 0, 0.00656778, 1, 0.506849, 0.5, 0, 0, []],
				77,
				625,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[27251, 59, 0, 91, 85, 0, 0.00656778, 1, 0.506849, 0.5, 0, 0, []],
				77,
				626,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[27323, 591, 0, 65, 63, 0, 0.00656778, 1, 0.506849, 0.5, 0, 0, []],
				77,
				627,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[13647, 323, 0, 262, 54, 0, 0, 1, 0.501027, 0.5, 0, 0, []],
				73,
				628,
				[
				],
				[
				[
					1
				],
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					50,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[14155, 266, 0, 286, 44, 0, 0, 1, 0.501027, 0.5, 0, 0, []],
				73,
				629,
				[
				],
				[
				[
					1
				],
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					50,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[26994, 471, 0, 287, 194, 0, 0, 1, 0.5, 0.504673, 0, 0, []],
				76,
				630,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					50,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[26672, 61, 0, 65, 63, 0, 0.00656778, 1, 0.506849, 0.5, 0, 0, []],
				77,
				631,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[15210, 458, 0, 50, 57, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				28,
				632,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[16429, 590, 0, 56, 58, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				633,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[16581, 582, 0, 62, 54, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				634,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[14541, 25, 0, 120, 128, 0, 0, 1, 0.5, 0.503597, 0, 0, []],
				29,
				636,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[16326, 7, 0, 120, 128, 0, 0, 1, 0.5, 0.503597, 0, 0, []],
				29,
				637,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[16403, 6, 0, 120, 128, 0, 0.528897, 1, 0.5, 0.503597, 0, 0, []],
				29,
				638,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[16479, 20, 0, 120, 128, 0, 0, 1, 0.5, 0.503597, 0, 0, []],
				29,
				639,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[16546, 29, 0, 120, 128, 0, 0, 1, 0.5, 0.503597, 0, 0, []],
				29,
				640,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[16712, -12, 0, 120, 128, 0, 0, 1, 0.5, 0.503597, 0, 0, []],
				29,
				641,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[16781, 14, 0, -83, 99, 0, 0.792027, 1, 0.5, 0.503597, 0, 0, []],
				29,
				642,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[18826, 12, 0, 120, 128, 0, 0, 1, 0.5, 0.503597, 0, 0, []],
				29,
				643,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[13799, 2, 0, 120, 128, 0, 0, 1, 0.5, 0.503597, 0, 0, []],
				29,
				644,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[13882, -3, 0, 120, 128, 0, -1.43394, 1, 0.5, 0.503597, 0, 0, []],
				29,
				645,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[16609, 29, 0, 120, 128, 0, -0.790467, 1, 0.5, 0.503597, 0, 0, []],
				29,
				646,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[13835, 25, 0, 120, 128, 0, 0, 1, 0.5, 0.503597, 0, 0, []],
				29,
				647,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[12276, 503, 0, 133, 221, 0, 0, 1, 0.503937, 0.502304, 0, 0, []],
				33,
				649,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[14431, 22, 0, 47.1576, 42.8889, 0, 2.92944, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				650,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[21346, 582, 0, 186, 108, 0, -0.0259036, 1, 0.50641, 0.523364, 0, 0, []],
				15,
				651,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					90,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[18069, 602, 0, 62, 54, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				652,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[19338, 15, 0, 120, 128, 0, 0.427153, 1, 0.5, 0.503597, 0, 0, []],
				29,
				653,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[19399, 12, 0, 120, 128, 0, -1.02826, 1, 0.5, 0.503597, 0, 0, []],
				29,
				654,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[16651, 571, 0, -190, 111, 0, 0.0600649, 1, 0.50641, 0.523364, 0, 0, []],
				15,
				655,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					90,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[12306, 387, 0, 666, 283, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				55,
				656,
				[
				],
				[
				],
				[
					1,
					"Default",
					0,
					1
				]
			]
,			[
				[12527, 486, 0, 139, 48, 0, 0, 1, 0.502075, 0.506173, 0, 0, []],
				56,
				657,
				[
				],
				[
				],
				[
					1,
					"Default",
					0,
					1
				]
			]
,			[
				[12168, 275, 0, 425, 222, 0, 0, 1, 0, 0, 0, 0, []],
				62,
				658,
				[
				],
				[
				],
				[
					"Text",
					1,
					"20pt Book Antiqua",
					"rgb(0,0,0)",
					0,
					0,
					0,
					0,
					0
				]
			]
,			[
				[14499, 616, 0, -132, 72, 0, 0, 1, 0.50641, 0.523364, 0, 0, []],
				15,
				660,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					90,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[18555, 490, 0, 50, 57, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				28,
				662,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[18883, 25, 0, -104, 128, 0, 0, 1, 0.5, 0.503597, 0, 0, []],
				29,
				663,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[16349, 569, 0, 171, 120, 0, 0, 1, 0.50641, 0.523364, 0, 0, []],
				15,
				664,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					90,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[12172, 502, 0, -115, -108, 0, -2.85705, 0.6, 0.512195, 0.5, 0, 0, []],
				57,
				666,
				[
				],
				[
				[
					1,
					1,
					0,
					4,
					0,
					0,
					0,
					50,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[15217, 575, 0, 54, 50, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				667,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[17178, 473, 0, 69, 55, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				668,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[10178, 341, 0, 61, 787, 0, 0.00231402, 1, 0.5, 0.5, 0, 0, []],
				13,
				675,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[14315, 600, 0, 191, 122, 0, 0, 1, 0.50641, 0.523364, 0, 0, []],
				15,
				676,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					90,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[28268, 458, 0, 724.092, 127.241, 0, 0, 1, 0.5, 0.512195, 0, 0, []],
				79,
				682,
				[
				],
				[
				],
				[
					1,
					"Default",
					0,
					1
				]
			]
,			[
				[12042, 473, 0, 250, 250, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				87,
				670,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[12051, 473, 0, 250, 250, 0, 0, 1, 0.524, 0.372, 0, 0, []],
				88,
				444,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[30725, 389, 0, 61, 787, 0, 0.00231402, 1, 0.5, 0.5, 0, 0, []],
				13,
				178,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[42694.2, 519, 0, 607, 143, 0, 0, 1, 0.501188, 0.503497, 0, 0, []],
				91,
				179,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[32356, 604, 0, 421, 143, 0, 0, 1, 0.501188, 0.503497, 0, 0, []],
				91,
				181,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[32839, 482, 0, 421, 143, 0, 0, 1, 0.501188, 0.503497, 0, 0, []],
				91,
				182,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[33292, 391, 0, 421, 143, 0, 0, 1, 0.501188, 0.503497, 0, 0, []],
				91,
				183,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[33876, 407, 0, 421, 143, 0, 0, 1, 0.501188, 0.503497, 0, 0, []],
				91,
				184,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[34319, 315, 0, 421, 143, 0, 0, 1, 0.501188, 0.503497, 0, 0, []],
				91,
				185,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[34827, 398, 0, 421, 143, 0, 0, 1, 0.501188, 0.503497, 0, 0, []],
				91,
				186,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[35380, 400, 0, 421, 143, 0, 0, 1, 0.501188, 0.503497, 0, 0, []],
				91,
				187,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[32441, 437, 0, 133, 221, 0, 0, 1, 0.503937, 0.502304, 0, 0, []],
				33,
				180,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[32094, 316, 0, 666, 283, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				55,
				188,
				[
				],
				[
				],
				[
					1,
					"Default",
					0,
					1
				]
			]
,			[
				[32324, 409, 0, 139, 48, 0, 0, 1, 0.502075, 0.506173, 0, 0, []],
				56,
				189,
				[
				],
				[
				],
				[
					1,
					"Default",
					0,
					1
				]
			]
,			[
				[31961, 206, 0, 425, 222, 0, 0, 1, 0, 0, 0, 0, []],
				62,
				190,
				[
				],
				[
				],
				[
					"Text",
					1,
					"20pt Book Antiqua",
					"rgb(0,0,0)",
					0,
					0,
					0,
					0,
					0
				]
			]
,			[
				[32261, 413, 0, 250, 250, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				92,
				191,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[32760.4, 395.585, 0, 47.1576, 42.8889, 0, 2.92944, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				193,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[33181, 303, 0, 47.1576, 42.8889, 0, 2.92944, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				194,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[33294, 242, 0, 304, 159, 0, 0.00124493, 1, 0.5, 0.504673, 0, 0, []],
				76,
				197,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					50,
					0
				]
				],
				[
					1,
					"Default",
					0,
					0
				]
			]
,			[
				[43337, 581, 0, 479, 174, 0, 0, 1, 0.501188, 0.503497, 0, 0, []],
				91,
				199,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[44014, 511, 0, 686, 194, 0, 0, 1, 0.501188, 0.503497, 0, 0, []],
				91,
				200,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[44788, 460, 0, 421, 143, 0, 0.109115, 1, 0.501188, 0.503497, 0, 0, []],
				91,
				201,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[41940, 545, 0, 421, 143, 0, 0.10072, 1, 0.501188, 0.503497, 0, 0, []],
				91,
				202,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[41387, 553, 0, 421, 143, 0, -0.0397642, 1, 0.501188, 0.503497, 0, 0, []],
				91,
				203,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[40791, 569, 0, 421, 143, 0, -0.0397642, 1, 0.501188, 0.503497, 0, 0, []],
				91,
				204,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[39563, 410, 0, 421, 143, 0, -0.0397642, 1, 0.501188, 0.503497, 0, 0, []],
				91,
				205,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[38199.1, 503.931, 0, 613, 183, 0, -0.0397642, 1, 0.501188, 0.503497, 0, 0, []],
				91,
				206,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[37495, 480, 0, 421, 143, 0, -0.0397642, 1, 0.501188, 0.503497, 0, 0, []],
				91,
				207,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[36828.9, 467.832, 0, 508, 164, 0, -0.0397642, 1, 0.501188, 0.503497, 0, 0, []],
				91,
				208,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[36116.9, 480.118, 0, 571, 180, 0, -0.0397642, 1, 0.501188, 0.503497, 0, 0, []],
				91,
				209,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[40154.7, 560.371, 0, 481, 160, 0, -0.0397642, 1, 0.501188, 0.503497, 0, 0, []],
				91,
				210,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[38917.2, 450.181, 0, 539, 190, 0, -0.0397642, 1, 0.501188, 0.503497, 0, 0, []],
				91,
				211,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[34336, 224, 0, 54, 50, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				212,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[34009, 317, 0, 54, 50, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				198,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[48080, 628, 0, 532, 190, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				94,
				216,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[49757, 655, 0, 532, 190, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				94,
				218,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[50262, 663, 0, 532, 190, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				94,
				219,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[51038, 679, 0, 532, 190, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				94,
				220,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[52904, 680, 0, 532, 190, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				94,
				221,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[53356, 682, 0, 532, 190, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				94,
				222,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[52235, 678, 0, 532, 190, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				94,
				223,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[51552, 681, 0, 582, 190, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				94,
				224,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[53055, 687, 0, 532, 190, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				94,
				225,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[54803, 690, 0, 532, 190, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				94,
				226,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[55255, 692, 0, 532, 190, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				94,
				227,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[54134, 688, 0, 532, 190, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				94,
				228,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[53476, 688.208, 0, 532, 190, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				94,
				229,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[48032, 455, 0, 250, 250, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				96,
				230,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[44855.6, 379.768, 0, 37.1519, 35.452, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				97,
				232,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[44822, 304, 0, 724.092, 127.241, 0, 0, 1, 0.5, 0.512195, 0, 0, []],
				79,
				233,
				[
				],
				[
				],
				[
					1,
					"Default",
					0,
					1
				]
			]
,			[
				[50314.7, 500.91, 0, 125, 187, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				98,
				237,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[48211, 446, 0, 133, 221, 0, 0, 1, 0.503937, 0.502304, 0, 0, []],
				33,
				238,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[48260, 360, 0, 666, 283, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				55,
				239,
				[
				],
				[
				],
				[
					1,
					"Default",
					0,
					1
				]
			]
,			[
				[48122, 248, 0, 425, 222, 0, 0, 1, 0, 0, 0, 0, []],
				62,
				240,
				[
				],
				[
				],
				[
					"Text",
					1,
					"20pt Book Antiqua",
					"rgb(0,0,0)",
					0,
					0,
					0,
					0,
					0
				]
			]
,			[
				[47941, 457, 0, 250, 250, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				92,
				241,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[48486, 449, 0, 139, 48, 0, 0, 1, 0.502075, 0.506173, 0, 0, []],
				56,
				242,
				[
				],
				[
				],
				[
					1,
					"Default",
					0,
					1
				]
			]
,			[
				[48511, 506, 0, 92, 101, 0, 0, 1, 0.5, 0.504951, 0, 0, []],
				100,
				244,
				[
				],
				[
				[
					1,
					0,
					0,
					9,
					0,
					0,
					0,
					50,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[52346.7, 539.41, 0, 111, 162, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				98,
				234,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[54990, 549, 0, -535, 190, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				101,
				217,
				[
				],
				[
				[
					1
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[53206, 550.5, 0, -535, 193, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				101,
				245,
				[
				],
				[
				[
					1
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[53199.5, 445, 0, -400, 167, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				101,
				246,
				[
				],
				[
				[
					1
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[51611, 533, 0, 93, 155, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				98,
				248,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[34899.8, 133, 0, -174, 96, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				102,
				254,
				[
				],
				[
				[
					1,
					0,
					0,
					13,
					0,
					0,
					0,
					2000,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[35933.8, 149.5, 0, 187, 107, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				102,
				252,
				[
				],
				[
				[
					1,
					0,
					0,
					13,
					0,
					0,
					0,
					2000,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[43876.6, 195, 0, -201, 107, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				102,
				255,
				[
				],
				[
				[
					1,
					0,
					0,
					13,
					0,
					0,
					0,
					2000,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[42865, 233, 0, -191, 107, 0, 0.0706281, 1, 0.503704, 0.5, 0, 0, []],
				102,
				256,
				[
				],
				[
				[
					1,
					0,
					0,
					13,
					0,
					0,
					0,
					2000,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[37794, 54, 0, -175, 107, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				102,
				257,
				[
				],
				[
				[
					1,
					0,
					0,
					13,
					0,
					0,
					0,
					2000,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[39792.8, 80, 0, 176, 107, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				102,
				258,
				[
				],
				[
				[
					1,
					0,
					0,
					13,
					0,
					0,
					0,
					2000,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[34265, 224, 0, 47.1576, 42.8889, 0, 2.92944, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				249,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[32725, 392.594, 0, 47.1576, 42.8889, 0, 0.994233, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				259,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[32686.5, 394.059, 0, 47.1576, 42.8889, 0, 2.92944, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				260,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[32793.2, 400.714, 0, 47.1576, 42.8889, 0, 2.92944, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				192,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[42201, 335, 0, -191, 107, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				102,
				261,
				[
				],
				[
				[
					1,
					0,
					0,
					13,
					0,
					0,
					0,
					2000,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[33957, 320, 0, 50, 57, 0, -0.038162, 1, 0.5, 0.5, 0, 0, []],
				28,
				262,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[34429, 232, 0, 50, 57, 0, -0.038162, 1, 0.5, 0.5, 0, 0, []],
				28,
				263,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[34753, 296, 0, 50, 57, 0, -0.038162, 1, 0.5, 0.5, 0, 0, []],
				28,
				264,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[36875, 362, 0, 50, 57, 0, -0.038162, 1, 0.5, 0.5, 0, 0, []],
				28,
				265,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[37527, 386, 0, 50, 57, 0, -0.038162, 1, 0.5, 0.5, 0, 0, []],
				28,
				266,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[67040, 518, 0, 62, 54, 0, 3.03974, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				274,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[62658, 501, 0, 50, 57, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				28,
				286,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[59804, 440, 0, 133, 221, 0, 0, 1, 0.503937, 0.502304, 0, 0, []],
				33,
				336,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[63036, 495, 0, 147, 91, 0, 0, 1, 0.50641, 0.523364, 0, 0, []],
				15,
				338,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					90,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[67318, 501, 0, 186, 108, 0, 0, 1, 0.50641, 0.523364, 0, 0, []],
				15,
				339,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					90,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[65032, 535, 0, 62, 54, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				340,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[59746, 359, 0, 666, 283, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				55,
				346,
				[
				],
				[
				],
				[
					1,
					"Default",
					0,
					1
				]
			]
,			[
				[59967, 458, 0, 139, 48, 0, 0, 1, 0.502075, 0.506173, 0, 0, []],
				56,
				347,
				[
				],
				[
				],
				[
					1,
					"Default",
					0,
					1
				]
			]
,			[
				[59613, 247, 0, 425, 222, 0, 0, 1, 0, 0, 0, 0, []],
				62,
				349,
				[
				],
				[
				],
				[
					"Text",
					1,
					"20pt Book Antiqua",
					"rgb(0,0,0)",
					0,
					0,
					0,
					0,
					0
				]
			]
,			[
				[62837, 496, 0, -132, 72, 0, 0, 1, 0.50641, 0.523364, 0, 0, []],
				15,
				350,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					90,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[62502, 539, 0, 107, 31, 0, 0, 1, 0.5, 0.555556, 0, 0, []],
				17,
				370,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[59688, 517, 0, 51, 47, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				375,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[59950, 513, 0, 52, 40, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				376,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[60586.8, 516.25, 0, 61, 52, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				377,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[60641, 517, 0, 54, 50, 0, 0.919171, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				378,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[61868, 698, 0, 809.041, 326.313, 0, 0, 1, 0.500818, 0.502415, 0, 0, []],
				103,
				278,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[62911, 692, 0, 892.308, 326.313, 0, 0, 1, 0.500818, 0.502415, 0, 0, []],
				103,
				268,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[59653, 418, 0, 250, 250, 0, 0.000519857, 1, 0.5, 0.5, 0, 0, []],
				105,
				271,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[63984.4, 684.585, 0, 882, 314, 0, 0, 1, 0.500818, 0.502415, 0, 0, []],
				103,
				137,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[64999, 690, 0, 787, 269, 0, 0, 1, 0.500818, 0.502415, 0, 0, []],
				103,
				276,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[59713, 701, 0, 809.041, 326.313, 0, 0, 1, 0.500818, 0.502415, 0, 0, []],
				103,
				275,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[60827.1, 708.36, 0, 931, 333, 0, 0, 1, 0.500818, 0.502415, 0, 0, []],
				103,
				277,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[64281, 512, 0, 69, 55, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				379,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[63867, 514, 0, 56, 58, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				289,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[64830, 537, 0, 69, 55, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				270,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[62371, 769, 0, 120, 140, 0, 0, 1, 0.504951, 0.504065, 0, 0, []],
				111,
				284,
				[
				],
				[
				[
					1,
					1,
					0,
					3,
					0,
					0,
					0,
					500,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[61408, 916, 0, 120, 140, 0, 0, 1, 0.504951, 0.504065, 0, 0, []],
				111,
				272,
				[
				],
				[
				[
					1,
					1,
					0,
					3,
					0,
					0,
					0,
					500,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[49326, 538, 0, 116, 139, 0, 0, 1, 0.5, 0.504951, 0, 0, []],
				100,
				251,
				[
				],
				[
				[
					1,
					0,
					0,
					9,
					0,
					0,
					0,
					50,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[55695, 570, 0, 190, 71, 0, 0, 1, 0.5, 0.507042, 0, 0, []],
				112,
				293,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[55964, 481, 0, 190, 71, 0, 0, 1, 0.5, 0.507042, 0, 0, []],
				112,
				294,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[56196, 362, 0, 190, 71, 0, 0, 1, 0.5, 0.507042, 0, 0, []],
				112,
				300,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[56372, 493, 0, 190, 71, 0, 0.000832086, 1, 0.5, 0.507042, 0, 0, []],
				112,
				313,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[56620, 433, 0, 190, 71, 0, 0.000832086, 1, 0.5, 0.507042, 0, 0, []],
				112,
				314,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[57019, 608, 0, 532, 190, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				94,
				319,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[56976.5, 506.04, 0, 37.1878, 34.9105, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				107,
				288,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[57050, 342, 0, 707, 120.984, 0, 0, 1, 0.5, 0.512195, 0, 0, []],
				79,
				290,
				[
				],
				[
				],
				[
					1,
					"Default",
					0,
					1
				]
			]
,			[
				[74915, 158, 0, 48, 46, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				18,
				317,
				[
				],
				[
				[
					1,
					1,
					2,
					4,
					0,
					0,
					0,
					300,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[78668, 198, 0, 48, 46, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				18,
				320,
				[
				],
				[
				[
					1,
					1,
					2,
					6,
					0,
					0,
					0,
					600,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[81278, 85, 0, 62, 54, 0, 3.03974, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				322,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[76533, 79, 0, 178, 259, 0, 0, 1, 0.504065, 0.502463, 0, 0, []],
				16,
				332,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[74934, 81, 0, 178, 259, 0, 0, 1, 0.504065, 0.502463, 0, 0, []],
				16,
				333,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[73934, 452, 0, 67, 69, 0, 0, 1, 0.5, 0.507246, 0, 0, []],
				27,
				334,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[77071, 289, 0, 50, 57, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				28,
				335,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[78677, 51, 0, 178, 259, 0, 0, 1, 0.504065, 0.502463, 0, 0, []],
				16,
				393,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[76990, 79, 0, 178, 259, 0, 0, 1, 0.504065, 0.502463, 0, 0, []],
				16,
				396,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[76479, 52, 0, 120, 128, 0, 0, 1, 0.5, 0.503597, 0, 0, []],
				29,
				398,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[76914, 70, 0, 126, 138, 0, 0, 1, 0.5, 0.503597, 0, 0, []],
				29,
				399,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[76610, 25, 0, 116, 132, 0, 0.846575, 1, 0.5, 0.503597, 0, 0, []],
				29,
				400,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[78124, 55, 0, 120, 128, 0, 0, 1, 0.5, 0.503597, 0, 0, []],
				29,
				401,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[78255, 34, 0, 120, 128, 0, 0.528897, 1, 0.5, 0.503597, 0, 0, []],
				29,
				402,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[78338, 56, 0, 120, 128, 0, 0, 1, 0.5, 0.503597, 0, 0, []],
				29,
				404,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[78431, 56, 0, 120, 128, 0, 0, 1, 0.5, 0.503597, 0, 0, []],
				29,
				405,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[78620, 18, 0, 120, 128, 0, 0, 1, 0.5, 0.503597, 0, 0, []],
				29,
				406,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[78730, 48, 0, -83, 99, 0, 0.792027, 1, 0.5, 0.503597, 0, 0, []],
				29,
				407,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[80734, 42, 0, 120, 128, 0, 0, 1, 0.5, 0.503597, 0, 0, []],
				29,
				408,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[75707, 32, 0, 120, 128, 0, 0, 1, 0.5, 0.503597, 0, 0, []],
				29,
				409,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[75790, 27, 0, 120, 128, 0, -1.43394, 1, 0.5, 0.503597, 0, 0, []],
				29,
				410,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[74859, 16, 0, 120, 128, 0, 0, 1, 0.5, 0.503597, 0, 0, []],
				29,
				411,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[75013, -11, 0, -115, -129, 0, 1.67019, 1, 0.5, 0.503597, 0, 0, []],
				29,
				412,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[74986, 43, 0, 120, 128, 0, 0, 1, 0.5, 0.503597, 0, 0, []],
				29,
				413,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[78517, 59, 0, 120, 128, 0, -0.790467, 1, 0.5, 0.503597, 0, 0, []],
				29,
				414,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[77053, 38, 0, 126, 138, 0, -1.31302, 1, 0.5, 0.503597, 0, 0, []],
				29,
				415,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[75743, 55, 0, 120, 128, 0, 0, 1, 0.5, 0.503597, 0, 0, []],
				29,
				416,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[73826, 388, 0, 133, 221, 0, 0, 1, 0.503937, 0.502304, 0, 0, []],
				33,
				417,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[75796, 50, 0, 47.1576, 42.8889, 0, 2.92944, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				418,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[81246, 45, 0, 120, 128, 0, 0.427153, 1, 0.5, 0.503597, 0, 0, []],
				29,
				424,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[81307, 42, 0, 120, 128, 0, -1.02826, 1, 0.5, 0.503597, 0, 0, []],
				29,
				425,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[73798, 304, 0, 666, 283, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				55,
				452,
				[
				],
				[
				],
				[
					1,
					"Default",
					0,
					1
				]
			]
,			[
				[74019, 403, 0, 139, 48, 0, 0, 1, 0.502075, 0.506173, 0, 0, []],
				56,
				648,
				[
				],
				[
				],
				[
					1,
					"Default",
					0,
					1
				]
			]
,			[
				[73665, 192, 0, 425, 222, 0, 0, 1, 0, 0, 0, 0, []],
				62,
				665,
				[
				],
				[
				],
				[
					"Text",
					1,
					"20pt Book Antiqua",
					"rgb(0,0,0)",
					0,
					0,
					0,
					0,
					0
				]
			]
,			[
				[80823, 55, 0, -104, 128, 0, 0, 1, 0.5, 0.503597, 0, 0, []],
				29,
				674,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[74515, 601.516, 0, 897, 228, 0, 0, 1, 0.5, 0.502262, 0, 0, []],
				4,
				688,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[73661, 597, 0, 838, 221, 0, 0, 1, 0.5, 0.502262, 0, 0, []],
				4,
				689,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[76598.5, 596, 0, 981, 231, 0, 0, 1, 0.5, 0.502262, 0, 0, []],
				4,
				690,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[75487, 626, 0, 838, 221, 0, 0, 1, 0.5, 0.502262, 0, 0, []],
				4,
				691,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[76532, 486, 0, 107, 31, 0, 0, 1, 0.5, 0.555556, 0, 0, []],
				17,
				692,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[76900, 489, 0, 107, 31, 0, 0, 1, 0.5, 0.555556, 0, 0, []],
				17,
				693,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[76992, 490, 0, 107, 31, 0, 0, 1, 0.5, 0.555556, 0, 0, []],
				17,
				694,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[73675, 472, 0, 51, 47, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				697,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[73951, 406, 0, 52, 40, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				698,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[74585, 476, 0, 46, 40, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				699,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[76288, 457, 0, 54, 50, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				700,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[75608, 474, 0, 191, 122, 0, 0, 1, 0.50641, 0.523364, 0, 0, []],
				15,
				710,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					90,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[74907, 485, 0, 107, 31, 0, 0, 1, 0.5, 0.555556, 0, 0, []],
				17,
				711,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[73494, 407, 0, 250, 250, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				113,
				326,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[78391, 202, 0, 48, 46, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				18,
				359,
				[
				],
				[
				[
					1,
					1,
					2,
					4,
					0,
					0,
					0,
					600,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[38294.7, 388.333, 0, 54, 50, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				496,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[38223.7, 388.333, 0, 47.1576, 42.8889, 0, 2.92944, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				539,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[38387.7, 396.333, 0, 50, 57, 0, -0.038162, 1, 0.5, 0.5, 0, 0, []],
				28,
				635,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[40251, 456, 0, 54, 50, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				661,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[40211.5, 464.059, 0, 47.1576, 42.8889, 0, 2.92944, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				708,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[40344, 464, 0, 50, 57, 0, -0.038162, 1, 0.5, 0.5, 0, 0, []],
				28,
				709,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[42667.7, 423.333, 0, 54, 50, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				712,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[42631, 429.928, 0, 47.1576, 42.8889, 0, 2.92944, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				713,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[42760.7, 431.333, 0, 50, 57, 0, -0.038162, 1, 0.5, 0.5, 0, 0, []],
				28,
				714,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[88665, 713, 0, 1077, 144, 0, 0, 1, 0.501027, 0.5, 0, 0, []],
				73,
				720,
				[
				],
				[
				[
					1
				],
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					50,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[104390, 555, 0, 334, 62, 0, -3.1286, 1, 0.501027, 0.5, 0, 0, []],
				75,
				770,
				[
				],
				[
				[
					1
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[88659, 58, 0, -104, 128, 0, 0, 1, 0.5, 0.503597, 0, 0, []],
				29,
				800,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[88637, 49, 0, 120, 128, 0, 0, 1, 0.5, 0.503597, 0, 0, []],
				29,
				801,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[88490, 35, 0, 120, 128, 0, 0, 1, 0.5, 0.503597, 0, 0, []],
				29,
				802,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[88547, 48, 0, -104, 128, 0, 0, 1, 0.5, 0.503597, 0, 0, []],
				29,
				803,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[88788, 39, 0, -104, 128, 0, 0, 1, 0.5, 0.503597, 0, 0, []],
				29,
				804,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[88766, 30, 0, 120, 128, 0, 0, 1, 0.5, 0.503597, 0, 0, []],
				29,
				805,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[88619, 16, 0, 120, 128, 0, 0, 1, 0.5, 0.503597, 0, 0, []],
				29,
				806,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[88676, 29, 0, -104, 128, 0, 0, 1, 0.5, 0.503597, 0, 0, []],
				29,
				807,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[88257, 28, 0, -104, 128, 0, 0, 1, 0.5, 0.503597, 0, 0, []],
				29,
				808,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[88235, 19, 0, 120, 128, 0, 0, 1, 0.5, 0.503597, 0, 0, []],
				29,
				809,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[88145, 18, 0, -104, 128, 0, 0, 1, 0.5, 0.503597, 0, 0, []],
				29,
				810,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[104478, 497.12, 0, 65, 63, 0, 0.00656778, 1, 0.506849, 0.5, 0, 0, []],
				77,
				886,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[104281, 495.319, 0, 65, 63, 0, 0.00656778, 1, 0.506849, 0.5, 0, 0, []],
				77,
				888,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[88455, 543, 0, 133, 221, 0, 0, 1, 0.503937, 0.502304, 0, 0, []],
				33,
				921,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[88822, 471, 0, 666, 283, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				55,
				928,
				[
				],
				[
				],
				[
					1,
					"Default",
					0,
					1
				]
			]
,			[
				[89043, 570, 0, 139, 48, 0, 0, 1, 0.502075, 0.506173, 0, 0, []],
				56,
				929,
				[
				],
				[
				],
				[
					1,
					"Default",
					0,
					1
				]
			]
,			[
				[88684, 359, 0, 425, 222, 0, 0, 1, 0, 0, 0, 0, []],
				62,
				930,
				[
				],
				[
				],
				[
					"Text",
					1,
					"20pt Book Antiqua",
					"rgb(0,0,0)",
					0,
					0,
					0,
					0,
					0
				]
			]
,			[
				[104482, 360, 0, 707, 120.984, 0, 0, 1, 0.5, 0.512195, 0, 0, []],
				79,
				939,
				[
				],
				[
				],
				[
					1,
					"Default",
					0,
					1
				]
			]
,			[
				[88220, 504, 0, 250, 250, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				87,
				940,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[88223, 509, 0, 250, 250, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				115,
				941,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[113925, 319, 0, 92, 101, 0, 0, 1, 0.5, 0.504951, 0, 0, []],
				100,
				944,
				[
				],
				[
				[
					1,
					0,
					0,
					9,
					0,
					0,
					0,
					50,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[114707, 554, 0, 92, 101, 0, 0, 1, 0.5, 0.504951, 0, 0, []],
				100,
				945,
				[
				],
				[
				[
					1,
					0,
					0,
					9,
					0,
					0,
					0,
					50,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[114860, 542, 0, 121, 122, 0, 0, 1, 0.5, 0.504951, 0, 0, []],
				100,
				946,
				[
				],
				[
				[
					1,
					0,
					0,
					9,
					0,
					0,
					0,
					50,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[115658, 412, 0, 92, 101, 0, 0, 1, 0.5, 0.504951, 0, 0, []],
				100,
				948,
				[
				],
				[
				[
					1,
					0,
					0,
					9,
					0,
					0,
					0,
					50,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[114298, 546, 0, 92, 101, 0, 0, 1, 0.5, 0.504951, 0, 0, []],
				100,
				949,
				[
				],
				[
				[
					1,
					0,
					0,
					9,
					0,
					0,
					0,
					50,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[108851, 735, 0, 532, 190, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				94,
				953,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[111702, 722, 0, 532, 190, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				94,
				956,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[113627, 651, 0, 532, 190, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				94,
				957,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[114079, 653, 0, 532, 190, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				94,
				958,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[112958, 649, 0, 532, 190, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				94,
				959,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[112325, 709, 0, 582, 190, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				94,
				960,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[113778, 658, 0, 532, 190, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				94,
				961,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[115526, 661, 0, 532, 190, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				94,
				962,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[115978, 663, 0, 532, 190, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				94,
				963,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[114857, 659, 0, 532, 190, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				94,
				964,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[114199, 659, 0, 532, 190, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				94,
				965,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[108921, 551, 0, 133, 221, 0, 0, 1, 0.503937, 0.502304, 0, 0, []],
				33,
				968,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[108873, 460, 0, 666, 283, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				55,
				969,
				[
				],
				[
				],
				[
					1,
					"Default",
					0,
					1
				]
			]
,			[
				[108735, 348, 0, 425, 222, 0, 0, 1, 0, 0, 0, 0, []],
				62,
				970,
				[
				],
				[
				],
				[
					"Text",
					1,
					"20pt Book Antiqua",
					"rgb(0,0,0)",
					0,
					0,
					0,
					0,
					0
				]
			]
,			[
				[109083, 533, 0, 139, 48, 0, 0, 1, 0.502075, 0.506173, 0, 0, []],
				56,
				972,
				[
				],
				[
				],
				[
					1,
					"Default",
					0,
					1
				]
			]
,			[
				[113023, 517, 0, 91.625, 148.82, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				98,
				974,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[115713, 520, 0, -535, 190, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				101,
				975,
				[
				],
				[
				[
					1
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[113933, 527.466, 0, -564.797, 190.069, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				101,
				976,
				[
				],
				[
				[
					1
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[113923, 416, 0, -400, 167, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				101,
				977,
				[
				],
				[
				[
					1
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[112322, 535.5, 0, 143, 206, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				98,
				978,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[117031, 629, 0, 190, 71, 0, 0, 1, 0.5, 0.507042, 0, 0, []],
				112,
				980,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[117232, 504, 0, 190, 71, 0, 0.000832086, 1, 0.5, 0.507042, 0, 0, []],
				112,
				983,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[117343, 404, 0, 190, 71, 0, 0.000832086, 1, 0.5, 0.507042, 0, 0, []],
				112,
				984,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[119841, 730, 0, 532, 190, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				94,
				985,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[120387, 383, 0, 707, 120.984, 0, 0, 1, 0.5, 0.512195, 0, 0, []],
				79,
				987,
				[
				],
				[
				],
				[
					1,
					"Default",
					0,
					1
				]
			]
,			[
				[108783, 540, 0, 250, 250, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				116,
				971,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[77304, 557, 0, 158, 59, 0, 0, 1, 0.5, 0.508475, 0, 0, []],
				117,
				330,
				[
				],
				[
				[
					1,
					1,
					0,
					4,
					0,
					0,
					0,
					50,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[77534, 495, 0, 158, 59, 0, 0, 1, 0.5, 0.508475, 0, 0, []],
				117,
				337,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					50,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[77806, 547, 0, 158, 59, 0, 0, 1, 0.5, 0.508475, 0, 0, []],
				117,
				343,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					50,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[78131, 548, 0, 158, 59, 0, 0, 1, 0.5, 0.508475, 0, 0, []],
				117,
				345,
				[
				],
				[
				[
					1,
					1,
					0,
					4,
					0,
					0,
					0,
					50,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[78380, 474, 0, 158, 59, 0, 0, 1, 0.5, 0.508475, 0, 0, []],
				117,
				348,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					50,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[78633, 538, 0, 158, 59, 0, 0, 1, 0.5, 0.508475, 0, 0, []],
				117,
				363,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					50,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[78861, 430, 0, 158, 59, 0, 0, 1, 0.5, 0.508475, 0, 0, []],
				117,
				364,
				[
				],
				[
				[
					1,
					1,
					0,
					4,
					0,
					0,
					0,
					50,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[79091, 368, 0, 158, 59, 0, 0, 1, 0.5, 0.508475, 0, 0, []],
				117,
				365,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					50,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[79363, 420, 0, 158, 59, 0, 0, 1, 0.5, 0.508475, 0, 0, []],
				117,
				366,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					50,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[79622, 360, 0, 158, 59, 0, 0, 1, 0.5, 0.508475, 0, 0, []],
				117,
				368,
				[
				],
				[
				[
					1,
					1,
					0,
					4,
					0,
					0,
					0,
					50,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[79852, 298, 0, 158, 59, 0, 0, 1, 0.5, 0.508475, 0, 0, []],
				117,
				369,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					50,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[80124, 350, 0, 158, 59, 0, 0, 1, 0.5, 0.508475, 0, 0, []],
				117,
				371,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					50,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[80348, 425, 0, 158, 59, 0, 0, 1, 0.5, 0.508475, 0, 0, []],
				117,
				382,
				[
				],
				[
				[
					1,
					1,
					0,
					4,
					0,
					0,
					0,
					50,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[80578, 363, 0, 158, 59, 0, 0, 1, 0.5, 0.508475, 0, 0, []],
				117,
				383,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					50,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[80850, 415, 0, 158, 59, 0, 0, 1, 0.5, 0.508475, 0, 0, []],
				117,
				385,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					50,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[81110, 493, 0, 158, 59, 0, 0, 1, 0.5, 0.508475, 0, 0, []],
				117,
				321,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					50,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[81369, 433, 0, 158, 59, 0, 0, 1, 0.5, 0.508475, 0, 0, []],
				117,
				329,
				[
				],
				[
				[
					1,
					1,
					0,
					4,
					0,
					0,
					0,
					50,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[81599, 371, 0, 158, 59, 0, 0, 1, 0.5, 0.508475, 0, 0, []],
				117,
				331,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					50,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[81871, 423, 0, 158, 59, 0, 0, 1, 0.5, 0.508475, 0, 0, []],
				117,
				372,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					50,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[82095, 498, 0, 158, 59, 0, 0, 1, 0.5, 0.508475, 0, 0, []],
				117,
				374,
				[
				],
				[
				[
					1,
					1,
					0,
					4,
					0,
					0,
					0,
					50,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[82325, 436, 0, 158, 59, 0, 0, 1, 0.5, 0.508475, 0, 0, []],
				117,
				380,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					50,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[82597, 488, 0, 158, 59, 0, 0, 1, 0.5, 0.508475, 0, 0, []],
				117,
				381,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					50,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[82860, 502, 0, 158, 59, 0, 0, 1, 0.5, 0.508475, 0, 0, []],
				117,
				386,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					50,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[83119, 442, 0, 158, 59, 0, 0, 1, 0.5, 0.508475, 0, 0, []],
				117,
				387,
				[
				],
				[
				[
					1,
					1,
					0,
					4,
					0,
					0,
					0,
					50,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[83349, 380, 0, 158, 59, 0, 0, 1, 0.5, 0.508475, 0, 0, []],
				117,
				389,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					50,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[83621, 432, 0, 158, 59, 0, 0, 1, 0.5, 0.508475, 0, 0, []],
				117,
				390,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					50,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[83845, 507, 0, 158, 59, 0, 0, 1, 0.5, 0.508475, 0, 0, []],
				117,
				391,
				[
				],
				[
				[
					1,
					1,
					0,
					4,
					0,
					0,
					0,
					50,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[84075, 445, 0, 158, 59, 0, 0, 1, 0.5, 0.508475, 0, 0, []],
				117,
				392,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					50,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[84347, 497, 0, 158, 59, 0, 0, 1, 0.5, 0.508475, 0, 0, []],
				117,
				394,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					50,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[84600, 460, 0, 158, 59, 0, 0, 1, 0.5, 0.508475, 0, 0, []],
				117,
				395,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					50,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[84859, 400, 0, 158, 59, 0, 0, 1, 0.5, 0.508475, 0, 0, []],
				117,
				421,
				[
				],
				[
				[
					1,
					1,
					0,
					4,
					0,
					0,
					0,
					50,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[85089, 338, 0, 158, 59, 0, 0, 1, 0.5, 0.508475, 0, 0, []],
				117,
				422,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					50,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[84437, 86, 0, 178, 259, 0, 0, 1, 0.504065, 0.502463, 0, 0, []],
				16,
				423,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[84219, 47, 0, 120, 128, 0, 0, 1, 0.5, 0.503597, 0, 0, []],
				29,
				427,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[84385, 6, 0, 120, 128, 0, 0, 1, 0.5, 0.503597, 0, 0, []],
				29,
				441,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[84495, 36, 0, -83, 99, 0, 0.792027, 1, 0.5, 0.503597, 0, 0, []],
				29,
				671,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[84282, 47, 0, 120, 128, 0, -0.790467, 1, 0.5, 0.503597, 0, 0, []],
				29,
				672,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[84147, 115, 0, 178, 259, 0, 0, 1, 0.504065, 0.502463, 0, 0, []],
				16,
				673,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[83929, 76, 0, 120, 128, 0, 0, 1, 0.5, 0.503597, 0, 0, []],
				29,
				677,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[84095, 35, 0, 120, 128, 0, 0, 1, 0.5, 0.503597, 0, 0, []],
				29,
				678,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[84205, 65, 0, -83, 99, 0, 0.792027, 1, 0.5, 0.503597, 0, 0, []],
				29,
				679,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[84002, 52, 0, 120, 128, 0, -0.790467, 1, 0.5, 0.503597, 0, 0, []],
				29,
				680,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[83660, 58, 0, 120, 128, 0, 0, 1, 0.5, 0.503597, 0, 0, []],
				29,
				683,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[83820, 45, 0, 120, 128, 0, 0, 1, 0.5, 0.503597, 0, 0, []],
				29,
				684,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[83900, 33, 0, -83, 99, 0, 0.792027, 1, 0.5, 0.503597, 0, 0, []],
				29,
				685,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[83723, 58, 0, 120, 128, 0, -0.790467, 1, 0.5, 0.503597, 0, 0, []],
				29,
				695,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[83579, 41, 0, 120, 128, 0, 0, 1, 0.5, 0.503597, 0, 0, []],
				29,
				701,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[83662, 30, 0, -83, 99, 0, 0.792027, 1, 0.5, 0.503597, 0, 0, []],
				29,
				703,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[83615, 35, 0, 120, 128, 0, -0.790467, 1, 0.5, 0.503597, 0, 0, []],
				29,
				704,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[82494.4, 73.6, 0, 178, 259, 0, 0, 1, 0.504065, 0.502463, 0, 0, []],
				16,
				705,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[82276.4, 34.6, 0, 120, 128, 0, 0, 1, 0.5, 0.503597, 0, 0, []],
				29,
				706,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[82442.4, -6.4, 0, 120, 128, 0, 0, 1, 0.5, 0.503597, 0, 0, []],
				29,
				718,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[82552.4, 23.6, 0, -83, 99, 0, 0.792027, 1, 0.5, 0.503597, 0, 0, []],
				29,
				719,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[82339.4, 34.6, 0, 120, 128, 0, -0.790467, 1, 0.5, 0.503597, 0, 0, []],
				29,
				721,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[82688, 97, 0, 178, 259, 0, 0, 1, 0.504065, 0.502463, 0, 0, []],
				16,
				722,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[82470, 58, 0, 120, 128, 0, 0, 1, 0.5, 0.503597, 0, 0, []],
				29,
				723,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[82636, 17, 0, 120, 128, 0, 0, 1, 0.5, 0.503597, 0, 0, []],
				29,
				724,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[82746, 47, 0, -83, 99, 0, 0.792027, 1, 0.5, 0.503597, 0, 0, []],
				29,
				725,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[82533, 58, 0, 120, 128, 0, -0.790467, 1, 0.5, 0.503597, 0, 0, []],
				29,
				990,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[81423, 68, 0, 178, 259, 0, 0, 1, 0.504065, 0.502463, 0, 0, []],
				16,
				991,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[81205, 29, 0, 120, 128, 0, 0, 1, 0.5, 0.503597, 0, 0, []],
				29,
				992,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[81371, -12, 0, 120, 128, 0, 0, 1, 0.5, 0.503597, 0, 0, []],
				29,
				993,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[81481, 18, 0, -83, 99, 0, 0.792027, 1, 0.5, 0.503597, 0, 0, []],
				29,
				994,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[81268, 29, 0, 120, 128, 0, -0.790467, 1, 0.5, 0.503597, 0, 0, []],
				29,
				995,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[85167, 522, 0, 707, 120.984, 0, 0, 1, 0.5, 0.512195, 0, 0, []],
				79,
				717,
				[
				],
				[
				],
				[
					1,
					"Default",
					0,
					1
				]
			]
,			[
				[89707, 712, 0, 1077, 144, 0, 0, 1, 0.501027, 0.5, 0, 0, []],
				73,
				681,
				[
				],
				[
				[
					1
				],
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					50,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[111156, 739, 0, 532, 190, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				119,
				716,
				[
				],
				[
				[
					1
				],
				[
					1,
					1,
					0,
					2,
					0,
					0,
					0,
					50,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[110621, 725, 0, 532, 190, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				119,
				726,
				[
				],
				[
				[
					1
				],
				[
					1,
					1,
					0,
					2,
					0,
					0,
					0,
					50,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[109543, 730, 0, 532, 190, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				119,
				728,
				[
				],
				[
				[
					1
				],
				[
					1,
					1,
					0,
					2,
					0,
					0,
					0,
					50,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[110006, 743, 0, 567, 232, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				119,
				729,
				[
				],
				[
				[
					1
				],
				[
					1,
					1,
					0,
					2,
					0,
					0,
					0,
					50,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[85089, 293.936, 0, 40.0213, 37.7077, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				120,
				613,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[61202.9, 307, 0, 184, 107, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				102,
				730,
				[
				],
				[
				[
					1,
					0,
					0,
					13,
					0,
					0,
					0,
					2000,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[63283, 212, 0, -175, 107, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				102,
				731,
				[
				],
				[
				[
					1,
					0,
					0,
					13,
					0,
					0,
					0,
					2000,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[78110.6, 219.5, 0, -164, 102, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				102,
				732,
				[
				],
				[
				[
					1,
					0,
					0,
					13,
					0,
					0,
					0,
					2000,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[80842.1, 278.5, 0, 91, 62, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				102,
				733,
				[
				],
				[
				[
					1,
					0,
					0,
					13,
					0,
					0,
					0,
					2000,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[142150, 700, 0, 34244, 12, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				121,
				737,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[90620, 538.5, 0, 436, 331, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				128,
				727,
				[
				],
				[
				[
					1
				],
				[
					300,
					0,
					0,
					0,
					1,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[103954, 472, 0, 250, 250, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				129,
				426,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[91836, 566, 0, 123, 83, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				130,
				740,
				[
				],
				[
				[
					1
				],
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					50,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[92018.7, 171, 0, 140, 83, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				130,
				741,
				[
				],
				[
				[
					1
				],
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					50,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[92759.9, 593, 0, 103, 67, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				130,
				742,
				[
				],
				[
				[
					1
				],
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					50,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[94668, 575, 0, 115, 75, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				130,
				743,
				[
				],
				[
				[
					1
				],
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					500,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[95835.8, 597, 0, -118, 73, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				130,
				744,
				[
				],
				[
				[
					1
				],
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					30,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[98051, 573, 0, -127, 73, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				130,
				746,
				[
				],
				[
				[
					1
				],
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					30,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[96045, 269, 0, -198, 121, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				130,
				747,
				[
				],
				[
				[
					1
				],
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					30,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[94419, 339, 0, 115, 75, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				130,
				745,
				[
				],
				[
				[
					1
				],
				[
					1,
					0,
					0,
					3,
					0,
					0,
					0,
					70,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[97866.9, 259.016, 0, 125, 73, 0, 0.0578489, 1, 0.503704, 0.5, 0, 0, []],
				130,
				748,
				[
				],
				[
				[
					1
				],
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					1000,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[104377, 508, 0, 37.0891, 36.0194, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				131,
				749,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[115665, 50, 0, -535, 190, 0, 3.13071, 1, 0.5, 0.5, 0, 0, []],
				101,
				739,
				[
				],
				[
				[
					1
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[49928.7, 544.667, 0, 54, 50, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				751,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[50010.7, 540.667, 0, 54, 50, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				752,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[50081.7, 516.667, 0, 50, 57, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				28,
				753,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[52114.7, 581.667, 0, 54, 50, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				754,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[52196.7, 577.667, 0, 54, 50, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				755,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[52267.7, 553.667, 0, 50, 57, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				28,
				756,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[56309, 445, 0, 54, 50, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				757,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[56352.2, 451.991, 0, 54, 50, 0, 0.770655, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				758,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[56462, 417, 0, 50, 57, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				28,
				759,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[61768.7, 520.667, 0, 54, 50, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				760,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[61850.7, 516.667, 0, 54, 50, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				761,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[61921.7, 492.667, 0, 50, 57, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				28,
				762,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[80314.6, 380.655, 0, 54, 50, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				763,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[80383.4, 375.922, 0, 54, 50, 0, 1.50656, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				764,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[80461, 338, 0, 50, 57, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				28,
				765,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[81839, 374, 0, 54, 50, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				766,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[81915.8, 378.327, 0, 54, 50, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				767,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[81992, 346, 0, 50, 57, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				28,
				768,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[90531.9, 625.992, 0, 54, 50, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				769,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[90603.5, 629.318, 0, 54, 50, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				771,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[90684, 587, 0, 50, 57, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				28,
				772,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[93662.7, 551.667, 0, 54, 50, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				773,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[93744.7, 547.667, 0, 54, 50, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				774,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[128058, 645, 0, 191, 122, 0, 0, 1, 0.50641, 0.523364, 0, 0, []],
				15,
				776,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					90,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[143385, 584, 0, 173, 107, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				102,
				781,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					500,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[132078, 578, 0, 115, 75, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				130,
				734,
				[
				],
				[
				[
					1
				],
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					200,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[131829, 342, 0, 115, 75, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				130,
				735,
				[
				],
				[
				[
					1
				],
				[
					1,
					0,
					0,
					3,
					0,
					0,
					0,
					70,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[134788, 686, 0, 115, 75, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				130,
				736,
				[
				],
				[
				[
					1
				],
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					500,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[134461, 248.5, 0, 69, 48, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				130,
				777,
				[
				],
				[
				[
					1
				],
				[
					1,
					0,
					0,
					3,
					0,
					0,
					0,
					70,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[136605, 606, 0, -105, 75, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				130,
				778,
				[
				],
				[
				[
					1
				],
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					100,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[136356, 370, 0, -105, 75, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				130,
				779,
				[
				],
				[
				[
					1
				],
				[
					1,
					0,
					0,
					3,
					0,
					0,
					0,
					70,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[137913, 616, 0, -105, 75, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				130,
				780,
				[
				],
				[
				[
					1
				],
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					100,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[137664, 380, 0, -105, 75, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				130,
				782,
				[
				],
				[
				[
					1
				],
				[
					1,
					0,
					0,
					3,
					0,
					0,
					0,
					70,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[128990, 629.611, 0, 101, 70, 0, -0.0758322, 1, 0.503704, 0.5, 0, 0, []],
				130,
				783,
				[
				],
				[
				[
					1
				],
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					80,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[128749, 393, 0, 117, 70, 0, -0.0758317, 1, 0.503704, 0.5, 0, 0, []],
				130,
				784,
				[
				],
				[
				[
					1
				],
				[
					1,
					0,
					0,
					3,
					0,
					0,
					0,
					70,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[129631, 633.294, 0, 99, 70, 0, -0.0758322, 1, 0.503704, 0.5, 0, 0, []],
				130,
				785,
				[
				],
				[
				[
					1
				],
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					100,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[129521, 313, 0, -95, 70, 0, -0.0758317, 1, 0.503704, 0.5, 0, 0, []],
				130,
				786,
				[
				],
				[
				[
					1
				],
				[
					1,
					0,
					0,
					3,
					0,
					0,
					0,
					70,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[130970, 624, 0, -121, 75, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				130,
				787,
				[
				],
				[
				[
					1
				],
				[
					1,
					0,
					0,
					3,
					0,
					0,
					0,
					70,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[130608, 420, 0, -116, 75, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				130,
				788,
				[
				],
				[
				[
					1
				],
				[
					1,
					0,
					0,
					3,
					0,
					0,
					0,
					70,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[142624, 420, 0, -155, 107, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				102,
				789,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					500,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[140304, 446, 0, 173, 107, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				102,
				790,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					100,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[137223, 535.5, 0, 65, 44, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				102,
				791,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					50,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[136033, 607.5, 0, 97, 61, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				102,
				792,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					100,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[136761, 292, 0, -101, 61, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				102,
				793,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					50,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[137273, 639, 0, 65, 44, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				102,
				794,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					20,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[137275, 435, 0, 65, 44, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				102,
				795,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					200,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[137196, 594, 0, 51, 32, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				102,
				796,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					60,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[139334, 620, 0, -117, 68, 0, 0.131855, 1, 0.503704, 0.5, 0, 0, []],
				102,
				797,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					500,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[140752, 614, 0, 121, 85, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				102,
				798,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					100,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[137363, 435, 0, 65, 44, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				102,
				799,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					50,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[137414, 538, 0, 65, 44, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				102,
				811,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					20,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[137416, 334, 0, 65, 44, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				102,
				812,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					200,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[137337, 493, 0, 51, 32, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				102,
				813,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					60,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[134331, 533, 0, 65, 44, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				102,
				814,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					50,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[134229, 628, 0, 65, 44, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				102,
				815,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					20,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[134231, 424, 0, 65, 44, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				102,
				816,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					200,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[134152, 583, 0, 51, 32, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				102,
				817,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					60,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[133823, 375, 0, 65, 44, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				102,
				818,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					50,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[133784, 493, 0, 65, 44, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				102,
				819,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					20,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[134079, 274, 0, 65, 44, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				102,
				820,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					200,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[134000, 433, 0, 51, 32, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				102,
				821,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					60,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[134068, 491, 0, 69, 48, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				130,
				822,
				[
				],
				[
				[
					1
				],
				[
					1,
					0,
					0,
					3,
					0,
					0,
					0,
					70,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[134190, 299, 0, 69, 48, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				130,
				823,
				[
				],
				[
				[
					1
				],
				[
					1,
					0,
					0,
					3,
					0,
					0,
					0,
					70,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[134006, 585, 0, 69, 48, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				130,
				824,
				[
				],
				[
				[
					1
				],
				[
					1,
					0,
					0,
					3,
					0,
					0,
					0,
					70,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[134581, 348, 0, 69, 48, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				130,
				825,
				[
				],
				[
				[
					1
				],
				[
					1,
					0,
					0,
					3,
					0,
					0,
					0,
					70,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[133411, 592, 0, 158, 59, 0, 0, 1, 0.5, 0.508475, 0, 0, []],
				133,
				826,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[133741, 459, 0, 158, 59, 0, 0, 1, 0.5, 0.508475, 0, 0, []],
				133,
				827,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[134567, 514, 0, 65, 44, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				102,
				828,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					100,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[134389, 414, 0, 65, 44, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				102,
				829,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					200,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[134152, 61.5, 0, 69, 48, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				130,
				830,
				[
				],
				[
				[
					1
				],
				[
					1,
					0,
					0,
					3,
					0,
					0,
					0,
					70,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[134529, 276.5, 0, 65, 44, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				102,
				831,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					100,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[133193, 386, 0, 158, 59, 0, 0, 1, 0.5, 0.508475, 0, 0, []],
				133,
				832,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[133519, 286, 0, 158, 59, 0, 0, 1, 0.5, 0.508475, 0, 0, []],
				133,
				833,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[138826, 669, 0, 54, 50, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				834,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[138908, 667, 0, 54, 50, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				835,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[136808, 684, 0, 54, 50, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				836,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[136890, 680, 0, 54, 50, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				837,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[133358, 545.708, 0, 37, 36, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				838,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[133440, 541.708, 0, 37, 36, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				839,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[133393, 551, 0, 56, 43, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				840,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[133475, 547, 0, 56, 43, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				841,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[133394, 528, 0, 37, 36, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				842,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[133726, 425, 0, 32, 25, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				843,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[133247, 337, 0, 37.4967, 36.4832, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				844,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[133538, 246, 0, 37, 36, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				845,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[133533, 206, 0, 37, 36, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				846,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[133700, 411, 0, 61, 43, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				847,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[133746, 412, 0, 61, 43, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				848,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[133249, 360, 0, 56, 43, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				849,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[133226, 310, 0, 56, 43, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				850,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[133261, 363, 0, 36.4967, 36.4832, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				851,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[133211, 357, 0, 55.4967, 43.4832, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				852,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[133173, 346, 0, 55, 43, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				853,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[133409, 531, 0, 37, 36, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				854,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[133429, 549, 0, 37, 36, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				855,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[133439, 519, 0, 37, 36, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				856,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[133921, 261, 0, 158, 59, 0, 0, 1, 0.5, 0.508475, 0, 0, []],
				133,
				857,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[133955, 209, 0, 37, 36, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				858,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[133931, 208, 0, 56, 43, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				859,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[133884, 216, 0, 56, 43, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				860,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[133929, 218, 0, 36, 36, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				861,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[133911, 221, 0, 55, 43, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				862,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[133947, 231, 0, 55, 43, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				863,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[134547, 587, 0, 65, 44, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				102,
				864,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					50,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[134447, 478, 0, 65, 44, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				102,
				865,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					200,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[134797, 402, 0, 69, 48, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				130,
				866,
				[
				],
				[
				[
					1
				],
				[
					1,
					0,
					0,
					3,
					0,
					0,
					0,
					70,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[134605, 468, 0, 65, 44, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				102,
				867,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					200,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[134744, 330, 0, 65, 44, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				102,
				868,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					100,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[133507, 203, 0, 56, 43, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				869,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[133495, 216, 0, 36, 36, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				870,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[133477, 237, 0, 55, 43, 0, 0.0872665, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				871,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[133515, 241, 0, 55, 43, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				872,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[133479, 247, 0, 41, 45, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				873,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[133540, 220, 0, 36, 36, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				874,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[133519, 224, 0, 55, 43, 0, 0.0872665, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				875,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[133540, 247, 0, 55, 43, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				876,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[134626, 320, 0, 101, 72, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				130,
				877,
				[
				],
				[
				[
					1
				],
				[
					1,
					0,
					0,
					3,
					0,
					0,
					0,
					70,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[134747, 420, 0, 101, 72, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				130,
				878,
				[
				],
				[
				[
					1
				],
				[
					1,
					0,
					0,
					3,
					0,
					0,
					0,
					70,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[134733, 586, 0, 97, 68, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				102,
				879,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					100,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[133448, 542, 0, 69, 60, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				880,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[133251, 312, 0, 37.4967, 36.4832, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				881,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[133265, 340, 0, 36.4967, 36.4832, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				882,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[133233, 333, 0, 55.4967, 43.4832, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				883,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[133219, 336, 0, 55, 43, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				884,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[133218, 291, 0, 37.4967, 36.4832, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				885,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[133202, 317, 0, 36.4967, 36.4832, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				887,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[133180, 321, 0, 55.4967, 43.4832, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				889,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[133214, 333, 0, 55, 43, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				890,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[117691, 746, 0, -400, 167, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				101,
				891,
				[
				],
				[
				[
					1
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[113895, 6, 0, -400, -123, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				101,
				892,
				[
				],
				[
				[
					1
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[113477, 14, 0, 532, -193, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				94,
				893,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[112993, 25, 0, 532, -193, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				94,
				894,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[112569, 25, 0, 532, -193, 0, 0.0133033, 1, 0.5, 0.5, 0, 0, []],
				94,
				895,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[112066, 44, 0, 532, -193, 0, 0.0133033, 1, 0.5, 0.5, 0, 0, []],
				94,
				896,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[111503, 40.9358, 0, 692, -193, 0, 0.0133033, 1, 0.5, 0.5, 0, 0, []],
				94,
				897,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[110893, 51, 0, 692, -193, 0, 0.0133033, 1, 0.5, 0.5, 0, 0, []],
				94,
				898,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[110267, 13, 0, 692, -193, 0, 0.0133033, 1, 0.5, 0.5, 0, 0, []],
				94,
				899,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[135141, 550, 0, 91, 57, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				130,
				900,
				[
				],
				[
				[
					1
				],
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					500,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[135151, 266, 0, 45, 30, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				130,
				901,
				[
				],
				[
				[
					1
				],
				[
					1,
					0,
					0,
					3,
					0,
					0,
					0,
					70,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[134959, 332, 0, 41, 26, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				102,
				902,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					200,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[135098, 194, 0, 41, 26, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				102,
				903,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					100,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[134980, 184, 0, 77, 54, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				130,
				904,
				[
				],
				[
				[
					1
				],
				[
					1,
					0,
					0,
					3,
					0,
					0,
					0,
					70,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[135092, 277.5, 0, 59, 41, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				130,
				905,
				[
				],
				[
				[
					1
				],
				[
					1,
					0,
					0,
					3,
					0,
					0,
					0,
					70,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[135078, 443.5, 0, 56, 37, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				102,
				906,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					100,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[117564, 413, 0, 190, 71, 0, 0.000832086, 1, 0.5, 0.507042, 0, 0, []],
				112,
				775,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[117809, 469, 0, 190, 71, 0, 0.000832086, 1, 0.5, 0.507042, 0, 0, []],
				112,
				907,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[114261, -8, 0, 532, -193, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				94,
				908,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[114719, 32, 0, 532, -193, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				94,
				909,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[115201, 48, 0, 532, -193, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				94,
				910,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[116139, 55, 0, 532, -193, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				94,
				911,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[116637, 18, 0, 532, -193, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				94,
				912,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[117132, -39, 0, 532, -193, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				94,
				913,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[109609, 37, 0, 692, -193, 0, 0.0133033, 1, 0.5, 0.5, 0, 0, []],
				94,
				914,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[115128, 163.263, 0, 98, 59, 0, 0, 1, 0.507463, 0.5, 0, 0, []],
				134,
				917,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[115181, 682, 0, 98, 59, 0, 3.12692, 1, 0.507463, 0.5, 0, 0, []],
				134,
				920,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[115226, 162, 0, 98, 59, 0, 0, 1, 0.507463, 0.5, 0, 0, []],
				134,
				922,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[115322, 163, 0, 98, 59, 0, 0, 1, 0.507463, 0.5, 0, 0, []],
				134,
				923,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[115420, 164, 0, 98, 59, 0, 0, 1, 0.507463, 0.5, 0, 0, []],
				134,
				924,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[65996.1, 682.014, 0, 847, 275, 0, 0, 1, 0.500818, 0.502415, 0, 0, []],
				103,
				295,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[67081.6, 683.029, 0, 914, 281, 0, 0, 1, 0.500818, 0.502415, 0, 0, []],
				103,
				296,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[68072, 679, 0, 787, 269, 0, 0, 1, 0.500818, 0.502415, 0, 0, []],
				103,
				297,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[68975, 726, 0, 787, 269, 0, 0, 1, 0.500818, 0.502415, 0, 0, []],
				103,
				298,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[70045, 466, 0, 707, 120.984, 0, 0, 1, 0.5, 0.512195, 0, 0, []],
				79,
				273,
				[
				],
				[
				],
				[
					1,
					"Default",
					0,
					1
				]
			]
,			[
				[61401, 758, 0, 120, 140, 0, 0, 1, 0.504951, 0.504065, 0, 0, []],
				111,
				282,
				[
				],
				[
				[
					1,
					1,
					0,
					3,
					0,
					0,
					0,
					500,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[61332, 696, 0, 120, 140, 0, 0, 1, 0.504951, 0.504065, 0, 0, []],
				111,
				283,
				[
				],
				[
				[
					1,
					1,
					0,
					3,
					0,
					0,
					0,
					500,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[63414, 677, 0, 120, 140, 0, 0, 1, 0.504951, 0.504065, 0, 0, []],
				111,
				287,
				[
				],
				[
				[
					1,
					1,
					0,
					3,
					0,
					0,
					0,
					500,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[63522, 705, 0, 120, 140, 0, 0, 1, 0.504951, 0.504065, 0, 0, []],
				111,
				299,
				[
				],
				[
				[
					1,
					1,
					0,
					3,
					0,
					0,
					0,
					500,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[65488, 696, 0, 120, 140, 0, 0, 1, 0.504951, 0.504065, 0, 0, []],
				111,
				301,
				[
				],
				[
				[
					1,
					1,
					0,
					3,
					0,
					0,
					0,
					500,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[65611, 710, 0, 120, 140, 0, 0, 1, 0.504951, 0.504065, 0, 0, []],
				111,
				303,
				[
				],
				[
				[
					1,
					1,
					0,
					3,
					0,
					0,
					0,
					500,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[66466, 706, 0, 120, 140, 0, 0, 1, 0.504951, 0.504065, 0, 0, []],
				111,
				304,
				[
				],
				[
				[
					1,
					1,
					0,
					3,
					0,
					0,
					0,
					500,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[66593, 754, 0, 120, 140, 0, 0, 1, 0.504951, 0.504065, 0, 0, []],
				111,
				305,
				[
				],
				[
				[
					1,
					1,
					0,
					3,
					0,
					0,
					0,
					500,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[68537, 791, 0, 120, 140, 0, 0, 1, 0.504951, 0.504065, 0, 0, []],
				111,
				306,
				[
				],
				[
				[
					1,
					1,
					0,
					3,
					0,
					0,
					0,
					500,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[69928.6, 718.048, 0, 882, 289, 0, 0, 1, 0.500818, 0.502415, 0, 0, []],
				103,
				307,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[116611, 777, 0, 567, 232, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				119,
				308,
				[
				],
				[
				[
					1
				],
				[
					1,
					1,
					0,
					2,
					0,
					0,
					0,
					50,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[118277, 770, 0, 567, 232, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				119,
				309,
				[
				],
				[
				[
					1
				],
				[
					1,
					1,
					0,
					2,
					0,
					0,
					0,
					50,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[118814, 743, 0, 567, 232, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				119,
				310,
				[
				],
				[
				[
					1
				],
				[
					1,
					1,
					0,
					2,
					0,
					0,
					0,
					50,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[119341, 743, 0, 567, 232, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				119,
				311,
				[
				],
				[
				[
					1
				],
				[
					1,
					1,
					0,
					2,
					0,
					0,
					0,
					50,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[120338, 767, 0, 532, 190, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				94,
				312,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[120825, 753, 0, 532, 190, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				94,
				315,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[142589, 596, 0, -145, 208, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				136,
				341,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[62666.5, 513, 0, 54, 50, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				361,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[62737.5, 489, 0, 50, 57, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				28,
				362,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[60627, 501, 0, 54, 50, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				397,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[60698, 477, 0, 50, 57, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				28,
				954,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[76548, 11, 0, 120, 128, 0, 0, 1, 0.5, 0.503597, 0, 0, []],
				29,
				966,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[111439, 156, 0, 98, 59, 0, 0, 1, 0.507463, 0.5, 0, 0, []],
				134,
				935,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[49102, 541, 0, 50, 57, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				28,
				435,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[81394, 180, 0, 48, 46, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				18,
				955,
				[
				],
				[
				[
					1,
					1,
					2,
					6,
					0,
					0,
					0,
					600,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[82613, 27, 0, 120, 128, 0, -0.790467, 1, 0.5, 0.503597, 0, 0, []],
				29,
				979,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[82694, 50, 0, 120, 128, 0, -0.790467, 1, 0.5, 0.503597, 0, 0, []],
				29,
				981,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[84141, 45, 0, 120, 128, 0, -0.790467, 1, 0.5, 0.503597, 0, 0, []],
				29,
				982,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[84432, 18, 0, 120, 128, 0, -0.790467, 1, 0.5, 0.503597, 0, 0, []],
				29,
				986,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[84379, 95, 0, 120, 128, 0, -0.790467, 1, 0.5, 0.503597, 0, 0, []],
				29,
				988,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[81451, -4, 0, 120, 128, 0, -0.790467, 1, 0.5, 0.503597, 0, 0, []],
				29,
				989,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[78677, 1, 0, 120, 128, 0, -0.790467, 1, 0.5, 0.503597, 0, 0, []],
				29,
				996,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[76997, 32, 0, 120, 128, 0, -0.790467, 1, 0.5, 0.503597, 0, 0, []],
				29,
				997,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[81123, 447, 0, 54, 50, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				1002,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[81399, 6, 0, 120, 128, 0, -0.790467, 1, 0.5, 0.503597, 0, 0, []],
				29,
				1003,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[100611, 606, 0, 145, 73, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				130,
				1004,
				[
				],
				[
				[
					1
				],
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					30,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[102821, 591, 0, 117, 73, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				130,
				1005,
				[
				],
				[
				[
					1
				],
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					30,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[103958, 440, 0, -117, 73, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				130,
				1006,
				[
				],
				[
				[
					1
				],
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					30,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[70115.2, 557.848, 0, 36, 37.5319, 0, 2.39733, 1, 0.5, 0.5, 0, 0, []],
				106,
				280,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[120829, 655.188, 0, 38.3338, 39.1345, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				132,
				750,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[68161, 493, 0, -189, 107, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				102,
				1007,
				[
				],
				[
				[
					1,
					0,
					0,
					13,
					0,
					0,
					0,
					2000,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[143666, 419.5, 0, 109, 1113, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				140,
				1008,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[125371, 469, 0, 109, 1113, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				140,
				1009,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[105750, 446, 0, 109, 1113, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				140,
				1010,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[128362, 594, 0, 133, 221, 0, 0, 1, 0.503937, 0.502304, 0, 0, []],
				33,
				1034,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[128304, 438, 0, 702, 307, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				55,
				1035,
				[
				],
				[
				],
				[
					1,
					"Default",
					0,
					1
				]
			]
,			[
				[128516, 558, 0, 139, 48, 0, 0, 1, 0.502075, 0.506173, 0, 0, []],
				56,
				1036,
				[
				],
				[
				],
				[
					1,
					"Default",
					0,
					1
				]
			]
,			[
				[128166, 325, 0, 425, 222, 0, 0, 1, 0, 0, 0, 0, []],
				62,
				1037,
				[
				],
				[
				],
				[
					"Text",
					1,
					"20pt Book Antiqua",
					"rgb(0,0,0)",
					0,
					0,
					0,
					0,
					0
				]
			]
,			[
				[145923, 569, 0, 250, 250, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				142,
				1038,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[145035, 627, 0, 154, 154, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				143,
				1040,
				[
				],
				[
				[
					1
				],
				[
					200,
					0,
					0,
					0,
					1,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[142111, 667, 0, 707, 120.984, 0, 0, 1, 0.5, 0.512195, 0, 0, []],
				79,
				1045,
				[
				],
				[
				],
				[
					1,
					"Default",
					0,
					1
				]
			]
,			[
				[133357, 543, 0, 50, 57, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				28,
				1021,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[133380, 543, 0, 50, 57, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				28,
				1046,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[133202, 638, 0, 50, 57, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				28,
				1047,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[133188, 670, 0, 50, 57, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				28,
				1048,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[133245, 663, 0, 50, 57, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				28,
				1049,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[133206, 332, 0, 50, 57, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				28,
				1050,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[133276, 660, 0, 50, 57, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				28,
				1051,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[136889, 668.8, 0, 56, 43, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				1052,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[136823, 652.8, 0, 37, 36, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				1053,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[136862, 663.8, 0, 69, 60, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				1054,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[136771, 664.8, 0, 50, 57, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				28,
				1055,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[136794, 664.8, 0, 50, 57, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				28,
				1056,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[136949, 674, 0, 56, 43, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				1057,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[136883, 658, 0, 37, 36, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				1058,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[136922, 669, 0, 69, 60, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				1059,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[136831, 670, 0, 50, 57, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				28,
				1060,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[136854, 670, 0, 50, 57, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				28,
				1061,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[136929, 654.8, 0, 56, 43, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				1062,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[136863, 638.8, 0, 37, 36, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				1063,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[136902, 649.8, 0, 69, 60, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				1064,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[136811, 650.8, 0, 50, 57, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				28,
				1065,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[136834, 650.8, 0, 50, 57, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				28,
				1066,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[133590, 685.8, 0, 56, 43, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				1067,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[133524, 669.8, 0, 37, 36, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				1068,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[133563, 680.8, 0, 69, 60, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				1069,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[133472, 681.8, 0, 50, 57, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				28,
				1070,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[133495, 681.8, 0, 50, 57, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				28,
				1071,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[145286, 275, 0, 66, 848, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				144,
				1041,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[144061, 630, 0, 154, 154, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				143,
				1039,
				[
				],
				[
				[
					1
				],
				[
					250,
					0,
					0,
					0,
					1,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[144389, 633, 0, 154, 154, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				143,
				1072,
				[
				],
				[
				[
					1
				],
				[
					250,
					0,
					0,
					0,
					1,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[144242, 632, 0, 154, 154, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				143,
				1073,
				[
				],
				[
				[
					1
				],
				[
					400,
					0,
					0,
					0,
					1,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[145669, 667.457, 0, 113, 67, 0, 0, 1, 0.5, 0.514286, 0, 0, []],
				145,
				1074,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[145779, 667, 0, 113, 67, 0, 0, 1, 0.5, 0.514286, 0, 0, []],
				145,
				1075,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[146142, 667, 0, 113, 67, 0, 0, 1, 0.5, 0.514286, 0, 0, []],
				145,
				1076,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[146253, 666, 0, 113, 67, 0, 0, 1, 0.5, 0.514286, 0, 0, []],
				145,
				1077,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[146502, 665.229, 0, 113, 67, 0, 0, 1, 0.5, 0.514286, 0, 0, []],
				145,
				1078,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[146612, 664.771, 0, 113, 67, 0, 0, 1, 0.5, 0.514286, 0, 0, []],
				145,
				1079,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[146950, 669, 0, 113, 67, 0, 0, 1, 0.5, 0.514286, 0, 0, []],
				145,
				1080,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[147451, 668, 0, 113, 67, 0, 0, 1, 0.5, 0.514286, 0, 0, []],
				145,
				1081,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[147205, 670, 0, 113, 67, 0, 0, 1, 0.5, 0.514286, 0, 0, []],
				145,
				1082,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[147953, 666, 0, 113, 67, 0, 0, 1, 0.5, 0.514286, 0, 0, []],
				145,
				1083,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[144109, 632, 0, 154, 154, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				143,
				1084,
				[
				],
				[
				[
					1
				],
				[
					100,
					0,
					0,
					0,
					1,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[144701, 624, 0, 154, 154, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				143,
				1085,
				[
				],
				[
				[
					1
				],
				[
					250,
					0,
					0,
					0,
					1,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[147763, 666, 0, 113, 67, 0, 0, 1, 0.5, 0.514286, 0, 0, []],
				145,
				1086,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[120153, 781, 0, 8804, 16, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				7,
				1042,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[153818, 727, 0, 35561, 27, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				7,
				1087,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[148242, 665, 0, 113, 67, 0, 0, 1, 0.5, 0.514286, 0, 0, []],
				145,
				1088,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[148686, 662, 0, 113, 67, 0, 0, 1, 0.5, 0.514286, 0, 0, []],
				145,
				1089,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[148946, 662, 0, 113, 67, 0, 0, 1, 0.5, 0.514286, 0, 0, []],
				145,
				1090,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[149229, 665, 0, 113, 67, 0, 0, 1, 0.5, 0.514286, 0, 0, []],
				145,
				1091,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[149555, 667, 0, 113, 67, 0, 0, 1, 0.5, 0.514286, 0, 0, []],
				145,
				1092,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[149932, 667, 0, 113, 67, 0, 0, 1, 0.5, 0.514286, 0, 0, []],
				145,
				1093,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[150286, 667, 0, 113, 67, 0, 0, 1, 0.5, 0.514286, 0, 0, []],
				145,
				1094,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[150635, 668, 0, 113, 67, 0, 0, 1, 0.5, 0.514286, 0, 0, []],
				145,
				1095,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[150742, 666, 0, 113, 67, 0, 0, 1, 0.5, 0.514286, 0, 0, []],
				145,
				1096,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[151080, 665, 0, 113, 67, 0, 0, 1, 0.5, 0.514286, 0, 0, []],
				145,
				1097,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[151436, 663, 0, 113, 67, 0, 0, 1, 0.5, 0.514286, 0, 0, []],
				145,
				1098,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[151818, 667, 0, 113, 67, 0, 0, 1, 0.5, 0.514286, 0, 0, []],
				145,
				1099,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[152195, 668, 0, 113, 67, 0, 0, 1, 0.5, 0.514286, 0, 0, []],
				145,
				1100,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[152569, 669, 0, 113, 67, 0, 0, 1, 0.5, 0.514286, 0, 0, []],
				145,
				1101,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[152684, 672, 0, 113, 67, 0, 0, 1, 0.5, 0.514286, 0, 0, []],
				145,
				1102,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[148756, 164, 0, 128, 85, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				102,
				1103,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					500,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[150290, 571, 0, 86, 30, 0, 0, 1, 0.509091, 0.5, 0, 0, []],
				147,
				1106,
				[
				],
				[
				],
				[
					1,
					"Default",
					0,
					1
				]
			]
,			[
				[150680, 551, 0, 86, 30, 0, 0, 1, 0.509091, 0.5, 0, 0, []],
				147,
				1104,
				[
				],
				[
				],
				[
					1,
					"Default",
					0,
					1
				]
			]
,			[
				[149932, 587, 0, 86, 30, 0, 0, 1, 0.509091, 0.5, 0, 0, []],
				147,
				1105,
				[
				],
				[
				],
				[
					1,
					"Default",
					0,
					1
				]
			]
,			[
				[149561, 578, 0, 86, 30, 0, 0, 1, 0.509091, 0.5, 0, 0, []],
				147,
				1107,
				[
				],
				[
				],
				[
					1,
					"Default",
					0,
					1
				]
			]
,			[
				[149222, 572, 0, 86, 30, 0, 0, 1, 0.509091, 0.5, 0, 0, []],
				147,
				1108,
				[
				],
				[
				],
				[
					1,
					"Default",
					0,
					1
				]
			]
,			[
				[148950, 530, 0, 86, 30, 0, 0, 1, 0.509091, 0.5, 0, 0, []],
				147,
				1109,
				[
				],
				[
				],
				[
					1,
					"Default",
					0,
					1
				]
			]
,			[
				[148686, 538, 0, 86, 30, 0, 0, 1, 0.509091, 0.5, 0, 0, []],
				147,
				1110,
				[
				],
				[
				],
				[
					1,
					"Default",
					0,
					1
				]
			]
,			[
				[148243, 533, 0, 86, 30, 0, 0, 1, 0.509091, 0.5, 0, 0, []],
				147,
				1111,
				[
				],
				[
				],
				[
					1,
					"Default",
					0,
					1
				]
			]
,			[
				[147986, 508, 0, 86, 30, 0, 0, 1, 0.509091, 0.5, 0, 0, []],
				147,
				1112,
				[
				],
				[
				],
				[
					1,
					"Default",
					0,
					1
				]
			]
,			[
				[147763, 522, 0, 86, 30, 0, 0, 1, 0.509091, 0.5, 0, 0, []],
				147,
				1113,
				[
				],
				[
				],
				[
					1,
					"Default",
					0,
					1
				]
			]
,			[
				[147464, 506, 0, 86, 30, 0, 0, 1, 0.509091, 0.5, 0, 0, []],
				147,
				1114,
				[
				],
				[
				],
				[
					1,
					"Default",
					0,
					1
				]
			]
,			[
				[147212, 514, 0, 86, 30, 0, 0, 1, 0.509091, 0.5, 0, 0, []],
				147,
				1115,
				[
				],
				[
				],
				[
					1,
					"Default",
					0,
					1
				]
			]
,			[
				[146954, 504, 0, 86, 30, 0, 0, 1, 0.509091, 0.5, 0, 0, []],
				147,
				1116,
				[
				],
				[
				],
				[
					1,
					"Default",
					0,
					1
				]
			]
,			[
				[146555, 503, 0, 86, 30, 0, 0, 1, 0.509091, 0.5, 0, 0, []],
				147,
				1117,
				[
				],
				[
				],
				[
					1,
					"Default",
					0,
					1
				]
			]
,			[
				[146196, 497, 0, 86, 30, 0, 0, 1, 0.509091, 0.5, 0, 0, []],
				147,
				1118,
				[
				],
				[
				],
				[
					1,
					"Default",
					0,
					1
				]
			]
,			[
				[145720, 526, 0, 86, 30, 0, 0, 1, 0.509091, 0.5, 0, 0, []],
				147,
				1119,
				[
				],
				[
				],
				[
					1,
					"Default",
					0,
					1
				]
			]
,			[
				[151090, 562, 0, 86, 30, 0, 0, 1, 0.509091, 0.5, 0, 0, []],
				147,
				1120,
				[
				],
				[
				],
				[
					1,
					"Default",
					0,
					1
				]
			]
,			[
				[151430, 573, 0, 86, 30, 0, 0, 1, 0.509091, 0.5, 0, 0, []],
				147,
				1121,
				[
				],
				[
				],
				[
					1,
					"Default",
					0,
					1
				]
			]
,			[
				[151831, 585, 0, 86, 30, 0, 0, 1, 0.509091, 0.5, 0, 0, []],
				147,
				1122,
				[
				],
				[
				],
				[
					1,
					"Default",
					0,
					1
				]
			]
,			[
				[152222, 571, 0, 86, 30, 0, 0, 1, 0.509091, 0.5, 0, 0, []],
				147,
				1123,
				[
				],
				[
				],
				[
					1,
					"Default",
					0,
					1
				]
			]
,			[
				[152625, 569, 0, 86, 30, 0, 0, 1, 0.509091, 0.5, 0, 0, []],
				147,
				1124,
				[
				],
				[
				],
				[
					1,
					"Default",
					0,
					1
				]
			]
,			[
				[153183, 666, 0, 113, 67, 0, 0, 1, 0.5, 0.514286, 0, 0, []],
				145,
				1125,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[153175, 563, 0, 86, 30, 0, 0, 1, 0.509091, 0.5, 0, 0, []],
				147,
				1126,
				[
				],
				[
				],
				[
					1,
					"Default",
					0,
					1
				]
			]
,			[
				[143785, 630, 0, 154, 154, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				143,
				1127,
				[
				],
				[
				[
					1
				],
				[
					400,
					0,
					0,
					0,
					1,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[143526, 628, 0, 154, 154, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				143,
				1128,
				[
				],
				[
				[
					1
				],
				[
					300,
					0,
					0,
					0,
					1,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[143936, 628, 0, 154, 154, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				143,
				1129,
				[
				],
				[
				[
					1
				],
				[
					250,
					0,
					0,
					0,
					1,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[153666, 670, 0, 113, 67, 0, 0, 1, 0.5, 0.514286, 0, 0, []],
				145,
				1130,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[153658, 567, 0, 86, 30, 0, 0, 1, 0.509091, 0.5, 0, 0, []],
				147,
				1131,
				[
				],
				[
				],
				[
					1,
					"Default",
					0,
					1
				]
			]
,			[
				[154179, 667, 0, 113, 67, 0, 0, 1, 0.5, 0.514286, 0, 0, []],
				145,
				1132,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[154171, 564, 0, 86, 30, 0, 0, 1, 0.509091, 0.5, 0, 0, []],
				147,
				1133,
				[
				],
				[
				],
				[
					1,
					"Default",
					0,
					1
				]
			]
,			[
				[154719, 666, 0, 113, 67, 0, 0, 1, 0.5, 0.514286, 0, 0, []],
				145,
				1134,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[154711, 563, 0, 86, 30, 0, 0, 1, 0.509091, 0.5, 0, 0, []],
				147,
				1135,
				[
				],
				[
				],
				[
					1,
					"Default",
					0,
					1
				]
			]
,			[
				[155234, 663, 0, 113, 67, 0, 0, 1, 0.5, 0.514286, 0, 0, []],
				145,
				1136,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[155226, 560, 0, 86, 30, 0, 0, 1, 0.509091, 0.5, 0, 0, []],
				147,
				1137,
				[
				],
				[
				],
				[
					1,
					"Default",
					0,
					1
				]
			]
,			[
				[155729, 667, 0, 113, 67, 0, 0, 1, 0.5, 0.514286, 0, 0, []],
				145,
				1138,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[155721, 564, 0, 86, 30, 0, 0, 1, 0.509091, 0.5, 0, 0, []],
				147,
				1139,
				[
				],
				[
				],
				[
					1,
					"Default",
					0,
					1
				]
			]
,			[
				[155973, 582, 0, 158, 59, 0, 0, 1, 0.5, 0.508475, 0, 0, []],
				133,
				1140,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[155919, 533, 0, 50, 57, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				28,
				1141,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[156150, 516, 0, 158, 59, 0, 0, 1, 0.5, 0.508475, 0, 0, []],
				133,
				1142,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[155933, 528, 0, 50, 57, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				28,
				1143,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[155983, 459, 0, 133, 221, 0, 0, 1, 0.503937, 0.502304, 0, 0, []],
				33,
				1144,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[155581, 382, 0, 666, 283, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				55,
				1145,
				[
				],
				[
				],
				[
					1,
					"Default",
					0,
					1
				]
			]
,			[
				[155802, 481, 0, 139, 48, 0, 0, 1, 0.502075, 0.506173, 0, 0, []],
				56,
				1146,
				[
				],
				[
				],
				[
					1,
					"Default",
					0,
					1
				]
			]
,			[
				[155443, 270, 0, 425, 222, 0, 0, 1, 0, 0, 0, 0, []],
				62,
				1147,
				[
				],
				[
				],
				[
					"Text",
					1,
					"20pt Book Antiqua",
					"rgb(0,0,0)",
					0,
					0,
					0,
					0,
					0
				]
			]
,			[
				[156130, 472, 0, 36, 36, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				148,
				1148,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[142495, 678.984, 0, 36, 36, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				149,
				1044,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[103337, 77, 0, 150, 142, 0, 0, 1, 0.502591, 0.502618, 0, 0, []],
				152,
				126,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[43152, 15, 0, 113, 106, 0, 0, 1, 0.502591, 0.502618, 0, 0, []],
				152,
				127,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[141450, -10, 0, 244, 239, 0, 0, 1, 0.5, 0.502392, 0, 0, []],
				153,
				128,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[160492, 560, 0, 415, 354, 0, 0, 1, 0.501205, 0.5, 0, 0, []],
				154,
				129,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[160956, 632, 0, 415, 354, 0, 0, 1, 0.501205, 0.5, 0, 0, []],
				154,
				131,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[161362, 744, 0, 100, 216, 0, 0, 1, 0.5, 0.502793, 0, 0, []],
				155,
				169,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[161369, 526, 0, 415, 354, 0, 0, 1, 0.501205, 0.5, 0, 0, []],
				154,
				170,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[161950, 570, 0, 415, 354, 0, 0, 1, 0.501205, 0.5, 0, 0, []],
				154,
				172,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[162374, 588, 0, 415, 354, 0, 0, 1, 0.501205, 0.5, 0, 0, []],
				154,
				173,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[162835, 675, 0, 100, 216, 0, 0, 1, 0.5, 0.502793, 0, 0, []],
				155,
				1011,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[162842, 498, 0, 415, 354, 0, 0, 1, 0.501205, 0.5, 0, 0, []],
				154,
				1012,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[163251, 674, 0, 100, 216, 0, 0, 1, 0.5, 0.502793, 0, 0, []],
				155,
				1013,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[163258, 487, 0, 415, 354, 0, 0, 1, 0.501205, 0.5, 0, 0, []],
				154,
				1014,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[160550, 285, 0, 133, 221, 0, 0, 1, 0.503937, 0.502304, 0, 0, []],
				33,
				1015,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[160540, 533, 0, 666, 283, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				55,
				1016,
				[
				],
				[
				],
				[
					1,
					"Default",
					0,
					1
				]
			]
,			[
				[160761, 632, 0, 139, 48, 0, 0, 1, 0.502075, 0.506173, 0, 0, []],
				56,
				1017,
				[
				],
				[
				],
				[
					1,
					"Default",
					0,
					1
				]
			]
,			[
				[160402, 421, 0, 425, 222, 0, 0, 1, 0, 0, 0, 0, []],
				62,
				1018,
				[
				],
				[
				],
				[
					"Text",
					1,
					"20pt Book Antiqua",
					"rgb(0,0,0)",
					0,
					0,
					0,
					0,
					0
				]
			]
,			[
				[160399, 276, 0, 250, 250, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				156,
				1019,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[163777, 755, 0, 100, 216, 0, 0, 1, 0.5, 0.502793, 0, 0, []],
				155,
				1020,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[163783, 562, 0, 415, 354, 0, 0, 1, 0.501205, 0.5, 0, 0, []],
				154,
				1022,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[164319, 784, 0, 100, 216, 0, 0, 1, 0.5, 0.502793, 0, 0, []],
				155,
				1023,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[164325, 525, 0, 415, 354, 0, 0, 1, 0.501205, 0.5, 0, 0, []],
				154,
				1024,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[164823, 559, 0, 415, 354, 0, 0, 1, 0.501205, 0.5, 0, 0, []],
				154,
				1026,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[165267, 638, 0, 415, 354, 0, 0, 1, 0.501205, 0.5, 0, 0, []],
				154,
				1028,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[110.857, 45, 0, 217, 53, 0, 0, 0.3, 0.502463, 0.5, 0, 0, []],
				71,
				176,
				[
				],
				[
				[
					0,
					0,
					0,
					0,
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[173, 32, 0, 46, 37, 0, 0, 1, 0, 0, 0, 0, []],
				159,
				1025,
				[
				],
				[
				[
					0,
					0,
					0,
					0,
					1
				]
				],
				[
					"0",
					0,
					"20pt Arial Rounded MT Bold",
					"rgb(255,255,255)",
					0,
					0,
					0,
					0,
					0
				]
			]
,			[
				[165818, 752, 0, 100, 216, 0, 0, 1, 0.5, 0.502793, 0, 0, []],
				155,
				1027,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[165825, 567, 0, 415, 354, 0, 0, 1, 0.501205, 0.5, 0, 0, []],
				154,
				1030,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[166265, 658.5, 0, 100, 216, 0, 0, 1, 0.5, 0.502793, 0, 0, []],
				155,
				1031,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[166271, 399.5, 0, 415, 354, 0, 0, 1, 0.501205, 0.5, 0, 0, []],
				154,
				1032,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[166783, 762, 0, 100, 216, 0, 0, 1, 0.5, 0.502793, 0, 0, []],
				155,
				1033,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[166789, 503, 0, 415, 354, 0, 0, 1, 0.501205, 0.5, 0, 0, []],
				154,
				1150,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[167328, 663, 0, 100, 216, 0, 0, 1, 0.5, 0.502793, 0, 0, []],
				155,
				1151,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[167334, 404, 0, 415, 354, 0, 0, 1, 0.501205, 0.5, 0, 0, []],
				154,
				1152,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[167818, 634, 0, 100, 216, 0, 0, 1, 0.5, 0.502793, 0, 0, []],
				155,
				1153,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[167824, 375, 0, 415, 354, 0, 0, 1, 0.501205, 0.5, 0, 0, []],
				154,
				1154,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[168346, 567, 0, 415, 354, 0, 0, 1, 0.501205, 0.5, 0, 0, []],
				154,
				1155,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[162549, 150, 0, 115, 75, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				130,
				1156,
				[
				],
				[
				[
					1
				],
				[
					1,
					0,
					0,
					3,
					0,
					0,
					0,
					70,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[161599, 236, 0, -113, 75, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				130,
				1157,
				[
				],
				[
				[
					1
				],
				[
					1,
					0,
					0,
					3,
					0,
					0,
					0,
					70,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[162299, 363, 0, -195, 120, 0, -0.0129369, 1, 0.50641, 0.523364, 0, 0, []],
				15,
				1158,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					90,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[162810, 273, 0, 177, 118, 0, -0.0129369, 1, 0.50641, 0.523364, 0, 0, []],
				15,
				1160,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					90,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[163138, 279, 0, 100, 66, 0, 0, 1, 0.5, 0.504673, 0, 0, []],
				76,
				1161,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					50,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[163340, 273.533, 0, 116, 73, 0, 0, 1, 0.5, 0.504673, 0, 0, []],
				76,
				1162,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					50,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[163827, 350, 0, 117, 74, 0, 0, 1, 0.5, 0.504673, 0, 0, []],
				76,
				1163,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					50,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[164933, 352, 0, 100, 66, 0, 0, 1, 0.5, 0.504673, 0, 0, []],
				76,
				1164,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					50,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[165183, 430, 0, -109, 66, 0, -0.023449, 1, 0.5, 0.504673, 0, 0, []],
				76,
				1165,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					50,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[166322, 190, 0, 100, 66, 0, 0, 1, 0.5, 0.504673, 0, 0, []],
				76,
				1166,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					50,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[164336, 90, 0, 123, 75, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				130,
				1159,
				[
				],
				[
				[
					1
				],
				[
					1,
					0,
					0,
					3,
					0,
					0,
					0,
					70,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[165872, 357, 0, -109, 66, 0, -0.023449, 1, 0.5, 0.504673, 0, 0, []],
				76,
				1167,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					50,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[166256, 185, 0, 175, 103, 0, -0.0129369, 1, 0.50641, 0.523364, 0, 0, []],
				15,
				1168,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					90,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[166716, 291, 0, -139, 87, 0, -0.0129369, 1, 0.50641, 0.523364, 0, 0, []],
				15,
				1169,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					90,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[167312, 189.542, 0, 112, 75, 0, 0, 1, 0.5, 0.504673, 0, 0, []],
				76,
				1170,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					50,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[168444, 358, 0, 100, 66, 0, 0, 1, 0.5, 0.504673, 0, 0, []],
				76,
				1171,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					50,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[168807, 663, 0, 415, 354, 0, 0, 1, 0.501205, 0.5, 0, 0, []],
				154,
				1172,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[168752, 451.533, 0, -122, 73, 0, 0, 1, 0.5, 0.504673, 0, 0, []],
				76,
				1173,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					50,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[168225, 360, 0, -112, 66, 0, 0, 1, 0.5, 0.504673, 0, 0, []],
				76,
				1174,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					50,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[169457, 426, 0, 46, 43, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				162,
				1175,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[169355, 312, 0, 541, 87.3771, 0, 0, 1, 0.5, 0.512195, 0, 0, []],
				79,
				1176,
				[
				],
				[
				],
				[
					1,
					"Default",
					0,
					1
				]
			]
,			[
				[156208, 317, 0, 541, 87.3771, 0, 0, 1, 0.5, 0.512195, 0, 0, []],
				79,
				1177,
				[
				],
				[
				],
				[
					1,
					"Default",
					0,
					1
				]
			]
,			[
				[165788, 369, 0, 50, 57, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				28,
				130,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[165388, 403, 0, 50, 57, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				28,
				171,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[165388, 346, 0, 50, 57, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				28,
				1182,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[862, 434, 0, 43, 41, 0, 0, 0.4, 0.5, 0.5, 0, 0, []],
				164,
				1183,
				[
				],
				[
				[
					0,
					0,
					0,
					0,
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[66978, 528, 0, 62, 54, 0, 3.03974, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				388,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[169379, 623, 0, 415, 354, 0, 0, 1, 0.501205, 0.5, 0, 0, []],
				154,
				285,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[172425, 612, 0, 415, 354, 0, 0, 1, 0.501205, 0.5, 0, 0, []],
				165,
				1185,
				[
				],
				[
				[
					1
				],
				[
					1,
					1,
					0,
					6,
					0,
					0,
					0,
					50,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[172964, 544.5, 0, 452, 429, 0, 0, 1, 0.501205, 0.5, 0, 0, []],
				165,
				1186,
				[
				],
				[
				[
					1
				],
				[
					1,
					1,
					0,
					7,
					0,
					0,
					0,
					100,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[172461, -75, 0, 415, 354, 0, 3.13823, 1, 0.501205, 0.5, 0, 0, []],
				165,
				1187,
				[
				],
				[
				[
					1
				],
				[
					1,
					1,
					0,
					6,
					0,
					0,
					0,
					50,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[185953, 402, 0, 666, 283, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				55,
				1188,
				[
				],
				[
				],
				[
					1,
					"Default",
					0,
					1
				]
			]
,			[
				[186174, 501, 0, 139, 48, 0, 0, 1, 0.502075, 0.506173, 0, 0, []],
				56,
				1189,
				[
				],
				[
				],
				[
					1,
					"Default",
					0,
					1
				]
			]
,			[
				[185815, 290, 0, 425, 222, 0, 0, 1, 0, 0, 0, 0, []],
				62,
				1190,
				[
				],
				[
				],
				[
					"Text",
					1,
					"20pt Book Antiqua",
					"rgb(0,0,0)",
					0,
					0,
					0,
					0,
					0
				]
			]
,			[
				[172409, 315, 0, 250, 250, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				166,
				1191,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[173353, 668, 0, 452, 429, 0, 0, 1, 0.501205, 0.5, 0, 0, []],
				165,
				1180,
				[
				],
				[
				[
					1
				],
				[
					1,
					1,
					0,
					7,
					0,
					0,
					0,
					70,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[174060, 826, 0, 452, 429, 0, 0, 1, 0.501205, 0.5, 0, 0, []],
				165,
				1181,
				[
				],
				[
				[
					1
				],
				[
					1,
					1,
					0,
					7,
					0,
					0,
					0,
					50,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[174714, 711, 0, 452, 429, 0, 0, 1, 0.501205, 0.5, 0, 0, []],
				165,
				1184,
				[
				],
				[
				[
					1
				],
				[
					1,
					1,
					0,
					7,
					0,
					0,
					0,
					50,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[179796, 718, 0, 16255, 16, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				7,
				1193,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[175383, 841, 0, 452, 429, 0, 0, 1, 0.501205, 0.5, 0, 0, []],
				165,
				1179,
				[
				],
				[
				[
					1
				],
				[
					1,
					1,
					0,
					7,
					0,
					0,
					0,
					50,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[176002, 733, 0, 452, 429, 0, 0, 1, 0.501205, 0.5, 0, 0, []],
				165,
				1194,
				[
				],
				[
				[
					1
				],
				[
					1,
					1,
					0,
					7,
					0,
					0,
					0,
					50,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[176686, 783, 0, 452, 429, 0, 0, 1, 0.501205, 0.5, 0, 0, []],
				165,
				1195,
				[
				],
				[
				[
					1
				],
				[
					1,
					1,
					0,
					7,
					0,
					0,
					0,
					50,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[176264, -134, 0, 452, 429, 0, -3.14101, 1, 0.501205, 0.5, 0, 0, []],
				165,
				1196,
				[
				],
				[
				[
					1
				],
				[
					1,
					1,
					0,
					7,
					0,
					0,
					0,
					50,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[177825, -50, 0, 452, 429, 0, -3.14101, 1, 0.501205, 0.5, 0, 0, []],
				165,
				1197,
				[
				],
				[
				[
					1
				],
				[
					1,
					1,
					0,
					7,
					0,
					0,
					0,
					50,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[177325, 780, 0, 452, 429, 0, 0, 1, 0.501205, 0.5, 0, 0, []],
				165,
				1198,
				[
				],
				[
				[
					1
				],
				[
					1,
					1,
					0,
					7,
					0,
					0,
					0,
					50,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[173601, 18, 0, 415, 354, 0, 3.13823, 1, 0.501205, 0.5, 0, 0, []],
				165,
				1199,
				[
				],
				[
				[
					1
				],
				[
					1,
					1,
					0,
					6,
					0,
					0,
					0,
					50,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[174173, -67, 0, 415, 354, 0, 3.13823, 1, 0.501205, 0.5, 0, 0, []],
				165,
				1200,
				[
				],
				[
				[
					1
				],
				[
					1,
					1,
					0,
					6,
					0,
					0,
					0,
					50,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[174670, 106, 0, 415, 354, 0, 3.13823, 1, 0.501205, 0.5, 0, 0, []],
				165,
				1201,
				[
				],
				[
				[
					1
				],
				[
					1,
					1,
					0,
					6,
					0,
					0,
					0,
					50,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[177210, 30, 0, 452, 429, 0, -3.14101, 1, 0.501205, 0.5, 0, 0, []],
				165,
				1202,
				[
				],
				[
				[
					1
				],
				[
					1,
					1,
					0,
					7,
					0,
					0,
					0,
					50,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[177975, 734, 0, 452, 429, 0, 0, 1, 0.501205, 0.5, 0, 0, []],
				165,
				1203,
				[
				],
				[
				[
					1
				],
				[
					1,
					1,
					0,
					7,
					0,
					0,
					0,
					50,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[178542, 662, 0, 452, 429, 0, 0, 1, 0.501205, 0.5, 0, 0, []],
				165,
				1204,
				[
				],
				[
				[
					1
				],
				[
					1,
					1,
					0,
					7,
					0,
					0,
					0,
					50,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[178839, -252, 0, 452, 429, 0, -3.13087, 1, 0.501205, 0.5, 0, 0, []],
				165,
				1205,
				[
				],
				[
				[
					1
				],
				[
					1,
					1,
					0,
					7,
					0,
					0,
					0,
					50,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[179105, 687, 0, 452, 429, 0, 0, 1, 0.501205, 0.5, 0, 0, []],
				165,
				1206,
				[
				],
				[
				[
					1
				],
				[
					1,
					1,
					0,
					7,
					0,
					0,
					0,
					50,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[180306, 573, 0, 452, 429, 0, 0, 1, 0.501205, 0.5, 0, 0, []],
				165,
				1207,
				[
				],
				[
				[
					1
				],
				[
					1,
					1,
					0,
					7,
					0,
					0,
					0,
					50,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[179760, 716, 0, 452, 429, 0, 0, 1, 0.501205, 0.5, 0, 0, []],
				165,
				1208,
				[
				],
				[
				[
					1
				],
				[
					1,
					1,
					0,
					7,
					0,
					0,
					0,
					50,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[181083, 773, 0, 615, 614, 0, 0, 1, 0.501205, 0.5, 0, 0, []],
				165,
				1209,
				[
				],
				[
				[
					1
				],
				[
					1,
					1,
					0,
					7,
					0,
					0,
					0,
					50,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[181740, 735, 0, 426, 349, 0, 0, 1, 0.501205, 0.5, 0, 0, []],
				165,
				1210,
				[
				],
				[
				[
					1
				],
				[
					1,
					1,
					0,
					7,
					0,
					0,
					0,
					50,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[181214, -168, 0, 426, 349, 0, 3.12685, 1, 0.501205, 0.5, 0, 0, []],
				165,
				1211,
				[
				],
				[
				[
					1
				],
				[
					1,
					1,
					0,
					7,
					0,
					0,
					0,
					50,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[182302, 701, 0, 426, 349, 0, 0, 1, 0.501205, 0.5, 0, 0, []],
				165,
				1212,
				[
				],
				[
				[
					1
				],
				[
					1,
					1,
					0,
					7,
					0,
					0,
					0,
					50,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[182836, 721, 0, 426, 349, 0, 0, 1, 0.501205, 0.5, 0, 0, []],
				165,
				1213,
				[
				],
				[
				[
					1
				],
				[
					1,
					1,
					0,
					7,
					0,
					0,
					0,
					50,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[183442, 674, 0, 452, 429, 0, 0, 1, 0.501205, 0.5, 0, 0, []],
				165,
				1214,
				[
				],
				[
				[
					1
				],
				[
					1,
					1,
					0,
					7,
					0,
					0,
					0,
					50,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[182948, -75, 0, 452, 429, 0, -3.1392, 1, 0.501205, 0.5, 0, 0, []],
				165,
				1215,
				[
				],
				[
				[
					1
				],
				[
					1,
					1,
					0,
					7,
					0,
					0,
					0,
					50,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[184074, 813, 0, 452, 429, 0, 0, 1, 0.501205, 0.5, 0, 0, []],
				165,
				1216,
				[
				],
				[
				[
					1
				],
				[
					1,
					1,
					0,
					7,
					0,
					0,
					0,
					50,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[184094, 17, 0, 452, 429, 0, -3.1392, 1, 0.501205, 0.5, 0, 0, []],
				165,
				1217,
				[
				],
				[
				[
					1
				],
				[
					1,
					1,
					0,
					7,
					0,
					0,
					0,
					50,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[184848, 822, 0, 452, 429, 0, 0, 1, 0.501205, 0.5, 0, 0, []],
				165,
				1218,
				[
				],
				[
				[
					1
				],
				[
					1,
					1,
					0,
					7,
					0,
					0,
					0,
					50,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[185378, 757, 0, 241, 231, 0, 0, 1, 0.501205, 0.5, 0, 0, []],
				165,
				1219,
				[
				],
				[
				[
					1
				],
				[
					1,
					1,
					0,
					7,
					0,
					0,
					0,
					50,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[185874, 737, 0, 241, 231, 0, 0, 1, 0.501205, 0.5, 0, 0, []],
				165,
				1220,
				[
				],
				[
				[
					1
				],
				[
					1,
					1,
					0,
					7,
					0,
					0,
					0,
					50,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[186262, 695, 0, 241, 231, 0, 0, 1, 0.501205, 0.5, 0, 0, []],
				165,
				1221,
				[
				],
				[
				[
					1
				],
				[
					1,
					1,
					0,
					0,
					0,
					0,
					0,
					0,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[185725, 30, 0, 452, 429, 0, -3.1392, 1, 0.501205, 0.5, 0, 0, []],
				165,
				1222,
				[
				],
				[
				[
					1
				],
				[
					1,
					1,
					0,
					7,
					0,
					0,
					0,
					50,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[186669, 789, 0, 452, 429, 0, -0.0080524, 1, 0.501205, 0.5, 0, 0, []],
				165,
				1224,
				[
				],
				[
				[
					1
				],
				[
					1,
					1,
					0,
					0,
					0,
					0,
					0,
					0,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[186524, 206, 0, 174, 107, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				102,
				1225,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					500,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[186656, 177.5, 0, 429, 356, 0, 0, 1, 0.502304, 0.5, 0, 0, []],
				167,
				1223,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[187164, 784, 0, 452, 429, 0, -0.0080524, 1, 0.501205, 0.5, 0, 0, []],
				165,
				1226,
				[
				],
				[
				[
					1
				],
				[
					1,
					1,
					0,
					0,
					0,
					0,
					0,
					0,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[180310, 67, 0, -157, 107, 0, 0.0961743, 1, 0.503704, 0.5, 0, 0, []],
				102,
				1227,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					500,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[185629, 793, 0, 241, 231, 0, 0, 1, 0.501205, 0.5, 0, 0, []],
				165,
				1228,
				[
				],
				[
				[
					1
				],
				[
					1,
					1,
					0,
					7,
					0,
					0,
					0,
					50,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[184479, 655, 0, 241, 231, 0, 0, 1, 0.501205, 0.5, 0, 0, []],
				165,
				1229,
				[
				],
				[
				[
					1
				],
				[
					1,
					1,
					0,
					7,
					0,
					0,
					0,
					50,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[184836, -120, 0, 452, 429, 0, -3.1392, 1, 0.501205, 0.5, 0, 0, []],
				165,
				1230,
				[
				],
				[
				[
					1
				],
				[
					1,
					1,
					0,
					7,
					0,
					0,
					0,
					50,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[167115, 477, 0, -157, 107, 0, 0.0961743, 1, 0.503704, 0.5, 0, 0, []],
				102,
				1231,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					500,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[172143, 48, 0, -157, 107, 0, 0.0961743, 1, 0.503704, 0.5, 0, 0, []],
				102,
				1232,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					500,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[174095, 288, 0, -157, 107, 0, 0.0961743, 1, 0.503704, 0.5, 0, 0, []],
				102,
				1233,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					500,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[175127, 92, 0, 251, 157, 0, 0.0961743, 1, 0.503704, 0.5, 0, 0, []],
				102,
				1234,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					500,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[176153, 162, 0, -157, 107, 0, 0.0961743, 1, 0.503704, 0.5, 0, 0, []],
				102,
				1235,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					500,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[178777, 30, 0, -157, 107, 0, 0.0961743, 1, 0.503704, 0.5, 0, 0, []],
				102,
				1236,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					500,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[179883, 180, 0, -157, 107, 0, 0.0961743, 1, 0.503704, 0.5, 0, 0, []],
				102,
				1237,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					500,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[179514, 130, 0, -157, 107, 0, 0.0961743, 1, 0.503704, 0.5, 0, 0, []],
				102,
				1238,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					500,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[181966, 12, 0, -157, 107, 0, 0.0961743, 1, 0.503704, 0.5, 0, 0, []],
				102,
				1239,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					500,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[181272, 127.179, 0, 154, 107, 0, 0.0961743, 1, 0.503704, 0.5, 0, 0, []],
				102,
				1240,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					500,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[186341, 66, 0, -127, 96, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				102,
				1241,
				[
				],
				[
				[
					1,
					0,
					0,
					8,
					0,
					0,
					0,
					500,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[186218, 73, 0, 174, 107, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				102,
				1242,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					500,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[186565, 28, 0, 174, 107, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				102,
				1243,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					500,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[185923, 60, 0, -127, 96, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				102,
				1244,
				[
				],
				[
				[
					1,
					0,
					0,
					8,
					0,
					0,
					0,
					500,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[185623, 30, 0, -127, 96, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				102,
				1245,
				[
				],
				[
				[
					1,
					0,
					0,
					8,
					0,
					0,
					0,
					500,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[186291, 484, 0, 133, 221, 0, 0, 1, 0.503937, 0.502304, 0, 0, []],
				33,
				1246,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[186489, 540, 0, 117, 94, 0, 0, 1, 0.505376, 0.5, 0, 0, []],
				168,
				1247,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[187357, 32, 0, 174, 107, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				102,
				1248,
				[
				],
				[
				[
					1,
					0,
					0,
					1,
					0,
					0,
					0,
					500,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[187329, 109, 0, 174, 107, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				102,
				1249,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					500,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[187155, 55, 0, 174, 107, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				102,
				1250,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					200,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[186889, 15, 0, 111, 77, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				102,
				1251,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					500,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[187511, 59, 0, 174, 107, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				102,
				1252,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					100,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[187245, 19, 0, 111, 77, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				102,
				1253,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					500,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[187018, 68, 0, 174, 107, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				102,
				1254,
				[
				],
				[
				[
					1,
					0,
					0,
					3,
					0,
					0,
					0,
					500,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[186752, 28, 0, 111, 77, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				102,
				1255,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					500,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[187874, 97, 0, 174, 107, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				102,
				1256,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					500,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[187608, 57, 0, 111, 77, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				102,
				1257,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					500,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[186916, 97, 0, 174, 107, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				102,
				1258,
				[
				],
				[
				[
					1,
					0,
					0,
					1,
					0,
					0,
					0,
					500,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[187070, 124, 0, 174, 107, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				102,
				1259,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					100,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[186804, 84, 0, 111, 77, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				102,
				1260,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					500,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[187167, 122, 0, 111, 77, 0, 0, 1, 0.503704, 0.5, 0, 0, []],
				102,
				1261,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					500,
					0
				],
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[186696, 477, 0, 707, 120.984, 0, 0, 1, 0.5, 0.512195, 0, 0, []],
				79,
				1263,
				[
				],
				[
				],
				[
					1,
					"Default",
					0,
					1
				]
			]
,			[
				[186297, 361, 0, 369, 59, 0, 0, 1, 0, 0, 0, 0, []],
				137,
				1265,
				[
				],
				[
				],
				[
					"SCORE:",
					1,
					"24pt Arial Rounded MT Bold",
					"rgb(0,0,0)",
					0,
					0,
					0,
					0,
					0
				]
			]
,			[
				[114, 106, 0, 217, 53, 0, 0, 0.3, 0.502463, 0.5, 0, 0, []],
				71,
				1262,
				[
				],
				[
				[
					0,
					0,
					0,
					0,
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
			],
			[			]
		]
,		[
			"elementosecenario",
			2,
			9453354456054541,
			true,
			[255, 255, 255],
			true,
			1,
			1,
			1,
			false,
			1,
			0,
			0,
			[
			[
				[129.758, 414.138, 0, 136, 166, 0, 0, 1, 0.515152, 0.60479, 0, 0, []],
				6,
				6,
				[
				],
				[
				[
					1
				],
				[
					330,
					1500,
					1500,
					700,
					1500,
					1200,
					1,
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[1435.5, 590, 0, 937, 221, 0, 0, 1, 0.5, 0.502262, 0, 0, []],
				4,
				7,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[389.5, 589, 0, 895, 221, 0, 0, 1, 0.5, 0.502262, 0, 0, []],
				4,
				5,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[3442, 592.023, 0, 864, 231, 0, 0, 1, 0.5, 0.502262, 0, 0, []],
				4,
				16,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[2496, 618, 0, 838, 221, 0, 0, 1, 0.5, 0.502262, 0, 0, []],
				4,
				17,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[3289, 478, 0, 107, 31, 0, 0, 1, 0.5, 0.555556, 0, 0, []],
				17,
				23,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[3657, 481, 0, 107, 31, 0, 0, 1, 0.5, 0.555556, 0, 0, []],
				17,
				80,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[3749, 482, 0, 107, 31, 0, 0, 1, 0.5, 0.555556, 0, 0, []],
				17,
				82,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[3137, 483, 0, 126, 40, 0, 0, 1, 0.503067, 0.5, 0, 0, []],
				30,
				86,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[1535.55, 488, 0, 143, 50, 0, 0, 1, 0.503067, 0.5, 0, 0, []],
				30,
				102,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[432.211, 464.594, 0, 51, 47, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				33,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[1188.79, 461, 0, 42, 40, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				29,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[1342.04, 468.562, 0, 46, 40, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				30,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[2803.02, 510.194, 0, 54, 50, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				37,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[5169.83, 535.798, 0, 69, 55, 0, 0, 1, 0.520833, 0.520833, 0, 0, []],
				20,
				45,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[3466, 486, 0, 143, 50, 0, 0, 1, 0.503067, 0.5, 0, 0, []],
				30,
				143,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[49255, 668, 0, 532, 190, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				94,
				213,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[48474, 624, 0, 532, 190, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				94,
				215,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[142663, 592, 0, -145, 208, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				136,
				327,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[127857, 594, 0, -145, 208, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				136,
				353,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[129136, 604, 0, -145, 208, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				136,
				354,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[129240, 568, 0, -176, 265, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				136,
				355,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[129278, 633, 0, -95, 151, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				136,
				356,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[140126, 603, 0, -145, 208, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				136,
				342,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[136159, 604, 0, -145, 208, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				136,
				344,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[136361, 604, 0, -145, 208, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				136,
				351,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[134456, 609, 0, -145, 208, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				136,
				352,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[134504, 595, 0, 165, 265, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				136,
				360,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[132332, 653, 0, -119, 175, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				136,
				358,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[132404, 615, 0, -176, 265, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				136,
				357,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
			],
			[			]
		]
,		[
			"tactil",
			3,
			93992145734896,
			true,
			[255, 255, 255],
			true,
			1,
			1,
			1,
			false,
			1,
			0,
			0,
			[
			[
				[8633, 773, 0, 45, 41.6751, 0, 1.66025, 1, 0.5, 0.5, 0, 0, []],
				32,
				104,
				[
				],
				[
				[
					500,
					50,
					0,
					0,
					1,
					1
				],
				[
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[115, 537, 0, 186, 181, 0, 0, 0.55, 0.5, 0.5, 0, 0, []],
				8,
				9,
				[
				],
				[
				[
					0,
					0,
					0,
					0,
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[307, 538, 0, 186, 181, 0, 0, 0.55, 0.5, 0.5, 0, 0, []],
				9,
				10,
				[
				],
				[
				[
					0,
					0,
					0,
					0,
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[939.5, 561.5, 0, 116, 113, 0, 0, 0.55, 0.5, 0.5, 0, 0, []],
				10,
				11,
				[
				],
				[
				[
					0,
					0,
					0,
					0,
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[959, 65, 0, 61, 58, 0, 0, 0.55, 0.5, 0.5, 0, 0, []],
				11,
				12,
				[
				],
				[
				[
					0,
					0,
					0,
					0,
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[529, 239, 0, 120, 106, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				12,
				13,
				[
				],
				[
				[
					0,
					0,
					0,
					0,
					1
				]
				],
				[
					1,
					"Default",
					0,
					1
				]
			]
,			[
				[-119, 316, 0, 61, 464, 0, 0.00231402, 1, 0.5, 0.5, 0, 0, []],
				13,
				14,
				[
				],
				[
				[
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[2365, 466, 0, 191, 122, 0, 0, 1, 0.50641, 0.523364, 0, 0, []],
				15,
				18,
				[
				],
				[
				[
					1,
					0,
					0,
					4,
					0,
					0,
					0,
					90,
					0
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[1664, 477, 0, 107, 31, 0, 0, 1, 0.5, 0.555556, 0, 0, []],
				17,
				20,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[38, 48, 0, 61, 56, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				19,
				25,
				[
				],
				[
				[
					0,
					0,
					0,
					0,
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[933, 447, 0, 104, 94, 0, 0, 0.55, 0.5, 0.5, 0, 0, []],
				31,
				103,
				[
				],
				[
				[
					0,
					0,
					0,
					0,
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[851, 416, 0, 72, 53, 0, 0, 1, 0, 0, 0, 0, []],
				22,
				28,
				[
				],
				[
				[
					0,
					0,
					0,
					0,
					1
				]
				],
				[
					"0",
					0,
					"22pt Arial Rounded MT Bold",
					"rgb(255,255,255)",
					0,
					0,
					0,
					0,
					0
				]
			]
,			[
				[8187, 436, 0, 541, 87.3771, 0, 0, 1, 0.5, 0.512195, 0, 0, []],
				79,
				419,
				[
				],
				[
				],
				[
					1,
					"Default",
					0,
					1
				]
			]
,			[
				[965, 151, 0, -78, 76, 0, 0, 0.55, 0.5, 0.5, 0, 0, []],
				25,
				196,
				[
				],
				[
				[
					0,
					0,
					0,
					0,
					1
				]
				],
				[
					1,
					"Default",
					0,
					0
				]
			]
,			[
				[127680, 573, 0, 250, 250, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				122,
				738,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[145, 51, 0, 47, 46, 0, 0, 1, 0.512195, 0.511628, 0, 0, []],
				158,
				1029,
				[
				],
				[
				[
					0,
					0,
					0,
					0,
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[186507, 257, 0, 993, 227, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				169,
				1264,
				[
				],
				[
				],
				[
					1,
					"Default",
					0,
					1
				]
			]
,			[
				[73, 88, 0, 142, 47, 0, 0, 1, 0, 0, 0, 0, []],
				69,
				174,
				[
				],
				[
				[
					0,
					0,
					0,
					0,
					1
				]
				],
				[
					"0",
					0,
					"22pt Arial Rounded MT Bold",
					"rgb(255,255,255)",
					0,
					0,
					0,
					0,
					0
				]
			]
,			[
				[42, 110, 0, 40, 42, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				99,
				235,
				[
				],
				[
				[
					0,
					0,
					0,
					0,
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[790.155, 538.196, 0, 186, 181, 0, 0.694641, 0.55, 0.5, 0.5, 0, 0, []],
				170,
				1266,
				[
				],
				[
				[
					0,
					0,
					0,
					0,
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[50.7882, 32, 0, 67, 38, 0, 0, 0.8, 0, 0, 0, 0, []],
				21,
				27,
				[
				],
				[
				[
					0,
					0,
					0,
					0,
					1
				]
				],
				[
					"10",
					0,
					"20pt Arial Rounded MT Bold",
					"rgb(255,255,255)",
					1,
					0,
					0,
					0,
					0
				]
			]
			],
			[			]
		]
		],
		[
		],
		[]
	]
,	[
		"perdio",
		1018,
		628,
		false,
		"perdioeventos",
		9797534452670282,
		[
		[
			"Layer 0",
			0,
			1085109416439308,
			true,
			[255, 255, 255],
			true,
			1,
			1,
			1,
			false,
			1,
			0,
			0,
			[
			],
			[			]
		]
,		[
			"TOUCH",
			1,
			9027898965726165,
			true,
			[255, 255, 255],
			false,
			1,
			1,
			1,
			false,
			1,
			0,
			0,
			[
			[
				[504, 307, 0, 1041, 703, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				66,
				111,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[530.5, 356, 0, -141, 134, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				25,
				38,
				[
				],
				[
				[
					0,
					0,
					0,
					0,
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[633, 255, 0, 457, 127, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				135,
				281,
				[
				],
				[
				],
				[
					"",
					0,
					"36pt Arial Rounded MT Bold",
					"rgb(0,0,0)",
					0,
					0,
					1,
					0,
					0
				]
			]
			],
			[			]
		]
		],
		[
		],
		[]
	]
,	[
		"creditosyhistoria",
		1018,
		628,
		false,
		"eventcreditoshistory",
		9089198457532285,
		[
		[
			"Layer 0",
			0,
			5341585381950418,
			true,
			[255, 255, 255],
			false,
			1,
			1,
			1,
			false,
			1,
			0,
			0,
			[
			[
				[546, 350, 0, 1089, 704, 0, 0, 1, 0.5, 0.500507, 0, 0, []],
				84,
				431,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[537.5, 347, 0, 755, 500, 0, 0, 0.6, 0.5, 0.5, 0, 0, []],
				151,
				125,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[191, 98, 0, 667, 514, 0, 0, 1, 0, 0, 0, 0, []],
				85,
				175,
				[
				],
				[
				],
				[
					"Hola Saludos  de parte  de JEANKEE a todos espero que difruten el juego es creado con mucho esfuerzo y cariño para todos ustedes tengo que agradecerles a :",
					0,
					"26pt Arial Rounded MT Bold",
					"rgb(0,0,0)",
					0,
					0,
					0,
					0,
					0
				]
			]
,			[
				[200, 374, 0, 200, 30, 0, 0, 1, 0, 0, 0, 0, []],
				86,
				302,
				[
				],
				[
				],
				[
					"http://openclipart.org",
					0,
					"14pt Arial Rounded MT Bold",
					"rgb(0,0,0)",
					0,
					0,
					0,
					0,
					0
				]
			]
,			[
				[200, 317, 0, 216, 30, 0, 0, 1, 0, 0, 0, 0, []],
				86,
				433,
				[
				],
				[
				],
				[
					"http://www.ludei.com",
					0,
					"14pt Arial Rounded MT Bold",
					"rgb(0,0,0)",
					0,
					0,
					0,
					0,
					0
				]
			]
,			[
				[199, 345, 0, 240, 30, 0, 0, 1, 0, 0, 0, 0, []],
				86,
				434,
				[
				],
				[
				],
				[
					"http://www.freesfx.co.uk",
					0,
					"14pt Arial Rounded MT Bold",
					"rgb(0,0,0)",
					0,
					0,
					0,
					0,
					0
				]
			]
,			[
				[202, 447, 0, 463, 59, 0, 0, 1, 0, 0, 0, 0, []],
				86,
				436,
				[
				],
				[
				],
				[
					"http://facebook.com/JeankeeCom",
					0,
					"20pt Arial Rounded MT Bold",
					"rgb(0,0,0)",
					0,
					0,
					0,
					0,
					0
				]
			]
,			[
				[204, 481, 0, 493, 59, 0, 0, 1, 0, 0, 0, 0, []],
				86,
				437,
				[
				],
				[
				],
				[
					"http://twitter.com/JeankeeOviedo",
					0,
					"20pt Arial Rounded MT Bold",
					"rgb(0,0,0)",
					0,
					0,
					0,
					0,
					0
				]
			]
,			[
				[202, 513, 0, 493, 59, 0, 0, 1, 0, 0, 0, 0, []],
				86,
				438,
				[
				],
				[
				],
				[
					"http://Jeankee.com",
					0,
					"20pt Arial Rounded MT Bold",
					"rgb(0,0,0)",
					0,
					0,
					0,
					0,
					0
				]
			]
,			[
				[536, 574, 0, -83, 85, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				25,
				440,
				[
				],
				[
				[
					0,
					0,
					0,
					0,
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[195, 406, 0, 557, 49, 0, 0, 1, 0, 0, 0, 0, []],
				86,
				439,
				[
				],
				[
				],
				[
					"Contact/Contacto",
					0,
					"18pt Arial Rounded MT Bold",
					"rgb(153,0,0)",
					0,
					0,
					0,
					0,
					0
				]
			]
			],
			[			]
		]
		],
		[
		],
		[]
	]
,	[
		"idioma",
		1018,
		628,
		false,
		"idiomaeventos",
		3034391749859396,
		[
		[
			"Layer 0",
			0,
			8905277602544676,
			true,
			[255, 255, 255],
			false,
			1,
			1,
			1,
			false,
			1,
			0,
			0,
			[
			[
				[522, 321.845, 0, 1066, 681, 0, 0, 1, 0.5, 0.500507, 0, 0, []],
				84,
				430,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[555, 246, 0, 241, 81, 0, 0, 1, 0.502075, 0.506173, 0, 0, []],
				82,
				428,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[555, 338, 0, 241, 81, 0, 0, 1, 0.502075, 0.506173, 0, 0, []],
				83,
				429,
				[
				],
				[
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
,			[
				[543, 466.5, 0, -149, 139, 0, 0, 1, 0.5, 0.5, 0, 0, []],
				25,
				113,
				[
				],
				[
				[
					0,
					0,
					0,
					0,
					1
				]
				],
				[
					0,
					"Default",
					0,
					1
				]
			]
			],
			[			]
		]
		],
		[
		],
		[]
	]
	],
	[
	[
		"mundoseventos",
		[
		[
			1,
			"localsavemision",
			0,
			0,
false,false,2537556983531753,false
		]
,		[
			0,
			[true, "inicio"],
			false,
			null,
			6033450793189434,
			[
			[
				-1,
				cr.system_object.prototype.cnds.IsGroupActive,
				null,
				0,
				false,
				false,
				false,
				6033450793189434,
				false
				,[
				[
					1,
					[
						2,
						"inicio"
					]
				]
				]
			]
			],
			[
			]
		]
,		[
			1,
			"niveldesbloqueado",
			0,
			0,
false,false,5648183239677347,false
		]
,		[
			1,
			"estamisiones",
			0,
			1,
false,false,2383989478694848,false
		]
,		[
			0,
			null,
			false,
			null,
			372961592771907,
			[
			[
				-1,
				cr.system_object.prototype.cnds.OnLoadFinished,
				null,
				1,
				false,
				false,
				false,
				1190504547640433,
				false
			]
			],
			[
			[
				150,
				cr.plugins_.CJSAds.prototype.acts.ShowBanner,
				null,
				9671480734882592,
				false
				,[
				[
					3,
					0
				]
				]
			]
,			[
				-1,
				cr.system_object.prototype.acts.SetTimescale,
				null,
				8889010284632485,
				false
				,[
				[
					0,
					[
						1,
						1.2
					]
				]
				]
			]
			]
		]
,		[
			0,
			null,
			false,
			null,
			9125341823974152,
			[
			[
				6,
				cr.plugins_.Sprite.prototype.cnds.OnCollision,
				null,
				0,
				false,
				false,
				true,
				9527315525256616,
				false
				,[
				[
					4,
					128
				]
				]
			]
			],
			[
			[
				128,
				cr.behaviors.Bullet.prototype.acts.SetEnabled,
				"Bullet",
				6818000953485315,
				false
				,[
				[
					3,
					1
				]
				]
			]
			]
		]
,		[
			0,
			null,
			false,
			null,
			2964826750161459,
			[
			[
				6,
				cr.plugins_.Sprite.prototype.cnds.OnCollision,
				null,
				0,
				false,
				false,
				true,
				6981067674672492,
				false
				,[
				[
					4,
					142
				]
				]
			]
			],
			[
			[
				143,
				cr.behaviors.Bullet.prototype.acts.SetEnabled,
				"Bullet",
				9035254385009885,
				false
				,[
				[
					3,
					1
				]
				]
			]
			]
		]
,		[
			0,
			null,
			false,
			null,
			119599832733213,
			[
			[
				-1,
				cr.system_object.prototype.cnds.OnLayoutStart,
				null,
				1,
				false,
				false,
				false,
				6164002718978726,
				false
			]
			],
			[
			]
			,[
			[
				0,
				null,
				false,
				null,
				1455094277238241,
				[
				[
					-1,
					cr.system_object.prototype.cnds.CompareVar,
					null,
					0,
					false,
					false,
					false,
					5808713895668769,
					false
					,[
					[
						11,
						"mision"
					]
,					[
						8,
						0
					]
,					[
						7,
						[
							0,
							1
						]
					]
					]
				]
				],
				[
				[
					159,
					cr.plugins_.Text.prototype.acts.SetText,
					null,
					729910552597169,
					false
					,[
					[
						7,
						[
							10,
							[
								2,
								""
							]
							,[
								5,
								[
									23,
									"mision"
								]
								,[
									0,
									1
								]
							]
						]
					]
					]
				]
				]
			]
			]
		]
,		[
			0,
			null,
			false,
			null,
			5720839771989195,
			[
			[
				-1,
				cr.system_object.prototype.cnds.OnLayoutStart,
				null,
				1,
				false,
				false,
				false,
				7064047925245759,
				false
			]
			],
			[
			]
			,[
			[
				0,
				null,
				false,
				null,
				4235759992186231,
				[
				[
					-1,
					cr.system_object.prototype.cnds.CompareVar,
					null,
					0,
					false,
					false,
					false,
					4832773956819214,
					false
					,[
					[
						11,
						"mision"
					]
,					[
						8,
						0
					]
,					[
						7,
						[
							0,
							2
						]
					]
					]
				]
				],
				[
				[
					6,
					cr.plugins_.Sprite.prototype.acts.SetPosToObject,
					null,
					3223889065610466,
					false
					,[
					[
						4,
						88
					]
,					[
						7,
						[
							0,
							0
						]
					]
					]
				]
,				[
					-1,
					cr.system_object.prototype.acts.Wait,
					null,
					7257005556859667,
					false
					,[
					[
						0,
						[
							1,
							0.5
						]
					]
					]
				]
,				[
					-1,
					cr.system_object.prototype.acts.SetVar,
					null,
					8866548826168072,
					false
					,[
					[
						11,
						"estamisiones"
					]
,					[
						7,
						[
							0,
							2
						]
					]
					]
				]
,				[
					159,
					cr.plugins_.Text.prototype.acts.SetText,
					null,
					3772938074622413,
					false
					,[
					[
						7,
						[
							10,
							[
								2,
								""
							]
							,[
								5,
								[
									23,
									"mision"
								]
								,[
									0,
									1
								]
							]
						]
					]
					]
				]
				]
			]
			]
		]
,		[
			0,
			null,
			false,
			null,
			828538772208592,
			[
			[
				-1,
				cr.system_object.prototype.cnds.OnLayoutStart,
				null,
				1,
				false,
				false,
				false,
				9845286806021059,
				false
			]
			],
			[
			]
			,[
			[
				0,
				null,
				false,
				null,
				6876684411828075,
				[
				[
					-1,
					cr.system_object.prototype.cnds.CompareVar,
					null,
					0,
					false,
					false,
					false,
					5886746356457399,
					false
					,[
					[
						11,
						"mision"
					]
,					[
						8,
						0
					]
,					[
						7,
						[
							0,
							3
						]
					]
					]
				]
				],
				[
				[
					6,
					cr.plugins_.Sprite.prototype.acts.SetPosToObject,
					null,
					4523544105094521,
					false
					,[
					[
						4,
						92
					]
,					[
						7,
						[
							0,
							0
						]
					]
					]
				]
,				[
					-1,
					cr.system_object.prototype.acts.Wait,
					null,
					816044888737096,
					false
					,[
					[
						0,
						[
							1,
							0.5
						]
					]
					]
				]
,				[
					-1,
					cr.system_object.prototype.acts.SetVar,
					null,
					8390068782296446,
					false
					,[
					[
						11,
						"estamisiones"
					]
,					[
						7,
						[
							0,
							3
						]
					]
					]
				]
,				[
					159,
					cr.plugins_.Text.prototype.acts.SetText,
					null,
					1579801564035368,
					false
					,[
					[
						7,
						[
							10,
							[
								2,
								""
							]
							,[
								5,
								[
									23,
									"mision"
								]
								,[
									0,
									1
								]
							]
						]
					]
					]
				]
				]
			]
			]
		]
,		[
			0,
			null,
			false,
			null,
			7550229311071765,
			[
			[
				-1,
				cr.system_object.prototype.cnds.OnLayoutStart,
				null,
				1,
				false,
				false,
				false,
				757043709577633,
				false
			]
			],
			[
			]
			,[
			[
				0,
				null,
				false,
				null,
				6813885228322786,
				[
				[
					-1,
					cr.system_object.prototype.cnds.CompareVar,
					null,
					0,
					false,
					false,
					false,
					2845275617033986,
					false
					,[
					[
						11,
						"mision"
					]
,					[
						8,
						0
					]
,					[
						7,
						[
							0,
							4
						]
					]
					]
				]
				],
				[
				[
					6,
					cr.plugins_.Sprite.prototype.acts.SetPosToObject,
					null,
					6857112806625367,
					false
					,[
					[
						4,
						96
					]
,					[
						7,
						[
							0,
							1
						]
					]
					]
				]
,				[
					-1,
					cr.system_object.prototype.acts.Wait,
					null,
					7973930372176247,
					false
					,[
					[
						0,
						[
							1,
							0.5
						]
					]
					]
				]
,				[
					-1,
					cr.system_object.prototype.acts.SetVar,
					null,
					4562447492733563,
					false
					,[
					[
						11,
						"estamisiones"
					]
,					[
						7,
						[
							0,
							4
						]
					]
					]
				]
,				[
					159,
					cr.plugins_.Text.prototype.acts.SetText,
					null,
					5511125113290054,
					false
					,[
					[
						7,
						[
							10,
							[
								2,
								""
							]
							,[
								5,
								[
									23,
									"mision"
								]
								,[
									0,
									1
								]
							]
						]
					]
					]
				]
				]
			]
			]
		]
,		[
			0,
			null,
			false,
			null,
			3185371272603467,
			[
			[
				-1,
				cr.system_object.prototype.cnds.OnLayoutStart,
				null,
				1,
				false,
				false,
				false,
				1590510018309527,
				false
			]
			],
			[
			]
			,[
			[
				0,
				null,
				false,
				null,
				7132632353565091,
				[
				[
					-1,
					cr.system_object.prototype.cnds.CompareVar,
					null,
					0,
					false,
					false,
					false,
					1699579324155618,
					false
					,[
					[
						11,
						"mision"
					]
,					[
						8,
						0
					]
,					[
						7,
						[
							0,
							5
						]
					]
					]
				]
				],
				[
				[
					6,
					cr.plugins_.Sprite.prototype.acts.SetPosToObject,
					null,
					4679949452438596,
					false
					,[
					[
						4,
						105
					]
,					[
						7,
						[
							0,
							0
						]
					]
					]
				]
,				[
					-1,
					cr.system_object.prototype.acts.Wait,
					null,
					5559110851939694,
					false
					,[
					[
						0,
						[
							1,
							0.5
						]
					]
					]
				]
,				[
					159,
					cr.plugins_.Text.prototype.acts.SetText,
					null,
					6443737167868251,
					false
					,[
					[
						7,
						[
							10,
							[
								2,
								""
							]
							,[
								5,
								[
									23,
									"mision"
								]
								,[
									0,
									1
								]
							]
						]
					]
					]
				]
,				[
					-1,
					cr.system_object.prototype.acts.SetVar,
					null,
					8824640755485368,
					false
					,[
					[
						11,
						"estamisiones"
					]
,					[
						7,
						[
							0,
							5
						]
					]
					]
				]
				]
			]
			]
		]
,		[
			0,
			null,
			false,
			null,
			6152184160906665,
			[
			[
				-1,
				cr.system_object.prototype.cnds.OnLayoutStart,
				null,
				1,
				false,
				false,
				false,
				7266588011087166,
				false
			]
			],
			[
			]
			,[
			[
				0,
				null,
				false,
				null,
				7270793814159178,
				[
				[
					-1,
					cr.system_object.prototype.cnds.CompareVar,
					null,
					0,
					false,
					false,
					false,
					4143641235456677,
					false
					,[
					[
						11,
						"mision"
					]
,					[
						8,
						0
					]
,					[
						7,
						[
							0,
							6
						]
					]
					]
				]
				],
				[
				[
					6,
					cr.plugins_.Sprite.prototype.acts.SetPosToObject,
					null,
					3406837886017906,
					false
					,[
					[
						4,
						113
					]
,					[
						7,
						[
							0,
							0
						]
					]
					]
				]
,				[
					-1,
					cr.system_object.prototype.acts.Wait,
					null,
					8025026693514123,
					false
					,[
					[
						0,
						[
							1,
							0.5
						]
					]
					]
				]
,				[
					-1,
					cr.system_object.prototype.acts.SetVar,
					null,
					7906456882566519,
					false
					,[
					[
						11,
						"estamisiones"
					]
,					[
						7,
						[
							0,
							6
						]
					]
					]
				]
,				[
					159,
					cr.plugins_.Text.prototype.acts.SetText,
					null,
					6057403535123769,
					false
					,[
					[
						7,
						[
							10,
							[
								2,
								""
							]
							,[
								5,
								[
									23,
									"mision"
								]
								,[
									0,
									1
								]
							]
						]
					]
					]
				]
				]
			]
			]
		]
,		[
			0,
			null,
			false,
			null,
			7338477145688975,
			[
			[
				-1,
				cr.system_object.prototype.cnds.OnLayoutStart,
				null,
				1,
				false,
				false,
				false,
				5518066099016701,
				false
			]
			],
			[
			]
			,[
			[
				0,
				null,
				false,
				null,
				3790818481031007,
				[
				[
					-1,
					cr.system_object.prototype.cnds.CompareVar,
					null,
					0,
					false,
					false,
					false,
					1086006711460922,
					false
					,[
					[
						11,
						"mision"
					]
,					[
						8,
						0
					]
,					[
						7,
						[
							0,
							7
						]
					]
					]
				]
				],
				[
				[
					6,
					cr.plugins_.Sprite.prototype.acts.SetPosToObject,
					null,
					3446514522800072,
					false
					,[
					[
						4,
						115
					]
,					[
						7,
						[
							0,
							0
						]
					]
					]
				]
,				[
					-1,
					cr.system_object.prototype.acts.Wait,
					null,
					5388016598477154,
					false
					,[
					[
						0,
						[
							1,
							0.5
						]
					]
					]
				]
,				[
					-1,
					cr.system_object.prototype.acts.SetVar,
					null,
					490866726327769,
					false
					,[
					[
						11,
						"estamisiones"
					]
,					[
						7,
						[
							0,
							7
						]
					]
					]
				]
,				[
					159,
					cr.plugins_.Text.prototype.acts.SetText,
					null,
					9780494119773554,
					false
					,[
					[
						7,
						[
							10,
							[
								2,
								""
							]
							,[
								5,
								[
									23,
									"mision"
								]
								,[
									0,
									1
								]
							]
						]
					]
					]
				]
				]
			]
			]
		]
,		[
			0,
			null,
			false,
			null,
			3929050052534543,
			[
			[
				-1,
				cr.system_object.prototype.cnds.OnLayoutStart,
				null,
				1,
				false,
				false,
				false,
				7022825858490061,
				false
			]
			],
			[
			]
			,[
			[
				0,
				null,
				false,
				null,
				8269480660042097,
				[
				[
					-1,
					cr.system_object.prototype.cnds.CompareVar,
					null,
					0,
					false,
					false,
					false,
					8466476867953077,
					false
					,[
					[
						11,
						"mision"
					]
,					[
						8,
						0
					]
,					[
						7,
						[
							0,
							8
						]
					]
					]
				]
				],
				[
				[
					6,
					cr.plugins_.Sprite.prototype.acts.SetPosToObject,
					null,
					3482881987078099,
					false
					,[
					[
						4,
						116
					]
,					[
						7,
						[
							0,
							0
						]
					]
					]
				]
,				[
					-1,
					cr.system_object.prototype.acts.Wait,
					null,
					8138900816173752,
					false
					,[
					[
						0,
						[
							1,
							0.5
						]
					]
					]
				]
,				[
					-1,
					cr.system_object.prototype.acts.SetVar,
					null,
					2302011520508512,
					false
					,[
					[
						11,
						"estamisiones"
					]
,					[
						7,
						[
							0,
							8
						]
					]
					]
				]
,				[
					159,
					cr.plugins_.Text.prototype.acts.SetText,
					null,
					6570613608909847,
					false
					,[
					[
						7,
						[
							10,
							[
								2,
								""
							]
							,[
								5,
								[
									23,
									"mision"
								]
								,[
									0,
									1
								]
							]
						]
					]
					]
				]
				]
			]
			]
		]
,		[
			0,
			null,
			false,
			null,
			6656386689046659,
			[
			[
				-1,
				cr.system_object.prototype.cnds.OnLayoutStart,
				null,
				1,
				false,
				false,
				false,
				1228012024910479,
				false
			]
			],
			[
			]
			,[
			[
				0,
				null,
				false,
				null,
				1519959940717217,
				[
				[
					-1,
					cr.system_object.prototype.cnds.CompareVar,
					null,
					0,
					false,
					false,
					false,
					1092822873589129,
					false
					,[
					[
						11,
						"mision"
					]
,					[
						8,
						0
					]
,					[
						7,
						[
							0,
							9
						]
					]
					]
				]
				],
				[
				[
					6,
					cr.plugins_.Sprite.prototype.acts.SetPosToObject,
					null,
					8401436419357459,
					false
					,[
					[
						4,
						122
					]
,					[
						7,
						[
							0,
							0
						]
					]
					]
				]
,				[
					-1,
					cr.system_object.prototype.acts.Wait,
					null,
					3662663425045254,
					false
					,[
					[
						0,
						[
							1,
							0.5
						]
					]
					]
				]
,				[
					-1,
					cr.system_object.prototype.acts.SetVar,
					null,
					3021091121773034,
					false
					,[
					[
						11,
						"estamisiones"
					]
,					[
						7,
						[
							0,
							9
						]
					]
					]
				]
,				[
					159,
					cr.plugins_.Text.prototype.acts.SetText,
					null,
					6307854137147758,
					false
					,[
					[
						7,
						[
							10,
							[
								2,
								""
							]
							,[
								5,
								[
									23,
									"mision"
								]
								,[
									0,
									1
								]
							]
						]
					]
					]
				]
				]
			]
			]
		]
,		[
			0,
			null,
			false,
			null,
			5646637670698241,
			[
			[
				-1,
				cr.system_object.prototype.cnds.OnLayoutStart,
				null,
				1,
				false,
				false,
				false,
				6126359543014791,
				false
			]
			],
			[
			]
			,[
			[
				0,
				null,
				false,
				null,
				1882592434104072,
				[
				[
					-1,
					cr.system_object.prototype.cnds.CompareVar,
					null,
					0,
					false,
					false,
					false,
					6919560354891847,
					false
					,[
					[
						11,
						"mision"
					]
,					[
						8,
						0
					]
,					[
						7,
						[
							0,
							10
						]
					]
					]
				]
				],
				[
				[
					6,
					cr.plugins_.Sprite.prototype.acts.SetPosToObject,
					null,
					923173475692046,
					false
					,[
					[
						4,
						142
					]
,					[
						7,
						[
							0,
							0
						]
					]
					]
				]
,				[
					-1,
					cr.system_object.prototype.acts.Wait,
					null,
					7565293193625309,
					false
					,[
					[
						0,
						[
							1,
							0.5
						]
					]
					]
				]
,				[
					-1,
					cr.system_object.prototype.acts.SetVar,
					null,
					2581990930458858,
					false
					,[
					[
						11,
						"estamisiones"
					]
,					[
						7,
						[
							0,
							10
						]
					]
					]
				]
,				[
					159,
					cr.plugins_.Text.prototype.acts.SetText,
					null,
					7306799928050051,
					false
					,[
					[
						7,
						[
							10,
							[
								2,
								""
							]
							,[
								5,
								[
									23,
									"mision"
								]
								,[
									0,
									1
								]
							]
						]
					]
					]
				]
				]
			]
			]
		]
,		[
			0,
			null,
			false,
			null,
			1958281737119296,
			[
			[
				-1,
				cr.system_object.prototype.cnds.OnLayoutStart,
				null,
				1,
				false,
				false,
				false,
				2781225679561212,
				false
			]
			],
			[
			]
			,[
			[
				0,
				null,
				false,
				null,
				1928540264274641,
				[
				[
					-1,
					cr.system_object.prototype.cnds.CompareVar,
					null,
					0,
					false,
					false,
					false,
					5627225425876901,
					false
					,[
					[
						11,
						"mision"
					]
,					[
						8,
						0
					]
,					[
						7,
						[
							0,
							11
						]
					]
					]
				]
				],
				[
				[
					6,
					cr.plugins_.Sprite.prototype.acts.SetPosToObject,
					null,
					7787984751038464,
					false
					,[
					[
						4,
						156
					]
,					[
						7,
						[
							0,
							0
						]
					]
					]
				]
,				[
					-1,
					cr.system_object.prototype.acts.Wait,
					null,
					7793862658520025,
					false
					,[
					[
						0,
						[
							1,
							0.5
						]
					]
					]
				]
,				[
					-1,
					cr.system_object.prototype.acts.SetVar,
					null,
					6964032800571116,
					false
					,[
					[
						11,
						"estamisiones"
					]
,					[
						7,
						[
							0,
							11
						]
					]
					]
				]
,				[
					159,
					cr.plugins_.Text.prototype.acts.SetText,
					null,
					1213668009047001,
					false
					,[
					[
						7,
						[
							10,
							[
								2,
								""
							]
							,[
								5,
								[
									23,
									"mision"
								]
								,[
									0,
									1
								]
							]
						]
					]
					]
				]
				]
			]
			]
		]
,		[
			0,
			null,
			false,
			null,
			8651236428792351,
			[
			[
				-1,
				cr.system_object.prototype.cnds.OnLayoutStart,
				null,
				1,
				false,
				false,
				false,
				7200159457210476,
				false
			]
			],
			[
			]
			,[
			[
				0,
				null,
				false,
				null,
				306246095050521,
				[
				[
					-1,
					cr.system_object.prototype.cnds.CompareVar,
					null,
					0,
					false,
					false,
					false,
					7024592604412953,
					false
					,[
					[
						11,
						"mision"
					]
,					[
						8,
						0
					]
,					[
						7,
						[
							0,
							12
						]
					]
					]
				]
				],
				[
				[
					6,
					cr.plugins_.Sprite.prototype.acts.SetPosToObject,
					null,
					7481533617425228,
					false
					,[
					[
						4,
						166
					]
,					[
						7,
						[
							0,
							0
						]
					]
					]
				]
,				[
					-1,
					cr.system_object.prototype.acts.Wait,
					null,
					9963898738210848,
					false
					,[
					[
						0,
						[
							1,
							0.5
						]
					]
					]
				]
,				[
					-1,
					cr.system_object.prototype.acts.SetVar,
					null,
					8661863624157751,
					false
					,[
					[
						11,
						"estamisiones"
					]
,					[
						7,
						[
							0,
							12
						]
					]
					]
				]
,				[
					159,
					cr.plugins_.Text.prototype.acts.SetText,
					null,
					4516793588684586,
					false
					,[
					[
						7,
						[
							10,
							[
								2,
								""
							]
							,[
								5,
								[
									23,
									"mision"
								]
								,[
									0,
									1
								]
							]
						]
					]
					]
				]
				]
			]
			]
		]
,		[
			0,
			null,
			false,
			null,
			1133631816833907,
			[
			[
				0,
				cr.plugins_.WebStorage.prototype.cnds.LocalStorageExists,
				null,
				0,
				false,
				false,
				false,
				7848856744839893,
				false
				,[
				[
					1,
					[
						2,
						"mision1"
					]
				]
				]
			]
			],
			[
			]
			,[
			[
				0,
				null,
				false,
				null,
				2358330654020171,
				[
				[
					0,
					cr.plugins_.WebStorage.prototype.cnds.CompareKeyNumber,
					null,
					0,
					false,
					false,
					false,
					8816846544157083,
					false
					,[
					[
						1,
						[
							2,
							"mision1"
						]
					]
,					[
						8,
						2
					]
,					[
						0,
						[
							23,
							"estamisiones"
						]
					]
					]
				]
				],
				[
				[
					-1,
					cr.system_object.prototype.acts.GoToLayout,
					null,
					3878438313025315,
					false
					,[
					[
						6,
						"seleccionar"
					]
					]
				]
				]
			]
			]
		]
,		[
			0,
			null,
			false,
			null,
			8149345501426398,
			[
			[
				0,
				cr.plugins_.WebStorage.prototype.cnds.LocalStorageExists,
				null,
				0,
				false,
				false,
				false,
				3465801482141493,
				false
				,[
				[
					1,
					[
						2,
						"vidas1"
					]
				]
				]
			]
			],
			[
			]
			,[
			[
				0,
				null,
				false,
				null,
				4358524833016975,
				[
				[
					0,
					cr.plugins_.WebStorage.prototype.cnds.CompareKeyNumber,
					null,
					0,
					false,
					false,
					false,
					5417364441914297,
					false
					,[
					[
						1,
						[
							2,
							"vidas1"
						]
					]
,					[
						8,
						1
					]
,					[
						0,
						[
							0,
							10
						]
					]
					]
				]
				],
				[
				[
					-1,
					cr.system_object.prototype.acts.SetVar,
					null,
					6503803466836131,
					false
					,[
					[
						11,
						"vidas"
					]
,					[
						7,
						[
							20,
							0,
							cr.plugins_.WebStorage.prototype.exps.LocalValue,
							true,
							null
							,[
[
								2,
								"vidas1"
							]
							]
						]
					]
					]
				]
,				[
					21,
					cr.plugins_.Text.prototype.acts.SetText,
					null,
					2575307106376548,
					false
					,[
					[
						7,
						[
							10,
							[
								2,
								""
							]
							,[
								23,
								"vidas"
							]
						]
					]
					]
				]
				]
			]
			]
		]
,		[
			0,
			null,
			false,
			null,
			3800855399807199,
			[
			[
				0,
				cr.plugins_.WebStorage.prototype.cnds.LocalStorageExists,
				null,
				0,
				false,
				false,
				false,
				678085878575369,
				false
				,[
				[
					1,
					[
						2,
						"monedas1"
					]
				]
				]
			]
			],
			[
			]
			,[
			[
				0,
				null,
				false,
				null,
				7746112371304603,
				[
				[
					0,
					cr.plugins_.WebStorage.prototype.cnds.CompareKeyNumber,
					null,
					0,
					false,
					false,
					false,
					4590514726138599,
					false
					,[
					[
						1,
						[
							2,
							"monedas1"
						]
					]
,					[
						8,
						3
					]
,					[
						0,
						[
							0,
							0
						]
					]
					]
				]
				],
				[
				[
					-1,
					cr.system_object.prototype.acts.SetVar,
					null,
					2786619827722351,
					false
					,[
					[
						11,
						"monedas"
					]
,					[
						7,
						[
							20,
							0,
							cr.plugins_.WebStorage.prototype.exps.LocalValue,
							true,
							null
							,[
[
								2,
								"monedas1"
							]
							]
						]
					]
					]
				]
,				[
					22,
					cr.plugins_.Text.prototype.acts.SetText,
					null,
					7561126616939376,
					false
					,[
					[
						7,
						[
							10,
							[
								2,
								""
							]
							,[
								23,
								"monedas"
							]
						]
					]
					]
				]
				]
			]
			]
		]
,		[
			0,
			null,
			false,
			null,
			4104020773322911,
			[
			[
				0,
				cr.plugins_.WebStorage.prototype.cnds.LocalStorageExists,
				null,
				0,
				false,
				false,
				false,
				874407423924133,
				false
				,[
				[
					1,
					[
						2,
						"score1"
					]
				]
				]
			]
			],
			[
			]
			,[
			[
				0,
				null,
				false,
				null,
				4368044039171353,
				[
				[
					0,
					cr.plugins_.WebStorage.prototype.cnds.CompareKeyNumber,
					null,
					0,
					false,
					false,
					false,
					6803398580045398,
					false
					,[
					[
						1,
						[
							2,
							"score1"
						]
					]
,					[
						8,
						5
					]
,					[
						0,
						[
							0,
							0
						]
					]
					]
				]
				],
				[
				[
					-1,
					cr.system_object.prototype.acts.SetVar,
					null,
					9585803292906394,
					false
					,[
					[
						11,
						"score"
					]
,					[
						7,
						[
							20,
							0,
							cr.plugins_.WebStorage.prototype.exps.LocalValue,
							true,
							null
							,[
[
								2,
								"score1"
							]
							]
						]
					]
					]
				]
,				[
					69,
					cr.plugins_.Text.prototype.acts.SetText,
					null,
					6489555274142757,
					false
					,[
					[
						7,
						[
							10,
							[
								2,
								""
							]
							,[
								23,
								"score"
							]
						]
					]
					]
				]
				]
			]
			]
		]
,		[
			0,
			null,
			false,
			null,
			1983251595183821,
			[
			[
				-1,
				cr.system_object.prototype.cnds.CompareVar,
				null,
				0,
				false,
				false,
				false,
				7212527440379062,
				false
				,[
				[
					11,
					"vidas"
				]
,				[
					8,
					3
				]
,				[
					7,
					[
						0,
						0
					]
				]
				]
			]
			],
			[
			[
				0,
				cr.plugins_.WebStorage.prototype.acts.RemoveLocal,
				null,
				4840897042135589,
				false
				,[
				[
					1,
					[
						2,
						"vidas1"
					]
				]
				]
			]
,			[
				0,
				cr.plugins_.WebStorage.prototype.acts.RemoveLocal,
				null,
				3718505327712348,
				false
				,[
				[
					1,
					[
						2,
						"monedas1"
					]
				]
				]
			]
,			[
				0,
				cr.plugins_.WebStorage.prototype.acts.RemoveLocal,
				null,
				2574209364942464,
				false
				,[
				[
					1,
					[
						2,
						"score1"
					]
				]
				]
			]
,			[
				-1,
				cr.system_object.prototype.acts.SetVar,
				null,
				4002393711751648,
				false
				,[
				[
					11,
					"niveldesbloqueado"
				]
,				[
					7,
					[
						0,
						0
					]
				]
				]
			]
,			[
				-1,
				cr.system_object.prototype.acts.GoToLayout,
				null,
				6107074931733424,
				false
				,[
				[
					6,
					"perdio"
				]
				]
			]
			]
		]
,		[
			0,
			null,
			false,
			null,
			668754127149166,
			[
			[
				-1,
				cr.system_object.prototype.cnds.CompareVar,
				null,
				0,
				false,
				false,
				false,
				6554663773287037,
				false
				,[
				[
					11,
					"vidas"
				]
,				[
					8,
					1
				]
,				[
					7,
					[
						0,
						10
					]
				]
				]
			]
			],
			[
			[
				21,
				cr.plugins_.Text.prototype.acts.SetText,
				null,
				8580385443287933,
				false
				,[
				[
					7,
					[
						10,
						[
							2,
							""
						]
						,[
							23,
							"vidas"
						]
					]
				]
				]
			]
			]
		]
,		[
			0,
			[true, "Touch"],
			false,
			null,
			7144894380551455,
			[
			[
				-1,
				cr.system_object.prototype.cnds.IsGroupActive,
				null,
				0,
				false,
				false,
				false,
				7144894380551455,
				false
				,[
				[
					1,
					[
						2,
						"Touch"
					]
				]
				]
			]
			],
			[
			]
		]
,		[
			0,
			null,
			false,
			null,
			5119701340996403,
			[
			[
				1,
				cr.plugins_.Touch.prototype.cnds.IsTouchingObject,
				null,
				0,
				false,
				false,
				false,
				250299649408626,
				false
				,[
				[
					4,
					8
				]
				]
			]
			],
			[
			[
				6,
				cr.plugins_.Sprite.prototype.acts.SetAnim,
				null,
				2743960297294298,
				false
				,[
				[
					1,
					[
						2,
						"corriendoatras"
					]
				]
,				[
					3,
					1
				]
				]
			]
,			[
				6,
				cr.behaviors.Platform.prototype.acts.SimulateControl,
				"Platform",
				7965657125994251,
				false
				,[
				[
					3,
					0
				]
				]
			]
			]
		]
,		[
			0,
			null,
			false,
			null,
			2526603539929856,
			[
			[
				1,
				cr.plugins_.Touch.prototype.cnds.IsTouchingObject,
				null,
				0,
				false,
				false,
				false,
				3497545649703361,
				false
				,[
				[
					4,
					9
				]
				]
			]
			],
			[
			[
				6,
				cr.plugins_.Sprite.prototype.acts.SetAnim,
				null,
				4365145317773857,
				false
				,[
				[
					1,
					[
						2,
						"corriendo"
					]
				]
,				[
					3,
					1
				]
				]
			]
,			[
				6,
				cr.behaviors.Platform.prototype.acts.SimulateControl,
				"Platform",
				7291306164786121,
				false
				,[
				[
					3,
					1
				]
				]
			]
			]
		]
,		[
			0,
			null,
			false,
			null,
			7272774943450258,
			[
			[
				1,
				cr.plugins_.Touch.prototype.cnds.IsTouchingObject,
				null,
				0,
				false,
				false,
				false,
				450252560773025,
				false
				,[
				[
					4,
					10
				]
				]
			]
			],
			[
			[
				6,
				cr.plugins_.Sprite.prototype.acts.StopAnim,
				null,
				4751638484851028,
				false
			]
,			[
				6,
				cr.behaviors.Platform.prototype.acts.SetJumpStrength,
				"Platform",
				9497578929898669,
				false
				,[
				[
					0,
					[
						0,
						760
					]
				]
				]
			]
,			[
				6,
				cr.behaviors.Platform.prototype.acts.FallThrough,
				"Platform",
				2547367286503123,
				false
			]
,			[
				6,
				cr.behaviors.Platform.prototype.acts.SimulateControl,
				"Platform",
				3179541670559163,
				false
				,[
				[
					3,
					2
				]
				]
			]
			]
		]
,		[
			0,
			null,
			false,
			null,
			9808420922400922,
			[
			[
				1,
				cr.plugins_.Touch.prototype.cnds.IsTouchingObject,
				null,
				0,
				false,
				false,
				false,
				5436952509447454,
				false
				,[
				[
					4,
					170
				]
				]
			]
			],
			[
			[
				6,
				cr.plugins_.Sprite.prototype.acts.StopAnim,
				null,
				4095677474673894,
				false
			]
,			[
				6,
				cr.behaviors.Platform.prototype.acts.SetJumpStrength,
				"Platform",
				4969529392661103,
				false
				,[
				[
					0,
					[
						0,
						760
					]
				]
				]
			]
,			[
				6,
				cr.behaviors.Platform.prototype.acts.SimulateControl,
				"Platform",
				4608663795441793,
				false
				,[
				[
					3,
					1
				]
				]
			]
,			[
				6,
				cr.behaviors.Platform.prototype.acts.FallThrough,
				"Platform",
				4023866516505629,
				false
			]
,			[
				6,
				cr.behaviors.Platform.prototype.acts.SimulateControl,
				"Platform",
				8982891611497583,
				false
				,[
				[
					3,
					2
				]
				]
			]
			]
		]
,		[
			0,
			null,
			false,
			null,
			8008613774032217,
			[
			[
				1,
				cr.plugins_.Touch.prototype.cnds.IsTouchingObject,
				null,
				0,
				false,
				false,
				false,
				8508923722429187,
				false
				,[
				[
					4,
					25
				]
				]
			]
			],
			[
			[
				-1,
				cr.system_object.prototype.acts.SetTimescale,
				null,
				3841242909872613,
				false
				,[
				[
					0,
					[
						1,
						1.3
					]
				]
				]
			]
,			[
				-1,
				cr.system_object.prototype.acts.GoToLayout,
				null,
				304589010970465,
				false
				,[
				[
					6,
					"splash"
				]
				]
			]
			]
		]
,		[
			0,
			null,
			false,
			null,
			1716387162266204,
			[
			[
				1,
				cr.plugins_.Touch.prototype.cnds.IsTouchingObject,
				null,
				0,
				false,
				false,
				false,
				8969107103025291,
				false
				,[
				[
					4,
					11
				]
				]
			]
			],
			[
			[
				-1,
				cr.system_object.prototype.acts.SetTimescale,
				null,
				8506002901231251,
				false
				,[
				[
					0,
					[
						0,
						0
					]
				]
				]
			]
,			[
				12,
				cr.plugins_.Sprite.prototype.acts.SetVisible,
				null,
				8350587397120057,
				false
				,[
				[
					3,
					1
				]
				]
			]
,			[
				11,
				cr.plugins_.Sprite.prototype.acts.SetVisible,
				null,
				7586326244897541,
				false
				,[
				[
					3,
					0
				]
				]
			]
,			[
				12,
				cr.plugins_.Sprite.prototype.acts.SetVisible,
				null,
				5853904639820769,
				false
				,[
				[
					3,
					1
				]
				]
			]
,			[
				25,
				cr.plugins_.Sprite.prototype.acts.SetVisible,
				null,
				7895088119780126,
				false
				,[
				[
					3,
					1
				]
				]
			]
			]
		]
,		[
			0,
			null,
			false,
			null,
			3012193454956052,
			[
			[
				1,
				cr.plugins_.Touch.prototype.cnds.IsTouchingObject,
				null,
				0,
				false,
				false,
				false,
				801124964303377,
				false
				,[
				[
					4,
					12
				]
				]
			]
			],
			[
			[
				11,
				cr.plugins_.Sprite.prototype.acts.SetVisible,
				null,
				4704678934938587,
				false
				,[
				[
					3,
					1
				]
				]
			]
,			[
				12,
				cr.plugins_.Sprite.prototype.acts.SetVisible,
				null,
				4372937577145868,
				false
				,[
				[
					3,
					0
				]
				]
			]
,			[
				-1,
				cr.system_object.prototype.acts.SetTimescale,
				null,
				4127396307526665,
				false
				,[
				[
					0,
					[
						1,
						1.3
					]
				]
				]
			]
,			[
				25,
				cr.plugins_.Sprite.prototype.acts.SetVisible,
				null,
				6538298163282421,
				false
				,[
				[
					3,
					0
				]
				]
			]
			]
		]
,		[
			0,
			null,
			false,
			null,
			932917807339974,
			[
			[
				-1,
				cr.system_object.prototype.cnds.CompareVar,
				null,
				0,
				false,
				false,
				false,
				8883126166638854,
				false
				,[
				[
					11,
					"monedas"
				]
,				[
					8,
					2
				]
,				[
					7,
					[
						0,
						0
					]
				]
				]
			]
			],
			[
			[
				31,
				cr.plugins_.Sprite.prototype.acts.SetVisible,
				null,
				4011725124999277,
				false
				,[
				[
					3,
					0
				]
				]
			]
,			[
				31,
				cr.plugins_.Sprite.prototype.acts.SetAnim,
				null,
				2771354115639243,
				false
				,[
				[
					1,
					[
						2,
						"sihay"
					]
				]
,				[
					3,
					1
				]
				]
			]
,			[
				22,
				cr.plugins_.Text.prototype.acts.SetText,
				null,
				6930063431160167,
				false
				,[
				[
					7,
					[
						10,
						[
							2,
							""
						]
						,[
							23,
							"monedas"
						]
					]
				]
				]
			]
,			[
				-1,
				cr.system_object.prototype.acts.SetVar,
				null,
				1365200604225502,
				false
				,[
				[
					11,
					"monedas"
				]
,				[
					7,
					[
						0,
						0
					]
				]
				]
			]
			]
		]
,		[
			0,
			null,
			false,
			null,
			5597486880410777,
			[
			[
				1,
				cr.plugins_.Touch.prototype.cnds.OnTouchEnd,
				null,
				1,
				false,
				false,
				false,
				1014674048887985,
				false
			]
			],
			[
			[
				6,
				cr.plugins_.Sprite.prototype.acts.StopAnim,
				null,
				5416886365021569,
				false
			]
			]
		]
,		[
			0,
			null,
			false,
			null,
			3077098332401225,
			[
			[
				-1,
				cr.system_object.prototype.cnds.CompareVar,
				null,
				0,
				false,
				false,
				false,
				3239962258702493,
				false
				,[
				[
					11,
					"monedas"
				]
,				[
					8,
					5
				]
,				[
					7,
					[
						0,
						1
					]
				]
				]
			]
			],
			[
			]
			,[
			[
				0,
				null,
				false,
				null,
				7736892945743787,
				[
				[
					1,
					cr.plugins_.Touch.prototype.cnds.IsTouchingObject,
					null,
					0,
					false,
					false,
					false,
					9311022923211457,
					false
					,[
					[
						4,
						31
					]
					]
				]
				],
				[
				[
					31,
					cr.plugins_.Sprite.prototype.acts.SetAnim,
					null,
					4971350886179864,
					false
					,[
					[
						1,
						[
							2,
							"sihay"
						]
					]
,					[
						3,
						1
					]
					]
				]
,				[
					6,
					cr.plugins_.Sprite.prototype.acts.SetAnim,
					null,
					520542238482561,
					false
					,[
					[
						1,
						[
							2,
							"disparando"
						]
					]
,					[
						3,
						1
					]
					]
				]
,				[
					6,
					cr.plugins_.Sprite.prototype.acts.Spawn,
					null,
					5302036468487567,
					false
					,[
					[
						4,
						32
					]
,					[
						5,
						[
							0,
							0
						]
					]
,					[
						7,
						[
							0,
							1
						]
					]
					]
				]
,				[
					-1,
					cr.system_object.prototype.acts.SetVar,
					null,
					4468567315914591,
					false
					,[
					[
						11,
						"monedas"
					]
,					[
						7,
						[
							10,
							[
								2,
								""
							]
							,[
								5,
								[
									23,
									"monedas"
								]
								,[
									0,
									1
								]
							]
						]
					]
					]
				]
,				[
					22,
					cr.plugins_.Text.prototype.acts.SetText,
					null,
					2131865830903256,
					false
					,[
					[
						7,
						[
							10,
							[
								2,
								""
							]
							,[
								5,
								[
									23,
									"monedas"
								]
								,[
									0,
									1
								]
							]
						]
					]
					]
				]
,				[
					3,
					cr.plugins_.Audio.prototype.acts.Play,
					null,
					9169262307661818,
					false
					,[
					[
						2,
						["lanzando2",false]
					]
,					[
						3,
						0
					]
,					[
						0,
						[
							0,
							0
						]
					]
,					[
						1,
						[
							2,
							""
						]
					]
					]
				]
,				[
					6,
					cr.plugins_.Sprite.prototype.acts.Spawn,
					null,
					7230273107625386,
					false
					,[
					[
						4,
						32
					]
,					[
						5,
						[
							0,
							2
						]
					]
,					[
						7,
						[
							0,
							1
						]
					]
					]
				]
				]
			]
			]
		]
,		[
			0,
			null,
			false,
			null,
			5648122858017801,
			[
			],
			[
			]
		]
,		[
			0,
			[true, "villanos"],
			false,
			null,
			80986990301085,
			[
			[
				-1,
				cr.system_object.prototype.cnds.IsGroupActive,
				null,
				0,
				false,
				false,
				false,
				80986990301085,
				false
				,[
				[
					1,
					[
						2,
						"villanos"
					]
				]
				]
			]
			],
			[
			]
		]
,		[
			0,
			null,
			false,
			null,
			282280077381292,
			[
			[
				77,
				cr.plugins_.Sprite.prototype.cnds.OnCollision,
				null,
				0,
				false,
				false,
				true,
				9064149678683075,
				false
				,[
				[
					4,
					6
				]
				]
			]
			],
			[
			[
				21,
				cr.plugins_.Text.prototype.acts.SetText,
				null,
				6204649804710621,
				false
				,[
				[
					7,
					[
						10,
						[
							2,
							""
						]
						,[
							5,
							[
								23,
								"vidas"
							]
							,[
								0,
								1
							]
						]
					]
				]
				]
			]
,			[
				6,
				cr.behaviors.scrollto.prototype.acts.Shake,
				"ScrollTo",
				6168797345515644,
				false
				,[
				[
					0,
					[
						0,
						15
					]
				]
,				[
					0,
					[
						1,
						0.5
					]
				]
,				[
					3,
					0
				]
				]
			]
,			[
				3,
				cr.plugins_.Audio.prototype.acts.Play,
				null,
				3341539798852799,
				false
				,[
				[
					2,
					["uy",false]
				]
,				[
					3,
					0
				]
,				[
					0,
					[
						0,
						0
					]
				]
,				[
					1,
					[
						2,
						""
					]
				]
				]
			]
,			[
				0,
				cr.plugins_.WebStorage.prototype.acts.StoreLocal,
				null,
				9227098938876234,
				false
				,[
				[
					1,
					[
						2,
						"vidas1"
					]
				]
,				[
					7,
					[
						10,
						[
							2,
							""
						]
						,[
							5,
							[
								23,
								"vidas"
							]
							,[
								0,
								1
							]
						]
					]
				]
				]
			]
			]
		]
,		[
			0,
			null,
			false,
			null,
			6472260744641997,
			[
			[
				168,
				cr.plugins_.Sprite.prototype.cnds.OnCollision,
				null,
				0,
				false,
				false,
				true,
				7294700318855714,
				false
				,[
				[
					4,
					6
				]
				]
			]
			],
			[
			[
				168,
				cr.plugins_.Sprite.prototype.acts.Destroy,
				null,
				1193134587400234,
				false
			]
,			[
				3,
				cr.plugins_.Audio.prototype.acts.Play,
				null,
				1277526112597262,
				false
				,[
				[
					2,
					["finalmision",false]
				]
,				[
					3,
					0
				]
,				[
					0,
					[
						0,
						0
					]
				]
,				[
					1,
					[
						2,
						""
					]
				]
				]
			]
,			[
				0,
				cr.plugins_.WebStorage.prototype.acts.StoreLocal,
				null,
				689544270273939,
				false
				,[
				[
					1,
					[
						2,
						"vidas1"
					]
				]
,				[
					7,
					[
						10,
						[
							2,
							""
						]
						,[
							5,
							[
								23,
								"vidas"
							]
							,[
								0,
								1
							]
						]
					]
				]
				]
			]
,			[
				102,
				cr.plugins_.Sprite.prototype.acts.SetAnim,
				null,
				245962034851438,
				false
				,[
				[
					1,
					[
						2,
						"boom"
					]
				]
,				[
					3,
					1
				]
				]
			]
,			[
				-1,
				cr.system_object.prototype.acts.Wait,
				null,
				7051594481055222,
				false
				,[
				[
					0,
					[
						1,
						3
					]
				]
				]
			]
,			[
				102,
				cr.plugins_.Sprite.prototype.acts.Destroy,
				null,
				1994215634535227,
				false
			]
,			[
				-1,
				cr.system_object.prototype.acts.Wait,
				null,
				230046554951261,
				false
				,[
				[
					0,
					[
						1,
						3
					]
				]
				]
			]
,			[
				167,
				cr.plugins_.Sprite.prototype.acts.Destroy,
				null,
				4720784384048565,
				false
			]
,			[
				79,
				cr.plugins_.Sprite.prototype.acts.SetVisible,
				null,
				3068197067479236,
				false
				,[
				[
					3,
					1
				]
				]
			]
,			[
				-1,
				cr.system_object.prototype.acts.Wait,
				null,
				9618812409237488,
				false
				,[
				[
					0,
					[
						1,
						3
					]
				]
				]
			]
,			[
				169,
				cr.plugins_.Sprite.prototype.acts.SetVisible,
				null,
				1418463670091043,
				false
				,[
				[
					3,
					1
				]
				]
			]
,			[
				3,
				cr.plugins_.Audio.prototype.acts.Play,
				null,
				5196533197604574,
				false
				,[
				[
					2,
					["finalmision",false]
				]
,				[
					3,
					0
				]
,				[
					0,
					[
						0,
						0
					]
				]
,				[
					1,
					[
						2,
						""
					]
				]
				]
			]
,			[
				137,
				cr.plugins_.Text.prototype.acts.SetVisible,
				null,
				5986990206092367,
				false
				,[
				[
					3,
					1
				]
				]
			]
,			[
				137,
				cr.plugins_.Text.prototype.acts.SetText,
				null,
				1920223185412702,
				false
				,[
				[
					7,
					[
						10,
						[
							2,
							"SCORE :"
						]
						,[
							23,
							"score"
						]
					]
				]
				]
			]
,			[
				-1,
				cr.system_object.prototype.acts.Wait,
				null,
				7146038152748077,
				false
				,[
				[
					0,
					[
						1,
						3
					]
				]
				]
			]
,			[
				-1,
				cr.system_object.prototype.acts.GoToLayout,
				null,
				946687480315028,
				false
				,[
				[
					6,
					"splash"
				]
				]
			]
			]
		]
,		[
			0,
			null,
			false,
			null,
			5077098890329252,
			[
			[
				6,
				cr.plugins_.Sprite.prototype.cnds.OnCollision,
				null,
				0,
				false,
				false,
				true,
				6190297700548853,
				false
				,[
				[
					4,
					76
				]
				]
			]
			],
			[
			[
				21,
				cr.plugins_.Text.prototype.acts.SetText,
				null,
				6656265194389135,
				false
				,[
				[
					7,
					[
						10,
						[
							2,
							""
						]
						,[
							5,
							[
								23,
								"vidas"
							]
							,[
								0,
								25
							]
						]
					]
				]
				]
			]
,			[
				6,
				cr.behaviors.scrollto.prototype.acts.Shake,
				"ScrollTo",
				7563262112483924,
				false
				,[
				[
					0,
					[
						0,
						20
					]
				]
,				[
					0,
					[
						1,
						0.5
					]
				]
,				[
					3,
					0
				]
				]
			]
,			[
				3,
				cr.plugins_.Audio.prototype.acts.Play,
				null,
				1144541980797416,
				false
				,[
				[
					2,
					["uy",false]
				]
,				[
					3,
					0
				]
,				[
					0,
					[
						0,
						0
					]
				]
,				[
					1,
					[
						2,
						""
					]
				]
				]
			]
,			[
				0,
				cr.plugins_.WebStorage.prototype.acts.StoreLocal,
				null,
				7671876378780711,
				false
				,[
				[
					1,
					[
						2,
						"vidas1"
					]
				]
,				[
					7,
					[
						10,
						[
							2,
							""
						]
						,[
							5,
							[
								23,
								"vidas"
							]
							,[
								0,
								25
							]
						]
					]
				]
				]
			]
			]
		]
,		[
			0,
			null,
			false,
			null,
			5789623308513718,
			[
			[
				6,
				cr.plugins_.Sprite.prototype.cnds.OnCollision,
				null,
				0,
				false,
				false,
				true,
				9155754466858244,
				false
				,[
				[
					4,
					98
				]
				]
			]
			],
			[
			[
				21,
				cr.plugins_.Text