$(document).ready(function()
{	var CollectionMap=[];
	var CollectionColors=[
				{
					color:"#F7464A",
					highlight: "#FF5A5E",
				},
				{
					
					color: "#46BFBD",
					highlight: "#5AD3D1"
					
				},
				{
					
					color: "#FDB45C",
					highlight: "#FFC870"
					
				},
				{
					
					color: "#949FB1",
					highlight: "#A8B3C5"
					
				},
				{
					
					color: "#4D5360",
					highlight: "#616774",
					
				}

	
	];
	var pieData = new Array();
	var url = 'http://www.corsproxy.com/webserver2.ineter.gob.ni/geofisica/sis/events/nicaragua.local';
	$('.preload').hide();
	DownloadFromINETER(url);
	
	$("#btnlastquakes" ).click(function()
	{	$('#contentEarthqueaks').show();
		$('#map').addClass('hideMap');
		$('#aboutApp').hide();
	    $( ".subtitulo" ).replaceWith( '<h2 class="subtitulo">&Uacuteltimos sismos registrados por INETER</h2>');
		DownloadFromINETER(url);
	});	
	
	$("#btnChart" ).click(function()
	{
		$('#map').addClass('hideMap'); 
		$('#listEarthqueaks').html('');
		$('#contentEarthqueaks').hide();
		$('#aboutApp').hide();
		$( ".subtitulo" ).replaceWith( '<h2 class="subtitulo">Sismos de mayor Magnitud registrados por INETER</h2>');
		var ctx = document.getElementById("chart-area").getContext("2d");
						ctx.textAlign='center';
						navigator.mypie=new Chart(ctx).Pie(pieData);
						
						//var ctx = document.getElementById("chart-area").getContext("2d");
				//navigator.myDoughnut = new Chart(ctx).Doughnut(pieData, {responsive : true});
	});	
	
	$("#btnlocation").click(function()
	{	 $('#listEarthqueaks').html('');
		 $('#contentEarthqueaks').hide();
		 $('#aboutApp').hide();
		 $('#map').removeClass('hideMap');
		$( ".subtitulo" ).replaceWith( '<h2 class="subtitulo">Mapa de sismos registrados por INETER</h2>' );
		AddMaps();
	});
	
	$("#btn-aboutApp").click(function()
	{	 $('#listEarthqueaks').html('');
		 $('#contentEarthqueaks').hide();
		 $('#map').addClass('hideMap');
		 $('#aboutApp').show();
		$( ".subtitulo" ).replaceWith( '<h2 class="subtitulo">Informaci&oacuten</h2>' );
	
	});
	function DownloadFromINETER(uri)
	{
		if(navigator.onLine)
		{
			$.ajax({
						type: 'get',
						url: uri,
						beforeSend: function() { $('.preload').show(); },
						timeout: 10000,
						error: function(xhr, status, error) { alert('Error: '+ xhr.status+ ' - '+ error); $('.preload').hide(); }, 
						dataType: 'text',
						success: function(response) {
						$('.preload').hide();
						var lines = response.trim().split(/\r?\n/);
						lines.pop();
						var regEx = /(\d{2}\/\d{2}\/\d{2})\s{1,}(\d{2}:\d{2}:\d{2})\s{1,}(\d{1,}.\d{1,}[A-Z]{1})\s{1,}(\d{1,}.\d{1,}[A-Z]{1})\s{1,}(\d{1,}.\d{1,})\s{1,}(\d{1,}.\d{1,}[A-Z]{2})\s{1,}(.*)/g;
						lines.forEach( function( line ){
						var parseLine = line.replace( regEx, "$1|$2|$3|$4|$5KM|$6|$7" );
						var parts = parseLine.split( "|" );
						
						$('#listEarthqueaks').append('<li><table><tr><td><table cellpadding="0" cellspacing="0" border="0" style="margin-top:5px; font-size:11px;"><tr><td style="padding-right:4px"><strong>Lugar:</strong></td><td class="point2">'+parts[6].trim()+'</td></tr><tr><td style="padding-right:4px"><strong>Magnitud:</strong></td><td class="point2">'+parts[5]+'</td></tr><tr><td style="padding-right:4px"><strong>Profundidad:</strong></td><td class="point2">'+parts[4]+'</td></tr><tr><td style="padding-right:4px"><strong>Coordenadas:</strong></td><td class="point2">'+'<strong>Latidud: </strong>'+parts[2]+' ; '+'<strong>Longitud: </strong>'+parts[3]+'</td></tr><tr><td style="padding-right:4px"><strong>Fecha Hora:</strong></td><td class="point2">'+parts[0].replace(/(\d{2})\/(\d{2})\/(\d{2})/, new Date().getFullYear() + "/$2/$3" )+' '+parts[1]+'</td></tr></table></td></tr></table></li>');
							
						var obj={
							"location": parts[6].trim(),
							"lat": parts[2].replace(/[^0-9\.]+/g, ""),
							"longf":parts[3].replace(/[^0-9\.]+/g, "")*-1,
							"mag":parts[5].replace(/[^0-9\.]+/g, "")
							
						   }
						   Array.prototype.orderByNumber=function(p,s){if(s!=-1&&s!=1)s=1;this.sort(function(a,b){return(a[p]-b[p])*s})}
						   CollectionMap.push(obj);
						   
						

					
						});
							CollectionMap.orderByNumber('mag',-1);
							for (i = 0; i <=4; i++){
									var chartobj={
										"value": parseInt(CollectionMap[i].mag),
										"color":CollectionColors[i].color,
										"highlight":CollectionColors[i].highlight,
										"label":CollectionMap[i].location
									
									}
									pieData.push(chartobj);
									
									
			
							}
							
						  
						}
						
			
				  });
		}//if
		else{
			alert( 'Requiere conexin a Internet' )
		}// else
	
	}//funcion

	function AddMaps()
{
	//Set Google Map options
	var options = { 
    zoom : 5, 
    mapTypeId : google.maps.MapTypeId.ROADMAP,
	zoomControl: true,
	mapTypeControlOptions: {
      style: google.maps.MapTypeControlStyle.DROPDOWN_MENU
    },
    zoomControl: true,
    zoomControlOptions: {
        style: google.maps.ZoomControlStyle.LARGE,
        position: google.maps.ControlPosition.LEFT_CENTER
    }
    };

  var $content = $("#map");

  //Set the height of the div containing the Map to rest of the screen
  $content.height(screen.height - 50);
  
  //Display the Map
  var map = new google.maps.Map ($content[0], options);
  var infowindow = new google.maps.InfoWindow(); 
    var marker, i;
    var bounds = new google.maps.LatLngBounds();
	for (i = 0; i < CollectionMap.length; i++)
	{
		 var pos = new google.maps.LatLng(CollectionMap[i].lat, CollectionMap[i].longf);
		 
        bounds.extend(pos);
        marker = new google.maps.Marker({
            position: pos,
			animation: google.maps.Animation.DROP,
            map: map
        });
		
		google.maps.event.addListener(marker, 'click', (function(marker, i) {
				return function() {
                infowindow.setContent(CollectionMap[i].location);
                infowindow.open(map, marker);
                                  }
                                    
    })(marker, i));
	 map.fitBounds(bounds);
	}
}
});

function errorHandler(error){
	  alert("Error while retrieving current position. Error code: " + error.code + ",Message: " + error.message);
}