var isFirefoxOS = true;
var engineRoot="";
var soundRoot="";	

var controllersFound=0;
var displayW=320;
var displayH=480;
var lowDisplayW=160;
var lowDisplayH=240;

 function SoundPool(channelCount) {
	this.useSound=false;
	this.extension='.ogg';
	this.channelCount=channelCount;
	
	// init our pool variables
	this.soundCount=0;
	this.successCount = 0;
	this.errorCount = 0;  
	this.soundList={};
	this.useAudioContext=true;
	
	// check support for OGG or MP3, else we bail out
	this.extension='.ogg';
   	if (!document.createElement('audio').canPlayType('audio/ogg')) {
   		this.extension='.mp3';
   		if (!document.createElement('audio').canPlayType('audio/mpeg')) return; 
   	}

   		
	try{
		this.audioContext = new AudioContext();
	}catch(e) {
		try{
			this.audioContext = new webkitAudioContext();
		}catch(e) {
			// simple <audio> tag, crude but it works in most of these cases
			if (document.createElement('audio').canPlayType) {

				this.useAudioContext=false;
				this.audiochannels = new Array();
				for (i=0;i<channelCount;i++) {
					this.audiochannels[i] = new Array();
					this.audiochannels[i]['channel'] = new Audio();	// create a new audio object
					this.audiochannels[i]['finished'] = -1;			// expected end time for this channel
				}
				
				this.currentChannel=-1;	
			} else {
				return;
			}
		}
	}

	this.useSound=true;
}



SoundPool.prototype.load=function(path,soundid) {
	if (!this.useSound) return;
	this.soundCount++;
	
	path+=this.extension;

	
	if (this.useAudioContext) {
	
		var soundpoolself=this;
		var loadrequest = new XMLHttpRequest();
			loadrequest.open("GET", path, true);
			loadrequest.responseType = "arraybuffer";
			try {
				loadrequest.send();
			} catch (err) {
				console.log("ERROR LOADING FILE", path);
			}
			
			loadrequest.onload = function() {
				  soundpoolself.audioContext.decodeAudioData(loadrequest.response, function onSuccess(decodedBuffer) {
				    // Decoding was successful, do something useful with the audio buffer
				    soundpoolself.soundList[soundid]=decodedBuffer;
				    soundpoolself.successCount++;
				  }, function onFailure() {
				    alert("Decoding the audio buffer failed");
				    soundpoolself.errorCount++;
				  });
			
				//soundpoolself.audioContext.createBuffer(); //loadrequest.response, false);
				//soundpoolself.successCount++;
			};
	
		// keep track of failed loads
		//loadrequest.onerror = function() {
			//soundpoolself.errorCount++;
		//};
//		loadrequest.send();
	} else {
		var snd=new Audio();
        var soundpoolself=this;
        
        snd.addEventListener("canplaythrough", 
        	function() {
            	soundpoolself.successCount += 1;
        	}, 
        	false);
        
        snd.addEventListener("error", 
        	function() {
        		soundpoolself.errorCount += 1;
    		}, 
    		false);
    	
    	snd.src=path;
		this.soundList[soundid]=snd;	
	}
}

SoundPool.prototype.getTotal = function() {
	return this.soundCount-1;
}

SoundPool.prototype.getDone = function () {
	return (this.successCount + this.errorCount);
}


SoundPool.prototype.isDone = function() {
    return (this.soundCount <= this.successCount + this.errorCount);
}



SoundPool.prototype.playSound=function(soundid, loop) {
	if (!this.useSound || !this.soundList[soundid]) return;

	if (this.useAudioContext) {
		
		var gainNode=this.audioContext.createGain() ? this.audioContext.createGain() : this.audioContext.createGainNode();
		var source=this.audioContext.createBufferSource();
		source.buffer = this.soundList[soundid];
		if (loop) source.loop="loop";

		source.connect(gainNode); 
		gainNode.connect(this.audioContext.destination);
		gainNode.gain.value=0.7;
		source.start(0);
		
	    return {
	      source: source,
	      gainNode: gainNode
	    };		
	} else {
	
		// find first available channel
		var foundChannel=false;
		this.currentChannel=0;
		while (!foundChannel  &&  this.currentChannel<this.audiochannels.length) {
			if (this.audiochannels[this.currentChannel]['channel']) {
				if (this.audiochannels[this.currentChannel]['channel'].src && !this.audiochannels[this.currentChannel]['channel'].ended) {
					this.currentChannel++;
				} else {
					 foundChannel=true;
				} 
			} else {
				foundChannel=true;
			}
		}
		
		if (foundChannel) {
			this.audiochannels[this.currentChannel]['channel'].src = this.soundList[soundid].src;
			this.audiochannels[this.currentChannel]['channel'].load();

			
			this.audiochannels[this.currentChannel]['channel'].play();
			if (loop) {
				this.audiochannels[this.currentChannel]['channel'].addEventListener('ended', 
					function() {
    					this.currentTime = 0;
    					this.play();
					}, false);
				//songLoop(this.audiochannels[this.currentChannel]['channel']) );
			}			

			
			return this.currentChannel;
		}
		return null;
	}
}
 
SoundPool.prototype.stopSound=function(soundid) {
	if (!this.useSound) return;
	if (!soundid) return;
	if (this.useAudioContext) {
		soundid.source.stop(0);
	} else {
		this.audiochannels[soundid]['channel'].removeEventListener('ended',null);
		this.audiochannels[soundid]['channel'].pause();
		this.audiochannels[soundid]['channel'] = new Audio();
	}
}

SoundPool.prototype.setVolume=function(soundid,volume) {
	if (!this.useSound) return;
	if (this.useAudioContext) {
		soundid.gainNode.gain.value=volume;	
	} else {
		this.audiochannels[soundid]['channel'].volume=volume;
	}
}


function AssetManager() {
	this.successCount = 0;
	this.errorCount = 0;  
	this.cache = {};
	this.downloadQueue = [];
	this.resourceRoot="";
}

AssetManager.prototype.queueDownload = function(path) {
    this.downloadQueue.push(path);
}

AssetManager.prototype.setRoot = function (res) {
	this.resourceRoot=res;
}

AssetManager.prototype.downloadAll = function(downloadCallback) {
	if (this.downloadQueue.length === 0) {
		downloadCallback();
  	}
  	
    for (var i = 0; i < this.downloadQueue.length; i++) {
        var path = this.downloadQueue[i];
        var img = new Image();
        var that = this;
        img.addEventListener("load", function() {
            that.successCount += 1;
			if (that.isDone()) {
        		downloadCallback();
    		}            
        }, false);
        img.addEventListener("error", function() {
        	that.errorCount += 1;
			if (that.isDone()) {
        		downloadCallback();
    		}        	
    	}, false);
    	
        img.src = this.resourceRoot+path;
        this.cache[path] = img;
    }
}

AssetManager.prototype.getTotal = function() {
	return this.downloadQueue.length-1;
}

AssetManager.prototype.getDone = function () {
	return (this.successCount + this.errorCount);
}

AssetManager.prototype.isDone = function() {
    return (this.downloadQueue.length <= this.successCount + this.errorCount);
}


AssetManager.prototype.getAsset = function(path) {
    return this.cache[path];
}
var frameRate = 0;
var canvas;
var lastTime;


var isXperiaPlay=true;
var isMoga=false;
var useMultiFactor = 0;
var keyBoardOut = true;
var isTouchBase = false;
var isFirefoxOS = true;

var GameState;	

var loopStart;
var loopEnd;
var loopPause;
var secondPassed=false;

var upPressed;
var upLocked;
var downPressed;
var downLocked;
var rightPressed;
var rightLocked;
var leftPressed;
var leftLocked;
var actionButton1;
var actionButton1Locked;
var actionButton2;
var actionButton2Locked;

var pl2_upPressed;
var pl2_upLocked;
var pl2_downPressed;
var pl2_downLocked;
var pl2_rightPressed;
var pl2_rightLocked;
var pl2_leftPressed;
var pl2_leftLocked;
var pl2_actionButton1;
var pl2_actionButton1Locked;
var pl2_actionButton2;
var pl2_actionButton2Locked;


var soundButton;
var soundButtonLocked;
var musicButton;
var musicButtonLocked;

var backPressed=false;
var backLocked=false;

var worldTicks;

// touch stuff
var mTouch = [];
var mTouchX = new Array(25);
var mTouchY = new Array(25);
var mTouchID = new Array(25);
var touchX=-1;
var touchY=-1;
var touched=false;
var touchReleased=true;


// tilt
var TiltXSpeed;
var TiltYSpeed;

var canvas;
var ctx;

window.requestAnimFrame = (function(){
  return  window.requestAnimationFrame       || 
          window.webkitRequestAnimationFrame || 
          window.mozRequestAnimationFrame    || 
          window.oRequestAnimationFrame      || 
          window.msRequestAnimationFrame     || 
          function( callback ){
            window.setTimeout(callback, 1000 / 60);
          };
})();
    
    
    
    
var params = {};

if (location.search) {
    var parts = location.search.substring(1).split('&');
    for (var i = 0; i < parts.length; i++) {
        var nv = parts[i].split('=');
        if (!nv[0]) continue;
        params[nv[0]] = nv[1] || true;
    }
}
    
 
function init() {
    canvas = document.getElementById('mycanvas');

	upPressed=false;
	upLocked=false;
	rightPressed=false;
	rightLocked=false;
	downPressed=false;
	downLocked=false;
	leftPressed=false;
	leftLocked=false;
	actionButton1=false;
	actionButton1Locked=false;
	actionButton2=false;
	actionButton2Locked=false;
	soundButton=false;
	soundButtonLocked=false;
	musicButton=false;
	musicButtonLocked=false;
	
 	worldTicks=0;
 	
 	
 	
    if (canvas.getContext){

        ctx = canvas.getContext('2d');
        
        // initialise our size
        if (isFirefoxOS) {
			useMultiFactor=0;
			drawableResource=engineRoot+"drawable/";
			
			canvas.width=lowDisplayW<<useMultiFactor;
			canvas.height=lowDisplayH<<useMultiFactor;
			
			ctx = canvas.getContext('2d');
		} else if (params.big && params.big==1) {
			useMultiFactor=2;
			drawableResource=engineRoot+"drawablex4/";
	
			canvas.width=lowDisplayW<<useMultiFactor;
			canvas.height=lowDisplayH<<useMultiFactor;
			
			ctx = canvas.getContext('2d');
		} else {
			useMultiFactor=1;
			drawableResource=engineRoot+"drawablex2/";
			
			canvas.width=lowDisplayW<<useMultiFactor;
			canvas.height=lowDisplayH<<useMultiFactor;
			
			ctx = canvas.getContext('2d');
		}	
		
        
        // Initialize game, before game start to call updates
        // This is function which you need to make every game!
        initGameEngine();
        
        
        
        // We need to initialize lastTime, so we don't get false delta value on first update
        lastTime = new Date().getTime();
        loopPause=new Date().getTime();
		loopStart = new Date().getTime();
        loopEnd=loopStart;

		runThread();

		// Setup events
        canvas.onmousemove = fw_mouseMove;
        canvas.onmousedown = fw_mouseDown;
        canvas.onmouseup = fw_mouseUp;    

		// reset touch
		touchX=-1;
		touchY=-1;
		touched=false;
		touchReleased=true;
		
		for (var i=mTouchX.length; --i>=0;) {
			mTouchX[i]=-1;
			mTouchY[i]=-1;
			mTouchID[i]=-1;
		}
		
		canvas.addEventListener('touchstart', function(event) {
			event.preventDefault();

			mTouch=event.touches;
			
			var pointerID;
			var touch;
			for (var i=0; i<event.touches.length; i++) {
//				pointerID=event.touches[i].identifier;
			    touch = event.touches[i];
			    
			    if (i==0) {
				    touchX=touch.pageX;
				    touchY=touch.pageY;
				    touched=true;
				}
							    
//			    mTouchX[pointerID]=touch.pageX;
//			    mTouchY[pointerID]=touch.pageY;
			}			
		}
		, false);

		
		canvas.addEventListener('touchmove', function(event) {
			event.preventDefault();
			
			mTouch=event.touches;
			
			var pointerID;
			var touch;

			for (var i=0; i<event.touches.length; i++) {
//				pointerID=event.touches[i].identifier;
			    touch = event.touches[i];
			    
			    if (i==0) {
				    touchX=touch.pageX;
				    touchY=touch.pageY;
				    touched=true;
				}
							    
//			    mTouchX[pointerID]=touch.pageX;
//			    mTouchY[pointerID]=touch.pageY;
			}
			
		}
		, false);
		
		canvas.addEventListener('touchend', function(event) {
			event.preventDefault();
			
			mTouch=event.touches;
/*
			var pointerID;
			var touch;

			for (var i=0; i<event.touches.length; i++) {
				pointerID=event.touches[i].identifier;
			    
			    mTouchX[pointerID]=-1;
			    mTouchY[pointerID]=-1;
			}
*/			
			touchX=-1;
			touchY=-1;
			touchReleased=true;
		}
		, false);
		
		
		
		if (window.DeviceOrientationEvent) {
		  window.addEventListener('devicemotion', function(event) {
		  	var accelZ = event.accelerationIncludingGravity.z;
		  	var accelX = event.accelerationIncludingGravity.x;
		  	var accelY = event.accelerationIncludingGravity.y;
  		
  			var facingUp = -1;
  			if (accelZ > 0) {
    			facingUp = +1;
  			}
  		
			// Convert the value from acceleration to degrees acceleration.x|y is the 
			// acceleration according to gravity, we'll assume we're on Earth and divide 
			// by 9.81 (earth gravity) to get a percentage value, and then multiply that 
			// by 90 to convert to degrees.                                
			TiltXSpeed = Math.round(((accelX) / 9.81) * 90)*facingUp;
			TiltYSpeed = Math.round(((accelY + 9.81) / 9.81) * 90 * facingUp);		    
		    
		  }, false);
		} else {
			alert("no tilt");
		}
		
		
    } else {
        alert('You need HTML5 compatible browser to see this demo!.. try Google Chrome ');
    }
}







// quick function to get random numbers easily
function getRandom(val) {
	var rand_no = Math.floor(val*Math.random()) ;
	return rand_no;
}

function convertToRadians(degree) {
	return degree*(Math.PI/180);
}

function runThread() {
	requestAnimFrame(runThread);

    loopEnd = new Date().getTime();
	if (loopEnd-loopStart<24) return;

    var currTime = new Date().getTime();
    lastTime = currTime;
    
    loopStart = new Date().getTime();
    
    if (GameState==INGAME) GameLoop();
    else LogicLoop();
    
    worldTicks++;
    if (worldTicks>1000) worldTicks-=1000;

	// prerender copy buffer to the screen
	//ctx.drawImage(preCanvas, 0, 0, 160, 240, 0,0, 320, 480);

	if (loopEnd-loopPause>1000) {
		secondPassed=true;
		loopPause=loopEnd;
	}

}



var mouseX=0;
var mouseY=0;

var mouseButton;


	
function fw_mouseMove(evt)
{
    // We calculate mouse canvas position
    mouseX = evt.clientX - canvas.offsetLeft;
    mouseY = evt.clientY - canvas.offsetTop;
}
 
function fw_mouseDown(evt)
{
    // We calculate mouse canvas position
    mouseX = evt.clientX - canvas.offsetLeft;
    mouseY = evt.clientY - canvas.offsetTop;
 
    touchX=(mouseX); //>>useMultiFactor);
    touchY=(mouseY); //>>useMultiFactor);
    
    // Button is pressed down
    switch(evt.which) {
        case 1 : mouseButton |= 0x01;    // left
            break;
        case 2 : mouseButton |= 0x02;    // middle
            break;
        case 3 : mouseButton |= 0x04;    // right
            break;
    }
 
}
 
function fw_mouseUp(evt)
{
    // We calculate mouse canvas position
    mouseX = evt.clientX - canvas.offsetLeft;
    mouseY = evt.clientY - canvas.offsetTop;
 
    touchX=-1;
    touchY=-1;
 
    // Button released
    switch(evt.which) {
        case 1 : mouseButton &= 0x06;
            break;
        case 2 : mouseButton &= 0x05;
            break;
        case 3 : mouseButton &= 0x03;
            break;
    }
    
    touchReleased=true;
 
}






function onKeyDown(evt){
	switch (evt.keyCode) {
		case 27:
			backPressed=true;
			evt.preventDefault();
			return false; 
		break;
		
		case 32: // SPACE used as alternate to action button
			actionButton2=true;
			evt.preventDefault(); 
			return false; 
		break;		
		
		case 38: 
			upPressed=true; 
			evt.preventDefault();
			return false; 
		break;
		case 40: 
			downPressed=true;
			evt.preventDefault();
			return false; 
		break;
		case 37: 
			leftPressed=true;
			evt.preventDefault(); 
			return false; 
		break;
		case 39: 
			rightPressed=true;
			evt.preventDefault(); 
			return false; 
		break;
	
		case 77: // m
			musicButton=true;
			evt.preventDefault();
			return false;
		break;	
		
		case 83: // s
			soundButton=true;
			evt.preventDefault();
			return false;
		break;
		
		case 88: 
			actionButton2=true;
			evt.preventDefault(); 
			return false; 
		break; // x
		
		
		case 90: 
			actionButton2=true;
			evt.preventDefault(); 
			return false; 
		break; // z
		
		
	}
}


function onKeyUp(evt){
	switch (evt.keyCode) {
		case 27:
			backPressed=false;
			backLocked=false;
			evt.preventDefault();
			return false; 
		break;
		
		case 32: // SPACE used as alternate to action button
			actionButton2=false;
			actionButton2Locked=false;
			evt.preventDefault(); 
			return false; 
		break;		
		
	
		case 38: 
			upPressed=false;
			upLocked=false;
			evt.preventDefault();
			return false; 
		break;
		
		case 40: 
			downPressed=false; 
			downLocked=false;
			evt.preventDefault();
			return false;
		break;
		
		case 37: 
			leftPressed=false; 
			leftLocked=false;
			evt.preventDefault();
			return false;
		break;
		
		case 39: 
			rightPressed=false;
			rightLocked=false;
			evt.preventDefault();
			return false; 
		break;
		
		
		case 77: // m
			musicButton=false;
			musicButtonLocked=false;
			evt.preventDefault();
			return false;
		break;
		
		case 83: // s
			soundButton=false;
			soundButtonLocked=false;
			evt.preventDefault();
			return false;
		break;
		
		case 88: // x
			actionButton2=false;
			actionButton2Locked=false;
			evt.preventDefault();
			return false;
		break;

		case 90: // z
			actionButton2=false;
			actionButton2Locked=false;
			evt.preventDefault();
			return false;
		break;


	}
}


function setAlpha(alpha) {
	ctx.globalAlpha=(1.0/255)*alpha;
}

// quick code to render part of an image (aka Sprites)
function renderAtPoint(imageObject, x, y) {
	ctx.drawImage(imageObject,x<<useMultiFactor,y<<useMultiFactor,imageObject.width, imageObject.height);
//	ctx.drawImage(imageObject,x,y,imageObject.width, imageObject.height);
}

function renderSubImageAtPoint(imageObject, x, y, sourceX, sourceY, width, height)
{
    ctx.drawImage(imageObject, sourceX<<useMultiFactor, sourceY<<useMultiFactor, width<<useMultiFactor, height<<useMultiFactor,  x<<useMultiFactor, y<<useMultiFactor, width<<useMultiFactor,height<<useMultiFactor);
//    ctx.drawImage(imageObject, sourceX, sourceY, width, height,  x, y, width,height);
}


function drawRect(x, y, w, h, fillColor) {
    ctx.fillStyle = fillColor;
    ctx.fillRect(x<<useMultiFactor, y<<useMultiFactor, (w-x)<<useMultiFactor, (h-y)<<useMultiFactor);
}


// [r, g, b] color value 0 - 255
// [a] alpha value 0.0 - 1.0
function makeRGBA(r, g, b, a) {
	a=(1.0/255)*a;
    return "rgba(" + r + "," + g + "," + b + "," + a + ")";
}


function clipRect(x,y,w,h) {

	ctx.save();
	ctx.beginPath();
	ctx.rect(x<<useMultiFactor,y<<useMultiFactor,((w-x)<<useMultiFactor),((h-y)<<useMultiFactor));
	ctx.clip();
	
}

function endClip() {
	ctx.restore();
	ctx.beginPath();
	ctx.rect(0,0,(lowDisplayW<<useMultiFactor),(lowDisplayH<<useMultiFactor));
	ctx.clip();
}




// used for prerendering
var renderToCanvas = function (width, height, renderFunction) {
    var buffer = document.createElement('canvas');
    buffer.width = width;
    buffer.height = height;
    renderFunction(buffer.getContext('2d'));
    return buffer;
};	

function setScale(cx, cy, h, v) {
	ctx.save();
	ctx.translate( cx<<useMultiFactor,cy<<useMultiFactor);
	ctx.scale( h, v);
	ctx.translate(-(cx<<useMultiFactor),-(cy<<useMultiFactor));
}

function endScale() {
	ctx.restore();
}
function PlayerProfile() {

	this.useMusic=true;
	this.useSFX=true;
	
	// keep track of whatsnew info
	this.highScore=0;

	this.heroSquadUnlocked = new Array(32);
	
	this.loadSettings=function() {
		if (localStorage["sketchbook"]!= null) {
			var myData=JSON.parse(localStorage["sketchbook"]);
			
			this.useMusic=myData.usemusic;
			this.useSFX=myData.usesfx;
		}
		
		if (localStorage["sketchsquad"]!=null) this.heroSquadUnlocked=JSON.parse(localStorage['sketchsquad']);
		
		this.heroSquadUnlocked[0]=true;
	}
	

	this.saveSettings=function() {
		localStorage["sketchbook"]=JSON.stringify({
					"usemusic":this.useMusic , 
					"usesfx":this.useSFX 
					});
	
		localStorage["sketchsquad"]=JSON.stringify(this.heroSquadUnlocked);
	}

}
function Bullets() {

	Bullets.bTRIGGER = 1,
	Bullets.bLASER = 2,
	Bullets.bBOMB = 3,
	Bullets.bLASERV = 4;
	
	// Bullet owner types
	Bullets.OWNER_PLAYER = 0,
	Bullets.OWNER_MONSTER = 1,
	Bullets.OWNER_ANYONE = 2;
	

	this.myType=0;
	this.subType=0;
	this.aiState=0;
	this.aiCountDown=0;
	this.bOwner=0;
	this.died=false;
	this.energy=0;

	this.floatX=0;
	this.floatY=0;
	this.x=0;
	this.y=0;
	this.xSpeed=0;
	this.ySpeed=0;
	this.ySpeedInc=0;
	this.xSpeedInc=0;
	this.targetY=0;
	this.targetX=0;
	
	this.rotation=0;
	this.w=0;
	this.h=0;
	this.xOffset=0;
	this.yOffset=0;
	this.animDelay=0;
	this.SpriteSet=0;
	this.visible=true;
	this.alpha=0;
	
	this.deleted=true;
	
	this.init=function( sOwner,  sx,  sy,  sType,  sSubType,  mtargetX,  mtargetY) {
		this.deleted=false;
		
		this.died=false;
		
		this.SpriteSet=1;
		this.bOwner=sOwner;
		
		this.rotation=0;
		this.x=sx;
		this.y=sy;
		this.xSpeed=0;
		this.ySpeed=0;
		this.energy=1;
		
		this.myType=sType;
		this.subType=sSubType;
		this.visible=true;
		
		this.alpha=255;
		
		switch (this.myType) {
			case Bullets.bTRIGGER:
				this.w=160;
				this.h=248;
				this.visible=false;
				
				this.y-=(this.h>>1);
				
				this.aiCountDown=4;
				this.energy=1+this.subType;
			break;
			
			
			case Bullets.bLASER:
				this.w=11;
				this.h=5;
				this.xOffset=22;
				this.yOffset=0;
				
				if (this.subType>0) this.xSpeed=48;
				else this.xSpeed=-48;
			break;
			
			case Bullets.bBOMB:
				this.w=16;
				this.h=16;
				
				this.aiState=1;
				if (this.mtargetX>0) {
					this.xSpeed=64;
				} else {
					this.xSpeed=-64;
				}
				this.SpriteSet=0;
				this.xOffset=64;
				this.yOffset=48;
				
				this.ySpeed=-96;
			break;
			
			case Bullets.bLASERV:
				this.w=5;
				this.h=11;
				this.xOffset=23;
				this.yOffset=5;

				this.ySpeed=64;
			break;
			
		}
		
		this.floatX=this.x<<4;
		this.floatY=this.y<<4;
	}

	
	
	
	
	this.update=function( myPlayer, myWorld) {
		
		hitPlayer=false;
		
		if (this.bOwner!=Bullets.OWNER_PLAYER && myPlayer.x+14>=this.x && myPlayer.x+2<this.x+this.w && myPlayer.y+14>this.y && myPlayer.y+2<this.y+this.h) hitPlayer=true;


		
		switch (this.myType) {
			case Bullets.bTRIGGER:
				if (this.aiCountDown>0) this.aiCountDown--;
				else {
					this.died=true;
				}
			break;
			
			case Bullets.bLASER:
				this.floatX+=this.xSpeed;
				this.floatY+=this.ySpeed;

				this.x=this.floatX>>4;
				this.y=this.floatY>>4;
		
				if (this.xSpeed>0 && this.xSpeed<128) this.xSpeed+=8;
				else if (this.xSpeed<0 && this.xSpeed>-128) this.xSpeed-=8;

				if (this.x<=-this.w<<1 || this.x>myWorld.displayW+48) this.died=true;
				
				if (hitPlayer) {
					myPlayer.electrify();
				}
			break;
			
			case Bullets.bBOMB:
				this.floatX+=this.xSpeed;
				this.floatY+=this.ySpeed;
				if (this.ySpeed<80) this.ySpeed+=16;
				this.y=this.floatY>>4;
				this.x=this.floatX>>4;
				
				if (this.y>myWorld.worldOffsetY+myWorld.displayH) this.died=true;
				
				if (this.xSpeed>0) this.rotation+=16;
				else if (this.xSpeed<0) this.rotation-=16;
			break;
			
			
			case Bullets.bLASERV:
				this.floatY+=this.ySpeed;

				this.x=this.floatX>>4;
				this.y=this.floatY>>4;
		
				if (hitPlayer) {
					myPlayer.electrify();
				}
				
				if (this.y>myWorld.worldOffsetY+myWorld.displayH) this.died=true;
			break;
			
		}
		
		
		
	}
	


	this.collidesWith=function( myMonster) {
		collide=false;

		if (this.bOwner!=Bullets.OWNER_ANYONE && this.bOwner==Bullets.OWNER_MONSTER) return false;
		var cw=this.x+this.w;
		var ch=this.y+this.h;
		
		if ((myMonster.x<=cw) && (myMonster.x+myMonster.w>=this.x) && (myMonster.y<=ch) && (myMonster.y+myMonster.h>=this.y)) collide=true;
		return collide;
	}	

	

}
window.addEventListener('load', init, false);
window.addEventListener('keydown', onKeyDown, false);
window.addEventListener('keyup', onKeyUp, false);


var MAXHEROES = 9;


var INLOADER = 1,
	INSPLASH = 2,
	INMENU = 3,
	INGAME = 4,

	INITMAP = 51,
	INPAUSE = 52,
	INCHARSELECT =53,
	INDIED = 54;
	
	var activePlayer=new PlayerProfile();

	// Preloader
	var myLoadManager = new AssetManager();
	
	
	var displayW=320;
	var displayH=480;
	var lowDisplayW=160;
	var lowDisplayH=240;


	// Collection of sprites (woohoo!)
	var sprites = new Array(32);
	var menuSelectedChar;
	var	statusBarY;
	var statusBarTarget;
	var currentHighScore;
	
	// linked lists for various level-stuff
	var fxList = new Array(512);
	var fxCount=0;
	var monsterList = new Array(256);
	var monsterCount=0;
	var bulletList = new Array(256);
	var bulletCount=0;
	var playerEcho = new Array(256);
	
	var digitsBoard = new Array(6);

	
	var myWorld = new TileMap();

	// world and player variables
	var myPlayer = new Player();
	
	// global used for drawing, calculating, etc
	var tx;
	var ty;



function initGameEngine() {
	initSounds();
	
	// set image root
	myLoadManager.setRoot(drawableResource);
	
	// preload our images
	myLoadManager.queueDownload('spl1.png');
	myLoadManager.queueDownload('spl2.png');
	
	myLoadManager.queueDownload('fx.png');
	myLoadManager.queueDownload('hints.png');
	myLoadManager.queueDownload('m01.png');
	myLoadManager.queueDownload('m02.png');
	myLoadManager.queueDownload('player.png');
	myLoadManager.queueDownload('playerbro.png');
	myLoadManager.queueDownload('playerbro2.png');
	myLoadManager.queueDownload('playercape1.png');
	myLoadManager.queueDownload('playercape2.png');
	myLoadManager.queueDownload('playerfem.png');
	myLoadManager.queueDownload('playerfem2.png');
	myLoadManager.queueDownload('playerfem3.png');
	myLoadManager.queueDownload('playerfem4.png');
	myLoadManager.queueDownload('t01.png');
	myLoadManager.queueDownload('uigame.png');
	
	
	myLoadManager.downloadAll(function() {});
	
	// generate our entity objects
	for (var i = fxList.length - 1; i >= 0; i--) fxList[i] = new FX();
	for (var i = monsterList.length - 1; i >= 0; i--) monsterList[i] = new Monster();
	for (var i = bulletList.length - 1; i >= 0; i--) bulletList[i] = new Bullets();
	for (var i = playerEcho.length - 1; i >= 0; i--) playerEcho[i] = new Player();
	
	
	activePlayer.loadSettings();
	GameState=INLOADER;
}






function LogicLoop() {
	touchX = -1;
	touchY = -1;
	if (mTouch[0]!=null && mTouch[0].pageX >= 0 && mTouch[0].pageY >= 0) {
		touchY = (lowDisplayH / 100) * ((100 / displayH) * mTouch[0].pageY);
		touchX = (lowDisplayW / 100) * ((100 / displayW) * mTouch[0].pageX);
	}

	switch (GameState) {
		case INLOADER:
			if (myLoadManager.isDone()) { // && mySoundPool.isDone()) {

				splashicn = myLoadManager.getAsset('spl1.png');
				splash = myLoadManager.getAsset('spl2.png');
				
				sprites[0] = myLoadManager.getAsset('player.png');
				sprites[1] = myLoadManager.getAsset('fx.png');
				sprites[2] = myLoadManager.getAsset('m01.png');
				sprites[3] = myLoadManager.getAsset('m02.png');
				
				sprites[5] = myLoadManager.getAsset('t01.png');
				sprites[6] = myLoadManager.getAsset('hints.png');
				
				sprites[7] = myLoadManager.getAsset('player.png');
				sprites[8] = myLoadManager.getAsset('playerfem.png');
				sprites[9] = myLoadManager.getAsset('playerbro.png');
				sprites[10] = myLoadManager.getAsset('playerfem2.png');
				sprites[11] = myLoadManager.getAsset('playercape1.png');
				sprites[12] = myLoadManager.getAsset('playerfem3.png');
				sprites[13] = myLoadManager.getAsset('playerbro2.png');
				sprites[14] = myLoadManager.getAsset('playercape2.png');
				sprites[15] = myLoadManager.getAsset('playerfem4.png');

				sprites[28] = myLoadManager.getAsset('uigame.png');
				
				splashFrame = 0;
				splashDone = false;
				splashAlpha = 0;
				splashY = 0;
				splashYSpeed = -8;
				GameState=INSPLASH;
				playSound('FX_SPLASH');
				
			} else {
				ctx.fillStyle = "#ffffff";
				ctx.fillRect(0,0,canvas.width,canvas.height);
				ctx.fillStyle = "#000000";
			}
		break;
		
		
		
		case INSPLASH:
			drawRect(0,0,displayW,displayH,makeRGBA(255,255,255,255));

			setAlpha(splashAlpha);

			if (!splashDone || splashAlpha < 255) {
				splashAlpha += 32;
				if (splashAlpha > 255)
					splashAlpha = 255;
			}

			if (!splashDone) {
				splashFrame += 16;
				if (splashFrame == 96) {
					splashFrame = 0;
					splashDone = true;
				}
			}

			// jump
			if (splashYSpeed < 6) splashYSpeed++;
			splashY += splashYSpeed;
			if (splashY >= 0) {
				splashY = 0;
				splashYSpeed = -(splashYSpeed >> 1);
			}

			// landscape calculations
			tx = (lowDisplayW >> 1) - 32;
			ty = ((lowDisplayH >> 1) - 48) + splashY;

			// render pixel
			renderSubImageAtPoint(splashicn, tx,ty, splashFrame<<2,0, 64,64);
			

			// render name
			tx = (lowDisplayW >> 1) - 61;
			ty = (lowDisplayH >> 1) + 30;
			renderSubImageAtPoint(splash,tx,ty,0,16,122,18);

			if (worldTicks > 48 && splashDone) {
				InitMenu();
				menuSelectedChar=1+getRandom(4);
			}
		
		break;
		
		
		
		
		case INMENU:
			ty=0;
			
			while (ty<lowDisplayH) {
				renderSubImageAtPoint(sprites[5], 0,ty, 0,0, 160,160);
				ty+=160;
			}

			ty=0;
			renderSubImageAtPoint(sprites[5], 0,ty, 0,160, 160,104);

			
			setAlpha(200);
			
			// sound fx
			tx=116;
			ty=162;
			if (!activePlayer.useSFX) {
				renderSubImageAtPoint(sprites[28], tx,ty, 54,10,17,22);
			} else {
				renderSubImageAtPoint(sprites[28], tx,ty, 54,10, 28,22);
			}
			if (touchReleased && touchX>=tx && touchY>=ty && touchX<=tx+64 && touchY<=ty+42) {
				touchReleased=false;
				activePlayer.useSFX=!activePlayer.useSFX;
				playSound('FX_CHOP');
			}
			
			
			// music
			tx=9;
			ty=176;
			if (!activePlayer.useMusic) {
				renderSubImageAtPoint(sprites[28], tx,ty, 63,53, 54,27);
			} else {
				tx-=7;
				ty-=16;
				renderSubImageAtPoint(sprites[28], tx,ty, 56,37, 66,43);
			}
			if (touchReleased && touchX>=tx && touchY>=ty && touchX<=tx+64 && touchY<=ty+42) {
				touchReleased=false;
				if (activePlayer.useMusic) stopBackground();
				activePlayer.useMusic=!activePlayer.useMusic;
				playBackground();					
				playSound('FX_CHOP');
			}
				
			
			// play
			tx=(lowDisplayW>>1)-32;
			ty=132;
			renderSubImageAtPoint(sprites[28], tx,ty, 93,119 ,63,14);
			
			if (touchReleased && touchX>=tx && touchY>=ty && touchX<=tx+54 && touchY<=ty+18) {
				touchReleased=false;
				playSound('FX_CHOP');
				
				if (activePlayer.heroSquadUnlocked[1]) {
					statusBarY=-48;
					GameState=INCHARSELECT;
				} else {
					stopBackground();
					
					// set as leader, and pick few random ones after that
					generateSquad(0);
					
					GameState=INITMAP;
				}
			}
			

			setAlpha(255);
			
			
			// topscore
			tx=1;
			ty=116;
			 //statusBarY+1;
			renderSubImageAtPoint(sprites[28], tx,ty, 0,72, 52,10);
			
			setDigits(activePlayer.highScore,digitsBoard);
			// render score
			tx=lowDisplayW-1-(6<<3);
			foundFirst=false;
			for (var i=0; i<6; i++) {
				renderSubImageAtPoint(sprites[28], tx,ty, digitsBoard[i]*8,0 ,8,10);
				tx+=8;
			}		
			
			// 
			tx=0;
			ty+=12;
			while (tx<lowDisplayW) {
				renderSubImageAtPoint(sprites[1], tx,ty, 6,14, 16,1);
				tx+=16;
			}
			
			// logo
			tx=(lowDisplayW>>1)-45;
			ty=statusBarY+2;
			
			renderSubImageAtPoint(sprites[28], tx,ty, 0,103, 89,32);
			
			
			if (statusBarY<statusBarTarget) {
				statusBarY+=(statusBarTarget-statusBarY)>>1;
			} else if (statusBarY>statusBarTarget) {
				statusBarY+=(statusBarTarget-statusBarY)>>1;
			}
			
			
			
			// F Like
			/*
			tx=1;
			ty=1;
			
			renderSubImageAtPoint(sprites[1], tx,ty, 148,78, 24,8);
			
			if (touchReleased && touchX>=tx && touchX<=tx+64 && touchY<=ty+24) {
				touchReleased=false;
				playSound('FX_CHOP');
				String url = "http://facebook.com/orangepixel";
				Intent i = new Intent(Intent.ACTION_VIEW);
				i.setData(Uri.parse(url));
				getParentActivity().startActivity(i);
			}
			*/
			
			
		break;
		
		
		

		case INITMAP:
			paused = false;
			destroyMap();
			initNewGame();
			GameState=INGAME;
			
			playBackground();
		break;
		
		
		case INPAUSE:
			touchX = -1;
			touchY = -1;
			if (mTouch[0]!=null && mTouch[0].pageX >= 0 && mTouch[0].pageY >= 0) {
				touchY = (lowDisplayH / 100) * ((100 / displayH) * mTouch[0].pageY);
				touchX = (lowDisplayW / 100) * ((100 / displayW) * mTouch[0].pageX);
			}
			
			tx=(lowDisplayW-16);
			ty=1;
			if (touchReleased && touchX>=8 && touchY<=ty+16) {
				touchReleased=false;
				paused=false;
				GameState=INGAME;
				playBackground();
			}
			
			renderScene();
			
			// play
			tx=8;
			ty=(lowDisplayH-64);
			renderSubImageAtPoint(sprites[28], tx,ty, 9,20, 37,17);
			if (touchReleased && touchX>=tx && touchY>=ty) {
				paused=false;
				GameState=INGAME;
				playBackground();
			}				

			
			// quit
			tx=(lowDisplayW-40);
			ty=lowDisplayH-64;
			renderSubImageAtPoint(sprites[1], tx,ty, 148,62, 31,16);
			if ((touchReleased && touchX>=tx && touchY>=ty) 
				|| (backPressed && !backLocked)) {
				if (backPressed) backLocked=true;
				else touchReleased=false;
				playSound('FX_CHOP');
				statusBarY=-48;
				GameState=INMENU;
			}				
		break;
		
		
		
		case INCHARSELECT:
			ty=0; //(160-myWorld.worldOffsetY%160);
			while (ty<lowDisplayH) {
				renderSubImageAtPoint(sprites[5], 0,ty, 0,0, 160,160);
				ty+=160;
			}

			tx=0;
			ty=statusBarY;
			renderSubImageAtPoint(sprites[28], tx,ty, 0,83, 160,20);
			
			if (statusBarY<statusBarTarget) {
				statusBarY+=(statusBarTarget-statusBarY)>>1;
			} else if (statusBarY>statusBarTarget) {
				statusBarY+=(statusBarTarget-statusBarY)>>1;
			}
			
			tx=(lowDisplayW>>1)-56;
			ty=36;
			for (var i=0; i<9; i++) {
				if (i>=MAXHEROES || !activePlayer.heroSquadUnlocked[i]) {
					renderSubImageAtPoint(sprites[1], tx+16,ty+16, 150,28, 16,16);
				} else {
					renderSubImageAtPoint(sprites[7+i], tx+16,ty+16, 48,0, 16,16);
				}
				
				renderSubImageAtPoint(sprites[1], tx+13,ty+12, 144,0, 21,24);
				
				if (i<MAXHEROES && activePlayer.heroSquadUnlocked[i] && touchReleased && touchX>=tx && touchY>=ty && touchX<=tx+32 && touchY<=ty+32) {
					touchReleased=false;
					playSound('FX_CHOP');
					
					stopBackground();
					
					// set as leader, and pick few random ones after that
					generateSquad(i);
					
					GameState=INITMAP;
					return;
				}
				
				tx+=32;
				if (tx>(lowDisplayW>>1)+16) {
					tx=(lowDisplayW>>1)-56;
					ty+=32;
				}
			}
			
			
			tx=(lowDisplayW-42);
			ty=lowDisplayH-64;
			renderSubImageAtPoint(sprites[28], tx,ty, 93,103, 39,16);
			if (touchReleased && touchX>=tx && touchY>=ty) {
				touchReleased=false;
				playSound('FX_CHOP');
				statusBarY=-48;
				GameState=INMENU;
			}
		break;
		
		
		case INDIED:
			if (myWorld.worldOffsetY<myWorld.worldOffsetYLowest) myWorld.worldOffsetYLowest=myWorld.worldOffsetY;

			
			myPlayer.update(myWorld);
			monsterUpdate();
			bulletUpdate();
			fxUpdate();

			if (myWorld.shakeCountDown>0) {
				myWorld.shakeCountDown--;
				myWorld.worldOffsetX=myCanvas.getRandom(8)-4;
				myWorld.worldOffsetY+=myCanvas.getRandom(4)-2;
			} else {
				myWorld.worldOffsetX=0;
			}
			
			
			renderScene();
			
			// render gameover
			tx=(lowDisplayW>>1)-21;
			ty=statusBarY;
			renderSubImageAtPoint(sprites[1], tx,ty, 0,36, 43,32);


			if (statusBarY<statusBarTarget) {
				statusBarY+=(statusBarTarget-statusBarY)>>1;
			} else if (statusBarY>statusBarTarget) {
				statusBarY+=(statusBarTarget-statusBarY)>>1;
			}
			
			if (myWorld.worldAge>0) myWorld.worldAge--;
			else {
				stopBackground();
				InitMenu();
			}
			
		break;

		
		
		
	}
}

 
 
 
function GameLoop() {
		touchX = -1;
		touchY = -1;
		if (mTouch[0]!=null && mTouch[0].pageX >= 0 && mTouch[0].pageY >= 0) {
			touchY = (lowDisplayH / 100) * ((100 / displayH) * mTouch[0].pageY);
			touchX = (lowDisplayW / 100) * ((100 / displayW) * mTouch[0].pageX);
		}
		
		tx=(lowDisplayW-16);
		ty=1;
		if (touchReleased && touchX>=8 && touchY<=ty+16) {
			touchReleased=false;
			initPauseMenu();
		}
		

		if (!myPlayer.isElectrified && !myPlayer.died) {
			if (TiltXSpeed>0.6) myPlayer.myDirection=1;
			else if (TiltXSpeed<-0.6) myPlayer.myDirection=-1;
			myPlayer.xSpeed=(TiltXSpeed*1.4);
		}
		
		if (touchReleased && touchX>0 && touchY>0) {
			myPlayer.actionPressed=true;
			touchReleased=false;
		}

		if (myWorld.worldOffsetY<myWorld.worldOffsetYLowest) myWorld.worldOffsetYLowest=myWorld.worldOffsetY;
		
		myWorld.worldOffsetY+=((myPlayer.y-160)-myWorld.worldOffsetY)>>2;
		if (myWorld.worldOffsetY>myWorld.worldOffsetYLowest+40) myWorld.worldOffsetY=myWorld.worldOffsetYLowest+40;
		else if (myWorld.worldOffsetY>0) myWorld.worldOffsetY=0;
		
		
		if (myWorld.shakeCountDown>0) {
			myWorld.shakeCountDown--;
			myWorld.worldOffsetX=myCanvas.getRandom(8)-4;
			myWorld.worldOffsetY+=myCanvas.getRandom(4)-2;
		} else {
			myWorld.worldOffsetX=0;
		}
		
		myWorld.worldAge++;
		
		while (myWorld.lastBlockY>myWorld.worldOffsetY-80) {
			addRow();
		}
		
		
		
		
		for (var i =255; --i>=0;) {
			playerEcho[i+1].clonePlayer(playerEcho[i]);
		}
		myPlayer.update(myWorld);
		playerEcho[0].clonePlayer(myPlayer);
		
		monsterUpdate();
		bulletUpdate();
		fxUpdate();

		
		if (myPlayer.doShootSound) {
			myPlayer.doShootSound=false;
			bulletAdd(Bullets.OWNER_PLAYER,Bullets.bBOMB,myPlayer.x,myPlayer.y-16,0,myPlayer.myDirection,0);
		}
		
		if (myPlayer.doHitSound) {
			myPlayer.doHitSound=false;
			if (myPlayer.isElectrified) playSound('FX_ZAP');
			else playSound('FX_HIT');
		}

		if (myPlayer.doJumpSound) {
			myPlayer.doJumpSound=false;
			playSound('FX_JUMP');
		}
		
		renderScene();
		

		
		if (myPlayer.died && myPlayer.diedCountDown==0) {
			if (myPlayer.extraChars[0]>-1) {
				myWorld.chapter++;
				fxAdd(0, myWorld.worldOffsetY+myWorld.displayH-64, FX.fCHAPTER, myWorld.chapter);
				// 2nd hero takes over!
				myPlayer.spriteIndex=7+myPlayer.extraChars[0];
				myPlayer.died=false;
				myPlayer.isElectrified=false;
				myPlayer.ySpeed=-196;
				myPlayer.invincable=48;
				// move all extra heroes one slot higher
				for (var i=1; i<32; i++) {
					myPlayer.extraChars[i-1]=myPlayer.extraChars[i];
				}
				myPlayer.extraChars[31]=-1;
				
				// v1.1.0
				for (var i=0; i<monsterList.length; i++) {
					if (!monsterList[i].deleted && !monsterList[i].died && monsterList[i].y>myWorld.worldOffsetY+myWorld.displayH) monsterList[i].deleted=true;
				}
				
				// v1.0.1
				monsterAdd(Monster.mPLATFORM,00,myWorld.worldOffsetY+(lowDisplayH-60), 2,0);
				monsterAdd(Monster.mPLATFORM,40,myWorld.worldOffsetY+(lowDisplayH-60), 2,0);
				monsterAdd(Monster.mPLATFORM,80,myWorld.worldOffsetY+(lowDisplayH-60), 2,0);
				monsterAdd(Monster.mPLATFORM,120,myWorld.worldOffsetY+(lowDisplayH-60), 2,0);
				
				// v1.1.0
				monsterAdd(Monster.mPLATFORM,-1,myWorld.worldOffsetY+(lowDisplayH-60)-48, 2,0);
			} else {
				initDied();
			}
		} else if (myPlayer.died && myPlayer.extraChars[0]==-1) {
			initDied();
		}
		
}



function destroyMap() {
		fxCount = 0;
		monsterCount = 0;
		bulletCount = 0;

		for (var i = fxList.length - 1; i >= 0; i--)
			fxList[i].deleted = true;
		for (var i = monsterList.length - 1; i >= 0; i--)
			monsterList[i].deleted = true;
		for (var i = bulletList.length - 1; i >= 0; i--)
			bulletList[i].deleted = true;
}



function monsterAdd(mType, aX, aY, mSpriteSet,mSubType) {
		var i = 0;
		while (monsterList[i] && !monsterList[i].deleted && i < monsterCount && i < monsterList.length) i++;
		
		if (i < monsterList.length) {
			if (!monsterList[i]) monsterList[i]=new Monster();
			monsterList[i].init(mType, aX, aY, mSpriteSet, mSubType, myWorld);
			if (i == monsterCount) monsterCount++;
			
			return i;
		}
		return null;
}


function monsterUpdate() {
	var i = 0;
	
	var hasMeteorite=false;

	while (i < monsterCount) {
		if (!monsterList[i].deleted && !paused) {
				
			monsterList[i].update(myWorld, myPlayer, lowDisplayW);
			
			if (myWorld.strictDelete && monsterList[i].y>myWorld.worldOffsetY+lowDisplayH) monsterList[i].died=true;
			
			
			if (monsterList[i].doShoot) {
				monsterList[i].doShoot=false;
				if (monsterList[i].myType==Monster.mSWITCH) {
					bulletAdd(Bullets.OWNER_PLAYER, Bullets.bTRIGGER, 0, monsterList[i].y, 0,0,0);
					fxAdd(monsterList[i].x-6, monsterList[i].y-14,FX.fHINTS,6);
					playSound('FX_SWITCH');
					
					unlockAchievement(ACH_SWITCH);
				}
				
				if (monsterList[i].myType==Monster.mROBOT
					|| monsterList[i].myType==Monster.mCHOPPER) {
					playSound('FX_SHOOT');
				}
			}
			
			if (monsterList[i].doFallSound) {
				monsterList[i].doFallSound=false;
				if (monsterList[i].myType==Monster.mPLATFORM || monsterList[i].myType==Monster.mFAKEPLATFORM) playSound('FX_CRACK');
				if (monsterList[i].myType==Monster.mROCKET) {
					playSound('FX_KICK');
					unlockAchievement(ACH_ROCKETJUMP);
				}
				if (monsterList[i].myType==Monster.mROBOT) {
					playSound('FX_EXPLODE2');
					unlockAchievement(ACH_BOOMBOT);
				}
				if (monsterList[i].myType==Monster.mCHOPPER) {
					playSound('FX_EXPLODE3');
					unlockAchievement(ACH_WHUPWHUP);
				}
			}

			if (monsterList[i].doHitSound) {
				monsterList[i].doHitSound=false;
			}


			if (monsterList[i].doMoveSound){
				monsterList[i].doMoveSound=false;
				if (monsterList[i].myType==Monster.mPICKUP) {
					playSound('FX_PICKUP');
					if (monsterList[i].subType==1) {
						myWorld.drinkCount++;
						if (myWorld.drinkCount==25) unlockAchievement(ACH_ENERGYDRINK);
					}
				}
				if (monsterList[i].myType==Monster.mROCKETLAUNCH) {
					monsterAdd(Monster.mROCKET,0,monsterList[i].y,3,monsterList[i].subType);
					myWorld.shakeCountDown=8;
					playSound('FX_EXPLODE');
				}
				if (monsterList[i].myType==Monster.mROCKET) playSound('FX_ROCKET');
				if (monsterList[i].myType==Monster.mLASER) playSound('FX_LASER');
				if (monsterList[i].myType==Monster.mCHOPPER) playSound('FX_CHOP');
				if (monsterList[i].myType==Monster.mRAZOR) playSound('FX_SAW');
				if (monsterList[i].myType==Monster.mMETEORITE) playSound('FX_METEOR');
			}
			
			if (monsterList[i].doExplodeSound) {
				monsterList[i].doExplodeSound=false;
				if (monsterList[i].myType==Monster.mROCKET) playSound('FX_EXPLODE');
				if (monsterList[i].myType==Monster.mHOSTAGE) {
					playSound('FX_PU');
					tx=0;
					while (myPlayer.extraChars[tx]>=0) tx++;
					myPlayer.extraChars[tx]=monsterList[i].subType;
					
					activePlayer.heroSquadUnlocked[monsterList[i].subType]=true;
					activePlayer.saveSettings();
					
					unlockAchievement(ACH_BRANDI+(monsterList[i].subType-1));
					
					// do we have bro / girl power?
					tx=0; // bro count
					ty=0; // girl count
					for (var bb=0; bb<32; bb++) {
						if (myPlayer.extraChars[bb]==2 || myPlayer.extraChars[bb]==6) tx++;
						if (myPlayer.extraChars[bb]==1 || myPlayer.extraChars[bb]==3 
							|| myPlayer.extraChars[bb]==5 || myPlayer.extraChars[bb]==8) ty++;
					}
					if (tx==2) unlockAchievement(ACH_BROPOWER);
					if (ty>=3) unlockAchievement(ACH_GIRLPOWER);
					
				}
				if (monsterList[i].myType==Monster.mMETEORITE) {
					playSound('FX_EXPLODE');
					unlockAchievement(ACH_METEORITE);
				}
			}
		

			if (monsterList[i].died) {
				monsterList[i].deleted = true;
			} else if (monsterList[i].myType==Monster.mMETEORITE && monsterList[i].y>myWorld.worldOffsetY) {
				hasMeteorite=true;
			}
		}
		i++;
	}
	
	if (hasMeteorite) myWorld.strictDelete=true;
	else myWorld.strictDelete=false;
}



function monsterRender(renderPass) {
	var i = 0;

	while (i < monsterCount) {
		if (!monsterList[i].deleted && monsterList[i].visible) {
			tx=monsterList[i].x-myWorld.worldOffsetX;
			ty=monsterList[i].y-myWorld.worldOffsetY;
			
			if (monsterList[i].rotation != 0) {
				ctx.save();
				ctx.translate( (tx+(monsterList[i].w>>1))<<useMultiFactor, (ty+(monsterList[i].h>>1))<<useMultiFactor);
				ctx.rotate( convertToRadians(monsterList[i].rotation) );
				ctx.translate( -(tx+(monsterList[i].w>>1))<<useMultiFactor, -(ty+(monsterList[i].h>>1))<<useMultiFactor);
			}				

			if (monsterList[i].myType==Monster.mHOSTAGE && monsterList[i].aiState==0) {
				renderSubImageAtPoint(sprites[7+monsterList[i].subType],tx+3,ty+4, 32,0, 16,16);
			}
			
			if (monsterList[i].myType==Monster.mPLATFORM && monsterList[i].subType==8) {
				renderSubImageAtPoint(sprites[monsterList[i].SpriteSet],tx-160,ty, 0,56, 160,32);
				renderSubImageAtPoint(sprites[monsterList[i].SpriteSet],tx+monsterList[i].w,ty, 0,56, 160,32);
			} else {
				// default rendering
				renderSubImageAtPoint(sprites[monsterList[i].SpriteSet],tx,ty, monsterList[i].xOffset,monsterList[i].yOffset, monsterList[i].w,monsterList[i].h);
			}
			
			
			if (monsterList[i].rotation != 0) {
				ctx.restore();
			}
			
			if (monsterList[i].myType==Monster.mLASER) {
				ty+=2;
				if (monsterList[i].aiState==1) {
					tx+=15;
					while (tx<lowDisplayW-16) {
						renderSubImageAtPoint(sprites[1],tx,ty, 6,0, 16,13);
						tx+=16;
					}
				}
				
				tx=lowDisplayW-16;
				ty-=2;
				renderSubImageAtPoint(sprites[monsterList[i].SpriteSet],tx,ty, monsterList[i].xOffset+16,monsterList[i].yOffset, monsterList[i].w,monsterList[i].h);
			}
		}
		i++;
	}
	setAlpha(255);
}




function fxAdd( ax,  ay,  aType,  aSubType) {
	// find first openspot
	var i = 0;
	while (fxList[i] && !fxList[i].deleted && i < fxCount) i++;
	
	if (!fxList[i]) fxList[i]=new FX();
	fxList[i].init(ax, ay, aType, aSubType);

	if (i == fxCount && fxCount < 512) fxCount++;
}

	
function fxUpdate() {
	// lets do all the effects in the list
	var i = 0;
	while (i < fxCount) {
		if (!fxList[i].deleted) {

				fxList[i].update(myWorld);

				// is our live cycle over!?
				if (fxList[i].died) {
					fxList[i].deleted = true;
				}


		}

		// NEXT please!
		i++;
	}
}


function fxRender(renderPass) {
	var i = 0;
	while (i < fxCount) {
		if (!fxList[i].deleted && fxList[i].renderPass==renderPass 
				&& fxList[i].visible) {

				tx = fxList[i].x-myWorld.worldOffsetX;
				ty = fxList[i].y-myWorld.worldOffsetY;

				setAlpha(fxList[i].alpha);
				
				if (ty >= -24 && ty < lowDisplayH && tx > -24 && tx < lowDisplayW) {
					
					if (fxList[i].rotation != 0) {
						ctx.save();
						ctx.translate( (tx+(fxList[i].w>>1))<<useMultiFactor, (ty+(fxList[i].h>>1))<<useMultiFactor);
						ctx.rotate( convertToRadians(fxList[i].rotation) );
						ctx.translate( -(tx+(fxList[i].w>>1))<<useMultiFactor, -(ty+(fxList[i].h>>1))<<useMultiFactor);
					}				

					renderSubImageAtPoint(sprites[fxList[i].spriteSet],
											tx,ty,
											fxList[i].animFrame, fxList[i].aOffset,
											fxList[i].w, fxList[i].h);

					if (fxList[i].fType==FX.fCHAPTER) {
						tx+=46;
						ty+=3;
						renderSubImageAtPoint(sprites[fxList[i].spriteSet],
												tx,ty,
												fxList[i].SubType*9, 98,
												9,10);
					}
					
					if (fxList[i].rotation != 0) ctx.restore();
				}
				

		}

		i++;
	}
	setAlpha(255);
}


	function bulletAdd( bOwner,  bType,  ax,  ay,  aSubType,  targetX,  targetY) {
		var i = 0;
		while (bulletList[i] && !bulletList[i].deleted && i < bulletCount) i++;
		if (!bulletList[i]) bulletList[i]=new Bullets();
		bulletList[i].init(bOwner, ax,ay,bType,aSubType,targetX,targetY);

		if (i == bulletCount && bulletCount < 256) bulletCount++;
	}
	

	function bulletUpdate() {
		var i = 0;

		while (i < bulletList.length) {
			if (!bulletList[i].deleted) {
				if (!paused) {
					bulletList[i].update(myPlayer, myWorld);
					
					for (var m=0; m<monsterList.length; m++) {
						if (!monsterList[m].deleted && !monsterList[m].died && bulletList[i].collidesWith(monsterList[m])) {
							if (monsterList[m].hit(bulletList[i],myPlayer)) {
								bulletList[i].died=true;
							}
						}
					}
					
					
				}

				if (bulletList[i].died) {
					bulletList[i].deleted = true;
				}
			}

			i++;
		}
	}
	
	
	function bulletRender() {
		var i = 0;

		while (i < bulletList.length) {
			if (!bulletList[i].deleted && bulletList[i].visible) {
					tx = bulletList[i].x-myWorld.worldOffsetX;
					ty = bulletList[i].y-myWorld.worldOffsetY;
					if (tx>-48 && ty>-48 && tx<lowDisplayW && ty<lowDisplayH) {

						if (bulletList[i].rotation != 0) {
							ctx.save();
							ctx.translate( (tx+(bulletList[i].w>>1))<<useMultiFactor, (ty+(bulletList[i].h>>1))<<useMultiFactor);
							ctx.rotate( convertToRadians(bulletList[i].rotation) );
							ctx.translate( -(tx+(bulletList[i].w>>1))<<useMultiFactor, -(ty+(bulletList[i].h>>1))<<useMultiFactor);
						}				

						renderSubImageAtPoint(sprites[bulletList[i].spriteSet],
							tx,ty,
							bulletList[i].xOffset, bulletList[i].yOffset,
							bulletList[i].w, fxList[i].h);
	
						if (bulletList[i].rotation != 0) {
							ctx.restore();
						}

					}
			}

			i++;
		}
	}



	function renderScene() {
		ty=-160-(myWorld.worldOffsetY%160);
		while (ty<lowDisplayH) {
			renderSubImageAtPoint(sprites[5], 0,ty, 0,0, 160,160);
			ty+=160;
		}
		
		
		setAlpha(255);

		
		// update and render the various items
		fxRender(1);
		monsterRender();
		fxRender(2);

		// draw echo's of rescued extra lives
		setAlpha(128);
		// 1st save
		tx=0;
		ty=8;
		foundFirst=false; // foundfirst empty slot?
		while (!foundFirst) {
			if (myPlayer.extraChars[tx]>=0) {
				playerEcho[ty].Paint(sprites[7+myPlayer.extraChars[tx]], myWorld);
				tx++;
				ty+=8;
			} else {
				foundFirst=true;
			}
		}

		setAlpha(255);
		
		// render actual player
		myPlayer.Paint(sprites[myPlayer.spriteIndex], myWorld);
		

		bulletRender();
		fxRender(3);

		// pass 4 used for messages
		fxRender(4);
		
		
		renderStatusBar();

	}


	function renderStatusBar() {
		// calc score
		tx=-(myWorld.worldOffsetYLowest>>3);
		tx+=myPlayer.plScore;
		
		currentHighScore=tx;
		
		if (tx>activePlayer.highScore) activePlayer.highScore=tx;
		setDigits(tx,digitsBoard);
		// render score
		tx=0;
		ty=1;
		foundFirst=false;
		for (var i=0; i<6; i++) {
			renderSubImageAtPoint(sprites[28], tx,ty, digitsBoard[i]*8,0, 8,10);
			tx+=8;
		}		
		
		// 
		tx=0;
		ty=12;
		while (tx<lowDisplayW) {
			renderSubImageAtPoint(sprites[1], tx,ty, 6,14, 16,1);
			tx+=16;
		}
		
		// pause button
		if (paused) {
			tx=(lowDisplayW-16);
			ty=1;
			renderSubImageAtPoint(sprites[1], tx,ty, 188,12, 8,10);
		} else {
			tx=(lowDisplayW-16);
			ty=1;
			renderSubImageAtPoint(sprites[1], tx,ty, 188,1, 9,10);
		}
		
	}

	
	
	function initNewGame() {
		myPlayer.newLife();
		myPlayer.gameReset(lowDisplayW>>1, lowDisplayH-16);
		myPlayer.spriteIndex=7+myWorld.heroSquad[0];
		myWorld.init();
		myWorld.displayW=lowDisplayW;
		myWorld.displayH=lowDisplayH;
		
		myWorld.lastBlockX=-1;
		
		myWorld.worldOffsetX=0;
		myWorld.worldOffsetY=0;
		myWorld.worldOffsetYLowest=0;
		
		myWorld.lastBlockY=myWorld.worldOffsetY+lowDisplayH-16;

		// add floor
		tx=0;
		while (tx<lowDisplayW) {
			monsterAdd(Monster.mPLATFORM,tx,myWorld.lastBlockY,2,0);
			tx+=40;
		}
		
		while (myWorld.lastBlockY>myWorld.worldOffsetY-20) {
			addRow();
		}
		
		GameState=INITMAP;
		myWorld.worldAge=-1;
	}
	
	
	function addRow() {
		
		
		// add hazard on the way?
		
		if (getRandom(64)>32) {
			monsterAdd(Monster.mPICKUP,getRandom(lowDisplayW-16),myWorld.lastBlockY-42,2,0);
		}
		
		
		
		ty=myWorld.lastBlockY-72;
		var plattype=0;
		
		if (myWorld.worldOffsetY<-1000) plattype=1+getRandom(3);	// remove big ones, introduce breakables
		else if (myWorld.worldOffsetY<-800) plattype=getRandom(3);
		else if (myWorld.worldOffsetY<-400) plattype=getRandom(2);
		else plattype=0;
		

		
		// add super character?
		if (ty<=myWorld.worldNextHero && myWorld.worldNextHeroID<MAXHEROES) {
			monsterAdd(Monster.mPLATFORM,-1,ty, 2,0);
			monsterAdd(Monster.mHOSTAGE, myWorld.lastBlockX-10, ty-24,1,myWorld.heroSquad[myWorld.worldNextHeroID]);
			
			myWorld.worldNextHeroID++;
			myWorld.worldNextHero-=2000+(myWorld.worldNextHeroID*512);
			
			if (!myWorld.didHintSave) {
				fxAdd( (lowDisplayW>>1)+getRandom(24)-12 ,ty+32, FX.fHINTS, 3);
				myWorld.didHintSave=true;
			}
			
		} 
		
		else if ( myWorld.worldOffsetY<-25000 && getRandom(60)>56) {
			monsterAdd(Monster.mMETEORITE,-1,ty-64, 2,0);
			monsterAdd(Monster.mMETEORITE,-1,ty-80, 2,0);
			myWorld.lastType=TileMap.type_GENERAL;
			
			if (!myWorld.didHintMeteor) {
				fxAdd( (lowDisplayW>>1)+getRandom(24)-12 ,ty+32, FX.fHINTS, 13);
				myWorld.didHintMeteor=true;
			}
		}

		else if (myWorld.worldOffsetY<-20000 && getRandom(60)>40 && myWorld.lastType!=TileMap.type_ENERGY) {
			// chopper
			monsterAdd(Monster.mPLATFORM,-1,ty, 2,0);	// platform
			monsterAdd(Monster.mBOMB,myWorld.lastBlockX,ty-16,2,0);
			ty-=72;
			
			monsterAdd(Monster.mPLATFORM,-1,ty, 2,plattype);	// platform
			ty-=72;
			
			monsterAdd(Monster.mPLATFORM,-1,ty, 2,0);	// platform
			monsterAdd(Monster.mCHOPPER,myWorld.lastBlockX-20,ty-16,3,0);
			myWorld.lastType=TileMap.type_GENERAL;
		}
		
		else if (myWorld.worldOffsetY<-15000 && getRandom(60)>40) {
			// robots

			if (!myWorld.didHintBomb) {
				fxAdd( (lowDisplayW>>1)+getRandom(24)-12 ,ty-64, FX.fHINTS, 1);
				myWorld.didHintBomb=true;
			}
			
			
			monsterAdd(Monster.mPLATFORM,-1,ty, 2,0);	// platform
			monsterAdd(Monster.mBOMB,myWorld.lastBlockX,ty-16,2,0);
			ty-=72;
			
			monsterAdd(Monster.mPLATFORM,-1,ty, 2,plattype);	// platform
			ty-=72;
			
			monsterAdd(Monster.mPLATFORM,-1,ty, 2,0);	// platform
			monsterAdd(Monster.mROBOT,myWorld.lastBlockX-20,ty-16,3,0);
			monsterAdd(Monster.mPLATFORM,myWorld.lastBlockX+20,ty, 2,0);	// platform
			myWorld.lastType=TileMap.type_GENERAL;
		} 
		
		else if (myWorld.worldOffsetY<-10000 && getRandom(60)>40 && myWorld.lastType!=TileMap.type_ENERGY) {
			// Razor!
			monsterAdd(Monster.mRAZOR, 80,ty, 3,0);
			monsterAdd(Monster.mPLATFORM,00,ty, 2,0);
			monsterAdd(Monster.mPLATFORM,40,ty, 2,0);
			monsterAdd(Monster.mPLATFORM,80,ty, 2,0);
			monsterAdd(Monster.mPLATFORM,120,ty, 2,0);
			myWorld.lastType=TileMap.type_SAW;
		} 
		
		else if (myWorld.worldOffsetY<-6000 && getRandom(80)>40 && myWorld.lastType!=TileMap.type_ENERGY) {
			// laser
			if (!myWorld.didHintSwitch) {
				fxAdd( (lowDisplayW>>1)+getRandom(24)-12 ,ty-64, FX.fHINTS, 2);
				myWorld.didHintSwitch=true;
				monsterAdd(Monster.mPLATFORM,-1,ty, 2,plattype);
				ty-=72;
			} else {
				fxAdd( (lowDisplayW>>1)+getRandom(24)-12 ,ty-128, FX.fHINTS, 4);
			}

			
			monsterAdd(Monster.mLASER,0,ty-128,3,0);
			
			if (getRandom(100)>50) {
				monsterAdd(Monster.mPLATFORM,0,ty, 2,2);	// platform
				monsterAdd(Monster.mSWITCH,myWorld.lastBlockX-8,ty-9,3,0);
				monsterAdd(Monster.mPLATFORM,lowDisplayW-20,ty, 2,2);	// platform
			} else {
				monsterAdd(Monster.mPLATFORM,0,ty, 2,2);	// platform
				monsterAdd(Monster.mPLATFORM,lowDisplayW-20,ty, 2,2);	// platform
				monsterAdd(Monster.mSWITCH,myWorld.lastBlockX-8,ty-9,3,0);
			}

			ty-=72;
			monsterAdd(Monster.mPLATFORM,-1,ty, 2,plattype);	// platform
			
			myWorld.lastType=TileMap.type_LASER;
		}
		
		else if (myWorld.worldOffsetY<-800 && getRandom(64)>32 && (myWorld.worldOffsetY<-2000 || myWorld.lastType!=TileMap.type_ENERGY)) {
			tx=24+getRandom(lowDisplayW-64);
			monsterAdd(Monster.mPICKUP,tx,ty-32,2,1);
			
			if (!myWorld.didHintCan){ 
				fxAdd( tx-9 ,ty-24, FX.fHINTS, 14);
				myWorld.didHintCan=true;
			}
			
			ty-=48;
			myWorld.lastType=TileMap.type_ENERGY;
		}
		
		else if (myWorld.worldOffsetY<-1500 && getRandom(48)>24) {
			// rocket
			monsterAdd(Monster.mROCKETLAUNCH,0,ty,3,0);
			
			if (!myWorld.didHintRocket) {
				fxAdd( (lowDisplayW>>1)+getRandom(24)-12 ,ty+24, FX.fHINTS, 0);
				myWorld.didHintRocket=true;
			}
			
			// v1.0.1
			if (myWorld.worldOffsetY>-5000) {
				monsterAdd(Monster.mPLATFORM,-1,ty+64, 2,0);
			}
			
			
			myWorld.lastType=TileMap.type_GENERAL;
		}	
			
		else if (myWorld.worldOffsetY<-256 && getRandom(48)>44) {
				// double swap spikes!
				monsterAdd(Monster.mPLATFORM,-1,ty, 2,2);	// platform
				monsterAdd(Monster.mSPIKES,myWorld.lastBlockX-10,ty-5,2,0);
				
				if (myWorld.lastBlockX<lowDisplayW>>1) {
					monsterAdd(Monster.mPLATFORM,myWorld.lastBlockX+10,ty, 2,2);	// platform
					monsterAdd(Monster.mSPIKES,myWorld.lastBlockX-10,ty-5,2,1);
				} else {
					monsterAdd(Monster.mPLATFORM,myWorld.lastBlockX-30,ty, 2,2);	// platform
					monsterAdd(Monster.mSPIKES,myWorld.lastBlockX-10,ty-5,2,1);
				}
				
				myWorld.lastType=TileMap.type_GENERAL;
		} 
		
		else {
			// platform only
			
			monsterAdd(Monster.mPLATFORM,-1,ty, 2,plattype);
			
			
			// add extra platforms at lower levels
			if (myWorld.worldOffsetY>-1000) {

				// v1.0.1
				if (myWorld.worldOffsetY<-20000) plattype=1+getRandom(3);	// remove big ones, introduce breakables
				else if (myWorld.worldOffsetY<-800) plattype=getRandom(3);
				else if (myWorld.worldOffsetY<-400) plattype=getRandom(2);
				else plattype=0;

				monsterAdd(Monster.mPLATFORM,-1,ty-24, 2,plattype);
			}			
			
			myWorld.lastType=TileMap.type_GENERAL;
		}
		
		// add fake platform
		if (myWorld.worldOffsetY<-8000 && getRandom(64)>40) {
			monsterAdd(Monster.mFAKEPLATFORM,-1,ty-32+getRandom(64), 2,0);
		}
		
		
		
		
		
		
		myWorld.lastBlockY=ty;
	}


	function initDied() {
		GameState=INDIED;
		
		statusBarY=-96;
		statusBarTarget=(lowDisplayH>>1);

		myWorld.worldAge=64;
/*		
		if (mHelper.isSignedIn()) {
			mHelper.getGamesClient().submitScore("CgkI4pn78coKEAIQAQ",currentHighScore);
			adHandler.post(googleCloudsave);
		}
*/		
		
		stopTilt();
//		adHandler.post(showAds);
	}



	function InitMenu() {
		paused = false;
		
		statusBarY=-48;
		statusBarTarget=0;
		
		GameState = INMENU;
		
		worldTicks=0;

		activePlayer.saveSettings();
		
		playBackground();
		
//		adHandler.post(showAds);
//		adHandler.post(showInterstitial);
	}


	
	
	
	/**
	 * Initialise the ingame-pause menu
	 * 
	 */
	function initPauseMenu() {
		GameState=INPAUSE;
		paused=true;
		stopBackground();
//		adHandler.post(showAds);
	}


 
var mySoundPool = new SoundPool(36);
var myGameMusic = -1;

function initSounds() {
	if (document.location.hostname == "localhost" || (params.noaudio && params.noaudio==1) ) {
		useSFX=false;
		return;
	}

	// sound only works when running from an actual url, not locally
	// comment this out if running local

	// note: extensions are loaded in soundpool based on browser
	mySoundPool.load(soundRoot+'audio/fxsplash','FX_SPLASH');
	mySoundPool.load(soundRoot+'audio/fxkick','FX_KICK');
	mySoundPool.load(soundRoot+'audio/fxjump','FX_JUMP');
	mySoundPool.load(soundRoot+'audio/fxzap','FX_ZAP');
	mySoundPool.load(soundRoot+'audio/fxshoot','FX_SHOOT');
	mySoundPool.load(soundRoot+'audio/fxswitch','FX_SWITCH');
	mySoundPool.load(soundRoot+'audio/fxrocket','FX_ROCKET');
	mySoundPool.load(soundRoot+'audio/fxexplode','FX_EXPLODE');
	mySoundPool.load(soundRoot+'audio/fxpu','FX_PU');
	mySoundPool.load(soundRoot+'audio/fxlaser','FX_LASER');
	mySoundPool.load(soundRoot+'audio/fxchop','FX_CHOP');
	mySoundPool.load(soundRoot+'audio/fxexplode2','FX_EXPLODE2');
	mySoundPool.load(soundRoot+'audio/fxexplode3','FX_EXPLODE3');
	mySoundPool.load(soundRoot+'audio/fxsaw','FX_SAW');
	mySoundPool.load(soundRoot+'audio/fxpickup','FX_PICKUP');
	mySoundPool.load(soundRoot+'audio/fxhit','FX_HIT');
	mySoundPool.load(soundRoot+'audio/fxcrack','FX_CRACK');
	mySoundPool.load(soundRoot+'audio/fxmeteor','FX_METEOR');
	mySoundPool.load(soundRoot+'audio/tune1','tune1');
	mySoundPool.load(soundRoot+'audio/tune2','tune2');

}


function playSound(soundid) {
	if (!activePlayer.useSFX) return;
	mySoundPool.playSound(soundid,false);
} 

	function stopAllSounds() {
		if (myGameMusic != null)
			myGameMusic.stop();
	}

	function playBackground() {
		if (activePlayer.useMusic) {
			if (GameState==INGAME) myGameMusic=mySoundPool.playSound('tune2',true);
			else myGameMusic=mySoundPool.playSound('tune1',true);
		}
	}

	function stopBackground() {
		if (activePlayer.useMusic && myGameMusic!=-1) mySoundPool.stopSound(myGameMusic);
	}

	


	
	function freeMusic() {
		if (myGameMusic!=null) {
			myGameMusic.destroy();
	        myGameMusic=null;
		}
	}	
	
	
	function setDigits(value, digits) {
		var temp=Math.round(value);
		var i=2;

		for (i=0; i<digits.length; i++)	digits[i]=0;
		i=digits.length-1;
		while (i>=0) {
			digits[i] = temp % 10;
			temp = (temp/10)>>0;
			if (temp == 0) i=-1;
			else i--;
		}
	}

 
 
	function generateSquad(leaderID) {
		// clear squad
		for (var j=32; --j>=0;) myWorld.heroSquad[j]=-1;
		
		// set hero (first player)
		myWorld.heroSquad[0]=leaderID;
		
		// find highest unlocked character
		var maxUnlocked=leaderID;
		while (maxUnlocked<MAXHEROES && activePlayer.heroSquadUnlocked[maxUnlocked]) maxUnlocked++;
		if (!activePlayer.heroSquadUnlocked[maxUnlocked]) maxUnlocked--;
		
		
		// now randomize the unlocked ones
		var it=0;
		
		tx2=1;
		var duplicate=false;
		ty=getRandom(maxUnlocked+1);

		if (ty==leaderID) {
			ty++;
			if (ty>=maxUnlocked) ty=0;
		}
		while (tx2<=maxUnlocked && it<32) {
			duplicate=false;
			for (var j=0; j<MAXHEROES; j++) {
				if (ty==myWorld.heroSquad[j]) duplicate=true;
			}
			if (!duplicate) {
				myWorld.heroSquad[tx2]=ty;
				tx2++;
				ty=getRandom(maxUnlocked+1);
			} else {
				ty++;
				if (ty>maxUnlocked) ty=0;
			}
			
			it++;
		}
		
		maxUnlocked++;
		// correct order for all others
		while (maxUnlocked<MAXHEROES) {
			myWorld.heroSquad[maxUnlocked]=maxUnlocked;
			maxUnlocked++;
		}
		
	}
 
 
 
 	// achievements and highscores
	var ACH_BRANDI = 1,
		ACH_MRDADDY = 2,
		ACH_CHICKY = 3,
		ACH_STUNTMANJOE = 4,
		ACH_LEILA = 5,
		ACH_JUNIOR = 6,
		ACH_JIMMY = 7,
		ACH_DENA = 8,
		ACH_ROCKETJUMP = 9,
		ACH_SWITCH = 10,
		ACH_BOOMBOT = 11,
		ACH_WHUPWHUP = 12,
		ACH_METEORITE = 13,
		ACH_BROPOWER = 14,
		ACH_GIRLPOWER = 15,
		ACH_ENERGYDRINK = 16;
	
	
	function unlockAchievement(id) {
	}
 
 function FX() {


	FX.fPOW			= 1,
	FX.fOUCH		= 2,
	FX.fZAP			= 3,
	FX.fBOUNCEDEBRI	= 4,
	FX.fROCKETPUFF	= 5,
	FX.fROBOTDEBRI	= 6,
	FX.fHINTS		= 7,
	FX.fGLOBEDEBRI	= 8,
	FX.fCHAPTER		= 9;

	this.x=0;
	this.tx=0;
	this.ty=0;
	this.floatX=0;
	this.floatY=0;
	this.x=0;
	this.y=0;
	this.xSpeed=0;
	this.ySpeed=0;
	this.w=0;
	this.h=0;
	this.animDelay=0;
	this.animSpeed=0;
	this.animFrame=0;
	this.animFrameA=0;
	this.aOffset=0;
	this.died=true;
	
	this.xIncrease=0;
	this.yIncrease=0;
	
	this.aiState=0;
	this.aiCountDown=0;
	
	this.renderPass=0;
	this.spriteSet=0;

	this.fType=0;
	
	this.SubType=0;

	this.rotation=0;
	this.alpha=0;
	
	this.visible=true;
	this.deleted=true;


	
	this.init=function( ax,  ay,  aType,  aSubType) {
		this.deleted=false;
		
		this.spriteSet=1;	// default FX spriteset
		this.x=ax;
		this.y=ay;
		this.fType=aType;
		this.SubType=aSubType;
		
		this.ySpeed=0;
		this.xSpeed=0;

		this.animSpeed=2;
		this.animFrameA=0;
		this.renderPass=1;
		
		this.alpha=255;
		
		this.rotation=0;
		this.visible=true;
		
		switch (this.fType) {
			case FX.fPOW:
				this.w=30;
				this.h=17;
				this.animFrame=62;
				this.aOffset=28;
				this.animSpeed=24;
				this.ySpeed=-48;
				this.rotation=getRandom(90)-45;
				this.alpha=64+getRandom(190);
			break;
			
			case FX.fOUCH:
				this.w=37;
				this.h=16;
				this.animFrame=86;
				this.aOffset=45;
				this.animSpeed=24;
				this.ySpeed=-48;
				this.rotation=getRandom(90)-45;
				this.alpha=64+getRandom(190);
				this.fType=FX.fPOW;
			break;
			
			case FX.fZAP:
				this.w=44;
				this.h=16;
				this.animFrame=125;
				this.aOffset=45;
				this.animSpeed=24;
				this.ySpeed=-48;
				this.rotation=getRandom(90)-45;
				this.alpha=64+getRandom(190);
				this.fType=FX.fPOW;
			break;
			
			
			case FX.fBOUNCEDEBRI:
				switch (this.SubType) {
					case 0:	// single dot
						this.w=1;
						this.h=1;
						this.animFrame=0;
						this.aOffset=0;
					break;
					
					case 1: // double dot
						this.w=2;
						this.h=2;
						this.animFrame=0;
						this.aOffset=0;
					break;
					
					case 2: // small star
						this.w=4;
						this.h=4;
						this.animFrame=2;
						this.aOffset=0;
					break;
					
					case 3: // part of the platform
						this.w=4;
						this.h=4;
						this.animFrame=64+getRandom(16);
						this.aOffset=16;
						this.spriteSet=2;
					break;
					
					case 4: // top-left-meteor
						this.w=8;
						this.h=6;
						this.animFrame=64;
						this.aOffset=21;
						this.spriteSet=2;
					break;
					case 5: // top-right-meteor
						this.w=8;
						this.h=6;
						this.animFrame=72;
						this.aOffset=21;
						this.spriteSet=2;
					break;
					case 6: // bot-right-meteor
						this.w=8;
						this.h=6;
						this.animFrame=72;
						this.aOffset=26;
						this.spriteSet=2;
					break;
					case 7: // bot-left-meteor
						this.w=8;
						this.h=6;
						this.animFrame=64;
						this.aOffset=26;
						this.spriteSet=2;
					break;
					
				}
				
				this.xSpeed=(getRandom(8)-4)<<4;
				this.ySpeed=-(1+getRandom(2))<<4;
				this.animSpeed=12;
				this.alpha=64+getRandom(190);
			break;
			
			
			case FX.fROCKETPUFF:
				this.w=12;
				this.h=12;
				if (this.SubType==0) {
					this.animFrame=33;
					this.aOffset=0;
					this.animFrameA=12;
				} else {
					this.animFrame=80;
					this.aOffset=64;
					this.animFrameA=12;
				}
				this.animSpeed=3;
			break;
			
			case FX.fROBOTDEBRI:
				this.w=8;
				this.h=8;
				switch (this.SubType) {
					case 0: // tl
						this.animFrame=128;
						this.aOffset=0;
						this.xSpeed=-96;
						this.ySpeed=-96;
					break;
					
					case 1: // tr
						this.animFrame=136;
						this.aOffset=0;
						this.xSpeed=96;
						this.ySpeed=-96;
						this.x+=8;
					break;
					
					case 2: // br
						this.animFrame=136;
						this.aOffset=8;
						this.xSpeed=96;
						this.ySpeed=-48;
						this.x+=8;
						this.y+=8;
					break;
					
					case 3: // bl
						this.animFrame=128;
						this.aOffset=8;
						this.xSpeed=-96;
						this.ySpeed=-48;
						this.y+=8;
					break;
				}
				this.rotation=getRandom(360);
				this.animSpeed=64;
			break;
			
			
			case FX.fHINTS:
				this.spriteSet=6;
				switch (this.SubType) {
					case 0: // rockets
						this.animFrame=0;
						this.aOffset=0;
						this.w=40;
						this.h=42;
					break;
					
					case 1: // throw
						this.animFrame=50;
						this.aOffset=0;
						this.w=50;
						this.h=42;
					break;
					
					case 2: // laser
						this.animFrame=0;
						this.aOffset=42;
						this.w=64;
						this.h=48;
					break;
					
					case 3: // save!!
						this.animFrame=65;
						this.aOffset=45;
						this.w=32;
						this.h=32;
					break;
					
					
					case 4: // brzzt
						this.animFrame=0;
						this.aOffset=90;
						this.w=70;
						this.h=17;
					break;
					
					case 5: // whump (chopper sound)
						this.animFrame=71;
						this.aOffset=78;
						this.w=37;
						this.h=16;
					break;
					
					case 6: // switch
						this.animFrame=71;
						this.aOffset=94;
						this.w=48;
						this.h=23;
					break;
					
					case 7: // +100
						this.w=45;
						this.h=20;
						this.animFrame=101;
						this.aOffset=0;
					break;
					
					case 8: // rrtt
						this.w=38;
						this.h=20;
						this.animFrame=101;
						this.aOffset=21;
					break;

					case 9: // +25
						this.w=22;
						this.h=14;
						this.animFrame=147;
						this.aOffset=0;
					break;
					
					case 10: // crash
						this.w=66;
						this.h=34;
						this.animFrame=101;
						this.aOffset=42;
					break;
					
					case 11: // screee
						this.w=51;
						this.h=42;
						this.animFrame=169;
						this.aOffset=0;
					break;
					
					case 12: // screee - other direction
						this.w=51;
						this.h=42;
						this.animFrame=169;
						this.aOffset=42;
					break;
					
					case 13: // info meteorite
						this.w=57;
						this.h=34;
						this.animFrame=121;
						this.aOffset=78;
					break;
					
					case 14: // energy drink
						this.w=35;
						this.h=26;
						this.animFrame=221;
						this.aOffset=0;
					break;
					
					case 15: // game over
						this.w=43;
						this.h=32;
						this.animFrame=0;
						this.aOffset=36;
						this.spriteSet=1;
					break;
						
				}	
				this.animSpeed=200;
			break;
			
			case FX.fGLOBEDEBRI:
				switch (this.SubType) {
					case 0: // tl
						this.animFrame=168;
						this.aOffset=0;
						this.xSpeed=-96;
						this.ySpeed=-96;
						this.w=11;
						this.h=7;
						this.x+=4;
					break;
					
					case 1: // tr
						this.animFrame=180;
						this.aOffset=2;
						this.xSpeed=96;
						this.ySpeed=-96;
						this.x+=16;
						this.y+=3;
						this.w=5;
						this.h=10;
					break;
					
					case 2: // br
						this.animFrame=172;
						this.aOffset=8;
						this.xSpeed=96;
						this.ySpeed=-48;
						this.x+=8;
						this.y+=9;
						this.w=8;
						this.h=6;
					break;
					
					case 3: // bl
						this.animFrame=166;
						this.aOffset=7;
						this.xSpeed=-96;
						this.ySpeed=-48;
						this.y+=8;
						this.x+=2;
						this.w=5;
						this.h=7;
					break;
				}
				this.fType=FX.fROBOTDEBRI;
				this.rotation=getRandom(360);
				this.animSpeed=64;
			break;
			
			case FX.fCHAPTER:
				this.w=160;
				this.h=14;
				this.animSpeed=200;
				this.animFrame=0;
				this.aOffset=84;
			break;
		}
		
		
		this.floatX=this.x<<4;
		this.floatY=this.y<<4;
		this.animDelay=this.animSpeed;
		
		this.died=false;
	}
	
	
	this.update=function(myWorld) {
		this.animDelay--;
		if (this.animDelay==0) {
			this.animDelay=this.animSpeed;
			this.animFrame+=this.animFrameA;

			switch (this.fType) {
			
				case FX.fROCKETPUFF:
					if (this.SubType==0 && this.animFrame>81) this.died=true;
					else if (this.SubType==1 && this.animFrame>128) this.died=true;
				break;
			
				default:
					this.died=true;
				break;
			}
		}
		
		
		

		switch (this.fType) {
		
			case FX.fPOW:
				this.floatY+=this.ySpeed;
				this.y=this.floatY>>4;
				if (this.ySpeed<0) this.ySpeed+=8;
				else this.ySpeed=0;
				this.animDelay=999;
			break;
			
			
			case FX.fBOUNCEDEBRI:
				this.floatX+=this.xSpeed;
				this.floatY+=this.ySpeed;
			break;
			
			
			case FX.fROBOTDEBRI:
				if (this.xSpeed<0) {
					this.rotation-=16;
					if (this.rotation<0) this.rotation+=360;
				} else if (this.xSpeed>0) {
					this.rotation+=16;
					if (this.rotation>360) this.rotation-=360;
				}
				
				if (this.ySpeed<128) this.ySpeed+=16;
				this.floatX+=this.xSpeed;
				this.floatY+=this.ySpeed;
				this.x=this.floatX>>4;
				this.y=this.floatY>>4;
				if (this.xSpeed>0) this.xSpeed-=8;
				else if (this.xSpeed<0) this.xSpeed+=8;
			break;
		}
		
		this.y=this.floatY>>4;
		this.x=this.floatX>>4;
		if (this.y>myWorld.worldOffsetY+myWorld.displayH) this.died=true;
	}
	

}
 /**
 * @constructor
 */
function Monster() {

	Monster.mPICKUP		= 0,
	Monster.mPLATFORM 	= 1,
	Monster.mROCKETLAUNCH = 2,
	Monster.mROCKET		= 3,
	Monster.mBOMB		= 4,
	Monster.mSPIKES		= 5,
	Monster.mLASER		= 6,
	Monster.mSWITCH		= 7,
	Monster.mROBOT		= 8,
	Monster.mCHOPPER	= 9,
	Monster.mHOSTAGE	= 10,
	Monster.mSPIKEY		= 11,
	Monster.mRAZOR		= 12,
	Monster.mFAKEPLATFORM = 13,
	Monster.mMETEORITE = 14;
	
	// position and size in the world
	this.w=0;
	this.h=0;
	this.x=0;
	this.y=0;
	this.floatX=0;
	this.floatY=0;
	this.targetX=0;
	this.targetY=0;
	this.startX=0;
	this.startY=0;
	this.rotation=0;

	// velocity and direction
	this.ySpeed=0;
	this.xSpeed=0;
	this.xIncrease=0;
	this.yIncrease=0;
	this.myDirection=0;
	this.maxSpeed=0;
	
	
	
	// animation and drawing values
	this.SpriteSet=0;
	this.xOffset=0;
	this.yOffset=0;
	this.xOffsetAdd=0;
	this.animDelay=0;
	this.animIncrease=0;
	this.animSpeed=0;
	this.visible=true;
	this.firstpass=true;
	this.alpha=0;
	
	// type and AI states
	this.myType=0;
	this.subType=0;
	this.energy=0;
	this.hitCount=0;
	this.maxEnergy=0;
	this.aiState=0;
	this.aiCountDown=0;
	this.playerTargetID=0;
	this.died=false;
	this.hasPlayer=false;
	
	this.doShoot=false;
	this.doHitSound=false;
	this.doMoveSound=false;
	this.doExplodeSound=false;
	this.doFallSound=false;
	
	// entity information
	this.deleted=false;

		

	this.init=function( mType,  aX, aY,  mSpriteSet,  mSubType, myWorld) {
		// we are now concidered active monster
		this.deleted=false;
		
		this.firstpass=true;
		// and let's get our selves sorted out!
		this.myType=mType;
		this.subType=mSubType;
		
		// where? ah! there:
		this.x=aX;
		this.y=aY;
		this.startX=aX;
		this.startY=aY;
		this.targetX=this.x;
		this.targetY=this.y;
		
		this.rotation=0;
		
		// what? 
		this.SpriteSet=mSpriteSet;
		this.visible=true;
		this.alpha=255;
		this.aiState=0;
		
		// we demand our defaults!
		this.died=false;
		this.hasPlayer=false;
		this.doHitSound=false;
		this.doShoot=false;
		this.doMoveSound=false;
		this.doExplodeSound=false;
		this.doFallSound=false;
		this.energy=0;
		this.maxEnergy=0;
		this.hitCount=0;

		// define type specifics (DNA!)
		switch (this.myType) {

			case Monster.mPICKUP:
				this.w=16;
				this.h=16;
				switch (this.subType) {
					case 0:	// energy drink
						this.xOffset=32;
						this.yOffset=0;
					break;
					
					case 1: // extra boost
						this.xOffset=48;
						this.yOffset=0;
					break;

					case 2: // left/right mixed
						this.xOffset=64;
						this.yOffset=0;
					break;
				}
				
				this.xSpeed=0;
				this.ySpeed=-4;
				this.yIncrease=-4;
				
				this.aiState=0;
			break;
			
			
			case Monster.mPLATFORM:
				
				switch (this.subType) {
					case 0: // default still platforms
						this.w=40;
						this.h=5;
						this.xOffset=0;
						this.yOffset=16;
						
						if (aX<0) this.x=getRandom(myWorld.displayW-this.w);
						else this.x=aX;
						
						myWorld.lastBlockX=this.x+20;
						this.y=aY;
					break;
				
					case 1:	// horizontal movers
						if (myWorld.worldOffsetY<-900) this.w=20;
						else this.w=40;
						this.h=5;
						this.xOffset=0;
						this.yOffset=16;
						
						if (getRandom(64)>32) {
							// enter from right
							this.x=myWorld.displayW;
							this.xSpeed=-(3+getRandom(6))<<2;
						} else {
							this.x=-this.w;
							this.xSpeed=(3+getRandom(6))<<2;
						}
						
						myWorld.lastBlockX=-1;
						this.y=aY;
					break;
					
					case 2: // still, half-size
						this.w=20;
						this.h=5;
						this.xOffset=0;
						this.yOffset=16;
						
						if (aX<0) this.x=getRandom(myWorld.displayW-this.w);
						else aX=myWorld.lastBlockX;
						
						this.y=aY;
						
						myWorld.lastBlockX=this.x+10;
						this.subType=0;
					break;						
					
					case 3: // breakable (bounce once)
						this.w=20;
						this.h=5;
						this.xOffset=0;
						this.yOffset=16;
						
						if (aX<0) this.x=getRandom(myWorld.displayW-this.w);
						else aX=myWorld.lastBlockX;
						
						this.y=aY; //myWorld.worldOffsetY+(getRandom(myWorld.displayH>>4)<<4);
						
						myWorld.lastBlockX=this.x+10;
						this.subType=3;
					break;

					case 4:// bouncers
						this.w=16;
						this.h=16;
						this.xOffset=48;
						this.yOffset=16;
						
						if (myWorld.lastBlockX<0) {
							this.x=((getRandom(myWorld.displayW>>4)-4)+2);
							if (this.x<0) this.x=0;
							if (this.x>myWorld.displayW-16) this.x=myWorld.displayW-16;

							myWorld.lastBlockX=this.x;
							
							this.targetY=(5+getRandom(2));
							myWorld.lastBlockY=this.targetY;
						} else {
							
							this.x=((myWorld.lastBlockX-4)+getRandom(8));
							if (this.x<0) this.x=((getRandom(myWorld.displayW>>4)-4)+2);
							if (this.x>(myWorld.displayW>>4)-1) this.x=((getRandom(myWorld.displayW>>4)-4)+2);

							if (this.x<0) this.x=0;
							if (this.x>myWorld.displayW-16) this.x=myWorld.displayW-16;
							myWorld.lastBlockX=this.x;
							
							this.targetY=((getRandom( myWorld.displayH>>4 ))<<4);
							this.targetY+=myWorld.worldOffsetY;
							
						}
						
						this.x=this.x<<4;
						this.targetY=(this.targetY<<4);
						
						this.y=myWorld.worldOffsetY+myWorld.displayH;
						
						this.aiState=0;
						this.aiCountDown=32; //16+(getRandom(32));
						this.ySpeed=0;
					break;

					
					case 5: // vertical (starts moving down)
						this.w=40;
						this.h=5;
						this.xOffset=0;
						this.yOffset=16;
						
						this.x=aX;
						this.y=aY; // myWorld.worldOffsetY+(getRandom(myWorld.displayH>>4)<<4);
						this.startY=this.y;
						this.targetY=this.y+82;

						this.ySpeed=48;
					break;
											
					
					case 6: // vertical (starts moving up)
						this.w=40;
						this.h=5;
						this.xOffset=0;
						this.yOffset=16;

						this.x=aX;
						this.y=aY; // myWorld.worldOffsetY+(getRandom(myWorld.displayH>>4)<<4);
						this.targetY=this.y;
						this.startY=this.y-82;

						this.ySpeed=-48;
						this.subType=5;
					break;				
					
					case 7: // vertical blockade
						this.w=5;
						this.h=40;
						this.xOffset=41;
						this.yOffset=16;
					break;
					
					case 8: // big block with spikes on sides
						// monster is actually the gap, everything else on it's row is solid
						this.w=32;
						this.h=32;
						this.xOffset=0;
						this.yOffset=56;
						this.aiState=0;

						if (aX<0) this.x=getRandom(myWorld.displayW-this.w);
						else this.x=aX;
						
						
						this.targetX=this.x;
						this.w=160;
						
						myWorld.lastBlockX=this.x+20;
						this.y=aY;							
					break;
					
					
					case 9: // teleport-int
						this.w=36;
						this.h=5;
						this.xOffset=0;
						this.yOffset=26;
						
						if (aX<0) this.x=getRandom(myWorld.displayW-this.w);
						else aX=myWorld.lastBlockX;
						
						this.y=aY;
						
						myWorld.lastBlockX=this.x+10;
					break;
				}
			break;
			
			case Monster.mROCKETLAUNCH:
				this.w=16;
				this.h=20;
				
				if (getRandom(64)>32) {
					// enter from right
					this.x=myWorld.displayW-8;
					this.xSpeed=-(4<<4); //3+getRandom(6))<<4;
					this.xOffset=72;
					this.yOffset=0;
					this.subType=-1;
				} else {
					this.x=(0-this.w)+8;
					this.xSpeed=4<<4; //(3+getRandom(6))<<4;
					this.xOffset=56;
					this.yOffset=0;
					this.subType=1;
				}

				myWorld.lastBlockX=this.x;

				this.aiState=0;
				this.y=aY;
			break;
			
			case Monster.mROCKET:
				this.w=20;
				this.h=16;
				
				if (this.subType<0) { //getRandom(64)>32) {
					// enter from right
					this.x=myWorld.displayW-8;
					this.xSpeed=-(4<<4); //3+getRandom(6))<<4;
					this.xOffset=0;
					this.yOffset=0;
				} else {
					this.x=(0-this.w)+8;
					this.xSpeed=4<<4; //(3+getRandom(6))<<4;
					this.xOffset=20;
					this.yOffset=0;
				}

				myWorld.lastBlockX=this.x;

				this.aiState=1;
				this.y=aY;
			break;
			
			case Monster.mBOMB:
				this.w=16;
				this.h=16;
				this.xOffset=16;
				this.yOffset=0;
				
				switch (this.subType) {
					case 0:		// pickup
						this.aiState=0;
					break;
					
					case 1:		// thrown!
						this.aiState=1;
						if (this.SpriteSet>0) {
							this.xSpeed=64;
						} else {
							this.xSpeed=-64;
						}
						this.SpriteSet=0;
						this.xOffset=64;
						this.yOffset=48;
						
						this.ySpeed=-64;
					break;
				}
			break;
			
			case Monster.mSPIKES:
				this.w=20;
				this.h=5;
				this.xOffset=0;
				this.yOffset=21;
				
				this.aiState=this.subType;
				this.aiCountDown=96;
			break;
			
			
			case Monster.mLASER:
				this.w=16;
				this.h=20;
				this.xOffset=56;
				this.yOffset=0;
				
				this.aiState=0; // on
			break;
			
			case Monster.mSWITCH:
				this.w=16;
				this.h=9;
				this.xOffset=0;
				this.yOffset=20;
				this.aiState=0;
			break;
			
			
			case Monster.mROBOT:
				this.w=16;
				this.h=16;
				this.xOffset=0;
				this.yOffset=29;
				this.targetY=this.y;
				this.targetX=this.x;
				this.x=this.targetX+getRandom(24);
				this.myDirection=getRandom(2);
				if (this.myDirection==0) this.myDirection=-1;

				if (this.x>160-16) {
					this.x=160-16;
					this.myDirection=-1;
				}
				
				if (this.myDirection<0) {
					this.xSpeed=-16;
					this.xOffset=16;
				} else {
					this.xSpeed=16;
					this.xOffset=0;
				}
			break;
			
			case Monster.mCHOPPER:
				this.w=30;
				this.h=29;
				this.xOffset=0;
				this.yOffset=45;
				this.xOffsetAdd=30;
				this.targetX=this.x;
				if (this.targetX<myWorld.displayW>>1) {
					this.x=myWorld.displayW;
				} else {
					this.x=-this.w;
				}
				this.aiState=0;
			break;
			
			
			case Monster.mHOSTAGE:
				this.w=21;
				this.h=24;
				this.xOffset=144;
				this.yOffset=0;
				this.aiState=0;
			break;
			
			case Monster.mSPIKEY:
				this.w=12;
				this.h=12;
				this.xOffset=34;
				this.yOffset=21;
			break;
			
			
			case Monster.mRAZOR:
				this.w=27;
				this.h=27;
				this.y-=12;
				this.xOffset=0;
				this.yOffset=74;
				
				this.startX=this.x-80;
				this.targetX=this.x+80-this.w;
				if (getRandom(64)>32) {
					this.xSpeed=128;
					this.myDirection=1;
				} else {
					this.xSpeed=-128;
					this.myDirection=-1;
				}
				
				this.aiState=0;
			break;
			
			case Monster.mFAKEPLATFORM:
				this.w=20;
				this.h=5;
				this.xOffset=64;
				this.yOffset=16;
				
				if (aX<0) this.x=getRandom(myWorld.displayW-this.w);
				else aX=myWorld.lastBlockX;
				
				this.y=aY; //myWorld.worldOffsetY+(getRandom(myWorld.displayH>>4)<<4);
				
				myWorld.lastBlockX=this.x+10;
			break;
			
			case Monster.mMETEORITE:
				this.w=16;
				this.h=12;
				this.xOffset=64;
				this.yOffset=21;
				if (getRandom(100)>50) {
					this.x=myWorld.displayW+4;
					this.xSpeed=-60; //(6<<4);
				} else {
					this.x=-20;
					this.xSpeed=60;
				}
				
				this.ySpeed=40;
				
				this.startX=this.x;
				this.startY=this.y;
			break;
		}
		
		this.energy=this.maxEnergy;
		this.animDelay=this.animSpeed;
		this.floatX=this.x<<4;
		this.floatY=this.y<<4;
	}
		
		
		
		/**
		 * Update the monster
		 * @param myPlayer	The player object, so we know where he is and what he does
		 */
		this.update=function(myWorld, myPlayer, displayW) {
			var tx;
			var ty;
			var tx2;
			var ty2;
			
			if (this.y>myWorld.worldOffsetY+myWorld.displayH+16) this.died=true;
			
			
			var tmpPlayer;
			var hitPlayer=false;

			tmpPlayer=myPlayer;
			
			if (tmpPlayer.x+16>=this.x && tmpPlayer.x<this.x+this.w && tmpPlayer.y+16>=this.y && tmpPlayer.y<this.y+this.h) hitPlayer=true;
				
			if (this.hitCount>0) this.hitCount--;
			
			switch (this.myType) {
				case Monster.mPICKUP:
					this.floatY+=this.ySpeed;
					this.ySpeed+=this.yIncrease;
					if (this.ySpeed<-16) this.yIncrease=4;
					else if (this.ySpeed>16) this.yIncrease=-4;
					
					this.y=this.floatY>>4;
			
			
					if (hitPlayer) {
						this.died=true;
						this.doMoveSound=true;
						fxAdd(this.x, this.y-2, FX.fHINTS, 9);
						
						switch (this.subType) {
							case 1:	 // boost!
								myPlayer.ySpeed=-180;
								myPlayer.flameCountdown=32;
							break;
							
						}
					}
					
				break;
				
				
				case Monster.mPLATFORM:
					switch (this.subType) {
						case 0:	// still, big
							if (hitPlayer && myPlayer.prevY+16<=this.y && myPlayer.y+16>this.y) {
								this.targetX=myPlayer.x-this.x;
								myPlayer.bounce(this.y,1);
							}							
						break;
							

						case 1:	// horizontals
							this.floatX+=this.xSpeed;
							this.x=this.floatX>>4;
							if (this.xSpeed<0 && this.x<=0) {
								this.x=0;
								this.floatX=this.x;
								this.xSpeed=-this.xSpeed;
							} else if (this.xSpeed>0 && this.x>myWorld.displayW-this.w) {
								this.x=myWorld.displayW-this.w;
								this.floatX=this.x<<4;
								this.xSpeed=-this.xSpeed;
							}
					
							
							if (hitPlayer && myPlayer.prevY+16<=this.y && myPlayer.y+16>this.y) {
								this.targetX=myPlayer.x-this.x;
								myPlayer.bounce(this.y,1);
							}
						break;
						
						case 3:
							if (hitPlayer && myPlayer.prevY+16<=this.y && myPlayer.y+16>this.y) {
								targetX=myPlayer.x-this.x;
								myPlayer.bounce(this.y,1);

								for (var i=4; --i>=0;) {
									fxAdd(this.x+(i<<2),this.y, FX.fBOUNCEDEBRI, 3);
								}
								
								this.doFallSound=true;
								this.died=true;
								
							}
						break;
						
						case 5: // verticals
							this.floatY+=this.ySpeed;
							this.y=this.floatY>>4;
							if (this.ySpeed<0 && this.y<=this.startY) {
								this.y=this.startY;
								this.floatY=this.startY<<4;
								this.ySpeed=-this.ySpeed;
							} else if (this.ySpeed>0 && this.y>=this.targetY) {
								this.y=this.targetY;
								this.floatY=this.y<<4;
								this.ySpeed=-this.ySpeed;
							}
							
							if (myPlayer.x<=this.x+this.w && myPlayer.x+16>=this.x && myPlayer.prevY+16<=this.y+6 && myPlayer.y+16>=this.y) {
								myPlayer.bounce(this.y,1);
							}
							
						break;
							
						
						
						case 8: // big blocks

							
							if (myPlayer.y<this.y+128) {
								if (this.w>32) this.w-=(this.w-32)>>3;
								this.x=this.targetX-(this.w>>1);
							}
							
							if (myPlayer.y+6>=this.y && myPlayer.y+6<=this.y+this.h-2) {
								if (myPlayer.x+16>=this.x+this.w) {
									myPlayer.x=this.x+this.w-16;
									myPlayer.floatX=myPlayer.x<<4;
									myPlayer.xSpeed=0;
								}
								if (myPlayer.x<=this.x) {
									myPlayer.x=this.x;
									myPlayer.floatX=myPlayer.x<<4;
									myPlayer.xSpeed=0;
								}
							}
							
							
							if (myPlayer.prevY+16<=this.y && myPlayer.y+16>this.y && (myPlayer.x+4<this.x || myPlayer.x>this.x+32)) {
								myPlayer.bounce(this.y,1);
							}
							
							if (myPlayer.prevY>this.y+this.h && myPlayer.y<this.y+this.h && (myPlayer.x+4<this.x || myPlayer.x>this.x+32)) {
								myPlayer.y=this.y+this.h;
								myPlayer.floatY=myPlayer.y<<4;
								myPlayer.ySpeed=0;
							}
						break;
						
						
						
						case 9: // teleport in
							if (this.animDelay>0) this.animDelay--;
							else {
								this.animDelay=2;
								this.yOffset+=5;
								if (this.yOffset>41) this.yOffset=26;
							}
						break;
							
					}
				break;
				
				
				case Monster.mROCKETLAUNCH:
					switch (this.aiState) {
						case 0:
							if (this.y>=myPlayer.y-16) {
								this.aiState=1;
								this.aiCountDown=32;
								this.doMoveSound=true;
							}
							
							if (this.y>myWorld.worldOffsetY+myWorld.displayH) this.died=true;
						break;
						
						case 1:
							if (this.aiCountDown>0) this.aiCountDown--;
							else {
								this.aiCountDown=32;
								this.doMoveSound=true;
							}
							
							if (this.y>myWorld.worldOffsetY+myWorld.displayH) this.died=true;
						break;
					}
				break;
				
				
				case Monster.mROCKET:
					switch (this.aiState) {
						case 0:
							if (this.y>=myPlayer.y+16) {
								this.aiState=1;
								this.doMoveSound=true;
							}
						break;
						
						case 1:
							this.floatX+=this.xSpeed;
							this.x=this.floatX>>4;
							
							if (this.x<-16 && this.xSpeed<0) this.died=true;
							else if (this.x>myWorld.displayW && this.xSpeed>0) this.died=true;
							
							if (hitPlayer && myPlayer.prevY+16<=this.y && myPlayer.y+16>this.y) {
								this.ySpeed=myPlayer.ySpeed;

								myPlayer.bounce(this.y,1);
								myPlayer.addScore(100);
								
								fxAdd(myPlayer.x,myPlayer.y, FX.fPOW,0);
								this.doFallSound=true;
								
								this.aiState=2;
								this.xOffset=40;
								this.w=16;
								this.h=20;
								this.xSpeed=0;
							}
							
							if (myWorld.worldAge%2==0) fxAdd(this.x,this.y+getRandom(12),FX.fROCKETPUFF,0);
						break;
						
						case 2: // dive down
							this.floatY+=this.ySpeed;
							this.y=this.floatY>>4;
							if (this.y>myWorld.worldOffsetY+myWorld.displayH) {
								this.died=true;

								for (var i=4; --i>=0;) {
									fxAdd(this.x,this.y+getRandom(4)-8,FX.fROCKETPUFF,0);
								}
							}
						break;
					}
				break;
				
				
				case Monster.mBOMB:
					switch (this.aiState) {
						case 0:
							if (hitPlayer && !myPlayer.hasBomb) {
								myPlayer.hasBomb=true;
								this.died=true;
							}
						break;
						
						case 1:
							this.floatX+=this.xSpeed;
							this.floatY+=this.ySpeed;
							if (this.ySpeed<80) this.ySpeed+=16;
							this.y=this.floatY>>4;
							this.x=this.floatX>>4;
							if (this.y>myWorld.worldOffsetY+myWorld.displayH) this.died=true;
						break;
					}
				break;
				
				
				case Monster.mSPIKES:
					switch (this.aiState) {
						case 0:
							this.visible=false;
						break;
						
						case 1:
							this.visible=true;
							if (myPlayer.x+8>this.x && myPlayer.x+8<this.x+this.w && !myPlayer.died && myPlayer.ySpeed>0 && myPlayer.prevY+16<=this.y && myPlayer.y+16>this.y) {
//								myPlayer.died=true;
//								myPlayer.diedCountDown=24;
								myPlayer.playDead(this.x,-myPlayer.myDirection);
							}
						break;
					}
					
					if (this.aiCountDown>0) this.aiCountDown--;
					else {
						this.aiState=1-this.aiState;
						this.aiCountDown=96;
					}
				break;
				
				
				case Monster.mLASER:
					if (this.aiCountDown>0) this.aiCountDown--;

					switch (this.aiState) {
						case 0: // wait for on screen
							if (this.y>myWorld.worldOffsetYLowest) {
								this.aiState=1; // turn on!
								this.ySpeed=0;
							}
						break;
						
						case 1:
							this.floatY+=this.ySpeed;
							if (this.ySpeed<24) this.ySpeed++;
							this.y=this.floatY>>4;
							
							fxAdd(this.x+12+getRandom(myWorld.displayW-30), this.y+getRandom(24)-4, FX.fROCKETPUFF, 1);
							if (myWorld.worldAge%3==0) this.doMoveSound=true;
							
							if (myPlayer.y+14>this.y && myPlayer.y+2<this.y+16) {
								myPlayer.electrify();
							}
							
							if (myPlayer.invincable>0) this.aiState=2;
						break;
						
						case 2: // switched off
							this.floatY+=this.ySpeed;
							if (this.ySpeed<24) this.ySpeed++;
							this.y=this.floatY>>4;
						break;
					}
				break;
				
				case Monster.mSWITCH:
					switch (this.aiState) {
						case 0:
							if (hitPlayer && !myPlayer.died && myPlayer.ySpeed>0 && myPlayer.prevY+16<=this.y && myPlayer.y+16>this.y) {
								this.aiState=1;
								this.aiCountDown=64;
								this.xOffset+=16;
								this.doShoot=true;
							}
						break;
						
						case 1:
							if (this.aiCountDown>0) this.aiCountDown--;
							else {
								this.aiState=0;
								this.xOffset=0;
							}
						break;
					}
				break;
				
				
				case Monster.mROBOT:
					switch (this.aiState) {
						case 0:
							this.floatY+=this.ySpeed;
							this.y=this.floatY>>4;
							if (this.ySpeed<24) this.ySpeed+=8;
							if (this.y>=this.targetY) {
								this.y=this.targetY;
								this.floatY=this.y<<4;
								this.ySpeed=-16;
							}
							
							
							this.floatX+=this.xSpeed;
							this.x=this.floatX>>4;
								
							if (this.x<=this.targetX) {
								this.x=this.targetX;
								this.xSpeed=16;
								this.myDirection=1;
							} else if (this.x>this.targetX+80-16) {
								this.x=this.targetX+80-16;
								this.xSpeed=-16;
								this.myDirection=-1;
							} else if (this.x>146) {
								this.x=146;
								this.xSpeed=-16;
								this.myDirection=-1;
							}
							
							if (this.myDirection<0) {
								this.xSpeed=-16;
								this.xOffset=16;
							} else {
								this.xSpeed=16;
								this.xOffset=0;
							}
							
							
							if (this.aiCountDown>0) this.aiCountDown--;
							else {
								this.aiCountDown=8;
								if (this.myDirection>0 && myPlayer.x>this.x && myPlayer.y>this.y-32 && myPlayer.y<this.y+32) {
									bulletAdd(Bullets.OWNER_MONSTER, Bullets.bLASER, this.x,this.y, 1, myPlayer.x,myPlayer.y);
									doShoot=true;
								} else if (this.myDirection<0 && myPlayer.x<this.x && myPlayer.y>this.y-32 && myPlayer.y<this.y+32) {
									bulletAdd(Bullets.OWNER_MONSTER, Bullets.bLASER, this.x,this.y, -1, myPlayer.x,myPlayer.y);
									this.doShoot=true;
								}
							}
							
							if (hitPlayer && myPlayer.prevY+16<=this.y && myPlayer.y+16>this.y) {
								myPlayer.bump(this.y);
							}
						break;
					
						case 999:
							if (this.visible) {
								fxAdd(this.x,this.y, FX.fROBOTDEBRI, 0);
								fxAdd(this.x,this.y, FX.fROBOTDEBRI, 1);
								fxAdd(this.x,this.y, FX.fROBOTDEBRI, 2);
								fxAdd(this.x,this.y, FX.fROBOTDEBRI, 3);								
								this.visible=false;
							}
							if (this.aiCountDown>0) this.aiCountDown--;
							else this.died=true;
							
							myWorld.shakeCountDown=12;
									
							if (myWorld.worldAge%2==0) fxAdd(this.x+getRandom(12),this.y+getRandom(12),FX.fROCKETPUFF,0);
						break;
					}	
				break;
				
				
				case Monster.mCHOPPER:
					if (this.animDelay>0) this.animDelay--;
					else {
						this.xOffset+=this.xOffsetAdd;
						if (this.xOffset==90 || this.xOffset==0) this.xOffsetAdd=-this.xOffsetAdd;
						if (this.aiState>0 && (this.xOffset==30 || this.xOffset==90)) this.doMoveSound=true;
					}
					
					switch (this.aiState) {
					
						case 0:
							if (this.y>myPlayer.y-164) {
								this.aiState=1;
								this.aiCountDown=0;
							}
						break;
						
						case 1:
							if (myWorld.worldAge%8==0) {
								fxAdd(4+getRandom(48),myWorld.worldOffsetY+myWorld.displayH-(this.aiCountDown*48), FX.fHINTS, 5);
								this.aiCountDown++;
							}
							
							if (this.x<this.targetX) {
								this.xSpeed=(this.targetX-this.x)>>1;
								if (this.xSpeed>96) this.xSpeed=96;
							} else if (this.x>this.targetX) {
								this.xSpeed=(this.targetX-this.x)>>1;
								if (this.xSpeed<-96) this.xSpeed=-96;
							}
							
							this.floatX+=this.xSpeed;
							this.x=this.floatX>>4;
								
							if (this.y+this.h>myPlayer.y-16) {
								this.aiState=2;
								this.aiCountDown=8;
								this.xIncrease=9;
							}
						break;
						
						case 2:// up and drop rockets!
							if (this.x<this.targetX) {
								this.xSpeed=(this.targetX-this.x)>>1;
								if (this.xSpeed>96) this.xSpeed=96;
							} else if (this.x>this.targetX) {
								this.xSpeed=(this.targetX-this.x)>>1;
								if (this.xSpeed<-96) this.xSpeed=-96;
							}
							
							this.floatX+=this.xSpeed;
							this.x=this.floatX>>4;
						
							this.targetY=myWorld.worldOffsetY;
							
							if (this.y>this.targetY) {
								this.ySpeed=(this.targetY-this.y)>>1;
							}
							this.floatY+=this.ySpeed;
							this.y=this.floatY>>4;
							
							if (this.aiCountDown>0) this.aiCountDown--;
							else {
								this.aiCountDown=3;
								bulletAdd(Bullets.OWNER_ANYONE, Bullets.bLASERV, this.x+8+getRandom(10), this.y+24, 0,0,0);
								this.doShoot=true;
								this.xIncrease--;
								if (this.xIncrease<=0) {
									this.aiState=3;
									if (this.x<myWorld.displayW>>1) this.targetX=myWorld.displayW+64;
									else this.targetX=-this.w<<1;
								}
							}
						break;
						
						case 3:
							
							if (this.x<this.targetX) {
								this.xSpeed=(this.targetX-this.x)>>1;
								if (this.xSpeed>96) this.xSpeed=96;
							} else if (this.x>this.targetX) {
								this.xSpeed=(this.targetX-this.x)>>1;
								if (this.xSpeed<-96) this.xSpeed=-96;
							}
							
							this.floatX+=this.xSpeed;
							this.x=this.floatX>>4;

							if (this.x<-this.w || this.x>myWorld.displayW) this.died=true;
						break;
						
						case 998:
							if (this.x<myWorld.displayW>>1) this.targetX=myWorld.displayW+64;
							else this.targetX=-this.w<<1;
							
							this.xSpeed=0;
							this.aiState=999;
						break;
						
						case 999:
							if (this.targetX<0) this.xSpeed-=16;
							else this.xSpeed+=16;

							this.floatX+=this.xSpeed;
							this.x=this.floatX>>4;

							if (this.x<-this.w || this.x>myWorld.displayW) this.died=true;
							
							myWorld.shakeCountDown=12;
									
							if (myWorld.worldAge%2==0) { 
								fxAdd(this.x+getRandom(12),this.y+getRandom(12),FX.fROCKETPUFF,0);
							}
						break;
					}
					
						
					this.rotation=(this.xSpeed>>2);
					if (this.rotation<0) this.rotation+=360;
					if (this.rotation>360) this.rotation-=360;
				break;
				
				
				case Monster.mHOSTAGE:
					switch (this.aiState) {
						case 0:
							if (hitPlayer) {
								this.aiState=1;
								this.h=10;
								this.yOffset=14;
								this.xOffset=165;
								this.y+=14;
								
								myWorld.shakeCountDown=12;
								this.doExplodeSound=true;
								fxAdd(this.x,this.y, FX.fGLOBEDEBRI,0);
								fxAdd(this.x,this.y, FX.fGLOBEDEBRI,1);
								fxAdd(this.x,this.y, FX.fGLOBEDEBRI,2);
								fxAdd(this.x,this.y, FX.fGLOBEDEBRI,3);
								
								fxAdd(this.x-20, this.y-29, FX.fHINTS, 10);
							}
						break;
						
						case 1: // broken
						break;
					}
				break;
				
				case Monster.mSPIKEY:
					hitPlayer=false;
					if (tmpPlayer.x+14>=this.x+4 && tmpPlayer.x+2<this.x+this.w-4 && tmpPlayer.y+14>=this.y+4 && tmpPlayer.y+2<this.y+this.h-4) hitPlayer=true;
					if (hitPlayer) {
						myPlayer.electrify();
					}
				break;
				
				case Monster.mRAZOR:
					switch (this.aiState) {
						case 0:
							this.aiState=1;
							fxAdd(this.x,this.y-8, FX.fHINTS,8);
						break;
						
						case 1: // move
							if (this.myDirection>0 && this.xSpeed<96) this.xSpeed+=16;
							else if (this.myDirection<0 && this.xSpeed>-96) this.xSpeed-=16;
							
							this.floatX+=this.xSpeed;
							this.x=this.floatX>>4;
							if (this.myDirection>0 && this.x>=this.targetX) {
								this.x=this.targetX;
								this.floatX=this.x<<4;
								this.xSpeed=0;
								this.aiState=2;
								this.aiCountDown=32;
							} else if (this.myDirection<0 && this.x<=this.startX) {
								this.x=this.startX;
								this.floatX=this.x<<4;
								this.xSpeed=0;
								this.aiState=2;
								this.aiCountDown=32;
							}
						break;
						
						case 2:
							if (this.aiCountDown>0) this.aiCountDown--;
							else {
								this.aiState=1;
								this.myDirection=-this.myDirection;
								this.doMoveSound=true;
							}
						break;
					}
					
					fxAdd(this.x+8, this.y+12, FX.fBOUNCEDEBRI, getRandom(2));

					
					if (this.myDirection<0) this.rotation+=16;
					else this.rotation-=16;
					if (this.rotation>360) this.rotation-=360;
					else if (this.rotation<0) this.rotation+=360;
					
					hitPlayer=false;
					if (tmpPlayer.x+14>=this.x+4 && tmpPlayer.x+2<this.x+this.w-4 && tmpPlayer.y+14>=this.y+4 && tmpPlayer.y+2<this.y+9 && tmpPlayer.ySpeed>=0) hitPlayer=true;
					if (hitPlayer) {
						myPlayer.playDead(this.x,0);
					}
				break;
				
				case Monster.mFAKEPLATFORM:
					if (hitPlayer && myPlayer.prevY+16<=this.y && myPlayer.y+16>this.y) {
						for (var i=4; --i>=0;) {
							fxAdd(this.x+(i<<2),this.y, FX.fBOUNCEDEBRI, 3);
						}
						this.died=true;
						this.doFallSound=true;
					}							
				break;
				
				
				case Monster.mMETEORITE:
					switch (this.aiState) {
						case 0:
							if (this.y>myPlayer.y-64) {
								this.aiState=1;
								this.y=myPlayer.y-32;
								this.doMoveSound=true;
								
								if (this.xSpeed<0) fxAdd((myWorld.displayW>>1)-25,this.y-20, FX.fHINTS,11);
								else fxAdd((myWorld.displayW>>1)-25,this.y-20, FX.fHINTS,12);
							}
						break;
						
						case 1:
							this.floatX+=this.xSpeed;
							this.floatY+=this.ySpeed;
							this.x=this.floatX>>4;
							this.y=this.floatY>>4;
							
							myWorld.shakeCountDown=12;
							
							fxAdd(this.x+getRandom(8), this.y+getRandom(10)-4, FX.fROCKETPUFF, 1);
							
							if ( (this.xSpeed>0 && this.x>myWorld.displayW) || (this.xSpeed<0 && this.x<-this.w)) {
								this.x=this.startX;
								this.y=this.startY;
								this.floatX=this.x<<4;
								this.floatY=this.y<<4;
								this.doMoveSound=true;
							}

							if (hitPlayer && myPlayer.prevY+16<=this.y && myPlayer.y+16>this.y) {
								myPlayer.bounce(this.y,1);
								this.died=true;
								this.doExplodeSound=true;
								fxAdd(this.x,this.y, FX.fBOUNCEDEBRI, 4);
								fxAdd(this.x+8,this.y, FX.fBOUNCEDEBRI, 5);
								fxAdd(this.x+8,this.y+6, FX.fBOUNCEDEBRI, 6);
								fxAdd(this.x,this.y+6, FX.fBOUNCEDEBRI, 7);
								
								fxAdd(myPlayer.x,myPlayer.y, FX.fPOW,0);
							}							
						break;
						
					}
				break;
				
			}
			
		}
	
		
		
		this.hit=function( tmpBullet, myPlayer) {
			switch (this.myType) {
				case Monster.mPLATFORM:
						if (tmpBullet.myType==Bullets.bBOMB && tmpBullet.ySpeed>=0 && tmpBullet.y<this.y-12) {
							tmpBullet.y=this.y-16;
							tmpBullet.ySpeed=-32;
							tmpBullet.floatY=tmpBullet.y<<4;
						}
						
						if (tmpBullet.myType==Bullets.bLASERV) {
							for (var i=8; --i>=0;) {
								fxAdd(tmpBullet.x, this.y, FX.fBOUNCEDEBRI, getRandom(2));
							}

							for (var i=4; --i>=0;) {
								fxAdd(tmpBullet.x,this.y-16+getRandom(4),FX.fROCKETPUFF,0);
							}
							return true;
						}
				break;
				
				case Monster.mLASER:
					if (tmpBullet.myType==Bullets.bTRIGGER && this.aiCountDown==0) {
						this.aiCountDown=64;
						if (this.aiState!=2) {
							this.aiState=2; // OFF!
							this.xOffset+=32;
						}
					}
				break;
				
				case Monster.mROBOT:
					if (tmpBullet.myType==Bullets.bBOMB) {
						this.aiState=999;
						this.aiCountDown=16;
						fxAdd(myPlayer.x,myPlayer.y, FX.fPOW,0);
						
						if (this.x>80) fxAdd(this.x-32,this.y-16, FX.fHINTS,7);
						else if (this.x<80) fxAdd(this.x+32,this.y-16, FX.fHINTS,7);
						
						myPlayer.addScore(100);
						
						this.doFallSound=true;
						return true;
					}
				break;
				
				case Monster.mCHOPPER:
					if (tmpBullet.myType==Bullets.bBOMB) {
						this.aiState=998;
						this.aiCountDown=16;
						fxAdd(myPlayer.x,myPlayer.y, FX.fPOW,0);
						this.doFallSound=true;
						return true;
					}
				break;
			}
			return false;
		}
		
		
		

}




	
 function Player() {

	// position and status
	this.floatX=0;
	this.floatY=0;
	this.x=0;
	this.y=0;
	this.prevX=0;
	this.prevY=0;
	this.targetX=0;
	this.targetY=0;

	this.ySpeed=0;
	this.xSpeed=0;
	this.maxSpeed=0;
	this.myDirection=0;

	this.invincable=0;
	
	this.died=false;
	this.isElectrified=false;
	this.isPushed=false;
	this.diedCountDown=0;
	
	this.flameCountdown=0;
	
	// visual
	this.yOffset=0;
	this.xOffset=0;
	this.FrameDelay=0;
	this.actionDelay=0;
	
	
	this.plScore=0;
	this.plLevel=0;
	this.plHealth=0;
	
	this.spriteIndex=0;
	this.extraChars=new Array(32);
	
	this.hasBomb=false;
	
	// movement
	this.actionPressed=false;
	this.actionReleased=false;
	this.blockPlayerMovement=false;
	
	this.doShootSound=false;
	this.doHitSound=false;
	this.doTeleportSound=false;
	this.doPickupSound=false;
	this.doLevelUp=false;
	this.doJumpSound=false;
	
	this.newLife=function() {
		this.plScore=0;
		this.plLevel=1;
		this.plHealth=100;
	}
	
	
	// only need to clone the graphic set and x,y position
	this.clonePlayer=function(source) {
		this.xOffset=source.xOffset;
		this.yOffset=source.yOffset;
		this.x=source.x;
		this.y=source.y;
		this.flameCountdown=source.flameCountdown;
	}
	
	
	this.gameReset=function( startX, startY) {
		this.x=startX;
		this.y=startY;
		this.ySpeed=-80;
		
		this.floatX=this.x<<4;
		this.floatY=this.y<<4;

		this.xOffset=0;
		this.yOffset=0;
		this.FrameDelay=0;
		
		
		this.doShootSound=false;
		this.doHitSound=false;
		this.doTeleportSound=true;
		this.doPickupSound=false;
		this.doLevelUp=false;

		this.actionPressed=false;
		this.actionReleased=true;
		this.blockPlayerMovement=false;

		this.actionDelay=0;
		
		this.flameCountdown=0;
		this.myDirection=0;
		this.died=false;
		this.isElectrified=false;
		this.isPushed=false;
		
		this.hasBomb=false;
		this.spriteIndex=7;
		this.invincable=0;
		
		for (var i=32; --i>=0;) this.extraChars[i]=-1;
	}

	
	
	this.addScore=function( value) {
		this.plScore+=value;
	}
	
	
	this.update=function(myWorld) {
		
		if (this.invincable>0) {
			this.invincable--;
			fxAdd(this.x+getRandom(8), this.y+12, FX.fROCKETPUFF, 1);
		}
		
		if (this.died) {
			if (this.isPushed) {
				if (this.FrameDelay>0) this.FrameDelay--;
				else {
					this.xOffset+=16;
					if (this.xOffset>=112) this.xOffset=112;
					this.FrameDelay=4;
				}
				
				if (this.xSpeed>0) {
					this.xSpeed-=4;
					if (this.xSpeed<=0) this.xSpeed=0;
				}
				else if (this.xSpeed<0) {
					this.xSpeed+=4;
					if (this.xSpeed>=0) this.xSpeed=0;
				}
				if (this.ySpeed<128) this.ySpeed+=8;
				
				this.floatX+=this.xSpeed;
				this.floatY+=this.ySpeed;
				this.x=this.floatX>>4;
				this.y=this.floatY>>4;
			}
			if (this.extraChars[0]>=0 && this.diedCountDown>16) this.diedCountDown=16;
			if (this.diedCountDown>0) this.diedCountDown--;
			return;
		}
		
		if (this.isElectrified) {
			if (this.FrameDelay>0) this.FrameDelay--;
			else {
				this.died=true;
				this.diedCountDown=0;
			}
			
			if (this.FrameDelay%4<2) {
				this.xOffset=96;
				if (this.myDirection<0) this.yOffset=48;
				else this.yOffset=32;
			} else {
				this.xOffset=32;
				if (this.myDirection<0) this.yOffset=16;
				else this.yOffset=0;
			}
			
			return;
		}
		
		if (this.flameCountdown>0) {
			this.flameCountdown--;
			fxAdd(this.x+getRandom(8), this.y+12, FX.fROCKETPUFF, 1);
		}
		

		if (this.ySpeed<0) {
			if (this.xOffset>16) this.xOffset=0;
			if (this.FrameDelay>0) this.FrameDelay--;
			else {
				this.FrameDelay=4+getRandom(4);
				this.xOffset+=16;
				if (this.xOffset>16) this.xOffset=0;
			}
		} else {
			if (this.xOffset<32 || this.xOffset>48) this.xOffset=32;
			
			if (this.FrameDelay>0) this.FrameDelay--;
			else {
				this.FrameDelay=4+getRandom(4);
				this.xOffset+=16;
				if (this.xOffset>48) this.xOffset=32;
			}
		}

		
		this.prevY=this.y;	// used for platform tests
		this.floatY+=this.ySpeed;
		this.y=this.floatY>>4;
		
		if (this.ySpeed<160) this.ySpeed+=8;

		if (this.y>myWorld.worldOffsetY+myWorld.displayH) {
			if (!this.died) {
				fxAdd(this.x,myWorld.worldOffsetY+myWorld.displayH-16, FX.fOUCH, 0);
				this.died=true;
				this.diedCountDown=48;
				this.doHitSound=true;
			}
		}
		
		this.prevX=this.x;
		this.floatX+=this.xSpeed;
		this.x=this.floatX>>4;
		
		if (this.x<0) {
			this.x=0;
			this.xSpeed=0;
			this.floatX=this.x<<4;
		}
		if (this.x>myWorld.displayW-16) {
			this.x=myWorld.displayW-16;
			this.floatX=this.x<<4;
			this.xSpeed=0;
		}
		
		
		if (this.myDirection>0) this.yOffset=0;
		else this.yOffset=16;
		
		if (this.actionPressed) {
			if (this.hasBomb) {
				this.doShootSound=true;
				this.hasBomb=false;
			}
			
			this.actionPressed=false;
		}
			
	}
	
	this.bounce=function( floor,  strength) {
		this.y=floor-16;
		this.floatY=this.y<<4;
		this.ySpeed=-160*strength;
		this.doJumpSound=true;
		for (var i=8; --i>=0;) {
			fxAdd(this.x+8, floor, FX.fBOUNCEDEBRI, getRandom(2));
		}
	}

	this.bump=function(floor) {
		this.y=floor-16;
		this.floatY=this.y<<4;
		this.ySpeed=-96;
		this.doJumpSound=true;
		for (var i=8; --i>=0;) {
			fxAdd(this.x+8, floor, FX.fBOUNCEDEBRI, getRandom(2));
		}
	}
	
	this.hitByMonster=function(tmpMonster) {
		if (this.died || this.isElectrified || this.invincable>0) return;
		
		fxAdd(this.x,this.y-16, FX.fOUCH, 0);
		this.died=true;
		this.diedCountDown=48;
		this.doHitSound=true;
	}
	
	
	this.die=function( tmpBullet,  myWorld) {
		if (this.died || this.invincable>0 || this.isElectrified) return;
		
		fxAdd(this.x,this.y-16, FX.fOUCH, 0);
		this.died=true;
		this.diedCountDown=48;
		this.doHitSound=true;
	}
	
	this.electrify=function() {
		if (this.isElectrified || this.died || this.invincable>0) return;
		
		this.doHitSound=true;
		
		this.xOffset=96;
		if (this.myDirection<0) this.yOffset=48;
		else this.yOffset=32;
		
		fxAdd(this.x,this.y-16, FX.fZAP, 0);
		
		this.isElectrified=true;
		this.FrameDelay=48;
		this.ySpeed=0;
		this.xSpeed=0;
	}
	
	
	this.playDead=function( mx,  mDirection) {
		if (this.died || this.invincable>0 || this.isElectrified) return;
		this.doHitSound=true;
		
		fxAdd(this.x,this.y-16, FX.fOUCH, 0);
		this.died=true;
		this.diedCountDown=48;
		
		this.xOffset=64;
		this.FrameDelay=4;
		
		if (this.mDirection!=0) {
			if (this.mDirection>0) {
				this.xSpeed=96;
				this.yOffset=0;
			} else {
				this.xSpeed=-96;
				this.yOffset=16;
			}
		} else {
			if (mx<this.x) {
				this.xSpeed=96;
				this.yOffset=0;
			} else {
				this.xSpeed=-96;
				this.yOffset=16;
			}
		}
		this.ySpeed=-32;
		this.isPushed=true;
	}
	
	
	this.Paint=function(sprite, myWorld) {
		var ty=this.y-myWorld.worldOffsetY;
		var moffsetAdd=0;
		
		if (this.hasBomb) moffsetAdd=32;
		
		renderSubImageAtPoint(sprite, this.x,ty, this.xOffset,this.yOffset+moffsetAdd, 16,16);
		
		if (this.hasBomb) {
			// render bomb!
			ty-=15;
			renderSubImageAtPoint(sprite, this.x,ty, 64,48, 16,16);
		}
	}
	
	
	
	
	
	
}
 function TileMap() {

	TileMap.tileMapW = 32;
	TileMap.tileMapH = 32;
	
	TileMap.type_GENERAL = 0, // platforms mostly
	TileMap.type_LASER = 1,
	TileMap.type_ENERGY = 2,
	TileMap.type_SAW = 3;

				
	this.shakeCountDown=0;
	this.worldOffsetX=0;
	this.worldOffsetY=0;
	this.worldAge=0;
	this.worldNextHero=0;
	this.worldNextHeroID=0;
	this.chapter=0;
	
	this.worldOffsetYLowest=0;
	this.displayW=0;
	this.displayH=0;
	
	this.lastBlockX=0;
	this.lastBlockY=0;
	
	this.lastType=0;
	
	this.drinkCount=0;
	
	this.didHintRocket=false;
	this.didHintBomb=false;
	this.didHintSwitch=false;
	this.didHintSave=false;
	this.didHintMeteor=false;
	this.didHintCan=false;
	
	this.strictDelete=false; 

	
	// tile map contains nice scenery and stuff
	this.tileMap=new Array(TileMap.tileMapW*TileMap.tileMapH);
	this.heroSquad = new Array(32);

	
	this.init=function() {
		this.didHintRocket=false;
		this.didHintBomb=false;
		this.didHintSwitch=false;
		this.didHintSave=false;
		this.didHintMeteor=false;
		this.didHintCan=false;
		
		this.drinkCount=0;
		
		this.worldNextHero=-2000;
		this.worldNextHeroID=1;
		this.chapter=1;
		this.shakeCountDown=0;
		
		this.strictDelete=false;
		this.lastType=TileMap.type_GENERAL;
	}
	
	
	this.put=function( x,  y,  tile) {
		this.tileMap[x+(y*TileMap.tileMapW)]=tile;
	}

	
	this.isSolid=function( tx, ty) {
		if (tx<=0 || ty<=0 || tx>=TileMap.tileMapW || ty>=TileMap.tileMapH || 
			(this.tileMap[tx+(ty*TileMap.tileMapW)]!=0 && this.tileMap[tx+(ty*TileMap.tileMapW)]!=9)) return true;
		return false;
	}
	
	this.isSolidForMonster=function( tx, ty) {
		if (tx<=0 || ty<=0 || tx>=TileMap.tileMapW || ty>=TileMap.tileMapH || this.tileMap[tx+(ty*TileMap.tileMapW)]!=0) return true;
		return false;
	}

	this.getTile=function( x,  y){
		if (x>=0 && y>=0 && x<TileMap.tileMapW && y<TileMap.tileMapH) return this.tileMap[x+(y*TileMap.tileMapW)];
		return -1;
	}

	
	this.clean=function( tile) {
		for (var y=TileMap.tileMapH; --y>=0;) {
			for (var x=TileMap.tileMapW; --x>=0;) {
				if (this.tileMap[x+(y*TileMap.tileMapW)]==tile) this.tileMap[x+(y*TileMap.tileMapW)]=0;
			}
		}
	}
	


}