posmos = {};

posmos.exportSvc = {importFolderId:null};

posmos.exportSvc.gdrive = function ()
{
    this.authorizeSectionId = 'authorizeSection';
    this.syncSectionId = 'exportSection';

    if(window.cordova || true) {
        this.CLIENT_ID = '746094888773.apps.googleusercontent.com';
        this.CLIENT_SECRET = 'rqPxcy1ZnK3LCWDGlCL77eM1';
    } else {
        this.CLIENT_ID = '746094888773-n77ej6mkd10753oisfltgk99n52fe9gs.apps.googleusercontent.com';
    }
     
    this.SCOPES = 'https://www.googleapis.com/auth/drive';
    
	this.unauthorize = function () {
		var oAuth = liquid.helper.oauth;oAuth.unAuthorize();
	};

    this.load = function () {
		this.checkAuth();
    };
    
    this.checkAuth = function (immediate) {
        if(window.cordova || true) {
			var oAuth = liquid.helper.oauth;
 
			var authSection = document.getElementById(this.authorizeSectionId);
			var exportSection = document.getElementById(this.syncSectionId);

			authSection.style.display = 'none';
			exportSection.style.display = 'none';
     
		   if(oAuth.isAuthorized()) {
		   
				liquid.helper.oauth.getAccessToken(function(tokenObj) {
				   /* at first set the access Token */
					gapi.auth.setToken({
						access_token: tokenObj.access_token
					});
			   });
						   
				$.mobile.loading( 'hide' );
				exportSection.style.display = 'block';
		   } else {
				authSection.style.display = 'block';
				oAuth.authorize(jQuery.proxy(this.liquidHandleAuthResult, this));
		   }
        } else {
            if(immediate == undefined) { immediate = true; }
			
            gapi.auth.authorize(
                {'client_id': this.CLIENT_ID, 'scope': this.SCOPES, 'immediate': immediate},
                jQuery.proxy(this.handleAuthResult, this));
            gapi.client.load('drive', 'v2');
        }
     };
    
    this.liquidHandleAuthResult = function ()
    {
        $.mobile.loading( 'hide' );
		var authSection = document.getElementById(this.authorizeSectionId);
		var exportSection = document.getElementById(this.syncSectionId);

        authSection.style.display = 'none';
        exportSection.style.display = 'none';
 
    	var oAuth = liquid.helper.oauth;
		if (oAuth.requestStatus == oAuth.status.SUCCESS) {
        	var authCode = oAuth.authCode;

			 oAuth.saveRefreshToken({
					  auth_code: oAuth.authCode
				 }, function() {
						liquid.helper.oauth.getAccessToken(function(tokenObj) {
						   /* at first set the access Token */
							gapi.auth.setToken({
								access_token: tokenObj.access_token
							});
					   });
						exportSection.style.display = 'block';
				 });
        } else if (oAuth.requestStatus == oAuth.status.ERROR) {
       		authSection.style.display = 'block';
		} else {
			authSection.style.display = 'block';
		}
    };
 
    this.handleAuthResult = function(authResult) {
        $.mobile.loading( 'hide' );
		var authSection = document.getElementById(this.authorizeSectionId);
		var exportSection = document.getElementById(this.syncSectionId);

        authSection.style.display = 'none';
        exportSection.style.display = 'none';
        
		if (authResult && !authResult.error) {
          // Access token has been successfully retrieved, requests can be sent to the API.
          exportSection.style.display = 'block';
          //exportButton.onchange = this.exportEntity();
        } else {
          // No access token could be retrieved, show  the button to start the authorization flow.
          authSection.style.display = 'block';
        }
      };
      
      this.exportEntity = function (entity)
      {
            $.mobile.loading( 'show', { text: system.translate("exportando") });
            this.entity = entity;
            //gapi.client.load('drive', 'v2', jQuery.proxy(this._exportEntity, this));
            this._exportEntity();
      };

      this.importEntity = function (entity, fileId)
      {
            $.mobile.loading( 'show', { text: system.translate("importando") });
            this.entity = entity;
			//this.fileId = fileId;
			this.fileId = (document.getElementById("import_files").value);
			var _callback = function (res) { console.log(res); };
			this.downloadFile({downloadUrl:this.fileId}, jQuery.proxy(this._importEntity, this));
      };


      this._exportEntity = function ()
      {
           entities[this.entity].exportToCsv(jQuery.proxy(this.exportFile, this));
      };

      this._importEntity = function (result)
      {
		  var _callback = function(rowsImported) {
				$.mobile.loading( 'hide' );
				document.getElementById('import_msg').innerHTML = 
				"" + rowsImported + " registros importados."
				
				$('#popupImportDone').popup();
				$('#popupImportDone').popup('open');
			};
			entities[this.entity].importFromCsv(result, _callback);
			
      };

      this.downloadFile = function(file, callback) {
	    if (file.downloadUrl) {
			var accessToken = gapi.auth.getToken().access_token;
			var xhr = new XMLHttpRequest();
			xhr.open('GET', file.downloadUrl);
			xhr.setRequestHeader('Authorization', 'Bearer ' + accessToken);
			xhr.onload = function() {
			  callback(xhr.responseText);
			};
			xhr.onerror = function() {
			  callback(null);
			};
			xhr.send();
		  } else {
			callback(null);
		  }
	 };
      
	  this.getFile = function(fileId, callback) {
		  //alert("Getting file"+fileId+"with callback"+callback);
/*		  var request = gapi.client.drive.files.get({
			'fileId': fileId
		  });*/
		  var request = gapi.client.request({
	        		      	'path': '/drive/v2/files/'+fileId,
		        	      	'method': 'GET',
              				'params': { 'fileId': fileId }
	              		});


		  request.execute(callback);
	  };

		this._getFiles = function(filesList, callback)
		{
			var _tmpList = filesList;
			var _count = 0;
			//alert("_! :)" + filesList.length);
			for(var i = 0; i < filesList.length; i++) {
				//alert("F: "+JSON.stringify(filesList));
				this.getFile(filesList[i].id, jQuery.proxy(function(response) {
//					alert("App PDF");
					if(response.exportLinks && response.exportLinks["application/pdf"]) {
						var exportPdf = response.exportLinks["application/pdf"];
						response.exportCsv = exportPdf.substring(0, exportPdf.length-4) + "=csv";
					}
					_tmpList[this.i] = response;
					
					_count++;
				}, {i:i}));
			}
			
			//alert("2");
			_checkAnk = 0;
			
			var checkFinished = function () {
				if(_count < _tmpList.length && _checkAnk < 15) {
					_checkAnk++;
					setTimeout(checkFinished, 100);
				} else {
					callback(_tmpList);
				}
			};
			//alert("finished!");	
			checkFinished();
		};

	  this.retrieveAllFilesInFolder = function(folderId, callback, q) {
		  var _tmp = this;
		  //alert("Searching on "+folderId);
		  var retrievePageOfChildren = function(request, result) {
		    //alert("Executing request"+request.execute);
			request.execute(function(resp) {
			//  alert("Checking resp"+JSON.stringify(resp));
			  result = result.concat(resp.items);
			  var nextPageToken = resp.nextPageToken;
			  if (nextPageToken) {
				 request = gapi.client.request({
	        		      	'path': '/drive/v2/files/'+folderId+'/children',
		        	      	'method': 'GET',
              				'params': {'folderId': folderId, 'q': q, 'pageToken':nextPageToken }
	              		});

				retrievePageOfChildren(request, result);
			  } else {
				//alert("Get files..."+JSON.stringify(result));
				_tmp._getFiles(result, callback);
			  }
			});
			//alert("No syntax error");
		  };
		  
/*		  var initialRequest = gapi.client.drive.children.list({
			  'folderId' : folderId, 'q': q
			});*/
		 var initialRequest = gapi.client.request({
	              	'path': '/drive/v2/files/'+folderId+'/children',
        	      	'method': 'GET',
              		'params': {'q': q, 'folderId': folderId }
              		});
		//alert(initialRequest);
		  //alert(initialRequest.execute);
		  retrievePageOfChildren(initialRequest, []);
		};

		this._getImportFolderId = function (_callback) {
			if(posmos.exportSvc.importFolderId) {
		
			} else {
				var setFolderId = function (res) {
				
					if(res && res.length > 0) {
						var dir = res[0];
						posmos.exportSvc.importFolderId = dir.id;
						
						if(_callback) {
							setTimeout(_callback, 300);
						}
					}
				};
				this.retrieveAllFilesInFolder('root', jQuery.proxy(setFolderId, this),
					"mimeType = 'application/vnd.google-apps.folder' and title = '"+storage.local.find('setting', 'sync_import_folder', 'skinkpos.1.import')+"'"
				);
			}
			
			return posmos.exportSvc.importFolderId;
		};
		
		this.loadFilesToImport = function () {
		    if(liquid.helper.oauth.isAuthorized()) {
				$.mobile.loading( 'show' );
				
				if(posmos.exportSvc.importFolderId) {
					this.retrieveAllFilesInFolder(posmos.exportSvc.importFolderId,
						jQuery.proxy(ui.fillSelect, { selectId: 'import_files', text: 'title', value: 'exportCsv', clean: true})
						, "mimeType = 'application/vnd.google-apps.spreadsheet'");
					$.mobile.loading( 'hide' );
				} else {
					this._getImportFolderId(jQuery.proxy(this.loadFilesToImport, this));
				}
			} else {
				this.load();
			}
		};
				
      this.exportFile = function (data)
      {
        const boundary = '-------314159265358979323846';
        const delimiter = "\r\n--" + boundary + "\r\n";
        const close_delim = "\r\n--" + boundary + "--";

        var contentType = 'text/csv'
        var metadata = {
            'title': 'skink.export_'+this.entity+'_'+(new Date().getTime())+'.csv',
            'mimeType': contentType
        };

        var multipartRequestBody =
              delimiter +
              'Content-Type: application/json\r\n\r\n' +
              JSON.stringify(metadata) +
              delimiter +
              'Content-Type: '+contentType+'\r\n' +
              'Content-Transfer-Encoding: ascii\r\n' +
              '\r\n' +
              (data) +
              close_delim;

          var request = gapi.client.request({
              'path': '/upload/drive/v2/files',
              'method': 'POST',
              'params': {'uploadType': 'multipart'},
              'headers': {
                'Content-Type': 'multipart/mixed; boundary="' + boundary + '"'
              },
              'body': multipartRequestBody});
        
        var callback = function(file) {
            $.mobile.loading( 'hide' );
            document.getElementById('export_msg').innerHTML = 
            file.lastModifyingUserName + ', ' +system.translate('exportacion_completa_leyenda') + ' '+ file.title;
            document.getElementById('export_href_file_gdrive').setAttribute('url', file.alternateLink);
            
            $('#popupExportDone').popup();
            $('#popupExportDone').popup('open');
        };
            
        request.execute(callback);
      };
      
};

posmosExport = new posmos.exportSvc.gdrive();
posmosImport = new posmos.exportSvc.gdrive();
posmosImport.authorizeSectionId = 'authorizeSectionImport';
posmosImport.syncSectionId = 'exportSectionImport';

function posmosExportLoad ()
{
    posmosExport.load();
}

function posmosImportLoad ()
{
    posmosImport.load();
//    gapi.client.load('drive', 'v2', function(){ posmosImport.load(); });
			//Searching folder: "mimeType = 'application/vnd.google-apps.folder' and title='skinkpos.1.import'"
		//SKINK POS: 0B-yi7ceI9a1VbzhXXzIyeS1CTFU
		//Searching xls: "mimeType = 'application/vnd.google-apps.spreadsheet'"

}