function disableTouch (event)
{
    event.preventDefault ();
}

function getUrlVars(url)
{
    if(typeof(url) == 'undefined') {
	url = window.location.href;
    }

    var vars = {}, hash;
	  
    var hashes = url.slice(url.indexOf('?') + 1).split('&');

    for(var i = 0; i < hashes.length; i++)
    {
        hash = hashes[i].split('=');
        vars[hash[0]] = hash[1];
    }
    return vars;
}

var system = {station:{uniqid:1}};

system.getUniqId = function ()
{
	system.station.uniqid = storage.local.find('setting', 'station_uniqid', settings.station.uniqid);
	return system.station.uniqid + '-' + system.getUnixTimestamp();
};

system.getUnixTimestamp = function () 
{
	return Math.round((new Date()).getTime() / 1000);
};

system.scan = function (callback)
{
    //if(window.plugins && window.plugins.barcodeScanner) {
        /*window.plugins.barcodeScanner.scan( function(result) {
                alert("Codigo de barras: \n" +
                        "Resultado: " + result.text + "\n" +
                          "Formato: " + result.format + "\n" +
                          "Cancelado: " + result.cancelled);
                //Redirect to the entity founded
                
            }, function(error) {
                alert("Fallo el scanner: " + error);
            }
        );*/
		
		 var scanner = cordova.require("cordova/plugin/BarcodeScanner");

		 scanner.scan(
			 callback,
			  /*function (result) {
				 alert("We got a barcode\n" +
						"Result: " + result.text + "\n" +
						"Format: " + result.format + "\n" +
						"Cancelled: " + result.cancelled);
			  },*/ 
			  function (error) {
				  alert("Error: " + error);
			  }
		  );
    /*} else {
        var test = true;
        var testValue = "1";
        if(test) {
            //entities.client.find(testValue, undefined, system._scan);
            entities.product.find(testValue, undefined, system._scan);
        } else {
            
        }
    }*/
};

system._scanPid = null;

system._scan = function (entity)
{
    if(entity.id && entity.id > 0) {
        //console.log(entity);
        system.showOperations(entity);
    }
};

//TODO: SetTimeout
//system.__scan = function ()
//{

//};

system.showOperations = function (entity)
{
    switch(entity.type) {
        case 'product':
            $('#page_product_operations').popup();
            $('#page_product_operations').popup('open');
            break;
    }
};
/** Entities **/

var entities = {};

entities.abstract = function (properties)
{
	this.properties = properties;
    
	var persistenceMethod = properties.persistence.method;

	this.type = properties.persistence.type;
	
	this.storage = storage[persistenceMethod];
	
	this.find  = function (id, defaultValue, callback) {
        var _tmp = {callback:callback, type: this.type, defaultValue: defaultValue, entity: this};
		this.storage.find(this.type, id, defaultValue, jQuery.proxy(this._find, _tmp));
	};
    
    this.exportToCsv = function (callback) { 
        storage.exportSvc.toCsv(this.type, this.storage, callback);
    };
	
	this.importFromCsv = function (content, callback) 
	{
		storage.exportSvc.fromCsv(content, this.type, this.storage, callback);
	};

	this.formatField = function (field, value)
	{
		if(this.properties['format'] && this.properties.format[field]) {
			var format = this.properties.format[field];
		} else {
			var format = '';
		}
		
		switch(format) {
			case 'currency':
				value = system.showCurrency(value);
				break;
			case 'date':
				value = system.showDate(value);
				break;
			default:
				break;
		}
		
		return value;
	};
	
	this._find = function (obj)
	{
		var entityObj = null;
		
		if(obj == null && this.defaultValue !== undefined) {
			obj = this.defaultValue;
		}
		
		if(entity.factory[this.type] == undefined) {
			entityObj = new entity(this.type, obj);
		} else {
			entityObj = new entity.factory[this.type](this.type, obj);
		}
		
        return this.callback (entityObj);
	};
	
	this.query  = function (query, queryCallback) { return this.storage.query(this.type, query, queryCallback); };
	this.count  = function () { return this.storage.count (this.type); };
	this.sync   = function () {};
	this.save   = function (id, data) {
		return this.storage.save (this.type, id, data); 
	};
    
    this.clean = function () {
        this.storage._cleanEntity(this.type);
    };

    this._serializeForm = function (form)
    {
        return serializeForm(form);
    };
    
	this.saveFromForm = function (form, moveTo) {
	
		var data = this._serializeForm(form);
		var id   = data.id;

		this.save (id, data);

		if(moveTo !== undefined) {
			//setTimeout(jQuery.proxy(this.updateList, this), 300);
			setTimeout(function(){$.mobile.changePage(moveTo, 'slideup');},
						300);
			//$.mobile.changePage('#page_impuestos', 'slideup');
		}
		
		
	};

	this.remove = function (id)   { return this.storage.remove(this.type, id);  };

	this.listItemHtml = "<a onclick='entities.@TYPE@.edit(\"@ID@\");' data-role='button' data-inline='true'>@ID@ (@NOMBRE@)</a><a href='#' onclick='entities.@TYPE@.remove(\"@ID@\");entities.@TYPE@.refreshList()' data-icon='delete' data-role='button' data-inline='true'>B</a>";

	this.updateList = function (listId, listItemHtml, query) {
			if(listId == undefined || listId == null) {
				listId = this.type + '_list';
			}
			
			if(listItemHtml == undefined || listItemHtml == null) {
				listItemHtml = this.listItemHtml;
			}
			//console.log(this._listItemHtml);
			
			this.listId = listId;
			this._listItemHtml = listItemHtml;
	
			this._lastItemHtml = listItemHtml;
			this._lastQuery    = query;
			this._lastListId   = listId;
	
			this.query (query, jQuery.proxy(this._updateList, this));
	};

	this._lastItemHtml = null;
	this._lastQuery    = null;
	this._lastListId   = null;
	
	this.refreshList = function ()
	{
		this.updateList(this._lastListId, this._lastItemHtml, this._lastQuery);
	};
	
	this._updateList = function (list) {
		var domList = $('#'+this.listId);
		var domItem = domList[0]; domItem.innerHTML = null;
        
  		for(var key in list) {
		
		    var item = document.createElement ('li');
		    var entity = list[key];
		    entity.type = this.type;
		    var itemHtml = this._listItemHtml;
	
			for(var field in entity) {
				if(typeof(entity[field]) == 'string'|| typeof(entity[field]) == 'number' ) { 
					itemHtml = 
					itemHtml.replace(new RegExp("@"+field.toUpperCase()+"@", "gi"), entities[this.type].formatField(field, entity[field]));    
				}
		    }
			 
	  	    item.innerHTML = itemHtml;
			
		    domItem.appendChild (item);
		}

		$('#'+this.listId).listview('refresh');
	};
	
	this.fillForm = function (id) {
		this.cleanForm ();
		
  		var form = document.getElementById(this.type+'_form');
		
		var _tmp = {form: form, entity: this};
		
		this.find (id, null, jQuery.proxy(this._fillForm, _tmp));
 	};
	
	this.prePopulate = function (obj)
	{
		return obj;
	};

	this._fillForm = function (obj)
	{
		var form = this.form;

		obj = this.entity.prePopulate(obj);

		for(var field in obj.data) {
			if(form[field] == undefined) {
			} else if(form[field].tagName == 'SELECT'){
				
				//$(form[field])."#my-Select option[text=" + myText +"]").attr("selected","selected") ;
				console.log(form[field]);
				
				if(form[field].getAttribute('data-role') == 'slider' || form[field].getAttribute('data-role') == 'flipswitch') {
					$(form[field]).val(obj.data[field]);
				} else {
					$(form[field]).val(obj.data[field]);
					$(form[field]).selectmenu();
					$(form[field]).selectmenu("refresh");
					//$(form[field]).selectmenu("refresh");
				}
			} else {
				form[field].value = obj.data[field];
			}
		}	
	};

	this.edit = function (id) {
		this.fillForm(id);
		$.mobile.changePage('#page_'+this.type+'_edit');
	};
	
	this.view = function (id) {
		this.find (id, null, jQuery.proxy(this.render, {id: id, renderType:'view'}));
		$.mobile.changePage('#page_'+this.type+'_view');
	};
	
	this.render = function (obj)
	{
		
	};
	
	this.cleanForm = function () {
		var form = document.getElementById(this.type+'_form');	
	
		form.reset();
		if(form.id !== undefined) {
			form.id.value = '0';
		}
	};
};

entities.init = function ()
{
	for (var key in settings.entities) {
		entities[key] = new entities.abstract(settings.entities[key]);
	}
};

/** End Entities **/

/** Entity **/
var entity = function (type, data)
{
	this.data = data;
	this.type = type;
	
	if(data == undefined || data.id == undefined) {
		this.id = 0;
	} else {
		this.id = data.id;
	}

	this.save = function (data) {
		entities[this.type].save (this.id, data);
	};

	this.remove = function (id) {
		entities[this.type].remove(id);
	};
};

entity.factory = {};

/** End Entity **/

/** Storage classes**/
var storage = {};

/** by definition every object to save need to have a type **/
storage.local = {};

storage.local.queryCb = null;

storage.local._get = function (id)
{
	if(localStorage[id] == undefined) {
		var list = {};
	} else {
		try {
			var list = JSON.parse(localStorage[id]);
		} catch (e) {
			var list = {};
		}
	}
	
	if(storage.local.queryCb !== undefined && storage.local.queryCb) {
		storage.local.queryCb(list);
	}
	
	storage.local.queryCb = null;
	
	return list;
};

storage.local._init = function ()
{
};

storage.local._initEntity = function ()
{
};

storage.local._set = function (id, obj)
{
	localStorage[id] = JSON.stringify(obj);
};

storage.local.save = function (type, id, obj)
{
	if(id !== undefined && id != 0 && id != null && (id > 0 || id.length > 1)) {
		//console.log(id);	
	} else {
		id = storage.local.count(type)+1;
	}

	obj.id = id;

	var list = storage.local._get(type);

	if(list == undefined || typeof(list) !== 'object') {
		list = {};
	}
	
	list[id] = obj;

	storage.local._set(type, list);	
};

storage.local.find = function (type, id, defaultValue, callback)
{
	var list = storage.local._get(type);
	
	if(list[id]) {
		var value = list[id];
	} else {
		if(typeof(defaultValue) == 'undefined') {
			var value = false;
		} else {
			var value = defaultValue;
			storage.local.save(type, id, defaultValue);
		}
	}

	if(callback !== undefined) {
		callback(value);
	}
	
	return value;
};

storage.exportSvc = {};

storage.exportSvc.toCsv = function (type, _storage, callback)
{
    this.callback = callback;
    _storage.query(type, null, jQuery.proxy(storage.exportSvc._toCsv, this));
};

storage.exportSvc._toCsv = function (data)
{
    var csv = "";
    var hasHeader = false;
    var header ="";
    
    for(var rowId in data) {
        for(var key in data[rowId]) {
            if(!hasHeader) {
                header += '"'+key+'",';
            }
            csv += '"'+data[rowId][key]+'",';
        }
        hasHeader = true;
        csv += "\n";
    }
    
    this.callback(header + '\n' + csv);
};

storage.exportSvc.fromCsv = function (content, type, _storage, callback)
{
	var lines = content.split("\n");
	var header = lines[0].split(",");
	
	for(var i = 1; i < lines.length; i++) {
		var obj = {id:0};
		var row = lines[i].split(",");
		for(var j = 0; j < header.length; j++) {
			obj[header[j]] = row[j];
		}
		
		_storage.save(type, obj.id, obj);
	}
	
	callback(lines.length-1);
};

storage.local.remove = function (type, id)
{
	var list = storage.local._get(type);
	if(list[id]) {
		delete list[id];
	}
	var list = storage.local._set(type, list);
};


storage.local.query = function (type, query, queryCallback)
{
	if(query == undefined) {
		storage.local.queryCb = queryCallback;
		
		return storage.local._get(type, queryCallback);
	} else {
		//not implemented yet
	}
};

storage.local._cleanEntity = function (type)
{
    delete localStorage[type];
};

storage.local.count = function (type)
{
	var list = Object.keys(storage.local._get(type));
	return list.length;
};

storage.db = {};

//Initializing a database of 60MB
storage.db._init = function (type) {
	if(storage.db.initialized['_main'] == undefined) {
		storage.db._db = window.openDatabase ("Database", "1.0", "Skink", 60*1024*1024); 
		storage.db.initialized['_main'] = true;
	}
	console.log(type, storage.db.initialized[type]);
	if(storage.db.initialized[type] == undefined) {
		storage.db._initEntity(type);
	}
};

storage.db.executeSql = function (sqlStack, params) {
    this.queryCb = null;
    this.getOne  = false;
    this.groupById = true;

    this.sqlStack = sqlStack;
    this.params   = params;
    
    if(this.params !== undefined) {
        for(var key in this.params) {
            this[key] = this.params[key];
        }
    }
        
    this.execute = function (successCb, errorCb) {
        if(errorCb == undefined) {
    		errorCb = this.errorCb;
    	}
    	if(successCb == undefined) {
    		successCb = this.successCb;
    	}
        
    	storage.db._db.transaction(jQuery.proxy(this._execute, this), errorCb, successCb);
    };

    this.successCb = function (tx, res) {
        console.log("Success ejecuting SQL transaction", tx, res);
    	//alert("Success in db transaction!");
    };
    
    this.errorCb = function (tx, err) {
    	console.log("Error", tx, err);
    	//alert("Error processing db transaction " + err.code);
    };

    this._execute = function (tx) {
        var sql = null;
        
    	while(sql = this.sqlStack.pop()) {
    		console.log("SQL: " + sql);
    		tx.executeSql(sql, [], jQuery.proxy(this._queryCb, this), jQuery.proxy(this.errorCb, this));
    	}
    };

    this._queryCb = function (tx, results) {

        if(this.getOne) {
    		var result = null;
    	} else {
    		var result = {};
    	}
    	
    	if(results.rows.length > 0) {
    		//console.log("getone", storage.db.getOne);
    		if(this.getOne) {
    			result = jQuery.extend({}, results.rows.item(0));
    		} else if(this.groupById) {
    			for(var i = 0; i < results.rows.length; i++) {
    				result[results.rows.item(i).id] = results.rows.item(i);
    			}
    		} else {
    			for(var i = 0; i < results.rows.length; i++) {
    				result[i] = results.rows.item(i);
    			}
    		}
    		//console.log("getone", storage.db.getOne);
    	} else {
    		
    	}
    
    	this.getOne = false;
    	this.groupById = true;
    	
    	if(this.queryCb !== undefined && this.queryCb) {
    		this.queryCb(result);
    	}
    	
    	this.queryCb = null;
    };

    this.execute();
};


storage.db._initEntity = function(type){
	var properties = entities[type].properties.persistence;

	var sql = "CREATE TABLE IF NOT EXISTS " + properties.table;
	
	var fields = [];
	
	for( var field in properties.fields ) {	
			fields.push(field + " " + properties.fields[field].type + " " + properties.fields[field].attribs);
	}
	
	sql += "("+fields.join(", ")+")";

	storage.db.initialized[type] = true;
	
	new storage.db.executeSql ([sql]);
};

storage.db._cleanEntity = function(type){
    var properties = entities[type].properties.persistence;

	var sql = "DROP TABLE " + properties.table;
			
	new storage.db.executeSql ([sql]);
	
	this._initEntity(type);
};

storage.db.initialized = {};

storage.db.save = function (type, id, obj)
{
		//TODO: how to handle id (UPDATE and INSERT)
		
		storage.db._init(type);
		
		var properties = entities[type].properties.persistence;
		
		var values = [];
		
		for( var field in properties.fields ) {	
			if(properties.fields[field].attribs == 'PRIMARY KEY AUTOINCREMENT' && obj[field] < 1) {
				values.push('null');
			} else if(obj[field] == null) {
				values.push('null');
			} else { //if (properties.fields) is string
				values.push ('"'+obj[field]+'"');
			}
		}
		
		var fields = Object.keys(properties.fields);
		
		var sql = "INSERT OR REPLACE INTO " + properties.table + "("+fields.join(", ")+") VALUES("+values.join(", ")+") ";
		
		new storage.db.executeSql ([sql]);
};

storage.db.find = function (type, id, defaultValue, callback)
{
	storage.db._init(type);
	
    var properties = entities[type].properties.persistence;
	
	var sql = "SELECT * FROM " + properties.table + " WHERE id = '"+id+"'";
	
	new storage.db.executeSql ([sql], {queryCb: callback, getOne : true});
};

storage.db.query = function (type, query, queryCallback)
{
	storage.db._init(type);
	
	var properties = entities[type].properties.persistence;
	
	if(query == undefined) {
		var sql = "SELECT * FROM "+properties.table;
		
		new storage.db.executeSql([sql], {queryCb: queryCallback});
	} else {
		var sql = query;
		
		new storage.db.executeSql([sql], {queryCb: queryCallback});
	}
};

storage.db.remove = function (type, id)
{
	storage.db._init(type);
	
	var properties = entities[type].properties.persistence;
	
	var sql = "DELETE FROM " + properties.table + " WHERE id = '"+id+"'";
	
	//storage.db.queryCb = callback;
	//storage.db.getOne = true;
	
	new storage.db.executeSql ([sql]);
};

storage.dbserialize = {};
storage.cloud = {};
/** end storage **/

entities.init();

/** begin clients **/
//var clients = new entity ('clients');
entities.client.addSell = function (client)
{
    /*  console.log(sellData);
        Object
        cliente: "1"
        fecha_hora: 1357855871
        id: "1-1357855861"
        metodo_pago: "efectivo"
        monto: "4"
        total: 2 */
        
		//(this.sellData.metodo_pago == 'credito') {
           // entities.client.
	  if(storage.local.find('forma_pago', this.sellData.metodo_pago).afecta_cxc == 'on') {
        var actualData = client.data;
    
		var saldo = 0;
	
		if(parseFloat(actualData.saldo) > 0) {
			saldo = parseFloat(actualData.saldo)
		} else {
		}
		actualData.saldo = saldo + parseFloat(this.sellData.total);
		
    	entities.client.save(client.id, actualData);

        entities.cliente_transaccion.saveSellTransaction(this.sellData);
    }        
};

entities.transaccion._serializeForm = function (form) {
    var data  = serializeForm(form);
    if(data.tipo == 'gasto' && data.cantidad > 0) {
        data.cantidad = data.cantidad * -1;
    } 
	if(data.tipo == 'ingreso' && data.cantidad < 0) {
        data.cantidad = data.cantidad * -1;
    }
	
	data.fecha = new Date(data.fecha+' 0:0:0').getTime()/1000;
	
    return data;
};

entities.transaccion.prePopulate = function (obj)
{
	var fecha = new Date(obj.data.fecha*1000);
	obj.data.fecha = fecha.getFullYear()+'-'+fecha.getMonth()+'-'+fecha.getDate()+' '+(fecha.toTimeString().substr(0,8));
		
	if(obj.data.cantidad > 0) {
		obj.data.tipo = "ingreso";
	} else {
		obj.data.tipo = "gasto";
	}
	
	return obj;
};

entities.cliente_transaccion.prePopulate = entities.transaccion.prePopulate;
entities.cliente_transaccion._serializeForm = entities.transaccion._serializeForm;

entities.cliente_transaccion.saveSellTransaction = function (data)
{
    var fecha = Math.round((new Date()).getTime() / 1000);
	
	var metodo_pago = (storage.local.find('forma_pago', data.metodo_pago));
	var numero_pagos = (metodo_pago.numero_pagos);
	var frecuencia = metodo_pago.frecuencia_pagos; //M = Mensual, Q = Quincenal, S = Semanal
	var fecha_pago_time = new Date(fecha*1000);
	var frecuencia_time = 15*24*60*69*1000;
	var total = data.total / numero_pagos;
	
	for(i = 0; i < numero_pagos; i++) {
		fecha_pago_time = system.addToDate(frecuencia, fecha_pago_time);
		console.log(fecha_pago_time);
		entities.cliente_transaccion.save(null, {
			fecha : fecha,
			concepto : 'Venta ' + data.id + ' - Pago ' + (i+1) + '/'+numero_pagos +' - Fecha de pago: ' + fecha_pago_time.toDateString(),
			cantidad : total,
			cliente: data.cliente
		});
	}
};

system.addToDate = function (frecuencia, curDate)
{
	if(frecuencia == "S") {
		return new Date(curDate.getFullYear(), curDate.getMonth(), curDate.getDate() + 7);
	} else if (frecuencia == "Q"){
		return new Date(curDate.getFullYear(), curDate.getMonth(), curDate.getDate() + 14);
	} else { //if (frecuencia == "M"){
		return new Date(curDate.getFullYear(), curDate.getMonth()+1, curDate.getDate());
	}
};


//    if(clientData.id) {
  //    //TODO: .. agregar una venta al cliente
    //  if(clientData.saldo) {
      //} else {
        //clientData.saldo = 0;
   // }  }
   
     // clientData.saldo = parseFloat(clientData.saldo) + parseFloat(ventaData.total);
      
      //clients._save(clientData, clientData.id);
  //  }
//};

/*
var cortesCaja = new entity ('cortes_caja');

cortesCaja.addCorte = function (data, date)
{
   var cortes = cortesCaja.loadFromDate(date);

   cortesCaja.setTotal (data.monto);
  
   cortes.cortes.push (data);

   var dateId = cortesCaja.getIdFromDate(date);

   cortesCaja._save (cortes, dateId);
};

cortesCaja.setTotal = function (total)
{
    storage.save('total_caja', total);
};

cortesCaja.getTotal = function ()
{
    return storage.load('total_caja') ? parseFloat(storage.load('total_caja')) : 0;
};

cortesCaja.loadFromDate = function (date)
{
    //Nos traemos la fecha en cadena, sin la parte de tiempo
    var dateString = cortesCaja.getIdFromDate(date);
    
    //Cargamos el corte a esa fecha con default a falso
    var cortes = cortesCaja.load(dateString);

    if(cortes.cortes) {
    } else {
        cortes.cortes = new Array ();
    }

    return cortes;
};

cortesCaja.getIdFromDate = function (date)
{
  return date.toDateString ();
};*/

//if(suppliers.count() > 0) {
//} else {
//	suppliers._save ([{name:'nombre',value:'Varios'}]);
//}

/** BEGIN PRODUCTS **/
entities.product.checkout = function (data)
{
	//console.log("_Chk", data);
	entities.product.find(data.id, null, jQuery.proxy(entities.product._checkout, data));
};

entities.product._checkout = function ()
{
    //console.log("Chk", this);
	var actualData = this.product.data;
	
	actualData.cantidad = parseInt(actualData.cantidad) - parseInt(this.qty);
	entities.product.save(this.id, actualData);
};

entities.product.checkin = function (data)
{
    entities.product.find(data.id, null, jQuery.proxy(entities.product._checkin, data));
};

entities.product._checkin = function ()
{
    var actualData = this.product.data;

	actualData.costo    = this.cost;
	actualData.cantidad = parseInt(actualData.cantidad) + parseInt(this.qty);
	actualData.proveedor = this.proveedor;
	
	entities.product.save(this.id, actualData);
};

entities.nota_entrada.listItemHtml = 
"<a onclick='entities.@TYPE@.view(\"@ID@\");' data-role='button' data-inline='true'>"+
"ID: @ID@ - Fecha: @FECHA_HORA@ - Total: <span class='currency'>@TOTAL@</span>"
+"</a><a href='#' onclick='entities.@TYPE@.remove(\"@ID@\");entities.@TYPE@.updateList(\"page_list_generic_list\")' data-icon='delete' data-role='button' data-inline='true'>B</a>";

entities.client.listItemHtml = 
"<a onclick='entities.@TYPE@.edit(\"@ID@\");' data-role='button' data-inline='true'>@ID@ (@NOMBRE@ @APELLIDO_PATERNO@) <span class='ui-li-count'>Saldo: @SALDO@</span></a>";
/** END PRODUCTS **/

entities.nota_entrada.render = function (obj)
{
	entities.nota_entrada_detail.query(
		" SELECT n.id, p.nombre AS producto, p.id AS codigo, n.qty, n.cost, n.qty*n.cost AS total "+
		" FROM nota_entrada_detail AS n INNER JOIN product AS p ON(n.product_id=p.id) "+
		" WHERE n.nota_entrada_id = '"+obj.id+"'",
		entities.nota_entrada._render);
		
	
	/*
		            <tr>
	                  <th>1</th>
	                  <td><a href="http://en.wikipedia.org/wiki/Citizen_Kane" data-rel="external">Citizen Kane</a></td>
	                  <td>1941</td>
	                  <td>100%</td>
	                  <td>74</td>
	                </tr>
					 <th data-priority="2">Producto</th>
	                  <th>C&oacute;digo</th>
	                  <th data-priority="3">Cantidad</th>
	                  <th data-priority="1">Costo unitario</th>
	                  <th data-priority="5">Costo total</th>
	";*/
};

entities.nota_entrada._render = function (obj)
{
	var html = "";
	for(var key in obj) {
		var row = obj[key];
		var rowHtml = "";
		rowHtml += "<th>"+row.producto+"</th>"+"<td>"+row.codigo+"</td>"+"<td>"+row.qty+"</td>"+"<td>"+row.cost+"</td>"+"<td>"+row.total+"</td>";
		
		html += "<tr>"+rowHtml+"</tr>";
	}
	
	document.getElementById('nota_entrada_view_tbody').innerHTML = html;
	
	$('#nota_entrada_view_table').table-columntoggle( "refresh" );
};


var inventario = {id:'main'};

inventario.load = function (id) {
	if(typeof(id) == 'undefined') {
		id = this.id;
	} else {
		this.id = id;
	}
	var productsList = storage.load('inventario_'+id, {});
	
	return productsList;
};

inventario.clean = function () {
	storage.save('inventario_'+this.id, {});
};

inventario.update = function (productos) {
	storage.save('inventario_'+this.id, productos);
};

inventario.apply = function () {
     var productos = inventario.load ();
     
     var productosPrevios = inventario.load ('main');
     
     for (var codigo in productos) {
         var producto = productos [codigo];
         if(productosPrevios [codigo]) {
         } else {
             productosPrevios [codigo] = {};
         }
         for (var key in producto) {
            productosPrevios [codigo][key] = producto[key];
         }
     }
     
     this.update(productosPrevios);
};

inventario.find = function (codigo)
{
	var productos = inventario.load();
	return productos[codigo];
};

inventario.setProduct = function (form)
{
    var objData = serializeForm(form);
    var productos = inventario.load ();
    
    var codigo = objData.codigo;
	
	if(productos[codigo] == undefined) {
		productos [codigo] = objData;
	} else {
     	for(var key in objData) {
           	productos[codigo][key] = objData[key];
     	}
	}
	
	inventario.update(productos);
};

inventario.addProduct = function (data, num)
{
	var productos = inventario.load ();
	
	if(typeof(num) == 'undefined') {
		var num = 1;
	}
	
	var codigo = data.codigo;
	
	if(productos[codigo] == undefined) {
		productos [codigo] = data;
		productos [codigo]['cantidad'] = num;
	}
	
	productos[codigo]['cantidad'] = parseInt(productos[codigo]['cantidad']) + parseInt(num);

	inventario.update(productos);
};

inventario.remove = function (id)
{
	var productos = inventario.load ();
	
    if(productos[id] == undefined) {
    } else {
		delete productos [id];
    }
	
	inventario.update(productos);
};

entities.transaccion.saveSellTransaction = function (data)
{
    var fecha = Math.round((new Date()).getTime() / 1000);
	
    entities.transaccion.save(null, {
    	fecha : fecha,
		concepto : 'Venta ' + data.id + ' a cliente: ' + data.cliente,
		cantidad : data.total,
	});
};

entities.transaccion.saveNotaEntradaTransaction = function (data)
{
    var fecha = Math.round((new Date()).getTime() / 1000);
    entities.transaccion.save(null, {
		fecha : fecha,
		concepto : 'Entrada a almacen - nota ' + data.id,
		cantidad : data.total * -1,
	});
};

/*------------- REFACTORING VENTA ------------*/
entity.factory.sell = function (type, data)
{
	//TODO: REMOVE duplicated code
	this.data = data;
	this.type = type;
	
	if(data == undefined || data.id == undefined) {
		this.id = system.getUniqId();
	} else {
		this.id = data.id;
	}

	this.save = function (data) {
		entities[this.type].save (this.id, data);
	};

	this.remove = function (id) {
		entities[this.type].remove(id);
	};
	
	this.products = {};
	
	this.checkout = function (data)
	{
		data.total = this.getTotal ();
		data.id    = this.id;
		data.fecha_hora = Math.round((new Date()).getTime() / 1000);

		this.save (data);
		
        entities.client.find(data.cliente, null, 
                jQuery.proxy(entities.client.addSell, {sellData:data}));
                
        entities.transaccion.saveSellTransaction(data);
        
        for(var key in this.products) {
			var product = this.products[key];
		
			//console.log(storage.local.find('setting', 'inventarios-negativos', 'on'));
			
			entities.product.checkout({id:key, product: product, qty:product.cantidad, price:product.precio});
	    
			entities.sell_detail.save(null, {
				product_id : product.id,
				sell_id : this.id,
				qty : product.cantidad,
				price : product.precio,
				total : (product.cantidad * product.precio),
				cost : product.data.costo 
			});
		}
        
        //this.clean();
	};
	
	
	this.addProduct = function (codigo)
	{
		if (codigo) {
			var producto = {nombre: system.translate('productos_varios'), id: codigo, precio: 0, cantidad: 99999};
			entities.product.find(codigo, producto, jQuery.proxy(this._addProduct, this));
			return;
			//TODO: SAVE TO CURRENT SPACE
		}
	};
	
	this._addProduct = function (producto)
	{
		var codigo = producto.id;
		
		if(this.products[codigo] == undefined) {
			this.products [codigo] = producto;
			this.products [codigo]['cantidad'] = 0;
			this.products [codigo]['precio'] = producto.data.precio;
		} else {
			 
		}

		this.products [codigo]['cantidad'] += 1;
	};
	
	this.setQty = function (codigo, qty)
	{
	  if(codigo){
		  this.products[codigo].cantidad = qty;
	  } else {
	  }
	};
	
	this.setPrecio = function (codigo, precio)
	{
	  if(codigo){
		  this.products[codigo].precio = precio;
	  } else {
	  }
	};
	
	this.getTotal = function ()
	{
		var total = 0;
	
		for(var key in this.products) {
			var product = this.products[key]
			total += (product.cantidad * product.precio);
		}
		
		return total;
	};
	
	this.clean = function ()
	{
		this.id = system.getUniqId();
		this.products = {};
	};
	
	this.deleteProduct = function (codigo)
	{
		delete this.products[codigo];	
	};

	this.hasStock = function ()
	{
		for(var key in this.products) {
			var product = this.products[key];
			if(product.cantidad > product.data.cantidad) {
				return false;
			}
		}

		return true;
	};
	
	this.hasProductsWithPriceZero = function ()
	{
		for(var key in this.products) {
			var product = this.products[key];
			
			if(product.precio <= 0) {
				return true;
			}
		}

		return false;
	};
	
};

entity.factory.nota_entrada = function (type, data)
{
    //TODO: REMOVE duplicated code
	this.data = data;
	this.type = type;
	this.supplier = "Varios";
	
	if(data == undefined || data.id == undefined) {
		this.id = system.getUniqId();
	} else {
		this.id = data.id;
	}

	this.save = function (data) {
		entities[this.type].save (this.id, data);
	};

	this.remove = function (id) {
		entities[this.type].remove(id);
	};
	
	this.products = {};
	
	this.checkout = function ()
	{
        var data = {};
		
		data.id    = this.id;
		data.fecha_hora = Math.round((new Date()).getTime() / 1000);
        data.total      = this.getTotal();
		data.proveedor = this.supplier;

		this.save (data);
		
        entities.transaccion.saveNotaEntradaTransaction(data);
        
        for(var key in this.products) {
			var product = this.products[key];
		
			entities.product.checkin({id:key, product: product, qty:product.cantidad, cost:product.cost, proveedor: data.proveedor});
	    
			entities.nota_entrada_detail.save(null, {
				product_id : product.id,
				nota_entrada_id : this.id,
				qty : product.cantidad,
				cost : product.cost,
				total : (product.cantidad * product.cost)
			});
		}
	};
	
    this.getTotal = function ()
	{
		var total = 0;
	
		for(var key in this.products) {
			var product = this.products[key]
			total += (product.cantidad * product.cost);
		}
		
		return total;
	};
	
	this.setSupplier = function (supplier)
	{
		if(supplier) {
			this.supplier = supplier;
		}
	};
	
	this.addProduct = function (codigo)
	{
		if (codigo) {
			var producto = {nombre: system.translate('productos_varios'), id: codigo, cost: 0, cantidad: 0};
			entities.product.find(codigo, producto, jQuery.proxy(this._addProduct, this));
			return;
			//TODO: SAVE TO CURRENT SPACE
		}
	};
	
	this._addProduct = function (producto)
	{
		var codigo = producto.id;
		
		if(this.products[codigo] == undefined) {
			this.products [codigo] = producto;
			this.products [codigo]['cantidad'] = 0;
			this.products [codigo]['cost'] = producto.data.cost;
		} else {
			 
		}

		this.products [codigo]['cantidad'] = parseInt(this.products [codigo]['cantidad']) + parseInt(1);
	};
	
	this.setQty = function (codigo, qty)
	{
	  if(codigo){
		  this.products[codigo].cantidad = qty;
	  } else {
	  }
	};
	
	this.setCosto = function (codigo, costo)
	{
	  if(codigo){
		  this.products[codigo].cost = costo;
	  } else {
	  }
	};
	
	this.clean = function ()
	{
		this.id = system.getUniqId();
		this.products = {};
	};
	
	this.deleteProduct = function (codigo)
	{
	    delete this.products[codigo];	
	};

	this.hasProductsWithCostZero = function ()
	{
		for(var key in this.products) {
			var product = this.products[key];
			
			if(product.cost <= 0) {
				return true;
			}
		}

		return false;
	};
	
};

currentSell = { 
	obj : null,
	
	set : function (obj) {
		currentSell.obj = obj;
	},
	
	get : function () {
		return currentSell.obj;
	}
};

currentNotaEntrada = { 
    obj : null,
	
	set : function (obj) {
		currentNotaEntrada.obj = obj;
	},
	
	get : function () {
        return currentNotaEntrada.obj;
	}
};

serializeForm = function (form) 
{
    var data = ($(form).serializeArray());
    var formData = {};
    for(var i = 0; i < data.length; i++) {
        formData[data[i].name] = data[i].value;
    }
    
    return formData;
};

/** sync data **/
sync = {};

sync.push = function () {
  var data = JSON.stringify(localStorage);
  
   //PUSH DATA TO THE SERVER 
};

sync.pull = function () {
  var data = {}; //PULL DATA
};

var setup = {};

setup.loadData = function (context, type)
{
	var dataC = data[context][type];
	for(var i = 0; i < dataC.length; i++) {
		var row = dataC[i];

		//dataC.length
		entities[type].save(row.id, row);
	}
	/*$.getScript("data."+context+".js").done(function(script,textStatus){
		console.log(data[context][type]);
	});*/
	
};

setup.reset = function ()
{
    entities.unit.clean();
    entities.sell.clean();
    entities.client.clean();
    entities.nota_entrada.clean();
	entities.nota_entrada_detail.clean();
	entities.sell_detail.clean();
	entities.product.clean();
	entities.transaccion.clean();
	entities.forma_pago.clean();
	entities.cliente_transaccion.clean();
	
	setup.loadDefaultData ();
};

if(data == undefined) { var data = {}; };
var translate = {};

system.showCurrency = function (val) { 
    var curVal = parseFloat(val),
        curInt = parseInt(curVal, 10),
        curDec = parseInt(curVal*100, 10) - parseInt(curInt*100, 10);

    curDec = (curDec < 10) ? "0" + curDec : curDec;

    if (isNaN(curInt)) {
		curInt = "0";
	}
	
	if(isNaN(curDec)) {
        curDec = "00";
    }
	
	return ("$"+curInt+"."+curDec);
};

system.showDate = function (val) {
	var sdate = new Date(val*1000);
	return sdate.toLocaleString();
};

system.language = false;

system.translate = function (label)
{
	return translate[system.language][label];
};

system.constructUi = function ()
{
	system.translateUi();
	
	if( storage.local.find('setting', 'usar-barcodescanner', 'off') == 'on' ) {
		$('[data-barcode="true"]').each(function(ix, node){node.style.display = '';})
	} else {
		$('[data-barcode="true"]').each(function(ix, node){node.style.display = 'none';})
	}
};

system.translateUi = function ()
{
	system.language = storage.local.find('setting', 'language', 'es')
	$('[data-translate]').each(function(a,b) {
		if(b.tagName == 'INPUT' && (b.type == 'reset' || b.type == 'submit')) {
			ui.changeLabel(b.parentNode, system.translate(b.getAttribute('data-translate')));
		} else {
			ui.changeLabel(b, system.translate(b.getAttribute('data-translate')));
		}
	});

};

system.pos_template = 'default';

system.fillQuickKeys = function ()
{
	//system.pos_template = storage.local.find('setting', 'pos_template', 'default');
	
	entities.product.query (null, jQuery.proxy(function(list){
		system.fillItems(list, 'tablet_products_experimental', 'product', 'div', 
		'<a data-role="button" class="product-button" onclick="ui.ventas.addProduct(@ID@);"  style="height:80px; font-size: 0.7em;">(@ID@)<br />@NOMBRE@</a>',
		function(){$('#quick_keys').trigger( "create" );});
	}, this));
};

system.fillItems = function(list, elementId, entityType, baseElement, _itemHtml, callback)
{
	var domList = $('#'+elementId);
	var domItem = domList[0]; domItem.innerHTML = null;
        
	var count = 0;
	console.log(list);
  	for(var key in list) {
		var item = document.createElement(baseElement);
		switch(count++ % 4) {
			case 0:
				item.className = "ui-block-a";
				break;
			case 1:
				item.className = "ui-block-b";
				break;
			case 2:
				item.className = "ui-block-c";
				break;
			case 3:
			default:
				item.className = "ui-block-d";
				break;
		}
		
		var entity = list[key];
		entity.type = entityType;

		var itemHtml = _itemHtml;
		
		for(var field in entity) {
			if(typeof(entity[field]) == 'string'|| typeof(entity[field]) == 'number' ) { 
				itemHtml = 
				itemHtml.replace(new RegExp("@"+field.toUpperCase()+"@", "gi"), entities[entityType].formatField(field, entity[field]));    
			}
		}
		 
		item.innerHTML = itemHtml;
		
		domItem.appendChild (item);
	}

	callback();
};

setup.loadDefaultData = function ()
{
	setup.loadData('mx', 'client'); 
	setup.loadData('mx', 'supplier'); 
	setup.loadData('mx', 'unit'); 
	setup.loadData('mx', 'tax');
	setup.loadData('mx', 'forma_pago');
};

entities.setting.find('setup', false, function(row){
	if(row.data){} else {
		setup.loadDefaultData();
		storage.local.save('setting', 'setup', true);
	}
});

entities.setting.find('dbVersion', 20, function(row){
	if(row.data == 20){
		setTimeout(function(){var sql = "ALTER TABLE sell ADD estatus TEXT";new storage.db.executeSql ([sql]);}, 500);
		entities.client.query(null, function(clients) { 
			for(var id in clients) {
				if(clients[id].saldo > 0) {
					var sellData = { total: clients[id].saldo, cliente: id, id: '' };
					entities.cliente_transaccion.saveSellTransaction(sellData);
				}
			}
		});
		storage.local.save('setting', 'dbVersion', 21);
	} else if(row.data == 21){
		setTimeout(function(){var sql = "ALTER TABLE nota_entrada ADD proveedor TEXT";new storage.db.executeSql ([sql]);}, 500);
		storage.local.save('setting', 'dbVersion', 22);
	} else {
	//	setup.loadDefaultData();
		
	}
});

entities.sell.find(null, {}, jQuery.proxy(currentSell.set, currentSell));
