var ui = {};

	
		function addProduct (codigo) {
			if(inventario.find(codigo)) {
				inventario.addProduct({codigo:codigo}, 1);
//				updateListadoIngresoProductos();
		
		} else {
				var element = document.getElementById('agregar_producto');
				var addHref = element.href;
				element.href += codigo;
				element.click();
				element.href = addHref; //$.mobile.loadPage
			}
		};
	
ui.caja = {};

ui.init = function ()
{
	system.constructUi();
};

ui.teardown = function () 
{
};

ui.renderReport = function (obj, report_id)
{
	var html = "";
	
	
	
	for(var key in obj) {
		var row = obj[key];
		var rowHtml = "";
		var tag = "th";
		for(var col in row) {
			rowHtml += "<"+tag+">"+row[col]+"</"+tag+">";
			tag = "td";
		}
		html += "<tr>"+rowHtml+"</tr>";
		
	}
	
	document.getElementById(report_id+'_tbody').innerHTML = html;
	
	$('#'+report_id+'_table').table( "refresh" );
};

ui.changeLabel = function (dom, label)
{
	var span = $(dom).find('.ui-btn-text');
	
	if(span.length > 0) {
		for(var i = 0; i < span.length; i++) {
			span[i].innerHTML = ui.ucfirst(label);
		}
	} else {
		dom.innerHTML = ui.ucfirst(label);
	}
};

ui.ucfirst = function (string)
{
	if(string) {
		return string.charAt(0).toUpperCase() + string.toLowerCase().slice(1);
	} else {
		return '';
	}
	
};

ui.showList = function (options)
{
	var link = options.options.link[0];
	var fromPage = options.options.fromPage[0];
	var entityType = link.getAttribute('data-type');
	entities[entityType].updateList('page_list_generic_list');

	if(link.getAttribute('data-back')) {
		var backHref = link.getAttribute('data-back');
	} else {
		var backHref = '#'+fromPage.id;
	}
	document.getElementById('page_list_generic_back').href = backHref;
	document.getElementById('page_list_generic_title').innerHTML = system.translate(entityType+'_plural');
	document.getElementById('page_list_generic_edit').href = '#page_' + entityType + '_edit';
	ui.changeLabel(document.getElementById('page_list_generic_edit'), system.translate('agregar') + ' ' + system.translate(entityType));
	document.getElementById('page_list_generic_edit').setAttribute('onclick', 'entities.'+entityType+'.cleanForm()');
};

//Verificamos que se halla hecho corte de caja
ui.initVerifyFondoCaja = function ()
{
    //console.log("Verificando fondo de caja: TODO");
    return;
	//Nos traemos la fecha de hoy
    var date = new Date ();
  
    cortes = cortesCaja.loadFromDate (date);
    
    //Si ya se capturo corte ... no hay bronca
    if(cortes.cortes && cortes.cortes.length > 0) {
    } else { //Si no se capturo mostramos la ventana para que se capture
       ui.fondoCaja.open();
    }
};

ui.fondoCaja = {};

ui.fondoCaja.save = function (form)
{
  var data = serializeForm(form);
  
  var date = new Date ();
  
  cortesCaja.addCorte(data, date);
};

ui.fondoCaja.open = function ()
{
    $("#fondo_caja_button_hidden").click();
};

ui.ventas = {};
ui.nota_entrada = {};
		
ui.products = {};

ui.products.remove = function (id)
{
  if(window.confirm('&iquest;Desea eliminar el producto')) {
      inventario.remove(id);
     // updateInventario();
  }
};

ui.products.edit = function (codigo)
{
    var productos = inventario.load();
    
    if(productos[codigo] !== undefined) {
      var form = document.getElementById('form_productos_editar');
      for (var key in productos[codigo]) {
          if(form[key].tagName == "SELECT") { //50196388
              $(form[key]).append($("<option />").val(productos[codigo][key]).text(productos[codigo][key]));
          }
   
          $(form[key]).val(productos[codigo][key]);
      }
      $.mobile.changePage('#page_editar_producto', {role: 'dialog'}); 
    }
   
};


ui.waitCallbacks = {};

ui.waitAndExec = function (callback, time, context)
{
    if(ui.waitCallbacks[context]) {
        clearTimeout(ui.waitCallbacks[context]);
    } else {
        
    }

    ui.waitCallbacks[context] = setTimeout(callback, time);
};

ui.ventas.setArticulo = function (codigo, cantidad)
{
    if(cantidad !== undefined && cantidad !== '') {
      currentSell.get().setQty(codigo, cantidad);
      ui.waitAndExec(ui.ventas.updateListadoVentaArticulos, 800);
    }
};

ui.ventas.setPrecio = function (codigo, precio)
{
    if(precio !== undefined && precio !== '') {
      currentSell.get().setPrecio(codigo, precio);
      ui.waitAndExec(ui.ventas.updateListadoVentaArticulos, 800);
    }
};

ui.ventas.addProduct = function (codigo)
{
    currentSell.get().addProduct(codigo);

	setTimeout(ui.ventas.updateListadoVentaArticulos, 300);    
};

ui.ventas.clean = function ()
{
   currentSell.get().clean();
   ui.ventas.updateListadoVentaArticulos();
};

ui.ventas.deleteArticulo = function (codigo)
{
    currentSell.get().deleteProduct (codigo);
    ui.ventas.updateListadoVentaArticulos();    
};

ui.ventas.updateListadoVentaArticulos = function ()
{
  var itemsList = currentSell.get().products;

  var domList = $('#listado_venta_articulos');
	
  var domItem = domList[0];
	
	//<div class="ui-block-b">C&oacute;digo</div>
	
  domItem.innerHTML = '<li data-role="list-divider"><div class="ui-grid-b"><div class="ui-block-a">'
  +system.translate('cantidad')
  +'</div><div class="ui-block-b">'+system.translate('precio_unitario')+'</div><div class="ui-block-c">'
  +system.translate('precio_total')+'</div></div></li>';
	
	var cantidadTotal = 0;
	var precioTotal   = 0;
	
	for(var key in itemsList) {
		var li = document.createElement ('li');
		var item = itemsList[key];
		console.log("Item:", item);	
		if(item.precio) {
		} else {
      		item.precio = 0;
		}
		
		var itemTotal = parseInt(item.cantidad) * parseFloat(item.precio);
		
		if(item.precio > 0 && false) {
      		var precio = "$" + item.precio;
      	} else {
           	var precio = "<span class='desc'>$</span><input type='text' size='3' name='precio' data-mini='true' data-inline='true' value='"+item.precio
			+"' style='font-size: 1em; max-width: 5em;' onchange='ui.ventas.setPrecio(\""+item.data.id+"\", this.value);' />";
      	}
		
		//<div class="ui-block-b"><small>'+item.codigo+'</small></div>
//onclick="ui.ventas.addProduct(\''+item.data.id+'\')"		
		li.innerHTML = 
		
		'<a><div class="nombreVenta">' + item.data.nombre + '&nbsp;&nbsp;<small>['+item.data.id+']</small></div>'
		+'<div class="ui-grid-b renglon-venta"><div class="ui-block-a">'
			
			
			+'<input type="text" size="3" name="cantidad" value="'+item.cantidad+'" data-mini="true" data-inline="true" '
				+'onchange="ui.ventas.setArticulo(\''+item.data.id+'\', this.value);" /> <span class="desc">x</span> '
		+'</div><div class="ui-block-b">'+precio+'</div><div class="ui-block-c"><span class="desc">= '+system.showCurrency(itemTotal)+'</span></div></div></a>';
		li.innerHTML += '<a href="#" onclick="ui.ventas.deleteArticulo(\''+item.data.id+'\')">Eliminar</a>'
		//'<fieldset><a data-role="button"  data-icon="plus" data-inline="true">Agregar</a></fieldset>';
		
		li.setAttribute('data-role', 'fieldcontain');
		domItem.appendChild (li);
		
		$(li).trigger('create');
		
		cantidadTotal += parseInt(item.cantidad);
		precioTotal += parseFloat(itemTotal);
	}
	
	var li = document.createElement ('li');
	
	li.innerHTML = '<li data-role="list-divider"><div class="ui-grid-b"><div class="ui-block-a" style="font-size: 20px;">'+cantidadTotal+'</div><div class="ui-block-b">&nbsp;</div><div class="ui-block-c" style="font-size: 20px;">'+system.showCurrency(precioTotal)+'</div></div></li>';
		
	domItem.appendChild (li);
	
	$('#listado_venta_articulos').listview('refresh');
};

ui.ventas.updateCheckout = function ()
{
	$('#cobro_monto_efectivo').each(function(k,item){ item.innerHTML = system.showCurrency(currentSell.get().getTotal());});
	document.getElementById("cobro_monto_efectivo").setAttribute('monto', (currentSell.get().getTotal()));
};

/** NOTA ENTRADA **/

ui.nota_entrada.setArticulo = function (codigo, cantidad)
{
    if(cantidad !== undefined && cantidad !== '') {
      currentNotaEntrada.get().setQty(codigo, cantidad);
      ui.waitAndExec(ui.nota_entrada.updateListadoArticulos, 800);
    }
};

ui.nota_entrada.setCosto = function (codigo, costo)
{
    if(costo !== undefined && costo !== '') {
      currentNotaEntrada.get().setCosto(codigo, costo);
      ui.waitAndExec(ui.nota_entrada.updateListadoArticulos, 500);
    }
};

ui.nota_entrada.addProduct = function (codigo)
{
    currentNotaEntrada.get().addProduct(codigo);

    setTimeout(ui.nota_entrada.updateListadoArticulos, 300);    
};

ui.nota_entrada.setSupplier = function (supplier)
{
	currentNotaEntrada.get().setSupplier(supplier);
};

ui.nota_entrada.clean = function ()
{
   currentNotaEntrada.get().clean();
   ui.nota_entrada.updateListadoArticulos();
};

ui.nota_entrada.deleteArticulo = function (codigo)
{
    currentNotaEntrada.get().deleteProduct (codigo);
    ui.nota_entrada.updateListadoArticulos();    
};

ui.nota_entrada.checkout = function () 
{
    currentNotaEntrada.get().checkout();
    //ui.nota_entrada.updateListadoArticulos();
    setTimeout(function(){ui.nota_entrada.clean();$.mobile.changePage('#page_productos');}, 300);
};

ui.nota_entrada.updateListadoArticulos = function ()
{
  var itemsList = currentNotaEntrada.get().products;

  var domList = $('#listado_nota_entrada_articulos');
	
  var domItem = domList[0];
	
	//<div class="ui-block-b">C&oacute;digo</div>
	
    domItem.innerHTML = '<li data-role="list-divider"><div class="ui-grid-b"><div class="ui-block-a">'+system.translate('cantidad')+'</div><div class="ui-block-b">'+system.translate('costo_por_producto')+'</div><div class="ui-block-c">'+system.translate('costo_total')+'</div></div></li>';
	
	var cantidadTotal = 0;
	var costoTotal   = 0;
	
	for(var key in itemsList) {
		var li = document.createElement ('li');
		var item = itemsList[key];
			
		if(item.cost) {
		} else {
      		item.cost = 0;
		}
		
		var itemTotal = parseInt(item.cantidad) * parseFloat(item.cost);
		
		if(item.cost > 0 && false) {
      		var costo = "$" + item.cost;
      	} else {
           	var costo = "$<input type='text' size='6' name='cost' value='"+item.cost+"' style='font-size: 1.1em; max-width: 6em;' onclick='event.stopPropagation();$(this).select();' onchange='ui.nota_entrada.setCosto(\""+item.data.id+"\", this.value);' />";
      	}
		
		//<div class="ui-block-b"><small>'+item.codigo+'</small></div>
		
		li.innerHTML = '<a onclick="ui.nota_entrada.addProduct(\''+item.data.id+'\')"><div class="nombreVenta">' + item.data.nombre + '&nbsp;&nbsp;<small>['+item.data.id+']</small></div><div class="ui-grid-b"><div class="ui-block-a"><input type="number" size="4" name="cantidad" value="'+item.cantidad+'" style="font-size: 1em; max-width: 4em;" onclick=\'event.stopPropagation();$(this).select();\' onchange="ui.nota_entrada.setArticulo(\''+item.data.id+'\', this.value);" /> &nbsp;&nbsp;&nbsp;x </div><div class="ui-block-b">'+costo+'</div><div class="ui-block-c">= '+system.showCurrency(itemTotal)+'</div></div></a>';
		li.innerHTML += '<a href="#" onclick="ui.nota_entrada.deleteArticulo(\''+item.data.id+'\')">Eliminar</a>';
		
		domItem.appendChild (li);
		
		cantidadTotal += parseInt(item.cantidad);
		costoTotal += parseFloat(itemTotal);
	}
	
	var li = document.createElement ('li');
	
	li.innerHTML = '<li data-role="list-divider"><div class="ui-grid-b"><div class="ui-block-a">'+system.translate('cantidad')+': '+cantidadTotal+'</div><div class="ui-block-b">&nbsp;</div><div class="ui-block-c">'+system.translate('costo_total')+': '+system.showCurrency(costoTotal)+'</div></div></li>';
		
	domItem.appendChild (li);
	
	$('#listado_nota_entrada_articulos').listview('refresh');
		
};

ui.nota_entrada.updateCheckout = function ()
{
	$('#cobro_monto_efectivo').each(function(k,item){ item.innerHTML = currentSell.get().getTotal();});
};
/** NOTA DE ENTRADA **/

ui.fillSelect = function (list)
{
  var selectId = this.selectId;
  var text = this.text;
  var value = this.value;
  var clean = this.clean;

  var select = $("#"+selectId);

  if(select.length > 0) {
  } else {
    select = $('[data-role="'+selectId+'"]');
  }
  
  if(clean) {
     var oldValue = select.val();
     select.html('');// = null;
  } else {
    var oldValue = false;
  }
  			
  $.each(list, function () {
    if(this[text] !== undefined) {
		var objText = this[text]; 
	} else {
		var objText = this.id;	
	} 
	
	if(this[value] !== undefined) {
		var objValue = this[value];
	} else {
		var objValue = this.id;
	}
	
	select.append($("<option />").val(objValue).text(objText));
  });

  if(oldValue) {
    select.val(oldValue);
  }
  
  select.selectmenu("refresh");
};

ui.fillFieldset = function (list)
{
  var selectId = this.domId;
  var text = this.text;
  var value = this.value;
  var clean = this.clean;
  var name = this.name;
  var options = this.options;

  var domElement = $("#"+selectId);

  if(domElement.length > 0) {
  } else {
    //select = $('[data-role="'+selectId+'"]');
  }
  
  if(clean) {
  //   var oldValue = select.val();
     domElement.html('');// = null;
  } else {
    //var oldValue = false;
  }
  			
  $.each(list, function () {
    if(this[text] !== undefined) {
		var objText = this[text]; 
	} else {
		var objText = this.id;	
	} 
	
	if(this[value] !== undefined) {
		var objValue = this[value];
	} else {
		var objValue = this.id;
	}
	
	domElement.append($("<input "+options+" type='radio' id='"+name+"_"+objValue+"' value='"+objValue+"' name='"+name+"' />")).append($("<label for='"+name+"_"+objValue+"' />").text(objText));
	
  });

  //if(oldValue) {
//    domElement.val(oldValue);
  //}
  
  $(domElement).trigger('create');
};

function disableTouch (event)
{
	event.preventDefault ();
}

$.mobile.loadingMessageTextVisible = true;
$.mobile.touchOverflowEnabled = true;
$.mobile.buttonMarkup.hoverDelay = 80;

$.mobile.defaultPageTransition = 'none';
$.mobile.defaultDialogTransition = 'none'

			
function init () 
{
  $(document).bind('pagebeforechange', function(event, options) {
    var toPage = options.toPage,
        fromPage = options.fromPage;
    if (typeof toPage === 'string') {
    } else {
      toPage = '#' + toPage[0].id;
    }
	
	if(toPage == '#page_venta_checkout') {
		if( storage.local.find('setting', 'inventarios-negativos', 'off') == 'off' //no permite
			&&	//y
			!(currentSell.get().hasStock())) { //no hay stock
			alert("No hay suficientes productos en inventario, contacte a su administrador del sistema o ingrese productos al inventario");
			event.preventDefault();
		} else {
			//Se permite o hay en stock
		}
		
		console.log(storage.local.find('setting', 'ventas-productos-cero', 'off'));
		if( storage.local.find('setting', 'ventas-productos-cero', 'off') == 'off' //no permite
			&&	//y
			(currentSell.get().hasProductsWithPriceZero())) { //hay productos con precios en 0
			alert("Existen productos con precios en cero, contacte a su administrador del sistema o ingrese el precio de los productos");
			event.preventDefault();
		} else {
			//Se permite o todos tienen precios
		}
	}
});
	//AUTOCOMPLETE
	$( "#listado_buscar_productos" ).on( "listviewbeforefilter", function ( e, data ) {
				var $ul = $( this ), $input = $( data.input ), value = $input.val(), html = "";
				//$ul.html( "" );
				if(value.length > 2) {
					itemHtml = "<a onclick='ui.ventas.addProduct(\"@ID@\");$( \"#popupSearchProduct\" ).popup( \"close\" )' data-role='button' data-inline='true'>@ID@ (@NOMBRE@)</a><a href='#' onclick='entities.@TYPE@.edit(\"@ID@\");' data-icon='arrow-r' data-role='button' data-inline='true'>B</a>";
					entities.product.refreshList = true;
					entities.product.updateList('listado_buscar_productos', 
						itemHtml,
						"SELECT * FROM product WHERE cantidad != '' AND nombre LIKE '%"+value+"%' OR id LIKE '%"+value+"%'");
					$( "#popupSearchProduct" ).popup( "reposition", {y:0});
				}
				
				/*if ( value && value.length > 2 ) {
					$ul.html( "<li><div class='ui-loader'><span class='ui-icon ui-icon-loading'></span></div></li>" );
					$ul.listview( "refresh" );
					$.ajax({
						url: "http://gd.geobytes.com/AutoCompleteCity",
						dataType: "jsonp",
						crossDomain: true,
						data: {
							q: $input.val()
						}
					})
					.then( function ( response ) {
						$.each( response, function ( i, val ) {
							html += "<li>" + val + "</li>";
						});
						$ul.html( html );
						$ul.listview( "refresh" );
						$ul.trigger( "updatelayout");
					});
				}*/
				
	});
	
			
  var scriptGapiLoaded = false;
  var exportLoaded = false;
  var importLoaded = false;
  
  $( document ).bind( "pagechange", function( event, options ){
    var toPage = options.toPage;
    
    if(typeof(toPage) == 'string') {
    } else {
      toPage = '#' + toPage[0].id;
    }

    if(toPage == '#page_export') {
		if(scriptGapiLoaded) {
			posmosExportLoad ();
		} else {
			$.mobile.loading( 'show', { theme: "b", text: system.translate('cargando_internet') });
			jQuery.getScript('https://apis.google.com/js/client.js?onload=posmosExportLoad');
			scriptGapiLoaded = true;
		}
	} else if(toPage == '#page_import') {
		if(!scriptGapiLoaded) {
			$.mobile.loading( 'show', { theme: "b", text: system.translate('cargando_internet') });
			jQuery.getScript('https://apis.google.com/js/client.js?onload=posmosImportLoad');
			scriptGapiLoaded = true;
		} else {
			posmosImportLoad ();
		}
    } else if(toPage == '#page_productos') {
		var itemHtml = "<a onclick='entities.@TYPE@.edit(\"@ID@\");' data-role='button' data-inline='true'>@ID@ (@NOMBRE@) <span class='ui-li-count'>@CANTIDAD@</span></a><a href='#' onclick='entities.@TYPE@.remove(\"@ID@\");entities.@TYPE@.refreshList()' data-icon='delete' data-role='button' data-inline='true'>B</a>";
		entities.product.updateList(null,itemHtml,"SELECT * FROM product WHERE cantidad != ''");
    } else if (toPage == '#page_clientes') {
    	var itemHtml = "<a onclick='entities.@TYPE@.edit(\"@ID@\");' data-role='button' data-inline='true'>@ID@ (@NOMBRE@ @APELLIDO_PATERNO@) <span class='ui-li-count'>Saldo: @SALDO@</span></a>"+
        "<a href='#' onclick='entities.@TYPE@.remove(\"@ID@\");entities.@TYPE@.refreshList()' data-icon='delete' data-role='button' data-inline='true'>B</a>";
        entities.client.updateList(null, itemHtml);
    } else if (toPage == '#page_proveedores') {
		entities.supplier.updateList();
    } else if (toPage == '#page_list_generic') {
		ui.showList(options);
    } else if (toPage == '#page_impuestos') {
		entities.tax.updateList();
    } else if (toPage == '#page_unidades') {
		entities.unit.updateList();
    } else if (toPage == '#page_balance') {
        var itemHtml = "<a onclick='entities.@TYPE@.edit(\"@ID@\");' data-role='button' data-inline='true'>@FECHA@ - @CONCEPTO@ <span class='ui-li-count'>"+system.translate('cantidad')+": @CANTIDAD@</span></a>"+
        "<a href='#' onclick='entities.@TYPE@.remove(\"@ID@\");entities.@TYPE@.refreshList();ui.page_balance.refresh();' data-icon='delete' data-role='button' data-inline='true'>B</a>";
    	entities.transaccion.updateList(null, itemHtml);
        ui.page_balance.refresh();
	} else if (toPage == '#page_client_edit') {
		ui.page_balance_cliente.refresh();
    } else if (toPage == '#page_balance_cliente') {
	//var link = options.options.link[0];
		var clientId = document.getElementById('client_form').id.value;
		document.getElementById('cliente_transaccion_form').cliente.value = clientId;
	
       var itemHtml = "<a onclick='entities.@TYPE@.edit(\"@ID@\");' data-role='button' data-inline='true'>@FECHA@ - @CONCEPTO@ <span class='ui-li-count'>"+system.translate('cantidad')+": @CANTIDAD@</span></a>"+
        "<a href='#' onclick='entities.@TYPE@.remove(\"@ID@\");entities.@TYPE@.refreshList();ui.page_balance_cliente.refresh();' data-icon='delete' data-role='button' data-inline='true'>B</a>";
    	
		entities.cliente_transaccion.updateList(null, itemHtml, "SELECT * FROM cliente_transaccion WHERE cliente = '"+clientId+"'");
		
		ui.page_balance_cliente.refresh();
    } else if (toPage == '#page_unidades_agregar') {
      
    } else if (toPage == '#fondo_caja') {
        $('#fondo_caja_valor_anterior').each(function(){this.innerHTML = cortesCaja.getTotal ();});
    } else if (toPage == '#page_reporte_fondo_caja') {
        var cortes = cortesCaja.loadFromDate(new Date);
        cortes = cortes.cortes;
        
        var points = new Array ();
        
        for(var i = 0; i < cortes.length; i++) {
            points.push(cortes[i].monto);
        }
        //cortes = cortesCaja.loadFromDate (date);
        var plot1 = $.jqplot ('reporte_fondo_caja', [points]);
    } else if (toPage == '#page_reporte_ventas_x_dia') {
        var points = new Array ();
        
        points.push(19);
        points.push(91);
        points.push(17);
        points.push(61);
        points.push(71);
        
        //for(var i = 0; i < cortes.length; i++) {
          //  points.push(cortes[i].monto);
        //}
        //cortes = cortesCaja.loadFromDate (date);
        var plot1 = $.jqplot ('reporte_ventas_x_dia', [points]);
    } else if (toPage == '#page_productos_mas_vendidos') {
		entities.product.refreshList = true;
		storage.db.groupById = false;
		
		var itemHtml = "<a onclick='entities.@TYPE@.edit(\"@ID@\");' data-role='button' data-inline='true'>@ID@ (@NOMBRE@) <span class='ui-li-count'>@QTY@</span></a>";

		entities.product.updateList('listado_productos_mas_vendidos', itemHtml, 
			"  SELECT product.*, SUM(qty) AS qty FROM product INNER JOIN"
			+"( SELECT SUM(sell_detail.qty) AS qty, product_id AS id "
			+"     FROM sell_detail "
			+" GROUP BY sell_detail.product_id ) AS _tmp ON(product.id=_tmp.id) "
			+" GROUP BY product.id ORDER BY qty DESC LIMIT 30"
		);
	} else if (toPage == '#page_reporte_utilidad_por_producto') {
		entities.sell_detail.query(
		" SELECT sd.product_id AS id, p.nombre, IFNULL(p.unidad,'-'), " +
		" SUM(qty) AS count, "+
		" ROUND((SUM(IFNULL(sd.price,0))-SUM(IFNULL(sd.cost,IFNULL(p.costo,0))))/SUM(IFNULL(qty,0)),2) AS up, "+
		" ROUND(SUM(IFNULL(sd.price,0))-SUM(IFNULL(sd.cost,IFNULL(p.costo,0))),2) AS ut "+
		" FROM sell_detail AS sd INNER JOIN product AS p ON(sd.product_id=p.id) " +
		" GROUP BY sd.product_id ",
			function(res) { ui.renderReport (res, 'reporte_utilidad_por_producto');}
		);
	} else if (toPage == '#page_productos_proximos_vencerse') {
		entities.product.refreshList = true;
		storage.db.groupById = false;
		
		var itemHtml = "<a onclick='entities.@TYPE@.edit(\"@ID@\");' data-role='button' data-inline='true'>@ID@ (@NOMBRE@) <span class='ui-li-count'>@QTY@</span></a>";

		entities.product.updateList('listado_productos_proximos_vencerse', itemHtml, 
			"  SELECT product.*, SUM(qty) AS qty FROM product INNER JOIN"
			+"( SELECT SUM(sell_detail.qty) AS qty, product_id AS id "
			+"     FROM sell_detail "
			+" GROUP BY sell_detail.product_id ) AS _tmp ON(product.id=_tmp.id) "
			+" GROUP BY product.id ORDER BY qty DESC LIMIT 30"
		);
	} else if (toPage == '#page_productos_agotados') {
		entities.product.refreshList = true;
		entities.product.updateList('listado_productos_agotados', null, "SELECT * FROM product WHERE cantidad < 1 ");
	} else if (toPage == '#page_productos_no_inventariados') {
		entities.product.refreshList = true;
		entities.product.updateList('listado_productos_no_inventariados', null, "SELECT * FROM product WHERE cantidad = ''");
    } else if (toPage == '#page_venta') {
        ui.initVerifyFondoCaja ();
		ui.ventas.updateListadoVentaArticulos();
		system.fillQuickKeys();
	  
    //  entities.client.query(null, jQuery.proxy(ui.fillSelect, { selectId:'venta_cliente', {0:{id:0, nombre:'Varios'}}, 'nombre', 'id', true); 
	 // ui.fillSelect ('venta_cliente', {0:{id:0, nombre:'Varios'}}, 'nombre', 'id', true);
       		//$('#buscar_articulo').focus();
	} else if (toPage == '#page_venta_checkout') {
		//FIXME: nombre a nombre_completo
        entities.client.query(null, jQuery.proxy(ui.fillSelect, { selectId: 'venta_cliente', text: 'nombre', value: 'id', clean: true}));
        ui.ventas.updateCheckout();
		
		entities.forma_pago.query(null, jQuery.proxy(ui.fillFieldset, 
			{ domId: 'metodos_pago_fieldset', text: 'nombre', value: 'id', clean: true, name: 'metodo_pago',
				options: 'onclick="ui.showHidePagoCon();"'}
		));  
	} else if (toPage == '#page_nota_entrada_edit') {
         if(!currentNotaEntrada.get()) {
            entities.nota_entrada.find(null, {}, jQuery.proxy(currentNotaEntrada.set, currentNotaEntrada));
         }
		 
		 entities.supplier.query(null, jQuery.proxy(ui.fillSelect, { selectId: 'nota_entrada_producto_proveedor', text: 'nombre', value: 'id', clean: true}));
         //$('#nota_entrada_buscar_articulo').focus();
	} else if (toPage == '#page_configuracion') {
		entities.setting.query(null, function(settings){ console.log(settings);for(var key in settings) { 
			
			$('#'+key).val(settings[key]);
			//select.selectmenu("refresh");
			$('#'+key).each(function(k,n){
				var func = n.getAttribute('data-role'); 
				
				if(func) { 
				//console.log("-" + func);
					if(func == 'flipswitch') {
					
						$('#'+key).trigger('create'); 
					} else {
						$('#'+key)[func]('refresh'); 
					}
				} else if(n.tagName == 'SELECT') { 
					$(n).selectmenu("refresh");
				}
			});
		} });
    } else if (toPage == '#page_product_edit') {
		entities.supplier.query(null, jQuery.proxy(ui.fillSelect, { selectId: 'producto_proveedor', text: 'nombre', value: 'id', clean: true}));
		entities.unit.query(null, jQuery.proxy(ui.fillSelect, { selectId: 'producto_unidad', text: 'nombre', value: 'id', clean: true}));
	} else {
		
	}
    
  });
  
  $( document ).bind({
		popupafteropen: function(event, data) { 
			if(event.target.id == 'popupSearchProductDEP') {
				itemHtml = "<a onclick='ui.ventas.addProduct(\"@ID@\");$( \"#popupSearchProduct\" ).popup( \"close\" )' data-role='button' data-inline='true'>@ID@ (@NOMBRE@)</a><a href='#' onclick='entities.@TYPE@.edit(\"@ID@\");' data-icon='arrow-r' data-role='button' data-inline='true'>B</a>";
				entities.product.refreshList = true;
				entities.product.updateList('listado_buscar_productos', itemHtml,"SELECT * FROM product WHERE cantidad != ''");
			}
            
            if(event.target.id == 'popupSearchProductNE') {
    			itemHtml = "<a onclick='ui.nota_entrada.addProduct(\"@ID@\");$( \"#popupSearchProductNE\" ).popup( \"close\" )' data-role='button' data-inline='true'>@ID@ (@NOMBRE@)</a><a href='#' onclick='entities.@TYPE@.edit(\"@ID@\");' data-icon='arrow-r' data-role='button' data-inline='true'>B</a>";
				entities.product.refreshList = true;
				entities.product.updateList('listado_buscar_productos_nota_entrada', itemHtml,"SELECT * FROM product WHERE cantidad != ''");
			}
		}
	});
  
  	$( document ).bind( "pageload", function( event, data ){
  		if(data.absUrl.search(new RegExp("productos_agregar", "i")) > 0) {
			var vars = getUrlVars (data.dataUrl);
			
			for(var key in vars) {
				var el = (document.getElementById('producto_'+key));
				
				if(el !== undefined && el) {
					el.value = vars[key];
				}
			}

			 //ui.fillSelect ('producto_proveedor', entities.supplier.query(), 'nombre', 'id');
			 //ui.fillSelect ('producto_unidad', entities.unit.query(), 'nombre', 'id');

			//$('productos_agregar', data.page)
		//} else if(data.absUrl.search(new RegExp("productos_buscar", "i")) > 0) {
      		//ui.ventas.updateProductsListSearch ();
		}
	});
       			
    ui.init();
};

ui.showHidePagoCon = function (metodo_pago)
{
	var efectivoCobro = 
		storage.local.find('forma_pago', $('#metodos_pago_fieldset :radio:checked').val()).afecta_cxc == 'off';
					
	if(efectivoCobro) {
		document.getElementById('pago_con_fieldcontain').style.display = 'block';
	} else {
		document.getElementById('pago_con_fieldcontain').style.display = 'none';
	}
};


ui.page_balance_cliente = {};
ui.page_balance_cliente.refresh = function () {
	var clientId = document.getElementById('client_form').id.value;
	entities.cliente_transaccion.query ("SELECT 0 AS id, SUM(cantidad) AS total FROM cliente_transaccion WHERE cliente = '"+clientId+"'"
				, function(results) { 
					document.getElementById('balance_cliente_monto').innerHTML = system.showCurrency(results[0].total); 
					document.getElementById('cliente_saldo').innerHTML = system.showCurrency(results[0].total); 
					entities.client.find(clientId, null, function(row) { row.data.saldo = results[0].total; entities.client.save(row.id, row.data); });
				});
	
};

ui.page_balance = {};
ui.page_balance.refresh = function () {
	entities.transaccion.query ("SELECT 0 AS id, SUM(cantidad) AS total FROM transaccion"
				, function(results) { document.getElementById('balance_monto').innerHTML = system.showCurrency(results[0].total); });
};