
var settings = {
	entities : {
		client : {
			persistence : {
				method 	: 'local',
				type	: 'client',
			},
			sync : {
				push	: { enable : false },
				pull 	: { enable : false } 
			},

			auth : {
			},
			
			format : {
				saldo : 'currency',
			},
			
		},
	
		forma_pago : {
			persistence: {
				method : 'local',
				type   : 'forma_pago',
			},
			sync : {
			},
			auth : {
			}
		},

		tax : {
			persistence: {
				method : 'local',
				type   : 'tax',
			},
			sync : {
			},
			auth : {
			}
		},
	
		unit : {
			persistence: {
				method : 'local',
				type   : 'unit',
			},
			sync : {
			},
			auth : {
			}
		},

		currency: {
			persistence: {
				method : 'local',
				type   : 'unit',	
			},
			sync : {
			},
			auth : {	
			}	
		},	
		
		supplier : {
			persistence : {
				method 	: 'local',
				type	: 'supplier'
			},
			sync : {
				push	: { enable : false },
				pull 	: { enable : false } 
			}
	
		},
		
		sell : {
			persistence : {
				method 	: 'db',
				type	: 'sell',
				table	: 'sell',
				fields	: { 
					id: {
						type: 'TEXT', attribs: 'PRIMARY KEY'
					},
					total: {
						type: 'REAL', attribs: ''
					},
					metodo_pago : {
						type: 'TEXT', attribs: ''
					},
					cliente: {
						type: 'TEXT', attribs: ''
					},
					fecha_hora: {
						type: 'INTEGER', attribs: ''
					},
					estatus: {
						type: 'TEXT', attribs: '' /* woah! */
					}
				}
			},
			sync : {
				push	: { enable : true },
				pull 	: { enable : false } 
			},
			format : {
				fecha_hora : 'date'
			},
        },
		
        nota_entrada : {
    		persistence : {
				method 	: 'db',
				type	: 'nota_entrada',
				table	: 'nota_entrada',
				fields	: { 
					id: {
						type: 'TEXT', attribs: 'PRIMARY KEY'
					},
					fecha_hora: {
						type: 'INTEGER', attribs: ''
					},
                    total: {
						type: 'REAL', attribs: ''
					},
					proveedor: {
						type: 'TEXT', attribs: ''
					},
					
				}
			},
			sync : {
				push	: { enable : true },
				pull 	: { enable : false } 
			},
			format : {
				total : 'currency',
				fecha_hora : 'date',
			},

		},
		
		sell_detail : {
			persistence : {
				method 	: 'db',
				type	: 'sell_detail',
				table	: 'sell_detail',
				fields	: { 
					id: {
						type: 'INTEGER', attribs: 'PRIMARY KEY AUTOINCREMENT'
					},
					product_id: {
						type: 'TEXT', attribs: ''
					},
					sell_id : {
						type: 'TEXT', attribs: ''
					},
					qty: {
						type: 'INTEGER', attribs: ''
					},
					price: {
						type: 'REAL', attribs: ''
					},
					cost: {
						type: 'REAL', attribs: ''
					},
					total: {
						type: 'REAL', attribs: ''
					}
				}
			},
			sync : {
				push	: { enable : true },
				pull 	: { enable : false } 
			}
		},
		
        nota_entrada_detail : {
    		persistence : {
				method 	: 'db',
				type	: 'nota_entrada_detail',
				table	: 'nota_entrada_detail',
				fields	: { 
					id: {
						type: 'INTEGER', attribs: 'PRIMARY KEY AUTOINCREMENT'
					},
					product_id: {
						type: 'TEXT', attribs: ''
					},
					nota_entrada_id : {
						type: 'TEXT', attribs: ''
					},
					qty: {
						type: 'INTEGER', attribs: ''
					},
					cost: {
						type: 'REAL', attribs: ''
					},
					total: {
						type: 'REAL', attribs: ''
					}
				}
			},
			sync : {
				push	: { enable : true },
				pull 	: { enable : false } 
			}
		},
        
		product : {
			persistence : {
				method 	: 'db',
				type	: 'product',
				table	: 'product',
				fields	: { 
					id: {
						type: 'TEXT', attribs: 'PRIMARY KEY DESC'
					},
					nombre: {
						type: 'TEXT', attribs: ''
					},
					cantidad: {
						type: 'REAL', attribs: ''
					},
					unidad: {
						type: 'TEXT', attribs: ''
					},
					precio: {
						type: 'REAL', attribs: ''
					},
					proveedor: {
						type: 'TEXT', attribs: ''
					},
					costo: {
						type: 'REAL', attribs: ''
					}
				}

			},
			sync : {
				push	: { enable : true },
				pull 	: { enable : false } 
			}
		},
		
		setting : {
			persistence : {
				method 	: 'local',
				type	: 'setting',
			},
			sync : {
				push	: { enable : false },
				pull 	: { enable : false } 
			},

			auth : {
			}
		},
        
        transaccion : {
            persistence : {
    			method 	: 'db',
				type	: 'transaccion',
				table	: 'transaccion',
				fields	: { 
					id: {
						type: 'INTEGER', attribs: 'PRIMARY KEY AUTOINCREMENT'
					},
					fecha: {
						type: 'INTEGER', attribs: ''
					},
					concepto: {
						type: 'TEXT', attribs: ''
					},
					cantidad: {
						type: 'REAL', attribs: ''
					},
				}
			},
			sync : {
				push	: { enable : true },
				pull 	: { enable : false } 
			},
			format : {
				cantidad : 'currency',
				fecha : 'date',
			},
		},
		
		cliente_transaccion : {
            	persistence : {
    			method 	: 'db',
				type	: 'cliente_transaccion',
				table	: 'cliente_transaccion',
				fields	: { 
					id: {
						type: 'INTEGER', attribs: 'PRIMARY KEY AUTOINCREMENT'
					},
					fecha: {
						type: 'INTEGER', attribs: ''
					},
					concepto: {
						type: 'TEXT', attribs: ''
					},
					cantidad: {
						type: 'REAL', attribs: ''
					},
					cliente: {
						type: 'TEXT', 
					},
				}
			},
			sync : {
				push	: { enable : true },
				pull 	: { enable : false } 
			},
			format : {
				cantidad : 'currency',
				fecha : 'date',
			},
		},
	},
	
	security : {
		roles : ['admin','pdv'],
		resources: ['sells','products','suppliers','clients','admin'],
		rules: [
			{ admin : ['sells','products','suppliers','clients','admin'] },
			{ pdv : ['sells'] }
		] 
	},
	log : {
		
	},
	sync : {
		sources : {
			push : [],
			pull : []
		}
	},
	persistence : {
		db : {
			
		}
	},
	station : {
		uniqid : 1
	}
};
