var $hxClasses = $hxClasses || {},$estr = function() { return js.Boot.__string_rec(this,''); };
function $extend(from, fields) {
	function inherit() {}; inherit.prototype = from; var proto = new inherit();
	for (var name in fields) proto[name] = fields[name];
	return proto;
}
var EReg = $hxClasses["EReg"] = function(r,opt) {
	opt = opt.split("u").join("");
	this.r = new RegExp(r,opt);
};
EReg.__name__ = ["EReg"];
EReg.prototype = {
	customReplace: function(s,f) {
		var buf = new StringBuf();
		while(true) {
			if(!this.match(s)) break;
			buf.b += Std.string(this.matchedLeft());
			buf.b += Std.string(f(this));
			s = this.matchedRight();
		}
		buf.b += Std.string(s);
		return buf.b;
	}
	,replace: function(s,by) {
		return s.replace(this.r,by);
	}
	,split: function(s) {
		var d = "#__delim__#";
		return s.replace(this.r,d).split(d);
	}
	,matchedPos: function() {
		if(this.r.m == null) throw "No string matched";
		return { pos : this.r.m.index, len : this.r.m[0].length};
	}
	,matchedRight: function() {
		if(this.r.m == null) throw "No string matched";
		var sz = this.r.m.index + this.r.m[0].length;
		return this.r.s.substr(sz,this.r.s.length - sz);
	}
	,matchedLeft: function() {
		if(this.r.m == null) throw "No string matched";
		return this.r.s.substr(0,this.r.m.index);
	}
	,matched: function(n) {
		return this.r.m != null && n >= 0 && n < this.r.m.length?this.r.m[n]:(function($this) {
			var $r;
			throw "EReg::matched";
			return $r;
		}(this));
	}
	,match: function(s) {
		if(this.r.global) this.r.lastIndex = 0;
		this.r.m = this.r.exec(s);
		this.r.s = s;
		return this.r.m != null;
	}
	,r: null
	,__class__: EReg
}
var HxOverrides = $hxClasses["HxOverrides"] = function() { }
HxOverrides.__name__ = ["HxOverrides"];
HxOverrides.dateStr = function(date) {
	var m = date.getMonth() + 1;
	var d = date.getDate();
	var h = date.getHours();
	var mi = date.getMinutes();
	var s = date.getSeconds();
	return date.getFullYear() + "-" + (m < 10?"0" + m:"" + m) + "-" + (d < 10?"0" + d:"" + d) + " " + (h < 10?"0" + h:"" + h) + ":" + (mi < 10?"0" + mi:"" + mi) + ":" + (s < 10?"0" + s:"" + s);
}
HxOverrides.strDate = function(s) {
	switch(s.length) {
	case 8:
		var k = s.split(":");
		var d = new Date();
		d.setTime(0);
		d.setUTCHours(k[0]);
		d.setUTCMinutes(k[1]);
		d.setUTCSeconds(k[2]);
		return d;
	case 10:
		var k = s.split("-");
		return new Date(k[0],k[1] - 1,k[2],0,0,0);
	case 19:
		var k = s.split(" ");
		var y = k[0].split("-");
		var t = k[1].split(":");
		return new Date(y[0],y[1] - 1,y[2],t[0],t[1],t[2]);
	default:
		throw "Invalid date format : " + s;
	}
}
HxOverrides.cca = function(s,index) {
	var x = s.charCodeAt(index);
	if(x != x) return undefined;
	return x;
}
HxOverrides.substr = function(s,pos,len) {
	if(pos != null && pos != 0 && len != null && len < 0) return "";
	if(len == null) len = s.length;
	if(pos < 0) {
		pos = s.length + pos;
		if(pos < 0) pos = 0;
	} else if(len < 0) len = s.length + len - pos;
	return s.substr(pos,len);
}
HxOverrides.remove = function(a,obj) {
	var i = 0;
	var l = a.length;
	while(i < l) {
		if(a[i] == obj) {
			a.splice(i,1);
			return true;
		}
		i++;
	}
	return false;
}
HxOverrides.iter = function(a) {
	return { cur : 0, arr : a, hasNext : function() {
		return this.cur < this.arr.length;
	}, next : function() {
		return this.arr[this.cur++];
	}};
}
var IntIter = $hxClasses["IntIter"] = function(min,max) {
	this.min = min;
	this.max = max;
};
IntIter.__name__ = ["IntIter"];
IntIter.prototype = {
	next: function() {
		return this.min++;
	}
	,hasNext: function() {
		return this.min < this.max;
	}
	,max: null
	,min: null
	,__class__: IntIter
}
var Lambda = $hxClasses["Lambda"] = function() { }
Lambda.__name__ = ["Lambda"];
Lambda.array = function(it) {
	var a = new Array();
	var $it0 = $iterator(it)();
	while( $it0.hasNext() ) {
		var i = $it0.next();
		a.push(i);
	}
	return a;
}
Lambda.list = function(it) {
	var l = new List();
	var $it0 = $iterator(it)();
	while( $it0.hasNext() ) {
		var i = $it0.next();
		l.add(i);
	}
	return l;
}
Lambda.map = function(it,f) {
	var l = new List();
	var $it0 = $iterator(it)();
	while( $it0.hasNext() ) {
		var x = $it0.next();
		l.add(f(x));
	}
	return l;
}
Lambda.mapi = function(it,f) {
	var l = new List();
	var i = 0;
	var $it0 = $iterator(it)();
	while( $it0.hasNext() ) {
		var x = $it0.next();
		l.add(f(i++,x));
	}
	return l;
}
Lambda.has = function(it,elt,cmp) {
	if(cmp == null) {
		var $it0 = $iterator(it)();
		while( $it0.hasNext() ) {
			var x = $it0.next();
			if(x == elt) return true;
		}
	} else {
		var $it1 = $iterator(it)();
		while( $it1.hasNext() ) {
			var x = $it1.next();
			if(cmp(x,elt)) return true;
		}
	}
	return false;
}
Lambda.exists = function(it,f) {
	var $it0 = $iterator(it)();
	while( $it0.hasNext() ) {
		var x = $it0.next();
		if(f(x)) return true;
	}
	return false;
}
Lambda.foreach = function(it,f) {
	var $it0 = $iterator(it)();
	while( $it0.hasNext() ) {
		var x = $it0.next();
		if(!f(x)) return false;
	}
	return true;
}
Lambda.iter = function(it,f) {
	var $it0 = $iterator(it)();
	while( $it0.hasNext() ) {
		var x = $it0.next();
		f(x);
	}
}
Lambda.filter = function(it,f) {
	var l = new List();
	var $it0 = $iterator(it)();
	while( $it0.hasNext() ) {
		var x = $it0.next();
		if(f(x)) l.add(x);
	}
	return l;
}
Lambda.fold = function(it,f,first) {
	var $it0 = $iterator(it)();
	while( $it0.hasNext() ) {
		var x = $it0.next();
		first = f(x,first);
	}
	return first;
}
Lambda.count = function(it,pred) {
	var n = 0;
	if(pred == null) {
		var $it0 = $iterator(it)();
		while( $it0.hasNext() ) {
			var _ = $it0.next();
			n++;
		}
	} else {
		var $it1 = $iterator(it)();
		while( $it1.hasNext() ) {
			var x = $it1.next();
			if(pred(x)) n++;
		}
	}
	return n;
}
Lambda.empty = function(it) {
	return !$iterator(it)().hasNext();
}
Lambda.indexOf = function(it,v) {
	var i = 0;
	var $it0 = $iterator(it)();
	while( $it0.hasNext() ) {
		var v2 = $it0.next();
		if(v == v2) return i;
		i++;
	}
	return -1;
}
Lambda.concat = function(a,b) {
	var l = new List();
	var $it0 = $iterator(a)();
	while( $it0.hasNext() ) {
		var x = $it0.next();
		l.add(x);
	}
	var $it1 = $iterator(b)();
	while( $it1.hasNext() ) {
		var x = $it1.next();
		l.add(x);
	}
	return l;
}
var List = $hxClasses["List"] = function() {
	this.length = 0;
};
List.__name__ = ["List"];
List.prototype = {
	map: function(f) {
		var b = new List();
		var l = this.h;
		while(l != null) {
			var v = l[0];
			l = l[1];
			b.add(f(v));
		}
		return b;
	}
	,filter: function(f) {
		var l2 = new List();
		var l = this.h;
		while(l != null) {
			var v = l[0];
			l = l[1];
			if(f(v)) l2.add(v);
		}
		return l2;
	}
	,join: function(sep) {
		var s = new StringBuf();
		var first = true;
		var l = this.h;
		while(l != null) {
			if(first) first = false; else s.b += Std.string(sep);
			s.b += Std.string(l[0]);
			l = l[1];
		}
		return s.b;
	}
	,toString: function() {
		var s = new StringBuf();
		var first = true;
		var l = this.h;
		s.b += Std.string("{");
		while(l != null) {
			if(first) first = false; else s.b += Std.string(", ");
			s.b += Std.string(Std.string(l[0]));
			l = l[1];
		}
		s.b += Std.string("}");
		return s.b;
	}
	,iterator: function() {
		return { h : this.h, hasNext : function() {
			return this.h != null;
		}, next : function() {
			if(this.h == null) return null;
			var x = this.h[0];
			this.h = this.h[1];
			return x;
		}};
	}
	,remove: function(v) {
		var prev = null;
		var l = this.h;
		while(l != null) {
			if(l[0] == v) {
				if(prev == null) this.h = l[1]; else prev[1] = l[1];
				if(this.q == l) this.q = prev;
				this.length--;
				return true;
			}
			prev = l;
			l = l[1];
		}
		return false;
	}
	,clear: function() {
		this.h = null;
		this.q = null;
		this.length = 0;
	}
	,isEmpty: function() {
		return this.h == null;
	}
	,pop: function() {
		if(this.h == null) return null;
		var x = this.h[0];
		this.h = this.h[1];
		if(this.h == null) this.q = null;
		this.length--;
		return x;
	}
	,last: function() {
		return this.q == null?null:this.q[0];
	}
	,first: function() {
		return this.h == null?null:this.h[0];
	}
	,push: function(item) {
		var x = [item,this.h];
		this.h = x;
		if(this.q == null) this.q = x;
		this.length++;
	}
	,add: function(item) {
		var x = [item];
		if(this.h == null) this.h = x; else this.q[1] = x;
		this.q = x;
		this.length++;
	}
	,length: null
	,q: null
	,h: null
	,__class__: List
}
var Reflect = $hxClasses["Reflect"] = function() { }
Reflect.__name__ = ["Reflect"];
Reflect.hasField = function(o,field) {
	return Object.prototype.hasOwnProperty.call(o,field);
}
Reflect.field = function(o,field) {
	var v = null;
	try {
		v = o[field];
	} catch( e ) {
	}
	return v;
}
Reflect.setField = function(o,field,value) {
	o[field] = value;
}
Reflect.getProperty = function(o,field) {
	var tmp;
	return o == null?null:o.__properties__ && (tmp = o.__properties__["get_" + field])?o[tmp]():o[field];
}
Reflect.setProperty = function(o,field,value) {
	var tmp;
	if(o.__properties__ && (tmp = o.__properties__["set_" + field])) o[tmp](value); else o[field] = value;
}
Reflect.callMethod = function(o,func,args) {
	return func.apply(o,args);
}
Reflect.fields = function(o) {
	var a = [];
	if(o != null) {
		var hasOwnProperty = Object.prototype.hasOwnProperty;
		for( var f in o ) {
		if(hasOwnProperty.call(o,f)) a.push(f);
		}
	}
	return a;
}
Reflect.isFunction = function(f) {
	return typeof(f) == "function" && !(f.__name__ || f.__ename__);
}
Reflect.compare = function(a,b) {
	return a == b?0:a > b?1:-1;
}
Reflect.compareMethods = function(f1,f2) {
	if(f1 == f2) return true;
	if(!Reflect.isFunction(f1) || !Reflect.isFunction(f2)) return false;
	return f1.scope == f2.scope && f1.method == f2.method && f1.method != null;
}
Reflect.isObject = function(v) {
	if(v == null) return false;
	var t = typeof(v);
	return t == "string" || t == "object" && !v.__enum__ || t == "function" && (v.__name__ || v.__ename__);
}
Reflect.deleteField = function(o,f) {
	if(!Reflect.hasField(o,f)) return false;
	delete(o[f]);
	return true;
}
Reflect.copy = function(o) {
	var o2 = { };
	var _g = 0, _g1 = Reflect.fields(o);
	while(_g < _g1.length) {
		var f = _g1[_g];
		++_g;
		o2[f] = Reflect.field(o,f);
	}
	return o2;
}
Reflect.makeVarArgs = function(f) {
	return function() {
		var a = Array.prototype.slice.call(arguments);
		return f(a);
	};
}
var Std = $hxClasses["Std"] = function() { }
Std.__name__ = ["Std"];
Std["is"] = function(v,t) {
	return js.Boot.__instanceof(v,t);
}
Std.string = function(s) {
	return js.Boot.__string_rec(s,"");
}
Std["int"] = function(x) {
	return x | 0;
}
Std.parseInt = function(x) {
	var v = parseInt(x,10);
	if(v == 0 && (HxOverrides.cca(x,1) == 120 || HxOverrides.cca(x,1) == 88)) v = parseInt(x);
	if(isNaN(v)) return null;
	return v;
}
Std.parseFloat = function(x) {
	return parseFloat(x);
}
Std.random = function(x) {
	return Math.floor(Math.random() * x);
}
var StringBuf = $hxClasses["StringBuf"] = function() {
	this.b = "";
};
StringBuf.__name__ = ["StringBuf"];
StringBuf.prototype = {
	toString: function() {
		return this.b;
	}
	,addSub: function(s,pos,len) {
		this.b += HxOverrides.substr(s,pos,len);
	}
	,addChar: function(c) {
		this.b += String.fromCharCode(c);
	}
	,add: function(x) {
		this.b += Std.string(x);
	}
	,b: null
	,__class__: StringBuf
}
var StringTools = $hxClasses["StringTools"] = function() { }
StringTools.__name__ = ["StringTools"];
StringTools.urlEncode = function(s) {
	return encodeURIComponent(s);
}
StringTools.urlDecode = function(s) {
	return decodeURIComponent(s.split("+").join(" "));
}
StringTools.htmlEscape = function(s) {
	return s.split("&").join("&amp;").split("<").join("&lt;").split(">").join("&gt;");
}
StringTools.htmlUnescape = function(s) {
	return s.split("&gt;").join(">").split("&lt;").join("<").split("&amp;").join("&");
}
StringTools.startsWith = function(s,start) {
	return s.length >= start.length && HxOverrides.substr(s,0,start.length) == start;
}
StringTools.endsWith = function(s,end) {
	var elen = end.length;
	var slen = s.length;
	return slen >= elen && HxOverrides.substr(s,slen - elen,elen) == end;
}
StringTools.isSpace = function(s,pos) {
	var c = HxOverrides.cca(s,pos);
	return c >= 9 && c <= 13 || c == 32;
}
StringTools.ltrim = function(s) {
	var l = s.length;
	var r = 0;
	while(r < l && StringTools.isSpace(s,r)) r++;
	if(r > 0) return HxOverrides.substr(s,r,l - r); else return s;
}
StringTools.rtrim = function(s) {
	var l = s.length;
	var r = 0;
	while(r < l && StringTools.isSpace(s,l - r - 1)) r++;
	if(r > 0) return HxOverrides.substr(s,0,l - r); else return s;
}
StringTools.trim = function(s) {
	return StringTools.ltrim(StringTools.rtrim(s));
}
StringTools.rpad = function(s,c,l) {
	var sl = s.length;
	var cl = c.length;
	while(sl < l) if(l - sl < cl) {
		s += HxOverrides.substr(c,0,l - sl);
		sl = l;
	} else {
		s += c;
		sl += cl;
	}
	return s;
}
StringTools.lpad = function(s,c,l) {
	var ns = "";
	var sl = s.length;
	if(sl >= l) return s;
	var cl = c.length;
	while(sl < l) if(l - sl < cl) {
		ns += HxOverrides.substr(c,0,l - sl);
		sl = l;
	} else {
		ns += c;
		sl += cl;
	}
	return ns + s;
}
StringTools.replace = function(s,sub,by) {
	return s.split(sub).join(by);
}
StringTools.hex = function(n,digits) {
	var s = "";
	var hexChars = "0123456789ABCDEF";
	do {
		s = hexChars.charAt(n & 15) + s;
		n >>>= 4;
	} while(n > 0);
	if(digits != null) while(s.length < digits) s = "0" + s;
	return s;
}
StringTools.fastCodeAt = function(s,index) {
	return s.charCodeAt(index);
}
StringTools.isEOF = function(c) {
	return c != c;
}
var ValueType = $hxClasses["ValueType"] = { __ename__ : ["ValueType"], __constructs__ : ["TNull","TInt","TFloat","TBool","TObject","TFunction","TClass","TEnum","TUnknown"] }
ValueType.TNull = ["TNull",0];
ValueType.TNull.toString = $estr;
ValueType.TNull.__enum__ = ValueType;
ValueType.TInt = ["TInt",1];
ValueType.TInt.toString = $estr;
ValueType.TInt.__enum__ = ValueType;
ValueType.TFloat = ["TFloat",2];
ValueType.TFloat.toString = $estr;
ValueType.TFloat.__enum__ = ValueType;
ValueType.TBool = ["TBool",3];
ValueType.TBool.toString = $estr;
ValueType.TBool.__enum__ = ValueType;
ValueType.TObject = ["TObject",4];
ValueType.TObject.toString = $estr;
ValueType.TObject.__enum__ = ValueType;
ValueType.TFunction = ["TFunction",5];
ValueType.TFunction.toString = $estr;
ValueType.TFunction.__enum__ = ValueType;
ValueType.TClass = function(c) { var $x = ["TClass",6,c]; $x.__enum__ = ValueType; $x.toString = $estr; return $x; }
ValueType.TEnum = function(e) { var $x = ["TEnum",7,e]; $x.__enum__ = ValueType; $x.toString = $estr; return $x; }
ValueType.TUnknown = ["TUnknown",8];
ValueType.TUnknown.toString = $estr;
ValueType.TUnknown.__enum__ = ValueType;
var Type = $hxClasses["Type"] = function() { }
Type.__name__ = ["Type"];
Type.getClass = function(o) {
	if(o == null) return null;
	return o.__class__;
}
Type.getEnum = function(o) {
	if(o == null) return null;
	return o.__enum__;
}
Type.getSuperClass = function(c) {
	return c.__super__;
}
Type.getClassName = function(c) {
	var a = c.__name__;
	return a.join(".");
}
Type.getEnumName = function(e) {
	var a = e.__ename__;
	return a.join(".");
}
Type.resolveClass = function(name) {
	var cl = $hxClasses[name];
	if(cl == null || !cl.__name__) return null;
	return cl;
}
Type.resolveEnum = function(name) {
	var e = $hxClasses[name];
	if(e == null || !e.__ename__) return null;
	return e;
}
Type.createInstance = function(cl,args) {
	switch(args.length) {
	case 0:
		return new cl();
	case 1:
		return new cl(args[0]);
	case 2:
		return new cl(args[0],args[1]);
	case 3:
		return new cl(args[0],args[1],args[2]);
	case 4:
		return new cl(args[0],args[1],args[2],args[3]);
	case 5:
		return new cl(args[0],args[1],args[2],args[3],args[4]);
	case 6:
		return new cl(args[0],args[1],args[2],args[3],args[4],args[5]);
	case 7:
		return new cl(args[0],args[1],args[2],args[3],args[4],args[5],args[6]);
	case 8:
		return new cl(args[0],args[1],args[2],args[3],args[4],args[5],args[6],args[7]);
	default:
		throw "Too many arguments";
	}
	return null;
}
Type.createEmptyInstance = function(cl) {
	function empty() {}; empty.prototype = cl.prototype;
	return new empty();
}
Type.createEnum = function(e,constr,params) {
	var f = Reflect.field(e,constr);
	if(f == null) throw "No such constructor " + constr;
	if(Reflect.isFunction(f)) {
		if(params == null) throw "Constructor " + constr + " need parameters";
		return f.apply(e,params);
	}
	if(params != null && params.length != 0) throw "Constructor " + constr + " does not need parameters";
	return f;
}
Type.createEnumIndex = function(e,index,params) {
	var c = e.__constructs__[index];
	if(c == null) throw index + " is not a valid enum constructor index";
	return Type.createEnum(e,c,params);
}
Type.getInstanceFields = function(c) {
	var a = [];
	for(var i in c.prototype) a.push(i);
	HxOverrides.remove(a,"__class__");
	HxOverrides.remove(a,"__properties__");
	return a;
}
Type.getClassFields = function(c) {
	var a = Reflect.fields(c);
	HxOverrides.remove(a,"__name__");
	HxOverrides.remove(a,"__interfaces__");
	HxOverrides.remove(a,"__properties__");
	HxOverrides.remove(a,"__super__");
	HxOverrides.remove(a,"prototype");
	return a;
}
Type.getEnumConstructs = function(e) {
	var a = e.__constructs__;
	return a.slice();
}
Type["typeof"] = function(v) {
	switch(typeof(v)) {
	case "boolean":
		return ValueType.TBool;
	case "string":
		return ValueType.TClass(String);
	case "number":
		if(Math.ceil(v) == v % 2147483648.0) return ValueType.TInt;
		return ValueType.TFloat;
	case "object":
		if(v == null) return ValueType.TNull;
		var e = v.__enum__;
		if(e != null) return ValueType.TEnum(e);
		var c = v.__class__;
		if(c != null) return ValueType.TClass(c);
		return ValueType.TObject;
	case "function":
		if(v.__name__ || v.__ename__) return ValueType.TObject;
		return ValueType.TFunction;
	case "undefined":
		return ValueType.TNull;
	default:
		return ValueType.TUnknown;
	}
}
Type.enumEq = function(a,b) {
	if(a == b) return true;
	try {
		if(a[0] != b[0]) return false;
		var _g1 = 2, _g = a.length;
		while(_g1 < _g) {
			var i = _g1++;
			if(!Type.enumEq(a[i],b[i])) return false;
		}
		var e = a.__enum__;
		if(e != b.__enum__ || e == null) return false;
	} catch( e ) {
		return false;
	}
	return true;
}
Type.enumConstructor = function(e) {
	return e[0];
}
Type.enumParameters = function(e) {
	return e.slice(2);
}
Type.enumIndex = function(e) {
	return e[1];
}
Type.allEnums = function(e) {
	var all = [];
	var cst = e.__constructs__;
	var _g = 0;
	while(_g < cst.length) {
		var c = cst[_g];
		++_g;
		var v = Reflect.field(e,c);
		if(!Reflect.isFunction(v)) all.push(v);
	}
	return all;
}
var co = co || {}
if(!co.doubleduck) co.doubleduck = {}
co.doubleduck.BaseAssets = $hxClasses["co.doubleduck.BaseAssets"] = function() {
};
co.doubleduck.BaseAssets.__name__ = ["co","doubleduck","BaseAssets"];
co.doubleduck.BaseAssets._localizedAssets = null;
co.doubleduck.BaseAssets.loader = function() {
	if(co.doubleduck.BaseAssets._loader == null) {
		co.doubleduck.BaseAssets._loader = new createjs.LoadQueue(true);
		co.doubleduck.BaseAssets._loader.installPlugin(createjs.LoadQueue.SOUND);
		co.doubleduck.BaseAssets._loader.onFileLoad = co.doubleduck.BaseAssets.handleFileLoaded;
		co.doubleduck.BaseAssets._loader.onError = co.doubleduck.BaseAssets.handleLoadError;
		co.doubleduck.BaseAssets._loader.setMaxConnections(10);
	}
	return co.doubleduck.BaseAssets._loader;
}
co.doubleduck.BaseAssets.loadAndCall = function(uri,callbackFunc) {
	co.doubleduck.BaseAssets.loader().loadFile(uri);
	co.doubleduck.BaseAssets._loadCallbacks[uri] = callbackFunc;
}
co.doubleduck.BaseAssets.finishLoading = function(manifest,sounds) {
	if(co.doubleduck.SoundManager.available) {
		var _g1 = 0, _g = sounds.length;
		while(_g1 < _g) {
			var currSound = _g1++;
			manifest.push(sounds[currSound] + co.doubleduck.SoundManager.EXTENSION);
			co.doubleduck.SoundManager.initSound(sounds[currSound]);
		}
	}
	if(co.doubleduck.BaseAssets._useLocalStorage) co.doubleduck.BaseAssets.loadFromLocalStorage(manifest);
	if(manifest.length == 0) {
		if(co.doubleduck.BaseAssets.onLoadAll != null) co.doubleduck.BaseAssets.onLoadAll();
	}
	if(co.doubleduck.BaseGame.isLocalized && co.doubleduck.BaseAssets._localizedAssets != null) {
		var _g1 = 0, _g = manifest.length;
		while(_g1 < _g) {
			var itemIndex = _g1++;
			var currItem = manifest[itemIndex];
			currItem = co.doubleduck.BaseAssets.getLocalisedImage(currItem);
			manifest[itemIndex] = currItem;
		}
	}
	co.doubleduck.BaseAssets.loader().onProgress = co.doubleduck.BaseAssets.handleProgress;
	co.doubleduck.BaseAssets.loader().onFileLoad = co.doubleduck.BaseAssets.manifestFileLoad;
	co.doubleduck.BaseAssets.loader().loadManifest(manifest);
	co.doubleduck.BaseAssets.loader().load();
}
co.doubleduck.BaseAssets.loadAll = function(manifest,sounds) {
	manifest[manifest.length] = "images/duckling/orientation_error_port.png";
	manifest[manifest.length] = "images/duckling/orientation_error_land.png";
	manifest[manifest.length] = "images/duckling/page_marker.png";
}
co.doubleduck.BaseAssets.setLocalizedAssets = function(assets) {
	co.doubleduck.BaseAssets._localizedAssets = assets;
}
co.doubleduck.BaseAssets.audioLoaded = function(event) {
	co.doubleduck.BaseAssets._cacheData[event.item.src] = event;
}
co.doubleduck.BaseAssets.manifestFileLoad = function(event) {
	if(co.doubleduck.BaseAssets._useLocalStorage && event != null) {
		var utils = new ddjsutils();
		try {
			var fileName = event.item.src;
			if(HxOverrides.substr(fileName,fileName.length - 3,null) == "jpg") return;
			co.doubleduck.BasePersistence.setValue(event.item.src,utils.getBase64Image(event.result));
		} catch( err ) {
		}
	}
}
co.doubleduck.BaseAssets.loadFromLocalStorage = function(manifest) {
	var entriesToRemove = new Array();
	var _g1 = 0, _g = manifest.length;
	while(_g1 < _g) {
		var i = _g1++;
		var entry = manifest[i];
		var value = co.doubleduck.BasePersistence.getValue(entry);
		if(value != null) {
			var bmp = new createjs.Bitmap("data:image/png;base64," + value);
			co.doubleduck.BaseAssets._cacheData[entry] = bmp.image;
			entriesToRemove.push(manifest[i]);
		}
	}
	var _g1 = 0, _g = entriesToRemove.length;
	while(_g1 < _g) {
		var j = _g1++;
		HxOverrides.remove(manifest,entriesToRemove[j]);
	}
}
co.doubleduck.BaseAssets.handleProgress = function(event) {
	co.doubleduck.BaseAssets.loaded = event.loaded;
	if(event.loaded == event.total) {
		co.doubleduck.BaseAssets.loader().onProgress = null;
		co.doubleduck.BaseAssets.onLoadAll();
	}
}
co.doubleduck.BaseAssets.handleLoadError = function(event) {
}
co.doubleduck.BaseAssets.handleFileLoaded = function(event) {
	if(event != null) {
		co.doubleduck.BaseAssets._cacheData[event.item.src] = event.result;
		var callbackFunc = Reflect.field(co.doubleduck.BaseAssets._loadCallbacks,event.item.src);
		if(callbackFunc != null) callbackFunc();
	}
}
co.doubleduck.BaseAssets.getAsset = function(uri) {
	var cache = Reflect.field(co.doubleduck.BaseAssets._cacheData,uri);
	if(cache == null) {
		if(co.doubleduck.BaseAssets.loader().getResult(uri) != null) {
			cache = co.doubleduck.BaseAssets.loader().getResult(uri);
			co.doubleduck.BaseAssets._cacheData[uri] = cache;
		}
	}
	return cache;
}
co.doubleduck.BaseAssets.getLocalisedImage = function(image) {
	var currItem = image;
	if(co.doubleduck.BaseAssets._localizedAssets != null && Lambda.indexOf(co.doubleduck.BaseAssets._localizedAssets,currItem) != -1) {
		var delim = ".png";
		var delimIndex = currItem.indexOf(delim);
		var localisedItem = HxOverrides.substr(currItem,0,delimIndex);
		localisedItem += "-" + co.doubleduck.BaseGame.activeLocale + ".png";
		return localisedItem;
	}
	return currItem;
}
co.doubleduck.BaseAssets.getRawImage = function(uri) {
	uri = co.doubleduck.BaseAssets.getLocalisedImage(uri);
	var cache = co.doubleduck.BaseAssets.getAsset(uri);
	if(cache == null) {
		var bmp = new createjs.Bitmap(uri);
		co.doubleduck.BaseAssets._cacheData[uri] = bmp.image;
		cache = bmp.image;
		null;
	}
	return cache;
}
co.doubleduck.BaseAssets.getImage = function(uri,mouseEnabled) {
	if(mouseEnabled == null) mouseEnabled = false;
	var result = new createjs.Bitmap(co.doubleduck.BaseAssets.getRawImage(uri));
	result.mouseEnabled = mouseEnabled;
	return result;
}
co.doubleduck.BaseAssets.prototype = {
	__class__: co.doubleduck.BaseAssets
}
co.doubleduck.Assets = $hxClasses["co.doubleduck.Assets"] = function() {
	co.doubleduck.BaseAssets.call(this);
};
co.doubleduck.Assets.__name__ = ["co","doubleduck","Assets"];
co.doubleduck.Assets.loadAll = function() {
	var manifest = new Array();
	var sounds = new Array();
	sounds.push("sound/button_press");
	sounds.push("sound/car_bump");
	sounds.push("sound/crunch");
	sounds.push("sound/level_pass");
	sounds.push("sound/menu_music");
	sounds.push("sound/teleport");
	sounds.push("sound/tommy_fall");
	co.doubleduck.BaseAssets.loadAll(manifest,sounds);
	var localised = [];
	manifest.push("images/splash/bg.png");
	manifest.push("images/splash/logo1.png");
	manifest.push("images/splash/logo2.png");
	manifest.push("images/splash/cookie1.png");
	manifest.push("images/splash/cookie2.png");
	manifest.push("images/splash/cookie3.png");
	manifest.push("images/splash/cookie4.png");
	manifest.push("images/splash/tap.png");
	localised.push("images/splash/tap.png");
	manifest.push("images/menu/bg.png");
	manifest.push("images/menu/arrow_right.png");
	manifest.push("images/menu/arrow_left.png");
	manifest.push("images/menu/help.png");
	manifest.push("images/menu/sound.png");
	var _g = 1;
	while(_g < 4) {
		var i = _g++;
		manifest.push("images/menu/icons" + i + ".png");
	}
	var _g = 0;
	while(_g < 10) {
		var i = _g++;
		manifest.push("images/menu/menu_font/" + i + ".png");
	}
	manifest.push("images/help/help_screen.png");
	manifest.push("images/help/help1.png");
	manifest.push("images/help/help2.png");
	manifest.push("images/help/help3.png");
	manifest.push("images/help/next.png");
	manifest.push("images/help/got_it.png");
	localised = localised.concat(["images/help/help1.png","images/help/help2.png","images/help/help3.png","images/help/next.png","images/help/got_it.png"]);
	manifest.push("images/session/tommy.png");
	manifest.push("images/session/cookie.png");
	manifest.push("images/session/stairs.png");
	manifest.push("images/session/menu.png");
	manifest.push("images/session/retry.png");
	var _g = 1;
	while(_g < 4) {
		var j = _g++;
		manifest.push("images/session/moveH" + j + ".png");
	}
	var _g = 1;
	while(_g < 4) {
		var j = _g++;
		manifest.push("images/session/moveV" + j + ".png");
	}
	var _g = 1;
	while(_g < 4) {
		var i = _g++;
		manifest.push("images/session/world" + i + "/back.png");
		manifest.push("images/session/world" + i + "/platform.png");
		manifest.push("images/session/world" + i + "/goal.png");
		var _g1 = 1;
		while(_g1 < 4) {
			var j = _g1++;
			manifest.push("images/session/world" + i + "/block" + j + ".png");
		}
	}
	manifest.push("images/session/session_end/finish.png");
	manifest.push("images/session/session_end/end_game.png");
	manifest.push("images/session/session_end/1star.png");
	manifest.push("images/session/session_end/2star.png");
	manifest.push("images/session/session_end/3star.png");
	manifest.push("images/session/session_end/glow.png");
	manifest.push("images/session/session_end/play.png");
	localised.push("images/session/session_end/finish.png");
	localised.push("images/session/session_end/end_game.png");
	co.doubleduck.BaseAssets.setLocalizedAssets(localised);
	co.doubleduck.BaseAssets.finishLoading(manifest,sounds);
}
co.doubleduck.Assets.__super__ = co.doubleduck.BaseAssets;
co.doubleduck.Assets.prototype = $extend(co.doubleduck.BaseAssets.prototype,{
	__class__: co.doubleduck.Assets
});
co.doubleduck.BaseGame = $hxClasses["co.doubleduck.BaseGame"] = function(stage) {
	this._waitingToStart = false;
	this._orientError = null;
	this._prevWinSize = new createjs.Rectangle(0,0,1,1);
	if(co.doubleduck.BaseGame._wantLandscape) {
		co.doubleduck.BaseGame.MAX_HEIGHT = 320;
		co.doubleduck.BaseGame.MAX_WIDTH = 570;
	} else {
		co.doubleduck.BaseGame.MAX_HEIGHT = 570;
		co.doubleduck.BaseGame.MAX_WIDTH = 320;
	}
	if(co.doubleduck.BaseGame.DEBUG) co.doubleduck.BasePersistence.clearAll();
	var isGS3Stock = /Android 4.0.4/.test(navigator.userAgent);
	isGS3Stock = isGS3Stock && /GT-I9300/.test(navigator.userAgent);
	isGS3Stock = isGS3Stock && !/Chrome/.test(navigator.userAgent);
	if(isGS3Stock) {
		var loc = window.location.href;
		if(loc.lastIndexOf("index.html") != -1) loc = HxOverrides.substr(loc,0,loc.lastIndexOf("index.html"));
		loc += "error.html";
		window.location.href=loc;
		return;
	}
	co.doubleduck.Persistence.initGameData();
	co.doubleduck.BaseGame._stage = stage;
	co.doubleduck.BaseGame._stage.onTick = $bind(this,this.handleStageTick);
	co.doubleduck.BaseGame._viewport = new createjs.Rectangle(0,0,1,1);
	co.doubleduck.BaseGame.hammer = new Hammer(js.Lib.document.getElementById("stageCanvas"));
	viewporter.preventPageScroll = true;
	viewporter.change($bind(this,this.handleViewportChanged));
	if(viewporter.ACTIVE) {
		viewporter.preventPageScroll = true;
		viewporter.change($bind(this,this.handleViewportChanged));
		if(co.doubleduck.BaseGame._wantLandscape != viewporter.isLandscape()) {
			if(co.doubleduck.BaseGame._wantLandscape) co.doubleduck.BaseAssets.loadAndCall(co.doubleduck.BaseGame.ORIENT_LAND_URI,$bind(this,this.waitForOrientation)); else co.doubleduck.BaseAssets.loadAndCall(co.doubleduck.BaseGame.ORIENT_PORT_URI,$bind(this,this.waitForOrientation));
		} else co.doubleduck.BaseAssets.loadAndCall(co.doubleduck.BaseGame.LOGO_URI,$bind(this,this.loadBarFill));
	} else co.doubleduck.BaseAssets.loadAndCall(co.doubleduck.BaseGame.LOGO_URI,$bind(this,this.loadBarFill));
};
co.doubleduck.BaseGame.__name__ = ["co","doubleduck","BaseGame"];
co.doubleduck.BaseGame._stage = null;
co.doubleduck.BaseGame._wantLandscape = null;
co.doubleduck.BaseGame.MAX_HEIGHT = null;
co.doubleduck.BaseGame.MAX_WIDTH = null;
co.doubleduck.BaseGame.activeLocale = null;
co.doubleduck.BaseGame.availableLocales = null;
co.doubleduck.BaseGame.defaultLocale = null;
co.doubleduck.BaseGame.hammer = null;
co.doubleduck.BaseGame.getViewport = function() {
	return co.doubleduck.BaseGame._viewport;
}
co.doubleduck.BaseGame.getScreenSize = function() {
	if(co.doubleduck.BaseGame._wantLandscape) return new createjs.Rectangle(0,0,Math.floor(co.doubleduck.BaseGame._viewport.width / co.doubleduck.BaseGame._scale),co.doubleduck.BaseGame.MAX_HEIGHT); else return new createjs.Rectangle(0,0,co.doubleduck.BaseGame.MAX_WIDTH,Math.floor(co.doubleduck.BaseGame._viewport.height / co.doubleduck.BaseGame._scale));
}
co.doubleduck.BaseGame.getScale = function() {
	return co.doubleduck.BaseGame._scale;
}
co.doubleduck.BaseGame.getStage = function() {
	return co.doubleduck.BaseGame._stage;
}
co.doubleduck.BaseGame.prototype = {
	setScale: function() {
		var fixedVal = co.doubleduck.BaseGame._viewport.width;
		var varVal = co.doubleduck.BaseGame._viewport.height;
		var idealFixed = co.doubleduck.BaseGame.MAX_WIDTH;
		var idealVar = co.doubleduck.BaseGame.MAX_HEIGHT;
		if(co.doubleduck.BaseGame._wantLandscape) {
			fixedVal = co.doubleduck.BaseGame._viewport.height;
			varVal = co.doubleduck.BaseGame._viewport.width;
			idealFixed = co.doubleduck.BaseGame.MAX_HEIGHT;
			idealVar = co.doubleduck.BaseGame.MAX_WIDTH;
		}
		var regScale = varVal / idealVar;
		if(fixedVal >= varVal) co.doubleduck.BaseGame._scale = regScale; else if(idealFixed * regScale < fixedVal) co.doubleduck.BaseGame._scale = fixedVal / idealFixed; else co.doubleduck.BaseGame._scale = regScale;
	}
	,handleViewportChanged: function() {
		if(co.doubleduck.BaseGame._wantLandscape != viewporter.isLandscape()) {
			if(this._orientError == null) {
				var err = co.doubleduck.BaseGame.ORIENT_PORT_URI;
				if(co.doubleduck.BaseGame._wantLandscape) err = co.doubleduck.BaseGame.ORIENT_LAND_URI;
				this._orientError = co.doubleduck.BaseAssets.getImage(err);
				this._orientError.regX = this._orientError.image.width / 2;
				this._orientError.regY = this._orientError.image.height / 2;
				this._orientError.x = co.doubleduck.BaseGame._viewport.height / 2;
				this._orientError.y = co.doubleduck.BaseGame._viewport.width / 2;
				co.doubleduck.BaseGame._stage.addChildAt(this._orientError,co.doubleduck.BaseGame._stage.getNumChildren());
				co.doubleduck.BaseGame._stage.update();
			}
		} else if(this._orientError != null) {
			co.doubleduck.BaseGame._stage.removeChild(this._orientError);
			this._orientError = null;
			if(createjs.Ticker.getPaused()) co.doubleduck.BaseGame._stage.update();
			if(this._waitingToStart) {
				this._waitingToStart = false;
				co.doubleduck.BaseAssets.loadAndCall(co.doubleduck.BaseGame.LOGO_URI,$bind(this,this.loadBarFill));
			}
		}
	}
	,focused: function() {
		co.doubleduck.SoundManager.unmute();
	}
	,blured: function(e) {
		co.doubleduck.SoundManager.mute();
	}
	,handleResize: function(e) {
		var isFirefox = /Firefox/.test(navigator.userAgent);
		var isAndroid = /Android/.test(navigator.userAgent);
		var screenW = js.Lib.window.innerWidth;
		var screenH = js.Lib.window.innerHeight;
		co.doubleduck.BaseGame._stage.canvas.width = screenW;
		co.doubleduck.BaseGame._stage.canvas.height = screenH;
		var shouldResize = co.doubleduck.BaseGame._wantLandscape == viewporter.isLandscape() || !viewporter.ACTIVE;
		if(shouldResize) {
			if(isFirefox) {
				screenH = Math.floor(co.doubleduck.Main.getFFHeight());
				var ffEstimate = Math.ceil((js.Lib.window.screen.height - 110) * (screenW / js.Lib.window.screen.width));
				if(!isAndroid) ffEstimate = Math.ceil(js.Lib.window.screen.height * (screenW / js.Lib.window.screen.width));
				if(ffEstimate < screenH) screenH = Math.floor(ffEstimate);
			}
			var wrongSize = screenH < screenW;
			if(co.doubleduck.BaseGame._wantLandscape) wrongSize = screenH > screenW;
			if(!viewporter.ACTIVE || !wrongSize) {
				co.doubleduck.BaseGame._viewport.width = screenW;
				co.doubleduck.BaseGame._viewport.height = screenH;
				this.setScale();
			}
			if(this._orientError != null && isFirefox) this.handleViewportChanged();
		} else if(isFirefox) this.handleViewportChanged();
		if(createjs.Ticker.getPaused()) co.doubleduck.BaseGame._stage.update();
	}
	,handleBackToMenu: function() {
		this._session.destroy();
		co.doubleduck.BaseGame._stage.removeChild(this._session);
		this._session = null;
		this._menu = new co.doubleduck.Menu();
		co.doubleduck.BaseGame._stage.addChildAt(this._menu,0);
		this._menu.onPlayClick = $bind(this,this.handlePlayClick);
	}
	,handleRestart: function(properties) {
		this._session.destroy();
		co.doubleduck.BaseGame._stage.removeChild(this._session);
		this._session = null;
		this.startSession(properties);
	}
	,handleSessionEnd: function() {
	}
	,handlePlayClick: function(properties) {
		co.doubleduck.BaseGame._stage.removeChild(this._menu);
		this.startSession(properties);
		this._menu.destroy();
		this._menu = null;
	}
	,startSession: function(properties) {
		this._session = new co.doubleduck.Session(properties);
		this._session.onBackToMenu = $bind(this,this.handleBackToMenu);
		this._session.onRestart = $bind(this,this.handleRestart);
		this._session.onSessionEnd = $bind(this,this.handleSessionEnd);
		co.doubleduck.BaseGame._stage.addChild(this._session);
	}
	,showMenu: function() {
		this._menu = new co.doubleduck.Menu();
		co.doubleduck.BaseGame._stage.addChildAt(this._menu,0);
		this._menu.onPlayClick = $bind(this,this.handlePlayClick);
	}
	,alphaFade: function(fadeElement) {
		if(fadeElement != null && js.Boot.__instanceof(fadeElement,createjs.Bitmap)) this._fadedText = fadeElement; else if(this._fadedText == null) return;
		if(this._fadedText.alpha == 0) createjs.Tween.get(this._fadedText).to({ alpha : 1},750).call($bind(this,this.alphaFade)); else if(this._fadedText.alpha == 1) createjs.Tween.get(this._fadedText).to({ alpha : 0},1500).call($bind(this,this.alphaFade));
	}
	,showGameSplash: function() {
	}
	,splashEnded: function() {
		js.Lib.document.body.bgColor = "#000000";
		co.doubleduck.BaseGame._stage.removeChild(this._splash);
		this._splash = null;
		js.Lib.window.onresize = $bind(this,this.handleResize);
		this.handleResize(null);
		this.showGameSplash();
	}
	,handleDoneLoading: function() {
		createjs.Tween.get(this._splash).wait(200).to({ alpha : 0},800).call($bind(this,this.splashEnded));
		co.doubleduck.BaseGame._stage.removeChild(this._loadingBar);
		co.doubleduck.BaseGame._stage.removeChild(this._loadingStroke);
	}
	,updateLoading: function() {
		if(co.doubleduck.BaseAssets.loaded != 1) {
			this._loadingBar.visible = true;
			var percent = co.doubleduck.BaseAssets.loaded;
			var barMask = new createjs.Shape();
			barMask.graphics.beginFill("#00000000");
			barMask.graphics.drawRect(this._loadingBar.x - this._loadingBar.image.width / 2,this._loadingBar.y,this._loadingBar.image.width * percent | 0,this._loadingBar.image.height);
			barMask.graphics.endFill();
			this._loadingBar.mask = barMask;
			co.doubleduck.Utils.waitAndCall(this,10,$bind(this,this.updateLoading));
		}
	}
	,exitFocus: function() {
		var hidden = document.mozHidden;
		if(hidden) co.doubleduck.SoundManager.mute(false); else if(!co.doubleduck.SoundManager.getPersistedMute()) co.doubleduck.SoundManager.unmute(false);
	}
	,showSplash: function() {
		if(viewporter.ACTIVE) js.Lib.document.body.bgColor = "#00A99D"; else js.Lib.document.body.bgColor = "#D94D00";
		this._splash = co.doubleduck.BaseAssets.getImage(co.doubleduck.BaseGame.LOGO_URI);
		this._splash.regX = this._splash.image.width / 2;
		this._splash.x = js.Lib.window.innerWidth / 2;
		if(co.doubleduck.BaseGame._wantLandscape) this._splash.y = 20; else this._splash.y = 90;
		co.doubleduck.BaseGame._stage.addChild(this._splash);
		this._loadingStroke = co.doubleduck.BaseAssets.getImage(co.doubleduck.BaseGame.LOAD_STROKE_URI);
		this._loadingStroke.regX = this._loadingStroke.image.width / 2;
		co.doubleduck.BaseGame._stage.addChildAt(this._loadingStroke,0);
		this._loadingBar = co.doubleduck.BaseAssets.getImage(co.doubleduck.BaseGame.LOAD_FILL_URI);
		this._loadingBar.regX = this._loadingBar.image.width / 2;
		co.doubleduck.BaseGame._stage.addChildAt(this._loadingBar,1);
		this._loadingBar.x = js.Lib.window.innerWidth / 2;
		this._loadingBar.y = this._splash.y + 192;
		this._loadingStroke.x = this._loadingBar.x;
		this._loadingStroke.y = this._loadingBar.y;
		this._loadingBar.visible = false;
		this.updateLoading();
		co.doubleduck.BaseGame._stage.canvas.width = js.Lib.window.innerWidth;
		co.doubleduck.BaseGame._stage.canvas.height = js.Lib.window.innerHeight;
		co.doubleduck.BaseAssets.onLoadAll = $bind(this,this.handleDoneLoading);
		co.doubleduck.Assets.loadAll();
	}
	,loadLocale: function() {
		if(co.doubleduck.BaseGame.isLocalized) {
			var lang = navigator.language;
			lang = HxOverrides.substr(lang.toLowerCase(),0,2);
			if(co.doubleduck.BaseGame.availableLocales != null && co.doubleduck.BaseGame.availableLocales.length > 0) {
				if(Lambda.indexOf(co.doubleduck.BaseGame.availableLocales,lang) != -1) {
					co.doubleduck.BaseGame.activeLocale = lang;
					this.showSplash();
					return;
				} else {
					co.doubleduck.BaseGame.activeLocale = co.doubleduck.BaseGame.defaultLocale;
					this.showSplash();
					return;
				}
			} else {
				co.doubleduck.BaseGame.activeLocale = co.doubleduck.BaseGame.defaultLocale;
				if(co.doubleduck.BaseGame.defaultLocale == null) throw "DDException: default locale not set";
			}
		}
		this.showSplash();
	}
	,waitForOrientation: function() {
		this._waitingToStart = true;
		if(this._orientError == null) {
			this._orientError = this.getErrorImage();
			this._orientError.regX = this._orientError.image.width / 2;
			this._orientError.regY = this._orientError.image.height / 2;
			this._orientError.x = js.Lib.window.innerWidth / 2;
			this._orientError.y = js.Lib.window.innerHeight / 2;
			co.doubleduck.BaseGame._stage.addChildAt(this._orientError,co.doubleduck.BaseGame._stage.getNumChildren());
		}
	}
	,getErrorImage: function() {
		if(co.doubleduck.BaseGame._wantLandscape) return co.doubleduck.BaseAssets.getImage(co.doubleduck.BaseGame.ORIENT_LAND_URI); else return co.doubleduck.BaseAssets.getImage(co.doubleduck.BaseGame.ORIENT_PORT_URI);
	}
	,loadBarStroke: function() {
		co.doubleduck.BaseAssets.loadAndCall(co.doubleduck.BaseGame.LOAD_STROKE_URI,$bind(this,this.loadLocale));
	}
	,loadBarFill: function() {
		co.doubleduck.BaseAssets.loadAndCall(co.doubleduck.BaseGame.LOAD_FILL_URI,$bind(this,this.loadBarStroke));
	}
	,handleStageTick: function() {
		if(js.Lib.window.innerWidth != this._prevWinSize.width || js.Lib.window.innerHeight != this._prevWinSize.height) {
			this._prevWinSize.width = js.Lib.window.innerWidth;
			this._prevWinSize.height = js.Lib.window.innerHeight;
			this.handleResize(null);
		}
	}
	,_prevWinSize: null
	,_fadedText: null
	,_loadingStroke: null
	,_loadingBar: null
	,_waitingToStart: null
	,_orientError: null
	,_session: null
	,_menu: null
	,_splash: null
	,__class__: co.doubleduck.BaseGame
}
co.doubleduck.BaseMenu = $hxClasses["co.doubleduck.BaseMenu"] = function() {
	createjs.Container.call(this);
};
co.doubleduck.BaseMenu.__name__ = ["co","doubleduck","BaseMenu"];
co.doubleduck.BaseMenu.__super__ = createjs.Container;
co.doubleduck.BaseMenu.prototype = $extend(createjs.Container.prototype,{
	destroy: function() {
		this.onPlayClick = null;
	}
	,onPlayClick: null
	,__class__: co.doubleduck.BaseMenu
});
co.doubleduck.BasePersistence = $hxClasses["co.doubleduck.BasePersistence"] = function() { }
co.doubleduck.BasePersistence.__name__ = ["co","doubleduck","BasePersistence"];
co.doubleduck.BasePersistence.localStorageSupported = function() {
	var result = null;
	try {
		localStorage.setItem("test","test");
		localStorage.removeItem("test");
		result = true;
	} catch( e ) {
		result = false;
	}
	return result;
}
co.doubleduck.BasePersistence.getValue = function(key) {
	if(!co.doubleduck.BasePersistence.available) return "0";
	var val = localStorage[co.doubleduck.BasePersistence.GAME_PREFIX + key];
	return val;
}
co.doubleduck.BasePersistence.setValue = function(key,value) {
	if(!co.doubleduck.BasePersistence.available) return;
	localStorage[co.doubleduck.BasePersistence.GAME_PREFIX + key] = value;
}
co.doubleduck.BasePersistence.clearAll = function() {
	if(!co.doubleduck.BasePersistence.available) return;
	localStorage.clear();
}
co.doubleduck.BasePersistence.initVar = function(initedVar,defaultVal) {
	if(defaultVal == null) defaultVal = "0";
	var value = co.doubleduck.BasePersistence.getValue(initedVar);
	if(value == null) try {
		co.doubleduck.BasePersistence.setValue(initedVar,defaultVal);
	} catch( e ) {
		co.doubleduck.BasePersistence.available = false;
	}
}
co.doubleduck.BasePersistence.getDynamicValue = function(key) {
	if(!co.doubleduck.BasePersistence.available) return { };
	var val = localStorage[co.doubleduck.BasePersistence.GAME_PREFIX + key];
	return val;
}
co.doubleduck.BasePersistence.setDynamicValue = function(key,value) {
	if(!co.doubleduck.BasePersistence.available) return;
	localStorage[co.doubleduck.BasePersistence.GAME_PREFIX + key] = value;
}
co.doubleduck.BasePersistence.initDynamicVar = function(initedVar,defaultVal) {
	var value = co.doubleduck.BasePersistence.getDynamicValue(initedVar);
	if(value == null) try {
		co.doubleduck.BasePersistence.setDynamicValue(initedVar,defaultVal);
	} catch( e ) {
		co.doubleduck.BasePersistence.available = false;
	}
}
co.doubleduck.BasePersistence.printAll = function() {
	var ls = localStorage;
	var localStorageLength = ls.length;
	var _g = 0;
	while(_g < localStorageLength) {
		var entry = _g++;
		null;
	}
}
co.doubleduck.BaseSession = $hxClasses["co.doubleduck.BaseSession"] = function() {
	createjs.Container.call(this);
};
co.doubleduck.BaseSession.__name__ = ["co","doubleduck","BaseSession"];
co.doubleduck.BaseSession.__super__ = createjs.Container;
co.doubleduck.BaseSession.prototype = $extend(createjs.Container.prototype,{
	destroy: function() {
		createjs.Ticker.removeListener(this);
		this.onRestart = null;
		this.onBackToMenu = null;
		this.onSessionEnd = null;
		this.onNextLevel = null;
	}
	,sessionEnded: function() {
		if(this.onSessionEnd != null) {
			createjs.Ticker.setPaused(false);
			this.onSessionEnd();
		}
	}
	,handleReplayClick: function(properties) {
		if(this.onRestart != null) {
			createjs.Ticker.setPaused(false);
			this.onRestart(properties);
		}
	}
	,handleMenuClick: function() {
		if(this.onBackToMenu != null) {
			createjs.Ticker.setPaused(false);
			this.onBackToMenu();
		}
	}
	,_replayBtn: null
	,_menuBtn: null
	,onNextLevel: null
	,onBackToMenu: null
	,onSessionEnd: null
	,onRestart: null
	,__class__: co.doubleduck.BaseSession
});
co.doubleduck.LabeledContainer = $hxClasses["co.doubleduck.LabeledContainer"] = function(bmp) {
	createjs.Container.call(this);
	this._bitmap = bmp;
	if(this._bitmap != null) {
		if(js.Boot.__instanceof(this._bitmap,createjs.Bitmap)) {
			this._bmp = this._bitmap;
			this.image = this._bmp.image;
		} else if(js.Boot.__instanceof(this._bitmap,createjs.BitmapAnimation)) {
			this.anim = this._bitmap;
			this.image = { width : this.anim.spriteSheet._frameWidth, height : this.anim.spriteSheet._frameHeight};
		}
	}
};
co.doubleduck.LabeledContainer.__name__ = ["co","doubleduck","LabeledContainer"];
co.doubleduck.LabeledContainer.__super__ = createjs.Container;
co.doubleduck.LabeledContainer.prototype = $extend(createjs.Container.prototype,{
	getLabel: function() {
		return this._label;
	}
	,addBitmap: function() {
		this.addChild(this._bitmap);
	}
	,addCenteredBitmap: function() {
		this._bitmap.regX = this.image.width / 2;
		this._bitmap.regY = this.image.height / 2;
		this._bitmap.x = this.image.width / 2;
		this._bitmap.y = this.image.height / 2;
		this.addChild(this._bitmap);
	}
	,addBitmapLabel: function(label,fontType,padding,centered) {
		if(centered == null) centered = true;
		if(padding == null) padding = 0;
		if(fontType == null) fontType = "";
		if(this._bitmapText != null) this.removeChild(this._bitmapText);
		var fontHelper = new co.doubleduck.FontHelper(fontType);
		this._bitmapText = fontHelper.getNumber(Std.parseInt(label),1,true,null,padding,centered);
		if(this.image != null) {
			this._bitmapText.x = this.image.width / 2;
			this._bitmapText.y = this.image.height / 2;
		}
		this._label = label;
		this.addChild(this._bitmapText);
	}
	,scaleBitmapFont: function(scale) {
		this._bitmapText.scaleX = this._bitmapText.scaleY = scale;
	}
	,shiftLabel: function(shiftX,shiftY) {
		this._bitmapText.x *= shiftX;
		this._bitmapText.y *= shiftY;
	}
	,setBitmapLabelY: function(ly) {
		this._bitmapText.y = ly;
	}
	,setBitmapLabelX: function(lx) {
		this._bitmapText.x = lx;
	}
	,getBitmapLabelWidth: function() {
		var maxWidth = 0;
		var _g1 = 0, _g = this._bitmapText.getNumChildren();
		while(_g1 < _g) {
			var digit = _g1++;
			var currentDigit = js.Boot.__cast(this._bitmapText.getChildAt(digit) , createjs.Bitmap);
			var endsAt = currentDigit.x + currentDigit.image.width;
			if(endsAt > maxWidth) maxWidth = endsAt;
		}
		return maxWidth;
	}
	,setLabelY: function(ly) {
		this._text.y = ly;
	}
	,setLabelX: function(lx) {
		this._text.x = lx;
	}
	,addLabel: function(label,color) {
		if(color == null) color = "#000000";
		if(this._text != null) this.removeChild(this._text);
		this._label = label;
		this._text = new createjs.Text(label,"bold 22px Arial",color);
		this._text.regY = this._text.getMeasuredHeight() / 2;
		this._text.textAlign = "center";
		if(this._bitmap != null) {
			this._text.x = this._bitmap.x;
			this._text.y = this._bitmap.y;
		}
		this.addChild(this._text);
	}
	,changeText: function(txt) {
	}
	,_bitmapText: null
	,_text: null
	,_bmp: null
	,_bitmap: null
	,_label: null
	,anim: null
	,image: null
	,__class__: co.doubleduck.LabeledContainer
});
co.doubleduck.Button = $hxClasses["co.doubleduck.Button"] = function(bmp,pauseAffected,clickType,clickSound) {
	if(clickType == null) clickType = 2;
	if(pauseAffected == null) pauseAffected = true;
	this._lastClickTime = 0;
	co.doubleduck.LabeledContainer.call(this,bmp);
	if(clickSound == null && co.doubleduck.Button._defaultSound != null) this._clickSound = co.doubleduck.Button._defaultSound; else this._clickSound = clickSound;
	this._bitmap.mouseEnabled = true;
	this._clickType = clickType;
	this._pauseAffected = pauseAffected;
	if(clickType == co.doubleduck.Button.CLICK_TYPE_TOGGLE) {
		var initObject = { };
		var size = this.image.width / 2;
		initObject.images = [this.image];
		initObject.frames = { width : size, height : this.image.height, regX : size / 2, regY : this.image.height / 2};
		this._states = new createjs.BitmapAnimation(new createjs.SpriteSheet(initObject));
		this._states.gotoAndStop(0);
		this.onClick = $bind(this,this.handleToggle);
		this.addChild(this._states);
	} else this.addCenteredBitmap();
	this.onPress = $bind(this,this.handlePress);
};
co.doubleduck.Button.__name__ = ["co","doubleduck","Button"];
co.doubleduck.Button.setDefaultSound = function(sound) {
	co.doubleduck.Button._defaultSound = sound;
}
co.doubleduck.Button.__super__ = co.doubleduck.LabeledContainer;
co.doubleduck.Button.prototype = $extend(co.doubleduck.LabeledContainer.prototype,{
	handleEndPressTint: function() {
		co.doubleduck.Utils.tintBitmap(this._bmp,1,1,1,1);
		if(createjs.Ticker.getPaused()) co.doubleduck.BaseGame.getStage().update();
	}
	,setToggle: function(flag) {
		if(flag) this._states.gotoAndStop(0); else this._states.gotoAndStop(1);
	}
	,handleToggle: function(e) {
		if(this.onToggle == null) return;
		if(this._lastClickPos == null) this._lastClickPos = new createjs.Point(0,0);
		if((this._lastClickPos.x < e.stageX + 1 || this._lastClickPos.x > e.stageX + 1) && (this._lastClickPos.y < e.stageY + 1 || this._lastClickPos.y > e.stageY + 1)) {
			var now = createjs.Ticker.getTime(true);
			if(now < this._lastClickTime + 500) return;
		}
		this._lastClickPos.x = e.stageX;
		this._lastClickPos.y = e.stageY;
		this._lastClickTime = createjs.Ticker.getTime(true);
		this._states.gotoAndStop(1 - this._states.currentFrame);
		this.onToggle();
	}
	,handlePress: function(event) {
		if(createjs.Ticker.getPaused() && this._pauseAffected) return;
		if(this._clickType == co.doubleduck.Button.CLICK_TYPE_HOLD) {
			if(this.onHoldStart != null) {
				this.onHoldStart();
				event.onMouseUp = this.onHoldFinish;
			}
		}
		if(this.onClick != null) {
			if(this._clickSound != null) co.doubleduck.SoundManager.playEffect(this._clickSound);
			switch(this._clickType) {
			case co.doubleduck.Button.CLICK_TYPE_TINT:
				if(this._bmp != null) {
					co.doubleduck.Utils.tintBitmap(this._bmp,0.55,0.55,0.55,1);
					var tween = createjs.Tween.get(this._bmp);
					tween.ignoreGlobalPause = true;
					tween.wait(200).call($bind(this,this.handleEndPressTint));
					if(createjs.Ticker.getPaused()) co.doubleduck.BaseGame.getStage().update();
				}
				break;
			case co.doubleduck.Button.CLICK_TYPE_JUICY:
				this._juiceTween = createjs.Tween.get(this._bitmap);
				this._juiceTween.ignoreGlobalPause = true;
				var startScaleX = this._bitmap.scaleX;
				var startScaleY = this._bitmap.scaleY;
				this._bitmap.scaleX = startScaleX * 1.25;
				this._bitmap.scaleY = startScaleY * 0.75;
				this._juiceTween.to({ scaleX : startScaleX, scaleY : startScaleY},500,createjs.Ease.elasticOut);
				break;
			case co.doubleduck.Button.CLICK_TYPE_SCALE:
				this._juiceTween = createjs.Tween.get(this._bitmap);
				this._juiceTween.ignoreGlobalPause = true;
				var startScaleX = this._bitmap.scaleX;
				var startScaleY = this._bitmap.scaleY;
				this._bitmap.scaleX = startScaleX * 1.18;
				this._bitmap.scaleY = startScaleY * 1.18;
				this._juiceTween.to({ scaleX : startScaleX, scaleY : startScaleY},200,createjs.Ease.elasticOut);
				break;
			case co.doubleduck.Button.CLICK_TYPE_TOGGLE:
				break;
			case co.doubleduck.Button.CLICK_TYPE_NONE:
				break;
			case co.doubleduck.Button.CLICK_TYPE_HOLD:
				throw "Use onHoldStart with CLICK_TYPE_HOLD, not onClick";
				break;
			}
		}
	}
	,setNoSound: function() {
		this._clickSound = null;
	}
	,_lastClickPos: null
	,_lastClickTime: null
	,_clickSound: null
	,_juiceTween: null
	,_clickType: null
	,_pauseAffected: null
	,_states: null
	,onHoldFinish: null
	,onHoldStart: null
	,onToggle: null
	,__class__: co.doubleduck.Button
});
co.doubleduck.FontHelper = $hxClasses["co.doubleduck.FontHelper"] = function(type) {
	this._fontType = type;
};
co.doubleduck.FontHelper.__name__ = ["co","doubleduck","FontHelper"];
co.doubleduck.FontHelper.prototype = {
	getNumber: function(num,scale,forceContainer,dims,padding,centered) {
		if(centered == null) centered = true;
		if(padding == null) padding = 0;
		if(forceContainer == null) forceContainer = false;
		if(scale == null) scale = 1;
		if(num >= 0 && num < 10) {
			var result = new createjs.Container();
			var bmp = this.getDigit(num);
			bmp.scaleX = bmp.scaleY = scale;
			result.addChild(bmp);
			if(centered) {
				result.regX = bmp.image.width / 2;
				result.regY = bmp.image.height / 2;
			}
			if(forceContainer) {
				if(dims != null) {
					dims.width = bmp.image.width;
					dims.height = bmp.image.height;
				}
				return result;
			} else return bmp;
		} else {
			var result = new createjs.Container();
			var numString = "" + num;
			var digits = new Array();
			var totalWidth = 0;
			digits[digits.length] = this.getDigit(Std.parseInt(HxOverrides.substr(numString,0,1)));
			digits[0].scaleX = digits[0].scaleY = scale;
			result.addChild(digits[0]);
			totalWidth += digits[0].image.width * scale;
			if(numString.length == 4 || numString.length == 7) {
				this._lastComma = this.getComma();
				this._lastComma.scaleX = this._lastComma.scaleY = scale;
				this._lastComma.x = digits[0].x + digits[0].image.width + padding;
				result.addChild(this._lastComma);
				totalWidth += this._lastComma.image.width * scale;
			}
			var _g1 = 1, _g = numString.length;
			while(_g1 < _g) {
				var i = _g1++;
				var index = digits.length;
				digits[index] = this.getDigit(Std.parseInt(HxOverrides.substr(numString,i,1)));
				if(numString.length - i == 3 || numString.length - i == 6) digits[index].x = this._lastComma.x + this._lastComma.image.width + padding; else digits[index].x = digits[index - 1].x + digits[index - 1].image.width + padding;
				digits[index].scaleX = digits[index].scaleY = scale;
				result.addChild(digits[index]);
				totalWidth += digits[index].image.width * scale + padding;
				if(numString.length - i == 4 || numString.length - i == 7) {
					this._lastComma = this.getComma();
					this._lastComma.scaleX = this._lastComma.scaleY = scale;
					this._lastComma.x = digits[index].x + digits[index].image.width + padding;
					result.addChild(this._lastComma);
					totalWidth += this._lastComma.image.width * scale + padding;
				}
			}
			if(centered) {
				result.regX = totalWidth / 2;
				result.regY = digits[0].image.height / 2;
			}
			if(dims != null) {
				dims.width = totalWidth;
				dims.height = digits[0].image.height;
			}
			return result;
		}
	}
	,getDigit: function(digit) {
		var digit1 = co.doubleduck.BaseAssets.getImage(this._fontType + digit + ".png");
		return digit1;
	}
	,getComma: function() {
		return co.doubleduck.BaseAssets.getImage(this._fontType + "comma.png");
	}
	,_fontType: null
	,_lastComma: null
	,__class__: co.doubleduck.FontHelper
}
co.doubleduck.Game = $hxClasses["co.doubleduck.Game"] = function(stage) {
	co.doubleduck.BaseGame._wantLandscape = false;
	co.doubleduck.BaseGame.isLocalized = true;
	co.doubleduck.BaseGame.defaultLocale = "en";
	co.doubleduck.BaseGame.availableLocales = ["en","es"];
	co.doubleduck.BaseGame.call(this,stage);
};
co.doubleduck.Game.__name__ = ["co","doubleduck","Game"];
co.doubleduck.Game.__super__ = co.doubleduck.BaseGame;
co.doubleduck.Game.prototype = $extend(co.doubleduck.BaseGame.prototype,{
	handleDoneSplash: function() {
		co.doubleduck.BaseGame.getStage().removeChild(this._gameSplash);
		this._gameSplash.onDone = null;
		this._gameSplash = null;
		this.showMenu();
	}
	,showGameSplash: function() {
		co.doubleduck.BaseGame.getStage().scaleX = co.doubleduck.BaseGame.getStage().scaleY = co.doubleduck.BaseGame.getScale();
		this._gameSplash = new co.doubleduck.GameSplash();
		this._gameSplash.onDone = $bind(this,this.handleDoneSplash);
		co.doubleduck.BaseGame.getStage().addChild(this._gameSplash);
	}
	,_gameSplash: null
	,__class__: co.doubleduck.Game
});
co.doubleduck.GameSplash = $hxClasses["co.doubleduck.GameSplash"] = function() {
	createjs.Container.call(this);
	this._back = co.doubleduck.Utils.getCenteredImage("images/splash/bg.png",false);
	this._back.x = co.doubleduck.BaseGame.getScreenSize().width * 0.5;
	this._back.y = co.doubleduck.BaseGame.getScreenSize().height * 0.5;
	this._back.alpha = 0;
	this.addChild(this._back);
	createjs.Tween.get(this._back).to({ alpha : 1},300).call($bind(this,this.popLogo));
};
co.doubleduck.GameSplash.__name__ = ["co","doubleduck","GameSplash"];
co.doubleduck.GameSplash.__super__ = createjs.Container;
co.doubleduck.GameSplash.prototype = $extend(createjs.Container.prototype,{
	loadCookie: function(id) {
		if(this._cookie != null) {
			this.removeChild(this._cookie);
			this._cookie = null;
		}
		this._cookie = co.doubleduck.Utils.getCenteredImage("images/splash/cookie" + id + ".png",false);
		this._cookie.x = co.doubleduck.BaseGame.getScreenSize().width * 0.5;
		this._cookie.y = co.doubleduck.BaseGame.getScreenSize().height * 0.35;
		this.addChild(this._cookie);
		createjs.Tween.get(this._cookie).to({ x : this._cookie.x - 5},40,createjs.Ease.sineOut).to({ x : this._cookie.x},50,createjs.Ease.sineInOut);
	}
	,loadLogo: function(id) {
		var anim = false;
		if(this._logo != null) {
			this.removeChild(this._logo);
			this._logo = null;
			anim = true;
		}
		this._logo = co.doubleduck.Utils.getCenteredImage("images/splash/logo" + id + ".png",false);
		this._logo.x = co.doubleduck.BaseGame.getScreenSize().width * 0.5;
		this._logo.y = co.doubleduck.BaseGame.getScreenSize().height * 0.35;
		this.addChild(this._logo);
		if(anim) createjs.Tween.get(this._logo).to({ x : this._logo.x - 5},40,createjs.Ease.sineOut).to({ x : this._logo.x},50,createjs.Ease.sineInOut);
	}
	,doneSplash: function() {
		if(this.onDone != null) this.onDone();
	}
	,fadeScreen: function() {
		createjs.Tween.get(this).to({ alpha : 0},300).call($bind(this,this.doneSplash));
	}
	,biteCookie: function(id) {
		this.loadCookie(id);
		if(id < 4) createjs.Tween.get(this).wait(250).call($bind(this,this.biteCookie),[id + 1]); else createjs.Tween.get(this._cookie).to({ alpha : 0},300).call($bind(this,this.fadeScreen));
	}
	,chompCookie: function() {
		this.loadCookie(1);
		this.loadLogo(2);
		createjs.Tween.get(this._logo).wait(400).to({ alpha : 0},700).wait(300).call($bind(this,this.biteCookie),[2]);
	}
	,popLogo: function() {
		this.loadLogo(1);
		this._logo.y *= -1;
		createjs.Tween.get(this._logo).to({ y : -this._logo.y},800,createjs.Ease.elasticOut).wait(300).call($bind(this,this.chompCookie));
	}
	,_tap2play: null
	,_cookie: null
	,_logo: null
	,_back: null
	,onDone: null
	,__class__: co.doubleduck.GameSplash
});
co.doubleduck.GridItem = $hxClasses["co.doubleduck.GridItem"] = function() {
	createjs.Container.call(this);
};
co.doubleduck.GridItem.__name__ = ["co","doubleduck","GridItem"];
co.doubleduck.GridItem.calcX = function(pos) {
	return (pos + 0.5) * (co.doubleduck.GridItem.GRID_SIZE / co.doubleduck.GridItem.GRID_COLS);
}
co.doubleduck.GridItem.calcXrev = function(pos) {
	return pos * (co.doubleduck.GridItem.GRID_COLS / co.doubleduck.GridItem.GRID_SIZE) - 0.5;
}
co.doubleduck.GridItem.calcY = function(pos) {
	return (pos + 0.5) * (co.doubleduck.GridItem.GRID_SIZE / co.doubleduck.GridItem.GRID_ROWS);
}
co.doubleduck.GridItem.calcYrev = function(pos) {
	return pos * (co.doubleduck.GridItem.GRID_ROWS / co.doubleduck.GridItem.GRID_SIZE) - 0.5;
}
co.doubleduck.GridItem.__super__ = createjs.Container;
co.doubleduck.GridItem.prototype = $extend(createjs.Container.prototype,{
	gridDistTo: function(other) {
		var deltaX = Math.abs(other.getPosX() - this.getPosX());
		var deltaY = Math.abs(other.getPosY() - this.getPosY());
		return Math.sqrt(deltaX * deltaX + deltaY * deltaY);
	}
	,getIsMoving: function() {
		return this._isMoving;
	}
	,setPos: function(val) {
		this.setPosX(val.x);
		this.setPosY(val.y);
		return this.getPos();
	}
	,getPos: function() {
		return new createjs.Point(this.getPosX(),this.getPosY());
	}
	,setPosY: function(val) {
		this._posY = val;
		this.y = co.doubleduck.GridItem.calcY(this._posY);
		return this.getPosY();
	}
	,getPosY: function() {
		this._posY = co.doubleduck.GridItem.calcYrev(this.y);
		return this._posY;
	}
	,setPosX: function(val) {
		this._posX = val;
		this.x = co.doubleduck.GridItem.calcX(this._posX);
		return this.getPosX();
	}
	,getPosX: function() {
		this._posX = co.doubleduck.GridItem.calcXrev(this.x);
		return this._posX;
	}
	,swipeTo: function(delta,isVertical,isFast) {
		if(isFast == null) isFast = false;
		var duration = Math.abs(delta) * co.doubleduck.GridItem.SLIDE_SPEED;
		if(isFast) duration *= 0.6;
		var tween;
		if(isVertical) tween = createjs.Tween.get(this).to({ y : co.doubleduck.GridItem.calcY(this.getPosY() + delta)},duration,createjs.Ease.sineIn).call($bind(this,this.setPosY),[this.getPosY() + delta]); else tween = createjs.Tween.get(this).to({ x : co.doubleduck.GridItem.calcX(this.getPosX() + delta)},duration,createjs.Ease.sineIn).call($bind(this,this.setPosX),[this.getPosX() + delta]);
		return tween;
	}
	,_isMoving: null
	,_posY: null
	,_posX: null
	,isMoving: null
	,posY: null
	,posX: null
	,pos: null
	,__class__: co.doubleduck.GridItem
	,__properties__: {set_pos:"setPos",get_pos:"getPos",set_posX:"setPosX",get_posX:"getPosX",set_posY:"setPosY",get_posY:"getPosY",get_isMoving:"getIsMoving"}
});
co.doubleduck.GoalItem = $hxClasses["co.doubleduck.GoalItem"] = function(worldId) {
	co.doubleduck.GridItem.call(this);
	this._isMoving = false;
	this._body = co.doubleduck.BaseAssets.getImage("images/session/world" + worldId + "/goal.png");
	this._body.regX = this._body.image.width / 2;
	this._body.regY = this._body.image.height / 2;
	this.addChild(this._body);
};
co.doubleduck.GoalItem.__name__ = ["co","doubleduck","GoalItem"];
co.doubleduck.GoalItem.__super__ = co.doubleduck.GridItem;
co.doubleduck.GoalItem.prototype = $extend(co.doubleduck.GridItem.prototype,{
	_body: null
	,__class__: co.doubleduck.GoalItem
});
co.doubleduck.LevelLoader = $hxClasses["co.doubleduck.LevelLoader"] = function() {
	throw "DDError: Can't instantiate a static class 'LevelLoader.hx'! Shame on you!";
};
co.doubleduck.LevelLoader.__name__ = ["co","doubleduck","LevelLoader"];
co.doubleduck.LevelLoader.data = function() {
	if(co.doubleduck.LevelLoader._levelsData == null) {
		var dat = new LevelDB();
		co.doubleduck.LevelLoader._levelsData = dat.getAllLevels();
	}
	return co.doubleduck.LevelLoader._levelsData;
}
co.doubleduck.LevelLoader.helpData = function() {
	if(co.doubleduck.LevelLoader._helpData == null) {
		var dat = new LevelDB();
		co.doubleduck.LevelLoader._helpData = dat.getAllHelpScreens();
	}
	return co.doubleduck.LevelLoader._helpData;
}
co.doubleduck.LevelLoader.getLevelCount = function() {
	return co.doubleduck.LevelLoader.data().length;
}
co.doubleduck.LevelLoader.getLevelWorld = function(level) {
	return co.doubleduck.LevelLoader.data()[level - 1].worldType | 0;
}
co.doubleduck.LevelLoader.loadLevel = function(level,actors,stars) {
	var levelData = co.doubleduck.LevelLoader.data()[level - 1];
	var gridData = levelData.grid;
	var world = levelData.worldType;
	var _g1 = 0, _g = co.doubleduck.GridItem.GRID_ROWS;
	while(_g1 < _g) {
		var i = _g1++;
		var _g3 = 1, _g2 = co.doubleduck.GridItem.GRID_COLS + 2;
		while(_g3 < _g2) {
			var j = _g3++;
			var item = null;
			switch(gridData[i][j]) {
			case 1:
				item = new co.doubleduck.Tommy();
				actors.addChild(item);
				break;
			case 2:
				item = new co.doubleduck.StaticItem(world,Std.random(3) + 1);
				actors.addChild(item);
				break;
			case 3:
				item = new co.doubleduck.GoalItem(world);
				actors.addChild(item);
				break;
			case 4:
				item = new co.doubleduck.StarItem();
				stars.addChild(item);
				break;
			case 5:
				item = new co.doubleduck.PortalItem();
				actors.addChild(item);
				break;
			case 6:
				item = new co.doubleduck.MovingItem(Std.random(3) + 1,true);
				actors.addChild(item);
				break;
			case 7:
				item = new co.doubleduck.MovingItem(Std.random(3) + 1,false);
				actors.addChild(item);
				break;
			}
			if(item != null) {
				item.setPosX(j - 1);
				item.setPosY(i);
			}
		}
	}
}
co.doubleduck.LevelLoader.getHelpForLevel = function(level) {
	var result = null;
	var helpScreens = co.doubleduck.LevelLoader.helpData();
	var _g1 = 0, _g = helpScreens.length;
	while(_g1 < _g) {
		var i = _g1++;
		result = helpScreens[i];
		if(level >= helpScreens[i].fromLevel && level <= helpScreens[i].toLevel) break;
	}
	return result;
}
co.doubleduck.LevelLoader.prototype = {
	__class__: co.doubleduck.LevelLoader
}
co.doubleduck.Main = $hxClasses["co.doubleduck.Main"] = function() { }
co.doubleduck.Main.__name__ = ["co","doubleduck","Main"];
co.doubleduck.Main._stage = null;
co.doubleduck.Main._game = null;
co.doubleduck.Main._ffHeight = null;
co.doubleduck.Main.main = function() {
	co.doubleduck.Main.testFFHeight();
	createjs.Ticker.useRAF = true;
	createjs.Ticker.setFPS(60);
	co.doubleduck.Main._stage = new createjs.Stage(js.Lib.document.getElementById("stageCanvas"));
	co.doubleduck.Main._game = new co.doubleduck.Game(co.doubleduck.Main._stage);
	createjs.Ticker.addListener(co.doubleduck.Main._stage);
	createjs.Touch.enable(co.doubleduck.Main._stage,true,false);
}
co.doubleduck.Main.testFFHeight = function() {
	var isAplicable = /Firefox/.test(navigator.userAgent);
	if(isAplicable && viewporter.ACTIVE) co.doubleduck.Main._ffHeight = js.Lib.window.innerHeight;
}
co.doubleduck.Main.getFFHeight = function() {
	return co.doubleduck.Main._ffHeight;
}
co.doubleduck.Menu = $hxClasses["co.doubleduck.Menu"] = function() {
	this._currLevelScreen = 0;
	this._isMoving = false;
	this._justViewedTutor = false;
	this._isUIAvail = false;
	this._isInHelp = false;
	co.doubleduck.BaseMenu.call(this);
	co.doubleduck.Button.setDefaultSound("sound/button_press");
	this._bg = co.doubleduck.BaseAssets.getImage("images/menu/bg.png");
	this._bg.regX = this._bg.image.width / 2;
	this._bg.x = co.doubleduck.BaseGame.getScreenSize().width / 2;
	this._bg.regY = this._bg.image.height / 2;
	this._bg.y = co.doubleduck.BaseGame.getScreenSize().height / 2;
	this.addChild(this._bg);
	this._levelButtons = new Array();
	this._levelsLayer = new createjs.Container();
	if(co.doubleduck.Menu._iconSpritesheets == null) {
		co.doubleduck.Menu._iconSpritesheets = new Array();
		var _g = 0;
		while(_g < 3) {
			var i = _g++;
			var img = co.doubleduck.BaseAssets.getRawImage("images/menu/icons" + (i + 1) + ".png");
			var initObject = { };
			initObject.images = [img];
			initObject.frames = { width : img.width / 5, height : img.height, regX : 0, regY : 0};
			initObject.animations = { };
			initObject.animations.locked = { frames : 4, frequency : 20};
			var _g1 = 0;
			while(_g1 < 4) {
				var i1 = _g1++;
				initObject.animations["star" + i1] = { frames : i1, frequency : 20};
			}
			co.doubleduck.Menu._iconSpritesheets[i] = new createjs.SpriteSheet(initObject);
		}
	}
	var _g1 = 0, _g = Math.ceil(co.doubleduck.LevelLoader.getLevelCount() / co.doubleduck.Menu.LEVELS_PER_SCREEN);
	while(_g1 < _g) {
		var i = _g1++;
		var _g3 = 0, _g2 = co.doubleduck.Menu.LEVELS_PER_SCREEN;
		while(_g3 < _g2) {
			var j = _g3++;
			var lvlNum = i * co.doubleduck.Menu.LEVELS_PER_SCREEN + j + 1;
			if(lvlNum > co.doubleduck.LevelLoader.getLevelCount()) break;
			var world = co.doubleduck.LevelLoader.getLevelWorld(lvlNum);
			var currLvl = new co.doubleduck.Button(new createjs.BitmapAnimation(co.doubleduck.Menu._iconSpritesheets[world - 1]));
			currLvl.name = "" + lvlNum;
			currLvl.regX = currLvl.image.width / 2;
			currLvl.regY = currLvl.image.height / 2;
			currLvl.x = co.doubleduck.BaseGame.getScreenSize().width * (0.2 + j % (co.doubleduck.Menu.LEVELS_PER_SCREEN / 2) * 0.3);
			currLvl.x += co.doubleduck.BaseGame.getScreenSize().width * i;
			currLvl.y = co.doubleduck.BaseGame.getScreenSize().height * (0.2 + Math.floor(j / (co.doubleduck.Menu.LEVELS_PER_SCREEN / 2)) * 0.25);
			if(lvlNum <= co.doubleduck.Persistence.getLastLevel()) {
				var stars = co.doubleduck.Persistence.getStarRating(lvlNum);
				currLvl.anim.gotoAndStop("star" + stars);
				currLvl.addBitmapLabel("" + lvlNum,"images/menu/menu_font/",1);
				if(stars == 0) currLvl.shiftLabel(1,1.25); else currLvl.shiftLabel(1,0.95);
				currLvl.scaleBitmapFont(1);
				currLvl.onClick = $bind(this,this.handleLevelClick);
			} else {
				currLvl.anim.gotoAndStop("locked");
				currLvl.addBitmapLabel("" + lvlNum,"images/menu/menu_font/",1);
				currLvl.shiftLabel(1,0.97);
				currLvl.scaleBitmapFont(1);
			}
			this._levelButtons[lvlNum - 1] = currLvl;
			this._levelsLayer.addChild(currLvl);
		}
	}
	this.addChild(this._levelsLayer);
	this._menuRightBtn = new co.doubleduck.Button(co.doubleduck.BaseAssets.getImage("images/menu/arrow_right.png"));
	this._menuRightBtn.regX = this._menuRightBtn.image.width;
	this._menuRightBtn.regY = this._menuRightBtn.image.height / 2;
	this._menuRightBtn.x = co.doubleduck.BaseGame.getScreenSize().width;
	this._menuRightBtn.y = co.doubleduck.BaseGame.getScreenSize().height * 0.475;
	this._menuRightBtn.onClick = $bind(this,this.goToNext);
	this.addChild(this._menuRightBtn);
	this._menuLeftBtn = new co.doubleduck.Button(co.doubleduck.BaseAssets.getImage("images/menu/arrow_left.png"));
	this._menuLeftBtn.regX = 0;
	this._menuLeftBtn.regY = this._menuLeftBtn.image.height / 2;
	this._menuLeftBtn.x = 0;
	this._menuLeftBtn.y = this._menuRightBtn.y;
	this._menuLeftBtn.onClick = $bind(this,this.goToPrev);
	this.addChild(this._menuLeftBtn);
	this._helpBtn = new co.doubleduck.Button(co.doubleduck.BaseAssets.getImage("images/menu/help.png"));
	this._helpBtn.regX = 0;
	this._helpBtn.regY = this._helpBtn.image.height;
	this._helpBtn.x = 22;
	this._helpBtn.y = co.doubleduck.BaseGame.getScreenSize().height - 20;
	this._helpBtn.onClick = $bind(this,this.showHelpMenu);
	this.addChild(this._helpBtn);
	if(co.doubleduck.SoundManager.available) {
		this._muteBtn = new co.doubleduck.Button(co.doubleduck.BaseAssets.getImage("images/menu/sound.png"),true,co.doubleduck.Button.CLICK_TYPE_TOGGLE);
		this.addChild(this._muteBtn);
		this._muteBtn.regX = this._muteBtn.image.width / 4;
		this._muteBtn.regY = this._muteBtn.image.height / 2;
		this._muteBtn.x = co.doubleduck.BaseGame.getScreenSize().width - 22;
		this._muteBtn.y = this._helpBtn.y;
		this._muteBtn.setToggle(!co.doubleduck.SoundManager.isMuted());
		this._muteBtn.onToggle = $bind(this,this.handleMuteToggle);
		this.addChild(this._muteBtn);
	}
	var gotoLevel = co.doubleduck.Session.getLastLevelId();
	if(gotoLevel == -1) gotoLevel = co.doubleduck.Persistence.getLastLevel();
	gotoLevel--;
	this.goToWorld(Math.floor(gotoLevel / co.doubleduck.Menu.LEVELS_PER_SCREEN),true);
	this.setArrowBtnVisibility();
	co.doubleduck.BaseGame.hammer.onswipe = $bind(this,this.handleSwipe);
	this._themeMusic = co.doubleduck.SoundManager.playMusic("sound/menu_music");
	this.addChild(co.doubleduck.Transition.getInstance());
	co.doubleduck.Transition.transitionIn();
	if(co.doubleduck.Session.shouldAutoLoadNext()) {
		this._levelsLayer.alpha = 0;
		var e = { target : { name : "" + (co.doubleduck.Session.getLastLevelId() + 1)}};
		this._isUIAvail = true;
		this.handleLevelClick(e);
	} else co.doubleduck.Utils.waitAndCall(this,1000,$bind(this,this.enableBtns));
};
co.doubleduck.Menu.__name__ = ["co","doubleduck","Menu"];
co.doubleduck.Menu.isTutorialNeeded = function(level) {
	var screensData = co.doubleduck.LevelLoader.getHelpForLevel(level);
	return level == (screensData.fromLevel | 0);
}
co.doubleduck.Menu.__super__ = co.doubleduck.BaseMenu;
co.doubleduck.Menu.prototype = $extend(co.doubleduck.BaseMenu.prototype,{
	goToPrev: function() {
		if(!this._isUIAvail) return;
		if(this._currLevelScreen <= 0) return;
		if(this._isInHelp) return;
		this.goToWorld(this._currLevelScreen - 1);
		this.setArrowBtnVisibility();
	}
	,goToNext: function() {
		if(!this._isUIAvail) return;
		if(this._currLevelScreen >= Math.floor((co.doubleduck.LevelLoader.getLevelCount() - 1) / co.doubleduck.Menu.LEVELS_PER_SCREEN)) return;
		if(this._isInHelp) return;
		this.goToWorld(this._currLevelScreen + 1);
		this.setArrowBtnVisibility();
	}
	,handleTick: function(elapsed) {
		var delta = co.doubleduck.Menu.WORLD_MOVE_EASE * elapsed;
		delta = Math.min(delta,0.2);
		delta *= this._targetLevelsPos - this._levelsLayer.x;
		this._levelsLayer.x += delta;
		if(Math.abs(delta) >= 1) this._levelsLayer.mouseEnabled = false; else this._levelsLayer.mouseEnabled = true;
		if(Math.abs(this._targetLevelsPos - this._levelsLayer.x) < 1) {
			this._levelsLayer.x = this._targetLevelsPos;
			this._levelsLayer.mouseEnabled = true;
			this._isMoving = false;
			this.onTick = null;
		}
	}
	,setArrowBtnVisibility: function() {
		this._menuRightBtn.visible = this._currLevelScreen < Math.floor((co.doubleduck.LevelLoader.getLevelCount() - 1) / co.doubleduck.Menu.LEVELS_PER_SCREEN);
		this._menuLeftBtn.visible = this._currLevelScreen > 0;
	}
	,goToWorld: function(id,force) {
		if(force == null) force = false;
		this._targetLevelsPos = id * co.doubleduck.BaseGame.getScreenSize().width * -1;
		this._currLevelScreen = id;
		if(force) this._levelsLayer.x = this._targetLevelsPos; else if(!this._isMoving) {
			this.onTick = $bind(this,this.handleTick);
			this._isMoving = true;
		}
	}
	,handleLevelClick: function(e) {
		if(!this._isUIAvail) return;
		var levelID = Std.parseInt(e.target.name);
		this._chosenLevel = levelID;
		if(this._themeMusic != null) this._themeMusic.stop();
		var screensData = co.doubleduck.LevelLoader.getHelpForLevel(this._chosenLevel);
		if(this._chosenLevel == (screensData.fromLevel | 0)) {
			if(this._justViewedTutor) this._justViewedTutor = false; else {
				this._justViewedTutor = true;
				this._levelAfterTutor = this._chosenLevel;
				this.showHelpMenu();
				return;
			}
		}
		this._levelsLayer.mouseEnabled = false;
		if(co.doubleduck.SoundManager.available) this._muteBtn.onClick = null;
		this._helpBtn.onClick = null;
		if(co.doubleduck.SoundManager.available) createjs.Tween.get(this._muteBtn).to({ alpha : 0},140);
		if(this.onPlayClick != null) {
			var properties = { level : this._chosenLevel};
			co.doubleduck.Transition.transitionOut(this.onPlayClick,[properties]);
		}
	}
	,closeHelp: function() {
		co.doubleduck.BaseGame.hammer.onswipe = $bind(this,this.handleSwipe);
		this._isInHelp = false;
		createjs.Tween.removeTweens(this._helpScreen);
		createjs.Tween.removeTweens(this._helpBtn);
		createjs.Tween.get(this._helpScreen).to({ alpha : 0},1000,createjs.Ease.sineOut);
		this._helpBtn.onClick = $bind(this,this.showHelpMenu);
		this._levelsLayer.mouseEnabled = true;
		if(this._muteBtn != null) this._muteBtn.alpha = 1;
		if(this._justViewedTutor) {
			var e = { target : { name : "" + this._levelAfterTutor}};
			this.handleLevelClick(e);
		} else {
			this.setArrowBtnVisibility();
			this._helpBtn.alpha = 1;
		}
	}
	,showHelpMenu: function() {
		if(this._helpScreen != null) {
			this._helpScreen.visible = false;
			this.removeChild(this._helpScreen);
			this._helpScreen = null;
		}
		var screensData;
		if(this._justViewedTutor) screensData = co.doubleduck.LevelLoader.getHelpForLevel(this._levelAfterTutor); else screensData = co.doubleduck.LevelLoader.getHelpForLevel(co.doubleduck.Persistence.getLastLevel());
		var screens = new Array();
		var _g1 = 0, _g = screensData.availableScreens.length;
		while(_g1 < _g) {
			var i = _g1++;
			screens.push("images/help/help" + screensData.availableScreens[i] + ".png");
		}
		this._helpScreen = new co.doubleduck.PagedHelp("images/help/help_screen.png","images/help/next.png","images/help/got_it.png",screens);
		this._helpScreen.x = co.doubleduck.BaseGame.getScreenSize().width / 2;
		this._helpScreen.y = co.doubleduck.BaseGame.getScreenSize().height * 0.475;
		this._helpScreen.setButtonsPos(0.79,0.98);
		this._helpScreen.setMarkersPos(5);
		this._helpScreen.onGotIt = $bind(this,this.closeHelp);
		if(this._justViewedTutor) this._helpScreen.goToPage((screensData.focusOn | 0) - 1);
		this.addChild(this._helpScreen);
		this._helpScreen.alpha = 0;
		if(this._muteBtn != null) this._muteBtn.alpha = 0;
		this._helpScreen.enableSwipe();
		this._isInHelp = true;
		createjs.Tween.get(this._helpScreen).to({ alpha : 1},1000,createjs.Ease.sineOut);
		createjs.Tween.get(this._helpBtn).to({ alpha : 0},1000,createjs.Ease.sineOut);
		this._helpScreen.visible = true;
		this._helpBtn.onClick = null;
		this._levelsLayer.mouseEnabled = false;
		this._menuRightBtn.visible = this._menuLeftBtn.visible = false;
	}
	,handleMuteToggle: function() {
		co.doubleduck.SoundManager.toggleMute();
	}
	,handleSwipe: function(event) {
		if(event.direction == "left") this.goToNext(); else if(event.direction == "right") this.goToPrev();
	}
	,preLevelTutorial: function(level) {
		var e = { target : { name : "" + level}};
		this.handleLevelClick(e);
		this._helpBtn.visible = false;
	}
	,enableBtns: function() {
		this._isUIAvail = true;
	}
	,_chosenLevel: null
	,_levelsLayer: null
	,_currLevelScreen: null
	,_isMoving: null
	,_targetLevelsPos: null
	,_menuLeftBtn: null
	,_menuRightBtn: null
	,_helpScreen: null
	,_helpBtn: null
	,_muteBtn: null
	,_bg: null
	,_levelAfterTutor: null
	,_justViewedTutor: null
	,_isUIAvail: null
	,_isInHelp: null
	,_themeMusic: null
	,_levelButtons: null
	,__class__: co.doubleduck.Menu
});
co.doubleduck.MovingItem = $hxClasses["co.doubleduck.MovingItem"] = function(id,isVertival) {
	co.doubleduck.GridItem.call(this);
	this._isMoving = true;
	this._isVertical = isVertival;
	if(this._isVertical) this._body = co.doubleduck.BaseAssets.getImage("images/session/moveV" + id + ".png"); else this._body = co.doubleduck.BaseAssets.getImage("images/session/moveH" + id + ".png");
	this._body.regX = this._body.image.width / 2;
	this._body.regY = this._body.image.height / 2;
	this.addChild(this._body);
};
co.doubleduck.MovingItem.__name__ = ["co","doubleduck","MovingItem"];
co.doubleduck.MovingItem.__super__ = co.doubleduck.GridItem;
co.doubleduck.MovingItem.prototype = $extend(co.doubleduck.GridItem.prototype,{
	swipeTo: function(delta,isVertical,isFast) {
		if(isFast == null) isFast = false;
		if(isVertical == this._isVertical) return co.doubleduck.GridItem.prototype.swipeTo.call(this,delta,isVertical,isFast);
		return null;
	}
	,_isVertical: null
	,_body: null
	,__class__: co.doubleduck.MovingItem
});
co.doubleduck.PagedHelp = $hxClasses["co.doubleduck.PagedHelp"] = function(backUri,nextBtnUri,gotItBtnUri,pages) {
	createjs.Container.call(this);
	this._background = co.doubleduck.BaseAssets.getImage(backUri);
	this.addChild(this._background);
	this.regX = this._background.image.width / 2;
	this.regY = this._background.image.height / 2;
	this._contentLayer = new createjs.Container();
	if(pages.length > 0) {
		var _g1 = 0, _g = pages.length;
		while(_g1 < _g) {
			var i = _g1++;
			this.addPage(pages[i],i);
		}
		this.addChild(this._contentLayer);
		this._pagesCount = pages.length;
		this._mask = new createjs.Shape();
		this._mask.graphics.beginFill("#000000");
		this._mask.graphics.drawRect(20,20,this._background.image.width - 40,this._background.image.height - 40);
		this._mask.graphics.endFill();
		this._contentLayer.mask = this._mask;
	} else this._pagesCount = 0;
	if(nextBtnUri != null && nextBtnUri != "") {
		this._nextBtn = new co.doubleduck.Button(co.doubleduck.BaseAssets.getImage(nextBtnUri),true,co.doubleduck.Button.CLICK_TYPE_SCALE);
		this._nextBtn.regX = this._nextBtn.image.width / 2;
		this._nextBtn.regY = this._nextBtn.image.height / 2;
		this._nextBtn.onClick = $bind(this,this.handleNextClick);
		this.addChild(this._nextBtn);
	}
	this._gotItBtn = new co.doubleduck.Button(co.doubleduck.BaseAssets.getImage(gotItBtnUri),true,co.doubleduck.Button.CLICK_TYPE_SCALE);
	this._gotItBtn.regX = this._gotItBtn.image.width / 2;
	this._gotItBtn.regY = this._gotItBtn.image.height / 2;
	this._gotItBtn.onClick = $bind(this,this.handleGotItClick);
	this.addChild(this._gotItBtn);
	this.setButtonsPos();
	this._currPage = 0;
	this.enableSwipe();
	this.addPageMarkers();
	this.setButtonsVis();
};
co.doubleduck.PagedHelp.__name__ = ["co","doubleduck","PagedHelp"];
co.doubleduck.PagedHelp.__super__ = createjs.Container;
co.doubleduck.PagedHelp.prototype = $extend(createjs.Container.prototype,{
	createPageMarker: function() {
		var img = co.doubleduck.BaseAssets.getRawImage("images/duckling/page_marker.png");
		var initObject = { };
		initObject.images = [img];
		initObject.frames = { width : 16, height : 18};
		initObject.animations = { };
		initObject.animations.idle = { frames : 0, frequency : 20};
		initObject.animations.active = { frames : 1, frequency : 20};
		var pageMarker = new createjs.BitmapAnimation(new createjs.SpriteSheet(initObject));
		pageMarker.gotoAndStop("idle");
		return pageMarker;
	}
	,handleNextClick: function() {
		this._currPage++;
		if(this._currPage >= this._pagesCount) {
			this._currPage = this._pagesCount - 1;
			return;
		}
		this._pageMarkers[this._currPage - 1].gotoAndStop("idle");
		this._pageMarkers[this._currPage].gotoAndStop("active");
		createjs.Tween.get(this._contentLayer).to({ x : -1 * this._background.image.width * this._currPage},200,createjs.Ease.sineOut);
		this.setButtonsVis();
	}
	,handlePrevClick: function() {
		this._currPage--;
		if(this._currPage < 0) {
			this._currPage = 0;
			return;
		}
		this._pageMarkers[this._currPage + 1].gotoAndStop("idle");
		this._pageMarkers[this._currPage].gotoAndStop("active");
		createjs.Tween.get(this._contentLayer).to({ x : -1 * this._background.image.width * this._currPage},200,createjs.Ease.sineOut);
		this.setButtonsVis();
	}
	,setButtonsVis: function() {
		if(this._pagesCount == 0) {
			this._gotItBtn.visible = true;
			return;
		}
		if(this._currPage == this._pagesCount - 1) {
			this._gotItBtn.visible = true;
			this._nextBtn.visible = false;
		} else {
			this._gotItBtn.visible = false;
			this._nextBtn.visible = true;
		}
	}
	,handleSwipe: function(event) {
		if(event.direction == "left") this.handleNextClick(); else if(event.direction == "right") this.handlePrevClick();
	}
	,handleGotItClick: function() {
		if(this.onGotIt != null) this.onGotIt();
	}
	,addPageMarkers: function() {
		if(this._pagesCount == 0) return;
		this._pageMarkers = new Array();
		var totalWidth = 0;
		this._markersLayer = new createjs.Container();
		var _g1 = 0, _g = this._pagesCount;
		while(_g1 < _g) {
			var currPage = _g1++;
			var pageMarker = this.createPageMarker();
			this._pageMarkers.push(pageMarker);
			if(currPage != 0) {
				pageMarker.x = this._pageMarkers[currPage - 1].x + this._pageMarkers[currPage - 1].spriteSheet._frameWidth + 5;
				totalWidth += 5;
			}
			totalWidth += pageMarker.spriteSheet._frameWidth;
			this._markersLayer.addChild(pageMarker);
		}
		this._markersLayer.y = this._background.image.height * 0.80;
		this._markersLayer.x = this._background.image.width / 2;
		this._markersLayer.regX = totalWidth / 2;
		this.addChild(this._markersLayer);
		this._pageMarkers[0].gotoAndStop("active");
	}
	,addPage: function(pageUri,index) {
		var page = co.doubleduck.BaseAssets.getImage(pageUri);
		page.x += this._background.image.width * index;
		this._contentLayer.addChild(page);
	}
	,goToPage: function(page) {
		this._pageMarkers[this._currPage].gotoAndStop("idle");
		this._currPage = page;
		this._pageMarkers[this._currPage].gotoAndStop("active");
		this._contentLayer.x = -1 * this._background.image.width * this._currPage;
		this.setButtonsVis();
	}
	,changeContentMask: function(topPad,bottomPad,leftPad,rightPad) {
		this._mask.graphics.clear();
		this._mask.graphics.beginFill("#000000");
		this._mask.graphics.drawRect(leftPad,topPad,this._background.image.width - (rightPad + leftPad),this._background.image.height - (bottomPad + topPad));
		this._mask.graphics.endFill();
	}
	,rewindPages: function() {
		this.goToPage(0);
	}
	,enableSwipe: function() {
		co.doubleduck.BaseGame.hammer.onswipe = $bind(this,this.handleSwipe);
	}
	,setMarkersPos: function(percentY,percentX) {
		if(percentX == null) percentX = 0.5;
		this._markersLayer.y = this._background.image.height * percentY;
		this._markersLayer.x = this._background.image.width * percentX;
	}
	,setButtonsPos: function(percentX,percentY) {
		if(percentY == null) percentY = 0.5;
		if(percentX == null) percentX = 0.5;
		if(this._nextBtn != null) {
			this._nextBtn.x = this._background.image.width * percentX;
			this._nextBtn.y = this._background.image.height * percentY;
		}
		this._gotItBtn.x = this._background.image.width * percentX;
		this._gotItBtn.y = this._background.image.height * percentY;
	}
	,_currPage: null
	,_pagesCount: null
	,_gotItBtn: null
	,_nextBtn: null
	,_pageMarkers: null
	,_markersLayer: null
	,_mask: null
	,_contentLayer: null
	,_background: null
	,onGotIt: null
	,__class__: co.doubleduck.PagedHelp
});
co.doubleduck.Persistence = $hxClasses["co.doubleduck.Persistence"] = function() { }
co.doubleduck.Persistence.__name__ = ["co","doubleduck","Persistence"];
co.doubleduck.Persistence.initGameData = function() {
	co.doubleduck.BasePersistence.GAME_PREFIX = "DDTommy_";
	if(!co.doubleduck.BasePersistence.available) return;
	co.doubleduck.BasePersistence.initVar(co.doubleduck.Persistence.LAST_LEVEL,"1");
	var _g1 = 0, _g = co.doubleduck.LevelLoader.getLevelCount();
	while(_g1 < _g) {
		var i = _g1++;
		co.doubleduck.BasePersistence.initVar(co.doubleduck.Persistence.STAR_PREFIX + (i + 1),"0");
	}
}
co.doubleduck.Persistence.setLastLevel = function(level) {
	co.doubleduck.BasePersistence.setValue(co.doubleduck.Persistence.LAST_LEVEL,level + "");
}
co.doubleduck.Persistence.getLastLevel = function() {
	return Std.parseInt(co.doubleduck.BasePersistence.getValue(co.doubleduck.Persistence.LAST_LEVEL));
}
co.doubleduck.Persistence.getStarRating = function(lvl) {
	return Std.parseInt(co.doubleduck.BasePersistence.getValue(co.doubleduck.Persistence.STAR_PREFIX + lvl));
}
co.doubleduck.Persistence.setStarRating = function(lvl,rating) {
	co.doubleduck.BasePersistence.setValue(co.doubleduck.Persistence.STAR_PREFIX + lvl,"" + rating);
}
co.doubleduck.Persistence.__super__ = co.doubleduck.BasePersistence;
co.doubleduck.Persistence.prototype = $extend(co.doubleduck.BasePersistence.prototype,{
	__class__: co.doubleduck.Persistence
});
co.doubleduck.PortalItem = $hxClasses["co.doubleduck.PortalItem"] = function() {
	co.doubleduck.GridItem.call(this);
	this._isMoving = false;
	this._body = co.doubleduck.BaseAssets.getImage("images/session/stairs.png");
	this._body.regX = this._body.image.width / 2;
	this._body.regY = this._body.image.height / 2;
	this.addChild(this._body);
};
co.doubleduck.PortalItem.__name__ = ["co","doubleduck","PortalItem"];
co.doubleduck.PortalItem.__super__ = co.doubleduck.GridItem;
co.doubleduck.PortalItem.prototype = $extend(co.doubleduck.GridItem.prototype,{
	_body: null
	,__class__: co.doubleduck.PortalItem
});
co.doubleduck.Session = $hxClasses["co.doubleduck.Session"] = function(properties) {
	this._isIdle = true;
	this._isSwiping = false;
	co.doubleduck.BaseSession.call(this);
	co.doubleduck.Session._autoLoadNext = false;
	co.doubleduck.Session._lastLevelId = this._lvlId = properties.level;
	this._worldType = co.doubleduck.LevelLoader.getLevelWorld(this._lvlId);
	this._starsTookCount = 0;
	this._backSea = co.doubleduck.BaseAssets.getImage("images/session/world" + this._worldType + "/back.png");
	this._backSea.regX = this._backSea.image.width / 2;
	this._backSea.regY = this._backSea.image.height / 2;
	this._backSea.x = co.doubleduck.BaseGame.getScreenSize().width / 2;
	this._backSea.y = co.doubleduck.BaseGame.getScreenSize().height / 2;
	this.addChild(this._backSea);
	this._backGrid = co.doubleduck.BaseAssets.getImage("images/session/world" + this._worldType + "/platform.png");
	this._backGrid.regX = this._backGrid.image.width / 2;
	this._backGrid.regY = this._backGrid.image.height / 2;
	this._backGrid.x = co.doubleduck.BaseGame.getScreenSize().width / 2;
	this._backGrid.y = co.doubleduck.BaseGame.getScreenSize().height / 2;
	this.addChild(this._backGrid);
	this._actorsLayer = new createjs.Container();
	this._actorsLayer.x = this._backGrid.x - this._backGrid.regX + 2;
	this._actorsLayer.y = this._backGrid.y - this._backGrid.regY;
	this._starLayer = new createjs.Container();
	this._starLayer.x = this._actorsLayer.x;
	this._starLayer.y = this._actorsLayer.y;
	this.addChild(this._starLayer);
	this.addChild(this._actorsLayer);
	co.doubleduck.LevelLoader.loadLevel(this._lvlId,this._actorsLayer,this._starLayer);
	var _g1 = 0, _g = this._actorsLayer.getNumChildren();
	while(_g1 < _g) {
		var i = _g1++;
		var curr = this._actorsLayer.getChildAt(i);
		if(js.Boot.__instanceof(curr,co.doubleduck.Tommy)) this._tommy = curr; else if(js.Boot.__instanceof(curr,co.doubleduck.GoalItem)) this._goal = curr; else if(js.Boot.__instanceof(curr,co.doubleduck.PortalItem)) {
			if(this._portals == null) this._portals = new Array();
			this._portals.push(curr);
		}
	}
	this._overlay = co.doubleduck.Utils.getRectangle(new createjs.Rectangle(0,0,co.doubleduck.GridItem.GRID_SIZE,co.doubleduck.GridItem.GRID_SIZE),"#888888");
	this._overlay.alpha = 0.01;
	this._overlay.x = this._actorsLayer.x;
	this._overlay.y = this._actorsLayer.y;
	this._overlay.onPress = $bind(this,this.handleGridMouseD);
	this.addChild(this._overlay);
	this._backMenuBtn = new co.doubleduck.Button(co.doubleduck.BaseAssets.getImage("images/session/menu.png"));
	this._backMenuBtn.x = 15;
	this._backMenuBtn.y = 15;
	this.addChild(this._backMenuBtn);
	this._retryBtn = new co.doubleduck.Button(co.doubleduck.BaseAssets.getImage("images/session/retry.png"));
	this._retryBtn.regX = this._retryBtn.image.width;
	this._retryBtn.x = co.doubleduck.BaseGame.getScreenSize().width - 15;
	this._retryBtn.y = this._backMenuBtn.y;
	this.addChild(this._retryBtn);
	this.addChild(co.doubleduck.Transition.getInstance());
	co.doubleduck.Transition.transitionIn();
	co.doubleduck.Utils.waitAndCall(null,1000,$bind(this,this.enableBtns));
};
co.doubleduck.Session.__name__ = ["co","doubleduck","Session"];
co.doubleduck.Session.sortZbyY = function(a,b) {
	if(js.Boot.__instanceof(a,co.doubleduck.PortalItem)) return -1; else if(js.Boot.__instanceof(b,co.doubleduck.PortalItem)) return 1;
	if(a.y < b.y) return -1; else if(a.y > b.y) return 1; else if(js.Boot.__instanceof(a,co.doubleduck.Tommy)) return 1; else if(js.Boot.__instanceof(b,co.doubleduck.Tommy)) return -1;
	return 0;
}
co.doubleduck.Session.getLastLevelId = function() {
	return co.doubleduck.Session._lastLevelId;
}
co.doubleduck.Session.shouldAutoLoadNext = function() {
	return co.doubleduck.Session._autoLoadNext;
}
co.doubleduck.Session.__super__ = co.doubleduck.BaseSession;
co.doubleduck.Session.prototype = $extend(co.doubleduck.BaseSession.prototype,{
	handleNext: function() {
		if(this.onRestart != null) {
			if(co.doubleduck.LevelLoader.getHelpForLevel(this._lvlId).toLevel == this._lvlId) {
				co.doubleduck.Session._autoLoadNext = true;
				co.doubleduck.Transition.transitionOut(this.onBackToMenu);
			} else co.doubleduck.Transition.transitionOut(this.onRestart,[{ level : this._lvlId + 1}]);
			this._backMenuBtn.onClick = null;
			this._retryBtn.onClick = null;
		}
	}
	,handleRetry: function() {
		if(this.onRestart != null) {
			co.doubleduck.Transition.transitionOut(this.onRestart,[{ level : this._lvlId}]);
			this._backMenuBtn.onClick = null;
			this._retryBtn.onClick = null;
		}
	}
	,handleBackMenu: function() {
		if(this.onBackToMenu != null) {
			co.doubleduck.Transition.transitionOut(this.onBackToMenu);
			this._backMenuBtn.onClick = null;
			this._retryBtn.onClick = null;
		}
	}
	,playerLost: function() {
		this._overlay.mouseEnabled = false;
		co.doubleduck.SoundManager.playEffect("sound/tommy_fall");
		this.handleRetry();
	}
	,playerWon: function() {
		co.doubleduck.SoundManager.playEffect("sound/level_pass");
		this._overlay.mouseEnabled = false;
		this.removeChild(this._retryBtn);
		this.removeChild(this._backMenuBtn);
		var end = new co.doubleduck.SessionEnd(this._lvlId,this._starsTookCount);
		end.onMenu = $bind(this,this.handleBackMenu);
		end.onRetry = $bind(this,this.handleRetry);
		end.onNext = $bind(this,this.handleNext);
		this.addChildAt(end,this.getChildIndex(co.doubleduck.Transition.getInstance()));
	}
	,handleGridIdle: function() {
		if(this._portals != null) {
			var gotoPort = -1;
			if(this._swipedItem.gridDistTo(this._portals[0]) == 0) gotoPort = 1; else if(this._swipedItem.gridDistTo(this._portals[1]) == 0) gotoPort = 0;
			if(gotoPort != -1) {
				co.doubleduck.SoundManager.playEffect("sound/teleport");
				this._swipedItem.setPosX(this._portals[gotoPort].getPosX());
				this._swipedItem.setPosY(this._portals[gotoPort].getPosY());
				this._actorsLayer.sortChildren(co.doubleduck.Session.sortZbyY);
				if(this._lastMoveDelta != 0) this.slideItem(this._lastMoveVertical,this._lastMoveDelta > 0); else this.slideItem(this._lastMoveVertical,this._prevDelta < 0);
				return;
			}
		}
		if(this._tommy.gridDistTo(this._goal) == 1 && this._swipedItem == this._tommy) {
			if(this._lastMoveVertical == (this._tommy.getPosX() == this._goal.getPosX())) {
				this.playerWon();
				return;
			}
		}
		this._actorsLayer.sortChildren(co.doubleduck.Session.sortZbyY);
		this._swipedItem = null;
		this._srcPos = null;
		this._isIdle = true;
	}
	,handleTookStar: function(star) {
		co.doubleduck.SoundManager.playEffect("sound/crunch");
		createjs.Tween.get(star).to({ alpha : 0},40).call(($_=this._starLayer,$bind($_,$_.removeChild)),[star]);
		this._starsTookCount++;
	}
	,handleItemGone: function() {
		if(this._swipedItem == this._tommy) this.playerLost(); else {
			this._actorsLayer.removeChild(this._swipedItem);
			createjs.Tween.removeTweens(this._swipedItem);
			this.handleGridIdle();
		}
	}
	,handleGridMouseOut: function(e) {
		this.endSwipe();
	}
	,handleGridMouseU: function(e) {
		this.endSwipe();
	}
	,handleGridMouseOver: function(e) {
		if(Math.abs(co.doubleduck.BaseGame.getStage().mouseX - this._srcPos.x) >= co.doubleduck.Session.DRAG_THRESH || Math.abs(co.doubleduck.BaseGame.getStage().mouseY - this._srcPos.y) >= co.doubleduck.Session.DRAG_THRESH) this.endSwipe();
	}
	,slideItem: function(vertical,deltaPositive) {
		this._prevDelta = this._lastMoveDelta;
		this._lastMoveDelta = 0;
		this._lastMoveVertical = vertical;
		var item = null;
		var starsOnPath = new Array();
		if(this._lastMoveVertical) {
			if(deltaPositive) {
				var _g1 = Math.floor(this._swipedItem.getPosY() + 1), _g = co.doubleduck.GridItem.GRID_ROWS;
				while(_g1 < _g) {
					var i = _g1++;
					item = this.getItemForGridPos(new createjs.Point(this._swipedItem.getPosX(),i));
					if(item == null) {
						var _g3 = 0, _g2 = this._starLayer.getNumChildren();
						while(_g3 < _g2) {
							var j = _g3++;
							var star = this._starLayer.getChildAt(j);
							if(star.getPosX() == this._swipedItem.getPosX() && star.getPosY() == i) starsOnPath.push(star);
						}
					}
					if(item != null) break;
				}
				if(item != null) {
					this._lastMoveDelta = Math.floor(item.getPosY() - this._swipedItem.getPosY());
					if(!js.Boot.__instanceof(item,co.doubleduck.PortalItem)) this._lastMoveDelta--;
				} else this._lastMoveDelta = Math.floor(co.doubleduck.GridItem.GRID_ROWS * 2 - this._swipedItem.getPosY());
			} else {
				var i = Math.floor(this._swipedItem.getPosY() - 1);
				while(i >= 0) {
					item = this.getItemForGridPos(new createjs.Point(this._swipedItem.getPosX(),i));
					if(item == null) {
						var _g1 = 0, _g = this._starLayer.getNumChildren();
						while(_g1 < _g) {
							var j = _g1++;
							var star = this._starLayer.getChildAt(j);
							if(star.getPosX() == this._swipedItem.getPosX() && star.getPosY() == i) starsOnPath.push(star);
						}
					}
					if(item != null) break;
					i--;
				}
				if(item != null) {
					this._lastMoveDelta = Math.floor(item.getPosY() - this._swipedItem.getPosY());
					if(!js.Boot.__instanceof(item,co.doubleduck.PortalItem)) this._lastMoveDelta++;
				} else this._lastMoveDelta = Math.floor(this._swipedItem.getPosY() - co.doubleduck.GridItem.GRID_ROWS * 2);
			}
		} else if(deltaPositive) {
			var _g1 = Math.floor(this._swipedItem.getPosX() + 1), _g = co.doubleduck.GridItem.GRID_COLS;
			while(_g1 < _g) {
				var i = _g1++;
				item = this.getItemForGridPos(new createjs.Point(i,this._swipedItem.getPosY()));
				if(item == null) {
					var _g3 = 0, _g2 = this._starLayer.getNumChildren();
					while(_g3 < _g2) {
						var j = _g3++;
						var star = this._starLayer.getChildAt(j);
						if(star.getPosX() == i && star.getPosY() == this._swipedItem.getPosY()) starsOnPath.push(star);
					}
				}
				if(item != null) break;
			}
			if(item != null) {
				this._lastMoveDelta = Math.floor(item.getPosX() - this._swipedItem.getPosX());
				if(!js.Boot.__instanceof(item,co.doubleduck.PortalItem)) this._lastMoveDelta--;
			} else this._lastMoveDelta = Math.floor(co.doubleduck.GridItem.GRID_COLS * 2 - this._swipedItem.getPosX());
		} else {
			var i = Math.floor(this._swipedItem.getPosX() - 1);
			while(i >= 0) {
				item = this.getItemForGridPos(new createjs.Point(i,this._swipedItem.getPosY()));
				if(item == null) {
					var _g1 = 0, _g = this._starLayer.getNumChildren();
					while(_g1 < _g) {
						var j = _g1++;
						var star = this._starLayer.getChildAt(j);
						if(star.getPosX() == i && star.getPosY() == this._swipedItem.getPosY()) starsOnPath.push(star);
					}
				}
				if(item != null) break;
				i--;
			}
			if(item != null) {
				this._lastMoveDelta = Math.floor(item.getPosX() - this._swipedItem.getPosX());
				if(!js.Boot.__instanceof(item,co.doubleduck.PortalItem)) this._lastMoveDelta++;
			} else this._lastMoveDelta = Math.floor(this._swipedItem.getPosX() - co.doubleduck.GridItem.GRID_COLS * 2);
		}
		var moveTween;
		if(item != null) {
			moveTween = this._swipedItem.swipeTo(this._lastMoveDelta,this._lastMoveVertical);
			if(moveTween != null) {
				moveTween.call($bind(this,this.handleGridIdle));
				co.doubleduck.SoundManager.playEffect("sound/car_bump");
			}
		} else {
			moveTween = this._swipedItem.swipeTo(this._lastMoveDelta,this._lastMoveVertical,true);
			if(moveTween != null) moveTween.call($bind(this,this.handleItemGone));
		}
		if(moveTween != null) {
			this._isIdle = false;
			if(this._swipedItem == this._tommy) {
				if(item == null) {
					this._retryBtn.onClick = null;
					this._backMenuBtn.onClick = null;
				}
				var _g = 0;
				while(_g < starsOnPath.length) {
					var star = starsOnPath[_g];
					++_g;
					createjs.Tween.get(star).wait(Math.floor(this._tommy.gridDistTo(star) * co.doubleduck.GridItem.SLIDE_SPEED) - 20).call($bind(this,this.handleTookStar),[star]);
				}
			}
		}
	}
	,endSwipe: function() {
		if(this._isSwiping) {
			this._isSwiping = false;
			this._overlay.onPress = $bind(this,this.handleGridMouseD);
			this._overlay.onTick = null;
			this._overlay.onClick = null;
			this._overlay.onMouseOut = null;
			var delta = new createjs.Point(co.doubleduck.BaseGame.getStage().mouseX,co.doubleduck.BaseGame.getStage().mouseY);
			delta.x -= this._srcPos.x;
			delta.y -= this._srcPos.y;
			if(delta.x == 0 && delta.y == 0) return;
			if(Math.abs(delta.x) < Math.abs(delta.y)) this.slideItem(true,delta.y > 0); else this.slideItem(false,delta.x > 0);
		}
	}
	,handleGridMouseD: function(e) {
		if(!this._isSwiping && this._isIdle) {
			this._isSwiping = true;
			this._swipedItem = this.getItemForMouse();
			if(this._swipedItem == null) {
				this._isSwiping = false;
				return;
			}
			if(!this._swipedItem.getIsMoving()) {
				this._isSwiping = false;
				this._swipedItem = null;
				return;
			}
			this._srcPos = new createjs.Point(co.doubleduck.BaseGame.getStage().mouseX,co.doubleduck.BaseGame.getStage().mouseY);
			this._overlay.onPress = null;
			this._overlay.onTick = $bind(this,this.handleGridMouseOver);
			this._overlay.onClick = $bind(this,this.handleGridMouseU);
			this._overlay.onMouseOut = $bind(this,this.handleGridMouseOut);
		}
	}
	,getItemForMouse: function() {
		var mousePos = this._overlay.globalToLocal(co.doubleduck.BaseGame.getStage().mouseX,co.doubleduck.BaseGame.getStage().mouseY);
		return this.getItemForPos(mousePos);
	}
	,getItemForPos: function(pos) {
		var gridPos = new createjs.Point(0,0);
		gridPos.x = Math.floor(pos.x / (co.doubleduck.GridItem.GRID_SIZE / co.doubleduck.GridItem.GRID_COLS));
		gridPos.y = Math.floor(pos.y / (co.doubleduck.GridItem.GRID_SIZE / co.doubleduck.GridItem.GRID_COLS));
		return this.getItemForGridPos(gridPos);
	}
	,getItemForGridPos: function(pos) {
		var _g1 = 0, _g = this._actorsLayer.getNumChildren();
		while(_g1 < _g) {
			var i = _g1++;
			var item = this._actorsLayer.getChildAt(i);
			if(item.getPosX() == pos.x && item.getPosY() == pos.y) return item;
		}
		return null;
	}
	,enableBtns: function() {
		this._retryBtn.onClick = $bind(this,this.handleRetry);
		this._backMenuBtn.onClick = $bind(this,this.handleBackMenu);
	}
	,_prevDelta: null
	,_lastMoveDelta: null
	,_lastMoveVertical: null
	,_starsTookCount: null
	,_srcPos: null
	,_swipedItem: null
	,_isIdle: null
	,_isSwiping: null
	,_worldType: null
	,_lvlId: null
	,_backMenuBtn: null
	,_retryBtn: null
	,_portals: null
	,_goal: null
	,_tommy: null
	,_overlay: null
	,_actorsLayer: null
	,_starLayer: null
	,_backGrid: null
	,_backSea: null
	,__class__: co.doubleduck.Session
});
co.doubleduck.SessionEnd = $hxClasses["co.doubleduck.SessionEnd"] = function(level,stars) {
	if(stars == null) stars = 0;
	createjs.Container.call(this);
	var isLast = false;
	if(level == co.doubleduck.LevelLoader.getLevelCount()) isLast = true;
	if(!isLast && co.doubleduck.Persistence.getLastLevel() == level) co.doubleduck.Persistence.setLastLevel(level + 1);
	if(co.doubleduck.Persistence.getStarRating(level) < stars) co.doubleduck.Persistence.setStarRating(level,stars);
	this._overlay = co.doubleduck.Utils.getRectangle(new createjs.Rectangle(0,0,co.doubleduck.BaseGame.getScreenSize().width,co.doubleduck.BaseGame.getScreenSize().height),"#000000");
	this._overlay.alpha = 0;
	this.addChild(this._overlay);
	var bg;
	if(isLast) bg = co.doubleduck.Utils.getCenteredImage("images/session/session_end/end_game.png",false); else bg = co.doubleduck.Utils.getCenteredImage("images/session/session_end/finish.png",false);
	bg.x = co.doubleduck.BaseGame.getScreenSize().width / 2;
	bg.y = -co.doubleduck.BaseGame.getScreenSize().height / 2;
	this.addChild(bg);
	var glow = null;
	if(stars == 3) {
		glow = co.doubleduck.Utils.getCenteredImage("images/session/session_end/glow.png",false);
		glow.x = co.doubleduck.BaseGame.getScreenSize().width / 2;
		glow.alpha = 0;
		createjs.Tween.get(glow).wait(450).to({ alpha : 0.4},750);
		this.addChild(glow);
	}
	var lastTween = null;
	var _g = 0;
	while(_g < stars) {
		var i = _g++;
		var star = co.doubleduck.Utils.getCenteredImage("images/session/session_end/" + (i + 1) + "star.png",false);
		star.x = co.doubleduck.BaseGame.getScreenSize().width / 2;
		star.y = co.doubleduck.BaseGame.getScreenSize().height / 2 - bg.image.height / 2 + star.image.height / 2;
		star.alpha = 0;
		this.addChild(star);
		lastTween = createjs.Tween.get(star).wait(500 + i * 250).to({ alpha : 1, scaleX : 1.2, scaleY : 1.2},100,createjs.Ease.sineOut).to({ scaleX : 1, scaleY : 1},250,createjs.Ease.sineInOut);
		if(glow != null) glow.y = co.doubleduck.BaseGame.getScreenSize().height / 2 - bg.image.height / 2 + star.image.height / 2;
	}
	createjs.Tween.get(this._overlay).to({ alpha : 0.75},400);
	if(lastTween != null) {
		createjs.Tween.get(bg).wait(100).to({ y : -bg.y},400,createjs.Ease.sineOut);
		lastTween.call($bind(this,this.showBtns),[isLast]);
	} else createjs.Tween.get(bg).wait(100).to({ y : -bg.y},400,createjs.Ease.sineOut).call($bind(this,this.showBtns),[isLast]);
};
co.doubleduck.SessionEnd.__name__ = ["co","doubleduck","SessionEnd"];
co.doubleduck.SessionEnd.__super__ = createjs.Container;
co.doubleduck.SessionEnd.prototype = $extend(createjs.Container.prototype,{
	handleNext: function() {
		if(this.onNext != null) {
			this.onNext();
			this._menu.onClick = null;
			this._retry.onClick = null;
			if(this._next != null) this._next.onClick = null;
		}
	}
	,handleRetry: function() {
		if(this.onRetry != null) {
			this.onRetry();
			this._menu.onClick = null;
			this._retry.onClick = null;
			if(this._next != null) this._next.onClick = null;
		}
	}
	,handleMenu: function() {
		if(this.onMenu != null) {
			this.onMenu();
			this._menu.onClick = null;
			this._retry.onClick = null;
			if(this._next != null) this._next.onClick = null;
		}
	}
	,showBtns: function(isLast) {
		this._menu = new co.doubleduck.Button(co.doubleduck.BaseAssets.getImage("images/session/menu.png"));
		this._menu.regX = this._menu.image.width / 2;
		this._menu.regY = this._menu.image.height / 2;
		this._menu.alpha = 0;
		this._menu.x = co.doubleduck.BaseGame.getScreenSize().width * 0.32;
		this._menu.y = co.doubleduck.BaseGame.getScreenSize().height * 0.65;
		this._menu.onClick = $bind(this,this.handleMenu);
		this.addChild(this._menu);
		this._retry = new co.doubleduck.Button(co.doubleduck.BaseAssets.getImage("images/session/retry.png"));
		this._retry.regX = this._retry.image.width / 2;
		this._retry.regY = this._retry.image.height / 2;
		this._retry.alpha = 0;
		this._retry.x = co.doubleduck.BaseGame.getScreenSize().width * 0.5;
		this._retry.y = this._menu.y;
		this._retry.onClick = $bind(this,this.handleRetry);
		this.addChild(this._retry);
		if(isLast) {
			this._menu.x = co.doubleduck.BaseGame.getScreenSize().width * 0.41;
			this._retry.x = co.doubleduck.BaseGame.getScreenSize().width * 0.59;
			this._menu.y = this._retry.y = co.doubleduck.BaseGame.getScreenSize().height * 0.55;
		} else {
			this._next = new co.doubleduck.Button(co.doubleduck.BaseAssets.getImage("images/session/session_end/play.png"));
			this._next.regX = this._next.image.width / 2;
			this._next.regY = this._next.image.height / 2;
			this._next.alpha = 0;
			this._next.x = co.doubleduck.BaseGame.getScreenSize().width * 0.68;
			this._next.y = this._menu.y;
			this._next.onClick = $bind(this,this.handleNext);
			this.addChild(this._next);
		}
		createjs.Tween.get(this._menu).to({ alpha : 1},300);
		createjs.Tween.get(this._retry).to({ alpha : 1},300);
		if(this._next != null) createjs.Tween.get(this._next).to({ alpha : 1},300);
	}
	,_next: null
	,_retry: null
	,_menu: null
	,_overlay: null
	,onNext: null
	,onRetry: null
	,onMenu: null
	,__class__: co.doubleduck.SessionEnd
});
co.doubleduck.SoundType = $hxClasses["co.doubleduck.SoundType"] = { __ename__ : ["co","doubleduck","SoundType"], __constructs__ : ["WEB_AUDIO","AUDIO_FX","AUDIO_NO_OVERLAP","HOWLER","NONE"] }
co.doubleduck.SoundType.WEB_AUDIO = ["WEB_AUDIO",0];
co.doubleduck.SoundType.WEB_AUDIO.toString = $estr;
co.doubleduck.SoundType.WEB_AUDIO.__enum__ = co.doubleduck.SoundType;
co.doubleduck.SoundType.AUDIO_FX = ["AUDIO_FX",1];
co.doubleduck.SoundType.AUDIO_FX.toString = $estr;
co.doubleduck.SoundType.AUDIO_FX.__enum__ = co.doubleduck.SoundType;
co.doubleduck.SoundType.AUDIO_NO_OVERLAP = ["AUDIO_NO_OVERLAP",2];
co.doubleduck.SoundType.AUDIO_NO_OVERLAP.toString = $estr;
co.doubleduck.SoundType.AUDIO_NO_OVERLAP.__enum__ = co.doubleduck.SoundType;
co.doubleduck.SoundType.HOWLER = ["HOWLER",3];
co.doubleduck.SoundType.HOWLER.toString = $estr;
co.doubleduck.SoundType.HOWLER.__enum__ = co.doubleduck.SoundType;
co.doubleduck.SoundType.NONE = ["NONE",4];
co.doubleduck.SoundType.NONE.toString = $estr;
co.doubleduck.SoundType.NONE.__enum__ = co.doubleduck.SoundType;
if(!co.doubleduck.audio) co.doubleduck.audio = {}
co.doubleduck.audio.AudioAPI = $hxClasses["co.doubleduck.audio.AudioAPI"] = function() { }
co.doubleduck.audio.AudioAPI.__name__ = ["co","doubleduck","audio","AudioAPI"];
co.doubleduck.audio.AudioAPI.prototype = {
	setVolume: null
	,pause: null
	,stop: null
	,playMusic: null
	,playEffect: null
	,init: null
	,__class__: co.doubleduck.audio.AudioAPI
}
co.doubleduck.audio.WebAudioAPI = $hxClasses["co.doubleduck.audio.WebAudioAPI"] = function(src) {
	this._src = src;
	this.loadAudioFile(this._src);
};
co.doubleduck.audio.WebAudioAPI.__name__ = ["co","doubleduck","audio","WebAudioAPI"];
co.doubleduck.audio.WebAudioAPI.__interfaces__ = [co.doubleduck.audio.AudioAPI];
co.doubleduck.audio.WebAudioAPI.context = null;
co.doubleduck.audio.WebAudioAPI.webAudioInit = function() {
	co.doubleduck.audio.WebAudioAPI.context = new webkitAudioContext();
}
co.doubleduck.audio.WebAudioAPI.saveBuffer = function(buffer,name) {
	co.doubleduck.audio.WebAudioAPI._buffers[name] = buffer;
}
co.doubleduck.audio.WebAudioAPI.decodeError = function() {
	null;
}
co.doubleduck.audio.WebAudioAPI.prototype = {
	setVolume: function(volume) {
		if(this._gainNode != null) this._gainNode.gain.value = volume;
	}
	,pause: function() {
	}
	,stop: function(fadeOut) {
		if(fadeOut == null) fadeOut = 0;
		if(this._source != null) this._source.noteOff(0);
	}
	,playMusic: function(volume,loop,fadeIn) {
		if(fadeIn == null) fadeIn = 0;
		if(loop == null) loop = true;
		if(volume == null) volume = 1;
		this.playBuffer(this._src,loop);
		this.setVolume(volume);
	}
	,playEffect: function(volume,overrideOtherEffects,loop,fadeIn) {
		if(fadeIn == null) fadeIn = 0;
		if(loop == null) loop = false;
		if(overrideOtherEffects == null) overrideOtherEffects = true;
		if(volume == null) volume = 1;
		this.playBuffer(this._src,loop);
		this.setVolume(volume);
	}
	,playBuffer: function(name,loop) {
		if(loop == null) loop = false;
		if(this._gainNode == null) {
			this._gainNode = co.doubleduck.audio.WebAudioAPI.context.createGainNode();
			this._gainNode.connect(co.doubleduck.audio.WebAudioAPI.context.destination);
		}
		this._buffer = Reflect.getProperty(co.doubleduck.audio.WebAudioAPI._buffers,this._src);
		if(this._buffer == null) return;
		this._source = co.doubleduck.audio.WebAudioAPI.context.createBufferSource();
		this._source.buffer = this._buffer;
		this._source.loop = loop;
		this._source.connect(this._gainNode);
		this._source.noteOn(0);
	}
	,loadAudioFile: function(src) {
		var request = new XMLHttpRequest();
		request.open("get",src,true);
		request.responseType = "arraybuffer";
		request.onload = function() { co.doubleduck.audio.WebAudioAPI.context.decodeAudioData(request.response, function(decodedBuffer) { buffer = decodedBuffer; co.doubleduck.audio.WebAudioAPI.saveBuffer(buffer,src); }, co.doubleduck.audio.WebAudioAPI.decodeError) }
		request.send();
	}
	,init: function() {
	}
	,_source: null
	,_gainNode: null
	,_buffer: null
	,_src: null
	,__class__: co.doubleduck.audio.WebAudioAPI
}
co.doubleduck.SoundManager = $hxClasses["co.doubleduck.SoundManager"] = function() {
};
co.doubleduck.SoundManager.__name__ = ["co","doubleduck","SoundManager"];
co.doubleduck.SoundManager.engineType = null;
co.doubleduck.SoundManager.EXTENSION = null;
co.doubleduck.SoundManager.getPersistedMute = function() {
	var mute = co.doubleduck.BasePersistence.getValue("mute");
	if(mute == "0") {
		mute = "false";
		co.doubleduck.SoundManager.setPersistedMute(false);
	}
	return mute == "true";
}
co.doubleduck.SoundManager.setPersistedMute = function(mute) {
	var val = "true";
	if(!mute) val = "false";
	co.doubleduck.BasePersistence.setValue("mute",val);
}
co.doubleduck.SoundManager.isSoundAvailable = function() {
	var isFirefox = /Firefox/.test(navigator.userAgent);
	var isChrome = /Chrome/.test(navigator.userAgent);
	var isMobile = /Mobile/.test(navigator.userAgent);
	var isAndroid = /Android/.test(navigator.userAgent);
	var isAndroid4 = /Android 4/.test(navigator.userAgent);
	var isSafari = /Safari/.test(navigator.userAgent);
	var agent = navigator.userAgent;
	var reg = new EReg("iPhone OS 6","");
	var isIOS6 = reg.match(agent) && isSafari && isMobile;
	var isIpad = /iPad/.test(navigator.userAgent);
	isIpad = isIpad && /OS 6/.test(navigator.userAgent);
	isIOS6 = isIOS6 || isIpad;
	if(isFirefox) {
		co.doubleduck.SoundManager.engineType = co.doubleduck.SoundType.AUDIO_FX;
		co.doubleduck.SoundManager.EXTENSION = ".ogg";
		return true;
	}
	if(isChrome && (!isAndroid && !isMobile)) {
		co.doubleduck.SoundManager.engineType = co.doubleduck.SoundType.WEB_AUDIO;
		co.doubleduck.audio.WebAudioAPI.webAudioInit();
		co.doubleduck.SoundManager.EXTENSION = ".ogg";
		return true;
	}
	co.doubleduck.SoundManager.engineType = co.doubleduck.SoundType.NONE;
	co.doubleduck.BasePersistence.initVar("mute");
	return false;
}
co.doubleduck.SoundManager.mute = function(persisted) {
	if(persisted == null) persisted = true;
	if(!co.doubleduck.SoundManager.available) return;
	co.doubleduck.SoundManager._muted = true;
	var _g1 = 0, _g = Reflect.fields(co.doubleduck.SoundManager._cache).length;
	while(_g1 < _g) {
		var currSound = _g1++;
		var mySound = Reflect.getProperty(co.doubleduck.SoundManager._cache,Reflect.fields(co.doubleduck.SoundManager._cache)[currSound]);
		if(mySound != null) mySound.setVolume(0);
	}
	if(persisted) co.doubleduck.SoundManager.setPersistedMute(co.doubleduck.SoundManager._muted);
}
co.doubleduck.SoundManager.unmute = function(persisted) {
	if(persisted == null) persisted = true;
	if(!co.doubleduck.SoundManager.available) return;
	co.doubleduck.SoundManager._muted = false;
	try {
		var _g1 = 0, _g = Reflect.fields(co.doubleduck.SoundManager._cache).length;
		while(_g1 < _g) {
			var currSound = _g1++;
			var mySound = Reflect.getProperty(co.doubleduck.SoundManager._cache,Reflect.fields(co.doubleduck.SoundManager._cache)[currSound]);
			if(mySound != null) mySound.setVolume(1);
		}
	} catch( e ) {
		null;
	}
	if(persisted) co.doubleduck.SoundManager.setPersistedMute(co.doubleduck.SoundManager._muted);
}
co.doubleduck.SoundManager.toggleMute = function() {
	if(co.doubleduck.SoundManager._muted) co.doubleduck.SoundManager.unmute(); else co.doubleduck.SoundManager.mute();
}
co.doubleduck.SoundManager.isMuted = function() {
	co.doubleduck.SoundManager._muted = co.doubleduck.SoundManager.getPersistedMute();
	return co.doubleduck.SoundManager._muted;
}
co.doubleduck.SoundManager.getAudioInstance = function(src) {
	if(!co.doubleduck.SoundManager.available) return new co.doubleduck.audio.DummyAudioAPI();
	src += co.doubleduck.SoundManager.EXTENSION;
	var audio = Reflect.getProperty(co.doubleduck.SoundManager._cache,src);
	if(audio == null) {
		switch( (co.doubleduck.SoundManager.engineType)[1] ) {
		case 1:
			audio = new co.doubleduck.audio.AudioFX(src);
			break;
		case 0:
			audio = new co.doubleduck.audio.WebAudioAPI(src);
			break;
		case 2:
			audio = new co.doubleduck.audio.NonOverlappingAudio(src);
			break;
		case 3:
			audio = new co.doubleduck.audio.HowlerAudio(src);
			break;
		case 4:
			return new co.doubleduck.audio.DummyAudioAPI();
		}
		Reflect.setProperty(co.doubleduck.SoundManager._cache,src,audio);
	}
	return audio;
}
co.doubleduck.SoundManager.playEffect = function(src,volume,optional) {
	if(optional == null) optional = false;
	if(volume == null) volume = 1;
	if(optional && co.doubleduck.SoundManager.engineType == co.doubleduck.SoundType.AUDIO_NO_OVERLAP) return new co.doubleduck.audio.DummyAudioAPI();
	var audio = co.doubleduck.SoundManager.getAudioInstance(src);
	var playVolume = volume;
	if(co.doubleduck.SoundManager._muted) playVolume = 0;
	audio.playEffect(playVolume);
	return audio;
}
co.doubleduck.SoundManager.playMusic = function(src,volume,loop) {
	if(loop == null) loop = true;
	if(volume == null) volume = 1;
	var audio = co.doubleduck.SoundManager.getAudioInstance(src);
	var playVolume = volume;
	if(co.doubleduck.SoundManager._muted) playVolume = 0;
	audio.playMusic(playVolume,loop);
	return audio;
}
co.doubleduck.SoundManager.initSound = function(src) {
	co.doubleduck.SoundManager.getAudioInstance(src);
}
co.doubleduck.SoundManager.prototype = {
	__class__: co.doubleduck.SoundManager
}
co.doubleduck.StarItem = $hxClasses["co.doubleduck.StarItem"] = function() {
	co.doubleduck.GridItem.call(this);
	this._isMoving = false;
	this._body = co.doubleduck.BaseAssets.getImage("images/session/cookie.png");
	this._body.regX = this._body.image.width / 2;
	this._body.regY = this._body.image.height / 2;
	this.addChild(this._body);
};
co.doubleduck.StarItem.__name__ = ["co","doubleduck","StarItem"];
co.doubleduck.StarItem.__super__ = co.doubleduck.GridItem;
co.doubleduck.StarItem.prototype = $extend(co.doubleduck.GridItem.prototype,{
	_body: null
	,__class__: co.doubleduck.StarItem
});
co.doubleduck.StaticItem = $hxClasses["co.doubleduck.StaticItem"] = function(worldId,id) {
	co.doubleduck.GridItem.call(this);
	this._isMoving = false;
	this._body = co.doubleduck.BaseAssets.getImage("images/session/world" + worldId + "/block" + id + ".png");
	this._body.regX = this._body.image.width / 2;
	this._body.regY = this._body.image.height / 2;
	this.addChild(this._body);
};
co.doubleduck.StaticItem.__name__ = ["co","doubleduck","StaticItem"];
co.doubleduck.StaticItem.__super__ = co.doubleduck.GridItem;
co.doubleduck.StaticItem.prototype = $extend(co.doubleduck.GridItem.prototype,{
	_body: null
	,__class__: co.doubleduck.StaticItem
});
co.doubleduck.Tommy = $hxClasses["co.doubleduck.Tommy"] = function() {
	co.doubleduck.GridItem.call(this);
	this._isMoving = true;
	if(co.doubleduck.Tommy._bodySheet == null) {
		var img = co.doubleduck.BaseAssets.getRawImage("images/session/tommy.png");
		var initObject = { };
		initObject.images = [img];
		initObject.frames = { width : co.doubleduck.Tommy.TOMMY_WIDTH, height : co.doubleduck.Tommy.TOMMY_HEIGHT, regX : co.doubleduck.Tommy.TOMMY_WIDTH / 2, regY : co.doubleduck.Tommy.TOMMY_HEIGHT / 2};
		initObject.animations = { };
		var states = Type.allEnums(co.doubleduck.TommyState);
		var _g1 = 0, _g = states.length;
		while(_g1 < _g) {
			var i = _g1++;
			initObject.animations[("" + Std.string(states[i])).toLowerCase()] = { frames : [i], frequency : 1};
		}
		co.doubleduck.Tommy._bodySheet = new createjs.SpriteSheet(initObject);
	}
	this._body = new createjs.BitmapAnimation(co.doubleduck.Tommy._bodySheet);
	this.addChild(this._body);
	this._state = co.doubleduck.TommyState.IDLE;
	this.updateBody();
};
co.doubleduck.Tommy.__name__ = ["co","doubleduck","Tommy"];
co.doubleduck.Tommy._bodySheet = null;
co.doubleduck.Tommy.__super__ = co.doubleduck.GridItem;
co.doubleduck.Tommy.prototype = $extend(co.doubleduck.GridItem.prototype,{
	updateBody: function(withState) {
		if(withState != null) this._state = withState;
		this._body.gotoAndStop(("" + Std.string(this._state)).toLowerCase());
	}
	,swipeTo: function(delta,isVertical,isFast) {
		if(isFast == null) isFast = false;
		var tween = co.doubleduck.GridItem.prototype.swipeTo.call(this,delta,isVertical,isFast);
		var duration = Math.abs(delta) * co.doubleduck.GridItem.SLIDE_SPEED;
		var bounceTween = createjs.Tween.get(this._body).wait(Math.floor(duration)).call($bind(this,this.updateBody),[co.doubleduck.TommyState.IDLE]);
		var bounceTime = 70;
		var offset = 4;
		if(isVertical) {
			if(delta < 0) {
				this.updateBody(co.doubleduck.TommyState.UP);
				this._body.x = this._body.regX = 0;
				this._body.y = this._body.regY = -co.doubleduck.Tommy.TOMMY_HEIGHT / 2;
				bounceTween.to({ scaleY : 0.75, y : this._body.y + offset},bounceTime,createjs.Ease.sineOut).to({ scaleY : 1, y : this._body.y},bounceTime,createjs.Ease.sineInOut);
			} else {
				this.updateBody(co.doubleduck.TommyState.DOWN);
				this._body.x = this._body.regX = 0;
				this._body.y = this._body.regY = co.doubleduck.Tommy.TOMMY_HEIGHT / 2;
				bounceTween.to({ scaleY : 0.75, y : this._body.y - offset},bounceTime,createjs.Ease.sineOut).to({ scaleY : 1, y : this._body.y},bounceTime,createjs.Ease.sineInOut);
			}
		} else if(delta > 0) {
			this.updateBody(co.doubleduck.TommyState.RIGHT);
			this._body.x = this._body.regX = co.doubleduck.Tommy.TOMMY_WIDTH / 2;
			this._body.y = this._body.regY = 0;
			bounceTween.to({ scaleX : 0.75, x : this._body.x - offset},bounceTime,createjs.Ease.sineOut).to({ scaleX : 1, x : this._body.x},bounceTime,createjs.Ease.sineInOut);
		} else {
			this.updateBody(co.doubleduck.TommyState.LEFT);
			this._body.x = this._body.regX = -co.doubleduck.Tommy.TOMMY_WIDTH / 2;
			this._body.y = this._body.regY = 0;
			bounceTween.to({ scaleX : 0.75, x : this._body.x + offset},bounceTime,createjs.Ease.sineOut).to({ scaleX : 1, x : this._body.x},bounceTime,createjs.Ease.sineInOut);
		}
		return tween.wait(bounceTime * 2);
	}
	,_state: null
	,_body: null
	,__class__: co.doubleduck.Tommy
});
co.doubleduck.TommyState = $hxClasses["co.doubleduck.TommyState"] = { __ename__ : ["co","doubleduck","TommyState"], __constructs__ : ["IDLE","UP","RIGHT","DOWN","LEFT"] }
co.doubleduck.TommyState.IDLE = ["IDLE",0];
co.doubleduck.TommyState.IDLE.toString = $estr;
co.doubleduck.TommyState.IDLE.__enum__ = co.doubleduck.TommyState;
co.doubleduck.TommyState.UP = ["UP",1];
co.doubleduck.TommyState.UP.toString = $estr;
co.doubleduck.TommyState.UP.__enum__ = co.doubleduck.TommyState;
co.doubleduck.TommyState.RIGHT = ["RIGHT",2];
co.doubleduck.TommyState.RIGHT.toString = $estr;
co.doubleduck.TommyState.RIGHT.__enum__ = co.doubleduck.TommyState;
co.doubleduck.TommyState.DOWN = ["DOWN",3];
co.doubleduck.TommyState.DOWN.toString = $estr;
co.doubleduck.TommyState.DOWN.__enum__ = co.doubleduck.TommyState;
co.doubleduck.TommyState.LEFT = ["LEFT",4];
co.doubleduck.TommyState.LEFT.toString = $estr;
co.doubleduck.TommyState.LEFT.__enum__ = co.doubleduck.TommyState;
co.doubleduck.Transition = $hxClasses["co.doubleduck.Transition"] = function() {
	createjs.Container.call(this);
	if(co.doubleduck.Transition._allowInstantiation == false) return;
	this.name = "Transition";
	this._blackOverlay = new createjs.Shape();
	this._blackOverlay.graphics.beginFill("#000000");
	this._blackOverlay.graphics.drawRect(0,0,co.doubleduck.BaseGame.getScreenSize().width,co.doubleduck.BaseGame.getScreenSize().height);
	this._blackOverlay.graphics.endFill();
	this.addChild(this._blackOverlay);
	this._blackOverlay.alpha = 0;
};
co.doubleduck.Transition.__name__ = ["co","doubleduck","Transition"];
co.doubleduck.Transition._instance = null;
co.doubleduck.Transition.getInstance = function() {
	co.doubleduck.Transition._allowInstantiation = true;
	if(co.doubleduck.Transition._instance != null) return co.doubleduck.Transition._instance;
	var instance = new co.doubleduck.Transition();
	co.doubleduck.Transition._instance = instance;
	return instance;
}
co.doubleduck.Transition.transitionIn = function() {
	if(co.doubleduck.Transition._instance == null) return;
	co.doubleduck.Transition._instance._blackOverlay.alpha = 1;
	createjs.Tween.get(co.doubleduck.Transition._instance._blackOverlay).to({ alpha : 0},500);
}
co.doubleduck.Transition.transitionOut = function(handler,params) {
	if(co.doubleduck.Transition._instance == null) return;
	co.doubleduck.Transition._instance._blackOverlay.alpha = 0;
	createjs.Tween.get(co.doubleduck.Transition._instance._blackOverlay).to({ alpha : 1},350).call(handler,params);
}
co.doubleduck.Transition.__super__ = createjs.Container;
co.doubleduck.Transition.prototype = $extend(createjs.Container.prototype,{
	_blackOverlay: null
	,__class__: co.doubleduck.Transition
});
co.doubleduck.Utils = $hxClasses["co.doubleduck.Utils"] = function() { }
co.doubleduck.Utils.__name__ = ["co","doubleduck","Utils"];
co.doubleduck.Utils.dateDeltaInDays = function(day1,day2) {
	var delta = Math.abs(day2.getTime() - day1.getTime());
	return delta / 86400000;
}
co.doubleduck.Utils.getTodayDate = function() {
	var newDate = new Date();
	return HxOverrides.dateStr(newDate);
}
co.doubleduck.Utils.getHour = function() {
	var newDate = new Date();
	return newDate.getHours();
}
co.doubleduck.Utils.rectOverlap = function(r1,r2) {
	var r1TopLeft = new createjs.Point(r1.x,r1.y);
	var r1BottomRight = new createjs.Point(r1.x + r1.width,r1.y + r1.height);
	var r1TopRight = new createjs.Point(r1.x + r1.width,r1.y);
	var r1BottomLeft = new createjs.Point(r1.x,r1.y + r1.height);
	var r2TopLeft = new createjs.Point(r2.x,r2.y);
	var r2BottomRight = new createjs.Point(r2.x + r2.width,r2.y + r2.height);
	var r2TopRight = new createjs.Point(r2.x + r2.width,r2.y);
	var r2BottomLeft = new createjs.Point(r2.x,r2.y + r2.height);
	if(co.doubleduck.Utils.rectContainPoint(r2TopLeft,r2BottomRight,r1TopLeft)) return true;
	if(co.doubleduck.Utils.rectContainPoint(r2TopLeft,r2BottomRight,r1BottomRight)) return true;
	if(co.doubleduck.Utils.rectContainPoint(r2TopLeft,r2BottomRight,r1TopRight)) return true;
	if(co.doubleduck.Utils.rectContainPoint(r2TopLeft,r2BottomRight,r1BottomLeft)) return true;
	if(co.doubleduck.Utils.rectContainPoint(r1TopLeft,r1BottomRight,r2TopLeft)) return true;
	if(co.doubleduck.Utils.rectContainPoint(r1TopLeft,r1BottomRight,r2BottomRight)) return true;
	if(co.doubleduck.Utils.rectContainPoint(r1TopLeft,r1BottomRight,r2TopRight)) return true;
	if(co.doubleduck.Utils.rectContainPoint(r1TopLeft,r1BottomRight,r2BottomLeft)) return true;
	return false;
}
co.doubleduck.Utils.overlap = function(obj1,obj1Width,obj1Height,obj2,obj2Width,obj2Height) {
	var o1TopLeft = new createjs.Point(obj1.x - obj1.regX * co.doubleduck.BaseGame.getScale(),obj1.y - obj1.regY * co.doubleduck.BaseGame.getScale());
	var o1BottomRight = new createjs.Point(o1TopLeft.x - obj1.regX * co.doubleduck.BaseGame.getScale() + obj1Width * co.doubleduck.BaseGame.getScale(),o1TopLeft.y + obj1Height * co.doubleduck.BaseGame.getScale() - obj1.regY * co.doubleduck.BaseGame.getScale());
	var o1TopRight = new createjs.Point(o1BottomRight.x - obj1.regX * co.doubleduck.BaseGame.getScale(),o1TopLeft.y - obj1.regY * co.doubleduck.BaseGame.getScale());
	var o1BottomLeft = new createjs.Point(o1TopLeft.x - obj1.regX * co.doubleduck.BaseGame.getScale(),o1BottomRight.y - obj1.regY * co.doubleduck.BaseGame.getScale());
	var o2TopLeft = new createjs.Point(obj2.x - obj2.regX * co.doubleduck.BaseGame.getScale(),obj2.y - obj2.regY * co.doubleduck.BaseGame.getScale());
	var o2BottomRight = new createjs.Point(o2TopLeft.x + obj2Width * co.doubleduck.BaseGame.getScale() - obj2.regX * co.doubleduck.BaseGame.getScale(),o2TopLeft.y + obj2Height * co.doubleduck.BaseGame.getScale() - obj2.regY * co.doubleduck.BaseGame.getScale());
	var o2TopRight = new createjs.Point(o2BottomRight.x - obj2.regX * co.doubleduck.BaseGame.getScale(),o2TopLeft.y - obj2.regY * co.doubleduck.BaseGame.getScale());
	var o2BottomLeft = new createjs.Point(o2TopLeft.x - obj2.regX * co.doubleduck.BaseGame.getScale(),o2BottomRight.y - obj2.regY * co.doubleduck.BaseGame.getScale());
	if(co.doubleduck.Utils.rectContainPoint(o2TopLeft,o2BottomRight,o1TopLeft)) return true;
	if(co.doubleduck.Utils.rectContainPoint(o2TopLeft,o2BottomRight,o1BottomRight)) return true;
	if(co.doubleduck.Utils.rectContainPoint(o2TopLeft,o2BottomRight,o1TopRight)) return true;
	if(co.doubleduck.Utils.rectContainPoint(o2TopLeft,o2BottomRight,o1BottomLeft)) return true;
	if(co.doubleduck.Utils.rectContainPoint(o1TopLeft,o1BottomRight,o2TopLeft)) return true;
	if(co.doubleduck.Utils.rectContainPoint(o1TopLeft,o1BottomRight,o2BottomRight)) return true;
	if(co.doubleduck.Utils.rectContainPoint(o1TopLeft,o1BottomRight,o2TopRight)) return true;
	if(co.doubleduck.Utils.rectContainPoint(o1TopLeft,o1BottomRight,o2BottomLeft)) return true;
	return false;
}
co.doubleduck.Utils.rectContainPoint = function(rectTopLeft,rectBottomRight,point) {
	return point.x >= rectTopLeft.x && point.x <= rectBottomRight.x && point.y >= rectTopLeft.y && point.y <= rectBottomRight.y;
}
co.doubleduck.Utils.objectContains = function(dyn,memberName) {
	return Reflect.hasField(dyn,memberName);
}
co.doubleduck.Utils.contains = function(arr,obj) {
	var _g = 0;
	while(_g < arr.length) {
		var element = arr[_g];
		++_g;
		if(element == obj) return true;
	}
	return false;
}
co.doubleduck.Utils.isMobileFirefox = function() {
	var isFirefox = /Firefox/.test(navigator.userAgent);
	return isFirefox && viewporter.ACTIVE;
}
co.doubleduck.Utils.get = function(x,y,tiles,columns) {
	return tiles[columns * y + x];
}
co.doubleduck.Utils.getBitmapLabel = function(label,fontType,padding) {
	if(padding == null) padding = 0;
	if(fontType == null) fontType = "";
	var fontHelper = new co.doubleduck.FontHelper(fontType);
	var bitmapText = fontHelper.getNumber(Std.parseInt(label),1,true,null,padding);
	return bitmapText;
}
co.doubleduck.Utils.concatWithoutDuplicates = function(array,otherArray) {
	var _g = 0;
	while(_g < otherArray.length) {
		var element = otherArray[_g];
		++_g;
		co.doubleduck.Utils.addToArrayWithoutDuplicates(array,element);
	}
	return array;
}
co.doubleduck.Utils.addToArrayWithoutDuplicates = function(array,element) {
	var _g = 0;
	while(_g < array.length) {
		var currElement = array[_g];
		++_g;
		if(currElement == element) return array;
	}
	array.push(element);
	return array;
}
co.doubleduck.Utils.getImageData = function(image) {
	var ctx = co.doubleduck.Utils.getCanvasContext();
	var img = co.doubleduck.BaseAssets.getImage(image);
	ctx.drawImage(img.image,0,0);
	return ctx.getImageData(0,0,img.image.width,img.image.height);
}
co.doubleduck.Utils.getCanvasContext = function() {
	var dom = js.Lib.document.createElement("Canvas");
	var canvas = dom;
	return canvas.getContext("2d");
}
co.doubleduck.Utils.joinArrays = function(a1,a2) {
	var arr = a1.slice();
	var _g = 0;
	while(_g < a2.length) {
		var el = a2[_g];
		++_g;
		arr.push(el);
	}
	return arr;
}
co.doubleduck.Utils.getRandomElement = function(arr) {
	return arr[Std.random(arr.length)];
}
co.doubleduck.Utils.splitArray = function(arr,parts) {
	var arrs = new Array();
	var _g = 0;
	while(_g < parts) {
		var p = _g++;
		arrs.push(new Array());
	}
	var currArr = 0;
	while(arr.length > 0) {
		arrs[currArr].push(arr.pop());
		currArr++;
		currArr %= parts;
	}
	return arrs;
}
co.doubleduck.Utils.map = function(value,aMin,aMax,bMin,bMax) {
	if(bMax == null) bMax = 1;
	if(bMin == null) bMin = 0;
	if(value <= aMin) return bMin;
	if(value >= aMax) return bMax;
	return (value - aMin) * (bMax - bMin) / (aMax - aMin) + bMin;
}
co.doubleduck.Utils.waitAndCall = function(parent,delay,func,args) {
	createjs.Tween.get(parent).wait(delay).call(func,args);
}
co.doubleduck.Utils.tintBitmap = function(src,redMultiplier,greenMultiplier,blueMultiplier,alphaMultiplier) {
	var colorFilter = new createjs.ColorFilter(redMultiplier,greenMultiplier,blueMultiplier,alphaMultiplier);
	src.cache(src.x,src.y,src.image.width,src.image.height);
	src.filters = [colorFilter];
	src.updateCache();
}
co.doubleduck.Utils.containBitmaps = function(bitmapList,spacing,isRow,dims) {
	if(isRow == null) isRow = true;
	if(spacing == null) spacing = 0;
	var totalWidth = 0;
	var totalHeight = 0;
	var result = new createjs.Container();
	var _g1 = 0, _g = bitmapList.length;
	while(_g1 < _g) {
		var currBitmap = _g1++;
		var bmp = bitmapList[currBitmap];
		bmp.regY = bmp.image.height / 2;
		if(currBitmap != 0) {
			if(isRow) {
				bmp.x = bitmapList[currBitmap - 1].x + bitmapList[currBitmap - 1].image.width + spacing;
				if(bmp.image.height > totalHeight) totalHeight = bmp.image.height;
				totalWidth += bmp.image.width + spacing;
			} else {
				bmp.y = bitmapList[currBitmap - 1].y + bitmapList[currBitmap - 1].image.height + spacing;
				if(bmp.image.width > totalWidth) totalWidth = bmp.image.width;
				totalHeight += bmp.image.height + spacing;
			}
		} else {
			totalWidth = bmp.image.width;
			totalHeight = bmp.image.height;
		}
		result.addChild(bmp);
	}
	result.regX = totalWidth / 2;
	result.regY = totalHeight / 2;
	if(dims != null) {
		dims.width = totalWidth;
		dims.height = totalHeight;
	}
	return result;
}
co.doubleduck.Utils.getCenteredImage = function(name,scaleToGame) {
	if(scaleToGame == null) scaleToGame = false;
	var img = co.doubleduck.BaseAssets.getImage(name);
	img.regX = img.image.width / 2;
	img.regY = img.image.height / 2;
	if(scaleToGame) img.scaleX = img.scaleY = co.doubleduck.BaseGame.getScale();
	return img;
}
co.doubleduck.Utils.setCenterReg = function(bmp) {
	bmp.regX = bmp.image.width / 2;
	bmp.regY = bmp.image.height / 2;
}
co.doubleduck.Utils.shuffleArray = function(arr) {
	var tmp, j, i = arr.length;
	while(i > 0) {
		j = Math.random() * i | 0;
		tmp = arr[--i];
		arr[i] = arr[j];
		arr[j] = tmp;
	}
}
co.doubleduck.Utils.scaleObject = function(obj) {
	obj.scaleX = obj.scaleY = co.doubleduck.BaseGame.getScale();
}
co.doubleduck.Utils.getRectangle = function(rect,color) {
	var ret = new createjs.Shape();
	ret.graphics.beginFill(color);
	ret.graphics.drawRect(rect.x,rect.y,rect.width,rect.height);
	ret.graphics.endFill();
	return ret;
}
co.doubleduck.Utils.getDistance = function(p1,p2) {
	var distX = p1.x - p2.x;
	var distY = p1.y - p2.y;
	var dist = Math.sqrt(distX * distX + distY * distY);
	return dist;
}
co.doubleduck.Utils.average = function(arr) {
	var sum = 0;
	var _g = 0;
	while(_g < arr.length) {
		var i = arr[_g];
		++_g;
		sum += i;
	}
	return sum / arr.length;
}
co.doubleduck.Utils.radToDeg = function(rad) {
	return rad * 180 / Math.PI;
}
co.doubleduck.Utils.degToRad = function(deg) {
	return deg * Math.PI / 180;
}
co.doubleduck.Utils.sign = function(num) {
	if(num < 0) return -1; else if(num > 0) return 1;
	return 0;
}
co.doubleduck.Utils.loadSpriteSheet = function(imgPath,numberOfFrames,animName,animFrequency,centerReg) {
	if(centerReg == null) centerReg = true;
	if(animFrequency == null) animFrequency = 1;
	var ret;
	var data = { };
	var img = co.doubleduck.BaseAssets.getRawImage(imgPath);
	var numFrames = numberOfFrames;
	var imageHeight = 0;
	var imageWidth = 0;
	if(img.width > img.height) {
		imageWidth = img.width / numFrames;
		imageHeight = img.height;
	} else {
		imageHeight = img.height / numFrames;
		imageWidth = img.width;
	}
	if(centerReg) data.frames = { width : imageWidth, height : imageHeight, regX : imageWidth / 2, regY : imageHeight / 2}; else data.frames = { width : imageWidth, height : imageHeight};
	data.images = [img];
	data.animations = { };
	var framesArr = [];
	var _g = 0;
	while(_g < numFrames) {
		var i = _g++;
		framesArr.push(i);
	}
	data[animName] = { frames : framesArr, frequency : 5};
	ret = new createjs.SpriteSheet(data);
	return ret;
}
co.doubleduck.audio.AudioFX = $hxClasses["co.doubleduck.audio.AudioFX"] = function(src) {
	this._jsAudio = null;
	this._src = src;
	this._loop = false;
	this._volume = 1;
};
co.doubleduck.audio.AudioFX.__name__ = ["co","doubleduck","audio","AudioFX"];
co.doubleduck.audio.AudioFX.__interfaces__ = [co.doubleduck.audio.AudioAPI];
co.doubleduck.audio.AudioFX._currentlyPlaying = null;
co.doubleduck.audio.AudioFX.prototype = {
	setVolume: function(volume) {
		this._volume = volume;
		if(this._jsAudio != null) this._jsAudio.setVolume(volume);
	}
	,pause: function() {
	}
	,stop: function(fadeOut) {
		if(fadeOut == null) fadeOut = 0;
		this._jsAudio.stop();
	}
	,playMusic: function(volume,loop,fadeIn) {
		if(fadeIn == null) fadeIn = 0;
		if(loop == null) loop = true;
		if(volume == null) volume = 1;
		if(this._jsAudio == null) this.load(loop);
		this._jsAudio.play();
		this.setVolume(volume);
	}
	,playEffect: function(volume,overrideOtherEffects,loop,fadeIn) {
		if(fadeIn == null) fadeIn = 0;
		if(loop == null) loop = false;
		if(overrideOtherEffects == null) overrideOtherEffects = true;
		if(volume == null) volume = 1;
		if(this._jsAudio == null) this.load(loop,co.doubleduck.SoundManager.audioPoolSize);
		this._jsAudio.play();
		this.setVolume(volume);
	}
	,load: function(isLoop,pool) {
		if(pool == null) pool = 1;
		var pathNoExtension = this._src;
		this._jsAudio = AudioFX(pathNoExtension, { loop: isLoop, pool: pool });
	}
	,init: function() {
	}
	,_volume: null
	,_loop: null
	,_jsAudio: null
	,_src: null
	,__class__: co.doubleduck.audio.AudioFX
}
co.doubleduck.audio.DummyAudioAPI = $hxClasses["co.doubleduck.audio.DummyAudioAPI"] = function() {
};
co.doubleduck.audio.DummyAudioAPI.__name__ = ["co","doubleduck","audio","DummyAudioAPI"];
co.doubleduck.audio.DummyAudioAPI.__interfaces__ = [co.doubleduck.audio.AudioAPI];
co.doubleduck.audio.DummyAudioAPI.prototype = {
	setVolume: function(volume) {
	}
	,pause: function() {
	}
	,stop: function(fadeOut) {
		if(fadeOut == null) fadeOut = 0;
	}
	,playMusic: function(volume,loop,fadeIn) {
		if(fadeIn == null) fadeIn = 0;
		if(loop == null) loop = true;
		if(volume == null) volume = 1;
	}
	,playEffect: function(volume,overrideOtherEffects,loop,fadeIn) {
		if(fadeIn == null) fadeIn = 0;
		if(loop == null) loop = false;
		if(overrideOtherEffects == null) overrideOtherEffects = true;
		if(volume == null) volume = 1;
	}
	,init: function() {
	}
	,__class__: co.doubleduck.audio.DummyAudioAPI
}
co.doubleduck.audio.HowlerAudio = $hxClasses["co.doubleduck.audio.HowlerAudio"] = function(src) {
	this._jsAudio = null;
	this._src = src;
	this._loop = false;
	this._volume = 1;
};
co.doubleduck.audio.HowlerAudio.__name__ = ["co","doubleduck","audio","HowlerAudio"];
co.doubleduck.audio.HowlerAudio.__interfaces__ = [co.doubleduck.audio.AudioAPI];
co.doubleduck.audio.HowlerAudio._currentlyPlaying = null;
co.doubleduck.audio.HowlerAudio.prototype = {
	setVolume: function(volume) {
		this._volume = volume;
		if(this._jsAudio != null) this._jsAudio.volume = volume;
	}
	,pause: function() {
	}
	,stop: function(fadeOut) {
		if(fadeOut == null) fadeOut = 0;
		this._jsAudio.stop();
	}
	,playMusic: function(volume,loop,fadeIn) {
		if(fadeIn == null) fadeIn = 0;
		if(loop == null) loop = true;
		if(volume == null) volume = 1;
		if(this._jsAudio == null) this.load(loop);
		this._jsAudio.play();
		this.setVolume(volume);
	}
	,playEffect: function(volume,overrideOtherEffects,loop,fadeIn) {
		if(fadeIn == null) fadeIn = 0;
		if(loop == null) loop = false;
		if(overrideOtherEffects == null) overrideOtherEffects = true;
		if(volume == null) volume = 1;
		if(this._jsAudio == null) this.load(loop,1);
		this._jsAudio.play();
		this.setVolume(volume);
	}
	,load: function(isLoop,pool) {
		if(pool == null) pool = 1;
		var pathNoExtension = this._src;
		var myUrls = new Array();
		myUrls.push(this._src + ".mp3");
		myUrls.push(this._src + ".ogg");
		this._jsAudio = new Howl({urls: myUrls, loop: false});
	}
	,init: function() {
	}
	,_volume: null
	,_loop: null
	,_jsAudio: null
	,_src: null
	,__class__: co.doubleduck.audio.HowlerAudio
}
co.doubleduck.audio.NonOverlappingAudio = $hxClasses["co.doubleduck.audio.NonOverlappingAudio"] = function(src) {
	this._src = src;
	this.load();
	this._isMusic = false;
};
co.doubleduck.audio.NonOverlappingAudio.__name__ = ["co","doubleduck","audio","NonOverlappingAudio"];
co.doubleduck.audio.NonOverlappingAudio.__interfaces__ = [co.doubleduck.audio.AudioAPI];
co.doubleduck.audio.NonOverlappingAudio._currentlyPlaying = null;
co.doubleduck.audio.NonOverlappingAudio.prototype = {
	getSrc: function() {
		return this._src;
	}
	,audio: function() {
		return this._audio;
	}
	,setVolume: function(volume) {
		if(this._audio != null) this._audio.volume = volume;
	}
	,pause: function() {
		if(this._audio != null) this._audio.pause();
	}
	,stop: function(fadeOut) {
		if(fadeOut == null) fadeOut = 0;
		if(this._isMusic) co.doubleduck.audio.NonOverlappingAudio._musicPlaying = false;
		if(this._audio != null) {
			this._audio.removeEventListener("ended",$bind(this,this.handleEnded));
			this._audio.currentTime = 0;
			this._audio.pause();
		}
	}
	,playMusic: function(volume,loop,fadeIn) {
		if(fadeIn == null) fadeIn = 0;
		if(loop == null) loop = false;
		if(volume == null) volume = 1;
		if(co.doubleduck.audio.NonOverlappingAudio._currentlyPlaying != null) co.doubleduck.audio.NonOverlappingAudio._currentlyPlaying.stop();
		this._isMusic = true;
		co.doubleduck.audio.NonOverlappingAudio._musicPlaying = true;
		this._audio.play();
		this._audio.volume = volume;
		this._audio.loop = loop;
		if(!loop) this._audio.addEventListener("ended",$bind(this,this.stop));
	}
	,handleEnded: function() {
		this._audio.removeEventListener("ended",$bind(this,this.handleEnded));
		this._audio.currentTime = 0;
	}
	,handleTimeUpdate: function() {
		if(this._audio.currentTime >= this._audio.duration - 0.3) this.stop();
	}
	,playEffect: function(volume,overrideOtherEffects,loop,fadeIn) {
		if(fadeIn == null) fadeIn = 0;
		if(loop == null) loop = false;
		if(overrideOtherEffects == null) overrideOtherEffects = true;
		if(volume == null) volume = 1;
		if(co.doubleduck.audio.NonOverlappingAudio._musicPlaying) return;
		if(overrideOtherEffects && co.doubleduck.audio.NonOverlappingAudio._currentlyPlaying != null) co.doubleduck.audio.NonOverlappingAudio._currentlyPlaying.stop();
		this._audio.play();
		this._audio.volume = volume;
		this._audio.loop = loop;
		if(!loop) this._audio.addEventListener("ended",$bind(this,this.stop));
		co.doubleduck.audio.NonOverlappingAudio._currentlyPlaying = this;
	}
	,handleError: function() {
	}
	,handleCanPlay: function() {
	}
	,load: function() {
		this._audio = new Audio();
		this._audio.src = this._src;
		this._audio.initialTime = 0;
		this._audio.addEventListener("canplaythrough",$bind(this,this.handleCanPlay));
		this._audio.addEventListener("onerror",$bind(this,this.handleError));
	}
	,init: function() {
	}
	,_isMusic: null
	,_audio: null
	,_src: null
	,__class__: co.doubleduck.audio.NonOverlappingAudio
}
var haxe = haxe || {}
haxe.Log = $hxClasses["haxe.Log"] = function() { }
haxe.Log.__name__ = ["haxe","Log"];
haxe.Log.trace = function(v,infos) {
	js.Boot.__trace(v,infos);
}
haxe.Log.clear = function() {
	js.Boot.__clear_trace();
}
haxe.Public = $hxClasses["haxe.Public"] = function() { }
haxe.Public.__name__ = ["haxe","Public"];
haxe.StackItem = $hxClasses["haxe.StackItem"] = { __ename__ : ["haxe","StackItem"], __constructs__ : ["CFunction","Module","FilePos","Method","Lambda"] }
haxe.StackItem.CFunction = ["CFunction",0];
haxe.StackItem.CFunction.toString = $estr;
haxe.StackItem.CFunction.__enum__ = haxe.StackItem;
haxe.StackItem.Module = function(m) { var $x = ["Module",1,m]; $x.__enum__ = haxe.StackItem; $x.toString = $estr; return $x; }
haxe.StackItem.FilePos = function(s,file,line) { var $x = ["FilePos",2,s,file,line]; $x.__enum__ = haxe.StackItem; $x.toString = $estr; return $x; }
haxe.StackItem.Method = function(classname,method) { var $x = ["Method",3,classname,method]; $x.__enum__ = haxe.StackItem; $x.toString = $estr; return $x; }
haxe.StackItem.Lambda = function(v) { var $x = ["Lambda",4,v]; $x.__enum__ = haxe.StackItem; $x.toString = $estr; return $x; }
haxe.Stack = $hxClasses["haxe.Stack"] = function() { }
haxe.Stack.__name__ = ["haxe","Stack"];
haxe.Stack.callStack = function() {
	var oldValue = Error.prepareStackTrace;
	Error.prepareStackTrace = function(error,callsites) {
		var stack = [];
		var _g = 0;
		while(_g < callsites.length) {
			var site = callsites[_g];
			++_g;
			var method = null;
			var fullName = site.getFunctionName();
			if(fullName != null) {
				var idx = fullName.lastIndexOf(".");
				if(idx >= 0) {
					var className = HxOverrides.substr(fullName,0,idx);
					var methodName = HxOverrides.substr(fullName,idx + 1,null);
					method = haxe.StackItem.Method(className,methodName);
				}
			}
			stack.push(haxe.StackItem.FilePos(method,site.getFileName(),site.getLineNumber()));
		}
		return stack;
	};
	var a = haxe.Stack.makeStack(new Error().stack);
	a.shift();
	Error.prepareStackTrace = oldValue;
	return a;
}
haxe.Stack.exceptionStack = function() {
	return [];
}
haxe.Stack.toString = function(stack) {
	var b = new StringBuf();
	var _g = 0;
	while(_g < stack.length) {
		var s = stack[_g];
		++_g;
		b.b += Std.string("\nCalled from ");
		haxe.Stack.itemToString(b,s);
	}
	return b.b;
}
haxe.Stack.itemToString = function(b,s) {
	var $e = (s);
	switch( $e[1] ) {
	case 0:
		b.b += Std.string("a C function");
		break;
	case 1:
		var m = $e[2];
		b.b += Std.string("module ");
		b.b += Std.string(m);
		break;
	case 2:
		var line = $e[4], file = $e[3], s1 = $e[2];
		if(s1 != null) {
			haxe.Stack.itemToString(b,s1);
			b.b += Std.string(" (");
		}
		b.b += Std.string(file);
		b.b += Std.string(" line ");
		b.b += Std.string(line);
		if(s1 != null) b.b += Std.string(")");
		break;
	case 3:
		var meth = $e[3], cname = $e[2];
		b.b += Std.string(cname);
		b.b += Std.string(".");
		b.b += Std.string(meth);
		break;
	case 4:
		var n = $e[2];
		b.b += Std.string("local function #");
		b.b += Std.string(n);
		break;
	}
}
haxe.Stack.makeStack = function(s) {
	if(typeof(s) == "string") {
		var stack = s.split("\n");
		var m = [];
		var _g = 0;
		while(_g < stack.length) {
			var line = stack[_g];
			++_g;
			m.push(haxe.StackItem.Module(line));
		}
		return m;
	} else return s;
}
if(!haxe.unit) haxe.unit = {}
haxe.unit.TestCase = $hxClasses["haxe.unit.TestCase"] = function() {
};
haxe.unit.TestCase.__name__ = ["haxe","unit","TestCase"];
haxe.unit.TestCase.__interfaces__ = [haxe.Public];
haxe.unit.TestCase.prototype = {
	assertEquals: function(expected,actual,c) {
		this.currentTest.done = true;
		if(actual != expected) {
			this.currentTest.success = false;
			this.currentTest.error = "expected '" + Std.string(expected) + "' but was '" + Std.string(actual) + "'";
			this.currentTest.posInfos = c;
			throw this.currentTest;
		}
	}
	,assertFalse: function(b,c) {
		this.currentTest.done = true;
		if(b == true) {
			this.currentTest.success = false;
			this.currentTest.error = "expected false but was true";
			this.currentTest.posInfos = c;
			throw this.currentTest;
		}
	}
	,assertTrue: function(b,c) {
		this.currentTest.done = true;
		if(b == false) {
			this.currentTest.success = false;
			this.currentTest.error = "expected true but was false";
			this.currentTest.posInfos = c;
			throw this.currentTest;
		}
	}
	,print: function(v) {
		haxe.unit.TestRunner.print(v);
	}
	,tearDown: function() {
	}
	,setup: function() {
	}
	,currentTest: null
	,__class__: haxe.unit.TestCase
}
haxe.unit.TestResult = $hxClasses["haxe.unit.TestResult"] = function() {
	this.m_tests = new List();
	this.success = true;
};
haxe.unit.TestResult.__name__ = ["haxe","unit","TestResult"];
haxe.unit.TestResult.prototype = {
	toString: function() {
		var buf = new StringBuf();
		var failures = 0;
		var $it0 = this.m_tests.iterator();
		while( $it0.hasNext() ) {
			var test = $it0.next();
			if(test.success == false) {
				buf.b += Std.string("* ");
				buf.b += Std.string(test.classname);
				buf.b += Std.string("::");
				buf.b += Std.string(test.method);
				buf.b += Std.string("()");
				buf.b += Std.string("\n");
				buf.b += Std.string("ERR: ");
				if(test.posInfos != null) {
					buf.b += Std.string(test.posInfos.fileName);
					buf.b += Std.string(":");
					buf.b += Std.string(test.posInfos.lineNumber);
					buf.b += Std.string("(");
					buf.b += Std.string(test.posInfos.className);
					buf.b += Std.string(".");
					buf.b += Std.string(test.posInfos.methodName);
					buf.b += Std.string(") - ");
				}
				buf.b += Std.string(test.error);
				buf.b += Std.string("\n");
				if(test.backtrace != null) {
					buf.b += Std.string(test.backtrace);
					buf.b += Std.string("\n");
				}
				buf.b += Std.string("\n");
				failures++;
			}
		}
		buf.b += Std.string("\n");
		if(failures == 0) buf.b += Std.string("OK "); else buf.b += Std.string("FAILED ");
		buf.b += Std.string(this.m_tests.length);
		buf.b += Std.string(" tests, ");
		buf.b += Std.string(failures);
		buf.b += Std.string(" failed, ");
		buf.b += Std.string(this.m_tests.length - failures);
		buf.b += Std.string(" success");
		buf.b += Std.string("\n");
		return buf.b;
	}
	,add: function(t) {
		this.m_tests.add(t);
		if(!t.success) this.success = false;
	}
	,success: null
	,m_tests: null
	,__class__: haxe.unit.TestResult
}
haxe.unit.TestRunner = $hxClasses["haxe.unit.TestRunner"] = function() {
	this.result = new haxe.unit.TestResult();
	this.cases = new List();
};
haxe.unit.TestRunner.__name__ = ["haxe","unit","TestRunner"];
haxe.unit.TestRunner.print = function(v) {
	var msg = StringTools.htmlEscape(js.Boot.__string_rec(v,"")).split("\n").join("<br/>");
	var d = document.getElementById("haxe:trace");
	if(d == null) alert("haxe:trace element not found"); else d.innerHTML += msg;
}
haxe.unit.TestRunner.customTrace = function(v,p) {
	haxe.unit.TestRunner.print(p.fileName + ":" + p.lineNumber + ": " + Std.string(v) + "\n");
}
haxe.unit.TestRunner.prototype = {
	runCase: function(t) {
		var old = haxe.Log.trace;
		haxe.Log.trace = haxe.unit.TestRunner.customTrace;
		var cl = Type.getClass(t);
		var fields = Type.getInstanceFields(cl);
		haxe.unit.TestRunner.print("Class: " + Type.getClassName(cl) + " ");
		var _g = 0;
		while(_g < fields.length) {
			var f = fields[_g];
			++_g;
			var fname = f;
			var field = Reflect.field(t,f);
			if(StringTools.startsWith(fname,"test") && Reflect.isFunction(field)) {
				t.currentTest = new haxe.unit.TestStatus();
				t.currentTest.classname = Type.getClassName(cl);
				t.currentTest.method = fname;
				t.setup();
				try {
					field.apply(t,new Array());
					if(t.currentTest.done) {
						t.currentTest.success = true;
						haxe.unit.TestRunner.print(".");
					} else {
						t.currentTest.success = false;
						t.currentTest.error = "(warning) no assert";
						haxe.unit.TestRunner.print("W");
					}
				} catch( $e0 ) {
					if( js.Boot.__instanceof($e0,haxe.unit.TestStatus) ) {
						var e = $e0;
						haxe.unit.TestRunner.print("F");
						t.currentTest.backtrace = haxe.Stack.toString(haxe.Stack.exceptionStack());
					} else {
					var e = $e0;
					haxe.unit.TestRunner.print("E");
					if(e.message != null) t.currentTest.error = "exception thrown : " + Std.string(e) + " [" + Std.string(e.message) + "]"; else t.currentTest.error = "exception thrown : " + Std.string(e);
					t.currentTest.backtrace = haxe.Stack.toString(haxe.Stack.exceptionStack());
					}
				}
				this.result.add(t.currentTest);
				t.tearDown();
			}
		}
		haxe.unit.TestRunner.print("\n");
		haxe.Log.trace = old;
	}
	,run: function() {
		this.result = new haxe.unit.TestResult();
		var $it0 = this.cases.iterator();
		while( $it0.hasNext() ) {
			var c = $it0.next();
			this.runCase(c);
		}
		haxe.unit.TestRunner.print(this.result.toString());
		return this.result.success;
	}
	,add: function(c) {
		this.cases.add(c);
	}
	,cases: null
	,result: null
	,__class__: haxe.unit.TestRunner
}
haxe.unit.TestStatus = $hxClasses["haxe.unit.TestStatus"] = function() {
	this.done = false;
	this.success = false;
};
haxe.unit.TestStatus.__name__ = ["haxe","unit","TestStatus"];
haxe.unit.TestStatus.prototype = {
	backtrace: null
	,posInfos: null
	,classname: null
	,method: null
	,error: null
	,success: null
	,done: null
	,__class__: haxe.unit.TestStatus
}
var js = js || {}
js.Boot = $hxClasses["js.Boot"] = function() { }
js.Boot.__name__ = ["js","Boot"];
js.Boot.__unhtml = function(s) {
	return s.split("&").join("&amp;").split("<").join("&lt;").split(">").join("&gt;");
}
js.Boot.__trace = function(v,i) {
	var msg = i != null?i.fileName + ":" + i.lineNumber + ": ":"";
	msg += js.Boot.__string_rec(v,"");
	var d;
	if(typeof(document) != "undefined" && (d = document.getElementById("haxe:trace")) != null) d.innerHTML += js.Boot.__unhtml(msg) + "<br/>"; else if(typeof(console) != "undefined" && console.log != null) console.log(msg);
}
js.Boot.__clear_trace = function() {
	var d = document.getElementById("haxe:trace");
	if(d != null) d.innerHTML = "";
}
js.Boot.isClass = function(o) {
	return o.__name__;
}
js.Boot.isEnum = function(e) {
	return e.__ename__;
}
js.Boot.getClass = function(o) {
	return o.__class__;
}
js.Boot.__string_rec = function(o,s) {
	if(o == null) return "null";
	if(s.length >= 5) return "<...>";
	var t = typeof(o);
	if(t == "function" && (o.__name__ || o.__ename__)) t = "object";
	switch(t) {
	case "object":
		if(o instanceof Array) {
			if(o.__enum__) {
				if(o.length == 2) return o[0];
				var str = o[0] + "(";
				s += "\t";
				var _g1 = 2, _g = o.length;
				while(_g1 < _g) {
					var i = _g1++;
					if(i != 2) str += "," + js.Boot.__string_rec(o[i],s); else str += js.Boot.__string_rec(o[i],s);
				}
				return str + ")";
			}
			var l = o.length;
			var i;
			var str = "[";
			s += "\t";
			var _g = 0;
			while(_g < l) {
				var i1 = _g++;
				str += (i1 > 0?",":"") + js.Boot.__string_rec(o[i1],s);
			}
			str += "]";
			return str;
		}
		var tostr;
		try {
			tostr = o.toString;
		} catch( e ) {
			return "???";
		}
		if(tostr != null && tostr != Object.toString) {
			var s2 = o.toString();
			if(s2 != "[object Object]") return s2;
		}
		var k = null;
		var str = "{\n";
		s += "\t";
		var hasp = o.hasOwnProperty != null;
		for( var k in o ) { ;
		if(hasp && !o.hasOwnProperty(k)) {
			continue;
		}
		if(k == "prototype" || k == "__class__" || k == "__super__" || k == "__interfaces__" || k == "__properties__") {
			continue;
		}
		if(str.length != 2) str += ", \n";
		str += s + k + " : " + js.Boot.__string_rec(o[k],s);
		}
		s = s.substring(1);
		str += "\n" + s + "}";
		return str;
	case "function":
		return "<function>";
	case "string":
		return o;
	default:
		return String(o);
	}
}
js.Boot.__interfLoop = function(cc,cl) {
	if(cc == null) return false;
	if(cc == cl) return true;
	var intf = cc.__interfaces__;
	if(intf != null) {
		var _g1 = 0, _g = intf.length;
		while(_g1 < _g) {
			var i = _g1++;
			var i1 = intf[i];
			if(i1 == cl || js.Boot.__interfLoop(i1,cl)) return true;
		}
	}
	return js.Boot.__interfLoop(cc.__super__,cl);
}
js.Boot.__instanceof = function(o,cl) {
	try {
		if(o instanceof cl) {
			if(cl == Array) return o.__enum__ == null;
			return true;
		}
		if(js.Boot.__interfLoop(o.__class__,cl)) return true;
	} catch( e ) {
		if(cl == null) return false;
	}
	switch(cl) {
	case Int:
		return Math.ceil(o%2147483648.0) === o;
	case Float:
		return typeof(o) == "number";
	case Bool:
		return o === true || o === false;
	case String:
		return typeof(o) == "string";
	case Dynamic:
		return true;
	default:
		if(o == null) return false;
		if(cl == Class && o.__name__ != null) return true; else null;
		if(cl == Enum && o.__ename__ != null) return true; else null;
		return o.__enum__ == cl;
	}
}
js.Boot.__cast = function(o,t) {
	if(js.Boot.__instanceof(o,t)) return o; else throw "Cannot cast " + Std.string(o) + " to " + Std.string(t);
}
js.Lib = $hxClasses["js.Lib"] = function() { }
js.Lib.__name__ = ["js","Lib"];
js.Lib.document = null;
js.Lib.window = null;
js.Lib.debug = function() {
	debugger;
}
js.Lib.alert = function(v) {
	alert(js.Boot.__string_rec(v,""));
}
js.Lib.eval = function(code) {
	return eval(code);
}
js.Lib.setErrorHandler = function(f) {
	js.Lib.onerror = f;
}
function $iterator(o) { if( o instanceof Array ) return function() { return HxOverrides.iter(o); }; return typeof(o.iterator) == 'function' ? $bind(o,o.iterator) : o.iterator; };
var $_;
function $bind(o,m) { var f = function(){ return f.method.apply(f.scope, arguments); }; f.scope = o; f.method = m; return f; };
if(Array.prototype.indexOf) HxOverrides.remove = function(a,o) {
	var i = a.indexOf(o);
	if(i == -1) return false;
	a.splice(i,1);
	return true;
}; else null;
Math.__name__ = ["Math"];
Math.NaN = Number.NaN;
Math.NEGATIVE_INFINITY = Number.NEGATIVE_INFINITY;
Math.POSITIVE_INFINITY = Number.POSITIVE_INFINITY;
$hxClasses.Math = Math;
Math.isFinite = function(i) {
	return isFinite(i);
};
Math.isNaN = function(i) {
	return isNaN(i);
};
String.prototype.__class__ = $hxClasses.String = String;
String.__name__ = ["String"];
Array.prototype.__class__ = $hxClasses.Array = Array;
Array.__name__ = ["Array"];
Date.prototype.__class__ = $hxClasses.Date = Date;
Date.__name__ = ["Date"];
var Int = $hxClasses.Int = { __name__ : ["Int"]};
var Dynamic = $hxClasses.Dynamic = { __name__ : ["Dynamic"]};
var Float = $hxClasses.Float = Number;
Float.__name__ = ["Float"];
var Bool = $hxClasses.Bool = Boolean;
Bool.__ename__ = ["Bool"];
var Class = $hxClasses.Class = { __name__ : ["Class"]};
var Enum = { };
var Void = $hxClasses.Void = { __ename__ : ["Void"]};
if(typeof document != "undefined") js.Lib.document = document;
if(typeof window != "undefined") {
	js.Lib.window = window;
	js.Lib.window.onerror = function(msg,url,line) {
		var f = js.Lib.onerror;
		if(f == null) return false;
		return f(msg,[url + ":" + line]);
	};
}
co.doubleduck.BaseAssets.onLoadAll = null;
co.doubleduck.BaseAssets._loader = null;
co.doubleduck.BaseAssets._cacheData = { };
co.doubleduck.BaseAssets._loadCallbacks = { };
co.doubleduck.BaseAssets.loaded = 0;
co.doubleduck.BaseAssets._useLocalStorage = false;
co.doubleduck.BaseGame._viewport = null;
co.doubleduck.BaseGame._scale = 1;
co.doubleduck.BaseGame.DEBUG = false;
co.doubleduck.BaseGame.LOGO_URI = "images/duckling/splash_logo.png";
co.doubleduck.BaseGame.LOAD_STROKE_URI = "images/duckling/loading_stroke.png";
co.doubleduck.BaseGame.LOAD_FILL_URI = "images/duckling/loading_fill.png";
co.doubleduck.BaseGame.ORIENT_PORT_URI = "images/duckling/orientation_error_port.png";
co.doubleduck.BaseGame.ORIENT_LAND_URI = "images/duckling/orientation_error_land.png";
co.doubleduck.BaseGame.isLocalized = false;
co.doubleduck.BasePersistence.GAME_PREFIX = "DUCK";
co.doubleduck.BasePersistence.available = co.doubleduck.BasePersistence.localStorageSupported();
co.doubleduck.Button.CLICK_TYPE_NONE = 0;
co.doubleduck.Button.CLICK_TYPE_TINT = 1;
co.doubleduck.Button.CLICK_TYPE_JUICY = 2;
co.doubleduck.Button.CLICK_TYPE_SCALE = 3;
co.doubleduck.Button.CLICK_TYPE_TOGGLE = 4;
co.doubleduck.Button.CLICK_TYPE_HOLD = 5;
co.doubleduck.Button._defaultSound = null;
co.doubleduck.GridItem.GRID_SIZE = 294;
co.doubleduck.GridItem.GRID_ROWS = 7;
co.doubleduck.GridItem.GRID_COLS = 7;
co.doubleduck.GridItem.SLIDE_SPEED = 110;
co.doubleduck.LevelLoader._levelsData = null;
co.doubleduck.LevelLoader._helpData = null;
co.doubleduck.Menu.LEVELS_PER_SCREEN = 5;
co.doubleduck.Menu.WORLD_MOVE_EASE = 0.007;
co.doubleduck.Menu._iconSpritesheets = null;
co.doubleduck.Persistence.LAST_LEVEL = "lastlevel";
co.doubleduck.Persistence.STAR_PREFIX = "starRateLvl_";
co.doubleduck.Session.DRAG_THRESH = 20;
co.doubleduck.Session._lastLevelId = -1;
co.doubleduck.Session._autoLoadNext = false;
co.doubleduck.audio.WebAudioAPI._buffers = { };
co.doubleduck.SoundManager._muted = false;
co.doubleduck.SoundManager._cache = { };
co.doubleduck.SoundManager.audioPoolSize = 2;
co.doubleduck.SoundManager.available = co.doubleduck.SoundManager.isSoundAvailable();
co.doubleduck.Tommy.TOMMY_WIDTH = 68;
co.doubleduck.Tommy.TOMMY_HEIGHT = 71;
co.doubleduck.Transition._allowInstantiation = false;
co.doubleduck.audio.AudioFX._muted = false;
co.doubleduck.audio.HowlerAudio._muted = false;
co.doubleduck.audio.NonOverlappingAudio._musicPlaying = false;
js.Lib.onerror = null;
co.doubleduck.Main.main();
