/**
 * Controle da Regra de Cadastro de clientes
 * @autor Guilherme Berghauser
 */
var componente;

jQuery(document).ready(function() {
	onloadCadastroCliente();
});

function onloadCadastroCliente() {
	document.addEventListener("deviceready", onDeviceReady, false);
}

function onDeviceReady() {

	document.addEventListener("backbutton", botaoBackCadastroCliente, false);

	$(".Menu").hide(0);
	$(".opcaoMenu").on('click', function(e) {
		e.preventDefault();
		// $('.Menu').toggle('slow');
		// var menu = $(".Menu");
		// var he = $("#header");
// 
		// $(".Menu").toggleClass("menuAberto");
		// $(".opcaoMenu").toggleClass("menuAberto");
		// console.log("TROCOU");

	});

	(function($) {

		eventoBotaoClick(".botao");

		componente = new ComponenteCadastro("cadastroForm", ".container", "Cadastro de Cliente", function(valores, ids) {

			if (valores.id != '' && valores.id != undefined) {
				abrirBanco(function(persistenceBanco) {
					persistenceBanco.query('clientes').filter('id', valores.id).execute().done(function(results) {

						if (results.length > 0 && results.length < 2) {
							for (var i = 0; i < ids.length; i++) {
								if (ids[i] != "id") {
									results[0][ids[i]] = valores[ids[i]];
								}
							}
							montarFinalSalvar(results[0]);
						} else {
							cli = new ClienteVal(valores);
							montarFinalSalvar(cli);
						}
					});
				});
			} else {
				cli = new ClienteVal(valores);
				montarFinalSalvar(cli);
			}
		});

		function montarFinalSalvar(cli) {

			cli.ativo = 1;
			cli.sinc = 0;

			verificarErros(cli, function(error, msg) {
				if (!error) {
					abrirBanco(function(persistenceBanco) {
						persistenceBanco.query('confSinc').all().execute().done(function(res) {
							cli.empresaId = res[0].empresa;
							cli.vendedorId = res[0].vendedor;
							adicionarBanco(persistenceBanco, 'clientes', cli, function(a) {
								window.location.replace('listaClientes.html');
							});
						});
					});
					return true;
				} else {
					jQuery('body,html').scrollTop(0);
					navigator.notification.alert(msg, alertDismissed, 'Dados Obrigatórios', 'Ok');
					return false;
				}
			});
		}

		abrirBanco(function(persistenceBanco) {
			persistenceBanco.query('formaPagamento').all().execute().done(function(results) {

				componente.adicionarCampo('Razão Social / Nome:', "text", "nome", "", '', true);
				componente.adicionarCampo("Fantasia / Apelido:", "text", "fantasia");
				componente.adicionarCampo("CNPJ/CPF:", "text", "cpfCnpj", '', true);
				componente.adicionarCampo("Inscrição / RG:", "text", "insEst");
				componente.adicionarCampo("Responsável:", "text", "resposavel");
				componente.adicionarCampo("UF:", "text", "uf", '', true);
				componente.adicionarCampo("Cidade:", "text", "cidade", '', true);
				componente.adicionarCampo("Endereço:", "text", "logadouro");
				componente.adicionarCampo("Número:", "text", "numero");
				componente.adicionarCampo("Bairro:", "text", "bairro");
				componente.adicionarCampo("CEP:", "text", "cep");
				componente.adicionarCampo("Complemento:", "text", "complemento");
				componente.adicionarCampo("Telefone:", "text", "telefone");
				componente.adicionarCampo("Celular:", "text", "celular");
				componente.adicionarCampo("Email NF-e:", "text", "email");
				componente.adicionarCampo("Observaçãoo:", "text", "obs");
				componente.adicionarCampo("Limite Crédito:", "text", "limiteCredito");
				componente.adicionarSelect("Forma Pagamento:", results, "formaPagamento", "formaPagamentoId", "descricao", false);
				componente.adicionarCampo("Lista de Preço:", "text", "listaPrecoId");
				componente.adicionarCampo("Data do último pedido:", "text", "ultData");
				componente.adicionarCampo("Total do último pedido:", "text", "ultTotal");

				// var selectTesteCom = [["vlr1", "TESTE UM"], ["vlr2", "TESTEDOIS"]];
				// var selectTeste = ["TESTE UM", "TESTEDOIS"];
				// componente.adicionarSelect("Teste Select Composto", selectTesteCom, "idTesteCom", true, "Teste Titulo Um");
				// componente.adicionarSelect("Teste Select normal", selectTeste, "idTeste", false, "Teste titulo dois");

				componente.montarCampos(function() {
					jQuery("#formaPagamento").append('<option value="0">0 - Indefinido</option>');
					jQuery("#formaPagamento").val(0);

					$("#cpfCnpj").attr('maxlength', '14');

					$('#addCliente').on('click', function() {
						botaoEvento();
					});
					$('#cancelCliente').on('click', function() {
						limparValores();
					});

					$("#limiteCredito").prop('disabled', true);
					$("#formaPagamento").prop('disabled', true);
					$("#listaPrecoId").prop('disabled', true);
					$("#ultTotal").prop('disabled', true);
					$("#ultData").prop('disabled', true);

					var cnpfCn = $('#cpfCnpj');
					cnpfCn.blur(function() {
						// inserção da mascara de CPF E CNPJ no mesmo campo
						cnpfCn.val(cpfCnpj(cnpfCn.val()));
					});

					if (localStorage.getItem("clienteEditar") != '') {
						var clienteEditar = JSON.parse(localStorage.getItem("clienteEditar"));
						if (clienteEditar.sinc == 1) {
							jQuery("canvas").hide();
							jQuery("#addCliente").hide();
							jQuery("#cancelCliente").hide();
							componente.inserirValores(clienteEditar, true);
						} else {
							jQuery("#cancelCliente").hide();
							componente.inserirValores(clienteEditar, false);
						}
					} else {
						new dgCidadesEstados({
							cidade : document.getElementById('cidade'),
							estado : document.getElementById('uf'),
							change : true
						});
					}

				});

				var a = $(".container .row #cadastroDescricao");
				var tamanho = a.length;

				for (var i = 0; i < tamanho; i++) {
					$(a[i]).fitText(1.2, {
						minFontSize : '13px',
						maxFontSize : '30px'
					});
				}

				var b = $("input");

				for (var i = 0; i < b.length; i++) {
					$(b[i]).fitText(1.2, {
						minFontSize : '13px',
						maxFontSize : '30px'
					});
				}

				var c = $("select");

				for (var i = 0; i < c.length; i++) {
					$(c[i]).fitText(1.2, {
						minFontSize : '13px',
						maxFontSize : '30px'
					});
				}

				var d = $('input[type="button"]');

				for (var i = 0; i < d.length; i++) {
					$(c[i]).fitText(1.2, {
						minFontSize : '13px',
						maxFontSize : '30px'
					});
				}
			});
		});
	})(jQuery);

}

function verificarErros(cli, callback) {

	var retornoString = '';
	var error = false;

	if (!validarOsDois(cli.cpfCnpj)) {
		error = true;
		retornoString += 'CPF/CNPJ inválido.\n';
		$("#cpfCnpj").addClass('bordaErro');

		retornoString += pedacoDoErros(cli);

		callback(error, retornoString);
	} else {
		abrirBanco(function(persistenceBanco) {
			persistenceBanco.query('clientes').filter('cpfCnpj', cli.cpfCnpj).execute().done(function(results) {

				var contador = 0;
				if (results.length != 0) {
					for (var i = 0; i < results.length; i++) {
						if (results[i].id !== cli.id) {
							if (contador < 1) {
								error = true;
								retornoString += 'CNPJ/CPF já utilizado (\n';
								retornoString += 'Nome: ' + results[i].nome + '\n';
								var status;
								if (results[i].ativo == 0) {
									status = 'Inativo';
								} else {
									status = 'Ativo';
								}
								retornoString += 'Status: ' + status + ').\n';
								$("#cpfCnpj").addClass('bordaErro');
								contador++;
							}
						} else {
							if (results.length <= 1) {
								$("#cpfCnpj").removeClass('bordaErro');
							}
							retornoString += pedacoDoErros(cli);
						}

						retornoString += pedacoDoErros(cli);
					}
					if (retornoString.length > 0) {
						error = true;
					}
					callback(error, retornoString);
				} else {
					$("#cpfCnpj").removeClass('bordaErro');
					retornoString += pedacoDoErros(cli);
					if (retornoString.length > 0) {
						error = true;
					}
					callback(error, retornoString);
				}
			});
		});
	}
}

function pedacoDoErros(cli) {
	var retornoString = '';

	if (cli.nome == '') {
		error = true;
		retornoString += 'NOME não pode ser vazio.\n';
		$("#nome").addClass('bordaErro');
	} else {
		$("#nome").removeClass('bordaErro');
	}
	if (cli.uf == '') {
		error = true;
		retornoString += 'ESTADO não pode ser vazio.\n';
		$("#uf").addClass('bordaErro');
	} else {
		$("#uf").removeClass('bordaErro');
	}
	if (cli.cidade == '') {
		error = true;
		retornoString += 'CIDADE não pode ser vazio.\n';
		$("#cidade").addClass('bordaErro');
	} else {
		$("#cidade").removeClass('bordaErro');
	}

	return retornoString;
}

function botaoBackCadastroCliente() {
	id = "";
	window.location.replace('listaClientes.html');
}

function alertDismissed() {
}

