/**
 *
 */

var $ = jQuery;
var ids;
var funcBotaoGlobal;
var idFormGlobal;
var tipoCampo;
var id = '';
var vari;

function ComponenteCadastro(idForm, blocoContainer, titulo, funcBotao) {

	var campos = [];
	var elementos = [];
	var composto = [];
	var obrigatorio = [];
	ids = [];
	var mask = [];
	var contador = 0;
	var center;
	var container = $(blocoContainer);
	adicionarForm();
	fecharForm();
	var idF = $("#" + idForm);
	var valoresSelect = [];
	tipoCampo = elementos;
	var valueGlobal = [];
	var descricaoGlobal = [];

	funcBotaoGlobal = funcBotao;
	idFormGlobal = idForm;

	this.adicionarCampo = adicionarCampo;
	this.montarCampos = montarCampos;
	this.adicionarSelect = adicionarSelect;
	this.inserirValores = inserirValores;

	function inserirValores(variavel, desabilitar) {
		vari = variavel;
		var form = $("#" + idFormGlobal);
		id = variavel.id;

		for (var i = 0; i < ids.length; i++) {
			if (tipoCampo[i] == 'text' || tipoCampo[i] == 'number') {
				if (ids[i] != 'cidade' && ids[i] != 'uf') {
					var formElemento = form.find('input[name="' + ids[i] + '"]');
					formElemento.val(variavel[ids[i]]);
					if (desabilitar) {
						formElemento.prop("disabled", true);
					}
				} else {
					if (ids[i] == 'cidade') {
						var valor = variavel[ids[i]] + "";
						valor = valor.split(" - ");

						new dgCidadesEstados({
							cidade : document.getElementById('cidade'),
							estado : document.getElementById('uf'),
							change : true,
							estadoVal : valor[1],
							cidadeVal : valor[0]
						});
					}
				}
			}

			if (tipoCampo[i] == 'select') {
				var formSelect = form.find('select[name="' + ids[i] + '"]');
				formSelect.val(variavel[ids[i]]);
				if (desabilitar) {
					formSelect.prop("disabled", true);
				}
			}

		}

		if (variavel.ativo == 0) {
			for (var i = 0; i < ids.length; i++) {
				if (tipoCampo[i] == 'text' || tipoCampo[i] == 'number') {

					if (ids[i] != 'cidade' && ids[i] != 'uf') {
						form.find('input[name="' + ids[i] + '"]').prop('disabled', true);
					} else {
						form.find('select[name="' + ids[i] + '"]').prop('disabled', true);
					}

				} else {
					form.find('select[name="' + ids[i] + '"]').prop('disabled', true);
				}
			}

			form.find('input[name="salvar"]').prop('disabled', true);
		}

		localStorage.setItem("clienteEditar", '');
	}

	/**
	 *	Metodo para adicionar os campos de text e suas variaveis
	 * @param descricao - nome da descrição do campo
	 * @param tipoCampo -  qual tipo de input que ele eh Ex: text, submit, tel
	 * @param id - id do Elemento
	 */
	function adicionarCampo(descricao, tipoCampo, id, maskVinda, obg) {
		campos[contador] = descricao;
		mask[contador] = maskVinda;
		elementos[contador] = tipoCampo;
		valoresSelect[contador] = [];
		composto[contador] = [];
		ids[contador] = id;
		obrigatorio[contador] = obg;
		contador++;
	};

	/**
	 * 	Metodo que adiciona o Select box
	 * @param descricao - Nome que ira no campo ex: Nome:
	 * @param valoresInternos - array com os valores do select box, caso seja composto o primeiro valor eh o id
	 * @param id - Id que o campo tera no ID do elemento
	 * @param compostaA - True or False - se for true o campo valoresInternos é array composta caso false array simples
	 * @param value - Id do option
	 * @param descricao - descricao do Select
	 */
	function adicionarSelect(descricao, valoresInternos, id, values, descricaos, compostoA) {
		campos[contador] = descricao;
		elementos[contador] = "select";
		valoresSelect[contador] = valoresInternos;
		ids[contador] = id;
		composto[contador] = compostoA;
		mask[contador] = "";
		valueGlobal[contador] = values;
		descricaoGlobal[contador] = descricaos;
		contador++;
	};

	/**
	 *	Metodo que monta todos os campos no html
	 * executar ele apos todos os adicionarcampos/select estejam instanciados
	 */
	function montarCampos(retorno) {
		// funcao main para montar os campos
		adicionarCenterDiv();
		fecharCenterDiv();
		center = $("#centerCadastro");

		gerarTitulo(center, titulo);
		var insercaoInicial = '';

		for (var i = 0; i < contador; i++) {
			insercaoInicial += "<div class=\"row\"> <div id=\"cadastroDescricao\" class=\"col-xs-12 col-sm-12\"><p>";
			insercaoInicial += campos[i];
			if (obrigatorio[i] != undefined) {
				insercaoInicial += '<span style="color:red">';
				insercaoInicial += '*';
				insercaoInicial += '</span>';
			}
			insercaoInicial += "</p></div></div>";
			center.append(insercaoInicial);
			insercaoInicial = '';

			if (tipoCampo[i] == "text" || tipoCampo[i] == 'number') {
				center.append("<div class=\"row\"><div id=\"cadastroCampo\" class=\"col-xs-12 col-sm-12\">" + getTipoCampo(elementos[i], i) + "</div></div>");
			}

			if (tipoCampo[i] == "select") {
				center.append("<div class=\"row\"><div id=\"cadastroCampoSelect\" class=\"col-xs-12 col-sm-12\">" + getTipoCampo(elementos[i], i) + "</div></div>");
			}

			if (mask[i] != null && mask[i] != '') {
				$("#" + ids[i]).mask(mask[i]);
			}
		}

		//botoes();

		retorno();

	};

	/**
	 *	Metodo que gera os botões de salvar e cancelar e insere no html
	 */
	function botoes() {
		//inserir a string do funcBotao com funcao(this.form)
		var str = new StringBuilder;
		str.append("<div class=\"row\">");
		str.append("<div id=\"botoesCadastro\" class=\"col-xs-12 col-sm-12\">");
		str.append("<INPUT TYPE=\"button\" NAME=\"salvar\" class=\"botao botaoSalvar\" Value=\"Salvar\" onClick=\"javascript: botaoEvento(this.form);\"> <INPUT TYPE=\"button\" NAME=\"cancelar\" class=\"botao\" Value=\"Cancelar\" onClick=\"javascript: limparValores(this.form);\">");
		str.append("</div></div>");
		center.append(str.toString());
	};

	/**
	 *	Metodo que insere a div que cria insere os campo ao centro
	 */
	function adicionarCenterDiv() {
		//adiciona a div que centraliza os campos ao centro
		idF.append("<div id=\"centerCadastro\" class=\"row\">");
	};

	function fecharCenterDiv() {
		idF.append("</div>");
	};

	/**
	 *	Metodo que cria o form do componente
	 */
	function adicionarForm() {
		// adiciona a form a html
		container.append("<FORM id=\"" + idForm + "\" NAME=\"" + idForm + "\" ACTION=\"\" METHOD=\"GET\">");
	};

	function fecharForm() {
		container.append("</form>");
	};

	/**
	 * Metodo que pega o tipo de input,
	 * existem dois grandes grupos ate a versao 0.1
	 * text(para as proximas adicionar novas) ou select
	 * @param {Object} tipoCampo - text ou select
	 * @param {Object} iContador - dentro do for qual é o campo que estamos referindo
	 */
	function getTipoCampo(tipoCampo, iContador) {
		//retorno os inputs de diferentes tipos

		if (tipoCampo == "text") {
			return "<input name=\"" + ids[iContador] + "\" id=\"" + ids[iContador] + "\" type=\"text\">";
		}
		if (tipoCampo == 'number') {
			return "<input name=\"" + ids[iContador] + "\" id=\"" + ids[iContador] + "\" type=\"number\" value=\"numeric\">";
		}
		if (tipoCampo == "select") {
			var retorno = new StringBuilder();

			retorno.append("<select name=\"");
			retorno.append(ids[iContador]);
			retorno.append("\" id=\"");
			retorno.append(ids[iContador]);
			retorno.append("\" class=\"selectBox\" ");
			retorno.append(">");

			var vetor = valoresSelect[iContador];
			var value;
			var descricao;
			for (var i = 0; i < vetor.length; i++) {

				if (composto[iContador]) {
					for (var j = 0; j < 2; j++) {

						if (j == 0) {
							value = vetor[i][j];
						} else {
							descricao = vetor[i][j];
						}
					}
				} else {
					var vetorTemp = vetor[i];
					value = vetorTemp[valueGlobal[iContador]];
					descricao = vetorTemp[descricaoGlobal[iContador]];
				}

				retorno.append("<option value=\"");
				retorno.append(value);
				retorno.append("\">");
				retorno.append(descricao);
				retorno.append("</option>");
			}

			retorno.append("</select>");

			return retorno.toString();
		}
	};

	/**
	 * 	Metodo que cria o titulo central da pagina
	 * @param {Object} variavel - elemento para ser inserido no caso o container
	 * @param {Object} tituloPagina - Titulo da pagina
	 */
	function gerarTitulo(variavel, tituloPagina) {
		variavel.append("<div class=\"row\"> <div id=\"traco\" class=\"col-xs-11 col-sm-6\"> <h1>" + tituloPagina + "</h1></div></div>");
	}

}

/**
 *	metodo que limpa todos os campos do form
 */
function limparValores() {
	var form = $("#" + idFormGlobal);
	for (var i = 0; i < ids.length; i++) {

		if (tipoCampo[i] == 'text' || tipoCampo[i] == 'number') {
			if (ids[i] !== "uf") {
				if (ids[i] !== "cidade") {
					form.find('input[name="' + ids[i] + '"]').val("").removeClass('bordaErro');
				} else {
					form.find('select[name="' + ids[i] + '"]').val("").removeClass('bordaErro');
				}
			} else {
				form.find('select[name="' + ids[i] + '"]').val("").removeClass('bordaErro');
			}
		}

		if (tipoCampo[i] == 'select') {
			form.find('select[name="' + ids[i] + '"]').val("").removeClass('bordaErro');
		}
	}
	id = "";
}

/**
 *	metodo que salva todas as informações dos forms em uma array
 */
function getArrayValores() {

	var valores = [];
	var form = $("#" + idFormGlobal);

	for (var i = 0; i < ids.length; i++) {
		if (tipoCampo[i] == 'text' || tipoCampo[i] == 'number') {
			if (ids[i] != 'uf' && ids[i] != 'cidade') {
				valores[i] = [ids[i], form.find('input[name="' + ids[i] + '"]').val()];
			} else {
				valores[i] = [ids[i], form.find('select[name="' + ids[i] + '"]').val()];
			}
		}

		if (tipoCampo[i] == 'select') {
			valores[i] = [ids[i], form.find('select[name="' + ids[i] + '"]').val()];
		}

	}

	var retorno = new StringBuilder();
	retorno.append('{');
	for (var i = 0; i < valores.length; i++) {
		retorno.append('"');
		retorno.append(valores[i][0]);
		retorno.append('"');
		retorno.append(':');
		retorno.append('"');
		retorno.append(valores[i][1]);
		retorno.append('"');

		if ((i + 1) < valores.length) {
			retorno.append(',');
		}
	}
	if (id != '') {
		retorno.append(',"id":"');
		retorno.append(id);
		retorno.append('"');
	}
	retorno.append('}');
	var retornoJson = JSON.parse(retorno.toString());

	return retornoJson;

}

/**
 * metodo que gera o callback para executar a acão do clickar em salvar
 * @param {Object} form função para executar o botão salvar
 */
function botaoEvento() {
	if (funcBotaoGlobal(getArrayValores(), ids)) {
		limparValores();
	}

}
