jQuery(document).ready(function() {

	new setarFont('#tituloPopup h1', '40px', '10px', 0.8);
	new setarFont('#linksPopup .row', '30px', '10px', 1);

	var height = jQuery(window.parent.window).height();
	height = height - 70;

	var width = jQuery(window.parent.window).width();
	width = width - (8 * width / 100);

	var pop = jQuery('#iframePopUp', window.parent.document);
	var contPop = jQuery('#corpoPopup');
	var adPop = jQuery('.adpopup', window.parent.document);

	if (contPop.prop("scrollHeight") > (jQuery(window.parent.window).height())) {
		jQuery('#corpoPopup').slimScroll({
			height : height,
			touchScrollStep : 100
		});
		contPop.css('width', width);
	} else {
		var valor = contPop.prop("scrollHeight");
		jQuery('.adpopup', window.parent.document).css('top', '100px');
		pop.css('height', valor + 'px');
		adPop.css('height', valor + 'px');
	}

	jQuery('#cadastrarNovo').on('click', function(e) {
		e.preventDefault();
		localStorage.removeItem('pedidoFinal');
		window.parent.window.location.replace('../../view/pedidos/cliente/listaClientes.html');
	});

	jQuery('#visualizarPedido').on('click', function(e) {
		e.preventDefault();
		window.parent.window.location.replace('../../view/pedidos/pedidoFinal.html');
	});

	jQuery('#excluirPedido').on('click', function(e) {
		e.preventDefault();
		var pedido = JSON.parse(localStorage.getItem("pedidoFinal"));

		if (pedido.sinc == 0) {
			if (confirm('Deseja remover o Pedido nº' + pedido.id + '?')) {
				abrirBanco(function(a) {

					apagarFlex(pedido, a);

					a.remove('pedidos', pedido.id).done(function() {
						window.parent.window.location.replace('../../view/pedidos/pedidoPrincipal.html');
					});
				});
			}
		} else {
			alert('Pedido já está sincronizado!');
		}

	});
});

function apagarFlex(pedido, persistenceBanco) {

	for (var i = 0; i < pedido.produtos.length; i++) {

		var produto = pedido.produtos[i];
		if (produto.saldo != undefined) {
			var valor = produto.saldo;
			if (valor != 0) {
				if (valor < 0) {

					persistenceBanco.query("confSinc").all().execute().done(function(results) {
						var saldo = new Saldo();

						saldo.empresaId = results[0].empresa;
						saldo.vendedorId = results[0].vendedor;
						saldo.saldo = (valor * -1) + window.parent.window.saldoFinal;
						window.parent.window.saldoFinal = window.parent.window.saldoFinal + (valor * -1);
						saldo.acrescimo = valor * -1;
						saldo.referencia = 'Pedido Nº' + pedido.id + ', [ DEL ] Produto ' + produto.produto.codigo + ' - ' + produto.produto.descricao;

						adicionarBanco(persistenceBanco, 'saldos', saldo, function(item) {

						});
					});
				} else if (valor > 0) {
					persistenceBanco.query("confSinc").all().execute().done(function(results) {
						var saldo = new Saldo();
						saldo.empresaId = results[0].empresa;
						saldo.vendedorId = results[0].vendedor;
						saldo.saldo = valor - window.parent.window.saldoFinal;
						window.parent.window.saldoFinal = window.parent.window.saldoFinal - valor;
						saldo.desconto = valor;
						saldo.referencia = 'Pedido Nº' + pedido.id + ', [ DEL ] Produto ' + tempProduto.codigo + ' - ' + tempProduto.descricao;

						adicionarBanco(persistenceBanco, 'saldos', saldo, function(item) {

						});
					});
				}
			}
		}
	}
}
